// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Cloud Map
///
/// Client for invoking operations on AWS Cloud Map. Each operation on AWS Cloud Map is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_servicediscovery::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_servicediscovery::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_servicediscovery::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateHttpNamespace`](crate::client::fluent_builders::CreateHttpNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateHttpNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateHttpNamespace::set_name): <p>The name that you want to assign to this namespace.</p>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateHttpNamespace::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateHttpNamespace::set_creator_request_id): <p>A unique string that identifies the request and that allows failed <code>CreateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHttpNamespace::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHttpNamespace::set_description): <p>A description for the namespace.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateHttpNamespace::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateHttpNamespace::set_tags): <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
    /// - On success, responds with [`CreateHttpNamespaceOutput`](crate::output::CreateHttpNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::CreateHttpNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<CreateHttpNamespaceError>`](crate::error::CreateHttpNamespaceError)
    pub fn create_http_namespace(&self) -> fluent_builders::CreateHttpNamespace {
        fluent_builders::CreateHttpNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePrivateDnsNamespace`](crate::client::fluent_builders::CreatePrivateDnsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_name): <p>The name that you want to assign to this namespace. When you create a private DNS namespace, Cloud Map automatically creates an Amazon Route 53 private hosted zone that has the same name as the namespace.</p>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_creator_request_id): <p>A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_description): <p>A description for the namespace.</p>
    ///   - [`vpc(impl Into<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::vpc) / [`set_vpc(Option<String>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_vpc): <p>The ID of the Amazon VPC that you want to associate the namespace with.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_tags): <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
    ///   - [`properties(PrivateDnsNamespaceProperties)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::properties) / [`set_properties(Option<PrivateDnsNamespaceProperties>)`](crate::client::fluent_builders::CreatePrivateDnsNamespace::set_properties): <p>Properties for the private DNS namespace.</p>
    /// - On success, responds with [`CreatePrivateDnsNamespaceOutput`](crate::output::CreatePrivateDnsNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::CreatePrivateDnsNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<CreatePrivateDnsNamespaceError>`](crate::error::CreatePrivateDnsNamespaceError)
    pub fn create_private_dns_namespace(&self) -> fluent_builders::CreatePrivateDnsNamespace {
        fluent_builders::CreatePrivateDnsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePublicDnsNamespace`](crate::client::fluent_builders::CreatePublicDnsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::set_name): <p>The name that you want to assign to this namespace.</p>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::set_creator_request_id): <p>A unique string that identifies the request and that allows failed <code>CreatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::set_description): <p>A description for the namespace.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::set_tags): <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
    ///   - [`properties(PublicDnsNamespaceProperties)`](crate::client::fluent_builders::CreatePublicDnsNamespace::properties) / [`set_properties(Option<PublicDnsNamespaceProperties>)`](crate::client::fluent_builders::CreatePublicDnsNamespace::set_properties): <p>Properties for the public DNS namespace.</p>
    /// - On success, responds with [`CreatePublicDnsNamespaceOutput`](crate::output::CreatePublicDnsNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::CreatePublicDnsNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<CreatePublicDnsNamespaceError>`](crate::error::CreatePublicDnsNamespaceError)
    pub fn create_public_dns_namespace(&self) -> fluent_builders::CreatePublicDnsNamespace {
        fluent_builders::CreatePublicDnsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateService`](crate::client::fluent_builders::CreateService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateService::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateService::set_name): <p>The name that you want to assign to the service.</p>  <p>If you want Cloud Map to create an <code>SRV</code> record when you register an instance and you're using a system that requires a specific <code>SRV</code> format, such as <a href="http://www.haproxy.org/">HAProxy</a>, specify the following for <code>Name</code>:</p>  <ul>   <li> <p>Start the name with an underscore (_), such as <code>_exampleservice</code>.</p> </li>   <li> <p>End the name with <i>._protocol</i>, such as <code>._tcp</code>.</p> </li>  </ul>  <p>When you register an instance, Cloud Map creates an <code>SRV</code> record and assigns a name to the record by concatenating the service name and the namespace name (for example,</p>  <p> <code>_exampleservice._tcp.example.com</code>).</p> <note>   <p>For services that are accessible by DNS queries, you can't create multiple services with names that differ only by case (such as EXAMPLE and example). Otherwise, these services have the same DNS name and can't be distinguished. However, if you use a namespace that's only accessible by API calls, then you can create services that with names that differ only by case.</p>  </note>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::CreateService::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::CreateService::set_namespace_id): <p>The ID of the namespace that you want to use to create the service. The namespace ID must be specified, but it can be specified either here or in the <code>DnsConfig</code> object.</p>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateService::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateService::set_creator_request_id): <p>A unique string that identifies the request and that allows failed <code>CreateService</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateService::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateService::set_description): <p>A description for the service.</p>
    ///   - [`dns_config(DnsConfig)`](crate::client::fluent_builders::CreateService::dns_config) / [`set_dns_config(Option<DnsConfig>)`](crate::client::fluent_builders::CreateService::set_dns_config): <p>A complex type that contains information about the Amazon Route 53 records that you want Cloud Map to create when you register an instance. </p>
    ///   - [`health_check_config(HealthCheckConfig)`](crate::client::fluent_builders::CreateService::health_check_config) / [`set_health_check_config(Option<HealthCheckConfig>)`](crate::client::fluent_builders::CreateService::set_health_check_config): <p> <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional Route 53 health check. If you specify settings for a health check, Cloud Map associates the health check with all the Route 53 DNS records that you specify in <code>DnsConfig</code>.</p> <important>   <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>  </important>  <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/cloud-map/pricing/">Cloud Map Pricing</a>.</p>
    ///   - [`health_check_custom_config(HealthCheckCustomConfig)`](crate::client::fluent_builders::CreateService::health_check_custom_config) / [`set_health_check_custom_config(Option<HealthCheckCustomConfig>)`](crate::client::fluent_builders::CreateService::set_health_check_custom_config): <p>A complex type that contains information about an optional custom health check.</p> <important>   <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>  </important>  <p>You can't add, update, or delete a <code>HealthCheckCustomConfig</code> configuration from an existing service.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateService::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateService::set_tags): <p>The tags to add to the service. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
    ///   - [`r#type(ServiceTypeOption)`](crate::client::fluent_builders::CreateService::type) / [`set_type(Option<ServiceTypeOption>)`](crate::client::fluent_builders::CreateService::set_type): <p>If present, specifies that the service instances are only discoverable using the <code>DiscoverInstances</code> API operation. No DNS records is registered for the service instances. The only valid value is <code>HTTP</code>.</p>
    /// - On success, responds with [`CreateServiceOutput`](crate::output::CreateServiceOutput) with field(s):
    ///   - [`service(Option<Service>)`](crate::output::CreateServiceOutput::service): <p>A complex type that contains information about the new service.</p>
    /// - On failure, responds with [`SdkError<CreateServiceError>`](crate::error::CreateServiceError)
    pub fn create_service(&self) -> fluent_builders::CreateService {
        fluent_builders::CreateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNamespace`](crate::client::fluent_builders::DeleteNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteNamespace::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteNamespace::set_id): <p>The ID of the namespace that you want to delete.</p>
    /// - On success, responds with [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::DeleteNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<DeleteNamespaceError>`](crate::error::DeleteNamespaceError)
    pub fn delete_namespace(&self) -> fluent_builders::DeleteNamespace {
        fluent_builders::DeleteNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteService`](crate::client::fluent_builders::DeleteService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteService::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteService::set_id): <p>The ID of the service that you want to delete.</p>
    /// - On success, responds with [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)

    /// - On failure, responds with [`SdkError<DeleteServiceError>`](crate::error::DeleteServiceError)
    pub fn delete_service(&self) -> fluent_builders::DeleteService {
        fluent_builders::DeleteService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterInstance`](crate::client::fluent_builders::DeregisterInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterInstance::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::DeregisterInstance::set_service_id): <p>The ID of the service that the instance is associated with.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeregisterInstance::set_instance_id): <p>The value that you specified for <code>Id</code> in the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
    /// - On success, responds with [`DeregisterInstanceOutput`](crate::output::DeregisterInstanceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::DeregisterInstanceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<DeregisterInstanceError>`](crate::error::DeregisterInstanceError)
    pub fn deregister_instance(&self) -> fluent_builders::DeregisterInstance {
        fluent_builders::DeregisterInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DiscoverInstances`](crate::client::fluent_builders::DiscoverInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`namespace_name(impl Into<String>)`](crate::client::fluent_builders::DiscoverInstances::namespace_name) / [`set_namespace_name(Option<String>)`](crate::client::fluent_builders::DiscoverInstances::set_namespace_name): <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the <code>Properties</code> member of the namespace.</p>
    ///   - [`service_name(impl Into<String>)`](crate::client::fluent_builders::DiscoverInstances::service_name) / [`set_service_name(Option<String>)`](crate::client::fluent_builders::DiscoverInstances::set_service_name): <p>The name of the service that you specified when you registered the instance.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DiscoverInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DiscoverInstances::set_max_results): <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
    ///   - [`query_parameters(HashMap<String, String>)`](crate::client::fluent_builders::DiscoverInstances::query_parameters) / [`set_query_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::DiscoverInstances::set_query_parameters): <p>Filters to scope the results based on custom attributes for the instance (for example, <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are returned.</p>
    ///   - [`optional_parameters(HashMap<String, String>)`](crate::client::fluent_builders::DiscoverInstances::optional_parameters) / [`set_optional_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::DiscoverInstances::set_optional_parameters): <p>Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in the <code>QueryParameters</code> parameter are returned.</p>
    ///   - [`health_status(HealthStatusFilter)`](crate::client::fluent_builders::DiscoverInstances::health_status) / [`set_health_status(Option<HealthStatusFilter>)`](crate::client::fluent_builders::DiscoverInstances::set_health_status): <p>The health status of the instances that you want to discover. This parameter is ignored for services that don't have a health check configured, and all instances are returned.</p>  <dl>   <dt>   HEALTHY  </dt>   <dd>    <p>Returns healthy instances.</p>   </dd>   <dt>   UNHEALTHY  </dt>   <dd>    <p>Returns unhealthy instances.</p>   </dd>   <dt>   ALL  </dt>   <dd>    <p>Returns all instances.</p>   </dd>   <dt>   HEALTHY_OR_ELSE_ALL  </dt>   <dd>    <p>Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is also called failing open.</p>   </dd>  </dl>
    /// - On success, responds with [`DiscoverInstancesOutput`](crate::output::DiscoverInstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<HttpInstanceSummary>>)`](crate::output::DiscoverInstancesOutput::instances): <p>A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.</p>
    /// - On failure, responds with [`SdkError<DiscoverInstancesError>`](crate::error::DiscoverInstancesError)
    pub fn discover_instances(&self) -> fluent_builders::DiscoverInstances {
        fluent_builders::DiscoverInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInstance`](crate::client::fluent_builders::GetInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::GetInstance::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::GetInstance::set_service_id): <p>The ID of the service that the instance is associated with.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetInstance::set_instance_id): <p>The ID of the instance that you want to get information about.</p>
    /// - On success, responds with [`GetInstanceOutput`](crate::output::GetInstanceOutput) with field(s):
    ///   - [`instance(Option<Instance>)`](crate::output::GetInstanceOutput::instance): <p>A complex type that contains information about a specified instance.</p>
    /// - On failure, responds with [`SdkError<GetInstanceError>`](crate::error::GetInstanceError)
    pub fn get_instance(&self) -> fluent_builders::GetInstance {
        fluent_builders::GetInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInstancesHealthStatus`](crate::client::fluent_builders::GetInstancesHealthStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInstancesHealthStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::GetInstancesHealthStatus::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::GetInstancesHealthStatus::set_service_id): <p>The ID of the service that the instance is associated with.</p>
    ///   - [`instances(Vec<String>)`](crate::client::fluent_builders::GetInstancesHealthStatus::instances) / [`set_instances(Option<Vec<String>>)`](crate::client::fluent_builders::GetInstancesHealthStatus::set_instances): <p>An array that contains the IDs of all the instances that you want to get the health status for.</p>  <p>If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are associated with the specified service.</p> <note>   <p>To get the IDs for the instances that you've registered by using a specified service, submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInstancesHealthStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInstancesHealthStatus::set_max_results): <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInstancesHealthStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInstancesHealthStatus::set_next_token): <p>For the first <code>GetInstancesHealthStatus</code> request, omit this value.</p>  <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
    /// - On success, responds with [`GetInstancesHealthStatusOutput`](crate::output::GetInstancesHealthStatusOutput) with field(s):
    ///   - [`status(Option<HashMap<String, HealthStatus>>)`](crate::output::GetInstancesHealthStatusOutput::status): <p>A complex type that contains the IDs and the health status of the instances that you specified in the <code>GetInstancesHealthStatus</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInstancesHealthStatusOutput::next_token): <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
    /// - On failure, responds with [`SdkError<GetInstancesHealthStatusError>`](crate::error::GetInstancesHealthStatusError)
    pub fn get_instances_health_status(&self) -> fluent_builders::GetInstancesHealthStatus {
        fluent_builders::GetInstancesHealthStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNamespace`](crate::client::fluent_builders::GetNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetNamespace::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetNamespace::set_id): <p>The ID of the namespace that you want to get information about.</p>
    /// - On success, responds with [`GetNamespaceOutput`](crate::output::GetNamespaceOutput) with field(s):
    ///   - [`namespace(Option<Namespace>)`](crate::output::GetNamespaceOutput::namespace): <p>A complex type that contains information about the specified namespace.</p>
    /// - On failure, responds with [`SdkError<GetNamespaceError>`](crate::error::GetNamespaceError)
    pub fn get_namespace(&self) -> fluent_builders::GetNamespace {
        fluent_builders::GetNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOperation`](crate::client::fluent_builders::GetOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`operation_id(impl Into<String>)`](crate::client::fluent_builders::GetOperation::operation_id) / [`set_operation_id(Option<String>)`](crate::client::fluent_builders::GetOperation::set_operation_id): <p>The ID of the operation that you want to get more information about.</p>
    /// - On success, responds with [`GetOperationOutput`](crate::output::GetOperationOutput) with field(s):
    ///   - [`operation(Option<Operation>)`](crate::output::GetOperationOutput::operation): <p>A complex type that contains information about the operation.</p>
    /// - On failure, responds with [`SdkError<GetOperationError>`](crate::error::GetOperationError)
    pub fn get_operation(&self) -> fluent_builders::GetOperation {
        fluent_builders::GetOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetService`](crate::client::fluent_builders::GetService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetService::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetService::set_id): <p>The ID of the service that you want to get settings for.</p>
    /// - On success, responds with [`GetServiceOutput`](crate::output::GetServiceOutput) with field(s):
    ///   - [`service(Option<Service>)`](crate::output::GetServiceOutput::service): <p>A complex type that contains information about the service.</p>
    /// - On failure, responds with [`SdkError<GetServiceError>`](crate::error::GetServiceError)
    pub fn get_service(&self) -> fluent_builders::GetService {
        fluent_builders::GetService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstances`](crate::client::fluent_builders::ListInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::ListInstances::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::ListInstances::set_service_id): <p>The ID of the service that you want to list instances for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstances::set_next_token): <p>For the first <code>ListInstances</code> request, omit this value.</p>  <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstances::set_max_results): <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
    /// - On success, responds with [`ListInstancesOutput`](crate::output::ListInstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<InstanceSummary>>)`](crate::output::ListInstancesOutput::instances): <p>Summary information about the instances that are associated with the specified service.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstancesOutput::next_token): <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
    /// - On failure, responds with [`SdkError<ListInstancesError>`](crate::error::ListInstancesError)
    pub fn list_instances(&self) -> fluent_builders::ListInstances {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNamespaces`](crate::client::fluent_builders::ListNamespaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNamespaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNamespaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNamespaces::set_next_token): <p>For the first <code>ListNamespaces</code> request, omit this value.</p>  <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNamespaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNamespaces::set_max_results): <p>The maximum number of namespaces that you want Cloud Map to return in the response to a <code>ListNamespaces</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 namespaces.</p>
    ///   - [`filters(Vec<NamespaceFilter>)`](crate::client::fluent_builders::ListNamespaces::filters) / [`set_filters(Option<Vec<NamespaceFilter>>)`](crate::client::fluent_builders::ListNamespaces::set_filters): <p>A complex type that contains specifications for the namespaces that you want to list.</p>  <p>If you specify more than one filter, a namespace must match all filters to be returned by <code>ListNamespaces</code>.</p>
    /// - On success, responds with [`ListNamespacesOutput`](crate::output::ListNamespacesOutput) with field(s):
    ///   - [`namespaces(Option<Vec<NamespaceSummary>>)`](crate::output::ListNamespacesOutput::namespaces): <p>An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNamespacesOutput::next_token): <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>  </note>
    /// - On failure, responds with [`SdkError<ListNamespacesError>`](crate::error::ListNamespacesError)
    pub fn list_namespaces(&self) -> fluent_builders::ListNamespaces {
        fluent_builders::ListNamespaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOperations`](crate::client::fluent_builders::ListOperations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOperations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOperations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOperations::set_next_token): <p>For the first <code>ListOperations</code> request, omit this value.</p>  <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOperations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOperations::set_max_results): <p>The maximum number of items that you want Cloud Map to return in the response to a <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 operations.</p>
    ///   - [`filters(Vec<OperationFilter>)`](crate::client::fluent_builders::ListOperations::filters) / [`set_filters(Option<Vec<OperationFilter>>)`](crate::client::fluent_builders::ListOperations::set_filters): <p>A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date.</p>  <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListOperations</code>.</p>
    /// - On success, responds with [`ListOperationsOutput`](crate::output::ListOperationsOutput) with field(s):
    ///   - [`operations(Option<Vec<OperationSummary>>)`](crate::output::ListOperationsOutput::operations): <p>Summary information about the operations that match the specified criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOperationsOutput::next_token): <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>  </note>
    /// - On failure, responds with [`SdkError<ListOperationsError>`](crate::error::ListOperationsError)
    pub fn list_operations(&self) -> fluent_builders::ListOperations {
        fluent_builders::ListOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServices`](crate::client::fluent_builders::ListServices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServices::set_next_token): <p>For the first <code>ListServices</code> request, omit this value.</p>  <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServices::set_max_results): <p>The maximum number of services that you want Cloud Map to return in the response to a <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 services.</p>
    ///   - [`filters(Vec<ServiceFilter>)`](crate::client::fluent_builders::ListServices::filters) / [`set_filters(Option<Vec<ServiceFilter>>)`](crate::client::fluent_builders::ListServices::set_filters): <p>A complex type that contains specifications for the namespaces that you want to list services for. </p>  <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListServices</code>.</p>
    /// - On success, responds with [`ListServicesOutput`](crate::output::ListServicesOutput) with field(s):
    ///   - [`services(Option<Vec<ServiceSummary>>)`](crate::output::ListServicesOutput::services): <p>An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServicesOutput::next_token): <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>   <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>  </note>
    /// - On failure, responds with [`SdkError<ListServicesError>`](crate::error::ListServicesError)
    pub fn list_services(&self) -> fluent_builders::ListServices {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are assigned to the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterInstance`](crate::client::fluent_builders::RegisterInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::RegisterInstance::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::RegisterInstance::set_service_id): <p>The ID of the service that you want to use for settings for the instance.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::RegisterInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::RegisterInstance::set_instance_id): <p>An identifier that you want to associate with the instance. Note the following:</p>  <ul>   <li> <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a>.</p> </li>   <li> <p>You can use this value to update an existing instance.</p> </li>   <li> <p>To register a new instance, you must specify a value that's unique among instances that you register by using the same service. </p> </li>   <li> <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing DNS records, if any. If there's also an existing health check, Cloud Map deletes the old health check and creates a new one. </p> <note>     <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.</p>    </note> </li>  </ul>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::RegisterInstance::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::RegisterInstance::set_creator_request_id): <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::RegisterInstance::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::RegisterInstance::set_attributes): <p>A string map that contains the following information for the service that you specify in <code>ServiceId</code>:</p>  <ul>   <li> <p>The attributes that apply to the records that are defined in the service. </p> </li>   <li> <p>For each attribute, the applicable value.</p> </li>  </ul>  <p>Supported attribute keys include the following:</p>  <dl>   <dt>   AWS_ALIAS_DNS_NAME  </dt>   <dd>    <p>If you want Cloud Map to create an Amazon Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that's associated with the load balancer. For information about how to get the DNS name, see "DNSName" in the topic <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a> in the <i>Route 53 API Reference</i>.</p>    <p>Note the following:</p>    <ul>     <li> <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</p> </li>     <li> <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code>.</p> </li>     <li> <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, Cloud Map will create the Route 53 health check, but it doesn't associate the health check with the alias record.</p> </li>     <li> <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other than Elastic Load Balancing load balancers.</p> </li>     <li> <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</p> </li>    </ul>   </dd>   <dt>   AWS_EC2_INSTANCE_ID  </dt>   <dd>    <p> <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. If the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code>. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the <code>AWS_INSTANCE_IPV4</code> attribute will be filled out with the primary private IPv4 address.</p>   </dd>   <dt>   AWS_INIT_HEALTH_STATUS  </dt>   <dd>    <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>   </dd>   <dt>   AWS_INSTANCE_CNAME  </dt>   <dd>    <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries (for example, <code>example.com</code>).</p>    <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.</p>   </dd>   <dt>   AWS_INSTANCE_IPV4  </dt>   <dd>    <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>    <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>   </dd>   <dt>   AWS_INSTANCE_IPV6  </dt>   <dd>    <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>    <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>   </dd>   <dt>   AWS_INSTANCE_PORT  </dt>   <dd>    <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</p>    <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send requests to. </p>    <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.</p>   </dd>   <dt>   Custom attributes  </dt>   <dd>    <p>You can add up to 30 custom attributes. For each key-value pair, the maximum length of the attribute name is 255 characters, and the maximum length of the attribute value is 1,024 characters. The total size of all provided attributes (sum of all keys and values) must not exceed 5,000 characters.</p>   </dd>  </dl>
    /// - On success, responds with [`RegisterInstanceOutput`](crate::output::RegisterInstanceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::RegisterInstanceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<RegisterInstanceError>`](crate::error::RegisterInstanceError)
    pub fn register_instance(&self) -> fluent_builders::RegisterInstance {
        fluent_builders::RegisterInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the specified resource. Specifying the tag key is required. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHttpNamespace`](crate::client::fluent_builders::UpdateHttpNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateHttpNamespace::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateHttpNamespace::set_id): <p>The ID of the namespace that you want to update.</p>
    ///   - [`updater_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHttpNamespace::updater_request_id) / [`set_updater_request_id(Option<String>)`](crate::client::fluent_builders::UpdateHttpNamespace::set_updater_request_id): <p>A unique string that identifies the request and that allows failed <code>UpdateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`namespace(HttpNamespaceChange)`](crate::client::fluent_builders::UpdateHttpNamespace::namespace) / [`set_namespace(Option<HttpNamespaceChange>)`](crate::client::fluent_builders::UpdateHttpNamespace::set_namespace): <p>Updated properties for the the HTTP namespace.</p>
    /// - On success, responds with [`UpdateHttpNamespaceOutput`](crate::output::UpdateHttpNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdateHttpNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<UpdateHttpNamespaceError>`](crate::error::UpdateHttpNamespaceError)
    pub fn update_http_namespace(&self) -> fluent_builders::UpdateHttpNamespace {
        fluent_builders::UpdateHttpNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInstanceCustomHealthStatus`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::set_service_id): <p>The ID of the service that includes the configuration for the custom health check that you want to change the status for.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::set_instance_id): <p>The ID of the instance that you want to change the health status for.</p>
    ///   - [`status(CustomHealthStatus)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::status) / [`set_status(Option<CustomHealthStatus>)`](crate::client::fluent_builders::UpdateInstanceCustomHealthStatus::set_status): <p>The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.</p>
    /// - On success, responds with [`UpdateInstanceCustomHealthStatusOutput`](crate::output::UpdateInstanceCustomHealthStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateInstanceCustomHealthStatusError>`](crate::error::UpdateInstanceCustomHealthStatusError)
    pub fn update_instance_custom_health_status(
        &self,
    ) -> fluent_builders::UpdateInstanceCustomHealthStatus {
        fluent_builders::UpdateInstanceCustomHealthStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePrivateDnsNamespace`](crate::client::fluent_builders::UpdatePrivateDnsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::set_id): <p>The ID of the namespace that you want to update.</p>
    ///   - [`updater_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::updater_request_id) / [`set_updater_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::set_updater_request_id): <p>A unique string that identifies the request and that allows failed <code>UpdatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`namespace(PrivateDnsNamespaceChange)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::namespace) / [`set_namespace(Option<PrivateDnsNamespaceChange>)`](crate::client::fluent_builders::UpdatePrivateDnsNamespace::set_namespace): <p>Updated properties for the private DNS namespace.</p>
    /// - On success, responds with [`UpdatePrivateDnsNamespaceOutput`](crate::output::UpdatePrivateDnsNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdatePrivateDnsNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<UpdatePrivateDnsNamespaceError>`](crate::error::UpdatePrivateDnsNamespaceError)
    pub fn update_private_dns_namespace(&self) -> fluent_builders::UpdatePrivateDnsNamespace {
        fluent_builders::UpdatePrivateDnsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePublicDnsNamespace`](crate::client::fluent_builders::UpdatePublicDnsNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::set_id): <p>The ID of the namespace being updated.</p>
    ///   - [`updater_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::updater_request_id) / [`set_updater_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::set_updater_request_id): <p>A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
    ///   - [`namespace(PublicDnsNamespaceChange)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::namespace) / [`set_namespace(Option<PublicDnsNamespaceChange>)`](crate::client::fluent_builders::UpdatePublicDnsNamespace::set_namespace): <p>Updated properties for the public DNS namespace.</p>
    /// - On success, responds with [`UpdatePublicDnsNamespaceOutput`](crate::output::UpdatePublicDnsNamespaceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdatePublicDnsNamespaceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<UpdatePublicDnsNamespaceError>`](crate::error::UpdatePublicDnsNamespaceError)
    pub fn update_public_dns_namespace(&self) -> fluent_builders::UpdatePublicDnsNamespace {
        fluent_builders::UpdatePublicDnsNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateService`](crate::client::fluent_builders::UpdateService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateService::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateService::set_id): <p>The ID of the service that you want to update.</p>
    ///   - [`service(ServiceChange)`](crate::client::fluent_builders::UpdateService::service) / [`set_service(Option<ServiceChange>)`](crate::client::fluent_builders::UpdateService::set_service): <p>A complex type that contains the new settings for the service.</p>
    /// - On success, responds with [`UpdateServiceOutput`](crate::output::UpdateServiceOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdateServiceOutput::operation_id): <p>A value that you can use to determine whether the request completed successfully. To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    /// - On failure, responds with [`SdkError<UpdateServiceError>`](crate::error::UpdateServiceError)
    pub fn update_service(&self) -> fluent_builders::UpdateService {
        fluent_builders::UpdateService::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateHttpNamespace`.
    ///
    /// <p>Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a <code>DiscoverInstances</code> request but can't be discovered using DNS.</p>
    /// <p>For the current quota on the number of namespaces that you can create using the same account, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html">Cloud Map quotas</a> in the <i>Cloud Map Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHttpNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_http_namespace_input::Builder,
    }
    impl CreateHttpNamespace {
        /// Creates a new `CreateHttpNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHttpNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHttpNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to assign to this namespace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to assign to this namespace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePrivateDnsNamespace`.
    ///
    /// <p>Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service <code>backend</code>, the resulting DNS name for the service is <code>backend.example.com</code>. Service instances that are registered using a private DNS namespace can be discovered using either a <code>DiscoverInstances</code> request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html">Cloud Map quotas</a> in the <i>Cloud Map Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePrivateDnsNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_private_dns_namespace_input::Builder,
    }
    impl CreatePrivateDnsNamespace {
        /// Creates a new `CreatePrivateDnsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePrivateDnsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePrivateDnsNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to assign to this namespace. When you create a private DNS namespace, Cloud Map automatically creates an Amazon Route 53 private hosted zone that has the same name as the namespace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to assign to this namespace. When you create a private DNS namespace, Cloud Map automatically creates an Amazon Route 53 private hosted zone that has the same name as the namespace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID of the Amazon VPC that you want to associate the namespace with.</p>
        pub fn vpc(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to associate the namespace with.</p>
        pub fn set_vpc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Properties for the private DNS namespace.</p>
        pub fn properties(mut self, input: crate::model::PrivateDnsNamespaceProperties) -> Self {
            self.inner = self.inner.properties(input);
            self
        }
        /// <p>Properties for the private DNS namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsNamespaceProperties>,
        ) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicDnsNamespace`.
    ///
    /// <p>Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service <code>backend</code>, the resulting DNS name for the service is <code>backend.example.com</code>. You can discover instances that were registered with a public DNS namespace by using either a <code>DiscoverInstances</code> request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html">Cloud Map quotas</a> in the <i>Cloud Map Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePublicDnsNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_public_dns_namespace_input::Builder,
    }
    impl CreatePublicDnsNamespace {
        /// Creates a new `CreatePublicDnsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicDnsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicDnsNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to assign to this namespace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to assign to this namespace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Properties for the public DNS namespace.</p>
        pub fn properties(mut self, input: crate::model::PublicDnsNamespaceProperties) -> Self {
            self.inner = self.inner.properties(input);
            self
        }
        /// <p>Properties for the public DNS namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::PublicDnsNamespaceProperties>,
        ) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateService`.
    ///
    /// <p>Creates a service. This action defines the configuration for the following entities:</p>
    /// <ul>
    /// <li> <p>For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:</p>
    /// <ul>
    /// <li> <p> <code>A</code> </p> </li>
    /// <li> <p> <code>AAAA</code> </p> </li>
    /// <li> <p> <code>A</code> and <code>AAAA</code> </p> </li>
    /// <li> <p> <code>SRV</code> </p> </li>
    /// <li> <p> <code>CNAME</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Optionally, a health check</p> </li>
    /// </ul>
    /// <p>After you create the service, you can submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, and Cloud Map uses the values in the configuration to create the specified entities.</p>
    /// <p>For the current quota on the number of instances that you can register using the same namespace and using the same service, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html">Cloud Map quotas</a> in the <i>Cloud Map Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_service_input::Builder,
    }
    impl CreateService {
        /// Creates a new `CreateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to assign to the service.</p>
        /// <p>If you want Cloud Map to create an <code>SRV</code> record when you register an instance and you're using a system that requires a specific <code>SRV</code> format, such as <a href="http://www.haproxy.org/">HAProxy</a>, specify the following for <code>Name</code>:</p>
        /// <ul>
        /// <li> <p>Start the name with an underscore (_), such as <code>_exampleservice</code>.</p> </li>
        /// <li> <p>End the name with <i>._protocol</i>, such as <code>._tcp</code>.</p> </li>
        /// </ul>
        /// <p>When you register an instance, Cloud Map creates an <code>SRV</code> record and assigns a name to the record by concatenating the service name and the namespace name (for example,</p>
        /// <p> <code>_exampleservice._tcp.example.com</code>).</p> <note>
        /// <p>For services that are accessible by DNS queries, you can't create multiple services with names that differ only by case (such as EXAMPLE and example). Otherwise, these services have the same DNS name and can't be distinguished. However, if you use a namespace that's only accessible by API calls, then you can create services that with names that differ only by case.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to assign to the service.</p>
        /// <p>If you want Cloud Map to create an <code>SRV</code> record when you register an instance and you're using a system that requires a specific <code>SRV</code> format, such as <a href="http://www.haproxy.org/">HAProxy</a>, specify the following for <code>Name</code>:</p>
        /// <ul>
        /// <li> <p>Start the name with an underscore (_), such as <code>_exampleservice</code>.</p> </li>
        /// <li> <p>End the name with <i>._protocol</i>, such as <code>._tcp</code>.</p> </li>
        /// </ul>
        /// <p>When you register an instance, Cloud Map creates an <code>SRV</code> record and assigns a name to the record by concatenating the service name and the namespace name (for example,</p>
        /// <p> <code>_exampleservice._tcp.example.com</code>).</p> <note>
        /// <p>For services that are accessible by DNS queries, you can't create multiple services with names that differ only by case (such as EXAMPLE and example). Otherwise, these services have the same DNS name and can't be distinguished. However, if you use a namespace that's only accessible by API calls, then you can create services that with names that differ only by case.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the namespace that you want to use to create the service. The namespace ID must be specified, but it can be specified either here or in the <code>DnsConfig</code> object.</p>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The ID of the namespace that you want to use to create the service. The namespace ID must be specified, but it can be specified either here or in the <code>DnsConfig</code> object.</p>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateService</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateService</code> requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A description for the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A complex type that contains information about the Amazon Route 53 records that you want Cloud Map to create when you register an instance. </p>
        pub fn dns_config(mut self, input: crate::model::DnsConfig) -> Self {
            self.inner = self.inner.dns_config(input);
            self
        }
        /// <p>A complex type that contains information about the Amazon Route 53 records that you want Cloud Map to create when you register an instance. </p>
        pub fn set_dns_config(
            mut self,
            input: std::option::Option<crate::model::DnsConfig>,
        ) -> Self {
            self.inner = self.inner.set_dns_config(input);
            self
        }
        /// <p> <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional Route 53 health check. If you specify settings for a health check, Cloud Map associates the health check with all the Route 53 DNS records that you specify in <code>DnsConfig</code>.</p> <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/cloud-map/pricing/">Cloud Map Pricing</a>.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.inner = self.inner.health_check_config(input);
            self
        }
        /// <p> <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional Route 53 health check. If you specify settings for a health check, Cloud Map associates the health check with all the Route 53 DNS records that you specify in <code>DnsConfig</code>.</p> <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/cloud-map/pricing/">Cloud Map Pricing</a>.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.inner = self.inner.set_health_check_config(input);
            self
        }
        /// <p>A complex type that contains information about an optional custom health check.</p> <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        /// <p>You can't add, update, or delete a <code>HealthCheckCustomConfig</code> configuration from an existing service.</p>
        pub fn health_check_custom_config(
            mut self,
            input: crate::model::HealthCheckCustomConfig,
        ) -> Self {
            self.inner = self.inner.health_check_custom_config(input);
            self
        }
        /// <p>A complex type that contains information about an optional custom health check.</p> <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        /// <p>You can't add, update, or delete a <code>HealthCheckCustomConfig</code> configuration from an existing service.</p>
        pub fn set_health_check_custom_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckCustomConfig>,
        ) -> Self {
            self.inner = self.inner.set_health_check_custom_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the service. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the service. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>If present, specifies that the service instances are only discoverable using the <code>DiscoverInstances</code> API operation. No DNS records is registered for the service instances. The only valid value is <code>HTTP</code>.</p>
        pub fn r#type(mut self, input: crate::model::ServiceTypeOption) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>If present, specifies that the service instances are only discoverable using the <code>DiscoverInstances</code> API operation. No DNS records is registered for the service instances. The only valid value is <code>HTTP</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ServiceTypeOption>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamespace`.
    ///
    /// <p>Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_namespace_input::Builder,
    }
    impl DeleteNamespace {
        /// Creates a new `DeleteNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the namespace that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the namespace that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteService`.
    ///
    /// <p>Deletes a specified service. If the service still contains one or more registered instances, the request fails.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_service_input::Builder,
    }
    impl DeleteService {
        /// Creates a new `DeleteService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the service that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterInstance`.
    ///
    /// <p>Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_instance_input::Builder,
    }
    impl DeregisterInstance {
        /// Creates a new `DeregisterInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// <p>The value that you specified for <code>Id</code> in the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The value that you specified for <code>Id</code> in the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DiscoverInstances`.
    ///
    /// <p>Discovers registered instances for a specified namespace and service. You can use <code>DiscoverInstances</code> to discover instances for any type of namespace. For public and private DNS namespaces, you can also use DNS queries to discover instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DiscoverInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::discover_instances_input::Builder,
    }
    impl DiscoverInstances {
        /// Creates a new `DiscoverInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DiscoverInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DiscoverInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the <code>Properties</code> member of the namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_name(input.into());
            self
        }
        /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the <code>Properties</code> member of the namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_namespace_name(input);
            self
        }
        /// <p>The name of the service that you specified when you registered the instance.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(input.into());
            self
        }
        /// <p>The name of the service that you specified when you registered the instance.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `QueryParameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>Filters to scope the results based on custom attributes for the instance (for example, <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are returned.</p>
        pub fn query_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.query_parameters(k.into(), v.into());
            self
        }
        /// <p>Filters to scope the results based on custom attributes for the instance (for example, <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are returned.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_parameters(input);
            self
        }
        /// Adds a key-value pair to `OptionalParameters`.
        ///
        /// To override the contents of this collection use [`set_optional_parameters`](Self::set_optional_parameters).
        ///
        /// <p>Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in the <code>QueryParameters</code> parameter are returned.</p>
        pub fn optional_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.optional_parameters(k.into(), v.into());
            self
        }
        /// <p>Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in the <code>QueryParameters</code> parameter are returned.</p>
        pub fn set_optional_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_optional_parameters(input);
            self
        }
        /// <p>The health status of the instances that you want to discover. This parameter is ignored for services that don't have a health check configured, and all instances are returned.</p>
        /// <dl>
        /// <dt>
        /// HEALTHY
        /// </dt>
        /// <dd>
        /// <p>Returns healthy instances.</p>
        /// </dd>
        /// <dt>
        /// UNHEALTHY
        /// </dt>
        /// <dd>
        /// <p>Returns unhealthy instances.</p>
        /// </dd>
        /// <dt>
        /// ALL
        /// </dt>
        /// <dd>
        /// <p>Returns all instances.</p>
        /// </dd>
        /// <dt>
        /// HEALTHY_OR_ELSE_ALL
        /// </dt>
        /// <dd>
        /// <p>Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is also called failing open.</p>
        /// </dd>
        /// </dl>
        pub fn health_status(mut self, input: crate::model::HealthStatusFilter) -> Self {
            self.inner = self.inner.health_status(input);
            self
        }
        /// <p>The health status of the instances that you want to discover. This parameter is ignored for services that don't have a health check configured, and all instances are returned.</p>
        /// <dl>
        /// <dt>
        /// HEALTHY
        /// </dt>
        /// <dd>
        /// <p>Returns healthy instances.</p>
        /// </dd>
        /// <dt>
        /// UNHEALTHY
        /// </dt>
        /// <dd>
        /// <p>Returns unhealthy instances.</p>
        /// </dd>
        /// <dt>
        /// ALL
        /// </dt>
        /// <dd>
        /// <p>Returns all instances.</p>
        /// </dd>
        /// <dt>
        /// HEALTHY_OR_ELSE_ALL
        /// </dt>
        /// <dd>
        /// <p>Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is also called failing open.</p>
        /// </dd>
        /// </dl>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::HealthStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_health_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstance`.
    ///
    /// <p>Gets information about a specified instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_instance_input::Builder,
    }
    impl GetInstance {
        /// Creates a new `GetInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// <p>The ID of the instance that you want to get information about.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance that you want to get information about.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstancesHealthStatus`.
    ///
    /// <p>Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or more instances that are associated with a specified service.</p> <note>
    /// <p>There's a brief delay between when you register an instance and when the health status for the instance is available. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInstancesHealthStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_instances_health_status_input::Builder,
    }
    impl GetInstancesHealthStatus {
        /// Creates a new `GetInstancesHealthStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstancesHealthStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstancesHealthStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInstancesHealthStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInstancesHealthStatusPaginator {
            crate::paginator::GetInstancesHealthStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that the instance is associated with.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// Appends an item to `Instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>An array that contains the IDs of all the instances that you want to get the health status for.</p>
        /// <p>If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are associated with the specified service.</p> <note>
        /// <p>To get the IDs for the instances that you've registered by using a specified service, submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.</p>
        /// </note>
        pub fn instances(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instances(input.into());
            self
        }
        /// <p>An array that contains the IDs of all the instances that you want to get the health status for.</p>
        /// <p>If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are associated with the specified service.</p> <note>
        /// <p>To get the IDs for the instances that you've registered by using a specified service, submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.</p>
        /// </note>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>GetInstancesHealthStatus</code> request, omit this value.</p>
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>GetInstancesHealthStatus</code> request, omit this value.</p>
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNamespace`.
    ///
    /// <p>Gets information about a namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_namespace_input::Builder,
    }
    impl GetNamespace {
        /// Creates a new `GetNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the namespace that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the namespace that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperation`.
    ///
    /// <p>Gets information about any operation that returns an operation ID in the response, such as a <code>CreateService</code> request.</p> <note>
    /// <p>To get a list of operations that match specified criteria, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html">ListOperations</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOperation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_operation_input::Builder,
    }
    impl GetOperation {
        /// Creates a new `GetOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the operation that you want to get more information about.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(input.into());
            self
        }
        /// <p>The ID of the operation that you want to get more information about.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetService`.
    ///
    /// <p>Gets the settings for a specified service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_input::Builder,
    }
    impl GetService {
        /// Creates a new `GetService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that you want to get settings for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the service that you want to get settings for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>Lists summary information about the instances that you registered by using a specified service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl ListInstances {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstancesPaginator {
            crate::paginator::ListInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the service that you want to list instances for.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that you want to list instances for.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// <p>For the first <code>ListInstances</code> request, omit this value.</p>
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListInstances</code> request, omit this value.</p>
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of instances that you want Cloud Map to return in the response to a <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 instances.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNamespaces`.
    ///
    /// <p>Lists summary information about the namespaces that were created by the current account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNamespaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_namespaces_input::Builder,
    }
    impl ListNamespaces {
        /// Creates a new `ListNamespaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNamespacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNamespacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNamespacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNamespacesPaginator {
            crate::paginator::ListNamespacesPaginator::new(self.handle, self.inner)
        }
        /// <p>For the first <code>ListNamespaces</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListNamespaces</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of namespaces that you want Cloud Map to return in the response to a <code>ListNamespaces</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 namespaces.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of namespaces that you want Cloud Map to return in the response to a <code>ListNamespaces</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 namespaces.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A complex type that contains specifications for the namespaces that you want to list.</p>
        /// <p>If you specify more than one filter, a namespace must match all filters to be returned by <code>ListNamespaces</code>.</p>
        pub fn filters(mut self, input: crate::model::NamespaceFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A complex type that contains specifications for the namespaces that you want to list.</p>
        /// <p>If you specify more than one filter, a namespace must match all filters to be returned by <code>ListNamespaces</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NamespaceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOperations`.
    ///
    /// <p>Lists operations that match the criteria that you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOperations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_operations_input::Builder,
    }
    impl ListOperations {
        /// Creates a new `ListOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOperationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOperationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOperationsPaginator {
            crate::paginator::ListOperationsPaginator::new(self.handle, self.inner)
        }
        /// <p>For the first <code>ListOperations</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListOperations</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items that you want Cloud Map to return in the response to a <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 operations.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items that you want Cloud Map to return in the response to a <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 operations.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date.</p>
        /// <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListOperations</code>.</p>
        pub fn filters(mut self, input: crate::model::OperationFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date.</p>
        /// <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListOperations</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OperationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Lists summary information for all the services that are associated with one or more specified namespaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_services_input::Builder,
    }
    impl ListServices {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServicesPaginator {
            crate::paginator::ListServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>For the first <code>ListServices</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListServices</code> request, omit this value.</p>
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.</p> <note>
        /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of services that you want Cloud Map to return in the response to a <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 services.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of services that you want Cloud Map to return in the response to a <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map returns up to 100 services.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A complex type that contains specifications for the namespaces that you want to list services for. </p>
        /// <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListServices</code>.</p>
        pub fn filters(mut self, input: crate::model::ServiceFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A complex type that contains specifications for the namespaces that you want to list services for. </p>
        /// <p>If you specify more than one filter, an operation must match all filters to be returned by <code>ListServices</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterInstance`.
    ///
    /// <p>Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a <code>RegisterInstance</code> request, the following occurs:</p>
    /// <ul>
    /// <li> <p>For each DNS record that you define in the service that's specified by <code>ServiceId</code>, a record is created or updated in the hosted zone that's associated with the corresponding namespace.</p> </li>
    /// <li> <p>If the service includes <code>HealthCheckConfig</code>, a health check is created based on the settings in the health check configuration.</p> </li>
    /// <li> <p>The health check, if any, is associated with each of the new or updated records.</p> </li>
    /// </ul> <important>
    /// <p>One <code>RegisterInstance</code> request must complete before you can submit another request and specify the same service ID and instance ID.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a>.</p>
    /// <p>When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:</p>
    /// <ul>
    /// <li> <p> <b>If the health check is healthy</b>: returns all the records</p> </li>
    /// <li> <p> <b>If the health check is unhealthy</b>: returns the applicable value for the last healthy instance</p> </li>
    /// <li> <p> <b>If you didn't specify a health check configuration</b>: returns all the records</p> </li>
    /// </ul>
    /// <p>For the current quota on the number of instances that you can register using the same namespace and using the same service, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html">Cloud Map quotas</a> in the <i>Cloud Map Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_instance_input::Builder,
    }
    impl RegisterInstance {
        /// Creates a new `RegisterInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that you want to use for settings for the instance.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that you want to use for settings for the instance.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// <p>An identifier that you want to associate with the instance. Note the following:</p>
        /// <ul>
        /// <li> <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a>.</p> </li>
        /// <li> <p>You can use this value to update an existing instance.</p> </li>
        /// <li> <p>To register a new instance, you must specify a value that's unique among instances that you register by using the same service. </p> </li>
        /// <li> <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing DNS records, if any. If there's also an existing health check, Cloud Map deletes the old health check and creates a new one. </p> <note>
        /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.</p>
        /// </note> </li>
        /// </ul>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>An identifier that you want to associate with the instance. Note the following:</p>
        /// <ul>
        /// <li> <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record, the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code> record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord &gt; Type</a>.</p> </li>
        /// <li> <p>You can use this value to update an existing instance.</p> </li>
        /// <li> <p>To register a new instance, you must specify a value that's unique among instances that you register by using the same service. </p> </li>
        /// <li> <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing DNS records, if any. If there's also an existing health check, Cloud Map deletes the old health check and creates a new one. </p> <note>
        /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a <code>ListHealthChecks</code> request, for example.</p>
        /// </note> </li>
        /// </ul>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time stamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A string map that contains the following information for the service that you specify in <code>ServiceId</code>:</p>
        /// <ul>
        /// <li> <p>The attributes that apply to the records that are defined in the service. </p> </li>
        /// <li> <p>For each attribute, the applicable value.</p> </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>
        /// AWS_ALIAS_DNS_NAME
        /// </dt>
        /// <dd>
        /// <p>If you want Cloud Map to create an Amazon Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that's associated with the load balancer. For information about how to get the DNS name, see "DNSName" in the topic <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a> in the <i>Route 53 API Reference</i>.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</p> </li>
        /// <li> <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code>.</p> </li>
        /// <li> <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, Cloud Map will create the Route 53 health check, but it doesn't associate the health check with the alias record.</p> </li>
        /// <li> <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other than Elastic Load Balancing load balancers.</p> </li>
        /// <li> <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// AWS_EC2_INSTANCE_ID
        /// </dt>
        /// <dd>
        /// <p> <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. If the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code>. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the <code>AWS_INSTANCE_IPV4</code> attribute will be filled out with the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>
        /// AWS_INIT_HEALTH_STATUS
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_CNAME
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries (for example, <code>example.com</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_IPV4
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_IPV6
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_PORT
        /// </dt>
        /// <dd>
        /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</p>
        /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send requests to. </p>
        /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.</p>
        /// </dd>
        /// <dt>
        /// Custom attributes
        /// </dt>
        /// <dd>
        /// <p>You can add up to 30 custom attributes. For each key-value pair, the maximum length of the attribute name is 255 characters, and the maximum length of the attribute value is 1,024 characters. The total size of all provided attributes (sum of all keys and values) must not exceed 5,000 characters.</p>
        /// </dd>
        /// </dl>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A string map that contains the following information for the service that you specify in <code>ServiceId</code>:</p>
        /// <ul>
        /// <li> <p>The attributes that apply to the records that are defined in the service. </p> </li>
        /// <li> <p>For each attribute, the applicable value.</p> </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>
        /// AWS_ALIAS_DNS_NAME
        /// </dt>
        /// <dd>
        /// <p>If you want Cloud Map to create an Amazon Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that's associated with the load balancer. For information about how to get the DNS name, see "DNSName" in the topic <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a> in the <i>Route 53 API Reference</i>.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an <code>A</code> record, an <code>AAAA</code> record, or both.</p> </li>
        /// <li> <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be <code>WEIGHTED</code>.</p> </li>
        /// <li> <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, Cloud Map will create the Route 53 health check, but it doesn't associate the health check with the alias record.</p> </li>
        /// <li> <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other than Elastic Load Balancing load balancers.</p> </li>
        /// <li> <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the <code>AWS_INSTANCE</code> attributes.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// AWS_EC2_INSTANCE_ID
        /// </dt>
        /// <dd>
        /// <p> <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. If the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the only other attribute that can be specified is <code>AWS_INIT_HEALTH_STATUS</code>. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified, then the <code>AWS_INSTANCE_IPV4</code> attribute will be filled out with the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>
        /// AWS_INIT_HEALTH_STATUS
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check, <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_CNAME
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to return in response to DNS queries (for example, <code>example.com</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>CNAME</code> record.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_IPV4
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_IPV6
        /// </dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>
        /// AWS_INSTANCE_PORT
        /// </dt>
        /// <dd>
        /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the port.</p>
        /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send requests to. </p>
        /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when you created the service.</p>
        /// </dd>
        /// <dt>
        /// Custom attributes
        /// </dt>
        /// <dd>
        /// <p>You can add up to 30 custom attributes. For each key-value pair, the maximum length of the attribute name is 255 characters, and the maximum length of the attribute value is 1,024 characters. The total size of all provided attributes (sum of all keys and values) must not exceed 5,000 characters.</p>
        /// </dd>
        /// </dl>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the specified resource. Specifying the tag key is required. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the specified resource. Specifying the tag key is required. You can set the value of a tag to an empty string, but you can't set the value of a tag to null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHttpNamespace`.
    ///
    /// <p>Updates an HTTP namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHttpNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_http_namespace_input::Builder,
    }
    impl UpdateHttpNamespace {
        /// Creates a new `UpdateHttpNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHttpNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHttpNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the namespace that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the namespace that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn updater_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.updater_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdateHttpNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_updater_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_updater_request_id(input);
            self
        }
        /// <p>Updated properties for the the HTTP namespace.</p>
        pub fn namespace(mut self, input: crate::model::HttpNamespaceChange) -> Self {
            self.inner = self.inner.namespace(input);
            self
        }
        /// <p>Updated properties for the the HTTP namespace.</p>
        pub fn set_namespace(
            mut self,
            input: std::option::Option<crate::model::HttpNamespaceChange>,
        ) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceCustomHealthStatus`.
    ///
    /// <p>Submits a request to change the health status of a custom health check to healthy or unhealthy.</p>
    /// <p>You can use <code>UpdateInstanceCustomHealthStatus</code> to change the status only for custom health checks, which you define using <code>HealthCheckCustomConfig</code> when you create a service. You can't use it to change the status for Route 53 health checks, which you define using <code>HealthCheckConfig</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html">HealthCheckCustomConfig</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInstanceCustomHealthStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_instance_custom_health_status_input::Builder,
    }
    impl UpdateInstanceCustomHealthStatus {
        /// Creates a new `UpdateInstanceCustomHealthStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceCustomHealthStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceCustomHealthStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that includes the configuration for the custom health check that you want to change the status for.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the service that includes the configuration for the custom health check that you want to change the status for.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// <p>The ID of the instance that you want to change the health status for.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance that you want to change the health status for.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.</p>
        pub fn status(mut self, input: crate::model::CustomHealthStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomHealthStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePrivateDnsNamespace`.
    ///
    /// <p>Updates a private DNS namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePrivateDnsNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_private_dns_namespace_input::Builder,
    }
    impl UpdatePrivateDnsNamespace {
        /// Creates a new `UpdatePrivateDnsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePrivateDnsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePrivateDnsNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the namespace that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the namespace that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn updater_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.updater_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdatePrivateDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_updater_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_updater_request_id(input);
            self
        }
        /// <p>Updated properties for the private DNS namespace.</p>
        pub fn namespace(mut self, input: crate::model::PrivateDnsNamespaceChange) -> Self {
            self.inner = self.inner.namespace(input);
            self
        }
        /// <p>Updated properties for the private DNS namespace.</p>
        pub fn set_namespace(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsNamespaceChange>,
        ) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePublicDnsNamespace`.
    ///
    /// <p>Updates a public DNS namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePublicDnsNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_public_dns_namespace_input::Builder,
    }
    impl UpdatePublicDnsNamespace {
        /// Creates a new `UpdatePublicDnsNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePublicDnsNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePublicDnsNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the namespace being updated.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the namespace being updated.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn updater_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.updater_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code> requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).</p>
        pub fn set_updater_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_updater_request_id(input);
            self
        }
        /// <p>Updated properties for the public DNS namespace.</p>
        pub fn namespace(mut self, input: crate::model::PublicDnsNamespaceChange) -> Self {
            self.inner = self.inner.namespace(input);
            self
        }
        /// <p>Updated properties for the public DNS namespace.</p>
        pub fn set_namespace(
            mut self,
            input: std::option::Option<crate::model::PublicDnsNamespaceChange>,
        ) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateService`.
    ///
    /// <p>Submits a request to perform the following operations:</p>
    /// <ul>
    /// <li> <p>Update the TTL setting for existing <code>DnsRecords</code> configurations</p> </li>
    /// <li> <p>Add, update, or delete <code>HealthCheckConfig</code> for a specified service</p> <note>
    /// <p>You can't add, update, or delete a <code>HealthCheckCustomConfig</code> configuration.</p>
    /// </note> </li>
    /// </ul>
    /// <p>For public and private DNS namespaces, note the following:</p>
    /// <ul>
    /// <li> <p>If you omit any existing <code>DnsRecords</code> or <code>HealthCheckConfig</code> configurations from an <code>UpdateService</code> request, the configurations are deleted from the service.</p> </li>
    /// <li> <p>If you omit an existing <code>HealthCheckCustomConfig</code> configuration from an <code>UpdateService</code> request, the configuration isn't deleted from the service.</p> </li>
    /// </ul>
    /// <p>When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_service_input::Builder,
    }
    impl UpdateService {
        /// Creates a new `UpdateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the service that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A complex type that contains the new settings for the service.</p>
        pub fn service(mut self, input: crate::model::ServiceChange) -> Self {
            self.inner = self.inner.service(input);
            self
        }
        /// <p>A complex type that contains the new settings for the service.</p>
        pub fn set_service(
            mut self,
            input: std::option::Option<crate::model::ServiceChange>,
        ) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
