// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_http_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHttpNamespaceOutput,
    crate::error::CreateHttpNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateHttpNamespaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::CreateHttpNamespaceError {
                meta: generic,
                kind: crate::error::CreateHttpNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::CreateHttpNamespaceError {
            meta: generic,
            kind: crate::error::CreateHttpNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceAlreadyExists" => crate::error::CreateHttpNamespaceError {
            meta: generic,
            kind: crate::error::CreateHttpNamespaceErrorKind::NamespaceAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceeded" => crate::error::CreateHttpNamespaceError {
            meta: generic,
            kind: crate::error::CreateHttpNamespaceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateHttpNamespaceError {
            meta: generic,
            kind: crate::error::CreateHttpNamespaceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHttpNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_http_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHttpNamespaceOutput,
    crate::error::CreateHttpNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_http_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_http_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHttpNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_private_dns_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePrivateDnsNamespaceOutput,
    crate::error::CreatePrivateDnsNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePrivateDnsNamespaceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::CreatePrivateDnsNamespaceError {
                meta: generic,
                kind: crate::error::CreatePrivateDnsNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::CreatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePrivateDnsNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceAlreadyExists" => crate::error::CreatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePrivateDnsNamespaceErrorKind::NamespaceAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceeded" => crate::error::CreatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePrivateDnsNamespaceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePrivateDnsNamespaceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePrivateDnsNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_private_dns_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePrivateDnsNamespaceOutput,
    crate::error::CreatePrivateDnsNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_private_dns_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_private_dns_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePrivateDnsNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_public_dns_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePublicDnsNamespaceOutput,
    crate::error::CreatePublicDnsNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePublicDnsNamespaceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::CreatePublicDnsNamespaceError {
                meta: generic,
                kind: crate::error::CreatePublicDnsNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::CreatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePublicDnsNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceAlreadyExists" => crate::error::CreatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePublicDnsNamespaceErrorKind::NamespaceAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceeded" => crate::error::CreatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePublicDnsNamespaceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::CreatePublicDnsNamespaceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePublicDnsNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_public_dns_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePublicDnsNamespaceOutput,
    crate::error::CreatePublicDnsNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_public_dns_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_public_dns_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePublicDnsNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceLimitExceeded" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceAlreadyExists" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::ServiceAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteNamespaceOutput, crate::error::DeleteNamespaceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteNamespaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::DeleteNamespaceError {
                meta: generic,
                kind: crate::error::DeleteNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::DeleteNamespaceError {
            meta: generic,
            kind: crate::error::DeleteNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::DeleteNamespaceError {
            meta: generic,
            kind: crate::error::DeleteNamespaceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::DeleteNamespaceError {
                meta: generic,
                kind: crate::error::DeleteNamespaceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteNamespaceOutput, crate::error::DeleteNamespaceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DeleteServiceError {
            meta: generic,
            kind: crate::error::DeleteServiceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::DeleteServiceError {
                meta: generic,
                kind: crate::error::DeleteServiceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotFound" => {
            crate::error::DeleteServiceError {
                meta: generic,
                kind: crate::error::DeleteServiceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_service_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterInstanceOutput,
    crate::error::DeregisterInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeregisterInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::DeregisterInstanceError {
                meta: generic,
                kind: crate::error::DeregisterInstanceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InstanceNotFound" => {
            crate::error::DeregisterInstanceError {
                meta: generic,
                kind: crate::error::DeregisterInstanceErrorKind::InstanceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::instance_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_instance_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::DeregisterInstanceError {
            meta: generic,
            kind: crate::error::DeregisterInstanceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeregisterInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::DeregisterInstanceError {
                meta: generic,
                kind: crate::error::DeregisterInstanceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotFound" => {
            crate::error::DeregisterInstanceError {
                meta: generic,
                kind: crate::error::DeregisterInstanceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeregisterInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterInstanceOutput,
    crate::error::DeregisterInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_deregister_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeregisterInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_discover_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DiscoverInstancesOutput, crate::error::DiscoverInstancesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DiscoverInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DiscoverInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DiscoverInstancesError {
            meta: generic,
            kind: crate::error::DiscoverInstancesErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DiscoverInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::DiscoverInstancesError {
            meta: generic,
            kind: crate::error::DiscoverInstancesErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DiscoverInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestLimitExceeded" => crate::error::DiscoverInstancesError {
            meta: generic,
            kind: crate::error::DiscoverInstancesErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::DiscoverInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::DiscoverInstancesError {
                meta: generic,
                kind: crate::error::DiscoverInstancesErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DiscoverInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DiscoverInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_discover_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DiscoverInstancesOutput, crate::error::DiscoverInstancesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::discover_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_discover_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DiscoverInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceOutput, crate::error::GetInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InstanceNotFound" => {
            crate::error::GetInstanceError {
                meta: generic,
                kind: crate::error::GetInstanceErrorKind::InstanceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::instance_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_instance_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::GetInstanceError {
                meta: generic,
                kind: crate::error::GetInstanceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceOutput, crate::error::GetInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instances_health_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstancesHealthStatusOutput,
    crate::error::GetInstancesHealthStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstancesHealthStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetInstancesHealthStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InstanceNotFound" => {
            crate::error::GetInstancesHealthStatusError {
                meta: generic,
                kind: crate::error::GetInstancesHealthStatusErrorKind::InstanceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::instance_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_instance_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesHealthStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::GetInstancesHealthStatusError {
            meta: generic,
            kind: crate::error::GetInstancesHealthStatusErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetInstancesHealthStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::GetInstancesHealthStatusError {
                meta: generic,
                kind: crate::error::GetInstancesHealthStatusErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesHealthStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetInstancesHealthStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instances_health_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstancesHealthStatusOutput,
    crate::error::GetInstancesHealthStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instances_health_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instances_health_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstancesHealthStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetNamespaceOutput, crate::error::GetNamespaceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetNamespaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetNamespaceError {
            meta: generic,
            kind: crate::error::GetNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::GetNamespaceError {
            meta: generic,
            kind: crate::error::GetNamespaceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetNamespaceOutput, crate::error::GetNamespaceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationOutput, crate::error::GetOperationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotFound" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::OperationNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationOutput, crate::error::GetOperationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetServiceOutput, crate::error::GetServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetServiceError {
            meta: generic,
            kind: crate::error::GetServiceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::GetServiceError {
                meta: generic,
                kind: crate::error::GetServiceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetServiceOutput, crate::error::GetServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListInstancesOutput, crate::error::ListInstancesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListInstancesError {
            meta: generic,
            kind: crate::error::ListInstancesErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::ListInstancesError {
                meta: generic,
                kind: crate::error::ListInstancesErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListInstancesOutput, crate::error::ListInstancesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_namespaces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListNamespacesOutput, crate::error::ListNamespacesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListNamespacesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListNamespacesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListNamespacesError {
            meta: generic,
            kind: crate::error::ListNamespacesErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListNamespacesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListNamespacesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_namespaces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListNamespacesOutput, crate::error::ListNamespacesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_namespaces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_namespaces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListNamespacesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_operations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListOperationsOutput, crate::error::ListOperationsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOperationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListOperationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListOperationsError {
            meta: generic,
            kind: crate::error::ListOperationsErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListOperationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_operations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListOperationsOutput, crate::error::ListOperationsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_operations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_operations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListOperationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_services_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListServicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListServicesError {
            meta: generic,
            kind: crate::error::ListServicesErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListServicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_services_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_services_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_services(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterInstanceOutput, crate::error::RegisterInstanceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::RegisterInstanceError {
                meta: generic,
                kind: crate::error::RegisterInstanceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::RegisterInstanceError {
            meta: generic,
            kind: crate::error::RegisterInstanceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RegisterInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::RegisterInstanceError {
                meta: generic,
                kind: crate::error::RegisterInstanceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::RegisterInstanceError {
            meta: generic,
            kind: crate::error::RegisterInstanceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::RegisterInstanceError {
                meta: generic,
                kind: crate::error::RegisterInstanceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RegisterInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterInstanceOutput, crate::error::RegisterInstanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_http_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHttpNamespaceOutput,
    crate::error::UpdateHttpNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateHttpNamespaceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::UpdateHttpNamespaceError {
                meta: generic,
                kind: crate::error::UpdateHttpNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::UpdateHttpNamespaceError {
            meta: generic,
            kind: crate::error::UpdateHttpNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::UpdateHttpNamespaceError {
            meta: generic,
            kind: crate::error::UpdateHttpNamespaceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::UpdateHttpNamespaceError {
                meta: generic,
                kind: crate::error::UpdateHttpNamespaceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateHttpNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_http_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateHttpNamespaceOutput,
    crate::error::UpdateHttpNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_http_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_http_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateHttpNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_instance_custom_health_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateInstanceCustomHealthStatusOutput,
    crate::error::UpdateInstanceCustomHealthStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomHealthNotFound" => crate::error::UpdateInstanceCustomHealthStatusError {
            meta: generic,
            kind: crate::error::UpdateInstanceCustomHealthStatusErrorKind::CustomHealthNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::custom_health_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_health_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InstanceNotFound" => {
            crate::error::UpdateInstanceCustomHealthStatusError {
                meta: generic,
                kind: crate::error::UpdateInstanceCustomHealthStatusErrorKind::InstanceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::instance_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_instance_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::UpdateInstanceCustomHealthStatusError {
            meta: generic,
            kind: crate::error::UpdateInstanceCustomHealthStatusErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::UpdateInstanceCustomHealthStatusError {
                meta: generic,
                kind: crate::error::UpdateInstanceCustomHealthStatusErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateInstanceCustomHealthStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateInstanceCustomHealthStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_instance_custom_health_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateInstanceCustomHealthStatusOutput,
    crate::error::UpdateInstanceCustomHealthStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_instance_custom_health_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_private_dns_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePrivateDnsNamespaceOutput,
    crate::error::UpdatePrivateDnsNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdatePrivateDnsNamespaceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::UpdatePrivateDnsNamespaceError {
                meta: generic,
                kind: crate::error::UpdatePrivateDnsNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::UpdatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::UpdatePrivateDnsNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::UpdatePrivateDnsNamespaceError {
            meta: generic,
            kind: crate::error::UpdatePrivateDnsNamespaceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::UpdatePrivateDnsNamespaceError {
                meta: generic,
                kind: crate::error::UpdatePrivateDnsNamespaceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdatePrivateDnsNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_private_dns_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePrivateDnsNamespaceOutput,
    crate::error::UpdatePrivateDnsNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_private_dns_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_private_dns_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePrivateDnsNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_public_dns_namespace_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePublicDnsNamespaceOutput,
    crate::error::UpdatePublicDnsNamespaceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdatePublicDnsNamespaceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::UpdatePublicDnsNamespaceError {
                meta: generic,
                kind: crate::error::UpdatePublicDnsNamespaceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::UpdatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::UpdatePublicDnsNamespaceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NamespaceNotFound" => crate::error::UpdatePublicDnsNamespaceError {
            meta: generic,
            kind: crate::error::UpdatePublicDnsNamespaceErrorKind::NamespaceNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::namespace_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_namespace_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUse" => {
            crate::error::UpdatePublicDnsNamespaceError {
                meta: generic,
                kind: crate::error::UpdatePublicDnsNamespaceErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdatePublicDnsNamespaceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_public_dns_namespace_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePublicDnsNamespaceOutput,
    crate::error::UpdatePublicDnsNamespaceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_public_dns_namespace_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_public_dns_namespace(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePublicDnsNamespaceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateRequest" => {
            crate::error::UpdateServiceError {
                meta: generic,
                kind: crate::error::UpdateServiceErrorKind::DuplicateRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::duplicate_request::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_request_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidInput" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::InvalidInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFound" => {
            crate::error::UpdateServiceError {
                meta: generic,
                kind: crate::error::UpdateServiceErrorKind::ServiceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateServiceError::unhandled)?;
        output.build()
    })
}
