// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateHttpNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHttpNamespaceError {
    /// Kind of error that occurred.
    pub kind: CreateHttpNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHttpNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHttpNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The namespace that you're trying to create already exists.</p>
    NamespaceAlreadyExists(crate::error::NamespaceAlreadyExists),
    /// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
    ResourceLimitExceeded(crate::error::ResourceLimitExceeded),
    /// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
    /// is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHttpNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHttpNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            CreateHttpNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateHttpNamespaceErrorKind::NamespaceAlreadyExists(_inner) => _inner.fmt(f),
            CreateHttpNamespaceErrorKind::ResourceLimitExceeded(_inner) => _inner.fmt(f),
            CreateHttpNamespaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateHttpNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHttpNamespaceError {
    fn code(&self) -> Option<&str> {
        CreateHttpNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHttpNamespaceError {
    /// Creates a new `CreateHttpNamespaceError`.
    pub fn new(kind: CreateHttpNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHttpNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHttpNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHttpNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHttpNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHttpNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            CreateHttpNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHttpNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateHttpNamespaceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateHttpNamespaceErrorKind::NamespaceAlreadyExists`.
    pub fn is_namespace_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateHttpNamespaceErrorKind::NamespaceAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHttpNamespaceErrorKind::ResourceLimitExceeded`.
    pub fn is_resource_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateHttpNamespaceErrorKind::ResourceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHttpNamespaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHttpNamespaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateHttpNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHttpNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            CreateHttpNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateHttpNamespaceErrorKind::NamespaceAlreadyExists(_inner) => Some(_inner),
            CreateHttpNamespaceErrorKind::ResourceLimitExceeded(_inner) => Some(_inner),
            CreateHttpNamespaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateHttpNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePrivateDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePrivateDnsNamespaceError {
    /// Kind of error that occurred.
    pub kind: CreatePrivateDnsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePrivateDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePrivateDnsNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The namespace that you're trying to create already exists.</p>
    NamespaceAlreadyExists(crate::error::NamespaceAlreadyExists),
    /// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
    ResourceLimitExceeded(crate::error::ResourceLimitExceeded),
    /// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
    /// is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePrivateDnsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePrivateDnsNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            CreatePrivateDnsNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreatePrivateDnsNamespaceErrorKind::NamespaceAlreadyExists(_inner) => _inner.fmt(f),
            CreatePrivateDnsNamespaceErrorKind::ResourceLimitExceeded(_inner) => _inner.fmt(f),
            CreatePrivateDnsNamespaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreatePrivateDnsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePrivateDnsNamespaceError {
    fn code(&self) -> Option<&str> {
        CreatePrivateDnsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePrivateDnsNamespaceError {
    /// Creates a new `CreatePrivateDnsNamespaceError`.
    pub fn new(kind: CreatePrivateDnsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePrivateDnsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePrivateDnsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePrivateDnsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePrivateDnsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePrivateDnsNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateDnsNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePrivateDnsNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateDnsNamespaceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePrivateDnsNamespaceErrorKind::NamespaceAlreadyExists`.
    pub fn is_namespace_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateDnsNamespaceErrorKind::NamespaceAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePrivateDnsNamespaceErrorKind::ResourceLimitExceeded`.
    pub fn is_resource_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateDnsNamespaceErrorKind::ResourceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePrivateDnsNamespaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePrivateDnsNamespaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreatePrivateDnsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePrivateDnsNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            CreatePrivateDnsNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            CreatePrivateDnsNamespaceErrorKind::NamespaceAlreadyExists(_inner) => Some(_inner),
            CreatePrivateDnsNamespaceErrorKind::ResourceLimitExceeded(_inner) => Some(_inner),
            CreatePrivateDnsNamespaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreatePrivateDnsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePublicDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePublicDnsNamespaceError {
    /// Kind of error that occurred.
    pub kind: CreatePublicDnsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePublicDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePublicDnsNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The namespace that you're trying to create already exists.</p>
    NamespaceAlreadyExists(crate::error::NamespaceAlreadyExists),
    /// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
    ResourceLimitExceeded(crate::error::ResourceLimitExceeded),
    /// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
    /// is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePublicDnsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePublicDnsNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            CreatePublicDnsNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreatePublicDnsNamespaceErrorKind::NamespaceAlreadyExists(_inner) => _inner.fmt(f),
            CreatePublicDnsNamespaceErrorKind::ResourceLimitExceeded(_inner) => _inner.fmt(f),
            CreatePublicDnsNamespaceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreatePublicDnsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePublicDnsNamespaceError {
    fn code(&self) -> Option<&str> {
        CreatePublicDnsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePublicDnsNamespaceError {
    /// Creates a new `CreatePublicDnsNamespaceError`.
    pub fn new(kind: CreatePublicDnsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePublicDnsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePublicDnsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePublicDnsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePublicDnsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePublicDnsNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicDnsNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublicDnsNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicDnsNamespaceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublicDnsNamespaceErrorKind::NamespaceAlreadyExists`.
    pub fn is_namespace_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicDnsNamespaceErrorKind::NamespaceAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublicDnsNamespaceErrorKind::ResourceLimitExceeded`.
    pub fn is_resource_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicDnsNamespaceErrorKind::ResourceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublicDnsNamespaceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicDnsNamespaceErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreatePublicDnsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePublicDnsNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            CreatePublicDnsNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            CreatePublicDnsNamespaceErrorKind::NamespaceAlreadyExists(_inner) => Some(_inner),
            CreatePublicDnsNamespaceErrorKind::ResourceLimitExceeded(_inner) => Some(_inner),
            CreatePublicDnsNamespaceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreatePublicDnsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceError {
    /// Kind of error that occurred.
    pub kind: CreateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
    ResourceLimitExceeded(crate::error::ResourceLimitExceeded),
    /// <p>The service can't be created because a service with the same name already exists.</p>
    ServiceAlreadyExists(crate::error::ServiceAlreadyExists),
    /// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
    /// is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ResourceLimitExceeded(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ServiceAlreadyExists(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceError {
    fn code(&self) -> Option<&str> {
        CreateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceError {
    /// Creates a new `CreateServiceError`.
    pub fn new(kind: CreateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::NamespaceNotFound(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ResourceLimitExceeded`.
    pub fn is_resource_limit_exceeded(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ResourceLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ServiceAlreadyExists`.
    pub fn is_service_already_exists(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ServiceAlreadyExists(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateServiceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            CreateServiceErrorKind::ResourceLimitExceeded(_inner) => Some(_inner),
            CreateServiceErrorKind::ServiceAlreadyExists(_inner) => Some(_inner),
            CreateServiceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNamespaceError {
    /// Kind of error that occurred.
    pub kind: DeleteNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNamespaceError {
    fn code(&self) -> Option<&str> {
        DeleteNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNamespaceError {
    /// Creates a new `DeleteNamespaceError`.
    pub fn new(kind: DeleteNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, DeleteNamespaceErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteNamespaceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(&self.kind, DeleteNamespaceErrorKind::NamespaceNotFound(_))
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, DeleteNamespaceErrorKind::ResourceInUse(_))
    }
}
impl std::error::Error for DeleteNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::ResourceInUse(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceError {
    fn code(&self) -> Option<&str> {
        DeleteServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceError {
    /// Creates a new `DeleteServiceError`.
    pub fn new(kind: DeleteServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ResourceInUse(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for DeleteServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteServiceErrorKind::ResourceInUse(_inner) => Some(_inner),
            DeleteServiceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            DeleteServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterInstanceError {
    /// Kind of error that occurred.
    pub kind: DeregisterInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterInstanceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>No instance exists with the specified ID, or the instance was recently registered, and information about the
    /// instance hasn't propagated yet.</p>
    InstanceNotFound(crate::error::InstanceNotFound),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterInstanceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            DeregisterInstanceErrorKind::InstanceNotFound(_inner) => _inner.fmt(f),
            DeregisterInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeregisterInstanceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            DeregisterInstanceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            DeregisterInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterInstanceError {
    fn code(&self) -> Option<&str> {
        DeregisterInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterInstanceError {
    /// Creates a new `DeregisterInstanceError`.
    pub fn new(kind: DeregisterInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterInstanceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, DeregisterInstanceErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `DeregisterInstanceErrorKind::InstanceNotFound`.
    pub fn is_instance_not_found(&self) -> bool {
        matches!(&self.kind, DeregisterInstanceErrorKind::InstanceNotFound(_))
    }
    /// Returns `true` if the error kind is `DeregisterInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeregisterInstanceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeregisterInstanceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, DeregisterInstanceErrorKind::ResourceInUse(_))
    }
    /// Returns `true` if the error kind is `DeregisterInstanceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, DeregisterInstanceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for DeregisterInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterInstanceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            DeregisterInstanceErrorKind::InstanceNotFound(_inner) => Some(_inner),
            DeregisterInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            DeregisterInstanceErrorKind::ResourceInUse(_inner) => Some(_inner),
            DeregisterInstanceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            DeregisterInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DiscoverInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DiscoverInstancesError {
    /// Kind of error that occurred.
    pub kind: DiscoverInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DiscoverInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DiscoverInstancesErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The operation can't be completed because you've reached the quota for the number of requests. For more
    /// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html">Cloud Map API request throttling
    /// quota</a> in the <i>Cloud Map Developer Guide</i>.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DiscoverInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DiscoverInstancesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DiscoverInstancesErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            DiscoverInstancesErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            DiscoverInstancesErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            DiscoverInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DiscoverInstancesError {
    fn code(&self) -> Option<&str> {
        DiscoverInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DiscoverInstancesError {
    /// Creates a new `DiscoverInstancesError`.
    pub fn new(kind: DiscoverInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DiscoverInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DiscoverInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DiscoverInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DiscoverInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DiscoverInstancesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DiscoverInstancesErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DiscoverInstancesErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(&self.kind, DiscoverInstancesErrorKind::NamespaceNotFound(_))
    }
    /// Returns `true` if the error kind is `DiscoverInstancesErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DiscoverInstancesErrorKind::RequestLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `DiscoverInstancesErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, DiscoverInstancesErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for DiscoverInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DiscoverInstancesErrorKind::InvalidInput(_inner) => Some(_inner),
            DiscoverInstancesErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            DiscoverInstancesErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            DiscoverInstancesErrorKind::ServiceNotFound(_inner) => Some(_inner),
            DiscoverInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceError {
    /// Kind of error that occurred.
    pub kind: GetInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceErrorKind {
    /// <p>No instance exists with the specified ID, or the instance was recently registered, and information about the
    /// instance hasn't propagated yet.</p>
    InstanceNotFound(crate::error::InstanceNotFound),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceErrorKind::InstanceNotFound(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceError {
    fn code(&self) -> Option<&str> {
        GetInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceError {
    /// Creates a new `GetInstanceError`.
    pub fn new(kind: GetInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::InstanceNotFound`.
    pub fn is_instance_not_found(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::InstanceNotFound(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for GetInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceErrorKind::InstanceNotFound(_inner) => Some(_inner),
            GetInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            GetInstanceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            GetInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstancesHealthStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstancesHealthStatusError {
    /// Kind of error that occurred.
    pub kind: GetInstancesHealthStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstancesHealthStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstancesHealthStatusErrorKind {
    /// <p>No instance exists with the specified ID, or the instance was recently registered, and information about the
    /// instance hasn't propagated yet.</p>
    InstanceNotFound(crate::error::InstanceNotFound),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstancesHealthStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstancesHealthStatusErrorKind::InstanceNotFound(_inner) => _inner.fmt(f),
            GetInstancesHealthStatusErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetInstancesHealthStatusErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            GetInstancesHealthStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstancesHealthStatusError {
    fn code(&self) -> Option<&str> {
        GetInstancesHealthStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstancesHealthStatusError {
    /// Creates a new `GetInstancesHealthStatusError`.
    pub fn new(kind: GetInstancesHealthStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstancesHealthStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstancesHealthStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstancesHealthStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstancesHealthStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstancesHealthStatusErrorKind::InstanceNotFound`.
    pub fn is_instance_not_found(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesHealthStatusErrorKind::InstanceNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancesHealthStatusErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesHealthStatusErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancesHealthStatusErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesHealthStatusErrorKind::ServiceNotFound(_)
        )
    }
}
impl std::error::Error for GetInstancesHealthStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstancesHealthStatusErrorKind::InstanceNotFound(_inner) => Some(_inner),
            GetInstancesHealthStatusErrorKind::InvalidInput(_inner) => Some(_inner),
            GetInstancesHealthStatusErrorKind::ServiceNotFound(_inner) => Some(_inner),
            GetInstancesHealthStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNamespaceError {
    /// Kind of error that occurred.
    pub kind: GetNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNamespaceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetNamespaceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            GetNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNamespaceError {
    fn code(&self) -> Option<&str> {
        GetNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNamespaceError {
    /// Creates a new `GetNamespaceError`.
    pub fn new(kind: GetNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetNamespaceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetNamespaceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(&self.kind, GetNamespaceErrorKind::NamespaceNotFound(_))
    }
}
impl std::error::Error for GetNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            GetNamespaceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            GetNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOperationError {
    /// Kind of error that occurred.
    pub kind: GetOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOperationErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No operation exists with the specified ID.</p>
    OperationNotFound(crate::error::OperationNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOperationErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetOperationErrorKind::OperationNotFound(_inner) => _inner.fmt(f),
            GetOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOperationError {
    fn code(&self) -> Option<&str> {
        GetOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOperationError {
    /// Creates a new `GetOperationError`.
    pub fn new(kind: GetOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::OperationNotFound`.
    pub fn is_operation_not_found(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::OperationNotFound(_))
    }
}
impl std::error::Error for GetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOperationErrorKind::InvalidInput(_inner) => Some(_inner),
            GetOperationErrorKind::OperationNotFound(_inner) => Some(_inner),
            GetOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceError {
    /// Kind of error that occurred.
    pub kind: GetServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            GetServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceError {
    fn code(&self) -> Option<&str> {
        GetServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceError {
    /// Creates a new `GetServiceError`.
    pub fn new(kind: GetServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for GetServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceErrorKind::InvalidInput(_inner) => Some(_inner),
            GetServiceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            GetServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstancesError {
    /// Kind of error that occurred.
    pub kind: ListInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstancesErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstancesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstancesError {
    fn code(&self) -> Option<&str> {
        ListInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstancesError {
    /// Creates a new `ListInstancesError`.
    pub fn new(kind: ListInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListInstancesErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, ListInstancesErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for ListInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstancesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListInstancesErrorKind::ServiceNotFound(_inner) => Some(_inner),
            ListInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNamespacesError {
    /// Kind of error that occurred.
    pub kind: ListNamespacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNamespacesErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNamespacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNamespacesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNamespacesError {
    fn code(&self) -> Option<&str> {
        ListNamespacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNamespacesError {
    /// Creates a new `ListNamespacesError`.
    pub fn new(kind: ListNamespacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNamespacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNamespacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNamespacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNamespacesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListNamespacesErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListNamespacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNamespacesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListNamespacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOperationsError {
    /// Kind of error that occurred.
    pub kind: ListOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOperationsErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOperationsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOperationsError {
    fn code(&self) -> Option<&str> {
        ListOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOperationsError {
    /// Creates a new `ListOperationsError`.
    pub fn new(kind: ListOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOperationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOperationsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListOperationsErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOperationsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The operation can't be completed because the resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterInstanceError {
    /// Kind of error that occurred.
    pub kind: RegisterInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterInstanceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
    ResourceLimitExceeded(crate::error::ResourceLimitExceeded),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterInstanceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            RegisterInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            RegisterInstanceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            RegisterInstanceErrorKind::ResourceLimitExceeded(_inner) => _inner.fmt(f),
            RegisterInstanceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            RegisterInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterInstanceError {
    fn code(&self) -> Option<&str> {
        RegisterInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterInstanceError {
    /// Creates a new `RegisterInstanceError`.
    pub fn new(kind: RegisterInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterInstanceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, RegisterInstanceErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `RegisterInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, RegisterInstanceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `RegisterInstanceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, RegisterInstanceErrorKind::ResourceInUse(_))
    }
    /// Returns `true` if the error kind is `RegisterInstanceErrorKind::ResourceLimitExceeded`.
    pub fn is_resource_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            RegisterInstanceErrorKind::ResourceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterInstanceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, RegisterInstanceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for RegisterInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterInstanceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            RegisterInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            RegisterInstanceErrorKind::ResourceInUse(_inner) => Some(_inner),
            RegisterInstanceErrorKind::ResourceLimitExceeded(_inner) => Some(_inner),
            RegisterInstanceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            RegisterInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The operation can't be completed because the resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
    /// is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidInput(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The operation can't be completed because the resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidInput(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHttpNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHttpNamespaceError {
    /// Kind of error that occurred.
    pub kind: UpdateHttpNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHttpNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHttpNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHttpNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHttpNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdateHttpNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateHttpNamespaceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            UpdateHttpNamespaceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            UpdateHttpNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHttpNamespaceError {
    fn code(&self) -> Option<&str> {
        UpdateHttpNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHttpNamespaceError {
    /// Creates a new `UpdateHttpNamespaceError`.
    pub fn new(kind: UpdateHttpNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHttpNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHttpNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHttpNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHttpNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateHttpNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHttpNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHttpNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UpdateHttpNamespaceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UpdateHttpNamespaceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHttpNamespaceErrorKind::NamespaceNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHttpNamespaceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, UpdateHttpNamespaceErrorKind::ResourceInUse(_))
    }
}
impl std::error::Error for UpdateHttpNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHttpNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdateHttpNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateHttpNamespaceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            UpdateHttpNamespaceErrorKind::ResourceInUse(_inner) => Some(_inner),
            UpdateHttpNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInstanceCustomHealthStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInstanceCustomHealthStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateInstanceCustomHealthStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInstanceCustomHealthStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInstanceCustomHealthStatusErrorKind {
    /// <p>The health check for the instance that's specified by <code>ServiceId</code> and <code>InstanceId</code> isn't a
    /// custom health check. </p>
    CustomHealthNotFound(crate::error::CustomHealthNotFound),
    /// <p>No instance exists with the specified ID, or the instance was recently registered, and information about the
    /// instance hasn't propagated yet.</p>
    InstanceNotFound(crate::error::InstanceNotFound),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInstanceCustomHealthStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInstanceCustomHealthStatusErrorKind::CustomHealthNotFound(_inner) => {
                _inner.fmt(f)
            }
            UpdateInstanceCustomHealthStatusErrorKind::InstanceNotFound(_inner) => _inner.fmt(f),
            UpdateInstanceCustomHealthStatusErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateInstanceCustomHealthStatusErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            UpdateInstanceCustomHealthStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInstanceCustomHealthStatusError {
    fn code(&self) -> Option<&str> {
        UpdateInstanceCustomHealthStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInstanceCustomHealthStatusError {
    /// Creates a new `UpdateInstanceCustomHealthStatusError`.
    pub fn new(
        kind: UpdateInstanceCustomHealthStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInstanceCustomHealthStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInstanceCustomHealthStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInstanceCustomHealthStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInstanceCustomHealthStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInstanceCustomHealthStatusErrorKind::CustomHealthNotFound`.
    pub fn is_custom_health_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceCustomHealthStatusErrorKind::CustomHealthNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceCustomHealthStatusErrorKind::InstanceNotFound`.
    pub fn is_instance_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceCustomHealthStatusErrorKind::InstanceNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceCustomHealthStatusErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceCustomHealthStatusErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceCustomHealthStatusErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceCustomHealthStatusErrorKind::ServiceNotFound(_)
        )
    }
}
impl std::error::Error for UpdateInstanceCustomHealthStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInstanceCustomHealthStatusErrorKind::CustomHealthNotFound(_inner) => Some(_inner),
            UpdateInstanceCustomHealthStatusErrorKind::InstanceNotFound(_inner) => Some(_inner),
            UpdateInstanceCustomHealthStatusErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateInstanceCustomHealthStatusErrorKind::ServiceNotFound(_inner) => Some(_inner),
            UpdateInstanceCustomHealthStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePrivateDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePrivateDnsNamespaceError {
    /// Kind of error that occurred.
    pub kind: UpdatePrivateDnsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePrivateDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePrivateDnsNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePrivateDnsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePrivateDnsNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdatePrivateDnsNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdatePrivateDnsNamespaceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            UpdatePrivateDnsNamespaceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            UpdatePrivateDnsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePrivateDnsNamespaceError {
    fn code(&self) -> Option<&str> {
        UpdatePrivateDnsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePrivateDnsNamespaceError {
    /// Creates a new `UpdatePrivateDnsNamespaceError`.
    pub fn new(kind: UpdatePrivateDnsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePrivateDnsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePrivateDnsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePrivateDnsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePrivateDnsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePrivateDnsNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrivateDnsNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrivateDnsNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrivateDnsNamespaceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrivateDnsNamespaceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrivateDnsNamespaceErrorKind::NamespaceNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrivateDnsNamespaceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrivateDnsNamespaceErrorKind::ResourceInUse(_)
        )
    }
}
impl std::error::Error for UpdatePrivateDnsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePrivateDnsNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdatePrivateDnsNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdatePrivateDnsNamespaceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            UpdatePrivateDnsNamespaceErrorKind::ResourceInUse(_inner) => Some(_inner),
            UpdatePrivateDnsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePublicDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePublicDnsNamespaceError {
    /// Kind of error that occurred.
    pub kind: UpdatePublicDnsNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePublicDnsNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePublicDnsNamespaceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No namespace exists with the specified ID.</p>
    NamespaceNotFound(crate::error::NamespaceNotFound),
    /// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
    /// service that contains any instances.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePublicDnsNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePublicDnsNamespaceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdatePublicDnsNamespaceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdatePublicDnsNamespaceErrorKind::NamespaceNotFound(_inner) => _inner.fmt(f),
            UpdatePublicDnsNamespaceErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            UpdatePublicDnsNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePublicDnsNamespaceError {
    fn code(&self) -> Option<&str> {
        UpdatePublicDnsNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePublicDnsNamespaceError {
    /// Creates a new `UpdatePublicDnsNamespaceError`.
    pub fn new(kind: UpdatePublicDnsNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePublicDnsNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePublicDnsNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePublicDnsNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePublicDnsNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePublicDnsNamespaceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicDnsNamespaceErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublicDnsNamespaceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicDnsNamespaceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublicDnsNamespaceErrorKind::NamespaceNotFound`.
    pub fn is_namespace_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicDnsNamespaceErrorKind::NamespaceNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublicDnsNamespaceErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicDnsNamespaceErrorKind::ResourceInUse(_)
        )
    }
}
impl std::error::Error for UpdatePublicDnsNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePublicDnsNamespaceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdatePublicDnsNamespaceErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdatePublicDnsNamespaceErrorKind::NamespaceNotFound(_inner) => Some(_inner),
            UpdatePublicDnsNamespaceErrorKind::ResourceInUse(_inner) => Some(_inner),
            UpdatePublicDnsNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceErrorKind {
    /// <p>The operation is already in progress.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
    /// be outside the allowed range, or a string value might exceed length constraints.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No service exists with the specified ID.</p>
    ServiceNotFound(crate::error::ServiceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ServiceNotFound(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceError {
    fn code(&self) -> Option<&str> {
        UpdateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceError {
    /// Creates a new `UpdateServiceError`.
    pub fn new(kind: UpdateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ServiceNotFound`.
    pub fn is_service_not_found(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ServiceNotFound(_))
    }
}
impl std::error::Error for UpdateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdateServiceErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateServiceErrorKind::ServiceNotFound(_inner) => Some(_inner),
            UpdateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>No service exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceNotFound")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceNotFound {}
/// See [`ServiceNotFound`](crate::error::ServiceNotFound)
pub mod service_not_found {
    /// A builder for [`ServiceNotFound`](crate::error::ServiceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNotFound`](crate::error::ServiceNotFound)
        pub fn build(self) -> crate::error::ServiceNotFound {
            crate::error::ServiceNotFound {
                message: self.message,
            }
        }
    }
}
impl ServiceNotFound {
    /// Creates a new builder-style object to manufacture [`ServiceNotFound`](crate::error::ServiceNotFound)
    pub fn builder() -> crate::error::service_not_found::Builder {
        crate::error::service_not_found::Builder::default()
    }
}

/// <p>One or more specified values aren't valid. For example, a required value might be missing, a numeric value might
/// be outside the allowed range, or a string value might exceed length constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInput {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInput")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInput {}
/// See [`InvalidInput`](crate::error::InvalidInput)
pub mod invalid_input {
    /// A builder for [`InvalidInput`](crate::error::InvalidInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInput`](crate::error::InvalidInput)
        pub fn build(self) -> crate::error::InvalidInput {
            crate::error::InvalidInput {
                message: self.message,
            }
        }
    }
}
impl InvalidInput {
    /// Creates a new builder-style object to manufacture [`InvalidInput`](crate::error::InvalidInput)
    pub fn builder() -> crate::error::invalid_input::Builder {
        crate::error::invalid_input::Builder::default()
    }
}

/// <p>The operation is already in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateRequest {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the operation that's already in progress.</p>
    pub duplicate_operation_id: std::option::Option<std::string::String>,
}
impl DuplicateRequest {
    /// <p>The ID of the operation that's already in progress.</p>
    pub fn duplicate_operation_id(&self) -> std::option::Option<&str> {
        self.duplicate_operation_id.as_deref()
    }
}
impl std::fmt::Debug for DuplicateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateRequest");
        formatter.field("message", &self.message);
        formatter.field("duplicate_operation_id", &self.duplicate_operation_id);
        formatter.finish()
    }
}
impl DuplicateRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateRequest")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateRequest {}
/// See [`DuplicateRequest`](crate::error::DuplicateRequest)
pub mod duplicate_request {
    /// A builder for [`DuplicateRequest`](crate::error::DuplicateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) duplicate_operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the operation that's already in progress.</p>
        pub fn duplicate_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.duplicate_operation_id = Some(input.into());
            self
        }
        /// <p>The ID of the operation that's already in progress.</p>
        pub fn set_duplicate_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.duplicate_operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateRequest`](crate::error::DuplicateRequest)
        pub fn build(self) -> crate::error::DuplicateRequest {
            crate::error::DuplicateRequest {
                message: self.message,
                duplicate_operation_id: self.duplicate_operation_id,
            }
        }
    }
}
impl DuplicateRequest {
    /// Creates a new builder-style object to manufacture [`DuplicateRequest`](crate::error::DuplicateRequest)
    pub fn builder() -> crate::error::duplicate_request::Builder {
        crate::error::duplicate_request::Builder::default()
    }
}

/// <p>The specified resource can't be deleted because it contains other resources. For example, you can't delete a
/// service that contains any instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUse")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUse {}
/// See [`ResourceInUse`](crate::error::ResourceInUse)
pub mod resource_in_use {
    /// A builder for [`ResourceInUse`](crate::error::ResourceInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUse`](crate::error::ResourceInUse)
        pub fn build(self) -> crate::error::ResourceInUse {
            crate::error::ResourceInUse {
                message: self.message,
            }
        }
    }
}
impl ResourceInUse {
    /// Creates a new builder-style object to manufacture [`ResourceInUse`](crate::error::ResourceInUse)
    pub fn builder() -> crate::error::resource_in_use::Builder {
        crate::error::resource_in_use::Builder::default()
    }
}

/// <p>No namespace exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NamespaceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NamespaceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NamespaceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NamespaceNotFound")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for NamespaceNotFound {}
/// See [`NamespaceNotFound`](crate::error::NamespaceNotFound)
pub mod namespace_not_found {
    /// A builder for [`NamespaceNotFound`](crate::error::NamespaceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceNotFound`](crate::error::NamespaceNotFound)
        pub fn build(self) -> crate::error::NamespaceNotFound {
            crate::error::NamespaceNotFound {
                message: self.message,
            }
        }
    }
}
impl NamespaceNotFound {
    /// Creates a new builder-style object to manufacture [`NamespaceNotFound`](crate::error::NamespaceNotFound)
    pub fn builder() -> crate::error::namespace_not_found::Builder {
        crate::error::namespace_not_found::Builder::default()
    }
}

/// <p>No instance exists with the specified ID, or the instance was recently registered, and information about the
/// instance hasn't propagated yet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InstanceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InstanceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InstanceNotFound")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InstanceNotFound {}
/// See [`InstanceNotFound`](crate::error::InstanceNotFound)
pub mod instance_not_found {
    /// A builder for [`InstanceNotFound`](crate::error::InstanceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNotFound`](crate::error::InstanceNotFound)
        pub fn build(self) -> crate::error::InstanceNotFound {
            crate::error::InstanceNotFound {
                message: self.message,
            }
        }
    }
}
impl InstanceNotFound {
    /// Creates a new builder-style object to manufacture [`InstanceNotFound`](crate::error::InstanceNotFound)
    pub fn builder() -> crate::error::instance_not_found::Builder {
        crate::error::instance_not_found::Builder::default()
    }
}

/// <p>The health check for the instance that's specified by <code>ServiceId</code> and <code>InstanceId</code> isn't a
/// custom health check. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomHealthNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomHealthNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomHealthNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomHealthNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomHealthNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomHealthNotFound")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomHealthNotFound {}
/// See [`CustomHealthNotFound`](crate::error::CustomHealthNotFound)
pub mod custom_health_not_found {
    /// A builder for [`CustomHealthNotFound`](crate::error::CustomHealthNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomHealthNotFound`](crate::error::CustomHealthNotFound)
        pub fn build(self) -> crate::error::CustomHealthNotFound {
            crate::error::CustomHealthNotFound {
                message: self.message,
            }
        }
    }
}
impl CustomHealthNotFound {
    /// Creates a new builder-style object to manufacture [`CustomHealthNotFound`](crate::error::CustomHealthNotFound)
    pub fn builder() -> crate::error::custom_health_not_found::Builder {
        crate::error::custom_health_not_found::Builder::default()
    }
}

/// <p>The operation can't be completed because the resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The list of tags on the resource is over the quota. The maximum number of tags that can be applied to a resource
/// is 50.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    /// <p>The name of the resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The resource can't be created because you've reached the quota on the number of resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceeded")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceeded {}
/// See [`ResourceLimitExceeded`](crate::error::ResourceLimitExceeded)
pub mod resource_limit_exceeded {
    /// A builder for [`ResourceLimitExceeded`](crate::error::ResourceLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceeded`](crate::error::ResourceLimitExceeded)
        pub fn build(self) -> crate::error::ResourceLimitExceeded {
            crate::error::ResourceLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceeded`](crate::error::ResourceLimitExceeded)
    pub fn builder() -> crate::error::resource_limit_exceeded::Builder {
        crate::error::resource_limit_exceeded::Builder::default()
    }
}

/// <p>No operation exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotFound")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotFound {}
/// See [`OperationNotFound`](crate::error::OperationNotFound)
pub mod operation_not_found {
    /// A builder for [`OperationNotFound`](crate::error::OperationNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotFound`](crate::error::OperationNotFound)
        pub fn build(self) -> crate::error::OperationNotFound {
            crate::error::OperationNotFound {
                message: self.message,
            }
        }
    }
}
impl OperationNotFound {
    /// Creates a new builder-style object to manufacture [`OperationNotFound`](crate::error::OperationNotFound)
    pub fn builder() -> crate::error::operation_not_found::Builder {
        crate::error::operation_not_found::Builder::default()
    }
}

/// <p>The operation can't be completed because you've reached the quota for the number of requests. For more
/// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html">Cloud Map API request throttling
/// quota</a> in the <i>Cloud Map Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestLimitExceeded")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestLimitExceeded {}
/// See [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
pub mod request_limit_exceeded {
    /// A builder for [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
        pub fn build(self) -> crate::error::RequestLimitExceeded {
            crate::error::RequestLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl RequestLimitExceeded {
    /// Creates a new builder-style object to manufacture [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
    pub fn builder() -> crate::error::request_limit_exceeded::Builder {
        crate::error::request_limit_exceeded::Builder::default()
    }
}

/// <p>The service can't be created because a service with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The <code>CreatorRequestId</code> that was used to create the service.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The ID of the existing service.</p>
    pub service_id: std::option::Option<std::string::String>,
}
impl ServiceAlreadyExists {
    /// <p>The <code>CreatorRequestId</code> that was used to create the service.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The ID of the existing service.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
}
impl std::fmt::Debug for ServiceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceAlreadyExists");
        formatter.field("message", &self.message);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("service_id", &self.service_id);
        formatter.finish()
    }
}
impl ServiceAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceAlreadyExists")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceAlreadyExists {}
/// See [`ServiceAlreadyExists`](crate::error::ServiceAlreadyExists)
pub mod service_already_exists {
    /// A builder for [`ServiceAlreadyExists`](crate::error::ServiceAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) service_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The <code>CreatorRequestId</code> that was used to create the service.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>The <code>CreatorRequestId</code> that was used to create the service.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The ID of the existing service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The ID of the existing service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceAlreadyExists`](crate::error::ServiceAlreadyExists)
        pub fn build(self) -> crate::error::ServiceAlreadyExists {
            crate::error::ServiceAlreadyExists {
                message: self.message,
                creator_request_id: self.creator_request_id,
                service_id: self.service_id,
            }
        }
    }
}
impl ServiceAlreadyExists {
    /// Creates a new builder-style object to manufacture [`ServiceAlreadyExists`](crate::error::ServiceAlreadyExists)
    pub fn builder() -> crate::error::service_already_exists::Builder {
        crate::error::service_already_exists::Builder::default()
    }
}

/// <p>The namespace that you're trying to create already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The <code>CreatorRequestId</code> that was used to create the namespace.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The ID of the existing namespace.</p>
    pub namespace_id: std::option::Option<std::string::String>,
}
impl NamespaceAlreadyExists {
    /// <p>The <code>CreatorRequestId</code> that was used to create the namespace.</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The ID of the existing namespace.</p>
    pub fn namespace_id(&self) -> std::option::Option<&str> {
        self.namespace_id.as_deref()
    }
}
impl std::fmt::Debug for NamespaceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceAlreadyExists");
        formatter.field("message", &self.message);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("namespace_id", &self.namespace_id);
        formatter.finish()
    }
}
impl NamespaceAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NamespaceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NamespaceAlreadyExists")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for NamespaceAlreadyExists {}
/// See [`NamespaceAlreadyExists`](crate::error::NamespaceAlreadyExists)
pub mod namespace_already_exists {
    /// A builder for [`NamespaceAlreadyExists`](crate::error::NamespaceAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The <code>CreatorRequestId</code> that was used to create the namespace.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>The <code>CreatorRequestId</code> that was used to create the namespace.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The ID of the existing namespace.</p>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The ID of the existing namespace.</p>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceAlreadyExists`](crate::error::NamespaceAlreadyExists)
        pub fn build(self) -> crate::error::NamespaceAlreadyExists {
            crate::error::NamespaceAlreadyExists {
                message: self.message,
                creator_request_id: self.creator_request_id,
                namespace_id: self.namespace_id,
            }
        }
    }
}
impl NamespaceAlreadyExists {
    /// Creates a new builder-style object to manufacture [`NamespaceAlreadyExists`](crate::error::NamespaceAlreadyExists)
    pub fn builder() -> crate::error::namespace_already_exists::Builder {
        crate::error::namespace_already_exists::Builder::default()
    }
}
