// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdateServiceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
pub mod update_service_output {
    /// A builder for [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
        pub fn build(self) -> crate::output::UpdateServiceOutput {
            crate::output::UpdateServiceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateServiceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    pub fn builder() -> crate::output::update_service_output::Builder {
        crate::output::update_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePublicDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdatePublicDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdatePublicDnsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePublicDnsNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdatePublicDnsNamespaceOutput`](crate::output::UpdatePublicDnsNamespaceOutput)
pub mod update_public_dns_namespace_output {
    /// A builder for [`UpdatePublicDnsNamespaceOutput`](crate::output::UpdatePublicDnsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePublicDnsNamespaceOutput`](crate::output::UpdatePublicDnsNamespaceOutput)
        pub fn build(self) -> crate::output::UpdatePublicDnsNamespaceOutput {
            crate::output::UpdatePublicDnsNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdatePublicDnsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePublicDnsNamespaceOutput`](crate::output::UpdatePublicDnsNamespaceOutput)
    pub fn builder() -> crate::output::update_public_dns_namespace_output::Builder {
        crate::output::update_public_dns_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePrivateDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdatePrivateDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdatePrivateDnsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePrivateDnsNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdatePrivateDnsNamespaceOutput`](crate::output::UpdatePrivateDnsNamespaceOutput)
pub mod update_private_dns_namespace_output {
    /// A builder for [`UpdatePrivateDnsNamespaceOutput`](crate::output::UpdatePrivateDnsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePrivateDnsNamespaceOutput`](crate::output::UpdatePrivateDnsNamespaceOutput)
        pub fn build(self) -> crate::output::UpdatePrivateDnsNamespaceOutput {
            crate::output::UpdatePrivateDnsNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdatePrivateDnsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePrivateDnsNamespaceOutput`](crate::output::UpdatePrivateDnsNamespaceOutput)
    pub fn builder() -> crate::output::update_private_dns_namespace_output::Builder {
        crate::output::update_private_dns_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstanceCustomHealthStatusOutput {}
impl std::fmt::Debug for UpdateInstanceCustomHealthStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstanceCustomHealthStatusOutput");
        formatter.finish()
    }
}
/// See [`UpdateInstanceCustomHealthStatusOutput`](crate::output::UpdateInstanceCustomHealthStatusOutput)
pub mod update_instance_custom_health_status_output {
    /// A builder for [`UpdateInstanceCustomHealthStatusOutput`](crate::output::UpdateInstanceCustomHealthStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateInstanceCustomHealthStatusOutput`](crate::output::UpdateInstanceCustomHealthStatusOutput)
        pub fn build(self) -> crate::output::UpdateInstanceCustomHealthStatusOutput {
            crate::output::UpdateInstanceCustomHealthStatusOutput {}
        }
    }
}
impl UpdateInstanceCustomHealthStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceCustomHealthStatusOutput`](crate::output::UpdateInstanceCustomHealthStatusOutput)
    pub fn builder() -> crate::output::update_instance_custom_health_status_output::Builder {
        crate::output::update_instance_custom_health_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHttpNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdateHttpNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateHttpNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHttpNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateHttpNamespaceOutput`](crate::output::UpdateHttpNamespaceOutput)
pub mod update_http_namespace_output {
    /// A builder for [`UpdateHttpNamespaceOutput`](crate::output::UpdateHttpNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHttpNamespaceOutput`](crate::output::UpdateHttpNamespaceOutput)
        pub fn build(self) -> crate::output::UpdateHttpNamespaceOutput {
            crate::output::UpdateHttpNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateHttpNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateHttpNamespaceOutput`](crate::output::UpdateHttpNamespaceOutput)
    pub fn builder() -> crate::output::update_http_namespace_output::Builder {
        crate::output::update_http_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterInstanceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl RegisterInstanceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterInstanceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`RegisterInstanceOutput`](crate::output::RegisterInstanceOutput)
pub mod register_instance_output {
    /// A builder for [`RegisterInstanceOutput`](crate::output::RegisterInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterInstanceOutput`](crate::output::RegisterInstanceOutput)
        pub fn build(self) -> crate::output::RegisterInstanceOutput {
            crate::output::RegisterInstanceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl RegisterInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RegisterInstanceOutput`](crate::output::RegisterInstanceOutput)
    pub fn builder() -> crate::output::register_instance_output::Builder {
        crate::output::register_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags that are assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are assigned to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesOutput {
    /// <p>An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
    /// criteria.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
    /// possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListServicesOutput {
    /// <p>An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
    /// criteria.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::ServiceSummary]> {
        self.services.as_deref()
    }
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
    /// possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesOutput");
        formatter.field("services", &self.services);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListServicesOutput`](crate::output::ListServicesOutput)
pub mod list_services_output {
    /// A builder for [`ListServicesOutput`](crate::output::ListServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
        /// criteria.</p>
        pub fn services(mut self, input: impl Into<crate::model::ServiceSummary>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
        /// criteria.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
        /// possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
        /// possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesOutput`](crate::output::ListServicesOutput)
        pub fn build(self) -> crate::output::ListServicesOutput {
            crate::output::ListServicesOutput {
                services: self.services,
                next_token: self.next_token,
            }
        }
    }
}
impl ListServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListServicesOutput`](crate::output::ListServicesOutput)
    pub fn builder() -> crate::output::list_services_output::Builder {
        crate::output::list_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationsOutput {
    /// <p>Summary information about the operations that match the specified criteria.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
    /// possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOperationsOutput {
    /// <p>Summary information about the operations that match the specified criteria.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::OperationSummary]> {
        self.operations.as_deref()
    }
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
    /// possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOperationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationsOutput");
        formatter.field("operations", &self.operations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOperationsOutput`](crate::output::ListOperationsOutput)
pub mod list_operations_output {
    /// A builder for [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>Summary information about the operations that match the specified criteria.</p>
        pub fn operations(mut self, input: impl Into<crate::model::OperationSummary>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>Summary information about the operations that match the specified criteria.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
        /// possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
        /// possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOperationsOutput`](crate::output::ListOperationsOutput)
        pub fn build(self) -> crate::output::ListOperationsOutput {
            crate::output::ListOperationsOutput {
                operations: self.operations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOperationsOutput {
    /// Creates a new builder-style object to manufacture [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    pub fn builder() -> crate::output::list_operations_output::Builder {
        crate::output::list_operations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNamespacesOutput {
    /// <p>An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
    /// filter criteria.</p>
    pub namespaces: std::option::Option<std::vec::Vec<crate::model::NamespaceSummary>>,
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
    /// possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNamespacesOutput {
    /// <p>An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
    /// filter criteria.</p>
    pub fn namespaces(&self) -> std::option::Option<&[crate::model::NamespaceSummary]> {
        self.namespaces.as_deref()
    }
    /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
    /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
    /// request.</p>
    /// <note>
    /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
    /// possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that
    /// subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNamespacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNamespacesOutput");
        formatter.field("namespaces", &self.namespaces);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
pub mod list_namespaces_output {
    /// A builder for [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespaces: std::option::Option<std::vec::Vec<crate::model::NamespaceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `namespaces`.
        ///
        /// To override the contents of this collection use [`set_namespaces`](Self::set_namespaces).
        ///
        /// <p>An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
        /// filter criteria.</p>
        pub fn namespaces(mut self, input: impl Into<crate::model::NamespaceSummary>) -> Self {
            let mut v = self.namespaces.unwrap_or_default();
            v.push(input.into());
            self.namespaces = Some(v);
            self
        }
        /// <p>An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
        /// filter criteria.</p>
        pub fn set_namespaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NamespaceSummary>>,
        ) -> Self {
            self.namespaces = input;
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
        /// possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
        /// next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
        /// request.</p>
        /// <note>
        /// <p>Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
        /// possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but that
        /// subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
        pub fn build(self) -> crate::output::ListNamespacesOutput {
            crate::output::ListNamespacesOutput {
                namespaces: self.namespaces,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNamespacesOutput {
    /// Creates a new builder-style object to manufacture [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
    pub fn builder() -> crate::output::list_namespaces_output::Builder {
        crate::output::list_namespaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstancesOutput {
    /// <p>Summary information about the instances that are associated with the specified service.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
    /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
    /// <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
    /// from the previous response in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstancesOutput {
    /// <p>Summary information about the instances that are associated with the specified service.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::InstanceSummary]> {
        self.instances.as_deref()
    }
    /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
    /// <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
    /// from the previous response in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstancesOutput");
        formatter.field("instances", &self.instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInstancesOutput`](crate::output::ListInstancesOutput)
pub mod list_instances_output {
    /// A builder for [`ListInstancesOutput`](crate::output::ListInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>Summary information about the instances that are associated with the specified service.</p>
        pub fn instances(mut self, input: impl Into<crate::model::InstanceSummary>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>Summary information about the instances that are associated with the specified service.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
        /// <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
        /// from the previous response in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
        /// <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
        /// from the previous response in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstancesOutput`](crate::output::ListInstancesOutput)
        pub fn build(self) -> crate::output::ListInstancesOutput {
            crate::output::ListInstancesOutput {
                instances: self.instances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListInstancesOutput`](crate::output::ListInstancesOutput)
    pub fn builder() -> crate::output::list_instances_output::Builder {
        crate::output::list_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceOutput {
    /// <p>A complex type that contains information about the service.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl GetServiceOutput {
    /// <p>A complex type that contains information about the service.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for GetServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`GetServiceOutput`](crate::output::GetServiceOutput)
pub mod get_service_output {
    /// A builder for [`GetServiceOutput`](crate::output::GetServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the service.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A complex type that contains information about the service.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceOutput`](crate::output::GetServiceOutput)
        pub fn build(self) -> crate::output::GetServiceOutput {
            crate::output::GetServiceOutput {
                service: self.service,
            }
        }
    }
}
impl GetServiceOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceOutput`](crate::output::GetServiceOutput)
    pub fn builder() -> crate::output::get_service_output::Builder {
        crate::output::get_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOperationOutput {
    /// <p>A complex type that contains information about the operation.</p>
    pub operation: std::option::Option<crate::model::Operation>,
}
impl GetOperationOutput {
    /// <p>A complex type that contains information about the operation.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::Operation> {
        self.operation.as_ref()
    }
}
impl std::fmt::Debug for GetOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOperationOutput");
        formatter.field("operation", &self.operation);
        formatter.finish()
    }
}
/// See [`GetOperationOutput`](crate::output::GetOperationOutput)
pub mod get_operation_output {
    /// A builder for [`GetOperationOutput`](crate::output::GetOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation: std::option::Option<crate::model::Operation>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the operation.</p>
        pub fn operation(mut self, input: crate::model::Operation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>A complex type that contains information about the operation.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::Operation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationOutput`](crate::output::GetOperationOutput)
        pub fn build(self) -> crate::output::GetOperationOutput {
            crate::output::GetOperationOutput {
                operation: self.operation,
            }
        }
    }
}
impl GetOperationOutput {
    /// Creates a new builder-style object to manufacture [`GetOperationOutput`](crate::output::GetOperationOutput)
    pub fn builder() -> crate::output::get_operation_output::Builder {
        crate::output::get_operation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNamespaceOutput {
    /// <p>A complex type that contains information about the specified namespace.</p>
    pub namespace: std::option::Option<crate::model::Namespace>,
}
impl GetNamespaceOutput {
    /// <p>A complex type that contains information about the specified namespace.</p>
    pub fn namespace(&self) -> std::option::Option<&crate::model::Namespace> {
        self.namespace.as_ref()
    }
}
impl std::fmt::Debug for GetNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNamespaceOutput");
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`GetNamespaceOutput`](crate::output::GetNamespaceOutput)
pub mod get_namespace_output {
    /// A builder for [`GetNamespaceOutput`](crate::output::GetNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<crate::model::Namespace>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the specified namespace.</p>
        pub fn namespace(mut self, input: crate::model::Namespace) -> Self {
            self.namespace = Some(input);
            self
        }
        /// <p>A complex type that contains information about the specified namespace.</p>
        pub fn set_namespace(
            mut self,
            input: std::option::Option<crate::model::Namespace>,
        ) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNamespaceOutput`](crate::output::GetNamespaceOutput)
        pub fn build(self) -> crate::output::GetNamespaceOutput {
            crate::output::GetNamespaceOutput {
                namespace: self.namespace,
            }
        }
    }
}
impl GetNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`GetNamespaceOutput`](crate::output::GetNamespaceOutput)
    pub fn builder() -> crate::output::get_namespace_output::Builder {
        crate::output::get_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstancesHealthStatusOutput {
    /// <p>A complex type that contains the IDs and the health status of the instances that you specified in the
    /// <code>GetInstancesHealthStatus</code> request.</p>
    pub status: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::HealthStatus>,
    >,
    /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
    /// <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
    /// <code>NextToken</code> from the previous response in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInstancesHealthStatusOutput {
    /// <p>A complex type that contains the IDs and the health status of the instances that you specified in the
    /// <code>GetInstancesHealthStatus</code> request.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::HealthStatus>,
    > {
        self.status.as_ref()
    }
    /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
    /// <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
    /// <code>NextToken</code> from the previous response in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInstancesHealthStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstancesHealthStatusOutput");
        formatter.field("status", &self.status);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInstancesHealthStatusOutput`](crate::output::GetInstancesHealthStatusOutput)
pub mod get_instances_health_status_output {
    /// A builder for [`GetInstancesHealthStatusOutput`](crate::output::GetInstancesHealthStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::HealthStatus>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>A complex type that contains the IDs and the health status of the instances that you specified in the
        /// <code>GetInstancesHealthStatus</code> request.</p>
        pub fn status(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::HealthStatus>,
        ) -> Self {
            let mut hash_map = self.status.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.status = Some(hash_map);
            self
        }
        /// <p>A complex type that contains the IDs and the health status of the instances that you specified in the
        /// <code>GetInstancesHealthStatus</code> request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::HealthStatus>,
            >,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
        /// <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
        /// <code>NextToken</code> from the previous response in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
        /// <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
        /// <code>NextToken</code> from the previous response in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstancesHealthStatusOutput`](crate::output::GetInstancesHealthStatusOutput)
        pub fn build(self) -> crate::output::GetInstancesHealthStatusOutput {
            crate::output::GetInstancesHealthStatusOutput {
                status: self.status,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInstancesHealthStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetInstancesHealthStatusOutput`](crate::output::GetInstancesHealthStatusOutput)
    pub fn builder() -> crate::output::get_instances_health_status_output::Builder {
        crate::output::get_instances_health_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstanceOutput {
    /// <p>A complex type that contains information about a specified instance.</p>
    pub instance: std::option::Option<crate::model::Instance>,
}
impl GetInstanceOutput {
    /// <p>A complex type that contains information about a specified instance.</p>
    pub fn instance(&self) -> std::option::Option<&crate::model::Instance> {
        self.instance.as_ref()
    }
}
impl std::fmt::Debug for GetInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstanceOutput");
        formatter.field("instance", &self.instance);
        formatter.finish()
    }
}
/// See [`GetInstanceOutput`](crate::output::GetInstanceOutput)
pub mod get_instance_output {
    /// A builder for [`GetInstanceOutput`](crate::output::GetInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance: std::option::Option<crate::model::Instance>,
    }
    impl Builder {
        /// <p>A complex type that contains information about a specified instance.</p>
        pub fn instance(mut self, input: crate::model::Instance) -> Self {
            self.instance = Some(input);
            self
        }
        /// <p>A complex type that contains information about a specified instance.</p>
        pub fn set_instance(mut self, input: std::option::Option<crate::model::Instance>) -> Self {
            self.instance = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceOutput`](crate::output::GetInstanceOutput)
        pub fn build(self) -> crate::output::GetInstanceOutput {
            crate::output::GetInstanceOutput {
                instance: self.instance,
            }
        }
    }
}
impl GetInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetInstanceOutput`](crate::output::GetInstanceOutput)
    pub fn builder() -> crate::output::get_instance_output::Builder {
        crate::output::get_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiscoverInstancesOutput {
    /// <p>A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::HttpInstanceSummary>>,
}
impl DiscoverInstancesOutput {
    /// <p>A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::HttpInstanceSummary]> {
        self.instances.as_deref()
    }
}
impl std::fmt::Debug for DiscoverInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiscoverInstancesOutput");
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}
/// See [`DiscoverInstancesOutput`](crate::output::DiscoverInstancesOutput)
pub mod discover_instances_output {
    /// A builder for [`DiscoverInstancesOutput`](crate::output::DiscoverInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::HttpInstanceSummary>>,
    }
    impl Builder {
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.</p>
        pub fn instances(mut self, input: impl Into<crate::model::HttpInstanceSummary>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpInstanceSummary>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DiscoverInstancesOutput`](crate::output::DiscoverInstancesOutput)
        pub fn build(self) -> crate::output::DiscoverInstancesOutput {
            crate::output::DiscoverInstancesOutput {
                instances: self.instances,
            }
        }
    }
}
impl DiscoverInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DiscoverInstancesOutput`](crate::output::DiscoverInstancesOutput)
    pub fn builder() -> crate::output::discover_instances_output::Builder {
        crate::output::discover_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterInstanceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl DeregisterInstanceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterInstanceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`DeregisterInstanceOutput`](crate::output::DeregisterInstanceOutput)
pub mod deregister_instance_output {
    /// A builder for [`DeregisterInstanceOutput`](crate::output::DeregisterInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterInstanceOutput`](crate::output::DeregisterInstanceOutput)
        pub fn build(self) -> crate::output::DeregisterInstanceOutput {
            crate::output::DeregisterInstanceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl DeregisterInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterInstanceOutput`](crate::output::DeregisterInstanceOutput)
    pub fn builder() -> crate::output::deregister_instance_output::Builder {
        crate::output::deregister_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceOutput {}
impl std::fmt::Debug for DeleteServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceOutput");
        formatter.finish()
    }
}
/// See [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
pub mod delete_service_output {
    /// A builder for [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
        pub fn build(self) -> crate::output::DeleteServiceOutput {
            crate::output::DeleteServiceOutput {}
        }
    }
}
impl DeleteServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    pub fn builder() -> crate::output::delete_service_output::Builder {
        crate::output::delete_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl DeleteNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
pub mod delete_namespace_output {
    /// A builder for [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
        pub fn build(self) -> crate::output::DeleteNamespaceOutput {
            crate::output::DeleteNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl DeleteNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    pub fn builder() -> crate::output::delete_namespace_output::Builder {
        crate::output::delete_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceOutput {
    /// <p>A complex type that contains information about the new service.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl CreateServiceOutput {
    /// <p>A complex type that contains information about the new service.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`CreateServiceOutput`](crate::output::CreateServiceOutput)
pub mod create_service_output {
    /// A builder for [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the new service.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A complex type that contains information about the new service.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceOutput`](crate::output::CreateServiceOutput)
        pub fn build(self) -> crate::output::CreateServiceOutput {
            crate::output::CreateServiceOutput {
                service: self.service,
            }
        }
    }
}
impl CreateServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    pub fn builder() -> crate::output::create_service_output::Builder {
        crate::output::create_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublicDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully. To get the status of the
    /// operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl CreatePublicDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully. To get the status of the
    /// operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePublicDnsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublicDnsNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`CreatePublicDnsNamespaceOutput`](crate::output::CreatePublicDnsNamespaceOutput)
pub mod create_public_dns_namespace_output {
    /// A builder for [`CreatePublicDnsNamespaceOutput`](crate::output::CreatePublicDnsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully. To get the status of the
        /// operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully. To get the status of the
        /// operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicDnsNamespaceOutput`](crate::output::CreatePublicDnsNamespaceOutput)
        pub fn build(self) -> crate::output::CreatePublicDnsNamespaceOutput {
            crate::output::CreatePublicDnsNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl CreatePublicDnsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`CreatePublicDnsNamespaceOutput`](crate::output::CreatePublicDnsNamespaceOutput)
    pub fn builder() -> crate::output::create_public_dns_namespace_output::Builder {
        crate::output::create_public_dns_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePrivateDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl CreatePrivateDnsNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePrivateDnsNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePrivateDnsNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`CreatePrivateDnsNamespaceOutput`](crate::output::CreatePrivateDnsNamespaceOutput)
pub mod create_private_dns_namespace_output {
    /// A builder for [`CreatePrivateDnsNamespaceOutput`](crate::output::CreatePrivateDnsNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePrivateDnsNamespaceOutput`](crate::output::CreatePrivateDnsNamespaceOutput)
        pub fn build(self) -> crate::output::CreatePrivateDnsNamespaceOutput {
            crate::output::CreatePrivateDnsNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl CreatePrivateDnsNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`CreatePrivateDnsNamespaceOutput`](crate::output::CreatePrivateDnsNamespaceOutput)
    pub fn builder() -> crate::output::create_private_dns_namespace_output::Builder {
        crate::output::create_private_dns_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHttpNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl CreateHttpNamespaceOutput {
    /// <p>A value that you can use to determine whether the request completed successfully.
    /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for CreateHttpNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHttpNamespaceOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`CreateHttpNamespaceOutput`](crate::output::CreateHttpNamespaceOutput)
pub mod create_http_namespace_output {
    /// A builder for [`CreateHttpNamespaceOutput`](crate::output::CreateHttpNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A value that you can use to determine whether the request completed successfully.
        /// To get the status of the operation, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html">GetOperation</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHttpNamespaceOutput`](crate::output::CreateHttpNamespaceOutput)
        pub fn build(self) -> crate::output::CreateHttpNamespaceOutput {
            crate::output::CreateHttpNamespaceOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl CreateHttpNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateHttpNamespaceOutput`](crate::output::CreateHttpNamespaceOutput)
    pub fn builder() -> crate::output::create_http_namespace_output::Builder {
        crate::output::create_http_namespace_output::Builder::default()
    }
}
