// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A complex type that contains changes to an existing service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceChange {
    /// <p>A description for the service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
    pub dns_config: std::option::Option<crate::model::DnsConfigChange>,
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
    /// settings for a health check, Cloud Map associates the health check with the records that you specify in
    /// <code>DnsConfig</code>.</p>
    pub health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
}
impl ServiceChange {
    /// <p>A description for the service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
    pub fn dns_config(&self) -> std::option::Option<&crate::model::DnsConfigChange> {
        self.dns_config.as_ref()
    }
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
    /// settings for a health check, Cloud Map associates the health check with the records that you specify in
    /// <code>DnsConfig</code>.</p>
    pub fn health_check_config(&self) -> std::option::Option<&crate::model::HealthCheckConfig> {
        self.health_check_config.as_ref()
    }
}
impl std::fmt::Debug for ServiceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceChange");
        formatter.field("description", &self.description);
        formatter.field("dns_config", &self.dns_config);
        formatter.field("health_check_config", &self.health_check_config);
        formatter.finish()
    }
}
/// See [`ServiceChange`](crate::model::ServiceChange)
pub mod service_change {
    /// A builder for [`ServiceChange`](crate::model::ServiceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) dns_config: std::option::Option<crate::model::DnsConfigChange>,
        pub(crate) health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
    }
    impl Builder {
        /// <p>A description for the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
        pub fn dns_config(mut self, input: crate::model::DnsConfigChange) -> Self {
            self.dns_config = Some(input);
            self
        }
        /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
        pub fn set_dns_config(
            mut self,
            input: std::option::Option<crate::model::DnsConfigChange>,
        ) -> Self {
            self.dns_config = input;
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
        /// settings for a health check, Cloud Map associates the health check with the records that you specify in
        /// <code>DnsConfig</code>.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.health_check_config = Some(input);
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
        /// settings for a health check, Cloud Map associates the health check with the records that you specify in
        /// <code>DnsConfig</code>.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.health_check_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceChange`](crate::model::ServiceChange)
        pub fn build(self) -> crate::model::ServiceChange {
            crate::model::ServiceChange {
                description: self.description,
                dns_config: self.dns_config,
                health_check_config: self.health_check_config,
            }
        }
    }
}
impl ServiceChange {
    /// Creates a new builder-style object to manufacture [`ServiceChange`](crate::model::ServiceChange)
    pub fn builder() -> crate::model::service_change::Builder {
        crate::model::service_change::Builder::default()
    }
}

/// <p>
/// <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
/// health check. If you specify settings for a health check, Cloud Map associates the health check with the records
/// that you specify in <code>DnsConfig</code>.</p>
/// <important>
/// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
/// <code>HealthCheckConfig</code> but not both.</p>
/// </important>
/// <p>Health checks are basic Route 53 health checks that monitor an Amazon Web Services endpoint. For information about
/// pricing for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
/// <p>Note the following about configuring health checks.</p>
/// <dl>
/// <dt>A and AAAA records</dt>
/// <dd>
/// <p>If <code>DnsConfig</code> includes configurations for both <code>A</code> and <code>AAAA</code> records,
/// Cloud Map creates a health check that uses the IPv4 address to check the health of the resource. If the endpoint
/// tthat's specified by the IPv4 address is unhealthy, Route 53 considers both the <code>A</code> and <code>AAAA</code>
/// records to be unhealthy. </p>
/// </dd>
/// <dt>CNAME records</dt>
/// <dd>
/// <p>You can't specify settings for <code>HealthCheckConfig</code> when the <code>DNSConfig</code> includes
/// <code>CNAME</code> for the value of <code>Type</code>. If you do, the <code>CreateService</code> request will
/// fail with an <code>InvalidInput</code> error.</p>
/// </dd>
/// <dt>Request interval</dt>
/// <dd>
/// <p>A Route 53 health checker in each health-checking Amazon Web Services Region sends a health check request to an endpoint every
/// 30 seconds. On average, your endpoint receives a health check request about every two seconds. However, health
/// checkers don't coordinate with one another. Therefore, you might sometimes see several requests in one second
/// that's followed by a few seconds with no health checks at all.</p>
/// </dd>
/// <dt>Health checking regions</dt>
/// <dd>
/// <p>Health checkers perform checks from all Route 53 health-checking Regions. For a list of the current Regions, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a>.</p>
/// </dd>
/// <dt>Alias records</dt>
/// <dd>
/// <p>When you register an instance, if you include the <code>AWS_ALIAS_DNS_NAME</code> attribute, Cloud Map
/// creates a Route 53 alias record. Note the following:</p>
/// <ul>
/// <li>
/// <p>Route 53 automatically sets <code>EvaluateTargetHealth</code> to true for alias records. When
/// <code>EvaluateTargetHealth</code> is true, the alias record inherits the health of the referenced Amazon Web Services
/// resource. such as an ELB load balancer. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth">EvaluateTargetHealth</a>.</p>
/// </li>
/// <li>
/// <p>If you include <code>HealthCheckConfig</code> and then use the service to register an instance that creates
/// an alias record, Route 53 doesn't create the health check.</p>
/// </li>
/// </ul>
/// </dd>
/// <dt>Charges for health checks</dt>
/// <dd>
/// <p>Health checks are basic Route 53 health checks that monitor an Amazon Web Services endpoint. For information about pricing for
/// health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
/// </dd>
/// </dl>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckConfig {
    /// <p>The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
    /// healthy.</p>
    /// <important>
    /// <p>You can't change the value of <code>Type</code> after you create a health check.</p>
    /// </important>
    /// <p>You can create the following types of health checks:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
    /// an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53
    /// submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</p>
    /// <important>
    /// <p>If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TCP</b>: Route 53 tries to establish a TCP connection.</p>
    /// <p>If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
    /// <code>ResourcePath</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether
    /// an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
    pub r#type: std::option::Option<crate::model::HealthCheckType>,
    /// <p>The path that you want Route 53 to request when performing health checks. The path can be any value that your
    /// endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is
    /// <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If you don't
    /// specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.</p>
    /// <p>If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
    /// <code>ResourcePath</code>.</p>
    pub resource_path: std::option::Option<std::string::String>,
    /// <p>The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
    /// status of the endpoint from unhealthy to healthy or the other way around. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53
    /// Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
    pub failure_threshold: std::option::Option<i32>,
}
impl HealthCheckConfig {
    /// <p>The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
    /// healthy.</p>
    /// <important>
    /// <p>You can't change the value of <code>Type</code> after you create a health check.</p>
    /// </important>
    /// <p>You can create the following types of health checks:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
    /// an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53
    /// submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</p>
    /// <important>
    /// <p>If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TCP</b>: Route 53 tries to establish a TCP connection.</p>
    /// <p>If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
    /// <code>ResourcePath</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether
    /// an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HealthCheckType> {
        self.r#type.as_ref()
    }
    /// <p>The path that you want Route 53 to request when performing health checks. The path can be any value that your
    /// endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is
    /// <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If you don't
    /// specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.</p>
    /// <p>If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
    /// <code>ResourcePath</code>.</p>
    pub fn resource_path(&self) -> std::option::Option<&str> {
        self.resource_path.as_deref()
    }
    /// <p>The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
    /// status of the endpoint from unhealthy to healthy or the other way around. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53
    /// Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
    pub fn failure_threshold(&self) -> std::option::Option<i32> {
        self.failure_threshold
    }
}
impl std::fmt::Debug for HealthCheckConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckConfig");
        formatter.field("r#type", &self.r#type);
        formatter.field("resource_path", &self.resource_path);
        formatter.field("failure_threshold", &self.failure_threshold);
        formatter.finish()
    }
}
/// See [`HealthCheckConfig`](crate::model::HealthCheckConfig)
pub mod health_check_config {
    /// A builder for [`HealthCheckConfig`](crate::model::HealthCheckConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::HealthCheckType>,
        pub(crate) resource_path: std::option::Option<std::string::String>,
        pub(crate) failure_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
        /// healthy.</p>
        /// <important>
        /// <p>You can't change the value of <code>Type</code> after you create a health check.</p>
        /// </important>
        /// <p>You can create the following types of health checks:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
        /// an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53
        /// submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</p>
        /// <important>
        /// <p>If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TCP</b>: Route 53 tries to establish a TCP connection.</p>
        /// <p>If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
        /// <code>ResourcePath</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether
        /// an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::HealthCheckType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
        /// healthy.</p>
        /// <important>
        /// <p>You can't change the value of <code>Type</code> after you create a health check.</p>
        /// </important>
        /// <p>You can create the following types of health checks:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
        /// an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53
        /// submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</p>
        /// <important>
        /// <p>If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TCP</b>: Route 53 tries to establish a TCP connection.</p>
        /// <p>If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
        /// <code>ResourcePath</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether
        /// an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HealthCheckType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The path that you want Route 53 to request when performing health checks. The path can be any value that your
        /// endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is
        /// <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If you don't
        /// specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.</p>
        /// <p>If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
        /// <code>ResourcePath</code>.</p>
        pub fn resource_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_path = Some(input.into());
            self
        }
        /// <p>The path that you want Route 53 to request when performing health checks. The path can be any value that your
        /// endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is
        /// <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If you don't
        /// specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.</p>
        /// <p>If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
        /// <code>ResourcePath</code>.</p>
        pub fn set_resource_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_path = input;
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
        /// status of the endpoint from unhealthy to healthy or the other way around. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53
        /// Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
        pub fn failure_threshold(mut self, input: i32) -> Self {
            self.failure_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
        /// status of the endpoint from unhealthy to healthy or the other way around. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53
        /// Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.</p>
        pub fn set_failure_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckConfig`](crate::model::HealthCheckConfig)
        pub fn build(self) -> crate::model::HealthCheckConfig {
            crate::model::HealthCheckConfig {
                r#type: self.r#type,
                resource_path: self.resource_path,
                failure_threshold: self.failure_threshold,
            }
        }
    }
}
impl HealthCheckConfig {
    /// Creates a new builder-style object to manufacture [`HealthCheckConfig`](crate::model::HealthCheckConfig)
    pub fn builder() -> crate::model::health_check_config::Builder {
        crate::model::health_check_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthCheckType {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthCheckType {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => HealthCheckType::Http,
            "HTTPS" => HealthCheckType::Https,
            "TCP" => HealthCheckType::Tcp,
            other => HealthCheckType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthCheckType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthCheckType::from(s))
    }
}
impl HealthCheckType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthCheckType::Http => "HTTP",
            HealthCheckType::Https => "HTTPS",
            HealthCheckType::Tcp => "TCP",
            HealthCheckType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "HTTPS", "TCP"]
    }
}
impl AsRef<str> for HealthCheckType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about changes to the Route 53 DNS records that Cloud Map creates when you
/// register an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsConfigChange {
    /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 record that you want Cloud Map to
    /// create when you register an instance.</p>
    pub dns_records: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
}
impl DnsConfigChange {
    /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 record that you want Cloud Map to
    /// create when you register an instance.</p>
    pub fn dns_records(&self) -> std::option::Option<&[crate::model::DnsRecord]> {
        self.dns_records.as_deref()
    }
}
impl std::fmt::Debug for DnsConfigChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsConfigChange");
        formatter.field("dns_records", &self.dns_records);
        formatter.finish()
    }
}
/// See [`DnsConfigChange`](crate::model::DnsConfigChange)
pub mod dns_config_change {
    /// A builder for [`DnsConfigChange`](crate::model::DnsConfigChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_records: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
    }
    impl Builder {
        /// Appends an item to `dns_records`.
        ///
        /// To override the contents of this collection use [`set_dns_records`](Self::set_dns_records).
        ///
        /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 record that you want Cloud Map to
        /// create when you register an instance.</p>
        pub fn dns_records(mut self, input: impl Into<crate::model::DnsRecord>) -> Self {
            let mut v = self.dns_records.unwrap_or_default();
            v.push(input.into());
            self.dns_records = Some(v);
            self
        }
        /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 record that you want Cloud Map to
        /// create when you register an instance.</p>
        pub fn set_dns_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
        ) -> Self {
            self.dns_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsConfigChange`](crate::model::DnsConfigChange)
        pub fn build(self) -> crate::model::DnsConfigChange {
            crate::model::DnsConfigChange {
                dns_records: self.dns_records,
            }
        }
    }
}
impl DnsConfigChange {
    /// Creates a new builder-style object to manufacture [`DnsConfigChange`](crate::model::DnsConfigChange)
    pub fn builder() -> crate::model::dns_config_change::Builder {
        crate::model::dns_config_change::Builder::default()
    }
}

/// <p>A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you
/// register an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRecord {
    /// <p>The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You
    /// can specify values for <code>Type</code> in the following combinations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>A</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>AAAA</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>A</code>
    /// </b> and <b>
    /// <code>AAAA</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>SRV</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CNAME</code>
    /// </b>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you want Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or
    /// <code>AAAA</code> for <code>Type</code>.</p>
    /// <p>You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you
    /// register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
    /// <p>The following values are supported:</p>
    /// <dl>
    /// <dt>A</dt>
    /// <dd>
    /// <p>Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</p>
    /// </dd>
    /// <dt>AAAA</dt>
    /// <dd>
    /// <p>Route 53 returns the IP address of the resource in IPv6 format, such as
    /// 2001:0db8:85a3:0000:0000:abcd:0001:2345.</p>
    /// </dd>
    /// <dt>CNAME</dt>
    /// <dd>
    /// <p>Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>You specify the domain name that you want to route traffic to when you register an instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
    /// </li>
    /// <li>
    /// <p>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.</p>
    /// </li>
    /// <li>
    /// <p>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
    /// <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
    /// error.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>SRV</dt>
    /// <dd>
    /// <p>Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the
    /// following values:</p>
    /// <p>
    /// <code>priority weight port service-hostname</code>
    /// </p>
    /// <p>Note the following about the values:</p>
    /// <ul>
    /// <li>
    /// <p>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
    /// changed. </p>
    /// </li>
    /// <li>
    /// <p>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
    /// attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
    /// </li>
    /// <li>
    /// <p>The value of <code>service-hostname</code> is a concatenation of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>The value that you specify for <code>InstanceId</code> when you register an instance.</p>
    /// </li>
    /// <li>
    /// <p>The name of the service.</p>
    /// </li>
    /// <li>
    /// <p>The name of the namespace. </p>
    /// </li>
    /// </ul>
    /// <p>For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
    /// <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
    /// <code>service-hostname</code> is the following:</p>
    /// <p>
    /// <code>test.backend.example.com</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you specify settings for an <code>SRV</code> record, note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the
    /// <code>RegisterInstance</code> request, Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code>
    /// records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record.
    /// You can ignore these records.</p>
    /// </li>
    /// <li>
    /// <p>If you're using a system that requires a specific <code>SRV</code> format, such as HAProxy, see the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name">Name</a> element in the documentation about <code>CreateService</code> for information about how to
    /// specify the correct name format.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::RecordType>,
    /// <p>The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
    /// <note>
    /// <p>Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes
    /// traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the
    /// <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register
    /// instances that create either alias or non-alias records.</p>
    /// </note>
    pub ttl: std::option::Option<i64>,
}
impl DnsRecord {
    /// <p>The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You
    /// can specify values for <code>Type</code> in the following combinations:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>A</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>AAAA</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>A</code>
    /// </b> and <b>
    /// <code>AAAA</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>SRV</code>
    /// </b>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>CNAME</code>
    /// </b>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you want Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or
    /// <code>AAAA</code> for <code>Type</code>.</p>
    /// <p>You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you
    /// register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
    /// <p>The following values are supported:</p>
    /// <dl>
    /// <dt>A</dt>
    /// <dd>
    /// <p>Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</p>
    /// </dd>
    /// <dt>AAAA</dt>
    /// <dd>
    /// <p>Route 53 returns the IP address of the resource in IPv6 format, such as
    /// 2001:0db8:85a3:0000:0000:abcd:0001:2345.</p>
    /// </dd>
    /// <dt>CNAME</dt>
    /// <dd>
    /// <p>Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>You specify the domain name that you want to route traffic to when you register an instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
    /// </li>
    /// <li>
    /// <p>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.</p>
    /// </li>
    /// <li>
    /// <p>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
    /// <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
    /// error.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>SRV</dt>
    /// <dd>
    /// <p>Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the
    /// following values:</p>
    /// <p>
    /// <code>priority weight port service-hostname</code>
    /// </p>
    /// <p>Note the following about the values:</p>
    /// <ul>
    /// <li>
    /// <p>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
    /// changed. </p>
    /// </li>
    /// <li>
    /// <p>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
    /// attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
    /// </li>
    /// <li>
    /// <p>The value of <code>service-hostname</code> is a concatenation of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>The value that you specify for <code>InstanceId</code> when you register an instance.</p>
    /// </li>
    /// <li>
    /// <p>The name of the service.</p>
    /// </li>
    /// <li>
    /// <p>The name of the namespace. </p>
    /// </li>
    /// </ul>
    /// <p>For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
    /// <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
    /// <code>service-hostname</code> is the following:</p>
    /// <p>
    /// <code>test.backend.example.com</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you specify settings for an <code>SRV</code> record, note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the
    /// <code>RegisterInstance</code> request, Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code>
    /// records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record.
    /// You can ignore these records.</p>
    /// </li>
    /// <li>
    /// <p>If you're using a system that requires a specific <code>SRV</code> format, such as HAProxy, see the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name">Name</a> element in the documentation about <code>CreateService</code> for information about how to
    /// specify the correct name format.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RecordType> {
        self.r#type.as_ref()
    }
    /// <p>The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
    /// <note>
    /// <p>Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes
    /// traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the
    /// <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register
    /// instances that create either alias or non-alias records.</p>
    /// </note>
    pub fn ttl(&self) -> std::option::Option<i64> {
        self.ttl
    }
}
impl std::fmt::Debug for DnsRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRecord");
        formatter.field("r#type", &self.r#type);
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`DnsRecord`](crate::model::DnsRecord)
pub mod dns_record {
    /// A builder for [`DnsRecord`](crate::model::DnsRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RecordType>,
        pub(crate) ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You
        /// can specify values for <code>Type</code> in the following combinations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>A</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>AAAA</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>A</code>
        /// </b> and <b>
        /// <code>AAAA</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SRV</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CNAME</code>
        /// </b>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you want Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or
        /// <code>AAAA</code> for <code>Type</code>.</p>
        /// <p>You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you
        /// register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
        /// <p>The following values are supported:</p>
        /// <dl>
        /// <dt>A</dt>
        /// <dd>
        /// <p>Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</p>
        /// </dd>
        /// <dt>AAAA</dt>
        /// <dd>
        /// <p>Route 53 returns the IP address of the resource in IPv6 format, such as
        /// 2001:0db8:85a3:0000:0000:abcd:0001:2345.</p>
        /// </dd>
        /// <dt>CNAME</dt>
        /// <dd>
        /// <p>Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>You specify the domain name that you want to route traffic to when you register an instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
        /// </li>
        /// <li>
        /// <p>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.</p>
        /// </li>
        /// <li>
        /// <p>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
        /// <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
        /// error.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>SRV</dt>
        /// <dd>
        /// <p>Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the
        /// following values:</p>
        /// <p>
        /// <code>priority weight port service-hostname</code>
        /// </p>
        /// <p>Note the following about the values:</p>
        /// <ul>
        /// <li>
        /// <p>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
        /// changed. </p>
        /// </li>
        /// <li>
        /// <p>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
        /// attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
        /// </li>
        /// <li>
        /// <p>The value of <code>service-hostname</code> is a concatenation of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>The value that you specify for <code>InstanceId</code> when you register an instance.</p>
        /// </li>
        /// <li>
        /// <p>The name of the service.</p>
        /// </li>
        /// <li>
        /// <p>The name of the namespace. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
        /// <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
        /// <code>service-hostname</code> is the following:</p>
        /// <p>
        /// <code>test.backend.example.com</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you specify settings for an <code>SRV</code> record, note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the
        /// <code>RegisterInstance</code> request, Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code>
        /// records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record.
        /// You can ignore these records.</p>
        /// </li>
        /// <li>
        /// <p>If you're using a system that requires a specific <code>SRV</code> format, such as HAProxy, see the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name">Name</a> element in the documentation about <code>CreateService</code> for information about how to
        /// specify the correct name format.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::RecordType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You
        /// can specify values for <code>Type</code> in the following combinations:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>A</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>AAAA</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>A</code>
        /// </b> and <b>
        /// <code>AAAA</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SRV</code>
        /// </b>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CNAME</code>
        /// </b>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you want Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or
        /// <code>AAAA</code> for <code>Type</code>.</p>
        /// <p>You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you
        /// register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
        /// <p>The following values are supported:</p>
        /// <dl>
        /// <dt>A</dt>
        /// <dd>
        /// <p>Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</p>
        /// </dd>
        /// <dt>AAAA</dt>
        /// <dd>
        /// <p>Route 53 returns the IP address of the resource in IPv6 format, such as
        /// 2001:0db8:85a3:0000:0000:abcd:0001:2345.</p>
        /// </dd>
        /// <dt>CNAME</dt>
        /// <dd>
        /// <p>Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>You specify the domain name that you want to route traffic to when you register an instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a>.</p>
        /// </li>
        /// <li>
        /// <p>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.</p>
        /// </li>
        /// <li>
        /// <p>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
        /// <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
        /// error.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>SRV</dt>
        /// <dd>
        /// <p>Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the
        /// following values:</p>
        /// <p>
        /// <code>priority weight port service-hostname</code>
        /// </p>
        /// <p>Note the following about the values:</p>
        /// <ul>
        /// <li>
        /// <p>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
        /// changed. </p>
        /// </li>
        /// <li>
        /// <p>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
        /// attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</p>
        /// </li>
        /// <li>
        /// <p>The value of <code>service-hostname</code> is a concatenation of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>The value that you specify for <code>InstanceId</code> when you register an instance.</p>
        /// </li>
        /// <li>
        /// <p>The name of the service.</p>
        /// </li>
        /// <li>
        /// <p>The name of the namespace. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
        /// <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
        /// <code>service-hostname</code> is the following:</p>
        /// <p>
        /// <code>test.backend.example.com</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you specify settings for an <code>SRV</code> record, note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the
        /// <code>RegisterInstance</code> request, Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code>
        /// records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record.
        /// You can ignore these records.</p>
        /// </li>
        /// <li>
        /// <p>If you're using a system that requires a specific <code>SRV</code> format, such as HAProxy, see the <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name">Name</a> element in the documentation about <code>CreateService</code> for information about how to
        /// specify the correct name format.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RecordType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
        /// <note>
        /// <p>Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes
        /// traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the
        /// <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register
        /// instances that create either alias or non-alias records.</p>
        /// </note>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
        /// <note>
        /// <p>Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes
        /// traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the
        /// <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register
        /// instances that create either alias or non-alias records.</p>
        /// </note>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRecord`](crate::model::DnsRecord)
        pub fn build(self) -> crate::model::DnsRecord {
            crate::model::DnsRecord {
                r#type: self.r#type,
                ttl: self.ttl,
            }
        }
    }
}
impl DnsRecord {
    /// Creates a new builder-style object to manufacture [`DnsRecord`](crate::model::DnsRecord)
    pub fn builder() -> crate::model::dns_record::Builder {
        crate::model::dns_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordType {
    #[allow(missing_docs)] // documentation missing in model
    A,
    #[allow(missing_docs)] // documentation missing in model
    Aaaa,
    #[allow(missing_docs)] // documentation missing in model
    Cname,
    #[allow(missing_docs)] // documentation missing in model
    Srv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordType {
    fn from(s: &str) -> Self {
        match s {
            "A" => RecordType::A,
            "AAAA" => RecordType::Aaaa,
            "CNAME" => RecordType::Cname,
            "SRV" => RecordType::Srv,
            other => RecordType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordType::from(s))
    }
}
impl RecordType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordType::A => "A",
            RecordType::Aaaa => "AAAA",
            RecordType::Cname => "CNAME",
            RecordType::Srv => "SRV",
            RecordType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["A", "AAAA", "CNAME", "SRV"]
    }
}
impl AsRef<str> for RecordType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Updated properties for the public DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicDnsNamespaceChange {
    /// <p>An updated description for the public DNS
    /// namespace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Properties to be updated in the public
    /// DNS namespace.</p>
    pub properties: std::option::Option<crate::model::PublicDnsNamespacePropertiesChange>,
}
impl PublicDnsNamespaceChange {
    /// <p>An updated description for the public DNS
    /// namespace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Properties to be updated in the public
    /// DNS namespace.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<&crate::model::PublicDnsNamespacePropertiesChange> {
        self.properties.as_ref()
    }
}
impl std::fmt::Debug for PublicDnsNamespaceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicDnsNamespaceChange");
        formatter.field("description", &self.description);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`PublicDnsNamespaceChange`](crate::model::PublicDnsNamespaceChange)
pub mod public_dns_namespace_change {
    /// A builder for [`PublicDnsNamespaceChange`](crate::model::PublicDnsNamespaceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<crate::model::PublicDnsNamespacePropertiesChange>,
    }
    impl Builder {
        /// <p>An updated description for the public DNS
        /// namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An updated description for the public DNS
        /// namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Properties to be updated in the public
        /// DNS namespace.</p>
        pub fn properties(
            mut self,
            input: crate::model::PublicDnsNamespacePropertiesChange,
        ) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>Properties to be updated in the public
        /// DNS namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::PublicDnsNamespacePropertiesChange>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicDnsNamespaceChange`](crate::model::PublicDnsNamespaceChange)
        pub fn build(self) -> crate::model::PublicDnsNamespaceChange {
            crate::model::PublicDnsNamespaceChange {
                description: self.description,
                properties: self.properties,
            }
        }
    }
}
impl PublicDnsNamespaceChange {
    /// Creates a new builder-style object to manufacture [`PublicDnsNamespaceChange`](crate::model::PublicDnsNamespaceChange)
    pub fn builder() -> crate::model::public_dns_namespace_change::Builder {
        crate::model::public_dns_namespace_change::Builder::default()
    }
}

/// <p>Updated properties for the public DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicDnsNamespacePropertiesChange {
    /// <p>Updated DNS properties for the hosted
    /// zone for the public DNS namespace.</p>
    pub dns_properties: std::option::Option<crate::model::PublicDnsPropertiesMutableChange>,
}
impl PublicDnsNamespacePropertiesChange {
    /// <p>Updated DNS properties for the hosted
    /// zone for the public DNS namespace.</p>
    pub fn dns_properties(
        &self,
    ) -> std::option::Option<&crate::model::PublicDnsPropertiesMutableChange> {
        self.dns_properties.as_ref()
    }
}
impl std::fmt::Debug for PublicDnsNamespacePropertiesChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicDnsNamespacePropertiesChange");
        formatter.field("dns_properties", &self.dns_properties);
        formatter.finish()
    }
}
/// See [`PublicDnsNamespacePropertiesChange`](crate::model::PublicDnsNamespacePropertiesChange)
pub mod public_dns_namespace_properties_change {
    /// A builder for [`PublicDnsNamespacePropertiesChange`](crate::model::PublicDnsNamespacePropertiesChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_properties:
            std::option::Option<crate::model::PublicDnsPropertiesMutableChange>,
    }
    impl Builder {
        /// <p>Updated DNS properties for the hosted
        /// zone for the public DNS namespace.</p>
        pub fn dns_properties(
            mut self,
            input: crate::model::PublicDnsPropertiesMutableChange,
        ) -> Self {
            self.dns_properties = Some(input);
            self
        }
        /// <p>Updated DNS properties for the hosted
        /// zone for the public DNS namespace.</p>
        pub fn set_dns_properties(
            mut self,
            input: std::option::Option<crate::model::PublicDnsPropertiesMutableChange>,
        ) -> Self {
            self.dns_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicDnsNamespacePropertiesChange`](crate::model::PublicDnsNamespacePropertiesChange)
        pub fn build(self) -> crate::model::PublicDnsNamespacePropertiesChange {
            crate::model::PublicDnsNamespacePropertiesChange {
                dns_properties: self.dns_properties,
            }
        }
    }
}
impl PublicDnsNamespacePropertiesChange {
    /// Creates a new builder-style object to manufacture [`PublicDnsNamespacePropertiesChange`](crate::model::PublicDnsNamespacePropertiesChange)
    pub fn builder() -> crate::model::public_dns_namespace_properties_change::Builder {
        crate::model::public_dns_namespace_properties_change::Builder::default()
    }
}

/// <p>Updated DNS properties for the public DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicDnsPropertiesMutableChange {
    /// <p>Updated fields for the Start of Authority
    /// (SOA) record for the hosted zone for the public DNS namespace.</p>
    pub soa: std::option::Option<crate::model::SoaChange>,
}
impl PublicDnsPropertiesMutableChange {
    /// <p>Updated fields for the Start of Authority
    /// (SOA) record for the hosted zone for the public DNS namespace.</p>
    pub fn soa(&self) -> std::option::Option<&crate::model::SoaChange> {
        self.soa.as_ref()
    }
}
impl std::fmt::Debug for PublicDnsPropertiesMutableChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicDnsPropertiesMutableChange");
        formatter.field("soa", &self.soa);
        formatter.finish()
    }
}
/// See [`PublicDnsPropertiesMutableChange`](crate::model::PublicDnsPropertiesMutableChange)
pub mod public_dns_properties_mutable_change {
    /// A builder for [`PublicDnsPropertiesMutableChange`](crate::model::PublicDnsPropertiesMutableChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) soa: std::option::Option<crate::model::SoaChange>,
    }
    impl Builder {
        /// <p>Updated fields for the Start of Authority
        /// (SOA) record for the hosted zone for the public DNS namespace.</p>
        pub fn soa(mut self, input: crate::model::SoaChange) -> Self {
            self.soa = Some(input);
            self
        }
        /// <p>Updated fields for the Start of Authority
        /// (SOA) record for the hosted zone for the public DNS namespace.</p>
        pub fn set_soa(mut self, input: std::option::Option<crate::model::SoaChange>) -> Self {
            self.soa = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicDnsPropertiesMutableChange`](crate::model::PublicDnsPropertiesMutableChange)
        pub fn build(self) -> crate::model::PublicDnsPropertiesMutableChange {
            crate::model::PublicDnsPropertiesMutableChange { soa: self.soa }
        }
    }
}
impl PublicDnsPropertiesMutableChange {
    /// Creates a new builder-style object to manufacture [`PublicDnsPropertiesMutableChange`](crate::model::PublicDnsPropertiesMutableChange)
    pub fn builder() -> crate::model::public_dns_properties_mutable_change::Builder {
        crate::model::public_dns_properties_mutable_change::Builder::default()
    }
}

/// <p>Updated Start of Authority (SOA)
/// properties for a public or private DNS namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoaChange {
    /// <p>The updated time to live (TTL) for
    /// purposes of negative caching.</p>
    pub ttl: std::option::Option<i64>,
}
impl SoaChange {
    /// <p>The updated time to live (TTL) for
    /// purposes of negative caching.</p>
    pub fn ttl(&self) -> std::option::Option<i64> {
        self.ttl
    }
}
impl std::fmt::Debug for SoaChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoaChange");
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`SoaChange`](crate::model::SoaChange)
pub mod soa_change {
    /// A builder for [`SoaChange`](crate::model::SoaChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The updated time to live (TTL) for
        /// purposes of negative caching.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The updated time to live (TTL) for
        /// purposes of negative caching.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`SoaChange`](crate::model::SoaChange)
        pub fn build(self) -> crate::model::SoaChange {
            crate::model::SoaChange { ttl: self.ttl }
        }
    }
}
impl SoaChange {
    /// Creates a new builder-style object to manufacture [`SoaChange`](crate::model::SoaChange)
    pub fn builder() -> crate::model::soa_change::Builder {
        crate::model::soa_change::Builder::default()
    }
}

/// <p>Updated properties for the private DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsNamespaceChange {
    /// <p>An updated description for the private
    /// DNS namespace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Properties to be updated in the private
    /// DNS namespace.</p>
    pub properties: std::option::Option<crate::model::PrivateDnsNamespacePropertiesChange>,
}
impl PrivateDnsNamespaceChange {
    /// <p>An updated description for the private
    /// DNS namespace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Properties to be updated in the private
    /// DNS namespace.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<&crate::model::PrivateDnsNamespacePropertiesChange> {
        self.properties.as_ref()
    }
}
impl std::fmt::Debug for PrivateDnsNamespaceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsNamespaceChange");
        formatter.field("description", &self.description);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`PrivateDnsNamespaceChange`](crate::model::PrivateDnsNamespaceChange)
pub mod private_dns_namespace_change {
    /// A builder for [`PrivateDnsNamespaceChange`](crate::model::PrivateDnsNamespaceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<crate::model::PrivateDnsNamespacePropertiesChange>,
    }
    impl Builder {
        /// <p>An updated description for the private
        /// DNS namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An updated description for the private
        /// DNS namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Properties to be updated in the private
        /// DNS namespace.</p>
        pub fn properties(
            mut self,
            input: crate::model::PrivateDnsNamespacePropertiesChange,
        ) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>Properties to be updated in the private
        /// DNS namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsNamespacePropertiesChange>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsNamespaceChange`](crate::model::PrivateDnsNamespaceChange)
        pub fn build(self) -> crate::model::PrivateDnsNamespaceChange {
            crate::model::PrivateDnsNamespaceChange {
                description: self.description,
                properties: self.properties,
            }
        }
    }
}
impl PrivateDnsNamespaceChange {
    /// Creates a new builder-style object to manufacture [`PrivateDnsNamespaceChange`](crate::model::PrivateDnsNamespaceChange)
    pub fn builder() -> crate::model::private_dns_namespace_change::Builder {
        crate::model::private_dns_namespace_change::Builder::default()
    }
}

/// <p>Updated properties for the private DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsNamespacePropertiesChange {
    /// <p>Updated DNS properties for the private
    /// DNS namespace.</p>
    pub dns_properties: std::option::Option<crate::model::PrivateDnsPropertiesMutableChange>,
}
impl PrivateDnsNamespacePropertiesChange {
    /// <p>Updated DNS properties for the private
    /// DNS namespace.</p>
    pub fn dns_properties(
        &self,
    ) -> std::option::Option<&crate::model::PrivateDnsPropertiesMutableChange> {
        self.dns_properties.as_ref()
    }
}
impl std::fmt::Debug for PrivateDnsNamespacePropertiesChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsNamespacePropertiesChange");
        formatter.field("dns_properties", &self.dns_properties);
        formatter.finish()
    }
}
/// See [`PrivateDnsNamespacePropertiesChange`](crate::model::PrivateDnsNamespacePropertiesChange)
pub mod private_dns_namespace_properties_change {
    /// A builder for [`PrivateDnsNamespacePropertiesChange`](crate::model::PrivateDnsNamespacePropertiesChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_properties:
            std::option::Option<crate::model::PrivateDnsPropertiesMutableChange>,
    }
    impl Builder {
        /// <p>Updated DNS properties for the private
        /// DNS namespace.</p>
        pub fn dns_properties(
            mut self,
            input: crate::model::PrivateDnsPropertiesMutableChange,
        ) -> Self {
            self.dns_properties = Some(input);
            self
        }
        /// <p>Updated DNS properties for the private
        /// DNS namespace.</p>
        pub fn set_dns_properties(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsPropertiesMutableChange>,
        ) -> Self {
            self.dns_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsNamespacePropertiesChange`](crate::model::PrivateDnsNamespacePropertiesChange)
        pub fn build(self) -> crate::model::PrivateDnsNamespacePropertiesChange {
            crate::model::PrivateDnsNamespacePropertiesChange {
                dns_properties: self.dns_properties,
            }
        }
    }
}
impl PrivateDnsNamespacePropertiesChange {
    /// Creates a new builder-style object to manufacture [`PrivateDnsNamespacePropertiesChange`](crate::model::PrivateDnsNamespacePropertiesChange)
    pub fn builder() -> crate::model::private_dns_namespace_properties_change::Builder {
        crate::model::private_dns_namespace_properties_change::Builder::default()
    }
}

/// <p>Updated DNS properties for the private
/// DNS namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsPropertiesMutableChange {
    /// <p>Updated fields for the Start of Authority
    /// (SOA) record for the hosted zone for the private DNS namespace.</p>
    pub soa: std::option::Option<crate::model::SoaChange>,
}
impl PrivateDnsPropertiesMutableChange {
    /// <p>Updated fields for the Start of Authority
    /// (SOA) record for the hosted zone for the private DNS namespace.</p>
    pub fn soa(&self) -> std::option::Option<&crate::model::SoaChange> {
        self.soa.as_ref()
    }
}
impl std::fmt::Debug for PrivateDnsPropertiesMutableChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsPropertiesMutableChange");
        formatter.field("soa", &self.soa);
        formatter.finish()
    }
}
/// See [`PrivateDnsPropertiesMutableChange`](crate::model::PrivateDnsPropertiesMutableChange)
pub mod private_dns_properties_mutable_change {
    /// A builder for [`PrivateDnsPropertiesMutableChange`](crate::model::PrivateDnsPropertiesMutableChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) soa: std::option::Option<crate::model::SoaChange>,
    }
    impl Builder {
        /// <p>Updated fields for the Start of Authority
        /// (SOA) record for the hosted zone for the private DNS namespace.</p>
        pub fn soa(mut self, input: crate::model::SoaChange) -> Self {
            self.soa = Some(input);
            self
        }
        /// <p>Updated fields for the Start of Authority
        /// (SOA) record for the hosted zone for the private DNS namespace.</p>
        pub fn set_soa(mut self, input: std::option::Option<crate::model::SoaChange>) -> Self {
            self.soa = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsPropertiesMutableChange`](crate::model::PrivateDnsPropertiesMutableChange)
        pub fn build(self) -> crate::model::PrivateDnsPropertiesMutableChange {
            crate::model::PrivateDnsPropertiesMutableChange { soa: self.soa }
        }
    }
}
impl PrivateDnsPropertiesMutableChange {
    /// Creates a new builder-style object to manufacture [`PrivateDnsPropertiesMutableChange`](crate::model::PrivateDnsPropertiesMutableChange)
    pub fn builder() -> crate::model::private_dns_properties_mutable_change::Builder {
        crate::model::private_dns_properties_mutable_change::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomHealthStatus {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomHealthStatus {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => CustomHealthStatus::Healthy,
            "UNHEALTHY" => CustomHealthStatus::Unhealthy,
            other => CustomHealthStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomHealthStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomHealthStatus::from(s))
    }
}
impl CustomHealthStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomHealthStatus::Healthy => "HEALTHY",
            CustomHealthStatus::Unhealthy => "UNHEALTHY",
            CustomHealthStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY"]
    }
}
impl AsRef<str> for CustomHealthStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Updated properties for the HTTP
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpNamespaceChange {
    /// <p>An updated description for the HTTP
    /// namespace.</p>
    pub description: std::option::Option<std::string::String>,
}
impl HttpNamespaceChange {
    /// <p>An updated description for the HTTP
    /// namespace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for HttpNamespaceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpNamespaceChange");
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`HttpNamespaceChange`](crate::model::HttpNamespaceChange)
pub mod http_namespace_change {
    /// A builder for [`HttpNamespaceChange`](crate::model::HttpNamespaceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An updated description for the HTTP
        /// namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An updated description for the HTTP
        /// namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpNamespaceChange`](crate::model::HttpNamespaceChange)
        pub fn build(self) -> crate::model::HttpNamespaceChange {
            crate::model::HttpNamespaceChange {
                description: self.description,
            }
        }
    }
}
impl HttpNamespaceChange {
    /// Creates a new builder-style object to manufacture [`HttpNamespaceChange`](crate::model::HttpNamespaceChange)
    pub fn builder() -> crate::model::http_namespace_change::Builder {
        crate::model::http_namespace_change::Builder::default()
    }
}

/// <p>A custom key-value pair that's associated with a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string,
    /// but you can't set the value of a tag to null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string,
    /// but you can't set the value of a tag to null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string,
        /// but you can't set the value of a tag to null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string value that's associated with the key of the tag. You can set the value of a tag to an empty string,
        /// but you can't set the value of a tag to null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A complex type that contains information about a specified service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSummary {
    /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Describes the systems that can be used to discover the service instances.</p>
    /// <dl>
    /// <dt>DNS_HTTP</dt>
    /// <dd>
    /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
    /// operation.</p>
    /// </dd>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
    /// </dd>
    /// <dt>DNS</dt>
    /// <dd>
    /// <p>Reserved.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::ServiceType>,
    /// <p>The description that you specify when you create the service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of instances that are currently associated with the service. Instances that were previously
    /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
    /// registrations and deregistrations.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
    pub dns_config: std::option::Option<crate::model::DnsConfig>,
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
    /// settings for a health check, Cloud Map associates the health check with the records that you specify in
    /// <code>DnsConfig</code>.</p>
    pub health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
    /// <p>Information about an optional custom health check. A custom health check, which requires that you use a
    /// third-party health checker to evaluate the health of your resources, is useful in the following circumstances:</p>
    /// <ul>
    /// <li>
    /// <p>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't
    /// available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.
    /// (To check the health of resources in a VPC, the health checker must also be in the VPC.)</p>
    /// </li>
    /// <li>
    /// <p>You want to use a third-party health checker regardless of where your resources are located.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
    /// <code>HealthCheckConfig</code> but not both.</p>
    /// </important>
    pub health_check_custom_config: std::option::Option<crate::model::HealthCheckCustomConfig>,
    /// <p>The date and time that the service was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl ServiceSummary {
    /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Describes the systems that can be used to discover the service instances.</p>
    /// <dl>
    /// <dt>DNS_HTTP</dt>
    /// <dd>
    /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
    /// operation.</p>
    /// </dd>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
    /// </dd>
    /// <dt>DNS</dt>
    /// <dd>
    /// <p>Reserved.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.r#type.as_ref()
    }
    /// <p>The description that you specify when you create the service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of instances that are currently associated with the service. Instances that were previously
    /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
    /// registrations and deregistrations.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
    pub fn dns_config(&self) -> std::option::Option<&crate::model::DnsConfig> {
        self.dns_config.as_ref()
    }
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
    /// settings for a health check, Cloud Map associates the health check with the records that you specify in
    /// <code>DnsConfig</code>.</p>
    pub fn health_check_config(&self) -> std::option::Option<&crate::model::HealthCheckConfig> {
        self.health_check_config.as_ref()
    }
    /// <p>Information about an optional custom health check. A custom health check, which requires that you use a
    /// third-party health checker to evaluate the health of your resources, is useful in the following circumstances:</p>
    /// <ul>
    /// <li>
    /// <p>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't
    /// available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.
    /// (To check the health of resources in a VPC, the health checker must also be in the VPC.)</p>
    /// </li>
    /// <li>
    /// <p>You want to use a third-party health checker regardless of where your resources are located.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
    /// <code>HealthCheckConfig</code> but not both.</p>
    /// </important>
    pub fn health_check_custom_config(
        &self,
    ) -> std::option::Option<&crate::model::HealthCheckCustomConfig> {
        self.health_check_custom_config.as_ref()
    }
    /// <p>The date and time that the service was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for ServiceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("dns_config", &self.dns_config);
        formatter.field("health_check_config", &self.health_check_config);
        formatter.field(
            "health_check_custom_config",
            &self.health_check_custom_config,
        );
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`ServiceSummary`](crate::model::ServiceSummary)
pub mod service_summary {
    /// A builder for [`ServiceSummary`](crate::model::ServiceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ServiceType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) dns_config: std::option::Option<crate::model::DnsConfig>,
        pub(crate) health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
        pub(crate) health_check_custom_config:
            std::option::Option<crate::model::HealthCheckCustomConfig>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Describes the systems that can be used to discover the service instances.</p>
        /// <dl>
        /// <dt>DNS_HTTP</dt>
        /// <dd>
        /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
        /// operation.</p>
        /// </dd>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
        /// </dd>
        /// <dt>DNS</dt>
        /// <dd>
        /// <p>Reserved.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::ServiceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Describes the systems that can be used to discover the service instances.</p>
        /// <dl>
        /// <dt>DNS_HTTP</dt>
        /// <dd>
        /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
        /// operation.</p>
        /// </dd>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
        /// </dd>
        /// <dt>DNS</dt>
        /// <dd>
        /// <p>Reserved.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ServiceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description that you specify when you create the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that you specify when you create the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of instances that are currently associated with the service. Instances that were previously
        /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
        /// registrations and deregistrations.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances that are currently associated with the service. Instances that were previously
        /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
        /// registrations and deregistrations.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
        pub fn dns_config(mut self, input: crate::model::DnsConfig) -> Self {
            self.dns_config = Some(input);
            self
        }
        /// <p>Information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.</p>
        pub fn set_dns_config(
            mut self,
            input: std::option::Option<crate::model::DnsConfig>,
        ) -> Self {
            self.dns_config = input;
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
        /// settings for a health check, Cloud Map associates the health check with the records that you specify in
        /// <code>DnsConfig</code>.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.health_check_config = Some(input);
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health check. If you specify
        /// settings for a health check, Cloud Map associates the health check with the records that you specify in
        /// <code>DnsConfig</code>.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.health_check_config = input;
            self
        }
        /// <p>Information about an optional custom health check. A custom health check, which requires that you use a
        /// third-party health checker to evaluate the health of your resources, is useful in the following circumstances:</p>
        /// <ul>
        /// <li>
        /// <p>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't
        /// available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.
        /// (To check the health of resources in a VPC, the health checker must also be in the VPC.)</p>
        /// </li>
        /// <li>
        /// <p>You want to use a third-party health checker regardless of where your resources are located.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
        /// <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        pub fn health_check_custom_config(
            mut self,
            input: crate::model::HealthCheckCustomConfig,
        ) -> Self {
            self.health_check_custom_config = Some(input);
            self
        }
        /// <p>Information about an optional custom health check. A custom health check, which requires that you use a
        /// third-party health checker to evaluate the health of your resources, is useful in the following circumstances:</p>
        /// <ul>
        /// <li>
        /// <p>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't
        /// available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.
        /// (To check the health of resources in a VPC, the health checker must also be in the VPC.)</p>
        /// </li>
        /// <li>
        /// <p>You want to use a third-party health checker regardless of where your resources are located.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
        /// <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        pub fn set_health_check_custom_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckCustomConfig>,
        ) -> Self {
            self.health_check_custom_config = input;
            self
        }
        /// <p>The date and time that the service was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the service was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSummary`](crate::model::ServiceSummary)
        pub fn build(self) -> crate::model::ServiceSummary {
            crate::model::ServiceSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                instance_count: self.instance_count,
                dns_config: self.dns_config,
                health_check_config: self.health_check_config,
                health_check_custom_config: self.health_check_custom_config,
                create_date: self.create_date,
            }
        }
    }
}
impl ServiceSummary {
    /// Creates a new builder-style object to manufacture [`ServiceSummary`](crate::model::ServiceSummary)
    pub fn builder() -> crate::model::service_summary::Builder {
        crate::model::service_summary::Builder::default()
    }
}

/// <p>A complex type that contains information about an optional custom health check. A custom health check, which
/// requires that you use a third-party health checker to evaluate the health of your resources, is useful in the
/// following circumstances:</p>
/// <ul>
/// <li>
/// <p>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't
/// available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC.
/// (To check the health of resources in a VPC, the health checker must also be in the VPC.)</p>
/// </li>
/// <li>
/// <p>You want to use a third-party health checker regardless of where your resources are located.</p>
/// </li>
/// </ul>
/// <important>
/// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
/// <code>HealthCheckConfig</code> but not both.</p>
/// </important>
/// <p>To change the status of a custom health check, submit an <code>UpdateInstanceCustomHealthStatus</code> request.
/// Cloud Map doesn't monitor the status of the resource, it just keeps a record of the status specified in the most recent
/// <code>UpdateInstanceCustomHealthStatus</code> request.</p>
/// <p>Here's how custom health checks work:</p>
/// <ol>
/// <li>
/// <p>You create a service.</p>
/// </li>
/// <li>
/// <p>You register an instance.</p>
/// </li>
/// <li>
/// <p>You configure a third-party health checker to monitor the resource that's associated with the new instance. </p>
/// <note>
/// <p>Cloud Map doesn't check the health of the resource directly. </p>
/// </note>
/// </li>
/// <li>
/// <p>The third-party health-checker determines that the resource is unhealthy and notifies your application.</p>
/// </li>
/// <li>
/// <p>Your application submits an <code>UpdateInstanceCustomHealthStatus</code> request.</p>
/// </li>
/// <li>
/// <p>Cloud Map waits for 30 seconds.</p>
/// </li>
/// <li>
/// <p>If another <code>UpdateInstanceCustomHealthStatus</code> request doesn't arrive during that time to change the
/// status back to healthy, Cloud Map stops routing traffic to the resource.</p>
/// </li>
/// </ol>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckCustomConfig {
    /// <important>
    /// <p>This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after
    /// receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service
    /// instance.</p>
    /// </important>
    /// <p>The number of 30-second intervals that you want Cloud Map to wait after receiving an
    /// <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
    /// instance.</p>
    /// <p>Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before
    /// 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds after the first
    /// request to make the change.</p>
    pub failure_threshold: std::option::Option<i32>,
}
impl HealthCheckCustomConfig {
    /// <important>
    /// <p>This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after
    /// receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service
    /// instance.</p>
    /// </important>
    /// <p>The number of 30-second intervals that you want Cloud Map to wait after receiving an
    /// <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
    /// instance.</p>
    /// <p>Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before
    /// 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds after the first
    /// request to make the change.</p>
    pub fn failure_threshold(&self) -> std::option::Option<i32> {
        self.failure_threshold
    }
}
impl std::fmt::Debug for HealthCheckCustomConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckCustomConfig");
        formatter.field("failure_threshold", &self.failure_threshold);
        formatter.finish()
    }
}
/// See [`HealthCheckCustomConfig`](crate::model::HealthCheckCustomConfig)
pub mod health_check_custom_config {
    /// A builder for [`HealthCheckCustomConfig`](crate::model::HealthCheckCustomConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <important>
        /// <p>This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after
        /// receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service
        /// instance.</p>
        /// </important>
        /// <p>The number of 30-second intervals that you want Cloud Map to wait after receiving an
        /// <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
        /// instance.</p>
        /// <p>Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before
        /// 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds after the first
        /// request to make the change.</p>
        pub fn failure_threshold(mut self, input: i32) -> Self {
            self.failure_threshold = Some(input);
            self
        }
        /// <important>
        /// <p>This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after
        /// receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service
        /// instance.</p>
        /// </important>
        /// <p>The number of 30-second intervals that you want Cloud Map to wait after receiving an
        /// <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
        /// instance.</p>
        /// <p>Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before
        /// 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds after the first
        /// request to make the change.</p>
        pub fn set_failure_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckCustomConfig`](crate::model::HealthCheckCustomConfig)
        pub fn build(self) -> crate::model::HealthCheckCustomConfig {
            crate::model::HealthCheckCustomConfig {
                failure_threshold: self.failure_threshold,
            }
        }
    }
}
impl HealthCheckCustomConfig {
    /// Creates a new builder-style object to manufacture [`HealthCheckCustomConfig`](crate::model::HealthCheckCustomConfig)
    pub fn builder() -> crate::model::health_check_custom_config::Builder {
        crate::model::health_check_custom_config::Builder::default()
    }
}

/// <p>A complex type that contains information about the Amazon Route 53 DNS records that you want Cloud Map to create when
/// you register an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsConfig {
    /// <p>The ID of the namespace to use for DNS configuration.</p>
    pub namespace_id: std::option::Option<std::string::String>,
    /// <p>The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an
    /// instance and specify this service.</p>
    /// <note>
    /// <p>If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code>
    /// for the routing policy.</p>
    /// </note>
    /// <p>You can specify the following values:</p>
    /// <dl>
    /// <dt>MULTIVALUE</dt>
    /// <dd>
    /// <p>If you define a health check for the service and the health check is healthy, Route 53 returns the applicable
    /// value for up to eight instances.</p>
    /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
    /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to
    /// eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP
    /// addresses for all of the healthy instances.</p>
    /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
    /// the values for up to eight instances.</p>
    /// <p>For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer
    /// Routing</a> in the <i>Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>WEIGHTED</dt>
    /// <dd>
    /// <p>Route 53 returns the applicable value from one randomly selected instance from among the instances that you
    /// registered using the same service. Currently, all records have the same weight, so you can't route more or less
    /// traffic to any instances.</p>
    /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
    /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one
    /// randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS
    /// queries as if all of the instances were healthy.</p>
    /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
    /// the applicable value for one randomly selected instance.</p>
    /// <p>For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the
    /// <i>Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub routing_policy: std::option::Option<crate::model::RoutingPolicy>,
    /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 DNS record that you want Cloud Map to
    /// create when you register an instance.</p>
    pub dns_records: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
}
impl DnsConfig {
    /// <p>The ID of the namespace to use for DNS configuration.</p>
    pub fn namespace_id(&self) -> std::option::Option<&str> {
        self.namespace_id.as_deref()
    }
    /// <p>The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an
    /// instance and specify this service.</p>
    /// <note>
    /// <p>If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code>
    /// for the routing policy.</p>
    /// </note>
    /// <p>You can specify the following values:</p>
    /// <dl>
    /// <dt>MULTIVALUE</dt>
    /// <dd>
    /// <p>If you define a health check for the service and the health check is healthy, Route 53 returns the applicable
    /// value for up to eight instances.</p>
    /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
    /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to
    /// eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP
    /// addresses for all of the healthy instances.</p>
    /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
    /// the values for up to eight instances.</p>
    /// <p>For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer
    /// Routing</a> in the <i>Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>WEIGHTED</dt>
    /// <dd>
    /// <p>Route 53 returns the applicable value from one randomly selected instance from among the instances that you
    /// registered using the same service. Currently, all records have the same weight, so you can't route more or less
    /// traffic to any instances.</p>
    /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
    /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one
    /// randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS
    /// queries as if all of the instances were healthy.</p>
    /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
    /// the applicable value for one randomly selected instance.</p>
    /// <p>For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the
    /// <i>Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub fn routing_policy(&self) -> std::option::Option<&crate::model::RoutingPolicy> {
        self.routing_policy.as_ref()
    }
    /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 DNS record that you want Cloud Map to
    /// create when you register an instance.</p>
    pub fn dns_records(&self) -> std::option::Option<&[crate::model::DnsRecord]> {
        self.dns_records.as_deref()
    }
}
impl std::fmt::Debug for DnsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsConfig");
        formatter.field("namespace_id", &self.namespace_id);
        formatter.field("routing_policy", &self.routing_policy);
        formatter.field("dns_records", &self.dns_records);
        formatter.finish()
    }
}
/// See [`DnsConfig`](crate::model::DnsConfig)
pub mod dns_config {
    /// A builder for [`DnsConfig`](crate::model::DnsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_id: std::option::Option<std::string::String>,
        pub(crate) routing_policy: std::option::Option<crate::model::RoutingPolicy>,
        pub(crate) dns_records: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
    }
    impl Builder {
        /// <p>The ID of the namespace to use for DNS configuration.</p>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The ID of the namespace to use for DNS configuration.</p>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// <p>The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an
        /// instance and specify this service.</p>
        /// <note>
        /// <p>If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code>
        /// for the routing policy.</p>
        /// </note>
        /// <p>You can specify the following values:</p>
        /// <dl>
        /// <dt>MULTIVALUE</dt>
        /// <dd>
        /// <p>If you define a health check for the service and the health check is healthy, Route 53 returns the applicable
        /// value for up to eight instances.</p>
        /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
        /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to
        /// eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP
        /// addresses for all of the healthy instances.</p>
        /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
        /// the values for up to eight instances.</p>
        /// <p>For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer
        /// Routing</a> in the <i>Route 53 Developer Guide</i>.</p>
        /// </dd>
        /// <dt>WEIGHTED</dt>
        /// <dd>
        /// <p>Route 53 returns the applicable value from one randomly selected instance from among the instances that you
        /// registered using the same service. Currently, all records have the same weight, so you can't route more or less
        /// traffic to any instances.</p>
        /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
        /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one
        /// randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS
        /// queries as if all of the instances were healthy.</p>
        /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
        /// the applicable value for one randomly selected instance.</p>
        /// <p>For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the
        /// <i>Route 53 Developer Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn routing_policy(mut self, input: crate::model::RoutingPolicy) -> Self {
            self.routing_policy = Some(input);
            self
        }
        /// <p>The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an
        /// instance and specify this service.</p>
        /// <note>
        /// <p>If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code>
        /// for the routing policy.</p>
        /// </note>
        /// <p>You can specify the following values:</p>
        /// <dl>
        /// <dt>MULTIVALUE</dt>
        /// <dd>
        /// <p>If you define a health check for the service and the health check is healthy, Route 53 returns the applicable
        /// value for up to eight instances.</p>
        /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
        /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to
        /// eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP
        /// addresses for all of the healthy instances.</p>
        /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
        /// the values for up to eight instances.</p>
        /// <p>For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer
        /// Routing</a> in the <i>Route 53 Developer Guide</i>.</p>
        /// </dd>
        /// <dt>WEIGHTED</dt>
        /// <dd>
        /// <p>Route 53 returns the applicable value from one randomly selected instance from among the instances that you
        /// registered using the same service. Currently, all records have the same weight, so you can't route more or less
        /// traffic to any instances.</p>
        /// <p>For example, suppose that the service includes configurations for one <code>A</code> record and a health
        /// check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one
        /// randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS
        /// queries as if all of the instances were healthy.</p>
        /// <p>If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns
        /// the applicable value for one randomly selected instance.</p>
        /// <p>For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the
        /// <i>Route 53 Developer Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn set_routing_policy(
            mut self,
            input: std::option::Option<crate::model::RoutingPolicy>,
        ) -> Self {
            self.routing_policy = input;
            self
        }
        /// Appends an item to `dns_records`.
        ///
        /// To override the contents of this collection use [`set_dns_records`](Self::set_dns_records).
        ///
        /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 DNS record that you want Cloud Map to
        /// create when you register an instance.</p>
        pub fn dns_records(mut self, input: impl Into<crate::model::DnsRecord>) -> Self {
            let mut v = self.dns_records.unwrap_or_default();
            v.push(input.into());
            self.dns_records = Some(v);
            self
        }
        /// <p>An array that contains one <code>DnsRecord</code> object for each Route 53 DNS record that you want Cloud Map to
        /// create when you register an instance.</p>
        pub fn set_dns_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DnsRecord>>,
        ) -> Self {
            self.dns_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsConfig`](crate::model::DnsConfig)
        pub fn build(self) -> crate::model::DnsConfig {
            crate::model::DnsConfig {
                namespace_id: self.namespace_id,
                routing_policy: self.routing_policy,
                dns_records: self.dns_records,
            }
        }
    }
}
impl DnsConfig {
    /// Creates a new builder-style object to manufacture [`DnsConfig`](crate::model::DnsConfig)
    pub fn builder() -> crate::model::dns_config::Builder {
        crate::model::dns_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoutingPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Multivalue,
    #[allow(missing_docs)] // documentation missing in model
    Weighted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoutingPolicy {
    fn from(s: &str) -> Self {
        match s {
            "MULTIVALUE" => RoutingPolicy::Multivalue,
            "WEIGHTED" => RoutingPolicy::Weighted,
            other => RoutingPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoutingPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoutingPolicy::from(s))
    }
}
impl RoutingPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoutingPolicy::Multivalue => "MULTIVALUE",
            RoutingPolicy::Weighted => "WEIGHTED",
            RoutingPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTIVALUE", "WEIGHTED"]
    }
}
impl AsRef<str> for RoutingPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceType {
    #[allow(missing_docs)] // documentation missing in model
    Dns,
    #[allow(missing_docs)] // documentation missing in model
    DnsHttp,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceType {
    fn from(s: &str) -> Self {
        match s {
            "DNS" => ServiceType::Dns,
            "DNS_HTTP" => ServiceType::DnsHttp,
            "HTTP" => ServiceType::Http,
            other => ServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceType::from(s))
    }
}
impl ServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceType::Dns => "DNS",
            ServiceType::DnsHttp => "DNS_HTTP",
            ServiceType::Http => "HTTP",
            ServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DNS", "DNS_HTTP", "HTTP"]
    }
}
impl AsRef<str> for ServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that lets you specify the namespaces that you want to list services for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceFilter {
    /// <p>Specify <code>NAMESPACE_ID</code>.</p>
    pub name: std::option::Option<crate::model::ServiceFilterName>,
    /// <p>The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
    /// services.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
    /// values for <code>Condition</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
    /// <code>EQ</code> is the default condition and can be omitted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN</code>: When you specify <code>IN</code>, specify a list of the IDs for the namespaces that you want
    /// <code>ListServices</code> to return a list of services for.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BETWEEN</code>: Not applicable.</p>
    /// </li>
    /// </ul>
    pub condition: std::option::Option<crate::model::FilterCondition>,
}
impl ServiceFilter {
    /// <p>Specify <code>NAMESPACE_ID</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::ServiceFilterName> {
        self.name.as_ref()
    }
    /// <p>The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
    /// services.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
    /// values for <code>Condition</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
    /// <code>EQ</code> is the default condition and can be omitted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN</code>: When you specify <code>IN</code>, specify a list of the IDs for the namespaces that you want
    /// <code>ListServices</code> to return a list of services for.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BETWEEN</code>: Not applicable.</p>
    /// </li>
    /// </ul>
    pub fn condition(&self) -> std::option::Option<&crate::model::FilterCondition> {
        self.condition.as_ref()
    }
}
impl std::fmt::Debug for ServiceFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`ServiceFilter`](crate::model::ServiceFilter)
pub mod service_filter {
    /// A builder for [`ServiceFilter`](crate::model::ServiceFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ServiceFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<crate::model::FilterCondition>,
    }
    impl Builder {
        /// <p>Specify <code>NAMESPACE_ID</code>.</p>
        pub fn name(mut self, input: crate::model::ServiceFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Specify <code>NAMESPACE_ID</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ServiceFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
        /// services.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
        /// services.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
        /// values for <code>Condition</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
        /// <code>EQ</code> is the default condition and can be omitted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN</code>: When you specify <code>IN</code>, specify a list of the IDs for the namespaces that you want
        /// <code>ListServices</code> to return a list of services for.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BETWEEN</code>: Not applicable.</p>
        /// </li>
        /// </ul>
        pub fn condition(mut self, input: crate::model::FilterCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
        /// values for <code>Condition</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
        /// <code>EQ</code> is the default condition and can be omitted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN</code>: When you specify <code>IN</code>, specify a list of the IDs for the namespaces that you want
        /// <code>ListServices</code> to return a list of services for.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BETWEEN</code>: Not applicable.</p>
        /// </li>
        /// </ul>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceFilter`](crate::model::ServiceFilter)
        pub fn build(self) -> crate::model::ServiceFilter {
            crate::model::ServiceFilter {
                name: self.name,
                values: self.values,
                condition: self.condition,
            }
        }
    }
}
impl ServiceFilter {
    /// Creates a new builder-style object to manufacture [`ServiceFilter`](crate::model::ServiceFilter)
    pub fn builder() -> crate::model::service_filter::Builder {
        crate::model::service_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterCondition {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    In,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterCondition {
    fn from(s: &str) -> Self {
        match s {
            "BETWEEN" => FilterCondition::Between,
            "EQ" => FilterCondition::Eq,
            "IN" => FilterCondition::In,
            other => FilterCondition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterCondition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterCondition::from(s))
    }
}
impl FilterCondition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterCondition::Between => "BETWEEN",
            FilterCondition::Eq => "EQ",
            FilterCondition::In => "IN",
            FilterCondition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BETWEEN", "EQ", "IN"]
    }
}
impl AsRef<str> for FilterCondition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceFilterName {
    #[allow(missing_docs)] // documentation missing in model
    NamespaceId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceFilterName {
    fn from(s: &str) -> Self {
        match s {
            "NAMESPACE_ID" => ServiceFilterName::NamespaceId,
            other => ServiceFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceFilterName::from(s))
    }
}
impl ServiceFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceFilterName::NamespaceId => "NAMESPACE_ID",
            ServiceFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NAMESPACE_ID"]
    }
}
impl AsRef<str> for ServiceFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about an operation that matches the criteria that you specified in a
/// <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html">ListOperations</a>
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationSummary {
    /// <p>The ID for an operation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The status of the operation. Values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>SUBMITTED</b>: This is the initial state immediately after you submit a
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PENDING</b>: Cloud Map is performing the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SUCCESS</b>: The operation succeeded.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>FAIL</b>: The operation failed. For the failure reason, see
    /// <code>ErrorMessage</code>.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::OperationStatus>,
}
impl OperationSummary {
    /// <p>The ID for an operation.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The status of the operation. Values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>SUBMITTED</b>: This is the initial state immediately after you submit a
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PENDING</b>: Cloud Map is performing the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SUCCESS</b>: The operation succeeded.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>FAIL</b>: The operation failed. For the failure reason, see
    /// <code>ErrorMessage</code>.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for OperationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationSummary");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OperationSummary`](crate::model::OperationSummary)
pub mod operation_summary {
    /// A builder for [`OperationSummary`](crate::model::OperationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
    }
    impl Builder {
        /// <p>The ID for an operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for an operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The status of the operation. Values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>SUBMITTED</b>: This is the initial state immediately after you submit a
        /// request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PENDING</b>: Cloud Map is performing the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SUCCESS</b>: The operation succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>FAIL</b>: The operation failed. For the failure reason, see
        /// <code>ErrorMessage</code>.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the operation. Values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>SUBMITTED</b>: This is the initial state immediately after you submit a
        /// request.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PENDING</b>: Cloud Map is performing the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SUCCESS</b>: The operation succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>FAIL</b>: The operation failed. For the failure reason, see
        /// <code>ErrorMessage</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationSummary`](crate::model::OperationSummary)
        pub fn build(self) -> crate::model::OperationSummary {
            crate::model::OperationSummary {
                id: self.id,
                status: self.status,
            }
        }
    }
}
impl OperationSummary {
    /// Creates a new builder-style object to manufacture [`OperationSummary`](crate::model::OperationSummary)
    pub fn builder() -> crate::model::operation_summary::Builder {
        crate::model::operation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAIL" => OperationStatus::Fail,
            "PENDING" => OperationStatus::Pending,
            "SUBMITTED" => OperationStatus::Submitted,
            "SUCCESS" => OperationStatus::Success,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::Fail => "FAIL",
            OperationStatus::Pending => "PENDING",
            OperationStatus::Submitted => "SUBMITTED",
            OperationStatus::Success => "SUCCESS",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAIL", "PENDING", "SUBMITTED", "SUCCESS"]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that lets you select the operations that you want to list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationFilter {
    /// <p>Specify the operations that you want to get:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SERVICE_ID</b>: Gets operations related to specified services.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>STATUS</b>: Gets operations based on the status of the operations:
    /// <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TYPE</b>: Gets specified types of operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time
    /// range. </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::OperationFilterName>,
    /// <p>Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NAMESPACE_ID</b>: Specify one namespace ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SERVICE_ID</b>: Specify one service ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>,
    /// <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TYPE</b>: Specify one or more of the following types:
    /// <code>CREATE_NAMESPACE</code>, <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>,
    /// <code>REGISTER_INSTANCE</code>, or <code>DEREGISTER_INSTANCE</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format
    /// and Coordinated Universal Time (UTC). The start date must be the first value.</p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator that you want to use to determine whether an operation matches the specified value. Valid values
    /// for condition include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
    /// <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
    /// <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
    /// values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one of
    /// the specified values to be returned in the response.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
    /// Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for <code>UPDATE_DATE</code>.
    /// </p>
    /// </li>
    /// </ul>
    pub condition: std::option::Option<crate::model::FilterCondition>,
}
impl OperationFilter {
    /// <p>Specify the operations that you want to get:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SERVICE_ID</b>: Gets operations related to specified services.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>STATUS</b>: Gets operations based on the status of the operations:
    /// <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TYPE</b>: Gets specified types of operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time
    /// range. </p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::OperationFilterName> {
        self.name.as_ref()
    }
    /// <p>Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NAMESPACE_ID</b>: Specify one namespace ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SERVICE_ID</b>: Specify one service ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>,
    /// <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TYPE</b>: Specify one or more of the following types:
    /// <code>CREATE_NAMESPACE</code>, <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>,
    /// <code>REGISTER_INSTANCE</code>, or <code>DEREGISTER_INSTANCE</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format
    /// and Coordinated Universal Time (UTC). The start date must be the first value.</p>
    /// </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The operator that you want to use to determine whether an operation matches the specified value. Valid values
    /// for condition include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
    /// <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
    /// <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
    /// values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one of
    /// the specified values to be returned in the response.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
    /// Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for <code>UPDATE_DATE</code>.
    /// </p>
    /// </li>
    /// </ul>
    pub fn condition(&self) -> std::option::Option<&crate::model::FilterCondition> {
        self.condition.as_ref()
    }
}
impl std::fmt::Debug for OperationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`OperationFilter`](crate::model::OperationFilter)
pub mod operation_filter {
    /// A builder for [`OperationFilter`](crate::model::OperationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::OperationFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<crate::model::FilterCondition>,
    }
    impl Builder {
        /// <p>Specify the operations that you want to get:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SERVICE_ID</b>: Gets operations related to specified services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>STATUS</b>: Gets operations based on the status of the operations:
        /// <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TYPE</b>: Gets specified types of operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time
        /// range. </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::OperationFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Specify the operations that you want to get:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SERVICE_ID</b>: Gets operations related to specified services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>STATUS</b>: Gets operations based on the status of the operations:
        /// <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TYPE</b>: Gets specified types of operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time
        /// range. </p>
        /// </li>
        /// </ul>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::OperationFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NAMESPACE_ID</b>: Specify one namespace ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SERVICE_ID</b>: Specify one service ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>,
        /// <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TYPE</b>: Specify one or more of the following types:
        /// <code>CREATE_NAMESPACE</code>, <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>,
        /// <code>REGISTER_INSTANCE</code>, or <code>DEREGISTER_INSTANCE</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format
        /// and Coordinated Universal Time (UTC). The start date must be the first value.</p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NAMESPACE_ID</b>: Specify one namespace ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SERVICE_ID</b>: Specify one service ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>,
        /// <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TYPE</b>: Specify one or more of the following types:
        /// <code>CREATE_NAMESPACE</code>, <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>,
        /// <code>REGISTER_INSTANCE</code>, or <code>DEREGISTER_INSTANCE</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format
        /// and Coordinated Universal Time (UTC). The start date must be the first value.</p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator that you want to use to determine whether an operation matches the specified value. Valid values
        /// for condition include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
        /// <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
        /// <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
        /// values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one of
        /// the specified values to be returned in the response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
        /// Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for <code>UPDATE_DATE</code>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn condition(mut self, input: crate::model::FilterCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The operator that you want to use to determine whether an operation matches the specified value. Valid values
        /// for condition include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
        /// <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
        /// <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
        /// values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one of
        /// the specified values to be returned in the response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
        /// Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for <code>UPDATE_DATE</code>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationFilter`](crate::model::OperationFilter)
        pub fn build(self) -> crate::model::OperationFilter {
            crate::model::OperationFilter {
                name: self.name,
                values: self.values,
                condition: self.condition,
            }
        }
    }
}
impl OperationFilter {
    /// Creates a new builder-style object to manufacture [`OperationFilter`](crate::model::OperationFilter)
    pub fn builder() -> crate::model::operation_filter::Builder {
        crate::model::operation_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationFilterName {
    #[allow(missing_docs)] // documentation missing in model
    NamespaceId,
    #[allow(missing_docs)] // documentation missing in model
    ServiceId,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    Type,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationFilterName {
    fn from(s: &str) -> Self {
        match s {
            "NAMESPACE_ID" => OperationFilterName::NamespaceId,
            "SERVICE_ID" => OperationFilterName::ServiceId,
            "STATUS" => OperationFilterName::Status,
            "TYPE" => OperationFilterName::Type,
            "UPDATE_DATE" => OperationFilterName::UpdateDate,
            other => OperationFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationFilterName::from(s))
    }
}
impl OperationFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationFilterName::NamespaceId => "NAMESPACE_ID",
            OperationFilterName::ServiceId => "SERVICE_ID",
            OperationFilterName::Status => "STATUS",
            OperationFilterName::Type => "TYPE",
            OperationFilterName::UpdateDate => "UPDATE_DATE",
            OperationFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NAMESPACE_ID",
            "SERVICE_ID",
            "STATUS",
            "TYPE",
            "UPDATE_DATE",
        ]
    }
}
impl AsRef<str> for OperationFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about a namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceSummary {
    /// <p>The ID of the namespace.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the namespace. When you create a namespace, Cloud Map automatically creates a Route 53 hosted zone
    /// that has the same name as the namespace.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the namespace, either public or private.</p>
    pub r#type: std::option::Option<crate::model::NamespaceType>,
    /// <p>A description for the namespace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of services that were created using the namespace.</p>
    pub service_count: std::option::Option<i32>,
    /// <p>The properties of the namespace.</p>
    pub properties: std::option::Option<crate::model::NamespaceProperties>,
    /// <p>The date and time that the namespace was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl NamespaceSummary {
    /// <p>The ID of the namespace.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the namespace. When you create a namespace, Cloud Map automatically creates a Route 53 hosted zone
    /// that has the same name as the namespace.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the namespace, either public or private.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NamespaceType> {
        self.r#type.as_ref()
    }
    /// <p>A description for the namespace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of services that were created using the namespace.</p>
    pub fn service_count(&self) -> std::option::Option<i32> {
        self.service_count
    }
    /// <p>The properties of the namespace.</p>
    pub fn properties(&self) -> std::option::Option<&crate::model::NamespaceProperties> {
        self.properties.as_ref()
    }
    /// <p>The date and time that the namespace was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for NamespaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("service_count", &self.service_count);
        formatter.field("properties", &self.properties);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`NamespaceSummary`](crate::model::NamespaceSummary)
pub mod namespace_summary {
    /// A builder for [`NamespaceSummary`](crate::model::NamespaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NamespaceType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) service_count: std::option::Option<i32>,
        pub(crate) properties: std::option::Option<crate::model::NamespaceProperties>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the namespace.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the namespace.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the namespace. When you create a namespace, Cloud Map automatically creates a Route 53 hosted zone
        /// that has the same name as the namespace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the namespace. When you create a namespace, Cloud Map automatically creates a Route 53 hosted zone
        /// that has the same name as the namespace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the namespace, either public or private.</p>
        pub fn r#type(mut self, input: crate::model::NamespaceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the namespace, either public or private.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::NamespaceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the namespace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of services that were created using the namespace.</p>
        pub fn service_count(mut self, input: i32) -> Self {
            self.service_count = Some(input);
            self
        }
        /// <p>The number of services that were created using the namespace.</p>
        pub fn set_service_count(mut self, input: std::option::Option<i32>) -> Self {
            self.service_count = input;
            self
        }
        /// <p>The properties of the namespace.</p>
        pub fn properties(mut self, input: crate::model::NamespaceProperties) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>The properties of the namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::NamespaceProperties>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The date and time that the namespace was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the namespace was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceSummary`](crate::model::NamespaceSummary)
        pub fn build(self) -> crate::model::NamespaceSummary {
            crate::model::NamespaceSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                service_count: self.service_count,
                properties: self.properties,
                create_date: self.create_date,
            }
        }
    }
}
impl NamespaceSummary {
    /// Creates a new builder-style object to manufacture [`NamespaceSummary`](crate::model::NamespaceSummary)
    pub fn builder() -> crate::model::namespace_summary::Builder {
        crate::model::namespace_summary::Builder::default()
    }
}

/// <p>A complex type that contains information that's specific to the namespace type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceProperties {
    /// <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a
    /// namespace.</p>
    pub dns_properties: std::option::Option<crate::model::DnsProperties>,
    /// <p>A complex type that contains the name of an HTTP namespace.</p>
    pub http_properties: std::option::Option<crate::model::HttpProperties>,
}
impl NamespaceProperties {
    /// <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a
    /// namespace.</p>
    pub fn dns_properties(&self) -> std::option::Option<&crate::model::DnsProperties> {
        self.dns_properties.as_ref()
    }
    /// <p>A complex type that contains the name of an HTTP namespace.</p>
    pub fn http_properties(&self) -> std::option::Option<&crate::model::HttpProperties> {
        self.http_properties.as_ref()
    }
}
impl std::fmt::Debug for NamespaceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceProperties");
        formatter.field("dns_properties", &self.dns_properties);
        formatter.field("http_properties", &self.http_properties);
        formatter.finish()
    }
}
/// See [`NamespaceProperties`](crate::model::NamespaceProperties)
pub mod namespace_properties {
    /// A builder for [`NamespaceProperties`](crate::model::NamespaceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_properties: std::option::Option<crate::model::DnsProperties>,
        pub(crate) http_properties: std::option::Option<crate::model::HttpProperties>,
    }
    impl Builder {
        /// <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a
        /// namespace.</p>
        pub fn dns_properties(mut self, input: crate::model::DnsProperties) -> Self {
            self.dns_properties = Some(input);
            self
        }
        /// <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a
        /// namespace.</p>
        pub fn set_dns_properties(
            mut self,
            input: std::option::Option<crate::model::DnsProperties>,
        ) -> Self {
            self.dns_properties = input;
            self
        }
        /// <p>A complex type that contains the name of an HTTP namespace.</p>
        pub fn http_properties(mut self, input: crate::model::HttpProperties) -> Self {
            self.http_properties = Some(input);
            self
        }
        /// <p>A complex type that contains the name of an HTTP namespace.</p>
        pub fn set_http_properties(
            mut self,
            input: std::option::Option<crate::model::HttpProperties>,
        ) -> Self {
            self.http_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceProperties`](crate::model::NamespaceProperties)
        pub fn build(self) -> crate::model::NamespaceProperties {
            crate::model::NamespaceProperties {
                dns_properties: self.dns_properties,
                http_properties: self.http_properties,
            }
        }
    }
}
impl NamespaceProperties {
    /// Creates a new builder-style object to manufacture [`NamespaceProperties`](crate::model::NamespaceProperties)
    pub fn builder() -> crate::model::namespace_properties::Builder {
        crate::model::namespace_properties::Builder::default()
    }
}

/// <p>A complex type that contains the name of an HTTP namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpProperties {
    /// <p>The name of an HTTP namespace.</p>
    pub http_name: std::option::Option<std::string::String>,
}
impl HttpProperties {
    /// <p>The name of an HTTP namespace.</p>
    pub fn http_name(&self) -> std::option::Option<&str> {
        self.http_name.as_deref()
    }
}
impl std::fmt::Debug for HttpProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpProperties");
        formatter.field("http_name", &self.http_name);
        formatter.finish()
    }
}
/// See [`HttpProperties`](crate::model::HttpProperties)
pub mod http_properties {
    /// A builder for [`HttpProperties`](crate::model::HttpProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an HTTP namespace.</p>
        pub fn http_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_name = Some(input.into());
            self
        }
        /// <p>The name of an HTTP namespace.</p>
        pub fn set_http_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_name = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpProperties`](crate::model::HttpProperties)
        pub fn build(self) -> crate::model::HttpProperties {
            crate::model::HttpProperties {
                http_name: self.http_name,
            }
        }
    }
}
impl HttpProperties {
    /// Creates a new builder-style object to manufacture [`HttpProperties`](crate::model::HttpProperties)
    pub fn builder() -> crate::model::http_properties::Builder {
        crate::model::http_properties::Builder::default()
    }
}

/// <p>A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsProperties {
    /// <p>The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>Start of Authority (SOA) record for the hosted zone.</p>
    pub soa: std::option::Option<crate::model::Soa>,
}
impl DnsProperties {
    /// <p>The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>Start of Authority (SOA) record for the hosted zone.</p>
    pub fn soa(&self) -> std::option::Option<&crate::model::Soa> {
        self.soa.as_ref()
    }
}
impl std::fmt::Debug for DnsProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsProperties");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("soa", &self.soa);
        formatter.finish()
    }
}
/// See [`DnsProperties`](crate::model::DnsProperties)
pub mod dns_properties {
    /// A builder for [`DnsProperties`](crate::model::DnsProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) soa: std::option::Option<crate::model::Soa>,
    }
    impl Builder {
        /// <p>The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>Start of Authority (SOA) record for the hosted zone.</p>
        pub fn soa(mut self, input: crate::model::Soa) -> Self {
            self.soa = Some(input);
            self
        }
        /// <p>Start of Authority (SOA) record for the hosted zone.</p>
        pub fn set_soa(mut self, input: std::option::Option<crate::model::Soa>) -> Self {
            self.soa = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsProperties`](crate::model::DnsProperties)
        pub fn build(self) -> crate::model::DnsProperties {
            crate::model::DnsProperties {
                hosted_zone_id: self.hosted_zone_id,
                soa: self.soa,
            }
        }
    }
}
impl DnsProperties {
    /// Creates a new builder-style object to manufacture [`DnsProperties`](crate::model::DnsProperties)
    pub fn builder() -> crate::model::dns_properties::Builder {
        crate::model::dns_properties::Builder::default()
    }
}

/// <p>Start of Authority (SOA) properties for a
/// public or private DNS namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Soa {
    /// <p>The time to live (TTL) for purposes of
    /// negative caching.</p>
    pub ttl: std::option::Option<i64>,
}
impl Soa {
    /// <p>The time to live (TTL) for purposes of
    /// negative caching.</p>
    pub fn ttl(&self) -> std::option::Option<i64> {
        self.ttl
    }
}
impl std::fmt::Debug for Soa {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Soa");
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`Soa`](crate::model::Soa)
pub mod soa {
    /// A builder for [`Soa`](crate::model::Soa)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The time to live (TTL) for purposes of
        /// negative caching.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The time to live (TTL) for purposes of
        /// negative caching.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`Soa`](crate::model::Soa)
        pub fn build(self) -> crate::model::Soa {
            crate::model::Soa { ttl: self.ttl }
        }
    }
}
impl Soa {
    /// Creates a new builder-style object to manufacture [`Soa`](crate::model::Soa)
    pub fn builder() -> crate::model::soa::Builder {
        crate::model::soa::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceType {
    #[allow(missing_docs)] // documentation missing in model
    DnsPrivate,
    #[allow(missing_docs)] // documentation missing in model
    DnsPublic,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceType {
    fn from(s: &str) -> Self {
        match s {
            "DNS_PRIVATE" => NamespaceType::DnsPrivate,
            "DNS_PUBLIC" => NamespaceType::DnsPublic,
            "HTTP" => NamespaceType::Http,
            other => NamespaceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceType::from(s))
    }
}
impl NamespaceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceType::DnsPrivate => "DNS_PRIVATE",
            NamespaceType::DnsPublic => "DNS_PUBLIC",
            NamespaceType::Http => "HTTP",
            NamespaceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DNS_PRIVATE", "DNS_PUBLIC", "HTTP"]
    }
}
impl AsRef<str> for NamespaceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that identifies the namespaces that you want to list. You can choose to list public or private
/// namespaces.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceFilter {
    /// <p>Specify <code>TYPE</code>.</p>
    pub name: std::option::Option<crate::model::NamespaceFilterName>,
    /// <p>If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
    /// <code>DNS_PRIVATE</code>.</p>
    /// <p>If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
    /// <code>DNS_PRIVATE</code>, or both.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
    /// values for <code>condition</code> include:</p>
    /// <dl>
    /// <dt>EQ</dt>
    /// <dd>
    /// <p>When you specify <code>EQ</code> for the condition, you can choose to list only public namespaces or private
    /// namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.</p>
    /// </dd>
    /// <dt>IN</dt>
    /// <dd>
    /// <p>When you specify <code>IN</code> for the condition, you can choose to list public namespaces, private
    /// namespaces, or both. </p>
    /// </dd>
    /// <dt>BETWEEN</dt>
    /// <dd>
    /// <p> Not applicable</p>
    /// </dd>
    /// </dl>
    pub condition: std::option::Option<crate::model::FilterCondition>,
}
impl NamespaceFilter {
    /// <p>Specify <code>TYPE</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::NamespaceFilterName> {
        self.name.as_ref()
    }
    /// <p>If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
    /// <code>DNS_PRIVATE</code>.</p>
    /// <p>If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
    /// <code>DNS_PRIVATE</code>, or both.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
    /// values for <code>condition</code> include:</p>
    /// <dl>
    /// <dt>EQ</dt>
    /// <dd>
    /// <p>When you specify <code>EQ</code> for the condition, you can choose to list only public namespaces or private
    /// namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.</p>
    /// </dd>
    /// <dt>IN</dt>
    /// <dd>
    /// <p>When you specify <code>IN</code> for the condition, you can choose to list public namespaces, private
    /// namespaces, or both. </p>
    /// </dd>
    /// <dt>BETWEEN</dt>
    /// <dd>
    /// <p> Not applicable</p>
    /// </dd>
    /// </dl>
    pub fn condition(&self) -> std::option::Option<&crate::model::FilterCondition> {
        self.condition.as_ref()
    }
}
impl std::fmt::Debug for NamespaceFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`NamespaceFilter`](crate::model::NamespaceFilter)
pub mod namespace_filter {
    /// A builder for [`NamespaceFilter`](crate::model::NamespaceFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::NamespaceFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<crate::model::FilterCondition>,
    }
    impl Builder {
        /// <p>Specify <code>TYPE</code>.</p>
        pub fn name(mut self, input: crate::model::NamespaceFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Specify <code>TYPE</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::NamespaceFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
        /// <code>DNS_PRIVATE</code>.</p>
        /// <p>If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
        /// <code>DNS_PRIVATE</code>, or both.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
        /// <code>DNS_PRIVATE</code>.</p>
        /// <p>If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
        /// <code>DNS_PRIVATE</code>, or both.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
        /// values for <code>condition</code> include:</p>
        /// <dl>
        /// <dt>EQ</dt>
        /// <dd>
        /// <p>When you specify <code>EQ</code> for the condition, you can choose to list only public namespaces or private
        /// namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.</p>
        /// </dd>
        /// <dt>IN</dt>
        /// <dd>
        /// <p>When you specify <code>IN</code> for the condition, you can choose to list public namespaces, private
        /// namespaces, or both. </p>
        /// </dd>
        /// <dt>BETWEEN</dt>
        /// <dd>
        /// <p> Not applicable</p>
        /// </dd>
        /// </dl>
        pub fn condition(mut self, input: crate::model::FilterCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
        /// values for <code>condition</code> include:</p>
        /// <dl>
        /// <dt>EQ</dt>
        /// <dd>
        /// <p>When you specify <code>EQ</code> for the condition, you can choose to list only public namespaces or private
        /// namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.</p>
        /// </dd>
        /// <dt>IN</dt>
        /// <dd>
        /// <p>When you specify <code>IN</code> for the condition, you can choose to list public namespaces, private
        /// namespaces, or both. </p>
        /// </dd>
        /// <dt>BETWEEN</dt>
        /// <dd>
        /// <p> Not applicable</p>
        /// </dd>
        /// </dl>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceFilter`](crate::model::NamespaceFilter)
        pub fn build(self) -> crate::model::NamespaceFilter {
            crate::model::NamespaceFilter {
                name: self.name,
                values: self.values,
                condition: self.condition,
            }
        }
    }
}
impl NamespaceFilter {
    /// Creates a new builder-style object to manufacture [`NamespaceFilter`](crate::model::NamespaceFilter)
    pub fn builder() -> crate::model::namespace_filter::Builder {
        crate::model::namespace_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Type,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceFilterName {
    fn from(s: &str) -> Self {
        match s {
            "TYPE" => NamespaceFilterName::Type,
            other => NamespaceFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceFilterName::from(s))
    }
}
impl NamespaceFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceFilterName::Type => "TYPE",
            NamespaceFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TYPE"]
    }
}
impl AsRef<str> for NamespaceFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about the instances that you registered by using a specified
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSummary {
    /// <p>The ID for an instance that you created by using a specified service.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A string map that contains the following information:</p>
    /// <ul>
    /// <li>
    /// <p>The attributes that are associated with the instance. </p>
    /// </li>
    /// <li>
    /// <p>For each attribute, the applicable value.</p>
    /// </li>
    /// </ul>
    /// <p>Supported attribute keys include the following:</p>
    /// <dl>
    /// <dt>AWS_ALIAS_DNS_NAME</dt>
    /// <dd>
    /// <p>For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the
    /// load balancer. </p>
    /// </dd>
    /// <dt>AWS_EC2_INSTANCE_ID (HTTP namespaces only)</dt>
    /// <dd>
    /// <p>The Amazon EC2 instance ID for the instance. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified,
    /// then the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
    /// </dd>
    /// <dt>AWS_INIT_HEALTH_STATUS</dt>
    /// <dd>
    /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
    /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
    /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
    /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_CNAME</dt>
    /// <dd>
    /// <p>For a <code>CNAME</code> record, the domain name that Route 53 returns in response to DNS queries (for example,
    /// <code>example.com</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV4</dt>
    /// <dd>
    /// <p>For an <code>A</code> record, the IPv4 address that Route 53 returns in response to DNS queries (for example,
    /// <code>192.0.2.44</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV6</dt>
    /// <dd>
    /// <p>For an <code>AAAA</code> record, the IPv6 address that Route 53 returns in response to DNS queries (for example,
    /// <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_PORT</dt>
    /// <dd>
    /// <p>For an <code>SRV</code> record, the value that Route 53 returns for the port. In addition, if the service
    /// includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests to.</p>
    /// </dd>
    /// </dl>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl InstanceSummary {
    /// <p>The ID for an instance that you created by using a specified service.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A string map that contains the following information:</p>
    /// <ul>
    /// <li>
    /// <p>The attributes that are associated with the instance. </p>
    /// </li>
    /// <li>
    /// <p>For each attribute, the applicable value.</p>
    /// </li>
    /// </ul>
    /// <p>Supported attribute keys include the following:</p>
    /// <dl>
    /// <dt>AWS_ALIAS_DNS_NAME</dt>
    /// <dd>
    /// <p>For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the
    /// load balancer. </p>
    /// </dd>
    /// <dt>AWS_EC2_INSTANCE_ID (HTTP namespaces only)</dt>
    /// <dd>
    /// <p>The Amazon EC2 instance ID for the instance. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified,
    /// then the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
    /// </dd>
    /// <dt>AWS_INIT_HEALTH_STATUS</dt>
    /// <dd>
    /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
    /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
    /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
    /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_CNAME</dt>
    /// <dd>
    /// <p>For a <code>CNAME</code> record, the domain name that Route 53 returns in response to DNS queries (for example,
    /// <code>example.com</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV4</dt>
    /// <dd>
    /// <p>For an <code>A</code> record, the IPv4 address that Route 53 returns in response to DNS queries (for example,
    /// <code>192.0.2.44</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV6</dt>
    /// <dd>
    /// <p>For an <code>AAAA</code> record, the IPv6 address that Route 53 returns in response to DNS queries (for example,
    /// <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_PORT</dt>
    /// <dd>
    /// <p>For an <code>SRV</code> record, the value that Route 53 returns for the port. In addition, if the service
    /// includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests to.</p>
    /// </dd>
    /// </dl>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for InstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSummary");
        formatter.field("id", &self.id);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`InstanceSummary`](crate::model::InstanceSummary)
pub mod instance_summary {
    /// A builder for [`InstanceSummary`](crate::model::InstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID for an instance that you created by using a specified service.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for an instance that you created by using a specified service.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A string map that contains the following information:</p>
        /// <ul>
        /// <li>
        /// <p>The attributes that are associated with the instance. </p>
        /// </li>
        /// <li>
        /// <p>For each attribute, the applicable value.</p>
        /// </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>AWS_ALIAS_DNS_NAME</dt>
        /// <dd>
        /// <p>For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the
        /// load balancer. </p>
        /// </dd>
        /// <dt>AWS_EC2_INSTANCE_ID (HTTP namespaces only)</dt>
        /// <dd>
        /// <p>The Amazon EC2 instance ID for the instance. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified,
        /// then the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>AWS_INIT_HEALTH_STATUS</dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
        /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
        /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
        /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_CNAME</dt>
        /// <dd>
        /// <p>For a <code>CNAME</code> record, the domain name that Route 53 returns in response to DNS queries (for example,
        /// <code>example.com</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV4</dt>
        /// <dd>
        /// <p>For an <code>A</code> record, the IPv4 address that Route 53 returns in response to DNS queries (for example,
        /// <code>192.0.2.44</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV6</dt>
        /// <dd>
        /// <p>For an <code>AAAA</code> record, the IPv6 address that Route 53 returns in response to DNS queries (for example,
        /// <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_PORT</dt>
        /// <dd>
        /// <p>For an <code>SRV</code> record, the value that Route 53 returns for the port. In addition, if the service
        /// includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests to.</p>
        /// </dd>
        /// </dl>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A string map that contains the following information:</p>
        /// <ul>
        /// <li>
        /// <p>The attributes that are associated with the instance. </p>
        /// </li>
        /// <li>
        /// <p>For each attribute, the applicable value.</p>
        /// </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>AWS_ALIAS_DNS_NAME</dt>
        /// <dd>
        /// <p>For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the
        /// load balancer. </p>
        /// </dd>
        /// <dt>AWS_EC2_INSTANCE_ID (HTTP namespaces only)</dt>
        /// <dd>
        /// <p>The Amazon EC2 instance ID for the instance. When the <code>AWS_EC2_INSTANCE_ID</code> attribute is specified,
        /// then the <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>AWS_INIT_HEALTH_STATUS</dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
        /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
        /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
        /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_CNAME</dt>
        /// <dd>
        /// <p>For a <code>CNAME</code> record, the domain name that Route 53 returns in response to DNS queries (for example,
        /// <code>example.com</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV4</dt>
        /// <dd>
        /// <p>For an <code>A</code> record, the IPv4 address that Route 53 returns in response to DNS queries (for example,
        /// <code>192.0.2.44</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV6</dt>
        /// <dd>
        /// <p>For an <code>AAAA</code> record, the IPv6 address that Route 53 returns in response to DNS queries (for example,
        /// <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_PORT</dt>
        /// <dd>
        /// <p>For an <code>SRV</code> record, the value that Route 53 returns for the port. In addition, if the service
        /// includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests to.</p>
        /// </dd>
        /// </dl>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSummary`](crate::model::InstanceSummary)
        pub fn build(self) -> crate::model::InstanceSummary {
            crate::model::InstanceSummary {
                id: self.id,
                attributes: self.attributes,
            }
        }
    }
}
impl InstanceSummary {
    /// Creates a new builder-style object to manufacture [`InstanceSummary`](crate::model::InstanceSummary)
    pub fn builder() -> crate::model::instance_summary::Builder {
        crate::model::instance_summary::Builder::default()
    }
}

/// <p>A complex type that contains information about the specified service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the namespace that was used to create the service.</p>
    pub namespace_id: std::option::Option<std::string::String>,
    /// <p>The description of the service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of instances that are currently associated with the service. Instances that were previously
    /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
    /// registrations and deregistrations.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you
    /// register an instance.</p>
    pub dns_config: std::option::Option<crate::model::DnsConfig>,
    /// <p>Describes the systems that can be used to discover the service instances.</p>
    /// <dl>
    /// <dt>DNS_HTTP</dt>
    /// <dd>
    /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
    /// operation.</p>
    /// </dd>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
    /// </dd>
    /// <dt>DNS</dt>
    /// <dd>
    /// <p>Reserved.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::ServiceType>,
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
    /// health check. If you specify settings for a health check, Cloud Map associates the health check with the records
    /// that you specify in <code>DnsConfig</code>.</p>
    /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    pub health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
    /// <p>A complex type that contains information about an optional custom health check.</p>
    /// <important>
    /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
    /// <code>HealthCheckConfig</code> but not both.</p>
    /// </important>
    pub health_check_custom_config: std::option::Option<crate::model::HealthCheckCustomConfig>,
    /// <p>The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value
    /// of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code> represents
    /// Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
    /// running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
    /// date/timestamp).</p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl Service {
    /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the namespace that was used to create the service.</p>
    pub fn namespace_id(&self) -> std::option::Option<&str> {
        self.namespace_id.as_deref()
    }
    /// <p>The description of the service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of instances that are currently associated with the service. Instances that were previously
    /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
    /// registrations and deregistrations.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you
    /// register an instance.</p>
    pub fn dns_config(&self) -> std::option::Option<&crate::model::DnsConfig> {
        self.dns_config.as_ref()
    }
    /// <p>Describes the systems that can be used to discover the service instances.</p>
    /// <dl>
    /// <dt>DNS_HTTP</dt>
    /// <dd>
    /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
    /// operation.</p>
    /// </dd>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
    /// </dd>
    /// <dt>DNS</dt>
    /// <dd>
    /// <p>Reserved.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.r#type.as_ref()
    }
    /// <p>
    /// <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
    /// health check. If you specify settings for a health check, Cloud Map associates the health check with the records
    /// that you specify in <code>DnsConfig</code>.</p>
    /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    pub fn health_check_config(&self) -> std::option::Option<&crate::model::HealthCheckConfig> {
        self.health_check_config.as_ref()
    }
    /// <p>A complex type that contains information about an optional custom health check.</p>
    /// <important>
    /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
    /// <code>HealthCheckConfig</code> but not both.</p>
    /// </important>
    pub fn health_check_custom_config(
        &self,
    ) -> std::option::Option<&crate::model::HealthCheckCustomConfig> {
        self.health_check_custom_config.as_ref()
    }
    /// <p>The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value
    /// of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code> represents
    /// Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
    /// running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
    /// date/timestamp).</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("namespace_id", &self.namespace_id);
        formatter.field("description", &self.description);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("dns_config", &self.dns_config);
        formatter.field("r#type", &self.r#type);
        formatter.field("health_check_config", &self.health_check_config);
        formatter.field(
            "health_check_custom_config",
            &self.health_check_custom_config,
        );
        formatter.field("create_date", &self.create_date);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) dns_config: std::option::Option<crate::model::DnsConfig>,
        pub(crate) r#type: std::option::Option<crate::model::ServiceType>,
        pub(crate) health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
        pub(crate) health_check_custom_config:
            std::option::Option<crate::model::HealthCheckCustomConfig>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that Cloud Map assigned to the service when you created it.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the namespace that was used to create the service.</p>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The ID of the namespace that was used to create the service.</p>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// <p>The description of the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of instances that are currently associated with the service. Instances that were previously
        /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
        /// registrations and deregistrations.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances that are currently associated with the service. Instances that were previously
        /// associated with the service but that are deleted aren't included in the count. The count might not reflect pending
        /// registrations and deregistrations.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you
        /// register an instance.</p>
        pub fn dns_config(mut self, input: crate::model::DnsConfig) -> Self {
            self.dns_config = Some(input);
            self
        }
        /// <p>A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you
        /// register an instance.</p>
        pub fn set_dns_config(
            mut self,
            input: std::option::Option<crate::model::DnsConfig>,
        ) -> Self {
            self.dns_config = input;
            self
        }
        /// <p>Describes the systems that can be used to discover the service instances.</p>
        /// <dl>
        /// <dt>DNS_HTTP</dt>
        /// <dd>
        /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
        /// operation.</p>
        /// </dd>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
        /// </dd>
        /// <dt>DNS</dt>
        /// <dd>
        /// <p>Reserved.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::ServiceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Describes the systems that can be used to discover the service instances.</p>
        /// <dl>
        /// <dt>DNS_HTTP</dt>
        /// <dd>
        /// <p>The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
        /// operation.</p>
        /// </dd>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.</p>
        /// </dd>
        /// <dt>DNS</dt>
        /// <dd>
        /// <p>Reserved.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ServiceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
        /// health check. If you specify settings for a health check, Cloud Map associates the health check with the records
        /// that you specify in <code>DnsConfig</code>.</p>
        /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.health_check_config = Some(input);
            self
        }
        /// <p>
        /// <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
        /// health check. If you specify settings for a health check, Cloud Map associates the health check with the records
        /// that you specify in <code>DnsConfig</code>.</p>
        /// <p>For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.health_check_config = input;
            self
        }
        /// <p>A complex type that contains information about an optional custom health check.</p>
        /// <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
        /// <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        pub fn health_check_custom_config(
            mut self,
            input: crate::model::HealthCheckCustomConfig,
        ) -> Self {
            self.health_check_custom_config = Some(input);
            self
        }
        /// <p>A complex type that contains information about an optional custom health check.</p>
        /// <important>
        /// <p>If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
        /// <code>HealthCheckConfig</code> but not both.</p>
        /// </important>
        pub fn set_health_check_custom_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckCustomConfig>,
        ) -> Self {
            self.health_check_custom_config = input;
            self
        }
        /// <p>The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value
        /// of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code> represents
        /// Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value
        /// of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code> represents
        /// Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
        /// running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
        /// date/timestamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
        /// running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
        /// date/timestamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                id: self.id,
                arn: self.arn,
                name: self.name,
                namespace_id: self.namespace_id,
                description: self.description,
                instance_count: self.instance_count,
                dns_config: self.dns_config,
                r#type: self.r#type,
                health_check_config: self.health_check_config,
                health_check_custom_config: self.health_check_custom_config,
                create_date: self.create_date,
                creator_request_id: self.creator_request_id,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>A complex type that contains information about a specified operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Operation {
    /// <p>The ID of the operation that you want to get information about.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the operation that's associated with the specified ID.</p>
    pub r#type: std::option::Option<crate::model::OperationType>,
    /// <p>The status of the operation. Values include the following:</p>
    /// <dl>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>This is the initial state that occurs immediately after you submit a request.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>Cloud Map is performing the operation.</p>
    /// </dd>
    /// <dt>SUCCESS</dt>
    /// <dd>
    /// <p>The operation succeeded.</p>
    /// </dd>
    /// <dt>FAIL</dt>
    /// <dd>
    /// <p>The operation failed. For the failure reason, see <code>ErrorMessage</code>.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::OperationStatus>,
    /// <p>If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANNOT_CREATE_HOSTED_ZONE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXPIRED_TOKEN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HOSTED_ZONE_NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INTERNAL_FAILURE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVALID_CHANGE_BATCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>THROTTLED_REQUEST</code>
    /// </p>
    /// </li>
    /// </ul>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
    /// The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
    /// and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to milliseconds. For example,
    /// the value <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub update_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the target entity that's associated with the operation:</p>
    /// <dl>
    /// <dt>NAMESPACE</dt>
    /// <dd>
    /// <p>The namespace ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// <dt>SERVICE</dt>
    /// <dd>
    /// <p>The service ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// <dt>INSTANCE</dt>
    /// <dd>
    /// <p>The instance ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// </dl>
    pub targets: std::option::Option<
        std::collections::HashMap<crate::model::OperationTargetType, std::string::String>,
    >,
}
impl Operation {
    /// <p>The ID of the operation that you want to get information about.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the operation that's associated with the specified ID.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperationType> {
        self.r#type.as_ref()
    }
    /// <p>The status of the operation. Values include the following:</p>
    /// <dl>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>This is the initial state that occurs immediately after you submit a request.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>Cloud Map is performing the operation.</p>
    /// </dd>
    /// <dt>SUCCESS</dt>
    /// <dd>
    /// <p>The operation succeeded.</p>
    /// </dd>
    /// <dt>FAIL</dt>
    /// <dd>
    /// <p>The operation failed. For the failure reason, see <code>ErrorMessage</code>.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.status.as_ref()
    }
    /// <p>If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANNOT_CREATE_HOSTED_ZONE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXPIRED_TOKEN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HOSTED_ZONE_NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INTERNAL_FAILURE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVALID_CHANGE_BATCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>THROTTLED_REQUEST</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
    /// The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
    /// and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to milliseconds. For example,
    /// the value <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_date.as_ref()
    }
    /// <p>The name of the target entity that's associated with the operation:</p>
    /// <dl>
    /// <dt>NAMESPACE</dt>
    /// <dd>
    /// <p>The namespace ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// <dt>SERVICE</dt>
    /// <dd>
    /// <p>The service ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// <dt>INSTANCE</dt>
    /// <dd>
    /// <p>The instance ID is returned in the <code>ResourceId</code> property.</p>
    /// </dd>
    /// </dl>
    pub fn targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::OperationTargetType, std::string::String>,
    > {
        self.targets.as_ref()
    }
}
impl std::fmt::Debug for Operation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Operation");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("error_message", &self.error_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("create_date", &self.create_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}
/// See [`Operation`](crate::model::Operation)
pub mod operation {
    /// A builder for [`Operation`](crate::model::Operation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::OperationType>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) targets: std::option::Option<
            std::collections::HashMap<crate::model::OperationTargetType, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the operation that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the operation that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the operation that's associated with the specified ID.</p>
        pub fn r#type(mut self, input: crate::model::OperationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The name of the operation that's associated with the specified ID.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OperationType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The status of the operation. Values include the following:</p>
        /// <dl>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>This is the initial state that occurs immediately after you submit a request.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>Cloud Map is performing the operation.</p>
        /// </dd>
        /// <dt>SUCCESS</dt>
        /// <dd>
        /// <p>The operation succeeded.</p>
        /// </dd>
        /// <dt>FAIL</dt>
        /// <dd>
        /// <p>The operation failed. For the failure reason, see <code>ErrorMessage</code>.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the operation. Values include the following:</p>
        /// <dl>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>This is the initial state that occurs immediately after you submit a request.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>Cloud Map is performing the operation.</p>
        /// </dd>
        /// <dt>SUCCESS</dt>
        /// <dd>
        /// <p>The operation succeeded.</p>
        /// </dd>
        /// <dt>FAIL</dt>
        /// <dd>
        /// <p>The operation failed. For the failure reason, see <code>ErrorMessage</code>.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANNOT_CREATE_HOSTED_ZONE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED_TOKEN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HOSTED_ZONE_NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INTERNAL_FAILURE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID_CHANGE_BATCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>THROTTLED_REQUEST</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANNOT_CREATE_HOSTED_ZONE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED_TOKEN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HOSTED_ZONE_NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INTERNAL_FAILURE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVALID_CHANGE_BATCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>THROTTLED_REQUEST</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
        /// The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
        /// The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
        /// and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to milliseconds. For example,
        /// the value <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
        /// and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to milliseconds. For example,
        /// the value <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// Adds a key-value pair to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The name of the target entity that's associated with the operation:</p>
        /// <dl>
        /// <dt>NAMESPACE</dt>
        /// <dd>
        /// <p>The namespace ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// <dt>SERVICE</dt>
        /// <dd>
        /// <p>The service ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// <dt>INSTANCE</dt>
        /// <dd>
        /// <p>The instance ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// </dl>
        pub fn targets(
            mut self,
            k: impl Into<crate::model::OperationTargetType>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.targets.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.targets = Some(hash_map);
            self
        }
        /// <p>The name of the target entity that's associated with the operation:</p>
        /// <dl>
        /// <dt>NAMESPACE</dt>
        /// <dd>
        /// <p>The namespace ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// <dt>SERVICE</dt>
        /// <dd>
        /// <p>The service ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// <dt>INSTANCE</dt>
        /// <dd>
        /// <p>The instance ID is returned in the <code>ResourceId</code> property.</p>
        /// </dd>
        /// </dl>
        pub fn set_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::OperationTargetType, std::string::String>,
            >,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`Operation`](crate::model::Operation)
        pub fn build(self) -> crate::model::Operation {
            crate::model::Operation {
                id: self.id,
                r#type: self.r#type,
                status: self.status,
                error_message: self.error_message,
                error_code: self.error_code,
                create_date: self.create_date,
                update_date: self.update_date,
                targets: self.targets,
            }
        }
    }
}
impl Operation {
    /// Creates a new builder-style object to manufacture [`Operation`](crate::model::Operation)
    pub fn builder() -> crate::model::operation::Builder {
        crate::model::operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationTargetType {
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    Namespace,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationTargetType {
    fn from(s: &str) -> Self {
        match s {
            "INSTANCE" => OperationTargetType::Instance,
            "NAMESPACE" => OperationTargetType::Namespace,
            "SERVICE" => OperationTargetType::Service,
            other => OperationTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationTargetType::from(s))
    }
}
impl OperationTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationTargetType::Instance => "INSTANCE",
            OperationTargetType::Namespace => "NAMESPACE",
            OperationTargetType::Service => "SERVICE",
            OperationTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTANCE", "NAMESPACE", "SERVICE"]
    }
}
impl AsRef<str> for OperationTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationType {
    #[allow(missing_docs)] // documentation missing in model
    CreateNamespace,
    #[allow(missing_docs)] // documentation missing in model
    DeleteNamespace,
    #[allow(missing_docs)] // documentation missing in model
    DeregisterInstance,
    #[allow(missing_docs)] // documentation missing in model
    RegisterInstance,
    #[allow(missing_docs)] // documentation missing in model
    UpdateNamespace,
    #[allow(missing_docs)] // documentation missing in model
    UpdateService,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_NAMESPACE" => OperationType::CreateNamespace,
            "DELETE_NAMESPACE" => OperationType::DeleteNamespace,
            "DEREGISTER_INSTANCE" => OperationType::DeregisterInstance,
            "REGISTER_INSTANCE" => OperationType::RegisterInstance,
            "UPDATE_NAMESPACE" => OperationType::UpdateNamespace,
            "UPDATE_SERVICE" => OperationType::UpdateService,
            other => OperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationType::from(s))
    }
}
impl OperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationType::CreateNamespace => "CREATE_NAMESPACE",
            OperationType::DeleteNamespace => "DELETE_NAMESPACE",
            OperationType::DeregisterInstance => "DEREGISTER_INSTANCE",
            OperationType::RegisterInstance => "REGISTER_INSTANCE",
            OperationType::UpdateNamespace => "UPDATE_NAMESPACE",
            OperationType::UpdateService => "UPDATE_SERVICE",
            OperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_NAMESPACE",
            "DELETE_NAMESPACE",
            "DEREGISTER_INSTANCE",
            "REGISTER_INSTANCE",
            "UPDATE_NAMESPACE",
            "UPDATE_SERVICE",
        ]
    }
}
impl AsRef<str> for OperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about a specified namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Namespace {
    /// <p>The ID of a namespace.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the namespace, such as <code>example.com</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the namespace. The methods for discovering instances depends on the value that you specify:</p>
    /// <dl>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
    /// API.</p>
    /// </dd>
    /// <dt>DNS_PUBLIC</dt>
    /// <dd>
    /// <p>Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.</p>
    /// </dd>
    /// <dt>DNS_PRIVATE</dt>
    /// <dd>
    /// <p>Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
    /// API.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::NamespaceType>,
    /// <p>The description that you specify for the namespace when you create it.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of services that are associated with the namespace.</p>
    pub service_count: std::option::Option<i32>,
    /// <p>A complex type that contains information that's specific to the type of the namespace.</p>
    pub properties: std::option::Option<crate::model::NamespaceProperties>,
    /// <p>The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The
    /// value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
    /// running an operation twice. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
}
impl Namespace {
    /// <p>The ID of a namespace.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the namespace, such as <code>example.com</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the namespace. The methods for discovering instances depends on the value that you specify:</p>
    /// <dl>
    /// <dt>HTTP</dt>
    /// <dd>
    /// <p>Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
    /// API.</p>
    /// </dd>
    /// <dt>DNS_PUBLIC</dt>
    /// <dd>
    /// <p>Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.</p>
    /// </dd>
    /// <dt>DNS_PRIVATE</dt>
    /// <dd>
    /// <p>Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
    /// API.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NamespaceType> {
        self.r#type.as_ref()
    }
    /// <p>The description that you specify for the namespace when you create it.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of services that are associated with the namespace.</p>
    pub fn service_count(&self) -> std::option::Option<i32> {
        self.service_count
    }
    /// <p>A complex type that contains information that's specific to the type of the namespace.</p>
    pub fn properties(&self) -> std::option::Option<&crate::model::NamespaceProperties> {
        self.properties.as_ref()
    }
    /// <p>The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The
    /// value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
    /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
    /// running an operation twice. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
}
impl std::fmt::Debug for Namespace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Namespace");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("service_count", &self.service_count);
        formatter.field("properties", &self.properties);
        formatter.field("create_date", &self.create_date);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.finish()
    }
}
/// See [`Namespace`](crate::model::Namespace)
pub mod namespace {
    /// A builder for [`Namespace`](crate::model::Namespace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NamespaceType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) service_count: std::option::Option<i32>,
        pub(crate) properties: std::option::Option<crate::model::NamespaceProperties>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a namespace.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a namespace.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the namespace, such as <code>example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the namespace, such as <code>example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the namespace. The methods for discovering instances depends on the value that you specify:</p>
        /// <dl>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
        /// API.</p>
        /// </dd>
        /// <dt>DNS_PUBLIC</dt>
        /// <dd>
        /// <p>Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.</p>
        /// </dd>
        /// <dt>DNS_PRIVATE</dt>
        /// <dd>
        /// <p>Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
        /// API.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::NamespaceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the namespace. The methods for discovering instances depends on the value that you specify:</p>
        /// <dl>
        /// <dt>HTTP</dt>
        /// <dd>
        /// <p>Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
        /// API.</p>
        /// </dd>
        /// <dt>DNS_PUBLIC</dt>
        /// <dd>
        /// <p>Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.</p>
        /// </dd>
        /// <dt>DNS_PRIVATE</dt>
        /// <dd>
        /// <p>Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
        /// API.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::NamespaceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description that you specify for the namespace when you create it.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that you specify for the namespace when you create it.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of services that are associated with the namespace.</p>
        pub fn service_count(mut self, input: i32) -> Self {
            self.service_count = Some(input);
            self
        }
        /// <p>The number of services that are associated with the namespace.</p>
        pub fn set_service_count(mut self, input: std::option::Option<i32>) -> Self {
            self.service_count = input;
            self
        }
        /// <p>A complex type that contains information that's specific to the type of the namespace.</p>
        pub fn properties(mut self, input: crate::model::NamespaceProperties) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>A complex type that contains information that's specific to the type of the namespace.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::NamespaceProperties>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The
        /// value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The
        /// value of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
        /// represents Friday, January 26, 2018 12:11:30.087 AM.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
        /// running an operation twice. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of
        /// running an operation twice. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Namespace`](crate::model::Namespace)
        pub fn build(self) -> crate::model::Namespace {
            crate::model::Namespace {
                id: self.id,
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                service_count: self.service_count,
                properties: self.properties,
                create_date: self.create_date,
                creator_request_id: self.creator_request_id,
            }
        }
    }
}
impl Namespace {
    /// Creates a new builder-style object to manufacture [`Namespace`](crate::model::Namespace)
    pub fn builder() -> crate::model::namespace::Builder {
        crate::model::namespace::Builder::default()
    }
}

/// _Note: `HealthStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthStatus {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthStatus {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => HealthStatus::Healthy,
            "UNHEALTHY" => HealthStatus::Unhealthy,
            "UNKNOWN" => HealthStatus::UnknownValue,
            other => HealthStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthStatus::from(s))
    }
}
impl HealthStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthStatus::Healthy => "HEALTHY",
            HealthStatus::Unhealthy => "UNHEALTHY",
            HealthStatus::UnknownValue => "UNKNOWN",
            HealthStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY", "UNKNOWN"]
    }
}
impl AsRef<str> for HealthStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about an instance that Cloud Map creates when you submit a
/// <code>RegisterInstance</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>An identifier that you want to associate with the instance. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record,
    /// the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code>
    /// record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord > Type</a>.</p>
    /// </li>
    /// <li>
    /// <p>You can use this value to update an existing instance.</p>
    /// </li>
    /// <li>
    /// <p>To register a new instance, you must specify a value that's unique among instances that you register by using
    /// the same service. </p>
    /// </li>
    /// <li>
    /// <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing
    /// DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new
    /// one. </p>
    /// <note>
    /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a
    /// <code>ListHealthChecks</code> request, for example.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be
    /// retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string
    /// every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same
    /// namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time
    /// stamp).</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A string map that contains the following information for the service that you specify in
    /// <code>ServiceId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>The attributes that apply to the records that are defined in the service. </p>
    /// </li>
    /// <li>
    /// <p>For each attribute, the applicable value.</p>
    /// </li>
    /// </ul>
    /// <p>Supported attribute keys include the following:</p>
    /// <dl>
    /// <dt>AWS_ALIAS_DNS_NAME</dt>
    /// <dd>
    /// <p>If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify
    /// the DNS name that's associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget->DNSName</a> in the <i>Route 53 API Reference</i>.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an
    /// <code>A</code> record, an <code>AAAA</code> record, or both.</p>
    /// </li>
    /// <li>
    /// <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
    /// <code>WEIGHTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings,
    /// Cloud Map creates the health check, but it won't associate the health check with the alias record.</p>
    /// </li>
    /// <li>
    /// <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other
    /// than ELB load balancers.</p>
    /// </li>
    /// <li>
    /// <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
    /// <code>AWS_INSTANCE</code> attributes.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>AWS_EC2_INSTANCE_ID</dt>
    /// <dd>
    /// <p>
    /// <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. The
    /// <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
    /// </dd>
    /// <dt>AWS_INIT_HEALTH_STATUS</dt>
    /// <dd>
    /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
    /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
    /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
    /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_CNAME</dt>
    /// <dd>
    /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to
    /// return in response to DNS queries (for example, <code>example.com</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>CNAME</code> record.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV4</dt>
    /// <dd>
    /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to
    /// return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value
    /// for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV6</dt>
    /// <dd>
    /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to
    /// return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a
    /// value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_PORT</dt>
    /// <dd>
    /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the
    /// port.</p>
    /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send
    /// requests to. </p>
    /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when
    /// you created the service.</p>
    /// </dd>
    /// </dl>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Instance {
    /// <p>An identifier that you want to associate with the instance. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record,
    /// the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code>
    /// record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord > Type</a>.</p>
    /// </li>
    /// <li>
    /// <p>You can use this value to update an existing instance.</p>
    /// </li>
    /// <li>
    /// <p>To register a new instance, you must specify a value that's unique among instances that you register by using
    /// the same service. </p>
    /// </li>
    /// <li>
    /// <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing
    /// DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new
    /// one. </p>
    /// <note>
    /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a
    /// <code>ListHealthChecks</code> request, for example.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be
    /// retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string
    /// every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same
    /// namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time
    /// stamp).</p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A string map that contains the following information for the service that you specify in
    /// <code>ServiceId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>The attributes that apply to the records that are defined in the service. </p>
    /// </li>
    /// <li>
    /// <p>For each attribute, the applicable value.</p>
    /// </li>
    /// </ul>
    /// <p>Supported attribute keys include the following:</p>
    /// <dl>
    /// <dt>AWS_ALIAS_DNS_NAME</dt>
    /// <dd>
    /// <p>If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify
    /// the DNS name that's associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget->DNSName</a> in the <i>Route 53 API Reference</i>.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an
    /// <code>A</code> record, an <code>AAAA</code> record, or both.</p>
    /// </li>
    /// <li>
    /// <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
    /// <code>WEIGHTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings,
    /// Cloud Map creates the health check, but it won't associate the health check with the alias record.</p>
    /// </li>
    /// <li>
    /// <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other
    /// than ELB load balancers.</p>
    /// </li>
    /// <li>
    /// <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
    /// <code>AWS_INSTANCE</code> attributes.</p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>AWS_EC2_INSTANCE_ID</dt>
    /// <dd>
    /// <p>
    /// <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. The
    /// <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
    /// </dd>
    /// <dt>AWS_INIT_HEALTH_STATUS</dt>
    /// <dd>
    /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
    /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
    /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
    /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_CNAME</dt>
    /// <dd>
    /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to
    /// return in response to DNS queries (for example, <code>example.com</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>CNAME</code> record.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV4</dt>
    /// <dd>
    /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to
    /// return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value
    /// for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_IPV6</dt>
    /// <dd>
    /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to
    /// return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
    /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
    /// <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a
    /// value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
    /// </dd>
    /// <dt>AWS_INSTANCE_PORT</dt>
    /// <dd>
    /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the
    /// port.</p>
    /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send
    /// requests to. </p>
    /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when
    /// you created the service.</p>
    /// </dd>
    /// </dl>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("id", &self.id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An identifier that you want to associate with the instance. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record,
        /// the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code>
        /// record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord > Type</a>.</p>
        /// </li>
        /// <li>
        /// <p>You can use this value to update an existing instance.</p>
        /// </li>
        /// <li>
        /// <p>To register a new instance, you must specify a value that's unique among instances that you register by using
        /// the same service. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing
        /// DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new
        /// one. </p>
        /// <note>
        /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a
        /// <code>ListHealthChecks</code> request, for example.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier that you want to associate with the instance. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If the service that's specified by <code>ServiceId</code> includes settings for an <code>SRV</code> record,
        /// the value of <code>InstanceId</code> is automatically included as part of the value for the <code>SRV</code>
        /// record. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type">DnsRecord > Type</a>.</p>
        /// </li>
        /// <li>
        /// <p>You can use this value to update an existing instance.</p>
        /// </li>
        /// <li>
        /// <p>To register a new instance, you must specify a value that's unique among instances that you register by using
        /// the same service. </p>
        /// </li>
        /// <li>
        /// <p>If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, Cloud Map updates the existing
        /// DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new
        /// one. </p>
        /// <note>
        /// <p>The health check isn't deleted immediately, so it will still appear for a while if you submit a
        /// <code>ListHealthChecks</code> request, for example.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be
        /// retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string
        /// every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same
        /// namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time
        /// stamp).</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be
        /// retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code> string
        /// every time you submit a <code>RegisterInstance</code> request if you're registering additional instances for the same
        /// namespace and service. <code>CreatorRequestId</code> can be any unique string (for example, a date/time
        /// stamp).</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A string map that contains the following information for the service that you specify in
        /// <code>ServiceId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>The attributes that apply to the records that are defined in the service. </p>
        /// </li>
        /// <li>
        /// <p>For each attribute, the applicable value.</p>
        /// </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>AWS_ALIAS_DNS_NAME</dt>
        /// <dd>
        /// <p>If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify
        /// the DNS name that's associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget->DNSName</a> in the <i>Route 53 API Reference</i>.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an
        /// <code>A</code> record, an <code>AAAA</code> record, or both.</p>
        /// </li>
        /// <li>
        /// <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
        /// <code>WEIGHTED</code>.</p>
        /// </li>
        /// <li>
        /// <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings,
        /// Cloud Map creates the health check, but it won't associate the health check with the alias record.</p>
        /// </li>
        /// <li>
        /// <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other
        /// than ELB load balancers.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
        /// <code>AWS_INSTANCE</code> attributes.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>AWS_EC2_INSTANCE_ID</dt>
        /// <dd>
        /// <p>
        /// <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. The
        /// <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>AWS_INIT_HEALTH_STATUS</dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
        /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
        /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
        /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_CNAME</dt>
        /// <dd>
        /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to
        /// return in response to DNS queries (for example, <code>example.com</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>CNAME</code> record.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV4</dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to
        /// return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value
        /// for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV6</dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to
        /// return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a
        /// value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_PORT</dt>
        /// <dd>
        /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the
        /// port.</p>
        /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send
        /// requests to. </p>
        /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when
        /// you created the service.</p>
        /// </dd>
        /// </dl>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A string map that contains the following information for the service that you specify in
        /// <code>ServiceId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>The attributes that apply to the records that are defined in the service. </p>
        /// </li>
        /// <li>
        /// <p>For each attribute, the applicable value.</p>
        /// </li>
        /// </ul>
        /// <p>Supported attribute keys include the following:</p>
        /// <dl>
        /// <dt>AWS_ALIAS_DNS_NAME</dt>
        /// <dd>
        /// <p>If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify
        /// the DNS name that's associated with the load balancer. For information about how to get the DNS name, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName">AliasTarget->DNSName</a> in the <i>Route 53 API Reference</i>.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>The configuration for the service that's specified by <code>ServiceId</code> must include settings for an
        /// <code>A</code> record, an <code>AAAA</code> record, or both.</p>
        /// </li>
        /// <li>
        /// <p>In the service that's specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
        /// <code>WEIGHTED</code>.</p>
        /// </li>
        /// <li>
        /// <p>If the service that's specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings,
        /// Cloud Map creates the health check, but it won't associate the health check with the alias record.</p>
        /// </li>
        /// <li>
        /// <p>Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other
        /// than ELB load balancers.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
        /// <code>AWS_INSTANCE</code> attributes.</p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>AWS_EC2_INSTANCE_ID</dt>
        /// <dd>
        /// <p>
        /// <i>HTTP namespaces only.</i> The Amazon EC2 instance ID for the instance. The
        /// <code>AWS_INSTANCE_IPV4</code> attribute contains the primary private IPv4 address.</p>
        /// </dd>
        /// <dt>AWS_INIT_HEALTH_STATUS</dt>
        /// <dd>
        /// <p>If the service configuration includes <code>HealthCheckCustomConfig</code>, you can optionally use
        /// <code>AWS_INIT_HEALTH_STATUS</code> to specify the initial status of the custom health check,
        /// <code>HEALTHY</code> or <code>UNHEALTHY</code>. If you don't specify a value for
        /// <code>AWS_INIT_HEALTH_STATUS</code>, the initial status is <code>HEALTHY</code>.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_CNAME</dt>
        /// <dd>
        /// <p>If the service configuration includes a <code>CNAME</code> record, the domain name that you want Route 53 to
        /// return in response to DNS queries (for example, <code>example.com</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>CNAME</code> record.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV4</dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>A</code> record, the IPv4 address that you want Route 53 to
        /// return in response to DNS queries (for example, <code>192.0.2.44</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>A</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a value
        /// for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_IPV6</dt>
        /// <dd>
        /// <p>If the service configuration includes an <code>AAAA</code> record, the IPv6 address that you want Route 53 to
        /// return in response to DNS queries (for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>).</p>
        /// <p>This value is required if the service specified by <code>ServiceId</code> includes settings for an
        /// <code>AAAA</code> record. If the service includes settings for an <code>SRV</code> record, you must specify a
        /// value for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.</p>
        /// </dd>
        /// <dt>AWS_INSTANCE_PORT</dt>
        /// <dd>
        /// <p>If the service includes an <code>SRV</code> record, the value that you want Route 53 to return for the
        /// port.</p>
        /// <p>If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send
        /// requests to. </p>
        /// <p>This value is required if you specified settings for an <code>SRV</code> record or a Route 53 health check when
        /// you created the service.</p>
        /// </dd>
        /// </dl>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                id: self.id,
                creator_request_id: self.creator_request_id,
                attributes: self.attributes,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>In a response to a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> request, <code>HttpInstanceSummary</code> contains information about one instance that
/// matches the values that you specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpInstanceSummary {
    /// <p>The ID of an instance that matches the values that you specified in the request.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>
    /// <code></code>
    /// <code></code>
    /// <code></code>
    /// </p>
    /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
    /// <code>Properties</code> member of the namespace.</p>
    pub namespace_name: std::option::Option<std::string::String>,
    /// <p>The name of the service that you specified when you registered the instance.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>If you configured health checking in the service, the current health status of the service instance.</p>
    pub health_status: std::option::Option<crate::model::HealthStatus>,
    /// <p>If you included any attributes when you registered the instance, the values of those attributes.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl HttpInstanceSummary {
    /// <p>The ID of an instance that matches the values that you specified in the request.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>
    /// <code></code>
    /// <code></code>
    /// <code></code>
    /// </p>
    /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
    /// <code>Properties</code> member of the namespace.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
    /// <p>The name of the service that you specified when you registered the instance.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>If you configured health checking in the service, the current health status of the service instance.</p>
    pub fn health_status(&self) -> std::option::Option<&crate::model::HealthStatus> {
        self.health_status.as_ref()
    }
    /// <p>If you included any attributes when you registered the instance, the values of those attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for HttpInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpInstanceSummary");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("namespace_name", &self.namespace_name);
        formatter.field("service_name", &self.service_name);
        formatter.field("health_status", &self.health_status);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`HttpInstanceSummary`](crate::model::HttpInstanceSummary)
pub mod http_instance_summary {
    /// A builder for [`HttpInstanceSummary`](crate::model::HttpInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) namespace_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<crate::model::HealthStatus>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of an instance that matches the values that you specified in the request.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of an instance that matches the values that you specified in the request.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>
        /// <code></code>
        /// <code></code>
        /// <code></code>
        /// </p>
        /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
        /// <code>Properties</code> member of the namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>
        /// <code></code>
        /// <code></code>
        /// <code></code>
        /// </p>
        /// <p>The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
        /// <code>Properties</code> member of the namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// <p>The name of the service that you specified when you registered the instance.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that you specified when you registered the instance.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>If you configured health checking in the service, the current health status of the service instance.</p>
        pub fn health_status(mut self, input: crate::model::HealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>If you configured health checking in the service, the current health status of the service instance.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::HealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>If you included any attributes when you registered the instance, the values of those attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>If you included any attributes when you registered the instance, the values of those attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpInstanceSummary`](crate::model::HttpInstanceSummary)
        pub fn build(self) -> crate::model::HttpInstanceSummary {
            crate::model::HttpInstanceSummary {
                instance_id: self.instance_id,
                namespace_name: self.namespace_name,
                service_name: self.service_name,
                health_status: self.health_status,
                attributes: self.attributes,
            }
        }
    }
}
impl HttpInstanceSummary {
    /// Creates a new builder-style object to manufacture [`HttpInstanceSummary`](crate::model::HttpInstanceSummary)
    pub fn builder() -> crate::model::http_instance_summary::Builder {
        crate::model::http_instance_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthStatusFilter {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    HealthyOrElseAll,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthStatusFilter {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => HealthStatusFilter::All,
            "HEALTHY" => HealthStatusFilter::Healthy,
            "HEALTHY_OR_ELSE_ALL" => HealthStatusFilter::HealthyOrElseAll,
            "UNHEALTHY" => HealthStatusFilter::Unhealthy,
            other => HealthStatusFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthStatusFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthStatusFilter::from(s))
    }
}
impl HealthStatusFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthStatusFilter::All => "ALL",
            HealthStatusFilter::Healthy => "HEALTHY",
            HealthStatusFilter::HealthyOrElseAll => "HEALTHY_OR_ELSE_ALL",
            HealthStatusFilter::Unhealthy => "UNHEALTHY",
            HealthStatusFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "HEALTHY", "HEALTHY_OR_ELSE_ALL", "UNHEALTHY"]
    }
}
impl AsRef<str> for HealthStatusFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceTypeOption {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceTypeOption {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => ServiceTypeOption::Http,
            other => ServiceTypeOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceTypeOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceTypeOption::from(s))
    }
}
impl ServiceTypeOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceTypeOption::Http => "HTTP",
            ServiceTypeOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP"]
    }
}
impl AsRef<str> for ServiceTypeOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>DNS properties for the public DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicDnsNamespaceProperties {
    /// <p>DNS properties for the public DNS
    /// namespace.</p>
    pub dns_properties: std::option::Option<crate::model::PublicDnsPropertiesMutable>,
}
impl PublicDnsNamespaceProperties {
    /// <p>DNS properties for the public DNS
    /// namespace.</p>
    pub fn dns_properties(&self) -> std::option::Option<&crate::model::PublicDnsPropertiesMutable> {
        self.dns_properties.as_ref()
    }
}
impl std::fmt::Debug for PublicDnsNamespaceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicDnsNamespaceProperties");
        formatter.field("dns_properties", &self.dns_properties);
        formatter.finish()
    }
}
/// See [`PublicDnsNamespaceProperties`](crate::model::PublicDnsNamespaceProperties)
pub mod public_dns_namespace_properties {
    /// A builder for [`PublicDnsNamespaceProperties`](crate::model::PublicDnsNamespaceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_properties: std::option::Option<crate::model::PublicDnsPropertiesMutable>,
    }
    impl Builder {
        /// <p>DNS properties for the public DNS
        /// namespace.</p>
        pub fn dns_properties(mut self, input: crate::model::PublicDnsPropertiesMutable) -> Self {
            self.dns_properties = Some(input);
            self
        }
        /// <p>DNS properties for the public DNS
        /// namespace.</p>
        pub fn set_dns_properties(
            mut self,
            input: std::option::Option<crate::model::PublicDnsPropertiesMutable>,
        ) -> Self {
            self.dns_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicDnsNamespaceProperties`](crate::model::PublicDnsNamespaceProperties)
        pub fn build(self) -> crate::model::PublicDnsNamespaceProperties {
            crate::model::PublicDnsNamespaceProperties {
                dns_properties: self.dns_properties,
            }
        }
    }
}
impl PublicDnsNamespaceProperties {
    /// Creates a new builder-style object to manufacture [`PublicDnsNamespaceProperties`](crate::model::PublicDnsNamespaceProperties)
    pub fn builder() -> crate::model::public_dns_namespace_properties::Builder {
        crate::model::public_dns_namespace_properties::Builder::default()
    }
}

/// <p>DNS properties for the public DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicDnsPropertiesMutable {
    /// <p>Start of Authority (SOA) record for the
    /// hosted zone for the public DNS namespace.</p>
    pub soa: std::option::Option<crate::model::Soa>,
}
impl PublicDnsPropertiesMutable {
    /// <p>Start of Authority (SOA) record for the
    /// hosted zone for the public DNS namespace.</p>
    pub fn soa(&self) -> std::option::Option<&crate::model::Soa> {
        self.soa.as_ref()
    }
}
impl std::fmt::Debug for PublicDnsPropertiesMutable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicDnsPropertiesMutable");
        formatter.field("soa", &self.soa);
        formatter.finish()
    }
}
/// See [`PublicDnsPropertiesMutable`](crate::model::PublicDnsPropertiesMutable)
pub mod public_dns_properties_mutable {
    /// A builder for [`PublicDnsPropertiesMutable`](crate::model::PublicDnsPropertiesMutable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) soa: std::option::Option<crate::model::Soa>,
    }
    impl Builder {
        /// <p>Start of Authority (SOA) record for the
        /// hosted zone for the public DNS namespace.</p>
        pub fn soa(mut self, input: crate::model::Soa) -> Self {
            self.soa = Some(input);
            self
        }
        /// <p>Start of Authority (SOA) record for the
        /// hosted zone for the public DNS namespace.</p>
        pub fn set_soa(mut self, input: std::option::Option<crate::model::Soa>) -> Self {
            self.soa = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicDnsPropertiesMutable`](crate::model::PublicDnsPropertiesMutable)
        pub fn build(self) -> crate::model::PublicDnsPropertiesMutable {
            crate::model::PublicDnsPropertiesMutable { soa: self.soa }
        }
    }
}
impl PublicDnsPropertiesMutable {
    /// Creates a new builder-style object to manufacture [`PublicDnsPropertiesMutable`](crate::model::PublicDnsPropertiesMutable)
    pub fn builder() -> crate::model::public_dns_properties_mutable::Builder {
        crate::model::public_dns_properties_mutable::Builder::default()
    }
}

/// <p>DNS properties for the private DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsNamespaceProperties {
    /// <p>DNS properties for the private DNS
    /// namespace.</p>
    pub dns_properties: std::option::Option<crate::model::PrivateDnsPropertiesMutable>,
}
impl PrivateDnsNamespaceProperties {
    /// <p>DNS properties for the private DNS
    /// namespace.</p>
    pub fn dns_properties(
        &self,
    ) -> std::option::Option<&crate::model::PrivateDnsPropertiesMutable> {
        self.dns_properties.as_ref()
    }
}
impl std::fmt::Debug for PrivateDnsNamespaceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsNamespaceProperties");
        formatter.field("dns_properties", &self.dns_properties);
        formatter.finish()
    }
}
/// See [`PrivateDnsNamespaceProperties`](crate::model::PrivateDnsNamespaceProperties)
pub mod private_dns_namespace_properties {
    /// A builder for [`PrivateDnsNamespaceProperties`](crate::model::PrivateDnsNamespaceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_properties: std::option::Option<crate::model::PrivateDnsPropertiesMutable>,
    }
    impl Builder {
        /// <p>DNS properties for the private DNS
        /// namespace.</p>
        pub fn dns_properties(mut self, input: crate::model::PrivateDnsPropertiesMutable) -> Self {
            self.dns_properties = Some(input);
            self
        }
        /// <p>DNS properties for the private DNS
        /// namespace.</p>
        pub fn set_dns_properties(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsPropertiesMutable>,
        ) -> Self {
            self.dns_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsNamespaceProperties`](crate::model::PrivateDnsNamespaceProperties)
        pub fn build(self) -> crate::model::PrivateDnsNamespaceProperties {
            crate::model::PrivateDnsNamespaceProperties {
                dns_properties: self.dns_properties,
            }
        }
    }
}
impl PrivateDnsNamespaceProperties {
    /// Creates a new builder-style object to manufacture [`PrivateDnsNamespaceProperties`](crate::model::PrivateDnsNamespaceProperties)
    pub fn builder() -> crate::model::private_dns_namespace_properties::Builder {
        crate::model::private_dns_namespace_properties::Builder::default()
    }
}

/// <p>DNS properties for the private DNS
/// namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsPropertiesMutable {
    /// <p>Fields for the Start of Authority (SOA)
    /// record for the hosted zone for the private DNS namespace.</p>
    pub soa: std::option::Option<crate::model::Soa>,
}
impl PrivateDnsPropertiesMutable {
    /// <p>Fields for the Start of Authority (SOA)
    /// record for the hosted zone for the private DNS namespace.</p>
    pub fn soa(&self) -> std::option::Option<&crate::model::Soa> {
        self.soa.as_ref()
    }
}
impl std::fmt::Debug for PrivateDnsPropertiesMutable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsPropertiesMutable");
        formatter.field("soa", &self.soa);
        formatter.finish()
    }
}
/// See [`PrivateDnsPropertiesMutable`](crate::model::PrivateDnsPropertiesMutable)
pub mod private_dns_properties_mutable {
    /// A builder for [`PrivateDnsPropertiesMutable`](crate::model::PrivateDnsPropertiesMutable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) soa: std::option::Option<crate::model::Soa>,
    }
    impl Builder {
        /// <p>Fields for the Start of Authority (SOA)
        /// record for the hosted zone for the private DNS namespace.</p>
        pub fn soa(mut self, input: crate::model::Soa) -> Self {
            self.soa = Some(input);
            self
        }
        /// <p>Fields for the Start of Authority (SOA)
        /// record for the hosted zone for the private DNS namespace.</p>
        pub fn set_soa(mut self, input: std::option::Option<crate::model::Soa>) -> Self {
            self.soa = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsPropertiesMutable`](crate::model::PrivateDnsPropertiesMutable)
        pub fn build(self) -> crate::model::PrivateDnsPropertiesMutable {
            crate::model::PrivateDnsPropertiesMutable { soa: self.soa }
        }
    }
}
impl PrivateDnsPropertiesMutable {
    /// Creates a new builder-style object to manufacture [`PrivateDnsPropertiesMutable`](crate::model::PrivateDnsPropertiesMutable)
    pub fn builder() -> crate::model::private_dns_properties_mutable::Builder {
        crate::model::private_dns_properties_mutable::Builder::default()
    }
}
