// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAttributeGroupOutput {
    /// <p>The updated information of the attribute group.</p>
    pub attribute_group: std::option::Option<crate::model::AttributeGroup>,
}
impl UpdateAttributeGroupOutput {
    /// <p>The updated information of the attribute group.</p>
    pub fn attribute_group(&self) -> std::option::Option<&crate::model::AttributeGroup> {
        self.attribute_group.as_ref()
    }
}
impl std::fmt::Debug for UpdateAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAttributeGroupOutput");
        formatter.field("attribute_group", &self.attribute_group);
        formatter.finish()
    }
}
/// See [`UpdateAttributeGroupOutput`](crate::output::UpdateAttributeGroupOutput)
pub mod update_attribute_group_output {
    /// A builder for [`UpdateAttributeGroupOutput`](crate::output::UpdateAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_group: std::option::Option<crate::model::AttributeGroup>,
    }
    impl Builder {
        /// <p>The updated information of the attribute group.</p>
        pub fn attribute_group(mut self, input: crate::model::AttributeGroup) -> Self {
            self.attribute_group = Some(input);
            self
        }
        /// <p>The updated information of the attribute group.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<crate::model::AttributeGroup>,
        ) -> Self {
            self.attribute_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAttributeGroupOutput`](crate::output::UpdateAttributeGroupOutput)
        pub fn build(self) -> crate::output::UpdateAttributeGroupOutput {
            crate::output::UpdateAttributeGroupOutput {
                attribute_group: self.attribute_group,
            }
        }
    }
}
impl UpdateAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAttributeGroupOutput`](crate::output::UpdateAttributeGroupOutput)
    pub fn builder() -> crate::output::update_attribute_group_output::Builder {
        crate::output::update_attribute_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {
    /// <p>The updated information of the application.</p>
    pub application: std::option::Option<crate::model::Application>,
}
impl UpdateApplicationOutput {
    /// <p>The updated information of the application.</p>
    pub fn application(&self) -> std::option::Option<&crate::model::Application> {
        self.application.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::Application>,
    }
    impl Builder {
        /// <p>The updated information of the application.</p>
        pub fn application(mut self, input: crate::model::Application) -> Self {
            self.application = Some(input);
            self
        }
        /// <p>The updated information of the application.</p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::Application>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyncResourceOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>
    pub action_taken: std::option::Option<crate::model::SyncAction>,
}
impl SyncResourceOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>
    pub fn action_taken(&self) -> std::option::Option<&crate::model::SyncAction> {
        self.action_taken.as_ref()
    }
}
impl std::fmt::Debug for SyncResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyncResourceOutput");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("action_taken", &self.action_taken);
        formatter.finish()
    }
}
/// See [`SyncResourceOutput`](crate::output::SyncResourceOutput)
pub mod sync_resource_output {
    /// A builder for [`SyncResourceOutput`](crate::output::SyncResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) action_taken: std::option::Option<crate::model::SyncAction>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>
        pub fn action_taken(mut self, input: crate::model::SyncAction) -> Self {
            self.action_taken = Some(input);
            self
        }
        /// <p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>
        pub fn set_action_taken(
            mut self,
            input: std::option::Option<crate::model::SyncAction>,
        ) -> Self {
            self.action_taken = input;
            self
        }
        /// Consumes the builder and constructs a [`SyncResourceOutput`](crate::output::SyncResourceOutput)
        pub fn build(self) -> crate::output::SyncResourceOutput {
            crate::output::SyncResourceOutput {
                application_arn: self.application_arn,
                resource_arn: self.resource_arn,
                action_taken: self.action_taken,
            }
        }
    }
}
impl SyncResourceOutput {
    /// Creates a new builder-style object to manufacture [`SyncResourceOutput`](crate::output::SyncResourceOutput)
    pub fn builder() -> crate::output::sync_resource_output::Builder {
        crate::output::sync_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags on the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags on the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags on the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags on the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttributeGroupsOutput {
    /// <p>This list of attribute groups.</p>
    pub attribute_groups: std::option::Option<std::vec::Vec<crate::model::AttributeGroupSummary>>,
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAttributeGroupsOutput {
    /// <p>This list of attribute groups.</p>
    pub fn attribute_groups(&self) -> std::option::Option<&[crate::model::AttributeGroupSummary]> {
        self.attribute_groups.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAttributeGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttributeGroupsOutput");
        formatter.field("attribute_groups", &self.attribute_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAttributeGroupsOutput`](crate::output::ListAttributeGroupsOutput)
pub mod list_attribute_groups_output {
    /// A builder for [`ListAttributeGroupsOutput`](crate::output::ListAttributeGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_groups:
            std::option::Option<std::vec::Vec<crate::model::AttributeGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attribute_groups`.
        ///
        /// To override the contents of this collection use [`set_attribute_groups`](Self::set_attribute_groups).
        ///
        /// <p>This list of attribute groups.</p>
        pub fn attribute_groups(mut self, input: crate::model::AttributeGroupSummary) -> Self {
            let mut v = self.attribute_groups.unwrap_or_default();
            v.push(input);
            self.attribute_groups = Some(v);
            self
        }
        /// <p>This list of attribute groups.</p>
        pub fn set_attribute_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeGroupSummary>>,
        ) -> Self {
            self.attribute_groups = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttributeGroupsOutput`](crate::output::ListAttributeGroupsOutput)
        pub fn build(self) -> crate::output::ListAttributeGroupsOutput {
            crate::output::ListAttributeGroupsOutput {
                attribute_groups: self.attribute_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAttributeGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListAttributeGroupsOutput`](crate::output::ListAttributeGroupsOutput)
    pub fn builder() -> crate::output::list_attribute_groups_output::Builder {
        crate::output::list_attribute_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedResourcesOutput {
    /// <p>Information about the resources.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::ResourceInfo>>,
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedResourcesOutput {
    /// <p>Information about the resources.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::ResourceInfo]> {
        self.resources.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedResourcesOutput`](crate::output::ListAssociatedResourcesOutput)
pub mod list_associated_resources_output {
    /// A builder for [`ListAssociatedResourcesOutput`](crate::output::ListAssociatedResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::ResourceInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Information about the resources.</p>
        pub fn resources(mut self, input: crate::model::ResourceInfo) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>Information about the resources.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceInfo>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedResourcesOutput`](crate::output::ListAssociatedResourcesOutput)
        pub fn build(self) -> crate::output::ListAssociatedResourcesOutput {
            crate::output::ListAssociatedResourcesOutput {
                resources: self.resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedResourcesOutput`](crate::output::ListAssociatedResourcesOutput)
    pub fn builder() -> crate::output::list_associated_resources_output::Builder {
        crate::output::list_associated_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedAttributeGroupsOutput {
    /// <p>A list of attribute group IDs.</p>
    pub attribute_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedAttributeGroupsOutput {
    /// <p>A list of attribute group IDs.</p>
    pub fn attribute_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_groups.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedAttributeGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedAttributeGroupsOutput");
        formatter.field("attribute_groups", &self.attribute_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedAttributeGroupsOutput`](crate::output::ListAssociatedAttributeGroupsOutput)
pub mod list_associated_attribute_groups_output {
    /// A builder for [`ListAssociatedAttributeGroupsOutput`](crate::output::ListAssociatedAttributeGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attribute_groups`.
        ///
        /// To override the contents of this collection use [`set_attribute_groups`](Self::set_attribute_groups).
        ///
        /// <p>A list of attribute group IDs.</p>
        pub fn attribute_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_groups.unwrap_or_default();
            v.push(input.into());
            self.attribute_groups = Some(v);
            self
        }
        /// <p>A list of attribute group IDs.</p>
        pub fn set_attribute_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_groups = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedAttributeGroupsOutput`](crate::output::ListAssociatedAttributeGroupsOutput)
        pub fn build(self) -> crate::output::ListAssociatedAttributeGroupsOutput {
            crate::output::ListAssociatedAttributeGroupsOutput {
                attribute_groups: self.attribute_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedAttributeGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedAttributeGroupsOutput`](crate::output::ListAssociatedAttributeGroupsOutput)
    pub fn builder() -> crate::output::list_associated_attribute_groups_output::Builder {
        crate::output::list_associated_attribute_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>This list of applications.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsOutput {
    /// <p>This list of applications.</p>
    pub fn applications(&self) -> std::option::Option<&[crate::model::ApplicationSummary]> {
        self.applications.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("applications", &self.applications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applications:
            std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>This list of applications.</p>
        pub fn applications(mut self, input: crate::model::ApplicationSummary) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input);
            self.applications = Some(v);
            self
        }
        /// <p>This list of applications.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                applications: self.applications,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAttributeGroupOutput {
    /// <p>The identifier of the attribute group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the attribute group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the attribute group that the user provides.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
    pub attributes: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Key-value pairs associated with the attribute group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetAttributeGroupOutput {
    /// <p>The identifier of the attribute group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the attribute group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the attribute group that the user provides.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
    pub fn attributes(&self) -> std::option::Option<&str> {
        self.attributes.as_deref()
    }
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>Key-value pairs associated with the attribute group.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAttributeGroupOutput");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("attributes", &self.attributes);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetAttributeGroupOutput`](crate::output::GetAttributeGroupOutput)
pub mod get_attribute_group_output {
    /// A builder for [`GetAttributeGroupOutput`](crate::output::GetAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the attribute group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the attribute group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.attributes = Some(input.into());
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn set_attributes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs associated with the attribute group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs associated with the attribute group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAttributeGroupOutput`](crate::output::GetAttributeGroupOutput)
        pub fn build(self) -> crate::output::GetAttributeGroupOutput {
            crate::output::GetAttributeGroupOutput {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                attributes: self.attributes,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                tags: self.tags,
            }
        }
    }
}
impl GetAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetAttributeGroupOutput`](crate::output::GetAttributeGroupOutput)
    pub fn builder() -> crate::output::get_attribute_group_output::Builder {
        crate::output::get_attribute_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssociatedResourceOutput {
    /// <p>The resource associated with the application.</p>
    pub resource: std::option::Option<crate::model::Resource>,
}
impl GetAssociatedResourceOutput {
    /// <p>The resource associated with the application.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
}
impl std::fmt::Debug for GetAssociatedResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssociatedResourceOutput");
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}
/// See [`GetAssociatedResourceOutput`](crate::output::GetAssociatedResourceOutput)
pub mod get_associated_resource_output {
    /// A builder for [`GetAssociatedResourceOutput`](crate::output::GetAssociatedResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<crate::model::Resource>,
    }
    impl Builder {
        /// <p>The resource associated with the application.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource associated with the application.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssociatedResourceOutput`](crate::output::GetAssociatedResourceOutput)
        pub fn build(self) -> crate::output::GetAssociatedResourceOutput {
            crate::output::GetAssociatedResourceOutput {
                resource: self.resource,
            }
        }
    }
}
impl GetAssociatedResourceOutput {
    /// Creates a new builder-style object to manufacture [`GetAssociatedResourceOutput`](crate::output::GetAssociatedResourceOutput)
    pub fn builder() -> crate::output::get_associated_resource_output::Builder {
        crate::output::get_associated_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationOutput {
    /// <p>The identifier of the application.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of top-level resources that were registered as part of this application.</p>
    pub associated_resource_count: i32,
    /// <p>Key-value pairs associated with the application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The information about the integration of the application with other services, such as Resource Groups.</p>
    pub integrations: std::option::Option<crate::model::Integrations>,
}
impl GetApplicationOutput {
    /// <p>The identifier of the application.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The number of top-level resources that were registered as part of this application.</p>
    pub fn associated_resource_count(&self) -> i32 {
        self.associated_resource_count
    }
    /// <p>Key-value pairs associated with the application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The information about the integration of the application with other services, such as Resource Groups.</p>
    pub fn integrations(&self) -> std::option::Option<&crate::model::Integrations> {
        self.integrations.as_ref()
    }
}
impl std::fmt::Debug for GetApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationOutput");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("associated_resource_count", &self.associated_resource_count);
        formatter.field("tags", &self.tags);
        formatter.field("integrations", &self.integrations);
        formatter.finish()
    }
}
/// See [`GetApplicationOutput`](crate::output::GetApplicationOutput)
pub mod get_application_output {
    /// A builder for [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) associated_resource_count: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) integrations: std::option::Option<crate::model::Integrations>,
    }
    impl Builder {
        /// <p>The identifier of the application.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The number of top-level resources that were registered as part of this application.</p>
        pub fn associated_resource_count(mut self, input: i32) -> Self {
            self.associated_resource_count = Some(input);
            self
        }
        /// <p>The number of top-level resources that were registered as part of this application.</p>
        pub fn set_associated_resource_count(mut self, input: std::option::Option<i32>) -> Self {
            self.associated_resource_count = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs associated with the application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The information about the integration of the application with other services, such as Resource Groups.</p>
        pub fn integrations(mut self, input: crate::model::Integrations) -> Self {
            self.integrations = Some(input);
            self
        }
        /// <p>The information about the integration of the application with other services, such as Resource Groups.</p>
        pub fn set_integrations(
            mut self,
            input: std::option::Option<crate::model::Integrations>,
        ) -> Self {
            self.integrations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationOutput`](crate::output::GetApplicationOutput)
        pub fn build(self) -> crate::output::GetApplicationOutput {
            crate::output::GetApplicationOutput {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                associated_resource_count: self.associated_resource_count.unwrap_or_default(),
                tags: self.tags,
                integrations: self.integrations,
            }
        }
    }
}
impl GetApplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    pub fn builder() -> crate::output::get_application_output::Builder {
        crate::output::get_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DisassociateResourceOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceOutput");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`DisassociateResourceOutput`](crate::output::DisassociateResourceOutput)
pub mod disassociate_resource_output {
    /// A builder for [`DisassociateResourceOutput`](crate::output::DisassociateResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceOutput`](crate::output::DisassociateResourceOutput)
        pub fn build(self) -> crate::output::DisassociateResourceOutput {
            crate::output::DisassociateResourceOutput {
                application_arn: self.application_arn,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl DisassociateResourceOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResourceOutput`](crate::output::DisassociateResourceOutput)
    pub fn builder() -> crate::output::disassociate_resource_output::Builder {
        crate::output::disassociate_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAttributeGroupOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the attribute group.</p>
    pub attribute_group_arn: std::option::Option<std::string::String>,
}
impl DisassociateAttributeGroupOutput {
    /// <p>The Amazon resource name (ARN) that specifies the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the attribute group.</p>
    pub fn attribute_group_arn(&self) -> std::option::Option<&str> {
        self.attribute_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAttributeGroupOutput");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("attribute_group_arn", &self.attribute_group_arn);
        formatter.finish()
    }
}
/// See [`DisassociateAttributeGroupOutput`](crate::output::DisassociateAttributeGroupOutput)
pub mod disassociate_attribute_group_output {
    /// A builder for [`DisassociateAttributeGroupOutput`](crate::output::DisassociateAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) attribute_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group.</p>
        pub fn attribute_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group.</p>
        pub fn set_attribute_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAttributeGroupOutput`](crate::output::DisassociateAttributeGroupOutput)
        pub fn build(self) -> crate::output::DisassociateAttributeGroupOutput {
            crate::output::DisassociateAttributeGroupOutput {
                application_arn: self.application_arn,
                attribute_group_arn: self.attribute_group_arn,
            }
        }
    }
}
impl DisassociateAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateAttributeGroupOutput`](crate::output::DisassociateAttributeGroupOutput)
    pub fn builder() -> crate::output::disassociate_attribute_group_output::Builder {
        crate::output::disassociate_attribute_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAttributeGroupOutput {
    /// <p>Information about the deleted attribute group.</p>
    pub attribute_group: std::option::Option<crate::model::AttributeGroupSummary>,
}
impl DeleteAttributeGroupOutput {
    /// <p>Information about the deleted attribute group.</p>
    pub fn attribute_group(&self) -> std::option::Option<&crate::model::AttributeGroupSummary> {
        self.attribute_group.as_ref()
    }
}
impl std::fmt::Debug for DeleteAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAttributeGroupOutput");
        formatter.field("attribute_group", &self.attribute_group);
        formatter.finish()
    }
}
/// See [`DeleteAttributeGroupOutput`](crate::output::DeleteAttributeGroupOutput)
pub mod delete_attribute_group_output {
    /// A builder for [`DeleteAttributeGroupOutput`](crate::output::DeleteAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_group: std::option::Option<crate::model::AttributeGroupSummary>,
    }
    impl Builder {
        /// <p>Information about the deleted attribute group.</p>
        pub fn attribute_group(mut self, input: crate::model::AttributeGroupSummary) -> Self {
            self.attribute_group = Some(input);
            self
        }
        /// <p>Information about the deleted attribute group.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<crate::model::AttributeGroupSummary>,
        ) -> Self {
            self.attribute_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttributeGroupOutput`](crate::output::DeleteAttributeGroupOutput)
        pub fn build(self) -> crate::output::DeleteAttributeGroupOutput {
            crate::output::DeleteAttributeGroupOutput {
                attribute_group: self.attribute_group,
            }
        }
    }
}
impl DeleteAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAttributeGroupOutput`](crate::output::DeleteAttributeGroupOutput)
    pub fn builder() -> crate::output::delete_attribute_group_output::Builder {
        crate::output::delete_attribute_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {
    /// <p>Information about the deleted application.</p>
    pub application: std::option::Option<crate::model::ApplicationSummary>,
}
impl DeleteApplicationOutput {
    /// <p>Information about the deleted application.</p>
    pub fn application(&self) -> std::option::Option<&crate::model::ApplicationSummary> {
        self.application.as_ref()
    }
}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::ApplicationSummary>,
    }
    impl Builder {
        /// <p>Information about the deleted application.</p>
        pub fn application(mut self, input: crate::model::ApplicationSummary) -> Self {
            self.application = Some(input);
            self
        }
        /// <p>Information about the deleted application.</p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::ApplicationSummary>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAttributeGroupOutput {
    /// <p>Information about the attribute group.</p>
    pub attribute_group: std::option::Option<crate::model::AttributeGroup>,
}
impl CreateAttributeGroupOutput {
    /// <p>Information about the attribute group.</p>
    pub fn attribute_group(&self) -> std::option::Option<&crate::model::AttributeGroup> {
        self.attribute_group.as_ref()
    }
}
impl std::fmt::Debug for CreateAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAttributeGroupOutput");
        formatter.field("attribute_group", &self.attribute_group);
        formatter.finish()
    }
}
/// See [`CreateAttributeGroupOutput`](crate::output::CreateAttributeGroupOutput)
pub mod create_attribute_group_output {
    /// A builder for [`CreateAttributeGroupOutput`](crate::output::CreateAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_group: std::option::Option<crate::model::AttributeGroup>,
    }
    impl Builder {
        /// <p>Information about the attribute group.</p>
        pub fn attribute_group(mut self, input: crate::model::AttributeGroup) -> Self {
            self.attribute_group = Some(input);
            self
        }
        /// <p>Information about the attribute group.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<crate::model::AttributeGroup>,
        ) -> Self {
            self.attribute_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAttributeGroupOutput`](crate::output::CreateAttributeGroupOutput)
        pub fn build(self) -> crate::output::CreateAttributeGroupOutput {
            crate::output::CreateAttributeGroupOutput {
                attribute_group: self.attribute_group,
            }
        }
    }
}
impl CreateAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateAttributeGroupOutput`](crate::output::CreateAttributeGroupOutput)
    pub fn builder() -> crate::output::create_attribute_group_output::Builder {
        crate::output::create_attribute_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>Information about the application.</p>
    pub application: std::option::Option<crate::model::Application>,
}
impl CreateApplicationOutput {
    /// <p>Information about the application.</p>
    pub fn application(&self) -> std::option::Option<&crate::model::Application> {
        self.application.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("application", &self.application);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<crate::model::Application>,
    }
    impl Builder {
        /// <p>Information about the application.</p>
        pub fn application(mut self, input: crate::model::Application) -> Self {
            self.application = Some(input);
            self
        }
        /// <p>Information about the application.</p>
        pub fn set_application(
            mut self,
            input: std::option::Option<crate::model::Application>,
        ) -> Self {
            self.application = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                application: self.application,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceOutput {
    /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl AssociateResourceOutput {
    /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceOutput");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`AssociateResourceOutput`](crate::output::AssociateResourceOutput)
pub mod associate_resource_output {
    /// A builder for [`AssociateResourceOutput`](crate::output::AssociateResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceOutput`](crate::output::AssociateResourceOutput)
        pub fn build(self) -> crate::output::AssociateResourceOutput {
            crate::output::AssociateResourceOutput {
                application_arn: self.application_arn,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl AssociateResourceOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResourceOutput`](crate::output::AssociateResourceOutput)
    pub fn builder() -> crate::output::associate_resource_output::Builder {
        crate::output::associate_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAttributeGroupOutput {
    /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.</p>
    pub attribute_group_arn: std::option::Option<std::string::String>,
}
impl AssociateAttributeGroupOutput {
    /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.</p>
    pub fn attribute_group_arn(&self) -> std::option::Option<&str> {
        self.attribute_group_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateAttributeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAttributeGroupOutput");
        formatter.field("application_arn", &self.application_arn);
        formatter.field("attribute_group_arn", &self.attribute_group_arn);
        formatter.finish()
    }
}
/// See [`AssociateAttributeGroupOutput`](crate::output::AssociateAttributeGroupOutput)
pub mod associate_attribute_group_output {
    /// A builder for [`AssociateAttributeGroupOutput`](crate::output::AssociateAttributeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) attribute_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.</p>
        pub fn attribute_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.</p>
        pub fn set_attribute_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAttributeGroupOutput`](crate::output::AssociateAttributeGroupOutput)
        pub fn build(self) -> crate::output::AssociateAttributeGroupOutput {
            crate::output::AssociateAttributeGroupOutput {
                application_arn: self.application_arn,
                attribute_group_arn: self.attribute_group_arn,
            }
        }
    }
}
impl AssociateAttributeGroupOutput {
    /// Creates a new builder-style object to manufacture [`AssociateAttributeGroupOutput`](crate::output::AssociateAttributeGroupOutput)
    pub fn builder() -> crate::output::associate_attribute_group_output::Builder {
        crate::output::associate_attribute_group_output::Builder::default()
    }
}
