// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Service Catalog App Registry
///
/// Client for invoking operations on AWS Service Catalog App Registry. Each operation on AWS Service Catalog App Registry is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_servicecatalogappregistry::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_servicecatalogappregistry::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_servicecatalogappregistry::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateAttributeGroup`](crate::client::fluent_builders::AssociateAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::AssociateAttributeGroup::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::AssociateAttributeGroup::set_application): <p>The name or ID of the application.</p>
    ///   - [`attribute_group(impl Into<String>)`](crate::client::fluent_builders::AssociateAttributeGroup::attribute_group) / [`set_attribute_group(Option<String>)`](crate::client::fluent_builders::AssociateAttributeGroup::set_attribute_group): <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
    /// - On success, responds with [`AssociateAttributeGroupOutput`](crate::output::AssociateAttributeGroupOutput) with field(s):
    ///   - [`application_arn(Option<String>)`](crate::output::AssociateAttributeGroupOutput::application_arn): <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    ///   - [`attribute_group_arn(Option<String>)`](crate::output::AssociateAttributeGroupOutput::attribute_group_arn): <p>The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.</p>
    /// - On failure, responds with [`SdkError<AssociateAttributeGroupError>`](crate::error::AssociateAttributeGroupError)
    pub fn associate_attribute_group(&self) -> fluent_builders::AssociateAttributeGroup<C, M, R> {
        fluent_builders::AssociateAttributeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResource`](crate::client::fluent_builders::AssociateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::AssociateResource::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::AssociateResource::set_application): <p>The name or ID of the application.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::AssociateResource::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::AssociateResource::set_resource_type): <p>The type of resource of which the application will be associated.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::AssociateResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::AssociateResource::set_resource): <p>The name or ID of the resource of which the application will be associated.</p>
    /// - On success, responds with [`AssociateResourceOutput`](crate::output::AssociateResourceOutput) with field(s):
    ///   - [`application_arn(Option<String>)`](crate::output::AssociateResourceOutput::application_arn): <p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::AssociateResourceOutput::resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    /// - On failure, responds with [`SdkError<AssociateResourceError>`](crate::error::AssociateResourceError)
    pub fn associate_resource(&self) -> fluent_builders::AssociateResource<C, M, R> {
        fluent_builders::AssociateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>The description of the application.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>Key-value pairs you can use to associate with the application.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_client_token): <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application(Option<Application>)`](crate::output::CreateApplicationOutput::application): <p>Information about the application.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAttributeGroup`](crate::client::fluent_builders::CreateAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAttributeGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAttributeGroup::set_name): <p>The name of the attribute group.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAttributeGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAttributeGroup::set_description): <p>The description of the attribute group that the user provides.</p>
    ///   - [`attributes(impl Into<String>)`](crate::client::fluent_builders::CreateAttributeGroup::attributes) / [`set_attributes(Option<String>)`](crate::client::fluent_builders::CreateAttributeGroup::set_attributes): <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAttributeGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAttributeGroup::set_tags): <p>Key-value pairs you can use to associate with the attribute group.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAttributeGroup::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAttributeGroup::set_client_token): <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
    /// - On success, responds with [`CreateAttributeGroupOutput`](crate::output::CreateAttributeGroupOutput) with field(s):
    ///   - [`attribute_group(Option<AttributeGroup>)`](crate::output::CreateAttributeGroupOutput::attribute_group): <p>Information about the attribute group.</p>
    /// - On failure, responds with [`SdkError<CreateAttributeGroupError>`](crate::error::CreateAttributeGroupError)
    pub fn create_attribute_group(&self) -> fluent_builders::CreateAttributeGroup<C, M, R> {
        fluent_builders::CreateAttributeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application): <p>The name or ID of the application.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput) with field(s):
    ///   - [`application(Option<ApplicationSummary>)`](crate::output::DeleteApplicationOutput::application): <p>Information about the deleted application.</p>
    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAttributeGroup`](crate::client::fluent_builders::DeleteAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_group(impl Into<String>)`](crate::client::fluent_builders::DeleteAttributeGroup::attribute_group) / [`set_attribute_group(Option<String>)`](crate::client::fluent_builders::DeleteAttributeGroup::set_attribute_group): <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
    /// - On success, responds with [`DeleteAttributeGroupOutput`](crate::output::DeleteAttributeGroupOutput) with field(s):
    ///   - [`attribute_group(Option<AttributeGroupSummary>)`](crate::output::DeleteAttributeGroupOutput::attribute_group): <p>Information about the deleted attribute group.</p>
    /// - On failure, responds with [`SdkError<DeleteAttributeGroupError>`](crate::error::DeleteAttributeGroupError)
    pub fn delete_attribute_group(&self) -> fluent_builders::DeleteAttributeGroup<C, M, R> {
        fluent_builders::DeleteAttributeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAttributeGroup`](crate::client::fluent_builders::DisassociateAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::DisassociateAttributeGroup::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::DisassociateAttributeGroup::set_application): <p>The name or ID of the application.</p>
    ///   - [`attribute_group(impl Into<String>)`](crate::client::fluent_builders::DisassociateAttributeGroup::attribute_group) / [`set_attribute_group(Option<String>)`](crate::client::fluent_builders::DisassociateAttributeGroup::set_attribute_group): <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
    /// - On success, responds with [`DisassociateAttributeGroupOutput`](crate::output::DisassociateAttributeGroupOutput) with field(s):
    ///   - [`application_arn(Option<String>)`](crate::output::DisassociateAttributeGroupOutput::application_arn): <p>The Amazon resource name (ARN) that specifies the application.</p>
    ///   - [`attribute_group_arn(Option<String>)`](crate::output::DisassociateAttributeGroupOutput::attribute_group_arn): <p>The Amazon resource name (ARN) that specifies the attribute group.</p>
    /// - On failure, responds with [`SdkError<DisassociateAttributeGroupError>`](crate::error::DisassociateAttributeGroupError)
    pub fn disassociate_attribute_group(
        &self,
    ) -> fluent_builders::DisassociateAttributeGroup<C, M, R> {
        fluent_builders::DisassociateAttributeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResource`](crate::client::fluent_builders::DisassociateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::DisassociateResource::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::DisassociateResource::set_application): <p>The name or ID of the application.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::DisassociateResource::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::DisassociateResource::set_resource_type): <p>The type of the resource that is being disassociated.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::DisassociateResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::DisassociateResource::set_resource): <p>The name or ID of the resource.</p>
    /// - On success, responds with [`DisassociateResourceOutput`](crate::output::DisassociateResourceOutput) with field(s):
    ///   - [`application_arn(Option<String>)`](crate::output::DisassociateResourceOutput::application_arn): <p>The Amazon resource name (ARN) that specifies the application.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DisassociateResourceOutput::resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    /// - On failure, responds with [`SdkError<DisassociateResourceError>`](crate::error::DisassociateResourceError)
    pub fn disassociate_resource(&self) -> fluent_builders::DisassociateResource<C, M, R> {
        fluent_builders::DisassociateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplication`](crate::client::fluent_builders::GetApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::GetApplication::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::GetApplication::set_application): <p>The name or ID of the application.</p>
    /// - On success, responds with [`GetApplicationOutput`](crate::output::GetApplicationOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetApplicationOutput::id): <p>The identifier of the application.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetApplicationOutput::arn): <p>The Amazon resource name (ARN) that specifies the application across services.</p>
    ///   - [`name(Option<String>)`](crate::output::GetApplicationOutput::name): <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    ///   - [`description(Option<String>)`](crate::output::GetApplicationOutput::description): <p>The description of the application.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::GetApplicationOutput::creation_time): <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
    ///   - [`last_update_time(Option<DateTime>)`](crate::output::GetApplicationOutput::last_update_time): <p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
    ///   - [`associated_resource_count(i32)`](crate::output::GetApplicationOutput::associated_resource_count): <p>The number of top-level resources that were registered as part of this application.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetApplicationOutput::tags): <p>Key-value pairs associated with the application.</p>
    ///   - [`integrations(Option<Integrations>)`](crate::output::GetApplicationOutput::integrations): <p>The information about the integration of the application with other services, such as Resource Groups.</p>
    /// - On failure, responds with [`SdkError<GetApplicationError>`](crate::error::GetApplicationError)
    pub fn get_application(&self) -> fluent_builders::GetApplication<C, M, R> {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssociatedResource`](crate::client::fluent_builders::GetAssociatedResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::GetAssociatedResource::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::GetAssociatedResource::set_application): <p>The name or ID of the application.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::GetAssociatedResource::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::GetAssociatedResource::set_resource_type): <p>The type of resource associated with the application.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::GetAssociatedResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::GetAssociatedResource::set_resource): <p>The name or ID of the resource associated with the application.</p>
    /// - On success, responds with [`GetAssociatedResourceOutput`](crate::output::GetAssociatedResourceOutput) with field(s):
    ///   - [`resource(Option<Resource>)`](crate::output::GetAssociatedResourceOutput::resource): <p>The resource associated with the application.</p>
    /// - On failure, responds with [`SdkError<GetAssociatedResourceError>`](crate::error::GetAssociatedResourceError)
    pub fn get_associated_resource(&self) -> fluent_builders::GetAssociatedResource<C, M, R> {
        fluent_builders::GetAssociatedResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAttributeGroup`](crate::client::fluent_builders::GetAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_group(impl Into<String>)`](crate::client::fluent_builders::GetAttributeGroup::attribute_group) / [`set_attribute_group(Option<String>)`](crate::client::fluent_builders::GetAttributeGroup::set_attribute_group): <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
    /// - On success, responds with [`GetAttributeGroupOutput`](crate::output::GetAttributeGroupOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::GetAttributeGroupOutput::id): <p>The identifier of the attribute group.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetAttributeGroupOutput::arn): <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
    ///   - [`name(Option<String>)`](crate::output::GetAttributeGroupOutput::name): <p>The name of the attribute group.</p>
    ///   - [`description(Option<String>)`](crate::output::GetAttributeGroupOutput::description): <p>The description of the attribute group that the user provides.</p>
    ///   - [`attributes(Option<String>)`](crate::output::GetAttributeGroupOutput::attributes): <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::GetAttributeGroupOutput::creation_time): <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
    ///   - [`last_update_time(Option<DateTime>)`](crate::output::GetAttributeGroupOutput::last_update_time): <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetAttributeGroupOutput::tags): <p>Key-value pairs associated with the attribute group.</p>
    /// - On failure, responds with [`SdkError<GetAttributeGroupError>`](crate::error::GetAttributeGroupError)
    pub fn get_attribute_group(&self) -> fluent_builders::GetAttributeGroup<C, M, R> {
        fluent_builders::GetAttributeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApplications::set_max_results): <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`applications(Option<Vec<ApplicationSummary>>)`](crate::output::ListApplicationsOutput::applications): <p>This list of applications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedAttributeGroups`](crate::client::fluent_builders::ListAssociatedAttributeGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociatedAttributeGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::set_application): <p>The name or ID of the application.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::set_next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociatedAttributeGroups::set_max_results): <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
    /// - On success, responds with [`ListAssociatedAttributeGroupsOutput`](crate::output::ListAssociatedAttributeGroupsOutput) with field(s):
    ///   - [`attribute_groups(Option<Vec<String>>)`](crate::output::ListAssociatedAttributeGroupsOutput::attribute_groups): <p>A list of attribute group IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedAttributeGroupsOutput::next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    /// - On failure, responds with [`SdkError<ListAssociatedAttributeGroupsError>`](crate::error::ListAssociatedAttributeGroupsError)
    pub fn list_associated_attribute_groups(
        &self,
    ) -> fluent_builders::ListAssociatedAttributeGroups<C, M, R> {
        fluent_builders::ListAssociatedAttributeGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedResources`](crate::client::fluent_builders::ListAssociatedResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociatedResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedResources::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::ListAssociatedResources::set_application): <p>The name or ID of the application.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedResources::set_next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociatedResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociatedResources::set_max_results): <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
    /// - On success, responds with [`ListAssociatedResourcesOutput`](crate::output::ListAssociatedResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<ResourceInfo>>)`](crate::output::ListAssociatedResourcesOutput::resources): <p>Information about the resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedResourcesOutput::next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    /// - On failure, responds with [`SdkError<ListAssociatedResourcesError>`](crate::error::ListAssociatedResourcesError)
    pub fn list_associated_resources(&self) -> fluent_builders::ListAssociatedResources<C, M, R> {
        fluent_builders::ListAssociatedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttributeGroups`](crate::client::fluent_builders::ListAttributeGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttributeGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttributeGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttributeGroups::set_next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttributeGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttributeGroups::set_max_results): <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
    /// - On success, responds with [`ListAttributeGroupsOutput`](crate::output::ListAttributeGroupsOutput) with field(s):
    ///   - [`attribute_groups(Option<Vec<AttributeGroupSummary>>)`](crate::output::ListAttributeGroupsOutput::attribute_groups): <p>This list of attribute groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttributeGroupsOutput::next_token): <p>The token to use to get the next page of results after a previous API call. </p>
    /// - On failure, responds with [`SdkError<ListAttributeGroupsError>`](crate::error::ListAttributeGroupsError)
    pub fn list_attribute_groups(&self) -> fluent_builders::ListAttributeGroups<C, M, R> {
        fluent_builders::ListAttributeGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags on the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SyncResource`](crate::client::fluent_builders::SyncResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::SyncResource::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::SyncResource::set_resource_type): <p>The type of resource of which the application will be associated.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::SyncResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::SyncResource::set_resource): <p>An entity you can work with and specify with a name or ID. Examples include an Amazon EC2 instance, an Amazon Web Services CloudFormation stack, or an Amazon S3 bucket.</p>
    /// - On success, responds with [`SyncResourceOutput`](crate::output::SyncResourceOutput) with field(s):
    ///   - [`application_arn(Option<String>)`](crate::output::SyncResourceOutput::application_arn): <p>The Amazon resource name (ARN) that specifies the application.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::SyncResourceOutput::resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    ///   - [`action_taken(Option<SyncAction>)`](crate::output::SyncResourceOutput::action_taken): <p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>
    /// - On failure, responds with [`SdkError<SyncResourceError>`](crate::error::SyncResourceError)
    pub fn sync_resource(&self) -> fluent_builders::SyncResource<C, M, R> {
        fluent_builders::SyncResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The new or modified tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon resource name (ARN) that specifies the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of the tag keys to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application) / [`set_application(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application): <p>The name or ID of the application that will be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_name): <p>The new name of the application. The name must be unique in the region in which you are updating the application.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>The new description of the application.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`application(Option<Application>)`](crate::output::UpdateApplicationOutput::application): <p>The updated information of the application.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAttributeGroup`](crate::client::fluent_builders::UpdateAttributeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_group(impl Into<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::attribute_group) / [`set_attribute_group(Option<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::set_attribute_group): <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::set_name): <p>The new name of the attribute group. The name must be unique in the region in which you are updating the attribute group.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::set_description): <p>The description of the attribute group that the user provides.</p>
    ///   - [`attributes(impl Into<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::attributes) / [`set_attributes(Option<String>)`](crate::client::fluent_builders::UpdateAttributeGroup::set_attributes): <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
    /// - On success, responds with [`UpdateAttributeGroupOutput`](crate::output::UpdateAttributeGroupOutput) with field(s):
    ///   - [`attribute_group(Option<AttributeGroup>)`](crate::output::UpdateAttributeGroupOutput::attribute_group): <p>The updated information of the attribute group.</p>
    /// - On failure, responds with [`SdkError<UpdateAttributeGroupError>`](crate::error::UpdateAttributeGroupError)
    pub fn update_attribute_group(&self) -> fluent_builders::UpdateAttributeGroup<C, M, R> {
        fluent_builders::UpdateAttributeGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAttributeGroup`.
    ///
    /// <p>Associates an attribute group with an application to augment the application's metadata with the group's attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_attribute_group_input::Builder,
    }
    impl<C, M, R> AssociateAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAttributeGroupInputOperationOutputAlias,
                crate::output::AssociateAttributeGroupOutput,
                crate::error::AssociateAttributeGroupError,
                crate::input::AssociateAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn attribute_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_group(input.into());
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResource`.
    ///
    /// <p>Associates a resource with an application. Both the resource and the application can be specified either by ID or name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resource_input::Builder,
    }
    impl<C, M, R> AssociateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResourceInputOperationOutputAlias,
                crate::output::AssociateResourceOutput,
                crate::error::AssociateResourceError,
                crate::input::AssociateResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The type of resource of which the application will be associated.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource of which the application will be associated.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The name or ID of the resource of which the application will be associated.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The name or ID of the resource of which the application will be associated.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs you can use to associate with the application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Key-value pairs you can use to associate with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAttributeGroup`.
    ///
    /// <p>Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_attribute_group_input::Builder,
    }
    impl<C, M, R> CreateAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAttributeGroupInputOperationOutputAlias,
                crate::output::CreateAttributeGroupOutput,
                crate::error::CreateAttributeGroupError,
                crate::input::CreateAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the attribute group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes(input.into());
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn set_attributes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs you can use to associate with the attribute group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Key-value pairs you can use to associate with the attribute group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an application that is specified either by its application ID or name. All associated attribute groups and resources must be disassociated from it before deleting an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttributeGroup`.
    ///
    /// <p>Deletes an attribute group, specified either by its attribute group ID or name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_attribute_group_input::Builder,
    }
    impl<C, M, R> DeleteAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAttributeGroupInputOperationOutputAlias,
                crate::output::DeleteAttributeGroupOutput,
                crate::error::DeleteAttributeGroupError,
                crate::input::DeleteAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn attribute_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_group(input.into());
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAttributeGroup`.
    ///
    /// <p>Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata. This operation reverts <code>AssociateAttributeGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_attribute_group_input::Builder,
    }
    impl<C, M, R> DisassociateAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAttributeGroupInputOperationOutputAlias,
                crate::output::DisassociateAttributeGroupOutput,
                crate::error::DisassociateAttributeGroupError,
                crate::input::DisassociateAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn attribute_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_group(input.into());
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResource`.
    ///
    /// <p>Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resource_input::Builder,
    }
    impl<C, M, R> DisassociateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResourceInputOperationOutputAlias,
                crate::output::DisassociateResourceOutput,
                crate::error::DisassociateResourceError,
                crate::input::DisassociateResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The type of the resource that is being disassociated.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resource that is being disassociated.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The name or ID of the resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The name or ID of the resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Retrieves metadata information about one of your applications. The application can be specified either by its unique ID or by its name (which is unique within one account in one region at a given point in time). Specify by ID in automated workflows if you want to make sure that the exact same application is returned or a <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_input::Builder,
    }
    impl<C, M, R> GetApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationInputOperationOutputAlias,
                crate::output::GetApplicationOutput,
                crate::error::GetApplicationError,
                crate::input::GetApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssociatedResource`.
    ///
    /// <p>Gets the resource associated with the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssociatedResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_associated_resource_input::Builder,
    }
    impl<C, M, R> GetAssociatedResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssociatedResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssociatedResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssociatedResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssociatedResourceInputOperationOutputAlias,
                crate::output::GetAssociatedResourceOutput,
                crate::error::GetAssociatedResourceError,
                crate::input::GetAssociatedResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The type of resource associated with the application.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource associated with the application.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The name or ID of the resource associated with the application.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The name or ID of the resource associated with the application.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttributeGroup`.
    ///
    /// <p>Retrieves an attribute group, either by its name or its ID. The attribute group can be specified either by its unique ID or by its name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attribute_group_input::Builder,
    }
    impl<C, M, R> GetAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttributeGroupInputOperationOutputAlias,
                crate::output::GetAttributeGroupOutput,
                crate::error::GetAttributeGroupError,
                crate::input::GetAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn attribute_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_group(input.into());
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Retrieves a list of all of your applications. Results are paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator<C, M, R> {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedAttributeGroups`.
    ///
    /// <p>Lists all attribute groups that are associated with specified application. Results are paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedAttributeGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_attribute_groups_input::Builder,
    }
    impl<C, M, R> ListAssociatedAttributeGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedAttributeGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedAttributeGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedAttributeGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedAttributeGroupsInputOperationOutputAlias,
                crate::output::ListAssociatedAttributeGroupsOutput,
                crate::error::ListAssociatedAttributeGroupsError,
                crate::input::ListAssociatedAttributeGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociatedAttributeGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAssociatedAttributeGroupsPaginator<C, M, R> {
            crate::paginator::ListAssociatedAttributeGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedResources`.
    ///
    /// <p>Lists all resources that are associated with specified application. Results are paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_resources_input::Builder,
    }
    impl<C, M, R> ListAssociatedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedResourcesInputOperationOutputAlias,
                crate::output::ListAssociatedResourcesOutput,
                crate::error::ListAssociatedResourcesError,
                crate::input::ListAssociatedResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociatedResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssociatedResourcesPaginator<C, M, R> {
            crate::paginator::ListAssociatedResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name or ID of the application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttributeGroups`.
    ///
    /// <p>Lists all attribute groups which you have access to. Results are paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttributeGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attribute_groups_input::Builder,
    }
    impl<C, M, R> ListAttributeGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttributeGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttributeGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttributeGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttributeGroupsInputOperationOutputAlias,
                crate::output::ListAttributeGroupsOutput,
                crate::error::ListAttributeGroupsError,
                crate::input::ListAttributeGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttributeGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttributeGroupsPaginator<C, M, R> {
            crate::paginator::ListAttributeGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all of the tags on the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SyncResource`.
    ///
    /// <p>Syncs the resource with current AppRegistry records.</p>
    /// <p>Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the resource's AppRegistry system tags if it does not associate with the application. The caller must have permissions to read and update the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SyncResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::sync_resource_input::Builder,
    }
    impl<C, M, R> SyncResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SyncResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SyncResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::SyncResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SyncResourceInputOperationOutputAlias,
                crate::output::SyncResourceOutput,
                crate::error::SyncResourceError,
                crate::input::SyncResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of resource of which the application will be associated.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource of which the application will be associated.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>An entity you can work with and specify with a name or ID. Examples include an Amazon EC2 instance, an Amazon Web Services CloudFormation stack, or an Amazon S3 bucket.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>An entity you can work with and specify with a name or ID. Examples include an Amazon EC2 instance, an Amazon Web Services CloudFormation stack, or an Amazon S3 bucket.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified resource.</p>
    /// <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.</p>
    /// <p>This operation returns an empty response if the call was successful.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    /// <p>This operation returns an empty response if the call was successful.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of the tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates an existing application with new attributes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the application that will be updated.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The name or ID of the application that will be updated.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The new name of the application. The name must be unique in the region in which you are updating the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name of the application. The name must be unique in the region in which you are updating the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAttributeGroup`.
    ///
    /// <p>Updates an existing attribute group with new details. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAttributeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_attribute_group_input::Builder,
    }
    impl<C, M, R> UpdateAttributeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAttributeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAttributeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAttributeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAttributeGroupInputOperationOutputAlias,
                crate::output::UpdateAttributeGroupOutput,
                crate::error::UpdateAttributeGroupError,
                crate::input::UpdateAttributeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn attribute_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_group(input.into());
            self
        }
        /// <p>The name or ID of the attribute group that holds the attributes to describe the application.</p>
        pub fn set_attribute_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_group(input);
            self
        }
        /// <p>The new name of the attribute group. The name must be unique in the region in which you are updating the attribute group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name of the attribute group. The name must be unique in the region in which you are updating the attribute group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes(input.into());
            self
        }
        /// <p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>
        pub fn set_attributes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
