// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a Amazon Web Services Service Catalog AppRegistry attribute group that is rich metadata which describes an application and its components.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeGroup {
    /// <p>The globally unique attribute group identifier of the attribute group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the attribute group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the attribute group that the user provides.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Key-value pairs you can use to associate with the attribute group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for AttributeGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeGroup");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AttributeGroup`](crate::model::AttributeGroup)
pub mod attribute_group {
    /// A builder for [`AttributeGroup`](crate::model::AttributeGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The globally unique attribute group identifier of the attribute group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The globally unique attribute group identifier of the attribute group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs you can use to associate with the attribute group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs you can use to associate with the attribute group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeGroup`](crate::model::AttributeGroup)
        pub fn build(self) -> crate::model::AttributeGroup {
            crate::model::AttributeGroup {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                tags: self.tags,
            }
        }
    }
}
impl AttributeGroup {
    /// Creates a new builder-style object to manufacture [`AttributeGroup`](crate::model::AttributeGroup)
    pub fn builder() -> crate::model::attribute_group::Builder {
        crate::model::attribute_group::Builder::default()
    }
}

/// <p>Represents a Amazon Web Services Service Catalog AppRegistry application that is the top-level node in a hierarchy of related
/// cloud resource abstractions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Application {
    /// <p>The identifier of the application.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Key-value pairs you can use to associate with the application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Application {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Application");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Application`](crate::model::Application)
pub mod application {
    /// A builder for [`Application`](crate::model::Application)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the application.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs you can use to associate with the application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs you can use to associate with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Application`](crate::model::Application)
        pub fn build(self) -> crate::model::Application {
            crate::model::Application {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                tags: self.tags,
            }
        }
    }
}
impl Application {
    /// Creates a new builder-style object to manufacture [`Application`](crate::model::Application)
    pub fn builder() -> crate::model::application::Builder {
        crate::model::application::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SyncAction {
    #[allow(missing_docs)] // documentation missing in model
    NoAction,
    #[allow(missing_docs)] // documentation missing in model
    StartSync,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SyncAction {
    fn from(s: &str) -> Self {
        match s {
            "NO_ACTION" => SyncAction::NoAction,
            "START_SYNC" => SyncAction::StartSync,
            other => SyncAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SyncAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SyncAction::from(s))
    }
}
impl SyncAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SyncAction::NoAction => "NO_ACTION",
            SyncAction::StartSync => "START_SYNC",
            SyncAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_ACTION", "START_SYNC"]
    }
}
impl AsRef<str> for SyncAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    CfnStack,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "CFN_STACK" => ResourceType::CfnStack,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::CfnStack => "CFN_STACK",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CFN_STACK"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeGroupSummary {
    /// <p>The globally unique attribute group identifier of the attribute group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the attribute group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the attribute group that the user provides.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AttributeGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeGroupSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`AttributeGroupSummary`](crate::model::AttributeGroupSummary)
pub mod attribute_group_summary {
    /// A builder for [`AttributeGroupSummary`](crate::model::AttributeGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The globally unique attribute group identifier of the attribute group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The globally unique attribute group identifier of the attribute group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the attribute group that the user provides.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeGroupSummary`](crate::model::AttributeGroupSummary)
        pub fn build(self) -> crate::model::AttributeGroupSummary {
            crate::model::AttributeGroupSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl AttributeGroupSummary {
    /// Creates a new builder-style object to manufacture [`AttributeGroupSummary`](crate::model::AttributeGroupSummary)
    pub fn builder() -> crate::model::attribute_group_summary::Builder {
        crate::model::attribute_group_summary::Builder::default()
    }
}

/// <p>The information about the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInfo {
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the resource across services.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInfo");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ResourceInfo`](crate::model::ResourceInfo)
pub mod resource_info {
    /// A builder for [`ResourceInfo`](crate::model::ResourceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the resource across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInfo`](crate::model::ResourceInfo)
        pub fn build(self) -> crate::model::ResourceInfo {
            crate::model::ResourceInfo {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl ResourceInfo {
    /// Creates a new builder-style object to manufacture [`ResourceInfo`](crate::model::ResourceInfo)
    pub fn builder() -> crate::model::resource_info::Builder {
        crate::model::resource_info::Builder::default()
    }
}

/// <p>Summary of a Amazon Web Services Service Catalog AppRegistry application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSummary {
    /// <p>The identifier of the application.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`ApplicationSummary`](crate::model::ApplicationSummary)
pub mod application_summary {
    /// A builder for [`ApplicationSummary`](crate::model::ApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the application.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) that specifies the application across services.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. The name must be unique in the region in which you are creating the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSummary`](crate::model::ApplicationSummary)
        pub fn build(self) -> crate::model::ApplicationSummary {
            crate::model::ApplicationSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl ApplicationSummary {
    /// Creates a new builder-style object to manufacture [`ApplicationSummary`](crate::model::ApplicationSummary)
    pub fn builder() -> crate::model::application_summary::Builder {
        crate::model::application_summary::Builder::default()
    }
}

/// <p> The information about the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time the resource was associated with the application.</p>
    pub association_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The service integration information about the resource.
    /// </p>
    pub integrations: std::option::Option<crate::model::ResourceIntegrations>,
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("association_time", &self.association_time);
        formatter.field("integrations", &self.integrations);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) association_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) integrations: std::option::Option<crate::model::ResourceIntegrations>,
    }
    impl Builder {
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon resource name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time the resource was associated with the application.</p>
        pub fn association_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.association_time = Some(input);
            self
        }
        /// <p>The time the resource was associated with the application.</p>
        pub fn set_association_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.association_time = input;
            self
        }
        /// <p>The service integration information about the resource.
        /// </p>
        pub fn integrations(mut self, input: crate::model::ResourceIntegrations) -> Self {
            self.integrations = Some(input);
            self
        }
        /// <p>The service integration information about the resource.
        /// </p>
        pub fn set_integrations(
            mut self,
            input: std::option::Option<crate::model::ResourceIntegrations>,
        ) -> Self {
            self.integrations = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                name: self.name,
                arn: self.arn,
                association_time: self.association_time,
                integrations: self.integrations,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>The service integration information about the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceIntegrations {
    /// <p>The information about the integration of Resource Groups.</p>
    pub resource_group: std::option::Option<crate::model::ResourceGroup>,
}
impl std::fmt::Debug for ResourceIntegrations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceIntegrations");
        formatter.field("resource_group", &self.resource_group);
        formatter.finish()
    }
}
/// See [`ResourceIntegrations`](crate::model::ResourceIntegrations)
pub mod resource_integrations {
    /// A builder for [`ResourceIntegrations`](crate::model::ResourceIntegrations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group: std::option::Option<crate::model::ResourceGroup>,
    }
    impl Builder {
        /// <p>The information about the integration of Resource Groups.</p>
        pub fn resource_group(mut self, input: crate::model::ResourceGroup) -> Self {
            self.resource_group = Some(input);
            self
        }
        /// <p>The information about the integration of Resource Groups.</p>
        pub fn set_resource_group(
            mut self,
            input: std::option::Option<crate::model::ResourceGroup>,
        ) -> Self {
            self.resource_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceIntegrations`](crate::model::ResourceIntegrations)
        pub fn build(self) -> crate::model::ResourceIntegrations {
            crate::model::ResourceIntegrations {
                resource_group: self.resource_group,
            }
        }
    }
}
impl ResourceIntegrations {
    /// Creates a new builder-style object to manufacture [`ResourceIntegrations`](crate::model::ResourceIntegrations)
    pub fn builder() -> crate::model::resource_integrations::Builder {
        crate::model::resource_integrations::Builder::default()
    }
}

/// <p>The information about the resource group integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceGroup {
    /// <p>The state of the propagation process for the resource group. The states includes:</p>
    /// <p>
    /// <code>CREATING </code>if the resource group is in the process of being created.</p>
    /// <p>
    /// <code>CREATE_COMPLETE</code> if the resource group was created successfully.</p>
    /// <p>
    /// <code>CREATE_FAILED</code> if the resource group failed to be created.</p>
    /// <p>
    /// <code>UPDATING</code> if the resource group is in the process of being updated.</p>
    /// <p>
    /// <code>UPDATE_COMPLETE</code> if the resource group updated successfully.</p>
    /// <p>
    /// <code>UPDATE_FAILED</code> if the resource group could not update successfully.</p>
    pub state: std::option::Option<crate::model::ResourceGroupState>,
    /// <p>The Amazon resource name (ARN) of the resource group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The error message that generates when the propagation process for the resource group fails.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceGroup");
        formatter.field("state", &self.state);
        formatter.field("arn", &self.arn);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ResourceGroup`](crate::model::ResourceGroup)
pub mod resource_group {
    /// A builder for [`ResourceGroup`](crate::model::ResourceGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ResourceGroupState>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the propagation process for the resource group. The states includes:</p>
        /// <p>
        /// <code>CREATING </code>if the resource group is in the process of being created.</p>
        /// <p>
        /// <code>CREATE_COMPLETE</code> if the resource group was created successfully.</p>
        /// <p>
        /// <code>CREATE_FAILED</code> if the resource group failed to be created.</p>
        /// <p>
        /// <code>UPDATING</code> if the resource group is in the process of being updated.</p>
        /// <p>
        /// <code>UPDATE_COMPLETE</code> if the resource group updated successfully.</p>
        /// <p>
        /// <code>UPDATE_FAILED</code> if the resource group could not update successfully.</p>
        pub fn state(mut self, input: crate::model::ResourceGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the propagation process for the resource group. The states includes:</p>
        /// <p>
        /// <code>CREATING </code>if the resource group is in the process of being created.</p>
        /// <p>
        /// <code>CREATE_COMPLETE</code> if the resource group was created successfully.</p>
        /// <p>
        /// <code>CREATE_FAILED</code> if the resource group failed to be created.</p>
        /// <p>
        /// <code>UPDATING</code> if the resource group is in the process of being updated.</p>
        /// <p>
        /// <code>UPDATE_COMPLETE</code> if the resource group updated successfully.</p>
        /// <p>
        /// <code>UPDATE_FAILED</code> if the resource group could not update successfully.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ResourceGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The Amazon resource name (ARN) of the resource group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the resource group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The error message that generates when the propagation process for the resource group fails.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that generates when the propagation process for the resource group fails.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceGroup`](crate::model::ResourceGroup)
        pub fn build(self) -> crate::model::ResourceGroup {
            crate::model::ResourceGroup {
                state: self.state,
                arn: self.arn,
                error_message: self.error_message,
            }
        }
    }
}
impl ResourceGroup {
    /// Creates a new builder-style object to manufacture [`ResourceGroup`](crate::model::ResourceGroup)
    pub fn builder() -> crate::model::resource_group::Builder {
        crate::model::resource_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceGroupState {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    UpdateComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceGroupState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => ResourceGroupState::CreateComplete,
            "CREATE_FAILED" => ResourceGroupState::CreateFailed,
            "CREATING" => ResourceGroupState::Creating,
            "UPDATE_COMPLETE" => ResourceGroupState::UpdateComplete,
            "UPDATE_FAILED" => ResourceGroupState::UpdateFailed,
            "UPDATING" => ResourceGroupState::Updating,
            other => ResourceGroupState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceGroupState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceGroupState::from(s))
    }
}
impl ResourceGroupState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceGroupState::CreateComplete => "CREATE_COMPLETE",
            ResourceGroupState::CreateFailed => "CREATE_FAILED",
            ResourceGroupState::Creating => "CREATING",
            ResourceGroupState::UpdateComplete => "UPDATE_COMPLETE",
            ResourceGroupState::UpdateFailed => "UPDATE_FAILED",
            ResourceGroupState::Updating => "UPDATING",
            ResourceGroupState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATING",
            "UPDATE_COMPLETE",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ResourceGroupState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The information about the service integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Integrations {
    /// <p> The information about the resource group integration.</p>
    pub resource_group: std::option::Option<crate::model::ResourceGroup>,
}
impl std::fmt::Debug for Integrations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Integrations");
        formatter.field("resource_group", &self.resource_group);
        formatter.finish()
    }
}
/// See [`Integrations`](crate::model::Integrations)
pub mod integrations {
    /// A builder for [`Integrations`](crate::model::Integrations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group: std::option::Option<crate::model::ResourceGroup>,
    }
    impl Builder {
        /// <p> The information about the resource group integration.</p>
        pub fn resource_group(mut self, input: crate::model::ResourceGroup) -> Self {
            self.resource_group = Some(input);
            self
        }
        /// <p> The information about the resource group integration.</p>
        pub fn set_resource_group(
            mut self,
            input: std::option::Option<crate::model::ResourceGroup>,
        ) -> Self {
            self.resource_group = input;
            self
        }
        /// Consumes the builder and constructs a [`Integrations`](crate::model::Integrations)
        pub fn build(self) -> crate::model::Integrations {
            crate::model::Integrations {
                resource_group: self.resource_group,
            }
        }
    }
}
impl Integrations {
    /// Creates a new builder-style object to manufacture [`Integrations`](crate::model::Integrations)
    pub fn builder() -> crate::model::integrations::Builder {
        crate::model::integrations::Builder::default()
    }
}
