// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptPortfolioShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_portfolio_share`](crate::client::Client::accept_portfolio_share).
///
/// See [`crate::client::fluent_builders::AcceptPortfolioShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptPortfolioShare {
    _private: (),
}
impl AcceptPortfolioShare {
    /// Creates a new builder-style object to manufacture [`AcceptPortfolioShareInput`](crate::input::AcceptPortfolioShareInput)
    pub fn builder() -> crate::input::accept_portfolio_share_input::Builder {
        crate::input::accept_portfolio_share_input::Builder::default()
    }
    /// Creates a new `AcceptPortfolioShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptPortfolioShare {
    type Output = std::result::Result<
        crate::output::AcceptPortfolioShareOutput,
        crate::error::AcceptPortfolioShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_portfolio_share_error(response)
        } else {
            crate::operation_deser::parse_accept_portfolio_share_response(response)
        }
    }
}

/// Operation shape for `AssociateBudgetWithResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_budget_with_resource`](crate::client::Client::associate_budget_with_resource).
///
/// See [`crate::client::fluent_builders::AssociateBudgetWithResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateBudgetWithResource {
    _private: (),
}
impl AssociateBudgetWithResource {
    /// Creates a new builder-style object to manufacture [`AssociateBudgetWithResourceInput`](crate::input::AssociateBudgetWithResourceInput)
    pub fn builder() -> crate::input::associate_budget_with_resource_input::Builder {
        crate::input::associate_budget_with_resource_input::Builder::default()
    }
    /// Creates a new `AssociateBudgetWithResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateBudgetWithResource {
    type Output = std::result::Result<
        crate::output::AssociateBudgetWithResourceOutput,
        crate::error::AssociateBudgetWithResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_budget_with_resource_error(response)
        } else {
            crate::operation_deser::parse_associate_budget_with_resource_response(response)
        }
    }
}

/// Operation shape for `AssociatePrincipalWithPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_principal_with_portfolio`](crate::client::Client::associate_principal_with_portfolio).
///
/// See [`crate::client::fluent_builders::AssociatePrincipalWithPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePrincipalWithPortfolio {
    _private: (),
}
impl AssociatePrincipalWithPortfolio {
    /// Creates a new builder-style object to manufacture [`AssociatePrincipalWithPortfolioInput`](crate::input::AssociatePrincipalWithPortfolioInput)
    pub fn builder() -> crate::input::associate_principal_with_portfolio_input::Builder {
        crate::input::associate_principal_with_portfolio_input::Builder::default()
    }
    /// Creates a new `AssociatePrincipalWithPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePrincipalWithPortfolio {
    type Output = std::result::Result<
        crate::output::AssociatePrincipalWithPortfolioOutput,
        crate::error::AssociatePrincipalWithPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_principal_with_portfolio_error(response)
        } else {
            crate::operation_deser::parse_associate_principal_with_portfolio_response(response)
        }
    }
}

/// Operation shape for `AssociateProductWithPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_product_with_portfolio`](crate::client::Client::associate_product_with_portfolio).
///
/// See [`crate::client::fluent_builders::AssociateProductWithPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateProductWithPortfolio {
    _private: (),
}
impl AssociateProductWithPortfolio {
    /// Creates a new builder-style object to manufacture [`AssociateProductWithPortfolioInput`](crate::input::AssociateProductWithPortfolioInput)
    pub fn builder() -> crate::input::associate_product_with_portfolio_input::Builder {
        crate::input::associate_product_with_portfolio_input::Builder::default()
    }
    /// Creates a new `AssociateProductWithPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateProductWithPortfolio {
    type Output = std::result::Result<
        crate::output::AssociateProductWithPortfolioOutput,
        crate::error::AssociateProductWithPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_product_with_portfolio_error(response)
        } else {
            crate::operation_deser::parse_associate_product_with_portfolio_response(response)
        }
    }
}

/// Operation shape for `AssociateServiceActionWithProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_service_action_with_provisioning_artifact`](crate::client::Client::associate_service_action_with_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateServiceActionWithProvisioningArtifact {
    _private: (),
}
impl AssociateServiceActionWithProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`AssociateServiceActionWithProvisioningArtifactInput`](crate::input::AssociateServiceActionWithProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::associate_service_action_with_provisioning_artifact_input::Builder {
        crate::input::associate_service_action_with_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `AssociateServiceActionWithProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for AssociateServiceActionWithProvisioningArtifact
{
    type Output = std::result::Result<
        crate::output::AssociateServiceActionWithProvisioningArtifactOutput,
        crate::error::AssociateServiceActionWithProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_service_action_with_provisioning_artifact_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_service_action_with_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `AssociateTagOptionWithResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_tag_option_with_resource`](crate::client::Client::associate_tag_option_with_resource).
///
/// See [`crate::client::fluent_builders::AssociateTagOptionWithResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTagOptionWithResource {
    _private: (),
}
impl AssociateTagOptionWithResource {
    /// Creates a new builder-style object to manufacture [`AssociateTagOptionWithResourceInput`](crate::input::AssociateTagOptionWithResourceInput)
    pub fn builder() -> crate::input::associate_tag_option_with_resource_input::Builder {
        crate::input::associate_tag_option_with_resource_input::Builder::default()
    }
    /// Creates a new `AssociateTagOptionWithResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTagOptionWithResource {
    type Output = std::result::Result<
        crate::output::AssociateTagOptionWithResourceOutput,
        crate::error::AssociateTagOptionWithResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_tag_option_with_resource_error(response)
        } else {
            crate::operation_deser::parse_associate_tag_option_with_resource_response(response)
        }
    }
}

/// Operation shape for `BatchAssociateServiceActionWithProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_service_action_with_provisioning_artifact`](crate::client::Client::batch_associate_service_action_with_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateServiceActionWithProvisioningArtifact {
    _private: (),
}
impl BatchAssociateServiceActionWithProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`BatchAssociateServiceActionWithProvisioningArtifactInput`](crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder
    {
        crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `BatchAssociateServiceActionWithProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for BatchAssociateServiceActionWithProvisioningArtifact
{
    type Output = std::result::Result<
        crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput,
        crate::error::BatchAssociateServiceActionWithProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_service_action_with_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_batch_associate_service_action_with_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `BatchDisassociateServiceActionFromProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_service_action_from_provisioning_artifact`](crate::client::Client::batch_disassociate_service_action_from_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateServiceActionFromProvisioningArtifact {
    _private: (),
}
impl BatchDisassociateServiceActionFromProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateServiceActionFromProvisioningArtifactInput`](crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder
    {
        crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateServiceActionFromProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for BatchDisassociateServiceActionFromProvisioningArtifact
{
    type Output = std::result::Result<
        crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput,
        crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_service_action_from_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_batch_disassociate_service_action_from_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `CopyProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_product`](crate::client::Client::copy_product).
///
/// See [`crate::client::fluent_builders::CopyProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyProduct {
    _private: (),
}
impl CopyProduct {
    /// Creates a new builder-style object to manufacture [`CopyProductInput`](crate::input::CopyProductInput)
    pub fn builder() -> crate::input::copy_product_input::Builder {
        crate::input::copy_product_input::Builder::default()
    }
    /// Creates a new `CopyProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyProduct {
    type Output =
        std::result::Result<crate::output::CopyProductOutput, crate::error::CopyProductError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_product_error(response)
        } else {
            crate::operation_deser::parse_copy_product_response(response)
        }
    }
}

/// Operation shape for `CreateConstraint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_constraint`](crate::client::Client::create_constraint).
///
/// See [`crate::client::fluent_builders::CreateConstraint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConstraint {
    _private: (),
}
impl CreateConstraint {
    /// Creates a new builder-style object to manufacture [`CreateConstraintInput`](crate::input::CreateConstraintInput)
    pub fn builder() -> crate::input::create_constraint_input::Builder {
        crate::input::create_constraint_input::Builder::default()
    }
    /// Creates a new `CreateConstraint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConstraint {
    type Output = std::result::Result<
        crate::output::CreateConstraintOutput,
        crate::error::CreateConstraintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_constraint_error(response)
        } else {
            crate::operation_deser::parse_create_constraint_response(response)
        }
    }
}

/// Operation shape for `CreatePortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_portfolio`](crate::client::Client::create_portfolio).
///
/// See [`crate::client::fluent_builders::CreatePortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePortfolio {
    _private: (),
}
impl CreatePortfolio {
    /// Creates a new builder-style object to manufacture [`CreatePortfolioInput`](crate::input::CreatePortfolioInput)
    pub fn builder() -> crate::input::create_portfolio_input::Builder {
        crate::input::create_portfolio_input::Builder::default()
    }
    /// Creates a new `CreatePortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePortfolio {
    type Output = std::result::Result<
        crate::output::CreatePortfolioOutput,
        crate::error::CreatePortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_portfolio_error(response)
        } else {
            crate::operation_deser::parse_create_portfolio_response(response)
        }
    }
}

/// Operation shape for `CreatePortfolioShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_portfolio_share`](crate::client::Client::create_portfolio_share).
///
/// See [`crate::client::fluent_builders::CreatePortfolioShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePortfolioShare {
    _private: (),
}
impl CreatePortfolioShare {
    /// Creates a new builder-style object to manufacture [`CreatePortfolioShareInput`](crate::input::CreatePortfolioShareInput)
    pub fn builder() -> crate::input::create_portfolio_share_input::Builder {
        crate::input::create_portfolio_share_input::Builder::default()
    }
    /// Creates a new `CreatePortfolioShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePortfolioShare {
    type Output = std::result::Result<
        crate::output::CreatePortfolioShareOutput,
        crate::error::CreatePortfolioShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_portfolio_share_error(response)
        } else {
            crate::operation_deser::parse_create_portfolio_share_response(response)
        }
    }
}

/// Operation shape for `CreateProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_product`](crate::client::Client::create_product).
///
/// See [`crate::client::fluent_builders::CreateProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProduct {
    _private: (),
}
impl CreateProduct {
    /// Creates a new builder-style object to manufacture [`CreateProductInput`](crate::input::CreateProductInput)
    pub fn builder() -> crate::input::create_product_input::Builder {
        crate::input::create_product_input::Builder::default()
    }
    /// Creates a new `CreateProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProduct {
    type Output =
        std::result::Result<crate::output::CreateProductOutput, crate::error::CreateProductError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_product_error(response)
        } else {
            crate::operation_deser::parse_create_product_response(response)
        }
    }
}

/// Operation shape for `CreateProvisionedProductPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_provisioned_product_plan`](crate::client::Client::create_provisioned_product_plan).
///
/// See [`crate::client::fluent_builders::CreateProvisionedProductPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProvisionedProductPlan {
    _private: (),
}
impl CreateProvisionedProductPlan {
    /// Creates a new builder-style object to manufacture [`CreateProvisionedProductPlanInput`](crate::input::CreateProvisionedProductPlanInput)
    pub fn builder() -> crate::input::create_provisioned_product_plan_input::Builder {
        crate::input::create_provisioned_product_plan_input::Builder::default()
    }
    /// Creates a new `CreateProvisionedProductPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProvisionedProductPlan {
    type Output = std::result::Result<
        crate::output::CreateProvisionedProductPlanOutput,
        crate::error::CreateProvisionedProductPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_provisioned_product_plan_error(response)
        } else {
            crate::operation_deser::parse_create_provisioned_product_plan_response(response)
        }
    }
}

/// Operation shape for `CreateProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_provisioning_artifact`](crate::client::Client::create_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::CreateProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProvisioningArtifact {
    _private: (),
}
impl CreateProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningArtifactInput`](crate::input::CreateProvisioningArtifactInput)
    pub fn builder() -> crate::input::create_provisioning_artifact_input::Builder {
        crate::input::create_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `CreateProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProvisioningArtifact {
    type Output = std::result::Result<
        crate::output::CreateProvisioningArtifactOutput,
        crate::error::CreateProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_create_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `CreateServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service_action`](crate::client::Client::create_service_action).
///
/// See [`crate::client::fluent_builders::CreateServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateServiceAction {
    _private: (),
}
impl CreateServiceAction {
    /// Creates a new builder-style object to manufacture [`CreateServiceActionInput`](crate::input::CreateServiceActionInput)
    pub fn builder() -> crate::input::create_service_action_input::Builder {
        crate::input::create_service_action_input::Builder::default()
    }
    /// Creates a new `CreateServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateServiceAction {
    type Output = std::result::Result<
        crate::output::CreateServiceActionOutput,
        crate::error::CreateServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_action_error(response)
        } else {
            crate::operation_deser::parse_create_service_action_response(response)
        }
    }
}

/// Operation shape for `CreateTagOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tag_option`](crate::client::Client::create_tag_option).
///
/// See [`crate::client::fluent_builders::CreateTagOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTagOption {
    _private: (),
}
impl CreateTagOption {
    /// Creates a new builder-style object to manufacture [`CreateTagOptionInput`](crate::input::CreateTagOptionInput)
    pub fn builder() -> crate::input::create_tag_option_input::Builder {
        crate::input::create_tag_option_input::Builder::default()
    }
    /// Creates a new `CreateTagOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTagOption {
    type Output = std::result::Result<
        crate::output::CreateTagOptionOutput,
        crate::error::CreateTagOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tag_option_error(response)
        } else {
            crate::operation_deser::parse_create_tag_option_response(response)
        }
    }
}

/// Operation shape for `DeleteConstraint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_constraint`](crate::client::Client::delete_constraint).
///
/// See [`crate::client::fluent_builders::DeleteConstraint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConstraint {
    _private: (),
}
impl DeleteConstraint {
    /// Creates a new builder-style object to manufacture [`DeleteConstraintInput`](crate::input::DeleteConstraintInput)
    pub fn builder() -> crate::input::delete_constraint_input::Builder {
        crate::input::delete_constraint_input::Builder::default()
    }
    /// Creates a new `DeleteConstraint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConstraint {
    type Output = std::result::Result<
        crate::output::DeleteConstraintOutput,
        crate::error::DeleteConstraintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_constraint_error(response)
        } else {
            crate::operation_deser::parse_delete_constraint_response(response)
        }
    }
}

/// Operation shape for `DeletePortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_portfolio`](crate::client::Client::delete_portfolio).
///
/// See [`crate::client::fluent_builders::DeletePortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePortfolio {
    _private: (),
}
impl DeletePortfolio {
    /// Creates a new builder-style object to manufacture [`DeletePortfolioInput`](crate::input::DeletePortfolioInput)
    pub fn builder() -> crate::input::delete_portfolio_input::Builder {
        crate::input::delete_portfolio_input::Builder::default()
    }
    /// Creates a new `DeletePortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePortfolio {
    type Output = std::result::Result<
        crate::output::DeletePortfolioOutput,
        crate::error::DeletePortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_portfolio_error(response)
        } else {
            crate::operation_deser::parse_delete_portfolio_response(response)
        }
    }
}

/// Operation shape for `DeletePortfolioShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_portfolio_share`](crate::client::Client::delete_portfolio_share).
///
/// See [`crate::client::fluent_builders::DeletePortfolioShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePortfolioShare {
    _private: (),
}
impl DeletePortfolioShare {
    /// Creates a new builder-style object to manufacture [`DeletePortfolioShareInput`](crate::input::DeletePortfolioShareInput)
    pub fn builder() -> crate::input::delete_portfolio_share_input::Builder {
        crate::input::delete_portfolio_share_input::Builder::default()
    }
    /// Creates a new `DeletePortfolioShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePortfolioShare {
    type Output = std::result::Result<
        crate::output::DeletePortfolioShareOutput,
        crate::error::DeletePortfolioShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_portfolio_share_error(response)
        } else {
            crate::operation_deser::parse_delete_portfolio_share_response(response)
        }
    }
}

/// Operation shape for `DeleteProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_product`](crate::client::Client::delete_product).
///
/// See [`crate::client::fluent_builders::DeleteProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProduct {
    _private: (),
}
impl DeleteProduct {
    /// Creates a new builder-style object to manufacture [`DeleteProductInput`](crate::input::DeleteProductInput)
    pub fn builder() -> crate::input::delete_product_input::Builder {
        crate::input::delete_product_input::Builder::default()
    }
    /// Creates a new `DeleteProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProduct {
    type Output =
        std::result::Result<crate::output::DeleteProductOutput, crate::error::DeleteProductError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_product_error(response)
        } else {
            crate::operation_deser::parse_delete_product_response(response)
        }
    }
}

/// Operation shape for `DeleteProvisionedProductPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_provisioned_product_plan`](crate::client::Client::delete_provisioned_product_plan).
///
/// See [`crate::client::fluent_builders::DeleteProvisionedProductPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProvisionedProductPlan {
    _private: (),
}
impl DeleteProvisionedProductPlan {
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedProductPlanInput`](crate::input::DeleteProvisionedProductPlanInput)
    pub fn builder() -> crate::input::delete_provisioned_product_plan_input::Builder {
        crate::input::delete_provisioned_product_plan_input::Builder::default()
    }
    /// Creates a new `DeleteProvisionedProductPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProvisionedProductPlan {
    type Output = std::result::Result<
        crate::output::DeleteProvisionedProductPlanOutput,
        crate::error::DeleteProvisionedProductPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_provisioned_product_plan_error(response)
        } else {
            crate::operation_deser::parse_delete_provisioned_product_plan_response(response)
        }
    }
}

/// Operation shape for `DeleteProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_provisioning_artifact`](crate::client::Client::delete_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::DeleteProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProvisioningArtifact {
    _private: (),
}
impl DeleteProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningArtifactInput`](crate::input::DeleteProvisioningArtifactInput)
    pub fn builder() -> crate::input::delete_provisioning_artifact_input::Builder {
        crate::input::delete_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `DeleteProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProvisioningArtifact {
    type Output = std::result::Result<
        crate::output::DeleteProvisioningArtifactOutput,
        crate::error::DeleteProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_delete_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `DeleteServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service_action`](crate::client::Client::delete_service_action).
///
/// See [`crate::client::fluent_builders::DeleteServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServiceAction {
    _private: (),
}
impl DeleteServiceAction {
    /// Creates a new builder-style object to manufacture [`DeleteServiceActionInput`](crate::input::DeleteServiceActionInput)
    pub fn builder() -> crate::input::delete_service_action_input::Builder {
        crate::input::delete_service_action_input::Builder::default()
    }
    /// Creates a new `DeleteServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServiceAction {
    type Output = std::result::Result<
        crate::output::DeleteServiceActionOutput,
        crate::error::DeleteServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_action_error(response)
        } else {
            crate::operation_deser::parse_delete_service_action_response(response)
        }
    }
}

/// Operation shape for `DeleteTagOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tag_option`](crate::client::Client::delete_tag_option).
///
/// See [`crate::client::fluent_builders::DeleteTagOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTagOption {
    _private: (),
}
impl DeleteTagOption {
    /// Creates a new builder-style object to manufacture [`DeleteTagOptionInput`](crate::input::DeleteTagOptionInput)
    pub fn builder() -> crate::input::delete_tag_option_input::Builder {
        crate::input::delete_tag_option_input::Builder::default()
    }
    /// Creates a new `DeleteTagOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTagOption {
    type Output = std::result::Result<
        crate::output::DeleteTagOptionOutput,
        crate::error::DeleteTagOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tag_option_error(response)
        } else {
            crate::operation_deser::parse_delete_tag_option_response(response)
        }
    }
}

/// Operation shape for `DescribeConstraint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_constraint`](crate::client::Client::describe_constraint).
///
/// See [`crate::client::fluent_builders::DescribeConstraint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConstraint {
    _private: (),
}
impl DescribeConstraint {
    /// Creates a new builder-style object to manufacture [`DescribeConstraintInput`](crate::input::DescribeConstraintInput)
    pub fn builder() -> crate::input::describe_constraint_input::Builder {
        crate::input::describe_constraint_input::Builder::default()
    }
    /// Creates a new `DescribeConstraint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConstraint {
    type Output = std::result::Result<
        crate::output::DescribeConstraintOutput,
        crate::error::DescribeConstraintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_constraint_error(response)
        } else {
            crate::operation_deser::parse_describe_constraint_response(response)
        }
    }
}

/// Operation shape for `DescribeCopyProductStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_copy_product_status`](crate::client::Client::describe_copy_product_status).
///
/// See [`crate::client::fluent_builders::DescribeCopyProductStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCopyProductStatus {
    _private: (),
}
impl DescribeCopyProductStatus {
    /// Creates a new builder-style object to manufacture [`DescribeCopyProductStatusInput`](crate::input::DescribeCopyProductStatusInput)
    pub fn builder() -> crate::input::describe_copy_product_status_input::Builder {
        crate::input::describe_copy_product_status_input::Builder::default()
    }
    /// Creates a new `DescribeCopyProductStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCopyProductStatus {
    type Output = std::result::Result<
        crate::output::DescribeCopyProductStatusOutput,
        crate::error::DescribeCopyProductStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_copy_product_status_error(response)
        } else {
            crate::operation_deser::parse_describe_copy_product_status_response(response)
        }
    }
}

/// Operation shape for `DescribePortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_portfolio`](crate::client::Client::describe_portfolio).
///
/// See [`crate::client::fluent_builders::DescribePortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePortfolio {
    _private: (),
}
impl DescribePortfolio {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioInput`](crate::input::DescribePortfolioInput)
    pub fn builder() -> crate::input::describe_portfolio_input::Builder {
        crate::input::describe_portfolio_input::Builder::default()
    }
    /// Creates a new `DescribePortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePortfolio {
    type Output = std::result::Result<
        crate::output::DescribePortfolioOutput,
        crate::error::DescribePortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_portfolio_error(response)
        } else {
            crate::operation_deser::parse_describe_portfolio_response(response)
        }
    }
}

/// Operation shape for `DescribePortfolioShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_portfolio_shares`](crate::client::Client::describe_portfolio_shares).
///
/// See [`crate::client::fluent_builders::DescribePortfolioShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePortfolioShares {
    _private: (),
}
impl DescribePortfolioShares {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioSharesInput`](crate::input::DescribePortfolioSharesInput)
    pub fn builder() -> crate::input::describe_portfolio_shares_input::Builder {
        crate::input::describe_portfolio_shares_input::Builder::default()
    }
    /// Creates a new `DescribePortfolioShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePortfolioShares {
    type Output = std::result::Result<
        crate::output::DescribePortfolioSharesOutput,
        crate::error::DescribePortfolioSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_portfolio_shares_error(response)
        } else {
            crate::operation_deser::parse_describe_portfolio_shares_response(response)
        }
    }
}

/// Operation shape for `DescribePortfolioShareStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_portfolio_share_status`](crate::client::Client::describe_portfolio_share_status).
///
/// See [`crate::client::fluent_builders::DescribePortfolioShareStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePortfolioShareStatus {
    _private: (),
}
impl DescribePortfolioShareStatus {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioShareStatusInput`](crate::input::DescribePortfolioShareStatusInput)
    pub fn builder() -> crate::input::describe_portfolio_share_status_input::Builder {
        crate::input::describe_portfolio_share_status_input::Builder::default()
    }
    /// Creates a new `DescribePortfolioShareStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePortfolioShareStatus {
    type Output = std::result::Result<
        crate::output::DescribePortfolioShareStatusOutput,
        crate::error::DescribePortfolioShareStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_portfolio_share_status_error(response)
        } else {
            crate::operation_deser::parse_describe_portfolio_share_status_response(response)
        }
    }
}

/// Operation shape for `DescribeProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_product`](crate::client::Client::describe_product).
///
/// See [`crate::client::fluent_builders::DescribeProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProduct {
    _private: (),
}
impl DescribeProduct {
    /// Creates a new builder-style object to manufacture [`DescribeProductInput`](crate::input::DescribeProductInput)
    pub fn builder() -> crate::input::describe_product_input::Builder {
        crate::input::describe_product_input::Builder::default()
    }
    /// Creates a new `DescribeProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProduct {
    type Output = std::result::Result<
        crate::output::DescribeProductOutput,
        crate::error::DescribeProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_product_error(response)
        } else {
            crate::operation_deser::parse_describe_product_response(response)
        }
    }
}

/// Operation shape for `DescribeProductAsAdmin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_product_as_admin`](crate::client::Client::describe_product_as_admin).
///
/// See [`crate::client::fluent_builders::DescribeProductAsAdmin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProductAsAdmin {
    _private: (),
}
impl DescribeProductAsAdmin {
    /// Creates a new builder-style object to manufacture [`DescribeProductAsAdminInput`](crate::input::DescribeProductAsAdminInput)
    pub fn builder() -> crate::input::describe_product_as_admin_input::Builder {
        crate::input::describe_product_as_admin_input::Builder::default()
    }
    /// Creates a new `DescribeProductAsAdmin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProductAsAdmin {
    type Output = std::result::Result<
        crate::output::DescribeProductAsAdminOutput,
        crate::error::DescribeProductAsAdminError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_product_as_admin_error(response)
        } else {
            crate::operation_deser::parse_describe_product_as_admin_response(response)
        }
    }
}

/// Operation shape for `DescribeProductView`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_product_view`](crate::client::Client::describe_product_view).
///
/// See [`crate::client::fluent_builders::DescribeProductView`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProductView {
    _private: (),
}
impl DescribeProductView {
    /// Creates a new builder-style object to manufacture [`DescribeProductViewInput`](crate::input::DescribeProductViewInput)
    pub fn builder() -> crate::input::describe_product_view_input::Builder {
        crate::input::describe_product_view_input::Builder::default()
    }
    /// Creates a new `DescribeProductView` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProductView {
    type Output = std::result::Result<
        crate::output::DescribeProductViewOutput,
        crate::error::DescribeProductViewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_product_view_error(response)
        } else {
            crate::operation_deser::parse_describe_product_view_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisionedProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioned_product`](crate::client::Client::describe_provisioned_product).
///
/// See [`crate::client::fluent_builders::DescribeProvisionedProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisionedProduct {
    _private: (),
}
impl DescribeProvisionedProduct {
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductInput`](crate::input::DescribeProvisionedProductInput)
    pub fn builder() -> crate::input::describe_provisioned_product_input::Builder {
        crate::input::describe_provisioned_product_input::Builder::default()
    }
    /// Creates a new `DescribeProvisionedProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisionedProduct {
    type Output = std::result::Result<
        crate::output::DescribeProvisionedProductOutput,
        crate::error::DescribeProvisionedProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioned_product_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioned_product_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisionedProductPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioned_product_plan`](crate::client::Client::describe_provisioned_product_plan).
///
/// See [`crate::client::fluent_builders::DescribeProvisionedProductPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisionedProductPlan {
    _private: (),
}
impl DescribeProvisionedProductPlan {
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductPlanInput`](crate::input::DescribeProvisionedProductPlanInput)
    pub fn builder() -> crate::input::describe_provisioned_product_plan_input::Builder {
        crate::input::describe_provisioned_product_plan_input::Builder::default()
    }
    /// Creates a new `DescribeProvisionedProductPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisionedProductPlan {
    type Output = std::result::Result<
        crate::output::DescribeProvisionedProductPlanOutput,
        crate::error::DescribeProvisionedProductPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioned_product_plan_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioned_product_plan_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioning_artifact`](crate::client::Client::describe_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::DescribeProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisioningArtifact {
    _private: (),
}
impl DescribeProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningArtifactInput`](crate::input::DescribeProvisioningArtifactInput)
    pub fn builder() -> crate::input::describe_provisioning_artifact_input::Builder {
        crate::input::describe_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `DescribeProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisioningArtifact {
    type Output = std::result::Result<
        crate::output::DescribeProvisioningArtifactOutput,
        crate::error::DescribeProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisioningParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioning_parameters`](crate::client::Client::describe_provisioning_parameters).
///
/// See [`crate::client::fluent_builders::DescribeProvisioningParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisioningParameters {
    _private: (),
}
impl DescribeProvisioningParameters {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningParametersInput`](crate::input::DescribeProvisioningParametersInput)
    pub fn builder() -> crate::input::describe_provisioning_parameters_input::Builder {
        crate::input::describe_provisioning_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeProvisioningParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisioningParameters {
    type Output = std::result::Result<
        crate::output::DescribeProvisioningParametersOutput,
        crate::error::DescribeProvisioningParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioning_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioning_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeRecord`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_record`](crate::client::Client::describe_record).
///
/// See [`crate::client::fluent_builders::DescribeRecord`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecord {
    _private: (),
}
impl DescribeRecord {
    /// Creates a new builder-style object to manufacture [`DescribeRecordInput`](crate::input::DescribeRecordInput)
    pub fn builder() -> crate::input::describe_record_input::Builder {
        crate::input::describe_record_input::Builder::default()
    }
    /// Creates a new `DescribeRecord` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecord {
    type Output =
        std::result::Result<crate::output::DescribeRecordOutput, crate::error::DescribeRecordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_record_error(response)
        } else {
            crate::operation_deser::parse_describe_record_response(response)
        }
    }
}

/// Operation shape for `DescribeServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service_action`](crate::client::Client::describe_service_action).
///
/// See [`crate::client::fluent_builders::DescribeServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServiceAction {
    _private: (),
}
impl DescribeServiceAction {
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionInput`](crate::input::DescribeServiceActionInput)
    pub fn builder() -> crate::input::describe_service_action_input::Builder {
        crate::input::describe_service_action_input::Builder::default()
    }
    /// Creates a new `DescribeServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServiceAction {
    type Output = std::result::Result<
        crate::output::DescribeServiceActionOutput,
        crate::error::DescribeServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_action_error(response)
        } else {
            crate::operation_deser::parse_describe_service_action_response(response)
        }
    }
}

/// Operation shape for `DescribeServiceActionExecutionParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service_action_execution_parameters`](crate::client::Client::describe_service_action_execution_parameters).
///
/// See [`crate::client::fluent_builders::DescribeServiceActionExecutionParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServiceActionExecutionParameters {
    _private: (),
}
impl DescribeServiceActionExecutionParameters {
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionExecutionParametersInput`](crate::input::DescribeServiceActionExecutionParametersInput)
    pub fn builder() -> crate::input::describe_service_action_execution_parameters_input::Builder {
        crate::input::describe_service_action_execution_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeServiceActionExecutionParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServiceActionExecutionParameters {
    type Output = std::result::Result<
        crate::output::DescribeServiceActionExecutionParametersOutput,
        crate::error::DescribeServiceActionExecutionParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_action_execution_parameters_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_service_action_execution_parameters_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeTagOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tag_option`](crate::client::Client::describe_tag_option).
///
/// See [`crate::client::fluent_builders::DescribeTagOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTagOption {
    _private: (),
}
impl DescribeTagOption {
    /// Creates a new builder-style object to manufacture [`DescribeTagOptionInput`](crate::input::DescribeTagOptionInput)
    pub fn builder() -> crate::input::describe_tag_option_input::Builder {
        crate::input::describe_tag_option_input::Builder::default()
    }
    /// Creates a new `DescribeTagOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTagOption {
    type Output = std::result::Result<
        crate::output::DescribeTagOptionOutput,
        crate::error::DescribeTagOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tag_option_error(response)
        } else {
            crate::operation_deser::parse_describe_tag_option_response(response)
        }
    }
}

/// Operation shape for `DisableAWSOrganizationsAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_aws_organizations_access`](crate::client::Client::disable_aws_organizations_access).
///
/// See [`crate::client::fluent_builders::DisableAWSOrganizationsAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableAWSOrganizationsAccess {
    _private: (),
}
impl DisableAWSOrganizationsAccess {
    /// Creates a new builder-style object to manufacture [`DisableAwsOrganizationsAccessInput`](crate::input::DisableAwsOrganizationsAccessInput)
    pub fn builder() -> crate::input::disable_aws_organizations_access_input::Builder {
        crate::input::disable_aws_organizations_access_input::Builder::default()
    }
    /// Creates a new `DisableAWSOrganizationsAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableAWSOrganizationsAccess {
    type Output = std::result::Result<
        crate::output::DisableAwsOrganizationsAccessOutput,
        crate::error::DisableAWSOrganizationsAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_aws_organizations_access_error(response)
        } else {
            crate::operation_deser::parse_disable_aws_organizations_access_response(response)
        }
    }
}

/// Operation shape for `DisassociateBudgetFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_budget_from_resource`](crate::client::Client::disassociate_budget_from_resource).
///
/// See [`crate::client::fluent_builders::DisassociateBudgetFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateBudgetFromResource {
    _private: (),
}
impl DisassociateBudgetFromResource {
    /// Creates a new builder-style object to manufacture [`DisassociateBudgetFromResourceInput`](crate::input::DisassociateBudgetFromResourceInput)
    pub fn builder() -> crate::input::disassociate_budget_from_resource_input::Builder {
        crate::input::disassociate_budget_from_resource_input::Builder::default()
    }
    /// Creates a new `DisassociateBudgetFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateBudgetFromResource {
    type Output = std::result::Result<
        crate::output::DisassociateBudgetFromResourceOutput,
        crate::error::DisassociateBudgetFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_budget_from_resource_error(response)
        } else {
            crate::operation_deser::parse_disassociate_budget_from_resource_response(response)
        }
    }
}

/// Operation shape for `DisassociatePrincipalFromPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_principal_from_portfolio`](crate::client::Client::disassociate_principal_from_portfolio).
///
/// See [`crate::client::fluent_builders::DisassociatePrincipalFromPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePrincipalFromPortfolio {
    _private: (),
}
impl DisassociatePrincipalFromPortfolio {
    /// Creates a new builder-style object to manufacture [`DisassociatePrincipalFromPortfolioInput`](crate::input::DisassociatePrincipalFromPortfolioInput)
    pub fn builder() -> crate::input::disassociate_principal_from_portfolio_input::Builder {
        crate::input::disassociate_principal_from_portfolio_input::Builder::default()
    }
    /// Creates a new `DisassociatePrincipalFromPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociatePrincipalFromPortfolio {
    type Output = std::result::Result<
        crate::output::DisassociatePrincipalFromPortfolioOutput,
        crate::error::DisassociatePrincipalFromPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_principal_from_portfolio_error(response)
        } else {
            crate::operation_deser::parse_disassociate_principal_from_portfolio_response(response)
        }
    }
}

/// Operation shape for `DisassociateProductFromPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_product_from_portfolio`](crate::client::Client::disassociate_product_from_portfolio).
///
/// See [`crate::client::fluent_builders::DisassociateProductFromPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateProductFromPortfolio {
    _private: (),
}
impl DisassociateProductFromPortfolio {
    /// Creates a new builder-style object to manufacture [`DisassociateProductFromPortfolioInput`](crate::input::DisassociateProductFromPortfolioInput)
    pub fn builder() -> crate::input::disassociate_product_from_portfolio_input::Builder {
        crate::input::disassociate_product_from_portfolio_input::Builder::default()
    }
    /// Creates a new `DisassociateProductFromPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateProductFromPortfolio {
    type Output = std::result::Result<
        crate::output::DisassociateProductFromPortfolioOutput,
        crate::error::DisassociateProductFromPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_product_from_portfolio_error(response)
        } else {
            crate::operation_deser::parse_disassociate_product_from_portfolio_response(response)
        }
    }
}

/// Operation shape for `DisassociateServiceActionFromProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_service_action_from_provisioning_artifact`](crate::client::Client::disassociate_service_action_from_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateServiceActionFromProvisioningArtifact {
    _private: (),
}
impl DisassociateServiceActionFromProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`DisassociateServiceActionFromProvisioningArtifactInput`](crate::input::DisassociateServiceActionFromProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder {
        crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder::default(
        )
    }
    /// Creates a new `DisassociateServiceActionFromProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DisassociateServiceActionFromProvisioningArtifact
{
    type Output = std::result::Result<
        crate::output::DisassociateServiceActionFromProvisioningArtifactOutput,
        crate::error::DisassociateServiceActionFromProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_service_action_from_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_disassociate_service_action_from_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `DisassociateTagOptionFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_tag_option_from_resource`](crate::client::Client::disassociate_tag_option_from_resource).
///
/// See [`crate::client::fluent_builders::DisassociateTagOptionFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTagOptionFromResource {
    _private: (),
}
impl DisassociateTagOptionFromResource {
    /// Creates a new builder-style object to manufacture [`DisassociateTagOptionFromResourceInput`](crate::input::DisassociateTagOptionFromResourceInput)
    pub fn builder() -> crate::input::disassociate_tag_option_from_resource_input::Builder {
        crate::input::disassociate_tag_option_from_resource_input::Builder::default()
    }
    /// Creates a new `DisassociateTagOptionFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTagOptionFromResource {
    type Output = std::result::Result<
        crate::output::DisassociateTagOptionFromResourceOutput,
        crate::error::DisassociateTagOptionFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_tag_option_from_resource_error(response)
        } else {
            crate::operation_deser::parse_disassociate_tag_option_from_resource_response(response)
        }
    }
}

/// Operation shape for `EnableAWSOrganizationsAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_aws_organizations_access`](crate::client::Client::enable_aws_organizations_access).
///
/// See [`crate::client::fluent_builders::EnableAWSOrganizationsAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAWSOrganizationsAccess {
    _private: (),
}
impl EnableAWSOrganizationsAccess {
    /// Creates a new builder-style object to manufacture [`EnableAwsOrganizationsAccessInput`](crate::input::EnableAwsOrganizationsAccessInput)
    pub fn builder() -> crate::input::enable_aws_organizations_access_input::Builder {
        crate::input::enable_aws_organizations_access_input::Builder::default()
    }
    /// Creates a new `EnableAWSOrganizationsAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAWSOrganizationsAccess {
    type Output = std::result::Result<
        crate::output::EnableAwsOrganizationsAccessOutput,
        crate::error::EnableAWSOrganizationsAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_aws_organizations_access_error(response)
        } else {
            crate::operation_deser::parse_enable_aws_organizations_access_response(response)
        }
    }
}

/// Operation shape for `ExecuteProvisionedProductPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_provisioned_product_plan`](crate::client::Client::execute_provisioned_product_plan).
///
/// See [`crate::client::fluent_builders::ExecuteProvisionedProductPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteProvisionedProductPlan {
    _private: (),
}
impl ExecuteProvisionedProductPlan {
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductPlanInput`](crate::input::ExecuteProvisionedProductPlanInput)
    pub fn builder() -> crate::input::execute_provisioned_product_plan_input::Builder {
        crate::input::execute_provisioned_product_plan_input::Builder::default()
    }
    /// Creates a new `ExecuteProvisionedProductPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteProvisionedProductPlan {
    type Output = std::result::Result<
        crate::output::ExecuteProvisionedProductPlanOutput,
        crate::error::ExecuteProvisionedProductPlanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_provisioned_product_plan_error(response)
        } else {
            crate::operation_deser::parse_execute_provisioned_product_plan_response(response)
        }
    }
}

/// Operation shape for `ExecuteProvisionedProductServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_provisioned_product_service_action`](crate::client::Client::execute_provisioned_product_service_action).
///
/// See [`crate::client::fluent_builders::ExecuteProvisionedProductServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteProvisionedProductServiceAction {
    _private: (),
}
impl ExecuteProvisionedProductServiceAction {
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductServiceActionInput`](crate::input::ExecuteProvisionedProductServiceActionInput)
    pub fn builder() -> crate::input::execute_provisioned_product_service_action_input::Builder {
        crate::input::execute_provisioned_product_service_action_input::Builder::default()
    }
    /// Creates a new `ExecuteProvisionedProductServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteProvisionedProductServiceAction {
    type Output = std::result::Result<
        crate::output::ExecuteProvisionedProductServiceActionOutput,
        crate::error::ExecuteProvisionedProductServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_provisioned_product_service_action_error(response)
        } else {
            crate::operation_deser::parse_execute_provisioned_product_service_action_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAWSOrganizationsAccessStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_aws_organizations_access_status`](crate::client::Client::get_aws_organizations_access_status).
///
/// See [`crate::client::fluent_builders::GetAWSOrganizationsAccessStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAWSOrganizationsAccessStatus {
    _private: (),
}
impl GetAWSOrganizationsAccessStatus {
    /// Creates a new builder-style object to manufacture [`GetAwsOrganizationsAccessStatusInput`](crate::input::GetAwsOrganizationsAccessStatusInput)
    pub fn builder() -> crate::input::get_aws_organizations_access_status_input::Builder {
        crate::input::get_aws_organizations_access_status_input::Builder::default()
    }
    /// Creates a new `GetAWSOrganizationsAccessStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAWSOrganizationsAccessStatus {
    type Output = std::result::Result<
        crate::output::GetAwsOrganizationsAccessStatusOutput,
        crate::error::GetAWSOrganizationsAccessStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_aws_organizations_access_status_error(response)
        } else {
            crate::operation_deser::parse_get_aws_organizations_access_status_response(response)
        }
    }
}

/// Operation shape for `GetProvisionedProductOutputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_provisioned_product_outputs`](crate::client::Client::get_provisioned_product_outputs).
///
/// See [`crate::client::fluent_builders::GetProvisionedProductOutputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProvisionedProductOutputs {
    _private: (),
}
impl GetProvisionedProductOutputs {
    /// Creates a new builder-style object to manufacture [`GetProvisionedProductOutputsInput`](crate::input::GetProvisionedProductOutputsInput)
    pub fn builder() -> crate::input::get_provisioned_product_outputs_input::Builder {
        crate::input::get_provisioned_product_outputs_input::Builder::default()
    }
    /// Creates a new `GetProvisionedProductOutputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProvisionedProductOutputs {
    type Output = std::result::Result<
        crate::output::GetProvisionedProductOutputsOutput,
        crate::error::GetProvisionedProductOutputsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_provisioned_product_outputs_error(response)
        } else {
            crate::operation_deser::parse_get_provisioned_product_outputs_response(response)
        }
    }
}

/// Operation shape for `ImportAsProvisionedProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_as_provisioned_product`](crate::client::Client::import_as_provisioned_product).
///
/// See [`crate::client::fluent_builders::ImportAsProvisionedProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportAsProvisionedProduct {
    _private: (),
}
impl ImportAsProvisionedProduct {
    /// Creates a new builder-style object to manufacture [`ImportAsProvisionedProductInput`](crate::input::ImportAsProvisionedProductInput)
    pub fn builder() -> crate::input::import_as_provisioned_product_input::Builder {
        crate::input::import_as_provisioned_product_input::Builder::default()
    }
    /// Creates a new `ImportAsProvisionedProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportAsProvisionedProduct {
    type Output = std::result::Result<
        crate::output::ImportAsProvisionedProductOutput,
        crate::error::ImportAsProvisionedProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_as_provisioned_product_error(response)
        } else {
            crate::operation_deser::parse_import_as_provisioned_product_response(response)
        }
    }
}

/// Operation shape for `ListAcceptedPortfolioShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accepted_portfolio_shares`](crate::client::Client::list_accepted_portfolio_shares).
///
/// See [`crate::client::fluent_builders::ListAcceptedPortfolioShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAcceptedPortfolioShares {
    _private: (),
}
impl ListAcceptedPortfolioShares {
    /// Creates a new builder-style object to manufacture [`ListAcceptedPortfolioSharesInput`](crate::input::ListAcceptedPortfolioSharesInput)
    pub fn builder() -> crate::input::list_accepted_portfolio_shares_input::Builder {
        crate::input::list_accepted_portfolio_shares_input::Builder::default()
    }
    /// Creates a new `ListAcceptedPortfolioShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAcceptedPortfolioShares {
    type Output = std::result::Result<
        crate::output::ListAcceptedPortfolioSharesOutput,
        crate::error::ListAcceptedPortfolioSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accepted_portfolio_shares_error(response)
        } else {
            crate::operation_deser::parse_list_accepted_portfolio_shares_response(response)
        }
    }
}

/// Operation shape for `ListBudgetsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_budgets_for_resource`](crate::client::Client::list_budgets_for_resource).
///
/// See [`crate::client::fluent_builders::ListBudgetsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBudgetsForResource {
    _private: (),
}
impl ListBudgetsForResource {
    /// Creates a new builder-style object to manufacture [`ListBudgetsForResourceInput`](crate::input::ListBudgetsForResourceInput)
    pub fn builder() -> crate::input::list_budgets_for_resource_input::Builder {
        crate::input::list_budgets_for_resource_input::Builder::default()
    }
    /// Creates a new `ListBudgetsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBudgetsForResource {
    type Output = std::result::Result<
        crate::output::ListBudgetsForResourceOutput,
        crate::error::ListBudgetsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_budgets_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_budgets_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListConstraintsForPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_constraints_for_portfolio`](crate::client::Client::list_constraints_for_portfolio).
///
/// See [`crate::client::fluent_builders::ListConstraintsForPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConstraintsForPortfolio {
    _private: (),
}
impl ListConstraintsForPortfolio {
    /// Creates a new builder-style object to manufacture [`ListConstraintsForPortfolioInput`](crate::input::ListConstraintsForPortfolioInput)
    pub fn builder() -> crate::input::list_constraints_for_portfolio_input::Builder {
        crate::input::list_constraints_for_portfolio_input::Builder::default()
    }
    /// Creates a new `ListConstraintsForPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConstraintsForPortfolio {
    type Output = std::result::Result<
        crate::output::ListConstraintsForPortfolioOutput,
        crate::error::ListConstraintsForPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_constraints_for_portfolio_error(response)
        } else {
            crate::operation_deser::parse_list_constraints_for_portfolio_response(response)
        }
    }
}

/// Operation shape for `ListLaunchPaths`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_launch_paths`](crate::client::Client::list_launch_paths).
///
/// See [`crate::client::fluent_builders::ListLaunchPaths`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLaunchPaths {
    _private: (),
}
impl ListLaunchPaths {
    /// Creates a new builder-style object to manufacture [`ListLaunchPathsInput`](crate::input::ListLaunchPathsInput)
    pub fn builder() -> crate::input::list_launch_paths_input::Builder {
        crate::input::list_launch_paths_input::Builder::default()
    }
    /// Creates a new `ListLaunchPaths` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLaunchPaths {
    type Output = std::result::Result<
        crate::output::ListLaunchPathsOutput,
        crate::error::ListLaunchPathsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_launch_paths_error(response)
        } else {
            crate::operation_deser::parse_list_launch_paths_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationPortfolioAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organization_portfolio_access`](crate::client::Client::list_organization_portfolio_access).
///
/// See [`crate::client::fluent_builders::ListOrganizationPortfolioAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationPortfolioAccess {
    _private: (),
}
impl ListOrganizationPortfolioAccess {
    /// Creates a new builder-style object to manufacture [`ListOrganizationPortfolioAccessInput`](crate::input::ListOrganizationPortfolioAccessInput)
    pub fn builder() -> crate::input::list_organization_portfolio_access_input::Builder {
        crate::input::list_organization_portfolio_access_input::Builder::default()
    }
    /// Creates a new `ListOrganizationPortfolioAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationPortfolioAccess {
    type Output = std::result::Result<
        crate::output::ListOrganizationPortfolioAccessOutput,
        crate::error::ListOrganizationPortfolioAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organization_portfolio_access_error(response)
        } else {
            crate::operation_deser::parse_list_organization_portfolio_access_response(response)
        }
    }
}

/// Operation shape for `ListPortfolioAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_portfolio_access`](crate::client::Client::list_portfolio_access).
///
/// See [`crate::client::fluent_builders::ListPortfolioAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPortfolioAccess {
    _private: (),
}
impl ListPortfolioAccess {
    /// Creates a new builder-style object to manufacture [`ListPortfolioAccessInput`](crate::input::ListPortfolioAccessInput)
    pub fn builder() -> crate::input::list_portfolio_access_input::Builder {
        crate::input::list_portfolio_access_input::Builder::default()
    }
    /// Creates a new `ListPortfolioAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPortfolioAccess {
    type Output = std::result::Result<
        crate::output::ListPortfolioAccessOutput,
        crate::error::ListPortfolioAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_portfolio_access_error(response)
        } else {
            crate::operation_deser::parse_list_portfolio_access_response(response)
        }
    }
}

/// Operation shape for `ListPortfolios`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_portfolios`](crate::client::Client::list_portfolios).
///
/// See [`crate::client::fluent_builders::ListPortfolios`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPortfolios {
    _private: (),
}
impl ListPortfolios {
    /// Creates a new builder-style object to manufacture [`ListPortfoliosInput`](crate::input::ListPortfoliosInput)
    pub fn builder() -> crate::input::list_portfolios_input::Builder {
        crate::input::list_portfolios_input::Builder::default()
    }
    /// Creates a new `ListPortfolios` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPortfolios {
    type Output =
        std::result::Result<crate::output::ListPortfoliosOutput, crate::error::ListPortfoliosError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_portfolios_error(response)
        } else {
            crate::operation_deser::parse_list_portfolios_response(response)
        }
    }
}

/// Operation shape for `ListPortfoliosForProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_portfolios_for_product`](crate::client::Client::list_portfolios_for_product).
///
/// See [`crate::client::fluent_builders::ListPortfoliosForProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPortfoliosForProduct {
    _private: (),
}
impl ListPortfoliosForProduct {
    /// Creates a new builder-style object to manufacture [`ListPortfoliosForProductInput`](crate::input::ListPortfoliosForProductInput)
    pub fn builder() -> crate::input::list_portfolios_for_product_input::Builder {
        crate::input::list_portfolios_for_product_input::Builder::default()
    }
    /// Creates a new `ListPortfoliosForProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPortfoliosForProduct {
    type Output = std::result::Result<
        crate::output::ListPortfoliosForProductOutput,
        crate::error::ListPortfoliosForProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_portfolios_for_product_error(response)
        } else {
            crate::operation_deser::parse_list_portfolios_for_product_response(response)
        }
    }
}

/// Operation shape for `ListPrincipalsForPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_principals_for_portfolio`](crate::client::Client::list_principals_for_portfolio).
///
/// See [`crate::client::fluent_builders::ListPrincipalsForPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPrincipalsForPortfolio {
    _private: (),
}
impl ListPrincipalsForPortfolio {
    /// Creates a new builder-style object to manufacture [`ListPrincipalsForPortfolioInput`](crate::input::ListPrincipalsForPortfolioInput)
    pub fn builder() -> crate::input::list_principals_for_portfolio_input::Builder {
        crate::input::list_principals_for_portfolio_input::Builder::default()
    }
    /// Creates a new `ListPrincipalsForPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPrincipalsForPortfolio {
    type Output = std::result::Result<
        crate::output::ListPrincipalsForPortfolioOutput,
        crate::error::ListPrincipalsForPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_principals_for_portfolio_error(response)
        } else {
            crate::operation_deser::parse_list_principals_for_portfolio_response(response)
        }
    }
}

/// Operation shape for `ListProvisionedProductPlans`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioned_product_plans`](crate::client::Client::list_provisioned_product_plans).
///
/// See [`crate::client::fluent_builders::ListProvisionedProductPlans`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisionedProductPlans {
    _private: (),
}
impl ListProvisionedProductPlans {
    /// Creates a new builder-style object to manufacture [`ListProvisionedProductPlansInput`](crate::input::ListProvisionedProductPlansInput)
    pub fn builder() -> crate::input::list_provisioned_product_plans_input::Builder {
        crate::input::list_provisioned_product_plans_input::Builder::default()
    }
    /// Creates a new `ListProvisionedProductPlans` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisionedProductPlans {
    type Output = std::result::Result<
        crate::output::ListProvisionedProductPlansOutput,
        crate::error::ListProvisionedProductPlansError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioned_product_plans_error(response)
        } else {
            crate::operation_deser::parse_list_provisioned_product_plans_response(response)
        }
    }
}

/// Operation shape for `ListProvisioningArtifacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioning_artifacts`](crate::client::Client::list_provisioning_artifacts).
///
/// See [`crate::client::fluent_builders::ListProvisioningArtifacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisioningArtifacts {
    _private: (),
}
impl ListProvisioningArtifacts {
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsInput`](crate::input::ListProvisioningArtifactsInput)
    pub fn builder() -> crate::input::list_provisioning_artifacts_input::Builder {
        crate::input::list_provisioning_artifacts_input::Builder::default()
    }
    /// Creates a new `ListProvisioningArtifacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisioningArtifacts {
    type Output = std::result::Result<
        crate::output::ListProvisioningArtifactsOutput,
        crate::error::ListProvisioningArtifactsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioning_artifacts_error(response)
        } else {
            crate::operation_deser::parse_list_provisioning_artifacts_response(response)
        }
    }
}

/// Operation shape for `ListProvisioningArtifactsForServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioning_artifacts_for_service_action`](crate::client::Client::list_provisioning_artifacts_for_service_action).
///
/// See [`crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisioningArtifactsForServiceAction {
    _private: (),
}
impl ListProvisioningArtifactsForServiceAction {
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsForServiceActionInput`](crate::input::ListProvisioningArtifactsForServiceActionInput)
    pub fn builder() -> crate::input::list_provisioning_artifacts_for_service_action_input::Builder
    {
        crate::input::list_provisioning_artifacts_for_service_action_input::Builder::default()
    }
    /// Creates a new `ListProvisioningArtifactsForServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisioningArtifactsForServiceAction {
    type Output = std::result::Result<
        crate::output::ListProvisioningArtifactsForServiceActionOutput,
        crate::error::ListProvisioningArtifactsForServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioning_artifacts_for_service_action_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_provisioning_artifacts_for_service_action_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListRecordHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_record_history`](crate::client::Client::list_record_history).
///
/// See [`crate::client::fluent_builders::ListRecordHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecordHistory {
    _private: (),
}
impl ListRecordHistory {
    /// Creates a new builder-style object to manufacture [`ListRecordHistoryInput`](crate::input::ListRecordHistoryInput)
    pub fn builder() -> crate::input::list_record_history_input::Builder {
        crate::input::list_record_history_input::Builder::default()
    }
    /// Creates a new `ListRecordHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecordHistory {
    type Output = std::result::Result<
        crate::output::ListRecordHistoryOutput,
        crate::error::ListRecordHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_record_history_error(response)
        } else {
            crate::operation_deser::parse_list_record_history_response(response)
        }
    }
}

/// Operation shape for `ListResourcesForTagOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources_for_tag_option`](crate::client::Client::list_resources_for_tag_option).
///
/// See [`crate::client::fluent_builders::ListResourcesForTagOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourcesForTagOption {
    _private: (),
}
impl ListResourcesForTagOption {
    /// Creates a new builder-style object to manufacture [`ListResourcesForTagOptionInput`](crate::input::ListResourcesForTagOptionInput)
    pub fn builder() -> crate::input::list_resources_for_tag_option_input::Builder {
        crate::input::list_resources_for_tag_option_input::Builder::default()
    }
    /// Creates a new `ListResourcesForTagOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourcesForTagOption {
    type Output = std::result::Result<
        crate::output::ListResourcesForTagOptionOutput,
        crate::error::ListResourcesForTagOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_for_tag_option_error(response)
        } else {
            crate::operation_deser::parse_list_resources_for_tag_option_response(response)
        }
    }
}

/// Operation shape for `ListServiceActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_actions`](crate::client::Client::list_service_actions).
///
/// See [`crate::client::fluent_builders::ListServiceActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceActions {
    _private: (),
}
impl ListServiceActions {
    /// Creates a new builder-style object to manufacture [`ListServiceActionsInput`](crate::input::ListServiceActionsInput)
    pub fn builder() -> crate::input::list_service_actions_input::Builder {
        crate::input::list_service_actions_input::Builder::default()
    }
    /// Creates a new `ListServiceActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceActions {
    type Output = std::result::Result<
        crate::output::ListServiceActionsOutput,
        crate::error::ListServiceActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_actions_error(response)
        } else {
            crate::operation_deser::parse_list_service_actions_response(response)
        }
    }
}

/// Operation shape for `ListServiceActionsForProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_actions_for_provisioning_artifact`](crate::client::Client::list_service_actions_for_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceActionsForProvisioningArtifact {
    _private: (),
}
impl ListServiceActionsForProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`ListServiceActionsForProvisioningArtifactInput`](crate::input::ListServiceActionsForProvisioningArtifactInput)
    pub fn builder() -> crate::input::list_service_actions_for_provisioning_artifact_input::Builder
    {
        crate::input::list_service_actions_for_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `ListServiceActionsForProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceActionsForProvisioningArtifact {
    type Output = std::result::Result<
        crate::output::ListServiceActionsForProvisioningArtifactOutput,
        crate::error::ListServiceActionsForProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_actions_for_provisioning_artifact_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_service_actions_for_provisioning_artifact_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListStackInstancesForProvisionedProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stack_instances_for_provisioned_product`](crate::client::Client::list_stack_instances_for_provisioned_product).
///
/// See [`crate::client::fluent_builders::ListStackInstancesForProvisionedProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStackInstancesForProvisionedProduct {
    _private: (),
}
impl ListStackInstancesForProvisionedProduct {
    /// Creates a new builder-style object to manufacture [`ListStackInstancesForProvisionedProductInput`](crate::input::ListStackInstancesForProvisionedProductInput)
    pub fn builder() -> crate::input::list_stack_instances_for_provisioned_product_input::Builder {
        crate::input::list_stack_instances_for_provisioned_product_input::Builder::default()
    }
    /// Creates a new `ListStackInstancesForProvisionedProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStackInstancesForProvisionedProduct {
    type Output = std::result::Result<
        crate::output::ListStackInstancesForProvisionedProductOutput,
        crate::error::ListStackInstancesForProvisionedProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stack_instances_for_provisioned_product_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_stack_instances_for_provisioned_product_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTagOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tag_options`](crate::client::Client::list_tag_options).
///
/// See [`crate::client::fluent_builders::ListTagOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagOptions {
    _private: (),
}
impl ListTagOptions {
    /// Creates a new builder-style object to manufacture [`ListTagOptionsInput`](crate::input::ListTagOptionsInput)
    pub fn builder() -> crate::input::list_tag_options_input::Builder {
        crate::input::list_tag_options_input::Builder::default()
    }
    /// Creates a new `ListTagOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagOptions {
    type Output =
        std::result::Result<crate::output::ListTagOptionsOutput, crate::error::ListTagOptionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tag_options_error(response)
        } else {
            crate::operation_deser::parse_list_tag_options_response(response)
        }
    }
}

/// Operation shape for `ProvisionProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_product`](crate::client::Client::provision_product).
///
/// See [`crate::client::fluent_builders::ProvisionProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionProduct {
    _private: (),
}
impl ProvisionProduct {
    /// Creates a new builder-style object to manufacture [`ProvisionProductInput`](crate::input::ProvisionProductInput)
    pub fn builder() -> crate::input::provision_product_input::Builder {
        crate::input::provision_product_input::Builder::default()
    }
    /// Creates a new `ProvisionProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionProduct {
    type Output = std::result::Result<
        crate::output::ProvisionProductOutput,
        crate::error::ProvisionProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_product_error(response)
        } else {
            crate::operation_deser::parse_provision_product_response(response)
        }
    }
}

/// Operation shape for `RejectPortfolioShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_portfolio_share`](crate::client::Client::reject_portfolio_share).
///
/// See [`crate::client::fluent_builders::RejectPortfolioShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectPortfolioShare {
    _private: (),
}
impl RejectPortfolioShare {
    /// Creates a new builder-style object to manufacture [`RejectPortfolioShareInput`](crate::input::RejectPortfolioShareInput)
    pub fn builder() -> crate::input::reject_portfolio_share_input::Builder {
        crate::input::reject_portfolio_share_input::Builder::default()
    }
    /// Creates a new `RejectPortfolioShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectPortfolioShare {
    type Output = std::result::Result<
        crate::output::RejectPortfolioShareOutput,
        crate::error::RejectPortfolioShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_portfolio_share_error(response)
        } else {
            crate::operation_deser::parse_reject_portfolio_share_response(response)
        }
    }
}

/// Operation shape for `ScanProvisionedProducts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`scan_provisioned_products`](crate::client::Client::scan_provisioned_products).
///
/// See [`crate::client::fluent_builders::ScanProvisionedProducts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ScanProvisionedProducts {
    _private: (),
}
impl ScanProvisionedProducts {
    /// Creates a new builder-style object to manufacture [`ScanProvisionedProductsInput`](crate::input::ScanProvisionedProductsInput)
    pub fn builder() -> crate::input::scan_provisioned_products_input::Builder {
        crate::input::scan_provisioned_products_input::Builder::default()
    }
    /// Creates a new `ScanProvisionedProducts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ScanProvisionedProducts {
    type Output = std::result::Result<
        crate::output::ScanProvisionedProductsOutput,
        crate::error::ScanProvisionedProductsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_scan_provisioned_products_error(response)
        } else {
            crate::operation_deser::parse_scan_provisioned_products_response(response)
        }
    }
}

/// Operation shape for `SearchProducts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_products`](crate::client::Client::search_products).
///
/// See [`crate::client::fluent_builders::SearchProducts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchProducts {
    _private: (),
}
impl SearchProducts {
    /// Creates a new builder-style object to manufacture [`SearchProductsInput`](crate::input::SearchProductsInput)
    pub fn builder() -> crate::input::search_products_input::Builder {
        crate::input::search_products_input::Builder::default()
    }
    /// Creates a new `SearchProducts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchProducts {
    type Output =
        std::result::Result<crate::output::SearchProductsOutput, crate::error::SearchProductsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_products_error(response)
        } else {
            crate::operation_deser::parse_search_products_response(response)
        }
    }
}

/// Operation shape for `SearchProductsAsAdmin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_products_as_admin`](crate::client::Client::search_products_as_admin).
///
/// See [`crate::client::fluent_builders::SearchProductsAsAdmin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchProductsAsAdmin {
    _private: (),
}
impl SearchProductsAsAdmin {
    /// Creates a new builder-style object to manufacture [`SearchProductsAsAdminInput`](crate::input::SearchProductsAsAdminInput)
    pub fn builder() -> crate::input::search_products_as_admin_input::Builder {
        crate::input::search_products_as_admin_input::Builder::default()
    }
    /// Creates a new `SearchProductsAsAdmin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchProductsAsAdmin {
    type Output = std::result::Result<
        crate::output::SearchProductsAsAdminOutput,
        crate::error::SearchProductsAsAdminError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_products_as_admin_error(response)
        } else {
            crate::operation_deser::parse_search_products_as_admin_response(response)
        }
    }
}

/// Operation shape for `SearchProvisionedProducts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_provisioned_products`](crate::client::Client::search_provisioned_products).
///
/// See [`crate::client::fluent_builders::SearchProvisionedProducts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchProvisionedProducts {
    _private: (),
}
impl SearchProvisionedProducts {
    /// Creates a new builder-style object to manufacture [`SearchProvisionedProductsInput`](crate::input::SearchProvisionedProductsInput)
    pub fn builder() -> crate::input::search_provisioned_products_input::Builder {
        crate::input::search_provisioned_products_input::Builder::default()
    }
    /// Creates a new `SearchProvisionedProducts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchProvisionedProducts {
    type Output = std::result::Result<
        crate::output::SearchProvisionedProductsOutput,
        crate::error::SearchProvisionedProductsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_provisioned_products_error(response)
        } else {
            crate::operation_deser::parse_search_provisioned_products_response(response)
        }
    }
}

/// Operation shape for `TerminateProvisionedProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_provisioned_product`](crate::client::Client::terminate_provisioned_product).
///
/// See [`crate::client::fluent_builders::TerminateProvisionedProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateProvisionedProduct {
    _private: (),
}
impl TerminateProvisionedProduct {
    /// Creates a new builder-style object to manufacture [`TerminateProvisionedProductInput`](crate::input::TerminateProvisionedProductInput)
    pub fn builder() -> crate::input::terminate_provisioned_product_input::Builder {
        crate::input::terminate_provisioned_product_input::Builder::default()
    }
    /// Creates a new `TerminateProvisionedProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateProvisionedProduct {
    type Output = std::result::Result<
        crate::output::TerminateProvisionedProductOutput,
        crate::error::TerminateProvisionedProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_provisioned_product_error(response)
        } else {
            crate::operation_deser::parse_terminate_provisioned_product_response(response)
        }
    }
}

/// Operation shape for `UpdateConstraint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_constraint`](crate::client::Client::update_constraint).
///
/// See [`crate::client::fluent_builders::UpdateConstraint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConstraint {
    _private: (),
}
impl UpdateConstraint {
    /// Creates a new builder-style object to manufacture [`UpdateConstraintInput`](crate::input::UpdateConstraintInput)
    pub fn builder() -> crate::input::update_constraint_input::Builder {
        crate::input::update_constraint_input::Builder::default()
    }
    /// Creates a new `UpdateConstraint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConstraint {
    type Output = std::result::Result<
        crate::output::UpdateConstraintOutput,
        crate::error::UpdateConstraintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_constraint_error(response)
        } else {
            crate::operation_deser::parse_update_constraint_response(response)
        }
    }
}

/// Operation shape for `UpdatePortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_portfolio`](crate::client::Client::update_portfolio).
///
/// See [`crate::client::fluent_builders::UpdatePortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePortfolio {
    _private: (),
}
impl UpdatePortfolio {
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioInput`](crate::input::UpdatePortfolioInput)
    pub fn builder() -> crate::input::update_portfolio_input::Builder {
        crate::input::update_portfolio_input::Builder::default()
    }
    /// Creates a new `UpdatePortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePortfolio {
    type Output = std::result::Result<
        crate::output::UpdatePortfolioOutput,
        crate::error::UpdatePortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_portfolio_error(response)
        } else {
            crate::operation_deser::parse_update_portfolio_response(response)
        }
    }
}

/// Operation shape for `UpdatePortfolioShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_portfolio_share`](crate::client::Client::update_portfolio_share).
///
/// See [`crate::client::fluent_builders::UpdatePortfolioShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePortfolioShare {
    _private: (),
}
impl UpdatePortfolioShare {
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioShareInput`](crate::input::UpdatePortfolioShareInput)
    pub fn builder() -> crate::input::update_portfolio_share_input::Builder {
        crate::input::update_portfolio_share_input::Builder::default()
    }
    /// Creates a new `UpdatePortfolioShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePortfolioShare {
    type Output = std::result::Result<
        crate::output::UpdatePortfolioShareOutput,
        crate::error::UpdatePortfolioShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_portfolio_share_error(response)
        } else {
            crate::operation_deser::parse_update_portfolio_share_response(response)
        }
    }
}

/// Operation shape for `UpdateProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_product`](crate::client::Client::update_product).
///
/// See [`crate::client::fluent_builders::UpdateProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProduct {
    _private: (),
}
impl UpdateProduct {
    /// Creates a new builder-style object to manufacture [`UpdateProductInput`](crate::input::UpdateProductInput)
    pub fn builder() -> crate::input::update_product_input::Builder {
        crate::input::update_product_input::Builder::default()
    }
    /// Creates a new `UpdateProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProduct {
    type Output =
        std::result::Result<crate::output::UpdateProductOutput, crate::error::UpdateProductError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_product_error(response)
        } else {
            crate::operation_deser::parse_update_product_response(response)
        }
    }
}

/// Operation shape for `UpdateProvisionedProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_provisioned_product`](crate::client::Client::update_provisioned_product).
///
/// See [`crate::client::fluent_builders::UpdateProvisionedProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProvisionedProduct {
    _private: (),
}
impl UpdateProvisionedProduct {
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductInput`](crate::input::UpdateProvisionedProductInput)
    pub fn builder() -> crate::input::update_provisioned_product_input::Builder {
        crate::input::update_provisioned_product_input::Builder::default()
    }
    /// Creates a new `UpdateProvisionedProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProvisionedProduct {
    type Output = std::result::Result<
        crate::output::UpdateProvisionedProductOutput,
        crate::error::UpdateProvisionedProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_provisioned_product_error(response)
        } else {
            crate::operation_deser::parse_update_provisioned_product_response(response)
        }
    }
}

/// Operation shape for `UpdateProvisionedProductProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_provisioned_product_properties`](crate::client::Client::update_provisioned_product_properties).
///
/// See [`crate::client::fluent_builders::UpdateProvisionedProductProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProvisionedProductProperties {
    _private: (),
}
impl UpdateProvisionedProductProperties {
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductPropertiesInput`](crate::input::UpdateProvisionedProductPropertiesInput)
    pub fn builder() -> crate::input::update_provisioned_product_properties_input::Builder {
        crate::input::update_provisioned_product_properties_input::Builder::default()
    }
    /// Creates a new `UpdateProvisionedProductProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProvisionedProductProperties {
    type Output = std::result::Result<
        crate::output::UpdateProvisionedProductPropertiesOutput,
        crate::error::UpdateProvisionedProductPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_provisioned_product_properties_error(response)
        } else {
            crate::operation_deser::parse_update_provisioned_product_properties_response(response)
        }
    }
}

/// Operation shape for `UpdateProvisioningArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_provisioning_artifact`](crate::client::Client::update_provisioning_artifact).
///
/// See [`crate::client::fluent_builders::UpdateProvisioningArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProvisioningArtifact {
    _private: (),
}
impl UpdateProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningArtifactInput`](crate::input::UpdateProvisioningArtifactInput)
    pub fn builder() -> crate::input::update_provisioning_artifact_input::Builder {
        crate::input::update_provisioning_artifact_input::Builder::default()
    }
    /// Creates a new `UpdateProvisioningArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProvisioningArtifact {
    type Output = std::result::Result<
        crate::output::UpdateProvisioningArtifactOutput,
        crate::error::UpdateProvisioningArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_provisioning_artifact_error(response)
        } else {
            crate::operation_deser::parse_update_provisioning_artifact_response(response)
        }
    }
}

/// Operation shape for `UpdateServiceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_action`](crate::client::Client::update_service_action).
///
/// See [`crate::client::fluent_builders::UpdateServiceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceAction {
    _private: (),
}
impl UpdateServiceAction {
    /// Creates a new builder-style object to manufacture [`UpdateServiceActionInput`](crate::input::UpdateServiceActionInput)
    pub fn builder() -> crate::input::update_service_action_input::Builder {
        crate::input::update_service_action_input::Builder::default()
    }
    /// Creates a new `UpdateServiceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceAction {
    type Output = std::result::Result<
        crate::output::UpdateServiceActionOutput,
        crate::error::UpdateServiceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_action_error(response)
        } else {
            crate::operation_deser::parse_update_service_action_response(response)
        }
    }
}

/// Operation shape for `UpdateTagOption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_tag_option`](crate::client::Client::update_tag_option).
///
/// See [`crate::client::fluent_builders::UpdateTagOption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTagOption {
    _private: (),
}
impl UpdateTagOption {
    /// Creates a new builder-style object to manufacture [`UpdateTagOptionInput`](crate::input::UpdateTagOptionInput)
    pub fn builder() -> crate::input::update_tag_option_input::Builder {
        crate::input::update_tag_option_input::Builder::default()
    }
    /// Creates a new `UpdateTagOption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTagOption {
    type Output = std::result::Result<
        crate::output::UpdateTagOptionOutput,
        crate::error::UpdateTagOptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_tag_option_error(response)
        } else {
            crate::operation_deser::parse_update_tag_option_response(response)
        }
    }
}
