// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Service Catalog
///
/// Client for invoking operations on AWS Service Catalog. Each operation on AWS Service Catalog is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_servicecatalog::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_servicecatalog::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_servicecatalog::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptPortfolioShare`](crate::client::fluent_builders::AcceptPortfolioShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::AcceptPortfolioShare::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::AcceptPortfolioShare::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::AcceptPortfolioShare::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::AcceptPortfolioShare::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`portfolio_share_type(PortfolioShareType)`](crate::client::fluent_builders::AcceptPortfolioShare::portfolio_share_type) / [`set_portfolio_share_type(Option<PortfolioShareType>)`](crate::client::fluent_builders::AcceptPortfolioShare::set_portfolio_share_type): <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>  <ul>   <li> <p> <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your organization.</p> </li>   <li> <p> <code>IMPORTED</code> - Accept imported portfolios.</p> </li>   <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>  </ul>  <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
    /// - On success, responds with [`AcceptPortfolioShareOutput`](crate::output::AcceptPortfolioShareOutput)

    /// - On failure, responds with [`SdkError<AcceptPortfolioShareError>`](crate::error::AcceptPortfolioShareError)
    pub fn accept_portfolio_share(&self) -> fluent_builders::AcceptPortfolioShare {
        fluent_builders::AcceptPortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateBudgetWithResource`](crate::client::fluent_builders::AssociateBudgetWithResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::AssociateBudgetWithResource::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::AssociateBudgetWithResource::set_budget_name): <p>The name of the budget you want to associate.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AssociateBudgetWithResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AssociateBudgetWithResource::set_resource_id): <p> The resource identifier. Either a portfolio-id or a product-id.</p>
    /// - On success, responds with [`AssociateBudgetWithResourceOutput`](crate::output::AssociateBudgetWithResourceOutput)

    /// - On failure, responds with [`SdkError<AssociateBudgetWithResourceError>`](crate::error::AssociateBudgetWithResourceError)
    pub fn associate_budget_with_resource(&self) -> fluent_builders::AssociateBudgetWithResource {
        fluent_builders::AssociateBudgetWithResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociatePrincipalWithPortfolio`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::set_principal_arn): <p>The ARN of the principal (IAM user, role, or group).</p>
    ///   - [`principal_type(PrincipalType)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::principal_type) / [`set_principal_type(Option<PrincipalType>)`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio::set_principal_type): <p>The principal type. The supported value is <code>IAM</code>.</p>
    /// - On success, responds with [`AssociatePrincipalWithPortfolioOutput`](crate::output::AssociatePrincipalWithPortfolioOutput)

    /// - On failure, responds with [`SdkError<AssociatePrincipalWithPortfolioError>`](crate::error::AssociatePrincipalWithPortfolioError)
    pub fn associate_principal_with_portfolio(
        &self,
    ) -> fluent_builders::AssociatePrincipalWithPortfolio {
        fluent_builders::AssociatePrincipalWithPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateProductWithPortfolio`](crate::client::fluent_builders::AssociateProductWithPortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::set_product_id): <p>The product identifier.</p>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`source_portfolio_id(impl Into<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::source_portfolio_id) / [`set_source_portfolio_id(Option<String>)`](crate::client::fluent_builders::AssociateProductWithPortfolio::set_source_portfolio_id): <p>The identifier of the source portfolio.</p>
    /// - On success, responds with [`AssociateProductWithPortfolioOutput`](crate::output::AssociateProductWithPortfolioOutput)

    /// - On failure, responds with [`SdkError<AssociateProductWithPortfolioError>`](crate::error::AssociateProductWithPortfolioError)
    pub fn associate_product_with_portfolio(
        &self,
    ) -> fluent_builders::AssociateProductWithPortfolio {
        fluent_builders::AssociateProductWithPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateServiceActionWithProvisioningArtifact`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::set_product_id): <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    ///   - [`service_action_id(impl Into<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::service_action_id) / [`set_service_action_id(Option<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::set_service_action_id): <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`AssociateServiceActionWithProvisioningArtifactOutput`](crate::output::AssociateServiceActionWithProvisioningArtifactOutput)

    /// - On failure, responds with [`SdkError<AssociateServiceActionWithProvisioningArtifactError>`](crate::error::AssociateServiceActionWithProvisioningArtifactError)
    pub fn associate_service_action_with_provisioning_artifact(
        &self,
    ) -> fluent_builders::AssociateServiceActionWithProvisioningArtifact {
        fluent_builders::AssociateServiceActionWithProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTagOptionWithResource`](crate::client::fluent_builders::AssociateTagOptionWithResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTagOptionWithResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AssociateTagOptionWithResource::set_resource_id): <p>The resource identifier.</p>
    ///   - [`tag_option_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTagOptionWithResource::tag_option_id) / [`set_tag_option_id(Option<String>)`](crate::client::fluent_builders::AssociateTagOptionWithResource::set_tag_option_id): <p>The TagOption identifier.</p>
    /// - On success, responds with [`AssociateTagOptionWithResourceOutput`](crate::output::AssociateTagOptionWithResourceOutput)

    /// - On failure, responds with [`SdkError<AssociateTagOptionWithResourceError>`](crate::error::AssociateTagOptionWithResourceError)
    pub fn associate_tag_option_with_resource(
        &self,
    ) -> fluent_builders::AssociateTagOptionWithResource {
        fluent_builders::AssociateTagOptionWithResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateServiceActionWithProvisioningArtifact`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_action_associations(Vec<ServiceActionAssociation>)`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::service_action_associations) / [`set_service_action_associations(Option<Vec<ServiceActionAssociation>>)`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::set_service_action_associations): <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`BatchAssociateServiceActionWithProvisioningArtifactOutput`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput) with field(s):
    ///   - [`failed_service_action_associations(Option<Vec<FailedServiceActionAssociation>>)`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput::failed_service_action_associations): <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
    /// - On failure, responds with [`SdkError<BatchAssociateServiceActionWithProvisioningArtifactError>`](crate::error::BatchAssociateServiceActionWithProvisioningArtifactError)
    pub fn batch_associate_service_action_with_provisioning_artifact(
        &self,
    ) -> fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact {
        fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`BatchDisassociateServiceActionFromProvisioningArtifact`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_action_associations(Vec<ServiceActionAssociation>)`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::service_action_associations) / [`set_service_action_associations(Option<Vec<ServiceActionAssociation>>)`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::set_service_action_associations): <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`BatchDisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput) with field(s):
    ///   - [`failed_service_action_associations(Option<Vec<FailedServiceActionAssociation>>)`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput::failed_service_action_associations): <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
    /// - On failure, responds with [`SdkError<BatchDisassociateServiceActionFromProvisioningArtifactError>`](crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError)
    pub fn batch_disassociate_service_action_from_provisioning_artifact(
        &self,
    ) -> fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact {
        fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`CopyProduct`](crate::client::fluent_builders::CopyProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CopyProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CopyProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`source_product_arn(impl Into<String>)`](crate::client::fluent_builders::CopyProduct::source_product_arn) / [`set_source_product_arn(Option<String>)`](crate::client::fluent_builders::CopyProduct::set_source_product_arn): <p>The Amazon Resource Name (ARN) of the source product.</p>
    ///   - [`target_product_id(impl Into<String>)`](crate::client::fluent_builders::CopyProduct::target_product_id) / [`set_target_product_id(Option<String>)`](crate::client::fluent_builders::CopyProduct::set_target_product_id): <p>The identifier of the target product. By default, a new product is created.</p>
    ///   - [`target_product_name(impl Into<String>)`](crate::client::fluent_builders::CopyProduct::target_product_name) / [`set_target_product_name(Option<String>)`](crate::client::fluent_builders::CopyProduct::set_target_product_name): <p>A name for the target product. The default is the name of the source product.</p>
    ///   - [`source_provisioning_artifact_identifiers(Vec<HashMap<ProvisioningArtifactPropertyName, String>>)`](crate::client::fluent_builders::CopyProduct::source_provisioning_artifact_identifiers) / [`set_source_provisioning_artifact_identifiers(Option<Vec<HashMap<ProvisioningArtifactPropertyName, String>>>)`](crate::client::fluent_builders::CopyProduct::set_source_provisioning_artifact_identifiers): <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.</p>
    ///   - [`copy_options(Vec<CopyOption>)`](crate::client::fluent_builders::CopyProduct::copy_options) / [`set_copy_options(Option<Vec<CopyOption>>)`](crate::client::fluent_builders::CopyProduct::set_copy_options): <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the target product.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CopyProduct::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CopyProduct::set_idempotency_token): <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. </p>
    /// - On success, responds with [`CopyProductOutput`](crate::output::CopyProductOutput) with field(s):
    ///   - [`copy_product_token(Option<String>)`](crate::output::CopyProductOutput::copy_product_token): <p>The token to use to track the progress of the operation.</p>
    /// - On failure, responds with [`SdkError<CopyProductError>`](crate::error::CopyProductError)
    pub fn copy_product(&self) -> fluent_builders::CopyProduct {
        fluent_builders::CopyProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConstraint`](crate::client::fluent_builders::CreateConstraint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_product_id): <p>The product identifier.</p>
    ///   - [`parameters(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::parameters) / [`set_parameters(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_parameters): <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>  <dl>   <dt>   LAUNCH  </dt>   <dd>    <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>    <p>Specify the <code>RoleArn</code> property as follows:</p>    <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>    <p>Specify the <code>LocalRoleName</code> property as follows:</p>    <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>    <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>     <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>    </note>    <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>    <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>   </dd>   <dt>   NOTIFICATION  </dt>   <dd>    <p>Specify the <code>NotificationArns</code> property as follows:</p>    <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>   </dd>   <dt>   RESOURCE_UPDATE  </dt>   <dd>    <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>    <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>    <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>   </dd>   <dt>   STACKSET  </dt>   <dd>    <p>Specify the <code>Parameters</code> property as follows:</p>    <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>    <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>    <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>    <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>   </dd>   <dt>   TEMPLATE  </dt>   <dd>    <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>   </dd>  </dl>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_type): <p>The type of constraint.</p>  <ul>   <li> <p> <code>LAUNCH</code> </p> </li>   <li> <p> <code>NOTIFICATION</code> </p> </li>   <li> <p> <code>RESOURCE_UPDATE</code> </p> </li>   <li> <p> <code>STACKSET</code> </p> </li>   <li> <p> <code>TEMPLATE</code> </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_description): <p>The description of the constraint.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateConstraint::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateConstraint::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`CreateConstraintOutput`](crate::output::CreateConstraintOutput) with field(s):
    ///   - [`constraint_detail(Option<ConstraintDetail>)`](crate::output::CreateConstraintOutput::constraint_detail): <p>Information about the constraint.</p>
    ///   - [`constraint_parameters(Option<String>)`](crate::output::CreateConstraintOutput::constraint_parameters): <p>The constraint parameters.</p>
    ///   - [`status(Option<Status>)`](crate::output::CreateConstraintOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<CreateConstraintError>`](crate::error::CreateConstraintError)
    pub fn create_constraint(&self) -> fluent_builders::CreateConstraint {
        fluent_builders::CreateConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePortfolio`](crate::client::fluent_builders::CreatePortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreatePortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolio::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreatePortfolio::set_display_name): <p>The name to use for display purposes.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolio::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePortfolio::set_description): <p>The description of the portfolio.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolio::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::CreatePortfolio::set_provider_name): <p>The name of the portfolio provider.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePortfolio::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePortfolio::set_tags): <p>One or more tags.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolio::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreatePortfolio::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`CreatePortfolioOutput`](crate::output::CreatePortfolioOutput) with field(s):
    ///   - [`portfolio_detail(Option<PortfolioDetail>)`](crate::output::CreatePortfolioOutput::portfolio_detail): <p>Information about the portfolio.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreatePortfolioOutput::tags): <p>Information about the tags associated with the portfolio.</p>
    /// - On failure, responds with [`SdkError<CreatePortfolioError>`](crate::error::CreatePortfolioError)
    pub fn create_portfolio(&self) -> fluent_builders::CreatePortfolio {
        fluent_builders::CreatePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePortfolioShare`](crate::client::fluent_builders::CreatePortfolioShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolioShare::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreatePortfolioShare::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolioShare::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::CreatePortfolioShare::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreatePortfolioShare::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreatePortfolioShare::set_account_id): <p>The AWS account ID. For example, <code>123456789012</code>.</p>
    ///   - [`organization_node(OrganizationNode)`](crate::client::fluent_builders::CreatePortfolioShare::organization_node) / [`set_organization_node(Option<OrganizationNode>)`](crate::client::fluent_builders::CreatePortfolioShare::set_organization_node): <p>The organization node to whom you are going to share. If <code>OrganizationNode</code> is passed in, <code>PortfolioShare</code> will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a <code>PortfolioShareToken</code> will be returned in the output in order for the administrator to monitor the status of the <code>PortfolioShare</code> creation process.</p>
    ///   - [`share_tag_options(bool)`](crate::client::fluent_builders::CreatePortfolioShare::share_tag_options) / [`set_share_tag_options(bool)`](crate::client::fluent_builders::CreatePortfolioShare::set_share_tag_options): <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
    /// - On success, responds with [`CreatePortfolioShareOutput`](crate::output::CreatePortfolioShareOutput) with field(s):
    ///   - [`portfolio_share_token(Option<String>)`](crate::output::CreatePortfolioShareOutput::portfolio_share_token): <p>The portfolio shares a unique identifier that only returns if the portfolio is shared to an organization node.</p>
    /// - On failure, responds with [`SdkError<CreatePortfolioShareError>`](crate::error::CreatePortfolioShareError)
    pub fn create_portfolio_share(&self) -> fluent_builders::CreatePortfolioShare {
        fluent_builders::CreatePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProduct`](crate::client::fluent_builders::CreateProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_name): <p>The name of the product.</p>
    ///   - [`owner(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::owner) / [`set_owner(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_owner): <p>The owner of the product.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_description): <p>The description of the product.</p>
    ///   - [`distributor(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::distributor) / [`set_distributor(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_distributor): <p>The distributor of the product.</p>
    ///   - [`support_description(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::support_description) / [`set_support_description(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_support_description): <p>The support information about the product.</p>
    ///   - [`support_email(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::support_email) / [`set_support_email(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_support_email): <p>The contact email for product support.</p>
    ///   - [`support_url(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::support_url) / [`set_support_url(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_support_url): <p>The contact URL for product support.</p>  <p> <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
    ///   - [`product_type(ProductType)`](crate::client::fluent_builders::CreateProduct::product_type) / [`set_product_type(Option<ProductType>)`](crate::client::fluent_builders::CreateProduct::set_product_type): <p>The type of product.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProduct::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProduct::set_tags): <p>One or more tags.</p>
    ///   - [`provisioning_artifact_parameters(ProvisioningArtifactProperties)`](crate::client::fluent_builders::CreateProduct::provisioning_artifact_parameters) / [`set_provisioning_artifact_parameters(Option<ProvisioningArtifactProperties>)`](crate::client::fluent_builders::CreateProduct::set_provisioning_artifact_parameters): <p>The configuration of the provisioning artifact. </p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateProduct::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateProduct::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`CreateProductOutput`](crate::output::CreateProductOutput) with field(s):
    ///   - [`product_view_detail(Option<ProductViewDetail>)`](crate::output::CreateProductOutput::product_view_detail): <p>Information about the product view.</p>
    ///   - [`provisioning_artifact_detail(Option<ProvisioningArtifactDetail>)`](crate::output::CreateProductOutput::provisioning_artifact_detail): <p>Information about the provisioning artifact. </p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateProductOutput::tags): <p>Information about the tags associated with the product.</p>
    /// - On failure, responds with [`SdkError<CreateProductError>`](crate::error::CreateProductError)
    pub fn create_product(&self) -> fluent_builders::CreateProduct {
        fluent_builders::CreateProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProvisionedProductPlan`](crate::client::fluent_builders::CreateProvisionedProductPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`plan_name(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::plan_name) / [`set_plan_name(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_plan_name): <p>The name of the plan.</p>
    ///   - [`plan_type(ProvisionedProductPlanType)`](crate::client::fluent_builders::CreateProvisionedProductPlan::plan_type) / [`set_plan_type(Option<ProvisionedProductPlanType>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_plan_type): <p>The plan type.</p>
    ///   - [`notification_arns(Vec<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::notification_arns) / [`set_notification_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_notification_arns): <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
    ///   - [`path_id(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::path_id) / [`set_path_id(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_path_id): <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>.</p>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_product_id): <p>The product identifier.</p>
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_provisioned_product_name): <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    ///   - [`provisioning_parameters(Vec<UpdateProvisioningParameter>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::provisioning_parameters) / [`set_provisioning_parameters(Option<Vec<UpdateProvisioningParameter>>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_provisioning_parameters): <p>Parameters specified by the administrator that are required for provisioning the product.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProvisionedProductPlan::set_tags): <p>One or more tags.</p>  <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
    /// - On success, responds with [`CreateProvisionedProductPlanOutput`](crate::output::CreateProvisionedProductPlanOutput) with field(s):
    ///   - [`plan_name(Option<String>)`](crate::output::CreateProvisionedProductPlanOutput::plan_name): <p>The name of the plan.</p>
    ///   - [`plan_id(Option<String>)`](crate::output::CreateProvisionedProductPlanOutput::plan_id): <p>The plan identifier.</p>
    ///   - [`provision_product_id(Option<String>)`](crate::output::CreateProvisionedProductPlanOutput::provision_product_id): <p>The product identifier.</p>
    ///   - [`provisioned_product_name(Option<String>)`](crate::output::CreateProvisionedProductPlanOutput::provisioned_product_name): <p>The user-friendly name of the provisioned product.</p>
    ///   - [`provisioning_artifact_id(Option<String>)`](crate::output::CreateProvisionedProductPlanOutput::provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    /// - On failure, responds with [`SdkError<CreateProvisionedProductPlanError>`](crate::error::CreateProvisionedProductPlanError)
    pub fn create_provisioned_product_plan(&self) -> fluent_builders::CreateProvisionedProductPlan {
        fluent_builders::CreateProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProvisioningArtifact`](crate::client::fluent_builders::CreateProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::set_product_id): <p>The product identifier.</p>
    ///   - [`parameters(ProvisioningArtifactProperties)`](crate::client::fluent_builders::CreateProvisioningArtifact::parameters) / [`set_parameters(Option<ProvisioningArtifactProperties>)`](crate::client::fluent_builders::CreateProvisioningArtifact::set_parameters): <p>The configuration for the provisioning artifact.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateProvisioningArtifact::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`CreateProvisioningArtifactOutput`](crate::output::CreateProvisioningArtifactOutput) with field(s):
    ///   - [`provisioning_artifact_detail(Option<ProvisioningArtifactDetail>)`](crate::output::CreateProvisioningArtifactOutput::provisioning_artifact_detail): <p>Information about the provisioning artifact.</p>
    ///   - [`info(Option<HashMap<String, String>>)`](crate::output::CreateProvisioningArtifactOutput::info): <p>Specify the template source with one of the following options, but not both. Keys accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>  <p>The URL of the CloudFormation template in Amazon S3, in JSON format. </p>  <p> <code>LoadTemplateFromURL</code> </p>  <p>Use the URL of the CloudFormation template in Amazon S3 in JSON format.</p>  <p> <code>ImportFromPhysicalId</code> </p>  <p>Use the physical id of the resource that contains the template; currently supports CloudFormation stack ARN.</p>
    ///   - [`status(Option<Status>)`](crate::output::CreateProvisioningArtifactOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<CreateProvisioningArtifactError>`](crate::error::CreateProvisioningArtifactError)
    pub fn create_provisioning_artifact(&self) -> fluent_builders::CreateProvisioningArtifact {
        fluent_builders::CreateProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateServiceAction`](crate::client::fluent_builders::CreateServiceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateServiceAction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateServiceAction::set_name): <p>The self-service action name.</p>
    ///   - [`definition_type(ServiceActionDefinitionType)`](crate::client::fluent_builders::CreateServiceAction::definition_type) / [`set_definition_type(Option<ServiceActionDefinitionType>)`](crate::client::fluent_builders::CreateServiceAction::set_definition_type): <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
    ///   - [`definition(HashMap<ServiceActionDefinitionKey, String>)`](crate::client::fluent_builders::CreateServiceAction::definition) / [`set_definition(Option<HashMap<ServiceActionDefinitionKey, String>>)`](crate::client::fluent_builders::CreateServiceAction::set_definition): <p>The self-service action definition. Can be one of the following:</p>  <dl>   <dt>   Name  </dt>   <dd>    <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>    <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>   </dd>   <dt>   Version  </dt>   <dd>    <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code> </p>   </dd>   <dt>   AssumeRole  </dt>   <dd>    <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>    <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>   </dd>   <dt>   Parameters  </dt>   <dd>    <p>The list of parameters in JSON format.</p>    <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>   </dd>  </dl>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateServiceAction::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateServiceAction::set_description): <p>The self-service action description.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::CreateServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::CreateServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateServiceAction::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateServiceAction::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`CreateServiceActionOutput`](crate::output::CreateServiceActionOutput) with field(s):
    ///   - [`service_action_detail(Option<ServiceActionDetail>)`](crate::output::CreateServiceActionOutput::service_action_detail): <p>An object containing information about the self-service action.</p>
    /// - On failure, responds with [`SdkError<CreateServiceActionError>`](crate::error::CreateServiceActionError)
    pub fn create_service_action(&self) -> fluent_builders::CreateServiceAction {
        fluent_builders::CreateServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTagOption`](crate::client::fluent_builders::CreateTagOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CreateTagOption::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CreateTagOption::set_key): <p>The TagOption key.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::CreateTagOption::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::CreateTagOption::set_value): <p>The TagOption value.</p>
    /// - On success, responds with [`CreateTagOptionOutput`](crate::output::CreateTagOptionOutput) with field(s):
    ///   - [`tag_option_detail(Option<TagOptionDetail>)`](crate::output::CreateTagOptionOutput::tag_option_detail): <p>Information about the TagOption.</p>
    /// - On failure, responds with [`SdkError<CreateTagOptionError>`](crate::error::CreateTagOptionError)
    pub fn create_tag_option(&self) -> fluent_builders::CreateTagOption {
        fluent_builders::CreateTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConstraint`](crate::client::fluent_builders::DeleteConstraint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeleteConstraint::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeleteConstraint::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteConstraint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteConstraint::set_id): <p>The identifier of the constraint.</p>
    /// - On success, responds with [`DeleteConstraintOutput`](crate::output::DeleteConstraintOutput)

    /// - On failure, responds with [`SdkError<DeleteConstraintError>`](crate::error::DeleteConstraintError)
    pub fn delete_constraint(&self) -> fluent_builders::DeleteConstraint {
        fluent_builders::DeleteConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePortfolio`](crate::client::fluent_builders::DeletePortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeletePortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeletePortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePortfolio::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePortfolio::set_id): <p>The portfolio identifier.</p>
    /// - On success, responds with [`DeletePortfolioOutput`](crate::output::DeletePortfolioOutput)

    /// - On failure, responds with [`SdkError<DeletePortfolioError>`](crate::error::DeletePortfolioError)
    pub fn delete_portfolio(&self) -> fluent_builders::DeletePortfolio {
        fluent_builders::DeletePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePortfolioShare`](crate::client::fluent_builders::DeletePortfolioShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeletePortfolioShare::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeletePortfolioShare::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::DeletePortfolioShare::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::DeletePortfolioShare::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeletePortfolioShare::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeletePortfolioShare::set_account_id): <p>The AWS account ID.</p>
    ///   - [`organization_node(OrganizationNode)`](crate::client::fluent_builders::DeletePortfolioShare::organization_node) / [`set_organization_node(Option<OrganizationNode>)`](crate::client::fluent_builders::DeletePortfolioShare::set_organization_node): <p>The organization node to whom you are going to stop sharing.</p>
    /// - On success, responds with [`DeletePortfolioShareOutput`](crate::output::DeletePortfolioShareOutput) with field(s):
    ///   - [`portfolio_share_token(Option<String>)`](crate::output::DeletePortfolioShareOutput::portfolio_share_token): <p>The portfolio share unique identifier. This will only be returned if delete is made to an organization node.</p>
    /// - On failure, responds with [`SdkError<DeletePortfolioShareError>`](crate::error::DeletePortfolioShareError)
    pub fn delete_portfolio_share(&self) -> fluent_builders::DeletePortfolioShare {
        fluent_builders::DeletePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProduct`](crate::client::fluent_builders::DeleteProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeleteProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeleteProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteProduct::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteProduct::set_id): <p>The product identifier.</p>
    /// - On success, responds with [`DeleteProductOutput`](crate::output::DeleteProductOutput)

    /// - On failure, responds with [`SdkError<DeleteProductError>`](crate::error::DeleteProductError)
    pub fn delete_product(&self) -> fluent_builders::DeleteProduct {
        fluent_builders::DeleteProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProvisionedProductPlan`](crate::client::fluent_builders::DeleteProvisionedProductPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`plan_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::plan_id) / [`set_plan_id(Option<String>)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::set_plan_id): <p>The plan identifier.</p>
    ///   - [`ignore_errors(bool)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::ignore_errors) / [`set_ignore_errors(bool)`](crate::client::fluent_builders::DeleteProvisionedProductPlan::set_ignore_errors): <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
    /// - On success, responds with [`DeleteProvisionedProductPlanOutput`](crate::output::DeleteProvisionedProductPlanOutput)

    /// - On failure, responds with [`SdkError<DeleteProvisionedProductPlanError>`](crate::error::DeleteProvisionedProductPlanError)
    pub fn delete_provisioned_product_plan(&self) -> fluent_builders::DeleteProvisionedProductPlan {
        fluent_builders::DeleteProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProvisioningArtifact`](crate::client::fluent_builders::DeleteProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::set_product_id): <p>The product identifier.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::DeleteProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    /// - On success, responds with [`DeleteProvisioningArtifactOutput`](crate::output::DeleteProvisioningArtifactOutput)

    /// - On failure, responds with [`SdkError<DeleteProvisioningArtifactError>`](crate::error::DeleteProvisioningArtifactError)
    pub fn delete_provisioning_artifact(&self) -> fluent_builders::DeleteProvisioningArtifact {
        fluent_builders::DeleteProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteServiceAction`](crate::client::fluent_builders::DeleteServiceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceAction::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteServiceAction::set_id): <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DeleteServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`DeleteServiceActionOutput`](crate::output::DeleteServiceActionOutput)

    /// - On failure, responds with [`SdkError<DeleteServiceActionError>`](crate::error::DeleteServiceActionError)
    pub fn delete_service_action(&self) -> fluent_builders::DeleteServiceAction {
        fluent_builders::DeleteServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTagOption`](crate::client::fluent_builders::DeleteTagOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteTagOption::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteTagOption::set_id): <p>The TagOption identifier.</p>
    /// - On success, responds with [`DeleteTagOptionOutput`](crate::output::DeleteTagOptionOutput)

    /// - On failure, responds with [`SdkError<DeleteTagOptionError>`](crate::error::DeleteTagOptionError)
    pub fn delete_tag_option(&self) -> fluent_builders::DeleteTagOption {
        fluent_builders::DeleteTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConstraint`](crate::client::fluent_builders::DescribeConstraint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeConstraint::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeConstraint::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeConstraint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeConstraint::set_id): <p>The identifier of the constraint.</p>
    /// - On success, responds with [`DescribeConstraintOutput`](crate::output::DescribeConstraintOutput) with field(s):
    ///   - [`constraint_detail(Option<ConstraintDetail>)`](crate::output::DescribeConstraintOutput::constraint_detail): <p>Information about the constraint.</p>
    ///   - [`constraint_parameters(Option<String>)`](crate::output::DescribeConstraintOutput::constraint_parameters): <p>The constraint parameters.</p>
    ///   - [`status(Option<Status>)`](crate::output::DescribeConstraintOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<DescribeConstraintError>`](crate::error::DescribeConstraintError)
    pub fn describe_constraint(&self) -> fluent_builders::DescribeConstraint {
        fluent_builders::DescribeConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCopyProductStatus`](crate::client::fluent_builders::DescribeCopyProductStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeCopyProductStatus::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeCopyProductStatus::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`copy_product_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCopyProductStatus::copy_product_token) / [`set_copy_product_token(Option<String>)`](crate::client::fluent_builders::DescribeCopyProductStatus::set_copy_product_token): <p>The token for the copy product operation. This token is returned by <code>CopyProduct</code>.</p>
    /// - On success, responds with [`DescribeCopyProductStatusOutput`](crate::output::DescribeCopyProductStatusOutput) with field(s):
    ///   - [`copy_product_status(Option<CopyProductStatus>)`](crate::output::DescribeCopyProductStatusOutput::copy_product_status): <p>The status of the copy product operation.</p>
    ///   - [`target_product_id(Option<String>)`](crate::output::DescribeCopyProductStatusOutput::target_product_id): <p>The identifier of the copied product.</p>
    ///   - [`status_detail(Option<String>)`](crate::output::DescribeCopyProductStatusOutput::status_detail): <p>The status message.</p>
    /// - On failure, responds with [`SdkError<DescribeCopyProductStatusError>`](crate::error::DescribeCopyProductStatusError)
    pub fn describe_copy_product_status(&self) -> fluent_builders::DescribeCopyProductStatus {
        fluent_builders::DescribeCopyProductStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePortfolio`](crate::client::fluent_builders::DescribePortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribePortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribePortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribePortfolio::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribePortfolio::set_id): <p>The portfolio identifier.</p>
    /// - On success, responds with [`DescribePortfolioOutput`](crate::output::DescribePortfolioOutput) with field(s):
    ///   - [`portfolio_detail(Option<PortfolioDetail>)`](crate::output::DescribePortfolioOutput::portfolio_detail): <p>Information about the portfolio.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribePortfolioOutput::tags): <p>Information about the tags associated with the portfolio.</p>
    ///   - [`tag_options(Option<Vec<TagOptionDetail>>)`](crate::output::DescribePortfolioOutput::tag_options): <p>Information about the TagOptions associated with the portfolio.</p>
    ///   - [`budgets(Option<Vec<BudgetDetail>>)`](crate::output::DescribePortfolioOutput::budgets): <p>Information about the associated budgets.</p>
    /// - On failure, responds with [`SdkError<DescribePortfolioError>`](crate::error::DescribePortfolioError)
    pub fn describe_portfolio(&self) -> fluent_builders::DescribePortfolio {
        fluent_builders::DescribePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePortfolioShares`](crate::client::fluent_builders::DescribePortfolioShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePortfolioShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::DescribePortfolioShares::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::DescribePortfolioShares::set_portfolio_id): <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
    ///   - [`r#type(DescribePortfolioShareType)`](crate::client::fluent_builders::DescribePortfolioShares::type) / [`set_type(Option<DescribePortfolioShareType>)`](crate::client::fluent_builders::DescribePortfolioShares::set_type): <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>  <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>  <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>  <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>  <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::DescribePortfolioShares::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::DescribePortfolioShares::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribePortfolioShares::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::DescribePortfolioShares::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`DescribePortfolioSharesOutput`](crate::output::DescribePortfolioSharesOutput) with field(s):
    ///   - [`next_page_token(Option<String>)`](crate::output::DescribePortfolioSharesOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    ///   - [`portfolio_share_details(Option<Vec<PortfolioShareDetail>>)`](crate::output::DescribePortfolioSharesOutput::portfolio_share_details): <p>Summaries about each of the portfolio shares.</p>
    /// - On failure, responds with [`SdkError<DescribePortfolioSharesError>`](crate::error::DescribePortfolioSharesError)
    pub fn describe_portfolio_shares(&self) -> fluent_builders::DescribePortfolioShares {
        fluent_builders::DescribePortfolioShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePortfolioShareStatus`](crate::client::fluent_builders::DescribePortfolioShareStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portfolio_share_token(impl Into<String>)`](crate::client::fluent_builders::DescribePortfolioShareStatus::portfolio_share_token) / [`set_portfolio_share_token(Option<String>)`](crate::client::fluent_builders::DescribePortfolioShareStatus::set_portfolio_share_token): <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
    /// - On success, responds with [`DescribePortfolioShareStatusOutput`](crate::output::DescribePortfolioShareStatusOutput) with field(s):
    ///   - [`portfolio_share_token(Option<String>)`](crate::output::DescribePortfolioShareStatusOutput::portfolio_share_token): <p>The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.</p>
    ///   - [`portfolio_id(Option<String>)`](crate::output::DescribePortfolioShareStatusOutput::portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`organization_node_value(Option<String>)`](crate::output::DescribePortfolioShareStatusOutput::organization_node_value): <p>Organization node identifier. It can be either account id, organizational unit id or organization id.</p>
    ///   - [`status(Option<ShareStatus>)`](crate::output::DescribePortfolioShareStatusOutput::status): <p>Status of the portfolio share operation.</p>
    ///   - [`share_details(Option<ShareDetails>)`](crate::output::DescribePortfolioShareStatusOutput::share_details): <p>Information about the portfolio share operation.</p>
    /// - On failure, responds with [`SdkError<DescribePortfolioShareStatusError>`](crate::error::DescribePortfolioShareStatusError)
    pub fn describe_portfolio_share_status(&self) -> fluent_builders::DescribePortfolioShareStatus {
        fluent_builders::DescribePortfolioShareStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProduct`](crate::client::fluent_builders::DescribeProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeProduct::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeProduct::set_id): <p>The product identifier.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeProduct::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeProduct::set_name): <p>The product name.</p>
    /// - On success, responds with [`DescribeProductOutput`](crate::output::DescribeProductOutput) with field(s):
    ///   - [`product_view_summary(Option<ProductViewSummary>)`](crate::output::DescribeProductOutput::product_view_summary): <p>Summary information about the product view.</p>
    ///   - [`provisioning_artifacts(Option<Vec<ProvisioningArtifact>>)`](crate::output::DescribeProductOutput::provisioning_artifacts): <p>Information about the provisioning artifacts for the specified product.</p>
    ///   - [`budgets(Option<Vec<BudgetDetail>>)`](crate::output::DescribeProductOutput::budgets): <p>Information about the associated budgets.</p>
    ///   - [`launch_paths(Option<Vec<LaunchPath>>)`](crate::output::DescribeProductOutput::launch_paths): <p>Information about the associated launch paths.</p>
    /// - On failure, responds with [`SdkError<DescribeProductError>`](crate::error::DescribeProductError)
    pub fn describe_product(&self) -> fluent_builders::DescribeProduct {
        fluent_builders::DescribeProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProductAsAdmin`](crate::client::fluent_builders::DescribeProductAsAdmin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::set_id): <p>The product identifier.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::set_name): <p>The product name.</p>
    ///   - [`source_portfolio_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::source_portfolio_id) / [`set_source_portfolio_id(Option<String>)`](crate::client::fluent_builders::DescribeProductAsAdmin::set_source_portfolio_id): <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>  <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
    /// - On success, responds with [`DescribeProductAsAdminOutput`](crate::output::DescribeProductAsAdminOutput) with field(s):
    ///   - [`product_view_detail(Option<ProductViewDetail>)`](crate::output::DescribeProductAsAdminOutput::product_view_detail): <p>Information about the product view.</p>
    ///   - [`provisioning_artifact_summaries(Option<Vec<ProvisioningArtifactSummary>>)`](crate::output::DescribeProductAsAdminOutput::provisioning_artifact_summaries): <p>Information about the provisioning artifacts (also known as versions) for the specified product.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeProductAsAdminOutput::tags): <p>Information about the tags associated with the product.</p>
    ///   - [`tag_options(Option<Vec<TagOptionDetail>>)`](crate::output::DescribeProductAsAdminOutput::tag_options): <p>Information about the TagOptions associated with the product.</p>
    ///   - [`budgets(Option<Vec<BudgetDetail>>)`](crate::output::DescribeProductAsAdminOutput::budgets): <p>Information about the associated budgets.</p>
    /// - On failure, responds with [`SdkError<DescribeProductAsAdminError>`](crate::error::DescribeProductAsAdminError)
    pub fn describe_product_as_admin(&self) -> fluent_builders::DescribeProductAsAdmin {
        fluent_builders::DescribeProductAsAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProductView`](crate::client::fluent_builders::DescribeProductView) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProductView::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProductView::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeProductView::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeProductView::set_id): <p>The product view identifier.</p>
    /// - On success, responds with [`DescribeProductViewOutput`](crate::output::DescribeProductViewOutput) with field(s):
    ///   - [`product_view_summary(Option<ProductViewSummary>)`](crate::output::DescribeProductViewOutput::product_view_summary): <p>Summary information about the product.</p>
    ///   - [`provisioning_artifacts(Option<Vec<ProvisioningArtifact>>)`](crate::output::DescribeProductViewOutput::provisioning_artifacts): <p>Information about the provisioning artifacts for the product.</p>
    /// - On failure, responds with [`SdkError<DescribeProductViewError>`](crate::error::DescribeProductViewError)
    pub fn describe_product_view(&self) -> fluent_builders::DescribeProductView {
        fluent_builders::DescribeProductView::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisionedProduct`](crate::client::fluent_builders::DescribeProvisionedProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::set_id): <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>  <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProduct::set_name): <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>  <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    /// - On success, responds with [`DescribeProvisionedProductOutput`](crate::output::DescribeProvisionedProductOutput) with field(s):
    ///   - [`provisioned_product_detail(Option<ProvisionedProductDetail>)`](crate::output::DescribeProvisionedProductOutput::provisioned_product_detail): <p>Information about the provisioned product.</p>
    ///   - [`cloud_watch_dashboards(Option<Vec<CloudWatchDashboard>>)`](crate::output::DescribeProvisionedProductOutput::cloud_watch_dashboards): <p>Any CloudWatch dashboards that were created when provisioning the product.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisionedProductError>`](crate::error::DescribeProvisionedProductError)
    pub fn describe_provisioned_product(&self) -> fluent_builders::DescribeProvisionedProduct {
        fluent_builders::DescribeProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisionedProductPlan`](crate::client::fluent_builders::DescribeProvisionedProductPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`plan_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::plan_id) / [`set_plan_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::set_plan_id): <p>The plan identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::DescribeProvisionedProductPlan::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`DescribeProvisionedProductPlanOutput`](crate::output::DescribeProvisionedProductPlanOutput) with field(s):
    ///   - [`provisioned_product_plan_details(Option<ProvisionedProductPlanDetails>)`](crate::output::DescribeProvisionedProductPlanOutput::provisioned_product_plan_details): <p>Information about the plan.</p>
    ///   - [`resource_changes(Option<Vec<ResourceChange>>)`](crate::output::DescribeProvisionedProductPlanOutput::resource_changes): <p>Information about the resource changes that will occur when the plan is executed.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::DescribeProvisionedProductPlanOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisionedProductPlanError>`](crate::error::DescribeProvisionedProductPlanError)
    pub fn describe_provisioned_product_plan(
        &self,
    ) -> fluent_builders::DescribeProvisionedProductPlan {
        fluent_builders::DescribeProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisioningArtifact`](crate::client::fluent_builders::DescribeProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_product_id): <p>The product identifier.</p>
    ///   - [`provisioning_artifact_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::provisioning_artifact_name) / [`set_provisioning_artifact_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_provisioning_artifact_name): <p>The provisioning artifact name.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_product_name): <p>The product name.</p>
    ///   - [`verbose(bool)`](crate::client::fluent_builders::DescribeProvisioningArtifact::verbose) / [`set_verbose(bool)`](crate::client::fluent_builders::DescribeProvisioningArtifact::set_verbose): <p>Indicates whether a verbose level of detail is enabled.</p>
    /// - On success, responds with [`DescribeProvisioningArtifactOutput`](crate::output::DescribeProvisioningArtifactOutput) with field(s):
    ///   - [`provisioning_artifact_detail(Option<ProvisioningArtifactDetail>)`](crate::output::DescribeProvisioningArtifactOutput::provisioning_artifact_detail): <p>Information about the provisioning artifact.</p>
    ///   - [`info(Option<HashMap<String, String>>)`](crate::output::DescribeProvisioningArtifactOutput::info): <p>The URL of the CloudFormation template in Amazon S3.</p>
    ///   - [`status(Option<Status>)`](crate::output::DescribeProvisioningArtifactOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisioningArtifactError>`](crate::error::DescribeProvisioningArtifactError)
    pub fn describe_provisioning_artifact(&self) -> fluent_builders::DescribeProvisioningArtifact {
        fluent_builders::DescribeProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisioningParameters`](crate::client::fluent_builders::DescribeProvisioningParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_product_id): <p>The product identifier. You must provide the product name or ID, but not both.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_product_name): <p>The name of the product. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_artifact_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::provisioning_artifact_name) / [`set_provisioning_artifact_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_provisioning_artifact_name): <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    ///   - [`path_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::path_id) / [`set_path_id(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_path_id): <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    ///   - [`path_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::path_name) / [`set_path_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningParameters::set_path_name): <p>The name of the path. You must provide the name or ID, but not both.</p>
    /// - On success, responds with [`DescribeProvisioningParametersOutput`](crate::output::DescribeProvisioningParametersOutput) with field(s):
    ///   - [`provisioning_artifact_parameters(Option<Vec<ProvisioningArtifactParameter>>)`](crate::output::DescribeProvisioningParametersOutput::provisioning_artifact_parameters): <p>Information about the parameters used to provision the product.</p>
    ///   - [`constraint_summaries(Option<Vec<ConstraintSummary>>)`](crate::output::DescribeProvisioningParametersOutput::constraint_summaries): <p>Information about the constraints used to provision the product.</p>
    ///   - [`usage_instructions(Option<Vec<UsageInstruction>>)`](crate::output::DescribeProvisioningParametersOutput::usage_instructions): <p>Any additional metadata specifically related to the provisioning of the product. For example, see the <code>Version</code> field of the CloudFormation template.</p>
    ///   - [`tag_options(Option<Vec<TagOptionSummary>>)`](crate::output::DescribeProvisioningParametersOutput::tag_options): <p>Information about the TagOptions associated with the resource.</p>
    ///   - [`provisioning_artifact_preferences(Option<ProvisioningArtifactPreferences>)`](crate::output::DescribeProvisioningParametersOutput::provisioning_artifact_preferences): <p>An object that contains information about preferences, such as regions and accounts, for the provisioning artifact.</p>
    ///   - [`provisioning_artifact_outputs(Option<Vec<ProvisioningArtifactOutput>>)`](crate::output::DescribeProvisioningParametersOutput::provisioning_artifact_outputs): <p>The output of the provisioning artifact.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisioningParametersError>`](crate::error::DescribeProvisioningParametersError)
    pub fn describe_provisioning_parameters(
        &self,
    ) -> fluent_builders::DescribeProvisioningParameters {
        fluent_builders::DescribeProvisioningParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRecord`](crate::client::fluent_builders::DescribeRecord) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeRecord::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeRecord::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeRecord::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeRecord::set_id): <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRecord::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::DescribeRecord::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::DescribeRecord::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::DescribeRecord::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`DescribeRecordOutput`](crate::output::DescribeRecordOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::DescribeRecordOutput::record_detail): <p>Information about the product.</p>
    ///   - [`record_outputs(Option<Vec<RecordOutput>>)`](crate::output::DescribeRecordOutput::record_outputs): <p>Information about the product created as the result of a request. For example, the output for a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::DescribeRecordOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeRecordError>`](crate::error::DescribeRecordError)
    pub fn describe_record(&self) -> fluent_builders::DescribeRecord {
        fluent_builders::DescribeRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServiceAction`](crate::client::fluent_builders::DescribeServiceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceAction::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeServiceAction::set_id): <p>The self-service action identifier.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`DescribeServiceActionOutput`](crate::output::DescribeServiceActionOutput) with field(s):
    ///   - [`service_action_detail(Option<ServiceActionDetail>)`](crate::output::DescribeServiceActionOutput::service_action_detail): <p>Detailed information about the self-service action.</p>
    /// - On failure, responds with [`SdkError<DescribeServiceActionError>`](crate::error::DescribeServiceActionError)
    pub fn describe_service_action(&self) -> fluent_builders::DescribeServiceAction {
        fluent_builders::DescribeServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServiceActionExecutionParameters`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::set_provisioned_product_id): <p>The identifier of the provisioned product.</p>
    ///   - [`service_action_id(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::service_action_id) / [`set_service_action_id(Option<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::set_service_action_id): <p>The self-service action identifier.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`DescribeServiceActionExecutionParametersOutput`](crate::output::DescribeServiceActionExecutionParametersOutput) with field(s):
    ///   - [`service_action_parameters(Option<Vec<ExecutionParameter>>)`](crate::output::DescribeServiceActionExecutionParametersOutput::service_action_parameters): <p>The parameters of the self-service action.</p>
    /// - On failure, responds with [`SdkError<DescribeServiceActionExecutionParametersError>`](crate::error::DescribeServiceActionExecutionParametersError)
    pub fn describe_service_action_execution_parameters(
        &self,
    ) -> fluent_builders::DescribeServiceActionExecutionParameters {
        fluent_builders::DescribeServiceActionExecutionParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTagOption`](crate::client::fluent_builders::DescribeTagOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeTagOption::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeTagOption::set_id): <p>The TagOption identifier.</p>
    /// - On success, responds with [`DescribeTagOptionOutput`](crate::output::DescribeTagOptionOutput) with field(s):
    ///   - [`tag_option_detail(Option<TagOptionDetail>)`](crate::output::DescribeTagOptionOutput::tag_option_detail): <p>Information about the TagOption.</p>
    /// - On failure, responds with [`SdkError<DescribeTagOptionError>`](crate::error::DescribeTagOptionError)
    pub fn describe_tag_option(&self) -> fluent_builders::DescribeTagOption {
        fluent_builders::DescribeTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableAWSOrganizationsAccess`](crate::client::fluent_builders::DisableAWSOrganizationsAccess) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableAWSOrganizationsAccess::send) it.

    /// - On success, responds with [`DisableAwsOrganizationsAccessOutput`](crate::output::DisableAwsOrganizationsAccessOutput)

    /// - On failure, responds with [`SdkError<DisableAWSOrganizationsAccessError>`](crate::error::DisableAWSOrganizationsAccessError)
    pub fn disable_aws_organizations_access(
        &self,
    ) -> fluent_builders::DisableAWSOrganizationsAccess {
        fluent_builders::DisableAWSOrganizationsAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateBudgetFromResource`](crate::client::fluent_builders::DisassociateBudgetFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`budget_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateBudgetFromResource::budget_name) / [`set_budget_name(Option<String>)`](crate::client::fluent_builders::DisassociateBudgetFromResource::set_budget_name): <p>The name of the budget you want to disassociate.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateBudgetFromResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DisassociateBudgetFromResource::set_resource_id): <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
    /// - On success, responds with [`DisassociateBudgetFromResourceOutput`](crate::output::DisassociateBudgetFromResourceOutput)

    /// - On failure, responds with [`SdkError<DisassociateBudgetFromResourceError>`](crate::error::DisassociateBudgetFromResourceError)
    pub fn disassociate_budget_from_resource(
        &self,
    ) -> fluent_builders::DisassociateBudgetFromResource {
        fluent_builders::DisassociateBudgetFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociatePrincipalFromPortfolio`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio::set_principal_arn): <p>The ARN of the principal (IAM user, role, or group).</p>
    /// - On success, responds with [`DisassociatePrincipalFromPortfolioOutput`](crate::output::DisassociatePrincipalFromPortfolioOutput)

    /// - On failure, responds with [`SdkError<DisassociatePrincipalFromPortfolioError>`](crate::error::DisassociatePrincipalFromPortfolioError)
    pub fn disassociate_principal_from_portfolio(
        &self,
    ) -> fluent_builders::DisassociatePrincipalFromPortfolio {
        fluent_builders::DisassociatePrincipalFromPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateProductFromPortfolio`](crate::client::fluent_builders::DisassociateProductFromPortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::set_product_id): <p>The product identifier.</p>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::DisassociateProductFromPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    /// - On success, responds with [`DisassociateProductFromPortfolioOutput`](crate::output::DisassociateProductFromPortfolioOutput)

    /// - On failure, responds with [`SdkError<DisassociateProductFromPortfolioError>`](crate::error::DisassociateProductFromPortfolioError)
    pub fn disassociate_product_from_portfolio(
        &self,
    ) -> fluent_builders::DisassociateProductFromPortfolio {
        fluent_builders::DisassociateProductFromPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateServiceActionFromProvisioningArtifact`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::set_product_id): <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    ///   - [`service_action_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::service_action_id) / [`set_service_action_id(Option<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::set_service_action_id): <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`DisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::DisassociateServiceActionFromProvisioningArtifactOutput)

    /// - On failure, responds with [`SdkError<DisassociateServiceActionFromProvisioningArtifactError>`](crate::error::DisassociateServiceActionFromProvisioningArtifactError)
    pub fn disassociate_service_action_from_provisioning_artifact(
        &self,
    ) -> fluent_builders::DisassociateServiceActionFromProvisioningArtifact {
        fluent_builders::DisassociateServiceActionFromProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTagOptionFromResource`](crate::client::fluent_builders::DisassociateTagOptionFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTagOptionFromResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DisassociateTagOptionFromResource::set_resource_id): <p>The resource identifier.</p>
    ///   - [`tag_option_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTagOptionFromResource::tag_option_id) / [`set_tag_option_id(Option<String>)`](crate::client::fluent_builders::DisassociateTagOptionFromResource::set_tag_option_id): <p>The TagOption identifier.</p>
    /// - On success, responds with [`DisassociateTagOptionFromResourceOutput`](crate::output::DisassociateTagOptionFromResourceOutput)

    /// - On failure, responds with [`SdkError<DisassociateTagOptionFromResourceError>`](crate::error::DisassociateTagOptionFromResourceError)
    pub fn disassociate_tag_option_from_resource(
        &self,
    ) -> fluent_builders::DisassociateTagOptionFromResource {
        fluent_builders::DisassociateTagOptionFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableAWSOrganizationsAccess`](crate::client::fluent_builders::EnableAWSOrganizationsAccess) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::EnableAWSOrganizationsAccess::send) it.

    /// - On success, responds with [`EnableAwsOrganizationsAccessOutput`](crate::output::EnableAwsOrganizationsAccessOutput)

    /// - On failure, responds with [`SdkError<EnableAWSOrganizationsAccessError>`](crate::error::EnableAWSOrganizationsAccessError)
    pub fn enable_aws_organizations_access(&self) -> fluent_builders::EnableAWSOrganizationsAccess {
        fluent_builders::EnableAWSOrganizationsAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteProvisionedProductPlan`](crate::client::fluent_builders::ExecuteProvisionedProductPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`plan_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::plan_id) / [`set_plan_id(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::set_plan_id): <p>The plan identifier.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductPlan::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`ExecuteProvisionedProductPlanOutput`](crate::output::ExecuteProvisionedProductPlanOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::ExecuteProvisionedProductPlanOutput::record_detail): <p>Information about the result of provisioning the product.</p>
    /// - On failure, responds with [`SdkError<ExecuteProvisionedProductPlanError>`](crate::error::ExecuteProvisionedProductPlanError)
    pub fn execute_provisioned_product_plan(
        &self,
    ) -> fluent_builders::ExecuteProvisionedProductPlan {
        fluent_builders::ExecuteProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteProvisionedProductServiceAction`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::set_provisioned_product_id): <p>The identifier of the provisioned product.</p>
    ///   - [`service_action_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::service_action_id) / [`set_service_action_id(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::set_service_action_id): <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    ///   - [`execute_token(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::execute_token) / [`set_execute_token(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::set_execute_token): <p>An idempotency token that uniquely identifies the execute request.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction::set_parameters): <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
    /// - On success, responds with [`ExecuteProvisionedProductServiceActionOutput`](crate::output::ExecuteProvisionedProductServiceActionOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::ExecuteProvisionedProductServiceActionOutput::record_detail): <p>An object containing detailed information about the result of provisioning the product.</p>
    /// - On failure, responds with [`SdkError<ExecuteProvisionedProductServiceActionError>`](crate::error::ExecuteProvisionedProductServiceActionError)
    pub fn execute_provisioned_product_service_action(
        &self,
    ) -> fluent_builders::ExecuteProvisionedProductServiceAction {
        fluent_builders::ExecuteProvisionedProductServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAWSOrganizationsAccessStatus`](crate::client::fluent_builders::GetAWSOrganizationsAccessStatus) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAWSOrganizationsAccessStatus::send) it.

    /// - On success, responds with [`GetAwsOrganizationsAccessStatusOutput`](crate::output::GetAwsOrganizationsAccessStatusOutput) with field(s):
    ///   - [`access_status(Option<AccessStatus>)`](crate::output::GetAwsOrganizationsAccessStatusOutput::access_status): <p>The status of the portfolio share feature.</p>
    /// - On failure, responds with [`SdkError<GetAWSOrganizationsAccessStatusError>`](crate::error::GetAWSOrganizationsAccessStatusError)
    pub fn get_aws_organizations_access_status(
        &self,
    ) -> fluent_builders::GetAWSOrganizationsAccessStatus {
        fluent_builders::GetAWSOrganizationsAccessStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProvisionedProductOutputs`](crate::client::fluent_builders::GetProvisionedProductOutputs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetProvisionedProductOutputs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_provisioned_product_id): <p>The identifier of the provisioned product that you want the outputs from.</p>
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_provisioned_product_name): <p>The name of the provisioned product that you want the outputs from.</p>
    ///   - [`output_keys(Vec<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::output_keys) / [`set_output_keys(Option<Vec<String>>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_output_keys): <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetProvisionedProductOutputs::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::GetProvisionedProductOutputs::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`GetProvisionedProductOutputsOutput`](crate::output::GetProvisionedProductOutputsOutput) with field(s):
    ///   - [`outputs(Option<Vec<RecordOutput>>)`](crate::output::GetProvisionedProductOutputsOutput::outputs): <p>Information about the product created as the result of a request. For example, the output for a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL. </p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetProvisionedProductOutputsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<GetProvisionedProductOutputsError>`](crate::error::GetProvisionedProductOutputsError)
    pub fn get_provisioned_product_outputs(&self) -> fluent_builders::GetProvisionedProductOutputs {
        fluent_builders::GetProvisionedProductOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportAsProvisionedProduct`](crate::client::fluent_builders::ImportAsProvisionedProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_product_id): <p>The product identifier.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_provisioned_product_name): <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
    ///   - [`physical_id(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::physical_id) / [`set_physical_id(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_physical_id): <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::ImportAsProvisionedProduct::set_idempotency_token): <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    /// - On success, responds with [`ImportAsProvisionedProductOutput`](crate::output::ImportAsProvisionedProductOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::ImportAsProvisionedProductOutput::record_detail): <p>Information about a request operation.</p>
    /// - On failure, responds with [`SdkError<ImportAsProvisionedProductError>`](crate::error::ImportAsProvisionedProductError)
    pub fn import_as_provisioned_product(&self) -> fluent_builders::ImportAsProvisionedProduct {
        fluent_builders::ImportAsProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAcceptedPortfolioShares`](crate::client::fluent_builders::ListAcceptedPortfolioShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAcceptedPortfolioShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`portfolio_share_type(PortfolioShareType)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::portfolio_share_type) / [`set_portfolio_share_type(Option<PortfolioShareType>)`](crate::client::fluent_builders::ListAcceptedPortfolioShares::set_portfolio_share_type): <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>  <ul>   <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>   <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>   <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>  </ul>
    /// - On success, responds with [`ListAcceptedPortfolioSharesOutput`](crate::output::ListAcceptedPortfolioSharesOutput) with field(s):
    ///   - [`portfolio_details(Option<Vec<PortfolioDetail>>)`](crate::output::ListAcceptedPortfolioSharesOutput::portfolio_details): <p>Information about the portfolios.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListAcceptedPortfolioSharesOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListAcceptedPortfolioSharesError>`](crate::error::ListAcceptedPortfolioSharesError)
    pub fn list_accepted_portfolio_shares(&self) -> fluent_builders::ListAcceptedPortfolioShares {
        fluent_builders::ListAcceptedPortfolioShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBudgetsForResource`](crate::client::fluent_builders::ListBudgetsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBudgetsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListBudgetsForResource::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListBudgetsForResource::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListBudgetsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListBudgetsForResource::set_resource_id): <p>The resource identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListBudgetsForResource::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListBudgetsForResource::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListBudgetsForResource::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListBudgetsForResource::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListBudgetsForResourceOutput`](crate::output::ListBudgetsForResourceOutput) with field(s):
    ///   - [`budgets(Option<Vec<BudgetDetail>>)`](crate::output::ListBudgetsForResourceOutput::budgets): <p>Information about the associated budgets.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListBudgetsForResourceOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListBudgetsForResourceError>`](crate::error::ListBudgetsForResourceError)
    pub fn list_budgets_for_resource(&self) -> fluent_builders::ListBudgetsForResource {
        fluent_builders::ListBudgetsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConstraintsForPortfolio`](crate::client::fluent_builders::ListConstraintsForPortfolio) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConstraintsForPortfolio::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::set_product_id): <p>The product identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListConstraintsForPortfolio::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListConstraintsForPortfolio::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListConstraintsForPortfolio::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListConstraintsForPortfolioOutput`](crate::output::ListConstraintsForPortfolioOutput) with field(s):
    ///   - [`constraint_details(Option<Vec<ConstraintDetail>>)`](crate::output::ListConstraintsForPortfolioOutput::constraint_details): <p>Information about the constraints.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListConstraintsForPortfolioOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListConstraintsForPortfolioError>`](crate::error::ListConstraintsForPortfolioError)
    pub fn list_constraints_for_portfolio(&self) -> fluent_builders::ListConstraintsForPortfolio {
        fluent_builders::ListConstraintsForPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLaunchPaths`](crate::client::fluent_builders::ListLaunchPaths) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLaunchPaths::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListLaunchPaths::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListLaunchPaths::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ListLaunchPaths::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ListLaunchPaths::set_product_id): <p>The product identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListLaunchPaths::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListLaunchPaths::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListLaunchPaths::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListLaunchPaths::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListLaunchPathsOutput`](crate::output::ListLaunchPathsOutput) with field(s):
    ///   - [`launch_path_summaries(Option<Vec<LaunchPathSummary>>)`](crate::output::ListLaunchPathsOutput::launch_path_summaries): <p>Information about the launch path.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListLaunchPathsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListLaunchPathsError>`](crate::error::ListLaunchPathsError)
    pub fn list_launch_paths(&self) -> fluent_builders::ListLaunchPaths {
        fluent_builders::ListLaunchPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationPortfolioAccess`](crate::client::fluent_builders::ListOrganizationPortfolioAccess) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::set_portfolio_id): <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
    ///   - [`organization_node_type(OrganizationNodeType)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::organization_node_type) / [`set_organization_node_type(Option<OrganizationNodeType>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::set_organization_node_type): <p>The organization node type that will be returned in the output.</p>  <ul>   <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>   <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>   <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>  </ul>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListOrganizationPortfolioAccess::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`ListOrganizationPortfolioAccessOutput`](crate::output::ListOrganizationPortfolioAccessOutput) with field(s):
    ///   - [`organization_nodes(Option<Vec<OrganizationNode>>)`](crate::output::ListOrganizationPortfolioAccessOutput::organization_nodes): <p>Displays information about the organization nodes.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListOrganizationPortfolioAccessOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationPortfolioAccessError>`](crate::error::ListOrganizationPortfolioAccessError)
    pub fn list_organization_portfolio_access(
        &self,
    ) -> fluent_builders::ListOrganizationPortfolioAccess {
        fluent_builders::ListOrganizationPortfolioAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPortfolioAccess`](crate::client::fluent_builders::ListPortfolioAccess) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPortfolioAccess::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListPortfolioAccess::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListPortfolioAccess::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::ListPortfolioAccess::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::ListPortfolioAccess::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`organization_parent_id(impl Into<String>)`](crate::client::fluent_builders::ListPortfolioAccess::organization_parent_id) / [`set_organization_parent_id(Option<String>)`](crate::client::fluent_builders::ListPortfolioAccess::set_organization_parent_id): <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPortfolioAccess::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPortfolioAccess::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPortfolioAccess::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListPortfolioAccess::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`ListPortfolioAccessOutput`](crate::output::ListPortfolioAccessOutput) with field(s):
    ///   - [`account_ids(Option<Vec<String>>)`](crate::output::ListPortfolioAccessOutput::account_ids): <p>Information about the AWS accounts with access to the portfolio.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPortfolioAccessOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListPortfolioAccessError>`](crate::error::ListPortfolioAccessError)
    pub fn list_portfolio_access(&self) -> fluent_builders::ListPortfolioAccess {
        fluent_builders::ListPortfolioAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPortfolios`](crate::client::fluent_builders::ListPortfolios) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPortfolios::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListPortfolios::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListPortfolios::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPortfolios::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPortfolios::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPortfolios::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListPortfolios::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`ListPortfoliosOutput`](crate::output::ListPortfoliosOutput) with field(s):
    ///   - [`portfolio_details(Option<Vec<PortfolioDetail>>)`](crate::output::ListPortfoliosOutput::portfolio_details): <p>Information about the portfolios.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPortfoliosOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListPortfoliosError>`](crate::error::ListPortfoliosError)
    pub fn list_portfolios(&self) -> fluent_builders::ListPortfolios {
        fluent_builders::ListPortfolios::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPortfoliosForProduct`](crate::client::fluent_builders::ListPortfoliosForProduct) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPortfoliosForProduct::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::set_product_id): <p>The product identifier.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPortfoliosForProduct::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPortfoliosForProduct::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListPortfoliosForProduct::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`ListPortfoliosForProductOutput`](crate::output::ListPortfoliosForProductOutput) with field(s):
    ///   - [`portfolio_details(Option<Vec<PortfolioDetail>>)`](crate::output::ListPortfoliosForProductOutput::portfolio_details): <p>Information about the portfolios.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPortfoliosForProductOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListPortfoliosForProductError>`](crate::error::ListPortfoliosForProductError)
    pub fn list_portfolios_for_product(&self) -> fluent_builders::ListPortfoliosForProduct {
        fluent_builders::ListPortfoliosForProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrincipalsForPortfolio`](crate::client::fluent_builders::ListPrincipalsForPortfolio) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrincipalsForPortfolio::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListPrincipalsForPortfolio::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListPrincipalsForPortfolioOutput`](crate::output::ListPrincipalsForPortfolioOutput) with field(s):
    ///   - [`principals(Option<Vec<Principal>>)`](crate::output::ListPrincipalsForPortfolioOutput::principals): <p>The IAM principals (users or roles) associated with the portfolio.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListPrincipalsForPortfolioOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListPrincipalsForPortfolioError>`](crate::error::ListPrincipalsForPortfolioError)
    pub fn list_principals_for_portfolio(&self) -> fluent_builders::ListPrincipalsForPortfolio {
        fluent_builders::ListPrincipalsForPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisionedProductPlans`](crate::client::fluent_builders::ListProvisionedProductPlans) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provision_product_id(impl Into<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::provision_product_id) / [`set_provision_product_id(Option<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::set_provision_product_id): <p>The product identifier.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListProvisionedProductPlans::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListProvisionedProductPlans::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListProvisionedProductPlans::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`access_level_filter(AccessLevelFilter)`](crate::client::fluent_builders::ListProvisionedProductPlans::access_level_filter) / [`set_access_level_filter(Option<AccessLevelFilter>)`](crate::client::fluent_builders::ListProvisionedProductPlans::set_access_level_filter): <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    /// - On success, responds with [`ListProvisionedProductPlansOutput`](crate::output::ListProvisionedProductPlansOutput) with field(s):
    ///   - [`provisioned_product_plans(Option<Vec<ProvisionedProductPlanSummary>>)`](crate::output::ListProvisionedProductPlansOutput::provisioned_product_plans): <p>Information about the plans.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListProvisionedProductPlansOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListProvisionedProductPlansError>`](crate::error::ListProvisionedProductPlansError)
    pub fn list_provisioned_product_plans(&self) -> fluent_builders::ListProvisionedProductPlans {
        fluent_builders::ListProvisionedProductPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisioningArtifacts`](crate::client::fluent_builders::ListProvisioningArtifacts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningArtifacts::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListProvisioningArtifacts::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningArtifacts::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ListProvisioningArtifacts::set_product_id): <p>The product identifier.</p>
    /// - On success, responds with [`ListProvisioningArtifactsOutput`](crate::output::ListProvisioningArtifactsOutput) with field(s):
    ///   - [`provisioning_artifact_details(Option<Vec<ProvisioningArtifactDetail>>)`](crate::output::ListProvisioningArtifactsOutput::provisioning_artifact_details): <p>Information about the provisioning artifacts.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListProvisioningArtifactsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListProvisioningArtifactsError>`](crate::error::ListProvisioningArtifactsError)
    pub fn list_provisioning_artifacts(&self) -> fluent_builders::ListProvisioningArtifacts {
        fluent_builders::ListProvisioningArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisioningArtifactsForServiceAction`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_action_id(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::service_action_id) / [`set_service_action_id(Option<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::set_service_action_id): <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`ListProvisioningArtifactsForServiceActionOutput`](crate::output::ListProvisioningArtifactsForServiceActionOutput) with field(s):
    ///   - [`provisioning_artifact_views(Option<Vec<ProvisioningArtifactView>>)`](crate::output::ListProvisioningArtifactsForServiceActionOutput::provisioning_artifact_views): <p>An array of objects with information about product views and provisioning artifacts.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListProvisioningArtifactsForServiceActionOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListProvisioningArtifactsForServiceActionError>`](crate::error::ListProvisioningArtifactsForServiceActionError)
    pub fn list_provisioning_artifacts_for_service_action(
        &self,
    ) -> fluent_builders::ListProvisioningArtifactsForServiceAction {
        fluent_builders::ListProvisioningArtifactsForServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecordHistory`](crate::client::fluent_builders::ListRecordHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListRecordHistory::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListRecordHistory::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`access_level_filter(AccessLevelFilter)`](crate::client::fluent_builders::ListRecordHistory::access_level_filter) / [`set_access_level_filter(Option<AccessLevelFilter>)`](crate::client::fluent_builders::ListRecordHistory::set_access_level_filter): <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    ///   - [`search_filter(ListRecordHistorySearchFilter)`](crate::client::fluent_builders::ListRecordHistory::search_filter) / [`set_search_filter(Option<ListRecordHistorySearchFilter>)`](crate::client::fluent_builders::ListRecordHistory::set_search_filter): <p>The search filter to scope the results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListRecordHistory::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListRecordHistory::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListRecordHistory::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListRecordHistory::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListRecordHistoryOutput`](crate::output::ListRecordHistoryOutput) with field(s):
    ///   - [`record_details(Option<Vec<RecordDetail>>)`](crate::output::ListRecordHistoryOutput::record_details): <p>The records, in reverse chronological order.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListRecordHistoryOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListRecordHistoryError>`](crate::error::ListRecordHistoryError)
    pub fn list_record_history(&self) -> fluent_builders::ListRecordHistory {
        fluent_builders::ListRecordHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourcesForTagOption`](crate::client::fluent_builders::ListResourcesForTagOption) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourcesForTagOption::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tag_option_id(impl Into<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::tag_option_id) / [`set_tag_option_id(Option<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::set_tag_option_id): <p>The TagOption identifier.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::set_resource_type): <p>The resource type.</p>  <ul>   <li> <p> <code>Portfolio</code> </p> </li>   <li> <p> <code>Product</code> </p> </li>  </ul>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListResourcesForTagOption::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListResourcesForTagOption::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListResourcesForTagOption::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListResourcesForTagOptionOutput`](crate::output::ListResourcesForTagOptionOutput) with field(s):
    ///   - [`resource_details(Option<Vec<ResourceDetail>>)`](crate::output::ListResourcesForTagOptionOutput::resource_details): <p>Information about the resources.</p>
    ///   - [`page_token(Option<String>)`](crate::output::ListResourcesForTagOptionOutput::page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On failure, responds with [`SdkError<ListResourcesForTagOptionError>`](crate::error::ListResourcesForTagOptionError)
    pub fn list_resources_for_tag_option(&self) -> fluent_builders::ListResourcesForTagOption {
        fluent_builders::ListResourcesForTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServiceActions`](crate::client::fluent_builders::ListServiceActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServiceActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListServiceActions::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListServiceActions::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListServiceActions::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListServiceActions::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListServiceActions::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListServiceActions::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListServiceActionsOutput`](crate::output::ListServiceActionsOutput) with field(s):
    ///   - [`service_action_summaries(Option<Vec<ServiceActionSummary>>)`](crate::output::ListServiceActionsOutput::service_action_summaries): <p>An object containing information about the service actions associated with the provisioning artifact.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListServiceActionsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListServiceActionsError>`](crate::error::ListServiceActionsError)
    pub fn list_service_actions(&self) -> fluent_builders::ListServiceActions {
        fluent_builders::ListServiceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServiceActionsForProvisioningArtifact`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::set_product_id): <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`ListServiceActionsForProvisioningArtifactOutput`](crate::output::ListServiceActionsForProvisioningArtifactOutput) with field(s):
    ///   - [`service_action_summaries(Option<Vec<ServiceActionSummary>>)`](crate::output::ListServiceActionsForProvisioningArtifactOutput::service_action_summaries): <p>An object containing information about the self-service actions associated with the provisioning artifact.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListServiceActionsForProvisioningArtifactOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListServiceActionsForProvisioningArtifactError>`](crate::error::ListServiceActionsForProvisioningArtifactError)
    pub fn list_service_actions_for_provisioning_artifact(
        &self,
    ) -> fluent_builders::ListServiceActionsForProvisioningArtifact {
        fluent_builders::ListServiceActionsForProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStackInstancesForProvisionedProduct`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::set_provisioned_product_id): <p>The identifier of the provisioned product.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct::set_page_size): <p>The maximum number of items to return with this call.</p>
    /// - On success, responds with [`ListStackInstancesForProvisionedProductOutput`](crate::output::ListStackInstancesForProvisionedProductOutput) with field(s):
    ///   - [`stack_instances(Option<Vec<StackInstance>>)`](crate::output::ListStackInstancesForProvisionedProductOutput::stack_instances): <p>List of stack instances.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ListStackInstancesForProvisionedProductOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListStackInstancesForProvisionedProductError>`](crate::error::ListStackInstancesForProvisionedProductError)
    pub fn list_stack_instances_for_provisioned_product(
        &self,
    ) -> fluent_builders::ListStackInstancesForProvisionedProduct {
        fluent_builders::ListStackInstancesForProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagOptions`](crate::client::fluent_builders::ListTagOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(ListTagOptionsFilters)`](crate::client::fluent_builders::ListTagOptions::filters) / [`set_filters(Option<ListTagOptionsFilters>)`](crate::client::fluent_builders::ListTagOptions::set_filters): <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListTagOptions::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ListTagOptions::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ListTagOptions::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ListTagOptions::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ListTagOptionsOutput`](crate::output::ListTagOptionsOutput) with field(s):
    ///   - [`tag_option_details(Option<Vec<TagOptionDetail>>)`](crate::output::ListTagOptionsOutput::tag_option_details): <p>Information about the TagOptions.</p>
    ///   - [`page_token(Option<String>)`](crate::output::ListTagOptionsOutput::page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On failure, responds with [`SdkError<ListTagOptionsError>`](crate::error::ListTagOptionsError)
    pub fn list_tag_options(&self) -> fluent_builders::ListTagOptions {
        fluent_builders::ListTagOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ProvisionProduct`](crate::client::fluent_builders::ProvisionProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_product_id): <p>The product identifier. You must provide the name or ID, but not both.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_product_name): <p>The name of the product. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_artifact_name(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::provisioning_artifact_name) / [`set_provisioning_artifact_name(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_provisioning_artifact_name): <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    ///   - [`path_id(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::path_id) / [`set_path_id(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_path_id): <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    ///   - [`path_name(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::path_name) / [`set_path_name(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_path_name): <p>The name of the path. You must provide the name or ID, but not both.</p>
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_provisioned_product_name): <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
    ///   - [`provisioning_parameters(Vec<ProvisioningParameter>)`](crate::client::fluent_builders::ProvisionProduct::provisioning_parameters) / [`set_provisioning_parameters(Option<Vec<ProvisioningParameter>>)`](crate::client::fluent_builders::ProvisionProduct::set_provisioning_parameters): <p>Parameters specified by the administrator that are required for provisioning the product.</p>
    ///   - [`provisioning_preferences(ProvisioningPreferences)`](crate::client::fluent_builders::ProvisionProduct::provisioning_preferences) / [`set_provisioning_preferences(Option<ProvisioningPreferences>)`](crate::client::fluent_builders::ProvisionProduct::set_provisioning_preferences): <p>An object that contains information about the provisioning preferences for a stack set.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ProvisionProduct::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ProvisionProduct::set_tags): <p>One or more tags.</p>
    ///   - [`notification_arns(Vec<String>)`](crate::client::fluent_builders::ProvisionProduct::notification_arns) / [`set_notification_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ProvisionProduct::set_notification_arns): <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
    ///   - [`provision_token(impl Into<String>)`](crate::client::fluent_builders::ProvisionProduct::provision_token) / [`set_provision_token(Option<String>)`](crate::client::fluent_builders::ProvisionProduct::set_provision_token): <p>An idempotency token that uniquely identifies the provisioning request.</p>
    /// - On success, responds with [`ProvisionProductOutput`](crate::output::ProvisionProductOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::ProvisionProductOutput::record_detail): <p>Information about the result of provisioning the product.</p>
    /// - On failure, responds with [`SdkError<ProvisionProductError>`](crate::error::ProvisionProductError)
    pub fn provision_product(&self) -> fluent_builders::ProvisionProduct {
        fluent_builders::ProvisionProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectPortfolioShare`](crate::client::fluent_builders::RejectPortfolioShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::RejectPortfolioShare::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::RejectPortfolioShare::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::RejectPortfolioShare::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::RejectPortfolioShare::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`portfolio_share_type(PortfolioShareType)`](crate::client::fluent_builders::RejectPortfolioShare::portfolio_share_type) / [`set_portfolio_share_type(Option<PortfolioShareType>)`](crate::client::fluent_builders::RejectPortfolioShare::set_portfolio_share_type): <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>  <ul>   <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>   <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>   <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>  </ul>  <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
    /// - On success, responds with [`RejectPortfolioShareOutput`](crate::output::RejectPortfolioShareOutput)

    /// - On failure, responds with [`SdkError<RejectPortfolioShareError>`](crate::error::RejectPortfolioShareError)
    pub fn reject_portfolio_share(&self) -> fluent_builders::RejectPortfolioShare {
        fluent_builders::RejectPortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ScanProvisionedProducts`](crate::client::fluent_builders::ScanProvisionedProducts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::ScanProvisionedProducts::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::ScanProvisionedProducts::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`access_level_filter(AccessLevelFilter)`](crate::client::fluent_builders::ScanProvisionedProducts::access_level_filter) / [`set_access_level_filter(Option<AccessLevelFilter>)`](crate::client::fluent_builders::ScanProvisionedProducts::set_access_level_filter): <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ScanProvisionedProducts::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::ScanProvisionedProducts::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::ScanProvisionedProducts::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::ScanProvisionedProducts::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`ScanProvisionedProductsOutput`](crate::output::ScanProvisionedProductsOutput) with field(s):
    ///   - [`provisioned_products(Option<Vec<ProvisionedProductDetail>>)`](crate::output::ScanProvisionedProductsOutput::provisioned_products): <p>Information about the provisioned products.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::ScanProvisionedProductsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<ScanProvisionedProductsError>`](crate::error::ScanProvisionedProductsError)
    pub fn scan_provisioned_products(&self) -> fluent_builders::ScanProvisionedProducts {
        fluent_builders::ScanProvisionedProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchProducts`](crate::client::fluent_builders::SearchProducts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchProducts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::SearchProducts::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::SearchProducts::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`filters(HashMap<ProductViewFilterBy, Vec<String>>)`](crate::client::fluent_builders::SearchProducts::filters) / [`set_filters(Option<HashMap<ProductViewFilterBy, Vec<String>>>)`](crate::client::fluent_builders::SearchProducts::set_filters): <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::SearchProducts::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::SearchProducts::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`sort_by(ProductViewSortBy)`](crate::client::fluent_builders::SearchProducts::sort_by) / [`set_sort_by(Option<ProductViewSortBy>)`](crate::client::fluent_builders::SearchProducts::set_sort_by): <p>The sort field. If no value is specified, the results are not sorted.</p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::SearchProducts::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::SearchProducts::set_sort_order): <p>The sort order. If no value is specified, the results are not sorted.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::SearchProducts::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::SearchProducts::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`SearchProductsOutput`](crate::output::SearchProductsOutput) with field(s):
    ///   - [`product_view_summaries(Option<Vec<ProductViewSummary>>)`](crate::output::SearchProductsOutput::product_view_summaries): <p>Information about the product views.</p>
    ///   - [`product_view_aggregations(Option<HashMap<String, Vec<ProductViewAggregationValue>>>)`](crate::output::SearchProductsOutput::product_view_aggregations): <p>The product view aggregations.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::SearchProductsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<SearchProductsError>`](crate::error::SearchProductsError)
    pub fn search_products(&self) -> fluent_builders::SearchProducts {
        fluent_builders::SearchProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchProductsAsAdmin`](crate::client::fluent_builders::SearchProductsAsAdmin) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchProductsAsAdmin::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_portfolio_id): <p>The portfolio identifier.</p>
    ///   - [`filters(HashMap<ProductViewFilterBy, Vec<String>>)`](crate::client::fluent_builders::SearchProductsAsAdmin::filters) / [`set_filters(Option<HashMap<ProductViewFilterBy, Vec<String>>>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_filters): <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
    ///   - [`sort_by(ProductViewSortBy)`](crate::client::fluent_builders::SearchProductsAsAdmin::sort_by) / [`set_sort_by(Option<ProductViewSortBy>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_sort_by): <p>The sort field. If no value is specified, the results are not sorted.</p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::SearchProductsAsAdmin::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_sort_order): <p>The sort order. If no value is specified, the results are not sorted.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::SearchProductsAsAdmin::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`product_source(ProductSource)`](crate::client::fluent_builders::SearchProductsAsAdmin::product_source) / [`set_product_source(Option<ProductSource>)`](crate::client::fluent_builders::SearchProductsAsAdmin::set_product_source): <p>Access level of the source of the product.</p>
    /// - On success, responds with [`SearchProductsAsAdminOutput`](crate::output::SearchProductsAsAdminOutput) with field(s):
    ///   - [`product_view_details(Option<Vec<ProductViewDetail>>)`](crate::output::SearchProductsAsAdminOutput::product_view_details): <p>Information about the product views.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::SearchProductsAsAdminOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<SearchProductsAsAdminError>`](crate::error::SearchProductsAsAdminError)
    pub fn search_products_as_admin(&self) -> fluent_builders::SearchProductsAsAdmin {
        fluent_builders::SearchProductsAsAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchProvisionedProducts`](crate::client::fluent_builders::SearchProvisionedProducts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchProvisionedProducts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`access_level_filter(AccessLevelFilter)`](crate::client::fluent_builders::SearchProvisionedProducts::access_level_filter) / [`set_access_level_filter(Option<AccessLevelFilter>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_access_level_filter): <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    ///   - [`filters(HashMap<ProvisionedProductViewFilterBy, Vec<String>>)`](crate::client::fluent_builders::SearchProvisionedProducts::filters) / [`set_filters(Option<HashMap<ProvisionedProductViewFilterBy, Vec<String>>>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_filters): <p>The search filters.</p>  <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>  <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
    ///   - [`sort_by(impl Into<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::sort_by) / [`set_sort_by(Option<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_sort_by): <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::SearchProvisionedProducts::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_sort_order): <p>The sort order. If no value is specified, the results are not sorted.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::SearchProvisionedProducts::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::SearchProvisionedProducts::set_page_size): <p>The maximum number of items to return with this call.</p>
    ///   - [`page_token(impl Into<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::page_token) / [`set_page_token(Option<String>)`](crate::client::fluent_builders::SearchProvisionedProducts::set_page_token): <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    /// - On success, responds with [`SearchProvisionedProductsOutput`](crate::output::SearchProvisionedProductsOutput) with field(s):
    ///   - [`provisioned_products(Option<Vec<ProvisionedProductAttribute>>)`](crate::output::SearchProvisionedProductsOutput::provisioned_products): <p>Information about the provisioned products.</p>
    ///   - [`total_results_count(i32)`](crate::output::SearchProvisionedProductsOutput::total_results_count): <p>The number of provisioned products found.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::SearchProvisionedProductsOutput::next_page_token): <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    /// - On failure, responds with [`SdkError<SearchProvisionedProductsError>`](crate::error::SearchProvisionedProductsError)
    pub fn search_provisioned_products(&self) -> fluent_builders::SearchProvisionedProducts {
        fluent_builders::SearchProvisionedProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateProvisionedProduct`](crate::client::fluent_builders::TerminateProvisionedProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_provisioned_product_name): <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_provisioned_product_id): <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    ///   - [`terminate_token(impl Into<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::terminate_token) / [`set_terminate_token(Option<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_terminate_token): <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
    ///   - [`ignore_errors(bool)`](crate::client::fluent_builders::TerminateProvisionedProduct::ignore_errors) / [`set_ignore_errors(bool)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_ignore_errors): <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`retain_physical_resources(bool)`](crate::client::fluent_builders::TerminateProvisionedProduct::retain_physical_resources) / [`set_retain_physical_resources(bool)`](crate::client::fluent_builders::TerminateProvisionedProduct::set_retain_physical_resources): <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
    /// - On success, responds with [`TerminateProvisionedProductOutput`](crate::output::TerminateProvisionedProductOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::TerminateProvisionedProductOutput::record_detail): <p>Information about the result of this request.</p>
    /// - On failure, responds with [`SdkError<TerminateProvisionedProductError>`](crate::error::TerminateProvisionedProductError)
    pub fn terminate_provisioned_product(&self) -> fluent_builders::TerminateProvisionedProduct {
        fluent_builders::TerminateProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConstraint`](crate::client::fluent_builders::UpdateConstraint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateConstraint::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateConstraint::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateConstraint::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateConstraint::set_id): <p>The identifier of the constraint.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateConstraint::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateConstraint::set_description): <p>The updated description of the constraint.</p>
    ///   - [`parameters(impl Into<String>)`](crate::client::fluent_builders::UpdateConstraint::parameters) / [`set_parameters(Option<String>)`](crate::client::fluent_builders::UpdateConstraint::set_parameters): <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>  <dl>   <dt>   LAUNCH  </dt>   <dd>    <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>    <p>Specify the <code>RoleArn</code> property as follows:</p>    <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>    <p>Specify the <code>LocalRoleName</code> property as follows:</p>    <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>    <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>     <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>    </note>    <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>    <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>   </dd>   <dt>   NOTIFICATION  </dt>   <dd>    <p>Specify the <code>NotificationArns</code> property as follows:</p>    <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>   </dd>   <dt>   RESOURCE_UPDATE  </dt>   <dd>    <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>    <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>    <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>   </dd>   <dt>   STACKSET  </dt>   <dd>    <p>Specify the <code>Parameters</code> property as follows:</p>    <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>    <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>    <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>    <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>   </dd>   <dt>   TEMPLATE  </dt>   <dd>    <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>   </dd>  </dl>
    /// - On success, responds with [`UpdateConstraintOutput`](crate::output::UpdateConstraintOutput) with field(s):
    ///   - [`constraint_detail(Option<ConstraintDetail>)`](crate::output::UpdateConstraintOutput::constraint_detail): <p>Information about the constraint.</p>
    ///   - [`constraint_parameters(Option<String>)`](crate::output::UpdateConstraintOutput::constraint_parameters): <p>The constraint parameters.</p>
    ///   - [`status(Option<Status>)`](crate::output::UpdateConstraintOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<UpdateConstraintError>`](crate::error::UpdateConstraintError)
    pub fn update_constraint(&self) -> fluent_builders::UpdateConstraint {
        fluent_builders::UpdateConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePortfolio`](crate::client::fluent_builders::UpdatePortfolio) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolio::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdatePortfolio::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolio::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePortfolio::set_id): <p>The portfolio identifier.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolio::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdatePortfolio::set_display_name): <p>The name to use for display purposes.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolio::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePortfolio::set_description): <p>The updated description of the portfolio.</p>
    ///   - [`provider_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolio::provider_name) / [`set_provider_name(Option<String>)`](crate::client::fluent_builders::UpdatePortfolio::set_provider_name): <p>The updated name of the portfolio provider.</p>
    ///   - [`add_tags(Vec<Tag>)`](crate::client::fluent_builders::UpdatePortfolio::add_tags) / [`set_add_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdatePortfolio::set_add_tags): <p>The tags to add.</p>
    ///   - [`remove_tags(Vec<String>)`](crate::client::fluent_builders::UpdatePortfolio::remove_tags) / [`set_remove_tags(Option<Vec<String>>)`](crate::client::fluent_builders::UpdatePortfolio::set_remove_tags): <p>The tags to remove.</p>
    /// - On success, responds with [`UpdatePortfolioOutput`](crate::output::UpdatePortfolioOutput) with field(s):
    ///   - [`portfolio_detail(Option<PortfolioDetail>)`](crate::output::UpdatePortfolioOutput::portfolio_detail): <p>Information about the portfolio.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdatePortfolioOutput::tags): <p>Information about the tags associated with the portfolio.</p>
    /// - On failure, responds with [`SdkError<UpdatePortfolioError>`](crate::error::UpdatePortfolioError)
    pub fn update_portfolio(&self) -> fluent_builders::UpdatePortfolio {
        fluent_builders::UpdatePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePortfolioShare`](crate::client::fluent_builders::UpdatePortfolioShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`portfolio_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::portfolio_id) / [`set_portfolio_id(Option<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::set_portfolio_id): <p>The unique identifier of the portfolio for which the share will be updated.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdatePortfolioShare::set_account_id): <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
    ///   - [`organization_node(OrganizationNode)`](crate::client::fluent_builders::UpdatePortfolioShare::organization_node) / [`set_organization_node(Option<OrganizationNode>)`](crate::client::fluent_builders::UpdatePortfolioShare::set_organization_node): <p>Information about the organization node.</p>
    ///   - [`share_tag_options(bool)`](crate::client::fluent_builders::UpdatePortfolioShare::share_tag_options) / [`set_share_tag_options(Option<bool>)`](crate::client::fluent_builders::UpdatePortfolioShare::set_share_tag_options): <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
    /// - On success, responds with [`UpdatePortfolioShareOutput`](crate::output::UpdatePortfolioShareOutput) with field(s):
    ///   - [`portfolio_share_token(Option<String>)`](crate::output::UpdatePortfolioShareOutput::portfolio_share_token): <p>The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to account or organizational type sharing.</p>
    ///   - [`status(Option<ShareStatus>)`](crate::output::UpdatePortfolioShareOutput::status): <p>The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using <code>DescribePortfolioShareStatus</code> API. </p>
    /// - On failure, responds with [`SdkError<UpdatePortfolioShareError>`](crate::error::UpdatePortfolioShareError)
    pub fn update_portfolio_share(&self) -> fluent_builders::UpdatePortfolioShare {
        fluent_builders::UpdatePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProduct`](crate::client::fluent_builders::UpdateProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_id): <p>The product identifier.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_name): <p>The updated product name.</p>
    ///   - [`owner(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::owner) / [`set_owner(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_owner): <p>The updated owner of the product.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_description): <p>The updated description of the product.</p>
    ///   - [`distributor(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::distributor) / [`set_distributor(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_distributor): <p>The updated distributor of the product.</p>
    ///   - [`support_description(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::support_description) / [`set_support_description(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_support_description): <p>The updated support description for the product.</p>
    ///   - [`support_email(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::support_email) / [`set_support_email(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_support_email): <p>The updated support email for the product.</p>
    ///   - [`support_url(impl Into<String>)`](crate::client::fluent_builders::UpdateProduct::support_url) / [`set_support_url(Option<String>)`](crate::client::fluent_builders::UpdateProduct::set_support_url): <p>The updated support URL for the product.</p>
    ///   - [`add_tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateProduct::add_tags) / [`set_add_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateProduct::set_add_tags): <p>The tags to add to the product.</p>
    ///   - [`remove_tags(Vec<String>)`](crate::client::fluent_builders::UpdateProduct::remove_tags) / [`set_remove_tags(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateProduct::set_remove_tags): <p>The tags to remove from the product.</p>
    /// - On success, responds with [`UpdateProductOutput`](crate::output::UpdateProductOutput) with field(s):
    ///   - [`product_view_detail(Option<ProductViewDetail>)`](crate::output::UpdateProductOutput::product_view_detail): <p>Information about the product view.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdateProductOutput::tags): <p>Information about the tags associated with the product.</p>
    /// - On failure, responds with [`SdkError<UpdateProductError>`](crate::error::UpdateProductError)
    pub fn update_product(&self) -> fluent_builders::UpdateProduct {
        fluent_builders::UpdateProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProvisionedProduct`](crate::client::fluent_builders::UpdateProvisionedProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provisioned_product_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioned_product_name) / [`set_provisioned_product_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioned_product_name): <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioned_product_id): <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_product_id): <p>The identifier of the product. You must provide the name or ID, but not both.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_product_name): <p>The name of the product. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    ///   - [`provisioning_artifact_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioning_artifact_name) / [`set_provisioning_artifact_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioning_artifact_name): <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    ///   - [`path_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::path_id) / [`set_path_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_path_id): <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
    ///   - [`path_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::path_name) / [`set_path_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_path_name): <p>The name of the path. You must provide the name or ID, but not both.</p>
    ///   - [`provisioning_parameters(Vec<UpdateProvisioningParameter>)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioning_parameters) / [`set_provisioning_parameters(Option<Vec<UpdateProvisioningParameter>>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioning_parameters): <p>The new parameters.</p>
    ///   - [`provisioning_preferences(UpdateProvisioningPreferences)`](crate::client::fluent_builders::UpdateProvisionedProduct::provisioning_preferences) / [`set_provisioning_preferences(Option<UpdateProvisioningPreferences>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_provisioning_preferences): <p>An object that contains information about the provisioning preferences for a stack set.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateProvisionedProduct::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_tags): <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
    ///   - [`update_token(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::update_token) / [`set_update_token(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProduct::set_update_token): <p>The idempotency token that uniquely identifies the provisioning update request.</p>
    /// - On success, responds with [`UpdateProvisionedProductOutput`](crate::output::UpdateProvisionedProductOutput) with field(s):
    ///   - [`record_detail(Option<RecordDetail>)`](crate::output::UpdateProvisionedProductOutput::record_detail): <p>Information about the result of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateProvisionedProductError>`](crate::error::UpdateProvisionedProductError)
    pub fn update_provisioned_product(&self) -> fluent_builders::UpdateProvisionedProduct {
        fluent_builders::UpdateProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProvisionedProductProperties`](crate::client::fluent_builders::UpdateProvisionedProductProperties) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`provisioned_product_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::provisioned_product_id) / [`set_provisioned_product_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::set_provisioned_product_id): <p>The identifier of the provisioned product.</p>
    ///   - [`provisioned_product_properties(HashMap<PropertyKey, String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::provisioned_product_properties) / [`set_provisioned_product_properties(Option<HashMap<PropertyKey, String>>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::set_provisioned_product_properties): <p>A map that contains the provisioned product properties to be updated.</p>  <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>  <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>  <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>  <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::UpdateProvisionedProductProperties::set_idempotency_token): <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
    /// - On success, responds with [`UpdateProvisionedProductPropertiesOutput`](crate::output::UpdateProvisionedProductPropertiesOutput) with field(s):
    ///   - [`provisioned_product_id(Option<String>)`](crate::output::UpdateProvisionedProductPropertiesOutput::provisioned_product_id): <p>The provisioned product identifier.</p>
    ///   - [`provisioned_product_properties(Option<HashMap<PropertyKey, String>>)`](crate::output::UpdateProvisionedProductPropertiesOutput::provisioned_product_properties): <p>A map that contains the properties updated.</p>
    ///   - [`record_id(Option<String>)`](crate::output::UpdateProvisionedProductPropertiesOutput::record_id): <p>The identifier of the record.</p>
    ///   - [`status(Option<RecordStatus>)`](crate::output::UpdateProvisionedProductPropertiesOutput::status): <p>The status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateProvisionedProductPropertiesError>`](crate::error::UpdateProvisionedProductPropertiesError)
    pub fn update_provisioned_product_properties(
        &self,
    ) -> fluent_builders::UpdateProvisionedProductProperties {
        fluent_builders::UpdateProvisionedProductProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProvisioningArtifact`](crate::client::fluent_builders::UpdateProvisioningArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    ///   - [`product_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::product_id) / [`set_product_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_product_id): <p>The product identifier.</p>
    ///   - [`provisioning_artifact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::provisioning_artifact_id) / [`set_provisioning_artifact_id(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_provisioning_artifact_id): <p>The identifier of the provisioning artifact.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_name): <p>The updated name of the provisioning artifact.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_description): <p>The updated description of the provisioning artifact.</p>
    ///   - [`active(bool)`](crate::client::fluent_builders::UpdateProvisioningArtifact::active) / [`set_active(Option<bool>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_active): <p>Indicates whether the product version is active.</p>  <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
    ///   - [`guidance(ProvisioningArtifactGuidance)`](crate::client::fluent_builders::UpdateProvisioningArtifact::guidance) / [`set_guidance(Option<ProvisioningArtifactGuidance>)`](crate::client::fluent_builders::UpdateProvisioningArtifact::set_guidance): <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>  <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>  <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
    /// - On success, responds with [`UpdateProvisioningArtifactOutput`](crate::output::UpdateProvisioningArtifactOutput) with field(s):
    ///   - [`provisioning_artifact_detail(Option<ProvisioningArtifactDetail>)`](crate::output::UpdateProvisioningArtifactOutput::provisioning_artifact_detail): <p>Information about the provisioning artifact.</p>
    ///   - [`info(Option<HashMap<String, String>>)`](crate::output::UpdateProvisioningArtifactOutput::info): <p>The URL of the CloudFormation template in Amazon S3.</p>
    ///   - [`status(Option<Status>)`](crate::output::UpdateProvisioningArtifactOutput::status): <p>The status of the current request.</p>
    /// - On failure, responds with [`SdkError<UpdateProvisioningArtifactError>`](crate::error::UpdateProvisioningArtifactError)
    pub fn update_provisioning_artifact(&self) -> fluent_builders::UpdateProvisioningArtifact {
        fluent_builders::UpdateProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServiceAction`](crate::client::fluent_builders::UpdateServiceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceAction::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateServiceAction::set_id): <p>The self-service action identifier.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceAction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateServiceAction::set_name): <p>The self-service action name.</p>
    ///   - [`definition(HashMap<ServiceActionDefinitionKey, String>)`](crate::client::fluent_builders::UpdateServiceAction::definition) / [`set_definition(Option<HashMap<ServiceActionDefinitionKey, String>>)`](crate::client::fluent_builders::UpdateServiceAction::set_definition): <p>A map that defines the self-service action.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceAction::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateServiceAction::set_description): <p>The self-service action description.</p>
    ///   - [`accept_language(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceAction::accept_language) / [`set_accept_language(Option<String>)`](crate::client::fluent_builders::UpdateServiceAction::set_accept_language): <p>The language code.</p>  <ul>   <li> <p> <code>en</code> - English (default)</p> </li>   <li> <p> <code>jp</code> - Japanese</p> </li>   <li> <p> <code>zh</code> - Chinese</p> </li>  </ul>
    /// - On success, responds with [`UpdateServiceActionOutput`](crate::output::UpdateServiceActionOutput) with field(s):
    ///   - [`service_action_detail(Option<ServiceActionDetail>)`](crate::output::UpdateServiceActionOutput::service_action_detail): <p>Detailed information about the self-service action.</p>
    /// - On failure, responds with [`SdkError<UpdateServiceActionError>`](crate::error::UpdateServiceActionError)
    pub fn update_service_action(&self) -> fluent_builders::UpdateServiceAction {
        fluent_builders::UpdateServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTagOption`](crate::client::fluent_builders::UpdateTagOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateTagOption::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateTagOption::set_id): <p>The TagOption identifier.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::UpdateTagOption::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::UpdateTagOption::set_value): <p>The updated value.</p>
    ///   - [`active(bool)`](crate::client::fluent_builders::UpdateTagOption::active) / [`set_active(Option<bool>)`](crate::client::fluent_builders::UpdateTagOption::set_active): <p>The updated active state.</p>
    /// - On success, responds with [`UpdateTagOptionOutput`](crate::output::UpdateTagOptionOutput) with field(s):
    ///   - [`tag_option_detail(Option<TagOptionDetail>)`](crate::output::UpdateTagOptionOutput::tag_option_detail): <p>Information about the TagOption.</p>
    /// - On failure, responds with [`SdkError<UpdateTagOptionError>`](crate::error::UpdateTagOptionError)
    pub fn update_tag_option(&self) -> fluent_builders::UpdateTagOption {
        fluent_builders::UpdateTagOption::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptPortfolioShare`.
    ///
    /// <p>Accepts an offer to share the specified portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptPortfolioShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_portfolio_share_input::Builder,
    }
    impl AcceptPortfolioShare {
        /// Creates a new `AcceptPortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptPortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptPortfolioShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Accept imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(input);
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Accept imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateBudgetWithResource`.
    ///
    /// <p>Associates the specified budget with the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateBudgetWithResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_budget_with_resource_input::Builder,
    }
    impl AssociateBudgetWithResource {
        /// Creates a new `AssociateBudgetWithResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBudgetWithResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBudgetWithResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the budget you want to associate.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget you want to associate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePrincipalWithPortfolio`.
    ///
    /// <p>Associates the specified principal ARN with the specified portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociatePrincipalWithPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_principal_with_portfolio_input::Builder,
    }
    impl AssociatePrincipalWithPortfolio {
        /// Creates a new `AssociatePrincipalWithPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePrincipalWithPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePrincipalWithPortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(input);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateProductWithPortfolio`.
    ///
    /// <p>Associates the specified product with the specified portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateProductWithPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_product_with_portfolio_input::Builder,
    }
    impl AssociateProductWithPortfolio {
        /// Creates a new `AssociateProductWithPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateProductWithPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateProductWithPortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn source_portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_portfolio_id(input.into());
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateServiceActionWithProvisioningArtifact`.
    ///
    /// <p>Associates a self-service action with a provisioning artifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateServiceActionWithProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_service_action_with_provisioning_artifact_input::Builder,
    }
    impl AssociateServiceActionWithProvisioningArtifact {
        /// Creates a new `AssociateServiceActionWithProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateServiceActionWithProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateServiceActionWithProvisioningArtifactError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTagOptionWithResource`.
    ///
    /// <p>Associate the specified TagOption with the specified portfolio or product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTagOptionWithResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_tag_option_with_resource_input::Builder,
    }
    impl AssociateTagOptionWithResource {
        /// Creates a new `AssociateTagOptionWithResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTagOptionWithResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTagOptionWithResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateServiceActionWithProvisioningArtifact`.
    ///
    /// <p>Associates multiple self-service actions with provisioning artifacts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateServiceActionWithProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner:
            crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder,
    }
    impl BatchAssociateServiceActionWithProvisioningArtifact {
        /// Creates a new `BatchAssociateServiceActionWithProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateServiceActionWithProvisioningArtifactError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ServiceActionAssociations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            input: crate::model::ServiceActionAssociation,
        ) -> Self {
            self.inner = self.inner.service_action_associations(input);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_service_action_associations(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateServiceActionFromProvisioningArtifact`.
    ///
    /// <p>Disassociates a batch of self-service actions from the specified provisioning artifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateServiceActionFromProvisioningArtifact {
                            handle: std::sync::Arc<super::Handle>,
                            inner: crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder
                        }
    impl BatchDisassociateServiceActionFromProvisioningArtifact {
        /// Creates a new `BatchDisassociateServiceActionFromProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ServiceActionAssociations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            input: crate::model::ServiceActionAssociation,
        ) -> Self {
            self.inner = self.inner.service_action_associations(input);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_service_action_associations(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyProduct`.
    ///
    /// <p>Copies the specified source product to the specified target product or a new product.</p>
    /// <p>You can copy a product to the same account or another account. You can copy a product to the same region or another region.</p>
    /// <p>This operation is performed asynchronously. To track the progress of the operation, use <code>DescribeCopyProductStatus</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_product_input::Builder,
    }
    impl CopyProduct {
        /// Creates a new `CopyProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyProductOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn source_product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_product_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn set_source_product_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_product_arn(input);
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn target_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_product_id(input.into());
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn set_target_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_product_id(input);
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn target_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_product_name(input.into());
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn set_target_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_product_name(input);
            self
        }
        /// Appends an item to `SourceProvisioningArtifactIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_source_provisioning_artifact_identifiers`](Self::set_source_provisioning_artifact_identifiers).
        ///
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.</p>
        pub fn source_provisioning_artifact_identifiers(
            mut self,
            input: std::collections::HashMap<
                crate::model::ProvisioningArtifactPropertyName,
                std::string::String,
            >,
        ) -> Self {
            self.inner = self.inner.source_provisioning_artifact_identifiers(input);
            self
        }
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.</p>
        pub fn set_source_provisioning_artifact_identifiers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        crate::model::ProvisioningArtifactPropertyName,
                        std::string::String,
                    >,
                >,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_provisioning_artifact_identifiers(input);
            self
        }
        /// Appends an item to `CopyOptions`.
        ///
        /// To override the contents of this collection use [`set_copy_options`](Self::set_copy_options).
        ///
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the target product.</p>
        pub fn copy_options(mut self, input: crate::model::CopyOption) -> Self {
            self.inner = self.inner.copy_options(input);
            self
        }
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the target product.</p>
        pub fn set_copy_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyOption>>,
        ) -> Self {
            self.inner = self.inner.set_copy_options(input);
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. </p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. </p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConstraint`.
    ///
    /// <p>Creates a constraint.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConstraint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_constraint_input::Builder,
    }
    impl CreateConstraint {
        /// Creates a new `CreateConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConstraintError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameters(input.into());
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li> <p> <code>LAUNCH</code> </p> </li>
        /// <li> <p> <code>NOTIFICATION</code> </p> </li>
        /// <li> <p> <code>RESOURCE_UPDATE</code> </p> </li>
        /// <li> <p> <code>STACKSET</code> </p> </li>
        /// <li> <p> <code>TEMPLATE</code> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li> <p> <code>LAUNCH</code> </p> </li>
        /// <li> <p> <code>NOTIFICATION</code> </p> </li>
        /// <li> <p> <code>RESOURCE_UPDATE</code> </p> </li>
        /// <li> <p> <code>STACKSET</code> </p> </li>
        /// <li> <p> <code>TEMPLATE</code> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortfolio`.
    ///
    /// <p>Creates a portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_portfolio_input::Builder,
    }
    impl CreatePortfolio {
        /// Creates a new `CreatePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortfolioShare`.
    ///
    /// <p>Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.</p>
    /// <p>Note that if a delegated admin is de-registered, they can no longer create portfolio shares.</p>
    /// <p> <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.</p>
    /// <p>You can't share a shared resource, including portfolios that contain a shared product.</p>
    /// <p>If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the <code> UpdatePortfolioShare</code> API instead.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePortfolioShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_portfolio_share_input::Builder,
    }
    impl CreatePortfolioShare {
        /// Creates a new `CreatePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortfolioShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code> is passed in, <code>PortfolioShare</code> will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a <code>PortfolioShareToken</code> will be returned in the output in order for the administrator to monitor the status of the <code>PortfolioShare</code> creation process.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(input);
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code> is passed in, <code>PortfolioShare</code> will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a <code>PortfolioShareToken</code> will be returned in the output in order for the administrator to monitor the status of the <code>PortfolioShare</code> creation process.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn share_tag_options(mut self, input: bool) -> Self {
            self.inner = self.inner.share_tag_options(input);
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_share_tag_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProduct`.
    ///
    /// <p>Creates a product.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    /// <p>The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source in the information data section.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_product_input::Builder,
    }
    impl CreateProduct {
        /// Creates a new `CreateProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProductOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the product.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The owner of the product.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(input.into());
            self
        }
        /// <p>The owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The description of the product.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn distributor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distributor(input.into());
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_distributor(input);
            self
        }
        /// <p>The support information about the product.</p>
        pub fn support_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_description(input.into());
            self
        }
        /// <p>The support information about the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_description(input);
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn support_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_email(input.into());
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_email(input);
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p> <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn support_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_url(input.into());
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p> <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_support_url(input);
            self
        }
        /// <p>The type of product.</p>
        pub fn product_type(mut self, input: crate::model::ProductType) -> Self {
            self.inner = self.inner.product_type(input);
            self
        }
        /// <p>The type of product.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::ProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn provisioning_artifact_parameters(
            mut self,
            input: crate::model::ProvisioningArtifactProperties,
        ) -> Self {
            self.inner = self.inner.provisioning_artifact_parameters(input);
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn set_provisioning_artifact_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisionedProductPlan`.
    ///
    /// <p>Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.</p>
    /// <p>You can create one plan per provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILBLE or TAINTED.</p>
    /// <p>To view the resource changes in the change set, use <code>DescribeProvisionedProductPlan</code>. To create or modify the provisioned product, use <code>ExecuteProvisionedProductPlan</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisionedProductPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_provisioned_product_plan_input::Builder,
    }
    impl CreateProvisionedProductPlan {
        /// Creates a new `CreateProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisionedProductPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_name(input.into());
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_name(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::ProvisionedProductPlanType) -> Self {
            self.inner = self.inner.plan_type(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanType>,
        ) -> Self {
            self.inner = self.inner.set_plan_type(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(input.into());
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::UpdateProvisioningParameter,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(input);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningArtifact`.
    ///
    /// <p>Creates a provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot create a provisioning artifact for a product that was shared with you.</p>
    /// <p>The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source in the information data section.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_provisioning_artifact_input::Builder,
    }
    impl CreateProvisioningArtifact {
        /// Creates a new `CreateProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningArtifactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn parameters(mut self, input: crate::model::ProvisioningArtifactProperties) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceAction`.
    ///
    /// <p>Creates a self-service action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_service_action_input::Builder,
    }
    impl CreateServiceAction {
        /// Creates a new `CreateServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn definition_type(mut self, input: crate::model::ServiceActionDefinitionType) -> Self {
            self.inner = self.inner.definition_type(input);
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn set_definition_type(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDefinitionType>,
        ) -> Self {
            self.inner = self.inner.set_definition_type(input);
            self
        }
        /// Adds a key-value pair to `Definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>
        /// Name
        /// </dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>
        /// Version
        /// </dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code> </p>
        /// </dd>
        /// <dt>
        /// AssumeRole
        /// </dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>
        /// Parameters
        /// </dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn definition(
            mut self,
            k: crate::model::ServiceActionDefinitionKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.definition(k, v.into());
            self
        }
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>
        /// Name
        /// </dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>
        /// Version
        /// </dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code> </p>
        /// </dd>
        /// <dt>
        /// AssumeRole
        /// </dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>
        /// Parameters
        /// </dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTagOption`.
    ///
    /// <p>Creates a TagOption.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTagOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tag_option_input::Builder,
    }
    impl CreateTagOption {
        /// Creates a new `CreateTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The TagOption value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConstraint`.
    ///
    /// <p>Deletes the specified constraint.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConstraint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_constraint_input::Builder,
    }
    impl DeleteConstraint {
        /// Creates a new `DeleteConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConstraintError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortfolio`.
    ///
    /// <p>Deletes the specified portfolio.</p>
    /// <p>You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_portfolio_input::Builder,
    }
    impl DeletePortfolio {
        /// Creates a new `DeletePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortfolioShare`.
    ///
    /// <p>Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.</p>
    /// <p>Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePortfolioShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_portfolio_share_input::Builder,
    }
    impl DeletePortfolioShare {
        /// Creates a new `DeletePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortfolioShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(input);
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProduct`.
    ///
    /// <p>Deletes the specified product.</p>
    /// <p>You cannot delete a product if it was shared with you or is associated with a portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_product_input::Builder,
    }
    impl DeleteProduct {
        /// Creates a new `DeleteProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisionedProductPlan`.
    ///
    /// <p>Deletes the specified plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisionedProductPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_provisioned_product_plan_input::Builder,
    }
    impl DeleteProvisionedProductPlan {
        /// Creates a new `DeleteProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisionedProductPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, input: bool) -> Self {
            self.inner = self.inner.ignore_errors(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_errors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningArtifact`.
    ///
    /// <p>Deletes the specified provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_provisioning_artifact_input::Builder,
    }
    impl DeleteProvisioningArtifact {
        /// Creates a new `DeleteProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningArtifactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceAction`.
    ///
    /// <p>Deletes a self-service action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_service_action_input::Builder,
    }
    impl DeleteServiceAction {
        /// Creates a new `DeleteServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTagOption`.
    ///
    /// <p>Deletes the specified TagOption.</p>
    /// <p>You cannot delete a TagOption if it is associated with a product or portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTagOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tag_option_input::Builder,
    }
    impl DeleteTagOption {
        /// Creates a new `DeleteTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConstraint`.
    ///
    /// <p>Gets information about the specified constraint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConstraint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_constraint_input::Builder,
    }
    impl DescribeConstraint {
        /// Creates a new `DescribeConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConstraintError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCopyProductStatus`.
    ///
    /// <p>Gets the status of the specified copy product operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCopyProductStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_copy_product_status_input::Builder,
    }
    impl DescribeCopyProductStatus {
        /// Creates a new `DescribeCopyProductStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCopyProductStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCopyProductStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <code>CopyProduct</code>.</p>
        pub fn copy_product_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_product_token(input.into());
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <code>CopyProduct</code>.</p>
        pub fn set_copy_product_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_product_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolio`.
    ///
    /// <p>Gets information about the specified portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_portfolio_input::Builder,
    }
    impl DescribePortfolio {
        /// Creates a new `DescribePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolioShares`.
    ///
    /// <p>Returns a summary of each of the portfolio shares that were created for the specified portfolio.</p>
    /// <p>You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.</p>
    /// <p>The <code>PortfolioId</code> and <code>Type</code> parameters are both required.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePortfolioShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_portfolio_shares_input::Builder,
    }
    impl DescribePortfolioShares {
        /// Creates a new `DescribePortfolioShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePortfolioSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePortfolioSharesPaginator {
            crate::paginator::DescribePortfolioSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn r#type(mut self, input: crate::model::DescribePortfolioShareType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DescribePortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolioShareStatus`.
    ///
    /// <p>Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePortfolioShareStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_portfolio_share_status_input::Builder,
    }
    impl DescribePortfolioShareStatus {
        /// Creates a new `DescribePortfolioShareStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioShareStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioShareStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_share_token(input.into());
            self
        }
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProduct`.
    ///
    /// <p>Gets information about the specified product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_product_input::Builder,
    }
    impl DescribeProduct {
        /// Creates a new `DescribeProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProductAsAdmin`.
    ///
    /// <p>Gets information about the specified product. This operation is run with administrator access.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProductAsAdmin {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_product_as_admin_input::Builder,
    }
    impl DescribeProductAsAdmin {
        /// Creates a new `DescribeProductAsAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductAsAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductAsAdminError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
        pub fn source_portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_portfolio_id(input.into());
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProductView`.
    ///
    /// <p>Gets information about the specified product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProductView {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_product_view_input::Builder,
    }
    impl DescribeProductView {
        /// Creates a new `DescribeProductView`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductViewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductViewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product view identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The product view identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisionedProduct`.
    ///
    /// <p>Gets information about the specified provisioned product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisionedProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_provisioned_product_input::Builder,
    }
    impl DescribeProvisionedProduct {
        /// Creates a new `DescribeProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisionedProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisionedProductPlan`.
    ///
    /// <p>Gets information about the resource changes for the specified plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisionedProductPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_provisioned_product_plan_input::Builder,
    }
    impl DescribeProvisionedProductPlan {
        /// Creates a new `DescribeProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisionedProductPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningArtifact`.
    ///
    /// <p>Gets information about the specified provisioning artifact (also known as a version) for the specified product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_provisioning_artifact_input::Builder,
    }
    impl DescribeProvisioningArtifact {
        /// Creates a new `DescribeProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningArtifactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(input.into());
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.inner = self.inner.verbose(input);
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningParameters`.
    ///
    /// <p>Gets information about the configuration required to provision the specified product using the specified provisioning artifact.</p>
    /// <p>If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to <code>ProvisionProduct</code>, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_provisioning_parameters_input::Builder,
    }
    impl DescribeProvisioningParameters {
        /// Creates a new `DescribeProvisioningParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecord`.
    ///
    /// <p>Gets information about the specified request operation.</p>
    /// <p>Use this operation after calling a request operation (for example, <code>ProvisionProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>UpdateProvisionedProduct</code>). </p> <note>
    /// <p>If a provisioned product was transferred to a new owner using <code>UpdateProvisionedProductProperties</code>, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use <code>ListRecordHistory</code> to see the product's history from when he was the owner.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecord {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_record_input::Builder,
    }
    impl DescribeRecord {
        /// Creates a new `DescribeRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceAction`.
    ///
    /// <p>Describes a self-service action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_service_action_input::Builder,
    }
    impl DescribeServiceAction {
        /// Creates a new `DescribeServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceActionExecutionParameters`.
    ///
    /// <p>Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServiceActionExecutionParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_service_action_execution_parameters_input::Builder,
    }
    impl DescribeServiceActionExecutionParameters {
        /// Creates a new `DescribeServiceActionExecutionParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceActionExecutionParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeServiceActionExecutionParametersError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTagOption`.
    ///
    /// <p>Gets information about the specified TagOption.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTagOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tag_option_input::Builder,
    }
    impl DescribeTagOption {
        /// Creates a new `DescribeTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAWSOrganizationsAccess`.
    ///
    /// <p>Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but it will prevent you from creating new shares throughout your organization. Current shares will not be in sync with your organization structure if it changes after calling this API. This API can only be called by the management account in the organization.</p>
    /// <p>This API can't be invoked if there are active delegated administrators in the organization.</p>
    /// <p>Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableAWSOrganizationsAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_aws_organizations_access_input::Builder,
    }
    impl DisableAWSOrganizationsAccess {
        /// Creates a new `DisableAWSOrganizationsAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAwsOrganizationsAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableAWSOrganizationsAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateBudgetFromResource`.
    ///
    /// <p>Disassociates the specified budget from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateBudgetFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_budget_from_resource_input::Builder,
    }
    impl DisassociateBudgetFromResource {
        /// Creates a new `DisassociateBudgetFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBudgetFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBudgetFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(input.into());
            self
        }
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePrincipalFromPortfolio`.
    ///
    /// <p>Disassociates a previously associated principal ARN from a specified portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociatePrincipalFromPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_principal_from_portfolio_input::Builder,
    }
    impl DisassociatePrincipalFromPortfolio {
        /// Creates a new `DisassociatePrincipalFromPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePrincipalFromPortfolioOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociatePrincipalFromPortfolioError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateProductFromPortfolio`.
    ///
    /// <p>Disassociates the specified product from the specified portfolio. </p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateProductFromPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_product_from_portfolio_input::Builder,
    }
    impl DisassociateProductFromPortfolio {
        /// Creates a new `DisassociateProductFromPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateProductFromPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateProductFromPortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceActionFromProvisioningArtifact`.
    ///
    /// <p>Disassociates the specified self-service action association from the specified provisioning artifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateServiceActionFromProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder,
    }
    impl DisassociateServiceActionFromProvisioningArtifact {
        /// Creates a new `DisassociateServiceActionFromProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateServiceActionFromProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateServiceActionFromProvisioningArtifactError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTagOptionFromResource`.
    ///
    /// <p>Disassociates the specified TagOption from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTagOptionFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_tag_option_from_resource_input::Builder,
    }
    impl DisassociateTagOptionFromResource {
        /// Creates a new `DisassociateTagOptionFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTagOptionFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTagOptionFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableAWSOrganizationsAccess`.
    ///
    /// <p>Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.</p>
    /// <p>By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.</p>
    /// <p>Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableAWSOrganizationsAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_aws_organizations_access_input::Builder,
    }
    impl EnableAWSOrganizationsAccess {
        /// Creates a new `EnableAWSOrganizationsAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAwsOrganizationsAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAWSOrganizationsAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ExecuteProvisionedProductPlan`.
    ///
    /// <p>Provisions or modifies a product based on the resource changes for the specified plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteProvisionedProductPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_provisioned_product_plan_input::Builder,
    }
    impl ExecuteProvisionedProductPlan {
        /// Creates a new `ExecuteProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteProvisionedProductPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteProvisionedProductServiceAction`.
    ///
    /// <p>Executes a self-service action against a provisioned product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteProvisionedProductServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_provisioned_product_service_action_input::Builder,
    }
    impl ExecuteProvisionedProductServiceAction {
        /// Creates a new `ExecuteProvisionedProductServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteProvisionedProductServiceActionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ExecuteProvisionedProductServiceActionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn execute_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execute_token(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn set_execute_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execute_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v);
            self
        }
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAWSOrganizationsAccessStatus`.
    ///
    /// <p>Get the Access Status for AWS Organization portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAWSOrganizationsAccessStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_aws_organizations_access_status_input::Builder,
    }
    impl GetAWSOrganizationsAccessStatus {
        /// Creates a new `GetAWSOrganizationsAccessStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAwsOrganizationsAccessStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAWSOrganizationsAccessStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetProvisionedProductOutputs`.
    ///
    /// <p>This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProvisionedProductOutputs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_provisioned_product_outputs_input::Builder,
    }
    impl GetProvisionedProductOutputs {
        /// Creates a new `GetProvisionedProductOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProvisionedProductOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProvisionedProductOutputsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetProvisionedProductOutputsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetProvisionedProductOutputsPaginator {
            crate::paginator::GetProvisionedProductOutputsPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// Appends an item to `OutputKeys`.
        ///
        /// To override the contents of this collection use [`set_output_keys`](Self::set_output_keys).
        ///
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn output_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_keys(input.into());
            self
        }
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn set_output_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_output_keys(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportAsProvisionedProduct`.
    ///
    /// <p>Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product.</p>
    /// <p>Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are not supported.</p>
    /// <p>The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>, <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>, <code>IMPORT_ROLLBACK_COMPLETE</code>.</p>
    /// <p>Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact. </p>
    /// <p>The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and <code>cloudformation:DescribeStacks</code> IAM policy permissions. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportAsProvisionedProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_as_provisioned_product_input::Builder,
    }
    impl ImportAsProvisionedProduct {
        /// Creates a new `ImportAsProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportAsProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportAsProvisionedProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
        pub fn physical_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.physical_id(input.into());
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
        pub fn set_physical_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_physical_id(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAcceptedPortfolioShares`.
    ///
    /// <p>Lists all portfolios for which sharing was accepted by this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAcceptedPortfolioShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accepted_portfolio_shares_input::Builder,
    }
    impl ListAcceptedPortfolioShares {
        /// Creates a new `ListAcceptedPortfolioShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAcceptedPortfolioSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAcceptedPortfolioSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAcceptedPortfolioSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAcceptedPortfolioSharesPaginator {
            crate::paginator::ListAcceptedPortfolioSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
        /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
        /// </ul>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(input);
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
        /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
        /// </ul>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBudgetsForResource`.
    ///
    /// <p>Lists all the budgets associated to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBudgetsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_budgets_for_resource_input::Builder,
    }
    impl ListBudgetsForResource {
        /// Creates a new `ListBudgetsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBudgetsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBudgetsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBudgetsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBudgetsForResourcePaginator {
            crate::paginator::ListBudgetsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConstraintsForPortfolio`.
    ///
    /// <p>Lists the constraints for the specified portfolio and product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConstraintsForPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_constraints_for_portfolio_input::Builder,
    }
    impl ListConstraintsForPortfolio {
        /// Creates a new `ListConstraintsForPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConstraintsForPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConstraintsForPortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConstraintsForPortfolioPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConstraintsForPortfolioPaginator {
            crate::paginator::ListConstraintsForPortfolioPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchPaths`.
    ///
    /// <p>Lists the paths to the specified product. A path is how the user has access to a specified product, and is necessary when provisioning a product. A path also determines the constraints put on the product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLaunchPaths {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_launch_paths_input::Builder,
    }
    impl ListLaunchPaths {
        /// Creates a new `ListLaunchPaths`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchPathsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchPathsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLaunchPathsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLaunchPathsPaginator {
            crate::paginator::ListLaunchPathsPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationPortfolioAccess`.
    ///
    /// <p>Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.</p>
    /// <p>If a delegated admin is de-registered, they can no longer perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationPortfolioAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_organization_portfolio_access_input::Builder,
    }
    impl ListOrganizationPortfolioAccess {
        /// Creates a new `ListOrganizationPortfolioAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationPortfolioAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationPortfolioAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationPortfolioAccessPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrganizationPortfolioAccessPaginator {
            crate::paginator::ListOrganizationPortfolioAccessPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
        /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
        /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
        /// </ul>
        pub fn organization_node_type(mut self, input: crate::model::OrganizationNodeType) -> Self {
            self.inner = self.inner.organization_node_type(input);
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
        /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
        /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
        /// </ul>
        pub fn set_organization_node_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationNodeType>,
        ) -> Self {
            self.inner = self.inner.set_organization_node_type(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfolioAccess`.
    ///
    /// <p>Lists the account IDs that have access to the specified portfolio.</p>
    /// <p>A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPortfolioAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_portfolio_access_input::Builder,
    }
    impl ListPortfolioAccess {
        /// Creates a new `ListPortfolioAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfolioAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfolioAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPortfolioAccessPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPortfolioAccessPaginator {
            crate::paginator::ListPortfolioAccessPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn organization_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_parent_id(input.into());
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn set_organization_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_parent_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfolios`.
    ///
    /// <p>Lists all portfolios in the catalog.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPortfolios {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_portfolios_input::Builder,
    }
    impl ListPortfolios {
        /// Creates a new `ListPortfolios`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfoliosOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfoliosError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPortfoliosPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPortfoliosPaginator {
            crate::paginator::ListPortfoliosPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfoliosForProduct`.
    ///
    /// <p>Lists all portfolios that the specified product is associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPortfoliosForProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_portfolios_for_product_input::Builder,
    }
    impl ListPortfoliosForProduct {
        /// Creates a new `ListPortfoliosForProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfoliosForProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfoliosForProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPortfoliosForProductPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPortfoliosForProductPaginator {
            crate::paginator::ListPortfoliosForProductPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipalsForPortfolio`.
    ///
    /// <p>Lists all principal ARNs associated with the specified portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrincipalsForPortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_principals_for_portfolio_input::Builder,
    }
    impl ListPrincipalsForPortfolio {
        /// Creates a new `ListPrincipalsForPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalsForPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalsForPortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPrincipalsForPortfolioPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPrincipalsForPortfolioPaginator {
            crate::paginator::ListPrincipalsForPortfolioPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisionedProductPlans`.
    ///
    /// <p>Lists the plans for the specified provisioned product or all plans to which the user has access.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisionedProductPlans {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_provisioned_product_plans_input::Builder,
    }
    impl ListProvisionedProductPlans {
        /// Creates a new `ListProvisionedProductPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisionedProductPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisionedProductPlansError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provision_product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningArtifacts`.
    ///
    /// <p>Lists all provisioning artifacts (also known as versions) for the specified product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisioningArtifacts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_provisioning_artifacts_input::Builder,
    }
    impl ListProvisioningArtifacts {
        /// Creates a new `ListProvisioningArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisioningArtifactsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningArtifactsForServiceAction`.
    ///
    /// <p>Lists all provisioning artifacts (also known as versions) for the specified self-service action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisioningArtifactsForServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_provisioning_artifacts_for_service_action_input::Builder,
    }
    impl ListProvisioningArtifactsForServiceAction {
        /// Creates a new `ListProvisioningArtifactsForServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningArtifactsForServiceActionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListProvisioningArtifactsForServiceActionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProvisioningArtifactsForServiceActionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListProvisioningArtifactsForServiceActionPaginator {
            crate::paginator::ListProvisioningArtifactsForServiceActionPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecordHistory`.
    ///
    /// <p>Lists the specified requests or all performed requests.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecordHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_record_history_input::Builder,
    }
    impl ListRecordHistory {
        /// Creates a new `ListRecordHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn search_filter(mut self, input: crate::model::ListRecordHistorySearchFilter) -> Self {
            self.inner = self.inner.search_filter(input);
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn set_search_filter(
            mut self,
            input: std::option::Option<crate::model::ListRecordHistorySearchFilter>,
        ) -> Self {
            self.inner = self.inner.set_search_filter(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesForTagOption`.
    ///
    /// <p>Lists the resources associated with the specified TagOption.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourcesForTagOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_for_tag_option_input::Builder,
    }
    impl ListResourcesForTagOption {
        /// Creates a new `ListResourcesForTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesForTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesForTagOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesForTagOptionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourcesForTagOptionPaginator {
            crate::paginator::ListResourcesForTagOptionPaginator::new(self.handle, self.inner)
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li> <p> <code>Portfolio</code> </p> </li>
        /// <li> <p> <code>Product</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li> <p> <code>Portfolio</code> </p> </li>
        /// <li> <p> <code>Product</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceActions`.
    ///
    /// <p>Lists all self-service actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_service_actions_input::Builder,
    }
    impl ListServiceActions {
        /// Creates a new `ListServiceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServiceActionsPaginator {
            crate::paginator::ListServiceActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceActionsForProvisioningArtifact`.
    ///
    /// <p>Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceActionsForProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_service_actions_for_provisioning_artifact_input::Builder,
    }
    impl ListServiceActionsForProvisioningArtifact {
        /// Creates a new `ListServiceActionsForProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceActionsForProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServiceActionsForProvisioningArtifactError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceActionsForProvisioningArtifactPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListServiceActionsForProvisioningArtifactPaginator {
            crate::paginator::ListServiceActionsForProvisioningArtifactPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackInstancesForProvisionedProduct`.
    ///
    /// <p>Returns summary information about stack instances that are associated with the specified <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStackInstancesForProvisionedProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_stack_instances_for_provisioned_product_input::Builder,
    }
    impl ListStackInstancesForProvisionedProduct {
        /// Creates a new `ListStackInstancesForProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackInstancesForProvisionedProductOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListStackInstancesForProvisionedProductError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagOptions`.
    ///
    /// <p>Lists the specified TagOptions or all TagOptions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tag_options_input::Builder,
    }
    impl ListTagOptions {
        /// Creates a new `ListTagOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagOptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagOptionsPaginator {
            crate::paginator::ListTagOptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn filters(mut self, input: crate::model::ListTagOptionsFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListTagOptionsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionProduct`.
    ///
    /// <p>Provisions the specified product.</p>
    /// <p>A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of this request using <code>DescribeRecord</code>.</p>
    /// <p>If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ProvisionProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::provision_product_input::Builder,
    }
    impl ProvisionProduct {
        /// Creates a new `ProvisionProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::ProvisioningParameter,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(input);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            input: crate::model::ProvisioningPreferences,
        ) -> Self {
            self.inner = self.inner.provisioning_preferences(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::ProvisioningPreferences>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_preferences(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(input.into());
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn provision_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provision_token(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn set_provision_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectPortfolioShare`.
    ///
    /// <p>Rejects an offer to share the specified portfolio.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectPortfolioShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_portfolio_share_input::Builder,
    }
    impl RejectPortfolioShare {
        /// Creates a new `RejectPortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectPortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectPortfolioShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(input);
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ScanProvisionedProducts`.
    ///
    /// <p>Lists the provisioned products that are available (not terminated).</p>
    /// <p>To use additional filtering, see <code>SearchProvisionedProducts</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ScanProvisionedProducts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::scan_provisioned_products_input::Builder,
    }
    impl ScanProvisionedProducts {
        /// Creates a new `ScanProvisionedProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScanProvisionedProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::ScanProvisionedProductsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProducts`.
    ///
    /// <p>Gets information about the products to which the caller has access.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchProducts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_products_input::Builder,
    }
    impl SearchProducts {
        /// Creates a new `SearchProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProductsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchProductsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchProductsPaginator {
            crate::paginator::SearchProductsPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
        pub fn filters(
            mut self,
            k: crate::model::ProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, input: crate::model::ProductViewSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProductsAsAdmin`.
    ///
    /// <p>Gets information about the products for the specified portfolio or all products.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchProductsAsAdmin {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_products_as_admin_input::Builder,
    }
    impl SearchProductsAsAdmin {
        /// Creates a new `SearchProductsAsAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProductsAsAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProductsAsAdminError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchProductsAsAdminPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchProductsAsAdminPaginator {
            crate::paginator::SearchProductsAsAdminPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
        pub fn filters(
            mut self,
            k: crate::model::ProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, input: crate::model::ProductViewSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn product_source(mut self, input: crate::model::ProductSource) -> Self {
            self.inner = self.inner.product_source(input);
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn set_product_source(
            mut self,
            input: std::option::Option<crate::model::ProductSource>,
        ) -> Self {
            self.inner = self.inner.set_product_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProvisionedProducts`.
    ///
    /// <p>Gets information about the provisioned products that meet the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchProvisionedProducts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_provisioned_products_input::Builder,
    }
    impl SearchProvisionedProducts {
        /// Creates a new `SearchProvisionedProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProvisionedProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProvisionedProductsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchProvisionedProductsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchProvisionedProductsPaginator {
            crate::paginator::SearchProvisionedProductsPaginator::new(self.handle, self.inner)
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
        pub fn filters(
            mut self,
            k: crate::model::ProvisionedProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProvisionedProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(input.into());
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateProvisionedProduct`.
    ///
    /// <p>Terminates the specified provisioned product.</p>
    /// <p>This operation does not delete any records associated with the provisioned product.</p>
    /// <p>You can check the status of this request using <code>DescribeRecord</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TerminateProvisionedProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::terminate_provisioned_product_input::Builder,
    }
    impl TerminateProvisionedProduct {
        /// Creates a new `TerminateProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateProvisionedProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
        pub fn terminate_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminate_token(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
        pub fn set_terminate_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_terminate_token(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, input: bool) -> Self {
            self.inner = self.inner.ignore_errors(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_errors(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
        pub fn retain_physical_resources(mut self, input: bool) -> Self {
            self.inner = self.inner.retain_physical_resources(input);
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
        pub fn set_retain_physical_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retain_physical_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConstraint`.
    ///
    /// <p>Updates the specified constraint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConstraint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_constraint_input::Builder,
    }
    impl UpdateConstraint {
        /// Creates a new `UpdateConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConstraintError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameters(input.into());
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortfolio`.
    ///
    /// <p>Updates the specified portfolio.</p>
    /// <p>You cannot update a product that was shared with you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePortfolio {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_portfolio_input::Builder,
    }
    impl UpdatePortfolio {
        /// Creates a new `UpdatePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortfolioError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(input.into());
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.add_tags(input);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove.</p>
        pub fn remove_tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tags(input.into());
            self
        }
        /// <p>The tags to remove.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortfolioShare`.
    ///
    /// <p>Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share. </p>
    /// <p>The portfolio share cannot be updated if the <code> CreatePortfolioShare</code> operation is <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED.</p>
    /// <p>You must provide the <code>accountId</code> or organization node in the input, but not both.</p>
    /// <p>If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type. </p>
    /// <p>This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for that action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePortfolioShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_portfolio_share_input::Builder,
    }
    impl UpdatePortfolioShare {
        /// Creates a new `UpdatePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortfolioShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(input.into());
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(input);
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn share_tag_options(mut self, input: bool) -> Self {
            self.inner = self.inner.share_tag_options(input);
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_share_tag_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProduct`.
    ///
    /// <p>Updates the specified product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_product_input::Builder,
    }
    impl UpdateProduct {
        /// Creates a new `UpdateProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProductOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The updated product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(input.into());
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn distributor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distributor(input.into());
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_distributor(input);
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn support_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_description(input.into());
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_description(input);
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn support_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_email(input.into());
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_email(input);
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn support_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_url(input.into());
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_support_url(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add to the product.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.add_tags(input);
            self
        }
        /// <p>The tags to add to the product.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove from the product.</p>
        pub fn remove_tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tags(input.into());
            self
        }
        /// <p>The tags to remove from the product.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisionedProduct`.
    ///
    /// <p>Requests updates to the configuration of the specified provisioned product.</p>
    /// <p>If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.</p>
    /// <p>You can check the status of this request using <code>DescribeRecord</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProvisionedProduct {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_provisioned_product_input::Builder,
    }
    impl UpdateProvisionedProduct {
        /// Creates a new `UpdateProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProvisionedProductError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(input.into());
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(input.into());
            self
        }
        /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>The new parameters.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::UpdateProvisioningParameter,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(input);
            self
        }
        /// <p>The new parameters.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            input: crate::model::UpdateProvisioningPreferences,
        ) -> Self {
            self.inner = self.inner.provisioning_preferences(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::UpdateProvisioningPreferences>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_preferences(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(input.into());
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisionedProductProperties`.
    ///
    /// <p>Requests updates to the properties of the specified provisioned product.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProvisionedProductProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_provisioned_product_properties_input::Builder,
    }
    impl UpdateProvisionedProductProperties {
        /// Creates a new `UpdateProvisionedProductProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisionedProductPropertiesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateProvisionedProductPropertiesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// Adds a key-value pair to `ProvisionedProductProperties`.
        ///
        /// To override the contents of this collection use [`set_provisioned_product_properties`](Self::set_provisioned_product_properties).
        ///
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
        pub fn provisioned_product_properties(
            mut self,
            k: crate::model::PropertyKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provisioned_product_properties(k, v.into());
            self
        }
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
        pub fn set_provisioned_product_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_properties(input);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisioningArtifact`.
    ///
    /// <p>Updates the specified provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot update a provisioning artifact for a product that was shared with you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProvisioningArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_provisioning_artifact_input::Builder,
    }
    impl UpdateProvisioningArtifact {
        /// Creates a new `UpdateProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProvisioningArtifactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.inner = self.inner.active(input);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn guidance(mut self, input: crate::model::ProvisioningArtifactGuidance) -> Self {
            self.inner = self.inner.guidance(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn set_guidance(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
        ) -> Self {
            self.inner = self.inner.set_guidance(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceAction`.
    ///
    /// <p>Updates a self-service action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServiceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_service_action_input::Builder,
    }
    impl UpdateServiceAction {
        /// Creates a new `UpdateServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>A map that defines the self-service action.</p>
        pub fn definition(
            mut self,
            k: crate::model::ServiceActionDefinitionKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.definition(k, v.into());
            self
        }
        /// <p>A map that defines the self-service action.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagOption`.
    ///
    /// <p>Updates the specified TagOption.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTagOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_tag_option_input::Builder,
    }
    impl UpdateTagOption {
        /// Creates a new `UpdateTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The updated value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The updated active state.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.inner = self.inner.active(input);
            self
        }
        /// <p>The updated active state.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
