// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_portfolio_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptPortfolioShareOutput,
    crate::error::AcceptPortfolioShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptPortfolioShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AcceptPortfolioShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::AcceptPortfolioShareError {
            meta: generic,
            kind: crate::error::AcceptPortfolioShareErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptPortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AcceptPortfolioShareError {
            meta: generic,
            kind: crate::error::AcceptPortfolioShareErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptPortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AcceptPortfolioShareError {
            meta: generic,
            kind: crate::error::AcceptPortfolioShareErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AcceptPortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcceptPortfolioShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_portfolio_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptPortfolioShareOutput,
    crate::error::AcceptPortfolioShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_portfolio_share_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_budget_with_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateBudgetWithResourceOutput,
    crate::error::AssociateBudgetWithResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateBudgetWithResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateBudgetWithResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::AssociateBudgetWithResourceError {
            meta: generic,
            kind: crate::error::AssociateBudgetWithResourceErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBudgetWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParametersException" => crate::error::AssociateBudgetWithResourceError {
            meta: generic,
            kind: crate::error::AssociateBudgetWithResourceErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBudgetWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AssociateBudgetWithResourceError {
            meta: generic,
            kind: crate::error::AssociateBudgetWithResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBudgetWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateBudgetWithResourceError {
            meta: generic,
            kind: crate::error::AssociateBudgetWithResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateBudgetWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateBudgetWithResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_budget_with_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateBudgetWithResourceOutput,
    crate::error::AssociateBudgetWithResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_budget_with_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_principal_with_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociatePrincipalWithPortfolioOutput,
    crate::error::AssociatePrincipalWithPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociatePrincipalWithPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociatePrincipalWithPortfolioError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::AssociatePrincipalWithPortfolioError {
            meta: generic,
            kind:
                crate::error::AssociatePrincipalWithPortfolioErrorKind::InvalidParametersException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameters_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePrincipalWithPortfolioError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::AssociatePrincipalWithPortfolioError {
            meta: generic,
            kind: crate::error::AssociatePrincipalWithPortfolioErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePrincipalWithPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociatePrincipalWithPortfolioError {
            meta: generic,
            kind: crate::error::AssociatePrincipalWithPortfolioErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociatePrincipalWithPortfolioError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::AssociatePrincipalWithPortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_principal_with_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociatePrincipalWithPortfolioOutput,
    crate::error::AssociatePrincipalWithPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_principal_with_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_product_with_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateProductWithPortfolioOutput,
    crate::error::AssociateProductWithPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateProductWithPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateProductWithPortfolioError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::AssociateProductWithPortfolioError {
            meta: generic,
            kind: crate::error::AssociateProductWithPortfolioErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateProductWithPortfolioError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceededException" => crate::error::AssociateProductWithPortfolioError {
            meta: generic,
            kind: crate::error::AssociateProductWithPortfolioErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateProductWithPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateProductWithPortfolioError {
            meta: generic,
            kind: crate::error::AssociateProductWithPortfolioErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateProductWithPortfolioError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::AssociateProductWithPortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_product_with_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateProductWithPortfolioOutput,
    crate::error::AssociateProductWithPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_product_with_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_service_action_with_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateServiceActionWithProvisioningArtifactOutput,
    crate::error::AssociateServiceActionWithProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateServiceActionWithProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::AssociateServiceActionWithProvisioningArtifactError::unhandled(
                    generic,
                ),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::AssociateServiceActionWithProvisioningArtifactError { meta: generic, kind: crate::error::AssociateServiceActionWithProvisioningArtifactErrorKind::DuplicateResourceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateServiceActionWithProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::AssociateServiceActionWithProvisioningArtifactError { meta: generic, kind: crate::error::AssociateServiceActionWithProvisioningArtifactErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateServiceActionWithProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::AssociateServiceActionWithProvisioningArtifactError { meta: generic, kind: crate::error::AssociateServiceActionWithProvisioningArtifactErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateServiceActionWithProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AssociateServiceActionWithProvisioningArtifactError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_service_action_with_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateServiceActionWithProvisioningArtifactOutput,
    crate::error::AssociateServiceActionWithProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::associate_service_action_with_provisioning_artifact_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_tag_option_with_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTagOptionWithResourceOutput,
    crate::error::AssociateTagOptionWithResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateTagOptionWithResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind: crate::error::AssociateTagOptionWithResourceErrorKind::DuplicateResourceException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::duplicate_resource_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParametersException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind: crate::error::AssociateTagOptionWithResourceErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidStateException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind: crate::error::AssociateTagOptionWithResourceErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind: crate::error::AssociateTagOptionWithResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind: crate::error::AssociateTagOptionWithResourceErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TagOptionNotMigratedException" => crate::error::AssociateTagOptionWithResourceError {
            meta: generic,
            kind:
                crate::error::AssociateTagOptionWithResourceErrorKind::TagOptionNotMigratedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::tag_option_not_migrated_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTagOptionWithResourceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::AssociateTagOptionWithResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_tag_option_with_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTagOptionWithResourceOutput,
    crate::error::AssociateTagOptionWithResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::associate_tag_option_with_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_associate_service_action_with_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput,
    crate::error::BatchAssociateServiceActionWithProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response).map_err(
        crate::error::BatchAssociateServiceActionWithProvisioningArtifactError::unhandled,
    )?;
    let error_code =
        match generic.code() {
            Some(code) => code,
            None => return Err(
                crate::error::BatchAssociateServiceActionWithProvisioningArtifactError::unhandled(
                    generic,
                ),
            ),
        };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::BatchAssociateServiceActionWithProvisioningArtifactError { meta: generic, kind: crate::error::BatchAssociateServiceActionWithProvisioningArtifactErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchAssociateServiceActionWithProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchAssociateServiceActionWithProvisioningArtifactError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_associate_service_action_with_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput,
    crate::error::BatchAssociateServiceActionWithProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::batch_associate_service_action_with_provisioning_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_associate_service_action_with_provisioning_artifact(response.body().as_ref(), output).map_err(crate::error::BatchAssociateServiceActionWithProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_disassociate_service_action_from_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput,
    crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response).map_err(
        crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError::unhandled,
    )?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(
            crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError::unhandled(
                generic,
            ),
        ),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError { meta: generic, kind: crate::error::BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_disassociate_service_action_from_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput,
    crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::batch_disassociate_service_action_from_provisioning_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_disassociate_service_action_from_provisioning_artifact(response.body().as_ref(), output).map_err(crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyProductOutput, crate::error::CopyProductError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CopyProductError {
            meta: generic,
            kind: crate::error::CopyProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CopyProductError {
            meta: generic,
            kind: crate::error::CopyProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopyProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyProductOutput, crate::error::CopyProductError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_copy_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_constraint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateConstraintOutput, crate::error::CreateConstraintError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConstraintError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateConstraintError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::CreateConstraintError {
            meta: generic,
            kind: crate::error::CreateConstraintErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParametersException" => crate::error::CreateConstraintError {
            meta: generic,
            kind: crate::error::CreateConstraintErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateConstraintError {
            meta: generic,
            kind: crate::error::CreateConstraintErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateConstraintError {
            meta: generic,
            kind: crate::error::CreateConstraintErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateConstraintError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_constraint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateConstraintOutput, crate::error::CreateConstraintError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_constraint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_constraint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateConstraintError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePortfolioOutput, crate::error::CreatePortfolioError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePortfolioError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreatePortfolioError {
            meta: generic,
            kind: crate::error::CreatePortfolioErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreatePortfolioError {
            meta: generic,
            kind: crate::error::CreatePortfolioErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::CreatePortfolioError {
            meta: generic,
            kind: crate::error::CreatePortfolioErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePortfolioOutput, crate::error::CreatePortfolioError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_portfolio_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_portfolio(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePortfolioError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portfolio_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePortfolioShareOutput,
    crate::error::CreatePortfolioShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePortfolioShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePortfolioShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreatePortfolioShareError {
            meta: generic,
            kind: crate::error::CreatePortfolioShareErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStateException" => crate::error::CreatePortfolioShareError {
            meta: generic,
            kind: crate::error::CreatePortfolioShareErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreatePortfolioShareError {
            meta: generic,
            kind: crate::error::CreatePortfolioShareErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::CreatePortfolioShareError {
            meta: generic,
            kind: crate::error::CreatePortfolioShareErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreatePortfolioShareError {
            meta: generic,
            kind: crate::error::CreatePortfolioShareErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePortfolioShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_portfolio_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePortfolioShareOutput,
    crate::error::CreatePortfolioShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_portfolio_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_portfolio_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePortfolioShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProductOutput, crate::error::CreateProductError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreateProductError {
            meta: generic,
            kind: crate::error::CreateProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateProductError {
            meta: generic,
            kind: crate::error::CreateProductErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::CreateProductError {
            meta: generic,
            kind: crate::error::CreateProductErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProductOutput, crate::error::CreateProductError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_provisioned_product_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProvisionedProductPlanOutput,
    crate::error::CreateProvisionedProductPlanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProvisionedProductPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateProvisionedProductPlanError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreateProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::CreateProvisionedProductPlanErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidStateException" => crate::error::CreateProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::CreateProvisionedProductPlanErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisionedProductPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::CreateProvisionedProductPlanErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisionedProductPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProvisionedProductPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_provisioned_product_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProvisionedProductPlanOutput,
    crate::error::CreateProvisionedProductPlanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_provisioned_product_plan_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_provisioned_product_plan(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateProvisionedProductPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProvisioningArtifactOutput,
    crate::error::CreateProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateProvisioningArtifactError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreateProvisioningArtifactError {
            meta: generic,
            kind: crate::error::CreateProvisioningArtifactErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateProvisioningArtifactError {
            meta: generic,
            kind: crate::error::CreateProvisioningArtifactErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateProvisioningArtifactError {
            meta: generic,
            kind: crate::error::CreateProvisioningArtifactErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProvisioningArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProvisioningArtifactOutput,
    crate::error::CreateProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_provisioning_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_provisioning_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceActionOutput,
    crate::error::CreateServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateServiceActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::CreateServiceActionError {
            meta: generic,
            kind: crate::error::CreateServiceActionErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateServiceActionError {
            meta: generic,
            kind: crate::error::CreateServiceActionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateServiceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceActionOutput,
    crate::error::CreateServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_service_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_service_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateServiceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tag_option_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagOptionOutput, crate::error::CreateTagOptionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTagOptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTagOptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::CreateTagOptionError {
            meta: generic,
            kind: crate::error::CreateTagOptionErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateTagOptionError {
            meta: generic,
            kind: crate::error::CreateTagOptionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::CreateTagOptionError {
            meta: generic,
            kind: crate::error::CreateTagOptionErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTagOptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tag_option_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagOptionOutput, crate::error::CreateTagOptionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tag_option_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_tag_option(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTagOptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_constraint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteConstraintOutput, crate::error::DeleteConstraintError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConstraintError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteConstraintError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeleteConstraintError {
            meta: generic,
            kind: crate::error::DeleteConstraintErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteConstraintError {
            meta: generic,
            kind: crate::error::DeleteConstraintErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteConstraintError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_constraint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteConstraintOutput, crate::error::DeleteConstraintError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_constraint_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePortfolioOutput, crate::error::DeletePortfolioError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePortfolioError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeletePortfolioError {
            meta: generic,
            kind: crate::error::DeletePortfolioErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeletePortfolioError {
            meta: generic,
            kind: crate::error::DeletePortfolioErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeletePortfolioError {
            meta: generic,
            kind: crate::error::DeletePortfolioErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::DeletePortfolioError {
            meta: generic,
            kind: crate::error::DeletePortfolioErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePortfolioOutput, crate::error::DeletePortfolioError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portfolio_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePortfolioShareOutput,
    crate::error::DeletePortfolioShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePortfolioShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePortfolioShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeletePortfolioShareError {
            meta: generic,
            kind: crate::error::DeletePortfolioShareErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStateException" => crate::error::DeletePortfolioShareError {
            meta: generic,
            kind: crate::error::DeletePortfolioShareErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::DeletePortfolioShareError {
            meta: generic,
            kind: crate::error::DeletePortfolioShareErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeletePortfolioShareError {
            meta: generic,
            kind: crate::error::DeletePortfolioShareErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePortfolioShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_portfolio_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePortfolioShareOutput,
    crate::error::DeletePortfolioShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_portfolio_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_portfolio_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePortfolioShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProductOutput, crate::error::DeleteProductError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeleteProductError {
            meta: generic,
            kind: crate::error::DeleteProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteProductError {
            meta: generic,
            kind: crate::error::DeleteProductErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteProductError {
            meta: generic,
            kind: crate::error::DeleteProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::DeleteProductError {
            meta: generic,
            kind: crate::error::DeleteProductErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProductOutput, crate::error::DeleteProductError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_product_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioned_product_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisionedProductPlanOutput,
    crate::error::DeleteProvisionedProductPlanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProvisionedProductPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteProvisionedProductPlanError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeleteProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::DeleteProvisionedProductPlanErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DeleteProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::DeleteProvisionedProductPlanErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedProductPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteProvisionedProductPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioned_product_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisionedProductPlanOutput,
    crate::error::DeleteProvisionedProductPlanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_provisioned_product_plan_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisioningArtifactOutput,
    crate::error::DeleteProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteProvisioningArtifactError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DeleteProvisioningArtifactError {
            meta: generic,
            kind: crate::error::DeleteProvisioningArtifactErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteProvisioningArtifactError {
            meta: generic,
            kind: crate::error::DeleteProvisioningArtifactErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteProvisioningArtifactError {
            meta: generic,
            kind: crate::error::DeleteProvisioningArtifactErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteProvisioningArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisioningArtifactOutput,
    crate::error::DeleteProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_provisioning_artifact_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceActionOutput,
    crate::error::DeleteServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteServiceActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUseException" => crate::error::DeleteServiceActionError {
            meta: generic,
            kind: crate::error::DeleteServiceActionErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteServiceActionError {
            meta: generic,
            kind: crate::error::DeleteServiceActionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServiceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceActionOutput,
    crate::error::DeleteServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_service_action_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tag_option_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagOptionOutput, crate::error::DeleteTagOptionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagOptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagOptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUseException" => crate::error::DeleteTagOptionError {
            meta: generic,
            kind: crate::error::DeleteTagOptionErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteTagOptionError {
            meta: generic,
            kind: crate::error::DeleteTagOptionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::DeleteTagOptionError {
            meta: generic,
            kind: crate::error::DeleteTagOptionErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagOptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tag_option_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagOptionOutput, crate::error::DeleteTagOptionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tag_option_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_constraint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConstraintOutput,
    crate::error::DescribeConstraintError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConstraintError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeConstraintError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeConstraintError {
            meta: generic,
            kind: crate::error::DescribeConstraintErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeConstraintError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_constraint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConstraintOutput,
    crate::error::DescribeConstraintError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_constraint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_constraint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConstraintError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_copy_product_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCopyProductStatusOutput,
    crate::error::DescribeCopyProductStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCopyProductStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCopyProductStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeCopyProductStatusError {
            meta: generic,
            kind: crate::error::DescribeCopyProductStatusErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCopyProductStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCopyProductStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_copy_product_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCopyProductStatusOutput,
    crate::error::DescribeCopyProductStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_copy_product_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_copy_product_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCopyProductStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePortfolioOutput, crate::error::DescribePortfolioError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePortfolioError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribePortfolioError {
            meta: generic,
            kind: crate::error::DescribePortfolioErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePortfolioOutput, crate::error::DescribePortfolioError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_portfolio_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_portfolio(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePortfolioError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePortfolioSharesOutput,
    crate::error::DescribePortfolioSharesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePortfolioSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePortfolioSharesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribePortfolioSharesError {
            meta: generic,
            kind: crate::error::DescribePortfolioSharesErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribePortfolioSharesError {
            meta: generic,
            kind: crate::error::DescribePortfolioSharesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePortfolioSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePortfolioSharesOutput,
    crate::error::DescribePortfolioSharesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_portfolio_shares_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_portfolio_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePortfolioSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_share_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePortfolioShareStatusOutput,
    crate::error::DescribePortfolioShareStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePortfolioShareStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePortfolioShareStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribePortfolioShareStatusError {
            meta: generic,
            kind: crate::error::DescribePortfolioShareStatusErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioShareStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotSupportedException" => crate::error::DescribePortfolioShareStatusError {
            meta: generic,
            kind:
                crate::error::DescribePortfolioShareStatusErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioShareStatusError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DescribePortfolioShareStatusError {
            meta: generic,
            kind: crate::error::DescribePortfolioShareStatusErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePortfolioShareStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePortfolioShareStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_portfolio_share_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePortfolioShareStatusOutput,
    crate::error::DescribePortfolioShareStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_portfolio_share_status_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_portfolio_share_status(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribePortfolioShareStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProductOutput, crate::error::DescribeProductError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProductError {
            meta: generic,
            kind: crate::error::DescribeProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeProductError {
            meta: generic,
            kind: crate::error::DescribeProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProductOutput, crate::error::DescribeProductError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_as_admin_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProductAsAdminOutput,
    crate::error::DescribeProductAsAdminError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProductAsAdminError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeProductAsAdminError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProductAsAdminError {
            meta: generic,
            kind: crate::error::DescribeProductAsAdminErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductAsAdminError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeProductAsAdminError {
            meta: generic,
            kind: crate::error::DescribeProductAsAdminErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductAsAdminError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProductAsAdminError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_as_admin_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProductAsAdminOutput,
    crate::error::DescribeProductAsAdminError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_product_as_admin_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_product_as_admin(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProductAsAdminError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_view_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProductViewOutput,
    crate::error::DescribeProductViewError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProductViewError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProductViewError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProductViewError {
            meta: generic,
            kind: crate::error::DescribeProductViewErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductViewError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeProductViewError {
            meta: generic,
            kind: crate::error::DescribeProductViewErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProductViewError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProductViewError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_product_view_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProductViewOutput,
    crate::error::DescribeProductViewError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_product_view_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_product_view(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProductViewError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioned_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisionedProductOutput,
    crate::error::DescribeProvisionedProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProvisionedProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeProvisionedProductError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProvisionedProductError {
            meta: generic,
            kind: crate::error::DescribeProvisionedProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeProvisionedProductError {
            meta: generic,
            kind: crate::error::DescribeProvisionedProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProvisionedProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioned_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisionedProductOutput,
    crate::error::DescribeProvisionedProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_provisioned_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_provisioned_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProvisionedProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioned_product_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisionedProductPlanOutput,
    crate::error::DescribeProvisionedProductPlanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProvisionedProductPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProvisionedProductPlanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::DescribeProvisionedProductPlanErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DescribeProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::DescribeProvisionedProductPlanErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeProvisionedProductPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioned_product_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisionedProductPlanOutput,
    crate::error::DescribeProvisionedProductPlanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_provisioned_product_plan_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_provisioned_product_plan(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeProvisionedProductPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisioningArtifactOutput,
    crate::error::DescribeProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeProvisioningArtifactError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProvisioningArtifactError {
            meta: generic,
            kind: crate::error::DescribeProvisioningArtifactErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisioningArtifactError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DescribeProvisioningArtifactError {
            meta: generic,
            kind: crate::error::DescribeProvisioningArtifactErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeProvisioningArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisioningArtifactOutput,
    crate::error::DescribeProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_provisioning_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_provisioning_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioning_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisioningParametersOutput,
    crate::error::DescribeProvisioningParametersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProvisioningParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProvisioningParametersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeProvisioningParametersError {
            meta: generic,
            kind: crate::error::DescribeProvisioningParametersErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisioningParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DescribeProvisioningParametersError {
            meta: generic,
            kind: crate::error::DescribeProvisioningParametersErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProvisioningParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeProvisioningParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_provisioning_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProvisioningParametersOutput,
    crate::error::DescribeProvisioningParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_provisioning_parameters_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_provisioning_parameters(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeProvisioningParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_record_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRecordOutput, crate::error::DescribeRecordError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRecordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeRecordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeRecordError {
            meta: generic,
            kind: crate::error::DescribeRecordErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRecordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeRecordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_record_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRecordOutput, crate::error::DescribeRecordError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_record_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_record(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRecordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceActionOutput,
    crate::error::DescribeServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeServiceActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeServiceActionError {
            meta: generic,
            kind: crate::error::DescribeServiceActionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeServiceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceActionOutput,
    crate::error::DescribeServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_service_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_service_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeServiceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_action_execution_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceActionExecutionParametersOutput,
    crate::error::DescribeServiceActionExecutionParametersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeServiceActionExecutionParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeServiceActionExecutionParametersError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DescribeServiceActionExecutionParametersError { meta: generic, kind: crate::error::DescribeServiceActionExecutionParametersErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceActionExecutionParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DescribeServiceActionExecutionParametersError { meta: generic, kind: crate::error::DescribeServiceActionExecutionParametersErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceActionExecutionParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeServiceActionExecutionParametersError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_action_execution_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceActionExecutionParametersOutput,
    crate::error::DescribeServiceActionExecutionParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_service_action_execution_parameters_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_service_action_execution_parameters(response.body().as_ref(), output).map_err(crate::error::DescribeServiceActionExecutionParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tag_option_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagOptionOutput, crate::error::DescribeTagOptionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagOptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagOptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DescribeTagOptionError {
            meta: generic,
            kind: crate::error::DescribeTagOptionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::DescribeTagOptionError {
            meta: generic,
            kind: crate::error::DescribeTagOptionErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagOptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tag_option_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagOptionOutput, crate::error::DescribeTagOptionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tag_option_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tag_option(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagOptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_aws_organizations_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAwsOrganizationsAccessOutput,
    crate::error::DisableAWSOrganizationsAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableAWSOrganizationsAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableAWSOrganizationsAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidStateException" => crate::error::DisableAWSOrganizationsAccessError {
            meta: generic,
            kind: crate::error::DisableAWSOrganizationsAccessErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSOrganizationsAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::DisableAWSOrganizationsAccessError {
            meta: generic,
            kind:
                crate::error::DisableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSOrganizationsAccessError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::DisableAWSOrganizationsAccessError {
            meta: generic,
            kind: crate::error::DisableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAWSOrganizationsAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DisableAWSOrganizationsAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_aws_organizations_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAwsOrganizationsAccessOutput,
    crate::error::DisableAWSOrganizationsAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_aws_organizations_access_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_budget_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateBudgetFromResourceOutput,
    crate::error::DisassociateBudgetFromResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateBudgetFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateBudgetFromResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DisassociateBudgetFromResourceError {
            meta: generic,
            kind: crate::error::DisassociateBudgetFromResourceErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateBudgetFromResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DisassociateBudgetFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_budget_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateBudgetFromResourceOutput,
    crate::error::DisassociateBudgetFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_budget_from_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_principal_from_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociatePrincipalFromPortfolioOutput,
    crate::error::DisassociatePrincipalFromPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociatePrincipalFromPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociatePrincipalFromPortfolioError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DisassociatePrincipalFromPortfolioError { meta: generic, kind: crate::error::DisassociatePrincipalFromPortfolioErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePrincipalFromPortfolioError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DisassociatePrincipalFromPortfolioError { meta: generic, kind: crate::error::DisassociatePrincipalFromPortfolioErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociatePrincipalFromPortfolioError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociatePrincipalFromPortfolioError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_principal_from_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociatePrincipalFromPortfolioOutput,
    crate::error::DisassociatePrincipalFromPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_principal_from_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_product_from_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateProductFromPortfolioOutput,
    crate::error::DisassociateProductFromPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateProductFromPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateProductFromPortfolioError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::DisassociateProductFromPortfolioError {
            meta: generic,
            kind:
                crate::error::DisassociateProductFromPortfolioErrorKind::InvalidParametersException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameters_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateProductFromPortfolioError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceInUseException" => crate::error::DisassociateProductFromPortfolioError {
            meta: generic,
            kind: crate::error::DisassociateProductFromPortfolioErrorKind::ResourceInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_in_use_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateProductFromPortfolioError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DisassociateProductFromPortfolioError {
            meta: generic,
            kind:
                crate::error::DisassociateProductFromPortfolioErrorKind::ResourceNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateProductFromPortfolioError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DisassociateProductFromPortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_product_from_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateProductFromPortfolioOutput,
    crate::error::DisassociateProductFromPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_product_from_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_service_action_from_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateServiceActionFromProvisioningArtifactOutput,
    crate::error::DisassociateServiceActionFromProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateServiceActionFromProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DisassociateServiceActionFromProvisioningArtifactError::unhandled(
                    generic,
                ),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DisassociateServiceActionFromProvisioningArtifactError { meta: generic, kind: crate::error::DisassociateServiceActionFromProvisioningArtifactErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateServiceActionFromProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateServiceActionFromProvisioningArtifactError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_service_action_from_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateServiceActionFromProvisioningArtifactOutput,
    crate::error::DisassociateServiceActionFromProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::disassociate_service_action_from_provisioning_artifact_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_tag_option_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTagOptionFromResourceOutput,
    crate::error::DisassociateTagOptionFromResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateTagOptionFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateTagOptionFromResourceError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::DisassociateTagOptionFromResourceError { meta: generic, kind: crate::error::DisassociateTagOptionFromResourceErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTagOptionFromResourceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagOptionNotMigratedException" => crate::error::DisassociateTagOptionFromResourceError { meta: generic, kind: crate::error::DisassociateTagOptionFromResourceErrorKind::TagOptionNotMigratedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTagOptionFromResourceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DisassociateTagOptionFromResourceError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_tag_option_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTagOptionFromResourceOutput,
    crate::error::DisassociateTagOptionFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disassociate_tag_option_from_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_aws_organizations_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAwsOrganizationsAccessOutput,
    crate::error::EnableAWSOrganizationsAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAWSOrganizationsAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::EnableAWSOrganizationsAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidStateException" => crate::error::EnableAWSOrganizationsAccessError {
            meta: generic,
            kind: crate::error::EnableAWSOrganizationsAccessErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSOrganizationsAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::EnableAWSOrganizationsAccessError {
            meta: generic,
            kind:
                crate::error::EnableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSOrganizationsAccessError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::EnableAWSOrganizationsAccessError {
            meta: generic,
            kind: crate::error::EnableAWSOrganizationsAccessErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAWSOrganizationsAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableAWSOrganizationsAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_aws_organizations_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAwsOrganizationsAccessOutput,
    crate::error::EnableAWSOrganizationsAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_aws_organizations_access_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_provisioned_product_plan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteProvisionedProductPlanOutput,
    crate::error::ExecuteProvisionedProductPlanError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteProvisionedProductPlanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ExecuteProvisionedProductPlanError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ExecuteProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::ExecuteProvisionedProductPlanErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidStateException" => crate::error::ExecuteProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::ExecuteProvisionedProductPlanErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductPlanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ExecuteProvisionedProductPlanError {
            meta: generic,
            kind: crate::error::ExecuteProvisionedProductPlanErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductPlanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ExecuteProvisionedProductPlanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_provisioned_product_plan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteProvisionedProductPlanOutput,
    crate::error::ExecuteProvisionedProductPlanError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_provisioned_product_plan_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_execute_provisioned_product_plan(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ExecuteProvisionedProductPlanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_provisioned_product_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteProvisionedProductServiceActionOutput,
    crate::error::ExecuteProvisionedProductServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteProvisionedProductServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ExecuteProvisionedProductServiceActionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ExecuteProvisionedProductServiceActionError { meta: generic, kind: crate::error::ExecuteProvisionedProductServiceActionErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductServiceActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidStateException" => crate::error::ExecuteProvisionedProductServiceActionError { meta: generic, kind: crate::error::ExecuteProvisionedProductServiceActionErrorKind::InvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductServiceActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ExecuteProvisionedProductServiceActionError { meta: generic, kind: crate::error::ExecuteProvisionedProductServiceActionErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductServiceActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ExecuteProvisionedProductServiceActionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_provisioned_product_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteProvisionedProductServiceActionOutput,
    crate::error::ExecuteProvisionedProductServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::execute_provisioned_product_service_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_execute_provisioned_product_service_action(response.body().as_ref(), output).map_err(crate::error::ExecuteProvisionedProductServiceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_aws_organizations_access_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAwsOrganizationsAccessStatusOutput,
    crate::error::GetAWSOrganizationsAccessStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAWSOrganizationsAccessStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAWSOrganizationsAccessStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotSupportedException" => crate::error::GetAWSOrganizationsAccessStatusError { meta: generic, kind: crate::error::GetAWSOrganizationsAccessStatusErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAWSOrganizationsAccessStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::GetAWSOrganizationsAccessStatusError { meta: generic, kind: crate::error::GetAWSOrganizationsAccessStatusErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAWSOrganizationsAccessStatusError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetAWSOrganizationsAccessStatusError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_aws_organizations_access_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAwsOrganizationsAccessStatusOutput,
    crate::error::GetAWSOrganizationsAccessStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_aws_organizations_access_status_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_aws_organizations_access_status(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetAWSOrganizationsAccessStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_provisioned_product_outputs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetProvisionedProductOutputsOutput,
    crate::error::GetProvisionedProductOutputsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetProvisionedProductOutputsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetProvisionedProductOutputsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::GetProvisionedProductOutputsError {
            meta: generic,
            kind: crate::error::GetProvisionedProductOutputsErrorKind::InvalidParametersException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameters_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedProductOutputsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::GetProvisionedProductOutputsError {
            meta: generic,
            kind: crate::error::GetProvisionedProductOutputsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedProductOutputsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetProvisionedProductOutputsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_provisioned_product_outputs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetProvisionedProductOutputsOutput,
    crate::error::GetProvisionedProductOutputsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_provisioned_product_outputs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_provisioned_product_outputs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetProvisionedProductOutputsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_as_provisioned_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportAsProvisionedProductOutput,
    crate::error::ImportAsProvisionedProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ImportAsProvisionedProductError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::ImportAsProvisionedProductError {
            meta: generic,
            kind: crate::error::ImportAsProvisionedProductErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParametersException" => crate::error::ImportAsProvisionedProductError {
            meta: generic,
            kind: crate::error::ImportAsProvisionedProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStateException" => crate::error::ImportAsProvisionedProductError {
            meta: generic,
            kind: crate::error::ImportAsProvisionedProductErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ImportAsProvisionedProductError {
            meta: generic,
            kind: crate::error::ImportAsProvisionedProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportAsProvisionedProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_as_provisioned_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportAsProvisionedProductOutput,
    crate::error::ImportAsProvisionedProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_as_provisioned_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_as_provisioned_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportAsProvisionedProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accepted_portfolio_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAcceptedPortfolioSharesOutput,
    crate::error::ListAcceptedPortfolioSharesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAcceptedPortfolioSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAcceptedPortfolioSharesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListAcceptedPortfolioSharesError {
            meta: generic,
            kind: crate::error::ListAcceptedPortfolioSharesErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAcceptedPortfolioSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::ListAcceptedPortfolioSharesError {
            meta: generic,
            kind:
                crate::error::ListAcceptedPortfolioSharesErrorKind::OperationNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAcceptedPortfolioSharesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ListAcceptedPortfolioSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accepted_portfolio_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAcceptedPortfolioSharesOutput,
    crate::error::ListAcceptedPortfolioSharesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_accepted_portfolio_shares_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_accepted_portfolio_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAcceptedPortfolioSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_budgets_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBudgetsForResourceOutput,
    crate::error::ListBudgetsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBudgetsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListBudgetsForResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListBudgetsForResourceError {
            meta: generic,
            kind: crate::error::ListBudgetsForResourceErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBudgetsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListBudgetsForResourceError {
            meta: generic,
            kind: crate::error::ListBudgetsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBudgetsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBudgetsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_budgets_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBudgetsForResourceOutput,
    crate::error::ListBudgetsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_budgets_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_budgets_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBudgetsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_constraints_for_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConstraintsForPortfolioOutput,
    crate::error::ListConstraintsForPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListConstraintsForPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListConstraintsForPortfolioError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListConstraintsForPortfolioError {
            meta: generic,
            kind: crate::error::ListConstraintsForPortfolioErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConstraintsForPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListConstraintsForPortfolioError {
            meta: generic,
            kind: crate::error::ListConstraintsForPortfolioErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListConstraintsForPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListConstraintsForPortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_constraints_for_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConstraintsForPortfolioOutput,
    crate::error::ListConstraintsForPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_constraints_for_portfolio_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_constraints_for_portfolio(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListConstraintsForPortfolioError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_launch_paths_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLaunchPathsOutput, crate::error::ListLaunchPathsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLaunchPathsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLaunchPathsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListLaunchPathsError {
            meta: generic,
            kind: crate::error::ListLaunchPathsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLaunchPathsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListLaunchPathsError {
            meta: generic,
            kind: crate::error::ListLaunchPathsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLaunchPathsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLaunchPathsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_launch_paths_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLaunchPathsOutput, crate::error::ListLaunchPathsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_launch_paths_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_launch_paths(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLaunchPathsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_organization_portfolio_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOrganizationPortfolioAccessOutput,
    crate::error::ListOrganizationPortfolioAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOrganizationPortfolioAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListOrganizationPortfolioAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListOrganizationPortfolioAccessError { meta: generic, kind: crate::error::ListOrganizationPortfolioAccessErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationPortfolioAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotSupportedException" => crate::error::ListOrganizationPortfolioAccessError { meta: generic, kind: crate::error::ListOrganizationPortfolioAccessErrorKind::OperationNotSupportedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationPortfolioAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListOrganizationPortfolioAccessError { meta: generic, kind: crate::error::ListOrganizationPortfolioAccessErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListOrganizationPortfolioAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListOrganizationPortfolioAccessError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_organization_portfolio_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOrganizationPortfolioAccessOutput,
    crate::error::ListOrganizationPortfolioAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_organization_portfolio_access_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_organization_portfolio_access(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListOrganizationPortfolioAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolio_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPortfolioAccessOutput,
    crate::error::ListPortfolioAccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPortfolioAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPortfolioAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListPortfolioAccessError {
            meta: generic,
            kind: crate::error::ListPortfolioAccessErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortfolioAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListPortfolioAccessError {
            meta: generic,
            kind: crate::error::ListPortfolioAccessErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortfolioAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPortfolioAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolio_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPortfolioAccessOutput,
    crate::error::ListPortfolioAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_portfolio_access_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_portfolio_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPortfolioAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolios_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPortfoliosOutput, crate::error::ListPortfoliosError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPortfoliosError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPortfoliosError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListPortfoliosError {
            meta: generic,
            kind: crate::error::ListPortfoliosErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortfoliosError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPortfoliosError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolios_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPortfoliosOutput, crate::error::ListPortfoliosError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_portfolios_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_portfolios(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPortfoliosError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolios_for_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPortfoliosForProductOutput,
    crate::error::ListPortfoliosForProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPortfoliosForProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPortfoliosForProductError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListPortfoliosForProductError {
            meta: generic,
            kind: crate::error::ListPortfoliosForProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortfoliosForProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListPortfoliosForProductError {
            meta: generic,
            kind: crate::error::ListPortfoliosForProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPortfoliosForProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPortfoliosForProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_portfolios_for_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPortfoliosForProductOutput,
    crate::error::ListPortfoliosForProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_portfolios_for_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_portfolios_for_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPortfoliosForProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_principals_for_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPrincipalsForPortfolioOutput,
    crate::error::ListPrincipalsForPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPrincipalsForPortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPrincipalsForPortfolioError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListPrincipalsForPortfolioError {
            meta: generic,
            kind: crate::error::ListPrincipalsForPortfolioErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPrincipalsForPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListPrincipalsForPortfolioError {
            meta: generic,
            kind: crate::error::ListPrincipalsForPortfolioErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPrincipalsForPortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPrincipalsForPortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_principals_for_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPrincipalsForPortfolioOutput,
    crate::error::ListPrincipalsForPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_principals_for_portfolio_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_principals_for_portfolio(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPrincipalsForPortfolioError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_product_plans_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedProductPlansOutput,
    crate::error::ListProvisionedProductPlansError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProvisionedProductPlansError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListProvisionedProductPlansError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListProvisionedProductPlansError {
            meta: generic,
            kind: crate::error::ListProvisionedProductPlansErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedProductPlansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListProvisionedProductPlansError {
            meta: generic,
            kind: crate::error::ListProvisionedProductPlansErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedProductPlansError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListProvisionedProductPlansError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_product_plans_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedProductPlansOutput,
    crate::error::ListProvisionedProductPlansError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_provisioned_product_plans_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_provisioned_product_plans(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProvisionedProductPlansError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioning_artifacts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisioningArtifactsOutput,
    crate::error::ListProvisioningArtifactsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProvisioningArtifactsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListProvisioningArtifactsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListProvisioningArtifactsError {
            meta: generic,
            kind: crate::error::ListProvisioningArtifactsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisioningArtifactsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListProvisioningArtifactsError {
            meta: generic,
            kind: crate::error::ListProvisioningArtifactsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisioningArtifactsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListProvisioningArtifactsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioning_artifacts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisioningArtifactsOutput,
    crate::error::ListProvisioningArtifactsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_provisioning_artifacts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_provisioning_artifacts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProvisioningArtifactsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioning_artifacts_for_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisioningArtifactsForServiceActionOutput,
    crate::error::ListProvisioningArtifactsForServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProvisioningArtifactsForServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListProvisioningArtifactsForServiceActionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListProvisioningArtifactsForServiceActionError { meta: generic, kind: crate::error::ListProvisioningArtifactsForServiceActionErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisioningArtifactsForServiceActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListProvisioningArtifactsForServiceActionError { meta: generic, kind: crate::error::ListProvisioningArtifactsForServiceActionErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisioningArtifactsForServiceActionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListProvisioningArtifactsForServiceActionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioning_artifacts_for_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisioningArtifactsForServiceActionOutput,
    crate::error::ListProvisioningArtifactsForServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_provisioning_artifacts_for_service_action_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_provisioning_artifacts_for_service_action(response.body().as_ref(), output).map_err(crate::error::ListProvisioningArtifactsForServiceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_record_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRecordHistoryOutput, crate::error::ListRecordHistoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRecordHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRecordHistoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListRecordHistoryError {
            meta: generic,
            kind: crate::error::ListRecordHistoryErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRecordHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRecordHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_record_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRecordHistoryOutput, crate::error::ListRecordHistoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_record_history_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_record_history(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRecordHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_tag_option_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForTagOptionOutput,
    crate::error::ListResourcesForTagOptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourcesForTagOptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListResourcesForTagOptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListResourcesForTagOptionError {
            meta: generic,
            kind: crate::error::ListResourcesForTagOptionErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListResourcesForTagOptionError {
            meta: generic,
            kind: crate::error::ListResourcesForTagOptionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::ListResourcesForTagOptionError {
            meta: generic,
            kind: crate::error::ListResourcesForTagOptionErrorKind::TagOptionNotMigratedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::tag_option_not_migrated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForTagOptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListResourcesForTagOptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_tag_option_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForTagOptionOutput,
    crate::error::ListResourcesForTagOptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resources_for_tag_option_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resources_for_tag_option(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourcesForTagOptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceActionsOutput,
    crate::error::ListServiceActionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServiceActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListServiceActionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListServiceActionsError {
            meta: generic,
            kind: crate::error::ListServiceActionsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServiceActionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListServiceActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceActionsOutput,
    crate::error::ListServiceActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_service_actions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_service_actions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServiceActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_actions_for_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceActionsForProvisioningArtifactOutput,
    crate::error::ListServiceActionsForProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServiceActionsForProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListServiceActionsForProvisioningArtifactError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListServiceActionsForProvisioningArtifactError { meta: generic, kind: crate::error::ListServiceActionsForProvisioningArtifactErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServiceActionsForProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListServiceActionsForProvisioningArtifactError { meta: generic, kind: crate::error::ListServiceActionsForProvisioningArtifactErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServiceActionsForProvisioningArtifactError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListServiceActionsForProvisioningArtifactError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_actions_for_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceActionsForProvisioningArtifactOutput,
    crate::error::ListServiceActionsForProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_service_actions_for_provisioning_artifact_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_service_actions_for_provisioning_artifact(response.body().as_ref(), output).map_err(crate::error::ListServiceActionsForProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_instances_for_provisioned_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackInstancesForProvisionedProductOutput,
    crate::error::ListStackInstancesForProvisionedProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStackInstancesForProvisionedProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListStackInstancesForProvisionedProductError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListStackInstancesForProvisionedProductError { meta: generic, kind: crate::error::ListStackInstancesForProvisionedProductErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListStackInstancesForProvisionedProductError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListStackInstancesForProvisionedProductError { meta: generic, kind: crate::error::ListStackInstancesForProvisionedProductErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListStackInstancesForProvisionedProductError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListStackInstancesForProvisionedProductError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_stack_instances_for_provisioned_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStackInstancesForProvisionedProductOutput,
    crate::error::ListStackInstancesForProvisionedProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_stack_instances_for_provisioned_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_stack_instances_for_provisioned_product(response.body().as_ref(), output).map_err(crate::error::ListStackInstancesForProvisionedProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tag_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagOptionsOutput, crate::error::ListTagOptionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagOptionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ListTagOptionsError {
            meta: generic,
            kind: crate::error::ListTagOptionsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::ListTagOptionsError {
            meta: generic,
            kind: crate::error::ListTagOptionsErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tag_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagOptionsOutput, crate::error::ListTagOptionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tag_options_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tag_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provision_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ProvisionProductOutput, crate::error::ProvisionProductError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ProvisionProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ProvisionProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::ProvisionProductError {
            meta: generic,
            kind: crate::error::ProvisionProductErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParametersException" => crate::error::ProvisionProductError {
            meta: generic,
            kind: crate::error::ProvisionProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ProvisionProductError {
            meta: generic,
            kind: crate::error::ProvisionProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ProvisionProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provision_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ProvisionProductOutput, crate::error::ProvisionProductError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::provision_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_provision_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ProvisionProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_portfolio_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectPortfolioShareOutput,
    crate::error::RejectPortfolioShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectPortfolioShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RejectPortfolioShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::RejectPortfolioShareError {
            meta: generic,
            kind: crate::error::RejectPortfolioShareErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RejectPortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectPortfolioShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_portfolio_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RejectPortfolioShareOutput,
    crate::error::RejectPortfolioShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_portfolio_share_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_scan_provisioned_products_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ScanProvisionedProductsOutput,
    crate::error::ScanProvisionedProductsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ScanProvisionedProductsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ScanProvisionedProductsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::ScanProvisionedProductsError {
            meta: generic,
            kind: crate::error::ScanProvisionedProductsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScanProvisionedProductsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ScanProvisionedProductsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_scan_provisioned_products_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ScanProvisionedProductsOutput,
    crate::error::ScanProvisionedProductsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::scan_provisioned_products_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_scan_provisioned_products(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ScanProvisionedProductsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_products_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchProductsOutput, crate::error::SearchProductsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchProductsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SearchProductsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::SearchProductsError {
            meta: generic,
            kind: crate::error::SearchProductsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SearchProductsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SearchProductsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_products_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchProductsOutput, crate::error::SearchProductsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_products_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_products(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchProductsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_products_as_admin_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchProductsAsAdminOutput,
    crate::error::SearchProductsAsAdminError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchProductsAsAdminError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SearchProductsAsAdminError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::SearchProductsAsAdminError {
            meta: generic,
            kind: crate::error::SearchProductsAsAdminErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SearchProductsAsAdminError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SearchProductsAsAdminError {
            meta: generic,
            kind: crate::error::SearchProductsAsAdminErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SearchProductsAsAdminError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SearchProductsAsAdminError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_products_as_admin_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchProductsAsAdminOutput,
    crate::error::SearchProductsAsAdminError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_products_as_admin_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_products_as_admin(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchProductsAsAdminError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_provisioned_products_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchProvisionedProductsOutput,
    crate::error::SearchProvisionedProductsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchProvisionedProductsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SearchProvisionedProductsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::SearchProvisionedProductsError {
            meta: generic,
            kind: crate::error::SearchProvisionedProductsErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SearchProvisionedProductsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SearchProvisionedProductsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_provisioned_products_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SearchProvisionedProductsOutput,
    crate::error::SearchProvisionedProductsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_provisioned_products_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search_provisioned_products(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchProvisionedProductsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_provisioned_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateProvisionedProductOutput,
    crate::error::TerminateProvisionedProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateProvisionedProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::TerminateProvisionedProductError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundException" => crate::error::TerminateProvisionedProductError {
            meta: generic,
            kind: crate::error::TerminateProvisionedProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TerminateProvisionedProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_provisioned_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TerminateProvisionedProductOutput,
    crate::error::TerminateProvisionedProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::terminate_provisioned_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_terminate_provisioned_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TerminateProvisionedProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_constraint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateConstraintOutput, crate::error::UpdateConstraintError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConstraintError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateConstraintError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateConstraintError {
            meta: generic,
            kind: crate::error::UpdateConstraintErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateConstraintError {
            meta: generic,
            kind: crate::error::UpdateConstraintErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateConstraintError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateConstraintError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_constraint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateConstraintOutput, crate::error::UpdateConstraintError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_constraint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_constraint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateConstraintError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePortfolioOutput, crate::error::UpdatePortfolioError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePortfolioError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePortfolioError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdatePortfolioError {
            meta: generic,
            kind: crate::error::UpdatePortfolioErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdatePortfolioError {
            meta: generic,
            kind: crate::error::UpdatePortfolioErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePortfolioError {
            meta: generic,
            kind: crate::error::UpdatePortfolioErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::UpdatePortfolioError {
            meta: generic,
            kind: crate::error::UpdatePortfolioErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePortfolioError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePortfolioOutput, crate::error::UpdatePortfolioError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_portfolio_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_portfolio(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePortfolioError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portfolio_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePortfolioShareOutput,
    crate::error::UpdatePortfolioShareError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePortfolioShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdatePortfolioShareError {
            meta: generic,
            kind: crate::error::UpdatePortfolioShareErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidStateException" => crate::error::UpdatePortfolioShareError {
            meta: generic,
            kind: crate::error::UpdatePortfolioShareErrorKind::InvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotSupportedException" => crate::error::UpdatePortfolioShareError {
            meta: generic,
            kind: crate::error::UpdatePortfolioShareErrorKind::OperationNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdatePortfolioShareError {
            meta: generic,
            kind: crate::error::UpdatePortfolioShareErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePortfolioShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_portfolio_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePortfolioShareOutput,
    crate::error::UpdatePortfolioShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_portfolio_share_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_portfolio_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePortfolioShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProductOutput, crate::error::UpdateProductError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateProductError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateProductError {
            meta: generic,
            kind: crate::error::UpdateProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateProductError {
            meta: generic,
            kind: crate::error::UpdateProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::UpdateProductError {
            meta: generic,
            kind: crate::error::UpdateProductErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProductOutput, crate::error::UpdateProductError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioned_product_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisionedProductOutput,
    crate::error::UpdateProvisionedProductError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProvisionedProductError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateProvisionedProductError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateProvisionedProductError {
            meta: generic,
            kind: crate::error::UpdateProvisionedProductErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateProvisionedProductError {
            meta: generic,
            kind: crate::error::UpdateProvisionedProductErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateProvisionedProductError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioned_product_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisionedProductOutput,
    crate::error::UpdateProvisionedProductError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_provisioned_product_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_provisioned_product(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateProvisionedProductError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioned_product_properties_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisionedProductPropertiesOutput,
    crate::error::UpdateProvisionedProductPropertiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProvisionedProductPropertiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateProvisionedProductPropertiesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateProvisionedProductPropertiesError { meta: generic, kind: crate::error::UpdateProvisionedProductPropertiesErrorKind::InvalidParametersException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidStateException" => crate::error::UpdateProvisionedProductPropertiesError { meta: generic, kind: crate::error::UpdateProvisionedProductPropertiesErrorKind::InvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateProvisionedProductPropertiesError { meta: generic, kind: crate::error::UpdateProvisionedProductPropertiesErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductPropertiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateProvisionedProductPropertiesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioned_product_properties_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisionedProductPropertiesOutput,
    crate::error::UpdateProvisionedProductPropertiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_provisioned_product_properties_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_provisioned_product_properties(response.body().as_ref(), output).map_err(crate::error::UpdateProvisionedProductPropertiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioning_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisioningArtifactOutput,
    crate::error::UpdateProvisioningArtifactError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProvisioningArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateProvisioningArtifactError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateProvisioningArtifactError {
            meta: generic,
            kind: crate::error::UpdateProvisioningArtifactErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateProvisioningArtifactError {
            meta: generic,
            kind: crate::error::UpdateProvisioningArtifactErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateProvisioningArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateProvisioningArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_provisioning_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateProvisioningArtifactOutput,
    crate::error::UpdateProvisioningArtifactError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_provisioning_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_provisioning_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateProvisioningArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceActionOutput,
    crate::error::UpdateServiceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServiceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateServiceActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParametersException" => crate::error::UpdateServiceActionError {
            meta: generic,
            kind: crate::error::UpdateServiceActionErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateServiceActionError {
            meta: generic,
            kind: crate::error::UpdateServiceActionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateServiceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceActionOutput,
    crate::error::UpdateServiceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_service_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_service_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateServiceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_tag_option_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTagOptionOutput, crate::error::UpdateTagOptionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTagOptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTagOptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateResourceException" => crate::error::UpdateTagOptionError {
            meta: generic,
            kind: crate::error::UpdateTagOptionErrorKind::DuplicateResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParametersException" => crate::error::UpdateTagOptionError {
            meta: generic,
            kind: crate::error::UpdateTagOptionErrorKind::InvalidParametersException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameters_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameters_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTagOptionError {
            meta: generic,
            kind: crate::error::UpdateTagOptionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagOptionNotMigratedException" => crate::error::UpdateTagOptionError {
            meta: generic,
            kind: crate::error::UpdateTagOptionErrorKind::TagOptionNotMigratedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tag_option_not_migrated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_option_not_migrated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTagOptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTagOptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_tag_option_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTagOptionOutput, crate::error::UpdateTagOptionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_tag_option_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_tag_option(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTagOptionError::unhandled)?;
        output.build()
    })
}
