// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptPortfolioShareInput`](crate::input::AcceptPortfolioShareInput)
pub mod accept_portfolio_share_input {
    /// A builder for [`AcceptPortfolioShareInput`](crate::input::AcceptPortfolioShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) portfolio_share_type: std::option::Option<crate::model::PortfolioShareType>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Accept imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.portfolio_share_type = Some(input);
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Accept imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.portfolio_share_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptPortfolioShareInput`](crate::input::AcceptPortfolioShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptPortfolioShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptPortfolioShareInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                portfolio_share_type: self.portfolio_share_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptPortfolioShareInputOperationOutputAlias = crate::operation::AcceptPortfolioShare;
#[doc(hidden)]
pub type AcceptPortfolioShareInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptPortfolioShareInput {
    /// Consumes the builder and constructs an Operation<[`AcceptPortfolioShare`](crate::operation::AcceptPortfolioShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptPortfolioShare,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptPortfolioShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptPortfolioShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptPortfolioShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AcceptPortfolioShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_portfolio_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptPortfolioShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptPortfolioShare",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptPortfolioShareInput`](crate::input::AcceptPortfolioShareInput)
    pub fn builder() -> crate::input::accept_portfolio_share_input::Builder {
        crate::input::accept_portfolio_share_input::Builder::default()
    }
}

/// See [`AssociateBudgetWithResourceInput`](crate::input::AssociateBudgetWithResourceInput)
pub mod associate_budget_with_resource_input {
    /// A builder for [`AssociateBudgetWithResourceInput`](crate::input::AssociateBudgetWithResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the budget you want to associate.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget you want to associate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateBudgetWithResourceInput`](crate::input::AssociateBudgetWithResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateBudgetWithResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateBudgetWithResourceInput {
                budget_name: self.budget_name,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateBudgetWithResourceInputOperationOutputAlias =
    crate::operation::AssociateBudgetWithResource;
#[doc(hidden)]
pub type AssociateBudgetWithResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateBudgetWithResourceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateBudgetWithResource`](crate::operation::AssociateBudgetWithResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateBudgetWithResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateBudgetWithResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateBudgetWithResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateBudgetWithResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AssociateBudgetWithResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_budget_with_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateBudgetWithResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateBudgetWithResource",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateBudgetWithResourceInput`](crate::input::AssociateBudgetWithResourceInput)
    pub fn builder() -> crate::input::associate_budget_with_resource_input::Builder {
        crate::input::associate_budget_with_resource_input::Builder::default()
    }
}

/// See [`AssociatePrincipalWithPortfolioInput`](crate::input::AssociatePrincipalWithPortfolioInput)
pub mod associate_principal_with_portfolio_input {
    /// A builder for [`AssociatePrincipalWithPortfolioInput`](crate::input::AssociatePrincipalWithPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePrincipalWithPortfolioInput`](crate::input::AssociatePrincipalWithPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePrincipalWithPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePrincipalWithPortfolioInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                principal_arn: self.principal_arn,
                principal_type: self.principal_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePrincipalWithPortfolioInputOperationOutputAlias =
    crate::operation::AssociatePrincipalWithPortfolio;
#[doc(hidden)]
pub type AssociatePrincipalWithPortfolioInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePrincipalWithPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePrincipalWithPortfolio`](crate::operation::AssociatePrincipalWithPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePrincipalWithPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociatePrincipalWithPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociatePrincipalWithPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociatePrincipalWithPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AssociatePrincipalWithPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_principal_with_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePrincipalWithPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePrincipalWithPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociatePrincipalWithPortfolioInput`](crate::input::AssociatePrincipalWithPortfolioInput)
    pub fn builder() -> crate::input::associate_principal_with_portfolio_input::Builder {
        crate::input::associate_principal_with_portfolio_input::Builder::default()
    }
}

/// See [`AssociateProductWithPortfolioInput`](crate::input::AssociateProductWithPortfolioInput)
pub mod associate_product_with_portfolio_input {
    /// A builder for [`AssociateProductWithPortfolioInput`](crate::input::AssociateProductWithPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) source_portfolio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn source_portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_portfolio_id = Some(input.into());
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_portfolio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateProductWithPortfolioInput`](crate::input::AssociateProductWithPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateProductWithPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateProductWithPortfolioInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                portfolio_id: self.portfolio_id,
                source_portfolio_id: self.source_portfolio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateProductWithPortfolioInputOperationOutputAlias =
    crate::operation::AssociateProductWithPortfolio;
#[doc(hidden)]
pub type AssociateProductWithPortfolioInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateProductWithPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`AssociateProductWithPortfolio`](crate::operation::AssociateProductWithPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateProductWithPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateProductWithPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateProductWithPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateProductWithPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AssociateProductWithPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_product_with_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateProductWithPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateProductWithPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateProductWithPortfolioInput`](crate::input::AssociateProductWithPortfolioInput)
    pub fn builder() -> crate::input::associate_product_with_portfolio_input::Builder {
        crate::input::associate_product_with_portfolio_input::Builder::default()
    }
}

/// See [`AssociateServiceActionWithProvisioningArtifactInput`](crate::input::AssociateServiceActionWithProvisioningArtifactInput)
pub mod associate_service_action_with_provisioning_artifact_input {
    /// A builder for [`AssociateServiceActionWithProvisioningArtifactInput`](crate::input::AssociateServiceActionWithProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateServiceActionWithProvisioningArtifactInput`](crate::input::AssociateServiceActionWithProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateServiceActionWithProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AssociateServiceActionWithProvisioningArtifactInput {
                    product_id: self.product_id,
                    provisioning_artifact_id: self.provisioning_artifact_id,
                    service_action_id: self.service_action_id,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AssociateServiceActionWithProvisioningArtifactInputOperationOutputAlias =
    crate::operation::AssociateServiceActionWithProvisioningArtifact;
#[doc(hidden)]
pub type AssociateServiceActionWithProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateServiceActionWithProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`AssociateServiceActionWithProvisioningArtifact`](crate::operation::AssociateServiceActionWithProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateServiceActionWithProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateServiceActionWithProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateServiceActionWithProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateServiceActionWithProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AssociateServiceActionWithProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_service_action_with_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateServiceActionWithProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateServiceActionWithProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateServiceActionWithProvisioningArtifactInput`](crate::input::AssociateServiceActionWithProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::associate_service_action_with_provisioning_artifact_input::Builder {
        crate::input::associate_service_action_with_provisioning_artifact_input::Builder::default()
    }
}

/// See [`AssociateTagOptionWithResourceInput`](crate::input::AssociateTagOptionWithResourceInput)
pub mod associate_tag_option_with_resource_input {
    /// A builder for [`AssociateTagOptionWithResourceInput`](crate::input::AssociateTagOptionWithResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_option_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_option_id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_option_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTagOptionWithResourceInput`](crate::input::AssociateTagOptionWithResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTagOptionWithResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTagOptionWithResourceInput {
                resource_id: self.resource_id,
                tag_option_id: self.tag_option_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTagOptionWithResourceInputOperationOutputAlias =
    crate::operation::AssociateTagOptionWithResource;
#[doc(hidden)]
pub type AssociateTagOptionWithResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTagOptionWithResourceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTagOptionWithResource`](crate::operation::AssociateTagOptionWithResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTagOptionWithResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateTagOptionWithResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateTagOptionWithResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateTagOptionWithResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.AssociateTagOptionWithResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_tag_option_with_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTagOptionWithResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTagOptionWithResource",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateTagOptionWithResourceInput`](crate::input::AssociateTagOptionWithResourceInput)
    pub fn builder() -> crate::input::associate_tag_option_with_resource_input::Builder {
        crate::input::associate_tag_option_with_resource_input::Builder::default()
    }
}

/// See [`BatchAssociateServiceActionWithProvisioningArtifactInput`](crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput)
pub mod batch_associate_service_action_with_provisioning_artifact_input {
    /// A builder for [`BatchAssociateServiceActionWithProvisioningArtifactInput`](crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_associations:
            std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_action_associations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            input: crate::model::ServiceActionAssociation,
        ) -> Self {
            let mut v = self.service_action_associations.unwrap_or_default();
            v.push(input);
            self.service_action_associations = Some(v);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.service_action_associations = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateServiceActionWithProvisioningArtifactInput`](crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput {
                    service_action_associations: self.service_action_associations,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateServiceActionWithProvisioningArtifactInputOperationOutputAlias =
    crate::operation::BatchAssociateServiceActionWithProvisioningArtifact;
#[doc(hidden)]
pub type BatchAssociateServiceActionWithProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchAssociateServiceActionWithProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateServiceActionWithProvisioningArtifact`](crate::operation::BatchAssociateServiceActionWithProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateServiceActionWithProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.BatchAssociateServiceActionWithProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_service_action_with_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateServiceActionWithProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateServiceActionWithProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateServiceActionWithProvisioningArtifactInput`](crate::input::BatchAssociateServiceActionWithProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder
    {
        crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder::default()
    }
}

/// See [`BatchDisassociateServiceActionFromProvisioningArtifactInput`](crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput)
pub mod batch_disassociate_service_action_from_provisioning_artifact_input {
    /// A builder for [`BatchDisassociateServiceActionFromProvisioningArtifactInput`](crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_associations:
            std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_action_associations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            input: crate::model::ServiceActionAssociation,
        ) -> Self {
            let mut v = self.service_action_associations.unwrap_or_default();
            v.push(input);
            self.service_action_associations = Some(v);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.service_action_associations = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateServiceActionFromProvisioningArtifactInput`](crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput {
                    service_action_associations: self.service_action_associations,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateServiceActionFromProvisioningArtifactInputOperationOutputAlias =
    crate::operation::BatchDisassociateServiceActionFromProvisioningArtifact;
#[doc(hidden)]
pub type BatchDisassociateServiceActionFromProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchDisassociateServiceActionFromProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateServiceActionFromProvisioningArtifact`](crate::operation::BatchDisassociateServiceActionFromProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateServiceActionFromProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                                    builder,
                                    http::header::HeaderName::from_static("x-amz-target"),
                                    "AWS242ServiceCatalogService.BatchDisassociateServiceActionFromProvisioningArtifact"
                                );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_service_action_from_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateServiceActionFromProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateServiceActionFromProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateServiceActionFromProvisioningArtifactInput`](crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder
    {
        crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder::default()
    }
}

/// See [`CopyProductInput`](crate::input::CopyProductInput)
pub mod copy_product_input {
    /// A builder for [`CopyProductInput`](crate::input::CopyProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) source_product_arn: std::option::Option<std::string::String>,
        pub(crate) target_product_id: std::option::Option<std::string::String>,
        pub(crate) target_product_name: std::option::Option<std::string::String>,
        pub(crate) source_provisioning_artifact_identifiers: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<
                    crate::model::ProvisioningArtifactPropertyName,
                    std::string::String,
                >,
            >,
        >,
        pub(crate) copy_options: std::option::Option<std::vec::Vec<crate::model::CopyOption>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn source_product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_product_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn set_source_product_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_product_arn = input;
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn target_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn set_target_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_product_id = input;
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn target_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_product_name = Some(input.into());
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn set_target_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_product_name = input;
            self
        }
        /// Appends an item to `source_provisioning_artifact_identifiers`.
        ///
        /// To override the contents of this collection use [`set_source_provisioning_artifact_identifiers`](Self::set_source_provisioning_artifact_identifiers).
        ///
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.</p>
        pub fn source_provisioning_artifact_identifiers(
            mut self,
            input: std::collections::HashMap<
                crate::model::ProvisioningArtifactPropertyName,
                std::string::String,
            >,
        ) -> Self {
            let mut v = self
                .source_provisioning_artifact_identifiers
                .unwrap_or_default();
            v.push(input);
            self.source_provisioning_artifact_identifiers = Some(v);
            self
        }
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.</p>
        pub fn set_source_provisioning_artifact_identifiers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        crate::model::ProvisioningArtifactPropertyName,
                        std::string::String,
                    >,
                >,
            >,
        ) -> Self {
            self.source_provisioning_artifact_identifiers = input;
            self
        }
        /// Appends an item to `copy_options`.
        ///
        /// To override the contents of this collection use [`set_copy_options`](Self::set_copy_options).
        ///
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the target product.</p>
        pub fn copy_options(mut self, input: crate::model::CopyOption) -> Self {
            let mut v = self.copy_options.unwrap_or_default();
            v.push(input);
            self.copy_options = Some(v);
            self
        }
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source product are copied to the target product.</p>
        pub fn set_copy_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyOption>>,
        ) -> Self {
            self.copy_options = input;
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. </p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. </p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyProductInput`](crate::input::CopyProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyProductInput {
                accept_language: self.accept_language,
                source_product_arn: self.source_product_arn,
                target_product_id: self.target_product_id,
                target_product_name: self.target_product_name,
                source_provisioning_artifact_identifiers: self
                    .source_provisioning_artifact_identifiers,
                copy_options: self.copy_options,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyProductInputOperationOutputAlias = crate::operation::CopyProduct;
#[doc(hidden)]
pub type CopyProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyProductInput {
    /// Consumes the builder and constructs an Operation<[`CopyProduct`](crate::operation::CopyProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CopyProduct",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_copy_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyProductInput`](crate::input::CopyProductInput)
    pub fn builder() -> crate::input::copy_product_input::Builder {
        crate::input::copy_product_input::Builder::default()
    }
}

/// See [`CreateConstraintInput`](crate::input::CreateConstraintInput)
pub mod create_constraint_input {
    /// A builder for [`CreateConstraintInput`](crate::input::CreateConstraintInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li> <p> <code>LAUNCH</code> </p> </li>
        /// <li> <p> <code>NOTIFICATION</code> </p> </li>
        /// <li> <p> <code>RESOURCE_UPDATE</code> </p> </li>
        /// <li> <p> <code>STACKSET</code> </p> </li>
        /// <li> <p> <code>TEMPLATE</code> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li> <p> <code>LAUNCH</code> </p> </li>
        /// <li> <p> <code>NOTIFICATION</code> </p> </li>
        /// <li> <p> <code>RESOURCE_UPDATE</code> </p> </li>
        /// <li> <p> <code>STACKSET</code> </p> </li>
        /// <li> <p> <code>TEMPLATE</code> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConstraintInput`](crate::input::CreateConstraintInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConstraintInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConstraintInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                product_id: self.product_id,
                parameters: self.parameters,
                r#type: self.r#type,
                description: self.description,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConstraintInputOperationOutputAlias = crate::operation::CreateConstraint;
#[doc(hidden)]
pub type CreateConstraintInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConstraintInput {
    /// Consumes the builder and constructs an Operation<[`CreateConstraint`](crate::operation::CreateConstraint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConstraint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConstraintInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConstraintInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConstraintInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateConstraint",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_constraint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConstraint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConstraint",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConstraintInput`](crate::input::CreateConstraintInput)
    pub fn builder() -> crate::input::create_constraint_input::Builder {
        crate::input::create_constraint_input::Builder::default()
    }
}

/// See [`CreatePortfolioInput`](crate::input::CreatePortfolioInput)
pub mod create_portfolio_input {
    /// A builder for [`CreatePortfolioInput`](crate::input::CreatePortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortfolioInput`](crate::input::CreatePortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePortfolioInput {
                accept_language: self.accept_language,
                display_name: self.display_name,
                description: self.description,
                provider_name: self.provider_name,
                tags: self.tags,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePortfolioInputOperationOutputAlias = crate::operation::CreatePortfolio;
#[doc(hidden)]
pub type CreatePortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePortfolioInput {
    /// Consumes the builder and constructs an Operation<[`CreatePortfolio`](crate::operation::CreatePortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreatePortfolio",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_portfolio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePortfolioInput`](crate::input::CreatePortfolioInput)
    pub fn builder() -> crate::input::create_portfolio_input::Builder {
        crate::input::create_portfolio_input::Builder::default()
    }
}

/// See [`CreatePortfolioShareInput`](crate::input::CreatePortfolioShareInput)
pub mod create_portfolio_share_input {
    /// A builder for [`CreatePortfolioShareInput`](crate::input::CreatePortfolioShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) organization_node: std::option::Option<crate::model::OrganizationNode>,
        pub(crate) share_tag_options: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code> is passed in, <code>PortfolioShare</code> will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a <code>PortfolioShareToken</code> will be returned in the output in order for the administrator to monitor the status of the <code>PortfolioShare</code> creation process.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.organization_node = Some(input);
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code> is passed in, <code>PortfolioShare</code> will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a <code>PortfolioShareToken</code> will be returned in the output in order for the administrator to monitor the status of the <code>PortfolioShare</code> creation process.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.organization_node = input;
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn share_tag_options(mut self, input: bool) -> Self {
            self.share_tag_options = Some(input);
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.share_tag_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortfolioShareInput`](crate::input::CreatePortfolioShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePortfolioShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePortfolioShareInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                account_id: self.account_id,
                organization_node: self.organization_node,
                share_tag_options: self.share_tag_options.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePortfolioShareInputOperationOutputAlias = crate::operation::CreatePortfolioShare;
#[doc(hidden)]
pub type CreatePortfolioShareInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePortfolioShareInput {
    /// Consumes the builder and constructs an Operation<[`CreatePortfolioShare`](crate::operation::CreatePortfolioShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePortfolioShare,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePortfolioShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePortfolioShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePortfolioShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreatePortfolioShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_portfolio_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePortfolioShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePortfolioShare",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePortfolioShareInput`](crate::input::CreatePortfolioShareInput)
    pub fn builder() -> crate::input::create_portfolio_share_input::Builder {
        crate::input::create_portfolio_share_input::Builder::default()
    }
}

/// See [`CreateProductInput`](crate::input::CreateProductInput)
pub mod create_product_input {
    /// A builder for [`CreateProductInput`](crate::input::CreateProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) distributor: std::option::Option<std::string::String>,
        pub(crate) support_description: std::option::Option<std::string::String>,
        pub(crate) support_email: std::option::Option<std::string::String>,
        pub(crate) support_url: std::option::Option<std::string::String>,
        pub(crate) product_type: std::option::Option<crate::model::ProductType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) provisioning_artifact_parameters:
            std::option::Option<crate::model::ProvisioningArtifactProperties>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The name of the product.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the product.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The description of the product.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn distributor(mut self, input: impl Into<std::string::String>) -> Self {
            self.distributor = Some(input.into());
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.distributor = input;
            self
        }
        /// <p>The support information about the product.</p>
        pub fn support_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_description = Some(input.into());
            self
        }
        /// <p>The support information about the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_description = input;
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn support_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_email = Some(input.into());
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_email = input;
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p> <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn support_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_url = Some(input.into());
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p> <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_url = input;
            self
        }
        /// <p>The type of product.</p>
        pub fn product_type(mut self, input: crate::model::ProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The type of product.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::ProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn provisioning_artifact_parameters(
            mut self,
            input: crate::model::ProvisioningArtifactProperties,
        ) -> Self {
            self.provisioning_artifact_parameters = Some(input);
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn set_provisioning_artifact_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.provisioning_artifact_parameters = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProductInput`](crate::input::CreateProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProductInput {
                accept_language: self.accept_language,
                name: self.name,
                owner: self.owner,
                description: self.description,
                distributor: self.distributor,
                support_description: self.support_description,
                support_email: self.support_email,
                support_url: self.support_url,
                product_type: self.product_type,
                tags: self.tags,
                provisioning_artifact_parameters: self.provisioning_artifact_parameters,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProductInputOperationOutputAlias = crate::operation::CreateProduct;
#[doc(hidden)]
pub type CreateProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProductInput {
    /// Consumes the builder and constructs an Operation<[`CreateProduct`](crate::operation::CreateProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateProduct",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProductInput`](crate::input::CreateProductInput)
    pub fn builder() -> crate::input::create_product_input::Builder {
        crate::input::create_product_input::Builder::default()
    }
}

/// See [`CreateProvisionedProductPlanInput`](crate::input::CreateProvisionedProductPlanInput)
pub mod create_provisioned_product_plan_input {
    /// A builder for [`CreateProvisionedProductPlanInput`](crate::input::CreateProvisionedProductPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) plan_name: std::option::Option<std::string::String>,
        pub(crate) plan_type: std::option::Option<crate::model::ProvisionedProductPlanType>,
        pub(crate) notification_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_name = Some(input.into());
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_name = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::ProvisionedProductPlanType) -> Self {
            self.plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanType>,
        ) -> Self {
            self.plan_type = input;
            self
        }
        /// Appends an item to `notification_arns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_arns.unwrap_or_default();
            v.push(input.into());
            self.notification_arns = Some(v);
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_arns = input;
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::UpdateProvisioningParameter,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input);
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisionedProductPlanInput`](crate::input::CreateProvisionedProductPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProvisionedProductPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProvisionedProductPlanInput {
                accept_language: self.accept_language,
                plan_name: self.plan_name,
                plan_type: self.plan_type,
                notification_arns: self.notification_arns,
                path_id: self.path_id,
                product_id: self.product_id,
                provisioned_product_name: self.provisioned_product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_parameters: self.provisioning_parameters,
                idempotency_token: self.idempotency_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProvisionedProductPlanInputOperationOutputAlias =
    crate::operation::CreateProvisionedProductPlan;
#[doc(hidden)]
pub type CreateProvisionedProductPlanInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateProvisionedProductPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateProvisionedProductPlan`](crate::operation::CreateProvisionedProductPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProvisionedProductPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProvisionedProductPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProvisionedProductPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProvisionedProductPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateProvisionedProductPlan",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_provisioned_product_plan(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProvisionedProductPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProvisionedProductPlan",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProvisionedProductPlanInput`](crate::input::CreateProvisionedProductPlanInput)
    pub fn builder() -> crate::input::create_provisioned_product_plan_input::Builder {
        crate::input::create_provisioned_product_plan_input::Builder::default()
    }
}

/// See [`CreateProvisioningArtifactInput`](crate::input::CreateProvisioningArtifactInput)
pub mod create_provisioning_artifact_input {
    /// A builder for [`CreateProvisioningArtifactInput`](crate::input::CreateProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn parameters(mut self, input: crate::model::ProvisioningArtifactProperties) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningArtifactInput`](crate::input::CreateProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProvisioningArtifactInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                parameters: self.parameters,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProvisioningArtifactInputOperationOutputAlias =
    crate::operation::CreateProvisioningArtifact;
#[doc(hidden)]
pub type CreateProvisioningArtifactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`CreateProvisioningArtifact`](crate::operation::CreateProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateProvisioningArtifact",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_provisioning_artifact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProvisioningArtifactInput`](crate::input::CreateProvisioningArtifactInput)
    pub fn builder() -> crate::input::create_provisioning_artifact_input::Builder {
        crate::input::create_provisioning_artifact_input::Builder::default()
    }
}

/// See [`CreateServiceActionInput`](crate::input::CreateServiceActionInput)
pub mod create_service_action_input {
    /// A builder for [`CreateServiceActionInput`](crate::input::CreateServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) definition_type: std::option::Option<crate::model::ServiceActionDefinitionType>,
        pub(crate) definition: std::option::Option<
            std::collections::HashMap<
                crate::model::ServiceActionDefinitionKey,
                std::string::String,
            >,
        >,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn definition_type(mut self, input: crate::model::ServiceActionDefinitionType) -> Self {
            self.definition_type = Some(input);
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn set_definition_type(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDefinitionType>,
        ) -> Self {
            self.definition_type = input;
            self
        }
        /// Adds a key-value pair to `definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>
        /// Name
        /// </dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>
        /// Version
        /// </dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code> </p>
        /// </dd>
        /// <dt>
        /// AssumeRole
        /// </dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>
        /// Parameters
        /// </dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn definition(
            mut self,
            k: crate::model::ServiceActionDefinitionKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.definition.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.definition = Some(hash_map);
            self
        }
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>
        /// Name
        /// </dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>
        /// Version
        /// </dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code> </p>
        /// </dd>
        /// <dt>
        /// AssumeRole
        /// </dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>
        /// Parameters
        /// </dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceActionInput`](crate::input::CreateServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceActionInput {
                name: self.name,
                definition_type: self.definition_type,
                definition: self.definition,
                description: self.description,
                accept_language: self.accept_language,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceActionInputOperationOutputAlias = crate::operation::CreateServiceAction;
#[doc(hidden)]
pub type CreateServiceActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceAction`](crate::operation::CreateServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateServiceAction",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_service_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceActionInput`](crate::input::CreateServiceActionInput)
    pub fn builder() -> crate::input::create_service_action_input::Builder {
        crate::input::create_service_action_input::Builder::default()
    }
}

/// See [`CreateTagOptionInput`](crate::input::CreateTagOptionInput)
pub mod create_tag_option_input {
    /// A builder for [`CreateTagOptionInput`](crate::input::CreateTagOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The TagOption key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The TagOption value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagOptionInput`](crate::input::CreateTagOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagOptionInput {
                key: self.key,
                value: self.value,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagOptionInputOperationOutputAlias = crate::operation::CreateTagOption;
#[doc(hidden)]
pub type CreateTagOptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTagOptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateTagOption`](crate::operation::CreateTagOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTagOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.CreateTagOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_tag_option(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTagOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTagOption",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagOptionInput`](crate::input::CreateTagOptionInput)
    pub fn builder() -> crate::input::create_tag_option_input::Builder {
        crate::input::create_tag_option_input::Builder::default()
    }
}

/// See [`DeleteConstraintInput`](crate::input::DeleteConstraintInput)
pub mod delete_constraint_input {
    /// A builder for [`DeleteConstraintInput`](crate::input::DeleteConstraintInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConstraintInput`](crate::input::DeleteConstraintInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConstraintInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConstraintInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConstraintInputOperationOutputAlias = crate::operation::DeleteConstraint;
#[doc(hidden)]
pub type DeleteConstraintInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConstraintInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConstraint`](crate::operation::DeleteConstraint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConstraint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConstraintInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConstraintInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConstraintInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteConstraint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_constraint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConstraint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConstraint",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConstraintInput`](crate::input::DeleteConstraintInput)
    pub fn builder() -> crate::input::delete_constraint_input::Builder {
        crate::input::delete_constraint_input::Builder::default()
    }
}

/// See [`DeletePortfolioInput`](crate::input::DeletePortfolioInput)
pub mod delete_portfolio_input {
    /// A builder for [`DeletePortfolioInput`](crate::input::DeletePortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortfolioInput`](crate::input::DeletePortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePortfolioInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePortfolioInputOperationOutputAlias = crate::operation::DeletePortfolio;
#[doc(hidden)]
pub type DeletePortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePortfolioInput {
    /// Consumes the builder and constructs an Operation<[`DeletePortfolio`](crate::operation::DeletePortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeletePortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_portfolio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePortfolioInput`](crate::input::DeletePortfolioInput)
    pub fn builder() -> crate::input::delete_portfolio_input::Builder {
        crate::input::delete_portfolio_input::Builder::default()
    }
}

/// See [`DeletePortfolioShareInput`](crate::input::DeletePortfolioShareInput)
pub mod delete_portfolio_share_input {
    /// A builder for [`DeletePortfolioShareInput`](crate::input::DeletePortfolioShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) organization_node: std::option::Option<crate::model::OrganizationNode>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.organization_node = Some(input);
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.organization_node = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortfolioShareInput`](crate::input::DeletePortfolioShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePortfolioShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePortfolioShareInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                account_id: self.account_id,
                organization_node: self.organization_node,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePortfolioShareInputOperationOutputAlias = crate::operation::DeletePortfolioShare;
#[doc(hidden)]
pub type DeletePortfolioShareInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePortfolioShareInput {
    /// Consumes the builder and constructs an Operation<[`DeletePortfolioShare`](crate::operation::DeletePortfolioShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePortfolioShare,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePortfolioShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePortfolioShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePortfolioShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeletePortfolioShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_portfolio_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePortfolioShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePortfolioShare",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePortfolioShareInput`](crate::input::DeletePortfolioShareInput)
    pub fn builder() -> crate::input::delete_portfolio_share_input::Builder {
        crate::input::delete_portfolio_share_input::Builder::default()
    }
}

/// See [`DeleteProductInput`](crate::input::DeleteProductInput)
pub mod delete_product_input {
    /// A builder for [`DeleteProductInput`](crate::input::DeleteProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProductInput`](crate::input::DeleteProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProductInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProductInputOperationOutputAlias = crate::operation::DeleteProduct;
#[doc(hidden)]
pub type DeleteProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProductInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProduct`](crate::operation::DeleteProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProductInput`](crate::input::DeleteProductInput)
    pub fn builder() -> crate::input::delete_product_input::Builder {
        crate::input::delete_product_input::Builder::default()
    }
}

/// See [`DeleteProvisionedProductPlanInput`](crate::input::DeleteProvisionedProductPlanInput)
pub mod delete_provisioned_product_plan_input {
    /// A builder for [`DeleteProvisionedProductPlanInput`](crate::input::DeleteProvisionedProductPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) ignore_errors: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, input: bool) -> Self {
            self.ignore_errors = Some(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProvisionedProductPlanInput`](crate::input::DeleteProvisionedProductPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProvisionedProductPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProvisionedProductPlanInput {
                accept_language: self.accept_language,
                plan_id: self.plan_id,
                ignore_errors: self.ignore_errors.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProvisionedProductPlanInputOperationOutputAlias =
    crate::operation::DeleteProvisionedProductPlan;
#[doc(hidden)]
pub type DeleteProvisionedProductPlanInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProvisionedProductPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProvisionedProductPlan`](crate::operation::DeleteProvisionedProductPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProvisionedProductPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProvisionedProductPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProvisionedProductPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProvisionedProductPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteProvisionedProductPlan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_provisioned_product_plan(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProvisionedProductPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProvisionedProductPlan",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedProductPlanInput`](crate::input::DeleteProvisionedProductPlanInput)
    pub fn builder() -> crate::input::delete_provisioned_product_plan_input::Builder {
        crate::input::delete_provisioned_product_plan_input::Builder::default()
    }
}

/// See [`DeleteProvisioningArtifactInput`](crate::input::DeleteProvisioningArtifactInput)
pub mod delete_provisioning_artifact_input {
    /// A builder for [`DeleteProvisioningArtifactInput`](crate::input::DeleteProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProvisioningArtifactInput`](crate::input::DeleteProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProvisioningArtifactInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProvisioningArtifactInputOperationOutputAlias =
    crate::operation::DeleteProvisioningArtifact;
#[doc(hidden)]
pub type DeleteProvisioningArtifactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProvisioningArtifact`](crate::operation::DeleteProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_provisioning_artifact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningArtifactInput`](crate::input::DeleteProvisioningArtifactInput)
    pub fn builder() -> crate::input::delete_provisioning_artifact_input::Builder {
        crate::input::delete_provisioning_artifact_input::Builder::default()
    }
}

/// See [`DeleteServiceActionInput`](crate::input::DeleteServiceActionInput)
pub mod delete_service_action_input {
    /// A builder for [`DeleteServiceActionInput`](crate::input::DeleteServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceActionInput`](crate::input::DeleteServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceActionInput {
                id: self.id,
                accept_language: self.accept_language,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceActionInputOperationOutputAlias = crate::operation::DeleteServiceAction;
#[doc(hidden)]
pub type DeleteServiceActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceAction`](crate::operation::DeleteServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteServiceAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_service_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceActionInput`](crate::input::DeleteServiceActionInput)
    pub fn builder() -> crate::input::delete_service_action_input::Builder {
        crate::input::delete_service_action_input::Builder::default()
    }
}

/// See [`DeleteTagOptionInput`](crate::input::DeleteTagOptionInput)
pub mod delete_tag_option_input {
    /// A builder for [`DeleteTagOptionInput`](crate::input::DeleteTagOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagOptionInput`](crate::input::DeleteTagOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagOptionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagOptionInputOperationOutputAlias = crate::operation::DeleteTagOption;
#[doc(hidden)]
pub type DeleteTagOptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTagOptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTagOption`](crate::operation::DeleteTagOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTagOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DeleteTagOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_tag_option(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTagOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTagOption",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagOptionInput`](crate::input::DeleteTagOptionInput)
    pub fn builder() -> crate::input::delete_tag_option_input::Builder {
        crate::input::delete_tag_option_input::Builder::default()
    }
}

/// See [`DescribeConstraintInput`](crate::input::DescribeConstraintInput)
pub mod describe_constraint_input {
    /// A builder for [`DescribeConstraintInput`](crate::input::DescribeConstraintInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConstraintInput`](crate::input::DescribeConstraintInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConstraintInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConstraintInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConstraintInputOperationOutputAlias = crate::operation::DescribeConstraint;
#[doc(hidden)]
pub type DescribeConstraintInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeConstraintInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConstraint`](crate::operation::DescribeConstraint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConstraint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConstraintInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConstraintInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConstraintInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeConstraint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_constraint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConstraint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConstraint",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConstraintInput`](crate::input::DescribeConstraintInput)
    pub fn builder() -> crate::input::describe_constraint_input::Builder {
        crate::input::describe_constraint_input::Builder::default()
    }
}

/// See [`DescribeCopyProductStatusInput`](crate::input::DescribeCopyProductStatusInput)
pub mod describe_copy_product_status_input {
    /// A builder for [`DescribeCopyProductStatusInput`](crate::input::DescribeCopyProductStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) copy_product_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <code>CopyProduct</code>.</p>
        pub fn copy_product_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_product_token = Some(input.into());
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <code>CopyProduct</code>.</p>
        pub fn set_copy_product_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_product_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCopyProductStatusInput`](crate::input::DescribeCopyProductStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCopyProductStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCopyProductStatusInput {
                accept_language: self.accept_language,
                copy_product_token: self.copy_product_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCopyProductStatusInputOperationOutputAlias =
    crate::operation::DescribeCopyProductStatus;
#[doc(hidden)]
pub type DescribeCopyProductStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCopyProductStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCopyProductStatus`](crate::operation::DescribeCopyProductStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCopyProductStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCopyProductStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCopyProductStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCopyProductStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeCopyProductStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_copy_product_status(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCopyProductStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCopyProductStatus",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCopyProductStatusInput`](crate::input::DescribeCopyProductStatusInput)
    pub fn builder() -> crate::input::describe_copy_product_status_input::Builder {
        crate::input::describe_copy_product_status_input::Builder::default()
    }
}

/// See [`DescribePortfolioInput`](crate::input::DescribePortfolioInput)
pub mod describe_portfolio_input {
    /// A builder for [`DescribePortfolioInput`](crate::input::DescribePortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioInput`](crate::input::DescribePortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePortfolioInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePortfolioInputOperationOutputAlias = crate::operation::DescribePortfolio;
#[doc(hidden)]
pub type DescribePortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePortfolioInput {
    /// Consumes the builder and constructs an Operation<[`DescribePortfolio`](crate::operation::DescribePortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribePortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_portfolio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePortfolioInput`](crate::input::DescribePortfolioInput)
    pub fn builder() -> crate::input::describe_portfolio_input::Builder {
        crate::input::describe_portfolio_input::Builder::default()
    }
}

/// See [`DescribePortfolioSharesInput`](crate::input::DescribePortfolioSharesInput)
pub mod describe_portfolio_shares_input {
    /// A builder for [`DescribePortfolioSharesInput`](crate::input::DescribePortfolioSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DescribePortfolioShareType>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn r#type(mut self, input: crate::model::DescribePortfolioShareType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DescribePortfolioShareType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioSharesInput`](crate::input::DescribePortfolioSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePortfolioSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePortfolioSharesInput {
                portfolio_id: self.portfolio_id,
                r#type: self.r#type,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePortfolioSharesInputOperationOutputAlias =
    crate::operation::DescribePortfolioShares;
#[doc(hidden)]
pub type DescribePortfolioSharesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePortfolioSharesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePortfolioShares`](crate::operation::DescribePortfolioShares)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePortfolioShares,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePortfolioSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePortfolioSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePortfolioSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribePortfolioShares",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_portfolio_shares(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePortfolioShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePortfolioShares",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePortfolioSharesInput`](crate::input::DescribePortfolioSharesInput)
    pub fn builder() -> crate::input::describe_portfolio_shares_input::Builder {
        crate::input::describe_portfolio_shares_input::Builder::default()
    }
}

/// See [`DescribePortfolioShareStatusInput`](crate::input::DescribePortfolioShareStatusInput)
pub mod describe_portfolio_share_status_input {
    /// A builder for [`DescribePortfolioShareStatusInput`](crate::input::DescribePortfolioShareStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_share_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_share_token = Some(input.into());
            self
        }
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portfolio_share_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioShareStatusInput`](crate::input::DescribePortfolioShareStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePortfolioShareStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePortfolioShareStatusInput {
                portfolio_share_token: self.portfolio_share_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePortfolioShareStatusInputOperationOutputAlias =
    crate::operation::DescribePortfolioShareStatus;
#[doc(hidden)]
pub type DescribePortfolioShareStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribePortfolioShareStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribePortfolioShareStatus`](crate::operation::DescribePortfolioShareStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePortfolioShareStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePortfolioShareStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePortfolioShareStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePortfolioShareStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribePortfolioShareStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_portfolio_share_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePortfolioShareStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePortfolioShareStatus",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePortfolioShareStatusInput`](crate::input::DescribePortfolioShareStatusInput)
    pub fn builder() -> crate::input::describe_portfolio_share_status_input::Builder {
        crate::input::describe_portfolio_share_status_input::Builder::default()
    }
}

/// See [`DescribeProductInput`](crate::input::DescribeProductInput)
pub mod describe_product_input {
    /// A builder for [`DescribeProductInput`](crate::input::DescribeProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductInput`](crate::input::DescribeProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProductInput {
                accept_language: self.accept_language,
                id: self.id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProductInputOperationOutputAlias = crate::operation::DescribeProduct;
#[doc(hidden)]
pub type DescribeProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProductInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProduct`](crate::operation::DescribeProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProductInput`](crate::input::DescribeProductInput)
    pub fn builder() -> crate::input::describe_product_input::Builder {
        crate::input::describe_product_input::Builder::default()
    }
}

/// See [`DescribeProductAsAdminInput`](crate::input::DescribeProductAsAdminInput)
pub mod describe_product_as_admin_input {
    /// A builder for [`DescribeProductAsAdminInput`](crate::input::DescribeProductAsAdminInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_portfolio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
        pub fn source_portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_portfolio_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_portfolio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductAsAdminInput`](crate::input::DescribeProductAsAdminInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProductAsAdminInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProductAsAdminInput {
                accept_language: self.accept_language,
                id: self.id,
                name: self.name,
                source_portfolio_id: self.source_portfolio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProductAsAdminInputOperationOutputAlias = crate::operation::DescribeProductAsAdmin;
#[doc(hidden)]
pub type DescribeProductAsAdminInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProductAsAdminInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProductAsAdmin`](crate::operation::DescribeProductAsAdmin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProductAsAdmin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProductAsAdminInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProductAsAdminInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProductAsAdminInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProductAsAdmin",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_product_as_admin(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProductAsAdmin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProductAsAdmin",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProductAsAdminInput`](crate::input::DescribeProductAsAdminInput)
    pub fn builder() -> crate::input::describe_product_as_admin_input::Builder {
        crate::input::describe_product_as_admin_input::Builder::default()
    }
}

/// See [`DescribeProductViewInput`](crate::input::DescribeProductViewInput)
pub mod describe_product_view_input {
    /// A builder for [`DescribeProductViewInput`](crate::input::DescribeProductViewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product view identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product view identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductViewInput`](crate::input::DescribeProductViewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProductViewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProductViewInput {
                accept_language: self.accept_language,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProductViewInputOperationOutputAlias = crate::operation::DescribeProductView;
#[doc(hidden)]
pub type DescribeProductViewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProductViewInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProductView`](crate::operation::DescribeProductView)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProductView,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProductViewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProductViewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProductViewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProductView",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_product_view(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProductView::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProductView",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProductViewInput`](crate::input::DescribeProductViewInput)
    pub fn builder() -> crate::input::describe_product_view_input::Builder {
        crate::input::describe_product_view_input::Builder::default()
    }
}

/// See [`DescribeProvisionedProductInput`](crate::input::DescribeProvisionedProductInput)
pub mod describe_provisioned_product_input {
    /// A builder for [`DescribeProvisionedProductInput`](crate::input::DescribeProvisionedProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisionedProductInput`](crate::input::DescribeProvisionedProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisionedProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisionedProductInput {
                accept_language: self.accept_language,
                id: self.id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisionedProductInputOperationOutputAlias =
    crate::operation::DescribeProvisionedProduct;
#[doc(hidden)]
pub type DescribeProvisionedProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisionedProductInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisionedProduct`](crate::operation::DescribeProvisionedProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisionedProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProvisionedProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProvisionedProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProvisionedProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProvisionedProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_provisioned_product(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisionedProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisionedProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductInput`](crate::input::DescribeProvisionedProductInput)
    pub fn builder() -> crate::input::describe_provisioned_product_input::Builder {
        crate::input::describe_provisioned_product_input::Builder::default()
    }
}

/// See [`DescribeProvisionedProductPlanInput`](crate::input::DescribeProvisionedProductPlanInput)
pub mod describe_provisioned_product_plan_input {
    /// A builder for [`DescribeProvisionedProductPlanInput`](crate::input::DescribeProvisionedProductPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisionedProductPlanInput`](crate::input::DescribeProvisionedProductPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisionedProductPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisionedProductPlanInput {
                accept_language: self.accept_language,
                plan_id: self.plan_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisionedProductPlanInputOperationOutputAlias =
    crate::operation::DescribeProvisionedProductPlan;
#[doc(hidden)]
pub type DescribeProvisionedProductPlanInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisionedProductPlanInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisionedProductPlan`](crate::operation::DescribeProvisionedProductPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisionedProductPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProvisionedProductPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProvisionedProductPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProvisionedProductPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProvisionedProductPlan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_provisioned_product_plan(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisionedProductPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisionedProductPlan",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductPlanInput`](crate::input::DescribeProvisionedProductPlanInput)
    pub fn builder() -> crate::input::describe_provisioned_product_plan_input::Builder {
        crate::input::describe_provisioned_product_plan_input::Builder::default()
    }
}

/// See [`DescribeProvisioningArtifactInput`](crate::input::DescribeProvisioningArtifactInput)
pub mod describe_provisioning_artifact_input {
    /// A builder for [`DescribeProvisioningArtifactInput`](crate::input::DescribeProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_name: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) verbose: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_name = Some(input.into());
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_name = input;
            self
        }
        /// <p>The product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.verbose = Some(input);
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.verbose = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningArtifactInput`](crate::input::DescribeProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisioningArtifactInput {
                accept_language: self.accept_language,
                provisioning_artifact_id: self.provisioning_artifact_id,
                product_id: self.product_id,
                provisioning_artifact_name: self.provisioning_artifact_name,
                product_name: self.product_name,
                verbose: self.verbose.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisioningArtifactInputOperationOutputAlias =
    crate::operation::DescribeProvisioningArtifact;
#[doc(hidden)]
pub type DescribeProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisioningArtifact`](crate::operation::DescribeProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningArtifactInput`](crate::input::DescribeProvisioningArtifactInput)
    pub fn builder() -> crate::input::describe_provisioning_artifact_input::Builder {
        crate::input::describe_provisioning_artifact_input::Builder::default()
    }
}

/// See [`DescribeProvisioningParametersInput`](crate::input::DescribeProvisioningParametersInput)
pub mod describe_provisioning_parameters_input {
    /// A builder for [`DescribeProvisioningParametersInput`](crate::input::DescribeProvisioningParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_name: std::option::Option<std::string::String>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) path_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_name = input;
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_name = Some(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningParametersInput`](crate::input::DescribeProvisioningParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisioningParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisioningParametersInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                product_name: self.product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_artifact_name: self.provisioning_artifact_name,
                path_id: self.path_id,
                path_name: self.path_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisioningParametersInputOperationOutputAlias =
    crate::operation::DescribeProvisioningParameters;
#[doc(hidden)]
pub type DescribeProvisioningParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisioningParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisioningParameters`](crate::operation::DescribeProvisioningParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisioningParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProvisioningParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProvisioningParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProvisioningParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeProvisioningParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_provisioning_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisioningParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisioningParameters",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningParametersInput`](crate::input::DescribeProvisioningParametersInput)
    pub fn builder() -> crate::input::describe_provisioning_parameters_input::Builder {
        crate::input::describe_provisioning_parameters_input::Builder::default()
    }
}

/// See [`DescribeRecordInput`](crate::input::DescribeRecordInput)
pub mod describe_record_input {
    /// A builder for [`DescribeRecordInput`](crate::input::DescribeRecordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecordInput`](crate::input::DescribeRecordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecordInput {
                accept_language: self.accept_language,
                id: self.id,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecordInputOperationOutputAlias = crate::operation::DescribeRecord;
#[doc(hidden)]
pub type DescribeRecordInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRecordInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecord`](crate::operation::DescribeRecord)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecord,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeRecord",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_record(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecord::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecord",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecordInput`](crate::input::DescribeRecordInput)
    pub fn builder() -> crate::input::describe_record_input::Builder {
        crate::input::describe_record_input::Builder::default()
    }
}

/// See [`DescribeServiceActionInput`](crate::input::DescribeServiceActionInput)
pub mod describe_service_action_input {
    /// A builder for [`DescribeServiceActionInput`](crate::input::DescribeServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceActionInput`](crate::input::DescribeServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServiceActionInput {
                id: self.id,
                accept_language: self.accept_language,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceActionInputOperationOutputAlias = crate::operation::DescribeServiceAction;
#[doc(hidden)]
pub type DescribeServiceActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceAction`](crate::operation::DescribeServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeServiceAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_service_action(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionInput`](crate::input::DescribeServiceActionInput)
    pub fn builder() -> crate::input::describe_service_action_input::Builder {
        crate::input::describe_service_action_input::Builder::default()
    }
}

/// See [`DescribeServiceActionExecutionParametersInput`](crate::input::DescribeServiceActionExecutionParametersInput)
pub mod describe_service_action_execution_parameters_input {
    /// A builder for [`DescribeServiceActionExecutionParametersInput`](crate::input::DescribeServiceActionExecutionParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceActionExecutionParametersInput`](crate::input::DescribeServiceActionExecutionParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceActionExecutionParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeServiceActionExecutionParametersInput {
                    provisioned_product_id: self.provisioned_product_id,
                    service_action_id: self.service_action_id,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceActionExecutionParametersInputOperationOutputAlias =
    crate::operation::DescribeServiceActionExecutionParameters;
#[doc(hidden)]
pub type DescribeServiceActionExecutionParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServiceActionExecutionParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceActionExecutionParameters`](crate::operation::DescribeServiceActionExecutionParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceActionExecutionParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServiceActionExecutionParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServiceActionExecutionParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServiceActionExecutionParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeServiceActionExecutionParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_service_action_execution_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceActionExecutionParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceActionExecutionParameters",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionExecutionParametersInput`](crate::input::DescribeServiceActionExecutionParametersInput)
    pub fn builder() -> crate::input::describe_service_action_execution_parameters_input::Builder {
        crate::input::describe_service_action_execution_parameters_input::Builder::default()
    }
}

/// See [`DescribeTagOptionInput`](crate::input::DescribeTagOptionInput)
pub mod describe_tag_option_input {
    /// A builder for [`DescribeTagOptionInput`](crate::input::DescribeTagOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagOptionInput`](crate::input::DescribeTagOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagOptionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagOptionInputOperationOutputAlias = crate::operation::DescribeTagOption;
#[doc(hidden)]
pub type DescribeTagOptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTagOptionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTagOption`](crate::operation::DescribeTagOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTagOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DescribeTagOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_tag_option(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTagOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTagOption",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagOptionInput`](crate::input::DescribeTagOptionInput)
    pub fn builder() -> crate::input::describe_tag_option_input::Builder {
        crate::input::describe_tag_option_input::Builder::default()
    }
}

/// See [`DisableAwsOrganizationsAccessInput`](crate::input::DisableAwsOrganizationsAccessInput)
pub mod disable_aws_organizations_access_input {
    /// A builder for [`DisableAwsOrganizationsAccessInput`](crate::input::DisableAwsOrganizationsAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableAwsOrganizationsAccessInput`](crate::input::DisableAwsOrganizationsAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableAwsOrganizationsAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableAwsOrganizationsAccessInput {})
        }
    }
}
#[doc(hidden)]
pub type DisableAwsOrganizationsAccessInputOperationOutputAlias =
    crate::operation::DisableAWSOrganizationsAccess;
#[doc(hidden)]
pub type DisableAwsOrganizationsAccessInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisableAwsOrganizationsAccessInput {
    /// Consumes the builder and constructs an Operation<[`DisableAWSOrganizationsAccess`](crate::operation::DisableAWSOrganizationsAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableAWSOrganizationsAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableAwsOrganizationsAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableAwsOrganizationsAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableAwsOrganizationsAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisableAWSOrganizationsAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_aws_organizations_access(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableAWSOrganizationsAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableAWSOrganizationsAccess",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableAwsOrganizationsAccessInput`](crate::input::DisableAwsOrganizationsAccessInput)
    pub fn builder() -> crate::input::disable_aws_organizations_access_input::Builder {
        crate::input::disable_aws_organizations_access_input::Builder::default()
    }
}

/// See [`DisassociateBudgetFromResourceInput`](crate::input::DisassociateBudgetFromResourceInput)
pub mod disassociate_budget_from_resource_input {
    /// A builder for [`DisassociateBudgetFromResourceInput`](crate::input::DisassociateBudgetFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_name: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateBudgetFromResourceInput`](crate::input::DisassociateBudgetFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateBudgetFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateBudgetFromResourceInput {
                budget_name: self.budget_name,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateBudgetFromResourceInputOperationOutputAlias =
    crate::operation::DisassociateBudgetFromResource;
#[doc(hidden)]
pub type DisassociateBudgetFromResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateBudgetFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateBudgetFromResource`](crate::operation::DisassociateBudgetFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateBudgetFromResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateBudgetFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateBudgetFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateBudgetFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisassociateBudgetFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_budget_from_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateBudgetFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateBudgetFromResource",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateBudgetFromResourceInput`](crate::input::DisassociateBudgetFromResourceInput)
    pub fn builder() -> crate::input::disassociate_budget_from_resource_input::Builder {
        crate::input::disassociate_budget_from_resource_input::Builder::default()
    }
}

/// See [`DisassociatePrincipalFromPortfolioInput`](crate::input::DisassociatePrincipalFromPortfolioInput)
pub mod disassociate_principal_from_portfolio_input {
    /// A builder for [`DisassociatePrincipalFromPortfolioInput`](crate::input::DisassociatePrincipalFromPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePrincipalFromPortfolioInput`](crate::input::DisassociatePrincipalFromPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePrincipalFromPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociatePrincipalFromPortfolioInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                principal_arn: self.principal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociatePrincipalFromPortfolioInputOperationOutputAlias =
    crate::operation::DisassociatePrincipalFromPortfolio;
#[doc(hidden)]
pub type DisassociatePrincipalFromPortfolioInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePrincipalFromPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePrincipalFromPortfolio`](crate::operation::DisassociatePrincipalFromPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePrincipalFromPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociatePrincipalFromPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociatePrincipalFromPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociatePrincipalFromPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisassociatePrincipalFromPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_principal_from_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePrincipalFromPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePrincipalFromPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePrincipalFromPortfolioInput`](crate::input::DisassociatePrincipalFromPortfolioInput)
    pub fn builder() -> crate::input::disassociate_principal_from_portfolio_input::Builder {
        crate::input::disassociate_principal_from_portfolio_input::Builder::default()
    }
}

/// See [`DisassociateProductFromPortfolioInput`](crate::input::DisassociateProductFromPortfolioInput)
pub mod disassociate_product_from_portfolio_input {
    /// A builder for [`DisassociateProductFromPortfolioInput`](crate::input::DisassociateProductFromPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateProductFromPortfolioInput`](crate::input::DisassociateProductFromPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateProductFromPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateProductFromPortfolioInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                portfolio_id: self.portfolio_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateProductFromPortfolioInputOperationOutputAlias =
    crate::operation::DisassociateProductFromPortfolio;
#[doc(hidden)]
pub type DisassociateProductFromPortfolioInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateProductFromPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateProductFromPortfolio`](crate::operation::DisassociateProductFromPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateProductFromPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateProductFromPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateProductFromPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateProductFromPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisassociateProductFromPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_product_from_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateProductFromPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateProductFromPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateProductFromPortfolioInput`](crate::input::DisassociateProductFromPortfolioInput)
    pub fn builder() -> crate::input::disassociate_product_from_portfolio_input::Builder {
        crate::input::disassociate_product_from_portfolio_input::Builder::default()
    }
}

/// See [`DisassociateServiceActionFromProvisioningArtifactInput`](crate::input::DisassociateServiceActionFromProvisioningArtifactInput)
pub mod disassociate_service_action_from_provisioning_artifact_input {
    /// A builder for [`DisassociateServiceActionFromProvisioningArtifactInput`](crate::input::DisassociateServiceActionFromProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateServiceActionFromProvisioningArtifactInput`](crate::input::DisassociateServiceActionFromProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateServiceActionFromProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateServiceActionFromProvisioningArtifactInput {
                    product_id: self.product_id,
                    provisioning_artifact_id: self.provisioning_artifact_id,
                    service_action_id: self.service_action_id,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateServiceActionFromProvisioningArtifactInputOperationOutputAlias =
    crate::operation::DisassociateServiceActionFromProvisioningArtifact;
#[doc(hidden)]
pub type DisassociateServiceActionFromProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateServiceActionFromProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateServiceActionFromProvisioningArtifact`](crate::operation::DisassociateServiceActionFromProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateServiceActionFromProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateServiceActionFromProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateServiceActionFromProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateServiceActionFromProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisassociateServiceActionFromProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_service_action_from_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateServiceActionFromProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateServiceActionFromProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateServiceActionFromProvisioningArtifactInput`](crate::input::DisassociateServiceActionFromProvisioningArtifactInput)
    pub fn builder(
    ) -> crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder {
        crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder::default(
        )
    }
}

/// See [`DisassociateTagOptionFromResourceInput`](crate::input::DisassociateTagOptionFromResourceInput)
pub mod disassociate_tag_option_from_resource_input {
    /// A builder for [`DisassociateTagOptionFromResourceInput`](crate::input::DisassociateTagOptionFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_option_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_option_id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_option_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTagOptionFromResourceInput`](crate::input::DisassociateTagOptionFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateTagOptionFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateTagOptionFromResourceInput {
                resource_id: self.resource_id,
                tag_option_id: self.tag_option_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateTagOptionFromResourceInputOperationOutputAlias =
    crate::operation::DisassociateTagOptionFromResource;
#[doc(hidden)]
pub type DisassociateTagOptionFromResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateTagOptionFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateTagOptionFromResource`](crate::operation::DisassociateTagOptionFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateTagOptionFromResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateTagOptionFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateTagOptionFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateTagOptionFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.DisassociateTagOptionFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_tag_option_from_resource(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateTagOptionFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateTagOptionFromResource",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateTagOptionFromResourceInput`](crate::input::DisassociateTagOptionFromResourceInput)
    pub fn builder() -> crate::input::disassociate_tag_option_from_resource_input::Builder {
        crate::input::disassociate_tag_option_from_resource_input::Builder::default()
    }
}

/// See [`EnableAwsOrganizationsAccessInput`](crate::input::EnableAwsOrganizationsAccessInput)
pub mod enable_aws_organizations_access_input {
    /// A builder for [`EnableAwsOrganizationsAccessInput`](crate::input::EnableAwsOrganizationsAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableAwsOrganizationsAccessInput`](crate::input::EnableAwsOrganizationsAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableAwsOrganizationsAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableAwsOrganizationsAccessInput {})
        }
    }
}
#[doc(hidden)]
pub type EnableAwsOrganizationsAccessInputOperationOutputAlias =
    crate::operation::EnableAWSOrganizationsAccess;
#[doc(hidden)]
pub type EnableAwsOrganizationsAccessInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl EnableAwsOrganizationsAccessInput {
    /// Consumes the builder and constructs an Operation<[`EnableAWSOrganizationsAccess`](crate::operation::EnableAWSOrganizationsAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableAWSOrganizationsAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableAwsOrganizationsAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableAwsOrganizationsAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableAwsOrganizationsAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.EnableAWSOrganizationsAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_aws_organizations_access(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableAWSOrganizationsAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableAWSOrganizationsAccess",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableAwsOrganizationsAccessInput`](crate::input::EnableAwsOrganizationsAccessInput)
    pub fn builder() -> crate::input::enable_aws_organizations_access_input::Builder {
        crate::input::enable_aws_organizations_access_input::Builder::default()
    }
}

/// See [`ExecuteProvisionedProductPlanInput`](crate::input::ExecuteProvisionedProductPlanInput)
pub mod execute_provisioned_product_plan_input {
    /// A builder for [`ExecuteProvisionedProductPlanInput`](crate::input::ExecuteProvisionedProductPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteProvisionedProductPlanInput`](crate::input::ExecuteProvisionedProductPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteProvisionedProductPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteProvisionedProductPlanInput {
                accept_language: self.accept_language,
                plan_id: self.plan_id,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteProvisionedProductPlanInputOperationOutputAlias =
    crate::operation::ExecuteProvisionedProductPlan;
#[doc(hidden)]
pub type ExecuteProvisionedProductPlanInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ExecuteProvisionedProductPlanInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteProvisionedProductPlan`](crate::operation::ExecuteProvisionedProductPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteProvisionedProductPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteProvisionedProductPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteProvisionedProductPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteProvisionedProductPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ExecuteProvisionedProductPlan",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_provisioned_product_plan(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteProvisionedProductPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteProvisionedProductPlan",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductPlanInput`](crate::input::ExecuteProvisionedProductPlanInput)
    pub fn builder() -> crate::input::execute_provisioned_product_plan_input::Builder {
        crate::input::execute_provisioned_product_plan_input::Builder::default()
    }
}

/// See [`ExecuteProvisionedProductServiceActionInput`](crate::input::ExecuteProvisionedProductServiceActionInput)
pub mod execute_provisioned_product_service_action_input {
    /// A builder for [`ExecuteProvisionedProductServiceActionInput`](crate::input::ExecuteProvisionedProductServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) execute_token: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn execute_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.execute_token = Some(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn set_execute_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execute_token = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteProvisionedProductServiceActionInput`](crate::input::ExecuteProvisionedProductServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteProvisionedProductServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteProvisionedProductServiceActionInput {
                provisioned_product_id: self.provisioned_product_id,
                service_action_id: self.service_action_id,
                execute_token: self.execute_token,
                accept_language: self.accept_language,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteProvisionedProductServiceActionInputOperationOutputAlias =
    crate::operation::ExecuteProvisionedProductServiceAction;
#[doc(hidden)]
pub type ExecuteProvisionedProductServiceActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ExecuteProvisionedProductServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteProvisionedProductServiceAction`](crate::operation::ExecuteProvisionedProductServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteProvisionedProductServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteProvisionedProductServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteProvisionedProductServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteProvisionedProductServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ExecuteProvisionedProductServiceAction",
            );
            Ok(builder)
        }
        if self.execute_token.is_none() {
            self.execute_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_provisioned_product_service_action(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteProvisionedProductServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteProvisionedProductServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductServiceActionInput`](crate::input::ExecuteProvisionedProductServiceActionInput)
    pub fn builder() -> crate::input::execute_provisioned_product_service_action_input::Builder {
        crate::input::execute_provisioned_product_service_action_input::Builder::default()
    }
}

/// See [`GetAwsOrganizationsAccessStatusInput`](crate::input::GetAwsOrganizationsAccessStatusInput)
pub mod get_aws_organizations_access_status_input {
    /// A builder for [`GetAwsOrganizationsAccessStatusInput`](crate::input::GetAwsOrganizationsAccessStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAwsOrganizationsAccessStatusInput`](crate::input::GetAwsOrganizationsAccessStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAwsOrganizationsAccessStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAwsOrganizationsAccessStatusInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAwsOrganizationsAccessStatusInputOperationOutputAlias =
    crate::operation::GetAWSOrganizationsAccessStatus;
#[doc(hidden)]
pub type GetAwsOrganizationsAccessStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAwsOrganizationsAccessStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetAWSOrganizationsAccessStatus`](crate::operation::GetAWSOrganizationsAccessStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAWSOrganizationsAccessStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAwsOrganizationsAccessStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAwsOrganizationsAccessStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAwsOrganizationsAccessStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.GetAWSOrganizationsAccessStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_aws_organizations_access_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAWSOrganizationsAccessStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAWSOrganizationsAccessStatus",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAwsOrganizationsAccessStatusInput`](crate::input::GetAwsOrganizationsAccessStatusInput)
    pub fn builder() -> crate::input::get_aws_organizations_access_status_input::Builder {
        crate::input::get_aws_organizations_access_status_input::Builder::default()
    }
}

/// See [`GetProvisionedProductOutputsInput`](crate::input::GetProvisionedProductOutputsInput)
pub mod get_provisioned_product_outputs_input {
    /// A builder for [`GetProvisionedProductOutputsInput`](crate::input::GetProvisionedProductOutputsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// Appends an item to `output_keys`.
        ///
        /// To override the contents of this collection use [`set_output_keys`](Self::set_output_keys).
        ///
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn output_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.output_keys.unwrap_or_default();
            v.push(input.into());
            self.output_keys = Some(v);
            self
        }
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn set_output_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.output_keys = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProvisionedProductOutputsInput`](crate::input::GetProvisionedProductOutputsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProvisionedProductOutputsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProvisionedProductOutputsInput {
                accept_language: self.accept_language,
                provisioned_product_id: self.provisioned_product_id,
                provisioned_product_name: self.provisioned_product_name,
                output_keys: self.output_keys,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProvisionedProductOutputsInputOperationOutputAlias =
    crate::operation::GetProvisionedProductOutputs;
#[doc(hidden)]
pub type GetProvisionedProductOutputsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetProvisionedProductOutputsInput {
    /// Consumes the builder and constructs an Operation<[`GetProvisionedProductOutputs`](crate::operation::GetProvisionedProductOutputs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProvisionedProductOutputs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetProvisionedProductOutputsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetProvisionedProductOutputsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetProvisionedProductOutputsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.GetProvisionedProductOutputs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_provisioned_product_outputs(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProvisionedProductOutputs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProvisionedProductOutputs",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetProvisionedProductOutputsInput`](crate::input::GetProvisionedProductOutputsInput)
    pub fn builder() -> crate::input::get_provisioned_product_outputs_input::Builder {
        crate::input::get_provisioned_product_outputs_input::Builder::default()
    }
}

/// See [`ImportAsProvisionedProductInput`](crate::input::ImportAsProvisionedProductInput)
pub mod import_as_provisioned_product_input {
    /// A builder for [`ImportAsProvisionedProductInput`](crate::input::ImportAsProvisionedProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) physical_id: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
        pub fn physical_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
        pub fn set_physical_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.physical_id = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAsProvisionedProductInput`](crate::input::ImportAsProvisionedProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportAsProvisionedProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportAsProvisionedProductInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioned_product_name: self.provisioned_product_name,
                physical_id: self.physical_id,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportAsProvisionedProductInputOperationOutputAlias =
    crate::operation::ImportAsProvisionedProduct;
#[doc(hidden)]
pub type ImportAsProvisionedProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportAsProvisionedProductInput {
    /// Consumes the builder and constructs an Operation<[`ImportAsProvisionedProduct`](crate::operation::ImportAsProvisionedProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportAsProvisionedProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportAsProvisionedProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportAsProvisionedProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportAsProvisionedProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ImportAsProvisionedProduct",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_as_provisioned_product(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportAsProvisionedProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportAsProvisionedProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportAsProvisionedProductInput`](crate::input::ImportAsProvisionedProductInput)
    pub fn builder() -> crate::input::import_as_provisioned_product_input::Builder {
        crate::input::import_as_provisioned_product_input::Builder::default()
    }
}

/// See [`ListAcceptedPortfolioSharesInput`](crate::input::ListAcceptedPortfolioSharesInput)
pub mod list_accepted_portfolio_shares_input {
    /// A builder for [`ListAcceptedPortfolioSharesInput`](crate::input::ListAcceptedPortfolioSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) portfolio_share_type: std::option::Option<crate::model::PortfolioShareType>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
        /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
        /// </ul>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.portfolio_share_type = Some(input);
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
        /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
        /// </ul>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.portfolio_share_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAcceptedPortfolioSharesInput`](crate::input::ListAcceptedPortfolioSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAcceptedPortfolioSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAcceptedPortfolioSharesInput {
                accept_language: self.accept_language,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
                portfolio_share_type: self.portfolio_share_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAcceptedPortfolioSharesInputOperationOutputAlias =
    crate::operation::ListAcceptedPortfolioShares;
#[doc(hidden)]
pub type ListAcceptedPortfolioSharesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAcceptedPortfolioSharesInput {
    /// Consumes the builder and constructs an Operation<[`ListAcceptedPortfolioShares`](crate::operation::ListAcceptedPortfolioShares)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAcceptedPortfolioShares,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAcceptedPortfolioSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAcceptedPortfolioSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAcceptedPortfolioSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListAcceptedPortfolioShares",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_accepted_portfolio_shares(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAcceptedPortfolioShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAcceptedPortfolioShares",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAcceptedPortfolioSharesInput`](crate::input::ListAcceptedPortfolioSharesInput)
    pub fn builder() -> crate::input::list_accepted_portfolio_shares_input::Builder {
        crate::input::list_accepted_portfolio_shares_input::Builder::default()
    }
}

/// See [`ListBudgetsForResourceInput`](crate::input::ListBudgetsForResourceInput)
pub mod list_budgets_for_resource_input {
    /// A builder for [`ListBudgetsForResourceInput`](crate::input::ListBudgetsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBudgetsForResourceInput`](crate::input::ListBudgetsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBudgetsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBudgetsForResourceInput {
                accept_language: self.accept_language,
                resource_id: self.resource_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBudgetsForResourceInputOperationOutputAlias = crate::operation::ListBudgetsForResource;
#[doc(hidden)]
pub type ListBudgetsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBudgetsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListBudgetsForResource`](crate::operation::ListBudgetsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBudgetsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBudgetsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBudgetsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBudgetsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListBudgetsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_budgets_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBudgetsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBudgetsForResource",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBudgetsForResourceInput`](crate::input::ListBudgetsForResourceInput)
    pub fn builder() -> crate::input::list_budgets_for_resource_input::Builder {
        crate::input::list_budgets_for_resource_input::Builder::default()
    }
}

/// See [`ListConstraintsForPortfolioInput`](crate::input::ListConstraintsForPortfolioInput)
pub mod list_constraints_for_portfolio_input {
    /// A builder for [`ListConstraintsForPortfolioInput`](crate::input::ListConstraintsForPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConstraintsForPortfolioInput`](crate::input::ListConstraintsForPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConstraintsForPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConstraintsForPortfolioInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                product_id: self.product_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConstraintsForPortfolioInputOperationOutputAlias =
    crate::operation::ListConstraintsForPortfolio;
#[doc(hidden)]
pub type ListConstraintsForPortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConstraintsForPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`ListConstraintsForPortfolio`](crate::operation::ListConstraintsForPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConstraintsForPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConstraintsForPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConstraintsForPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConstraintsForPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListConstraintsForPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_constraints_for_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConstraintsForPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConstraintsForPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConstraintsForPortfolioInput`](crate::input::ListConstraintsForPortfolioInput)
    pub fn builder() -> crate::input::list_constraints_for_portfolio_input::Builder {
        crate::input::list_constraints_for_portfolio_input::Builder::default()
    }
}

/// See [`ListLaunchPathsInput`](crate::input::ListLaunchPathsInput)
pub mod list_launch_paths_input {
    /// A builder for [`ListLaunchPathsInput`](crate::input::ListLaunchPathsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchPathsInput`](crate::input::ListLaunchPathsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLaunchPathsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLaunchPathsInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLaunchPathsInputOperationOutputAlias = crate::operation::ListLaunchPaths;
#[doc(hidden)]
pub type ListLaunchPathsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLaunchPathsInput {
    /// Consumes the builder and constructs an Operation<[`ListLaunchPaths`](crate::operation::ListLaunchPaths)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLaunchPaths,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLaunchPathsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLaunchPathsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLaunchPathsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListLaunchPaths",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_launch_paths(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLaunchPaths::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLaunchPaths",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLaunchPathsInput`](crate::input::ListLaunchPathsInput)
    pub fn builder() -> crate::input::list_launch_paths_input::Builder {
        crate::input::list_launch_paths_input::Builder::default()
    }
}

/// See [`ListOrganizationPortfolioAccessInput`](crate::input::ListOrganizationPortfolioAccessInput)
pub mod list_organization_portfolio_access_input {
    /// A builder for [`ListOrganizationPortfolioAccessInput`](crate::input::ListOrganizationPortfolioAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) organization_node_type: std::option::Option<crate::model::OrganizationNodeType>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
        /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
        /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
        /// </ul>
        pub fn organization_node_type(mut self, input: crate::model::OrganizationNodeType) -> Self {
            self.organization_node_type = Some(input);
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
        /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
        /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
        /// </ul>
        pub fn set_organization_node_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationNodeType>,
        ) -> Self {
            self.organization_node_type = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationPortfolioAccessInput`](crate::input::ListOrganizationPortfolioAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationPortfolioAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationPortfolioAccessInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                organization_node_type: self.organization_node_type,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationPortfolioAccessInputOperationOutputAlias =
    crate::operation::ListOrganizationPortfolioAccess;
#[doc(hidden)]
pub type ListOrganizationPortfolioAccessInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListOrganizationPortfolioAccessInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationPortfolioAccess`](crate::operation::ListOrganizationPortfolioAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationPortfolioAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOrganizationPortfolioAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOrganizationPortfolioAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOrganizationPortfolioAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListOrganizationPortfolioAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_organization_portfolio_access(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationPortfolioAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationPortfolioAccess",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationPortfolioAccessInput`](crate::input::ListOrganizationPortfolioAccessInput)
    pub fn builder() -> crate::input::list_organization_portfolio_access_input::Builder {
        crate::input::list_organization_portfolio_access_input::Builder::default()
    }
}

/// See [`ListPortfolioAccessInput`](crate::input::ListPortfolioAccessInput)
pub mod list_portfolio_access_input {
    /// A builder for [`ListPortfolioAccessInput`](crate::input::ListPortfolioAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) organization_parent_id: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn organization_parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_parent_id = Some(input.into());
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn set_organization_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_parent_id = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfolioAccessInput`](crate::input::ListPortfolioAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPortfolioAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPortfolioAccessInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                organization_parent_id: self.organization_parent_id,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPortfolioAccessInputOperationOutputAlias = crate::operation::ListPortfolioAccess;
#[doc(hidden)]
pub type ListPortfolioAccessInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPortfolioAccessInput {
    /// Consumes the builder and constructs an Operation<[`ListPortfolioAccess`](crate::operation::ListPortfolioAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPortfolioAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPortfolioAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPortfolioAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPortfolioAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListPortfolioAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_portfolio_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPortfolioAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPortfolioAccess",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPortfolioAccessInput`](crate::input::ListPortfolioAccessInput)
    pub fn builder() -> crate::input::list_portfolio_access_input::Builder {
        crate::input::list_portfolio_access_input::Builder::default()
    }
}

/// See [`ListPortfoliosInput`](crate::input::ListPortfoliosInput)
pub mod list_portfolios_input {
    /// A builder for [`ListPortfoliosInput`](crate::input::ListPortfoliosInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfoliosInput`](crate::input::ListPortfoliosInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPortfoliosInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPortfoliosInput {
                accept_language: self.accept_language,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPortfoliosInputOperationOutputAlias = crate::operation::ListPortfolios;
#[doc(hidden)]
pub type ListPortfoliosInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPortfoliosInput {
    /// Consumes the builder and constructs an Operation<[`ListPortfolios`](crate::operation::ListPortfolios)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPortfolios,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPortfoliosInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPortfoliosInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPortfoliosInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListPortfolios",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_portfolios(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPortfolios::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPortfolios",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPortfoliosInput`](crate::input::ListPortfoliosInput)
    pub fn builder() -> crate::input::list_portfolios_input::Builder {
        crate::input::list_portfolios_input::Builder::default()
    }
}

/// See [`ListPortfoliosForProductInput`](crate::input::ListPortfoliosForProductInput)
pub mod list_portfolios_for_product_input {
    /// A builder for [`ListPortfoliosForProductInput`](crate::input::ListPortfoliosForProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfoliosForProductInput`](crate::input::ListPortfoliosForProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPortfoliosForProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPortfoliosForProductInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPortfoliosForProductInputOperationOutputAlias =
    crate::operation::ListPortfoliosForProduct;
#[doc(hidden)]
pub type ListPortfoliosForProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPortfoliosForProductInput {
    /// Consumes the builder and constructs an Operation<[`ListPortfoliosForProduct`](crate::operation::ListPortfoliosForProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPortfoliosForProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPortfoliosForProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPortfoliosForProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPortfoliosForProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListPortfoliosForProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_portfolios_for_product(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPortfoliosForProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPortfoliosForProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPortfoliosForProductInput`](crate::input::ListPortfoliosForProductInput)
    pub fn builder() -> crate::input::list_portfolios_for_product_input::Builder {
        crate::input::list_portfolios_for_product_input::Builder::default()
    }
}

/// See [`ListPrincipalsForPortfolioInput`](crate::input::ListPrincipalsForPortfolioInput)
pub mod list_principals_for_portfolio_input {
    /// A builder for [`ListPrincipalsForPortfolioInput`](crate::input::ListPrincipalsForPortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalsForPortfolioInput`](crate::input::ListPrincipalsForPortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPrincipalsForPortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPrincipalsForPortfolioInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPrincipalsForPortfolioInputOperationOutputAlias =
    crate::operation::ListPrincipalsForPortfolio;
#[doc(hidden)]
pub type ListPrincipalsForPortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPrincipalsForPortfolioInput {
    /// Consumes the builder and constructs an Operation<[`ListPrincipalsForPortfolio`](crate::operation::ListPrincipalsForPortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPrincipalsForPortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPrincipalsForPortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPrincipalsForPortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPrincipalsForPortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListPrincipalsForPortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_principals_for_portfolio(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPrincipalsForPortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPrincipalsForPortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPrincipalsForPortfolioInput`](crate::input::ListPrincipalsForPortfolioInput)
    pub fn builder() -> crate::input::list_principals_for_portfolio_input::Builder {
        crate::input::list_principals_for_portfolio_input::Builder::default()
    }
}

/// See [`ListProvisionedProductPlansInput`](crate::input::ListProvisionedProductPlansInput)
pub mod list_provisioned_product_plans_input {
    /// A builder for [`ListProvisionedProductPlansInput`](crate::input::ListProvisionedProductPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provision_product_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.access_level_filter = Some(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.access_level_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedProductPlansInput`](crate::input::ListProvisionedProductPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProvisionedProductPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProvisionedProductPlansInput {
                accept_language: self.accept_language,
                provision_product_id: self.provision_product_id,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
                access_level_filter: self.access_level_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProvisionedProductPlansInputOperationOutputAlias =
    crate::operation::ListProvisionedProductPlans;
#[doc(hidden)]
pub type ListProvisionedProductPlansInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProvisionedProductPlansInput {
    /// Consumes the builder and constructs an Operation<[`ListProvisionedProductPlans`](crate::operation::ListProvisionedProductPlans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProvisionedProductPlans,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProvisionedProductPlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProvisionedProductPlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProvisionedProductPlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListProvisionedProductPlans",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_provisioned_product_plans(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProvisionedProductPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProvisionedProductPlans",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProvisionedProductPlansInput`](crate::input::ListProvisionedProductPlansInput)
    pub fn builder() -> crate::input::list_provisioned_product_plans_input::Builder {
        crate::input::list_provisioned_product_plans_input::Builder::default()
    }
}

/// See [`ListProvisioningArtifactsInput`](crate::input::ListProvisioningArtifactsInput)
pub mod list_provisioning_artifacts_input {
    /// A builder for [`ListProvisioningArtifactsInput`](crate::input::ListProvisioningArtifactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningArtifactsInput`](crate::input::ListProvisioningArtifactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProvisioningArtifactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProvisioningArtifactsInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProvisioningArtifactsInputOperationOutputAlias =
    crate::operation::ListProvisioningArtifacts;
#[doc(hidden)]
pub type ListProvisioningArtifactsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProvisioningArtifactsInput {
    /// Consumes the builder and constructs an Operation<[`ListProvisioningArtifacts`](crate::operation::ListProvisioningArtifacts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProvisioningArtifacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProvisioningArtifactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProvisioningArtifactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProvisioningArtifactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListProvisioningArtifacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_provisioning_artifacts(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProvisioningArtifacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProvisioningArtifacts",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsInput`](crate::input::ListProvisioningArtifactsInput)
    pub fn builder() -> crate::input::list_provisioning_artifacts_input::Builder {
        crate::input::list_provisioning_artifacts_input::Builder::default()
    }
}

/// See [`ListProvisioningArtifactsForServiceActionInput`](crate::input::ListProvisioningArtifactsForServiceActionInput)
pub mod list_provisioning_artifacts_for_service_action_input {
    /// A builder for [`ListProvisioningArtifactsForServiceActionInput`](crate::input::ListProvisioningArtifactsForServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningArtifactsForServiceActionInput`](crate::input::ListProvisioningArtifactsForServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProvisioningArtifactsForServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListProvisioningArtifactsForServiceActionInput {
                    service_action_id: self.service_action_id,
                    page_size: self.page_size.unwrap_or_default(),
                    page_token: self.page_token,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListProvisioningArtifactsForServiceActionInputOperationOutputAlias =
    crate::operation::ListProvisioningArtifactsForServiceAction;
#[doc(hidden)]
pub type ListProvisioningArtifactsForServiceActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListProvisioningArtifactsForServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`ListProvisioningArtifactsForServiceAction`](crate::operation::ListProvisioningArtifactsForServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProvisioningArtifactsForServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProvisioningArtifactsForServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProvisioningArtifactsForServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProvisioningArtifactsForServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListProvisioningArtifactsForServiceAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_provisioning_artifacts_for_service_action(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProvisioningArtifactsForServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProvisioningArtifactsForServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsForServiceActionInput`](crate::input::ListProvisioningArtifactsForServiceActionInput)
    pub fn builder() -> crate::input::list_provisioning_artifacts_for_service_action_input::Builder
    {
        crate::input::list_provisioning_artifacts_for_service_action_input::Builder::default()
    }
}

/// See [`ListRecordHistoryInput`](crate::input::ListRecordHistoryInput)
pub mod list_record_history_input {
    /// A builder for [`ListRecordHistoryInput`](crate::input::ListRecordHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
        pub(crate) search_filter: std::option::Option<crate::model::ListRecordHistorySearchFilter>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.access_level_filter = Some(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.access_level_filter = input;
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn search_filter(mut self, input: crate::model::ListRecordHistorySearchFilter) -> Self {
            self.search_filter = Some(input);
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn set_search_filter(
            mut self,
            input: std::option::Option<crate::model::ListRecordHistorySearchFilter>,
        ) -> Self {
            self.search_filter = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordHistoryInput`](crate::input::ListRecordHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecordHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecordHistoryInput {
                accept_language: self.accept_language,
                access_level_filter: self.access_level_filter,
                search_filter: self.search_filter,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecordHistoryInputOperationOutputAlias = crate::operation::ListRecordHistory;
#[doc(hidden)]
pub type ListRecordHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRecordHistoryInput {
    /// Consumes the builder and constructs an Operation<[`ListRecordHistory`](crate::operation::ListRecordHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecordHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecordHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecordHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecordHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListRecordHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_record_history(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecordHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecordHistory",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecordHistoryInput`](crate::input::ListRecordHistoryInput)
    pub fn builder() -> crate::input::list_record_history_input::Builder {
        crate::input::list_record_history_input::Builder::default()
    }
}

/// See [`ListResourcesForTagOptionInput`](crate::input::ListResourcesForTagOptionInput)
pub mod list_resources_for_tag_option_input {
    /// A builder for [`ListResourcesForTagOptionInput`](crate::input::ListResourcesForTagOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_option_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_option_id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_option_id = input;
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li> <p> <code>Portfolio</code> </p> </li>
        /// <li> <p> <code>Product</code> </p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li> <p> <code>Portfolio</code> </p> </li>
        /// <li> <p> <code>Product</code> </p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesForTagOptionInput`](crate::input::ListResourcesForTagOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourcesForTagOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourcesForTagOptionInput {
                tag_option_id: self.tag_option_id,
                resource_type: self.resource_type,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourcesForTagOptionInputOperationOutputAlias =
    crate::operation::ListResourcesForTagOption;
#[doc(hidden)]
pub type ListResourcesForTagOptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourcesForTagOptionInput {
    /// Consumes the builder and constructs an Operation<[`ListResourcesForTagOption`](crate::operation::ListResourcesForTagOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourcesForTagOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourcesForTagOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourcesForTagOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourcesForTagOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListResourcesForTagOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resources_for_tag_option(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourcesForTagOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourcesForTagOption",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourcesForTagOptionInput`](crate::input::ListResourcesForTagOptionInput)
    pub fn builder() -> crate::input::list_resources_for_tag_option_input::Builder {
        crate::input::list_resources_for_tag_option_input::Builder::default()
    }
}

/// See [`ListServiceActionsInput`](crate::input::ListServiceActionsInput)
pub mod list_service_actions_input {
    /// A builder for [`ListServiceActionsInput`](crate::input::ListServiceActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceActionsInput`](crate::input::ListServiceActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceActionsInput {
                accept_language: self.accept_language,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceActionsInputOperationOutputAlias = crate::operation::ListServiceActions;
#[doc(hidden)]
pub type ListServiceActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListServiceActionsInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceActions`](crate::operation::ListServiceActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListServiceActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_actions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceActions",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceActionsInput`](crate::input::ListServiceActionsInput)
    pub fn builder() -> crate::input::list_service_actions_input::Builder {
        crate::input::list_service_actions_input::Builder::default()
    }
}

/// See [`ListServiceActionsForProvisioningArtifactInput`](crate::input::ListServiceActionsForProvisioningArtifactInput)
pub mod list_service_actions_for_provisioning_artifact_input {
    /// A builder for [`ListServiceActionsForProvisioningArtifactInput`](crate::input::ListServiceActionsForProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceActionsForProvisioningArtifactInput`](crate::input::ListServiceActionsForProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceActionsForProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListServiceActionsForProvisioningArtifactInput {
                    product_id: self.product_id,
                    provisioning_artifact_id: self.provisioning_artifact_id,
                    page_size: self.page_size.unwrap_or_default(),
                    page_token: self.page_token,
                    accept_language: self.accept_language,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListServiceActionsForProvisioningArtifactInputOperationOutputAlias =
    crate::operation::ListServiceActionsForProvisioningArtifact;
#[doc(hidden)]
pub type ListServiceActionsForProvisioningArtifactInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListServiceActionsForProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceActionsForProvisioningArtifact`](crate::operation::ListServiceActionsForProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceActionsForProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceActionsForProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceActionsForProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceActionsForProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListServiceActionsForProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_actions_for_provisioning_artifact(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceActionsForProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceActionsForProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceActionsForProvisioningArtifactInput`](crate::input::ListServiceActionsForProvisioningArtifactInput)
    pub fn builder() -> crate::input::list_service_actions_for_provisioning_artifact_input::Builder
    {
        crate::input::list_service_actions_for_provisioning_artifact_input::Builder::default()
    }
}

/// See [`ListStackInstancesForProvisionedProductInput`](crate::input::ListStackInstancesForProvisionedProductInput)
pub mod list_stack_instances_for_provisioned_product_input {
    /// A builder for [`ListStackInstancesForProvisionedProductInput`](crate::input::ListStackInstancesForProvisionedProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackInstancesForProvisionedProductInput`](crate::input::ListStackInstancesForProvisionedProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStackInstancesForProvisionedProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStackInstancesForProvisionedProductInput {
                accept_language: self.accept_language,
                provisioned_product_id: self.provisioned_product_id,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListStackInstancesForProvisionedProductInputOperationOutputAlias =
    crate::operation::ListStackInstancesForProvisionedProduct;
#[doc(hidden)]
pub type ListStackInstancesForProvisionedProductInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListStackInstancesForProvisionedProductInput {
    /// Consumes the builder and constructs an Operation<[`ListStackInstancesForProvisionedProduct`](crate::operation::ListStackInstancesForProvisionedProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStackInstancesForProvisionedProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStackInstancesForProvisionedProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStackInstancesForProvisionedProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStackInstancesForProvisionedProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListStackInstancesForProvisionedProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_stack_instances_for_provisioned_product(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStackInstancesForProvisionedProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStackInstancesForProvisionedProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStackInstancesForProvisionedProductInput`](crate::input::ListStackInstancesForProvisionedProductInput)
    pub fn builder() -> crate::input::list_stack_instances_for_provisioned_product_input::Builder {
        crate::input::list_stack_instances_for_provisioned_product_input::Builder::default()
    }
}

/// See [`ListTagOptionsInput`](crate::input::ListTagOptionsInput)
pub mod list_tag_options_input {
    /// A builder for [`ListTagOptionsInput`](crate::input::ListTagOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::ListTagOptionsFilters>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn filters(mut self, input: crate::model::ListTagOptionsFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListTagOptionsFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagOptionsInput`](crate::input::ListTagOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagOptionsInput {
                filters: self.filters,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagOptionsInputOperationOutputAlias = crate::operation::ListTagOptions;
#[doc(hidden)]
pub type ListTagOptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagOptionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTagOptions`](crate::operation::ListTagOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ListTagOptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tag_options(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagOptions",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagOptionsInput`](crate::input::ListTagOptionsInput)
    pub fn builder() -> crate::input::list_tag_options_input::Builder {
        crate::input::list_tag_options_input::Builder::default()
    }
}

/// See [`ProvisionProductInput`](crate::input::ProvisionProductInput)
pub mod provision_product_input {
    /// A builder for [`ProvisionProductInput`](crate::input::ProvisionProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_name: std::option::Option<std::string::String>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) path_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        pub(crate) provisioning_preferences:
            std::option::Option<crate::model::ProvisioningPreferences>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) notification_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) provision_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_name = input;
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_name = Some(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_name = input;
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::ProvisioningParameter,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input);
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            input: crate::model::ProvisioningPreferences,
        ) -> Self {
            self.provisioning_preferences = Some(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::ProvisioningPreferences>,
        ) -> Self {
            self.provisioning_preferences = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `notification_arns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_arns.unwrap_or_default();
            v.push(input.into());
            self.notification_arns = Some(v);
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_arns = input;
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn provision_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_token = Some(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn set_provision_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionProductInput`](crate::input::ProvisionProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ProvisionProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ProvisionProductInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                product_name: self.product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_artifact_name: self.provisioning_artifact_name,
                path_id: self.path_id,
                path_name: self.path_name,
                provisioned_product_name: self.provisioned_product_name,
                provisioning_parameters: self.provisioning_parameters,
                provisioning_preferences: self.provisioning_preferences,
                tags: self.tags,
                notification_arns: self.notification_arns,
                provision_token: self.provision_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ProvisionProductInputOperationOutputAlias = crate::operation::ProvisionProduct;
#[doc(hidden)]
pub type ProvisionProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ProvisionProductInput {
    /// Consumes the builder and constructs an Operation<[`ProvisionProduct`](crate::operation::ProvisionProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ProvisionProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ProvisionProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ProvisionProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ProvisionProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ProvisionProduct",
            );
            Ok(builder)
        }
        if self.provision_token.is_none() {
            self.provision_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_provision_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ProvisionProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ProvisionProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ProvisionProductInput`](crate::input::ProvisionProductInput)
    pub fn builder() -> crate::input::provision_product_input::Builder {
        crate::input::provision_product_input::Builder::default()
    }
}

/// See [`RejectPortfolioShareInput`](crate::input::RejectPortfolioShareInput)
pub mod reject_portfolio_share_input {
    /// A builder for [`RejectPortfolioShareInput`](crate::input::RejectPortfolioShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) portfolio_share_type: std::option::Option<crate::model::PortfolioShareType>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn portfolio_share_type(mut self, input: crate::model::PortfolioShareType) -> Self {
            self.portfolio_share_type = Some(input);
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
        /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
        /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.portfolio_share_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectPortfolioShareInput`](crate::input::RejectPortfolioShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectPortfolioShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectPortfolioShareInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                portfolio_share_type: self.portfolio_share_type,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectPortfolioShareInputOperationOutputAlias = crate::operation::RejectPortfolioShare;
#[doc(hidden)]
pub type RejectPortfolioShareInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RejectPortfolioShareInput {
    /// Consumes the builder and constructs an Operation<[`RejectPortfolioShare`](crate::operation::RejectPortfolioShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectPortfolioShare,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectPortfolioShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectPortfolioShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectPortfolioShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.RejectPortfolioShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_portfolio_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectPortfolioShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectPortfolioShare",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectPortfolioShareInput`](crate::input::RejectPortfolioShareInput)
    pub fn builder() -> crate::input::reject_portfolio_share_input::Builder {
        crate::input::reject_portfolio_share_input::Builder::default()
    }
}

/// See [`ScanProvisionedProductsInput`](crate::input::ScanProvisionedProductsInput)
pub mod scan_provisioned_products_input {
    /// A builder for [`ScanProvisionedProductsInput`](crate::input::ScanProvisionedProductsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.access_level_filter = Some(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.access_level_filter = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanProvisionedProductsInput`](crate::input::ScanProvisionedProductsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ScanProvisionedProductsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ScanProvisionedProductsInput {
                accept_language: self.accept_language,
                access_level_filter: self.access_level_filter,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ScanProvisionedProductsInputOperationOutputAlias =
    crate::operation::ScanProvisionedProducts;
#[doc(hidden)]
pub type ScanProvisionedProductsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ScanProvisionedProductsInput {
    /// Consumes the builder and constructs an Operation<[`ScanProvisionedProducts`](crate::operation::ScanProvisionedProducts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ScanProvisionedProducts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ScanProvisionedProductsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ScanProvisionedProductsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ScanProvisionedProductsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.ScanProvisionedProducts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_scan_provisioned_products(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ScanProvisionedProducts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ScanProvisionedProducts",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ScanProvisionedProductsInput`](crate::input::ScanProvisionedProductsInput)
    pub fn builder() -> crate::input::scan_provisioned_products_input::Builder {
        crate::input::scan_provisioned_products_input::Builder::default()
    }
}

/// See [`SearchProductsInput`](crate::input::SearchProductsInput)
pub mod search_products_input {
    /// A builder for [`SearchProductsInput`](crate::input::SearchProductsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<
            std::collections::HashMap<
                crate::model::ProductViewFilterBy,
                std::vec::Vec<std::string::String>,
            >,
        >,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) sort_by: std::option::Option<crate::model::ProductViewSortBy>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Adds a key-value pair to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
        pub fn filters(
            mut self,
            k: crate::model::ProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filters.unwrap_or_default();
            hash_map.insert(k, v);
            self.filters = Some(hash_map);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, input: crate::model::ProductViewSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProductsInput`](crate::input::SearchProductsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchProductsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchProductsInput {
                accept_language: self.accept_language,
                filters: self.filters,
                page_size: self.page_size.unwrap_or_default(),
                sort_by: self.sort_by,
                sort_order: self.sort_order,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchProductsInputOperationOutputAlias = crate::operation::SearchProducts;
#[doc(hidden)]
pub type SearchProductsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchProductsInput {
    /// Consumes the builder and constructs an Operation<[`SearchProducts`](crate::operation::SearchProducts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchProducts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchProductsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchProductsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchProductsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.SearchProducts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_products(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchProducts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchProducts",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchProductsInput`](crate::input::SearchProductsInput)
    pub fn builder() -> crate::input::search_products_input::Builder {
        crate::input::search_products_input::Builder::default()
    }
}

/// See [`SearchProductsAsAdminInput`](crate::input::SearchProductsAsAdminInput)
pub mod search_products_as_admin_input {
    /// A builder for [`SearchProductsAsAdminInput`](crate::input::SearchProductsAsAdminInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<
            std::collections::HashMap<
                crate::model::ProductViewFilterBy,
                std::vec::Vec<std::string::String>,
            >,
        >,
        pub(crate) sort_by: std::option::Option<crate::model::ProductViewSortBy>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) product_source: std::option::Option<crate::model::ProductSource>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// Adds a key-value pair to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
        pub fn filters(
            mut self,
            k: crate::model::ProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filters.unwrap_or_default();
            hash_map.insert(k, v);
            self.filters = Some(hash_map);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, input: crate::model::ProductViewSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn product_source(mut self, input: crate::model::ProductSource) -> Self {
            self.product_source = Some(input);
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn set_product_source(
            mut self,
            input: std::option::Option<crate::model::ProductSource>,
        ) -> Self {
            self.product_source = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProductsAsAdminInput`](crate::input::SearchProductsAsAdminInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchProductsAsAdminInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchProductsAsAdminInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                filters: self.filters,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
                page_token: self.page_token,
                page_size: self.page_size.unwrap_or_default(),
                product_source: self.product_source,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchProductsAsAdminInputOperationOutputAlias = crate::operation::SearchProductsAsAdmin;
#[doc(hidden)]
pub type SearchProductsAsAdminInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchProductsAsAdminInput {
    /// Consumes the builder and constructs an Operation<[`SearchProductsAsAdmin`](crate::operation::SearchProductsAsAdmin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchProductsAsAdmin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchProductsAsAdminInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchProductsAsAdminInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchProductsAsAdminInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.SearchProductsAsAdmin",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_products_as_admin(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchProductsAsAdmin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchProductsAsAdmin",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchProductsAsAdminInput`](crate::input::SearchProductsAsAdminInput)
    pub fn builder() -> crate::input::search_products_as_admin_input::Builder {
        crate::input::search_products_as_admin_input::Builder::default()
    }
}

/// See [`SearchProvisionedProductsInput`](crate::input::SearchProvisionedProductsInput)
pub mod search_provisioned_products_input {
    /// A builder for [`SearchProvisionedProductsInput`](crate::input::SearchProvisionedProductsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
        pub(crate) filters: std::option::Option<
            std::collections::HashMap<
                crate::model::ProvisionedProductViewFilterBy,
                std::vec::Vec<std::string::String>,
            >,
        >,
        pub(crate) sort_by: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, input: crate::model::AccessLevelFilter) -> Self {
            self.access_level_filter = Some(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.access_level_filter = input;
            self
        }
        /// Adds a key-value pair to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
        pub fn filters(
            mut self,
            k: crate::model::ProvisionedProductViewFilterBy,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.filters.unwrap_or_default();
            hash_map.insert(k, v);
            self.filters = Some(hash_map);
            self
        }
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProvisionedProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_by = Some(input.into());
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProvisionedProductsInput`](crate::input::SearchProvisionedProductsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchProvisionedProductsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchProvisionedProductsInput {
                accept_language: self.accept_language,
                access_level_filter: self.access_level_filter,
                filters: self.filters,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
                page_size: self.page_size.unwrap_or_default(),
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchProvisionedProductsInputOperationOutputAlias =
    crate::operation::SearchProvisionedProducts;
#[doc(hidden)]
pub type SearchProvisionedProductsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchProvisionedProductsInput {
    /// Consumes the builder and constructs an Operation<[`SearchProvisionedProducts`](crate::operation::SearchProvisionedProducts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchProvisionedProducts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchProvisionedProductsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchProvisionedProductsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchProvisionedProductsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.SearchProvisionedProducts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_provisioned_products(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchProvisionedProducts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchProvisionedProducts",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchProvisionedProductsInput`](crate::input::SearchProvisionedProductsInput)
    pub fn builder() -> crate::input::search_provisioned_products_input::Builder {
        crate::input::search_provisioned_products_input::Builder::default()
    }
}

/// See [`TerminateProvisionedProductInput`](crate::input::TerminateProvisionedProductInput)
pub mod terminate_provisioned_product_input {
    /// A builder for [`TerminateProvisionedProductInput`](crate::input::TerminateProvisionedProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) terminate_token: std::option::Option<std::string::String>,
        pub(crate) ignore_errors: std::option::Option<bool>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) retain_physical_resources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
        pub fn terminate_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.terminate_token = Some(input.into());
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
        pub fn set_terminate_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.terminate_token = input;
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, input: bool) -> Self {
            self.ignore_errors = Some(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_errors = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
        pub fn retain_physical_resources(mut self, input: bool) -> Self {
            self.retain_physical_resources = Some(input);
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
        pub fn set_retain_physical_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.retain_physical_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateProvisionedProductInput`](crate::input::TerminateProvisionedProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateProvisionedProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateProvisionedProductInput {
                provisioned_product_name: self.provisioned_product_name,
                provisioned_product_id: self.provisioned_product_id,
                terminate_token: self.terminate_token,
                ignore_errors: self.ignore_errors.unwrap_or_default(),
                accept_language: self.accept_language,
                retain_physical_resources: self.retain_physical_resources.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateProvisionedProductInputOperationOutputAlias =
    crate::operation::TerminateProvisionedProduct;
#[doc(hidden)]
pub type TerminateProvisionedProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TerminateProvisionedProductInput {
    /// Consumes the builder and constructs an Operation<[`TerminateProvisionedProduct`](crate::operation::TerminateProvisionedProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateProvisionedProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateProvisionedProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateProvisionedProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateProvisionedProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.TerminateProvisionedProduct",
            );
            Ok(builder)
        }
        if self.terminate_token.is_none() {
            self.terminate_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_terminate_provisioned_product(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateProvisionedProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateProvisionedProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateProvisionedProductInput`](crate::input::TerminateProvisionedProductInput)
    pub fn builder() -> crate::input::terminate_provisioned_product_input::Builder {
        crate::input::terminate_provisioned_product_input::Builder::default()
    }
}

/// See [`UpdateConstraintInput`](crate::input::UpdateConstraintInput)
pub mod update_constraint_input {
    /// A builder for [`UpdateConstraintInput`](crate::input::UpdateConstraintInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>
        /// LAUNCH
        /// </dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>
        /// NOTIFICATION
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
        /// </dd>
        /// <dt>
        /// RESOURCE_UPDATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>
        /// STACKSET
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>
        /// TEMPLATE
        /// </dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConstraintInput`](crate::input::UpdateConstraintInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConstraintInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConstraintInput {
                accept_language: self.accept_language,
                id: self.id,
                description: self.description,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConstraintInputOperationOutputAlias = crate::operation::UpdateConstraint;
#[doc(hidden)]
pub type UpdateConstraintInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConstraintInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConstraint`](crate::operation::UpdateConstraint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConstraint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConstraintInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConstraintInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConstraintInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateConstraint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_constraint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConstraint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConstraint",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConstraintInput`](crate::input::UpdateConstraintInput)
    pub fn builder() -> crate::input::update_constraint_input::Builder {
        crate::input::update_constraint_input::Builder::default()
    }
}

/// See [`UpdatePortfolioInput`](crate::input::UpdatePortfolioInput)
pub mod update_portfolio_input {
    /// A builder for [`UpdatePortfolioInput`](crate::input::UpdatePortfolioInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) remove_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Appends an item to `add_tags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.add_tags.unwrap_or_default();
            v.push(input);
            self.add_tags = Some(v);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.add_tags = input;
            self
        }
        /// Appends an item to `remove_tags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove.</p>
        pub fn remove_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_tags.unwrap_or_default();
            v.push(input.into());
            self.remove_tags = Some(v);
            self
        }
        /// <p>The tags to remove.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortfolioInput`](crate::input::UpdatePortfolioInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePortfolioInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePortfolioInput {
                accept_language: self.accept_language,
                id: self.id,
                display_name: self.display_name,
                description: self.description,
                provider_name: self.provider_name,
                add_tags: self.add_tags,
                remove_tags: self.remove_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePortfolioInputOperationOutputAlias = crate::operation::UpdatePortfolio;
#[doc(hidden)]
pub type UpdatePortfolioInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePortfolioInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePortfolio`](crate::operation::UpdatePortfolio)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePortfolio,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePortfolioInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePortfolioInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePortfolioInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdatePortfolio",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_portfolio(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePortfolio::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePortfolio",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioInput`](crate::input::UpdatePortfolioInput)
    pub fn builder() -> crate::input::update_portfolio_input::Builder {
        crate::input::update_portfolio_input::Builder::default()
    }
}

/// See [`UpdatePortfolioShareInput`](crate::input::UpdatePortfolioShareInput)
pub mod update_portfolio_share_input {
    /// A builder for [`UpdatePortfolioShareInput`](crate::input::UpdatePortfolioShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) organization_node: std::option::Option<crate::model::OrganizationNode>,
        pub(crate) share_tag_options: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn organization_node(mut self, input: crate::model::OrganizationNode) -> Self {
            self.organization_node = Some(input);
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.organization_node = input;
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn share_tag_options(mut self, input: bool) -> Self {
            self.share_tag_options = Some(input);
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.share_tag_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortfolioShareInput`](crate::input::UpdatePortfolioShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePortfolioShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePortfolioShareInput {
                accept_language: self.accept_language,
                portfolio_id: self.portfolio_id,
                account_id: self.account_id,
                organization_node: self.organization_node,
                share_tag_options: self.share_tag_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePortfolioShareInputOperationOutputAlias = crate::operation::UpdatePortfolioShare;
#[doc(hidden)]
pub type UpdatePortfolioShareInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePortfolioShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePortfolioShare`](crate::operation::UpdatePortfolioShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePortfolioShare,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePortfolioShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePortfolioShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePortfolioShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdatePortfolioShare",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_portfolio_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePortfolioShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePortfolioShare",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioShareInput`](crate::input::UpdatePortfolioShareInput)
    pub fn builder() -> crate::input::update_portfolio_share_input::Builder {
        crate::input::update_portfolio_share_input::Builder::default()
    }
}

/// See [`UpdateProductInput`](crate::input::UpdateProductInput)
pub mod update_product_input {
    /// A builder for [`UpdateProductInput`](crate::input::UpdateProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) distributor: std::option::Option<std::string::String>,
        pub(crate) support_description: std::option::Option<std::string::String>,
        pub(crate) support_email: std::option::Option<std::string::String>,
        pub(crate) support_url: std::option::Option<std::string::String>,
        pub(crate) add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) remove_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The updated product name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn distributor(mut self, input: impl Into<std::string::String>) -> Self {
            self.distributor = Some(input.into());
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.distributor = input;
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn support_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_description = Some(input.into());
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_description = input;
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn support_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_email = Some(input.into());
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_email = input;
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn support_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_url = Some(input.into());
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_url = input;
            self
        }
        /// Appends an item to `add_tags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add to the product.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.add_tags.unwrap_or_default();
            v.push(input);
            self.add_tags = Some(v);
            self
        }
        /// <p>The tags to add to the product.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.add_tags = input;
            self
        }
        /// Appends an item to `remove_tags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove from the product.</p>
        pub fn remove_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_tags.unwrap_or_default();
            v.push(input.into());
            self.remove_tags = Some(v);
            self
        }
        /// <p>The tags to remove from the product.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProductInput`](crate::input::UpdateProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProductInput {
                accept_language: self.accept_language,
                id: self.id,
                name: self.name,
                owner: self.owner,
                description: self.description,
                distributor: self.distributor,
                support_description: self.support_description,
                support_email: self.support_email,
                support_url: self.support_url,
                add_tags: self.add_tags,
                remove_tags: self.remove_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProductInputOperationOutputAlias = crate::operation::UpdateProduct;
#[doc(hidden)]
pub type UpdateProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProductInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProduct`](crate::operation::UpdateProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateProduct",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_product(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProductInput`](crate::input::UpdateProductInput)
    pub fn builder() -> crate::input::update_product_input::Builder {
        crate::input::update_product_input::Builder::default()
    }
}

/// See [`UpdateProvisionedProductInput`](crate::input::UpdateProvisionedProductInput)
pub mod update_provisioned_product_input {
    /// A builder for [`UpdateProvisionedProductInput`](crate::input::UpdateProvisionedProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_name: std::option::Option<std::string::String>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) path_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        pub(crate) provisioning_preferences:
            std::option::Option<crate::model::UpdateProvisioningPreferences>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) update_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_name = input;
            self
        }
        /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_name = Some(input.into());
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_name = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>The new parameters.</p>
        pub fn provisioning_parameters(
            mut self,
            input: crate::model::UpdateProvisioningParameter,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input);
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>The new parameters.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            input: crate::model::UpdateProvisioningPreferences,
        ) -> Self {
            self.provisioning_preferences = Some(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::UpdateProvisioningPreferences>,
        ) -> Self {
            self.provisioning_preferences = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn update_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_token = Some(input.into());
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.update_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisionedProductInput`](crate::input::UpdateProvisionedProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProvisionedProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProvisionedProductInput {
                accept_language: self.accept_language,
                provisioned_product_name: self.provisioned_product_name,
                provisioned_product_id: self.provisioned_product_id,
                product_id: self.product_id,
                product_name: self.product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_artifact_name: self.provisioning_artifact_name,
                path_id: self.path_id,
                path_name: self.path_name,
                provisioning_parameters: self.provisioning_parameters,
                provisioning_preferences: self.provisioning_preferences,
                tags: self.tags,
                update_token: self.update_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProvisionedProductInputOperationOutputAlias =
    crate::operation::UpdateProvisionedProduct;
#[doc(hidden)]
pub type UpdateProvisionedProductInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProvisionedProductInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProvisionedProduct`](crate::operation::UpdateProvisionedProduct)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProvisionedProduct,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProvisionedProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProvisionedProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProvisionedProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateProvisionedProduct",
            );
            Ok(builder)
        }
        if self.update_token.is_none() {
            self.update_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_provisioned_product(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProvisionedProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProvisionedProduct",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductInput`](crate::input::UpdateProvisionedProductInput)
    pub fn builder() -> crate::input::update_provisioned_product_input::Builder {
        crate::input::update_provisioned_product_input::Builder::default()
    }
}

/// See [`UpdateProvisionedProductPropertiesInput`](crate::input::UpdateProvisionedProductPropertiesInput)
pub mod update_provisioned_product_properties_input {
    /// A builder for [`UpdateProvisionedProductPropertiesInput`](crate::input::UpdateProvisionedProductPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_properties: std::option::Option<
            std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
        >,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// Adds a key-value pair to `provisioned_product_properties`.
        ///
        /// To override the contents of this collection use [`set_provisioned_product_properties`](Self::set_provisioned_product_properties).
        ///
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
        pub fn provisioned_product_properties(
            mut self,
            k: crate::model::PropertyKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provisioned_product_properties.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.provisioned_product_properties = Some(hash_map);
            self
        }
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
        pub fn set_provisioned_product_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.provisioned_product_properties = input;
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisionedProductPropertiesInput`](crate::input::UpdateProvisionedProductPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProvisionedProductPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProvisionedProductPropertiesInput {
                accept_language: self.accept_language,
                provisioned_product_id: self.provisioned_product_id,
                provisioned_product_properties: self.provisioned_product_properties,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProvisionedProductPropertiesInputOperationOutputAlias =
    crate::operation::UpdateProvisionedProductProperties;
#[doc(hidden)]
pub type UpdateProvisionedProductPropertiesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProvisionedProductPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProvisionedProductProperties`](crate::operation::UpdateProvisionedProductProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProvisionedProductProperties,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProvisionedProductPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProvisionedProductPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProvisionedProductPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateProvisionedProductProperties",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_provisioned_product_properties(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProvisionedProductProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProvisionedProductProperties",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductPropertiesInput`](crate::input::UpdateProvisionedProductPropertiesInput)
    pub fn builder() -> crate::input::update_provisioned_product_properties_input::Builder {
        crate::input::update_provisioned_product_properties_input::Builder::default()
    }
}

/// See [`UpdateProvisioningArtifactInput`](crate::input::UpdateProvisioningArtifactInput)
pub mod update_provisioning_artifact_input {
    /// A builder for [`UpdateProvisioningArtifactInput`](crate::input::UpdateProvisioningArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_language: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) active: std::option::Option<bool>,
        pub(crate) guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
    }
    impl Builder {
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn guidance(mut self, input: crate::model::ProvisioningArtifactGuidance) -> Self {
            self.guidance = Some(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn set_guidance(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
        ) -> Self {
            self.guidance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisioningArtifactInput`](crate::input::UpdateProvisioningArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProvisioningArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProvisioningArtifactInput {
                accept_language: self.accept_language,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                name: self.name,
                description: self.description,
                active: self.active,
                guidance: self.guidance,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProvisioningArtifactInputOperationOutputAlias =
    crate::operation::UpdateProvisioningArtifact;
#[doc(hidden)]
pub type UpdateProvisioningArtifactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProvisioningArtifactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProvisioningArtifact`](crate::operation::UpdateProvisioningArtifact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProvisioningArtifact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProvisioningArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProvisioningArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProvisioningArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateProvisioningArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_provisioning_artifact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProvisioningArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProvisioningArtifact",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningArtifactInput`](crate::input::UpdateProvisioningArtifactInput)
    pub fn builder() -> crate::input::update_provisioning_artifact_input::Builder {
        crate::input::update_provisioning_artifact_input::Builder::default()
    }
}

/// See [`UpdateServiceActionInput`](crate::input::UpdateServiceActionInput)
pub mod update_service_action_input {
    /// A builder for [`UpdateServiceActionInput`](crate::input::UpdateServiceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<
            std::collections::HashMap<
                crate::model::ServiceActionDefinitionKey,
                std::string::String,
            >,
        >,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) accept_language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>A map that defines the self-service action.</p>
        pub fn definition(
            mut self,
            k: crate::model::ServiceActionDefinitionKey,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.definition.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.definition = Some(hash_map);
            self
        }
        /// <p>A map that defines the self-service action.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn accept_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_language = Some(input.into());
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li> <p> <code>en</code> - English (default)</p> </li>
        /// <li> <p> <code>jp</code> - Japanese</p> </li>
        /// <li> <p> <code>zh</code> - Chinese</p> </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_language = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceActionInput`](crate::input::UpdateServiceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceActionInput {
                id: self.id,
                name: self.name,
                definition: self.definition,
                description: self.description,
                accept_language: self.accept_language,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceActionInputOperationOutputAlias = crate::operation::UpdateServiceAction;
#[doc(hidden)]
pub type UpdateServiceActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateServiceActionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceAction`](crate::operation::UpdateServiceAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateServiceAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceAction",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceActionInput`](crate::input::UpdateServiceActionInput)
    pub fn builder() -> crate::input::update_service_action_input::Builder {
        crate::input::update_service_action_input::Builder::default()
    }
}

/// See [`UpdateTagOptionInput`](crate::input::UpdateTagOptionInput)
pub mod update_tag_option_input {
    /// A builder for [`UpdateTagOptionInput`](crate::input::UpdateTagOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The updated value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The updated value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The updated active state.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>The updated active state.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTagOptionInput`](crate::input::UpdateTagOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTagOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTagOptionInput {
                id: self.id,
                value: self.value,
                active: self.active,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTagOptionInputOperationOutputAlias = crate::operation::UpdateTagOption;
#[doc(hidden)]
pub type UpdateTagOptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTagOptionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTagOption`](crate::operation::UpdateTagOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTagOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTagOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTagOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTagOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWS242ServiceCatalogService.UpdateTagOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_tag_option(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTagOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTagOption",
            "servicecatalog",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTagOptionInput`](crate::input::UpdateTagOptionInput)
    pub fn builder() -> crate::input::update_tag_option_input::Builder {
        crate::input::update_tag_option_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The updated value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The updated active state.</p>
    pub active: std::option::Option<bool>,
}
impl UpdateTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The updated value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The updated active state.</p>
    pub fn active(&self) -> std::option::Option<bool> {
        self.active
    }
}
impl std::fmt::Debug for UpdateTagOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagOptionInput");
        formatter.field("id", &self.id);
        formatter.field("value", &self.value);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceActionInput {
    /// <p>The self-service action identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The self-service action name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map that defines the self-service action.</p>
    pub definition: std::option::Option<
        std::collections::HashMap<crate::model::ServiceActionDefinitionKey, std::string::String>,
    >,
    /// <p>The self-service action description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl UpdateServiceActionInput {
    /// <p>The self-service action identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The self-service action name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A map that defines the self-service action.</p>
    pub fn definition(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::ServiceActionDefinitionKey, std::string::String>,
    > {
        self.definition.as_ref()
    }
    /// <p>The self-service action description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for UpdateServiceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceActionInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("definition", &self.definition);
        formatter.field("description", &self.description);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisioningArtifactInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The updated name of the provisioning artifact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description of the provisioning artifact.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether the product version is active.</p>
    /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
    pub active: std::option::Option<bool>,
    /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
    /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
    /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
    pub guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
}
impl UpdateProvisioningArtifactInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The identifier of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The updated name of the provisioning artifact.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated description of the provisioning artifact.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether the product version is active.</p>
    /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
    pub fn active(&self) -> std::option::Option<bool> {
        self.active
    }
    /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
    /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
    /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
    pub fn guidance(&self) -> std::option::Option<&crate::model::ProvisioningArtifactGuidance> {
        self.guidance.as_ref()
    }
}
impl std::fmt::Debug for UpdateProvisioningArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisioningArtifactInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("active", &self.active);
        formatter.field("guidance", &self.guidance);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisionedProductPropertiesInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>A map that contains the provisioned product properties to be updated.</p>
    /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
    /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
    /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
    /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
    pub provisioned_product_properties: std::option::Option<
        std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
    >,
    /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl UpdateProvisionedProductPropertiesInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The identifier of the provisioned product.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>A map that contains the provisioned product properties to be updated.</p>
    /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as <code>UpdateProvisionedProduct</code>, <code>TerminateProvisionedProduct</code>, or <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
    /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.</p>
    /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
    /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.</p>
    pub fn provisioned_product_properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
    > {
        self.provisioned_product_properties.as_ref()
    }
    /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateProvisionedProductPropertiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisionedProductPropertiesInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field(
            "provisioned_product_properties",
            &self.provisioned_product_properties,
        );
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub provisioning_artifact_name: std::option::Option<std::string::String>,
    /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub path_name: std::option::Option<std::string::String>,
    /// <p>The new parameters.</p>
    pub provisioning_parameters:
        std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
    /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
    pub provisioning_preferences: std::option::Option<crate::model::UpdateProvisioningPreferences>,
    /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
    pub update_token: std::option::Option<std::string::String>,
}
impl UpdateProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub fn provisioned_product_name(&self) -> std::option::Option<&str> {
        self.provisioned_product_name.as_deref()
    }
    /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>The identifier of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub fn provisioning_artifact_name(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_name.as_deref()
    }
    /// <p>The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
    pub fn path_id(&self) -> std::option::Option<&str> {
        self.path_id.as_deref()
    }
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub fn path_name(&self) -> std::option::Option<&str> {
        self.path_name.as_deref()
    }
    /// <p>The new parameters.</p>
    pub fn provisioning_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::UpdateProvisioningParameter]> {
        self.provisioning_parameters.as_deref()
    }
    /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
    pub fn provisioning_preferences(
        &self,
    ) -> std::option::Option<&crate::model::UpdateProvisioningPreferences> {
        self.provisioning_preferences.as_ref()
    }
    /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
    pub fn update_token(&self) -> std::option::Option<&str> {
        self.update_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateProvisionedProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisionedProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("product_name", &self.product_name);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field(
            "provisioning_artifact_name",
            &self.provisioning_artifact_name,
        );
        formatter.field("path_id", &self.path_id);
        formatter.field("path_name", &self.path_name);
        formatter.field("provisioning_parameters", &self.provisioning_parameters);
        formatter.field("provisioning_preferences", &self.provisioning_preferences);
        formatter.field("tags", &self.tags);
        formatter.field("update_token", &self.update_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The updated product name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated owner of the product.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The updated description of the product.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated distributor of the product.</p>
    pub distributor: std::option::Option<std::string::String>,
    /// <p>The updated support description for the product.</p>
    pub support_description: std::option::Option<std::string::String>,
    /// <p>The updated support email for the product.</p>
    pub support_email: std::option::Option<std::string::String>,
    /// <p>The updated support URL for the product.</p>
    pub support_url: std::option::Option<std::string::String>,
    /// <p>The tags to add to the product.</p>
    pub add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The tags to remove from the product.</p>
    pub remove_tags: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The updated product name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated owner of the product.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The updated description of the product.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated distributor of the product.</p>
    pub fn distributor(&self) -> std::option::Option<&str> {
        self.distributor.as_deref()
    }
    /// <p>The updated support description for the product.</p>
    pub fn support_description(&self) -> std::option::Option<&str> {
        self.support_description.as_deref()
    }
    /// <p>The updated support email for the product.</p>
    pub fn support_email(&self) -> std::option::Option<&str> {
        self.support_email.as_deref()
    }
    /// <p>The updated support URL for the product.</p>
    pub fn support_url(&self) -> std::option::Option<&str> {
        self.support_url.as_deref()
    }
    /// <p>The tags to add to the product.</p>
    pub fn add_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.add_tags.as_deref()
    }
    /// <p>The tags to remove from the product.</p>
    pub fn remove_tags(&self) -> std::option::Option<&[std::string::String]> {
        self.remove_tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("description", &self.description);
        formatter.field("distributor", &self.distributor);
        formatter.field("support_description", &self.support_description);
        formatter.field("support_email", &self.support_email);
        formatter.field("support_url", &self.support_url);
        formatter.field("add_tags", &self.add_tags);
        formatter.field("remove_tags", &self.remove_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortfolioShareInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Information about the organization node.</p>
    pub organization_node: std::option::Option<crate::model::OrganizationNode>,
    /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
    pub share_tag_options: std::option::Option<bool>,
}
impl UpdatePortfolioShareInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Information about the organization node.</p>
    pub fn organization_node(&self) -> std::option::Option<&crate::model::OrganizationNode> {
        self.organization_node.as_ref()
    }
    /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
    pub fn share_tag_options(&self) -> std::option::Option<bool> {
        self.share_tag_options
    }
}
impl std::fmt::Debug for UpdatePortfolioShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortfolioShareInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("organization_node", &self.organization_node);
        formatter.field("share_tag_options", &self.share_tag_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name to use for display purposes.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the portfolio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated name of the portfolio provider.</p>
    pub provider_name: std::option::Option<std::string::String>,
    /// <p>The tags to add.</p>
    pub add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The tags to remove.</p>
    pub remove_tags: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdatePortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name to use for display purposes.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The updated description of the portfolio.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated name of the portfolio provider.</p>
    pub fn provider_name(&self) -> std::option::Option<&str> {
        self.provider_name.as_deref()
    }
    /// <p>The tags to add.</p>
    pub fn add_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.add_tags.as_deref()
    }
    /// <p>The tags to remove.</p>
    pub fn remove_tags(&self) -> std::option::Option<&[std::string::String]> {
        self.remove_tags.as_deref()
    }
}
impl std::fmt::Debug for UpdatePortfolioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortfolioInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("provider_name", &self.provider_name);
        formatter.field("add_tags", &self.add_tags);
        formatter.field("remove_tags", &self.remove_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConstraintInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The identifier of the constraint.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The updated description of the constraint.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
    /// <dl>
    /// <dt>
    /// LAUNCH
    /// </dt>
    /// <dd>
    /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
    /// <p>Specify the <code>RoleArn</code> property as follows:</p>
    /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
    /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
    /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
    /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
    /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
    /// </note>
    /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
    /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
    /// </dd>
    /// <dt>
    /// NOTIFICATION
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
    /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
    /// </dd>
    /// <dt>
    /// RESOURCE_UPDATE
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
    /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
    /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
    /// </dd>
    /// <dt>
    /// STACKSET
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>Parameters</code> property as follows:</p>
    /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
    /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
    /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
    /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
    /// </dd>
    /// <dt>
    /// TEMPLATE
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
    /// </dd>
    /// </dl>
    pub parameters: std::option::Option<std::string::String>,
}
impl UpdateConstraintInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The identifier of the constraint.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The updated description of the constraint.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
    /// <dl>
    /// <dt>
    /// LAUNCH
    /// </dt>
    /// <dd>
    /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
    /// <p>Specify the <code>RoleArn</code> property as follows:</p>
    /// <p> <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code> </p>
    /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
    /// <p> <code>{"LocalRoleName": "SCBasicLaunchRole"}</code> </p>
    /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.</p> <note>
    /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
    /// </note>
    /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
    /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
    /// </dd>
    /// <dt>
    /// NOTIFICATION
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
    /// <p> <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code> </p>
    /// </dd>
    /// <dt>
    /// RESOURCE_UPDATE
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
    /// <p> <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code> </p>
    /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
    /// </dd>
    /// <dt>
    /// STACKSET
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>Parameters</code> property as follows:</p>
    /// <p> <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code> </p>
    /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
    /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
    /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
    /// </dd>
    /// <dt>
    /// TEMPLATE
    /// </dt>
    /// <dd>
    /// <p>Specify the <code>Rules</code> property. For more information, see <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
    /// </dd>
    /// </dl>
    pub fn parameters(&self) -> std::option::Option<&str> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for UpdateConstraintInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConstraintInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateProvisionedProductInput {
    /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
    pub terminate_token: std::option::Option<std::string::String>,
    /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
    pub ignore_errors: bool,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
    pub retain_physical_resources: bool,
}
impl TerminateProvisionedProductInput {
    /// <p>The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub fn provisioned_product_name(&self) -> std::option::Option<&str> {
        self.provisioned_product_name.as_deref()
    }
    /// <p>The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return <b>ResourceNotFound</b>.</p>
    pub fn terminate_token(&self) -> std::option::Option<&str> {
        self.terminate_token.as_deref()
    }
    /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.</p>
    pub fn ignore_errors(&self) -> bool {
        self.ignore_errors
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.</p>
    pub fn retain_physical_resources(&self) -> bool {
        self.retain_physical_resources
    }
}
impl std::fmt::Debug for TerminateProvisionedProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateProvisionedProductInput");
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("terminate_token", &self.terminate_token);
        formatter.field("ignore_errors", &self.ignore_errors);
        formatter.field("accept_language", &self.accept_language);
        formatter.field("retain_physical_resources", &self.retain_physical_resources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProvisionedProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
    /// <p>The search filters.</p>
    /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
    /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
    pub filters: std::option::Option<
        std::collections::HashMap<
            crate::model::ProvisionedProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    >,
    /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
    pub sort_by: std::option::Option<std::string::String>,
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl SearchProvisionedProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub fn access_level_filter(&self) -> std::option::Option<&crate::model::AccessLevelFilter> {
        self.access_level_filter.as_ref()
    }
    /// <p>The search filters.</p>
    /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>, <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>, <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>, <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>, <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>, <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
    /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code> </p>
    pub fn filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::ProvisionedProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.filters.as_ref()
    }
    /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>, and <code>lastRecordId</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&str> {
        self.sort_by.as_deref()
    }
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for SearchProvisionedProductsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProvisionedProductsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("access_level_filter", &self.access_level_filter);
        formatter.field("filters", &self.filters);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProductsAsAdminInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
    pub filters: std::option::Option<
        std::collections::HashMap<
            crate::model::ProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    >,
    /// <p>The sort field. If no value is specified, the results are not sorted.</p>
    pub sort_by: std::option::Option<crate::model::ProductViewSortBy>,
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>Access level of the source of the product.</p>
    pub product_source: std::option::Option<crate::model::ProductSource>,
}
impl SearchProductsAsAdminInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The search filters. If no search filters are specified, the output includes all products to which the administrator has access.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::ProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.filters.as_ref()
    }
    /// <p>The sort field. If no value is specified, the results are not sorted.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ProductViewSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>Access level of the source of the product.</p>
    pub fn product_source(&self) -> std::option::Option<&crate::model::ProductSource> {
        self.product_source.as_ref()
    }
}
impl std::fmt::Debug for SearchProductsAsAdminInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProductsAsAdminInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("filters", &self.filters);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.field("product_source", &self.product_source);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
    pub filters: std::option::Option<
        std::collections::HashMap<
            crate::model::ProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    >,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The sort field. If no value is specified, the results are not sorted.</p>
    pub sort_by: std::option::Option<crate::model::ProductViewSortBy>,
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl SearchProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The search filters. If no search filters are specified, the output includes all products to which the caller has access.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::ProductViewFilterBy,
            std::vec::Vec<std::string::String>,
        >,
    > {
        self.filters.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The sort field. If no value is specified, the results are not sorted.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ProductViewSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The sort order. If no value is specified, the results are not sorted.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for SearchProductsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProductsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("filters", &self.filters);
        formatter.field("page_size", &self.page_size);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanProvisionedProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ScanProvisionedProductsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub fn access_level_filter(&self) -> std::option::Option<&crate::model::AccessLevelFilter> {
        self.access_level_filter.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ScanProvisionedProductsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanProvisionedProductsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("access_level_filter", &self.access_level_filter);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectPortfolioShareInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
    /// <ul>
    /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
    /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
    /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
    /// </ul>
    /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
    pub portfolio_share_type: std::option::Option<crate::model::PortfolioShareType>,
}
impl RejectPortfolioShareInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
    /// <ul>
    /// <li> <p> <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.</p> </li>
    /// <li> <p> <code>IMPORTED</code> - Reject imported portfolios.</p> </li>
    /// <li> <p> <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p> </li>
    /// </ul>
    /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code> </p>
    pub fn portfolio_share_type(&self) -> std::option::Option<&crate::model::PortfolioShareType> {
        self.portfolio_share_type.as_ref()
    }
}
impl std::fmt::Debug for RejectPortfolioShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectPortfolioShareInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("portfolio_share_type", &self.portfolio_share_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier. You must provide the name or ID, but not both.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub provisioning_artifact_name: std::option::Option<std::string::String>,
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub path_name: std::option::Option<std::string::String>,
    /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
    pub provisioning_parameters:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
    /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
    pub provisioning_preferences: std::option::Option<crate::model::ProvisioningPreferences>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
    pub notification_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
    pub provision_token: std::option::Option<std::string::String>,
}
impl ProvisionProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier. You must provide the name or ID, but not both.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub fn provisioning_artifact_name(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_name.as_deref()
    }
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    pub fn path_id(&self) -> std::option::Option<&str> {
        self.path_id.as_deref()
    }
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub fn path_name(&self) -> std::option::Option<&str> {
        self.path_name.as_deref()
    }
    /// <p>A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.</p>
    pub fn provisioned_product_name(&self) -> std::option::Option<&str> {
        self.provisioned_product_name.as_deref()
    }
    /// <p>Parameters specified by the administrator that are required for provisioning the product.</p>
    pub fn provisioning_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisioningParameter]> {
        self.provisioning_parameters.as_deref()
    }
    /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
    pub fn provisioning_preferences(
        &self,
    ) -> std::option::Option<&crate::model::ProvisioningPreferences> {
        self.provisioning_preferences.as_ref()
    }
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.</p>
    pub fn notification_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.notification_arns.as_deref()
    }
    /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
    pub fn provision_token(&self) -> std::option::Option<&str> {
        self.provision_token.as_deref()
    }
}
impl std::fmt::Debug for ProvisionProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("product_name", &self.product_name);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field(
            "provisioning_artifact_name",
            &self.provisioning_artifact_name,
        );
        formatter.field("path_id", &self.path_id);
        formatter.field("path_name", &self.path_name);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("provisioning_parameters", &self.provisioning_parameters);
        formatter.field("provisioning_preferences", &self.provisioning_preferences);
        formatter.field("tags", &self.tags);
        formatter.field("notification_arns", &self.notification_arns);
        formatter.field("provision_token", &self.provision_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagOptionsInput {
    /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
    pub filters: std::option::Option<crate::model::ListTagOptionsFilters>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListTagOptionsInput {
    /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListTagOptionsFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagOptionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackInstancesForProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl ListStackInstancesForProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The identifier of the provisioned product.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for ListStackInstancesForProvisionedProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackInstancesForProvisionedProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceActionsForProvisioningArtifactInput {
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl ListServiceActionsForProvisioningArtifactInput {
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for ListServiceActionsForProvisioningArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceActionsForProvisioningArtifactInput");
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceActionsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListServiceActionsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListServiceActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceActionsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesForTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub tag_option_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    /// <ul>
    /// <li> <p> <code>Portfolio</code> </p> </li>
    /// <li> <p> <code>Product</code> </p> </li>
    /// </ul>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListResourcesForTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub fn tag_option_id(&self) -> std::option::Option<&str> {
        self.tag_option_id.as_deref()
    }
    /// <p>The resource type.</p>
    /// <ul>
    /// <li> <p> <code>Portfolio</code> </p> </li>
    /// <li> <p> <code>Product</code> </p> </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourcesForTagOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesForTagOptionInput");
        formatter.field("tag_option_id", &self.tag_option_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordHistoryInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
    /// <p>The search filter to scope the results.</p>
    pub search_filter: std::option::Option<crate::model::ListRecordHistorySearchFilter>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListRecordHistoryInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub fn access_level_filter(&self) -> std::option::Option<&crate::model::AccessLevelFilter> {
        self.access_level_filter.as_ref()
    }
    /// <p>The search filter to scope the results.</p>
    pub fn search_filter(
        &self,
    ) -> std::option::Option<&crate::model::ListRecordHistorySearchFilter> {
        self.search_filter.as_ref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecordHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordHistoryInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("access_level_filter", &self.access_level_filter);
        formatter.field("search_filter", &self.search_filter);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningArtifactsForServiceActionInput {
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl ListProvisioningArtifactsForServiceActionInput {
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub fn service_action_id(&self) -> std::option::Option<&str> {
        self.service_action_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for ListProvisioningArtifactsForServiceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningArtifactsForServiceActionInput");
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningArtifactsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
}
impl ListProvisioningArtifactsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
}
impl std::fmt::Debug for ListProvisioningArtifactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningArtifactsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedProductPlansInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub provision_product_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub access_level_filter: std::option::Option<crate::model::AccessLevelFilter>,
}
impl ListProvisionedProductPlansInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn provision_product_id(&self) -> std::option::Option<&str> {
        self.provision_product_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
    pub fn access_level_filter(&self) -> std::option::Option<&crate::model::AccessLevelFilter> {
        self.access_level_filter.as_ref()
    }
}
impl std::fmt::Debug for ListProvisionedProductPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedProductPlansInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provision_product_id", &self.provision_product_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.field("access_level_filter", &self.access_level_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalsForPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListPrincipalsForPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListPrincipalsForPortfolioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalsForPortfolioInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfoliosForProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl ListPortfoliosForProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for ListPortfoliosForProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfoliosForProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfoliosInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl ListPortfoliosInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for ListPortfoliosInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfoliosInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfolioAccessInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
    pub organization_parent_id: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl ListPortfolioAccessInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
    pub fn organization_parent_id(&self) -> std::option::Option<&str> {
        self.organization_parent_id.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for ListPortfolioAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfolioAccessInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("organization_parent_id", &self.organization_parent_id);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationPortfolioAccessInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The organization node type that will be returned in the output.</p>
    /// <ul>
    /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
    /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
    /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
    /// </ul>
    pub organization_node_type: std::option::Option<crate::model::OrganizationNodeType>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl ListOrganizationPortfolioAccessInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The organization node type that will be returned in the output.</p>
    /// <ul>
    /// <li> <p> <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p> </li>
    /// <li> <p> <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p> </li>
    /// <li> <p> <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p> </li>
    /// </ul>
    pub fn organization_node_type(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationNodeType> {
        self.organization_node_type.as_ref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for ListOrganizationPortfolioAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationPortfolioAccessInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("organization_node_type", &self.organization_node_type);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchPathsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListLaunchPathsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListLaunchPathsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchPathsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConstraintsForPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListConstraintsForPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListConstraintsForPortfolioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConstraintsForPortfolioInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBudgetsForResourceInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The resource identifier.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl ListBudgetsForResourceInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The resource identifier.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for ListBudgetsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBudgetsForResourceInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAcceptedPortfolioSharesInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
    /// <ul>
    /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
    /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
    /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
    /// </ul>
    pub portfolio_share_type: std::option::Option<crate::model::PortfolioShareType>,
}
impl ListAcceptedPortfolioSharesInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
    /// <ul>
    /// <li> <p> <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management account of your organization</p> </li>
    /// <li> <p> <code>AWS_SERVICECATALOG</code> - List default portfolios</p> </li>
    /// <li> <p> <code>IMPORTED</code> - List imported portfolios</p> </li>
    /// </ul>
    pub fn portfolio_share_type(&self) -> std::option::Option<&crate::model::PortfolioShareType> {
        self.portfolio_share_type.as_ref()
    }
}
impl std::fmt::Debug for ListAcceptedPortfolioSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAcceptedPortfolioSharesInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.field("portfolio_share_type", &self.portfolio_share_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAsProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
    pub physical_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl ImportAsProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The identifier of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. </p>
    pub fn provisioned_product_name(&self) -> std::option::Option<&str> {
        self.provisioned_product_name.as_deref()
    }
    /// <p>The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.</p>
    pub fn physical_id(&self) -> std::option::Option<&str> {
        self.physical_id.as_deref()
    }
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for ImportAsProvisionedProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAsProvisionedProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("physical_id", &self.physical_id);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProvisionedProductOutputsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product that you want the outputs from.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioned product that you want the outputs from.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
    pub output_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl GetProvisionedProductOutputsInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The identifier of the provisioned product that you want the outputs from.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The name of the provisioned product that you want the outputs from.</p>
    pub fn provisioned_product_name(&self) -> std::option::Option<&str> {
        self.provisioned_product_name.as_deref()
    }
    /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
    pub fn output_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.output_keys.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for GetProvisionedProductOutputsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProvisionedProductOutputsInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("output_keys", &self.output_keys);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAwsOrganizationsAccessStatusInput {}
impl std::fmt::Debug for GetAwsOrganizationsAccessStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAwsOrganizationsAccessStatusInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteProvisionedProductServiceActionInput {
    /// <p>The identifier of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>An idempotency token that uniquely identifies the execute request.</p>
    pub execute_token: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl ExecuteProvisionedProductServiceActionInput {
    /// <p>The identifier of the provisioned product.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub fn service_action_id(&self) -> std::option::Option<&str> {
        self.service_action_id.as_deref()
    }
    /// <p>An idempotency token that uniquely identifies the execute request.</p>
    pub fn execute_token(&self) -> std::option::Option<&str> {
        self.execute_token.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as <code>TARGET</code>.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for ExecuteProvisionedProductServiceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteProvisionedProductServiceActionInput");
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("execute_token", &self.execute_token);
        formatter.field("accept_language", &self.accept_language);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteProvisionedProductPlanInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The plan identifier.</p>
    pub plan_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl ExecuteProvisionedProductPlanInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The plan identifier.</p>
    pub fn plan_id(&self) -> std::option::Option<&str> {
        self.plan_id.as_deref()
    }
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for ExecuteProvisionedProductPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteProvisionedProductPlanInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("plan_id", &self.plan_id);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAwsOrganizationsAccessInput {}
impl std::fmt::Debug for EnableAwsOrganizationsAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAwsOrganizationsAccessInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTagOptionFromResourceInput {
    /// <p>The resource identifier.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The TagOption identifier.</p>
    pub tag_option_id: std::option::Option<std::string::String>,
}
impl DisassociateTagOptionFromResourceInput {
    /// <p>The resource identifier.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The TagOption identifier.</p>
    pub fn tag_option_id(&self) -> std::option::Option<&str> {
        self.tag_option_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateTagOptionFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTagOptionFromResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_option_id", &self.tag_option_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateServiceActionFromProvisioningArtifactInput {
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl DisassociateServiceActionFromProvisioningArtifactInput {
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub fn service_action_id(&self) -> std::option::Option<&str> {
        self.service_action_id.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for DisassociateServiceActionFromProvisioningArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DisassociateServiceActionFromProvisioningArtifactInput");
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateProductFromPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
}
impl DisassociateProductFromPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateProductFromPortfolioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateProductFromPortfolioInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociatePrincipalFromPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the principal (IAM user, role, or group).</p>
    pub principal_arn: std::option::Option<std::string::String>,
}
impl DisassociatePrincipalFromPortfolioInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The portfolio identifier.</p>
    pub fn portfolio_id(&self) -> std::option::Option<&str> {
        self.portfolio_id.as_deref()
    }
    /// <p>The ARN of the principal (IAM user, role, or group).</p>
    pub fn principal_arn(&self) -> std::option::Option<&str> {
        self.principal_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociatePrincipalFromPortfolioInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociatePrincipalFromPortfolioInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateBudgetFromResourceInput {
    /// <p>The name of the budget you want to disassociate.</p>
    pub budget_name: std::option::Option<std::string::String>,
    /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DisassociateBudgetFromResourceInput {
    /// <p>The name of the budget you want to disassociate.</p>
    pub fn budget_name(&self) -> std::option::Option<&str> {
        self.budget_name.as_deref()
    }
    /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateBudgetFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateBudgetFromResourceInput");
        formatter.field("budget_name", &self.budget_name);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAwsOrganizationsAccessInput {}
impl std::fmt::Debug for DisableAwsOrganizationsAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAwsOrganizationsAccessInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeTagOptionInput {
    /// <p>The TagOption identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagOptionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceActionExecutionParametersInput {
    /// <p>The identifier of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The self-service action identifier.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl DescribeServiceActionExecutionParametersInput {
    /// <p>The identifier of the provisioned product.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The self-service action identifier.</p>
    pub fn service_action_id(&self) -> std::option::Option<&str> {
        self.service_action_id.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for DescribeServiceActionExecutionParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceActionExecutionParametersInput");
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceActionInput {
    /// <p>The self-service action identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
}
impl DescribeServiceActionInput {
    /// <p>The self-service action identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
}
impl std::fmt::Debug for DescribeServiceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceActionInput");
        formatter.field("id", &self.id);
        formatter.field("accept_language", &self.accept_language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecordInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
}
impl DescribeRecordInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The record identifier of the provisioned product. This identifier is returned by the request operation.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
}
impl std::fmt::Debug for DescribeRecordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecordInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("page_token", &self.page_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningParametersInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub provisioning_artifact_name: std::option::Option<std::string::String>,
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub path_name: std::option::Option<std::string::String>,
}
impl DescribeProvisioningParametersInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The name of the product. You must provide the name or ID, but not both.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
    pub fn provisioning_artifact_name(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_name.as_deref()
    }
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use <code>ListLaunchPaths</code>. You must provide the name or ID, but not both.</p>
    pub fn path_id(&self) -> std::option::Option<&str> {
        self.path_id.as_deref()
    }
    /// <p>The name of the path. You must provide the name or ID, but not both.</p>
    pub fn path_name(&self) -> std::option::Option<&str> {
        self.path_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProvisioningParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningParametersInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("product_id", &self.product_id);
        formatter.field("product_name", &self.product_name);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field(
            "provisioning_artifact_name",
            &self.provisioning_artifact_name,
        );
        formatter.field("path_id", &self.path_id);
        formatter.field("path_name", &self.path_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningArtifactInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The provisioning artifact name.</p>
    pub provisioning_artifact_name: std::option::Option<std::string::String>,
    /// <p>The product name.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether a verbose level of detail is enabled.</p>
    pub verbose: bool,
}
impl DescribeProvisioningArtifactInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The identifier of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The provisioning artifact name.</p>
    pub fn provisioning_artifact_name(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_name.as_deref()
    }
    /// <p>The product name.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>Indicates whether a verbose level of detail is enabled.</p>
    pub fn verbose(&self) -> bool {
        self.verbose
    }
}
impl std::fmt::Debug for DescribeProvisioningArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningArtifactInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("product_id", &self.product_id);
        formatter.field(
            "provisioning_artifact_name",
            &self.provisioning_artifact_name,
        );
        formatter.field("product_name", &self.product_name);
        formatter.field("verbose", &self.verbose);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisionedProductPlanInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The plan identifier.</p>
    pub plan_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call.</p>
    pub page_size: i32,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl DescribeProvisionedProductPlanInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The plan identifier.</p>
    pub fn plan_id(&self) -> std::option::Option<&str> {
        self.plan_id.as_deref()
    }
    /// <p>The maximum number of items to return with this call.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub fn page_token(&self) -> std::option::Option<&str> {
        self.page_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeProvisionedProductPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisionedProductPlanInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("plan_id", &self.plan_id);
        formatter.field("page_size", &self.page_size);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}

/// DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned product identifier. Customers must provide either Id or Name.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
    /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
    /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeProvisionedProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
    /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
    /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProvisionedProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisionedProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductViewInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product view identifier.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeProductViewInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product view identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeProductViewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductViewInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductAsAdminInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The product name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
    /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
    pub source_portfolio_id: std::option::Option<std::string::String>,
}
impl DescribeProductAsAdminInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The product name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier of the shared portfolio that the specified product is associated with.</p>
    /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the product. If this parameter is provided and if TagOptions sharing is enabled in the portfolio share, the API returns both local and shared TagOptions associated with the product. Otherwise only local TagOptions will be returned. </p>
    pub fn source_portfolio_id(&self) -> std::option::Option<&str> {
        self.source_portfolio_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeProductAsAdminInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductAsAdminInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("source_portfolio_id", &self.source_portfolio_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub accept_language: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The product name.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeProductInput {
    /// <p>The language code.</p>
    /// <ul>
    /// <li> <p> <code>en</code> - English (default)</p> </li>
    /// <li> <p> <code>jp</code> - Japanese</p> </li>
    /// <li> <p> <code>zh</code> - Chinese</p> </li>
    /// </ul>
    pub fn accept_language(&self) -> std::option::Option<&str> {
        self.accept_language.as_deref()
    }
    /// <p>The product identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The product name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductInput");
        formatter.field("accept_language", &self.accept_language);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortfolioShareStatusInput {
    /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
    pub portfolio_share_token: std::option::Option<std::string::String>,
}
impl DescribePortfolioShareStatusInput {
    /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
    pub fn portfolio_share_token(&self) -> std::option::Option<&str> {
        self.portfolio_share_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePortfolioShareStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortfolioShareStatusInput");
        formatter.field("portfolio_share_token", &self.portfolio_share_token);
        formatter.finish()
    }
}

#[a