// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWS242ServiceCatalogService`.
///
/// This client allows ergonomic access to a `AWS242ServiceCatalogService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptPortfolioShare` operation.
    ///
    /// See [`AcceptPortfolioShare`](crate::client::fluent_builders::AcceptPortfolioShare) for more information about the
    /// operation and its arguments.
    pub fn accept_portfolio_share(&self) -> fluent_builders::AcceptPortfolioShare<C, M, R> {
        fluent_builders::AcceptPortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateBudgetWithResource` operation.
    ///
    /// See [`AssociateBudgetWithResource`](crate::client::fluent_builders::AssociateBudgetWithResource) for more information about the
    /// operation and its arguments.
    pub fn associate_budget_with_resource(
        &self,
    ) -> fluent_builders::AssociateBudgetWithResource<C, M, R> {
        fluent_builders::AssociateBudgetWithResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociatePrincipalWithPortfolio` operation.
    ///
    /// See [`AssociatePrincipalWithPortfolio`](crate::client::fluent_builders::AssociatePrincipalWithPortfolio) for more information about the
    /// operation and its arguments.
    pub fn associate_principal_with_portfolio(
        &self,
    ) -> fluent_builders::AssociatePrincipalWithPortfolio<C, M, R> {
        fluent_builders::AssociatePrincipalWithPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateProductWithPortfolio` operation.
    ///
    /// See [`AssociateProductWithPortfolio`](crate::client::fluent_builders::AssociateProductWithPortfolio) for more information about the
    /// operation and its arguments.
    pub fn associate_product_with_portfolio(
        &self,
    ) -> fluent_builders::AssociateProductWithPortfolio<C, M, R> {
        fluent_builders::AssociateProductWithPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateServiceActionWithProvisioningArtifact` operation.
    ///
    /// See [`AssociateServiceActionWithProvisioningArtifact`](crate::client::fluent_builders::AssociateServiceActionWithProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn associate_service_action_with_provisioning_artifact(
        &self,
    ) -> fluent_builders::AssociateServiceActionWithProvisioningArtifact<C, M, R> {
        fluent_builders::AssociateServiceActionWithProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTagOptionWithResource` operation.
    ///
    /// See [`AssociateTagOptionWithResource`](crate::client::fluent_builders::AssociateTagOptionWithResource) for more information about the
    /// operation and its arguments.
    pub fn associate_tag_option_with_resource(
        &self,
    ) -> fluent_builders::AssociateTagOptionWithResource<C, M, R> {
        fluent_builders::AssociateTagOptionWithResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchAssociateServiceActionWithProvisioningArtifact` operation.
    ///
    /// See [`BatchAssociateServiceActionWithProvisioningArtifact`](crate::client::fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn batch_associate_service_action_with_provisioning_artifact(
        &self,
    ) -> fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact<C, M, R> {
        fluent_builders::BatchAssociateServiceActionWithProvisioningArtifact::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `BatchDisassociateServiceActionFromProvisioningArtifact` operation.
    ///
    /// See [`BatchDisassociateServiceActionFromProvisioningArtifact`](crate::client::fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn batch_disassociate_service_action_from_provisioning_artifact(
        &self,
    ) -> fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact<C, M, R> {
        fluent_builders::BatchDisassociateServiceActionFromProvisioningArtifact::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `CopyProduct` operation.
    ///
    /// See [`CopyProduct`](crate::client::fluent_builders::CopyProduct) for more information about the
    /// operation and its arguments.
    pub fn copy_product(&self) -> fluent_builders::CopyProduct<C, M, R> {
        fluent_builders::CopyProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConstraint` operation.
    ///
    /// See [`CreateConstraint`](crate::client::fluent_builders::CreateConstraint) for more information about the
    /// operation and its arguments.
    pub fn create_constraint(&self) -> fluent_builders::CreateConstraint<C, M, R> {
        fluent_builders::CreateConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePortfolio` operation.
    ///
    /// See [`CreatePortfolio`](crate::client::fluent_builders::CreatePortfolio) for more information about the
    /// operation and its arguments.
    pub fn create_portfolio(&self) -> fluent_builders::CreatePortfolio<C, M, R> {
        fluent_builders::CreatePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePortfolioShare` operation.
    ///
    /// See [`CreatePortfolioShare`](crate::client::fluent_builders::CreatePortfolioShare) for more information about the
    /// operation and its arguments.
    pub fn create_portfolio_share(&self) -> fluent_builders::CreatePortfolioShare<C, M, R> {
        fluent_builders::CreatePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProduct` operation.
    ///
    /// See [`CreateProduct`](crate::client::fluent_builders::CreateProduct) for more information about the
    /// operation and its arguments.
    pub fn create_product(&self) -> fluent_builders::CreateProduct<C, M, R> {
        fluent_builders::CreateProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProvisionedProductPlan` operation.
    ///
    /// See [`CreateProvisionedProductPlan`](crate::client::fluent_builders::CreateProvisionedProductPlan) for more information about the
    /// operation and its arguments.
    pub fn create_provisioned_product_plan(
        &self,
    ) -> fluent_builders::CreateProvisionedProductPlan<C, M, R> {
        fluent_builders::CreateProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProvisioningArtifact` operation.
    ///
    /// See [`CreateProvisioningArtifact`](crate::client::fluent_builders::CreateProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn create_provisioning_artifact(
        &self,
    ) -> fluent_builders::CreateProvisioningArtifact<C, M, R> {
        fluent_builders::CreateProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceAction` operation.
    ///
    /// See [`CreateServiceAction`](crate::client::fluent_builders::CreateServiceAction) for more information about the
    /// operation and its arguments.
    pub fn create_service_action(&self) -> fluent_builders::CreateServiceAction<C, M, R> {
        fluent_builders::CreateServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTagOption` operation.
    ///
    /// See [`CreateTagOption`](crate::client::fluent_builders::CreateTagOption) for more information about the
    /// operation and its arguments.
    pub fn create_tag_option(&self) -> fluent_builders::CreateTagOption<C, M, R> {
        fluent_builders::CreateTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConstraint` operation.
    ///
    /// See [`DeleteConstraint`](crate::client::fluent_builders::DeleteConstraint) for more information about the
    /// operation and its arguments.
    pub fn delete_constraint(&self) -> fluent_builders::DeleteConstraint<C, M, R> {
        fluent_builders::DeleteConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePortfolio` operation.
    ///
    /// See [`DeletePortfolio`](crate::client::fluent_builders::DeletePortfolio) for more information about the
    /// operation and its arguments.
    pub fn delete_portfolio(&self) -> fluent_builders::DeletePortfolio<C, M, R> {
        fluent_builders::DeletePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePortfolioShare` operation.
    ///
    /// See [`DeletePortfolioShare`](crate::client::fluent_builders::DeletePortfolioShare) for more information about the
    /// operation and its arguments.
    pub fn delete_portfolio_share(&self) -> fluent_builders::DeletePortfolioShare<C, M, R> {
        fluent_builders::DeletePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProduct` operation.
    ///
    /// See [`DeleteProduct`](crate::client::fluent_builders::DeleteProduct) for more information about the
    /// operation and its arguments.
    pub fn delete_product(&self) -> fluent_builders::DeleteProduct<C, M, R> {
        fluent_builders::DeleteProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProvisionedProductPlan` operation.
    ///
    /// See [`DeleteProvisionedProductPlan`](crate::client::fluent_builders::DeleteProvisionedProductPlan) for more information about the
    /// operation and its arguments.
    pub fn delete_provisioned_product_plan(
        &self,
    ) -> fluent_builders::DeleteProvisionedProductPlan<C, M, R> {
        fluent_builders::DeleteProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProvisioningArtifact` operation.
    ///
    /// See [`DeleteProvisioningArtifact`](crate::client::fluent_builders::DeleteProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn delete_provisioning_artifact(
        &self,
    ) -> fluent_builders::DeleteProvisioningArtifact<C, M, R> {
        fluent_builders::DeleteProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceAction` operation.
    ///
    /// See [`DeleteServiceAction`](crate::client::fluent_builders::DeleteServiceAction) for more information about the
    /// operation and its arguments.
    pub fn delete_service_action(&self) -> fluent_builders::DeleteServiceAction<C, M, R> {
        fluent_builders::DeleteServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTagOption` operation.
    ///
    /// See [`DeleteTagOption`](crate::client::fluent_builders::DeleteTagOption) for more information about the
    /// operation and its arguments.
    pub fn delete_tag_option(&self) -> fluent_builders::DeleteTagOption<C, M, R> {
        fluent_builders::DeleteTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConstraint` operation.
    ///
    /// See [`DescribeConstraint`](crate::client::fluent_builders::DescribeConstraint) for more information about the
    /// operation and its arguments.
    pub fn describe_constraint(&self) -> fluent_builders::DescribeConstraint<C, M, R> {
        fluent_builders::DescribeConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCopyProductStatus` operation.
    ///
    /// See [`DescribeCopyProductStatus`](crate::client::fluent_builders::DescribeCopyProductStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_copy_product_status(
        &self,
    ) -> fluent_builders::DescribeCopyProductStatus<C, M, R> {
        fluent_builders::DescribeCopyProductStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePortfolio` operation.
    ///
    /// See [`DescribePortfolio`](crate::client::fluent_builders::DescribePortfolio) for more information about the
    /// operation and its arguments.
    pub fn describe_portfolio(&self) -> fluent_builders::DescribePortfolio<C, M, R> {
        fluent_builders::DescribePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePortfolioShares` operation.
    ///
    /// See [`DescribePortfolioShares`](crate::client::fluent_builders::DescribePortfolioShares) for more information about the
    /// operation and its arguments.
    pub fn describe_portfolio_shares(&self) -> fluent_builders::DescribePortfolioShares<C, M, R> {
        fluent_builders::DescribePortfolioShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePortfolioShareStatus` operation.
    ///
    /// See [`DescribePortfolioShareStatus`](crate::client::fluent_builders::DescribePortfolioShareStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_portfolio_share_status(
        &self,
    ) -> fluent_builders::DescribePortfolioShareStatus<C, M, R> {
        fluent_builders::DescribePortfolioShareStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProduct` operation.
    ///
    /// See [`DescribeProduct`](crate::client::fluent_builders::DescribeProduct) for more information about the
    /// operation and its arguments.
    pub fn describe_product(&self) -> fluent_builders::DescribeProduct<C, M, R> {
        fluent_builders::DescribeProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProductAsAdmin` operation.
    ///
    /// See [`DescribeProductAsAdmin`](crate::client::fluent_builders::DescribeProductAsAdmin) for more information about the
    /// operation and its arguments.
    pub fn describe_product_as_admin(&self) -> fluent_builders::DescribeProductAsAdmin<C, M, R> {
        fluent_builders::DescribeProductAsAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProductView` operation.
    ///
    /// See [`DescribeProductView`](crate::client::fluent_builders::DescribeProductView) for more information about the
    /// operation and its arguments.
    pub fn describe_product_view(&self) -> fluent_builders::DescribeProductView<C, M, R> {
        fluent_builders::DescribeProductView::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisionedProduct` operation.
    ///
    /// See [`DescribeProvisionedProduct`](crate::client::fluent_builders::DescribeProvisionedProduct) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioned_product(
        &self,
    ) -> fluent_builders::DescribeProvisionedProduct<C, M, R> {
        fluent_builders::DescribeProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisionedProductPlan` operation.
    ///
    /// See [`DescribeProvisionedProductPlan`](crate::client::fluent_builders::DescribeProvisionedProductPlan) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioned_product_plan(
        &self,
    ) -> fluent_builders::DescribeProvisionedProductPlan<C, M, R> {
        fluent_builders::DescribeProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisioningArtifact` operation.
    ///
    /// See [`DescribeProvisioningArtifact`](crate::client::fluent_builders::DescribeProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioning_artifact(
        &self,
    ) -> fluent_builders::DescribeProvisioningArtifact<C, M, R> {
        fluent_builders::DescribeProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisioningParameters` operation.
    ///
    /// See [`DescribeProvisioningParameters`](crate::client::fluent_builders::DescribeProvisioningParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioning_parameters(
        &self,
    ) -> fluent_builders::DescribeProvisioningParameters<C, M, R> {
        fluent_builders::DescribeProvisioningParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecord` operation.
    ///
    /// See [`DescribeRecord`](crate::client::fluent_builders::DescribeRecord) for more information about the
    /// operation and its arguments.
    pub fn describe_record(&self) -> fluent_builders::DescribeRecord<C, M, R> {
        fluent_builders::DescribeRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeServiceAction` operation.
    ///
    /// See [`DescribeServiceAction`](crate::client::fluent_builders::DescribeServiceAction) for more information about the
    /// operation and its arguments.
    pub fn describe_service_action(&self) -> fluent_builders::DescribeServiceAction<C, M, R> {
        fluent_builders::DescribeServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeServiceActionExecutionParameters` operation.
    ///
    /// See [`DescribeServiceActionExecutionParameters`](crate::client::fluent_builders::DescribeServiceActionExecutionParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_service_action_execution_parameters(
        &self,
    ) -> fluent_builders::DescribeServiceActionExecutionParameters<C, M, R> {
        fluent_builders::DescribeServiceActionExecutionParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTagOption` operation.
    ///
    /// See [`DescribeTagOption`](crate::client::fluent_builders::DescribeTagOption) for more information about the
    /// operation and its arguments.
    pub fn describe_tag_option(&self) -> fluent_builders::DescribeTagOption<C, M, R> {
        fluent_builders::DescribeTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableAWSOrganizationsAccess` operation.
    ///
    /// See [`DisableAWSOrganizationsAccess`](crate::client::fluent_builders::DisableAWSOrganizationsAccess) for more information about the
    /// operation and its arguments.
    pub fn disable_aws_organizations_access(
        &self,
    ) -> fluent_builders::DisableAWSOrganizationsAccess<C, M, R> {
        fluent_builders::DisableAWSOrganizationsAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateBudgetFromResource` operation.
    ///
    /// See [`DisassociateBudgetFromResource`](crate::client::fluent_builders::DisassociateBudgetFromResource) for more information about the
    /// operation and its arguments.
    pub fn disassociate_budget_from_resource(
        &self,
    ) -> fluent_builders::DisassociateBudgetFromResource<C, M, R> {
        fluent_builders::DisassociateBudgetFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociatePrincipalFromPortfolio` operation.
    ///
    /// See [`DisassociatePrincipalFromPortfolio`](crate::client::fluent_builders::DisassociatePrincipalFromPortfolio) for more information about the
    /// operation and its arguments.
    pub fn disassociate_principal_from_portfolio(
        &self,
    ) -> fluent_builders::DisassociatePrincipalFromPortfolio<C, M, R> {
        fluent_builders::DisassociatePrincipalFromPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateProductFromPortfolio` operation.
    ///
    /// See [`DisassociateProductFromPortfolio`](crate::client::fluent_builders::DisassociateProductFromPortfolio) for more information about the
    /// operation and its arguments.
    pub fn disassociate_product_from_portfolio(
        &self,
    ) -> fluent_builders::DisassociateProductFromPortfolio<C, M, R> {
        fluent_builders::DisassociateProductFromPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateServiceActionFromProvisioningArtifact` operation.
    ///
    /// See [`DisassociateServiceActionFromProvisioningArtifact`](crate::client::fluent_builders::DisassociateServiceActionFromProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn disassociate_service_action_from_provisioning_artifact(
        &self,
    ) -> fluent_builders::DisassociateServiceActionFromProvisioningArtifact<C, M, R> {
        fluent_builders::DisassociateServiceActionFromProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTagOptionFromResource` operation.
    ///
    /// See [`DisassociateTagOptionFromResource`](crate::client::fluent_builders::DisassociateTagOptionFromResource) for more information about the
    /// operation and its arguments.
    pub fn disassociate_tag_option_from_resource(
        &self,
    ) -> fluent_builders::DisassociateTagOptionFromResource<C, M, R> {
        fluent_builders::DisassociateTagOptionFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableAWSOrganizationsAccess` operation.
    ///
    /// See [`EnableAWSOrganizationsAccess`](crate::client::fluent_builders::EnableAWSOrganizationsAccess) for more information about the
    /// operation and its arguments.
    pub fn enable_aws_organizations_access(
        &self,
    ) -> fluent_builders::EnableAWSOrganizationsAccess<C, M, R> {
        fluent_builders::EnableAWSOrganizationsAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteProvisionedProductPlan` operation.
    ///
    /// See [`ExecuteProvisionedProductPlan`](crate::client::fluent_builders::ExecuteProvisionedProductPlan) for more information about the
    /// operation and its arguments.
    pub fn execute_provisioned_product_plan(
        &self,
    ) -> fluent_builders::ExecuteProvisionedProductPlan<C, M, R> {
        fluent_builders::ExecuteProvisionedProductPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteProvisionedProductServiceAction` operation.
    ///
    /// See [`ExecuteProvisionedProductServiceAction`](crate::client::fluent_builders::ExecuteProvisionedProductServiceAction) for more information about the
    /// operation and its arguments.
    pub fn execute_provisioned_product_service_action(
        &self,
    ) -> fluent_builders::ExecuteProvisionedProductServiceAction<C, M, R> {
        fluent_builders::ExecuteProvisionedProductServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAWSOrganizationsAccessStatus` operation.
    ///
    /// See [`GetAWSOrganizationsAccessStatus`](crate::client::fluent_builders::GetAWSOrganizationsAccessStatus) for more information about the
    /// operation and its arguments.
    pub fn get_aws_organizations_access_status(
        &self,
    ) -> fluent_builders::GetAWSOrganizationsAccessStatus<C, M, R> {
        fluent_builders::GetAWSOrganizationsAccessStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProvisionedProductOutputs` operation.
    ///
    /// See [`GetProvisionedProductOutputs`](crate::client::fluent_builders::GetProvisionedProductOutputs) for more information about the
    /// operation and its arguments.
    pub fn get_provisioned_product_outputs(
        &self,
    ) -> fluent_builders::GetProvisionedProductOutputs<C, M, R> {
        fluent_builders::GetProvisionedProductOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportAsProvisionedProduct` operation.
    ///
    /// See [`ImportAsProvisionedProduct`](crate::client::fluent_builders::ImportAsProvisionedProduct) for more information about the
    /// operation and its arguments.
    pub fn import_as_provisioned_product(
        &self,
    ) -> fluent_builders::ImportAsProvisionedProduct<C, M, R> {
        fluent_builders::ImportAsProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAcceptedPortfolioShares` operation.
    ///
    /// See [`ListAcceptedPortfolioShares`](crate::client::fluent_builders::ListAcceptedPortfolioShares) for more information about the
    /// operation and its arguments.
    pub fn list_accepted_portfolio_shares(
        &self,
    ) -> fluent_builders::ListAcceptedPortfolioShares<C, M, R> {
        fluent_builders::ListAcceptedPortfolioShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBudgetsForResource` operation.
    ///
    /// See [`ListBudgetsForResource`](crate::client::fluent_builders::ListBudgetsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_budgets_for_resource(&self) -> fluent_builders::ListBudgetsForResource<C, M, R> {
        fluent_builders::ListBudgetsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConstraintsForPortfolio` operation.
    ///
    /// See [`ListConstraintsForPortfolio`](crate::client::fluent_builders::ListConstraintsForPortfolio) for more information about the
    /// operation and its arguments.
    pub fn list_constraints_for_portfolio(
        &self,
    ) -> fluent_builders::ListConstraintsForPortfolio<C, M, R> {
        fluent_builders::ListConstraintsForPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLaunchPaths` operation.
    ///
    /// See [`ListLaunchPaths`](crate::client::fluent_builders::ListLaunchPaths) for more information about the
    /// operation and its arguments.
    pub fn list_launch_paths(&self) -> fluent_builders::ListLaunchPaths<C, M, R> {
        fluent_builders::ListLaunchPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizationPortfolioAccess` operation.
    ///
    /// See [`ListOrganizationPortfolioAccess`](crate::client::fluent_builders::ListOrganizationPortfolioAccess) for more information about the
    /// operation and its arguments.
    pub fn list_organization_portfolio_access(
        &self,
    ) -> fluent_builders::ListOrganizationPortfolioAccess<C, M, R> {
        fluent_builders::ListOrganizationPortfolioAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPortfolioAccess` operation.
    ///
    /// See [`ListPortfolioAccess`](crate::client::fluent_builders::ListPortfolioAccess) for more information about the
    /// operation and its arguments.
    pub fn list_portfolio_access(&self) -> fluent_builders::ListPortfolioAccess<C, M, R> {
        fluent_builders::ListPortfolioAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPortfolios` operation.
    ///
    /// See [`ListPortfolios`](crate::client::fluent_builders::ListPortfolios) for more information about the
    /// operation and its arguments.
    pub fn list_portfolios(&self) -> fluent_builders::ListPortfolios<C, M, R> {
        fluent_builders::ListPortfolios::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPortfoliosForProduct` operation.
    ///
    /// See [`ListPortfoliosForProduct`](crate::client::fluent_builders::ListPortfoliosForProduct) for more information about the
    /// operation and its arguments.
    pub fn list_portfolios_for_product(
        &self,
    ) -> fluent_builders::ListPortfoliosForProduct<C, M, R> {
        fluent_builders::ListPortfoliosForProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPrincipalsForPortfolio` operation.
    ///
    /// See [`ListPrincipalsForPortfolio`](crate::client::fluent_builders::ListPrincipalsForPortfolio) for more information about the
    /// operation and its arguments.
    pub fn list_principals_for_portfolio(
        &self,
    ) -> fluent_builders::ListPrincipalsForPortfolio<C, M, R> {
        fluent_builders::ListPrincipalsForPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisionedProductPlans` operation.
    ///
    /// See [`ListProvisionedProductPlans`](crate::client::fluent_builders::ListProvisionedProductPlans) for more information about the
    /// operation and its arguments.
    pub fn list_provisioned_product_plans(
        &self,
    ) -> fluent_builders::ListProvisionedProductPlans<C, M, R> {
        fluent_builders::ListProvisionedProductPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisioningArtifacts` operation.
    ///
    /// See [`ListProvisioningArtifacts`](crate::client::fluent_builders::ListProvisioningArtifacts) for more information about the
    /// operation and its arguments.
    pub fn list_provisioning_artifacts(
        &self,
    ) -> fluent_builders::ListProvisioningArtifacts<C, M, R> {
        fluent_builders::ListProvisioningArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisioningArtifactsForServiceAction` operation.
    ///
    /// See [`ListProvisioningArtifactsForServiceAction`](crate::client::fluent_builders::ListProvisioningArtifactsForServiceAction) for more information about the
    /// operation and its arguments.
    pub fn list_provisioning_artifacts_for_service_action(
        &self,
    ) -> fluent_builders::ListProvisioningArtifactsForServiceAction<C, M, R> {
        fluent_builders::ListProvisioningArtifactsForServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecordHistory` operation.
    ///
    /// See [`ListRecordHistory`](crate::client::fluent_builders::ListRecordHistory) for more information about the
    /// operation and its arguments.
    pub fn list_record_history(&self) -> fluent_builders::ListRecordHistory<C, M, R> {
        fluent_builders::ListRecordHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourcesForTagOption` operation.
    ///
    /// See [`ListResourcesForTagOption`](crate::client::fluent_builders::ListResourcesForTagOption) for more information about the
    /// operation and its arguments.
    pub fn list_resources_for_tag_option(
        &self,
    ) -> fluent_builders::ListResourcesForTagOption<C, M, R> {
        fluent_builders::ListResourcesForTagOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceActions` operation.
    ///
    /// See [`ListServiceActions`](crate::client::fluent_builders::ListServiceActions) for more information about the
    /// operation and its arguments.
    pub fn list_service_actions(&self) -> fluent_builders::ListServiceActions<C, M, R> {
        fluent_builders::ListServiceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceActionsForProvisioningArtifact` operation.
    ///
    /// See [`ListServiceActionsForProvisioningArtifact`](crate::client::fluent_builders::ListServiceActionsForProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn list_service_actions_for_provisioning_artifact(
        &self,
    ) -> fluent_builders::ListServiceActionsForProvisioningArtifact<C, M, R> {
        fluent_builders::ListServiceActionsForProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStackInstancesForProvisionedProduct` operation.
    ///
    /// See [`ListStackInstancesForProvisionedProduct`](crate::client::fluent_builders::ListStackInstancesForProvisionedProduct) for more information about the
    /// operation and its arguments.
    pub fn list_stack_instances_for_provisioned_product(
        &self,
    ) -> fluent_builders::ListStackInstancesForProvisionedProduct<C, M, R> {
        fluent_builders::ListStackInstancesForProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagOptions` operation.
    ///
    /// See [`ListTagOptions`](crate::client::fluent_builders::ListTagOptions) for more information about the
    /// operation and its arguments.
    pub fn list_tag_options(&self) -> fluent_builders::ListTagOptions<C, M, R> {
        fluent_builders::ListTagOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionProduct` operation.
    ///
    /// See [`ProvisionProduct`](crate::client::fluent_builders::ProvisionProduct) for more information about the
    /// operation and its arguments.
    pub fn provision_product(&self) -> fluent_builders::ProvisionProduct<C, M, R> {
        fluent_builders::ProvisionProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectPortfolioShare` operation.
    ///
    /// See [`RejectPortfolioShare`](crate::client::fluent_builders::RejectPortfolioShare) for more information about the
    /// operation and its arguments.
    pub fn reject_portfolio_share(&self) -> fluent_builders::RejectPortfolioShare<C, M, R> {
        fluent_builders::RejectPortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ScanProvisionedProducts` operation.
    ///
    /// See [`ScanProvisionedProducts`](crate::client::fluent_builders::ScanProvisionedProducts) for more information about the
    /// operation and its arguments.
    pub fn scan_provisioned_products(&self) -> fluent_builders::ScanProvisionedProducts<C, M, R> {
        fluent_builders::ScanProvisionedProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchProducts` operation.
    ///
    /// See [`SearchProducts`](crate::client::fluent_builders::SearchProducts) for more information about the
    /// operation and its arguments.
    pub fn search_products(&self) -> fluent_builders::SearchProducts<C, M, R> {
        fluent_builders::SearchProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchProductsAsAdmin` operation.
    ///
    /// See [`SearchProductsAsAdmin`](crate::client::fluent_builders::SearchProductsAsAdmin) for more information about the
    /// operation and its arguments.
    pub fn search_products_as_admin(&self) -> fluent_builders::SearchProductsAsAdmin<C, M, R> {
        fluent_builders::SearchProductsAsAdmin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchProvisionedProducts` operation.
    ///
    /// See [`SearchProvisionedProducts`](crate::client::fluent_builders::SearchProvisionedProducts) for more information about the
    /// operation and its arguments.
    pub fn search_provisioned_products(
        &self,
    ) -> fluent_builders::SearchProvisionedProducts<C, M, R> {
        fluent_builders::SearchProvisionedProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateProvisionedProduct` operation.
    ///
    /// See [`TerminateProvisionedProduct`](crate::client::fluent_builders::TerminateProvisionedProduct) for more information about the
    /// operation and its arguments.
    pub fn terminate_provisioned_product(
        &self,
    ) -> fluent_builders::TerminateProvisionedProduct<C, M, R> {
        fluent_builders::TerminateProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConstraint` operation.
    ///
    /// See [`UpdateConstraint`](crate::client::fluent_builders::UpdateConstraint) for more information about the
    /// operation and its arguments.
    pub fn update_constraint(&self) -> fluent_builders::UpdateConstraint<C, M, R> {
        fluent_builders::UpdateConstraint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePortfolio` operation.
    ///
    /// See [`UpdatePortfolio`](crate::client::fluent_builders::UpdatePortfolio) for more information about the
    /// operation and its arguments.
    pub fn update_portfolio(&self) -> fluent_builders::UpdatePortfolio<C, M, R> {
        fluent_builders::UpdatePortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePortfolioShare` operation.
    ///
    /// See [`UpdatePortfolioShare`](crate::client::fluent_builders::UpdatePortfolioShare) for more information about the
    /// operation and its arguments.
    pub fn update_portfolio_share(&self) -> fluent_builders::UpdatePortfolioShare<C, M, R> {
        fluent_builders::UpdatePortfolioShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProduct` operation.
    ///
    /// See [`UpdateProduct`](crate::client::fluent_builders::UpdateProduct) for more information about the
    /// operation and its arguments.
    pub fn update_product(&self) -> fluent_builders::UpdateProduct<C, M, R> {
        fluent_builders::UpdateProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProvisionedProduct` operation.
    ///
    /// See [`UpdateProvisionedProduct`](crate::client::fluent_builders::UpdateProvisionedProduct) for more information about the
    /// operation and its arguments.
    pub fn update_provisioned_product(&self) -> fluent_builders::UpdateProvisionedProduct<C, M, R> {
        fluent_builders::UpdateProvisionedProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProvisionedProductProperties` operation.
    ///
    /// See [`UpdateProvisionedProductProperties`](crate::client::fluent_builders::UpdateProvisionedProductProperties) for more information about the
    /// operation and its arguments.
    pub fn update_provisioned_product_properties(
        &self,
    ) -> fluent_builders::UpdateProvisionedProductProperties<C, M, R> {
        fluent_builders::UpdateProvisionedProductProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProvisioningArtifact` operation.
    ///
    /// See [`UpdateProvisioningArtifact`](crate::client::fluent_builders::UpdateProvisioningArtifact) for more information about the
    /// operation and its arguments.
    pub fn update_provisioning_artifact(
        &self,
    ) -> fluent_builders::UpdateProvisioningArtifact<C, M, R> {
        fluent_builders::UpdateProvisioningArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceAction` operation.
    ///
    /// See [`UpdateServiceAction`](crate::client::fluent_builders::UpdateServiceAction) for more information about the
    /// operation and its arguments.
    pub fn update_service_action(&self) -> fluent_builders::UpdateServiceAction<C, M, R> {
        fluent_builders::UpdateServiceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTagOption` operation.
    ///
    /// See [`UpdateTagOption`](crate::client::fluent_builders::UpdateTagOption) for more information about the
    /// operation and its arguments.
    pub fn update_tag_option(&self) -> fluent_builders::UpdateTagOption<C, M, R> {
        fluent_builders::UpdateTagOption::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptPortfolioShare`.
    ///
    /// <p>Accepts an offer to share the specified portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptPortfolioShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_portfolio_share_input::Builder,
    }
    impl<C, M, R> AcceptPortfolioShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptPortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptPortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptPortfolioShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptPortfolioShareInputOperationOutputAlias,
                crate::output::AcceptPortfolioShareOutput,
                crate::error::AcceptPortfolioShareError,
                crate::input::AcceptPortfolioShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your
        /// organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - Accept imported portfolios.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
        /// </p>
        pub fn portfolio_share_type(mut self, inp: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(inp);
            self
        }
        /// <p>The type of shared portfolios to accept. The default is to accept imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - Accept portfolios shared by the management account of your
        /// organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - Accept imported portfolios.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
        /// </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateBudgetWithResource`.
    ///
    /// <p>Associates the specified budget with the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateBudgetWithResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_budget_with_resource_input::Builder,
    }
    impl<C, M, R> AssociateBudgetWithResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateBudgetWithResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBudgetWithResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBudgetWithResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateBudgetWithResourceInputOperationOutputAlias,
                crate::output::AssociateBudgetWithResourceOutput,
                crate::error::AssociateBudgetWithResourceError,
                crate::input::AssociateBudgetWithResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the budget you want to associate.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget you want to associate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p> The resource identifier. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociatePrincipalWithPortfolio`.
    ///
    /// <p>Associates the specified principal ARN with the specified portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociatePrincipalWithPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_principal_with_portfolio_input::Builder,
    }
    impl<C, M, R> AssociatePrincipalWithPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociatePrincipalWithPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociatePrincipalWithPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociatePrincipalWithPortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociatePrincipalWithPortfolioInputOperationOutputAlias,
                crate::output::AssociatePrincipalWithPortfolioOutput,
                crate::error::AssociatePrincipalWithPortfolioError,
                crate::input::AssociatePrincipalWithPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(inp);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn principal_type(mut self, inp: crate::model::PrincipalType) -> Self {
            self.inner = self.inner.principal_type(inp);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.inner = self.inner.set_principal_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateProductWithPortfolio`.
    ///
    /// <p>Associates the specified product with the specified portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateProductWithPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_product_with_portfolio_input::Builder,
    }
    impl<C, M, R> AssociateProductWithPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateProductWithPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateProductWithPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateProductWithPortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateProductWithPortfolioInputOperationOutputAlias,
                crate::output::AssociateProductWithPortfolioOutput,
                crate::error::AssociateProductWithPortfolioError,
                crate::input::AssociateProductWithPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn source_portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_portfolio_id(inp);
            self
        }
        /// <p>The identifier of the source portfolio.</p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateServiceActionWithProvisioningArtifact`.
    ///
    /// <p>Associates a self-service action with a provisioning artifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateServiceActionWithProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_service_action_with_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> AssociateServiceActionWithProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateServiceActionWithProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::AssociateServiceActionWithProvisioningArtifactOutput, aws_smithy_http::result::SdkError<crate::error::AssociateServiceActionWithProvisioningArtifactError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::AssociateServiceActionWithProvisioningArtifactInputOperationOutputAlias,
                                    crate::output::AssociateServiceActionWithProvisioningArtifactOutput,
                                    crate::error::AssociateServiceActionWithProvisioningArtifactError,
                                    crate::input::AssociateServiceActionWithProvisioningArtifactInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(inp);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTagOptionWithResource`.
    ///
    /// <p>Associate the specified TagOption with the specified portfolio or product.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateTagOptionWithResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_tag_option_with_resource_input::Builder,
    }
    impl<C, M, R> AssociateTagOptionWithResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTagOptionWithResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTagOptionWithResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTagOptionWithResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTagOptionWithResourceInputOperationOutputAlias,
                crate::output::AssociateTagOptionWithResourceOutput,
                crate::error::AssociateTagOptionWithResourceError,
                crate::input::AssociateTagOptionWithResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateServiceActionWithProvisioningArtifact`.
    ///
    /// <p>Associates multiple self-service actions with provisioning artifacts.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchAssociateServiceActionWithProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner:
            crate::input::batch_associate_service_action_with_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> BatchAssociateServiceActionWithProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateServiceActionWithProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput, aws_smithy_http::result::SdkError<crate::error::BatchAssociateServiceActionWithProvisioningArtifactError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::BatchAssociateServiceActionWithProvisioningArtifactInputOperationOutputAlias,
                                    crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput,
                                    crate::error::BatchAssociateServiceActionWithProvisioningArtifactError,
                                    crate::input::BatchAssociateServiceActionWithProvisioningArtifactInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ServiceActionAssociations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            inp: impl Into<crate::model::ServiceActionAssociation>,
        ) -> Self {
            self.inner = self.inner.service_action_associations(inp);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_service_action_associations(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateServiceActionFromProvisioningArtifact`.
    ///
    /// <p>Disassociates a batch of self-service actions from the specified provisioning artifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDisassociateServiceActionFromProvisioningArtifact<C= aws_smithy_client::erase::DynConnector, M= aws_hyper::AwsMiddleware, R= aws_smithy_client::retry::Standard> {
                            handle: std::sync::Arc<super::Handle<C, M, R>>,
                            inner: crate::input::batch_disassociate_service_action_from_provisioning_artifact_input::Builder
                        }
    impl<C, M, R> BatchDisassociateServiceActionFromProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateServiceActionFromProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput, aws_smithy_http::result::SdkError<crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInputOperationOutputAlias,
                                    crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput,
                                    crate::error::BatchDisassociateServiceActionFromProvisioningArtifactError,
                                    crate::input::BatchDisassociateServiceActionFromProvisioningArtifactInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ServiceActionAssociations`.
        ///
        /// To override the contents of this collection use [`set_service_action_associations`](Self::set_service_action_associations).
        ///
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn service_action_associations(
            mut self,
            inp: impl Into<crate::model::ServiceActionAssociation>,
        ) -> Self {
            self.inner = self.inner.service_action_associations(inp);
            self
        }
        /// <p>One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
        pub fn set_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_service_action_associations(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyProduct`.
    ///
    /// <p>Copies the specified source product to the specified target product or a new product.</p>
    /// <p>You can copy a product to the same account or another account.
    /// You can copy a product to the same region or another region.</p>
    /// <p>This operation is performed asynchronously. To track the progress of the
    /// operation, use <a>DescribeCopyProductStatus</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_product_input::Builder,
    }
    impl<C, M, R> CopyProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyProductOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyProductInputOperationOutputAlias,
                crate::output::CopyProductOutput,
                crate::error::CopyProductError,
                crate::input::CopyProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn source_product_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_product_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source product.</p>
        pub fn set_source_product_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_product_arn(input);
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn target_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_product_id(inp);
            self
        }
        /// <p>The identifier of the target product. By default, a new product is created.</p>
        pub fn set_target_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_product_id(input);
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn target_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_product_name(inp);
            self
        }
        /// <p>A name for the target product. The default is the name of the source product.</p>
        pub fn set_target_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_product_name(input);
            self
        }
        /// Appends an item to `SourceProvisioningArtifactIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_source_provisioning_artifact_identifiers`](Self::set_source_provisioning_artifact_identifiers).
        ///
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy.
        /// By default, all provisioning artifacts are copied.</p>
        pub fn source_provisioning_artifact_identifiers(
            mut self,
            inp: impl Into<
                std::collections::HashMap<
                    crate::model::ProvisioningArtifactPropertyName,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.source_provisioning_artifact_identifiers(inp);
            self
        }
        /// <p>The identifiers of the provisioning artifacts (also known as versions) of the product to copy.
        /// By default, all provisioning artifacts are copied.</p>
        pub fn set_source_provisioning_artifact_identifiers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        crate::model::ProvisioningArtifactPropertyName,
                        std::string::String,
                    >,
                >,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_provisioning_artifact_identifiers(input);
            self
        }
        /// Appends an item to `CopyOptions`.
        ///
        /// To override the contents of this collection use [`set_copy_options`](Self::set_copy_options).
        ///
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source
        /// product are copied to the target product.</p>
        pub fn copy_options(mut self, inp: impl Into<crate::model::CopyOption>) -> Self {
            self.inner = self.inner.copy_options(inp);
            self
        }
        /// <p>The copy options. If the value is <code>CopyTags</code>, the tags from the source
        /// product are copied to the target product.</p>
        pub fn set_copy_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CopyOption>>,
        ) -> Self {
            self.inner = self.inner.set_copy_options(input);
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request. </p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p> A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request. </p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConstraint`.
    ///
    /// <p>Creates a constraint.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConstraint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_constraint_input::Builder,
    }
    impl<C, M, R> CreateConstraint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConstraintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConstraintInputOperationOutputAlias,
                crate::output::CreateConstraintOutput,
                crate::error::CreateConstraintError,
                crate::input::CreateConstraintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>LAUNCH</dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p>
        /// <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
        /// </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p>
        /// <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
        /// </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be
        /// account-agnostic so the administrator can create fewer resources per shared account.</p>
        /// <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>NOTIFICATION</dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p>
        /// <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
        /// </p>
        /// </dd>
        /// <dt>RESOURCE_UPDATE</dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p>
        /// <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
        /// </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>STACKSET</dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p>
        /// <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
        /// </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>TEMPLATE</dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see
        /// <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>LAUNCH</dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p>
        /// <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
        /// </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p>
        /// <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
        /// </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be
        /// account-agnostic so the administrator can create fewer resources per shared account.</p>
        /// <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>NOTIFICATION</dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p>
        /// <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
        /// </p>
        /// </dd>
        /// <dt>RESOURCE_UPDATE</dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p>
        /// <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
        /// </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>STACKSET</dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p>
        /// <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
        /// </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>TEMPLATE</dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see
        /// <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOURCE_UPDATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STACKSET</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOURCE_UPDATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STACKSET</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortfolio`.
    ///
    /// <p>Creates a portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_portfolio_input::Builder,
    }
    impl<C, M, R> CreatePortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePortfolioInputOperationOutputAlias,
                crate::output::CreatePortfolioOutput,
                crate::error::CreatePortfolioError,
                crate::input::CreatePortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortfolioShare`.
    ///
    /// <p>Shares the specified portfolio with the specified account or organization node.
    /// Shares to an organization node can only be created by the management account of an
    /// organization or by a delegated administrator. You can share portfolios to an organization,
    /// an organizational unit, or a specific account.</p>
    /// <p>Note that if a delegated admin is de-registered, they can no longer create portfolio shares.</p>
    /// <p>
    /// <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.</p>
    /// <p>You can't share a shared resource, including portfolios that contain a shared product.</p>
    /// <p>If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the <code> UpdatePortfolioShare</code> API instead.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePortfolioShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_portfolio_share_input::Builder,
    }
    impl<C, M, R> CreatePortfolioShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortfolioShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePortfolioShareInputOperationOutputAlias,
                crate::output::CreatePortfolioShareOutput,
                crate::error::CreatePortfolioShareError,
                crate::input::CreatePortfolioShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The AWS account ID. For example, <code>123456789012</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code>
        /// is passed in, <code>PortfolioShare</code> will be created for the node an
        /// ListOrganizationPortfolioAccessd its children (when applies), and a
        /// <code>PortfolioShareToken</code> will be returned in the output in order for the
        /// administrator to monitor the status of the <code>PortfolioShare</code> creation
        /// process.</p>
        pub fn organization_node(mut self, inp: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(inp);
            self
        }
        /// <p>The organization node to whom you are going to share. If <code>OrganizationNode</code>
        /// is passed in, <code>PortfolioShare</code> will be created for the node an
        /// ListOrganizationPortfolioAccessd its children (when applies), and a
        /// <code>PortfolioShareToken</code> will be returned in the output in order for the
        /// administrator to monitor the status of the <code>PortfolioShare</code> creation
        /// process.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn share_tag_options(mut self, inp: bool) -> Self {
            self.inner = self.inner.share_tag_options(inp);
            self
        }
        /// <p>Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_share_tag_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProduct`.
    ///
    /// <p>Creates a product.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    ///
    /// <p>The user or role that performs this operation must have the
    /// <code>cloudformation:GetTemplate</code> IAM policy permission. This policy permission is
    /// required when using the <code>ImportFromPhysicalId</code> template source in the
    /// information data section.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_product_input::Builder,
    }
    impl<C, M, R> CreateProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProductOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProductInputOperationOutputAlias,
                crate::output::CreateProductOutput,
                crate::error::CreateProductError,
                crate::input::CreateProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the product.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The owner of the product.</p>
        pub fn owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The description of the product.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn distributor(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distributor(inp);
            self
        }
        /// <p>The distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_distributor(input);
            self
        }
        /// <p>The support information about the product.</p>
        pub fn support_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_description(inp);
            self
        }
        /// <p>The support information about the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_description(input);
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn support_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_email(inp);
            self
        }
        /// <p>The contact email for product support.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_email(input);
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p>
        /// <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn support_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_url(inp);
            self
        }
        /// <p>The contact URL for product support.</p>
        /// <p>
        /// <code>^https?:\/\// </code>/ is the pattern used to validate SupportUrl.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_support_url(input);
            self
        }
        /// <p>The type of product.</p>
        pub fn product_type(mut self, inp: crate::model::ProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The type of product.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::ProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn provisioning_artifact_parameters(
            mut self,
            inp: crate::model::ProvisioningArtifactProperties,
        ) -> Self {
            self.inner = self.inner.provisioning_artifact_parameters(inp);
            self
        }
        /// <p>The configuration of the provisioning artifact. </p>
        pub fn set_provisioning_artifact_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisionedProductPlan`.
    ///
    /// <p>Creates a plan. A plan includes the list of resources to be  
    /// created (when provisioning a new product) or modified (when updating a provisioned product)
    /// when the plan is executed.</p>
    /// <p>You can create one plan per provisioned product. To create a plan for an existing
    /// provisioned product, the product status must be AVAILBLE or TAINTED.</p>
    /// <p>To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>.
    /// To create or modify the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProvisionedProductPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioned_product_plan_input::Builder,
    }
    impl<C, M, R> CreateProvisionedProductPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisionedProductPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisionedProductPlanInputOperationOutputAlias,
                crate::output::CreateProvisionedProductPlanOutput,
                crate::error::CreateProvisionedProductPlanError,
                crate::input::CreateProvisionedProductPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_name(inp);
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_name(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, inp: crate::model::ProvisionedProductPlanType) -> Self {
            self.inner = self.inner.plan_type(inp);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanType>,
        ) -> Self {
            self.inner = self.inner.set_plan_type(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn notification_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(inp);
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>.</p>
        pub fn path_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(inp);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be
        /// unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be
        /// unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn provisioning_parameters(
            mut self,
            inp: impl Into<crate::model::UpdateProvisioningParameter>,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(inp);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        /// <p>If the plan is for an existing provisioned product, the product must have a <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningArtifact`.
    ///
    /// <p>Creates a provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot create a provisioning artifact for a product that was shared with you.</p>
    ///
    /// <p>The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code>
    /// IAM policy permission. This policy permission is required when using the
    /// <code>ImportFromPhysicalId</code> template source in the information data section.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> CreateProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningArtifactInputOperationOutputAlias,
                crate::output::CreateProvisioningArtifactOutput,
                crate::error::CreateProvisioningArtifactError,
                crate::input::CreateProvisioningArtifactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn parameters(mut self, inp: crate::model::ProvisioningArtifactProperties) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The configuration for the provisioning artifact.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactProperties>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceAction`.
    ///
    /// <p>Creates a self-service action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_action_input::Builder,
    }
    impl<C, M, R> CreateServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceActionInputOperationOutputAlias,
                crate::output::CreateServiceActionOutput,
                crate::error::CreateServiceActionError,
                crate::input::CreateServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn definition_type(mut self, inp: crate::model::ServiceActionDefinitionType) -> Self {
            self.inner = self.inner.definition_type(inp);
            self
        }
        /// <p>The service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn set_definition_type(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDefinitionType>,
        ) -> Self {
            self.inner = self.inner.set_definition_type(input);
            self
        }
        /// Adds a key-value pair to `Definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>Name</dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>Version</dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
        /// </p>
        /// </dd>
        /// <dt>AssumeRole</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>Parameters</dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn definition(
            mut self,
            k: impl Into<crate::model::ServiceActionDefinitionKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.definition(k, v);
            self
        }
        /// <p>The self-service action definition. Can be one of the following:</p>
        /// <dl>
        /// <dt>Name</dt>
        /// <dd>
        /// <p>The name of the AWS Systems Manager document (SSM document). For example, <code>AWS-RestartEC2Instance</code>.</p>
        /// <p>If you are using a shared SSM document, you must provide the ARN instead of the name.</p>
        /// </dd>
        /// <dt>Version</dt>
        /// <dd>
        /// <p>The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
        /// </p>
        /// </dd>
        /// <dt>AssumeRole</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.</p>
        /// <p>To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.</p>
        /// </dd>
        /// <dt>Parameters</dt>
        /// <dd>
        /// <p>The list of parameters in JSON format.</p>
        /// <p>For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.</p>
        /// </dd>
        /// </dl>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTagOption`.
    ///
    /// <p>Creates a TagOption.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTagOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tag_option_input::Builder,
    }
    impl<C, M, R> CreateTagOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagOptionInputOperationOutputAlias,
                crate::output::CreateTagOptionOutput,
                crate::error::CreateTagOptionError,
                crate::input::CreateTagOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption key.</p>
        pub fn key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(inp);
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The TagOption value.</p>
        pub fn value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(inp);
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConstraint`.
    ///
    /// <p>Deletes the specified constraint.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConstraint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_constraint_input::Builder,
    }
    impl<C, M, R> DeleteConstraint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConstraintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConstraintInputOperationOutputAlias,
                crate::output::DeleteConstraintOutput,
                crate::error::DeleteConstraintError,
                crate::input::DeleteConstraintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortfolio`.
    ///
    /// <p>Deletes the specified portfolio.</p>
    /// <p>You cannot delete a portfolio if it was shared with you or if it has associated
    /// products, users, constraints, or shared accounts.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_portfolio_input::Builder,
    }
    impl<C, M, R> DeletePortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePortfolioInputOperationOutputAlias,
                crate::output::DeletePortfolioOutput,
                crate::error::DeletePortfolioError,
                crate::input::DeletePortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortfolioShare`.
    ///
    /// <p>Stops sharing the specified portfolio with the specified account or organization
    /// node. Shares to an organization node can only be deleted by the management account of an
    /// organization or by a delegated administrator.</p>
    /// <p>Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePortfolioShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_portfolio_share_input::Builder,
    }
    impl<C, M, R> DeletePortfolioShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortfolioShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePortfolioShareInputOperationOutputAlias,
                crate::output::DeletePortfolioShareOutput,
                crate::error::DeletePortfolioShareError,
                crate::input::DeletePortfolioShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn organization_node(mut self, inp: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(inp);
            self
        }
        /// <p>The organization node to whom you are going to stop sharing.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProduct`.
    ///
    /// <p>Deletes the specified product.</p>
    /// <p>You cannot delete a product if it was shared with you or is associated with a portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_product_input::Builder,
    }
    impl<C, M, R> DeleteProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProductInputOperationOutputAlias,
                crate::output::DeleteProductOutput,
                crate::error::DeleteProductError,
                crate::input::DeleteProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisionedProductPlan`.
    ///
    /// <p>Deletes the specified plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProvisionedProductPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioned_product_plan_input::Builder,
    }
    impl<C, M, R> DeleteProvisionedProductPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisionedProductPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisionedProductPlanInputOperationOutputAlias,
                crate::output::DeleteProvisionedProductPlanOutput,
                crate::error::DeleteProvisionedProductPlanError,
                crate::input::DeleteProvisionedProductPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(inp);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even
        /// if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, inp: bool) -> Self {
            self.inner = self.inner.ignore_errors(inp);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even
        /// if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_errors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningArtifact`.
    ///
    /// <p>Deletes the specified provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot delete a provisioning artifact associated with a product that was shared with you.
    /// You cannot delete the last provisioning artifact for a product, because a product must have at
    /// least one provisioning artifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> DeleteProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisioningArtifactInputOperationOutputAlias,
                crate::output::DeleteProvisioningArtifactOutput,
                crate::error::DeleteProvisioningArtifactError,
                crate::input::DeleteProvisioningArtifactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceAction`.
    ///
    /// <p>Deletes a self-service action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_action_input::Builder,
    }
    impl<C, M, R> DeleteServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceActionInputOperationOutputAlias,
                crate::output::DeleteServiceActionOutput,
                crate::error::DeleteServiceActionError,
                crate::input::DeleteServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTagOption`.
    ///
    /// <p>Deletes the specified TagOption.</p>
    /// <p>You cannot delete a TagOption if it is associated with a product or portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTagOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tag_option_input::Builder,
    }
    impl<C, M, R> DeleteTagOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagOptionInputOperationOutputAlias,
                crate::output::DeleteTagOptionOutput,
                crate::error::DeleteTagOptionError,
                crate::input::DeleteTagOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConstraint`.
    ///
    /// <p>Gets information about the specified constraint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConstraint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_constraint_input::Builder,
    }
    impl<C, M, R> DescribeConstraint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConstraintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConstraintInputOperationOutputAlias,
                crate::output::DescribeConstraintOutput,
                crate::error::DescribeConstraintError,
                crate::input::DescribeConstraintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCopyProductStatus`.
    ///
    /// <p>Gets the status of the specified copy product operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCopyProductStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_copy_product_status_input::Builder,
    }
    impl<C, M, R> DescribeCopyProductStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCopyProductStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCopyProductStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCopyProductStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCopyProductStatusInputOperationOutputAlias,
                crate::output::DescribeCopyProductStatusOutput,
                crate::error::DescribeCopyProductStatusError,
                crate::input::DescribeCopyProductStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <a>CopyProduct</a>.</p>
        pub fn copy_product_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_product_token(inp);
            self
        }
        /// <p>The token for the copy product operation. This token is returned by <a>CopyProduct</a>.</p>
        pub fn set_copy_product_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_product_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolio`.
    ///
    /// <p>Gets information about the specified portfolio.</p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_portfolio_input::Builder,
    }
    impl<C, M, R> DescribePortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePortfolioInputOperationOutputAlias,
                crate::output::DescribePortfolioOutput,
                crate::error::DescribePortfolioError,
                crate::input::DescribePortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolioShares`.
    ///
    /// <p>Returns a summary of each of the portfolio shares that were created for the specified portfolio.</p>
    /// <p>You can use this API to determine which accounts or organizational nodes this
    /// portfolio have been shared, whether the recipient entity has imported the share, and
    /// whether TagOptions are included with the share.</p>
    /// <p>The <code>PortfolioId</code> and <code>Type</code> parameters are both required.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePortfolioShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_portfolio_shares_input::Builder,
    }
    impl<C, M, R> DescribePortfolioShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePortfolioShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePortfolioSharesInputOperationOutputAlias,
                crate::output::DescribePortfolioSharesOutput,
                crate::error::DescribePortfolioSharesError,
                crate::input::DescribePortfolioSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The unique identifier of the portfolio for which shares will be retrieved.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn r#type(mut self, inp: crate::model::DescribePortfolioShareType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:</p>
        /// <p>1. <code>ACCOUNT</code> - Represents an external account to account share.</p>
        /// <p>2. <code>ORGANIZATION</code> - Represents a share to an organization. This share is available to every account in the organization.</p>
        /// <p>3. <code>ORGANIZATIONAL_UNIT</code> - Represents a share to an organizational unit.</p>
        /// <p>4. <code>ORGANIZATION_MEMBER_ACCOUNT</code> - Represents a share to an account in the organization.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DescribePortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePortfolioShareStatus`.
    ///
    /// <p>Gets the status of the specified portfolio share operation. This API can only be called
    /// by the management account in the organization or by a delegated admin.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePortfolioShareStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_portfolio_share_status_input::Builder,
    }
    impl<C, M, R> DescribePortfolioShareStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePortfolioShareStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortfolioShareStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortfolioShareStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePortfolioShareStatusInputOperationOutputAlias,
                crate::output::DescribePortfolioShareStatusOutput,
                crate::error::DescribePortfolioShareStatusError,
                crate::input::DescribePortfolioShareStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn portfolio_share_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_share_token(inp);
            self
        }
        /// <p>The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProduct`.
    ///
    /// <p>Gets information about the specified product.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_product_input::Builder,
    }
    impl<C, M, R> DescribeProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProductInputOperationOutputAlias,
                crate::output::DescribeProductOutput,
                crate::error::DescribeProductError,
                crate::input::DescribeProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProductAsAdmin`.
    ///
    /// <p>Gets information about the specified product. This operation is run with administrator access.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProductAsAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_product_as_admin_input::Builder,
    }
    impl<C, M, R> DescribeProductAsAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProductAsAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductAsAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductAsAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProductAsAdminInputOperationOutputAlias,
                crate::output::DescribeProductAsAdminOutput,
                crate::error::DescribeProductAsAdminError,
                crate::input::DescribeProductAsAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The product name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated
        /// with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the
        /// product. If this parameter is provided and if TagOptions sharing is enabled in the
        /// portfolio share, the API returns both local and shared TagOptions associated with the
        /// product. Otherwise only local TagOptions will be returned. </p>
        pub fn source_portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_portfolio_id(inp);
            self
        }
        /// <p>The unique identifier of the shared portfolio that the specified product is associated
        /// with.</p>
        /// <p>You can provide this parameter to retrieve the shared TagOptions associated with the
        /// product. If this parameter is provided and if TagOptions sharing is enabled in the
        /// portfolio share, the API returns both local and shared TagOptions associated with the
        /// product. Otherwise only local TagOptions will be returned. </p>
        pub fn set_source_portfolio_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProductView`.
    ///
    /// <p>Gets information about the specified product.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProductView<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_product_view_input::Builder,
    }
    impl<C, M, R> DescribeProductView<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProductView`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductViewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductViewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProductViewInputOperationOutputAlias,
                crate::output::DescribeProductViewOutput,
                crate::error::DescribeProductViewError,
                crate::input::DescribeProductViewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product view identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The product view identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisionedProduct`.
    ///
    /// <p>Gets information about the specified provisioned product.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProvisionedProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioned_product_input::Builder,
    }
    impl<C, M, R> DescribeProvisionedProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisionedProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisionedProductInputOperationOutputAlias,
                crate::output::DescribeProvisionedProductOutput,
                crate::error::DescribeProvisionedProductError,
                crate::input::DescribeProvisionedProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The provisioned product identifier. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the provisioned product. You must provide the name or ID, but not both.</p>
        /// <p>If you do not provide a name or ID, or you provide both name and ID, an <code>InvalidParametersException</code> will occur.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisionedProductPlan`.
    ///
    /// <p>Gets information about the resource changes for the specified plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProvisionedProductPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioned_product_plan_input::Builder,
    }
    impl<C, M, R> DescribeProvisionedProductPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisionedProductPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisionedProductPlanInputOperationOutputAlias,
                crate::output::DescribeProvisionedProductPlanOutput,
                crate::error::DescribeProvisionedProductPlanError,
                crate::input::DescribeProvisionedProductPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(inp);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningArtifact`.
    ///
    /// <p>Gets information about the specified provisioning artifact (also known as a version) for the specified product.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningArtifactInputOperationOutputAlias,
                crate::output::DescribeProvisioningArtifactOutput,
                crate::error::DescribeProvisioningArtifactError,
                crate::input::DescribeProvisioningArtifactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn provisioning_artifact_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(inp);
            self
        }
        /// <p>The provisioning artifact name.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The product name.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>The product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn verbose(mut self, inp: bool) -> Self {
            self.inner = self.inner.verbose(inp);
            self
        }
        /// <p>Indicates whether a verbose level of detail is enabled.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningParameters`.
    ///
    /// <p>Gets information about the configuration required to provision the specified product using
    /// the specified provisioning artifact.</p>
    /// <p>If the output contains a TagOption key with an empty list of values, there is a
    /// TagOption conflict for that key. The end user cannot take action to fix the conflict, and
    /// launch is not blocked. In subsequent calls to <a>ProvisionProduct</a>,
    /// do not include conflicted TagOption keys as tags, or this causes the error
    /// "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
    /// Tag the provisioned product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProvisioningParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_parameters_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningParametersInputOperationOutputAlias,
                crate::output::DescribeProvisioningParametersOutput,
                crate::error::DescribeProvisioningParametersError,
                crate::input::DescribeProvisioningParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier. You must provide the product name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(inp);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(inp);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(inp);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecord`.
    ///
    /// <p>Gets information about the specified request operation.</p>
    /// <p>Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
    /// <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
    /// </p>
    /// <note>
    /// <p>If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new owner
    /// will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to
    /// use <a>ListRecordHistory</a> to see the product's history from when he was the owner.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecord<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_record_input::Builder,
    }
    impl<C, M, R> DescribeRecord<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecordInputOperationOutputAlias,
                crate::output::DescribeRecordOutput,
                crate::error::DescribeRecordError,
                crate::input::DescribeRecordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the
        /// request operation.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The record identifier of the provisioned product. This identifier is returned by the
        /// request operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceAction`.
    ///
    /// <p>Describes a self-service action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_service_action_input::Builder,
    }
    impl<C, M, R> DescribeServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServiceActionInputOperationOutputAlias,
                crate::output::DescribeServiceActionOutput,
                crate::error::DescribeServiceActionError,
                crate::input::DescribeServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceActionExecutionParameters`.
    ///
    /// <p>Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServiceActionExecutionParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_service_action_execution_parameters_input::Builder,
    }
    impl<C, M, R> DescribeServiceActionExecutionParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServiceActionExecutionParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceActionExecutionParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeServiceActionExecutionParametersError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServiceActionExecutionParametersInputOperationOutputAlias,
                crate::output::DescribeServiceActionExecutionParametersOutput,
                crate::error::DescribeServiceActionExecutionParametersError,
                crate::input::DescribeServiceActionExecutionParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn service_action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(inp);
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTagOption`.
    ///
    /// <p>Gets information about the specified TagOption.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTagOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tag_option_input::Builder,
    }
    impl<C, M, R> DescribeTagOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagOptionInputOperationOutputAlias,
                crate::output::DescribeTagOptionOutput,
                crate::error::DescribeTagOptionError,
                crate::input::DescribeTagOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAWSOrganizationsAccess`.
    ///
    /// <p>Disable portfolio sharing through AWS Organizations feature. This feature will not
    /// delete your current shares but it will prevent you from creating new shares throughout your
    /// organization. Current shares will not be in sync with your organization structure if it
    /// changes after calling this API. This API can only be called by the management  account in
    /// the organization.</p>
    /// <p>This API can't be invoked if there are active delegated administrators in the organization.</p>
    /// <p>Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableAWSOrganizationsAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_aws_organizations_access_input::Builder,
    }
    impl<C, M, R> DisableAWSOrganizationsAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableAWSOrganizationsAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAwsOrganizationsAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableAWSOrganizationsAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableAwsOrganizationsAccessInputOperationOutputAlias,
                crate::output::DisableAwsOrganizationsAccessOutput,
                crate::error::DisableAWSOrganizationsAccessError,
                crate::input::DisableAwsOrganizationsAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateBudgetFromResource`.
    ///
    /// <p>Disassociates the specified budget from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateBudgetFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_budget_from_resource_input::Builder,
    }
    impl<C, M, R> DisassociateBudgetFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateBudgetFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBudgetFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBudgetFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateBudgetFromResourceInputOperationOutputAlias,
                crate::output::DisassociateBudgetFromResourceOutput,
                crate::error::DisassociateBudgetFromResourceError,
                crate::input::DisassociateBudgetFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn budget_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.budget_name(inp);
            self
        }
        /// <p>The name of the budget you want to disassociate.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_budget_name(input);
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociatePrincipalFromPortfolio`.
    ///
    /// <p>Disassociates a previously associated principal ARN from a specified
    /// portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociatePrincipalFromPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_principal_from_portfolio_input::Builder,
    }
    impl<C, M, R> DisassociatePrincipalFromPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociatePrincipalFromPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociatePrincipalFromPortfolioOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociatePrincipalFromPortfolioError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociatePrincipalFromPortfolioInputOperationOutputAlias,
                crate::output::DisassociatePrincipalFromPortfolioOutput,
                crate::error::DisassociatePrincipalFromPortfolioError,
                crate::input::DisassociatePrincipalFromPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(inp);
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateProductFromPortfolio`.
    ///
    /// <p>Disassociates the specified product from the specified portfolio. </p>
    /// <p>A delegated admin is authorized to invoke this command.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateProductFromPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_product_from_portfolio_input::Builder,
    }
    impl<C, M, R> DisassociateProductFromPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateProductFromPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateProductFromPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateProductFromPortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateProductFromPortfolioInputOperationOutputAlias,
                crate::output::DisassociateProductFromPortfolioOutput,
                crate::error::DisassociateProductFromPortfolioError,
                crate::input::DisassociateProductFromPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceActionFromProvisioningArtifact`.
    ///
    /// <p>Disassociates the specified self-service action association from the specified provisioning artifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateServiceActionFromProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_service_action_from_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> DisassociateServiceActionFromProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateServiceActionFromProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DisassociateServiceActionFromProvisioningArtifactOutput, aws_smithy_http::result::SdkError<crate::error::DisassociateServiceActionFromProvisioningArtifactError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DisassociateServiceActionFromProvisioningArtifactInputOperationOutputAlias,
                                    crate::output::DisassociateServiceActionFromProvisioningArtifactOutput,
                                    crate::error::DisassociateServiceActionFromProvisioningArtifactError,
                                    crate::input::DisassociateServiceActionFromProvisioningArtifactInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(inp);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTagOptionFromResource`.
    ///
    /// <p>Disassociates the specified TagOption from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateTagOptionFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_tag_option_from_resource_input::Builder,
    }
    impl<C, M, R> DisassociateTagOptionFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTagOptionFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTagOptionFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTagOptionFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTagOptionFromResourceInputOperationOutputAlias,
                crate::output::DisassociateTagOptionFromResourceOutput,
                crate::error::DisassociateTagOptionFromResourceError,
                crate::input::DisassociateTagOptionFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableAWSOrganizationsAccess`.
    ///
    /// <p>Enable portfolio sharing feature through AWS Organizations. This API will allow Service
    /// Catalog to receive updates on your organization in order to sync your shares with the
    /// current structure. This API can only be called by the management  account in the
    /// organization.</p>
    /// <p>By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.</p>
    /// <p>Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableAWSOrganizationsAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_aws_organizations_access_input::Builder,
    }
    impl<C, M, R> EnableAWSOrganizationsAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableAWSOrganizationsAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAwsOrganizationsAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAWSOrganizationsAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableAwsOrganizationsAccessInputOperationOutputAlias,
                crate::output::EnableAwsOrganizationsAccessOutput,
                crate::error::EnableAWSOrganizationsAccessError,
                crate::input::EnableAwsOrganizationsAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ExecuteProvisionedProductPlan`.
    ///
    /// <p>Provisions or modifies a product based on the resource changes for the specified plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteProvisionedProductPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_provisioned_product_plan_input::Builder,
    }
    impl<C, M, R> ExecuteProvisionedProductPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteProvisionedProductPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteProvisionedProductPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteProvisionedProductPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteProvisionedProductPlanInputOperationOutputAlias,
                crate::output::ExecuteProvisionedProductPlanOutput,
                crate::error::ExecuteProvisionedProductPlanError,
                crate::input::ExecuteProvisionedProductPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plan_id(inp);
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plan_id(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteProvisionedProductServiceAction`.
    ///
    /// <p>Executes a self-service action against a provisioned product.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteProvisionedProductServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_provisioned_product_service_action_input::Builder,
    }
    impl<C, M, R> ExecuteProvisionedProductServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteProvisionedProductServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteProvisionedProductServiceActionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ExecuteProvisionedProductServiceActionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteProvisionedProductServiceActionInputOperationOutputAlias,
                crate::output::ExecuteProvisionedProductServiceActionOutput,
                crate::error::ExecuteProvisionedProductServiceActionError,
                crate::input::ExecuteProvisionedProductServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(inp);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn execute_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execute_token(inp);
            self
        }
        /// <p>An idempotency token that uniquely identifies the execute request.</p>
        pub fn set_execute_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execute_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will
        /// override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for
        /// any special parameters such as <code>TARGET</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as <code>TARGET</code>, the provided value will
        /// override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for
        /// any special parameters such as <code>TARGET</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAWSOrganizationsAccessStatus`.
    ///
    /// <p>Get the Access Status for AWS Organization portfolio share feature. This API can only be
    /// called by the management account in the organization or by a delegated admin.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAWSOrganizationsAccessStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aws_organizations_access_status_input::Builder,
    }
    impl<C, M, R> GetAWSOrganizationsAccessStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAWSOrganizationsAccessStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAwsOrganizationsAccessStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAWSOrganizationsAccessStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAwsOrganizationsAccessStatusInputOperationOutputAlias,
                crate::output::GetAwsOrganizationsAccessStatusOutput,
                crate::error::GetAWSOrganizationsAccessStatusError,
                crate::input::GetAwsOrganizationsAccessStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetProvisionedProductOutputs`.
    ///
    /// <p>This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProvisionedProductOutputs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_provisioned_product_outputs_input::Builder,
    }
    impl<C, M, R> GetProvisionedProductOutputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProvisionedProductOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProvisionedProductOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProvisionedProductOutputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProvisionedProductOutputsInputOperationOutputAlias,
                crate::output::GetProvisionedProductOutputsOutput,
                crate::error::GetProvisionedProductOutputsError,
                crate::input::GetProvisionedProductOutputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>The name of the provisioned product that you want the outputs from.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// Appends an item to `OutputKeys`.
        ///
        /// To override the contents of this collection use [`set_output_keys`](Self::set_output_keys).
        ///
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn output_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_keys(inp);
            self
        }
        /// <p>The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product.</p>
        pub fn set_output_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_output_keys(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportAsProvisionedProduct`.
    ///
    /// <p>Requests the import of a resource as a Service Catalog provisioned product that is
    /// associated to a Service Catalog product and provisioning artifact. Once imported, all
    /// supported Service Catalog governance actions are supported on the provisioned
    /// product.</p>
    /// <p>Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and
    /// non-root nested stacks are not supported.</p>
    /// <p>The CloudFormation stack must have one of the following statuses to be imported:
    /// <code>CREATE_COMPLETE</code>, <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>,
    /// <code>IMPORT_ROLLBACK_COMPLETE</code>.</p>
    /// <p>Import of the resource requires that the CloudFormation stack template matches the
    /// associated Service Catalog product provisioning artifact. </p>
    ///
    /// <p>The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code>
    /// and <code>cloudformation:DescribeStacks</code> IAM policy permissions. </p>
    #[derive(std::fmt::Debug)]
    pub struct ImportAsProvisionedProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_as_provisioned_product_input::Builder,
    }
    impl<C, M, R> ImportAsProvisionedProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportAsProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportAsProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportAsProvisionedProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportAsProvisionedProductInputOperationOutputAlias,
                crate::output::ImportAsProvisionedProductOutput,
                crate::error::ImportAsProvisionedProductError,
                crate::input::ImportAsProvisionedProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS
        /// account. The name cannot be updated after the product is provisioned. </p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>The user-friendly name of the provisioned product. The value must be unique for the AWS
        /// account. The name cannot be updated after the product is provisioned. </p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports
        /// CloudFormation stack IDs.</p>
        pub fn physical_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.physical_id(inp);
            self
        }
        /// <p>The unique identifier of the resource to be imported. It only currently supports
        /// CloudFormation stack IDs.</p>
        pub fn set_physical_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_physical_id(input);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAcceptedPortfolioShares`.
    ///
    /// <p>Lists all portfolios for which sharing was accepted by this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAcceptedPortfolioShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accepted_portfolio_shares_input::Builder,
    }
    impl<C, M, R> ListAcceptedPortfolioShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAcceptedPortfolioShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAcceptedPortfolioSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAcceptedPortfolioSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAcceptedPortfolioSharesInputOperationOutputAlias,
                crate::output::ListAcceptedPortfolioSharesOutput,
                crate::error::ListAcceptedPortfolioSharesError,
                crate::input::ListAcceptedPortfolioSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management
        /// account of your organization</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - List default portfolios</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - List imported portfolios</p>
        /// </li>
        /// </ul>
        pub fn portfolio_share_type(mut self, inp: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(inp);
            self
        }
        /// <p>The type of shared portfolios to list. The default is to list imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - List portfolios shared by the management
        /// account of your organization</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - List default portfolios</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - List imported portfolios</p>
        /// </li>
        /// </ul>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBudgetsForResource`.
    ///
    /// <p>Lists all the budgets associated to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBudgetsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_budgets_for_resource_input::Builder,
    }
    impl<C, M, R> ListBudgetsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBudgetsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBudgetsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBudgetsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBudgetsForResourceInputOperationOutputAlias,
                crate::output::ListBudgetsForResourceOutput,
                crate::error::ListBudgetsForResourceError,
                crate::input::ListBudgetsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConstraintsForPortfolio`.
    ///
    /// <p>Lists the constraints for the specified portfolio and product.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConstraintsForPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_constraints_for_portfolio_input::Builder,
    }
    impl<C, M, R> ListConstraintsForPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConstraintsForPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConstraintsForPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConstraintsForPortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConstraintsForPortfolioInputOperationOutputAlias,
                crate::output::ListConstraintsForPortfolioOutput,
                crate::error::ListConstraintsForPortfolioError,
                crate::input::ListConstraintsForPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLaunchPaths`.
    ///
    /// <p>Lists the paths to the specified product. A path is how the user
    /// has access to a specified product, and is necessary when provisioning a product. A path
    /// also determines the constraints put on the product.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLaunchPaths<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_launch_paths_input::Builder,
    }
    impl<C, M, R> ListLaunchPaths<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLaunchPaths`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLaunchPathsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLaunchPathsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLaunchPathsInputOperationOutputAlias,
                crate::output::ListLaunchPathsOutput,
                crate::error::ListLaunchPathsError,
                crate::input::ListLaunchPathsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationPortfolioAccess`.
    ///
    /// <p>Lists the organization nodes that have access to the specified portfolio. This API can
    /// only be called by the management account in the organization or by a delegated
    /// admin.</p>
    /// <p>If a delegated admin is de-registered, they can no longer perform this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizationPortfolioAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_portfolio_access_input::Builder,
    }
    impl<C, M, R> ListOrganizationPortfolioAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationPortfolioAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationPortfolioAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationPortfolioAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationPortfolioAccessInputOperationOutputAlias,
                crate::output::ListOrganizationPortfolioAccessOutput,
                crate::error::ListOrganizationPortfolioAccessError,
                crate::input::ListOrganizationPortfolioAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p>
        /// </li>
        /// </ul>
        pub fn organization_node_type(mut self, inp: crate::model::OrganizationNodeType) -> Self {
            self.inner = self.inner.organization_node_type(inp);
            self
        }
        /// <p>The organization node type that will be returned in the output.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ORGANIZATION</code> - Organization that has access to the portfolio. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.</p>
        /// </li>
        /// </ul>
        pub fn set_organization_node_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationNodeType>,
        ) -> Self {
            self.inner = self.inner.set_organization_node_type(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfolioAccess`.
    ///
    /// <p>Lists the account IDs that have access to the specified portfolio.</p>
    /// <p>A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPortfolioAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portfolio_access_input::Builder,
    }
    impl<C, M, R> ListPortfolioAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortfolioAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfolioAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfolioAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortfolioAccessInputOperationOutputAlias,
                crate::output::ListPortfolioAccessOutput,
                crate::error::ListPortfolioAccessError,
                crate::input::ListPortfolioAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn organization_parent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_parent_id(inp);
            self
        }
        /// <p>The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned.</p>
        pub fn set_organization_parent_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_parent_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfolios`.
    ///
    /// <p>Lists all portfolios in the catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPortfolios<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portfolios_input::Builder,
    }
    impl<C, M, R> ListPortfolios<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortfolios`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfoliosOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfoliosError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortfoliosInputOperationOutputAlias,
                crate::output::ListPortfoliosOutput,
                crate::error::ListPortfoliosError,
                crate::input::ListPortfoliosInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortfoliosForProduct`.
    ///
    /// <p>Lists all portfolios that the specified product is associated with.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPortfoliosForProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portfolios_for_product_input::Builder,
    }
    impl<C, M, R> ListPortfoliosForProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortfoliosForProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortfoliosForProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortfoliosForProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortfoliosForProductInputOperationOutputAlias,
                crate::output::ListPortfoliosForProductOutput,
                crate::error::ListPortfoliosForProductError,
                crate::input::ListPortfoliosForProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipalsForPortfolio`.
    ///
    /// <p>Lists all principal ARNs associated with the specified portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPrincipalsForPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_principals_for_portfolio_input::Builder,
    }
    impl<C, M, R> ListPrincipalsForPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrincipalsForPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalsForPortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalsForPortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPrincipalsForPortfolioInputOperationOutputAlias,
                crate::output::ListPrincipalsForPortfolioOutput,
                crate::error::ListPrincipalsForPortfolioError,
                crate::input::ListPrincipalsForPortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisionedProductPlans`.
    ///
    /// <p>Lists the plans for the specified provisioned product or all plans to which the user has access.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProvisionedProductPlans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioned_product_plans_input::Builder,
    }
    impl<C, M, R> ListProvisionedProductPlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisionedProductPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisionedProductPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisionedProductPlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisionedProductPlansInputOperationOutputAlias,
                crate::output::ListProvisionedProductPlansOutput,
                crate::error::ListProvisionedProductPlansError,
                crate::input::ListProvisionedProductPlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provision_product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_product_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, inp: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(inp);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningArtifacts`.
    ///
    /// <p>Lists all provisioning artifacts (also known as versions) for the specified product.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProvisioningArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioning_artifacts_input::Builder,
    }
    impl<C, M, R> ListProvisioningArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisioningArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisioningArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisioningArtifactsInputOperationOutputAlias,
                crate::output::ListProvisioningArtifactsOutput,
                crate::error::ListProvisioningArtifactsError,
                crate::input::ListProvisioningArtifactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningArtifactsForServiceAction`.
    ///
    /// <p>Lists all provisioning artifacts (also known as versions) for the specified self-service action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProvisioningArtifactsForServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioning_artifacts_for_service_action_input::Builder,
    }
    impl<C, M, R> ListProvisioningArtifactsForServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisioningArtifactsForServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningArtifactsForServiceActionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListProvisioningArtifactsForServiceActionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisioningArtifactsForServiceActionInputOperationOutputAlias,
                crate::output::ListProvisioningArtifactsForServiceActionOutput,
                crate::error::ListProvisioningArtifactsForServiceActionError,
                crate::input::ListProvisioningArtifactsForServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_action_id(inp);
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_action_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecordHistory`.
    ///
    /// <p>Lists the specified requests or all performed requests.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecordHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_record_history_input::Builder,
    }
    impl<C, M, R> ListRecordHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecordHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecordHistoryInputOperationOutputAlias,
                crate::output::ListRecordHistoryOutput,
                crate::error::ListRecordHistoryError,
                crate::input::ListRecordHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, inp: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(inp);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn search_filter(mut self, inp: crate::model::ListRecordHistorySearchFilter) -> Self {
            self.inner = self.inner.search_filter(inp);
            self
        }
        /// <p>The search filter to scope the results.</p>
        pub fn set_search_filter(
            mut self,
            input: std::option::Option<crate::model::ListRecordHistorySearchFilter>,
        ) -> Self {
            self.inner = self.inner.set_search_filter(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesForTagOption`.
    ///
    /// <p>Lists the resources associated with the specified TagOption.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourcesForTagOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_for_tag_option_input::Builder,
    }
    impl<C, M, R> ListResourcesForTagOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourcesForTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesForTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesForTagOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesForTagOptionInputOperationOutputAlias,
                crate::output::ListResourcesForTagOptionOutput,
                crate::error::ListResourcesForTagOptionError,
                crate::input::ListResourcesForTagOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn tag_option_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_option_id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_tag_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tag_option_id(input);
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Portfolio</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Product</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Portfolio</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Product</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceActions`.
    ///
    /// <p>Lists all self-service actions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_actions_input::Builder,
    }
    impl<C, M, R> ListServiceActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceActionsInputOperationOutputAlias,
                crate::output::ListServiceActionsOutput,
                crate::error::ListServiceActionsError,
                crate::input::ListServiceActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceActionsForProvisioningArtifact`.
    ///
    /// <p>Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceActionsForProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_actions_for_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> ListServiceActionsForProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceActionsForProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceActionsForProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServiceActionsForProvisioningArtifactError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceActionsForProvisioningArtifactInputOperationOutputAlias,
                crate::output::ListServiceActionsForProvisioningArtifactOutput,
                crate::error::ListServiceActionsForProvisioningArtifactError,
                crate::input::ListServiceActionsForProvisioningArtifactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStackInstancesForProvisionedProduct`.
    ///
    /// <p>Returns summary information about stack instances that are associated with the specified <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListStackInstancesForProvisionedProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stack_instances_for_provisioned_product_input::Builder,
    }
    impl<C, M, R> ListStackInstancesForProvisionedProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStackInstancesForProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStackInstancesForProvisionedProductOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListStackInstancesForProvisionedProductError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStackInstancesForProvisionedProductInputOperationOutputAlias,
                crate::output::ListStackInstancesForProvisionedProductOutput,
                crate::error::ListStackInstancesForProvisionedProductError,
                crate::input::ListStackInstancesForProvisionedProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagOptions`.
    ///
    /// <p>Lists the specified TagOptions or all TagOptions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tag_options_input::Builder,
    }
    impl<C, M, R> ListTagOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagOptionsInputOperationOutputAlias,
                crate::output::ListTagOptionsOutput,
                crate::error::ListTagOptionsError,
                crate::input::ListTagOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn filters(mut self, inp: crate::model::ListTagOptionsFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all TagOptions.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListTagOptionsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionProduct`.
    ///
    /// <p>Provisions the specified product.</p>
    /// <p>A provisioned product is a resourced instance of a product.
    /// For example, provisioning a product based on a CloudFormation template launches a
    /// CloudFormation stack and its underlying resources.
    /// You can check the status of this request using <a>DescribeRecord</a>.</p>
    /// <p>If the request contains a tag key with an empty list of values, there is a
    /// tag conflict for that key. Do not include conflicted keys as tags, or this causes
    /// the error "Parameter validation failed: Missing required parameter in
    /// Tags[<i>N</i>]:<i>Value</i>".</p>
    #[derive(std::fmt::Debug)]
    pub struct ProvisionProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::provision_product_input::Builder,
    }
    impl<C, M, R> ProvisionProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ProvisionProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionProductOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ProvisionProductInputOperationOutputAlias,
                crate::output::ProvisionProductOutput,
                crate::error::ProvisionProductError,
                crate::input::ProvisionProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(inp);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(inp);
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(inp);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be
        /// unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>A user-friendly name for the provisioned product. This value must be
        /// unique for the AWS account and cannot be updated after the product is provisioned.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn provisioning_parameters(
            mut self,
            inp: impl Into<crate::model::ProvisioningParameter>,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(inp);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            inp: crate::model::ProvisioningPreferences,
        ) -> Self {
            self.inner = self.inner.provisioning_preferences(inp);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::ProvisioningPreferences>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_preferences(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn notification_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(inp);
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn provision_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provision_token(inp);
            self
        }
        /// <p>An idempotency token that uniquely identifies the provisioning request.</p>
        pub fn set_provision_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provision_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectPortfolioShare`.
    ///
    /// <p>Rejects an offer to share the specified portfolio.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectPortfolioShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_portfolio_share_input::Builder,
    }
    impl<C, M, R> RejectPortfolioShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectPortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectPortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectPortfolioShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectPortfolioShareInputOperationOutputAlias,
                crate::output::RejectPortfolioShareOutput,
                crate::error::RejectPortfolioShareError,
                crate::input::RejectPortfolioShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your
        /// organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - Reject imported portfolios.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
        /// </p>
        pub fn portfolio_share_type(mut self, inp: crate::model::PortfolioShareType) -> Self {
            self.inner = self.inner.portfolio_share_type(inp);
            self
        }
        /// <p>The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your
        /// organization.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IMPORTED</code> - Reject imported portfolios.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
        /// </p>
        pub fn set_portfolio_share_type(
            mut self,
            input: std::option::Option<crate::model::PortfolioShareType>,
        ) -> Self {
            self.inner = self.inner.set_portfolio_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ScanProvisionedProducts`.
    ///
    /// <p>Lists the provisioned products that are available (not terminated).</p>
    /// <p>To use additional filtering, see <a>SearchProvisionedProducts</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ScanProvisionedProducts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::scan_provisioned_products_input::Builder,
    }
    impl<C, M, R> ScanProvisionedProducts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ScanProvisionedProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScanProvisionedProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::ScanProvisionedProductsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ScanProvisionedProductsInputOperationOutputAlias,
                crate::output::ScanProvisionedProductsOutput,
                crate::error::ScanProvisionedProductsError,
                crate::input::ScanProvisionedProductsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, inp: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(inp);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProducts`.
    ///
    /// <p>Gets information about the products to which the caller has access.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchProducts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_products_input::Builder,
    }
    impl<C, M, R> SearchProducts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProductsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchProductsInputOperationOutputAlias,
                crate::output::SearchProductsOutput,
                crate::error::SearchProductsError,
                crate::input::SearchProductsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes
        /// all products to which the caller has access.</p>
        pub fn filters(
            mut self,
            k: impl Into<crate::model::ProductViewFilterBy>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes
        /// all products to which the caller has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, inp: crate::model::ProductViewSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProductsAsAdmin`.
    ///
    /// <p>Gets information about the products for the specified portfolio or all products.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchProductsAsAdmin<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_products_as_admin_input::Builder,
    }
    impl<C, M, R> SearchProductsAsAdmin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchProductsAsAdmin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProductsAsAdminOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProductsAsAdminError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchProductsAsAdminInputOperationOutputAlias,
                crate::output::SearchProductsAsAdminOutput,
                crate::error::SearchProductsAsAdminError,
                crate::input::SearchProductsAsAdminInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters. If no search filters are specified, the output includes all products
        /// to which the administrator has access.</p>
        pub fn filters(
            mut self,
            k: impl Into<crate::model::ProductViewFilterBy>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters. If no search filters are specified, the output includes all products
        /// to which the administrator has access.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn sort_by(mut self, inp: crate::model::ProductViewSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProductViewSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn product_source(mut self, inp: crate::model::ProductSource) -> Self {
            self.inner = self.inner.product_source(inp);
            self
        }
        /// <p>Access level of the source of the product.</p>
        pub fn set_product_source(
            mut self,
            input: std::option::Option<crate::model::ProductSource>,
        ) -> Self {
            self.inner = self.inner.set_product_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProvisionedProducts`.
    ///
    /// <p>Gets information about the provisioned products that meet the specified criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchProvisionedProducts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_provisioned_products_input::Builder,
    }
    impl<C, M, R> SearchProvisionedProducts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchProvisionedProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProvisionedProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProvisionedProductsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchProvisionedProductsInputOperationOutputAlias,
                crate::output::SearchProvisionedProductsOutput,
                crate::error::SearchProvisionedProductsError,
                crate::input::SearchProvisionedProductsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn access_level_filter(mut self, inp: crate::model::AccessLevelFilter) -> Self {
            self.inner = self.inner.access_level_filter(inp);
            self
        }
        /// <p>The access level to use to obtain results. The default is <code>User</code>.</p>
        pub fn set_access_level_filter(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilter>,
        ) -> Self {
            self.inner = self.inner.set_access_level_filter(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
        /// <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>,
        /// <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>,
        /// <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>,
        /// <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>,
        /// <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
        /// </p>
        pub fn filters(
            mut self,
            k: impl Into<crate::model::ProvisionedProductViewFilterBy>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>The search filters.</p>
        /// <p>When the key is <code>SearchQuery</code>, the searchable fields are <code>arn</code>,
        /// <code>createdTime</code>, <code>id</code>, <code>lastRecordId</code>,
        /// <code>idempotencyToken</code>, <code>name</code>, <code>physicalId</code>, <code>productId</code>,
        /// <code>provisioningArtifact</code>, <code>type</code>, <code>status</code>,
        /// <code>tags</code>, <code>userArn</code>, <code>userArnSession</code>, <code>lastProvisioningRecordId</code>, <code>lastSuccessfulProvisioningRecordId</code>,
        /// <code>productName</code>, and <code>provisioningArtifactName</code>.</p>
        /// <p>Example: <code>"SearchQuery":["status:AVAILABLE"]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ProvisionedProductViewFilterBy,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>,
        /// and <code>lastRecordId</code>.</p>
        pub fn sort_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The sort field. If no value is specified, the results are not sorted. The valid values are <code>arn</code>, <code>id</code>, <code>name</code>,
        /// and <code>lastRecordId</code>.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The sort order. If no value is specified, the results are not sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of items to return with this call.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateProvisionedProduct`.
    ///
    /// <p>Terminates the specified provisioned product.</p>
    /// <p>This operation does not delete any records associated with the provisioned product.</p>
    /// <p>You can check the status of this request using <a>DescribeRecord</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateProvisionedProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_provisioned_product_input::Builder,
    }
    impl<C, M, R> TerminateProvisionedProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateProvisionedProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateProvisionedProductInputOperationOutputAlias,
                crate::output::TerminateProvisionedProductOutput,
                crate::error::TerminateProvisionedProductError,
                crate::input::TerminateProvisionedProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is
        /// only valid during the termination process. After the provisioned product is terminated,
        /// subsequent requests to terminate the same provisioned product always return
        /// <b>ResourceNotFound</b>.</p>
        pub fn terminate_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminate_token(inp);
            self
        }
        /// <p>An idempotency token that uniquely identifies the termination request. This token is
        /// only valid during the termination process. After the provisioned product is terminated,
        /// subsequent requests to terminate the same provisioned product always return
        /// <b>ResourceNotFound</b>.</p>
        pub fn set_terminate_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_terminate_token(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even
        /// if it cannot delete the underlying resources.</p>
        pub fn ignore_errors(mut self, inp: bool) -> Self {
            self.inner = self.inner.ignore_errors(inp);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops managing the specified provisioned product even
        /// if it cannot delete the underlying resources.</p>
        pub fn set_ignore_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_errors(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes
        /// the Service Catalog provisioned product. However, it does not remove the CloudFormation
        /// stack, stack set, or the underlying resources of the deleted provisioned product. The
        /// default value is false.</p>
        pub fn retain_physical_resources(mut self, inp: bool) -> Self {
            self.inner = self.inner.retain_physical_resources(inp);
            self
        }
        /// <p>When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes
        /// the Service Catalog provisioned product. However, it does not remove the CloudFormation
        /// stack, stack set, or the underlying resources of the deleted provisioned product. The
        /// default value is false.</p>
        pub fn set_retain_physical_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retain_physical_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConstraint`.
    ///
    /// <p>Updates the specified constraint.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConstraint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_constraint_input::Builder,
    }
    impl<C, M, R> UpdateConstraint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConstraint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConstraintOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConstraintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConstraintInputOperationOutputAlias,
                crate::output::UpdateConstraintOutput,
                crate::error::UpdateConstraintError,
                crate::input::UpdateConstraintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>LAUNCH</dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p>
        /// <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
        /// </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p>
        /// <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
        /// </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be
        /// account-agnostic so the administrator can create fewer resources per shared account.</p>
        /// <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>NOTIFICATION</dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p>
        /// <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
        /// </p>
        /// </dd>
        /// <dt>RESOURCE_UPDATE</dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p>
        /// <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
        /// </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>STACKSET</dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p>
        /// <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
        /// </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>TEMPLATE</dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see
        /// <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn parameters(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:</p>
        /// <dl>
        /// <dt>LAUNCH</dt>
        /// <dd>
        /// <p>You are required to specify either the <code>RoleArn</code> or the <code>LocalRoleName</code> but can't use both.</p>
        /// <p>Specify the <code>RoleArn</code> property as follows:</p>
        /// <p>
        /// <code>{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}</code>
        /// </p>
        /// <p>Specify the <code>LocalRoleName</code> property as follows:</p>
        /// <p>
        /// <code>{"LocalRoleName": "SCBasicLaunchRole"}</code>
        /// </p>
        /// <p>If you specify the <code>LocalRoleName</code> property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be
        /// account-agnostic so the administrator can create fewer resources per shared account.</p>
        /// <note>
        /// <p>The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.</p>
        /// </note>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>LAUNCH</code> constraint on a product and portfolio.</p>
        /// </dd>
        /// <dt>NOTIFICATION</dt>
        /// <dd>
        /// <p>Specify the <code>NotificationArns</code> property as follows:</p>
        /// <p>
        /// <code>{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}</code>
        /// </p>
        /// </dd>
        /// <dt>RESOURCE_UPDATE</dt>
        /// <dd>
        /// <p>Specify the <code>TagUpdatesOnProvisionedProduct</code> property as follows:</p>
        /// <p>
        /// <code>{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}</code>
        /// </p>
        /// <p>The <code>TagUpdatesOnProvisionedProduct</code> property accepts a string value of <code>ALLOWED</code> or <code>NOT_ALLOWED</code>.</p>
        /// </dd>
        /// <dt>STACKSET</dt>
        /// <dd>
        /// <p>Specify the <code>Parameters</code> property as follows:</p>
        /// <p>
        /// <code>{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}</code>
        /// </p>
        /// <p>You cannot have both a <code>LAUNCH</code> and a <code>STACKSET</code> constraint.</p>
        /// <p>You also cannot have more than one <code>STACKSET</code> constraint on a product and portfolio.</p>
        /// <p>Products with a <code>STACKSET</code> constraint will launch an AWS CloudFormation stack set.</p>
        /// </dd>
        /// <dt>TEMPLATE</dt>
        /// <dd>
        /// <p>Specify the <code>Rules</code> property. For more information, see
        /// <a href="http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html">Template Constraint Rules</a>.</p>
        /// </dd>
        /// </dl>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortfolio`.
    ///
    /// <p>Updates the specified portfolio.</p>
    /// <p>You cannot update a product that was shared with you.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_portfolio_input::Builder,
    }
    impl<C, M, R> UpdatePortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortfolioOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortfolioError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePortfolioInputOperationOutputAlias,
                crate::output::UpdatePortfolioOutput,
                crate::error::UpdatePortfolioError,
                crate::input::UpdatePortfolioInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_name(inp);
            self
        }
        /// <p>The updated name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_name(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add.</p>
        pub fn add_tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.add_tags(inp);
            self
        }
        /// <p>The tags to add.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove.</p>
        pub fn remove_tags(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tags(inp);
            self
        }
        /// <p>The tags to remove.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortfolioShare`.
    ///
    /// <p>Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share. </p>
    ///
    /// <p>The portfolio share cannot be updated if the <code> CreatePortfolioShare</code> operation is <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED.</p>
    ///
    /// <p>You must provide the <code>accountId</code> or organization node in the input, but not both.</p>
    ///
    /// <p>If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type. </p>
    ///
    /// <p>This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for that action. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePortfolioShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_portfolio_share_input::Builder,
    }
    impl<C, M, R> UpdatePortfolioShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePortfolioShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortfolioShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortfolioShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePortfolioShareInputOperationOutputAlias,
                crate::output::UpdatePortfolioShareOutput,
                crate::error::UpdatePortfolioShareError,
                crate::input::UpdatePortfolioShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn portfolio_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portfolio_id(inp);
            self
        }
        /// <p>The unique identifier of the portfolio for which the share will be updated.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portfolio_id(input);
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The AWS Account Id of the recipient account. This field is required when updating an external account to account type share.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn organization_node(mut self, inp: crate::model::OrganizationNode) -> Self {
            self.inner = self.inner.organization_node(inp);
            self
        }
        /// <p>Information about the organization node.</p>
        pub fn set_organization_node(
            mut self,
            input: std::option::Option<crate::model::OrganizationNode>,
        ) -> Self {
            self.inner = self.inner.set_organization_node(input);
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn share_tag_options(mut self, inp: bool) -> Self {
            self.inner = self.inner.share_tag_options(inp);
            self
        }
        /// <p>A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_share_tag_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProduct`.
    ///
    /// <p>Updates the specified product.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_product_input::Builder,
    }
    impl<C, M, R> UpdateProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProductOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProductInputOperationOutputAlias,
                crate::output::UpdateProductOutput,
                crate::error::UpdateProductError,
                crate::input::UpdateProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated product name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated product name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The updated owner of the product.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the product.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn distributor(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distributor(inp);
            self
        }
        /// <p>The updated distributor of the product.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_distributor(input);
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn support_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_description(inp);
            self
        }
        /// <p>The updated support description for the product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_description(input);
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn support_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_email(inp);
            self
        }
        /// <p>The updated support email for the product.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_support_email(input);
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn support_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.support_url(inp);
            self
        }
        /// <p>The updated support URL for the product.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_support_url(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>The tags to add to the product.</p>
        pub fn add_tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.add_tags(inp);
            self
        }
        /// <p>The tags to add to the product.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTags`.
        ///
        /// To override the contents of this collection use [`set_remove_tags`](Self::set_remove_tags).
        ///
        /// <p>The tags to remove from the product.</p>
        pub fn remove_tags(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tags(inp);
            self
        }
        /// <p>The tags to remove from the product.</p>
        pub fn set_remove_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisionedProduct`.
    ///
    /// <p>Requests updates to the configuration of the specified provisioned product.</p>
    /// <p>If there are tags associated with the object, they cannot be updated or added.
    /// Depending on the specific updates requested, this operation can update with no
    /// interruption, with some interruption, or replace the provisioned product entirely.</p>
    /// <p>You can check the status of this request using <a>DescribeRecord</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProvisionedProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_provisioned_product_input::Builder,
    }
    impl<C, M, R> UpdateProvisionedProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProvisionedProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisionedProductOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProvisionedProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProvisionedProductInputOperationOutputAlias,
                crate::output::UpdateProvisionedProductOutput,
                crate::error::UpdateProvisionedProductError,
                crate::input::UpdateProvisionedProductInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn provisioned_product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_name(inp);
            self
        }
        /// <p>The name of the provisioned product. You cannot specify both
        /// <code>ProvisionedProductName</code> and <code>ProvisionedProductId</code>.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_name(input);
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product. You must provide the name or ID, but not both.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The identifier of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>The name of the product. You must provide the name or ID, but not both.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn provisioning_artifact_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_name(inp);
            self
        }
        /// <p>The name of the provisioning artifact. You must provide the name or ID, but not both.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_name(input);
            self
        }
        /// <p>The path identifier. This value is optional if the product
        /// has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn path_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_id(inp);
            self
        }
        /// <p>The path identifier. This value is optional if the product
        /// has a default path, and required if the product has more than one path. You must provide the name or ID, but not both.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_id(input);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn path_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_name(inp);
            self
        }
        /// <p>The name of the path. You must provide the name or ID, but not both.</p>
        pub fn set_path_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_name(input);
            self
        }
        /// Appends an item to `ProvisioningParameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>The new parameters.</p>
        pub fn provisioning_parameters(
            mut self,
            inp: impl Into<crate::model::UpdateProvisioningParameter>,
        ) -> Self {
            self.inner = self.inner.provisioning_parameters(inp);
            self
        }
        /// <p>The new parameters.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_parameters(input);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn provisioning_preferences(
            mut self,
            inp: crate::model::UpdateProvisioningPreferences,
        ) -> Self {
            self.inner = self.inner.provisioning_preferences(inp);
            self
        }
        /// <p>An object that contains information about the provisioning preferences for a stack set.</p>
        pub fn set_provisioning_preferences(
            mut self,
            input: std::option::Option<crate::model::UpdateProvisioningPreferences>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_preferences(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn update_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_token(inp);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning update request.</p>
        pub fn set_update_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisionedProductProperties`.
    ///
    /// <p>Requests updates to the properties of the specified provisioned product.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProvisionedProductProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_provisioned_product_properties_input::Builder,
    }
    impl<C, M, R> UpdateProvisionedProductProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProvisionedProductProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisionedProductPropertiesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateProvisionedProductPropertiesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProvisionedProductPropertiesInputOperationOutputAlias,
                crate::output::UpdateProvisionedProductPropertiesOutput,
                crate::error::UpdateProvisionedProductPropertiesError,
                crate::input::UpdateProvisionedProductPropertiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioned_product_id(inp);
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_id(input);
            self
        }
        /// Adds a key-value pair to `ProvisionedProductProperties`.
        ///
        /// To override the contents of this collection use [`set_provisioned_product_properties`](Self::set_provisioned_product_properties).
        ///
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an
        /// administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch
        /// role that is associated with a provisioned product. This role is used when an end user
        /// calls a provisioning operation such as <code>UpdateProvisionedProduct</code>,
        /// <code>TerminateProvisionedProduct</code>, or
        /// <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        ///
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user
        /// that has permission to see, update, terminate, and execute service actions in the
        /// provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and
        /// administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can
        /// describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>,
        /// but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or
        /// Service Catalog console such as update, terminate, and execute service actions.
        /// If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through
        /// API or the Service Catalog console on that provisioned product.</p>
        pub fn provisioned_product_properties(
            mut self,
            k: impl Into<crate::model::PropertyKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.provisioned_product_properties(k, v);
            self
        }
        /// <p>A map that contains the provisioned product properties to be updated.</p>
        /// <p>The <code>LAUNCH_ROLE</code> key accepts role ARNs. This key allows an
        /// administrator to call <code>UpdateProvisionedProductProperties</code> to update the launch
        /// role that is associated with a provisioned product. This role is used when an end user
        /// calls a provisioning operation such as <code>UpdateProvisionedProduct</code>,
        /// <code>TerminateProvisionedProduct</code>, or
        /// <code>ExecuteProvisionedProductServiceAction</code>. Only a role ARN is valid. A user ARN is invalid. </p>
        ///
        /// <p>The <code>OWNER</code> key accepts user ARNs and role ARNs. The owner is the user
        /// that has permission to see, update, terminate, and execute service actions in the
        /// provisioned product.</p>
        /// <p>The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and
        /// administrators can see ownership history of the provisioned product using the <code>ListRecordHistory</code> API. The new owner can
        /// describe all past records for the provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>,
        /// but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.</p>
        /// <p>If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or
        /// Service Catalog console such as update, terminate, and execute service actions.
        /// If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through
        /// API or the Service Catalog console on that provisioned product.</p>
        pub fn set_provisioned_product_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_provisioned_product_properties(input);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>The idempotency token that uniquely identifies the provisioning product update request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProvisioningArtifact`.
    ///
    /// <p>Updates the specified provisioning artifact (also known as a version) for the specified product.</p>
    /// <p>You cannot update a provisioning artifact for a product that was shared with you.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProvisioningArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_provisioning_artifact_input::Builder,
    }
    impl<C, M, R> UpdateProvisioningArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProvisioningArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProvisioningArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProvisioningArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProvisioningArtifactInputOperationOutputAlias,
                crate::output::UpdateProvisioningArtifactOutput,
                crate::error::UpdateProvisioningArtifactError,
                crate::input::UpdateProvisioningArtifactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_artifact_id(inp);
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_artifact_id(input);
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn active(mut self, inp: bool) -> Self {
            self.inner = self.inner.active(inp);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        /// <p>Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform
        /// users that the product version is deprecated. Users are able to make updates to a provisioned product
        /// of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn guidance(mut self, inp: crate::model::ProvisioningArtifactGuidance) -> Self {
            self.inner = self.inner.guidance(inp);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        /// <p>The <code>DEFAULT</code> value indicates that the product version is active.</p>
        /// <p>The administrator can set the guidance to <code>DEPRECATED</code> to inform
        /// users that the product version is deprecated. Users are able to make updates to a provisioned product
        /// of a deprecated version but cannot launch new provisioned products using a deprecated version.</p>
        pub fn set_guidance(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
        ) -> Self {
            self.inner = self.inner.set_guidance(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceAction`.
    ///
    /// <p>Updates a self-service action.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_action_input::Builder,
    }
    impl<C, M, R> UpdateServiceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceActionInputOperationOutputAlias,
                crate::output::UpdateServiceActionOutput,
                crate::error::UpdateServiceActionError,
                crate::input::UpdateServiceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>A map that defines the self-service action.</p>
        pub fn definition(
            mut self,
            k: impl Into<crate::model::ServiceActionDefinitionKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.definition(k, v);
            self
        }
        /// <p>A map that defines the self-service action.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn accept_language(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_language(inp);
            self
        }
        /// <p>The language code.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>en</code> - English (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>jp</code> - Japanese</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>zh</code> - Chinese</p>
        /// </li>
        /// </ul>
        pub fn set_accept_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accept_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagOption`.
    ///
    /// <p>Updates the specified TagOption.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTagOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_tag_option_input::Builder,
    }
    impl<C, M, R> UpdateTagOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTagOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTagOptionInputOperationOutputAlias,
                crate::output::UpdateTagOptionOutput,
                crate::error::UpdateTagOptionError,
                crate::input::UpdateTagOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated value.</p>
        pub fn value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(inp);
            self
        }
        /// <p>The updated value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The updated active state.</p>
        pub fn active(mut self, inp: bool) -> Self {
            self.inner = self.inner.active(inp);
            self
        }
        /// <p>The updated active state.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
