// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a TagOption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOptionDetail {
    /// <p>The TagOption key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The TagOption value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The TagOption active state.</p>
    pub active: std::option::Option<bool>,
    /// <p>The TagOption identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The AWS account Id of the owner account that created the TagOption.</p>
    pub owner: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagOptionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOptionDetail");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("active", &self.active);
        formatter.field("id", &self.id);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`TagOptionDetail`](crate::model::TagOptionDetail)
pub mod tag_option_detail {
    /// A builder for [`TagOptionDetail`](crate::model::TagOptionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) active: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The TagOption key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The TagOption value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The TagOption active state.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>The TagOption active state.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The TagOption identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The AWS account Id of the owner account that created the TagOption.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The AWS account Id of the owner account that created the TagOption.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`TagOptionDetail`](crate::model::TagOptionDetail)
        pub fn build(self) -> crate::model::TagOptionDetail {
            crate::model::TagOptionDetail {
                key: self.key,
                value: self.value,
                active: self.active,
                id: self.id,
                owner: self.owner,
            }
        }
    }
}
impl TagOptionDetail {
    /// Creates a new builder-style object to manufacture [`TagOptionDetail`](crate::model::TagOptionDetail)
    pub fn builder() -> crate::model::tag_option_detail::Builder {
        crate::model::tag_option_detail::Builder::default()
    }
}

/// <p>An object containing detailed information about the self-service action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceActionDetail {
    /// <p>Summary information about the self-service action.</p>
    pub service_action_summary: std::option::Option<crate::model::ServiceActionSummary>,
    /// <p>A map that defines the self-service action.</p>
    pub definition: std::option::Option<
        std::collections::HashMap<crate::model::ServiceActionDefinitionKey, std::string::String>,
    >,
}
impl std::fmt::Debug for ServiceActionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceActionDetail");
        formatter.field("service_action_summary", &self.service_action_summary);
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}
/// See [`ServiceActionDetail`](crate::model::ServiceActionDetail)
pub mod service_action_detail {
    /// A builder for [`ServiceActionDetail`](crate::model::ServiceActionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_summary: std::option::Option<crate::model::ServiceActionSummary>,
        pub(crate) definition: std::option::Option<
            std::collections::HashMap<
                crate::model::ServiceActionDefinitionKey,
                std::string::String,
            >,
        >,
    }
    impl Builder {
        /// <p>Summary information about the self-service action.</p>
        pub fn service_action_summary(mut self, input: crate::model::ServiceActionSummary) -> Self {
            self.service_action_summary = Some(input);
            self
        }
        /// <p>Summary information about the self-service action.</p>
        pub fn set_service_action_summary(
            mut self,
            input: std::option::Option<crate::model::ServiceActionSummary>,
        ) -> Self {
            self.service_action_summary = input;
            self
        }
        /// Adds a key-value pair to `definition`.
        ///
        /// To override the contents of this collection use [`set_definition`](Self::set_definition).
        ///
        /// <p>A map that defines the self-service action.</p>
        pub fn definition(
            mut self,
            k: impl Into<crate::model::ServiceActionDefinitionKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.definition.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.definition = Some(hash_map);
            self
        }
        /// <p>A map that defines the self-service action.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ServiceActionDefinitionKey,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceActionDetail`](crate::model::ServiceActionDetail)
        pub fn build(self) -> crate::model::ServiceActionDetail {
            crate::model::ServiceActionDetail {
                service_action_summary: self.service_action_summary,
                definition: self.definition,
            }
        }
    }
}
impl ServiceActionDetail {
    /// Creates a new builder-style object to manufacture [`ServiceActionDetail`](crate::model::ServiceActionDetail)
    pub fn builder() -> crate::model::service_action_detail::Builder {
        crate::model::service_action_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceActionDefinitionKey {
    #[allow(missing_docs)] // documentation missing in model
    AssumeRole,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Parameters,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceActionDefinitionKey {
    fn from(s: &str) -> Self {
        match s {
            "AssumeRole" => ServiceActionDefinitionKey::AssumeRole,
            "Name" => ServiceActionDefinitionKey::Name,
            "Parameters" => ServiceActionDefinitionKey::Parameters,
            "Version" => ServiceActionDefinitionKey::Version,
            other => ServiceActionDefinitionKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceActionDefinitionKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceActionDefinitionKey::from(s))
    }
}
impl ServiceActionDefinitionKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceActionDefinitionKey::AssumeRole => "AssumeRole",
            ServiceActionDefinitionKey::Name => "Name",
            ServiceActionDefinitionKey::Parameters => "Parameters",
            ServiceActionDefinitionKey::Version => "Version",
            ServiceActionDefinitionKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AssumeRole", "Name", "Parameters", "Version"]
    }
}
impl AsRef<str> for ServiceActionDefinitionKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detailed information about the self-service action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceActionSummary {
    /// <p>The self-service action identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The self-service action name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The self-service action description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
    pub definition_type: std::option::Option<crate::model::ServiceActionDefinitionType>,
}
impl std::fmt::Debug for ServiceActionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceActionSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("definition_type", &self.definition_type);
        formatter.finish()
    }
}
/// See [`ServiceActionSummary`](crate::model::ServiceActionSummary)
pub mod service_action_summary {
    /// A builder for [`ServiceActionSummary`](crate::model::ServiceActionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) definition_type: std::option::Option<crate::model::ServiceActionDefinitionType>,
    }
    impl Builder {
        /// <p>The self-service action identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The self-service action name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The self-service action name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The self-service action description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The self-service action description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn definition_type(mut self, input: crate::model::ServiceActionDefinitionType) -> Self {
            self.definition_type = Some(input);
            self
        }
        /// <p>The self-service action definition type. For example, <code>SSM_AUTOMATION</code>.</p>
        pub fn set_definition_type(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDefinitionType>,
        ) -> Self {
            self.definition_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceActionSummary`](crate::model::ServiceActionSummary)
        pub fn build(self) -> crate::model::ServiceActionSummary {
            crate::model::ServiceActionSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                definition_type: self.definition_type,
            }
        }
    }
}
impl ServiceActionSummary {
    /// Creates a new builder-style object to manufacture [`ServiceActionSummary`](crate::model::ServiceActionSummary)
    pub fn builder() -> crate::model::service_action_summary::Builder {
        crate::model::service_action_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceActionDefinitionType {
    #[allow(missing_docs)] // documentation missing in model
    SsmAutomation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceActionDefinitionType {
    fn from(s: &str) -> Self {
        match s {
            "SSM_AUTOMATION" => ServiceActionDefinitionType::SsmAutomation,
            other => ServiceActionDefinitionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceActionDefinitionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceActionDefinitionType::from(s))
    }
}
impl ServiceActionDefinitionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceActionDefinitionType::SsmAutomation => "SSM_AUTOMATION",
            ServiceActionDefinitionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSM_AUTOMATION"]
    }
}
impl AsRef<str> for ServiceActionDefinitionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => Status::Available,
            "CREATING" => Status::Creating,
            "FAILED" => Status::Failed,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Available => "AVAILABLE",
            Status::Creating => "CREATING",
            Status::Failed => "FAILED",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "FAILED"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a provisioning artifact (also known as a version) for a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactDetail {
    /// <p>The identifier of the provisioning artifact.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the provisioning artifact.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of provisioning artifact.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ProvisioningArtifactType>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates whether the product version is active.</p>
    pub active: std::option::Option<bool>,
    /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
    pub guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
}
impl std::fmt::Debug for ProvisioningArtifactDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactDetail");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_time", &self.created_time);
        formatter.field("active", &self.active);
        formatter.field("guidance", &self.guidance);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactDetail`](crate::model::ProvisioningArtifactDetail)
pub mod provisioning_artifact_detail {
    /// A builder for [`ProvisioningArtifactDetail`](crate::model::ProvisioningArtifactDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ProvisioningArtifactType>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) active: std::option::Option<bool>,
        pub(crate) guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
    }
    impl Builder {
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of provisioning artifact.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ProvisioningArtifactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of provisioning artifact.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Indicates whether the product version is active.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        pub fn guidance(mut self, input: crate::model::ProvisioningArtifactGuidance) -> Self {
            self.guidance = Some(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        pub fn set_guidance(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
        ) -> Self {
            self.guidance = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactDetail`](crate::model::ProvisioningArtifactDetail)
        pub fn build(self) -> crate::model::ProvisioningArtifactDetail {
            crate::model::ProvisioningArtifactDetail {
                id: self.id,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                created_time: self.created_time,
                active: self.active,
                guidance: self.guidance,
            }
        }
    }
}
impl ProvisioningArtifactDetail {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactDetail`](crate::model::ProvisioningArtifactDetail)
    pub fn builder() -> crate::model::provisioning_artifact_detail::Builder {
        crate::model::provisioning_artifact_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisioningArtifactGuidance {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisioningArtifactGuidance {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ProvisioningArtifactGuidance::Default,
            "DEPRECATED" => ProvisioningArtifactGuidance::Deprecated,
            other => ProvisioningArtifactGuidance::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisioningArtifactGuidance {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisioningArtifactGuidance::from(s))
    }
}
impl ProvisioningArtifactGuidance {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisioningArtifactGuidance::Default => "DEFAULT",
            ProvisioningArtifactGuidance::Deprecated => "DEPRECATED",
            ProvisioningArtifactGuidance::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "DEPRECATED"]
    }
}
impl AsRef<str> for ProvisioningArtifactGuidance {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisioningArtifactType {
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationTemplate,
    #[allow(missing_docs)] // documentation missing in model
    MarketplaceAmi,
    #[allow(missing_docs)] // documentation missing in model
    MarketplaceCar,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisioningArtifactType {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD_FORMATION_TEMPLATE" => ProvisioningArtifactType::CloudFormationTemplate,
            "MARKETPLACE_AMI" => ProvisioningArtifactType::MarketplaceAmi,
            "MARKETPLACE_CAR" => ProvisioningArtifactType::MarketplaceCar,
            other => ProvisioningArtifactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisioningArtifactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisioningArtifactType::from(s))
    }
}
impl ProvisioningArtifactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisioningArtifactType::CloudFormationTemplate => "CLOUD_FORMATION_TEMPLATE",
            ProvisioningArtifactType::MarketplaceAmi => "MARKETPLACE_AMI",
            ProvisioningArtifactType::MarketplaceCar => "MARKETPLACE_CAR",
            ProvisioningArtifactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLOUD_FORMATION_TEMPLATE",
            "MARKETPLACE_AMI",
            "MARKETPLACE_CAR",
        ]
    }
}
impl AsRef<str> for ProvisioningArtifactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    InProgressInError,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => RecordStatus::Created,
            "FAILED" => RecordStatus::Failed,
            "IN_PROGRESS" => RecordStatus::InProgress,
            "IN_PROGRESS_IN_ERROR" => RecordStatus::InProgressInError,
            "SUCCEEDED" => RecordStatus::Succeeded,
            other => RecordStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordStatus::from(s))
    }
}
impl RecordStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordStatus::Created => "CREATED",
            RecordStatus::Failed => "FAILED",
            RecordStatus::InProgress => "IN_PROGRESS",
            RecordStatus::InProgressInError => "IN_PROGRESS_IN_ERROR",
            RecordStatus::Succeeded => "SUCCEEDED",
            RecordStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATED",
            "FAILED",
            "IN_PROGRESS",
            "IN_PROGRESS_IN_ERROR",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for RecordStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropertyKey {
    #[allow(missing_docs)] // documentation missing in model
    LaunchRole,
    #[allow(missing_docs)] // documentation missing in model
    Owner,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropertyKey {
    fn from(s: &str) -> Self {
        match s {
            "LAUNCH_ROLE" => PropertyKey::LaunchRole,
            "OWNER" => PropertyKey::Owner,
            other => PropertyKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropertyKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropertyKey::from(s))
    }
}
impl PropertyKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropertyKey::LaunchRole => "LAUNCH_ROLE",
            PropertyKey::Owner => "OWNER",
            PropertyKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAUNCH_ROLE", "OWNER"]
    }
}
impl AsRef<str> for PropertyKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordDetail {
    /// <p>The identifier of the record.</p>
    pub record_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the provisioned product.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The status of the provisioned product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The request was created but the operation has not started.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The requested operation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS_IN_ERROR</code> - The provisioned product is under change but the
    /// requested operation failed and some remediation is occurring. For example, a rollback.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code> - The requested operation has successfully completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The requested operation has unsuccessfully completed.
    /// Investigate using the error messages returned.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::RecordStatus>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time when the record was last updated.</p>
    pub updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
    pub provisioned_product_type: std::option::Option<std::string::String>,
    /// <p>The record type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISION_PRODUCT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_PROVISIONED_PRODUCT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TERMINATE_PROVISIONED_PRODUCT</code>
    /// </p>
    /// </li>
    /// </ul>
    pub record_type: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The path identifier.</p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>The errors that occurred.</p>
    pub record_errors: std::option::Option<std::vec::Vec<crate::model::RecordError>>,
    /// <p>One or more tags.</p>
    pub record_tags: std::option::Option<std::vec::Vec<crate::model::RecordTag>>,
    /// <p>The ARN of the launch role associated with the provisioned product.</p>
    pub launch_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecordDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordDetail");
        formatter.field("record_id", &self.record_id);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.field("provisioned_product_type", &self.provisioned_product_type);
        formatter.field("record_type", &self.record_type);
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("path_id", &self.path_id);
        formatter.field("record_errors", &self.record_errors);
        formatter.field("record_tags", &self.record_tags);
        formatter.field("launch_role_arn", &self.launch_role_arn);
        formatter.finish()
    }
}
/// See [`RecordDetail`](crate::model::RecordDetail)
pub mod record_detail {
    /// A builder for [`RecordDetail`](crate::model::RecordDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecordStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) provisioned_product_type: std::option::Option<std::string::String>,
        pub(crate) record_type: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) record_errors: std::option::Option<std::vec::Vec<crate::model::RecordError>>,
        pub(crate) record_tags: std::option::Option<std::vec::Vec<crate::model::RecordTag>>,
        pub(crate) launch_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the record.</p>
        pub fn record_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_id = Some(input.into());
            self
        }
        /// <p>The identifier of the record.</p>
        pub fn set_record_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_id = input;
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The request was created but the operation has not started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The requested operation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS_IN_ERROR</code> - The provisioned product is under change but the
        /// requested operation failed and some remediation is occurring. For example, a rollback.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code> - The requested operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The requested operation has unsuccessfully completed.
        /// Investigate using the error messages returned.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::RecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The request was created but the operation has not started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The requested operation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS_IN_ERROR</code> - The provisioned product is under change but the
        /// requested operation failed and some remediation is occurring. For example, a rollback.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code> - The requested operation has successfully completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The requested operation has unsuccessfully completed.
        /// Investigate using the error messages returned.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time when the record was last updated.</p>
        pub fn updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_time = Some(input);
            self
        }
        /// <p>The time when the record was last updated.</p>
        pub fn set_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_time = input;
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn provisioned_product_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_type = Some(input.into());
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn set_provisioned_product_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_type = input;
            self
        }
        /// <p>The record type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISION_PRODUCT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PROVISIONED_PRODUCT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATE_PROVISIONED_PRODUCT</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn record_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_type = Some(input.into());
            self
        }
        /// <p>The record type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISION_PRODUCT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_PROVISIONED_PRODUCT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TERMINATE_PROVISIONED_PRODUCT</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_record_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_type = input;
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The path identifier.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// Appends an item to `record_errors`.
        ///
        /// To override the contents of this collection use [`set_record_errors`](Self::set_record_errors).
        ///
        /// <p>The errors that occurred.</p>
        pub fn record_errors(mut self, input: impl Into<crate::model::RecordError>) -> Self {
            let mut v = self.record_errors.unwrap_or_default();
            v.push(input.into());
            self.record_errors = Some(v);
            self
        }
        /// <p>The errors that occurred.</p>
        pub fn set_record_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordError>>,
        ) -> Self {
            self.record_errors = input;
            self
        }
        /// Appends an item to `record_tags`.
        ///
        /// To override the contents of this collection use [`set_record_tags`](Self::set_record_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn record_tags(mut self, input: impl Into<crate::model::RecordTag>) -> Self {
            let mut v = self.record_tags.unwrap_or_default();
            v.push(input.into());
            self.record_tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_record_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordTag>>,
        ) -> Self {
            self.record_tags = input;
            self
        }
        /// <p>The ARN of the launch role associated with the provisioned product.</p>
        pub fn launch_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the launch role associated with the provisioned product.</p>
        pub fn set_launch_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordDetail`](crate::model::RecordDetail)
        pub fn build(self) -> crate::model::RecordDetail {
            crate::model::RecordDetail {
                record_id: self.record_id,
                provisioned_product_name: self.provisioned_product_name,
                status: self.status,
                created_time: self.created_time,
                updated_time: self.updated_time,
                provisioned_product_type: self.provisioned_product_type,
                record_type: self.record_type,
                provisioned_product_id: self.provisioned_product_id,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                path_id: self.path_id,
                record_errors: self.record_errors,
                record_tags: self.record_tags,
                launch_role_arn: self.launch_role_arn,
            }
        }
    }
}
impl RecordDetail {
    /// Creates a new builder-style object to manufacture [`RecordDetail`](crate::model::RecordDetail)
    pub fn builder() -> crate::model::record_detail::Builder {
        crate::model::record_detail::Builder::default()
    }
}

/// <p>Information about a tag, which is a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordTag {
    /// <p>The key for this tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for this tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecordTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordTag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`RecordTag`](crate::model::RecordTag)
pub mod record_tag {
    /// A builder for [`RecordTag`](crate::model::RecordTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for this tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for this tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for this tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for this tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordTag`](crate::model::RecordTag)
        pub fn build(self) -> crate::model::RecordTag {
            crate::model::RecordTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl RecordTag {
    /// Creates a new builder-style object to manufacture [`RecordTag`](crate::model::RecordTag)
    pub fn builder() -> crate::model::record_tag::Builder {
        crate::model::record_tag::Builder::default()
    }
}

/// <p>The error code and description resulting from an operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordError {
    /// <p>The numeric value of the error.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The description of the error.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordError");
        formatter.field("code", &self.code);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`RecordError`](crate::model::RecordError)
pub mod record_error {
    /// A builder for [`RecordError`](crate::model::RecordError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The numeric value of the error.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The numeric value of the error.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The description of the error.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the error.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordError`](crate::model::RecordError)
        pub fn build(self) -> crate::model::RecordError {
            crate::model::RecordError {
                code: self.code,
                description: self.description,
            }
        }
    }
}
impl RecordError {
    /// Creates a new builder-style object to manufacture [`RecordError`](crate::model::RecordError)
    pub fn builder() -> crate::model::record_error::Builder {
        crate::model::record_error::Builder::default()
    }
}

/// <p>Information about a tag. A tag is a key-value pair. Tags are propagated
/// to the resources created when provisioning a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for this key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for this key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for this key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The user-defined preferences that will be applied when updating a provisioned product. Not all preferences are applicable to all provisioned product types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisioningPreferences {
    /// <p>One or more AWS accounts that will have access to the provisioned product.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
    /// <p>If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.</p>
    pub stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more AWS Regions where the provisioned product will be available.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
    /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
    pub stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
    /// <p>The default value is <code>0</code> if no value is specified.</p>
    pub stack_set_failure_tolerance_count: std::option::Option<i32>,
    /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
    pub stack_set_failure_tolerance_percentage: std::option::Option<i32>,
    /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
    /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
    pub stack_set_max_concurrency_count: std::option::Option<i32>,
    /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
    /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
    pub stack_set_max_concurrency_percentage: std::option::Option<i32>,
    /// <p>Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <dl>
    /// <dt>CREATE</dt>
    /// <dd>
    /// <p>Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.</p>
    /// </dd>
    /// <dt>UPDATE</dt>
    /// <dd>
    /// <p>Updates the stack set represented by the provisioned product and also its stack instances.</p>
    /// </dd>
    /// <dt>DELETE</dt>
    /// <dd>
    /// <p>Deletes a stack instance in the stack set represented by the provisioned product.</p>
    /// </dd>
    /// </dl>
    pub stack_set_operation_type: std::option::Option<crate::model::StackSetOperationType>,
}
impl std::fmt::Debug for UpdateProvisioningPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisioningPreferences");
        formatter.field("stack_set_accounts", &self.stack_set_accounts);
        formatter.field("stack_set_regions", &self.stack_set_regions);
        formatter.field(
            "stack_set_failure_tolerance_count",
            &self.stack_set_failure_tolerance_count,
        );
        formatter.field(
            "stack_set_failure_tolerance_percentage",
            &self.stack_set_failure_tolerance_percentage,
        );
        formatter.field(
            "stack_set_max_concurrency_count",
            &self.stack_set_max_concurrency_count,
        );
        formatter.field(
            "stack_set_max_concurrency_percentage",
            &self.stack_set_max_concurrency_percentage,
        );
        formatter.field("stack_set_operation_type", &self.stack_set_operation_type);
        formatter.finish()
    }
}
/// See [`UpdateProvisioningPreferences`](crate::model::UpdateProvisioningPreferences)
pub mod update_provisioning_preferences {
    /// A builder for [`UpdateProvisioningPreferences`](crate::model::UpdateProvisioningPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_set_failure_tolerance_count: std::option::Option<i32>,
        pub(crate) stack_set_failure_tolerance_percentage: std::option::Option<i32>,
        pub(crate) stack_set_max_concurrency_count: std::option::Option<i32>,
        pub(crate) stack_set_max_concurrency_percentage: std::option::Option<i32>,
        pub(crate) stack_set_operation_type:
            std::option::Option<crate::model::StackSetOperationType>,
    }
    impl Builder {
        /// Appends an item to `stack_set_accounts`.
        ///
        /// To override the contents of this collection use [`set_stack_set_accounts`](Self::set_stack_set_accounts).
        ///
        /// <p>One or more AWS accounts that will have access to the provisioned product.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.</p>
        pub fn stack_set_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_accounts.unwrap_or_default();
            v.push(input.into());
            self.stack_set_accounts = Some(v);
            self
        }
        /// <p>One or more AWS accounts that will have access to the provisioned product.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The AWS accounts specified should be within the list of accounts in the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all accounts from the <code>STACKSET</code> constraint.</p>
        pub fn set_stack_set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_accounts = input;
            self
        }
        /// Appends an item to `stack_set_regions`.
        ///
        /// To override the contents of this collection use [`set_stack_set_regions`](Self::set_stack_set_regions).
        ///
        /// <p>One or more AWS Regions where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
        pub fn stack_set_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_regions.unwrap_or_default();
            v.push(input.into());
            self.stack_set_regions = Some(v);
            self
        }
        /// <p>One or more AWS Regions where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
        pub fn set_stack_set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_regions = input;
            self
        }
        /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        /// <p>The default value is <code>0</code> if no value is specified.</p>
        pub fn stack_set_failure_tolerance_count(mut self, input: i32) -> Self {
            self.stack_set_failure_tolerance_count = Some(input);
            self
        }
        /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        /// <p>The default value is <code>0</code> if no value is specified.</p>
        pub fn set_stack_set_failure_tolerance_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_failure_tolerance_count = input;
            self
        }
        /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        pub fn stack_set_failure_tolerance_percentage(mut self, input: i32) -> Self {
            self.stack_set_failure_tolerance_percentage = Some(input);
            self
        }
        /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        pub fn set_stack_set_failure_tolerance_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_failure_tolerance_percentage = input;
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn stack_set_max_concurrency_count(mut self, input: i32) -> Self {
            self.stack_set_max_concurrency_count = Some(input);
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn set_stack_set_max_concurrency_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_max_concurrency_count = input;
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn stack_set_max_concurrency_percentage(mut self, input: i32) -> Self {
            self.stack_set_max_concurrency_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn set_stack_set_max_concurrency_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_max_concurrency_percentage = input;
            self
        }
        /// <p>Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <dl>
        /// <dt>CREATE</dt>
        /// <dd>
        /// <p>Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.</p>
        /// </dd>
        /// <dt>UPDATE</dt>
        /// <dd>
        /// <p>Updates the stack set represented by the provisioned product and also its stack instances.</p>
        /// </dd>
        /// <dt>DELETE</dt>
        /// <dd>
        /// <p>Deletes a stack instance in the stack set represented by the provisioned product.</p>
        /// </dd>
        /// </dl>
        pub fn stack_set_operation_type(
            mut self,
            input: crate::model::StackSetOperationType,
        ) -> Self {
            self.stack_set_operation_type = Some(input);
            self
        }
        /// <p>Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is <code>UPDATE</code> if nothing is specified.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <dl>
        /// <dt>CREATE</dt>
        /// <dd>
        /// <p>Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.</p>
        /// </dd>
        /// <dt>UPDATE</dt>
        /// <dd>
        /// <p>Updates the stack set represented by the provisioned product and also its stack instances.</p>
        /// </dd>
        /// <dt>DELETE</dt>
        /// <dd>
        /// <p>Deletes a stack instance in the stack set represented by the provisioned product.</p>
        /// </dd>
        /// </dl>
        pub fn set_stack_set_operation_type(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationType>,
        ) -> Self {
            self.stack_set_operation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisioningPreferences`](crate::model::UpdateProvisioningPreferences)
        pub fn build(self) -> crate::model::UpdateProvisioningPreferences {
            crate::model::UpdateProvisioningPreferences {
                stack_set_accounts: self.stack_set_accounts,
                stack_set_regions: self.stack_set_regions,
                stack_set_failure_tolerance_count: self.stack_set_failure_tolerance_count,
                stack_set_failure_tolerance_percentage: self.stack_set_failure_tolerance_percentage,
                stack_set_max_concurrency_count: self.stack_set_max_concurrency_count,
                stack_set_max_concurrency_percentage: self.stack_set_max_concurrency_percentage,
                stack_set_operation_type: self.stack_set_operation_type,
            }
        }
    }
}
impl UpdateProvisioningPreferences {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningPreferences`](crate::model::UpdateProvisioningPreferences)
    pub fn builder() -> crate::model::update_provisioning_preferences::Builder {
        crate::model::update_provisioning_preferences::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetOperationType {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetOperationType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => StackSetOperationType::Create,
            "DELETE" => StackSetOperationType::Delete,
            "UPDATE" => StackSetOperationType::Update,
            other => StackSetOperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetOperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetOperationType::from(s))
    }
}
impl StackSetOperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetOperationType::Create => "CREATE",
            StackSetOperationType::Delete => "DELETE",
            StackSetOperationType::Update => "UPDATE",
            StackSetOperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "DELETE", "UPDATE"]
    }
}
impl AsRef<str> for StackSetOperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The parameter key-value pair used to update a provisioned product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisioningParameter {
    /// <p>The parameter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The parameter value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>If set to true, <code>Value</code> is ignored and the previous parameter value is kept.</p>
    pub use_previous_value: bool,
}
impl std::fmt::Debug for UpdateProvisioningParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisioningParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("use_previous_value", &self.use_previous_value);
        formatter.finish()
    }
}
/// See [`UpdateProvisioningParameter`](crate::model::UpdateProvisioningParameter)
pub mod update_provisioning_parameter {
    /// A builder for [`UpdateProvisioningParameter`](crate::model::UpdateProvisioningParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) use_previous_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The parameter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The parameter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The parameter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The parameter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>If set to true, <code>Value</code> is ignored and the previous parameter value is kept.</p>
        pub fn use_previous_value(mut self, input: bool) -> Self {
            self.use_previous_value = Some(input);
            self
        }
        /// <p>If set to true, <code>Value</code> is ignored and the previous parameter value is kept.</p>
        pub fn set_use_previous_value(mut self, input: std::option::Option<bool>) -> Self {
            self.use_previous_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisioningParameter`](crate::model::UpdateProvisioningParameter)
        pub fn build(self) -> crate::model::UpdateProvisioningParameter {
            crate::model::UpdateProvisioningParameter {
                key: self.key,
                value: self.value,
                use_previous_value: self.use_previous_value.unwrap_or_default(),
            }
        }
    }
}
impl UpdateProvisioningParameter {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningParameter`](crate::model::UpdateProvisioningParameter)
    pub fn builder() -> crate::model::update_provisioning_parameter::Builder {
        crate::model::update_provisioning_parameter::Builder::default()
    }
}

/// <p>Information about a product view.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductViewDetail {
    /// <p>Summary information about the product view.</p>
    pub product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
    /// <p>The status of the product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The product is ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Product creation has started; the product is not ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - An action failed.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The ARN of the product.</p>
    pub product_arn: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ProductViewDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductViewDetail");
        formatter.field("product_view_summary", &self.product_view_summary);
        formatter.field("status", &self.status);
        formatter.field("product_arn", &self.product_arn);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`ProductViewDetail`](crate::model::ProductViewDetail)
pub mod product_view_detail {
    /// A builder for [`ProductViewDetail`](crate::model::ProductViewDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) product_arn: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Summary information about the product view.</p>
        pub fn product_view_summary(mut self, input: crate::model::ProductViewSummary) -> Self {
            self.product_view_summary = Some(input);
            self
        }
        /// <p>Summary information about the product view.</p>
        pub fn set_product_view_summary(
            mut self,
            input: std::option::Option<crate::model::ProductViewSummary>,
        ) -> Self {
            self.product_view_summary = input;
            self
        }
        /// <p>The status of the product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The product is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Product creation has started; the product is not ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - An action failed.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The product is ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Product creation has started; the product is not ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - An action failed.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The ARN of the product.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the product.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_arn = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductViewDetail`](crate::model::ProductViewDetail)
        pub fn build(self) -> crate::model::ProductViewDetail {
            crate::model::ProductViewDetail {
                product_view_summary: self.product_view_summary,
                status: self.status,
                product_arn: self.product_arn,
                created_time: self.created_time,
            }
        }
    }
}
impl ProductViewDetail {
    /// Creates a new builder-style object to manufacture [`ProductViewDetail`](crate::model::ProductViewDetail)
    pub fn builder() -> crate::model::product_view_detail::Builder {
        crate::model::product_view_detail::Builder::default()
    }
}

/// <p>Summary information about a product view.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductViewSummary {
    /// <p>The product view identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the product.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The owner of the product. Contact the product administrator for the significance of
    /// this value.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>Short description of the product.</p>
    pub short_description: std::option::Option<std::string::String>,
    /// <p>The product type. Contact the product administrator for the significance of this
    /// value. If this value is <code>MARKETPLACE</code>, the product was created by AWS
    /// Marketplace.</p>
    pub r#type: std::option::Option<crate::model::ProductType>,
    /// <p>The distributor of the product. Contact the product administrator for the
    /// significance of this value.</p>
    pub distributor: std::option::Option<std::string::String>,
    /// <p>Indicates whether the product has a default path.
    /// If the product does not have a default path, call <a>ListLaunchPaths</a>
    /// to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not
    /// required, and the output of <a>ProductViewSummary</a> can be used directly with
    /// <a>DescribeProvisioningParameters</a>.</p>
    pub has_default_path: bool,
    /// <p>The email contact information to obtain support for this Product.</p>
    pub support_email: std::option::Option<std::string::String>,
    /// <p>The description of the support for this Product.</p>
    pub support_description: std::option::Option<std::string::String>,
    /// <p>The URL information to obtain support for this Product.</p>
    pub support_url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProductViewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductViewSummary");
        formatter.field("id", &self.id);
        formatter.field("product_id", &self.product_id);
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("short_description", &self.short_description);
        formatter.field("r#type", &self.r#type);
        formatter.field("distributor", &self.distributor);
        formatter.field("has_default_path", &self.has_default_path);
        formatter.field("support_email", &self.support_email);
        formatter.field("support_description", &self.support_description);
        formatter.field("support_url", &self.support_url);
        formatter.finish()
    }
}
/// See [`ProductViewSummary`](crate::model::ProductViewSummary)
pub mod product_view_summary {
    /// A builder for [`ProductViewSummary`](crate::model::ProductViewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) short_description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ProductType>,
        pub(crate) distributor: std::option::Option<std::string::String>,
        pub(crate) has_default_path: std::option::Option<bool>,
        pub(crate) support_email: std::option::Option<std::string::String>,
        pub(crate) support_description: std::option::Option<std::string::String>,
        pub(crate) support_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product view identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product view identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the product.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The owner of the product. Contact the product administrator for the significance of
        /// this value.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the product. Contact the product administrator for the significance of
        /// this value.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>Short description of the product.</p>
        pub fn short_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_description = Some(input.into());
            self
        }
        /// <p>Short description of the product.</p>
        pub fn set_short_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.short_description = input;
            self
        }
        /// <p>The product type. Contact the product administrator for the significance of this
        /// value. If this value is <code>MARKETPLACE</code>, the product was created by AWS
        /// Marketplace.</p>
        pub fn r#type(mut self, input: crate::model::ProductType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The product type. Contact the product administrator for the significance of this
        /// value. If this value is <code>MARKETPLACE</code>, the product was created by AWS
        /// Marketplace.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ProductType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The distributor of the product. Contact the product administrator for the
        /// significance of this value.</p>
        pub fn distributor(mut self, input: impl Into<std::string::String>) -> Self {
            self.distributor = Some(input.into());
            self
        }
        /// <p>The distributor of the product. Contact the product administrator for the
        /// significance of this value.</p>
        pub fn set_distributor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.distributor = input;
            self
        }
        /// <p>Indicates whether the product has a default path.
        /// If the product does not have a default path, call <a>ListLaunchPaths</a>
        /// to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not
        /// required, and the output of <a>ProductViewSummary</a> can be used directly with
        /// <a>DescribeProvisioningParameters</a>.</p>
        pub fn has_default_path(mut self, input: bool) -> Self {
            self.has_default_path = Some(input);
            self
        }
        /// <p>Indicates whether the product has a default path.
        /// If the product does not have a default path, call <a>ListLaunchPaths</a>
        /// to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not
        /// required, and the output of <a>ProductViewSummary</a> can be used directly with
        /// <a>DescribeProvisioningParameters</a>.</p>
        pub fn set_has_default_path(mut self, input: std::option::Option<bool>) -> Self {
            self.has_default_path = input;
            self
        }
        /// <p>The email contact information to obtain support for this Product.</p>
        pub fn support_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_email = Some(input.into());
            self
        }
        /// <p>The email contact information to obtain support for this Product.</p>
        pub fn set_support_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_email = input;
            self
        }
        /// <p>The description of the support for this Product.</p>
        pub fn support_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_description = Some(input.into());
            self
        }
        /// <p>The description of the support for this Product.</p>
        pub fn set_support_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.support_description = input;
            self
        }
        /// <p>The URL information to obtain support for this Product.</p>
        pub fn support_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_url = Some(input.into());
            self
        }
        /// <p>The URL information to obtain support for this Product.</p>
        pub fn set_support_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductViewSummary`](crate::model::ProductViewSummary)
        pub fn build(self) -> crate::model::ProductViewSummary {
            crate::model::ProductViewSummary {
                id: self.id,
                product_id: self.product_id,
                name: self.name,
                owner: self.owner,
                short_description: self.short_description,
                r#type: self.r#type,
                distributor: self.distributor,
                has_default_path: self.has_default_path.unwrap_or_default(),
                support_email: self.support_email,
                support_description: self.support_description,
                support_url: self.support_url,
            }
        }
    }
}
impl ProductViewSummary {
    /// Creates a new builder-style object to manufacture [`ProductViewSummary`](crate::model::ProductViewSummary)
    pub fn builder() -> crate::model::product_view_summary::Builder {
        crate::model::product_view_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductType {
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationTemplate,
    #[allow(missing_docs)] // documentation missing in model
    Marketplace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductType {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD_FORMATION_TEMPLATE" => ProductType::CloudFormationTemplate,
            "MARKETPLACE" => ProductType::Marketplace,
            other => ProductType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductType::from(s))
    }
}
impl ProductType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductType::CloudFormationTemplate => "CLOUD_FORMATION_TEMPLATE",
            ProductType::Marketplace => "MARKETPLACE",
            ProductType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD_FORMATION_TEMPLATE", "MARKETPLACE"]
    }
}
impl AsRef<str> for ProductType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ShareStatus::Completed,
            "COMPLETED_WITH_ERRORS" => ShareStatus::CompletedWithErrors,
            "ERROR" => ShareStatus::Error,
            "IN_PROGRESS" => ShareStatus::InProgress,
            "NOT_STARTED" => ShareStatus::NotStarted,
            other => ShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareStatus::from(s))
    }
}
impl ShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareStatus::Completed => "COMPLETED",
            ShareStatus::CompletedWithErrors => "COMPLETED_WITH_ERRORS",
            ShareStatus::Error => "ERROR",
            ShareStatus::InProgress => "IN_PROGRESS",
            ShareStatus::NotStarted => "NOT_STARTED",
            ShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "COMPLETED_WITH_ERRORS",
            "ERROR",
            "IN_PROGRESS",
            "NOT_STARTED",
        ]
    }
}
impl AsRef<str> for ShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the organization node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationNode {
    /// <p>The organization node type.</p>
    pub r#type: std::option::Option<crate::model::OrganizationNodeType>,
    /// <p>The identifier of the organization node.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationNode");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`OrganizationNode`](crate::model::OrganizationNode)
pub mod organization_node {
    /// A builder for [`OrganizationNode`](crate::model::OrganizationNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OrganizationNodeType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The organization node type.</p>
        pub fn r#type(mut self, input: crate::model::OrganizationNodeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The organization node type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationNodeType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier of the organization node.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The identifier of the organization node.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationNode`](crate::model::OrganizationNode)
        pub fn build(self) -> crate::model::OrganizationNode {
            crate::model::OrganizationNode {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl OrganizationNode {
    /// Creates a new builder-style object to manufacture [`OrganizationNode`](crate::model::OrganizationNode)
    pub fn builder() -> crate::model::organization_node::Builder {
        crate::model::organization_node::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrganizationNodeType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationalUnit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrganizationNodeType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => OrganizationNodeType::Account,
            "ORGANIZATION" => OrganizationNodeType::Organization,
            "ORGANIZATIONAL_UNIT" => OrganizationNodeType::OrganizationalUnit,
            other => OrganizationNodeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrganizationNodeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrganizationNodeType::from(s))
    }
}
impl OrganizationNodeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrganizationNodeType::Account => "ACCOUNT",
            OrganizationNodeType::Organization => "ORGANIZATION",
            OrganizationNodeType::OrganizationalUnit => "ORGANIZATIONAL_UNIT",
            OrganizationNodeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORGANIZATION", "ORGANIZATIONAL_UNIT"]
    }
}
impl AsRef<str> for OrganizationNodeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a portfolio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortfolioDetail {
    /// <p>The portfolio identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN assigned to the portfolio.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name to use for display purposes.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description of the portfolio.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the portfolio provider.</p>
    pub provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PortfolioDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortfolioDetail");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("provider_name", &self.provider_name);
        formatter.finish()
    }
}
/// See [`PortfolioDetail`](crate::model::PortfolioDetail)
pub mod portfolio_detail {
    /// A builder for [`PortfolioDetail`](crate::model::PortfolioDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The portfolio identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN assigned to the portfolio.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN assigned to the portfolio.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name to use for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the portfolio.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// <p>The name of the portfolio provider.</p>
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PortfolioDetail`](crate::model::PortfolioDetail)
        pub fn build(self) -> crate::model::PortfolioDetail {
            crate::model::PortfolioDetail {
                id: self.id,
                arn: self.arn,
                display_name: self.display_name,
                description: self.description,
                created_time: self.created_time,
                provider_name: self.provider_name,
            }
        }
    }
}
impl PortfolioDetail {
    /// Creates a new builder-style object to manufacture [`PortfolioDetail`](crate::model::PortfolioDetail)
    pub fn builder() -> crate::model::portfolio_detail::Builder {
        crate::model::portfolio_detail::Builder::default()
    }
}

/// <p>Information about a constraint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConstraintDetail {
    /// <p>The identifier of the constraint.</p>
    pub constraint_id: std::option::Option<std::string::String>,
    /// <p>The type of constraint.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LAUNCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOTIFICATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>STACKSET</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPLATE</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The description of the constraint.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The owner of the constraint.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The identifier of the product the constraint applies to. Note that a constraint applies to a specific instance of a product within a certain portfolio.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the portfolio the product resides in. The constraint applies only to the instance of the product that lives within this portfolio.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConstraintDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConstraintDetail");
        formatter.field("constraint_id", &self.constraint_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("owner", &self.owner);
        formatter.field("product_id", &self.product_id);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.finish()
    }
}
/// See [`ConstraintDetail`](crate::model::ConstraintDetail)
pub mod constraint_detail {
    /// A builder for [`ConstraintDetail`](crate::model::ConstraintDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraint_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the constraint.</p>
        pub fn constraint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_id = Some(input.into());
            self
        }
        /// <p>The identifier of the constraint.</p>
        pub fn set_constraint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_id = input;
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>STACKSET</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>STACKSET</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The owner of the constraint.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the constraint.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The identifier of the product the constraint applies to. Note that a constraint applies to a specific instance of a product within a certain portfolio.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the product the constraint applies to. Note that a constraint applies to a specific instance of a product within a certain portfolio.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the portfolio the product resides in. The constraint applies only to the instance of the product that lives within this portfolio.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The identifier of the portfolio the product resides in. The constraint applies only to the instance of the product that lives within this portfolio.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConstraintDetail`](crate::model::ConstraintDetail)
        pub fn build(self) -> crate::model::ConstraintDetail {
            crate::model::ConstraintDetail {
                constraint_id: self.constraint_id,
                r#type: self.r#type,
                description: self.description,
                owner: self.owner,
                product_id: self.product_id,
                portfolio_id: self.portfolio_id,
            }
        }
    }
}
impl ConstraintDetail {
    /// Creates a new builder-style object to manufacture [`ConstraintDetail`](crate::model::ConstraintDetail)
    pub fn builder() -> crate::model::constraint_detail::Builder {
        crate::model::constraint_detail::Builder::default()
    }
}

/// <p>Information about a provisioned product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedProductAttribute {
    /// <p>The user-friendly name of the provisioned product.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the provisioned product.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The current status of the provisioned product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
    /// recent operation succeeded and completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
    /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
    /// completed the requested operation but is not exactly what was requested. For example, a
    /// request to update to a new version failed and the stack rolled back to the current version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
    /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
    /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ProvisionedProductStatus>,
    /// <p>The current status message of the provisioned product.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
    /// the same response is returned for each repeated request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last request performed on this provisioned product.</p>
    pub last_record_id: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// ProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// UpdateProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// ExecuteProvisionedProductPlan
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// TerminateProvisionedProduct
    /// </p>
    /// </li>
    /// </ul>
    pub last_provisioning_record_id: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// ProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// UpdateProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// ExecuteProvisionedProductPlan
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// TerminateProvisionedProduct
    /// </p>
    /// </li>
    /// </ul>
    pub last_successful_provisioning_record_id: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The assigned identifier for the resource, such as an EC2 instance ID or an S3 bucket name.</p>
    pub physical_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the product.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact.</p>
    pub provisioning_artifact_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM user.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM user in the session. This ARN might contain a session ID.</p>
    pub user_arn_session: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedProductAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedProductAttribute");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_time", &self.created_time);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("last_record_id", &self.last_record_id);
        formatter.field(
            "last_provisioning_record_id",
            &self.last_provisioning_record_id,
        );
        formatter.field(
            "last_successful_provisioning_record_id",
            &self.last_successful_provisioning_record_id,
        );
        formatter.field("tags", &self.tags);
        formatter.field("physical_id", &self.physical_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("product_name", &self.product_name);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field(
            "provisioning_artifact_name",
            &self.provisioning_artifact_name,
        );
        formatter.field("user_arn", &self.user_arn);
        formatter.field("user_arn_session", &self.user_arn_session);
        formatter.finish()
    }
}
/// See [`ProvisionedProductAttribute`](crate::model::ProvisionedProductAttribute)
pub mod provisioned_product_attribute {
    /// A builder for [`ProvisionedProductAttribute`](crate::model::ProvisionedProductAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedProductStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) last_record_id: std::option::Option<std::string::String>,
        pub(crate) last_provisioning_record_id: std::option::Option<std::string::String>,
        pub(crate) last_successful_provisioning_record_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) physical_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_name: std::option::Option<std::string::String>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) user_arn_session: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the provisioned product.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the provisioned product.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The current status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
        /// recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
        /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
        /// completed the requested operation but is not exactly what was requested. For example, a
        /// request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
        /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
        /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ProvisionedProductStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
        /// recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
        /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
        /// completed the requested operation but is not exactly what was requested. For example, a
        /// request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
        /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
        /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The current status message of the provisioned product.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The current status message of the provisioned product.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product.</p>
        pub fn last_record_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product.</p>
        pub fn set_last_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_record_id = input;
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn last_provisioning_record_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_provisioning_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_last_provisioning_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_provisioning_record_id = input;
            self
        }
        /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn last_successful_provisioning_record_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_successful_provisioning_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_last_successful_provisioning_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_successful_provisioning_record_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The assigned identifier for the resource, such as an EC2 instance ID or an S3 bucket name.</p>
        pub fn physical_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_id = Some(input.into());
            self
        }
        /// <p>The assigned identifier for the resource, such as an EC2 instance ID or an S3 bucket name.</p>
        pub fn set_physical_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.physical_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the product.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The name of the product.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn provisioning_artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The ARN of the IAM user in the session. This ARN might contain a session ID.</p>
        pub fn user_arn_session(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn_session = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM user in the session. This ARN might contain a session ID.</p>
        pub fn set_user_arn_session(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_arn_session = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedProductAttribute`](crate::model::ProvisionedProductAttribute)
        pub fn build(self) -> crate::model::ProvisionedProductAttribute {
            crate::model::ProvisionedProductAttribute {
                name: self.name,
                arn: self.arn,
                r#type: self.r#type,
                id: self.id,
                status: self.status,
                status_message: self.status_message,
                created_time: self.created_time,
                idempotency_token: self.idempotency_token,
                last_record_id: self.last_record_id,
                last_provisioning_record_id: self.last_provisioning_record_id,
                last_successful_provisioning_record_id: self.last_successful_provisioning_record_id,
                tags: self.tags,
                physical_id: self.physical_id,
                product_id: self.product_id,
                product_name: self.product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_artifact_name: self.provisioning_artifact_name,
                user_arn: self.user_arn,
                user_arn_session: self.user_arn_session,
            }
        }
    }
}
impl ProvisionedProductAttribute {
    /// Creates a new builder-style object to manufacture [`ProvisionedProductAttribute`](crate::model::ProvisionedProductAttribute)
    pub fn builder() -> crate::model::provisioned_product_attribute::Builder {
        crate::model::provisioned_product_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedProductStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    PlanInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Tainted,
    #[allow(missing_docs)] // documentation missing in model
    UnderChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedProductStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ProvisionedProductStatus::Available,
            "ERROR" => ProvisionedProductStatus::Error,
            "PLAN_IN_PROGRESS" => ProvisionedProductStatus::PlanInProgress,
            "TAINTED" => ProvisionedProductStatus::Tainted,
            "UNDER_CHANGE" => ProvisionedProductStatus::UnderChange,
            other => ProvisionedProductStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedProductStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedProductStatus::from(s))
    }
}
impl ProvisionedProductStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedProductStatus::Available => "AVAILABLE",
            ProvisionedProductStatus::Error => "ERROR",
            ProvisionedProductStatus::PlanInProgress => "PLAN_IN_PROGRESS",
            ProvisionedProductStatus::Tainted => "TAINTED",
            ProvisionedProductStatus::UnderChange => "UNDER_CHANGE",
            ProvisionedProductStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "ERROR",
            "PLAN_IN_PROGRESS",
            "TAINTED",
            "UNDER_CHANGE",
        ]
    }
}
impl AsRef<str> for ProvisionedProductStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedProductViewFilterBy {
    #[allow(missing_docs)] // documentation missing in model
    SearchQuery,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedProductViewFilterBy {
    fn from(s: &str) -> Self {
        match s {
            "SearchQuery" => ProvisionedProductViewFilterBy::SearchQuery,
            other => ProvisionedProductViewFilterBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedProductViewFilterBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedProductViewFilterBy::from(s))
    }
}
impl ProvisionedProductViewFilterBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedProductViewFilterBy::SearchQuery => "SearchQuery",
            ProvisionedProductViewFilterBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SearchQuery"]
    }
}
impl AsRef<str> for ProvisionedProductViewFilterBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The access level to use to filter results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessLevelFilter {
    /// <p>The access level.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Account</code> - Filter results based on the account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Role</code> - Filter results based on the federated role of the specified user.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>User</code> - Filter results based on the specified user.</p>
    /// </li>
    /// </ul>
    pub key: std::option::Option<crate::model::AccessLevelFilterKey>,
    /// <p>The user to which the access level applies. The only supported value is <code>Self</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessLevelFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessLevelFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AccessLevelFilter`](crate::model::AccessLevelFilter)
pub mod access_level_filter {
    /// A builder for [`AccessLevelFilter`](crate::model::AccessLevelFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::AccessLevelFilterKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access level.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Account</code> - Filter results based on the account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Role</code> - Filter results based on the federated role of the specified user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>User</code> - Filter results based on the specified user.</p>
        /// </li>
        /// </ul>
        pub fn key(mut self, input: crate::model::AccessLevelFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The access level.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Account</code> - Filter results based on the account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Role</code> - Filter results based on the federated role of the specified user.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>User</code> - Filter results based on the specified user.</p>
        /// </li>
        /// </ul>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::AccessLevelFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The user to which the access level applies. The only supported value is <code>Self</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The user to which the access level applies. The only supported value is <code>Self</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessLevelFilter`](crate::model::AccessLevelFilter)
        pub fn build(self) -> crate::model::AccessLevelFilter {
            crate::model::AccessLevelFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AccessLevelFilter {
    /// Creates a new builder-style object to manufacture [`AccessLevelFilter`](crate::model::AccessLevelFilter)
    pub fn builder() -> crate::model::access_level_filter::Builder {
        crate::model::access_level_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessLevelFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessLevelFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "Account" => AccessLevelFilterKey::Account,
            "Role" => AccessLevelFilterKey::Role,
            "User" => AccessLevelFilterKey::User,
            other => AccessLevelFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessLevelFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessLevelFilterKey::from(s))
    }
}
impl AccessLevelFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessLevelFilterKey::Account => "Account",
            AccessLevelFilterKey::Role => "Role",
            AccessLevelFilterKey::User => "User",
            AccessLevelFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Account", "Role", "User"]
    }
}
impl AsRef<str> for AccessLevelFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductSource {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductSource {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => ProductSource::Account,
            other => ProductSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductSource::from(s))
    }
}
impl ProductSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductSource::Account => "ACCOUNT",
            ProductSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT"]
    }
}
impl AsRef<str> for ProductSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductViewSortBy {
    #[allow(missing_docs)] // documentation missing in model
    CreationDate,
    #[allow(missing_docs)] // documentation missing in model
    Title,
    #[allow(missing_docs)] // documentation missing in model
    VersionCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductViewSortBy {
    fn from(s: &str) -> Self {
        match s {
            "CreationDate" => ProductViewSortBy::CreationDate,
            "Title" => ProductViewSortBy::Title,
            "VersionCount" => ProductViewSortBy::VersionCount,
            other => ProductViewSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductViewSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductViewSortBy::from(s))
    }
}
impl ProductViewSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductViewSortBy::CreationDate => "CreationDate",
            ProductViewSortBy::Title => "Title",
            ProductViewSortBy::VersionCount => "VersionCount",
            ProductViewSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CreationDate", "Title", "VersionCount"]
    }
}
impl AsRef<str> for ProductViewSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductViewFilterBy {
    #[allow(missing_docs)] // documentation missing in model
    FullTextSearch,
    #[allow(missing_docs)] // documentation missing in model
    Owner,
    #[allow(missing_docs)] // documentation missing in model
    ProductType,
    #[allow(missing_docs)] // documentation missing in model
    SourceProductId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductViewFilterBy {
    fn from(s: &str) -> Self {
        match s {
            "FullTextSearch" => ProductViewFilterBy::FullTextSearch,
            "Owner" => ProductViewFilterBy::Owner,
            "ProductType" => ProductViewFilterBy::ProductType,
            "SourceProductId" => ProductViewFilterBy::SourceProductId,
            other => ProductViewFilterBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductViewFilterBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductViewFilterBy::from(s))
    }
}
impl ProductViewFilterBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductViewFilterBy::FullTextSearch => "FullTextSearch",
            ProductViewFilterBy::Owner => "Owner",
            ProductViewFilterBy::ProductType => "ProductType",
            ProductViewFilterBy::SourceProductId => "SourceProductId",
            ProductViewFilterBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FullTextSearch", "Owner", "ProductType", "SourceProductId"]
    }
}
impl AsRef<str> for ProductViewFilterBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A single product view aggregation value/count pair, containing metadata about each
/// product to which the calling user has access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductViewAggregationValue {
    /// <p>The value of the product view aggregation.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>An approximate count of the products that match the value.</p>
    pub approximate_count: i32,
}
impl std::fmt::Debug for ProductViewAggregationValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductViewAggregationValue");
        formatter.field("value", &self.value);
        formatter.field("approximate_count", &self.approximate_count);
        formatter.finish()
    }
}
/// See [`ProductViewAggregationValue`](crate::model::ProductViewAggregationValue)
pub mod product_view_aggregation_value {
    /// A builder for [`ProductViewAggregationValue`](crate::model::ProductViewAggregationValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) approximate_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value of the product view aggregation.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the product view aggregation.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>An approximate count of the products that match the value.</p>
        pub fn approximate_count(mut self, input: i32) -> Self {
            self.approximate_count = Some(input);
            self
        }
        /// <p>An approximate count of the products that match the value.</p>
        pub fn set_approximate_count(mut self, input: std::option::Option<i32>) -> Self {
            self.approximate_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductViewAggregationValue`](crate::model::ProductViewAggregationValue)
        pub fn build(self) -> crate::model::ProductViewAggregationValue {
            crate::model::ProductViewAggregationValue {
                value: self.value,
                approximate_count: self.approximate_count.unwrap_or_default(),
            }
        }
    }
}
impl ProductViewAggregationValue {
    /// Creates a new builder-style object to manufacture [`ProductViewAggregationValue`](crate::model::ProductViewAggregationValue)
    pub fn builder() -> crate::model::product_view_aggregation_value::Builder {
        crate::model::product_view_aggregation_value::Builder::default()
    }
}

/// <p>Information about a provisioned product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedProductDetail {
    /// <p>The user-friendly name of the provisioned product.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the provisioned product.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioned product.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The current status of the provisioned product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
    /// recent operation succeeded and completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
    /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
    /// completed the requested operation but is not exactly what was requested. For example, a
    /// request to update to a new version failed and the stack rolled back to the current version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
    /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
    /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ProvisionedProductStatus>,
    /// <p>The current status message of the provisioned product.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
    /// the same response is returned for each repeated request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last request performed on this provisioned product.</p>
    pub last_record_id: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// ProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// UpdateProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// ExecuteProvisionedProductPlan
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// TerminateProvisionedProduct
    /// </p>
    /// </li>
    /// </ul>
    pub last_provisioning_record_id: std::option::Option<std::string::String>,
    /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// ProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// UpdateProvisionedProduct
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// ExecuteProvisionedProductPlan
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// TerminateProvisionedProduct
    /// </p>
    /// </li>
    /// </ul>
    pub last_successful_provisioning_record_id: std::option::Option<std::string::String>,
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the launch role associated with the provisioned product.</p>
    pub launch_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedProductDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedProductDetail");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_time", &self.created_time);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("last_record_id", &self.last_record_id);
        formatter.field(
            "last_provisioning_record_id",
            &self.last_provisioning_record_id,
        );
        formatter.field(
            "last_successful_provisioning_record_id",
            &self.last_successful_provisioning_record_id,
        );
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("launch_role_arn", &self.launch_role_arn);
        formatter.finish()
    }
}
/// See [`ProvisionedProductDetail`](crate::model::ProvisionedProductDetail)
pub mod provisioned_product_detail {
    /// A builder for [`ProvisionedProductDetail`](crate::model::ProvisionedProductDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedProductStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) last_record_id: std::option::Option<std::string::String>,
        pub(crate) last_provisioning_record_id: std::option::Option<std::string::String>,
        pub(crate) last_successful_provisioning_record_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) launch_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the provisioned product.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the provisioned product.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of provisioned product. The supported values are <code>CFN_STACK</code> and <code>CFN_STACKSET</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioned product.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The current status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
        /// recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
        /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
        /// completed the requested operation but is not exactly what was requested. For example, a
        /// request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
        /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
        /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ProvisionedProductStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the provisioned product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most
        /// recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results.
        /// Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has
        /// completed the requested operation but is not exactly what was requested. For example, a
        /// request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
        /// For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
        /// but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The current status message of the provisioned product.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The current status message of the provisioned product.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token,
        /// the same response is returned for each repeated request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product.</p>
        pub fn last_record_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product.</p>
        pub fn set_last_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_record_id = input;
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn last_provisioning_record_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_provisioning_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_last_provisioning_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_provisioning_record_id = input;
            self
        }
        /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn last_successful_provisioning_record_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_successful_provisioning_record_id = Some(input.into());
            self
        }
        /// <p>The record identifier of the last successful request performed on this provisioned product of the following types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// ProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// UpdateProvisionedProduct
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// ExecuteProvisionedProductPlan
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// TerminateProvisionedProduct
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_last_successful_provisioning_record_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_successful_provisioning_record_id = input;
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The ARN of the launch role associated with the provisioned product.</p>
        pub fn launch_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the launch role associated with the provisioned product.</p>
        pub fn set_launch_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedProductDetail`](crate::model::ProvisionedProductDetail)
        pub fn build(self) -> crate::model::ProvisionedProductDetail {
            crate::model::ProvisionedProductDetail {
                name: self.name,
                arn: self.arn,
                r#type: self.r#type,
                id: self.id,
                status: self.status,
                status_message: self.status_message,
                created_time: self.created_time,
                idempotency_token: self.idempotency_token,
                last_record_id: self.last_record_id,
                last_provisioning_record_id: self.last_provisioning_record_id,
                last_successful_provisioning_record_id: self.last_successful_provisioning_record_id,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                launch_role_arn: self.launch_role_arn,
            }
        }
    }
}
impl ProvisionedProductDetail {
    /// Creates a new builder-style object to manufacture [`ProvisionedProductDetail`](crate::model::ProvisionedProductDetail)
    pub fn builder() -> crate::model::provisioned_product_detail::Builder {
        crate::model::provisioned_product_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortfolioShareType {
    #[allow(missing_docs)] // documentation missing in model
    AwsOrganizations,
    #[allow(missing_docs)] // documentation missing in model
    AwsServicecatalog,
    #[allow(missing_docs)] // documentation missing in model
    Imported,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortfolioShareType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_ORGANIZATIONS" => PortfolioShareType::AwsOrganizations,
            "AWS_SERVICECATALOG" => PortfolioShareType::AwsServicecatalog,
            "IMPORTED" => PortfolioShareType::Imported,
            other => PortfolioShareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortfolioShareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortfolioShareType::from(s))
    }
}
impl PortfolioShareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortfolioShareType::AwsOrganizations => "AWS_ORGANIZATIONS",
            PortfolioShareType::AwsServicecatalog => "AWS_SERVICECATALOG",
            PortfolioShareType::Imported => "IMPORTED",
            PortfolioShareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_ORGANIZATIONS", "AWS_SERVICECATALOG", "IMPORTED"]
    }
}
impl AsRef<str> for PortfolioShareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The user-defined preferences that will be applied when updating a provisioned
/// product. Not all preferences are applicable to all provisioned product type</p>
/// <p>One or more AWS accounts that will have access to the provisioned product.</p>
/// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
/// <p>The AWS accounts specified should be within the list of accounts in the
/// <code>STACKSET</code> constraint. To get the list of accounts in the
/// <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code>
/// operation.</p>
/// <p>If no values are specified, the default value is all accounts from the
/// <code>STACKSET</code> constraint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningPreferences {
    /// <p>One or more AWS accounts where the provisioned product will be available.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>The specified accounts should be within the list of accounts from the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
    /// <p>If no values are specified, the default value is all acounts from the <code>STACKSET</code> constraint.</p>
    pub stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more AWS Regions where the provisioned product will be available.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
    /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
    pub stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
    /// <p>The default value is <code>0</code> if no value is specified.</p>
    pub stack_set_failure_tolerance_count: std::option::Option<i32>,
    /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
    pub stack_set_failure_tolerance_percentage: std::option::Option<i32>,
    /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
    /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
    pub stack_set_max_concurrency_count: std::option::Option<i32>,
    /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
    /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
    pub stack_set_max_concurrency_percentage: std::option::Option<i32>,
}
impl std::fmt::Debug for ProvisioningPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningPreferences");
        formatter.field("stack_set_accounts", &self.stack_set_accounts);
        formatter.field("stack_set_regions", &self.stack_set_regions);
        formatter.field(
            "stack_set_failure_tolerance_count",
            &self.stack_set_failure_tolerance_count,
        );
        formatter.field(
            "stack_set_failure_tolerance_percentage",
            &self.stack_set_failure_tolerance_percentage,
        );
        formatter.field(
            "stack_set_max_concurrency_count",
            &self.stack_set_max_concurrency_count,
        );
        formatter.field(
            "stack_set_max_concurrency_percentage",
            &self.stack_set_max_concurrency_percentage,
        );
        formatter.finish()
    }
}
/// See [`ProvisioningPreferences`](crate::model::ProvisioningPreferences)
pub mod provisioning_preferences {
    /// A builder for [`ProvisioningPreferences`](crate::model::ProvisioningPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_set_failure_tolerance_count: std::option::Option<i32>,
        pub(crate) stack_set_failure_tolerance_percentage: std::option::Option<i32>,
        pub(crate) stack_set_max_concurrency_count: std::option::Option<i32>,
        pub(crate) stack_set_max_concurrency_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `stack_set_accounts`.
        ///
        /// To override the contents of this collection use [`set_stack_set_accounts`](Self::set_stack_set_accounts).
        ///
        /// <p>One or more AWS accounts where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified accounts should be within the list of accounts from the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all acounts from the <code>STACKSET</code> constraint.</p>
        pub fn stack_set_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_accounts.unwrap_or_default();
            v.push(input.into());
            self.stack_set_accounts = Some(v);
            self
        }
        /// <p>One or more AWS accounts where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified accounts should be within the list of accounts from the <code>STACKSET</code> constraint. To get the list of accounts in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all acounts from the <code>STACKSET</code> constraint.</p>
        pub fn set_stack_set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_accounts = input;
            self
        }
        /// Appends an item to `stack_set_regions`.
        ///
        /// To override the contents of this collection use [`set_stack_set_regions`](Self::set_stack_set_regions).
        ///
        /// <p>One or more AWS Regions where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
        pub fn stack_set_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_regions.unwrap_or_default();
            v.push(input.into());
            self.stack_set_regions = Some(v);
            self
        }
        /// <p>One or more AWS Regions where the provisioned product will be available.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>The specified regions should be within the list of regions from the <code>STACKSET</code> constraint. To get the list of regions in the <code>STACKSET</code> constraint, use the <code>DescribeProvisioningParameters</code> operation.</p>
        /// <p>If no values are specified, the default value is all regions from the <code>STACKSET</code> constraint.</p>
        pub fn set_stack_set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_regions = input;
            self
        }
        /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        /// <p>The default value is <code>0</code> if no value is specified.</p>
        pub fn stack_set_failure_tolerance_count(mut self, input: i32) -> Self {
            self.stack_set_failure_tolerance_count = Some(input);
            self
        }
        /// <p>The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        /// <p>The default value is <code>0</code> if no value is specified.</p>
        pub fn set_stack_set_failure_tolerance_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_failure_tolerance_count = input;
            self
        }
        /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        pub fn stack_set_failure_tolerance_percentage(mut self, input: i32) -> Self {
            self.stack_set_failure_tolerance_percentage = Some(input);
            self
        }
        /// <p>The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetFailureToleranceCount</code> or <code>StackSetFailureTolerancePercentage</code>, but not both.</p>
        pub fn set_stack_set_failure_tolerance_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_failure_tolerance_percentage = input;
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn stack_set_max_concurrency_count(mut self, input: i32) -> Self {
            self.stack_set_max_concurrency_count = Some(input);
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>StackSetFailureToleranceCount</code>. <code>StackSetMaxConcurrentCount</code> is at most one more than the <code>StackSetFailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn set_stack_set_max_concurrency_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_max_concurrency_count = input;
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn stack_set_max_concurrency_percentage(mut self, input: i32) -> Self {
            self.stack_set_max_concurrency_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as <code>1</code> instead.</p>
        /// <p>Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        /// <p>Conditional: You must specify either <code>StackSetMaxConcurrentCount</code> or <code>StackSetMaxConcurrentPercentage</code>, but not both.</p>
        pub fn set_stack_set_max_concurrency_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.stack_set_max_concurrency_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningPreferences`](crate::model::ProvisioningPreferences)
        pub fn build(self) -> crate::model::ProvisioningPreferences {
            crate::model::ProvisioningPreferences {
                stack_set_accounts: self.stack_set_accounts,
                stack_set_regions: self.stack_set_regions,
                stack_set_failure_tolerance_count: self.stack_set_failure_tolerance_count,
                stack_set_failure_tolerance_percentage: self.stack_set_failure_tolerance_percentage,
                stack_set_max_concurrency_count: self.stack_set_max_concurrency_count,
                stack_set_max_concurrency_percentage: self.stack_set_max_concurrency_percentage,
            }
        }
    }
}
impl ProvisioningPreferences {
    /// Creates a new builder-style object to manufacture [`ProvisioningPreferences`](crate::model::ProvisioningPreferences)
    pub fn builder() -> crate::model::provisioning_preferences::Builder {
        crate::model::provisioning_preferences::Builder::default()
    }
}

/// <p>Information about a parameter used to provision a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningParameter {
    /// <p>The parameter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The parameter value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisioningParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ProvisioningParameter`](crate::model::ProvisioningParameter)
pub mod provisioning_parameter {
    /// A builder for [`ProvisioningParameter`](crate::model::ProvisioningParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parameter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The parameter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The parameter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The parameter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningParameter`](crate::model::ProvisioningParameter)
        pub fn build(self) -> crate::model::ProvisioningParameter {
            crate::model::ProvisioningParameter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ProvisioningParameter {
    /// Creates a new builder-style object to manufacture [`ProvisioningParameter`](crate::model::ProvisioningParameter)
    pub fn builder() -> crate::model::provisioning_parameter::Builder {
        crate::model::provisioning_parameter::Builder::default()
    }
}

/// <p>Filters to use when listing TagOptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagOptionsFilters {
    /// <p>The TagOption key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The TagOption value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The active state.</p>
    pub active: std::option::Option<bool>,
}
impl std::fmt::Debug for ListTagOptionsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagOptionsFilters");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}
/// See [`ListTagOptionsFilters`](crate::model::ListTagOptionsFilters)
pub mod list_tag_options_filters {
    /// A builder for [`ListTagOptionsFilters`](crate::model::ListTagOptionsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The TagOption key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The TagOption value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The active state.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>The active state.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagOptionsFilters`](crate::model::ListTagOptionsFilters)
        pub fn build(self) -> crate::model::ListTagOptionsFilters {
            crate::model::ListTagOptionsFilters {
                key: self.key,
                value: self.value,
                active: self.active,
            }
        }
    }
}
impl ListTagOptionsFilters {
    /// Creates a new builder-style object to manufacture [`ListTagOptionsFilters`](crate::model::ListTagOptionsFilters)
    pub fn builder() -> crate::model::list_tag_options_filters::Builder {
        crate::model::list_tag_options_filters::Builder::default()
    }
}

/// <p>An AWS CloudFormation stack, in a specific account and region, that's part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given region. A stack instance can exist without a stack—for example, if the stack couldn't be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, as well as the ID of the actual stack and the stack status. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstance {
    /// <p>The name of the AWS account that the stack instance is associated with.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The name of the AWS region that the stack instance is associated with.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to true, to delete the stack instance, and then delete the stack manually. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because either            
    /// the associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation,           
    /// or the stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CURRENT</code>: The stack is currently up to date with the stack set.</p>
    /// </li>
    /// </ul>
    pub stack_instance_status: std::option::Option<crate::model::StackInstanceStatus>,
}
impl std::fmt::Debug for StackInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstance");
        formatter.field("account", &self.account);
        formatter.field("region", &self.region);
        formatter.field("stack_instance_status", &self.stack_instance_status);
        formatter.finish()
    }
}
/// See [`StackInstance`](crate::model::StackInstance)
pub mod stack_instance {
    /// A builder for [`StackInstance`](crate::model::StackInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) stack_instance_status: std::option::Option<crate::model::StackInstanceStatus>,
    }
    impl Builder {
        /// <p>The name of the AWS account that the stack instance is associated with.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The name of the AWS account that the stack instance is associated with.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The name of the AWS region that the stack instance is associated with.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the AWS region that the stack instance is associated with.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to true, to delete the stack instance, and then delete the stack manually. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because either            
        /// the associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation,           
        /// or the stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CURRENT</code>: The stack is currently up to date with the stack set.</p>
        /// </li>
        /// </ul>
        pub fn stack_instance_status(mut self, input: crate::model::StackInstanceStatus) -> Self {
            self.stack_instance_status = Some(input);
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to true, to delete the stack instance, and then delete the stack manually. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because either            
        /// the associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation,           
        /// or the stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CURRENT</code>: The stack is currently up to date with the stack set.</p>
        /// </li>
        /// </ul>
        pub fn set_stack_instance_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceStatus>,
        ) -> Self {
            self.stack_instance_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstance`](crate::model::StackInstance)
        pub fn build(self) -> crate::model::StackInstance {
            crate::model::StackInstance {
                account: self.account,
                region: self.region,
                stack_instance_status: self.stack_instance_status,
            }
        }
    }
}
impl StackInstance {
    /// Creates a new builder-style object to manufacture [`StackInstance`](crate::model::StackInstance)
    pub fn builder() -> crate::model::stack_instance::Builder {
        crate::model::stack_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Current,
    #[allow(missing_docs)] // documentation missing in model
    Inoperable,
    #[allow(missing_docs)] // documentation missing in model
    Outdated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT" => StackInstanceStatus::Current,
            "INOPERABLE" => StackInstanceStatus::Inoperable,
            "OUTDATED" => StackInstanceStatus::Outdated,
            other => StackInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackInstanceStatus::from(s))
    }
}
impl StackInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackInstanceStatus::Current => "CURRENT",
            StackInstanceStatus::Inoperable => "INOPERABLE",
            StackInstanceStatus::Outdated => "OUTDATED",
            StackInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENT", "INOPERABLE", "OUTDATED"]
    }
}
impl AsRef<str> for StackInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDetail {
    /// <p>The identifier of the resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The creation time of the resource.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ResourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDetail");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`ResourceDetail`](crate::model::ResourceDetail)
pub mod resource_detail {
    /// A builder for [`ResourceDetail`](crate::model::ResourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The creation time of the resource.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The creation time of the resource.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDetail`](crate::model::ResourceDetail)
        pub fn build(self) -> crate::model::ResourceDetail {
            crate::model::ResourceDetail {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                created_time: self.created_time,
            }
        }
    }
}
impl ResourceDetail {
    /// Creates a new builder-style object to manufacture [`ResourceDetail`](crate::model::ResourceDetail)
    pub fn builder() -> crate::model::resource_detail::Builder {
        crate::model::resource_detail::Builder::default()
    }
}

/// <p>The search filter to use when listing history records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordHistorySearchFilter {
    /// <p>The filter key.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>product</code> - Filter results based on the specified product identifier.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>provisionedproduct</code> - Filter results based on the provisioned product identifier.</p>
    /// </li>
    /// </ul>
    pub key: std::option::Option<std::string::String>,
    /// <p>The filter value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRecordHistorySearchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordHistorySearchFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ListRecordHistorySearchFilter`](crate::model::ListRecordHistorySearchFilter)
pub mod list_record_history_search_filter {
    /// A builder for [`ListRecordHistorySearchFilter`](crate::model::ListRecordHistorySearchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The filter key.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>product</code> - Filter results based on the specified product identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>provisionedproduct</code> - Filter results based on the provisioned product identifier.</p>
        /// </li>
        /// </ul>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The filter key.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>product</code> - Filter results based on the specified product identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>provisionedproduct</code> - Filter results based on the provisioned product identifier.</p>
        /// </li>
        /// </ul>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The filter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The filter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordHistorySearchFilter`](crate::model::ListRecordHistorySearchFilter)
        pub fn build(self) -> crate::model::ListRecordHistorySearchFilter {
            crate::model::ListRecordHistorySearchFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ListRecordHistorySearchFilter {
    /// Creates a new builder-style object to manufacture [`ListRecordHistorySearchFilter`](crate::model::ListRecordHistorySearchFilter)
    pub fn builder() -> crate::model::list_record_history_search_filter::Builder {
        crate::model::list_record_history_search_filter::Builder::default()
    }
}

/// <p>An object that contains summary information about a product view and a provisioning artifact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactView {
    /// <p>Summary information about a product view.</p>
    pub product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
    /// <p>Information about a provisioning artifact. A provisioning artifact is also known as a product version.</p>
    pub provisioning_artifact: std::option::Option<crate::model::ProvisioningArtifact>,
}
impl std::fmt::Debug for ProvisioningArtifactView {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactView");
        formatter.field("product_view_summary", &self.product_view_summary);
        formatter.field("provisioning_artifact", &self.provisioning_artifact);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactView`](crate::model::ProvisioningArtifactView)
pub mod provisioning_artifact_view {
    /// A builder for [`ProvisioningArtifactView`](crate::model::ProvisioningArtifactView)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
        pub(crate) provisioning_artifact: std::option::Option<crate::model::ProvisioningArtifact>,
    }
    impl Builder {
        /// <p>Summary information about a product view.</p>
        pub fn product_view_summary(mut self, input: crate::model::ProductViewSummary) -> Self {
            self.product_view_summary = Some(input);
            self
        }
        /// <p>Summary information about a product view.</p>
        pub fn set_product_view_summary(
            mut self,
            input: std::option::Option<crate::model::ProductViewSummary>,
        ) -> Self {
            self.product_view_summary = input;
            self
        }
        /// <p>Information about a provisioning artifact. A provisioning artifact is also known as a product version.</p>
        pub fn provisioning_artifact(mut self, input: crate::model::ProvisioningArtifact) -> Self {
            self.provisioning_artifact = Some(input);
            self
        }
        /// <p>Information about a provisioning artifact. A provisioning artifact is also known as a product version.</p>
        pub fn set_provisioning_artifact(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifact>,
        ) -> Self {
            self.provisioning_artifact = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactView`](crate::model::ProvisioningArtifactView)
        pub fn build(self) -> crate::model::ProvisioningArtifactView {
            crate::model::ProvisioningArtifactView {
                product_view_summary: self.product_view_summary,
                provisioning_artifact: self.provisioning_artifact,
            }
        }
    }
}
impl ProvisioningArtifactView {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactView`](crate::model::ProvisioningArtifactView)
    pub fn builder() -> crate::model::provisioning_artifact_view::Builder {
        crate::model::provisioning_artifact_view::Builder::default()
    }
}

/// <p>Information about a provisioning artifact. A provisioning artifact is also known as a product version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifact {
    /// <p>The identifier of the provisioning artifact.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the provisioning artifact.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
    pub guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
}
impl std::fmt::Debug for ProvisioningArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifact");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("guidance", &self.guidance);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifact`](crate::model::ProvisioningArtifact)
pub mod provisioning_artifact {
    /// A builder for [`ProvisioningArtifact`](crate::model::ProvisioningArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) guidance: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
    }
    impl Builder {
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        pub fn guidance(mut self, input: crate::model::ProvisioningArtifactGuidance) -> Self {
            self.guidance = Some(input);
            self
        }
        /// <p>Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.</p>
        pub fn set_guidance(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactGuidance>,
        ) -> Self {
            self.guidance = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifact`](crate::model::ProvisioningArtifact)
        pub fn build(self) -> crate::model::ProvisioningArtifact {
            crate::model::ProvisioningArtifact {
                id: self.id,
                name: self.name,
                description: self.description,
                created_time: self.created_time,
                guidance: self.guidance,
            }
        }
    }
}
impl ProvisioningArtifact {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifact`](crate::model::ProvisioningArtifact)
    pub fn builder() -> crate::model::provisioning_artifact::Builder {
        crate::model::provisioning_artifact::Builder::default()
    }
}

/// <p>Summary information about a plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedProductPlanSummary {
    /// <p>The name of the plan.</p>
    pub plan_name: std::option::Option<std::string::String>,
    /// <p>The plan identifier.</p>
    pub plan_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub provision_product_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the provisioned product.</p>
    pub provision_product_name: std::option::Option<std::string::String>,
    /// <p>The plan type.</p>
    pub plan_type: std::option::Option<crate::model::ProvisionedProductPlanType>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedProductPlanSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedProductPlanSummary");
        formatter.field("plan_name", &self.plan_name);
        formatter.field("plan_id", &self.plan_id);
        formatter.field("provision_product_id", &self.provision_product_id);
        formatter.field("provision_product_name", &self.provision_product_name);
        formatter.field("plan_type", &self.plan_type);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.finish()
    }
}
/// See [`ProvisionedProductPlanSummary`](crate::model::ProvisionedProductPlanSummary)
pub mod provisioned_product_plan_summary {
    /// A builder for [`ProvisionedProductPlanSummary`](crate::model::ProvisionedProductPlanSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) plan_name: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) provision_product_id: std::option::Option<std::string::String>,
        pub(crate) provision_product_name: std::option::Option<std::string::String>,
        pub(crate) plan_type: std::option::Option<crate::model::ProvisionedProductPlanType>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_name = Some(input.into());
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_name = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_id = input;
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn provision_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_provision_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_name = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::ProvisionedProductPlanType) -> Self {
            self.plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanType>,
        ) -> Self {
            self.plan_type = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedProductPlanSummary`](crate::model::ProvisionedProductPlanSummary)
        pub fn build(self) -> crate::model::ProvisionedProductPlanSummary {
            crate::model::ProvisionedProductPlanSummary {
                plan_name: self.plan_name,
                plan_id: self.plan_id,
                provision_product_id: self.provision_product_id,
                provision_product_name: self.provision_product_name,
                plan_type: self.plan_type,
                provisioning_artifact_id: self.provisioning_artifact_id,
            }
        }
    }
}
impl ProvisionedProductPlanSummary {
    /// Creates a new builder-style object to manufacture [`ProvisionedProductPlanSummary`](crate::model::ProvisionedProductPlanSummary)
    pub fn builder() -> crate::model::provisioned_product_plan_summary::Builder {
        crate::model::provisioned_product_plan_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedProductPlanType {
    #[allow(missing_docs)] // documentation missing in model
    Cloudformation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedProductPlanType {
    fn from(s: &str) -> Self {
        match s {
            "CLOUDFORMATION" => ProvisionedProductPlanType::Cloudformation,
            other => ProvisionedProductPlanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedProductPlanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedProductPlanType::from(s))
    }
}
impl ProvisionedProductPlanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedProductPlanType::Cloudformation => "CLOUDFORMATION",
            ProvisionedProductPlanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUDFORMATION"]
    }
}
impl AsRef<str> for ProvisionedProductPlanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a principal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Principal {
    /// <p>The ARN of the principal (IAM user, role, or group).</p>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>The principal type. The supported value is <code>IAM</code>.</p>
    pub principal_type: std::option::Option<crate::model::PrincipalType>,
}
impl std::fmt::Debug for Principal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Principal");
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("principal_type", &self.principal_type);
        formatter.finish()
    }
}
/// See [`Principal`](crate::model::Principal)
pub mod principal {
    /// A builder for [`Principal`](crate::model::Principal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) principal_type: std::option::Option<crate::model::PrincipalType>,
    }
    impl Builder {
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal (IAM user, role, or group).</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn principal_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.principal_type = Some(input);
            self
        }
        /// <p>The principal type. The supported value is <code>IAM</code>.</p>
        pub fn set_principal_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.principal_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Principal`](crate::model::Principal)
        pub fn build(self) -> crate::model::Principal {
            crate::model::Principal {
                principal_arn: self.principal_arn,
                principal_type: self.principal_type,
            }
        }
    }
}
impl Principal {
    /// Creates a new builder-style object to manufacture [`Principal`](crate::model::Principal)
    pub fn builder() -> crate::model::principal::Builder {
        crate::model::principal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalType {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalType {
    fn from(s: &str) -> Self {
        match s {
            "IAM" => PrincipalType::Iam,
            other => PrincipalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalType::from(s))
    }
}
impl PrincipalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalType::Iam => "IAM",
            PrincipalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM"]
    }
}
impl AsRef<str> for PrincipalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a product path for a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchPathSummary {
    /// <p>The identifier of the product path.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The constraints on the portfolio-product relationship.</p>
    pub constraint_summaries: std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
    /// <p>The tags associated with this product path.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The name of the portfolio to which the user was assigned.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LaunchPathSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchPathSummary");
        formatter.field("id", &self.id);
        formatter.field("constraint_summaries", &self.constraint_summaries);
        formatter.field("tags", &self.tags);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`LaunchPathSummary`](crate::model::LaunchPathSummary)
pub mod launch_path_summary {
    /// A builder for [`LaunchPathSummary`](crate::model::LaunchPathSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) constraint_summaries:
            std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the product path.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the product path.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `constraint_summaries`.
        ///
        /// To override the contents of this collection use [`set_constraint_summaries`](Self::set_constraint_summaries).
        ///
        /// <p>The constraints on the portfolio-product relationship.</p>
        pub fn constraint_summaries(
            mut self,
            input: impl Into<crate::model::ConstraintSummary>,
        ) -> Self {
            let mut v = self.constraint_summaries.unwrap_or_default();
            v.push(input.into());
            self.constraint_summaries = Some(v);
            self
        }
        /// <p>The constraints on the portfolio-product relationship.</p>
        pub fn set_constraint_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
        ) -> Self {
            self.constraint_summaries = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with this product path.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with this product path.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the portfolio to which the user was assigned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the portfolio to which the user was assigned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchPathSummary`](crate::model::LaunchPathSummary)
        pub fn build(self) -> crate::model::LaunchPathSummary {
            crate::model::LaunchPathSummary {
                id: self.id,
                constraint_summaries: self.constraint_summaries,
                tags: self.tags,
                name: self.name,
            }
        }
    }
}
impl LaunchPathSummary {
    /// Creates a new builder-style object to manufacture [`LaunchPathSummary`](crate::model::LaunchPathSummary)
    pub fn builder() -> crate::model::launch_path_summary::Builder {
        crate::model::launch_path_summary::Builder::default()
    }
}

/// <p>Summary information about a constraint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConstraintSummary {
    /// <p>The type of constraint.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LAUNCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOTIFICATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>STACKSET</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPLATE</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The description of the constraint.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConstraintSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConstraintSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ConstraintSummary`](crate::model::ConstraintSummary)
pub mod constraint_summary {
    /// A builder for [`ConstraintSummary`](crate::model::ConstraintSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>STACKSET</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of constraint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>STACKSET</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPLATE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the constraint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ConstraintSummary`](crate::model::ConstraintSummary)
        pub fn build(self) -> crate::model::ConstraintSummary {
            crate::model::ConstraintSummary {
                r#type: self.r#type,
                description: self.description,
            }
        }
    }
}
impl ConstraintSummary {
    /// Creates a new builder-style object to manufacture [`ConstraintSummary`](crate::model::ConstraintSummary)
    pub fn builder() -> crate::model::constraint_summary::Builder {
        crate::model::constraint_summary::Builder::default()
    }
}

/// <p>Information about a budget.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BudgetDetail {
    /// <p>Name of the associated budget.</p>
    pub budget_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BudgetDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BudgetDetail");
        formatter.field("budget_name", &self.budget_name);
        formatter.finish()
    }
}
/// See [`BudgetDetail`](crate::model::BudgetDetail)
pub mod budget_detail {
    /// A builder for [`BudgetDetail`](crate::model::BudgetDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budget_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the associated budget.</p>
        pub fn budget_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.budget_name = Some(input.into());
            self
        }
        /// <p>Name of the associated budget.</p>
        pub fn set_budget_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.budget_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BudgetDetail`](crate::model::BudgetDetail)
        pub fn build(self) -> crate::model::BudgetDetail {
            crate::model::BudgetDetail {
                budget_name: self.budget_name,
            }
        }
    }
}
impl BudgetDetail {
    /// Creates a new builder-style object to manufacture [`BudgetDetail`](crate::model::BudgetDetail)
    pub fn builder() -> crate::model::budget_detail::Builder {
        crate::model::budget_detail::Builder::default()
    }
}

/// <p>The output for the product created as the result of a request. For example, the output for
/// a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordOutput {
    /// <p>The output key.</p>
    pub output_key: std::option::Option<std::string::String>,
    /// <p>The output value.</p>
    pub output_value: std::option::Option<std::string::String>,
    /// <p>The description of the output.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordOutput");
        formatter.field("output_key", &self.output_key);
        formatter.field("output_value", &self.output_value);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`RecordOutput`](crate::model::RecordOutput)
pub mod record_output {
    /// A builder for [`RecordOutput`](crate::model::RecordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_key: std::option::Option<std::string::String>,
        pub(crate) output_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The output key.</p>
        pub fn output_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_key = Some(input.into());
            self
        }
        /// <p>The output key.</p>
        pub fn set_output_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_key = input;
            self
        }
        /// <p>The output value.</p>
        pub fn output_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_value = Some(input.into());
            self
        }
        /// <p>The output value.</p>
        pub fn set_output_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_value = input;
            self
        }
        /// <p>The description of the output.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the output.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordOutput`](crate::model::RecordOutput)
        pub fn build(self) -> crate::model::RecordOutput {
            crate::model::RecordOutput {
                output_key: self.output_key,
                output_value: self.output_value,
                description: self.description,
            }
        }
    }
}
impl RecordOutput {
    /// Creates a new builder-style object to manufacture [`RecordOutput`](crate::model::RecordOutput)
    pub fn builder() -> crate::model::record_output::Builder {
        crate::model::record_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    UnderChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AccessStatus::Disabled,
            "ENABLED" => AccessStatus::Enabled,
            "UNDER_CHANGE" => AccessStatus::UnderChange,
            other => AccessStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessStatus::from(s))
    }
}
impl AccessStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessStatus::Disabled => "DISABLED",
            AccessStatus::Enabled => "ENABLED",
            AccessStatus::UnderChange => "UNDER_CHANGE",
            AccessStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED", "UNDER_CHANGE"]
    }
}
impl AsRef<str> for AccessStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of an execution parameter value that is passed to a self-service action when executed on a provisioned product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionParameter {
    /// <p>The name of the execution parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The execution parameter type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The default values for the execution parameter.</p>
    pub default_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ExecutionParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionParameter");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("default_values", &self.default_values);
        formatter.finish()
    }
}
/// See [`ExecutionParameter`](crate::model::ExecutionParameter)
pub mod execution_parameter {
    /// A builder for [`ExecutionParameter`](crate::model::ExecutionParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) default_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the execution parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The execution parameter type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The execution parameter type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `default_values`.
        ///
        /// To override the contents of this collection use [`set_default_values`](Self::set_default_values).
        ///
        /// <p>The default values for the execution parameter.</p>
        pub fn default_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.default_values.unwrap_or_default();
            v.push(input.into());
            self.default_values = Some(v);
            self
        }
        /// <p>The default values for the execution parameter.</p>
        pub fn set_default_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.default_values = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionParameter`](crate::model::ExecutionParameter)
        pub fn build(self) -> crate::model::ExecutionParameter {
            crate::model::ExecutionParameter {
                name: self.name,
                r#type: self.r#type,
                default_values: self.default_values,
            }
        }
    }
}
impl ExecutionParameter {
    /// Creates a new builder-style object to manufacture [`ExecutionParameter`](crate::model::ExecutionParameter)
    pub fn builder() -> crate::model::execution_parameter::Builder {
        crate::model::execution_parameter::Builder::default()
    }
}

/// <p>Provisioning artifact output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactOutput {
    /// <p>The provisioning artifact output key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Description of the provisioning artifact output key.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactOutput");
        formatter.field("key", &self.key);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactOutput`](crate::model::ProvisioningArtifactOutput)
pub mod provisioning_artifact_output {
    /// A builder for [`ProvisioningArtifactOutput`](crate::model::ProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The provisioning artifact output key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The provisioning artifact output key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Description of the provisioning artifact output key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the provisioning artifact output key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactOutput`](crate::model::ProvisioningArtifactOutput)
        pub fn build(self) -> crate::model::ProvisioningArtifactOutput {
            crate::model::ProvisioningArtifactOutput {
                key: self.key,
                description: self.description,
            }
        }
    }
}
impl ProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactOutput`](crate::model::ProvisioningArtifactOutput)
    pub fn builder() -> crate::model::provisioning_artifact_output::Builder {
        crate::model::provisioning_artifact_output::Builder::default()
    }
}

/// <p>The user-defined preferences that will be applied during product provisioning, unless overridden by <code>ProvisioningPreferences</code> or <code>UpdateProvisioningPreferences</code>.</p>
/// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a> in the <i>AWS CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactPreferences {
    /// <p>One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    pub stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in <code>ProvisioningPreferences$StackSetRegions</code> and <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
    /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
    pub stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ProvisioningArtifactPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactPreferences");
        formatter.field("stack_set_accounts", &self.stack_set_accounts);
        formatter.field("stack_set_regions", &self.stack_set_regions);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactPreferences`](crate::model::ProvisioningArtifactPreferences)
pub mod provisioning_artifact_preferences {
    /// A builder for [`ProvisioningArtifactPreferences`](crate::model::ProvisioningArtifactPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stack_set_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_set_accounts`.
        ///
        /// To override the contents of this collection use [`set_stack_set_accounts`](Self::set_stack_set_accounts).
        ///
        /// <p>One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        pub fn stack_set_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_accounts.unwrap_or_default();
            v.push(input.into());
            self.stack_set_accounts = Some(v);
            self
        }
        /// <p>One or more AWS accounts where stack instances are deployed from the stack set. These accounts can be scoped in <code>ProvisioningPreferences$StackSetAccounts</code> and <code>UpdateProvisioningPreferences$StackSetAccounts</code>.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        pub fn set_stack_set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_accounts = input;
            self
        }
        /// Appends an item to `stack_set_regions`.
        ///
        /// To override the contents of this collection use [`set_stack_set_regions`](Self::set_stack_set_regions).
        ///
        /// <p>One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in <code>ProvisioningPreferences$StackSetRegions</code> and <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        pub fn stack_set_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_set_regions.unwrap_or_default();
            v.push(input.into());
            self.stack_set_regions = Some(v);
            self
        }
        /// <p>One or more AWS Regions where stack instances are deployed from the stack set. These regions can be scoped in <code>ProvisioningPreferences$StackSetRegions</code> and <code>UpdateProvisioningPreferences$StackSetRegions</code>.</p>
        /// <p>Applicable only to a <code>CFN_STACKSET</code> provisioned product type.</p>
        pub fn set_stack_set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_set_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactPreferences`](crate::model::ProvisioningArtifactPreferences)
        pub fn build(self) -> crate::model::ProvisioningArtifactPreferences {
            crate::model::ProvisioningArtifactPreferences {
                stack_set_accounts: self.stack_set_accounts,
                stack_set_regions: self.stack_set_regions,
            }
        }
    }
}
impl ProvisioningArtifactPreferences {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactPreferences`](crate::model::ProvisioningArtifactPreferences)
    pub fn builder() -> crate::model::provisioning_artifact_preferences::Builder {
        crate::model::provisioning_artifact_preferences::Builder::default()
    }
}

/// <p>Summary information about a TagOption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOptionSummary {
    /// <p>The TagOption key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The TagOption value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for TagOptionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOptionSummary");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`TagOptionSummary`](crate::model::TagOptionSummary)
pub mod tag_option_summary {
    /// A builder for [`TagOptionSummary`](crate::model::TagOptionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The TagOption key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The TagOption key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The TagOption value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The TagOption value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagOptionSummary`](crate::model::TagOptionSummary)
        pub fn build(self) -> crate::model::TagOptionSummary {
            crate::model::TagOptionSummary {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl TagOptionSummary {
    /// Creates a new builder-style object to manufacture [`TagOptionSummary`](crate::model::TagOptionSummary)
    pub fn builder() -> crate::model::tag_option_summary::Builder {
        crate::model::tag_option_summary::Builder::default()
    }
}

/// <p>Additional information provided by the administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageInstruction {
    /// <p>The usage instruction type for the value.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The usage instruction value for this type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UsageInstruction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageInstruction");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`UsageInstruction`](crate::model::UsageInstruction)
pub mod usage_instruction {
    /// A builder for [`UsageInstruction`](crate::model::UsageInstruction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The usage instruction type for the value.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The usage instruction type for the value.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The usage instruction value for this type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The usage instruction value for this type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageInstruction`](crate::model::UsageInstruction)
        pub fn build(self) -> crate::model::UsageInstruction {
            crate::model::UsageInstruction {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl UsageInstruction {
    /// Creates a new builder-style object to manufacture [`UsageInstruction`](crate::model::UsageInstruction)
    pub fn builder() -> crate::model::usage_instruction::Builder {
        crate::model::usage_instruction::Builder::default()
    }
}

/// <p>Information about a parameter used to provision a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactParameter {
    /// <p>The parameter key.</p>
    pub parameter_key: std::option::Option<std::string::String>,
    /// <p>The default value.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The parameter type.</p>
    pub parameter_type: std::option::Option<std::string::String>,
    /// <p>If this value is true, the value for this parameter is obfuscated from view when the
    /// parameter is retrieved. This parameter is used to hide sensitive information.</p>
    pub is_no_echo: bool,
    /// <p>The description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Constraints that the administrator has put on a parameter.</p>
    pub parameter_constraints: std::option::Option<crate::model::ParameterConstraints>,
}
impl std::fmt::Debug for ProvisioningArtifactParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactParameter");
        formatter.field("parameter_key", &self.parameter_key);
        formatter.field("default_value", &self.default_value);
        formatter.field("parameter_type", &self.parameter_type);
        formatter.field("is_no_echo", &self.is_no_echo);
        formatter.field("description", &self.description);
        formatter.field("parameter_constraints", &self.parameter_constraints);
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactParameter`](crate::model::ProvisioningArtifactParameter)
pub mod provisioning_artifact_parameter {
    /// A builder for [`ProvisioningArtifactParameter`](crate::model::ProvisioningArtifactParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_key: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) parameter_type: std::option::Option<std::string::String>,
        pub(crate) is_no_echo: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameter_constraints: std::option::Option<crate::model::ParameterConstraints>,
    }
    impl Builder {
        /// <p>The parameter key.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The parameter key.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// <p>The default value.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The parameter type.</p>
        pub fn parameter_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_type = Some(input.into());
            self
        }
        /// <p>The parameter type.</p>
        pub fn set_parameter_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_type = input;
            self
        }
        /// <p>If this value is true, the value for this parameter is obfuscated from view when the
        /// parameter is retrieved. This parameter is used to hide sensitive information.</p>
        pub fn is_no_echo(mut self, input: bool) -> Self {
            self.is_no_echo = Some(input);
            self
        }
        /// <p>If this value is true, the value for this parameter is obfuscated from view when the
        /// parameter is retrieved. This parameter is used to hide sensitive information.</p>
        pub fn set_is_no_echo(mut self, input: std::option::Option<bool>) -> Self {
            self.is_no_echo = input;
            self
        }
        /// <p>The description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Constraints that the administrator has put on a parameter.</p>
        pub fn parameter_constraints(mut self, input: crate::model::ParameterConstraints) -> Self {
            self.parameter_constraints = Some(input);
            self
        }
        /// <p>Constraints that the administrator has put on a parameter.</p>
        pub fn set_parameter_constraints(
            mut self,
            input: std::option::Option<crate::model::ParameterConstraints>,
        ) -> Self {
            self.parameter_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactParameter`](crate::model::ProvisioningArtifactParameter)
        pub fn build(self) -> crate::model::ProvisioningArtifactParameter {
            crate::model::ProvisioningArtifactParameter {
                parameter_key: self.parameter_key,
                default_value: self.default_value,
                parameter_type: self.parameter_type,
                is_no_echo: self.is_no_echo.unwrap_or_default(),
                description: self.description,
                parameter_constraints: self.parameter_constraints,
            }
        }
    }
}
impl ProvisioningArtifactParameter {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactParameter`](crate::model::ProvisioningArtifactParameter)
    pub fn builder() -> crate::model::provisioning_artifact_parameter::Builder {
        crate::model::provisioning_artifact_parameter::Builder::default()
    }
}

/// <p>The constraints that the administrator has put on the parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterConstraints {
    /// <p>The values that the administrator has allowed for the parameter.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A regular expression that represents the patterns that allow for <code>String</code> types. The pattern must match the entire parameter value provided.</p>
    pub allowed_pattern: std::option::Option<std::string::String>,
    /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following error message when the user specifies an invalid value:</p>
    ///
    /// <p>
    /// <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
    /// </p>
    ///
    /// <p>By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you can display the following customized error message:</p>
    ///
    /// <p>
    /// <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
    /// </p>
    pub constraint_description: std::option::Option<std::string::String>,
    /// <p>An integer value that determines the largest number of characters you want to allow for <code>String</code> types. </p>
    pub max_length: std::option::Option<std::string::String>,
    /// <p>An integer value that determines the smallest number of characters you want to allow for <code>String</code> types.</p>
    pub min_length: std::option::Option<std::string::String>,
    /// <p>A numeric value that determines the largest numeric value you want to allow for <code>Number</code> types.</p>
    pub max_value: std::option::Option<std::string::String>,
    /// <p>A numeric value that determines the smallest numeric value you want to allow for <code>Number</code> types. </p>
    pub min_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterConstraints");
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("allowed_pattern", &self.allowed_pattern);
        formatter.field("constraint_description", &self.constraint_description);
        formatter.field("max_length", &self.max_length);
        formatter.field("min_length", &self.min_length);
        formatter.field("max_value", &self.max_value);
        formatter.field("min_value", &self.min_value);
        formatter.finish()
    }
}
/// See [`ParameterConstraints`](crate::model::ParameterConstraints)
pub mod parameter_constraints {
    /// A builder for [`ParameterConstraints`](crate::model::ParameterConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_pattern: std::option::Option<std::string::String>,
        pub(crate) constraint_description: std::option::Option<std::string::String>,
        pub(crate) max_length: std::option::Option<std::string::String>,
        pub(crate) min_length: std::option::Option<std::string::String>,
        pub(crate) max_value: std::option::Option<std::string::String>,
        pub(crate) min_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>The values that the administrator has allowed for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input.into());
            self.allowed_values = Some(v);
            self
        }
        /// <p>The values that the administrator has allowed for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>A regular expression that represents the patterns that allow for <code>String</code> types. The pattern must match the entire parameter value provided.</p>
        pub fn allowed_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_pattern = Some(input.into());
            self
        }
        /// <p>A regular expression that represents the patterns that allow for <code>String</code> types. The pattern must match the entire parameter value provided.</p>
        pub fn set_allowed_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_pattern = input;
            self
        }
        /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following error message when the user specifies an invalid value:</p>
        ///
        /// <p>
        /// <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
        /// </p>
        ///
        /// <p>By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you can display the following customized error message:</p>
        ///
        /// <p>
        /// <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
        /// </p>
        pub fn constraint_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_description = Some(input.into());
            self
        }
        /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of <code>[A-Za-z0-9]+</code> displays the following error message when the user specifies an invalid value:</p>
        ///
        /// <p>
        /// <code>Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+</code>
        /// </p>
        ///
        /// <p>By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you can display the following customized error message:</p>
        ///
        /// <p>
        /// <code>Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.</code>
        /// </p>
        pub fn set_constraint_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_description = input;
            self
        }
        /// <p>An integer value that determines the largest number of characters you want to allow for <code>String</code> types. </p>
        pub fn max_length(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_length = Some(input.into());
            self
        }
        /// <p>An integer value that determines the largest number of characters you want to allow for <code>String</code> types. </p>
        pub fn set_max_length(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_length = input;
            self
        }
        /// <p>An integer value that determines the smallest number of characters you want to allow for <code>String</code> types.</p>
        pub fn min_length(mut self, input: impl Into<std::string::String>) -> Self {
            self.min_length = Some(input.into());
            self
        }
        /// <p>An integer value that determines the smallest number of characters you want to allow for <code>String</code> types.</p>
        pub fn set_min_length(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min_length = input;
            self
        }
        /// <p>A numeric value that determines the largest numeric value you want to allow for <code>Number</code> types.</p>
        pub fn max_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_value = Some(input.into());
            self
        }
        /// <p>A numeric value that determines the largest numeric value you want to allow for <code>Number</code> types.</p>
        pub fn set_max_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>A numeric value that determines the smallest numeric value you want to allow for <code>Number</code> types. </p>
        pub fn min_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.min_value = Some(input.into());
            self
        }
        /// <p>A numeric value that determines the smallest numeric value you want to allow for <code>Number</code> types. </p>
        pub fn set_min_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterConstraints`](crate::model::ParameterConstraints)
        pub fn build(self) -> crate::model::ParameterConstraints {
            crate::model::ParameterConstraints {
                allowed_values: self.allowed_values,
                allowed_pattern: self.allowed_pattern,
                constraint_description: self.constraint_description,
                max_length: self.max_length,
                min_length: self.min_length,
                max_value: self.max_value,
                min_value: self.min_value,
            }
        }
    }
}
impl ParameterConstraints {
    /// Creates a new builder-style object to manufacture [`ParameterConstraints`](crate::model::ParameterConstraints)
    pub fn builder() -> crate::model::parameter_constraints::Builder {
        crate::model::parameter_constraints::Builder::default()
    }
}

/// <p>Information about a resource change that will occur when a plan is executed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceChange {
    /// <p>The change action.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The ID of the resource, as defined in the CloudFormation template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the resource, if it was already created.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>If the change type is <code>Modify</code>, indicates whether the existing resource
    /// is deleted and replaced with a new one.</p>
    pub replacement: std::option::Option<crate::model::Replacement>,
    /// <p>The change scope.</p>
    pub scope: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
    /// <p>Information about the resource changes.</p>
    pub details: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
}
impl std::fmt::Debug for ResourceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceChange");
        formatter.field("action", &self.action);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("replacement", &self.replacement);
        formatter.field("scope", &self.scope);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ResourceChange`](crate::model::ResourceChange)
pub mod resource_change {
    /// A builder for [`ResourceChange`](crate::model::ResourceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) replacement: std::option::Option<crate::model::Replacement>,
        pub(crate) scope: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        pub(crate) details: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
    }
    impl Builder {
        /// <p>The change action.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The change action.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The ID of the resource, as defined in the CloudFormation template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource, as defined in the CloudFormation template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The ID of the resource, if it was already created.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource, if it was already created.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>If the change type is <code>Modify</code>, indicates whether the existing resource
        /// is deleted and replaced with a new one.</p>
        pub fn replacement(mut self, input: crate::model::Replacement) -> Self {
            self.replacement = Some(input);
            self
        }
        /// <p>If the change type is <code>Modify</code>, indicates whether the existing resource
        /// is deleted and replaced with a new one.</p>
        pub fn set_replacement(
            mut self,
            input: std::option::Option<crate::model::Replacement>,
        ) -> Self {
            self.replacement = input;
            self
        }
        /// Appends an item to `scope`.
        ///
        /// To override the contents of this collection use [`set_scope`](Self::set_scope).
        ///
        /// <p>The change scope.</p>
        pub fn scope(mut self, input: impl Into<crate::model::ResourceAttribute>) -> Self {
            let mut v = self.scope.unwrap_or_default();
            v.push(input.into());
            self.scope = Some(v);
            self
        }
        /// <p>The change scope.</p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// Appends an item to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>Information about the resource changes.</p>
        pub fn details(mut self, input: impl Into<crate::model::ResourceChangeDetail>) -> Self {
            let mut v = self.details.unwrap_or_default();
            v.push(input.into());
            self.details = Some(v);
            self
        }
        /// <p>Information about the resource changes.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceChange`](crate::model::ResourceChange)
        pub fn build(self) -> crate::model::ResourceChange {
            crate::model::ResourceChange {
                action: self.action,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                replacement: self.replacement,
                scope: self.scope,
                details: self.details,
            }
        }
    }
}
impl ResourceChange {
    /// Creates a new builder-style object to manufacture [`ResourceChange`](crate::model::ResourceChange)
    pub fn builder() -> crate::model::resource_change::Builder {
        crate::model::resource_change::Builder::default()
    }
}

/// <p>Information about a change to a resource attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceChangeDetail {
    /// <p>Information about the resource attribute to be modified.</p>
    pub target: std::option::Option<crate::model::ResourceTargetDefinition>,
    /// <p>For static evaluations, the value of the resource attribute will change and the new value is known.
    /// For dynamic evaluations, the value might change, and any new value will be determined when the plan is updated.</p>
    pub evaluation: std::option::Option<crate::model::EvaluationType>,
    /// <p>The ID of the entity that caused the change.</p>
    pub causing_entity: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceChangeDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceChangeDetail");
        formatter.field("target", &self.target);
        formatter.field("evaluation", &self.evaluation);
        formatter.field("causing_entity", &self.causing_entity);
        formatter.finish()
    }
}
/// See [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
pub mod resource_change_detail {
    /// A builder for [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<crate::model::ResourceTargetDefinition>,
        pub(crate) evaluation: std::option::Option<crate::model::EvaluationType>,
        pub(crate) causing_entity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the resource attribute to be modified.</p>
        pub fn target(mut self, input: crate::model::ResourceTargetDefinition) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>Information about the resource attribute to be modified.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::ResourceTargetDefinition>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>For static evaluations, the value of the resource attribute will change and the new value is known.
        /// For dynamic evaluations, the value might change, and any new value will be determined when the plan is updated.</p>
        pub fn evaluation(mut self, input: crate::model::EvaluationType) -> Self {
            self.evaluation = Some(input);
            self
        }
        /// <p>For static evaluations, the value of the resource attribute will change and the new value is known.
        /// For dynamic evaluations, the value might change, and any new value will be determined when the plan is updated.</p>
        pub fn set_evaluation(
            mut self,
            input: std::option::Option<crate::model::EvaluationType>,
        ) -> Self {
            self.evaluation = input;
            self
        }
        /// <p>The ID of the entity that caused the change.</p>
        pub fn causing_entity(mut self, input: impl Into<std::string::String>) -> Self {
            self.causing_entity = Some(input.into());
            self
        }
        /// <p>The ID of the entity that caused the change.</p>
        pub fn set_causing_entity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.causing_entity = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
        pub fn build(self) -> crate::model::ResourceChangeDetail {
            crate::model::ResourceChangeDetail {
                target: self.target,
                evaluation: self.evaluation,
                causing_entity: self.causing_entity,
            }
        }
    }
}
impl ResourceChangeDetail {
    /// Creates a new builder-style object to manufacture [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
    pub fn builder() -> crate::model::resource_change_detail::Builder {
        crate::model::resource_change_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EvaluationType {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EvaluationType {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMIC" => EvaluationType::Dynamic,
            "STATIC" => EvaluationType::Static,
            other => EvaluationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EvaluationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EvaluationType::from(s))
    }
}
impl EvaluationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EvaluationType::Dynamic => "DYNAMIC",
            EvaluationType::Static => "STATIC",
            EvaluationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMIC", "STATIC"]
    }
}
impl AsRef<str> for EvaluationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a change to a resource attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTargetDefinition {
    /// <p>The attribute to be changed.</p>
    pub attribute: std::option::Option<crate::model::ResourceAttribute>,
    /// <p>If the attribute is <code>Properties</code>, the value is the name of the property.
    /// Otherwise, the value is null.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If the attribute is <code>Properties</code>, indicates whether a change to this property
    /// causes the resource to be re-created.</p>
    pub requires_recreation: std::option::Option<crate::model::RequiresRecreation>,
}
impl std::fmt::Debug for ResourceTargetDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTargetDefinition");
        formatter.field("attribute", &self.attribute);
        formatter.field("name", &self.name);
        formatter.field("requires_recreation", &self.requires_recreation);
        formatter.finish()
    }
}
/// See [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
pub mod resource_target_definition {
    /// A builder for [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::ResourceAttribute>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) requires_recreation: std::option::Option<crate::model::RequiresRecreation>,
    }
    impl Builder {
        /// <p>The attribute to be changed.</p>
        pub fn attribute(mut self, input: crate::model::ResourceAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to be changed.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::ResourceAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>If the attribute is <code>Properties</code>, the value is the name of the property.
        /// Otherwise, the value is null.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>If the attribute is <code>Properties</code>, the value is the name of the property.
        /// Otherwise, the value is null.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If the attribute is <code>Properties</code>, indicates whether a change to this property
        /// causes the resource to be re-created.</p>
        pub fn requires_recreation(mut self, input: crate::model::RequiresRecreation) -> Self {
            self.requires_recreation = Some(input);
            self
        }
        /// <p>If the attribute is <code>Properties</code>, indicates whether a change to this property
        /// causes the resource to be re-created.</p>
        pub fn set_requires_recreation(
            mut self,
            input: std::option::Option<crate::model::RequiresRecreation>,
        ) -> Self {
            self.requires_recreation = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
        pub fn build(self) -> crate::model::ResourceTargetDefinition {
            crate::model::ResourceTargetDefinition {
                attribute: self.attribute,
                name: self.name,
                requires_recreation: self.requires_recreation,
            }
        }
    }
}
impl ResourceTargetDefinition {
    /// Creates a new builder-style object to manufacture [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
    pub fn builder() -> crate::model::resource_target_definition::Builder {
        crate::model::resource_target_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequiresRecreation {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Conditionally,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequiresRecreation {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => RequiresRecreation::Always,
            "CONDITIONALLY" => RequiresRecreation::Conditionally,
            "NEVER" => RequiresRecreation::Never,
            other => RequiresRecreation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequiresRecreation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequiresRecreation::from(s))
    }
}
impl RequiresRecreation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequiresRecreation::Always => "ALWAYS",
            RequiresRecreation::Conditionally => "CONDITIONALLY",
            RequiresRecreation::Never => "NEVER",
            RequiresRecreation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "CONDITIONALLY", "NEVER"]
    }
}
impl AsRef<str> for RequiresRecreation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceAttribute {
    #[allow(missing_docs)] // documentation missing in model
    Creationpolicy,
    #[allow(missing_docs)] // documentation missing in model
    Deletionpolicy,
    #[allow(missing_docs)] // documentation missing in model
    Metadata,
    #[allow(missing_docs)] // documentation missing in model
    Properties,
    #[allow(missing_docs)] // documentation missing in model
    Tags,
    #[allow(missing_docs)] // documentation missing in model
    Updatepolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceAttribute {
    fn from(s: &str) -> Self {
        match s {
            "CREATIONPOLICY" => ResourceAttribute::Creationpolicy,
            "DELETIONPOLICY" => ResourceAttribute::Deletionpolicy,
            "METADATA" => ResourceAttribute::Metadata,
            "PROPERTIES" => ResourceAttribute::Properties,
            "TAGS" => ResourceAttribute::Tags,
            "UPDATEPOLICY" => ResourceAttribute::Updatepolicy,
            other => ResourceAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceAttribute::from(s))
    }
}
impl ResourceAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceAttribute::Creationpolicy => "CREATIONPOLICY",
            ResourceAttribute::Deletionpolicy => "DELETIONPOLICY",
            ResourceAttribute::Metadata => "METADATA",
            ResourceAttribute::Properties => "PROPERTIES",
            ResourceAttribute::Tags => "TAGS",
            ResourceAttribute::Updatepolicy => "UPDATEPOLICY",
            ResourceAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATIONPOLICY",
            "DELETIONPOLICY",
            "METADATA",
            "PROPERTIES",
            "TAGS",
            "UPDATEPOLICY",
        ]
    }
}
impl AsRef<str> for ResourceAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Replacement {
    #[allow(missing_docs)] // documentation missing in model
    Conditional,
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Replacement {
    fn from(s: &str) -> Self {
        match s {
            "CONDITIONAL" => Replacement::Conditional,
            "FALSE" => Replacement::False,
            "TRUE" => Replacement::True,
            other => Replacement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Replacement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Replacement::from(s))
    }
}
impl Replacement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Replacement::Conditional => "CONDITIONAL",
            Replacement::False => "FALSE",
            Replacement::True => "TRUE",
            Replacement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONDITIONAL", "FALSE", "TRUE"]
    }
}
impl AsRef<str> for Replacement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => ChangeAction::Add,
            "MODIFY" => ChangeAction::Modify,
            "REMOVE" => ChangeAction::Remove,
            other => ChangeAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeAction::from(s))
    }
}
impl ChangeAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeAction::Add => "ADD",
            ChangeAction::Modify => "MODIFY",
            ChangeAction::Remove => "REMOVE",
            ChangeAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "MODIFY", "REMOVE"]
    }
}
impl AsRef<str> for ChangeAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedProductPlanDetails {
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The path identifier of the product. This value is optional if the product
    /// has a default path, and required if the product has more than one path.
    /// To list the paths for a product, use <a>ListLaunchPaths</a>.</p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The name of the plan.</p>
    pub plan_name: std::option::Option<std::string::String>,
    /// <p>The plan identifier.</p>
    pub plan_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub provision_product_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the provisioned product.</p>
    pub provision_product_name: std::option::Option<std::string::String>,
    /// <p>The plan type.</p>
    pub plan_type: std::option::Option<crate::model::ProvisionedProductPlanType>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The status.</p>
    pub status: std::option::Option<crate::model::ProvisionedProductPlanStatus>,
    /// <p>The time when the plan was last updated.</p>
    pub updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
    /// events.</p>
    pub notification_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Parameters specified by the administrator that are required for provisioning the
    /// product.</p>
    pub provisioning_parameters:
        std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The status message.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedProductPlanDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedProductPlanDetails");
        formatter.field("created_time", &self.created_time);
        formatter.field("path_id", &self.path_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("plan_name", &self.plan_name);
        formatter.field("plan_id", &self.plan_id);
        formatter.field("provision_product_id", &self.provision_product_id);
        formatter.field("provision_product_name", &self.provision_product_name);
        formatter.field("plan_type", &self.plan_type);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("status", &self.status);
        formatter.field("updated_time", &self.updated_time);
        formatter.field("notification_arns", &self.notification_arns);
        formatter.field("provisioning_parameters", &self.provisioning_parameters);
        formatter.field("tags", &self.tags);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`ProvisionedProductPlanDetails`](crate::model::ProvisionedProductPlanDetails)
pub mod provisioned_product_plan_details {
    /// A builder for [`ProvisionedProductPlanDetails`](crate::model::ProvisionedProductPlanDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) plan_name: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) provision_product_id: std::option::Option<std::string::String>,
        pub(crate) provision_product_name: std::option::Option<std::string::String>,
        pub(crate) plan_type: std::option::Option<crate::model::ProvisionedProductPlanType>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedProductPlanStatus>,
        pub(crate) updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) notification_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>.</p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product
        /// has a default path, and required if the product has more than one path.
        /// To list the paths for a product, use <a>ListLaunchPaths</a>.</p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_name = Some(input.into());
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_name = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_id = input;
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn provision_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_provision_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_name = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::ProvisionedProductPlanType) -> Self {
            self.plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanType>,
        ) -> Self {
            self.plan_type = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The status.</p>
        pub fn status(mut self, input: crate::model::ProvisionedProductPlanStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when the plan was last updated.</p>
        pub fn updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_time = Some(input);
            self
        }
        /// <p>The time when the plan was last updated.</p>
        pub fn set_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_time = input;
            self
        }
        /// Appends an item to `notification_arns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_arns.unwrap_or_default();
            v.push(input.into());
            self.notification_arns = Some(v);
            self
        }
        /// <p>Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
        /// events.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_arns = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: impl Into<crate::model::UpdateProvisioningParameter>,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input.into());
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>Parameters specified by the administrator that are required for provisioning the
        /// product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedProductPlanDetails`](crate::model::ProvisionedProductPlanDetails)
        pub fn build(self) -> crate::model::ProvisionedProductPlanDetails {
            crate::model::ProvisionedProductPlanDetails {
                created_time: self.created_time,
                path_id: self.path_id,
                product_id: self.product_id,
                plan_name: self.plan_name,
                plan_id: self.plan_id,
                provision_product_id: self.provision_product_id,
                provision_product_name: self.provision_product_name,
                plan_type: self.plan_type,
                provisioning_artifact_id: self.provisioning_artifact_id,
                status: self.status,
                updated_time: self.updated_time,
                notification_arns: self.notification_arns,
                provisioning_parameters: self.provisioning_parameters,
                tags: self.tags,
                status_message: self.status_message,
            }
        }
    }
}
impl ProvisionedProductPlanDetails {
    /// Creates a new builder-style object to manufacture [`ProvisionedProductPlanDetails`](crate::model::ProvisionedProductPlanDetails)
    pub fn builder() -> crate::model::provisioned_product_plan_details::Builder {
        crate::model::provisioned_product_plan_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedProductPlanStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateSuccess,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteFailed,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteSuccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedProductPlanStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => ProvisionedProductPlanStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => ProvisionedProductPlanStatus::CreateInProgress,
            "CREATE_SUCCESS" => ProvisionedProductPlanStatus::CreateSuccess,
            "EXECUTE_FAILED" => ProvisionedProductPlanStatus::ExecuteFailed,
            "EXECUTE_IN_PROGRESS" => ProvisionedProductPlanStatus::ExecuteInProgress,
            "EXECUTE_SUCCESS" => ProvisionedProductPlanStatus::ExecuteSuccess,
            other => ProvisionedProductPlanStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedProductPlanStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedProductPlanStatus::from(s))
    }
}
impl ProvisionedProductPlanStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedProductPlanStatus::CreateFailed => "CREATE_FAILED",
            ProvisionedProductPlanStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            ProvisionedProductPlanStatus::CreateSuccess => "CREATE_SUCCESS",
            ProvisionedProductPlanStatus::ExecuteFailed => "EXECUTE_FAILED",
            ProvisionedProductPlanStatus::ExecuteInProgress => "EXECUTE_IN_PROGRESS",
            ProvisionedProductPlanStatus::ExecuteSuccess => "EXECUTE_SUCCESS",
            ProvisionedProductPlanStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_SUCCESS",
            "EXECUTE_FAILED",
            "EXECUTE_IN_PROGRESS",
            "EXECUTE_SUCCESS",
        ]
    }
}
impl AsRef<str> for ProvisionedProductPlanStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a CloudWatch dashboard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchDashboard {
    /// <p>The name of the CloudWatch dashboard.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchDashboard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchDashboard");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CloudWatchDashboard`](crate::model::CloudWatchDashboard)
pub mod cloud_watch_dashboard {
    /// A builder for [`CloudWatchDashboard`](crate::model::CloudWatchDashboard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchDashboard`](crate::model::CloudWatchDashboard)
        pub fn build(self) -> crate::model::CloudWatchDashboard {
            crate::model::CloudWatchDashboard { name: self.name }
        }
    }
}
impl CloudWatchDashboard {
    /// Creates a new builder-style object to manufacture [`CloudWatchDashboard`](crate::model::CloudWatchDashboard)
    pub fn builder() -> crate::model::cloud_watch_dashboard::Builder {
        crate::model::cloud_watch_dashboard::Builder::default()
    }
}

/// <p>Summary information about a provisioning artifact (also known as a version) for a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactSummary {
    /// <p>The identifier of the provisioning artifact.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the provisioning artifact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the provisioning artifact.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The UTC time stamp of the creation time.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The metadata for the provisioning artifact. This is used with AWS Marketplace products.</p>
    pub provisioning_artifact_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ProvisioningArtifactSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field(
            "provisioning_artifact_metadata",
            &self.provisioning_artifact_metadata,
        );
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactSummary`](crate::model::ProvisioningArtifactSummary)
pub mod provisioning_artifact_summary {
    /// A builder for [`ProvisioningArtifactSummary`](crate::model::ProvisioningArtifactSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) provisioning_artifact_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The UTC time stamp of the creation time.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Adds a key-value pair to `provisioning_artifact_metadata`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_metadata`](Self::set_provisioning_artifact_metadata).
        ///
        /// <p>The metadata for the provisioning artifact. This is used with AWS Marketplace products.</p>
        pub fn provisioning_artifact_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provisioning_artifact_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.provisioning_artifact_metadata = Some(hash_map);
            self
        }
        /// <p>The metadata for the provisioning artifact. This is used with AWS Marketplace products.</p>
        pub fn set_provisioning_artifact_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.provisioning_artifact_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactSummary`](crate::model::ProvisioningArtifactSummary)
        pub fn build(self) -> crate::model::ProvisioningArtifactSummary {
            crate::model::ProvisioningArtifactSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                created_time: self.created_time,
                provisioning_artifact_metadata: self.provisioning_artifact_metadata,
            }
        }
    }
}
impl ProvisioningArtifactSummary {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactSummary`](crate::model::ProvisioningArtifactSummary)
    pub fn builder() -> crate::model::provisioning_artifact_summary::Builder {
        crate::model::provisioning_artifact_summary::Builder::default()
    }
}

/// <p>A launch path object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchPath {
    /// <p>The identifier of the launch path.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the launch path.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LaunchPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchPath");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`LaunchPath`](crate::model::LaunchPath)
pub mod launch_path {
    /// A builder for [`LaunchPath`](crate::model::LaunchPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the launch path.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the launch path.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the launch path.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch path.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchPath`](crate::model::LaunchPath)
        pub fn build(self) -> crate::model::LaunchPath {
            crate::model::LaunchPath {
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl LaunchPath {
    /// Creates a new builder-style object to manufacture [`LaunchPath`](crate::model::LaunchPath)
    pub fn builder() -> crate::model::launch_path::Builder {
        crate::model::launch_path::Builder::default()
    }
}

/// <p>Information about the portfolio share operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareDetails {
    /// <p>List of accounts for whom the operation succeeded.</p>
    pub successful_shares: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of errors.</p>
    pub share_errors: std::option::Option<std::vec::Vec<crate::model::ShareError>>,
}
impl std::fmt::Debug for ShareDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareDetails");
        formatter.field("successful_shares", &self.successful_shares);
        formatter.field("share_errors", &self.share_errors);
        formatter.finish()
    }
}
/// See [`ShareDetails`](crate::model::ShareDetails)
pub mod share_details {
    /// A builder for [`ShareDetails`](crate::model::ShareDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_shares: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) share_errors: std::option::Option<std::vec::Vec<crate::model::ShareError>>,
    }
    impl Builder {
        /// Appends an item to `successful_shares`.
        ///
        /// To override the contents of this collection use [`set_successful_shares`](Self::set_successful_shares).
        ///
        /// <p>List of accounts for whom the operation succeeded.</p>
        pub fn successful_shares(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.successful_shares.unwrap_or_default();
            v.push(input.into());
            self.successful_shares = Some(v);
            self
        }
        /// <p>List of accounts for whom the operation succeeded.</p>
        pub fn set_successful_shares(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.successful_shares = input;
            self
        }
        /// Appends an item to `share_errors`.
        ///
        /// To override the contents of this collection use [`set_share_errors`](Self::set_share_errors).
        ///
        /// <p>List of errors.</p>
        pub fn share_errors(mut self, input: impl Into<crate::model::ShareError>) -> Self {
            let mut v = self.share_errors.unwrap_or_default();
            v.push(input.into());
            self.share_errors = Some(v);
            self
        }
        /// <p>List of errors.</p>
        pub fn set_share_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ShareError>>,
        ) -> Self {
            self.share_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareDetails`](crate::model::ShareDetails)
        pub fn build(self) -> crate::model::ShareDetails {
            crate::model::ShareDetails {
                successful_shares: self.successful_shares,
                share_errors: self.share_errors,
            }
        }
    }
}
impl ShareDetails {
    /// Creates a new builder-style object to manufacture [`ShareDetails`](crate::model::ShareDetails)
    pub fn builder() -> crate::model::share_details::Builder {
        crate::model::share_details::Builder::default()
    }
}

/// <p>Errors that occurred during the portfolio share operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareError {
    /// <p>List of accounts impacted by the error.</p>
    pub accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Error type that happened when processing the operation.</p>
    pub error: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareError");
        formatter.field("accounts", &self.accounts);
        formatter.field("message", &self.message);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ShareError`](crate::model::ShareError)
pub mod share_error {
    /// A builder for [`ShareError`](crate::model::ShareError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>List of accounts impacted by the error.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>List of accounts impacted by the error.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>Information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Error type that happened when processing the operation.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>Error type that happened when processing the operation.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareError`](crate::model::ShareError)
        pub fn build(self) -> crate::model::ShareError {
            crate::model::ShareError {
                accounts: self.accounts,
                message: self.message,
                error: self.error,
            }
        }
    }
}
impl ShareError {
    /// Creates a new builder-style object to manufacture [`ShareError`](crate::model::ShareError)
    pub fn builder() -> crate::model::share_error::Builder {
        crate::model::share_error::Builder::default()
    }
}

/// <p>Information about the portfolio share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortfolioShareDetail {
    /// <p>The identifier of the recipient entity that received the portfolio share.
    /// The recipient entities can be one of the following:
    /// </p>
    /// <p>1. An external account.</p>
    /// <p>2. An organziation member account.</p>
    /// <p>3. An organzational unit (OU).</p>
    /// <p>4. The organization itself. (This shares with every account in the organization).</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The type of the portfolio share.</p>
    pub r#type: std::option::Option<crate::model::DescribePortfolioShareType>,
    /// <p>Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an organization node, the share is automatically imported, and the field is always set to true.</p>
    pub accepted: bool,
    /// <p>Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.</p>
    pub share_tag_options: bool,
}
impl std::fmt::Debug for PortfolioShareDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortfolioShareDetail");
        formatter.field("principal_id", &self.principal_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("accepted", &self.accepted);
        formatter.field("share_tag_options", &self.share_tag_options);
        formatter.finish()
    }
}
/// See [`PortfolioShareDetail`](crate::model::PortfolioShareDetail)
pub mod portfolio_share_detail {
    /// A builder for [`PortfolioShareDetail`](crate::model::PortfolioShareDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DescribePortfolioShareType>,
        pub(crate) accepted: std::option::Option<bool>,
        pub(crate) share_tag_options: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the recipient entity that received the portfolio share.
        /// The recipient entities can be one of the following:
        /// </p>
        /// <p>1. An external account.</p>
        /// <p>2. An organziation member account.</p>
        /// <p>3. An organzational unit (OU).</p>
        /// <p>4. The organization itself. (This shares with every account in the organization).</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The identifier of the recipient entity that received the portfolio share.
        /// The recipient entities can be one of the following:
        /// </p>
        /// <p>1. An external account.</p>
        /// <p>2. An organziation member account.</p>
        /// <p>3. An organzational unit (OU).</p>
        /// <p>4. The organization itself. (This shares with every account in the organization).</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The type of the portfolio share.</p>
        pub fn r#type(mut self, input: crate::model::DescribePortfolioShareType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the portfolio share.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DescribePortfolioShareType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an organization node, the share is automatically imported, and the field is always set to true.</p>
        pub fn accepted(mut self, input: bool) -> Self {
            self.accepted = Some(input);
            self
        }
        /// <p>Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an organization node, the share is automatically imported, and the field is always set to true.</p>
        pub fn set_accepted(mut self, input: std::option::Option<bool>) -> Self {
            self.accepted = input;
            self
        }
        /// <p>Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.</p>
        pub fn share_tag_options(mut self, input: bool) -> Self {
            self.share_tag_options = Some(input);
            self
        }
        /// <p>Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.</p>
        pub fn set_share_tag_options(mut self, input: std::option::Option<bool>) -> Self {
            self.share_tag_options = input;
            self
        }
        /// Consumes the builder and constructs a [`PortfolioShareDetail`](crate::model::PortfolioShareDetail)
        pub fn build(self) -> crate::model::PortfolioShareDetail {
            crate::model::PortfolioShareDetail {
                principal_id: self.principal_id,
                r#type: self.r#type,
                accepted: self.accepted.unwrap_or_default(),
                share_tag_options: self.share_tag_options.unwrap_or_default(),
            }
        }
    }
}
impl PortfolioShareDetail {
    /// Creates a new builder-style object to manufacture [`PortfolioShareDetail`](crate::model::PortfolioShareDetail)
    pub fn builder() -> crate::model::portfolio_share_detail::Builder {
        crate::model::portfolio_share_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DescribePortfolioShareType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationalUnit,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationMemberAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DescribePortfolioShareType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => DescribePortfolioShareType::Account,
            "ORGANIZATION" => DescribePortfolioShareType::Organization,
            "ORGANIZATIONAL_UNIT" => DescribePortfolioShareType::OrganizationalUnit,
            "ORGANIZATION_MEMBER_ACCOUNT" => DescribePortfolioShareType::OrganizationMemberAccount,
            other => DescribePortfolioShareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DescribePortfolioShareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DescribePortfolioShareType::from(s))
    }
}
impl DescribePortfolioShareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DescribePortfolioShareType::Account => "ACCOUNT",
            DescribePortfolioShareType::Organization => "ORGANIZATION",
            DescribePortfolioShareType::OrganizationalUnit => "ORGANIZATIONAL_UNIT",
            DescribePortfolioShareType::OrganizationMemberAccount => "ORGANIZATION_MEMBER_ACCOUNT",
            DescribePortfolioShareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT",
            "ORGANIZATION",
            "ORGANIZATIONAL_UNIT",
            "ORGANIZATION_MEMBER_ACCOUNT",
        ]
    }
}
impl AsRef<str> for DescribePortfolioShareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CopyProductStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CopyProductStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => CopyProductStatus::Failed,
            "IN_PROGRESS" => CopyProductStatus::InProgress,
            "SUCCEEDED" => CopyProductStatus::Succeeded,
            other => CopyProductStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CopyProductStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CopyProductStatus::from(s))
    }
}
impl CopyProductStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CopyProductStatus::Failed => "FAILED",
            CopyProductStatus::InProgress => "IN_PROGRESS",
            CopyProductStatus::Succeeded => "SUCCEEDED",
            CopyProductStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for CopyProductStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a provisioning artifact (also known as a version) for a product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningArtifactProperties {
    /// <p>The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the provisioning artifact, including how it differs from the previous provisioning artifact.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specify the template source with one of the following options, but not both.
    /// Keys accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ]</p>
    /// <p>The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:</p>
    /// <p>
    /// <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
    /// </p>
    /// <p>
    /// <code>ImportFromPhysicalId</code>: The physical id of the resource that contains the
    /// template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON
    /// format as follows: <code>ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]</code>
    /// </p>
    pub info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of provisioning artifact.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ProvisioningArtifactType>,
    /// <p>If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.</p>
    pub disable_template_validation: bool,
}
impl std::fmt::Debug for ProvisioningArtifactProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningArtifactProperties");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("info", &self.info);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "disable_template_validation",
            &self.disable_template_validation,
        );
        formatter.finish()
    }
}
/// See [`ProvisioningArtifactProperties`](crate::model::ProvisioningArtifactProperties)
pub mod provisioning_artifact_properties {
    /// A builder for [`ProvisioningArtifactProperties`](crate::model::ProvisioningArtifactProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::ProvisioningArtifactType>,
        pub(crate) disable_template_validation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the provisioning artifact, including how it differs from the previous provisioning artifact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the provisioning artifact, including how it differs from the previous provisioning artifact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `info`.
        ///
        /// To override the contents of this collection use [`set_info`](Self::set_info).
        ///
        /// <p>Specify the template source with one of the following options, but not both.
        /// Keys accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ]</p>
        /// <p>The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:</p>
        /// <p>
        /// <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
        /// </p>
        /// <p>
        /// <code>ImportFromPhysicalId</code>: The physical id of the resource that contains the
        /// template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON
        /// format as follows: <code>ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]</code>
        /// </p>
        pub fn info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.info = Some(hash_map);
            self
        }
        /// <p>Specify the template source with one of the following options, but not both.
        /// Keys accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ]</p>
        /// <p>The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:</p>
        /// <p>
        /// <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
        /// </p>
        /// <p>
        /// <code>ImportFromPhysicalId</code>: The physical id of the resource that contains the
        /// template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON
        /// format as follows: <code>ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]</code>
        /// </p>
        pub fn set_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.info = input;
            self
        }
        /// <p>The type of provisioning artifact.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ProvisioningArtifactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of provisioning artifact.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.</p>
        pub fn disable_template_validation(mut self, input: bool) -> Self {
            self.disable_template_validation = Some(input);
            self
        }
        /// <p>If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.</p>
        pub fn set_disable_template_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_template_validation = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningArtifactProperties`](crate::model::ProvisioningArtifactProperties)
        pub fn build(self) -> crate::model::ProvisioningArtifactProperties {
            crate::model::ProvisioningArtifactProperties {
                name: self.name,
                description: self.description,
                info: self.info,
                r#type: self.r#type,
                disable_template_validation: self.disable_template_validation.unwrap_or_default(),
            }
        }
    }
}
impl ProvisioningArtifactProperties {
    /// Creates a new builder-style object to manufacture [`ProvisioningArtifactProperties`](crate::model::ProvisioningArtifactProperties)
    pub fn builder() -> crate::model::provisioning_artifact_properties::Builder {
        crate::model::provisioning_artifact_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CopyOption {
    #[allow(missing_docs)] // documentation missing in model
    CopyTags,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CopyOption {
    fn from(s: &str) -> Self {
        match s {
            "CopyTags" => CopyOption::CopyTags,
            other => CopyOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CopyOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CopyOption::from(s))
    }
}
impl CopyOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CopyOption::CopyTags => "CopyTags",
            CopyOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CopyTags"]
    }
}
impl AsRef<str> for CopyOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisioningArtifactPropertyName {
    #[allow(missing_docs)] // documentation missing in model
    Id,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisioningArtifactPropertyName {
    fn from(s: &str) -> Self {
        match s {
            "Id" => ProvisioningArtifactPropertyName::Id,
            other => ProvisioningArtifactPropertyName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisioningArtifactPropertyName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisioningArtifactPropertyName::from(s))
    }
}
impl ProvisioningArtifactPropertyName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisioningArtifactPropertyName::Id => "Id",
            ProvisioningArtifactPropertyName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Id"]
    }
}
impl AsRef<str> for ProvisioningArtifactPropertyName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object containing information about the error, along with identifying information about the self-service action and its associations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedServiceActionAssociation {
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The error code. Valid values are listed below.</p>
    pub error_code: std::option::Option<crate::model::ServiceActionAssociationErrorCode>,
    /// <p>A text description of the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailedServiceActionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedServiceActionAssociation");
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedServiceActionAssociation`](crate::model::FailedServiceActionAssociation)
pub mod failed_service_action_association {
    /// A builder for [`FailedServiceActionAssociation`](crate::model::FailedServiceActionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ServiceActionAssociationErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The error code. Valid values are listed below.</p>
        pub fn error_code(
            mut self,
            input: crate::model::ServiceActionAssociationErrorCode,
        ) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code. Valid values are listed below.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ServiceActionAssociationErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A text description of the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A text description of the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedServiceActionAssociation`](crate::model::FailedServiceActionAssociation)
        pub fn build(self) -> crate::model::FailedServiceActionAssociation {
            crate::model::FailedServiceActionAssociation {
                service_action_id: self.service_action_id,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedServiceActionAssociation {
    /// Creates a new builder-style object to manufacture [`FailedServiceActionAssociation`](crate::model::FailedServiceActionAssociation)
    pub fn builder() -> crate::model::failed_service_action_association::Builder {
        crate::model::failed_service_action_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceActionAssociationErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateResourceException,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceededException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceActionAssociationErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_RESOURCE" => ServiceActionAssociationErrorCode::DuplicateResourceException,
            "INTERNAL_FAILURE" => ServiceActionAssociationErrorCode::InternalFailure,
            "LIMIT_EXCEEDED" => ServiceActionAssociationErrorCode::LimitExceededException,
            "RESOURCE_NOT_FOUND" => ServiceActionAssociationErrorCode::ResourceNotFoundException,
            "THROTTLING" => ServiceActionAssociationErrorCode::ThrottlingException,
            other => ServiceActionAssociationErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceActionAssociationErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceActionAssociationErrorCode::from(s))
    }
}
impl ServiceActionAssociationErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceActionAssociationErrorCode::DuplicateResourceException => "DUPLICATE_RESOURCE",
            ServiceActionAssociationErrorCode::InternalFailure => "INTERNAL_FAILURE",
            ServiceActionAssociationErrorCode::LimitExceededException => "LIMIT_EXCEEDED",
            ServiceActionAssociationErrorCode::ResourceNotFoundException => "RESOURCE_NOT_FOUND",
            ServiceActionAssociationErrorCode::ThrottlingException => "THROTTLING",
            ServiceActionAssociationErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DUPLICATE_RESOURCE",
            "INTERNAL_FAILURE",
            "LIMIT_EXCEEDED",
            "RESOURCE_NOT_FOUND",
            "THROTTLING",
        ]
    }
}
impl AsRef<str> for ServiceActionAssociationErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A self-service action association consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceActionAssociation {
    /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
    pub service_action_id: std::option::Option<std::string::String>,
    /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceActionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceActionAssociation");
        formatter.field("service_action_id", &self.service_action_id);
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.finish()
    }
}
/// See [`ServiceActionAssociation`](crate::model::ServiceActionAssociation)
pub mod service_action_association {
    /// A builder for [`ServiceActionAssociation`](crate::model::ServiceActionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_id: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn service_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_action_id = Some(input.into());
            self
        }
        /// <p>The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.</p>
        pub fn set_service_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_action_id = input;
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceActionAssociation`](crate::model::ServiceActionAssociation)
        pub fn build(self) -> crate::model::ServiceActionAssociation {
            crate::model::ServiceActionAssociation {
                service_action_id: self.service_action_id,
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
            }
        }
    }
}
impl ServiceActionAssociation {
    /// Creates a new builder-style object to manufacture [`ServiceActionAssociation`](crate::model::ServiceActionAssociation)
    pub fn builder() -> crate::model::service_action_association::Builder {
        crate::model::service_action_association::Builder::default()
    }
}
