// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagOptionOutput {
    /// <p>Information about the TagOption.</p>
    pub tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
}
impl std::fmt::Debug for UpdateTagOptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagOptionOutput");
        formatter.field("tag_option_detail", &self.tag_option_detail);
        formatter.finish()
    }
}
/// See [`UpdateTagOptionOutput`](crate::output::UpdateTagOptionOutput)
pub mod update_tag_option_output {
    /// A builder for [`UpdateTagOptionOutput`](crate::output::UpdateTagOptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
    }
    impl Builder {
        /// <p>Information about the TagOption.</p>
        pub fn tag_option_detail(mut self, input: crate::model::TagOptionDetail) -> Self {
            self.tag_option_detail = Some(input);
            self
        }
        /// <p>Information about the TagOption.</p>
        pub fn set_tag_option_detail(
            mut self,
            input: std::option::Option<crate::model::TagOptionDetail>,
        ) -> Self {
            self.tag_option_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTagOptionOutput`](crate::output::UpdateTagOptionOutput)
        pub fn build(self) -> crate::output::UpdateTagOptionOutput {
            crate::output::UpdateTagOptionOutput {
                tag_option_detail: self.tag_option_detail,
            }
        }
    }
}
impl UpdateTagOptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTagOptionOutput`](crate::output::UpdateTagOptionOutput)
    pub fn builder() -> crate::output::update_tag_option_output::Builder {
        crate::output::update_tag_option_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceActionOutput {
    /// <p>Detailed information about the self-service action.</p>
    pub service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
}
impl std::fmt::Debug for UpdateServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceActionOutput");
        formatter.field("service_action_detail", &self.service_action_detail);
        formatter.finish()
    }
}
/// See [`UpdateServiceActionOutput`](crate::output::UpdateServiceActionOutput)
pub mod update_service_action_output {
    /// A builder for [`UpdateServiceActionOutput`](crate::output::UpdateServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
    }
    impl Builder {
        /// <p>Detailed information about the self-service action.</p>
        pub fn service_action_detail(mut self, input: crate::model::ServiceActionDetail) -> Self {
            self.service_action_detail = Some(input);
            self
        }
        /// <p>Detailed information about the self-service action.</p>
        pub fn set_service_action_detail(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDetail>,
        ) -> Self {
            self.service_action_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceActionOutput`](crate::output::UpdateServiceActionOutput)
        pub fn build(self) -> crate::output::UpdateServiceActionOutput {
            crate::output::UpdateServiceActionOutput {
                service_action_detail: self.service_action_detail,
            }
        }
    }
}
impl UpdateServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceActionOutput`](crate::output::UpdateServiceActionOutput)
    pub fn builder() -> crate::output::update_service_action_output::Builder {
        crate::output::update_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisioningArtifactOutput {
    /// <p>Information about the provisioning artifact.</p>
    pub provisioning_artifact_detail: std::option::Option<crate::model::ProvisioningArtifactDetail>,
    /// <p>The URL of the CloudFormation template in Amazon S3.</p>
    pub info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for UpdateProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisioningArtifactOutput");
        formatter.field(
            "provisioning_artifact_detail",
            &self.provisioning_artifact_detail,
        );
        formatter.field("info", &self.info);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateProvisioningArtifactOutput`](crate::output::UpdateProvisioningArtifactOutput)
pub mod update_provisioning_artifact_output {
    /// A builder for [`UpdateProvisioningArtifactOutput`](crate::output::UpdateProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_detail:
            std::option::Option<crate::model::ProvisioningArtifactDetail>,
        pub(crate) info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the provisioning artifact.</p>
        pub fn provisioning_artifact_detail(
            mut self,
            input: crate::model::ProvisioningArtifactDetail,
        ) -> Self {
            self.provisioning_artifact_detail = Some(input);
            self
        }
        /// <p>Information about the provisioning artifact.</p>
        pub fn set_provisioning_artifact_detail(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactDetail>,
        ) -> Self {
            self.provisioning_artifact_detail = input;
            self
        }
        /// Adds a key-value pair to `info`.
        ///
        /// To override the contents of this collection use [`set_info`](Self::set_info).
        ///
        /// <p>The URL of the CloudFormation template in Amazon S3.</p>
        pub fn info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.info = Some(hash_map);
            self
        }
        /// <p>The URL of the CloudFormation template in Amazon S3.</p>
        pub fn set_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.info = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisioningArtifactOutput`](crate::output::UpdateProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::UpdateProvisioningArtifactOutput {
            crate::output::UpdateProvisioningArtifactOutput {
                provisioning_artifact_detail: self.provisioning_artifact_detail,
                info: self.info,
                status: self.status,
            }
        }
    }
}
impl UpdateProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningArtifactOutput`](crate::output::UpdateProvisioningArtifactOutput)
    pub fn builder() -> crate::output::update_provisioning_artifact_output::Builder {
        crate::output::update_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisionedProductPropertiesOutput {
    /// <p>The provisioned product identifier.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>A map that contains the properties updated.</p>
    pub provisioned_product_properties: std::option::Option<
        std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
    >,
    /// <p>The identifier of the record.</p>
    pub record_id: std::option::Option<std::string::String>,
    /// <p>The status of the request.</p>
    pub status: std::option::Option<crate::model::RecordStatus>,
}
impl std::fmt::Debug for UpdateProvisionedProductPropertiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisionedProductPropertiesOutput");
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field(
            "provisioned_product_properties",
            &self.provisioned_product_properties,
        );
        formatter.field("record_id", &self.record_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateProvisionedProductPropertiesOutput`](crate::output::UpdateProvisionedProductPropertiesOutput)
pub mod update_provisioned_product_properties_output {
    /// A builder for [`UpdateProvisionedProductPropertiesOutput`](crate::output::UpdateProvisionedProductPropertiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_properties: std::option::Option<
            std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
        >,
        pub(crate) record_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecordStatus>,
    }
    impl Builder {
        /// <p>The provisioned product identifier.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The provisioned product identifier.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// Adds a key-value pair to `provisioned_product_properties`.
        ///
        /// To override the contents of this collection use [`set_provisioned_product_properties`](Self::set_provisioned_product_properties).
        ///
        /// <p>A map that contains the properties updated.</p>
        pub fn provisioned_product_properties(
            mut self,
            k: impl Into<crate::model::PropertyKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.provisioned_product_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.provisioned_product_properties = Some(hash_map);
            self
        }
        /// <p>A map that contains the properties updated.</p>
        pub fn set_provisioned_product_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::PropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.provisioned_product_properties = input;
            self
        }
        /// <p>The identifier of the record.</p>
        pub fn record_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_id = Some(input.into());
            self
        }
        /// <p>The identifier of the record.</p>
        pub fn set_record_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_id = input;
            self
        }
        /// <p>The status of the request.</p>
        pub fn status(mut self, input: crate::model::RecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisionedProductPropertiesOutput`](crate::output::UpdateProvisionedProductPropertiesOutput)
        pub fn build(self) -> crate::output::UpdateProvisionedProductPropertiesOutput {
            crate::output::UpdateProvisionedProductPropertiesOutput {
                provisioned_product_id: self.provisioned_product_id,
                provisioned_product_properties: self.provisioned_product_properties,
                record_id: self.record_id,
                status: self.status,
            }
        }
    }
}
impl UpdateProvisionedProductPropertiesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductPropertiesOutput`](crate::output::UpdateProvisionedProductPropertiesOutput)
    pub fn builder() -> crate::output::update_provisioned_product_properties_output::Builder {
        crate::output::update_provisioned_product_properties_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisionedProductOutput {
    /// <p>Information about the result of the request.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for UpdateProvisionedProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisionedProductOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`UpdateProvisionedProductOutput`](crate::output::UpdateProvisionedProductOutput)
pub mod update_provisioned_product_output {
    /// A builder for [`UpdateProvisionedProductOutput`](crate::output::UpdateProvisionedProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>Information about the result of the request.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about the result of the request.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProvisionedProductOutput`](crate::output::UpdateProvisionedProductOutput)
        pub fn build(self) -> crate::output::UpdateProvisionedProductOutput {
            crate::output::UpdateProvisionedProductOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl UpdateProvisionedProductOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProvisionedProductOutput`](crate::output::UpdateProvisionedProductOutput)
    pub fn builder() -> crate::output::update_provisioned_product_output::Builder {
        crate::output::update_provisioned_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProductOutput {
    /// <p>Information about the product view.</p>
    pub product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
    /// <p>Information about the tags associated with the product.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UpdateProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProductOutput");
        formatter.field("product_view_detail", &self.product_view_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateProductOutput`](crate::output::UpdateProductOutput)
pub mod update_product_output {
    /// A builder for [`UpdateProductOutput`](crate::output::UpdateProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Information about the product view.</p>
        pub fn product_view_detail(mut self, input: crate::model::ProductViewDetail) -> Self {
            self.product_view_detail = Some(input);
            self
        }
        /// <p>Information about the product view.</p>
        pub fn set_product_view_detail(
            mut self,
            input: std::option::Option<crate::model::ProductViewDetail>,
        ) -> Self {
            self.product_view_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the product.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the product.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProductOutput`](crate::output::UpdateProductOutput)
        pub fn build(self) -> crate::output::UpdateProductOutput {
            crate::output::UpdateProductOutput {
                product_view_detail: self.product_view_detail,
                tags: self.tags,
            }
        }
    }
}
impl UpdateProductOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProductOutput`](crate::output::UpdateProductOutput)
    pub fn builder() -> crate::output::update_product_output::Builder {
        crate::output::update_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortfolioShareOutput {
    /// <p>The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to account or  organizational type sharing.</p>
    pub portfolio_share_token: std::option::Option<std::string::String>,
    /// <p>The status of <code>UpdatePortfolioShare</code> operation.
    /// You can also obtain the operation status using <code>DescribePortfolioShareStatus</code> API.
    /// </p>
    pub status: std::option::Option<crate::model::ShareStatus>,
}
impl std::fmt::Debug for UpdatePortfolioShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortfolioShareOutput");
        formatter.field("portfolio_share_token", &self.portfolio_share_token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdatePortfolioShareOutput`](crate::output::UpdatePortfolioShareOutput)
pub mod update_portfolio_share_output {
    /// A builder for [`UpdatePortfolioShareOutput`](crate::output::UpdatePortfolioShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_share_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ShareStatus>,
    }
    impl Builder {
        /// <p>The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to account or  organizational type sharing.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_share_token = Some(input.into());
            self
        }
        /// <p>The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to account or  organizational type sharing.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portfolio_share_token = input;
            self
        }
        /// <p>The status of <code>UpdatePortfolioShare</code> operation.
        /// You can also obtain the operation status using <code>DescribePortfolioShareStatus</code> API.
        /// </p>
        pub fn status(mut self, input: crate::model::ShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of <code>UpdatePortfolioShare</code> operation.
        /// You can also obtain the operation status using <code>DescribePortfolioShareStatus</code> API.
        /// </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ShareStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortfolioShareOutput`](crate::output::UpdatePortfolioShareOutput)
        pub fn build(self) -> crate::output::UpdatePortfolioShareOutput {
            crate::output::UpdatePortfolioShareOutput {
                portfolio_share_token: self.portfolio_share_token,
                status: self.status,
            }
        }
    }
}
impl UpdatePortfolioShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioShareOutput`](crate::output::UpdatePortfolioShareOutput)
    pub fn builder() -> crate::output::update_portfolio_share_output::Builder {
        crate::output::update_portfolio_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortfolioOutput {
    /// <p>Information about the portfolio.</p>
    pub portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
    /// <p>Information about the tags associated with the portfolio.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UpdatePortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortfolioOutput");
        formatter.field("portfolio_detail", &self.portfolio_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdatePortfolioOutput`](crate::output::UpdatePortfolioOutput)
pub mod update_portfolio_output {
    /// A builder for [`UpdatePortfolioOutput`](crate::output::UpdatePortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Information about the portfolio.</p>
        pub fn portfolio_detail(mut self, input: crate::model::PortfolioDetail) -> Self {
            self.portfolio_detail = Some(input);
            self
        }
        /// <p>Information about the portfolio.</p>
        pub fn set_portfolio_detail(
            mut self,
            input: std::option::Option<crate::model::PortfolioDetail>,
        ) -> Self {
            self.portfolio_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortfolioOutput`](crate::output::UpdatePortfolioOutput)
        pub fn build(self) -> crate::output::UpdatePortfolioOutput {
            crate::output::UpdatePortfolioOutput {
                portfolio_detail: self.portfolio_detail,
                tags: self.tags,
            }
        }
    }
}
impl UpdatePortfolioOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePortfolioOutput`](crate::output::UpdatePortfolioOutput)
    pub fn builder() -> crate::output::update_portfolio_output::Builder {
        crate::output::update_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConstraintOutput {
    /// <p>Information about the constraint.</p>
    pub constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
    /// <p>The constraint parameters.</p>
    pub constraint_parameters: std::option::Option<std::string::String>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for UpdateConstraintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConstraintOutput");
        formatter.field("constraint_detail", &self.constraint_detail);
        formatter.field("constraint_parameters", &self.constraint_parameters);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateConstraintOutput`](crate::output::UpdateConstraintOutput)
pub mod update_constraint_output {
    /// A builder for [`UpdateConstraintOutput`](crate::output::UpdateConstraintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
        pub(crate) constraint_parameters: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the constraint.</p>
        pub fn constraint_detail(mut self, input: crate::model::ConstraintDetail) -> Self {
            self.constraint_detail = Some(input);
            self
        }
        /// <p>Information about the constraint.</p>
        pub fn set_constraint_detail(
            mut self,
            input: std::option::Option<crate::model::ConstraintDetail>,
        ) -> Self {
            self.constraint_detail = input;
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn constraint_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_parameters = Some(input.into());
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn set_constraint_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_parameters = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConstraintOutput`](crate::output::UpdateConstraintOutput)
        pub fn build(self) -> crate::output::UpdateConstraintOutput {
            crate::output::UpdateConstraintOutput {
                constraint_detail: self.constraint_detail,
                constraint_parameters: self.constraint_parameters,
                status: self.status,
            }
        }
    }
}
impl UpdateConstraintOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConstraintOutput`](crate::output::UpdateConstraintOutput)
    pub fn builder() -> crate::output::update_constraint_output::Builder {
        crate::output::update_constraint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateProvisionedProductOutput {
    /// <p>Information about the result of this request.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for TerminateProvisionedProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateProvisionedProductOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`TerminateProvisionedProductOutput`](crate::output::TerminateProvisionedProductOutput)
pub mod terminate_provisioned_product_output {
    /// A builder for [`TerminateProvisionedProductOutput`](crate::output::TerminateProvisionedProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>Information about the result of this request.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about the result of this request.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateProvisionedProductOutput`](crate::output::TerminateProvisionedProductOutput)
        pub fn build(self) -> crate::output::TerminateProvisionedProductOutput {
            crate::output::TerminateProvisionedProductOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl TerminateProvisionedProductOutput {
    /// Creates a new builder-style object to manufacture [`TerminateProvisionedProductOutput`](crate::output::TerminateProvisionedProductOutput)
    pub fn builder() -> crate::output::terminate_provisioned_product_output::Builder {
        crate::output::terminate_provisioned_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProvisionedProductsOutput {
    /// <p>Information about the provisioned products.</p>
    pub provisioned_products:
        std::option::Option<std::vec::Vec<crate::model::ProvisionedProductAttribute>>,
    /// <p>The number of provisioned products found.</p>
    pub total_results_count: i32,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchProvisionedProductsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProvisionedProductsOutput");
        formatter.field("provisioned_products", &self.provisioned_products);
        formatter.field("total_results_count", &self.total_results_count);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`SearchProvisionedProductsOutput`](crate::output::SearchProvisionedProductsOutput)
pub mod search_provisioned_products_output {
    /// A builder for [`SearchProvisionedProductsOutput`](crate::output::SearchProvisionedProductsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_products:
            std::option::Option<std::vec::Vec<crate::model::ProvisionedProductAttribute>>,
        pub(crate) total_results_count: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioned_products`.
        ///
        /// To override the contents of this collection use [`set_provisioned_products`](Self::set_provisioned_products).
        ///
        /// <p>Information about the provisioned products.</p>
        pub fn provisioned_products(
            mut self,
            input: impl Into<crate::model::ProvisionedProductAttribute>,
        ) -> Self {
            let mut v = self.provisioned_products.unwrap_or_default();
            v.push(input.into());
            self.provisioned_products = Some(v);
            self
        }
        /// <p>Information about the provisioned products.</p>
        pub fn set_provisioned_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisionedProductAttribute>>,
        ) -> Self {
            self.provisioned_products = input;
            self
        }
        /// <p>The number of provisioned products found.</p>
        pub fn total_results_count(mut self, input: i32) -> Self {
            self.total_results_count = Some(input);
            self
        }
        /// <p>The number of provisioned products found.</p>
        pub fn set_total_results_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_results_count = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProvisionedProductsOutput`](crate::output::SearchProvisionedProductsOutput)
        pub fn build(self) -> crate::output::SearchProvisionedProductsOutput {
            crate::output::SearchProvisionedProductsOutput {
                provisioned_products: self.provisioned_products,
                total_results_count: self.total_results_count.unwrap_or_default(),
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl SearchProvisionedProductsOutput {
    /// Creates a new builder-style object to manufacture [`SearchProvisionedProductsOutput`](crate::output::SearchProvisionedProductsOutput)
    pub fn builder() -> crate::output::search_provisioned_products_output::Builder {
        crate::output::search_provisioned_products_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProductsAsAdminOutput {
    /// <p>Information about the product views.</p>
    pub product_view_details: std::option::Option<std::vec::Vec<crate::model::ProductViewDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchProductsAsAdminOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProductsAsAdminOutput");
        formatter.field("product_view_details", &self.product_view_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`SearchProductsAsAdminOutput`](crate::output::SearchProductsAsAdminOutput)
pub mod search_products_as_admin_output {
    /// A builder for [`SearchProductsAsAdminOutput`](crate::output::SearchProductsAsAdminOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_details:
            std::option::Option<std::vec::Vec<crate::model::ProductViewDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `product_view_details`.
        ///
        /// To override the contents of this collection use [`set_product_view_details`](Self::set_product_view_details).
        ///
        /// <p>Information about the product views.</p>
        pub fn product_view_details(
            mut self,
            input: impl Into<crate::model::ProductViewDetail>,
        ) -> Self {
            let mut v = self.product_view_details.unwrap_or_default();
            v.push(input.into());
            self.product_view_details = Some(v);
            self
        }
        /// <p>Information about the product views.</p>
        pub fn set_product_view_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductViewDetail>>,
        ) -> Self {
            self.product_view_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProductsAsAdminOutput`](crate::output::SearchProductsAsAdminOutput)
        pub fn build(self) -> crate::output::SearchProductsAsAdminOutput {
            crate::output::SearchProductsAsAdminOutput {
                product_view_details: self.product_view_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl SearchProductsAsAdminOutput {
    /// Creates a new builder-style object to manufacture [`SearchProductsAsAdminOutput`](crate::output::SearchProductsAsAdminOutput)
    pub fn builder() -> crate::output::search_products_as_admin_output::Builder {
        crate::output::search_products_as_admin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProductsOutput {
    /// <p>Information about the product views.</p>
    pub product_view_summaries:
        std::option::Option<std::vec::Vec<crate::model::ProductViewSummary>>,
    /// <p>The product view aggregations.</p>
    pub product_view_aggregations: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ProductViewAggregationValue>,
        >,
    >,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchProductsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProductsOutput");
        formatter.field("product_view_summaries", &self.product_view_summaries);
        formatter.field("product_view_aggregations", &self.product_view_aggregations);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`SearchProductsOutput`](crate::output::SearchProductsOutput)
pub mod search_products_output {
    /// A builder for [`SearchProductsOutput`](crate::output::SearchProductsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_summaries:
            std::option::Option<std::vec::Vec<crate::model::ProductViewSummary>>,
        pub(crate) product_view_aggregations: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ProductViewAggregationValue>,
            >,
        >,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `product_view_summaries`.
        ///
        /// To override the contents of this collection use [`set_product_view_summaries`](Self::set_product_view_summaries).
        ///
        /// <p>Information about the product views.</p>
        pub fn product_view_summaries(
            mut self,
            input: impl Into<crate::model::ProductViewSummary>,
        ) -> Self {
            let mut v = self.product_view_summaries.unwrap_or_default();
            v.push(input.into());
            self.product_view_summaries = Some(v);
            self
        }
        /// <p>Information about the product views.</p>
        pub fn set_product_view_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductViewSummary>>,
        ) -> Self {
            self.product_view_summaries = input;
            self
        }
        /// Adds a key-value pair to `product_view_aggregations`.
        ///
        /// To override the contents of this collection use [`set_product_view_aggregations`](Self::set_product_view_aggregations).
        ///
        /// <p>The product view aggregations.</p>
        pub fn product_view_aggregations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ProductViewAggregationValue>>,
        ) -> Self {
            let mut hash_map = self.product_view_aggregations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.product_view_aggregations = Some(hash_map);
            self
        }
        /// <p>The product view aggregations.</p>
        pub fn set_product_view_aggregations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ProductViewAggregationValue>,
                >,
            >,
        ) -> Self {
            self.product_view_aggregations = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProductsOutput`](crate::output::SearchProductsOutput)
        pub fn build(self) -> crate::output::SearchProductsOutput {
            crate::output::SearchProductsOutput {
                product_view_summaries: self.product_view_summaries,
                product_view_aggregations: self.product_view_aggregations,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl SearchProductsOutput {
    /// Creates a new builder-style object to manufacture [`SearchProductsOutput`](crate::output::SearchProductsOutput)
    pub fn builder() -> crate::output::search_products_output::Builder {
        crate::output::search_products_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanProvisionedProductsOutput {
    /// <p>Information about the provisioned products.</p>
    pub provisioned_products:
        std::option::Option<std::vec::Vec<crate::model::ProvisionedProductDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScanProvisionedProductsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanProvisionedProductsOutput");
        formatter.field("provisioned_products", &self.provisioned_products);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ScanProvisionedProductsOutput`](crate::output::ScanProvisionedProductsOutput)
pub mod scan_provisioned_products_output {
    /// A builder for [`ScanProvisionedProductsOutput`](crate::output::ScanProvisionedProductsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_products:
            std::option::Option<std::vec::Vec<crate::model::ProvisionedProductDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioned_products`.
        ///
        /// To override the contents of this collection use [`set_provisioned_products`](Self::set_provisioned_products).
        ///
        /// <p>Information about the provisioned products.</p>
        pub fn provisioned_products(
            mut self,
            input: impl Into<crate::model::ProvisionedProductDetail>,
        ) -> Self {
            let mut v = self.provisioned_products.unwrap_or_default();
            v.push(input.into());
            self.provisioned_products = Some(v);
            self
        }
        /// <p>Information about the provisioned products.</p>
        pub fn set_provisioned_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisionedProductDetail>>,
        ) -> Self {
            self.provisioned_products = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanProvisionedProductsOutput`](crate::output::ScanProvisionedProductsOutput)
        pub fn build(self) -> crate::output::ScanProvisionedProductsOutput {
            crate::output::ScanProvisionedProductsOutput {
                provisioned_products: self.provisioned_products,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ScanProvisionedProductsOutput {
    /// Creates a new builder-style object to manufacture [`ScanProvisionedProductsOutput`](crate::output::ScanProvisionedProductsOutput)
    pub fn builder() -> crate::output::scan_provisioned_products_output::Builder {
        crate::output::scan_provisioned_products_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectPortfolioShareOutput {}
impl std::fmt::Debug for RejectPortfolioShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectPortfolioShareOutput");
        formatter.finish()
    }
}
/// See [`RejectPortfolioShareOutput`](crate::output::RejectPortfolioShareOutput)
pub mod reject_portfolio_share_output {
    /// A builder for [`RejectPortfolioShareOutput`](crate::output::RejectPortfolioShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RejectPortfolioShareOutput`](crate::output::RejectPortfolioShareOutput)
        pub fn build(self) -> crate::output::RejectPortfolioShareOutput {
            crate::output::RejectPortfolioShareOutput {}
        }
    }
}
impl RejectPortfolioShareOutput {
    /// Creates a new builder-style object to manufacture [`RejectPortfolioShareOutput`](crate::output::RejectPortfolioShareOutput)
    pub fn builder() -> crate::output::reject_portfolio_share_output::Builder {
        crate::output::reject_portfolio_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionProductOutput {
    /// <p>Information about the result of provisioning the product.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for ProvisionProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionProductOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`ProvisionProductOutput`](crate::output::ProvisionProductOutput)
pub mod provision_product_output {
    /// A builder for [`ProvisionProductOutput`](crate::output::ProvisionProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>Information about the result of provisioning the product.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about the result of provisioning the product.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionProductOutput`](crate::output::ProvisionProductOutput)
        pub fn build(self) -> crate::output::ProvisionProductOutput {
            crate::output::ProvisionProductOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl ProvisionProductOutput {
    /// Creates a new builder-style object to manufacture [`ProvisionProductOutput`](crate::output::ProvisionProductOutput)
    pub fn builder() -> crate::output::provision_product_output::Builder {
        crate::output::provision_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagOptionsOutput {
    /// <p>Information about the TagOptions.</p>
    pub tag_option_details: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagOptionsOutput");
        formatter.field("tag_option_details", &self.tag_option_details);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}
/// See [`ListTagOptionsOutput`](crate::output::ListTagOptionsOutput)
pub mod list_tag_options_output {
    /// A builder for [`ListTagOptionsOutput`](crate::output::ListTagOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_option_details:
            std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tag_option_details`.
        ///
        /// To override the contents of this collection use [`set_tag_option_details`](Self::set_tag_option_details).
        ///
        /// <p>Information about the TagOptions.</p>
        pub fn tag_option_details(
            mut self,
            input: impl Into<crate::model::TagOptionDetail>,
        ) -> Self {
            let mut v = self.tag_option_details.unwrap_or_default();
            v.push(input.into());
            self.tag_option_details = Some(v);
            self
        }
        /// <p>Information about the TagOptions.</p>
        pub fn set_tag_option_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        ) -> Self {
            self.tag_option_details = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagOptionsOutput`](crate::output::ListTagOptionsOutput)
        pub fn build(self) -> crate::output::ListTagOptionsOutput {
            crate::output::ListTagOptionsOutput {
                tag_option_details: self.tag_option_details,
                page_token: self.page_token,
            }
        }
    }
}
impl ListTagOptionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagOptionsOutput`](crate::output::ListTagOptionsOutput)
    pub fn builder() -> crate::output::list_tag_options_output::Builder {
        crate::output::list_tag_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStackInstancesForProvisionedProductOutput {
    /// <p>List of stack instances.</p>
    pub stack_instances: std::option::Option<std::vec::Vec<crate::model::StackInstance>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListStackInstancesForProvisionedProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStackInstancesForProvisionedProductOutput");
        formatter.field("stack_instances", &self.stack_instances);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListStackInstancesForProvisionedProductOutput`](crate::output::ListStackInstancesForProvisionedProductOutput)
pub mod list_stack_instances_for_provisioned_product_output {
    /// A builder for [`ListStackInstancesForProvisionedProductOutput`](crate::output::ListStackInstancesForProvisionedProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_instances: std::option::Option<std::vec::Vec<crate::model::StackInstance>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `stack_instances`.
        ///
        /// To override the contents of this collection use [`set_stack_instances`](Self::set_stack_instances).
        ///
        /// <p>List of stack instances.</p>
        pub fn stack_instances(mut self, input: impl Into<crate::model::StackInstance>) -> Self {
            let mut v = self.stack_instances.unwrap_or_default();
            v.push(input.into());
            self.stack_instances = Some(v);
            self
        }
        /// <p>List of stack instances.</p>
        pub fn set_stack_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackInstance>>,
        ) -> Self {
            self.stack_instances = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStackInstancesForProvisionedProductOutput`](crate::output::ListStackInstancesForProvisionedProductOutput)
        pub fn build(self) -> crate::output::ListStackInstancesForProvisionedProductOutput {
            crate::output::ListStackInstancesForProvisionedProductOutput {
                stack_instances: self.stack_instances,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListStackInstancesForProvisionedProductOutput {
    /// Creates a new builder-style object to manufacture [`ListStackInstancesForProvisionedProductOutput`](crate::output::ListStackInstancesForProvisionedProductOutput)
    pub fn builder() -> crate::output::list_stack_instances_for_provisioned_product_output::Builder
    {
        crate::output::list_stack_instances_for_provisioned_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceActionsForProvisioningArtifactOutput {
    /// <p>An object containing information about the self-service actions associated with the provisioning artifact.</p>
    pub service_action_summaries:
        std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListServiceActionsForProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceActionsForProvisioningArtifactOutput");
        formatter.field("service_action_summaries", &self.service_action_summaries);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListServiceActionsForProvisioningArtifactOutput`](crate::output::ListServiceActionsForProvisioningArtifactOutput)
pub mod list_service_actions_for_provisioning_artifact_output {
    /// A builder for [`ListServiceActionsForProvisioningArtifactOutput`](crate::output::ListServiceActionsForProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_summaries:
            std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_action_summaries`.
        ///
        /// To override the contents of this collection use [`set_service_action_summaries`](Self::set_service_action_summaries).
        ///
        /// <p>An object containing information about the self-service actions associated with the provisioning artifact.</p>
        pub fn service_action_summaries(
            mut self,
            input: impl Into<crate::model::ServiceActionSummary>,
        ) -> Self {
            let mut v = self.service_action_summaries.unwrap_or_default();
            v.push(input.into());
            self.service_action_summaries = Some(v);
            self
        }
        /// <p>An object containing information about the self-service actions associated with the provisioning artifact.</p>
        pub fn set_service_action_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
        ) -> Self {
            self.service_action_summaries = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceActionsForProvisioningArtifactOutput`](crate::output::ListServiceActionsForProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::ListServiceActionsForProvisioningArtifactOutput {
            crate::output::ListServiceActionsForProvisioningArtifactOutput {
                service_action_summaries: self.service_action_summaries,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListServiceActionsForProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceActionsForProvisioningArtifactOutput`](crate::output::ListServiceActionsForProvisioningArtifactOutput)
    pub fn builder() -> crate::output::list_service_actions_for_provisioning_artifact_output::Builder
    {
        crate::output::list_service_actions_for_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceActionsOutput {
    /// <p>An object containing information about the service actions associated with the provisioning artifact.</p>
    pub service_action_summaries:
        std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListServiceActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceActionsOutput");
        formatter.field("service_action_summaries", &self.service_action_summaries);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListServiceActionsOutput`](crate::output::ListServiceActionsOutput)
pub mod list_service_actions_output {
    /// A builder for [`ListServiceActionsOutput`](crate::output::ListServiceActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_summaries:
            std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_action_summaries`.
        ///
        /// To override the contents of this collection use [`set_service_action_summaries`](Self::set_service_action_summaries).
        ///
        /// <p>An object containing information about the service actions associated with the provisioning artifact.</p>
        pub fn service_action_summaries(
            mut self,
            input: impl Into<crate::model::ServiceActionSummary>,
        ) -> Self {
            let mut v = self.service_action_summaries.unwrap_or_default();
            v.push(input.into());
            self.service_action_summaries = Some(v);
            self
        }
        /// <p>An object containing information about the service actions associated with the provisioning artifact.</p>
        pub fn set_service_action_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceActionSummary>>,
        ) -> Self {
            self.service_action_summaries = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceActionsOutput`](crate::output::ListServiceActionsOutput)
        pub fn build(self) -> crate::output::ListServiceActionsOutput {
            crate::output::ListServiceActionsOutput {
                service_action_summaries: self.service_action_summaries,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListServiceActionsOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceActionsOutput`](crate::output::ListServiceActionsOutput)
    pub fn builder() -> crate::output::list_service_actions_output::Builder {
        crate::output::list_service_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesForTagOptionOutput {
    /// <p>Information about the resources.</p>
    pub resource_details: std::option::Option<std::vec::Vec<crate::model::ResourceDetail>>,
    /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
    pub page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListResourcesForTagOptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesForTagOptionOutput");
        formatter.field("resource_details", &self.resource_details);
        formatter.field("page_token", &self.page_token);
        formatter.finish()
    }
}
/// See [`ListResourcesForTagOptionOutput`](crate::output::ListResourcesForTagOptionOutput)
pub mod list_resources_for_tag_option_output {
    /// A builder for [`ListResourcesForTagOptionOutput`](crate::output::ListResourcesForTagOptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_details:
            std::option::Option<std::vec::Vec<crate::model::ResourceDetail>>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_details`.
        ///
        /// To override the contents of this collection use [`set_resource_details`](Self::set_resource_details).
        ///
        /// <p>Information about the resources.</p>
        pub fn resource_details(mut self, input: impl Into<crate::model::ResourceDetail>) -> Self {
            let mut v = self.resource_details.unwrap_or_default();
            v.push(input.into());
            self.resource_details = Some(v);
            self
        }
        /// <p>Information about the resources.</p>
        pub fn set_resource_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceDetail>>,
        ) -> Self {
            self.resource_details = input;
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The page token for the next set of results. To retrieve the first set of results, use null.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesForTagOptionOutput`](crate::output::ListResourcesForTagOptionOutput)
        pub fn build(self) -> crate::output::ListResourcesForTagOptionOutput {
            crate::output::ListResourcesForTagOptionOutput {
                resource_details: self.resource_details,
                page_token: self.page_token,
            }
        }
    }
}
impl ListResourcesForTagOptionOutput {
    /// Creates a new builder-style object to manufacture [`ListResourcesForTagOptionOutput`](crate::output::ListResourcesForTagOptionOutput)
    pub fn builder() -> crate::output::list_resources_for_tag_option_output::Builder {
        crate::output::list_resources_for_tag_option_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordHistoryOutput {
    /// <p>The records, in reverse chronological order.</p>
    pub record_details: std::option::Option<std::vec::Vec<crate::model::RecordDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRecordHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordHistoryOutput");
        formatter.field("record_details", &self.record_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListRecordHistoryOutput`](crate::output::ListRecordHistoryOutput)
pub mod list_record_history_output {
    /// A builder for [`ListRecordHistoryOutput`](crate::output::ListRecordHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_details: std::option::Option<std::vec::Vec<crate::model::RecordDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `record_details`.
        ///
        /// To override the contents of this collection use [`set_record_details`](Self::set_record_details).
        ///
        /// <p>The records, in reverse chronological order.</p>
        pub fn record_details(mut self, input: impl Into<crate::model::RecordDetail>) -> Self {
            let mut v = self.record_details.unwrap_or_default();
            v.push(input.into());
            self.record_details = Some(v);
            self
        }
        /// <p>The records, in reverse chronological order.</p>
        pub fn set_record_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordDetail>>,
        ) -> Self {
            self.record_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordHistoryOutput`](crate::output::ListRecordHistoryOutput)
        pub fn build(self) -> crate::output::ListRecordHistoryOutput {
            crate::output::ListRecordHistoryOutput {
                record_details: self.record_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListRecordHistoryOutput {
    /// Creates a new builder-style object to manufacture [`ListRecordHistoryOutput`](crate::output::ListRecordHistoryOutput)
    pub fn builder() -> crate::output::list_record_history_output::Builder {
        crate::output::list_record_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningArtifactsForServiceActionOutput {
    /// <p>An array of objects with information about product views and provisioning artifacts.</p>
    pub provisioning_artifact_views:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactView>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProvisioningArtifactsForServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningArtifactsForServiceActionOutput");
        formatter.field(
            "provisioning_artifact_views",
            &self.provisioning_artifact_views,
        );
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListProvisioningArtifactsForServiceActionOutput`](crate::output::ListProvisioningArtifactsForServiceActionOutput)
pub mod list_provisioning_artifacts_for_service_action_output {
    /// A builder for [`ListProvisioningArtifactsForServiceActionOutput`](crate::output::ListProvisioningArtifactsForServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_views:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactView>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioning_artifact_views`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_views`](Self::set_provisioning_artifact_views).
        ///
        /// <p>An array of objects with information about product views and provisioning artifacts.</p>
        pub fn provisioning_artifact_views(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifactView>,
        ) -> Self {
            let mut v = self.provisioning_artifact_views.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifact_views = Some(v);
            self
        }
        /// <p>An array of objects with information about product views and provisioning artifacts.</p>
        pub fn set_provisioning_artifact_views(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactView>>,
        ) -> Self {
            self.provisioning_artifact_views = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningArtifactsForServiceActionOutput`](crate::output::ListProvisioningArtifactsForServiceActionOutput)
        pub fn build(self) -> crate::output::ListProvisioningArtifactsForServiceActionOutput {
            crate::output::ListProvisioningArtifactsForServiceActionOutput {
                provisioning_artifact_views: self.provisioning_artifact_views,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListProvisioningArtifactsForServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsForServiceActionOutput`](crate::output::ListProvisioningArtifactsForServiceActionOutput)
    pub fn builder() -> crate::output::list_provisioning_artifacts_for_service_action_output::Builder
    {
        crate::output::list_provisioning_artifacts_for_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningArtifactsOutput {
    /// <p>Information about the provisioning artifacts.</p>
    pub provisioning_artifact_details:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProvisioningArtifactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningArtifactsOutput");
        formatter.field(
            "provisioning_artifact_details",
            &self.provisioning_artifact_details,
        );
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListProvisioningArtifactsOutput`](crate::output::ListProvisioningArtifactsOutput)
pub mod list_provisioning_artifacts_output {
    /// A builder for [`ListProvisioningArtifactsOutput`](crate::output::ListProvisioningArtifactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_details:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioning_artifact_details`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_details`](Self::set_provisioning_artifact_details).
        ///
        /// <p>Information about the provisioning artifacts.</p>
        pub fn provisioning_artifact_details(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifactDetail>,
        ) -> Self {
            let mut v = self.provisioning_artifact_details.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifact_details = Some(v);
            self
        }
        /// <p>Information about the provisioning artifacts.</p>
        pub fn set_provisioning_artifact_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactDetail>>,
        ) -> Self {
            self.provisioning_artifact_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningArtifactsOutput`](crate::output::ListProvisioningArtifactsOutput)
        pub fn build(self) -> crate::output::ListProvisioningArtifactsOutput {
            crate::output::ListProvisioningArtifactsOutput {
                provisioning_artifact_details: self.provisioning_artifact_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListProvisioningArtifactsOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisioningArtifactsOutput`](crate::output::ListProvisioningArtifactsOutput)
    pub fn builder() -> crate::output::list_provisioning_artifacts_output::Builder {
        crate::output::list_provisioning_artifacts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedProductPlansOutput {
    /// <p>Information about the plans.</p>
    pub provisioned_product_plans:
        std::option::Option<std::vec::Vec<crate::model::ProvisionedProductPlanSummary>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProvisionedProductPlansOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedProductPlansOutput");
        formatter.field("provisioned_product_plans", &self.provisioned_product_plans);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListProvisionedProductPlansOutput`](crate::output::ListProvisionedProductPlansOutput)
pub mod list_provisioned_product_plans_output {
    /// A builder for [`ListProvisionedProductPlansOutput`](crate::output::ListProvisionedProductPlansOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_plans:
            std::option::Option<std::vec::Vec<crate::model::ProvisionedProductPlanSummary>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioned_product_plans`.
        ///
        /// To override the contents of this collection use [`set_provisioned_product_plans`](Self::set_provisioned_product_plans).
        ///
        /// <p>Information about the plans.</p>
        pub fn provisioned_product_plans(
            mut self,
            input: impl Into<crate::model::ProvisionedProductPlanSummary>,
        ) -> Self {
            let mut v = self.provisioned_product_plans.unwrap_or_default();
            v.push(input.into());
            self.provisioned_product_plans = Some(v);
            self
        }
        /// <p>Information about the plans.</p>
        pub fn set_provisioned_product_plans(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisionedProductPlanSummary>>,
        ) -> Self {
            self.provisioned_product_plans = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedProductPlansOutput`](crate::output::ListProvisionedProductPlansOutput)
        pub fn build(self) -> crate::output::ListProvisionedProductPlansOutput {
            crate::output::ListProvisionedProductPlansOutput {
                provisioned_product_plans: self.provisioned_product_plans,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListProvisionedProductPlansOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisionedProductPlansOutput`](crate::output::ListProvisionedProductPlansOutput)
    pub fn builder() -> crate::output::list_provisioned_product_plans_output::Builder {
        crate::output::list_provisioned_product_plans_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalsForPortfolioOutput {
    /// <p>The IAM principals (users or roles) associated with the portfolio.</p>
    pub principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPrincipalsForPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalsForPortfolioOutput");
        formatter.field("principals", &self.principals);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPrincipalsForPortfolioOutput`](crate::output::ListPrincipalsForPortfolioOutput)
pub mod list_principals_for_portfolio_output {
    /// A builder for [`ListPrincipalsForPortfolioOutput`](crate::output::ListPrincipalsForPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The IAM principals (users or roles) associated with the portfolio.</p>
        pub fn principals(mut self, input: impl Into<crate::model::Principal>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The IAM principals (users or roles) associated with the portfolio.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalsForPortfolioOutput`](crate::output::ListPrincipalsForPortfolioOutput)
        pub fn build(self) -> crate::output::ListPrincipalsForPortfolioOutput {
            crate::output::ListPrincipalsForPortfolioOutput {
                principals: self.principals,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPrincipalsForPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`ListPrincipalsForPortfolioOutput`](crate::output::ListPrincipalsForPortfolioOutput)
    pub fn builder() -> crate::output::list_principals_for_portfolio_output::Builder {
        crate::output::list_principals_for_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfoliosForProductOutput {
    /// <p>Information about the portfolios.</p>
    pub portfolio_details: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPortfoliosForProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfoliosForProductOutput");
        formatter.field("portfolio_details", &self.portfolio_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPortfoliosForProductOutput`](crate::output::ListPortfoliosForProductOutput)
pub mod list_portfolios_for_product_output {
    /// A builder for [`ListPortfoliosForProductOutput`](crate::output::ListPortfoliosForProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_details:
            std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `portfolio_details`.
        ///
        /// To override the contents of this collection use [`set_portfolio_details`](Self::set_portfolio_details).
        ///
        /// <p>Information about the portfolios.</p>
        pub fn portfolio_details(
            mut self,
            input: impl Into<crate::model::PortfolioDetail>,
        ) -> Self {
            let mut v = self.portfolio_details.unwrap_or_default();
            v.push(input.into());
            self.portfolio_details = Some(v);
            self
        }
        /// <p>Information about the portfolios.</p>
        pub fn set_portfolio_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        ) -> Self {
            self.portfolio_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfoliosForProductOutput`](crate::output::ListPortfoliosForProductOutput)
        pub fn build(self) -> crate::output::ListPortfoliosForProductOutput {
            crate::output::ListPortfoliosForProductOutput {
                portfolio_details: self.portfolio_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPortfoliosForProductOutput {
    /// Creates a new builder-style object to manufacture [`ListPortfoliosForProductOutput`](crate::output::ListPortfoliosForProductOutput)
    pub fn builder() -> crate::output::list_portfolios_for_product_output::Builder {
        crate::output::list_portfolios_for_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfoliosOutput {
    /// <p>Information about the portfolios.</p>
    pub portfolio_details: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPortfoliosOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfoliosOutput");
        formatter.field("portfolio_details", &self.portfolio_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPortfoliosOutput`](crate::output::ListPortfoliosOutput)
pub mod list_portfolios_output {
    /// A builder for [`ListPortfoliosOutput`](crate::output::ListPortfoliosOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_details:
            std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `portfolio_details`.
        ///
        /// To override the contents of this collection use [`set_portfolio_details`](Self::set_portfolio_details).
        ///
        /// <p>Information about the portfolios.</p>
        pub fn portfolio_details(
            mut self,
            input: impl Into<crate::model::PortfolioDetail>,
        ) -> Self {
            let mut v = self.portfolio_details.unwrap_or_default();
            v.push(input.into());
            self.portfolio_details = Some(v);
            self
        }
        /// <p>Information about the portfolios.</p>
        pub fn set_portfolio_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        ) -> Self {
            self.portfolio_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfoliosOutput`](crate::output::ListPortfoliosOutput)
        pub fn build(self) -> crate::output::ListPortfoliosOutput {
            crate::output::ListPortfoliosOutput {
                portfolio_details: self.portfolio_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPortfoliosOutput {
    /// Creates a new builder-style object to manufacture [`ListPortfoliosOutput`](crate::output::ListPortfoliosOutput)
    pub fn builder() -> crate::output::list_portfolios_output::Builder {
        crate::output::list_portfolios_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortfolioAccessOutput {
    /// <p>Information about the AWS accounts with access to the portfolio.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPortfolioAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortfolioAccessOutput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListPortfolioAccessOutput`](crate::output::ListPortfolioAccessOutput)
pub mod list_portfolio_access_output {
    /// A builder for [`ListPortfolioAccessOutput`](crate::output::ListPortfolioAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>Information about the AWS accounts with access to the portfolio.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>Information about the AWS accounts with access to the portfolio.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortfolioAccessOutput`](crate::output::ListPortfolioAccessOutput)
        pub fn build(self) -> crate::output::ListPortfolioAccessOutput {
            crate::output::ListPortfolioAccessOutput {
                account_ids: self.account_ids,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListPortfolioAccessOutput {
    /// Creates a new builder-style object to manufacture [`ListPortfolioAccessOutput`](crate::output::ListPortfolioAccessOutput)
    pub fn builder() -> crate::output::list_portfolio_access_output::Builder {
        crate::output::list_portfolio_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationPortfolioAccessOutput {
    /// <p>Displays information about the organization nodes.</p>
    pub organization_nodes: std::option::Option<std::vec::Vec<crate::model::OrganizationNode>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListOrganizationPortfolioAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationPortfolioAccessOutput");
        formatter.field("organization_nodes", &self.organization_nodes);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListOrganizationPortfolioAccessOutput`](crate::output::ListOrganizationPortfolioAccessOutput)
pub mod list_organization_portfolio_access_output {
    /// A builder for [`ListOrganizationPortfolioAccessOutput`](crate::output::ListOrganizationPortfolioAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_nodes:
            std::option::Option<std::vec::Vec<crate::model::OrganizationNode>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_nodes`.
        ///
        /// To override the contents of this collection use [`set_organization_nodes`](Self::set_organization_nodes).
        ///
        /// <p>Displays information about the organization nodes.</p>
        pub fn organization_nodes(
            mut self,
            input: impl Into<crate::model::OrganizationNode>,
        ) -> Self {
            let mut v = self.organization_nodes.unwrap_or_default();
            v.push(input.into());
            self.organization_nodes = Some(v);
            self
        }
        /// <p>Displays information about the organization nodes.</p>
        pub fn set_organization_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrganizationNode>>,
        ) -> Self {
            self.organization_nodes = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationPortfolioAccessOutput`](crate::output::ListOrganizationPortfolioAccessOutput)
        pub fn build(self) -> crate::output::ListOrganizationPortfolioAccessOutput {
            crate::output::ListOrganizationPortfolioAccessOutput {
                organization_nodes: self.organization_nodes,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListOrganizationPortfolioAccessOutput {
    /// Creates a new builder-style object to manufacture [`ListOrganizationPortfolioAccessOutput`](crate::output::ListOrganizationPortfolioAccessOutput)
    pub fn builder() -> crate::output::list_organization_portfolio_access_output::Builder {
        crate::output::list_organization_portfolio_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLaunchPathsOutput {
    /// <p>Information about the launch path.</p>
    pub launch_path_summaries: std::option::Option<std::vec::Vec<crate::model::LaunchPathSummary>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLaunchPathsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLaunchPathsOutput");
        formatter.field("launch_path_summaries", &self.launch_path_summaries);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListLaunchPathsOutput`](crate::output::ListLaunchPathsOutput)
pub mod list_launch_paths_output {
    /// A builder for [`ListLaunchPathsOutput`](crate::output::ListLaunchPathsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_path_summaries:
            std::option::Option<std::vec::Vec<crate::model::LaunchPathSummary>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `launch_path_summaries`.
        ///
        /// To override the contents of this collection use [`set_launch_path_summaries`](Self::set_launch_path_summaries).
        ///
        /// <p>Information about the launch path.</p>
        pub fn launch_path_summaries(
            mut self,
            input: impl Into<crate::model::LaunchPathSummary>,
        ) -> Self {
            let mut v = self.launch_path_summaries.unwrap_or_default();
            v.push(input.into());
            self.launch_path_summaries = Some(v);
            self
        }
        /// <p>Information about the launch path.</p>
        pub fn set_launch_path_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchPathSummary>>,
        ) -> Self {
            self.launch_path_summaries = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLaunchPathsOutput`](crate::output::ListLaunchPathsOutput)
        pub fn build(self) -> crate::output::ListLaunchPathsOutput {
            crate::output::ListLaunchPathsOutput {
                launch_path_summaries: self.launch_path_summaries,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListLaunchPathsOutput {
    /// Creates a new builder-style object to manufacture [`ListLaunchPathsOutput`](crate::output::ListLaunchPathsOutput)
    pub fn builder() -> crate::output::list_launch_paths_output::Builder {
        crate::output::list_launch_paths_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConstraintsForPortfolioOutput {
    /// <p>Information about the constraints.</p>
    pub constraint_details: std::option::Option<std::vec::Vec<crate::model::ConstraintDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConstraintsForPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConstraintsForPortfolioOutput");
        formatter.field("constraint_details", &self.constraint_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListConstraintsForPortfolioOutput`](crate::output::ListConstraintsForPortfolioOutput)
pub mod list_constraints_for_portfolio_output {
    /// A builder for [`ListConstraintsForPortfolioOutput`](crate::output::ListConstraintsForPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraint_details:
            std::option::Option<std::vec::Vec<crate::model::ConstraintDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `constraint_details`.
        ///
        /// To override the contents of this collection use [`set_constraint_details`](Self::set_constraint_details).
        ///
        /// <p>Information about the constraints.</p>
        pub fn constraint_details(
            mut self,
            input: impl Into<crate::model::ConstraintDetail>,
        ) -> Self {
            let mut v = self.constraint_details.unwrap_or_default();
            v.push(input.into());
            self.constraint_details = Some(v);
            self
        }
        /// <p>Information about the constraints.</p>
        pub fn set_constraint_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConstraintDetail>>,
        ) -> Self {
            self.constraint_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConstraintsForPortfolioOutput`](crate::output::ListConstraintsForPortfolioOutput)
        pub fn build(self) -> crate::output::ListConstraintsForPortfolioOutput {
            crate::output::ListConstraintsForPortfolioOutput {
                constraint_details: self.constraint_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListConstraintsForPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`ListConstraintsForPortfolioOutput`](crate::output::ListConstraintsForPortfolioOutput)
    pub fn builder() -> crate::output::list_constraints_for_portfolio_output::Builder {
        crate::output::list_constraints_for_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBudgetsForResourceOutput {
    /// <p>Information about the associated budgets.</p>
    pub budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBudgetsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBudgetsForResourceOutput");
        formatter.field("budgets", &self.budgets);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListBudgetsForResourceOutput`](crate::output::ListBudgetsForResourceOutput)
pub mod list_budgets_for_resource_output {
    /// A builder for [`ListBudgetsForResourceOutput`](crate::output::ListBudgetsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `budgets`.
        ///
        /// To override the contents of this collection use [`set_budgets`](Self::set_budgets).
        ///
        /// <p>Information about the associated budgets.</p>
        pub fn budgets(mut self, input: impl Into<crate::model::BudgetDetail>) -> Self {
            let mut v = self.budgets.unwrap_or_default();
            v.push(input.into());
            self.budgets = Some(v);
            self
        }
        /// <p>Information about the associated budgets.</p>
        pub fn set_budgets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        ) -> Self {
            self.budgets = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBudgetsForResourceOutput`](crate::output::ListBudgetsForResourceOutput)
        pub fn build(self) -> crate::output::ListBudgetsForResourceOutput {
            crate::output::ListBudgetsForResourceOutput {
                budgets: self.budgets,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListBudgetsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListBudgetsForResourceOutput`](crate::output::ListBudgetsForResourceOutput)
    pub fn builder() -> crate::output::list_budgets_for_resource_output::Builder {
        crate::output::list_budgets_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAcceptedPortfolioSharesOutput {
    /// <p>Information about the portfolios.</p>
    pub portfolio_details: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAcceptedPortfolioSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAcceptedPortfolioSharesOutput");
        formatter.field("portfolio_details", &self.portfolio_details);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`ListAcceptedPortfolioSharesOutput`](crate::output::ListAcceptedPortfolioSharesOutput)
pub mod list_accepted_portfolio_shares_output {
    /// A builder for [`ListAcceptedPortfolioSharesOutput`](crate::output::ListAcceptedPortfolioSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_details:
            std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `portfolio_details`.
        ///
        /// To override the contents of this collection use [`set_portfolio_details`](Self::set_portfolio_details).
        ///
        /// <p>Information about the portfolios.</p>
        pub fn portfolio_details(
            mut self,
            input: impl Into<crate::model::PortfolioDetail>,
        ) -> Self {
            let mut v = self.portfolio_details.unwrap_or_default();
            v.push(input.into());
            self.portfolio_details = Some(v);
            self
        }
        /// <p>Information about the portfolios.</p>
        pub fn set_portfolio_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortfolioDetail>>,
        ) -> Self {
            self.portfolio_details = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAcceptedPortfolioSharesOutput`](crate::output::ListAcceptedPortfolioSharesOutput)
        pub fn build(self) -> crate::output::ListAcceptedPortfolioSharesOutput {
            crate::output::ListAcceptedPortfolioSharesOutput {
                portfolio_details: self.portfolio_details,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl ListAcceptedPortfolioSharesOutput {
    /// Creates a new builder-style object to manufacture [`ListAcceptedPortfolioSharesOutput`](crate::output::ListAcceptedPortfolioSharesOutput)
    pub fn builder() -> crate::output::list_accepted_portfolio_shares_output::Builder {
        crate::output::list_accepted_portfolio_shares_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAsProvisionedProductOutput {
    /// <p>Information about a request operation.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for ImportAsProvisionedProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAsProvisionedProductOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`ImportAsProvisionedProductOutput`](crate::output::ImportAsProvisionedProductOutput)
pub mod import_as_provisioned_product_output {
    /// A builder for [`ImportAsProvisionedProductOutput`](crate::output::ImportAsProvisionedProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>Information about a request operation.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about a request operation.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAsProvisionedProductOutput`](crate::output::ImportAsProvisionedProductOutput)
        pub fn build(self) -> crate::output::ImportAsProvisionedProductOutput {
            crate::output::ImportAsProvisionedProductOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl ImportAsProvisionedProductOutput {
    /// Creates a new builder-style object to manufacture [`ImportAsProvisionedProductOutput`](crate::output::ImportAsProvisionedProductOutput)
    pub fn builder() -> crate::output::import_as_provisioned_product_output::Builder {
        crate::output::import_as_provisioned_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProvisionedProductOutputsOutput {
    /// <p>Information about the product created as the result of a request. For example, the output for a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
    /// </p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetProvisionedProductOutputsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProvisionedProductOutputsOutput");
        formatter.field("outputs", &self.outputs);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetProvisionedProductOutputsOutput`](crate::output::GetProvisionedProductOutputsOutput)
pub mod get_provisioned_product_outputs_output {
    /// A builder for [`GetProvisionedProductOutputsOutput`](crate::output::GetProvisionedProductOutputsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>Information about the product created as the result of a request. For example, the output for a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
        /// </p>
        pub fn outputs(mut self, input: impl Into<crate::model::RecordOutput>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>Information about the product created as the result of a request. For example, the output for a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
        /// </p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProvisionedProductOutputsOutput`](crate::output::GetProvisionedProductOutputsOutput)
        pub fn build(self) -> crate::output::GetProvisionedProductOutputsOutput {
            crate::output::GetProvisionedProductOutputsOutput {
                outputs: self.outputs,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetProvisionedProductOutputsOutput {
    /// Creates a new builder-style object to manufacture [`GetProvisionedProductOutputsOutput`](crate::output::GetProvisionedProductOutputsOutput)
    pub fn builder() -> crate::output::get_provisioned_product_outputs_output::Builder {
        crate::output::get_provisioned_product_outputs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAwsOrganizationsAccessStatusOutput {
    /// <p>The status of the portfolio share feature.</p>
    pub access_status: std::option::Option<crate::model::AccessStatus>,
}
impl std::fmt::Debug for GetAwsOrganizationsAccessStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAwsOrganizationsAccessStatusOutput");
        formatter.field("access_status", &self.access_status);
        formatter.finish()
    }
}
/// See [`GetAwsOrganizationsAccessStatusOutput`](crate::output::GetAwsOrganizationsAccessStatusOutput)
pub mod get_aws_organizations_access_status_output {
    /// A builder for [`GetAwsOrganizationsAccessStatusOutput`](crate::output::GetAwsOrganizationsAccessStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_status: std::option::Option<crate::model::AccessStatus>,
    }
    impl Builder {
        /// <p>The status of the portfolio share feature.</p>
        pub fn access_status(mut self, input: crate::model::AccessStatus) -> Self {
            self.access_status = Some(input);
            self
        }
        /// <p>The status of the portfolio share feature.</p>
        pub fn set_access_status(
            mut self,
            input: std::option::Option<crate::model::AccessStatus>,
        ) -> Self {
            self.access_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAwsOrganizationsAccessStatusOutput`](crate::output::GetAwsOrganizationsAccessStatusOutput)
        pub fn build(self) -> crate::output::GetAwsOrganizationsAccessStatusOutput {
            crate::output::GetAwsOrganizationsAccessStatusOutput {
                access_status: self.access_status,
            }
        }
    }
}
impl GetAwsOrganizationsAccessStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetAwsOrganizationsAccessStatusOutput`](crate::output::GetAwsOrganizationsAccessStatusOutput)
    pub fn builder() -> crate::output::get_aws_organizations_access_status_output::Builder {
        crate::output::get_aws_organizations_access_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteProvisionedProductServiceActionOutput {
    /// <p>An object containing detailed information about the result of provisioning the product.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for ExecuteProvisionedProductServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteProvisionedProductServiceActionOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`ExecuteProvisionedProductServiceActionOutput`](crate::output::ExecuteProvisionedProductServiceActionOutput)
pub mod execute_provisioned_product_service_action_output {
    /// A builder for [`ExecuteProvisionedProductServiceActionOutput`](crate::output::ExecuteProvisionedProductServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>An object containing detailed information about the result of provisioning the product.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>An object containing detailed information about the result of provisioning the product.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteProvisionedProductServiceActionOutput`](crate::output::ExecuteProvisionedProductServiceActionOutput)
        pub fn build(self) -> crate::output::ExecuteProvisionedProductServiceActionOutput {
            crate::output::ExecuteProvisionedProductServiceActionOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl ExecuteProvisionedProductServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductServiceActionOutput`](crate::output::ExecuteProvisionedProductServiceActionOutput)
    pub fn builder() -> crate::output::execute_provisioned_product_service_action_output::Builder {
        crate::output::execute_provisioned_product_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteProvisionedProductPlanOutput {
    /// <p>Information about the result of provisioning the product.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
}
impl std::fmt::Debug for ExecuteProvisionedProductPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteProvisionedProductPlanOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.finish()
    }
}
/// See [`ExecuteProvisionedProductPlanOutput`](crate::output::ExecuteProvisionedProductPlanOutput)
pub mod execute_provisioned_product_plan_output {
    /// A builder for [`ExecuteProvisionedProductPlanOutput`](crate::output::ExecuteProvisionedProductPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
    }
    impl Builder {
        /// <p>Information about the result of provisioning the product.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about the result of provisioning the product.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteProvisionedProductPlanOutput`](crate::output::ExecuteProvisionedProductPlanOutput)
        pub fn build(self) -> crate::output::ExecuteProvisionedProductPlanOutput {
            crate::output::ExecuteProvisionedProductPlanOutput {
                record_detail: self.record_detail,
            }
        }
    }
}
impl ExecuteProvisionedProductPlanOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteProvisionedProductPlanOutput`](crate::output::ExecuteProvisionedProductPlanOutput)
    pub fn builder() -> crate::output::execute_provisioned_product_plan_output::Builder {
        crate::output::execute_provisioned_product_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAwsOrganizationsAccessOutput {}
impl std::fmt::Debug for EnableAwsOrganizationsAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAwsOrganizationsAccessOutput");
        formatter.finish()
    }
}
/// See [`EnableAwsOrganizationsAccessOutput`](crate::output::EnableAwsOrganizationsAccessOutput)
pub mod enable_aws_organizations_access_output {
    /// A builder for [`EnableAwsOrganizationsAccessOutput`](crate::output::EnableAwsOrganizationsAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableAwsOrganizationsAccessOutput`](crate::output::EnableAwsOrganizationsAccessOutput)
        pub fn build(self) -> crate::output::EnableAwsOrganizationsAccessOutput {
            crate::output::EnableAwsOrganizationsAccessOutput {}
        }
    }
}
impl EnableAwsOrganizationsAccessOutput {
    /// Creates a new builder-style object to manufacture [`EnableAwsOrganizationsAccessOutput`](crate::output::EnableAwsOrganizationsAccessOutput)
    pub fn builder() -> crate::output::enable_aws_organizations_access_output::Builder {
        crate::output::enable_aws_organizations_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTagOptionFromResourceOutput {}
impl std::fmt::Debug for DisassociateTagOptionFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTagOptionFromResourceOutput");
        formatter.finish()
    }
}
/// See [`DisassociateTagOptionFromResourceOutput`](crate::output::DisassociateTagOptionFromResourceOutput)
pub mod disassociate_tag_option_from_resource_output {
    /// A builder for [`DisassociateTagOptionFromResourceOutput`](crate::output::DisassociateTagOptionFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateTagOptionFromResourceOutput`](crate::output::DisassociateTagOptionFromResourceOutput)
        pub fn build(self) -> crate::output::DisassociateTagOptionFromResourceOutput {
            crate::output::DisassociateTagOptionFromResourceOutput {}
        }
    }
}
impl DisassociateTagOptionFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTagOptionFromResourceOutput`](crate::output::DisassociateTagOptionFromResourceOutput)
    pub fn builder() -> crate::output::disassociate_tag_option_from_resource_output::Builder {
        crate::output::disassociate_tag_option_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateServiceActionFromProvisioningArtifactOutput {}
impl std::fmt::Debug for DisassociateServiceActionFromProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DisassociateServiceActionFromProvisioningArtifactOutput");
        formatter.finish()
    }
}
/// See [`DisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::DisassociateServiceActionFromProvisioningArtifactOutput)
pub mod disassociate_service_action_from_provisioning_artifact_output {
    /// A builder for [`DisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::DisassociateServiceActionFromProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::DisassociateServiceActionFromProvisioningArtifactOutput)
        pub fn build(
            self,
        ) -> crate::output::DisassociateServiceActionFromProvisioningArtifactOutput {
            crate::output::DisassociateServiceActionFromProvisioningArtifactOutput {}
        }
    }
}
impl DisassociateServiceActionFromProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::DisassociateServiceActionFromProvisioningArtifactOutput)
    pub fn builder(
    ) -> crate::output::disassociate_service_action_from_provisioning_artifact_output::Builder {
        crate::output::disassociate_service_action_from_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateProductFromPortfolioOutput {}
impl std::fmt::Debug for DisassociateProductFromPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateProductFromPortfolioOutput");
        formatter.finish()
    }
}
/// See [`DisassociateProductFromPortfolioOutput`](crate::output::DisassociateProductFromPortfolioOutput)
pub mod disassociate_product_from_portfolio_output {
    /// A builder for [`DisassociateProductFromPortfolioOutput`](crate::output::DisassociateProductFromPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateProductFromPortfolioOutput`](crate::output::DisassociateProductFromPortfolioOutput)
        pub fn build(self) -> crate::output::DisassociateProductFromPortfolioOutput {
            crate::output::DisassociateProductFromPortfolioOutput {}
        }
    }
}
impl DisassociateProductFromPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateProductFromPortfolioOutput`](crate::output::DisassociateProductFromPortfolioOutput)
    pub fn builder() -> crate::output::disassociate_product_from_portfolio_output::Builder {
        crate::output::disassociate_product_from_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociatePrincipalFromPortfolioOutput {}
impl std::fmt::Debug for DisassociatePrincipalFromPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociatePrincipalFromPortfolioOutput");
        formatter.finish()
    }
}
/// See [`DisassociatePrincipalFromPortfolioOutput`](crate::output::DisassociatePrincipalFromPortfolioOutput)
pub mod disassociate_principal_from_portfolio_output {
    /// A builder for [`DisassociatePrincipalFromPortfolioOutput`](crate::output::DisassociatePrincipalFromPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociatePrincipalFromPortfolioOutput`](crate::output::DisassociatePrincipalFromPortfolioOutput)
        pub fn build(self) -> crate::output::DisassociatePrincipalFromPortfolioOutput {
            crate::output::DisassociatePrincipalFromPortfolioOutput {}
        }
    }
}
impl DisassociatePrincipalFromPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`DisassociatePrincipalFromPortfolioOutput`](crate::output::DisassociatePrincipalFromPortfolioOutput)
    pub fn builder() -> crate::output::disassociate_principal_from_portfolio_output::Builder {
        crate::output::disassociate_principal_from_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateBudgetFromResourceOutput {}
impl std::fmt::Debug for DisassociateBudgetFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateBudgetFromResourceOutput");
        formatter.finish()
    }
}
/// See [`DisassociateBudgetFromResourceOutput`](crate::output::DisassociateBudgetFromResourceOutput)
pub mod disassociate_budget_from_resource_output {
    /// A builder for [`DisassociateBudgetFromResourceOutput`](crate::output::DisassociateBudgetFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateBudgetFromResourceOutput`](crate::output::DisassociateBudgetFromResourceOutput)
        pub fn build(self) -> crate::output::DisassociateBudgetFromResourceOutput {
            crate::output::DisassociateBudgetFromResourceOutput {}
        }
    }
}
impl DisassociateBudgetFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateBudgetFromResourceOutput`](crate::output::DisassociateBudgetFromResourceOutput)
    pub fn builder() -> crate::output::disassociate_budget_from_resource_output::Builder {
        crate::output::disassociate_budget_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAwsOrganizationsAccessOutput {}
impl std::fmt::Debug for DisableAwsOrganizationsAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAwsOrganizationsAccessOutput");
        formatter.finish()
    }
}
/// See [`DisableAwsOrganizationsAccessOutput`](crate::output::DisableAwsOrganizationsAccessOutput)
pub mod disable_aws_organizations_access_output {
    /// A builder for [`DisableAwsOrganizationsAccessOutput`](crate::output::DisableAwsOrganizationsAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableAwsOrganizationsAccessOutput`](crate::output::DisableAwsOrganizationsAccessOutput)
        pub fn build(self) -> crate::output::DisableAwsOrganizationsAccessOutput {
            crate::output::DisableAwsOrganizationsAccessOutput {}
        }
    }
}
impl DisableAwsOrganizationsAccessOutput {
    /// Creates a new builder-style object to manufacture [`DisableAwsOrganizationsAccessOutput`](crate::output::DisableAwsOrganizationsAccessOutput)
    pub fn builder() -> crate::output::disable_aws_organizations_access_output::Builder {
        crate::output::disable_aws_organizations_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagOptionOutput {
    /// <p>Information about the TagOption.</p>
    pub tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
}
impl std::fmt::Debug for DescribeTagOptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagOptionOutput");
        formatter.field("tag_option_detail", &self.tag_option_detail);
        formatter.finish()
    }
}
/// See [`DescribeTagOptionOutput`](crate::output::DescribeTagOptionOutput)
pub mod describe_tag_option_output {
    /// A builder for [`DescribeTagOptionOutput`](crate::output::DescribeTagOptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
    }
    impl Builder {
        /// <p>Information about the TagOption.</p>
        pub fn tag_option_detail(mut self, input: crate::model::TagOptionDetail) -> Self {
            self.tag_option_detail = Some(input);
            self
        }
        /// <p>Information about the TagOption.</p>
        pub fn set_tag_option_detail(
            mut self,
            input: std::option::Option<crate::model::TagOptionDetail>,
        ) -> Self {
            self.tag_option_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagOptionOutput`](crate::output::DescribeTagOptionOutput)
        pub fn build(self) -> crate::output::DescribeTagOptionOutput {
            crate::output::DescribeTagOptionOutput {
                tag_option_detail: self.tag_option_detail,
            }
        }
    }
}
impl DescribeTagOptionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagOptionOutput`](crate::output::DescribeTagOptionOutput)
    pub fn builder() -> crate::output::describe_tag_option_output::Builder {
        crate::output::describe_tag_option_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceActionExecutionParametersOutput {
    /// <p>The parameters of the self-service action.</p>
    pub service_action_parameters:
        std::option::Option<std::vec::Vec<crate::model::ExecutionParameter>>,
}
impl std::fmt::Debug for DescribeServiceActionExecutionParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceActionExecutionParametersOutput");
        formatter.field("service_action_parameters", &self.service_action_parameters);
        formatter.finish()
    }
}
/// See [`DescribeServiceActionExecutionParametersOutput`](crate::output::DescribeServiceActionExecutionParametersOutput)
pub mod describe_service_action_execution_parameters_output {
    /// A builder for [`DescribeServiceActionExecutionParametersOutput`](crate::output::DescribeServiceActionExecutionParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_parameters:
            std::option::Option<std::vec::Vec<crate::model::ExecutionParameter>>,
    }
    impl Builder {
        /// Appends an item to `service_action_parameters`.
        ///
        /// To override the contents of this collection use [`set_service_action_parameters`](Self::set_service_action_parameters).
        ///
        /// <p>The parameters of the self-service action.</p>
        pub fn service_action_parameters(
            mut self,
            input: impl Into<crate::model::ExecutionParameter>,
        ) -> Self {
            let mut v = self.service_action_parameters.unwrap_or_default();
            v.push(input.into());
            self.service_action_parameters = Some(v);
            self
        }
        /// <p>The parameters of the self-service action.</p>
        pub fn set_service_action_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionParameter>>,
        ) -> Self {
            self.service_action_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceActionExecutionParametersOutput`](crate::output::DescribeServiceActionExecutionParametersOutput)
        pub fn build(self) -> crate::output::DescribeServiceActionExecutionParametersOutput {
            crate::output::DescribeServiceActionExecutionParametersOutput {
                service_action_parameters: self.service_action_parameters,
            }
        }
    }
}
impl DescribeServiceActionExecutionParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionExecutionParametersOutput`](crate::output::DescribeServiceActionExecutionParametersOutput)
    pub fn builder() -> crate::output::describe_service_action_execution_parameters_output::Builder
    {
        crate::output::describe_service_action_execution_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceActionOutput {
    /// <p>Detailed information about the self-service action.</p>
    pub service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
}
impl std::fmt::Debug for DescribeServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceActionOutput");
        formatter.field("service_action_detail", &self.service_action_detail);
        formatter.finish()
    }
}
/// See [`DescribeServiceActionOutput`](crate::output::DescribeServiceActionOutput)
pub mod describe_service_action_output {
    /// A builder for [`DescribeServiceActionOutput`](crate::output::DescribeServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
    }
    impl Builder {
        /// <p>Detailed information about the self-service action.</p>
        pub fn service_action_detail(mut self, input: crate::model::ServiceActionDetail) -> Self {
            self.service_action_detail = Some(input);
            self
        }
        /// <p>Detailed information about the self-service action.</p>
        pub fn set_service_action_detail(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDetail>,
        ) -> Self {
            self.service_action_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceActionOutput`](crate::output::DescribeServiceActionOutput)
        pub fn build(self) -> crate::output::DescribeServiceActionOutput {
            crate::output::DescribeServiceActionOutput {
                service_action_detail: self.service_action_detail,
            }
        }
    }
}
impl DescribeServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServiceActionOutput`](crate::output::DescribeServiceActionOutput)
    pub fn builder() -> crate::output::describe_service_action_output::Builder {
        crate::output::describe_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecordOutput {
    /// <p>Information about the product.</p>
    pub record_detail: std::option::Option<crate::model::RecordDetail>,
    /// <p>Information about the product created as the result of a request. For example, the output for  
    /// a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.</p>
    pub record_outputs: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRecordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecordOutput");
        formatter.field("record_detail", &self.record_detail);
        formatter.field("record_outputs", &self.record_outputs);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`DescribeRecordOutput`](crate::output::DescribeRecordOutput)
pub mod describe_record_output {
    /// A builder for [`DescribeRecordOutput`](crate::output::DescribeRecordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_detail: std::option::Option<crate::model::RecordDetail>,
        pub(crate) record_outputs: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the product.</p>
        pub fn record_detail(mut self, input: crate::model::RecordDetail) -> Self {
            self.record_detail = Some(input);
            self
        }
        /// <p>Information about the product.</p>
        pub fn set_record_detail(
            mut self,
            input: std::option::Option<crate::model::RecordDetail>,
        ) -> Self {
            self.record_detail = input;
            self
        }
        /// Appends an item to `record_outputs`.
        ///
        /// To override the contents of this collection use [`set_record_outputs`](Self::set_record_outputs).
        ///
        /// <p>Information about the product created as the result of a request. For example, the output for  
        /// a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.</p>
        pub fn record_outputs(mut self, input: impl Into<crate::model::RecordOutput>) -> Self {
            let mut v = self.record_outputs.unwrap_or_default();
            v.push(input.into());
            self.record_outputs = Some(v);
            self
        }
        /// <p>Information about the product created as the result of a request. For example, the output for  
        /// a CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.</p>
        pub fn set_record_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordOutput>>,
        ) -> Self {
            self.record_outputs = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecordOutput`](crate::output::DescribeRecordOutput)
        pub fn build(self) -> crate::output::DescribeRecordOutput {
            crate::output::DescribeRecordOutput {
                record_detail: self.record_detail,
                record_outputs: self.record_outputs,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl DescribeRecordOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecordOutput`](crate::output::DescribeRecordOutput)
    pub fn builder() -> crate::output::describe_record_output::Builder {
        crate::output::describe_record_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningParametersOutput {
    /// <p>Information about the parameters used to provision the product.</p>
    pub provisioning_artifact_parameters:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactParameter>>,
    /// <p>Information about the constraints used to provision the product.</p>
    pub constraint_summaries: std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
    /// <p>Any additional metadata specifically related to the provisioning of the product. For
    /// example, see the <code>Version</code> field of the CloudFormation template.</p>
    pub usage_instructions: std::option::Option<std::vec::Vec<crate::model::UsageInstruction>>,
    /// <p>Information about the TagOptions associated with the resource.</p>
    pub tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionSummary>>,
    /// <p>An object that contains information about preferences, such as regions and accounts, for the provisioning artifact.</p>
    pub provisioning_artifact_preferences:
        std::option::Option<crate::model::ProvisioningArtifactPreferences>,
    /// <p>The output of the provisioning artifact.</p>
    pub provisioning_artifact_outputs:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactOutput>>,
}
impl std::fmt::Debug for DescribeProvisioningParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningParametersOutput");
        formatter.field(
            "provisioning_artifact_parameters",
            &self.provisioning_artifact_parameters,
        );
        formatter.field("constraint_summaries", &self.constraint_summaries);
        formatter.field("usage_instructions", &self.usage_instructions);
        formatter.field("tag_options", &self.tag_options);
        formatter.field(
            "provisioning_artifact_preferences",
            &self.provisioning_artifact_preferences,
        );
        formatter.field(
            "provisioning_artifact_outputs",
            &self.provisioning_artifact_outputs,
        );
        formatter.finish()
    }
}
/// See [`DescribeProvisioningParametersOutput`](crate::output::DescribeProvisioningParametersOutput)
pub mod describe_provisioning_parameters_output {
    /// A builder for [`DescribeProvisioningParametersOutput`](crate::output::DescribeProvisioningParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_parameters:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactParameter>>,
        pub(crate) constraint_summaries:
            std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
        pub(crate) usage_instructions:
            std::option::Option<std::vec::Vec<crate::model::UsageInstruction>>,
        pub(crate) tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionSummary>>,
        pub(crate) provisioning_artifact_preferences:
            std::option::Option<crate::model::ProvisioningArtifactPreferences>,
        pub(crate) provisioning_artifact_outputs:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactOutput>>,
    }
    impl Builder {
        /// Appends an item to `provisioning_artifact_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_parameters`](Self::set_provisioning_artifact_parameters).
        ///
        /// <p>Information about the parameters used to provision the product.</p>
        pub fn provisioning_artifact_parameters(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifactParameter>,
        ) -> Self {
            let mut v = self.provisioning_artifact_parameters.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifact_parameters = Some(v);
            self
        }
        /// <p>Information about the parameters used to provision the product.</p>
        pub fn set_provisioning_artifact_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactParameter>>,
        ) -> Self {
            self.provisioning_artifact_parameters = input;
            self
        }
        /// Appends an item to `constraint_summaries`.
        ///
        /// To override the contents of this collection use [`set_constraint_summaries`](Self::set_constraint_summaries).
        ///
        /// <p>Information about the constraints used to provision the product.</p>
        pub fn constraint_summaries(
            mut self,
            input: impl Into<crate::model::ConstraintSummary>,
        ) -> Self {
            let mut v = self.constraint_summaries.unwrap_or_default();
            v.push(input.into());
            self.constraint_summaries = Some(v);
            self
        }
        /// <p>Information about the constraints used to provision the product.</p>
        pub fn set_constraint_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConstraintSummary>>,
        ) -> Self {
            self.constraint_summaries = input;
            self
        }
        /// Appends an item to `usage_instructions`.
        ///
        /// To override the contents of this collection use [`set_usage_instructions`](Self::set_usage_instructions).
        ///
        /// <p>Any additional metadata specifically related to the provisioning of the product. For
        /// example, see the <code>Version</code> field of the CloudFormation template.</p>
        pub fn usage_instructions(
            mut self,
            input: impl Into<crate::model::UsageInstruction>,
        ) -> Self {
            let mut v = self.usage_instructions.unwrap_or_default();
            v.push(input.into());
            self.usage_instructions = Some(v);
            self
        }
        /// <p>Any additional metadata specifically related to the provisioning of the product. For
        /// example, see the <code>Version</code> field of the CloudFormation template.</p>
        pub fn set_usage_instructions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageInstruction>>,
        ) -> Self {
            self.usage_instructions = input;
            self
        }
        /// Appends an item to `tag_options`.
        ///
        /// To override the contents of this collection use [`set_tag_options`](Self::set_tag_options).
        ///
        /// <p>Information about the TagOptions associated with the resource.</p>
        pub fn tag_options(mut self, input: impl Into<crate::model::TagOptionSummary>) -> Self {
            let mut v = self.tag_options.unwrap_or_default();
            v.push(input.into());
            self.tag_options = Some(v);
            self
        }
        /// <p>Information about the TagOptions associated with the resource.</p>
        pub fn set_tag_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagOptionSummary>>,
        ) -> Self {
            self.tag_options = input;
            self
        }
        /// <p>An object that contains information about preferences, such as regions and accounts, for the provisioning artifact.</p>
        pub fn provisioning_artifact_preferences(
            mut self,
            input: crate::model::ProvisioningArtifactPreferences,
        ) -> Self {
            self.provisioning_artifact_preferences = Some(input);
            self
        }
        /// <p>An object that contains information about preferences, such as regions and accounts, for the provisioning artifact.</p>
        pub fn set_provisioning_artifact_preferences(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactPreferences>,
        ) -> Self {
            self.provisioning_artifact_preferences = input;
            self
        }
        /// Appends an item to `provisioning_artifact_outputs`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_outputs`](Self::set_provisioning_artifact_outputs).
        ///
        /// <p>The output of the provisioning artifact.</p>
        pub fn provisioning_artifact_outputs(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifactOutput>,
        ) -> Self {
            let mut v = self.provisioning_artifact_outputs.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifact_outputs = Some(v);
            self
        }
        /// <p>The output of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactOutput>>,
        ) -> Self {
            self.provisioning_artifact_outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningParametersOutput`](crate::output::DescribeProvisioningParametersOutput)
        pub fn build(self) -> crate::output::DescribeProvisioningParametersOutput {
            crate::output::DescribeProvisioningParametersOutput {
                provisioning_artifact_parameters: self.provisioning_artifact_parameters,
                constraint_summaries: self.constraint_summaries,
                usage_instructions: self.usage_instructions,
                tag_options: self.tag_options,
                provisioning_artifact_preferences: self.provisioning_artifact_preferences,
                provisioning_artifact_outputs: self.provisioning_artifact_outputs,
            }
        }
    }
}
impl DescribeProvisioningParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningParametersOutput`](crate::output::DescribeProvisioningParametersOutput)
    pub fn builder() -> crate::output::describe_provisioning_parameters_output::Builder {
        crate::output::describe_provisioning_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningArtifactOutput {
    /// <p>Information about the provisioning artifact.</p>
    pub provisioning_artifact_detail: std::option::Option<crate::model::ProvisioningArtifactDetail>,
    /// <p>The URL of the CloudFormation template in Amazon S3.</p>
    pub info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for DescribeProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningArtifactOutput");
        formatter.field(
            "provisioning_artifact_detail",
            &self.provisioning_artifact_detail,
        );
        formatter.field("info", &self.info);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeProvisioningArtifactOutput`](crate::output::DescribeProvisioningArtifactOutput)
pub mod describe_provisioning_artifact_output {
    /// A builder for [`DescribeProvisioningArtifactOutput`](crate::output::DescribeProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_detail:
            std::option::Option<crate::model::ProvisioningArtifactDetail>,
        pub(crate) info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the provisioning artifact.</p>
        pub fn provisioning_artifact_detail(
            mut self,
            input: crate::model::ProvisioningArtifactDetail,
        ) -> Self {
            self.provisioning_artifact_detail = Some(input);
            self
        }
        /// <p>Information about the provisioning artifact.</p>
        pub fn set_provisioning_artifact_detail(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactDetail>,
        ) -> Self {
            self.provisioning_artifact_detail = input;
            self
        }
        /// Adds a key-value pair to `info`.
        ///
        /// To override the contents of this collection use [`set_info`](Self::set_info).
        ///
        /// <p>The URL of the CloudFormation template in Amazon S3.</p>
        pub fn info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.info = Some(hash_map);
            self
        }
        /// <p>The URL of the CloudFormation template in Amazon S3.</p>
        pub fn set_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.info = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningArtifactOutput`](crate::output::DescribeProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::DescribeProvisioningArtifactOutput {
            crate::output::DescribeProvisioningArtifactOutput {
                provisioning_artifact_detail: self.provisioning_artifact_detail,
                info: self.info,
                status: self.status,
            }
        }
    }
}
impl DescribeProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningArtifactOutput`](crate::output::DescribeProvisioningArtifactOutput)
    pub fn builder() -> crate::output::describe_provisioning_artifact_output::Builder {
        crate::output::describe_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisionedProductPlanOutput {
    /// <p>Information about the plan.</p>
    pub provisioned_product_plan_details:
        std::option::Option<crate::model::ProvisionedProductPlanDetails>,
    /// <p>Information about the resource changes that will occur when the plan is executed.</p>
    pub resource_changes: std::option::Option<std::vec::Vec<crate::model::ResourceChange>>,
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeProvisionedProductPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisionedProductPlanOutput");
        formatter.field(
            "provisioned_product_plan_details",
            &self.provisioned_product_plan_details,
        );
        formatter.field("resource_changes", &self.resource_changes);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`DescribeProvisionedProductPlanOutput`](crate::output::DescribeProvisionedProductPlanOutput)
pub mod describe_provisioned_product_plan_output {
    /// A builder for [`DescribeProvisionedProductPlanOutput`](crate::output::DescribeProvisionedProductPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_plan_details:
            std::option::Option<crate::model::ProvisionedProductPlanDetails>,
        pub(crate) resource_changes:
            std::option::Option<std::vec::Vec<crate::model::ResourceChange>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the plan.</p>
        pub fn provisioned_product_plan_details(
            mut self,
            input: crate::model::ProvisionedProductPlanDetails,
        ) -> Self {
            self.provisioned_product_plan_details = Some(input);
            self
        }
        /// <p>Information about the plan.</p>
        pub fn set_provisioned_product_plan_details(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductPlanDetails>,
        ) -> Self {
            self.provisioned_product_plan_details = input;
            self
        }
        /// Appends an item to `resource_changes`.
        ///
        /// To override the contents of this collection use [`set_resource_changes`](Self::set_resource_changes).
        ///
        /// <p>Information about the resource changes that will occur when the plan is executed.</p>
        pub fn resource_changes(mut self, input: impl Into<crate::model::ResourceChange>) -> Self {
            let mut v = self.resource_changes.unwrap_or_default();
            v.push(input.into());
            self.resource_changes = Some(v);
            self
        }
        /// <p>Information about the resource changes that will occur when the plan is executed.</p>
        pub fn set_resource_changes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceChange>>,
        ) -> Self {
            self.resource_changes = input;
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisionedProductPlanOutput`](crate::output::DescribeProvisionedProductPlanOutput)
        pub fn build(self) -> crate::output::DescribeProvisionedProductPlanOutput {
            crate::output::DescribeProvisionedProductPlanOutput {
                provisioned_product_plan_details: self.provisioned_product_plan_details,
                resource_changes: self.resource_changes,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl DescribeProvisionedProductPlanOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductPlanOutput`](crate::output::DescribeProvisionedProductPlanOutput)
    pub fn builder() -> crate::output::describe_provisioned_product_plan_output::Builder {
        crate::output::describe_provisioned_product_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisionedProductOutput {
    /// <p>Information about the provisioned product.</p>
    pub provisioned_product_detail: std::option::Option<crate::model::ProvisionedProductDetail>,
    /// <p>Any CloudWatch dashboards that were created when provisioning the product.</p>
    pub cloud_watch_dashboards:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchDashboard>>,
}
impl std::fmt::Debug for DescribeProvisionedProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisionedProductOutput");
        formatter.field(
            "provisioned_product_detail",
            &self.provisioned_product_detail,
        );
        formatter.field("cloud_watch_dashboards", &self.cloud_watch_dashboards);
        formatter.finish()
    }
}
/// See [`DescribeProvisionedProductOutput`](crate::output::DescribeProvisionedProductOutput)
pub mod describe_provisioned_product_output {
    /// A builder for [`DescribeProvisionedProductOutput`](crate::output::DescribeProvisionedProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_detail:
            std::option::Option<crate::model::ProvisionedProductDetail>,
        pub(crate) cloud_watch_dashboards:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchDashboard>>,
    }
    impl Builder {
        /// <p>Information about the provisioned product.</p>
        pub fn provisioned_product_detail(
            mut self,
            input: crate::model::ProvisionedProductDetail,
        ) -> Self {
            self.provisioned_product_detail = Some(input);
            self
        }
        /// <p>Information about the provisioned product.</p>
        pub fn set_provisioned_product_detail(
            mut self,
            input: std::option::Option<crate::model::ProvisionedProductDetail>,
        ) -> Self {
            self.provisioned_product_detail = input;
            self
        }
        /// Appends an item to `cloud_watch_dashboards`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_dashboards`](Self::set_cloud_watch_dashboards).
        ///
        /// <p>Any CloudWatch dashboards that were created when provisioning the product.</p>
        pub fn cloud_watch_dashboards(
            mut self,
            input: impl Into<crate::model::CloudWatchDashboard>,
        ) -> Self {
            let mut v = self.cloud_watch_dashboards.unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_dashboards = Some(v);
            self
        }
        /// <p>Any CloudWatch dashboards that were created when provisioning the product.</p>
        pub fn set_cloud_watch_dashboards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchDashboard>>,
        ) -> Self {
            self.cloud_watch_dashboards = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisionedProductOutput`](crate::output::DescribeProvisionedProductOutput)
        pub fn build(self) -> crate::output::DescribeProvisionedProductOutput {
            crate::output::DescribeProvisionedProductOutput {
                provisioned_product_detail: self.provisioned_product_detail,
                cloud_watch_dashboards: self.cloud_watch_dashboards,
            }
        }
    }
}
impl DescribeProvisionedProductOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisionedProductOutput`](crate::output::DescribeProvisionedProductOutput)
    pub fn builder() -> crate::output::describe_provisioned_product_output::Builder {
        crate::output::describe_provisioned_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductViewOutput {
    /// <p>Summary information about the product.</p>
    pub product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
    /// <p>Information about the provisioning artifacts for the product.</p>
    pub provisioning_artifacts:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
}
impl std::fmt::Debug for DescribeProductViewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductViewOutput");
        formatter.field("product_view_summary", &self.product_view_summary);
        formatter.field("provisioning_artifacts", &self.provisioning_artifacts);
        formatter.finish()
    }
}
/// See [`DescribeProductViewOutput`](crate::output::DescribeProductViewOutput)
pub mod describe_product_view_output {
    /// A builder for [`DescribeProductViewOutput`](crate::output::DescribeProductViewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
        pub(crate) provisioning_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
    }
    impl Builder {
        /// <p>Summary information about the product.</p>
        pub fn product_view_summary(mut self, input: crate::model::ProductViewSummary) -> Self {
            self.product_view_summary = Some(input);
            self
        }
        /// <p>Summary information about the product.</p>
        pub fn set_product_view_summary(
            mut self,
            input: std::option::Option<crate::model::ProductViewSummary>,
        ) -> Self {
            self.product_view_summary = input;
            self
        }
        /// Appends an item to `provisioning_artifacts`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifacts`](Self::set_provisioning_artifacts).
        ///
        /// <p>Information about the provisioning artifacts for the product.</p>
        pub fn provisioning_artifacts(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifact>,
        ) -> Self {
            let mut v = self.provisioning_artifacts.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifacts = Some(v);
            self
        }
        /// <p>Information about the provisioning artifacts for the product.</p>
        pub fn set_provisioning_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
        ) -> Self {
            self.provisioning_artifacts = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductViewOutput`](crate::output::DescribeProductViewOutput)
        pub fn build(self) -> crate::output::DescribeProductViewOutput {
            crate::output::DescribeProductViewOutput {
                product_view_summary: self.product_view_summary,
                provisioning_artifacts: self.provisioning_artifacts,
            }
        }
    }
}
impl DescribeProductViewOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProductViewOutput`](crate::output::DescribeProductViewOutput)
    pub fn builder() -> crate::output::describe_product_view_output::Builder {
        crate::output::describe_product_view_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductAsAdminOutput {
    /// <p>Information about the product view.</p>
    pub product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
    /// <p>Information about the provisioning artifacts (also known as versions) for the specified product.</p>
    pub provisioning_artifact_summaries:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactSummary>>,
    /// <p>Information about the tags associated with the product.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Information about the TagOptions associated with the product.</p>
    pub tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
    /// <p>Information about the associated budgets.</p>
    pub budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
}
impl std::fmt::Debug for DescribeProductAsAdminOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductAsAdminOutput");
        formatter.field("product_view_detail", &self.product_view_detail);
        formatter.field(
            "provisioning_artifact_summaries",
            &self.provisioning_artifact_summaries,
        );
        formatter.field("tags", &self.tags);
        formatter.field("tag_options", &self.tag_options);
        formatter.field("budgets", &self.budgets);
        formatter.finish()
    }
}
/// See [`DescribeProductAsAdminOutput`](crate::output::DescribeProductAsAdminOutput)
pub mod describe_product_as_admin_output {
    /// A builder for [`DescribeProductAsAdminOutput`](crate::output::DescribeProductAsAdminOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
        pub(crate) provisioning_artifact_summaries:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactSummary>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        pub(crate) budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
    }
    impl Builder {
        /// <p>Information about the product view.</p>
        pub fn product_view_detail(mut self, input: crate::model::ProductViewDetail) -> Self {
            self.product_view_detail = Some(input);
            self
        }
        /// <p>Information about the product view.</p>
        pub fn set_product_view_detail(
            mut self,
            input: std::option::Option<crate::model::ProductViewDetail>,
        ) -> Self {
            self.product_view_detail = input;
            self
        }
        /// Appends an item to `provisioning_artifact_summaries`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifact_summaries`](Self::set_provisioning_artifact_summaries).
        ///
        /// <p>Information about the provisioning artifacts (also known as versions) for the specified product.</p>
        pub fn provisioning_artifact_summaries(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifactSummary>,
        ) -> Self {
            let mut v = self.provisioning_artifact_summaries.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifact_summaries = Some(v);
            self
        }
        /// <p>Information about the provisioning artifacts (also known as versions) for the specified product.</p>
        pub fn set_provisioning_artifact_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifactSummary>>,
        ) -> Self {
            self.provisioning_artifact_summaries = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the product.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the product.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `tag_options`.
        ///
        /// To override the contents of this collection use [`set_tag_options`](Self::set_tag_options).
        ///
        /// <p>Information about the TagOptions associated with the product.</p>
        pub fn tag_options(mut self, input: impl Into<crate::model::TagOptionDetail>) -> Self {
            let mut v = self.tag_options.unwrap_or_default();
            v.push(input.into());
            self.tag_options = Some(v);
            self
        }
        /// <p>Information about the TagOptions associated with the product.</p>
        pub fn set_tag_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        ) -> Self {
            self.tag_options = input;
            self
        }
        /// Appends an item to `budgets`.
        ///
        /// To override the contents of this collection use [`set_budgets`](Self::set_budgets).
        ///
        /// <p>Information about the associated budgets.</p>
        pub fn budgets(mut self, input: impl Into<crate::model::BudgetDetail>) -> Self {
            let mut v = self.budgets.unwrap_or_default();
            v.push(input.into());
            self.budgets = Some(v);
            self
        }
        /// <p>Information about the associated budgets.</p>
        pub fn set_budgets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        ) -> Self {
            self.budgets = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductAsAdminOutput`](crate::output::DescribeProductAsAdminOutput)
        pub fn build(self) -> crate::output::DescribeProductAsAdminOutput {
            crate::output::DescribeProductAsAdminOutput {
                product_view_detail: self.product_view_detail,
                provisioning_artifact_summaries: self.provisioning_artifact_summaries,
                tags: self.tags,
                tag_options: self.tag_options,
                budgets: self.budgets,
            }
        }
    }
}
impl DescribeProductAsAdminOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProductAsAdminOutput`](crate::output::DescribeProductAsAdminOutput)
    pub fn builder() -> crate::output::describe_product_as_admin_output::Builder {
        crate::output::describe_product_as_admin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductOutput {
    /// <p>Summary information about the product view.</p>
    pub product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
    /// <p>Information about the provisioning artifacts for the specified product.</p>
    pub provisioning_artifacts:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
    /// <p>Information about the associated budgets.</p>
    pub budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
    /// <p>Information about the associated launch paths.</p>
    pub launch_paths: std::option::Option<std::vec::Vec<crate::model::LaunchPath>>,
}
impl std::fmt::Debug for DescribeProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductOutput");
        formatter.field("product_view_summary", &self.product_view_summary);
        formatter.field("provisioning_artifacts", &self.provisioning_artifacts);
        formatter.field("budgets", &self.budgets);
        formatter.field("launch_paths", &self.launch_paths);
        formatter.finish()
    }
}
/// See [`DescribeProductOutput`](crate::output::DescribeProductOutput)
pub mod describe_product_output {
    /// A builder for [`DescribeProductOutput`](crate::output::DescribeProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_summary: std::option::Option<crate::model::ProductViewSummary>,
        pub(crate) provisioning_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
        pub(crate) budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        pub(crate) launch_paths: std::option::Option<std::vec::Vec<crate::model::LaunchPath>>,
    }
    impl Builder {
        /// <p>Summary information about the product view.</p>
        pub fn product_view_summary(mut self, input: crate::model::ProductViewSummary) -> Self {
            self.product_view_summary = Some(input);
            self
        }
        /// <p>Summary information about the product view.</p>
        pub fn set_product_view_summary(
            mut self,
            input: std::option::Option<crate::model::ProductViewSummary>,
        ) -> Self {
            self.product_view_summary = input;
            self
        }
        /// Appends an item to `provisioning_artifacts`.
        ///
        /// To override the contents of this collection use [`set_provisioning_artifacts`](Self::set_provisioning_artifacts).
        ///
        /// <p>Information about the provisioning artifacts for the specified product.</p>
        pub fn provisioning_artifacts(
            mut self,
            input: impl Into<crate::model::ProvisioningArtifact>,
        ) -> Self {
            let mut v = self.provisioning_artifacts.unwrap_or_default();
            v.push(input.into());
            self.provisioning_artifacts = Some(v);
            self
        }
        /// <p>Information about the provisioning artifacts for the specified product.</p>
        pub fn set_provisioning_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningArtifact>>,
        ) -> Self {
            self.provisioning_artifacts = input;
            self
        }
        /// Appends an item to `budgets`.
        ///
        /// To override the contents of this collection use [`set_budgets`](Self::set_budgets).
        ///
        /// <p>Information about the associated budgets.</p>
        pub fn budgets(mut self, input: impl Into<crate::model::BudgetDetail>) -> Self {
            let mut v = self.budgets.unwrap_or_default();
            v.push(input.into());
            self.budgets = Some(v);
            self
        }
        /// <p>Information about the associated budgets.</p>
        pub fn set_budgets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        ) -> Self {
            self.budgets = input;
            self
        }
        /// Appends an item to `launch_paths`.
        ///
        /// To override the contents of this collection use [`set_launch_paths`](Self::set_launch_paths).
        ///
        /// <p>Information about the associated launch paths.</p>
        pub fn launch_paths(mut self, input: impl Into<crate::model::LaunchPath>) -> Self {
            let mut v = self.launch_paths.unwrap_or_default();
            v.push(input.into());
            self.launch_paths = Some(v);
            self
        }
        /// <p>Information about the associated launch paths.</p>
        pub fn set_launch_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchPath>>,
        ) -> Self {
            self.launch_paths = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductOutput`](crate::output::DescribeProductOutput)
        pub fn build(self) -> crate::output::DescribeProductOutput {
            crate::output::DescribeProductOutput {
                product_view_summary: self.product_view_summary,
                provisioning_artifacts: self.provisioning_artifacts,
                budgets: self.budgets,
                launch_paths: self.launch_paths,
            }
        }
    }
}
impl DescribeProductOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProductOutput`](crate::output::DescribeProductOutput)
    pub fn builder() -> crate::output::describe_product_output::Builder {
        crate::output::describe_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortfolioShareStatusOutput {
    /// <p>The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.</p>
    pub portfolio_share_token: std::option::Option<std::string::String>,
    /// <p>The portfolio identifier.</p>
    pub portfolio_id: std::option::Option<std::string::String>,
    /// <p>Organization node identifier. It can be either account id, organizational unit id or organization id.</p>
    pub organization_node_value: std::option::Option<std::string::String>,
    /// <p>Status of the portfolio share operation.</p>
    pub status: std::option::Option<crate::model::ShareStatus>,
    /// <p>Information about the portfolio share operation.</p>
    pub share_details: std::option::Option<crate::model::ShareDetails>,
}
impl std::fmt::Debug for DescribePortfolioShareStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortfolioShareStatusOutput");
        formatter.field("portfolio_share_token", &self.portfolio_share_token);
        formatter.field("portfolio_id", &self.portfolio_id);
        formatter.field("organization_node_value", &self.organization_node_value);
        formatter.field("status", &self.status);
        formatter.field("share_details", &self.share_details);
        formatter.finish()
    }
}
/// See [`DescribePortfolioShareStatusOutput`](crate::output::DescribePortfolioShareStatusOutput)
pub mod describe_portfolio_share_status_output {
    /// A builder for [`DescribePortfolioShareStatusOutput`](crate::output::DescribePortfolioShareStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_share_token: std::option::Option<std::string::String>,
        pub(crate) portfolio_id: std::option::Option<std::string::String>,
        pub(crate) organization_node_value: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) share_details: std::option::Option<crate::model::ShareDetails>,
    }
    impl Builder {
        /// <p>The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_share_token = Some(input.into());
            self
        }
        /// <p>The token for the portfolio share operation. For example, <code>share-6v24abcdefghi</code>.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portfolio_share_token = input;
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn portfolio_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_id = Some(input.into());
            self
        }
        /// <p>The portfolio identifier.</p>
        pub fn set_portfolio_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portfolio_id = input;
            self
        }
        /// <p>Organization node identifier. It can be either account id, organizational unit id or organization id.</p>
        pub fn organization_node_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_node_value = Some(input.into());
            self
        }
        /// <p>Organization node identifier. It can be either account id, organizational unit id or organization id.</p>
        pub fn set_organization_node_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_node_value = input;
            self
        }
        /// <p>Status of the portfolio share operation.</p>
        pub fn status(mut self, input: crate::model::ShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the portfolio share operation.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ShareStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the portfolio share operation.</p>
        pub fn share_details(mut self, input: crate::model::ShareDetails) -> Self {
            self.share_details = Some(input);
            self
        }
        /// <p>Information about the portfolio share operation.</p>
        pub fn set_share_details(
            mut self,
            input: std::option::Option<crate::model::ShareDetails>,
        ) -> Self {
            self.share_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioShareStatusOutput`](crate::output::DescribePortfolioShareStatusOutput)
        pub fn build(self) -> crate::output::DescribePortfolioShareStatusOutput {
            crate::output::DescribePortfolioShareStatusOutput {
                portfolio_share_token: self.portfolio_share_token,
                portfolio_id: self.portfolio_id,
                organization_node_value: self.organization_node_value,
                status: self.status,
                share_details: self.share_details,
            }
        }
    }
}
impl DescribePortfolioShareStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioShareStatusOutput`](crate::output::DescribePortfolioShareStatusOutput)
    pub fn builder() -> crate::output::describe_portfolio_share_status_output::Builder {
        crate::output::describe_portfolio_share_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortfolioSharesOutput {
    /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>Summaries about each of the portfolio shares.</p>
    pub portfolio_share_details:
        std::option::Option<std::vec::Vec<crate::model::PortfolioShareDetail>>,
}
impl std::fmt::Debug for DescribePortfolioSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortfolioSharesOutput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("portfolio_share_details", &self.portfolio_share_details);
        formatter.finish()
    }
}
/// See [`DescribePortfolioSharesOutput`](crate::output::DescribePortfolioSharesOutput)
pub mod describe_portfolio_shares_output {
    /// A builder for [`DescribePortfolioSharesOutput`](crate::output::DescribePortfolioSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) portfolio_share_details:
            std::option::Option<std::vec::Vec<crate::model::PortfolioShareDetail>>,
    }
    impl Builder {
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The page token to use to retrieve the next set of results. If there are no additional results, this value is null.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Appends an item to `portfolio_share_details`.
        ///
        /// To override the contents of this collection use [`set_portfolio_share_details`](Self::set_portfolio_share_details).
        ///
        /// <p>Summaries about each of the portfolio shares.</p>
        pub fn portfolio_share_details(
            mut self,
            input: impl Into<crate::model::PortfolioShareDetail>,
        ) -> Self {
            let mut v = self.portfolio_share_details.unwrap_or_default();
            v.push(input.into());
            self.portfolio_share_details = Some(v);
            self
        }
        /// <p>Summaries about each of the portfolio shares.</p>
        pub fn set_portfolio_share_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortfolioShareDetail>>,
        ) -> Self {
            self.portfolio_share_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioSharesOutput`](crate::output::DescribePortfolioSharesOutput)
        pub fn build(self) -> crate::output::DescribePortfolioSharesOutput {
            crate::output::DescribePortfolioSharesOutput {
                next_page_token: self.next_page_token,
                portfolio_share_details: self.portfolio_share_details,
            }
        }
    }
}
impl DescribePortfolioSharesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioSharesOutput`](crate::output::DescribePortfolioSharesOutput)
    pub fn builder() -> crate::output::describe_portfolio_shares_output::Builder {
        crate::output::describe_portfolio_shares_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortfolioOutput {
    /// <p>Information about the portfolio.</p>
    pub portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
    /// <p>Information about the tags associated with the portfolio.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Information about the TagOptions associated with the portfolio.</p>
    pub tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
    /// <p>Information about the associated budgets.</p>
    pub budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
}
impl std::fmt::Debug for DescribePortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortfolioOutput");
        formatter.field("portfolio_detail", &self.portfolio_detail);
        formatter.field("tags", &self.tags);
        formatter.field("tag_options", &self.tag_options);
        formatter.field("budgets", &self.budgets);
        formatter.finish()
    }
}
/// See [`DescribePortfolioOutput`](crate::output::DescribePortfolioOutput)
pub mod describe_portfolio_output {
    /// A builder for [`DescribePortfolioOutput`](crate::output::DescribePortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) tag_options: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        pub(crate) budgets: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
    }
    impl Builder {
        /// <p>Information about the portfolio.</p>
        pub fn portfolio_detail(mut self, input: crate::model::PortfolioDetail) -> Self {
            self.portfolio_detail = Some(input);
            self
        }
        /// <p>Information about the portfolio.</p>
        pub fn set_portfolio_detail(
            mut self,
            input: std::option::Option<crate::model::PortfolioDetail>,
        ) -> Self {
            self.portfolio_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `tag_options`.
        ///
        /// To override the contents of this collection use [`set_tag_options`](Self::set_tag_options).
        ///
        /// <p>Information about the TagOptions associated with the portfolio.</p>
        pub fn tag_options(mut self, input: impl Into<crate::model::TagOptionDetail>) -> Self {
            let mut v = self.tag_options.unwrap_or_default();
            v.push(input.into());
            self.tag_options = Some(v);
            self
        }
        /// <p>Information about the TagOptions associated with the portfolio.</p>
        pub fn set_tag_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagOptionDetail>>,
        ) -> Self {
            self.tag_options = input;
            self
        }
        /// Appends an item to `budgets`.
        ///
        /// To override the contents of this collection use [`set_budgets`](Self::set_budgets).
        ///
        /// <p>Information about the associated budgets.</p>
        pub fn budgets(mut self, input: impl Into<crate::model::BudgetDetail>) -> Self {
            let mut v = self.budgets.unwrap_or_default();
            v.push(input.into());
            self.budgets = Some(v);
            self
        }
        /// <p>Information about the associated budgets.</p>
        pub fn set_budgets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BudgetDetail>>,
        ) -> Self {
            self.budgets = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortfolioOutput`](crate::output::DescribePortfolioOutput)
        pub fn build(self) -> crate::output::DescribePortfolioOutput {
            crate::output::DescribePortfolioOutput {
                portfolio_detail: self.portfolio_detail,
                tags: self.tags,
                tag_options: self.tag_options,
                budgets: self.budgets,
            }
        }
    }
}
impl DescribePortfolioOutput {
    /// Creates a new builder-style object to manufacture [`DescribePortfolioOutput`](crate::output::DescribePortfolioOutput)
    pub fn builder() -> crate::output::describe_portfolio_output::Builder {
        crate::output::describe_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCopyProductStatusOutput {
    /// <p>The status of the copy product operation.</p>
    pub copy_product_status: std::option::Option<crate::model::CopyProductStatus>,
    /// <p>The identifier of the copied product.</p>
    pub target_product_id: std::option::Option<std::string::String>,
    /// <p>The status message.</p>
    pub status_detail: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCopyProductStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCopyProductStatusOutput");
        formatter.field("copy_product_status", &self.copy_product_status);
        formatter.field("target_product_id", &self.target_product_id);
        formatter.field("status_detail", &self.status_detail);
        formatter.finish()
    }
}
/// See [`DescribeCopyProductStatusOutput`](crate::output::DescribeCopyProductStatusOutput)
pub mod describe_copy_product_status_output {
    /// A builder for [`DescribeCopyProductStatusOutput`](crate::output::DescribeCopyProductStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_product_status: std::option::Option<crate::model::CopyProductStatus>,
        pub(crate) target_product_id: std::option::Option<std::string::String>,
        pub(crate) status_detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the copy product operation.</p>
        pub fn copy_product_status(mut self, input: crate::model::CopyProductStatus) -> Self {
            self.copy_product_status = Some(input);
            self
        }
        /// <p>The status of the copy product operation.</p>
        pub fn set_copy_product_status(
            mut self,
            input: std::option::Option<crate::model::CopyProductStatus>,
        ) -> Self {
            self.copy_product_status = input;
            self
        }
        /// <p>The identifier of the copied product.</p>
        pub fn target_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_product_id = Some(input.into());
            self
        }
        /// <p>The identifier of the copied product.</p>
        pub fn set_target_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_product_id = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_detail = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_detail(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCopyProductStatusOutput`](crate::output::DescribeCopyProductStatusOutput)
        pub fn build(self) -> crate::output::DescribeCopyProductStatusOutput {
            crate::output::DescribeCopyProductStatusOutput {
                copy_product_status: self.copy_product_status,
                target_product_id: self.target_product_id,
                status_detail: self.status_detail,
            }
        }
    }
}
impl DescribeCopyProductStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCopyProductStatusOutput`](crate::output::DescribeCopyProductStatusOutput)
    pub fn builder() -> crate::output::describe_copy_product_status_output::Builder {
        crate::output::describe_copy_product_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConstraintOutput {
    /// <p>Information about the constraint.</p>
    pub constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
    /// <p>The constraint parameters.</p>
    pub constraint_parameters: std::option::Option<std::string::String>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for DescribeConstraintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConstraintOutput");
        formatter.field("constraint_detail", &self.constraint_detail);
        formatter.field("constraint_parameters", &self.constraint_parameters);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeConstraintOutput`](crate::output::DescribeConstraintOutput)
pub mod describe_constraint_output {
    /// A builder for [`DescribeConstraintOutput`](crate::output::DescribeConstraintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
        pub(crate) constraint_parameters: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the constraint.</p>
        pub fn constraint_detail(mut self, input: crate::model::ConstraintDetail) -> Self {
            self.constraint_detail = Some(input);
            self
        }
        /// <p>Information about the constraint.</p>
        pub fn set_constraint_detail(
            mut self,
            input: std::option::Option<crate::model::ConstraintDetail>,
        ) -> Self {
            self.constraint_detail = input;
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn constraint_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_parameters = Some(input.into());
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn set_constraint_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_parameters = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConstraintOutput`](crate::output::DescribeConstraintOutput)
        pub fn build(self) -> crate::output::DescribeConstraintOutput {
            crate::output::DescribeConstraintOutput {
                constraint_detail: self.constraint_detail,
                constraint_parameters: self.constraint_parameters,
                status: self.status,
            }
        }
    }
}
impl DescribeConstraintOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConstraintOutput`](crate::output::DescribeConstraintOutput)
    pub fn builder() -> crate::output::describe_constraint_output::Builder {
        crate::output::describe_constraint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagOptionOutput {}
impl std::fmt::Debug for DeleteTagOptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagOptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagOptionOutput`](crate::output::DeleteTagOptionOutput)
pub mod delete_tag_option_output {
    /// A builder for [`DeleteTagOptionOutput`](crate::output::DeleteTagOptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagOptionOutput`](crate::output::DeleteTagOptionOutput)
        pub fn build(self) -> crate::output::DeleteTagOptionOutput {
            crate::output::DeleteTagOptionOutput {}
        }
    }
}
impl DeleteTagOptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagOptionOutput`](crate::output::DeleteTagOptionOutput)
    pub fn builder() -> crate::output::delete_tag_option_output::Builder {
        crate::output::delete_tag_option_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceActionOutput {}
impl std::fmt::Debug for DeleteServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceActionOutput");
        formatter.finish()
    }
}
/// See [`DeleteServiceActionOutput`](crate::output::DeleteServiceActionOutput)
pub mod delete_service_action_output {
    /// A builder for [`DeleteServiceActionOutput`](crate::output::DeleteServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServiceActionOutput`](crate::output::DeleteServiceActionOutput)
        pub fn build(self) -> crate::output::DeleteServiceActionOutput {
            crate::output::DeleteServiceActionOutput {}
        }
    }
}
impl DeleteServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceActionOutput`](crate::output::DeleteServiceActionOutput)
    pub fn builder() -> crate::output::delete_service_action_output::Builder {
        crate::output::delete_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisioningArtifactOutput {}
impl std::fmt::Debug for DeleteProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisioningArtifactOutput");
        formatter.finish()
    }
}
/// See [`DeleteProvisioningArtifactOutput`](crate::output::DeleteProvisioningArtifactOutput)
pub mod delete_provisioning_artifact_output {
    /// A builder for [`DeleteProvisioningArtifactOutput`](crate::output::DeleteProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProvisioningArtifactOutput`](crate::output::DeleteProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::DeleteProvisioningArtifactOutput {
            crate::output::DeleteProvisioningArtifactOutput {}
        }
    }
}
impl DeleteProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningArtifactOutput`](crate::output::DeleteProvisioningArtifactOutput)
    pub fn builder() -> crate::output::delete_provisioning_artifact_output::Builder {
        crate::output::delete_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisionedProductPlanOutput {}
impl std::fmt::Debug for DeleteProvisionedProductPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisionedProductPlanOutput");
        formatter.finish()
    }
}
/// See [`DeleteProvisionedProductPlanOutput`](crate::output::DeleteProvisionedProductPlanOutput)
pub mod delete_provisioned_product_plan_output {
    /// A builder for [`DeleteProvisionedProductPlanOutput`](crate::output::DeleteProvisionedProductPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProvisionedProductPlanOutput`](crate::output::DeleteProvisionedProductPlanOutput)
        pub fn build(self) -> crate::output::DeleteProvisionedProductPlanOutput {
            crate::output::DeleteProvisionedProductPlanOutput {}
        }
    }
}
impl DeleteProvisionedProductPlanOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedProductPlanOutput`](crate::output::DeleteProvisionedProductPlanOutput)
    pub fn builder() -> crate::output::delete_provisioned_product_plan_output::Builder {
        crate::output::delete_provisioned_product_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProductOutput {}
impl std::fmt::Debug for DeleteProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProductOutput");
        formatter.finish()
    }
}
/// See [`DeleteProductOutput`](crate::output::DeleteProductOutput)
pub mod delete_product_output {
    /// A builder for [`DeleteProductOutput`](crate::output::DeleteProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProductOutput`](crate::output::DeleteProductOutput)
        pub fn build(self) -> crate::output::DeleteProductOutput {
            crate::output::DeleteProductOutput {}
        }
    }
}
impl DeleteProductOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProductOutput`](crate::output::DeleteProductOutput)
    pub fn builder() -> crate::output::delete_product_output::Builder {
        crate::output::delete_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePortfolioShareOutput {
    /// <p>The portfolio share unique identifier. This will only be returned if delete is made to an organization node.</p>
    pub portfolio_share_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeletePortfolioShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePortfolioShareOutput");
        formatter.field("portfolio_share_token", &self.portfolio_share_token);
        formatter.finish()
    }
}
/// See [`DeletePortfolioShareOutput`](crate::output::DeletePortfolioShareOutput)
pub mod delete_portfolio_share_output {
    /// A builder for [`DeletePortfolioShareOutput`](crate::output::DeletePortfolioShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_share_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The portfolio share unique identifier. This will only be returned if delete is made to an organization node.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_share_token = Some(input.into());
            self
        }
        /// <p>The portfolio share unique identifier. This will only be returned if delete is made to an organization node.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portfolio_share_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortfolioShareOutput`](crate::output::DeletePortfolioShareOutput)
        pub fn build(self) -> crate::output::DeletePortfolioShareOutput {
            crate::output::DeletePortfolioShareOutput {
                portfolio_share_token: self.portfolio_share_token,
            }
        }
    }
}
impl DeletePortfolioShareOutput {
    /// Creates a new builder-style object to manufacture [`DeletePortfolioShareOutput`](crate::output::DeletePortfolioShareOutput)
    pub fn builder() -> crate::output::delete_portfolio_share_output::Builder {
        crate::output::delete_portfolio_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePortfolioOutput {}
impl std::fmt::Debug for DeletePortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePortfolioOutput");
        formatter.finish()
    }
}
/// See [`DeletePortfolioOutput`](crate::output::DeletePortfolioOutput)
pub mod delete_portfolio_output {
    /// A builder for [`DeletePortfolioOutput`](crate::output::DeletePortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePortfolioOutput`](crate::output::DeletePortfolioOutput)
        pub fn build(self) -> crate::output::DeletePortfolioOutput {
            crate::output::DeletePortfolioOutput {}
        }
    }
}
impl DeletePortfolioOutput {
    /// Creates a new builder-style object to manufacture [`DeletePortfolioOutput`](crate::output::DeletePortfolioOutput)
    pub fn builder() -> crate::output::delete_portfolio_output::Builder {
        crate::output::delete_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConstraintOutput {}
impl std::fmt::Debug for DeleteConstraintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConstraintOutput");
        formatter.finish()
    }
}
/// See [`DeleteConstraintOutput`](crate::output::DeleteConstraintOutput)
pub mod delete_constraint_output {
    /// A builder for [`DeleteConstraintOutput`](crate::output::DeleteConstraintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConstraintOutput`](crate::output::DeleteConstraintOutput)
        pub fn build(self) -> crate::output::DeleteConstraintOutput {
            crate::output::DeleteConstraintOutput {}
        }
    }
}
impl DeleteConstraintOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConstraintOutput`](crate::output::DeleteConstraintOutput)
    pub fn builder() -> crate::output::delete_constraint_output::Builder {
        crate::output::delete_constraint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagOptionOutput {
    /// <p>Information about the TagOption.</p>
    pub tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
}
impl std::fmt::Debug for CreateTagOptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagOptionOutput");
        formatter.field("tag_option_detail", &self.tag_option_detail);
        formatter.finish()
    }
}
/// See [`CreateTagOptionOutput`](crate::output::CreateTagOptionOutput)
pub mod create_tag_option_output {
    /// A builder for [`CreateTagOptionOutput`](crate::output::CreateTagOptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_option_detail: std::option::Option<crate::model::TagOptionDetail>,
    }
    impl Builder {
        /// <p>Information about the TagOption.</p>
        pub fn tag_option_detail(mut self, input: crate::model::TagOptionDetail) -> Self {
            self.tag_option_detail = Some(input);
            self
        }
        /// <p>Information about the TagOption.</p>
        pub fn set_tag_option_detail(
            mut self,
            input: std::option::Option<crate::model::TagOptionDetail>,
        ) -> Self {
            self.tag_option_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagOptionOutput`](crate::output::CreateTagOptionOutput)
        pub fn build(self) -> crate::output::CreateTagOptionOutput {
            crate::output::CreateTagOptionOutput {
                tag_option_detail: self.tag_option_detail,
            }
        }
    }
}
impl CreateTagOptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagOptionOutput`](crate::output::CreateTagOptionOutput)
    pub fn builder() -> crate::output::create_tag_option_output::Builder {
        crate::output::create_tag_option_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceActionOutput {
    /// <p>An object containing information about the self-service action.</p>
    pub service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
}
impl std::fmt::Debug for CreateServiceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceActionOutput");
        formatter.field("service_action_detail", &self.service_action_detail);
        formatter.finish()
    }
}
/// See [`CreateServiceActionOutput`](crate::output::CreateServiceActionOutput)
pub mod create_service_action_output {
    /// A builder for [`CreateServiceActionOutput`](crate::output::CreateServiceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_action_detail: std::option::Option<crate::model::ServiceActionDetail>,
    }
    impl Builder {
        /// <p>An object containing information about the self-service action.</p>
        pub fn service_action_detail(mut self, input: crate::model::ServiceActionDetail) -> Self {
            self.service_action_detail = Some(input);
            self
        }
        /// <p>An object containing information about the self-service action.</p>
        pub fn set_service_action_detail(
            mut self,
            input: std::option::Option<crate::model::ServiceActionDetail>,
        ) -> Self {
            self.service_action_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceActionOutput`](crate::output::CreateServiceActionOutput)
        pub fn build(self) -> crate::output::CreateServiceActionOutput {
            crate::output::CreateServiceActionOutput {
                service_action_detail: self.service_action_detail,
            }
        }
    }
}
impl CreateServiceActionOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceActionOutput`](crate::output::CreateServiceActionOutput)
    pub fn builder() -> crate::output::create_service_action_output::Builder {
        crate::output::create_service_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProvisioningArtifactOutput {
    /// <p>Information about the provisioning artifact.</p>
    pub provisioning_artifact_detail: std::option::Option<crate::model::ProvisioningArtifactDetail>,
    /// <p>Specify the template source with one of the following options, but not both. Keys
    /// accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>
    /// <p>The URL of the CloudFormation template in Amazon S3, in JSON format. </p>
    /// <p>
    /// <code>LoadTemplateFromURL</code>
    /// </p>
    /// <p>Use the URL of the CloudFormation template in Amazon S3 in JSON format.</p>
    /// <p>
    /// <code>ImportFromPhysicalId</code>
    /// </p>
    /// <p>Use the physical id of the resource that contains the template; currently supports
    /// CloudFormation stack ARN.</p>
    pub info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for CreateProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProvisioningArtifactOutput");
        formatter.field(
            "provisioning_artifact_detail",
            &self.provisioning_artifact_detail,
        );
        formatter.field("info", &self.info);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateProvisioningArtifactOutput`](crate::output::CreateProvisioningArtifactOutput)
pub mod create_provisioning_artifact_output {
    /// A builder for [`CreateProvisioningArtifactOutput`](crate::output::CreateProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_detail:
            std::option::Option<crate::model::ProvisioningArtifactDetail>,
        pub(crate) info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the provisioning artifact.</p>
        pub fn provisioning_artifact_detail(
            mut self,
            input: crate::model::ProvisioningArtifactDetail,
        ) -> Self {
            self.provisioning_artifact_detail = Some(input);
            self
        }
        /// <p>Information about the provisioning artifact.</p>
        pub fn set_provisioning_artifact_detail(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactDetail>,
        ) -> Self {
            self.provisioning_artifact_detail = input;
            self
        }
        /// Adds a key-value pair to `info`.
        ///
        /// To override the contents of this collection use [`set_info`](Self::set_info).
        ///
        /// <p>Specify the template source with one of the following options, but not both. Keys
        /// accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>
        /// <p>The URL of the CloudFormation template in Amazon S3, in JSON format. </p>
        /// <p>
        /// <code>LoadTemplateFromURL</code>
        /// </p>
        /// <p>Use the URL of the CloudFormation template in Amazon S3 in JSON format.</p>
        /// <p>
        /// <code>ImportFromPhysicalId</code>
        /// </p>
        /// <p>Use the physical id of the resource that contains the template; currently supports
        /// CloudFormation stack ARN.</p>
        pub fn info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.info = Some(hash_map);
            self
        }
        /// <p>Specify the template source with one of the following options, but not both. Keys
        /// accepted: [ <code>LoadTemplateFromURL</code>, <code>ImportFromPhysicalId</code> ].</p>
        /// <p>The URL of the CloudFormation template in Amazon S3, in JSON format. </p>
        /// <p>
        /// <code>LoadTemplateFromURL</code>
        /// </p>
        /// <p>Use the URL of the CloudFormation template in Amazon S3 in JSON format.</p>
        /// <p>
        /// <code>ImportFromPhysicalId</code>
        /// </p>
        /// <p>Use the physical id of the resource that contains the template; currently supports
        /// CloudFormation stack ARN.</p>
        pub fn set_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.info = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningArtifactOutput`](crate::output::CreateProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::CreateProvisioningArtifactOutput {
            crate::output::CreateProvisioningArtifactOutput {
                provisioning_artifact_detail: self.provisioning_artifact_detail,
                info: self.info,
                status: self.status,
            }
        }
    }
}
impl CreateProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningArtifactOutput`](crate::output::CreateProvisioningArtifactOutput)
    pub fn builder() -> crate::output::create_provisioning_artifact_output::Builder {
        crate::output::create_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProvisionedProductPlanOutput {
    /// <p>The name of the plan.</p>
    pub plan_name: std::option::Option<std::string::String>,
    /// <p>The plan identifier.</p>
    pub plan_id: std::option::Option<std::string::String>,
    /// <p>The product identifier.</p>
    pub provision_product_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name of the provisioned product.</p>
    pub provisioned_product_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateProvisionedProductPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProvisionedProductPlanOutput");
        formatter.field("plan_name", &self.plan_name);
        formatter.field("plan_id", &self.plan_id);
        formatter.field("provision_product_id", &self.provision_product_id);
        formatter.field("provisioned_product_name", &self.provisioned_product_name);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.finish()
    }
}
/// See [`CreateProvisionedProductPlanOutput`](crate::output::CreateProvisionedProductPlanOutput)
pub mod create_provisioned_product_plan_output {
    /// A builder for [`CreateProvisionedProductPlanOutput`](crate::output::CreateProvisionedProductPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) plan_name: std::option::Option<std::string::String>,
        pub(crate) plan_id: std::option::Option<std::string::String>,
        pub(crate) provision_product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_name: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the plan.</p>
        pub fn plan_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_name = Some(input.into());
            self
        }
        /// <p>The name of the plan.</p>
        pub fn set_plan_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_name = input;
            self
        }
        /// <p>The plan identifier.</p>
        pub fn plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_id = Some(input.into());
            self
        }
        /// <p>The plan identifier.</p>
        pub fn set_plan_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plan_id = input;
            self
        }
        /// <p>The product identifier.</p>
        pub fn provision_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provision_product_id = Some(input.into());
            self
        }
        /// <p>The product identifier.</p>
        pub fn set_provision_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provision_product_id = input;
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn provisioned_product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_name = Some(input.into());
            self
        }
        /// <p>The user-friendly name of the provisioned product.</p>
        pub fn set_provisioned_product_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_name = input;
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisionedProductPlanOutput`](crate::output::CreateProvisionedProductPlanOutput)
        pub fn build(self) -> crate::output::CreateProvisionedProductPlanOutput {
            crate::output::CreateProvisionedProductPlanOutput {
                plan_name: self.plan_name,
                plan_id: self.plan_id,
                provision_product_id: self.provision_product_id,
                provisioned_product_name: self.provisioned_product_name,
                provisioning_artifact_id: self.provisioning_artifact_id,
            }
        }
    }
}
impl CreateProvisionedProductPlanOutput {
    /// Creates a new builder-style object to manufacture [`CreateProvisionedProductPlanOutput`](crate::output::CreateProvisionedProductPlanOutput)
    pub fn builder() -> crate::output::create_provisioned_product_plan_output::Builder {
        crate::output::create_provisioned_product_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProductOutput {
    /// <p>Information about the product view.</p>
    pub product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
    /// <p>Information about the provisioning artifact. </p>
    pub provisioning_artifact_detail: std::option::Option<crate::model::ProvisioningArtifactDetail>,
    /// <p>Information about the tags associated with the product.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProductOutput");
        formatter.field("product_view_detail", &self.product_view_detail);
        formatter.field(
            "provisioning_artifact_detail",
            &self.provisioning_artifact_detail,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateProductOutput`](crate::output::CreateProductOutput)
pub mod create_product_output {
    /// A builder for [`CreateProductOutput`](crate::output::CreateProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_view_detail: std::option::Option<crate::model::ProductViewDetail>,
        pub(crate) provisioning_artifact_detail:
            std::option::Option<crate::model::ProvisioningArtifactDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Information about the product view.</p>
        pub fn product_view_detail(mut self, input: crate::model::ProductViewDetail) -> Self {
            self.product_view_detail = Some(input);
            self
        }
        /// <p>Information about the product view.</p>
        pub fn set_product_view_detail(
            mut self,
            input: std::option::Option<crate::model::ProductViewDetail>,
        ) -> Self {
            self.product_view_detail = input;
            self
        }
        /// <p>Information about the provisioning artifact. </p>
        pub fn provisioning_artifact_detail(
            mut self,
            input: crate::model::ProvisioningArtifactDetail,
        ) -> Self {
            self.provisioning_artifact_detail = Some(input);
            self
        }
        /// <p>Information about the provisioning artifact. </p>
        pub fn set_provisioning_artifact_detail(
            mut self,
            input: std::option::Option<crate::model::ProvisioningArtifactDetail>,
        ) -> Self {
            self.provisioning_artifact_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the product.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the product.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProductOutput`](crate::output::CreateProductOutput)
        pub fn build(self) -> crate::output::CreateProductOutput {
            crate::output::CreateProductOutput {
                product_view_detail: self.product_view_detail,
                provisioning_artifact_detail: self.provisioning_artifact_detail,
                tags: self.tags,
            }
        }
    }
}
impl CreateProductOutput {
    /// Creates a new builder-style object to manufacture [`CreateProductOutput`](crate::output::CreateProductOutput)
    pub fn builder() -> crate::output::create_product_output::Builder {
        crate::output::create_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePortfolioShareOutput {
    /// <p>The portfolio shares a unique identifier that only returns if the portfolio is shared to an organization node.</p>
    pub portfolio_share_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreatePortfolioShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePortfolioShareOutput");
        formatter.field("portfolio_share_token", &self.portfolio_share_token);
        formatter.finish()
    }
}
/// See [`CreatePortfolioShareOutput`](crate::output::CreatePortfolioShareOutput)
pub mod create_portfolio_share_output {
    /// A builder for [`CreatePortfolioShareOutput`](crate::output::CreatePortfolioShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_share_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The portfolio shares a unique identifier that only returns if the portfolio is shared to an organization node.</p>
        pub fn portfolio_share_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.portfolio_share_token = Some(input.into());
            self
        }
        /// <p>The portfolio shares a unique identifier that only returns if the portfolio is shared to an organization node.</p>
        pub fn set_portfolio_share_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portfolio_share_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortfolioShareOutput`](crate::output::CreatePortfolioShareOutput)
        pub fn build(self) -> crate::output::CreatePortfolioShareOutput {
            crate::output::CreatePortfolioShareOutput {
                portfolio_share_token: self.portfolio_share_token,
            }
        }
    }
}
impl CreatePortfolioShareOutput {
    /// Creates a new builder-style object to manufacture [`CreatePortfolioShareOutput`](crate::output::CreatePortfolioShareOutput)
    pub fn builder() -> crate::output::create_portfolio_share_output::Builder {
        crate::output::create_portfolio_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePortfolioOutput {
    /// <p>Information about the portfolio.</p>
    pub portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
    /// <p>Information about the tags associated with the portfolio.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreatePortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePortfolioOutput");
        formatter.field("portfolio_detail", &self.portfolio_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreatePortfolioOutput`](crate::output::CreatePortfolioOutput)
pub mod create_portfolio_output {
    /// A builder for [`CreatePortfolioOutput`](crate::output::CreatePortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portfolio_detail: std::option::Option<crate::model::PortfolioDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Information about the portfolio.</p>
        pub fn portfolio_detail(mut self, input: crate::model::PortfolioDetail) -> Self {
            self.portfolio_detail = Some(input);
            self
        }
        /// <p>Information about the portfolio.</p>
        pub fn set_portfolio_detail(
            mut self,
            input: std::option::Option<crate::model::PortfolioDetail>,
        ) -> Self {
            self.portfolio_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags associated with the portfolio.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortfolioOutput`](crate::output::CreatePortfolioOutput)
        pub fn build(self) -> crate::output::CreatePortfolioOutput {
            crate::output::CreatePortfolioOutput {
                portfolio_detail: self.portfolio_detail,
                tags: self.tags,
            }
        }
    }
}
impl CreatePortfolioOutput {
    /// Creates a new builder-style object to manufacture [`CreatePortfolioOutput`](crate::output::CreatePortfolioOutput)
    pub fn builder() -> crate::output::create_portfolio_output::Builder {
        crate::output::create_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConstraintOutput {
    /// <p>Information about the constraint.</p>
    pub constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
    /// <p>The constraint parameters.</p>
    pub constraint_parameters: std::option::Option<std::string::String>,
    /// <p>The status of the current request.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for CreateConstraintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConstraintOutput");
        formatter.field("constraint_detail", &self.constraint_detail);
        formatter.field("constraint_parameters", &self.constraint_parameters);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateConstraintOutput`](crate::output::CreateConstraintOutput)
pub mod create_constraint_output {
    /// A builder for [`CreateConstraintOutput`](crate::output::CreateConstraintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraint_detail: std::option::Option<crate::model::ConstraintDetail>,
        pub(crate) constraint_parameters: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Information about the constraint.</p>
        pub fn constraint_detail(mut self, input: crate::model::ConstraintDetail) -> Self {
            self.constraint_detail = Some(input);
            self
        }
        /// <p>Information about the constraint.</p>
        pub fn set_constraint_detail(
            mut self,
            input: std::option::Option<crate::model::ConstraintDetail>,
        ) -> Self {
            self.constraint_detail = input;
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn constraint_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_parameters = Some(input.into());
            self
        }
        /// <p>The constraint parameters.</p>
        pub fn set_constraint_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_parameters = input;
            self
        }
        /// <p>The status of the current request.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the current request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConstraintOutput`](crate::output::CreateConstraintOutput)
        pub fn build(self) -> crate::output::CreateConstraintOutput {
            crate::output::CreateConstraintOutput {
                constraint_detail: self.constraint_detail,
                constraint_parameters: self.constraint_parameters,
                status: self.status,
            }
        }
    }
}
impl CreateConstraintOutput {
    /// Creates a new builder-style object to manufacture [`CreateConstraintOutput`](crate::output::CreateConstraintOutput)
    pub fn builder() -> crate::output::create_constraint_output::Builder {
        crate::output::create_constraint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyProductOutput {
    /// <p>The token to use to track the progress of the operation.</p>
    pub copy_product_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CopyProductOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyProductOutput");
        formatter.field("copy_product_token", &self.copy_product_token);
        formatter.finish()
    }
}
/// See [`CopyProductOutput`](crate::output::CopyProductOutput)
pub mod copy_product_output {
    /// A builder for [`CopyProductOutput`](crate::output::CopyProductOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_product_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to use to track the progress of the operation.</p>
        pub fn copy_product_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_product_token = Some(input.into());
            self
        }
        /// <p>The token to use to track the progress of the operation.</p>
        pub fn set_copy_product_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_product_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyProductOutput`](crate::output::CopyProductOutput)
        pub fn build(self) -> crate::output::CopyProductOutput {
            crate::output::CopyProductOutput {
                copy_product_token: self.copy_product_token,
            }
        }
    }
}
impl CopyProductOutput {
    /// Creates a new builder-style object to manufacture [`CopyProductOutput`](crate::output::CopyProductOutput)
    pub fn builder() -> crate::output::copy_product_output::Builder {
        crate::output::copy_product_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateServiceActionFromProvisioningArtifactOutput {
    /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
    pub failed_service_action_associations:
        std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
}
impl std::fmt::Debug for BatchDisassociateServiceActionFromProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchDisassociateServiceActionFromProvisioningArtifactOutput");
        formatter.field(
            "failed_service_action_associations",
            &self.failed_service_action_associations,
        );
        formatter.finish()
    }
}
/// See [`BatchDisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput)
pub mod batch_disassociate_service_action_from_provisioning_artifact_output {
    /// A builder for [`BatchDisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_service_action_associations:
            std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
    }
    impl Builder {
        /// Appends an item to `failed_service_action_associations`.
        ///
        /// To override the contents of this collection use [`set_failed_service_action_associations`](Self::set_failed_service_action_associations).
        ///
        /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
        pub fn failed_service_action_associations(
            mut self,
            input: impl Into<crate::model::FailedServiceActionAssociation>,
        ) -> Self {
            let mut v = self.failed_service_action_associations.unwrap_or_default();
            v.push(input.into());
            self.failed_service_action_associations = Some(v);
            self
        }
        /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
        pub fn set_failed_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
        ) -> Self {
            self.failed_service_action_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput)
        pub fn build(
            self,
        ) -> crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput {
            crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput {
                failed_service_action_associations: self.failed_service_action_associations,
            }
        }
    }
}
impl BatchDisassociateServiceActionFromProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateServiceActionFromProvisioningArtifactOutput`](crate::output::BatchDisassociateServiceActionFromProvisioningArtifactOutput)
    pub fn builder(
    ) -> crate::output::batch_disassociate_service_action_from_provisioning_artifact_output::Builder
    {
        crate::output::batch_disassociate_service_action_from_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateServiceActionWithProvisioningArtifactOutput {
    /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
    pub failed_service_action_associations:
        std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
}
impl std::fmt::Debug for BatchAssociateServiceActionWithProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchAssociateServiceActionWithProvisioningArtifactOutput");
        formatter.field(
            "failed_service_action_associations",
            &self.failed_service_action_associations,
        );
        formatter.finish()
    }
}
/// See [`BatchAssociateServiceActionWithProvisioningArtifactOutput`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput)
pub mod batch_associate_service_action_with_provisioning_artifact_output {
    /// A builder for [`BatchAssociateServiceActionWithProvisioningArtifactOutput`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_service_action_associations:
            std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
    }
    impl Builder {
        /// Appends an item to `failed_service_action_associations`.
        ///
        /// To override the contents of this collection use [`set_failed_service_action_associations`](Self::set_failed_service_action_associations).
        ///
        /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
        pub fn failed_service_action_associations(
            mut self,
            input: impl Into<crate::model::FailedServiceActionAssociation>,
        ) -> Self {
            let mut v = self.failed_service_action_associations.unwrap_or_default();
            v.push(input.into());
            self.failed_service_action_associations = Some(v);
            self
        }
        /// <p>An object that contains a list of errors, along with information to help you identify the self-service action.</p>
        pub fn set_failed_service_action_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedServiceActionAssociation>>,
        ) -> Self {
            self.failed_service_action_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateServiceActionWithProvisioningArtifactOutput`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput)
        pub fn build(
            self,
        ) -> crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput {
            crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput {
                failed_service_action_associations: self.failed_service_action_associations,
            }
        }
    }
}
impl BatchAssociateServiceActionWithProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateServiceActionWithProvisioningArtifactOutput`](crate::output::BatchAssociateServiceActionWithProvisioningArtifactOutput)
    pub fn builder(
    ) -> crate::output::batch_associate_service_action_with_provisioning_artifact_output::Builder
    {
        crate::output::batch_associate_service_action_with_provisioning_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTagOptionWithResourceOutput {}
impl std::fmt::Debug for AssociateTagOptionWithResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTagOptionWithResourceOutput");
        formatter.finish()
    }
}
/// See [`AssociateTagOptionWithResourceOutput`](crate::output::AssociateTagOptionWithResourceOutput)
pub mod associate_tag_option_with_resource_output {
    /// A builder for [`AssociateTagOptionWithResourceOutput`](crate::output::AssociateTagOptionWithResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateTagOptionWithResourceOutput`](crate::output::AssociateTagOptionWithResourceOutput)
        pub fn build(self) -> crate::output::AssociateTagOptionWithResourceOutput {
            crate::output::AssociateTagOptionWithResourceOutput {}
        }
    }
}
impl AssociateTagOptionWithResourceOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTagOptionWithResourceOutput`](crate::output::AssociateTagOptionWithResourceOutput)
    pub fn builder() -> crate::output::associate_tag_option_with_resource_output::Builder {
        crate::output::associate_tag_option_with_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateServiceActionWithProvisioningArtifactOutput {}
impl std::fmt::Debug for AssociateServiceActionWithProvisioningArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateServiceActionWithProvisioningArtifactOutput");
        formatter.finish()
    }
}
/// See [`AssociateServiceActionWithProvisioningArtifactOutput`](crate::output::AssociateServiceActionWithProvisioningArtifactOutput)
pub mod associate_service_action_with_provisioning_artifact_output {
    /// A builder for [`AssociateServiceActionWithProvisioningArtifactOutput`](crate::output::AssociateServiceActionWithProvisioningArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateServiceActionWithProvisioningArtifactOutput`](crate::output::AssociateServiceActionWithProvisioningArtifactOutput)
        pub fn build(self) -> crate::output::AssociateServiceActionWithProvisioningArtifactOutput {
            crate::output::AssociateServiceActionWithProvisioningArtifactOutput {}
        }
    }
}
impl AssociateServiceActionWithProvisioningArtifactOutput {
    /// Creates a new builder-style object to manufacture [`AssociateServiceActionWithProvisioningArtifactOutput`](crate::output::AssociateServiceActionWithProvisioningArtifactOutput)
    pub fn builder(
    ) -> crate::output::associate_service_action_with_provisioning_artifact_output::Builder {
        crate::output::associate_service_action_with_provisioning_artifact_output::Builder::default(
        )
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateProductWithPortfolioOutput {}
impl std::fmt::Debug for AssociateProductWithPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateProductWithPortfolioOutput");
        formatter.finish()
    }
}
/// See [`AssociateProductWithPortfolioOutput`](crate::output::AssociateProductWithPortfolioOutput)
pub mod associate_product_with_portfolio_output {
    /// A builder for [`AssociateProductWithPortfolioOutput`](crate::output::AssociateProductWithPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateProductWithPortfolioOutput`](crate::output::AssociateProductWithPortfolioOutput)
        pub fn build(self) -> crate::output::AssociateProductWithPortfolioOutput {
            crate::output::AssociateProductWithPortfolioOutput {}
        }
    }
}
impl AssociateProductWithPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`AssociateProductWithPortfolioOutput`](crate::output::AssociateProductWithPortfolioOutput)
    pub fn builder() -> crate::output::associate_product_with_portfolio_output::Builder {
        crate::output::associate_product_with_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePrincipalWithPortfolioOutput {}
impl std::fmt::Debug for AssociatePrincipalWithPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePrincipalWithPortfolioOutput");
        formatter.finish()
    }
}
/// See [`AssociatePrincipalWithPortfolioOutput`](crate::output::AssociatePrincipalWithPortfolioOutput)
pub mod associate_principal_with_portfolio_output {
    /// A builder for [`AssociatePrincipalWithPortfolioOutput`](crate::output::AssociatePrincipalWithPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociatePrincipalWithPortfolioOutput`](crate::output::AssociatePrincipalWithPortfolioOutput)
        pub fn build(self) -> crate::output::AssociatePrincipalWithPortfolioOutput {
            crate::output::AssociatePrincipalWithPortfolioOutput {}
        }
    }
}
impl AssociatePrincipalWithPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`AssociatePrincipalWithPortfolioOutput`](crate::output::AssociatePrincipalWithPortfolioOutput)
    pub fn builder() -> crate::output::associate_principal_with_portfolio_output::Builder {
        crate::output::associate_principal_with_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateBudgetWithResourceOutput {}
impl std::fmt::Debug for AssociateBudgetWithResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateBudgetWithResourceOutput");
        formatter.finish()
    }
}
/// See [`AssociateBudgetWithResourceOutput`](crate::output::AssociateBudgetWithResourceOutput)
pub mod associate_budget_with_resource_output {
    /// A builder for [`AssociateBudgetWithResourceOutput`](crate::output::AssociateBudgetWithResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateBudgetWithResourceOutput`](crate::output::AssociateBudgetWithResourceOutput)
        pub fn build(self) -> crate::output::AssociateBudgetWithResourceOutput {
            crate::output::AssociateBudgetWithResourceOutput {}
        }
    }
}
impl AssociateBudgetWithResourceOutput {
    /// Creates a new builder-style object to manufacture [`AssociateBudgetWithResourceOutput`](crate::output::AssociateBudgetWithResourceOutput)
    pub fn builder() -> crate::output::associate_budget_with_resource_output::Builder {
        crate::output::associate_budget_with_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptPortfolioShareOutput {}
impl std::fmt::Debug for AcceptPortfolioShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptPortfolioShareOutput");
        formatter.finish()
    }
}
/// See [`AcceptPortfolioShareOutput`](crate::output::AcceptPortfolioShareOutput)
pub mod accept_portfolio_share_output {
    /// A builder for [`AcceptPortfolioShareOutput`](crate::output::AcceptPortfolioShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AcceptPortfolioShareOutput`](crate::output::AcceptPortfolioShareOutput)
        pub fn build(self) -> crate::output::AcceptPortfolioShareOutput {
            crate::output::AcceptPortfolioShareOutput {}
        }
    }
}
impl AcceptPortfolioShareOutput {
    /// Creates a new builder-style object to manufacture [`AcceptPortfolioShareOutput`](crate::output::AcceptPortfolioShareOutput)
    pub fn builder() -> crate::output::accept_portfolio_share_output::Builder {
        crate::output::accept_portfolio_share_output::Builder::default()
    }
}
