// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptPortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptPortfolioShareError {
    /// Kind of error that occurred.
    pub kind: AcceptPortfolioShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptPortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptPortfolioShareErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptPortfolioShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptPortfolioShareErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            AcceptPortfolioShareErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AcceptPortfolioShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptPortfolioShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptPortfolioShareError {
    fn code(&self) -> Option<&str> {
        AcceptPortfolioShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptPortfolioShareError {
    /// Creates a new `AcceptPortfolioShareError`.
    pub fn new(kind: AcceptPortfolioShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptPortfolioShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptPortfolioShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptPortfolioShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptPortfolioShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AcceptPortfolioShareErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptPortfolioShareErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `AcceptPortfolioShareErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptPortfolioShareErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AcceptPortfolioShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptPortfolioShareErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AcceptPortfolioShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptPortfolioShareErrorKind::InvalidParametersException(_inner) => Some(_inner),
            AcceptPortfolioShareErrorKind::LimitExceededException(_inner) => Some(_inner),
            AcceptPortfolioShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptPortfolioShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateBudgetWithResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateBudgetWithResourceError {
    /// Kind of error that occurred.
    pub kind: AssociateBudgetWithResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateBudgetWithResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateBudgetWithResourceErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateBudgetWithResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateBudgetWithResourceErrorKind::DuplicateResourceException(_inner) => {
                _inner.fmt(f)
            }
            AssociateBudgetWithResourceErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            AssociateBudgetWithResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateBudgetWithResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateBudgetWithResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateBudgetWithResourceError {
    fn code(&self) -> Option<&str> {
        AssociateBudgetWithResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateBudgetWithResourceError {
    /// Creates a new `AssociateBudgetWithResourceError`.
    pub fn new(kind: AssociateBudgetWithResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateBudgetWithResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateBudgetWithResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateBudgetWithResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateBudgetWithResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateBudgetWithResourceErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBudgetWithResourceErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `AssociateBudgetWithResourceErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBudgetWithResourceErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `AssociateBudgetWithResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBudgetWithResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociateBudgetWithResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBudgetWithResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateBudgetWithResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateBudgetWithResourceErrorKind::DuplicateResourceException(_inner) => {
                Some(_inner)
            }
            AssociateBudgetWithResourceErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            AssociateBudgetWithResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateBudgetWithResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateBudgetWithResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociatePrincipalWithPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePrincipalWithPortfolioError {
    /// Kind of error that occurred.
    pub kind: AssociatePrincipalWithPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePrincipalWithPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePrincipalWithPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePrincipalWithPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePrincipalWithPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePrincipalWithPortfolioErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePrincipalWithPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePrincipalWithPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePrincipalWithPortfolioError {
    fn code(&self) -> Option<&str> {
        AssociatePrincipalWithPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePrincipalWithPortfolioError {
    /// Creates a new `AssociatePrincipalWithPortfolioError`.
    pub fn new(
        kind: AssociatePrincipalWithPortfolioErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePrincipalWithPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePrincipalWithPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePrincipalWithPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePrincipalWithPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociatePrincipalWithPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePrincipalWithPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `AssociatePrincipalWithPortfolioErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePrincipalWithPortfolioErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociatePrincipalWithPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePrincipalWithPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociatePrincipalWithPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePrincipalWithPortfolioErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            AssociatePrincipalWithPortfolioErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            AssociatePrincipalWithPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociatePrincipalWithPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateProductWithPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateProductWithPortfolioError {
    /// Kind of error that occurred.
    pub kind: AssociateProductWithPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateProductWithPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateProductWithPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateProductWithPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateProductWithPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProductWithPortfolioErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateProductWithPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProductWithPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateProductWithPortfolioError {
    fn code(&self) -> Option<&str> {
        AssociateProductWithPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateProductWithPortfolioError {
    /// Creates a new `AssociateProductWithPortfolioError`.
    pub fn new(
        kind: AssociateProductWithPortfolioErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateProductWithPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateProductWithPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateProductWithPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateProductWithPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateProductWithPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProductWithPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `AssociateProductWithPortfolioErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProductWithPortfolioErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociateProductWithPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProductWithPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateProductWithPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateProductWithPortfolioErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            AssociateProductWithPortfolioErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateProductWithPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateProductWithPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateServiceActionWithProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateServiceActionWithProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: AssociateServiceActionWithProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateServiceActionWithProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateServiceActionWithProvisioningArtifactErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateServiceActionWithProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateServiceActionWithProvisioningArtifactErrorKind::DuplicateResourceException(
                _inner,
            ) => _inner.fmt(f),
            AssociateServiceActionWithProvisioningArtifactErrorKind::LimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            AssociateServiceActionWithProvisioningArtifactErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            AssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for AssociateServiceActionWithProvisioningArtifactError
{
    fn code(&self) -> Option<&str> {
        AssociateServiceActionWithProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateServiceActionWithProvisioningArtifactError {
    /// Creates a new `AssociateServiceActionWithProvisioningArtifactError`.
    pub fn new(
        kind: AssociateServiceActionWithProvisioningArtifactErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateServiceActionWithProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateServiceActionWithProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateServiceActionWithProvisioningArtifactErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceActionWithProvisioningArtifactErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `AssociateServiceActionWithProvisioningArtifactErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceActionWithProvisioningArtifactErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociateServiceActionWithProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceActionWithProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateServiceActionWithProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateServiceActionWithProvisioningArtifactErrorKind::DuplicateResourceException(
                _inner,
            ) => Some(_inner),
            AssociateServiceActionWithProvisioningArtifactErrorKind::LimitExceededException(
                _inner,
            ) => Some(_inner),
            AssociateServiceActionWithProvisioningArtifactErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            AssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateTagOptionWithResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateTagOptionWithResourceError {
    /// Kind of error that occurred.
    pub kind: AssociateTagOptionWithResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateTagOptionWithResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateTagOptionWithResourceErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateTagOptionWithResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateTagOptionWithResourceErrorKind::DuplicateResourceException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTagOptionWithResourceErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTagOptionWithResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            AssociateTagOptionWithResourceErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTagOptionWithResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTagOptionWithResourceErrorKind::TagOptionNotMigratedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateTagOptionWithResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateTagOptionWithResourceError {
    fn code(&self) -> Option<&str> {
        AssociateTagOptionWithResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateTagOptionWithResourceError {
    /// Creates a new `AssociateTagOptionWithResourceError`.
    pub fn new(
        kind: AssociateTagOptionWithResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateTagOptionWithResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateTagOptionWithResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateTagOptionWithResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateTagOptionWithResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateTagOptionWithResourceErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTagOptionWithResourceErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for AssociateTagOptionWithResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateTagOptionWithResourceErrorKind::DuplicateResourceException(_inner) => {
                Some(_inner)
            }
            AssociateTagOptionWithResourceErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            AssociateTagOptionWithResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            AssociateTagOptionWithResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateTagOptionWithResourceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateTagOptionWithResourceErrorKind::TagOptionNotMigratedException(_inner) => {
                Some(_inner)
            }
            AssociateTagOptionWithResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchAssociateServiceActionWithProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateServiceActionWithProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateServiceActionWithProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateServiceActionWithProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateServiceActionWithProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateServiceActionWithProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateServiceActionWithProvisioningArtifactErrorKind::InvalidParametersException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchAssociateServiceActionWithProvisioningArtifactError
{
    fn code(&self) -> Option<&str> {
        BatchAssociateServiceActionWithProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateServiceActionWithProvisioningArtifactError {
    /// Creates a new `BatchAssociateServiceActionWithProvisioningArtifactError`.
    pub fn new(
        kind: BatchAssociateServiceActionWithProvisioningArtifactErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateServiceActionWithProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateServiceActionWithProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchAssociateServiceActionWithProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateServiceActionWithProvisioningArtifactErrorKind::InvalidParametersException(_))
    }
}
impl std::error::Error for BatchAssociateServiceActionWithProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateServiceActionWithProvisioningArtifactErrorKind::InvalidParametersException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateServiceActionWithProvisioningArtifactErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchDisassociateServiceActionFromProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateServiceActionFromProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateServiceActionFromProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateServiceActionFromProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateServiceActionFromProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateServiceActionFromProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::InvalidParametersException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchDisassociateServiceActionFromProvisioningArtifactError
{
    fn code(&self) -> Option<&str> {
        BatchDisassociateServiceActionFromProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateServiceActionFromProvisioningArtifactError {
    /// Creates a new `BatchDisassociateServiceActionFromProvisioningArtifactError`.
    pub fn new(
        kind: BatchDisassociateServiceActionFromProvisioningArtifactErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateServiceActionFromProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateServiceActionFromProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::InvalidParametersException(_))
    }
}
impl std::error::Error for BatchDisassociateServiceActionFromProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::InvalidParametersException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CopyProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyProductError {
    /// Kind of error that occurred.
    pub kind: CopyProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CopyProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CopyProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyProductError {
    fn code(&self) -> Option<&str> {
        CopyProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyProductError {
    /// Creates a new `CopyProductError`.
    pub fn new(kind: CopyProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CopyProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CopyProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CopyProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CopyProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CopyProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConstraintError {
    /// Kind of error that occurred.
    pub kind: CreateConstraintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConstraintErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConstraintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConstraintErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateConstraintErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CreateConstraintErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateConstraintErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConstraintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConstraintError {
    fn code(&self) -> Option<&str> {
        CreateConstraintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConstraintError {
    /// Creates a new `CreateConstraintError`.
    pub fn new(kind: CreateConstraintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConstraintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConstraintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConstraintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConstraintErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConstraintErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConstraintErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `CreateConstraintErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConstraintErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreateConstraintErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConstraintErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateConstraintErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConstraintErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateConstraintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConstraintErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateConstraintErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreateConstraintErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateConstraintErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConstraintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePortfolioError {
    /// Kind of error that occurred.
    pub kind: CreatePortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePortfolioErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CreatePortfolioErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePortfolioErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            CreatePortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePortfolioError {
    fn code(&self) -> Option<&str> {
        CreatePortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePortfolioError {
    /// Creates a new `CreatePortfolioError`.
    pub fn new(kind: CreatePortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for CreatePortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePortfolioErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreatePortfolioErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePortfolioErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            CreatePortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePortfolioShareError {
    /// Kind of error that occurred.
    pub kind: CreatePortfolioShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePortfolioShareErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePortfolioShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePortfolioShareErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CreatePortfolioShareErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            CreatePortfolioShareErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePortfolioShareErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            CreatePortfolioShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePortfolioShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePortfolioShareError {
    fn code(&self) -> Option<&str> {
        CreatePortfolioShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePortfolioShareError {
    /// Creates a new `CreatePortfolioShareError`.
    pub fn new(kind: CreatePortfolioShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePortfolioShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePortfolioShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePortfolioShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePortfolioShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePortfolioShareErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioShareErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioShareErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioShareErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioShareErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioShareErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioShareErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioShareErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortfolioShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortfolioShareErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreatePortfolioShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePortfolioShareErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreatePortfolioShareErrorKind::InvalidStateException(_inner) => Some(_inner),
            CreatePortfolioShareErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePortfolioShareErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            CreatePortfolioShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePortfolioShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProductError {
    /// Kind of error that occurred.
    pub kind: CreateProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CreateProductErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProductErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            CreateProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProductError {
    fn code(&self) -> Option<&str> {
        CreateProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProductError {
    /// Creates a new `CreateProductError`.
    pub fn new(kind: CreateProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreateProductErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProductErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProductErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProductErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for CreateProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreateProductErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProductErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            CreateProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProvisionedProductPlanError {
    /// Kind of error that occurred.
    pub kind: CreateProvisionedProductPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProvisionedProductPlanErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProvisionedProductPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisionedProductPlanErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            CreateProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisionedProductPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProvisionedProductPlanError {
    fn code(&self) -> Option<&str> {
        CreateProvisionedProductPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProvisionedProductPlanError {
    /// Creates a new `CreateProvisionedProductPlanError`.
    pub fn new(kind: CreateProvisionedProductPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProvisionedProductPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProvisionedProductPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProvisionedProductPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProvisionedProductPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProvisionedProductPlanErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisionedProductPlanErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreateProvisionedProductPlanErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisionedProductPlanErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `CreateProvisionedProductPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisionedProductPlanErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateProvisionedProductPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            CreateProvisionedProductPlanErrorKind::InvalidStateException(_inner) => Some(_inner),
            CreateProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateProvisionedProductPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: CreateProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProvisioningArtifactErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningArtifactErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProvisioningArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProvisioningArtifactError {
    fn code(&self) -> Option<&str> {
        CreateProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProvisioningArtifactError {
    /// Creates a new `CreateProvisioningArtifactError`.
    pub fn new(kind: CreateProvisioningArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningArtifactErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreateProvisioningArtifactErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningArtifactErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProvisioningArtifactErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreateProvisioningArtifactErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProvisioningArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceActionError {
    /// Kind of error that occurred.
    pub kind: CreateServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceActionErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceActionErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            CreateServiceActionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceActionError {
    fn code(&self) -> Option<&str> {
        CreateServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceActionError {
    /// Creates a new `CreateServiceActionError`.
    pub fn new(kind: CreateServiceActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateServiceActionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceActionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `CreateServiceActionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceActionErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceActionErrorKind::InvalidParametersException(_inner) => Some(_inner),
            CreateServiceActionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateServiceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagOptionError {
    /// Kind of error that occurred.
    pub kind: CreateTagOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagOptionErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagOptionErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateTagOptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTagOptionErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            CreateTagOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagOptionError {
    fn code(&self) -> Option<&str> {
        CreateTagOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagOptionError {
    /// Creates a new `CreateTagOptionError`.
    pub fn new(kind: CreateTagOptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTagOptionErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagOptionErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `CreateTagOptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagOptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateTagOptionErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTagOptionErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for CreateTagOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagOptionErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateTagOptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTagOptionErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            CreateTagOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConstraintError {
    /// Kind of error that occurred.
    pub kind: DeleteConstraintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConstraintErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConstraintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConstraintErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DeleteConstraintErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConstraintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConstraintError {
    fn code(&self) -> Option<&str> {
        DeleteConstraintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConstraintError {
    /// Creates a new `DeleteConstraintError`.
    pub fn new(kind: DeleteConstraintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConstraintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConstraintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConstraintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConstraintErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConstraintErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConstraintErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConstraintErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConstraintErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConstraintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConstraintErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DeleteConstraintErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConstraintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePortfolioError {
    /// Kind of error that occurred.
    pub kind: DeletePortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePortfolioErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DeletePortfolioErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeletePortfolioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePortfolioErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            DeletePortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePortfolioError {
    fn code(&self) -> Option<&str> {
        DeletePortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePortfolioError {
    /// Creates a new `DeletePortfolioError`.
    pub fn new(kind: DeletePortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for DeletePortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePortfolioErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DeletePortfolioErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeletePortfolioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePortfolioErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            DeletePortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePortfolioShareError {
    /// Kind of error that occurred.
    pub kind: DeletePortfolioShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePortfolioShareErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePortfolioShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePortfolioShareErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DeletePortfolioShareErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeletePortfolioShareErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            DeletePortfolioShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePortfolioShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePortfolioShareError {
    fn code(&self) -> Option<&str> {
        DeletePortfolioShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePortfolioShareError {
    /// Creates a new `DeletePortfolioShareError`.
    pub fn new(kind: DeletePortfolioShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePortfolioShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePortfolioShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePortfolioShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePortfolioShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePortfolioShareErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioShareErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioShareErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioShareErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioShareErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioShareErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortfolioShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortfolioShareErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePortfolioShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePortfolioShareErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DeletePortfolioShareErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeletePortfolioShareErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            DeletePortfolioShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePortfolioShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProductError {
    /// Kind of error that occurred.
    pub kind: DeleteProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DeleteProductErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProductErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            DeleteProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProductError {
    fn code(&self) -> Option<&str> {
        DeleteProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProductError {
    /// Creates a new `DeleteProductError`.
    pub fn new(kind: DeleteProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProductErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProductErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProductErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProductErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProductErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for DeleteProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DeleteProductErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProductErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            DeleteProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProvisionedProductPlanError {
    /// Kind of error that occurred.
    pub kind: DeleteProvisionedProductPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProvisionedProductPlanErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProvisionedProductPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedProductPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProvisionedProductPlanError {
    fn code(&self) -> Option<&str> {
        DeleteProvisionedProductPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProvisionedProductPlanError {
    /// Creates a new `DeleteProvisionedProductPlanError`.
    pub fn new(kind: DeleteProvisionedProductPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProvisionedProductPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProvisionedProductPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProvisionedProductPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProvisionedProductPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProvisionedProductPlanErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedProductPlanErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProvisionedProductPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedProductPlanErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteProvisionedProductPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedProductPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: DeleteProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProvisioningArtifactErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningArtifactErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProvisioningArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProvisioningArtifactError {
    fn code(&self) -> Option<&str> {
        DeleteProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProvisioningArtifactError {
    /// Creates a new `DeleteProvisioningArtifactError`.
    pub fn new(kind: DeleteProvisioningArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningArtifactErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProvisioningArtifactErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningArtifactErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProvisioningArtifactErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DeleteProvisioningArtifactErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProvisioningArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceActionError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceActionErrorKind {
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceActionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteServiceActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceActionError {
    fn code(&self) -> Option<&str> {
        DeleteServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceActionError {
    /// Creates a new `DeleteServiceActionError`.
    pub fn new(kind: DeleteServiceActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteServiceActionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceActionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServiceActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceActionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceActionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteServiceActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagOptionError {
    /// Kind of error that occurred.
    pub kind: DeleteTagOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagOptionErrorKind {
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagOptionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteTagOptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTagOptionErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            DeleteTagOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagOptionError {
    fn code(&self) -> Option<&str> {
        DeleteTagOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagOptionError {
    /// Creates a new `DeleteTagOptionError`.
    pub fn new(kind: DeleteTagOptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTagOptionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagOptionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTagOptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagOptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTagOptionErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagOptionErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for DeleteTagOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagOptionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteTagOptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTagOptionErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            DeleteTagOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConstraintError {
    /// Kind of error that occurred.
    pub kind: DescribeConstraintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConstraintErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConstraintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConstraintErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeConstraintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConstraintError {
    fn code(&self) -> Option<&str> {
        DescribeConstraintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConstraintError {
    /// Creates a new `DescribeConstraintError`.
    pub fn new(kind: DescribeConstraintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConstraintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConstraintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConstraintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConstraintErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConstraintErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConstraintErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConstraintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConstraintErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeConstraintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCopyProductStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCopyProductStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeCopyProductStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCopyProductStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCopyProductStatusErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCopyProductStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCopyProductStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCopyProductStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCopyProductStatusError {
    fn code(&self) -> Option<&str> {
        DescribeCopyProductStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCopyProductStatusError {
    /// Creates a new `DescribeCopyProductStatusError`.
    pub fn new(kind: DescribeCopyProductStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCopyProductStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCopyProductStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCopyProductStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCopyProductStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCopyProductStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCopyProductStatusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCopyProductStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCopyProductStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCopyProductStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePortfolioError {
    /// Kind of error that occurred.
    pub kind: DescribePortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePortfolioErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePortfolioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePortfolioError {
    fn code(&self) -> Option<&str> {
        DescribePortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePortfolioError {
    /// Creates a new `DescribePortfolioError`.
    pub fn new(kind: DescribePortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePortfolioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePortfolioShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePortfolioSharesError {
    /// Kind of error that occurred.
    pub kind: DescribePortfolioSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePortfolioShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePortfolioSharesErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePortfolioSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePortfolioSharesErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DescribePortfolioSharesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePortfolioSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePortfolioSharesError {
    fn code(&self) -> Option<&str> {
        DescribePortfolioSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePortfolioSharesError {
    /// Creates a new `DescribePortfolioSharesError`.
    pub fn new(kind: DescribePortfolioSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePortfolioSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePortfolioSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePortfolioSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePortfolioSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePortfolioSharesErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioSharesErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortfolioSharesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioSharesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePortfolioSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePortfolioSharesErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DescribePortfolioSharesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePortfolioSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePortfolioShareStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePortfolioShareStatusError {
    /// Kind of error that occurred.
    pub kind: DescribePortfolioShareStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePortfolioShareStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePortfolioShareStatusErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePortfolioShareStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePortfolioShareStatusErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DescribePortfolioShareStatusErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DescribePortfolioShareStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribePortfolioShareStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePortfolioShareStatusError {
    fn code(&self) -> Option<&str> {
        DescribePortfolioShareStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePortfolioShareStatusError {
    /// Creates a new `DescribePortfolioShareStatusError`.
    pub fn new(kind: DescribePortfolioShareStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePortfolioShareStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePortfolioShareStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePortfolioShareStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePortfolioShareStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePortfolioShareStatusErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioShareStatusErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortfolioShareStatusErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioShareStatusErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortfolioShareStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortfolioShareStatusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePortfolioShareStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePortfolioShareStatusErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DescribePortfolioShareStatusErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DescribePortfolioShareStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribePortfolioShareStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProductError {
    /// Kind of error that occurred.
    pub kind: DescribeProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DescribeProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProductError {
    fn code(&self) -> Option<&str> {
        DescribeProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProductError {
    /// Creates a new `DescribeProductError`.
    pub fn new(kind: DescribeProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DescribeProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProductAsAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProductAsAdminError {
    /// Kind of error that occurred.
    pub kind: DescribeProductAsAdminErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProductAsAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProductAsAdminErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProductAsAdminError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProductAsAdminErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DescribeProductAsAdminErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProductAsAdminErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProductAsAdminError {
    fn code(&self) -> Option<&str> {
        DescribeProductAsAdminError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProductAsAdminError {
    /// Creates a new `DescribeProductAsAdminError`.
    pub fn new(kind: DescribeProductAsAdminErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProductAsAdminError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProductAsAdminErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProductAsAdminError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProductAsAdminErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProductAsAdminErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductAsAdminErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProductAsAdminErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductAsAdminErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProductAsAdminError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProductAsAdminErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DescribeProductAsAdminErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProductAsAdminErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProductView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProductViewError {
    /// Kind of error that occurred.
    pub kind: DescribeProductViewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProductView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProductViewErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProductViewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProductViewErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            DescribeProductViewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProductViewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProductViewError {
    fn code(&self) -> Option<&str> {
        DescribeProductViewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProductViewError {
    /// Creates a new `DescribeProductViewError`.
    pub fn new(kind: DescribeProductViewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProductViewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProductViewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProductViewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProductViewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProductViewErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductViewErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProductViewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProductViewErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProductViewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProductViewErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DescribeProductViewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProductViewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisionedProductError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisionedProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisionedProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisionedProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisionedProductErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisionedProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProvisionedProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisionedProductError {
    fn code(&self) -> Option<&str> {
        DescribeProvisionedProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisionedProductError {
    /// Creates a new `DescribeProvisionedProductError`.
    pub fn new(kind: DescribeProvisionedProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisionedProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisionedProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisionedProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisionedProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProvisionedProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisionedProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProvisionedProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisionedProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProvisionedProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisionedProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            DescribeProvisionedProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProvisionedProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisionedProductPlanError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisionedProductPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisionedProductPlanErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisionedProductPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisionedProductPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisionedProductPlanError {
    fn code(&self) -> Option<&str> {
        DescribeProvisionedProductPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisionedProductPlanError {
    /// Creates a new `DescribeProvisionedProductPlanError`.
    pub fn new(
        kind: DescribeProvisionedProductPlanErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisionedProductPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisionedProductPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisionedProductPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisionedProductPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProvisionedProductPlanErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisionedProductPlanErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProvisionedProductPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisionedProductPlanErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProvisionedProductPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DescribeProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeProvisionedProductPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisioningArtifactErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisioningArtifactError {
    fn code(&self) -> Option<&str> {
        DescribeProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisioningArtifactError {
    /// Creates a new `DescribeProvisioningArtifactError`.
    pub fn new(kind: DescribeProvisioningArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningArtifactErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisioningArtifactErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisioningParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisioningParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisioningParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisioningParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisioningParametersErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisioningParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisioningParametersErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningParametersErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisioningParametersError {
    fn code(&self) -> Option<&str> {
        DescribeProvisioningParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisioningParametersError {
    /// Creates a new `DescribeProvisioningParametersError`.
    pub fn new(
        kind: DescribeProvisioningParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisioningParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisioningParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisioningParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisioningParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProvisioningParametersErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningParametersErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProvisioningParametersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningParametersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProvisioningParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisioningParametersErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningParametersErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRecordError {
    /// Kind of error that occurred.
    pub kind: DescribeRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRecordErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRecordError {
    fn code(&self) -> Option<&str> {
        DescribeRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRecordError {
    /// Creates a new `DescribeRecordError`.
    pub fn new(kind: DescribeRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRecordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRecordErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceActionError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceActionErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceActionError {
    fn code(&self) -> Option<&str> {
        DescribeServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceActionError {
    /// Creates a new `DescribeServiceActionError`.
    pub fn new(kind: DescribeServiceActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServiceActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceActionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeServiceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServiceActionExecutionParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceActionExecutionParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceActionExecutionParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServiceActionExecutionParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceActionExecutionParametersErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceActionExecutionParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceActionExecutionParametersErrorKind::InvalidParametersException(
                _inner,
            ) => _inner.fmt(f),
            DescribeServiceActionExecutionParametersErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeServiceActionExecutionParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceActionExecutionParametersError {
    fn code(&self) -> Option<&str> {
        DescribeServiceActionExecutionParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceActionExecutionParametersError {
    /// Creates a new `DescribeServiceActionExecutionParametersError`.
    pub fn new(
        kind: DescribeServiceActionExecutionParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceActionExecutionParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceActionExecutionParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceActionExecutionParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceActionExecutionParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServiceActionExecutionParametersErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceActionExecutionParametersErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceActionExecutionParametersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceActionExecutionParametersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeServiceActionExecutionParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceActionExecutionParametersErrorKind::InvalidParametersException(
                _inner,
            ) => Some(_inner),
            DescribeServiceActionExecutionParametersErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeServiceActionExecutionParametersErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagOptionError {
    /// Kind of error that occurred.
    pub kind: DescribeTagOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagOptionErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagOptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagOptionErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            DescribeTagOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagOptionError {
    fn code(&self) -> Option<&str> {
        DescribeTagOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagOptionError {
    /// Creates a new `DescribeTagOptionError`.
    pub fn new(kind: DescribeTagOptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeTagOptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagOptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeTagOptionErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagOptionErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for DescribeTagOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagOptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTagOptionErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            DescribeTagOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableAWSOrganizationsAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableAWSOrganizationsAccessError {
    /// Kind of error that occurred.
    pub kind: DisableAWSOrganizationsAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableAWSOrganizationsAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableAWSOrganizationsAccessErrorKind {
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableAWSOrganizationsAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableAWSOrganizationsAccessErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DisableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            DisableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisableAWSOrganizationsAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableAWSOrganizationsAccessError {
    fn code(&self) -> Option<&str> {
        DisableAWSOrganizationsAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableAWSOrganizationsAccessError {
    /// Creates a new `DisableAWSOrganizationsAccessError`.
    pub fn new(
        kind: DisableAWSOrganizationsAccessErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableAWSOrganizationsAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableAWSOrganizationsAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableAWSOrganizationsAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableAWSOrganizationsAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisableAWSOrganizationsAccessErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSOrganizationsAccessErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `DisableAWSOrganizationsAccessErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `DisableAWSOrganizationsAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableAWSOrganizationsAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableAWSOrganizationsAccessErrorKind::InvalidStateException(_inner) => Some(_inner),
            DisableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            DisableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisableAWSOrganizationsAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateBudgetFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateBudgetFromResourceError {
    /// Kind of error that occurred.
    pub kind: DisassociateBudgetFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateBudgetFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateBudgetFromResourceErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateBudgetFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateBudgetFromResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateBudgetFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateBudgetFromResourceError {
    fn code(&self) -> Option<&str> {
        DisassociateBudgetFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateBudgetFromResourceError {
    /// Creates a new `DisassociateBudgetFromResourceError`.
    pub fn new(
        kind: DisassociateBudgetFromResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateBudgetFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateBudgetFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateBudgetFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateBudgetFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateBudgetFromResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBudgetFromResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateBudgetFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateBudgetFromResourceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateBudgetFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociatePrincipalFromPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePrincipalFromPortfolioError {
    /// Kind of error that occurred.
    pub kind: DisassociatePrincipalFromPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePrincipalFromPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePrincipalFromPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePrincipalFromPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePrincipalFromPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePrincipalFromPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePrincipalFromPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociatePrincipalFromPortfolioError {
    fn code(&self) -> Option<&str> {
        DisassociatePrincipalFromPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePrincipalFromPortfolioError {
    /// Creates a new `DisassociatePrincipalFromPortfolioError`.
    pub fn new(
        kind: DisassociatePrincipalFromPortfolioErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePrincipalFromPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePrincipalFromPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePrincipalFromPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePrincipalFromPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociatePrincipalFromPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePrincipalFromPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DisassociatePrincipalFromPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePrincipalFromPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociatePrincipalFromPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePrincipalFromPortfolioErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DisassociatePrincipalFromPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociatePrincipalFromPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateProductFromPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateProductFromPortfolioError {
    /// Kind of error that occurred.
    pub kind: DisassociateProductFromPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateProductFromPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateProductFromPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateProductFromPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateProductFromPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateProductFromPortfolioErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateProductFromPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateProductFromPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateProductFromPortfolioError {
    fn code(&self) -> Option<&str> {
        DisassociateProductFromPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateProductFromPortfolioError {
    /// Creates a new `DisassociateProductFromPortfolioError`.
    pub fn new(
        kind: DisassociateProductFromPortfolioErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateProductFromPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateProductFromPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateProductFromPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateProductFromPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateProductFromPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateProductFromPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateProductFromPortfolioErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateProductFromPortfolioErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateProductFromPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateProductFromPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateProductFromPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateProductFromPortfolioErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            DisassociateProductFromPortfolioErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            DisassociateProductFromPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateProductFromPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateServiceActionFromProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateServiceActionFromProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: DisassociateServiceActionFromProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateServiceActionFromProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateServiceActionFromProvisioningArtifactErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateServiceActionFromProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateServiceActionFromProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DisassociateServiceActionFromProvisioningArtifactError
{
    fn code(&self) -> Option<&str> {
        DisassociateServiceActionFromProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateServiceActionFromProvisioningArtifactError {
    /// Creates a new `DisassociateServiceActionFromProvisioningArtifactError`.
    pub fn new(
        kind: DisassociateServiceActionFromProvisioningArtifactErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateServiceActionFromProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateServiceActionFromProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateServiceActionFromProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceActionFromProvisioningArtifactErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
}
impl std::error::Error for DisassociateServiceActionFromProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateServiceActionFromProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            DisassociateServiceActionFromProvisioningArtifactErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateTagOptionFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateTagOptionFromResourceError {
    /// Kind of error that occurred.
    pub kind: DisassociateTagOptionFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateTagOptionFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateTagOptionFromResourceErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateTagOptionFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateTagOptionFromResourceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTagOptionFromResourceErrorKind::TagOptionNotMigratedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateTagOptionFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateTagOptionFromResourceError {
    fn code(&self) -> Option<&str> {
        DisassociateTagOptionFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateTagOptionFromResourceError {
    /// Creates a new `DisassociateTagOptionFromResourceError`.
    pub fn new(
        kind: DisassociateTagOptionFromResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateTagOptionFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateTagOptionFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateTagOptionFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateTagOptionFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateTagOptionFromResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTagOptionFromResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateTagOptionFromResourceErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateTagOptionFromResourceErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for DisassociateTagOptionFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateTagOptionFromResourceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateTagOptionFromResourceErrorKind::TagOptionNotMigratedException(_inner) => {
                Some(_inner)
            }
            DisassociateTagOptionFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableAWSOrganizationsAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAWSOrganizationsAccessError {
    /// Kind of error that occurred.
    pub kind: EnableAWSOrganizationsAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAWSOrganizationsAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAWSOrganizationsAccessErrorKind {
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAWSOrganizationsAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAWSOrganizationsAccessErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            EnableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            EnableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            EnableAWSOrganizationsAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAWSOrganizationsAccessError {
    fn code(&self) -> Option<&str> {
        EnableAWSOrganizationsAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAWSOrganizationsAccessError {
    /// Creates a new `EnableAWSOrganizationsAccessError`.
    pub fn new(kind: EnableAWSOrganizationsAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAWSOrganizationsAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAWSOrganizationsAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAWSOrganizationsAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAWSOrganizationsAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `EnableAWSOrganizationsAccessErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSOrganizationsAccessErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `EnableAWSOrganizationsAccessErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `EnableAWSOrganizationsAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableAWSOrganizationsAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAWSOrganizationsAccessErrorKind::InvalidStateException(_inner) => Some(_inner),
            EnableAWSOrganizationsAccessErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            EnableAWSOrganizationsAccessErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            EnableAWSOrganizationsAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteProvisionedProductPlanError {
    /// Kind of error that occurred.
    pub kind: ExecuteProvisionedProductPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteProvisionedProductPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteProvisionedProductPlanErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteProvisionedProductPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteProvisionedProductPlanErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ExecuteProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteProvisionedProductPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteProvisionedProductPlanError {
    fn code(&self) -> Option<&str> {
        ExecuteProvisionedProductPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteProvisionedProductPlanError {
    /// Creates a new `ExecuteProvisionedProductPlanError`.
    pub fn new(
        kind: ExecuteProvisionedProductPlanErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteProvisionedProductPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteProvisionedProductPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteProvisionedProductPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteProvisionedProductPlanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductPlanErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductPlanErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductPlanErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductPlanErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductPlanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductPlanErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ExecuteProvisionedProductPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteProvisionedProductPlanErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ExecuteProvisionedProductPlanErrorKind::InvalidStateException(_inner) => Some(_inner),
            ExecuteProvisionedProductPlanErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ExecuteProvisionedProductPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteProvisionedProductServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteProvisionedProductServiceActionError {
    /// Kind of error that occurred.
    pub kind: ExecuteProvisionedProductServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteProvisionedProductServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteProvisionedProductServiceActionErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteProvisionedProductServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteProvisionedProductServiceActionErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteProvisionedProductServiceActionErrorKind::InvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteProvisionedProductServiceActionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteProvisionedProductServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteProvisionedProductServiceActionError {
    fn code(&self) -> Option<&str> {
        ExecuteProvisionedProductServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteProvisionedProductServiceActionError {
    /// Creates a new `ExecuteProvisionedProductServiceActionError`.
    pub fn new(
        kind: ExecuteProvisionedProductServiceActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteProvisionedProductServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteProvisionedProductServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteProvisionedProductServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteProvisionedProductServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductServiceActionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductServiceActionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductServiceActionErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductServiceActionErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `ExecuteProvisionedProductServiceActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteProvisionedProductServiceActionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ExecuteProvisionedProductServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteProvisionedProductServiceActionErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ExecuteProvisionedProductServiceActionErrorKind::InvalidStateException(_inner) => {
                Some(_inner)
            }
            ExecuteProvisionedProductServiceActionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ExecuteProvisionedProductServiceActionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAWSOrganizationsAccessStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAWSOrganizationsAccessStatusError {
    /// Kind of error that occurred.
    pub kind: GetAWSOrganizationsAccessStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAWSOrganizationsAccessStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAWSOrganizationsAccessStatusErrorKind {
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAWSOrganizationsAccessStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAWSOrganizationsAccessStatusErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            GetAWSOrganizationsAccessStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetAWSOrganizationsAccessStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAWSOrganizationsAccessStatusError {
    fn code(&self) -> Option<&str> {
        GetAWSOrganizationsAccessStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAWSOrganizationsAccessStatusError {
    /// Creates a new `GetAWSOrganizationsAccessStatusError`.
    pub fn new(
        kind: GetAWSOrganizationsAccessStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAWSOrganizationsAccessStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAWSOrganizationsAccessStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAWSOrganizationsAccessStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAWSOrganizationsAccessStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAWSOrganizationsAccessStatusErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSOrganizationsAccessStatusErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `GetAWSOrganizationsAccessStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSOrganizationsAccessStatusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetAWSOrganizationsAccessStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAWSOrganizationsAccessStatusErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            GetAWSOrganizationsAccessStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetAWSOrganizationsAccessStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProvisionedProductOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProvisionedProductOutputsError {
    /// Kind of error that occurred.
    pub kind: GetProvisionedProductOutputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProvisionedProductOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProvisionedProductOutputsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProvisionedProductOutputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProvisionedProductOutputsErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            GetProvisionedProductOutputsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetProvisionedProductOutputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProvisionedProductOutputsError {
    fn code(&self) -> Option<&str> {
        GetProvisionedProductOutputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProvisionedProductOutputsError {
    /// Creates a new `GetProvisionedProductOutputsError`.
    pub fn new(kind: GetProvisionedProductOutputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProvisionedProductOutputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProvisionedProductOutputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProvisionedProductOutputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProvisionedProductOutputsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetProvisionedProductOutputsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedProductOutputsErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `GetProvisionedProductOutputsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedProductOutputsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetProvisionedProductOutputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProvisionedProductOutputsErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            GetProvisionedProductOutputsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetProvisionedProductOutputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportAsProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportAsProvisionedProductError {
    /// Kind of error that occurred.
    pub kind: ImportAsProvisionedProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportAsProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportAsProvisionedProductErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportAsProvisionedProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportAsProvisionedProductErrorKind::DuplicateResourceException(_inner) => {
                _inner.fmt(f)
            }
            ImportAsProvisionedProductErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ImportAsProvisionedProductErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ImportAsProvisionedProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportAsProvisionedProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportAsProvisionedProductError {
    fn code(&self) -> Option<&str> {
        ImportAsProvisionedProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportAsProvisionedProductError {
    /// Creates a new `ImportAsProvisionedProductError`.
    pub fn new(kind: ImportAsProvisionedProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportAsProvisionedProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportAsProvisionedProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportAsProvisionedProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportAsProvisionedProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportAsProvisionedProductErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAsProvisionedProductErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `ImportAsProvisionedProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAsProvisionedProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ImportAsProvisionedProductErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAsProvisionedProductErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `ImportAsProvisionedProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAsProvisionedProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ImportAsProvisionedProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportAsProvisionedProductErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            ImportAsProvisionedProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ImportAsProvisionedProductErrorKind::InvalidStateException(_inner) => Some(_inner),
            ImportAsProvisionedProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportAsProvisionedProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAcceptedPortfolioShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAcceptedPortfolioSharesError {
    /// Kind of error that occurred.
    pub kind: ListAcceptedPortfolioSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAcceptedPortfolioShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAcceptedPortfolioSharesErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAcceptedPortfolioSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAcceptedPortfolioSharesErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ListAcceptedPortfolioSharesErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            ListAcceptedPortfolioSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAcceptedPortfolioSharesError {
    fn code(&self) -> Option<&str> {
        ListAcceptedPortfolioSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAcceptedPortfolioSharesError {
    /// Creates a new `ListAcceptedPortfolioSharesError`.
    pub fn new(kind: ListAcceptedPortfolioSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAcceptedPortfolioSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAcceptedPortfolioSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAcceptedPortfolioSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAcceptedPortfolioSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAcceptedPortfolioSharesErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAcceptedPortfolioSharesErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListAcceptedPortfolioSharesErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAcceptedPortfolioSharesErrorKind::OperationNotSupportedException(_)
        )
    }
}
impl std::error::Error for ListAcceptedPortfolioSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAcceptedPortfolioSharesErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ListAcceptedPortfolioSharesErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            ListAcceptedPortfolioSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBudgetsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBudgetsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListBudgetsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBudgetsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBudgetsForResourceErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBudgetsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBudgetsForResourceErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListBudgetsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBudgetsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBudgetsForResourceError {
    fn code(&self) -> Option<&str> {
        ListBudgetsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBudgetsForResourceError {
    /// Creates a new `ListBudgetsForResourceError`.
    pub fn new(kind: ListBudgetsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBudgetsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBudgetsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBudgetsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBudgetsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListBudgetsForResourceErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBudgetsForResourceErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListBudgetsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBudgetsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListBudgetsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBudgetsForResourceErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListBudgetsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBudgetsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConstraintsForPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConstraintsForPortfolioError {
    /// Kind of error that occurred.
    pub kind: ListConstraintsForPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConstraintsForPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConstraintsForPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConstraintsForPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConstraintsForPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ListConstraintsForPortfolioErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListConstraintsForPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConstraintsForPortfolioError {
    fn code(&self) -> Option<&str> {
        ListConstraintsForPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConstraintsForPortfolioError {
    /// Creates a new `ListConstraintsForPortfolioError`.
    pub fn new(kind: ListConstraintsForPortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConstraintsForPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConstraintsForPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConstraintsForPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConstraintsForPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListConstraintsForPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConstraintsForPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListConstraintsForPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConstraintsForPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListConstraintsForPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConstraintsForPortfolioErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ListConstraintsForPortfolioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListConstraintsForPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLaunchPaths` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLaunchPathsError {
    /// Kind of error that occurred.
    pub kind: ListLaunchPathsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLaunchPaths` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLaunchPathsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLaunchPathsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLaunchPathsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListLaunchPathsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLaunchPathsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLaunchPathsError {
    fn code(&self) -> Option<&str> {
        ListLaunchPathsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLaunchPathsError {
    /// Creates a new `ListLaunchPathsError`.
    pub fn new(kind: ListLaunchPathsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLaunchPathsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLaunchPathsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLaunchPathsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLaunchPathsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLaunchPathsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchPathsErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListLaunchPathsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLaunchPathsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListLaunchPathsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLaunchPathsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListLaunchPathsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLaunchPathsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOrganizationPortfolioAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOrganizationPortfolioAccessError {
    /// Kind of error that occurred.
    pub kind: ListOrganizationPortfolioAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOrganizationPortfolioAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOrganizationPortfolioAccessErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOrganizationPortfolioAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOrganizationPortfolioAccessErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationPortfolioAccessErrorKind::OperationNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationPortfolioAccessErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationPortfolioAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOrganizationPortfolioAccessError {
    fn code(&self) -> Option<&str> {
        ListOrganizationPortfolioAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOrganizationPortfolioAccessError {
    /// Creates a new `ListOrganizationPortfolioAccessError`.
    pub fn new(
        kind: ListOrganizationPortfolioAccessErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOrganizationPortfolioAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOrganizationPortfolioAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOrganizationPortfolioAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOrganizationPortfolioAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOrganizationPortfolioAccessErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationPortfolioAccessErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListOrganizationPortfolioAccessErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationPortfolioAccessErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `ListOrganizationPortfolioAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationPortfolioAccessErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListOrganizationPortfolioAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOrganizationPortfolioAccessErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ListOrganizationPortfolioAccessErrorKind::OperationNotSupportedException(_inner) => {
                Some(_inner)
            }
            ListOrganizationPortfolioAccessErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListOrganizationPortfolioAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPortfolioAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPortfolioAccessError {
    /// Kind of error that occurred.
    pub kind: ListPortfolioAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPortfolioAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPortfolioAccessErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPortfolioAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPortfolioAccessErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListPortfolioAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPortfolioAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPortfolioAccessError {
    fn code(&self) -> Option<&str> {
        ListPortfolioAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPortfolioAccessError {
    /// Creates a new `ListPortfolioAccessError`.
    pub fn new(kind: ListPortfolioAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPortfolioAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPortfolioAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPortfolioAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPortfolioAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPortfolioAccessErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortfolioAccessErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListPortfolioAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortfolioAccessErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPortfolioAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPortfolioAccessErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListPortfolioAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPortfolioAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPortfolios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPortfoliosError {
    /// Kind of error that occurred.
    pub kind: ListPortfoliosErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPortfolios` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPortfoliosErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPortfoliosError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPortfoliosErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListPortfoliosErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPortfoliosError {
    fn code(&self) -> Option<&str> {
        ListPortfoliosError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPortfoliosError {
    /// Creates a new `ListPortfoliosError`.
    pub fn new(kind: ListPortfoliosErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPortfoliosError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPortfoliosErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPortfoliosError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPortfoliosErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPortfoliosErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortfoliosErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for ListPortfoliosError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPortfoliosErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListPortfoliosErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPortfoliosForProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPortfoliosForProductError {
    /// Kind of error that occurred.
    pub kind: ListPortfoliosForProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPortfoliosForProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPortfoliosForProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPortfoliosForProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPortfoliosForProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListPortfoliosForProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPortfoliosForProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPortfoliosForProductError {
    fn code(&self) -> Option<&str> {
        ListPortfoliosForProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPortfoliosForProductError {
    /// Creates a new `ListPortfoliosForProductError`.
    pub fn new(kind: ListPortfoliosForProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPortfoliosForProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPortfoliosForProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPortfoliosForProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPortfoliosForProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPortfoliosForProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortfoliosForProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListPortfoliosForProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortfoliosForProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPortfoliosForProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPortfoliosForProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListPortfoliosForProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPortfoliosForProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrincipalsForPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPrincipalsForPortfolioError {
    /// Kind of error that occurred.
    pub kind: ListPrincipalsForPortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrincipalsForPortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPrincipalsForPortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPrincipalsForPortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPrincipalsForPortfolioErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ListPrincipalsForPortfolioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPrincipalsForPortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPrincipalsForPortfolioError {
    fn code(&self) -> Option<&str> {
        ListPrincipalsForPortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPrincipalsForPortfolioError {
    /// Creates a new `ListPrincipalsForPortfolioError`.
    pub fn new(kind: ListPrincipalsForPortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPrincipalsForPortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPrincipalsForPortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPrincipalsForPortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPrincipalsForPortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPrincipalsForPortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsForPortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListPrincipalsForPortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsForPortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPrincipalsForPortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPrincipalsForPortfolioErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListPrincipalsForPortfolioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPrincipalsForPortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisionedProductPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisionedProductPlansError {
    /// Kind of error that occurred.
    pub kind: ListProvisionedProductPlansErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisionedProductPlans` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisionedProductPlansErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisionedProductPlansError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisionedProductPlansErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedProductPlansErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedProductPlansErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisionedProductPlansError {
    fn code(&self) -> Option<&str> {
        ListProvisionedProductPlansError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisionedProductPlansError {
    /// Creates a new `ListProvisionedProductPlansError`.
    pub fn new(kind: ListProvisionedProductPlansErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisionedProductPlansError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisionedProductPlansErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisionedProductPlansError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisionedProductPlansErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProvisionedProductPlansErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedProductPlansErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListProvisionedProductPlansErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedProductPlansErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProvisionedProductPlansError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisionedProductPlansErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            ListProvisionedProductPlansErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProvisionedProductPlansErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisioningArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisioningArtifactsError {
    /// Kind of error that occurred.
    pub kind: ListProvisioningArtifactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisioningArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisioningArtifactsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisioningArtifactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisioningArtifactsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListProvisioningArtifactsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProvisioningArtifactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisioningArtifactsError {
    fn code(&self) -> Option<&str> {
        ListProvisioningArtifactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisioningArtifactsError {
    /// Creates a new `ListProvisioningArtifactsError`.
    pub fn new(kind: ListProvisioningArtifactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisioningArtifactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisioningArtifactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisioningArtifactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisioningArtifactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProvisioningArtifactsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningArtifactsErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListProvisioningArtifactsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningArtifactsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProvisioningArtifactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisioningArtifactsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListProvisioningArtifactsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProvisioningArtifactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisioningArtifactsForServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisioningArtifactsForServiceActionError {
    /// Kind of error that occurred.
    pub kind: ListProvisioningArtifactsForServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisioningArtifactsForServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisioningArtifactsForServiceActionErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisioningArtifactsForServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisioningArtifactsForServiceActionErrorKind::InvalidParametersException(
                _inner,
            ) => _inner.fmt(f),
            ListProvisioningArtifactsForServiceActionErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListProvisioningArtifactsForServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisioningArtifactsForServiceActionError {
    fn code(&self) -> Option<&str> {
        ListProvisioningArtifactsForServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisioningArtifactsForServiceActionError {
    /// Creates a new `ListProvisioningArtifactsForServiceActionError`.
    pub fn new(
        kind: ListProvisioningArtifactsForServiceActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisioningArtifactsForServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisioningArtifactsForServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisioningArtifactsForServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisioningArtifactsForServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProvisioningArtifactsForServiceActionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningArtifactsForServiceActionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListProvisioningArtifactsForServiceActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningArtifactsForServiceActionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProvisioningArtifactsForServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisioningArtifactsForServiceActionErrorKind::InvalidParametersException(
                _inner,
            ) => Some(_inner),
            ListProvisioningArtifactsForServiceActionErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            ListProvisioningArtifactsForServiceActionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListRecordHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecordHistoryError {
    /// Kind of error that occurred.
    pub kind: ListRecordHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecordHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecordHistoryErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecordHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecordHistoryErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListRecordHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecordHistoryError {
    fn code(&self) -> Option<&str> {
        ListRecordHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecordHistoryError {
    /// Creates a new `ListRecordHistoryError`.
    pub fn new(kind: ListRecordHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecordHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecordHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecordHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecordHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRecordHistoryErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecordHistoryErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for ListRecordHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecordHistoryErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListRecordHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourcesForTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesForTagOptionError {
    /// Kind of error that occurred.
    pub kind: ListResourcesForTagOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourcesForTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesForTagOptionErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesForTagOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesForTagOptionErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListResourcesForTagOptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListResourcesForTagOptionErrorKind::TagOptionNotMigratedException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesForTagOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesForTagOptionError {
    fn code(&self) -> Option<&str> {
        ListResourcesForTagOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesForTagOptionError {
    /// Creates a new `ListResourcesForTagOptionError`.
    pub fn new(kind: ListResourcesForTagOptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesForTagOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesForTagOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesForTagOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesForTagOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListResourcesForTagOptionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForTagOptionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListResourcesForTagOptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForTagOptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListResourcesForTagOptionErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForTagOptionErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for ListResourcesForTagOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesForTagOptionErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListResourcesForTagOptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListResourcesForTagOptionErrorKind::TagOptionNotMigratedException(_inner) => {
                Some(_inner)
            }
            ListResourcesForTagOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceActionsError {
    /// Kind of error that occurred.
    pub kind: ListServiceActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceActionsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceActionsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListServiceActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceActionsError {
    fn code(&self) -> Option<&str> {
        ListServiceActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceActionsError {
    /// Creates a new `ListServiceActionsError`.
    pub fn new(kind: ListServiceActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListServiceActionsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceActionsErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for ListServiceActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceActionsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListServiceActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceActionsForProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceActionsForProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: ListServiceActionsForProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceActionsForProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceActionsForProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceActionsForProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceActionsForProvisioningArtifactErrorKind::InvalidParametersException(
                _inner,
            ) => _inner.fmt(f),
            ListServiceActionsForProvisioningArtifactErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListServiceActionsForProvisioningArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceActionsForProvisioningArtifactError {
    fn code(&self) -> Option<&str> {
        ListServiceActionsForProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceActionsForProvisioningArtifactError {
    /// Creates a new `ListServiceActionsForProvisioningArtifactError`.
    pub fn new(
        kind: ListServiceActionsForProvisioningArtifactErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceActionsForProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceActionsForProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceActionsForProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceActionsForProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListServiceActionsForProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceActionsForProvisioningArtifactErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListServiceActionsForProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceActionsForProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListServiceActionsForProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceActionsForProvisioningArtifactErrorKind::InvalidParametersException(
                _inner,
            ) => Some(_inner),
            ListServiceActionsForProvisioningArtifactErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            ListServiceActionsForProvisioningArtifactErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListStackInstancesForProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackInstancesForProvisionedProductError {
    /// Kind of error that occurred.
    pub kind: ListStackInstancesForProvisionedProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackInstancesForProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackInstancesForProvisionedProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackInstancesForProvisionedProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackInstancesForProvisionedProductErrorKind::InvalidParametersException(
                _inner,
            ) => _inner.fmt(f),
            ListStackInstancesForProvisionedProductErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListStackInstancesForProvisionedProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackInstancesForProvisionedProductError {
    fn code(&self) -> Option<&str> {
        ListStackInstancesForProvisionedProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackInstancesForProvisionedProductError {
    /// Creates a new `ListStackInstancesForProvisionedProductError`.
    pub fn new(
        kind: ListStackInstancesForProvisionedProductErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackInstancesForProvisionedProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackInstancesForProvisionedProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackInstancesForProvisionedProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackInstancesForProvisionedProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStackInstancesForProvisionedProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackInstancesForProvisionedProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListStackInstancesForProvisionedProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackInstancesForProvisionedProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListStackInstancesForProvisionedProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackInstancesForProvisionedProductErrorKind::InvalidParametersException(
                _inner,
            ) => Some(_inner),
            ListStackInstancesForProvisionedProductErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListStackInstancesForProvisionedProductErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTagOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagOptionsError {
    /// Kind of error that occurred.
    pub kind: ListTagOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagOptionsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagOptionsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ListTagOptionsErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            ListTagOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagOptionsError {
    fn code(&self) -> Option<&str> {
        ListTagOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagOptionsError {
    /// Creates a new `ListTagOptionsError`.
    pub fn new(kind: ListTagOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagOptionsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagOptionsErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ListTagOptionsErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagOptionsErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for ListTagOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagOptionsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ListTagOptionsErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            ListTagOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ProvisionProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ProvisionProductError {
    /// Kind of error that occurred.
    pub kind: ProvisionProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ProvisionProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ProvisionProductErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ProvisionProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ProvisionProductErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            ProvisionProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ProvisionProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ProvisionProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ProvisionProductError {
    fn code(&self) -> Option<&str> {
        ProvisionProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ProvisionProductError {
    /// Creates a new `ProvisionProductError`.
    pub fn new(kind: ProvisionProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ProvisionProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ProvisionProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ProvisionProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ProvisionProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ProvisionProductErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionProductErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ProvisionProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ProvisionProductErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            ProvisionProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ProvisionProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ProvisionProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectPortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectPortfolioShareError {
    /// Kind of error that occurred.
    pub kind: RejectPortfolioShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectPortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectPortfolioShareErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectPortfolioShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectPortfolioShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RejectPortfolioShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectPortfolioShareError {
    fn code(&self) -> Option<&str> {
        RejectPortfolioShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectPortfolioShareError {
    /// Creates a new `RejectPortfolioShareError`.
    pub fn new(kind: RejectPortfolioShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectPortfolioShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectPortfolioShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectPortfolioShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectPortfolioShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RejectPortfolioShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectPortfolioShareErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RejectPortfolioShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectPortfolioShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RejectPortfolioShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ScanProvisionedProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ScanProvisionedProductsError {
    /// Kind of error that occurred.
    pub kind: ScanProvisionedProductsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ScanProvisionedProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ScanProvisionedProductsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ScanProvisionedProductsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ScanProvisionedProductsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            ScanProvisionedProductsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ScanProvisionedProductsError {
    fn code(&self) -> Option<&str> {
        ScanProvisionedProductsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ScanProvisionedProductsError {
    /// Creates a new `ScanProvisionedProductsError`.
    pub fn new(kind: ScanProvisionedProductsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ScanProvisionedProductsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ScanProvisionedProductsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ScanProvisionedProductsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ScanProvisionedProductsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ScanProvisionedProductsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScanProvisionedProductsErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for ScanProvisionedProductsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ScanProvisionedProductsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            ScanProvisionedProductsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchProductsError {
    /// Kind of error that occurred.
    pub kind: SearchProductsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchProductsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchProductsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchProductsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            SearchProductsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchProductsError {
    fn code(&self) -> Option<&str> {
        SearchProductsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchProductsError {
    /// Creates a new `SearchProductsError`.
    pub fn new(kind: SearchProductsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchProductsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchProductsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchProductsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchProductsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchProductsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProductsErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for SearchProductsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchProductsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            SearchProductsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchProductsAsAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchProductsAsAdminError {
    /// Kind of error that occurred.
    pub kind: SearchProductsAsAdminErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchProductsAsAdmin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchProductsAsAdminErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchProductsAsAdminError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchProductsAsAdminErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            SearchProductsAsAdminErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchProductsAsAdminErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchProductsAsAdminError {
    fn code(&self) -> Option<&str> {
        SearchProductsAsAdminError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchProductsAsAdminError {
    /// Creates a new `SearchProductsAsAdminError`.
    pub fn new(kind: SearchProductsAsAdminErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchProductsAsAdminError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchProductsAsAdminErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchProductsAsAdminError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchProductsAsAdminErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchProductsAsAdminErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProductsAsAdminErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `SearchProductsAsAdminErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProductsAsAdminErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for SearchProductsAsAdminError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchProductsAsAdminErrorKind::InvalidParametersException(_inner) => Some(_inner),
            SearchProductsAsAdminErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchProductsAsAdminErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchProvisionedProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchProvisionedProductsError {
    /// Kind of error that occurred.
    pub kind: SearchProvisionedProductsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchProvisionedProducts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchProvisionedProductsErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchProvisionedProductsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchProvisionedProductsErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            SearchProvisionedProductsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchProvisionedProductsError {
    fn code(&self) -> Option<&str> {
        SearchProvisionedProductsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchProvisionedProductsError {
    /// Creates a new `SearchProvisionedProductsError`.
    pub fn new(kind: SearchProvisionedProductsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchProvisionedProductsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchProvisionedProductsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchProvisionedProductsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchProvisionedProductsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchProvisionedProductsErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProvisionedProductsErrorKind::InvalidParametersException(_)
        )
    }
}
impl std::error::Error for SearchProvisionedProductsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchProvisionedProductsErrorKind::InvalidParametersException(_inner) => Some(_inner),
            SearchProvisionedProductsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateProvisionedProductError {
    /// Kind of error that occurred.
    pub kind: TerminateProvisionedProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateProvisionedProductErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateProvisionedProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateProvisionedProductErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            TerminateProvisionedProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateProvisionedProductError {
    fn code(&self) -> Option<&str> {
        TerminateProvisionedProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateProvisionedProductError {
    /// Creates a new `TerminateProvisionedProductError`.
    pub fn new(kind: TerminateProvisionedProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateProvisionedProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateProvisionedProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateProvisionedProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateProvisionedProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TerminateProvisionedProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateProvisionedProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TerminateProvisionedProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateProvisionedProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TerminateProvisionedProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConstraintError {
    /// Kind of error that occurred.
    pub kind: UpdateConstraintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConstraint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConstraintErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConstraintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConstraintErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdateConstraintErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConstraintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConstraintError {
    fn code(&self) -> Option<&str> {
        UpdateConstraintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConstraintError {
    /// Creates a new `UpdateConstraintError`.
    pub fn new(kind: UpdateConstraintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConstraintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConstraintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConstraintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConstraintErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConstraintErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConstraintErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConstraintErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConstraintErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConstraintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConstraintErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateConstraintErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConstraintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePortfolioError {
    /// Kind of error that occurred.
    pub kind: UpdatePortfolioErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePortfolio` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePortfolioErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The current limits of the service would have been exceeded by this operation. Decrease your
    /// resource use or increase your service limits and retry the operation.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePortfolioError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePortfolioErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdatePortfolioErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdatePortfolioErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePortfolioErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            UpdatePortfolioErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePortfolioError {
    fn code(&self) -> Option<&str> {
        UpdatePortfolioError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePortfolioError {
    /// Creates a new `UpdatePortfolioError`.
    pub fn new(kind: UpdatePortfolioErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePortfolioError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePortfolioErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePortfolioError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePortfolioErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdatePortfolioErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for UpdatePortfolioError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePortfolioErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdatePortfolioErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdatePortfolioErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePortfolioErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            UpdatePortfolioErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePortfolioShareError {
    /// Kind of error that occurred.
    pub kind: UpdatePortfolioShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePortfolioShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePortfolioShareErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation is not supported.</p>
    OperationNotSupportedException(crate::error::OperationNotSupportedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePortfolioShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePortfolioShareErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdatePortfolioShareErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdatePortfolioShareErrorKind::OperationNotSupportedException(_inner) => _inner.fmt(f),
            UpdatePortfolioShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePortfolioShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePortfolioShareError {
    fn code(&self) -> Option<&str> {
        UpdatePortfolioShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePortfolioShareError {
    /// Creates a new `UpdatePortfolioShareError`.
    pub fn new(kind: UpdatePortfolioShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePortfolioShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePortfolioShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePortfolioShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePortfolioShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdatePortfolioShareErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioShareErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioShareErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioShareErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioShareErrorKind::OperationNotSupportedException`.
    pub fn is_operation_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioShareErrorKind::OperationNotSupportedException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortfolioShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortfolioShareErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdatePortfolioShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePortfolioShareErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdatePortfolioShareErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdatePortfolioShareErrorKind::OperationNotSupportedException(_inner) => Some(_inner),
            UpdatePortfolioShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePortfolioShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProductError {
    /// Kind of error that occurred.
    pub kind: UpdateProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdateProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProductErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            UpdateProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProductError {
    fn code(&self) -> Option<&str> {
        UpdateProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProductError {
    /// Creates a new `UpdateProductError`.
    pub fn new(kind: UpdateProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProductErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProductErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProductErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for UpdateProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProductErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            UpdateProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProvisionedProductError {
    /// Kind of error that occurred.
    pub kind: UpdateProvisionedProductErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProvisionedProduct` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProvisionedProductErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProvisionedProductError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProvisionedProductErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdateProvisionedProductErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProvisionedProductErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProvisionedProductError {
    fn code(&self) -> Option<&str> {
        UpdateProvisionedProductError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProvisionedProductError {
    /// Creates a new `UpdateProvisionedProductError`.
    pub fn new(kind: UpdateProvisionedProductErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProvisionedProductError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProvisionedProductErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProvisionedProductError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProvisionedProductErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProvisionedProductErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisionedProductErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProvisionedProductErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisionedProductErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProvisionedProductError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProvisionedProductErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateProvisionedProductErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProvisionedProductErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProvisionedProductProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProvisionedProductPropertiesError {
    /// Kind of error that occurred.
    pub kind: UpdateProvisionedProductPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProvisionedProductProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProvisionedProductPropertiesErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>An attempt was made to modify a resource that is in a state that is not valid.
    /// Check your resources to ensure that they are in valid states before retrying the operation.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProvisionedProductPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProvisionedProductPropertiesErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            UpdateProvisionedProductPropertiesErrorKind::InvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            UpdateProvisionedProductPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateProvisionedProductPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProvisionedProductPropertiesError {
    fn code(&self) -> Option<&str> {
        UpdateProvisionedProductPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProvisionedProductPropertiesError {
    /// Creates a new `UpdateProvisionedProductPropertiesError`.
    pub fn new(
        kind: UpdateProvisionedProductPropertiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProvisionedProductPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProvisionedProductPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProvisionedProductPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProvisionedProductPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProvisionedProductPropertiesErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisionedProductPropertiesErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProvisionedProductPropertiesErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisionedProductPropertiesErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProvisionedProductPropertiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisionedProductPropertiesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProvisionedProductPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProvisionedProductPropertiesErrorKind::InvalidParametersException(_inner) => {
                Some(_inner)
            }
            UpdateProvisionedProductPropertiesErrorKind::InvalidStateException(_inner) => {
                Some(_inner)
            }
            UpdateProvisionedProductPropertiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateProvisionedProductPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProvisioningArtifactError {
    /// Kind of error that occurred.
    pub kind: UpdateProvisioningArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProvisioningArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProvisioningArtifactErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProvisioningArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProvisioningArtifactErrorKind::InvalidParametersException(_inner) => {
                _inner.fmt(f)
            }
            UpdateProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProvisioningArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProvisioningArtifactError {
    fn code(&self) -> Option<&str> {
        UpdateProvisioningArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProvisioningArtifactError {
    /// Creates a new `UpdateProvisioningArtifactError`.
    pub fn new(kind: UpdateProvisioningArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProvisioningArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProvisioningArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProvisioningArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProvisioningArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProvisioningArtifactErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisioningArtifactErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProvisioningArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProvisioningArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProvisioningArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProvisioningArtifactErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateProvisioningArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProvisioningArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceActionError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceActionErrorKind {
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceActionErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdateServiceActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceActionError {
    fn code(&self) -> Option<&str> {
        UpdateServiceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceActionError {
    /// Creates a new `UpdateServiceActionError`.
    pub fn new(kind: UpdateServiceActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateServiceActionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceActionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceActionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateServiceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceActionErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateServiceActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTagOptionError {
    /// Kind of error that occurred.
    pub kind: UpdateTagOptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTagOption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTagOptionErrorKind {
    /// <p>The specified resource is a duplicate.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>One or more parameters provided to the operation are not valid.</p>
    InvalidParametersException(crate::error::InvalidParametersException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An operation requiring TagOptions failed because the TagOptions migration process has
    /// not been performed for this account. Please use the AWS console to perform the migration
    /// process before retrying the operation.</p>
    TagOptionNotMigratedException(crate::error::TagOptionNotMigratedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTagOptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTagOptionErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateTagOptionErrorKind::InvalidParametersException(_inner) => _inner.fmt(f),
            UpdateTagOptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTagOptionErrorKind::TagOptionNotMigratedException(_inner) => _inner.fmt(f),
            UpdateTagOptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTagOptionError {
    fn code(&self) -> Option<&str> {
        UpdateTagOptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTagOptionError {
    /// Creates a new `UpdateTagOptionError`.
    pub fn new(kind: UpdateTagOptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTagOptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTagOptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTagOptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTagOptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTagOptionErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagOptionErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagOptionErrorKind::InvalidParametersException`.
    pub fn is_invalid_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagOptionErrorKind::InvalidParametersException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagOptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagOptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTagOptionErrorKind::TagOptionNotMigratedException`.
    pub fn is_tag_option_not_migrated_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagOptionErrorKind::TagOptionNotMigratedException(_)
        )
    }
}
impl std::error::Error for UpdateTagOptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTagOptionErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateTagOptionErrorKind::InvalidParametersException(_inner) => Some(_inner),
            UpdateTagOptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTagOptionErrorKind::TagOptionNotMigratedException(_inner) => Some(_inner),
            UpdateTagOptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An operation requiring TagOptions failed because the TagOptions migration process has
/// not been performed for this account. Please use the AWS console to perform the migration
/// process before retrying the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOptionNotMigratedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagOptionNotMigratedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOptionNotMigratedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagOptionNotMigratedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagOptionNotMigratedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagOptionNotMigratedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagOptionNotMigratedException {}
/// See [`TagOptionNotMigratedException`](crate::error::TagOptionNotMigratedException)
pub mod tag_option_not_migrated_exception {
    /// A builder for [`TagOptionNotMigratedException`](crate::error::TagOptionNotMigratedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagOptionNotMigratedException`](crate::error::TagOptionNotMigratedException)
        pub fn build(self) -> crate::error::TagOptionNotMigratedException {
            crate::error::TagOptionNotMigratedException {
                message: self.message,
            }
        }
    }
}
impl TagOptionNotMigratedException {
    /// Creates a new builder-style object to manufacture [`TagOptionNotMigratedException`](crate::error::TagOptionNotMigratedException)
    pub fn builder() -> crate::error::tag_option_not_migrated_exception::Builder {
        crate::error::tag_option_not_migrated_exception::Builder::default()
    }
}

/// <p>The specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>One or more parameters provided to the operation are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParametersException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParametersException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParametersException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParametersException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParametersException {}
/// See [`InvalidParametersException`](crate::error::InvalidParametersException)
pub mod invalid_parameters_exception {
    /// A builder for [`InvalidParametersException`](crate::error::InvalidParametersException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParametersException`](crate::error::InvalidParametersException)
        pub fn build(self) -> crate::error::InvalidParametersException {
            crate::error::InvalidParametersException {
                message: self.message,
            }
        }
    }
}
impl InvalidParametersException {
    /// Creates a new builder-style object to manufacture [`InvalidParametersException`](crate::error::InvalidParametersException)
    pub fn builder() -> crate::error::invalid_parameters_exception::Builder {
        crate::error::invalid_parameters_exception::Builder::default()
    }
}

/// <p>The specified resource is a duplicate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateResourceException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateResourceException {}
/// See [`DuplicateResourceException`](crate::error::DuplicateResourceException)
pub mod duplicate_resource_exception {
    /// A builder for [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateResourceException`](crate::error::DuplicateResourceException)
        pub fn build(self) -> crate::error::DuplicateResourceException {
            crate::error::DuplicateResourceException {
                message: self.message,
            }
        }
    }
}
impl DuplicateResourceException {
    /// Creates a new builder-style object to manufacture [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    pub fn builder() -> crate::error::duplicate_resource_exception::Builder {
        crate::error::duplicate_resource_exception::Builder::default()
    }
}

/// <p>An attempt was made to modify a resource that is in a state that is not valid.
/// Check your resources to ensure that they are in valid states before retrying the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>The operation is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotSupportedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotSupportedException {}
/// See [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
pub mod operation_not_supported_exception {
    /// A builder for [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
        pub fn build(self) -> crate::error::OperationNotSupportedException {
            crate::error::OperationNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotSupportedException {
    /// Creates a new builder-style object to manufacture [`OperationNotSupportedException`](crate::error::OperationNotSupportedException)
    pub fn builder() -> crate::error::operation_not_supported_exception::Builder {
        crate::error::operation_not_supported_exception::Builder::default()
    }
}

/// <p>The current limits of the service would have been exceeded by this operation. Decrease your
/// resource use or increase your service limits and retry the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>A resource that is currently in use. Ensure that the resource is not in use and retry the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}
