// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateApplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateApplicationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateApplicationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationVersionError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplicationVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationVersionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApplicationVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateApplicationVersionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateApplicationVersionErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateApplicationVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateApplicationVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationVersionError {
    fn code(&self) -> Option<&str> {
        CreateApplicationVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationVersionError {
    /// Creates a new `CreateApplicationVersionError`.
    pub fn new(kind: CreateApplicationVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationVersionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationVersionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateApplicationVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateApplicationVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCloudFormationChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCloudFormationChangeSetError {
    /// Kind of error that occurred.
    pub kind: CreateCloudFormationChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCloudFormationChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCloudFormationChangeSetErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCloudFormationChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCloudFormationChangeSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateCloudFormationChangeSetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateCloudFormationChangeSetErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateCloudFormationChangeSetErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateCloudFormationChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCloudFormationChangeSetError {
    fn code(&self) -> Option<&str> {
        CreateCloudFormationChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCloudFormationChangeSetError {
    /// Creates a new `CreateCloudFormationChangeSetError`.
    pub fn new(
        kind: CreateCloudFormationChangeSetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCloudFormationChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCloudFormationChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCloudFormationChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCloudFormationChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCloudFormationChangeSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationChangeSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationChangeSetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationChangeSetErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationChangeSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationChangeSetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationChangeSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationChangeSetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateCloudFormationChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCloudFormationChangeSetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateCloudFormationChangeSetErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateCloudFormationChangeSetErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateCloudFormationChangeSetErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            CreateCloudFormationChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCloudFormationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCloudFormationTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateCloudFormationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCloudFormationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCloudFormationTemplateErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCloudFormationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCloudFormationTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateCloudFormationTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateCloudFormationTemplateErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateCloudFormationTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateCloudFormationTemplateErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            CreateCloudFormationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCloudFormationTemplateError {
    fn code(&self) -> Option<&str> {
        CreateCloudFormationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCloudFormationTemplateError {
    /// Creates a new `CreateCloudFormationTemplateError`.
    pub fn new(kind: CreateCloudFormationTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCloudFormationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCloudFormationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCloudFormationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCloudFormationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCloudFormationTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateCloudFormationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCloudFormationTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateCloudFormationTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateCloudFormationTemplateErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateCloudFormationTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateCloudFormationTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateCloudFormationTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteApplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApplicationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationError {
    /// Kind of error that occurred.
    pub kind: GetApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationError {
    fn code(&self) -> Option<&str> {
        GetApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationError {
    /// Creates a new `GetApplicationError`.
    pub fn new(kind: GetApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApplicationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetApplicationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApplicationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApplicationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApplicationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApplicationPolicyError {
    /// Kind of error that occurred.
    pub kind: GetApplicationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApplicationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApplicationPolicyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApplicationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApplicationPolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApplicationPolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetApplicationPolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetApplicationPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApplicationPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetApplicationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApplicationPolicyError {
    fn code(&self) -> Option<&str> {
        GetApplicationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApplicationPolicyError {
    /// Creates a new `GetApplicationPolicyError`.
    pub fn new(kind: GetApplicationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApplicationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApplicationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApplicationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApplicationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApplicationPolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationPolicyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationPolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationPolicyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationPolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationPolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationPolicyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApplicationPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApplicationPolicyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetApplicationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApplicationPolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApplicationPolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetApplicationPolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetApplicationPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApplicationPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetApplicationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCloudFormationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCloudFormationTemplateError {
    /// Kind of error that occurred.
    pub kind: GetCloudFormationTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCloudFormationTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCloudFormationTemplateErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCloudFormationTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCloudFormationTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCloudFormationTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCloudFormationTemplateErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetCloudFormationTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCloudFormationTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCloudFormationTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCloudFormationTemplateError {
    fn code(&self) -> Option<&str> {
        GetCloudFormationTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCloudFormationTemplateError {
    /// Creates a new `GetCloudFormationTemplateError`.
    pub fn new(kind: GetCloudFormationTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCloudFormationTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCloudFormationTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCloudFormationTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCloudFormationTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCloudFormationTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationTemplateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetCloudFormationTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCloudFormationTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCloudFormationTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCloudFormationTemplateErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            GetCloudFormationTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCloudFormationTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCloudFormationTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplicationDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationDependenciesError {
    /// Kind of error that occurred.
    pub kind: ListApplicationDependenciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationDependenciesErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationDependenciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationDependenciesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListApplicationDependenciesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListApplicationDependenciesErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListApplicationDependenciesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListApplicationDependenciesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListApplicationDependenciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationDependenciesError {
    fn code(&self) -> Option<&str> {
        ListApplicationDependenciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationDependenciesError {
    /// Creates a new `ListApplicationDependenciesError`.
    pub fn new(kind: ListApplicationDependenciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationDependenciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationDependenciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationDependenciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationDependenciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationDependenciesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationDependenciesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationDependenciesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationDependenciesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationDependenciesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationDependenciesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationDependenciesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationDependenciesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationDependenciesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationDependenciesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListApplicationDependenciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationDependenciesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListApplicationDependenciesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListApplicationDependenciesErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListApplicationDependenciesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListApplicationDependenciesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListApplicationDependenciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationsError {
    fn code(&self) -> Option<&str> {
        ListApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationsError {
    /// Creates a new `ListApplicationsError`.
    pub fn new(kind: ListApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListApplicationsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListApplicationsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListApplicationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListApplicationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListApplicationsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApplicationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApplicationVersionsError {
    /// Kind of error that occurred.
    pub kind: ListApplicationVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApplicationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApplicationVersionsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApplicationVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApplicationVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListApplicationVersionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListApplicationVersionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListApplicationVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListApplicationVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListApplicationVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApplicationVersionsError {
    fn code(&self) -> Option<&str> {
        ListApplicationVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApplicationVersionsError {
    /// Creates a new `ListApplicationVersionsError`.
    pub fn new(kind: ListApplicationVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApplicationVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApplicationVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApplicationVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApplicationVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApplicationVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationVersionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationVersionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationVersionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationVersionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApplicationVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApplicationVersionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListApplicationVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApplicationVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListApplicationVersionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListApplicationVersionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListApplicationVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListApplicationVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListApplicationVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutApplicationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutApplicationPolicyError {
    /// Kind of error that occurred.
    pub kind: PutApplicationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutApplicationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutApplicationPolicyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutApplicationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutApplicationPolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutApplicationPolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutApplicationPolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutApplicationPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutApplicationPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutApplicationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutApplicationPolicyError {
    fn code(&self) -> Option<&str> {
        PutApplicationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutApplicationPolicyError {
    /// Creates a new `PutApplicationPolicyError`.
    pub fn new(kind: PutApplicationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutApplicationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutApplicationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutApplicationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutApplicationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutApplicationPolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApplicationPolicyErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApplicationPolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApplicationPolicyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApplicationPolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApplicationPolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApplicationPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApplicationPolicyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutApplicationPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutApplicationPolicyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutApplicationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutApplicationPolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            PutApplicationPolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutApplicationPolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutApplicationPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            PutApplicationPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutApplicationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnshareApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnshareApplicationError {
    /// Kind of error that occurred.
    pub kind: UnshareApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnshareApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnshareApplicationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnshareApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnshareApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UnshareApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UnshareApplicationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UnshareApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UnshareApplicationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UnshareApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnshareApplicationError {
    fn code(&self) -> Option<&str> {
        UnshareApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnshareApplicationError {
    /// Creates a new `UnshareApplicationError`.
    pub fn new(kind: UnshareApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnshareApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnshareApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnshareApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnshareApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnshareApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareApplicationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareApplicationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareApplicationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UnshareApplicationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnshareApplicationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UnshareApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnshareApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            UnshareApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            UnshareApplicationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UnshareApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            UnshareApplicationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UnshareApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The client is not authenticated.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationError {
    /// Creates a new `UpdateApplicationError`.
    pub fn new(kind: UpdateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateApplicationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApplicationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The client is sending more than the allowed number of requests per unit of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>429</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TooManyRequestsException {
    /// <p>429</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>429</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>429</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The client is sending more than the allowed number of requests per unit of time.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>404</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NotFoundException {
    /// <p>404</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>404</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>404</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource (for example, an access policy statement) specified in the request doesn't exist.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>500</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InternalServerErrorException {
    /// <p>500</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>500</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>500</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The AWS Serverless Application Repository service encountered an internal error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>The client is not authenticated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>403</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The client is not authenticated.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ForbiddenException {
    /// <p>403</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>403</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>403</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The client is not authenticated.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The client is not authenticated.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>The resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>409</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The resource already exists.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>409</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>409</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>409</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The resource already exists.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource already exists.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>One of the parameters in the request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>400</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>One of the parameters in the request is invalid.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BadRequestException {
    /// <p>400</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>400</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>400</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>One of the parameters in the request is invalid.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>One of the parameters in the request is invalid.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}
