// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWSServerlessApplicationRepository
///
/// Client for invoking operations on AWSServerlessApplicationRepository. Each operation on AWSServerlessApplicationRepository is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_serverlessapplicationrepository::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_serverlessapplicationrepository::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_serverlessapplicationrepository::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`author(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::author) / [`set_author(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_author): <p>The name of the author publishing the app.</p> <p>Minimum length=1. Maximum length=127.</p> <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>The description of the application.</p> <p>Minimum length=1. Maximum length=256</p>
    ///   - [`home_page_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::home_page_url) / [`set_home_page_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_home_page_url): <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::CreateApplication::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::CreateApplication::set_labels): <p>Labels to improve discovery of apps in search results.</p> <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p> <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    ///   - [`license_body(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::license_body) / [`set_license_body(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_license_body): <p>A local text file that contains the license of the app that matches the spdxLicenseID value of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p> <p>Maximum size 5 MB</p> <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
    ///   - [`license_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::license_url) / [`set_license_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_license_url): <p>A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.</p> <p>Maximum size 5 MB</p> <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>The name of the application that you want to publish.</p> <p>Minimum length=1. Maximum length=140</p> <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    ///   - [`readme_body(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::readme_body) / [`set_readme_body(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_readme_body): <p>A local text readme file in Markdown language that contains a more detailed description of the application and how it works. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p> <p>Maximum size 5 MB</p> <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
    ///   - [`readme_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::readme_url) / [`set_readme_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_readme_url): <p>A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p> <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`source_code_archive_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::source_code_archive_url) / [`set_source_code_archive_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_source_code_archive_url): <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p> <p>Maximum size 50 MB</p>
    ///   - [`source_code_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::source_code_url) / [`set_source_code_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_source_code_url): <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    ///   - [`spdx_license_id(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::spdx_license_id) / [`set_spdx_license_id(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_spdx_license_id): <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_template_body): <p>The local raw packaged AWS SAM template file of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p> <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
    ///   - [`template_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::template_url) / [`set_template_url(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_template_url): <p>A link to the S3 object containing the packaged AWS SAM template of your application.</p> <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateApplicationOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`author(Option<String>)`](crate::output::CreateApplicationOutput::author): <p>The name of the author publishing the app.</p> <p>Minimum length=1. Maximum length=127.</p> <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    ///   - [`creation_time(Option<String>)`](crate::output::CreateApplicationOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateApplicationOutput::description): <p>The description of the application.</p> <p>Minimum length=1. Maximum length=256</p>
    ///   - [`home_page_url(Option<String>)`](crate::output::CreateApplicationOutput::home_page_url): <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    ///   - [`is_verified_author(bool)`](crate::output::CreateApplicationOutput::is_verified_author): <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    ///   - [`labels(Option<Vec<String>>)`](crate::output::CreateApplicationOutput::labels): <p>Labels to improve discovery of apps in search results.</p> <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p> <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    ///   - [`license_url(Option<String>)`](crate::output::CreateApplicationOutput::license_url): <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p> <p>Maximum size 5 MB</p>
    ///   - [`name(Option<String>)`](crate::output::CreateApplicationOutput::name): <p>The name of the application.</p> <p>Minimum length=1. Maximum length=140</p> <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    ///   - [`readme_url(Option<String>)`](crate::output::CreateApplicationOutput::readme_url): <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p>
    ///   - [`spdx_license_id(Option<String>)`](crate::output::CreateApplicationOutput::spdx_license_id): <p>A valid identifier from https://spdx.org/licenses/.</p>
    ///   - [`verified_author_url(Option<String>)`](crate::output::CreateApplicationOutput::verified_author_url): <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    ///   - [`version(Option<Version>)`](crate::output::CreateApplicationOutput::version): <p>Version information about the application.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplicationVersion`](crate::client::fluent_builders::CreateApplicationVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_semantic_version): <p>The semantic version of the new version.</p>
    ///   - [`source_code_archive_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::source_code_archive_url) / [`set_source_code_archive_url(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_source_code_archive_url): <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p> <p>Maximum size 50 MB</p>
    ///   - [`source_code_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::source_code_url) / [`set_source_code_url(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_source_code_url): <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_template_body): <p>The raw packaged AWS SAM template of your application.</p>
    ///   - [`template_url(impl Into<String>)`](crate::client::fluent_builders::CreateApplicationVersion::template_url) / [`set_template_url(Option<String>)`](crate::client::fluent_builders::CreateApplicationVersion::set_template_url): <p>A link to the packaged AWS SAM template of your application.</p>
    /// - On success, responds with [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateApplicationVersionOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`creation_time(Option<String>)`](crate::output::CreateApplicationVersionOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`parameter_definitions(Option<Vec<ParameterDefinition>>)`](crate::output::CreateApplicationVersionOutput::parameter_definitions): <p>An array of parameter types supported by the application.</p>
    ///   - [`required_capabilities(Option<Vec<Capability>>)`](crate::output::CreateApplicationVersionOutput::required_capabilities): <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p> <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p> <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p> <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p> <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    ///   - [`resources_supported(bool)`](crate::output::CreateApplicationVersionOutput::resources_supported): <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
    ///   - [`semantic_version(Option<String>)`](crate::output::CreateApplicationVersionOutput::semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`source_code_archive_url(Option<String>)`](crate::output::CreateApplicationVersionOutput::source_code_archive_url): <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p> <p>Maximum size 50 MB</p>
    ///   - [`source_code_url(Option<String>)`](crate::output::CreateApplicationVersionOutput::source_code_url): <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    ///   - [`template_url(Option<String>)`](crate::output::CreateApplicationVersionOutput::template_url): <p>A link to the packaged AWS SAM template of your application.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationVersionError>`](crate::error::CreateApplicationVersionError)
    pub fn create_application_version(&self) -> fluent_builders::CreateApplicationVersion<C, M, R> {
        fluent_builders::CreateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCloudFormationChangeSet`](crate::client::fluent_builders::CreateCloudFormationChangeSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`capabilities(Vec<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::capabilities) / [`set_capabilities(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_capabilities): <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p> <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p> <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p> <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy</a>.</p> <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p> <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    ///   - [`change_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::change_set_name) / [`set_change_set_name(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_change_set_name): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_client_token): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_description): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`notification_arns(Vec<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::notification_arns) / [`set_notification_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_notification_arns): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`parameter_overrides(Vec<ParameterValue>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::parameter_overrides) / [`set_parameter_overrides(Option<Vec<ParameterValue>>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_parameter_overrides): <p>A list of parameter values for the parameters of the application.</p>
    ///   - [`resource_types(Vec<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::resource_types) / [`set_resource_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_resource_types): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`rollback_configuration(RollbackConfiguration)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::rollback_configuration) / [`set_rollback_configuration(Option<RollbackConfiguration>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_rollback_configuration): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_stack_name): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_tags): <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationChangeSet::set_template_id): <p>The UUID returned by CreateCloudFormationTemplate.</p> <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    /// - On success, responds with [`CreateCloudFormationChangeSetOutput`](crate::output::CreateCloudFormationChangeSetOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateCloudFormationChangeSetOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`change_set_id(Option<String>)`](crate::output::CreateCloudFormationChangeSetOutput::change_set_id): <p>The Amazon Resource Name (ARN) of the change set.</p> <p>Length constraints: Minimum length of 1.</p> <p>Pattern: ARN:[-a-zA-Z0-9:/]*</p>
    ///   - [`semantic_version(Option<String>)`](crate::output::CreateCloudFormationChangeSetOutput::semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`stack_id(Option<String>)`](crate::output::CreateCloudFormationChangeSetOutput::stack_id): <p>The unique ID of the stack.</p>
    /// - On failure, responds with [`SdkError<CreateCloudFormationChangeSetError>`](crate::error::CreateCloudFormationChangeSetError)
    pub fn create_cloud_formation_change_set(
        &self,
    ) -> fluent_builders::CreateCloudFormationChangeSet<C, M, R> {
        fluent_builders::CreateCloudFormationChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCloudFormationTemplate`](crate::client::fluent_builders::CreateCloudFormationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationTemplate::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationTemplate::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateCloudFormationTemplate::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateCloudFormationTemplate::set_semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    /// - On success, responds with [`CreateCloudFormationTemplateOutput`](crate::output::CreateCloudFormationTemplateOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`creation_time(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`expiration_time(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::expiration_time): <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    ///   - [`semantic_version(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`status(Option<Status>)`](crate::output::CreateCloudFormationTemplateOutput::status): <p>Status of the template creation workflow.</p> <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    ///   - [`template_id(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::template_id): <p>The UUID returned by CreateCloudFormationTemplate.</p> <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    ///   - [`template_url(Option<String>)`](crate::output::CreateCloudFormationTemplateOutput::template_url): <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    /// - On failure, responds with [`SdkError<CreateCloudFormationTemplateError>`](crate::error::CreateCloudFormationTemplateError)
    pub fn create_cloud_formation_template(
        &self,
    ) -> fluent_builders::CreateCloudFormationTemplate<C, M, R> {
        fluent_builders::CreateCloudFormationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplication`](crate::client::fluent_builders::GetApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApplication::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::GetApplication::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::GetApplication::set_semantic_version): <p>The semantic version of the application to get.</p>
    /// - On success, responds with [`GetApplicationOutput`](crate::output::GetApplicationOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetApplicationOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`author(Option<String>)`](crate::output::GetApplicationOutput::author): <p>The name of the author publishing the app.</p> <p>Minimum length=1. Maximum length=127.</p> <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    ///   - [`creation_time(Option<String>)`](crate::output::GetApplicationOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`description(Option<String>)`](crate::output::GetApplicationOutput::description): <p>The description of the application.</p> <p>Minimum length=1. Maximum length=256</p>
    ///   - [`home_page_url(Option<String>)`](crate::output::GetApplicationOutput::home_page_url): <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    ///   - [`is_verified_author(bool)`](crate::output::GetApplicationOutput::is_verified_author): <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    ///   - [`labels(Option<Vec<String>>)`](crate::output::GetApplicationOutput::labels): <p>Labels to improve discovery of apps in search results.</p> <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p> <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    ///   - [`license_url(Option<String>)`](crate::output::GetApplicationOutput::license_url): <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p> <p>Maximum size 5 MB</p>
    ///   - [`name(Option<String>)`](crate::output::GetApplicationOutput::name): <p>The name of the application.</p> <p>Minimum length=1. Maximum length=140</p> <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    ///   - [`readme_url(Option<String>)`](crate::output::GetApplicationOutput::readme_url): <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p>
    ///   - [`spdx_license_id(Option<String>)`](crate::output::GetApplicationOutput::spdx_license_id): <p>A valid identifier from https://spdx.org/licenses/.</p>
    ///   - [`verified_author_url(Option<String>)`](crate::output::GetApplicationOutput::verified_author_url): <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    ///   - [`version(Option<Version>)`](crate::output::GetApplicationOutput::version): <p>Version information about the application.</p>
    /// - On failure, responds with [`SdkError<GetApplicationError>`](crate::error::GetApplicationError)
    pub fn get_application(&self) -> fluent_builders::GetApplication<C, M, R> {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApplicationPolicy`](crate::client::fluent_builders::GetApplicationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetApplicationPolicy::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetApplicationPolicy::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    /// - On success, responds with [`GetApplicationPolicyOutput`](crate::output::GetApplicationPolicyOutput) with field(s):
    ///   - [`statements(Option<Vec<ApplicationPolicyStatement>>)`](crate::output::GetApplicationPolicyOutput::statements): <p>An array of policy statements applied to the application.</p>
    /// - On failure, responds with [`SdkError<GetApplicationPolicyError>`](crate::error::GetApplicationPolicyError)
    pub fn get_application_policy(&self) -> fluent_builders::GetApplicationPolicy<C, M, R> {
        fluent_builders::GetApplicationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCloudFormationTemplate`](crate::client::fluent_builders::GetCloudFormationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::GetCloudFormationTemplate::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::GetCloudFormationTemplate::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::GetCloudFormationTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::GetCloudFormationTemplate::set_template_id): <p>The UUID returned by CreateCloudFormationTemplate.</p> <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    /// - On success, responds with [`GetCloudFormationTemplateOutput`](crate::output::GetCloudFormationTemplateOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`creation_time(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`expiration_time(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::expiration_time): <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    ///   - [`semantic_version(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::semantic_version): <p>The semantic version of the application:</p> <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    ///   - [`status(Option<Status>)`](crate::output::GetCloudFormationTemplateOutput::status): <p>Status of the template creation workflow.</p> <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    ///   - [`template_id(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::template_id): <p>The UUID returned by CreateCloudFormationTemplate.</p> <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    ///   - [`template_url(Option<String>)`](crate::output::GetCloudFormationTemplateOutput::template_url): <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    /// - On failure, responds with [`SdkError<GetCloudFormationTemplateError>`](crate::error::GetCloudFormationTemplateError)
    pub fn get_cloud_formation_template(
        &self,
    ) -> fluent_builders::GetCloudFormationTemplate<C, M, R> {
        fluent_builders::GetCloudFormationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplicationDependencies`](crate::client::fluent_builders::ListApplicationDependencies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplicationDependencies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListApplicationDependencies::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListApplicationDependencies::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListApplicationDependencies::max_items) / [`set_max_items(i32)`](crate::client::fluent_builders::ListApplicationDependencies::set_max_items): <p>The total number of items to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplicationDependencies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplicationDependencies::set_next_token): <p>A token to specify where to start paginating.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::ListApplicationDependencies::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::ListApplicationDependencies::set_semantic_version): <p>The semantic version of the application to get.</p>
    /// - On success, responds with [`ListApplicationDependenciesOutput`](crate::output::ListApplicationDependenciesOutput) with field(s):
    ///   - [`dependencies(Option<Vec<ApplicationDependencySummary>>)`](crate::output::ListApplicationDependenciesOutput::dependencies): <p>An array of application summaries nested in the application.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationDependenciesOutput::next_token): <p>The token to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListApplicationDependenciesError>`](crate::error::ListApplicationDependenciesError)
    pub fn list_application_dependencies(
        &self,
    ) -> fluent_builders::ListApplicationDependencies<C, M, R> {
        fluent_builders::ListApplicationDependencies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListApplications::max_items) / [`set_max_items(i32)`](crate::client::fluent_builders::ListApplications::set_max_items): <p>The total number of items to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplications::set_next_token): <p>A token to specify where to start paginating.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`applications(Option<Vec<ApplicationSummary>>)`](crate::output::ListApplicationsOutput::applications): <p>An array of application summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationsOutput::next_token): <p>The token to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplicationVersions`](crate::client::fluent_builders::ListApplicationVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApplicationVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::ListApplicationVersions::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::ListApplicationVersions::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListApplicationVersions::max_items) / [`set_max_items(i32)`](crate::client::fluent_builders::ListApplicationVersions::set_max_items): <p>The total number of items to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApplicationVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApplicationVersions::set_next_token): <p>A token to specify where to start paginating.</p>
    /// - On success, responds with [`ListApplicationVersionsOutput`](crate::output::ListApplicationVersionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListApplicationVersionsOutput::next_token): <p>The token to request the next page of results.</p>
    ///   - [`versions(Option<Vec<VersionSummary>>)`](crate::output::ListApplicationVersionsOutput::versions): <p>An array of version summaries for the application.</p>
    /// - On failure, responds with [`SdkError<ListApplicationVersionsError>`](crate::error::ListApplicationVersionsError)
    pub fn list_application_versions(&self) -> fluent_builders::ListApplicationVersions<C, M, R> {
        fluent_builders::ListApplicationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutApplicationPolicy`](crate::client::fluent_builders::PutApplicationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::PutApplicationPolicy::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::PutApplicationPolicy::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`statements(Vec<ApplicationPolicyStatement>)`](crate::client::fluent_builders::PutApplicationPolicy::statements) / [`set_statements(Option<Vec<ApplicationPolicyStatement>>)`](crate::client::fluent_builders::PutApplicationPolicy::set_statements): <p>An array of policy statements applied to the application.</p>
    /// - On success, responds with [`PutApplicationPolicyOutput`](crate::output::PutApplicationPolicyOutput) with field(s):
    ///   - [`statements(Option<Vec<ApplicationPolicyStatement>>)`](crate::output::PutApplicationPolicyOutput::statements): <p>An array of policy statements applied to the application.</p>
    /// - On failure, responds with [`SdkError<PutApplicationPolicyError>`](crate::error::PutApplicationPolicyError)
    pub fn put_application_policy(&self) -> fluent_builders::PutApplicationPolicy<C, M, R> {
        fluent_builders::PutApplicationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnshareApplication`](crate::client::fluent_builders::UnshareApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UnshareApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UnshareApplication::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::UnshareApplication::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::UnshareApplication::set_organization_id): <p>The AWS Organization ID to unshare the application from.</p>
    /// - On success, responds with [`UnshareApplicationOutput`](crate::output::UnshareApplicationOutput)

    /// - On failure, responds with [`SdkError<UnshareApplicationError>`](crate::error::UnshareApplicationError)
    pub fn unshare_application(&self) -> fluent_builders::UnshareApplication<C, M, R> {
        fluent_builders::UnshareApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application_id): <p>The Amazon Resource Name (ARN) of the application.</p>
    ///   - [`author(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::author) / [`set_author(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_author): <p>The name of the author publishing the app.</p> <p>Minimum length=1. Maximum length=127.</p> <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>The description of the application.</p> <p>Minimum length=1. Maximum length=256</p>
    ///   - [`home_page_url(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::home_page_url) / [`set_home_page_url(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_home_page_url): <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::UpdateApplication::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateApplication::set_labels): <p>Labels to improve discovery of apps in search results.</p> <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p> <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    ///   - [`readme_body(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::readme_body) / [`set_readme_body(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_readme_body): <p>A text readme file in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p>
    ///   - [`readme_url(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::readme_url) / [`set_readme_url(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_readme_url): <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`application_id(Option<String>)`](crate::output::UpdateApplicationOutput::application_id): <p>The application Amazon Resource Name (ARN).</p>
    ///   - [`author(Option<String>)`](crate::output::UpdateApplicationOutput::author): <p>The name of the author publishing the app.</p> <p>Minimum length=1. Maximum length=127.</p> <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    ///   - [`creation_time(Option<String>)`](crate::output::UpdateApplicationOutput::creation_time): <p>The date and time this resource was created.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateApplicationOutput::description): <p>The description of the application.</p> <p>Minimum length=1. Maximum length=256</p>
    ///   - [`home_page_url(Option<String>)`](crate::output::UpdateApplicationOutput::home_page_url): <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    ///   - [`is_verified_author(bool)`](crate::output::UpdateApplicationOutput::is_verified_author): <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    ///   - [`labels(Option<Vec<String>>)`](crate::output::UpdateApplicationOutput::labels): <p>Labels to improve discovery of apps in search results.</p> <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p> <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    ///   - [`license_url(Option<String>)`](crate::output::UpdateApplicationOutput::license_url): <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p> <p>Maximum size 5 MB</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateApplicationOutput::name): <p>The name of the application.</p> <p>Minimum length=1. Maximum length=140</p> <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    ///   - [`readme_url(Option<String>)`](crate::output::UpdateApplicationOutput::readme_url): <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p> <p>Maximum size 5 MB</p>
    ///   - [`spdx_license_id(Option<String>)`](crate::output::UpdateApplicationOutput::spdx_license_id): <p>A valid identifier from https://spdx.org/licenses/.</p>
    ///   - [`verified_author_url(Option<String>)`](crate::output::UpdateApplicationOutput::verified_author_url): <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    ///   - [`version(Option<Version>)`](crate::output::UpdateApplicationOutput::version): <p>Version information about the application.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application, optionally including an AWS SAM file to create the first application version in the same call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author(input);
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_page_url(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_page_url(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>A local text file that contains the license of the app that matches the spdxLicenseID value of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn license_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_body(input.into());
            self
        }
        /// <p>A local text file that contains the license of the app that matches the spdxLicenseID value of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn set_license_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_body(input);
            self
        }
        /// <p>A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn license_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_url(input.into());
            self
        }
        /// <p>A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_url(input);
            self
        }
        /// <p>The name of the application that you want to publish.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application that you want to publish.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A local text readme file in Markdown language that contains a more detailed description of the application and how it works. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn readme_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_body(input.into());
            self
        }
        /// <p>A local text readme file in Markdown language that contains a more detailed description of the application and how it works. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn set_readme_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_body(input);
            self
        }
        /// <p>A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn readme_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_url(input.into());
            self
        }
        /// <p>A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        /// <p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_url(input);
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_archive_url(input.into());
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_archive_url(input);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_url(input.into());
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_url(input);
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn spdx_license_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spdx_license_id(input.into());
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_spdx_license_id(input);
            self
        }
        /// <p>The local raw packaged AWS SAM template file of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The local raw packaged AWS SAM template file of your application. The file has the format file://&lt;path&gt;/&lt;filename&gt;.</p>
        /// <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>A link to the S3 object containing the packaged AWS SAM template of your application.</p>
        /// <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(input.into());
            self
        }
        /// <p>A link to the S3 object containing the packaged AWS SAM template of your application.</p>
        /// <p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplicationVersion`.
    ///
    /// <p>Creates an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_version_input::Builder,
    }
    impl<C, M, R> CreateApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationVersionInputOperationOutputAlias,
                crate::output::CreateApplicationVersionOutput,
                crate::error::CreateApplicationVersionError,
                crate::input::CreateApplicationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the new version.</p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the new version.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_archive_url(input.into());
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_archive_url(input);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_url(input.into());
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_url(input);
            self
        }
        /// <p>The raw packaged AWS SAM template of your application.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The raw packaged AWS SAM template of your application.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(input.into());
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFormationChangeSet`.
    ///
    /// <p>Creates an AWS CloudFormation change set for the given application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCloudFormationChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_formation_change_set_input::Builder,
    }
    impl<C, M, R> CreateCloudFormationChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFormationChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFormationChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFormationChangeSetInputOperationOutputAlias,
                crate::output::CreateCloudFormationChangeSetOutput,
                crate::error::CreateCloudFormationChangeSetError,
                crate::input::CreateCloudFormationChangeSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(input.into());
            self
        }
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn notification_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// Appends an item to `ParameterOverrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p>A list of parameter values for the parameters of the application.</p>
        pub fn parameter_overrides(mut self, input: crate::model::ParameterValue) -> Self {
            self.inner = self.inner.parameter_overrides(input);
            self
        }
        /// <p>A list of parameter values for the parameters of the application.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_overrides(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn rollback_configuration(
            mut self,
            input: crate::model::RollbackConfiguration,
        ) -> Self {
            self.inner = self.inner.rollback_configuration(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rollback_configuration(input);
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a> </i> API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFormationTemplate`.
    ///
    /// <p>Creates an AWS CloudFormation template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCloudFormationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_formation_template_input::Builder,
    }
    impl<C, M, R> CreateCloudFormationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFormationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFormationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFormationTemplateInputOperationOutputAlias,
                crate::output::CreateCloudFormationTemplateOutput,
                crate::error::CreateCloudFormationTemplateError,
                crate::input::CreateCloudFormationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Gets the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_input::Builder,
    }
    impl<C, M, R> GetApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationInputOperationOutputAlias,
                crate::output::GetApplicationOutput,
                crate::error::GetApplicationError,
                crate::input::GetApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationPolicy`.
    ///
    /// <p>Retrieves the policy for the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApplicationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_policy_input::Builder,
    }
    impl<C, M, R> GetApplicationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationPolicyInputOperationOutputAlias,
                crate::output::GetApplicationPolicyOutput,
                crate::error::GetApplicationPolicyError,
                crate::input::GetApplicationPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFormationTemplate`.
    ///
    /// <p>Gets the specified AWS CloudFormation template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCloudFormationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cloud_formation_template_input::Builder,
    }
    impl<C, M, R> GetCloudFormationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCloudFormationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFormationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCloudFormationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCloudFormationTemplateInputOperationOutputAlias,
                crate::output::GetCloudFormationTemplateOutput,
                crate::error::GetCloudFormationTemplateError,
                crate::input::GetCloudFormationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationDependencies`.
    ///
    /// <p>Retrieves the list of applications nested in the containing application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationDependencies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_dependencies_input::Builder,
    }
    impl<C, M, R> ListApplicationDependencies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationDependencies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationDependenciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationDependenciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationDependenciesInputOperationOutputAlias,
                crate::output::ListApplicationDependenciesOutput,
                crate::error::ListApplicationDependenciesError,
                crate::input::ListApplicationDependenciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationDependenciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListApplicationDependenciesPaginator<C, M, R> {
            crate::paginator::ListApplicationDependenciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists applications owned by the requester.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationsPaginator<C, M, R> {
            crate::paginator::ListApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationVersions`.
    ///
    /// <p>Lists versions for the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplicationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_versions_input::Builder,
    }
    impl<C, M, R> ListApplicationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationVersionsInputOperationOutputAlias,
                crate::output::ListApplicationVersionsOutput,
                crate::error::ListApplicationVersionsError,
                crate::input::ListApplicationVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApplicationVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApplicationVersionsPaginator<C, M, R> {
            crate::paginator::ListApplicationVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutApplicationPolicy`.
    ///
    /// <p>Sets the permission policy for an application. For the list of actions supported for this operation, see <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application Permissions</a> .</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutApplicationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_application_policy_input::Builder,
    }
    impl<C, M, R> PutApplicationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutApplicationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutApplicationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutApplicationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutApplicationPolicyInputOperationOutputAlias,
                crate::output::PutApplicationPolicyOutput,
                crate::error::PutApplicationPolicyError,
                crate::input::PutApplicationPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// Appends an item to `Statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>An array of policy statements applied to the application.</p>
        pub fn statements(mut self, input: crate::model::ApplicationPolicyStatement) -> Self {
            self.inner = self.inner.statements(input);
            self
        }
        /// <p>An array of policy statements applied to the application.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
        ) -> Self {
            self.inner = self.inner.set_statements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnshareApplication`.
    ///
    /// <p>Unshares an application from an AWS Organization.</p>
    /// <p>This operation can be called only from the organization's master account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnshareApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unshare_application_input::Builder,
    }
    impl<C, M, R> UnshareApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnshareApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnshareApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UnshareApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnshareApplicationInputOperationOutputAlias,
                crate::output::UnshareApplicationOutput,
                crate::error::UnshareApplicationError,
                crate::input::UnshareApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The AWS Organization ID to unshare the application from.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>The AWS Organization ID to unshare the application from.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author(input);
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_page_url(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_page_url(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>A text readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn readme_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_body(input.into());
            self
        }
        /// <p>A text readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_readme_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_body(input);
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn readme_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_url(input.into());
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_url(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
