// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub home_page_url: std::option::Option<std::string::String>,
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub is_verified_author: bool,
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub license_url: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub readme_url: std::option::Option<std::string::String>,
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub spdx_license_id: std::option::Option<std::string::String>,
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub verified_author_url: std::option::Option<std::string::String>,
    /// <p>Version information about the application.</p>
    pub version: std::option::Option<crate::model::Version>,
}
impl UpdateApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub fn home_page_url(&self) -> std::option::Option<&str> {
        self.home_page_url.as_deref()
    }
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub fn is_verified_author(&self) -> bool {
        self.is_verified_author
    }
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn license_url(&self) -> std::option::Option<&str> {
        self.license_url.as_deref()
    }
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn readme_url(&self) -> std::option::Option<&str> {
        self.readme_url.as_deref()
    }
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub fn spdx_license_id(&self) -> std::option::Option<&str> {
        self.spdx_license_id.as_deref()
    }
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub fn verified_author_url(&self) -> std::option::Option<&str> {
        self.verified_author_url.as_deref()
    }
    /// <p>Version information about the application.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::Version> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("author", &self.author);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("home_page_url", &self.home_page_url);
        formatter.field("is_verified_author", &self.is_verified_author);
        formatter.field("labels", &self.labels);
        formatter.field("license_url", &self.license_url);
        formatter.field("name", &self.name);
        formatter.field("readme_url", &self.readme_url);
        formatter.field("spdx_license_id", &self.spdx_license_id);
        formatter.field("verified_author_url", &self.verified_author_url);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
pub mod update_application_output {
    /// A builder for [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) home_page_url: std::option::Option<std::string::String>,
        pub(crate) is_verified_author: std::option::Option<bool>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_url: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) readme_url: std::option::Option<std::string::String>,
        pub(crate) spdx_license_id: std::option::Option<std::string::String>,
        pub(crate) verified_author_url: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::Version>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_page_url = Some(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_page_url = input;
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn is_verified_author(mut self, input: bool) -> Self {
            self.is_verified_author = Some(input);
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn set_is_verified_author(mut self, input: std::option::Option<bool>) -> Self {
            self.is_verified_author = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn license_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_url = Some(input.into());
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_url = input;
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn readme_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.readme_url = Some(input.into());
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.readme_url = input;
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn spdx_license_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spdx_license_id = Some(input.into());
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spdx_license_id = input;
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn verified_author_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.verified_author_url = Some(input.into());
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn set_verified_author_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verified_author_url = input;
            self
        }
        /// <p>Version information about the application.</p>
        pub fn version(mut self, input: crate::model::Version) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>Version information about the application.</p>
        pub fn set_version(mut self, input: std::option::Option<crate::model::Version>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
        pub fn build(self) -> crate::output::UpdateApplicationOutput {
            crate::output::UpdateApplicationOutput {
                application_id: self.application_id,
                author: self.author,
                creation_time: self.creation_time,
                description: self.description,
                home_page_url: self.home_page_url,
                is_verified_author: self.is_verified_author.unwrap_or_default(),
                labels: self.labels,
                license_url: self.license_url,
                name: self.name,
                readme_url: self.readme_url,
                spdx_license_id: self.spdx_license_id,
                verified_author_url: self.verified_author_url,
                version: self.version,
            }
        }
    }
}
impl UpdateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)
    pub fn builder() -> crate::output::update_application_output::Builder {
        crate::output::update_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnshareApplicationOutput {}
impl std::fmt::Debug for UnshareApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnshareApplicationOutput");
        formatter.finish()
    }
}
/// See [`UnshareApplicationOutput`](crate::output::UnshareApplicationOutput)
pub mod unshare_application_output {
    /// A builder for [`UnshareApplicationOutput`](crate::output::UnshareApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UnshareApplicationOutput`](crate::output::UnshareApplicationOutput)
        pub fn build(self) -> crate::output::UnshareApplicationOutput {
            crate::output::UnshareApplicationOutput {}
        }
    }
}
impl UnshareApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UnshareApplicationOutput`](crate::output::UnshareApplicationOutput)
    pub fn builder() -> crate::output::unshare_application_output::Builder {
        crate::output::unshare_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutApplicationPolicyOutput {
    /// <p>An array of policy statements applied to the application.</p>
    pub statements: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
}
impl PutApplicationPolicyOutput {
    /// <p>An array of policy statements applied to the application.</p>
    pub fn statements(&self) -> std::option::Option<&[crate::model::ApplicationPolicyStatement]> {
        self.statements.as_deref()
    }
}
impl std::fmt::Debug for PutApplicationPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutApplicationPolicyOutput");
        formatter.field("statements", &self.statements);
        formatter.finish()
    }
}
/// See [`PutApplicationPolicyOutput`](crate::output::PutApplicationPolicyOutput)
pub mod put_application_policy_output {
    /// A builder for [`PutApplicationPolicyOutput`](crate::output::PutApplicationPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statements:
            std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
    }
    impl Builder {
        /// Appends an item to `statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>An array of policy statements applied to the application.</p>
        pub fn statements(mut self, input: crate::model::ApplicationPolicyStatement) -> Self {
            let mut v = self.statements.unwrap_or_default();
            v.push(input);
            self.statements = Some(v);
            self
        }
        /// <p>An array of policy statements applied to the application.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
        ) -> Self {
            self.statements = input;
            self
        }
        /// Consumes the builder and constructs a [`PutApplicationPolicyOutput`](crate::output::PutApplicationPolicyOutput)
        pub fn build(self) -> crate::output::PutApplicationPolicyOutput {
            crate::output::PutApplicationPolicyOutput {
                statements: self.statements,
            }
        }
    }
}
impl PutApplicationPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutApplicationPolicyOutput`](crate::output::PutApplicationPolicyOutput)
    pub fn builder() -> crate::output::put_application_policy_output::Builder {
        crate::output::put_application_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationVersionsOutput {
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of version summaries for the application.</p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::VersionSummary>>,
}
impl ListApplicationVersionsOutput {
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of version summaries for the application.</p>
    pub fn versions(&self) -> std::option::Option<&[crate::model::VersionSummary]> {
        self.versions.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("versions", &self.versions);
        formatter.finish()
    }
}
/// See [`ListApplicationVersionsOutput`](crate::output::ListApplicationVersionsOutput)
pub mod list_application_versions_output {
    /// A builder for [`ListApplicationVersionsOutput`](crate::output::ListApplicationVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<crate::model::VersionSummary>>,
    }
    impl Builder {
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>An array of version summaries for the application.</p>
        pub fn versions(mut self, input: crate::model::VersionSummary) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input);
            self.versions = Some(v);
            self
        }
        /// <p>An array of version summaries for the application.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VersionSummary>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationVersionsOutput`](crate::output::ListApplicationVersionsOutput)
        pub fn build(self) -> crate::output::ListApplicationVersionsOutput {
            crate::output::ListApplicationVersionsOutput {
                next_token: self.next_token,
                versions: self.versions,
            }
        }
    }
}
impl ListApplicationVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationVersionsOutput`](crate::output::ListApplicationVersionsOutput)
    pub fn builder() -> crate::output::list_application_versions_output::Builder {
        crate::output::list_application_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsOutput {
    /// <p>An array of application summaries.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationsOutput {
    /// <p>An array of application summaries.</p>
    pub fn applications(&self) -> std::option::Option<&[crate::model::ApplicationSummary]> {
        self.applications.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsOutput");
        formatter.field("applications", &self.applications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
pub mod list_applications_output {
    /// A builder for [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) applications:
            std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>An array of application summaries.</p>
        pub fn applications(mut self, input: crate::model::ApplicationSummary) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input);
            self.applications = Some(v);
            self
        }
        /// <p>An array of application summaries.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationSummary>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
        pub fn build(self) -> crate::output::ListApplicationsOutput {
            crate::output::ListApplicationsOutput {
                applications: self.applications,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationsOutput`](crate::output::ListApplicationsOutput)
    pub fn builder() -> crate::output::list_applications_output::Builder {
        crate::output::list_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationDependenciesOutput {
    /// <p>An array of application summaries nested in the application.</p>
    pub dependencies:
        std::option::Option<std::vec::Vec<crate::model::ApplicationDependencySummary>>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApplicationDependenciesOutput {
    /// <p>An array of application summaries nested in the application.</p>
    pub fn dependencies(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationDependencySummary]> {
        self.dependencies.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationDependenciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationDependenciesOutput");
        formatter.field("dependencies", &self.dependencies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApplicationDependenciesOutput`](crate::output::ListApplicationDependenciesOutput)
pub mod list_application_dependencies_output {
    /// A builder for [`ListApplicationDependenciesOutput`](crate::output::ListApplicationDependenciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dependencies:
            std::option::Option<std::vec::Vec<crate::model::ApplicationDependencySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dependencies`.
        ///
        /// To override the contents of this collection use [`set_dependencies`](Self::set_dependencies).
        ///
        /// <p>An array of application summaries nested in the application.</p>
        pub fn dependencies(mut self, input: crate::model::ApplicationDependencySummary) -> Self {
            let mut v = self.dependencies.unwrap_or_default();
            v.push(input);
            self.dependencies = Some(v);
            self
        }
        /// <p>An array of application summaries nested in the application.</p>
        pub fn set_dependencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationDependencySummary>>,
        ) -> Self {
            self.dependencies = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationDependenciesOutput`](crate::output::ListApplicationDependenciesOutput)
        pub fn build(self) -> crate::output::ListApplicationDependenciesOutput {
            crate::output::ListApplicationDependenciesOutput {
                dependencies: self.dependencies,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApplicationDependenciesOutput {
    /// Creates a new builder-style object to manufacture [`ListApplicationDependenciesOutput`](crate::output::ListApplicationDependenciesOutput)
    pub fn builder() -> crate::output::list_application_dependencies_output::Builder {
        crate::output::list_application_dependencies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCloudFormationTemplateOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    pub expiration_time: std::option::Option<std::string::String>,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>Status of the template creation workflow.</p>
    /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
    /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    pub template_url: std::option::Option<std::string::String>,
}
impl GetCloudFormationTemplateOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    pub fn expiration_time(&self) -> std::option::Option<&str> {
        self.expiration_time.as_deref()
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>Status of the template creation workflow.</p>
    /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
    /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
}
impl std::fmt::Debug for GetCloudFormationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCloudFormationTemplateOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("status", &self.status);
        formatter.field("template_id", &self.template_id);
        formatter.field("template_url", &self.template_url);
        formatter.finish()
    }
}
/// See [`GetCloudFormationTemplateOutput`](crate::output::GetCloudFormationTemplateOutput)
pub mod get_cloud_formation_template_output {
    /// A builder for [`GetCloudFormationTemplateOutput`](crate::output::GetCloudFormationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
        pub fn expiration_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration_time = Some(input.into());
            self
        }
        /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>Status of the template creation workflow.</p>
        /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the template creation workflow.</p>
        /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFormationTemplateOutput`](crate::output::GetCloudFormationTemplateOutput)
        pub fn build(self) -> crate::output::GetCloudFormationTemplateOutput {
            crate::output::GetCloudFormationTemplateOutput {
                application_id: self.application_id,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
                semantic_version: self.semantic_version,
                status: self.status,
                template_id: self.template_id,
                template_url: self.template_url,
            }
        }
    }
}
impl GetCloudFormationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetCloudFormationTemplateOutput`](crate::output::GetCloudFormationTemplateOutput)
    pub fn builder() -> crate::output::get_cloud_formation_template_output::Builder {
        crate::output::get_cloud_formation_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationPolicyOutput {
    /// <p>An array of policy statements applied to the application.</p>
    pub statements: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
}
impl GetApplicationPolicyOutput {
    /// <p>An array of policy statements applied to the application.</p>
    pub fn statements(&self) -> std::option::Option<&[crate::model::ApplicationPolicyStatement]> {
        self.statements.as_deref()
    }
}
impl std::fmt::Debug for GetApplicationPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationPolicyOutput");
        formatter.field("statements", &self.statements);
        formatter.finish()
    }
}
/// See [`GetApplicationPolicyOutput`](crate::output::GetApplicationPolicyOutput)
pub mod get_application_policy_output {
    /// A builder for [`GetApplicationPolicyOutput`](crate::output::GetApplicationPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statements:
            std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
    }
    impl Builder {
        /// Appends an item to `statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>An array of policy statements applied to the application.</p>
        pub fn statements(mut self, input: crate::model::ApplicationPolicyStatement) -> Self {
            let mut v = self.statements.unwrap_or_default();
            v.push(input);
            self.statements = Some(v);
            self
        }
        /// <p>An array of policy statements applied to the application.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
        ) -> Self {
            self.statements = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationPolicyOutput`](crate::output::GetApplicationPolicyOutput)
        pub fn build(self) -> crate::output::GetApplicationPolicyOutput {
            crate::output::GetApplicationPolicyOutput {
                statements: self.statements,
            }
        }
    }
}
impl GetApplicationPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationPolicyOutput`](crate::output::GetApplicationPolicyOutput)
    pub fn builder() -> crate::output::get_application_policy_output::Builder {
        crate::output::get_application_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub home_page_url: std::option::Option<std::string::String>,
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub is_verified_author: bool,
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub license_url: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub readme_url: std::option::Option<std::string::String>,
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub spdx_license_id: std::option::Option<std::string::String>,
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub verified_author_url: std::option::Option<std::string::String>,
    /// <p>Version information about the application.</p>
    pub version: std::option::Option<crate::model::Version>,
}
impl GetApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub fn home_page_url(&self) -> std::option::Option<&str> {
        self.home_page_url.as_deref()
    }
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub fn is_verified_author(&self) -> bool {
        self.is_verified_author
    }
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn license_url(&self) -> std::option::Option<&str> {
        self.license_url.as_deref()
    }
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn readme_url(&self) -> std::option::Option<&str> {
        self.readme_url.as_deref()
    }
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub fn spdx_license_id(&self) -> std::option::Option<&str> {
        self.spdx_license_id.as_deref()
    }
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub fn verified_author_url(&self) -> std::option::Option<&str> {
        self.verified_author_url.as_deref()
    }
    /// <p>Version information about the application.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::Version> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for GetApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApplicationOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("author", &self.author);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("home_page_url", &self.home_page_url);
        formatter.field("is_verified_author", &self.is_verified_author);
        formatter.field("labels", &self.labels);
        formatter.field("license_url", &self.license_url);
        formatter.field("name", &self.name);
        formatter.field("readme_url", &self.readme_url);
        formatter.field("spdx_license_id", &self.spdx_license_id);
        formatter.field("verified_author_url", &self.verified_author_url);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`GetApplicationOutput`](crate::output::GetApplicationOutput)
pub mod get_application_output {
    /// A builder for [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) home_page_url: std::option::Option<std::string::String>,
        pub(crate) is_verified_author: std::option::Option<bool>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_url: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) readme_url: std::option::Option<std::string::String>,
        pub(crate) spdx_license_id: std::option::Option<std::string::String>,
        pub(crate) verified_author_url: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::Version>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_page_url = Some(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_page_url = input;
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn is_verified_author(mut self, input: bool) -> Self {
            self.is_verified_author = Some(input);
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn set_is_verified_author(mut self, input: std::option::Option<bool>) -> Self {
            self.is_verified_author = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn license_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_url = Some(input.into());
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_url = input;
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn readme_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.readme_url = Some(input.into());
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.readme_url = input;
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn spdx_license_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spdx_license_id = Some(input.into());
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spdx_license_id = input;
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn verified_author_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.verified_author_url = Some(input.into());
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn set_verified_author_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verified_author_url = input;
            self
        }
        /// <p>Version information about the application.</p>
        pub fn version(mut self, input: crate::model::Version) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>Version information about the application.</p>
        pub fn set_version(mut self, input: std::option::Option<crate::model::Version>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApplicationOutput`](crate::output::GetApplicationOutput)
        pub fn build(self) -> crate::output::GetApplicationOutput {
            crate::output::GetApplicationOutput {
                application_id: self.application_id,
                author: self.author,
                creation_time: self.creation_time,
                description: self.description,
                home_page_url: self.home_page_url,
                is_verified_author: self.is_verified_author.unwrap_or_default(),
                labels: self.labels,
                license_url: self.license_url,
                name: self.name,
                readme_url: self.readme_url,
                spdx_license_id: self.spdx_license_id,
                verified_author_url: self.verified_author_url,
                version: self.version,
            }
        }
    }
}
impl GetApplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetApplicationOutput`](crate::output::GetApplicationOutput)
    pub fn builder() -> crate::output::get_application_output::Builder {
        crate::output::get_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutput {}
impl std::fmt::Debug for DeleteApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
pub mod delete_application_output {
    /// A builder for [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
        pub fn build(self) -> crate::output::DeleteApplicationOutput {
            crate::output::DeleteApplicationOutput {}
        }
    }
}
impl DeleteApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)
    pub fn builder() -> crate::output::delete_application_output::Builder {
        crate::output::delete_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCloudFormationTemplateOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    pub expiration_time: std::option::Option<std::string::String>,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>Status of the template creation workflow.</p>
    /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
    /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    pub template_url: std::option::Option<std::string::String>,
}
impl CreateCloudFormationTemplateOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
    pub fn expiration_time(&self) -> std::option::Option<&str> {
        self.expiration_time.as_deref()
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>Status of the template creation workflow.</p>
    /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
    /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
}
impl std::fmt::Debug for CreateCloudFormationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCloudFormationTemplateOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("status", &self.status);
        formatter.field("template_id", &self.template_id);
        formatter.field("template_url", &self.template_url);
        formatter.finish()
    }
}
/// See [`CreateCloudFormationTemplateOutput`](crate::output::CreateCloudFormationTemplateOutput)
pub mod create_cloud_formation_template_output {
    /// A builder for [`CreateCloudFormationTemplateOutput`](crate::output::CreateCloudFormationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
        pub fn expiration_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration_time = Some(input.into());
            self
        }
        /// <p>The date and time this template expires. Templates expire 1 hour after creation.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>Status of the template creation workflow.</p>
        /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the template creation workflow.</p>
        /// <p>Possible values: PREPARING | ACTIVE | EXPIRED </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p>
        /// <p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>A link to the template that can be used to deploy the application using AWS CloudFormation.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCloudFormationTemplateOutput`](crate::output::CreateCloudFormationTemplateOutput)
        pub fn build(self) -> crate::output::CreateCloudFormationTemplateOutput {
            crate::output::CreateCloudFormationTemplateOutput {
                application_id: self.application_id,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
                semantic_version: self.semantic_version,
                status: self.status,
                template_id: self.template_id,
                template_url: self.template_url,
            }
        }
    }
}
impl CreateCloudFormationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationTemplateOutput`](crate::output::CreateCloudFormationTemplateOutput)
    pub fn builder() -> crate::output::create_cloud_formation_template_output::Builder {
        crate::output::create_cloud_formation_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCloudFormationChangeSetOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the change set.</p>
    /// <p>Length constraints: Minimum length of 1.</p>
    /// <p>Pattern: ARN:[-a-zA-Z0-9:/]*</p>
    pub change_set_id: std::option::Option<std::string::String>,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>The unique ID of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl CreateCloudFormationChangeSetOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the change set.</p>
    /// <p>Length constraints: Minimum length of 1.</p>
    /// <p>Pattern: ARN:[-a-zA-Z0-9:/]*</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>The unique ID of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for CreateCloudFormationChangeSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCloudFormationChangeSetOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}
/// See [`CreateCloudFormationChangeSetOutput`](crate::output::CreateCloudFormationChangeSetOutput)
pub mod create_cloud_formation_change_set_output {
    /// A builder for [`CreateCloudFormationChangeSetOutput`](crate::output::CreateCloudFormationChangeSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the change set.</p>
        /// <p>Length constraints: Minimum length of 1.</p>
        /// <p>Pattern: ARN:[-a-zA-Z0-9:/]*</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the change set.</p>
        /// <p>Length constraints: Minimum length of 1.</p>
        /// <p>Pattern: ARN:[-a-zA-Z0-9:/]*</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>The unique ID of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCloudFormationChangeSetOutput`](crate::output::CreateCloudFormationChangeSetOutput)
        pub fn build(self) -> crate::output::CreateCloudFormationChangeSetOutput {
            crate::output::CreateCloudFormationChangeSetOutput {
                application_id: self.application_id,
                change_set_id: self.change_set_id,
                semantic_version: self.semantic_version,
                stack_id: self.stack_id,
            }
        }
    }
}
impl CreateCloudFormationChangeSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationChangeSetOutput`](crate::output::CreateCloudFormationChangeSetOutput)
    pub fn builder() -> crate::output::create_cloud_formation_change_set_output::Builder {
        crate::output::create_cloud_formation_change_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationVersionOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>An array of parameter types supported by the application.</p>
    pub parameter_definitions:
        std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
    /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
    /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
    /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
    /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
    /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
    /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    pub required_capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
    pub resources_supported: bool,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
    /// <p>Maximum size 50 MB</p>
    pub source_code_archive_url: std::option::Option<std::string::String>,
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub source_code_url: std::option::Option<std::string::String>,
    /// <p>A link to the packaged AWS SAM template of your application.</p>
    pub template_url: std::option::Option<std::string::String>,
}
impl CreateApplicationVersionOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>An array of parameter types supported by the application.</p>
    pub fn parameter_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterDefinition]> {
        self.parameter_definitions.as_deref()
    }
    /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
    /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
    /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
    /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
    /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
    /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    pub fn required_capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.required_capabilities.as_deref()
    }
    /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
    pub fn resources_supported(&self) -> bool {
        self.resources_supported
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
    /// <p>Maximum size 50 MB</p>
    pub fn source_code_archive_url(&self) -> std::option::Option<&str> {
        self.source_code_archive_url.as_deref()
    }
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub fn source_code_url(&self) -> std::option::Option<&str> {
        self.source_code_url.as_deref()
    }
    /// <p>A link to the packaged AWS SAM template of your application.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationVersionOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("parameter_definitions", &self.parameter_definitions);
        formatter.field("required_capabilities", &self.required_capabilities);
        formatter.field("resources_supported", &self.resources_supported);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("source_code_archive_url", &self.source_code_archive_url);
        formatter.field("source_code_url", &self.source_code_url);
        formatter.field("template_url", &self.template_url);
        formatter.finish()
    }
}
/// See [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
pub mod create_application_version_output {
    /// A builder for [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) parameter_definitions:
            std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
        pub(crate) required_capabilities:
            std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) resources_supported: std::option::Option<bool>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) source_code_archive_url: std::option::Option<std::string::String>,
        pub(crate) source_code_url: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `parameter_definitions`.
        ///
        /// To override the contents of this collection use [`set_parameter_definitions`](Self::set_parameter_definitions).
        ///
        /// <p>An array of parameter types supported by the application.</p>
        pub fn parameter_definitions(mut self, input: crate::model::ParameterDefinition) -> Self {
            let mut v = self.parameter_definitions.unwrap_or_default();
            v.push(input);
            self.parameter_definitions = Some(v);
            self
        }
        /// <p>An array of parameter types supported by the application.</p>
        pub fn set_parameter_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
        ) -> Self {
            self.parameter_definitions = input;
            self
        }
        /// Appends an item to `required_capabilities`.
        ///
        /// To override the contents of this collection use [`set_required_capabilities`](Self::set_required_capabilities).
        ///
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn required_capabilities(mut self, input: crate::model::Capability) -> Self {
            let mut v = self.required_capabilities.unwrap_or_default();
            v.push(input);
            self.required_capabilities = Some(v);
            self
        }
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn set_required_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.required_capabilities = input;
            self
        }
        /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
        pub fn resources_supported(mut self, input: bool) -> Self {
            self.resources_supported = Some(input);
            self
        }
        /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
        pub fn set_resources_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.resources_supported = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_archive_url = Some(input.into());
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_archive_url = input;
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_url = Some(input.into());
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_url = input;
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
        pub fn build(self) -> crate::output::CreateApplicationVersionOutput {
            crate::output::CreateApplicationVersionOutput {
                application_id: self.application_id,
                creation_time: self.creation_time,
                parameter_definitions: self.parameter_definitions,
                required_capabilities: self.required_capabilities,
                resources_supported: self.resources_supported.unwrap_or_default(),
                semantic_version: self.semantic_version,
                source_code_archive_url: self.source_code_archive_url,
                source_code_url: self.source_code_url,
                template_url: self.template_url,
            }
        }
    }
}
impl CreateApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationVersionOutput`](crate::output::CreateApplicationVersionOutput)
    pub fn builder() -> crate::output::create_application_version_output::Builder {
        crate::output::create_application_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub home_page_url: std::option::Option<std::string::String>,
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub is_verified_author: bool,
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub license_url: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub readme_url: std::option::Option<std::string::String>,
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub spdx_license_id: std::option::Option<std::string::String>,
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub verified_author_url: std::option::Option<std::string::String>,
    /// <p>Version information about the application.</p>
    pub version: std::option::Option<crate::model::Version>,
}
impl CreateApplicationOutput {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub fn home_page_url(&self) -> std::option::Option<&str> {
        self.home_page_url.as_deref()
    }
    /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
    pub fn is_verified_author(&self) -> bool {
        self.is_verified_author
    }
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn license_url(&self) -> std::option::Option<&str> {
        self.license_url.as_deref()
    }
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
    /// <p>Maximum size 5 MB</p>
    pub fn readme_url(&self) -> std::option::Option<&str> {
        self.readme_url.as_deref()
    }
    /// <p>A valid identifier from https://spdx.org/licenses/.</p>
    pub fn spdx_license_id(&self) -> std::option::Option<&str> {
        self.spdx_license_id.as_deref()
    }
    /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
    pub fn verified_author_url(&self) -> std::option::Option<&str> {
        self.verified_author_url.as_deref()
    }
    /// <p>Version information about the application.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::Version> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationOutput");
        formatter.field("application_id", &self.application_id);
        formatter.field("author", &self.author);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("home_page_url", &self.home_page_url);
        formatter.field("is_verified_author", &self.is_verified_author);
        formatter.field("labels", &self.labels);
        formatter.field("license_url", &self.license_url);
        formatter.field("name", &self.name);
        formatter.field("readme_url", &self.readme_url);
        formatter.field("spdx_license_id", &self.spdx_license_id);
        formatter.field("verified_author_url", &self.verified_author_url);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
pub mod create_application_output {
    /// A builder for [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) home_page_url: std::option::Option<std::string::String>,
        pub(crate) is_verified_author: std::option::Option<bool>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_url: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) readme_url: std::option::Option<std::string::String>,
        pub(crate) spdx_license_id: std::option::Option<std::string::String>,
        pub(crate) verified_author_url: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::Version>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_page_url = Some(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_page_url = input;
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn is_verified_author(mut self, input: bool) -> Self {
            self.is_verified_author = Some(input);
            self
        }
        /// <p>Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.</p>
        pub fn set_is_verified_author(mut self, input: std::option::Option<bool>) -> Self {
            self.is_verified_author = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn license_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_url = Some(input.into());
            self
        }
        /// <p>A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_url = input;
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn readme_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.readme_url = Some(input.into());
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p>
        /// <p>Maximum size 5 MB</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.readme_url = input;
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn spdx_license_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spdx_license_id = Some(input.into());
            self
        }
        /// <p>A valid identifier from https://spdx.org/licenses/.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spdx_license_id = input;
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn verified_author_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.verified_author_url = Some(input.into());
            self
        }
        /// <p>The URL to the public profile of a verified author. This URL is submitted by the author.</p>
        pub fn set_verified_author_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verified_author_url = input;
            self
        }
        /// <p>Version information about the application.</p>
        pub fn version(mut self, input: crate::model::Version) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>Version information about the application.</p>
        pub fn set_version(mut self, input: std::option::Option<crate::model::Version>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
        pub fn build(self) -> crate::output::CreateApplicationOutput {
            crate::output::CreateApplicationOutput {
                application_id: self.application_id,
                author: self.author,
                creation_time: self.creation_time,
                description: self.description,
                home_page_url: self.home_page_url,
                is_verified_author: self.is_verified_author.unwrap_or_default(),
                labels: self.labels,
                license_url: self.license_url,
                name: self.name,
                readme_url: self.readme_url,
                spdx_license_id: self.spdx_license_id,
                verified_author_url: self.verified_author_url,
                version: self.version,
            }
        }
    }
}
impl CreateApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateApplicationOutput`](crate::output::CreateApplicationOutput)
    pub fn builder() -> crate::output::create_application_output::Builder {
        crate::output::create_application_output::Builder::default()
    }
}
