// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Application version details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Version {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>An array of parameter types supported by the application.</p>
    pub parameter_definitions:
        std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
    /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
    /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
    /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
    /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
    /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
    /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    pub required_capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
    pub resources_supported: bool,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
    /// <p>Maximum size 50 MB</p>
    pub source_code_archive_url: std::option::Option<std::string::String>,
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub source_code_url: std::option::Option<std::string::String>,
    /// <p>A link to the packaged AWS SAM template of your application.</p>
    pub template_url: std::option::Option<std::string::String>,
}
impl Version {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>An array of parameter types supported by the application.</p>
    pub fn parameter_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterDefinition]> {
        self.parameter_definitions.as_deref()
    }
    /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
    /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
    /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
    /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
    /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
    /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
    pub fn required_capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.required_capabilities.as_deref()
    }
    /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
    pub fn resources_supported(&self) -> bool {
        self.resources_supported
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
    /// <p>Maximum size 50 MB</p>
    pub fn source_code_archive_url(&self) -> std::option::Option<&str> {
        self.source_code_archive_url.as_deref()
    }
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub fn source_code_url(&self) -> std::option::Option<&str> {
        self.source_code_url.as_deref()
    }
    /// <p>A link to the packaged AWS SAM template of your application.</p>
    pub fn template_url(&self) -> std::option::Option<&str> {
        self.template_url.as_deref()
    }
}
impl std::fmt::Debug for Version {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Version");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("parameter_definitions", &self.parameter_definitions);
        formatter.field("required_capabilities", &self.required_capabilities);
        formatter.field("resources_supported", &self.resources_supported);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("source_code_archive_url", &self.source_code_archive_url);
        formatter.field("source_code_url", &self.source_code_url);
        formatter.field("template_url", &self.template_url);
        formatter.finish()
    }
}
/// See [`Version`](crate::model::Version)
pub mod version {
    /// A builder for [`Version`](crate::model::Version)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) parameter_definitions:
            std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
        pub(crate) required_capabilities:
            std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) resources_supported: std::option::Option<bool>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) source_code_archive_url: std::option::Option<std::string::String>,
        pub(crate) source_code_url: std::option::Option<std::string::String>,
        pub(crate) template_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `parameter_definitions`.
        ///
        /// To override the contents of this collection use [`set_parameter_definitions`](Self::set_parameter_definitions).
        ///
        /// <p>An array of parameter types supported by the application.</p>
        pub fn parameter_definitions(mut self, input: crate::model::ParameterDefinition) -> Self {
            let mut v = self.parameter_definitions.unwrap_or_default();
            v.push(input);
            self.parameter_definitions = Some(v);
            self
        }
        /// <p>An array of parameter types supported by the application.</p>
        pub fn set_parameter_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterDefinition>>,
        ) -> Self {
            self.parameter_definitions = input;
            self
        }
        /// Appends an item to `required_capabilities`.
        ///
        /// To override the contents of this collection use [`set_required_capabilities`](Self::set_required_capabilities).
        ///
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn required_capabilities(mut self, input: crate::model::Capability) -> Self {
            let mut v = self.required_capabilities.unwrap_or_default();
            v.push(input);
            self.required_capabilities = Some(v);
            self
        }
        /// <p>A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.</p>
        /// <p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p>
        /// <p>The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.</p>
        /// <p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS::TopicPolicy</a>.</p>
        /// <p>Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.</p>
        /// <p>If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn set_required_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.required_capabilities = input;
            self
        }
        /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
        pub fn resources_supported(mut self, input: bool) -> Self {
            self.resources_supported = Some(input);
            self
        }
        /// <p>Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.</p>
        pub fn set_resources_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.resources_supported = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_archive_url = Some(input.into());
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p>
        /// <p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_archive_url = input;
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_url = Some(input.into());
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_url = input;
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn template_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_url = Some(input.into());
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_url = input;
            self
        }
        /// Consumes the builder and constructs a [`Version`](crate::model::Version)
        pub fn build(self) -> crate::model::Version {
            crate::model::Version {
                application_id: self.application_id,
                creation_time: self.creation_time,
                parameter_definitions: self.parameter_definitions,
                required_capabilities: self.required_capabilities,
                resources_supported: self.resources_supported.unwrap_or_default(),
                semantic_version: self.semantic_version,
                source_code_archive_url: self.source_code_archive_url,
                source_code_url: self.source_code_url,
                template_url: self.template_url,
            }
        }
    }
}
impl Version {
    /// Creates a new builder-style object to manufacture [`Version`](crate::model::Version)
    pub fn builder() -> crate::model::version::Builder {
        crate::model::version::Builder::default()
    }
}

/// <p>Values that must be specified in order to deploy some applications.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Capability {
    #[allow(missing_docs)] // documentation missing in model
    CapabilityAutoExpand,
    #[allow(missing_docs)] // documentation missing in model
    CapabilityIam,
    #[allow(missing_docs)] // documentation missing in model
    CapabilityNamedIam,
    #[allow(missing_docs)] // documentation missing in model
    CapabilityResourcePolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Capability {
    fn from(s: &str) -> Self {
        match s {
            "CAPABILITY_AUTO_EXPAND" => Capability::CapabilityAutoExpand,
            "CAPABILITY_IAM" => Capability::CapabilityIam,
            "CAPABILITY_NAMED_IAM" => Capability::CapabilityNamedIam,
            "CAPABILITY_RESOURCE_POLICY" => Capability::CapabilityResourcePolicy,
            other => Capability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Capability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Capability::from(s))
    }
}
impl Capability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Capability::CapabilityAutoExpand => "CAPABILITY_AUTO_EXPAND",
            Capability::CapabilityIam => "CAPABILITY_IAM",
            Capability::CapabilityNamedIam => "CAPABILITY_NAMED_IAM",
            Capability::CapabilityResourcePolicy => "CAPABILITY_RESOURCE_POLICY",
            Capability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CAPABILITY_AUTO_EXPAND",
            "CAPABILITY_IAM",
            "CAPABILITY_NAMED_IAM",
            "CAPABILITY_RESOURCE_POLICY",
        ]
    }
}
impl AsRef<str> for Capability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameters supported by the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterDefinition {
    /// <p>A regular expression that represents the patterns to allow for String types.</p>
    pub allowed_pattern: std::option::Option<std::string::String>,
    /// <p>An array containing the list of values allowed for the parameter.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message when the user specifies an invalid value:</p>
    /// <p> Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+ </p>
    /// <p>By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:</p>
    /// <p> Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers. </p>
    pub constraint_description: std::option::Option<std::string::String>,
    /// <p>A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A string of up to 4,000 characters that describes the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An integer value that determines the largest number of characters that you want to allow for String types.</p>
    pub max_length: i32,
    /// <p>A numeric value that determines the largest numeric value that you want to allow for Number types.</p>
    pub max_value: i32,
    /// <p>An integer value that determines the smallest number of characters that you want to allow for String types.</p>
    pub min_length: i32,
    /// <p>A numeric value that determines the smallest numeric value that you want to allow for Number types.</p>
    pub min_value: i32,
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).</p>
    pub no_echo: bool,
    /// <p>A list of AWS SAM resources that use this parameter.</p>
    pub referenced_by_resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of the parameter.</p>
    /// <p>Valid values: String | Number | List&lt;Number&gt; | CommaDelimitedList </p>
    /// <p> String: A literal string.</p>
    /// <p>For example, users can specify "MyUserName".</p>
    /// <p> Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.</p>
    /// <p>For example, users might specify "8888".</p>
    /// <p> List&lt;Number&gt;: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.</p>
    /// <p>For example, users might specify "80,20", and then Ref results in ["80","20"].</p>
    /// <p> CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.</p>
    /// <p>For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl ParameterDefinition {
    /// <p>A regular expression that represents the patterns to allow for String types.</p>
    pub fn allowed_pattern(&self) -> std::option::Option<&str> {
        self.allowed_pattern.as_deref()
    }
    /// <p>An array containing the list of values allowed for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_values.as_deref()
    }
    /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message when the user specifies an invalid value:</p>
    /// <p> Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+ </p>
    /// <p>By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:</p>
    /// <p> Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers. </p>
    pub fn constraint_description(&self) -> std::option::Option<&str> {
        self.constraint_description.as_deref()
    }
    /// <p>A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A string of up to 4,000 characters that describes the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An integer value that determines the largest number of characters that you want to allow for String types.</p>
    pub fn max_length(&self) -> i32 {
        self.max_length
    }
    /// <p>A numeric value that determines the largest numeric value that you want to allow for Number types.</p>
    pub fn max_value(&self) -> i32 {
        self.max_value
    }
    /// <p>An integer value that determines the smallest number of characters that you want to allow for String types.</p>
    pub fn min_length(&self) -> i32 {
        self.min_length
    }
    /// <p>A numeric value that determines the smallest numeric value that you want to allow for Number types.</p>
    pub fn min_value(&self) -> i32 {
        self.min_value
    }
    /// <p>The name of the parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).</p>
    pub fn no_echo(&self) -> bool {
        self.no_echo
    }
    /// <p>A list of AWS SAM resources that use this parameter.</p>
    pub fn referenced_by_resources(&self) -> std::option::Option<&[std::string::String]> {
        self.referenced_by_resources.as_deref()
    }
    /// <p>The type of the parameter.</p>
    /// <p>Valid values: String | Number | List&lt;Number&gt; | CommaDelimitedList </p>
    /// <p> String: A literal string.</p>
    /// <p>For example, users can specify "MyUserName".</p>
    /// <p> Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.</p>
    /// <p>For example, users might specify "8888".</p>
    /// <p> List&lt;Number&gt;: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.</p>
    /// <p>For example, users might specify "80,20", and then Ref results in ["80","20"].</p>
    /// <p> CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.</p>
    /// <p>For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ParameterDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterDefinition");
        formatter.field("allowed_pattern", &self.allowed_pattern);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("constraint_description", &self.constraint_description);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("max_length", &self.max_length);
        formatter.field("max_value", &self.max_value);
        formatter.field("min_length", &self.min_length);
        formatter.field("min_value", &self.min_value);
        formatter.field("name", &self.name);
        formatter.field("no_echo", &self.no_echo);
        formatter.field("referenced_by_resources", &self.referenced_by_resources);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ParameterDefinition`](crate::model::ParameterDefinition)
pub mod parameter_definition {
    /// A builder for [`ParameterDefinition`](crate::model::ParameterDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_pattern: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) constraint_description: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) max_length: std::option::Option<i32>,
        pub(crate) max_value: std::option::Option<i32>,
        pub(crate) min_length: std::option::Option<i32>,
        pub(crate) min_value: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) no_echo: std::option::Option<bool>,
        pub(crate) referenced_by_resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A regular expression that represents the patterns to allow for String types.</p>
        pub fn allowed_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_pattern = Some(input.into());
            self
        }
        /// <p>A regular expression that represents the patterns to allow for String types.</p>
        pub fn set_allowed_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_pattern = input;
            self
        }
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>An array containing the list of values allowed for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input.into());
            self.allowed_values = Some(v);
            self
        }
        /// <p>An array containing the list of values allowed for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message when the user specifies an invalid value:</p>
        /// <p> Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+ </p>
        /// <p>By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:</p>
        /// <p> Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers. </p>
        pub fn constraint_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.constraint_description = Some(input.into());
            self
        }
        /// <p>A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message when the user specifies an invalid value:</p>
        /// <p> Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+ </p>
        /// <p>By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:</p>
        /// <p> Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers. </p>
        pub fn set_constraint_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constraint_description = input;
            self
        }
        /// <p>A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A string of up to 4,000 characters that describes the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string of up to 4,000 characters that describes the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An integer value that determines the largest number of characters that you want to allow for String types.</p>
        pub fn max_length(mut self, input: i32) -> Self {
            self.max_length = Some(input);
            self
        }
        /// <p>An integer value that determines the largest number of characters that you want to allow for String types.</p>
        pub fn set_max_length(mut self, input: std::option::Option<i32>) -> Self {
            self.max_length = input;
            self
        }
        /// <p>A numeric value that determines the largest numeric value that you want to allow for Number types.</p>
        pub fn max_value(mut self, input: i32) -> Self {
            self.max_value = Some(input);
            self
        }
        /// <p>A numeric value that determines the largest numeric value that you want to allow for Number types.</p>
        pub fn set_max_value(mut self, input: std::option::Option<i32>) -> Self {
            self.max_value = input;
            self
        }
        /// <p>An integer value that determines the smallest number of characters that you want to allow for String types.</p>
        pub fn min_length(mut self, input: i32) -> Self {
            self.min_length = Some(input);
            self
        }
        /// <p>An integer value that determines the smallest number of characters that you want to allow for String types.</p>
        pub fn set_min_length(mut self, input: std::option::Option<i32>) -> Self {
            self.min_length = input;
            self
        }
        /// <p>A numeric value that determines the smallest numeric value that you want to allow for Number types.</p>
        pub fn min_value(mut self, input: i32) -> Self {
            self.min_value = Some(input);
            self
        }
        /// <p>A numeric value that determines the smallest numeric value that you want to allow for Number types.</p>
        pub fn set_min_value(mut self, input: std::option::Option<i32>) -> Self {
            self.min_value = input;
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).</p>
        pub fn no_echo(mut self, input: bool) -> Self {
            self.no_echo = Some(input);
            self
        }
        /// <p>Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).</p>
        pub fn set_no_echo(mut self, input: std::option::Option<bool>) -> Self {
            self.no_echo = input;
            self
        }
        /// Appends an item to `referenced_by_resources`.
        ///
        /// To override the contents of this collection use [`set_referenced_by_resources`](Self::set_referenced_by_resources).
        ///
        /// <p>A list of AWS SAM resources that use this parameter.</p>
        pub fn referenced_by_resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.referenced_by_resources.unwrap_or_default();
            v.push(input.into());
            self.referenced_by_resources = Some(v);
            self
        }
        /// <p>A list of AWS SAM resources that use this parameter.</p>
        pub fn set_referenced_by_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.referenced_by_resources = input;
            self
        }
        /// <p>The type of the parameter.</p>
        /// <p>Valid values: String | Number | List&lt;Number&gt; | CommaDelimitedList </p>
        /// <p> String: A literal string.</p>
        /// <p>For example, users can specify "MyUserName".</p>
        /// <p> Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.</p>
        /// <p>For example, users might specify "8888".</p>
        /// <p> List&lt;Number&gt;: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.</p>
        /// <p>For example, users might specify "80,20", and then Ref results in ["80","20"].</p>
        /// <p> CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.</p>
        /// <p>For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the parameter.</p>
        /// <p>Valid values: String | Number | List&lt;Number&gt; | CommaDelimitedList </p>
        /// <p> String: A literal string.</p>
        /// <p>For example, users can specify "MyUserName".</p>
        /// <p> Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.</p>
        /// <p>For example, users might specify "8888".</p>
        /// <p> List&lt;Number&gt;: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.</p>
        /// <p>For example, users might specify "80,20", and then Ref results in ["80","20"].</p>
        /// <p> CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.</p>
        /// <p>For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterDefinition`](crate::model::ParameterDefinition)
        pub fn build(self) -> crate::model::ParameterDefinition {
            crate::model::ParameterDefinition {
                allowed_pattern: self.allowed_pattern,
                allowed_values: self.allowed_values,
                constraint_description: self.constraint_description,
                default_value: self.default_value,
                description: self.description,
                max_length: self.max_length.unwrap_or_default(),
                max_value: self.max_value.unwrap_or_default(),
                min_length: self.min_length.unwrap_or_default(),
                min_value: self.min_value.unwrap_or_default(),
                name: self.name,
                no_echo: self.no_echo.unwrap_or_default(),
                referenced_by_resources: self.referenced_by_resources,
                r#type: self.r#type,
            }
        }
    }
}
impl ParameterDefinition {
    /// Creates a new builder-style object to manufacture [`ParameterDefinition`](crate::model::ParameterDefinition)
    pub fn builder() -> crate::model::parameter_definition::Builder {
        crate::model::parameter_definition::Builder::default()
    }
}

/// <p>Policy statement applied to the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationPolicyStatement {
    /// <p>For the list of actions supported for this operation, see <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application Permissions</a>.</p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id">aws:PrincipalOrgID</a> global condition key.</p>
    pub principal_org_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of AWS account IDs, or * to make the application public.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique ID for the statement.</p>
    pub statement_id: std::option::Option<std::string::String>,
}
impl ApplicationPolicyStatement {
    /// <p>For the list of actions supported for this operation, see <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application Permissions</a>.</p>
    pub fn actions(&self) -> std::option::Option<&[std::string::String]> {
        self.actions.as_deref()
    }
    /// <p>An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id">aws:PrincipalOrgID</a> global condition key.</p>
    pub fn principal_org_i_ds(&self) -> std::option::Option<&[std::string::String]> {
        self.principal_org_i_ds.as_deref()
    }
    /// <p>An array of AWS account IDs, or * to make the application public.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>A unique ID for the statement.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
}
impl std::fmt::Debug for ApplicationPolicyStatement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationPolicyStatement");
        formatter.field("actions", &self.actions);
        formatter.field("principal_org_i_ds", &self.principal_org_i_ds);
        formatter.field("principals", &self.principals);
        formatter.field("statement_id", &self.statement_id);
        formatter.finish()
    }
}
/// See [`ApplicationPolicyStatement`](crate::model::ApplicationPolicyStatement)
pub mod application_policy_statement {
    /// A builder for [`ApplicationPolicyStatement`](crate::model::ApplicationPolicyStatement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principal_org_i_ds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>For the list of actions supported for this operation, see <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application Permissions</a>.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>For the list of actions supported for this operation, see <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application Permissions</a>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `principal_org_i_ds`.
        ///
        /// To override the contents of this collection use [`set_principal_org_i_ds`](Self::set_principal_org_i_ds).
        ///
        /// <p>An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id">aws:PrincipalOrgID</a> global condition key.</p>
        pub fn principal_org_i_ds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principal_org_i_ds.unwrap_or_default();
            v.push(input.into());
            self.principal_org_i_ds = Some(v);
            self
        }
        /// <p>An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id">aws:PrincipalOrgID</a> global condition key.</p>
        pub fn set_principal_org_i_ds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principal_org_i_ds = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>An array of AWS account IDs, or * to make the application public.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>An array of AWS account IDs, or * to make the application public.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>A unique ID for the statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>A unique ID for the statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationPolicyStatement`](crate::model::ApplicationPolicyStatement)
        pub fn build(self) -> crate::model::ApplicationPolicyStatement {
            crate::model::ApplicationPolicyStatement {
                actions: self.actions,
                principal_org_i_ds: self.principal_org_i_ds,
                principals: self.principals,
                statement_id: self.statement_id,
            }
        }
    }
}
impl ApplicationPolicyStatement {
    /// Creates a new builder-style object to manufacture [`ApplicationPolicyStatement`](crate::model::ApplicationPolicyStatement)
    pub fn builder() -> crate::model::application_policy_statement::Builder {
        crate::model::application_policy_statement::Builder::default()
    }
}

/// <p>An application version summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionSummary {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub source_code_url: std::option::Option<std::string::String>,
}
impl VersionSummary {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The semantic version of the application:</p>
    /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
    pub fn source_code_url(&self) -> std::option::Option<&str> {
        self.source_code_url.as_deref()
    }
}
impl std::fmt::Debug for VersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionSummary");
        formatter.field("application_id", &self.application_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("source_code_url", &self.source_code_url);
        formatter.finish()
    }
}
/// See [`VersionSummary`](crate::model::VersionSummary)
pub mod version_summary {
    /// A builder for [`VersionSummary`](crate::model::VersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) source_code_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the application:</p>
        /// <p> <a href="https://semver.org/">https://semver.org/</a> </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_url = Some(input.into());
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_url = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionSummary`](crate::model::VersionSummary)
        pub fn build(self) -> crate::model::VersionSummary {
            crate::model::VersionSummary {
                application_id: self.application_id,
                creation_time: self.creation_time,
                semantic_version: self.semantic_version,
                source_code_url: self.source_code_url,
            }
        }
    }
}
impl VersionSummary {
    /// Creates a new builder-style object to manufacture [`VersionSummary`](crate::model::VersionSummary)
    pub fn builder() -> crate::model::version_summary::Builder {
        crate::model::version_summary::Builder::default()
    }
}

/// <p>Summary of details about the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSummary {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>The date and time this resource was created.</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub home_page_url: std::option::Option<std::string::String>,
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
    pub spdx_license_id: std::option::Option<std::string::String>,
}
impl ApplicationSummary {
    /// <p>The application Amazon Resource Name (ARN).</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The name of the author publishing the app.</p>
    /// <p>Minimum length=1. Maximum length=127.</p>
    /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>The date and time this resource was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&str> {
        self.creation_time.as_deref()
    }
    /// <p>The description of the application.</p>
    /// <p>Minimum length=1. Maximum length=256</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
    pub fn home_page_url(&self) -> std::option::Option<&str> {
        self.home_page_url.as_deref()
    }
    /// <p>Labels to improve discovery of apps in search results.</p>
    /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
    /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>The name of the application.</p>
    /// <p>Minimum length=1. Maximum length=140</p>
    /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
    pub fn spdx_license_id(&self) -> std::option::Option<&str> {
        self.spdx_license_id.as_deref()
    }
}
impl std::fmt::Debug for ApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSummary");
        formatter.field("application_id", &self.application_id);
        formatter.field("author", &self.author);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("home_page_url", &self.home_page_url);
        formatter.field("labels", &self.labels);
        formatter.field("name", &self.name);
        formatter.field("spdx_license_id", &self.spdx_license_id);
        formatter.finish()
    }
}
/// See [`ApplicationSummary`](crate::model::ApplicationSummary)
pub mod application_summary {
    /// A builder for [`ApplicationSummary`](crate::model::ApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) home_page_url: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) spdx_license_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The application Amazon Resource Name (ARN).</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The name of the author publishing the app.</p>
        /// <p>Minimum length=1. Maximum length=127.</p>
        /// <p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time this resource was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        /// <p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_page_url = Some(input.into());
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_page_url = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p>
        /// <p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p>
        /// <p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        /// <p>Minimum length=1. Maximum length=140</p>
        /// <p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn spdx_license_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spdx_license_id = Some(input.into());
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spdx_license_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSummary`](crate::model::ApplicationSummary)
        pub fn build(self) -> crate::model::ApplicationSummary {
            crate::model::ApplicationSummary {
                application_id: self.application_id,
                author: self.author,
                creation_time: self.creation_time,
                description: self.description,
                home_page_url: self.home_page_url,
                labels: self.labels,
                name: self.name,
                spdx_license_id: self.spdx_license_id,
            }
        }
    }
}
impl ApplicationSummary {
    /// Creates a new builder-style object to manufacture [`ApplicationSummary`](crate::model::ApplicationSummary)
    pub fn builder() -> crate::model::application_summary::Builder {
        crate::model::application_summary::Builder::default()
    }
}

/// <p>A nested application summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationDependencySummary {
    /// <p>The Amazon Resource Name (ARN) of the nested application.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The semantic version of the nested application.</p>
    pub semantic_version: std::option::Option<std::string::String>,
}
impl ApplicationDependencySummary {
    /// <p>The Amazon Resource Name (ARN) of the nested application.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The semantic version of the nested application.</p>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
}
impl std::fmt::Debug for ApplicationDependencySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationDependencySummary");
        formatter.field("application_id", &self.application_id);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.finish()
    }
}
/// See [`ApplicationDependencySummary`](crate::model::ApplicationDependencySummary)
pub mod application_dependency_summary {
    /// A builder for [`ApplicationDependencySummary`](crate::model::ApplicationDependencySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the nested application.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the nested application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The semantic version of the nested application.</p>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the nested application.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationDependencySummary`](crate::model::ApplicationDependencySummary)
        pub fn build(self) -> crate::model::ApplicationDependencySummary {
            crate::model::ApplicationDependencySummary {
                application_id: self.application_id,
                semantic_version: self.semantic_version,
            }
        }
    }
}
impl ApplicationDependencySummary {
    /// Creates a new builder-style object to manufacture [`ApplicationDependencySummary`](crate::model::ApplicationDependencySummary)
    pub fn builder() -> crate::model::application_dependency_summary::Builder {
        crate::model::application_dependency_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => Status::Active,
            "EXPIRED" => Status::Expired,
            "PREPARING" => Status::Preparing,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Active => "ACTIVE",
            Status::Expired => "EXPIRED",
            Status::Preparing => "PREPARING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "EXPIRED", "PREPARING"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This property corresponds to the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag">Tag</a> </i> Data Type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag">Tag</a> </i> Data Type.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag"> Tag</a> </i> Data Type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag">Tag</a> </i> Data Type.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag"> Tag</a> </i> Data Type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag">Tag</a> </i> Data Type.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag">Tag</a> </i> Data Type.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag"> Tag</a> </i> Data Type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag"> Tag</a> </i> Data Type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>This property corresponds to the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackConfiguration {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
    pub monitoring_time_in_minutes: i32,
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
    pub rollback_triggers: std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
}
impl RollbackConfiguration {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
    pub fn monitoring_time_in_minutes(&self) -> i32 {
        self.monitoring_time_in_minutes
    }
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
    pub fn rollback_triggers(&self) -> std::option::Option<&[crate::model::RollbackTrigger]> {
        self.rollback_triggers.as_deref()
    }
}
impl std::fmt::Debug for RollbackConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackConfiguration");
        formatter.field(
            "monitoring_time_in_minutes",
            &self.monitoring_time_in_minutes,
        );
        formatter.field("rollback_triggers", &self.rollback_triggers);
        formatter.finish()
    }
}
/// See [`RollbackConfiguration`](crate::model::RollbackConfiguration)
pub mod rollback_configuration {
    /// A builder for [`RollbackConfiguration`](crate::model::RollbackConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_time_in_minutes: std::option::Option<i32>,
        pub(crate) rollback_triggers:
            std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
    }
    impl Builder {
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
        pub fn monitoring_time_in_minutes(mut self, input: i32) -> Self {
            self.monitoring_time_in_minutes = Some(input);
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
        pub fn set_monitoring_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_time_in_minutes = input;
            self
        }
        /// Appends an item to `rollback_triggers`.
        ///
        /// To override the contents of this collection use [`set_rollback_triggers`](Self::set_rollback_triggers).
        ///
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
        pub fn rollback_triggers(mut self, input: crate::model::RollbackTrigger) -> Self {
            let mut v = self.rollback_triggers.unwrap_or_default();
            v.push(input);
            self.rollback_triggers = Some(v);
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackConfiguration">RollbackConfiguration</a> </i> Data Type.</p>
        pub fn set_rollback_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
        ) -> Self {
            self.rollback_triggers = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackConfiguration`](crate::model::RollbackConfiguration)
        pub fn build(self) -> crate::model::RollbackConfiguration {
            crate::model::RollbackConfiguration {
                monitoring_time_in_minutes: self.monitoring_time_in_minutes.unwrap_or_default(),
                rollback_triggers: self.rollback_triggers,
            }
        }
    }
}
impl RollbackConfiguration {
    /// Creates a new builder-style object to manufacture [`RollbackConfiguration`](crate::model::RollbackConfiguration)
    pub fn builder() -> crate::model::rollback_configuration::Builder {
        crate::model::rollback_configuration::Builder::default()
    }
}

/// <p>This property corresponds to the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackTrigger {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl RollbackTrigger {
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for RollbackTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackTrigger");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RollbackTrigger`](crate::model::RollbackTrigger)
pub mod rollback_trigger {
    /// A builder for [`RollbackTrigger`](crate::model::RollbackTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>This property corresponds to the content of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackTrigger">RollbackTrigger</a> </i> Data Type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackTrigger`](crate::model::RollbackTrigger)
        pub fn build(self) -> crate::model::RollbackTrigger {
            crate::model::RollbackTrigger {
                arn: self.arn,
                r#type: self.r#type,
            }
        }
    }
}
impl RollbackTrigger {
    /// Creates a new builder-style object to manufacture [`RollbackTrigger`](crate::model::RollbackTrigger)
    pub fn builder() -> crate::model::rollback_trigger::Builder {
        crate::model::rollback_trigger::Builder::default()
    }
}

/// <p>Parameter value of the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterValue {
    /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The input value associated with the parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ParameterValue {
    /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The input value associated with the parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ParameterValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterValue");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ParameterValue`](crate::model::ParameterValue)
pub mod parameter_value {
    /// A builder for [`ParameterValue`](crate::model::ParameterValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The input value associated with the parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The input value associated with the parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterValue`](crate::model::ParameterValue)
        pub fn build(self) -> crate::model::ParameterValue {
            crate::model::ParameterValue {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ParameterValue {
    /// Creates a new builder-style object to manufacture [`ParameterValue`](crate::model::ParameterValue)
    pub fn builder() -> crate::model::parameter_value::Builder {
        crate::model::parameter_value::Builder::default()
    }
}
