// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `ServerlessApplicationRepository`.
///
/// This client allows ergonomic access to a `ServerlessApplicationRepository`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApplication` operation.
    ///
    /// See [`CreateApplication`](crate::client::fluent_builders::CreateApplication) for more information about the
    /// operation and its arguments.
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApplicationVersion` operation.
    ///
    /// See [`CreateApplicationVersion`](crate::client::fluent_builders::CreateApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn create_application_version(&self) -> fluent_builders::CreateApplicationVersion<C, M, R> {
        fluent_builders::CreateApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCloudFormationChangeSet` operation.
    ///
    /// See [`CreateCloudFormationChangeSet`](crate::client::fluent_builders::CreateCloudFormationChangeSet) for more information about the
    /// operation and its arguments.
    pub fn create_cloud_formation_change_set(
        &self,
    ) -> fluent_builders::CreateCloudFormationChangeSet<C, M, R> {
        fluent_builders::CreateCloudFormationChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCloudFormationTemplate` operation.
    ///
    /// See [`CreateCloudFormationTemplate`](crate::client::fluent_builders::CreateCloudFormationTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_cloud_formation_template(
        &self,
    ) -> fluent_builders::CreateCloudFormationTemplate<C, M, R> {
        fluent_builders::CreateCloudFormationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApplication` operation.
    ///
    /// See [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplication` operation.
    ///
    /// See [`GetApplication`](crate::client::fluent_builders::GetApplication) for more information about the
    /// operation and its arguments.
    pub fn get_application(&self) -> fluent_builders::GetApplication<C, M, R> {
        fluent_builders::GetApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApplicationPolicy` operation.
    ///
    /// See [`GetApplicationPolicy`](crate::client::fluent_builders::GetApplicationPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_application_policy(&self) -> fluent_builders::GetApplicationPolicy<C, M, R> {
        fluent_builders::GetApplicationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCloudFormationTemplate` operation.
    ///
    /// See [`GetCloudFormationTemplate`](crate::client::fluent_builders::GetCloudFormationTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_cloud_formation_template(
        &self,
    ) -> fluent_builders::GetCloudFormationTemplate<C, M, R> {
        fluent_builders::GetCloudFormationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationDependencies` operation.
    ///
    /// See [`ListApplicationDependencies`](crate::client::fluent_builders::ListApplicationDependencies) for more information about the
    /// operation and its arguments.
    pub fn list_application_dependencies(
        &self,
    ) -> fluent_builders::ListApplicationDependencies<C, M, R> {
        fluent_builders::ListApplicationDependencies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplications` operation.
    ///
    /// See [`ListApplications`](crate::client::fluent_builders::ListApplications) for more information about the
    /// operation and its arguments.
    pub fn list_applications(&self) -> fluent_builders::ListApplications<C, M, R> {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApplicationVersions` operation.
    ///
    /// See [`ListApplicationVersions`](crate::client::fluent_builders::ListApplicationVersions) for more information about the
    /// operation and its arguments.
    pub fn list_application_versions(&self) -> fluent_builders::ListApplicationVersions<C, M, R> {
        fluent_builders::ListApplicationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutApplicationPolicy` operation.
    ///
    /// See [`PutApplicationPolicy`](crate::client::fluent_builders::PutApplicationPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_application_policy(&self) -> fluent_builders::PutApplicationPolicy<C, M, R> {
        fluent_builders::PutApplicationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnshareApplication` operation.
    ///
    /// See [`UnshareApplication`](crate::client::fluent_builders::UnshareApplication) for more information about the
    /// operation and its arguments.
    pub fn unshare_application(&self) -> fluent_builders::UnshareApplication<C, M, R> {
        fluent_builders::UnshareApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApplication` operation.
    ///
    /// See [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) for more information about the
    /// operation and its arguments.
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application, optionally including an AWS SAM file to create the first application version in the same call.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the author publishing the app.</p><p>Minimum length=1. Maximum length=127.</p><p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author(inp);
            self
        }
        /// <p>The name of the author publishing the app.</p><p>Minimum length=1. Maximum length=127.</p><p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author(input);
            self
        }
        /// <p>The description of the application.</p><p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the application.</p><p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_page_url(inp);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_page_url(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p><p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p><p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p><p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p><p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>A local text file that contains the license of the app that matches the spdxLicenseID value of your application.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>Maximum size 5 MB</p><p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn license_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_body(inp);
            self
        }
        /// <p>A local text file that contains the license of the app that matches the spdxLicenseID value of your application.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>Maximum size 5 MB</p><p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn set_license_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_body(input);
            self
        }
        /// <p>A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.</p><p>Maximum size 5 MB</p><p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn license_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_url(inp);
            self
        }
        /// <p>A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.</p><p>Maximum size 5 MB</p><p>You can specify only one of licenseBody and licenseUrl; otherwise, an error results.</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_url(input);
            self
        }
        /// <p>The name of the application that you want to publish.</p><p>Minimum length=1. Maximum length=140</p><p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the application that you want to publish.</p><p>Minimum length=1. Maximum length=140</p><p>Pattern: "[a-zA-Z0-9\\-]+";</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A local text readme file in Markdown language that contains a more detailed description of the application and how it works.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>Maximum size 5 MB</p><p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn readme_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_body(inp);
            self
        }
        /// <p>A local text readme file in Markdown language that contains a more detailed description of the application and how it works.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>Maximum size 5 MB</p><p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn set_readme_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_body(input);
            self
        }
        /// <p>A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p><p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn readme_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_url(inp);
            self
        }
        /// <p>A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p><p>You can specify only one of readmeBody and readmeUrl; otherwise, an error results.</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_url(input);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p><p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_archive_url(inp);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p><p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_archive_url(input);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_url(inp);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_url(input);
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn spdx_license_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spdx_license_id(inp);
            self
        }
        /// <p>A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.</p>
        pub fn set_spdx_license_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_spdx_license_id(input);
            self
        }
        /// <p>The local raw packaged AWS SAM template file of your application.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>The local raw packaged AWS SAM template file of your application.
        /// The file has the format file://&lt;path>/&lt;filename>.</p><p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>A link to the S3 object containing the packaged AWS SAM template of your application.</p><p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>A link to the S3 object containing the packaged AWS SAM template of your application.</p><p>You can specify only one of templateBody and templateUrl; otherwise an error results.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplicationVersion`.
    ///
    /// <p>Creates an application version.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_version_input::Builder,
    }
    impl<C, M, R> CreateApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationVersionInputOperationOutputAlias,
                crate::output::CreateApplicationVersionOutput,
                crate::error::CreateApplicationVersionError,
                crate::input::CreateApplicationVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the new version.</p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the new version.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p><p>Maximum size 50 MB</p>
        pub fn source_code_archive_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_archive_url(inp);
            self
        }
        /// <p>A link to the S3 object that contains the ZIP archive of the source code for this version of your application.</p><p>Maximum size 50 MB</p>
        pub fn set_source_code_archive_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_archive_url(input);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn source_code_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_code_url(inp);
            self
        }
        /// <p>A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.</p>
        pub fn set_source_code_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_code_url(input);
            self
        }
        /// <p>The raw packaged AWS SAM template of your application.</p>
        pub fn template_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(inp);
            self
        }
        /// <p>The raw packaged AWS SAM template of your application.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn template_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_url(inp);
            self
        }
        /// <p>A link to the packaged AWS SAM template of your application.</p>
        pub fn set_template_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFormationChangeSet`.
    ///
    /// <p>Creates an AWS CloudFormation change set for the given application.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCloudFormationChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_formation_change_set_input::Builder,
    }
    impl<C, M, R> CreateCloudFormationChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFormationChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFormationChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFormationChangeSetInputOperationOutputAlias,
                crate::output::CreateCloudFormationChangeSetOutput,
                crate::error::CreateCloudFormationChangeSetError,
                crate::input::CreateCloudFormationChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// Appends an item to `Capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of values that you must specify before you can deploy certain applications.
        /// Some applications might include resources that can affect permissions in your AWS
        /// account, for example, by creating new AWS Identity and Access Management (IAM) users.
        /// For those applications, you must explicitly acknowledge their capabilities by
        /// specifying this parameter.</p><p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
        /// CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p><p>The following resources require you to specify CAPABILITY_IAM or
        /// CAPABILITY_NAMED_IAM:
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>.
        /// If the application contains IAM resources, you can specify either CAPABILITY_IAM
        /// or CAPABILITY_NAMED_IAM. If the application contains IAM resources
        /// with custom names, you must specify CAPABILITY_NAMED_IAM.</p><p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy</a>.</p><p>Applications that contain one or more nested applications require you to specify
        /// CAPABILITY_AUTO_EXPAND.</p><p>If your application template contains any of the above resources, we recommend that you review
        /// all permissions associated with the application before deploying. If you don't specify
        /// this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn capabilities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(inp);
            self
        }
        /// <p>A list of values that you must specify before you can deploy certain applications.
        /// Some applications might include resources that can affect permissions in your AWS
        /// account, for example, by creating new AWS Identity and Access Management (IAM) users.
        /// For those applications, you must explicitly acknowledge their capabilities by
        /// specifying this parameter.</p><p>The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
        /// CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.</p><p>The following resources require you to specify CAPABILITY_IAM or
        /// CAPABILITY_NAMED_IAM:
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy</a>, and
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role</a>.
        /// If the application contains IAM resources, you can specify either CAPABILITY_IAM
        /// or CAPABILITY_NAMED_IAM. If the application contains IAM resources
        /// with custom names, you must specify CAPABILITY_NAMED_IAM.</p><p>The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy</a>,
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy</a>, and
        /// <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy</a>.</p><p>Applications that contain one or more nested applications require you to specify
        /// CAPABILITY_AUTO_EXPAND.</p><p>If your application template contains any of the above resources, we recommend that you review
        /// all permissions associated with the application before deploying. If you don't specify
        /// this parameter for an application that requires capabilities, the call will fail.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `NotificationArns`.
        ///
        /// To override the contents of this collection use [`set_notification_arns`](Self::set_notification_arns).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn notification_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_arns(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_notification_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_notification_arns(input);
            self
        }
        /// Appends an item to `ParameterOverrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p>A list of parameter values for the parameters of the application.</p>
        pub fn parameter_overrides(mut self, inp: impl Into<crate::model::ParameterValue>) -> Self {
            self.inner = self.inner.parameter_overrides(inp);
            self
        }
        /// <p>A list of parameter values for the parameters of the application.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_overrides(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn resource_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn rollback_configuration(mut self, inp: crate::model::RollbackConfiguration) -> Self {
            self.inner = self.inner.rollback_configuration(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rollback_configuration(input);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>This property corresponds to the parameter of the same name for the <i>AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet</a>
        /// </i> API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p><p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p><p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFormationTemplate`.
    ///
    /// <p>Creates an AWS CloudFormation template.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCloudFormationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_formation_template_input::Builder,
    }
    impl<C, M, R> CreateCloudFormationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFormationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFormationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFormationTemplateInputOperationOutputAlias,
                crate::output::CreateCloudFormationTemplateOutput,
                crate::error::CreateCloudFormationTemplateError,
                crate::input::CreateCloudFormationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the application:</p><p>
        /// <a href="https://semver.org/">https://semver.org/</a>
        /// </p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplication`.
    ///
    /// <p>Gets the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_input::Builder,
    }
    impl<C, M, R> GetApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationInputOperationOutputAlias,
                crate::output::GetApplicationOutput,
                crate::error::GetApplicationError,
                crate::input::GetApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApplicationPolicy`.
    ///
    /// <p>Retrieves the policy for the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApplicationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_application_policy_input::Builder,
    }
    impl<C, M, R> GetApplicationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApplicationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApplicationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApplicationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApplicationPolicyInputOperationOutputAlias,
                crate::output::GetApplicationPolicyOutput,
                crate::error::GetApplicationPolicyError,
                crate::input::GetApplicationPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFormationTemplate`.
    ///
    /// <p>Gets the specified AWS CloudFormation template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCloudFormationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cloud_formation_template_input::Builder,
    }
    impl<C, M, R> GetCloudFormationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCloudFormationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFormationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCloudFormationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCloudFormationTemplateInputOperationOutputAlias,
                crate::output::GetCloudFormationTemplateOutput,
                crate::error::GetCloudFormationTemplateError,
                crate::input::GetCloudFormationTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p><p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The UUID returned by CreateCloudFormationTemplate.</p><p>Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationDependencies`.
    ///
    /// <p>Retrieves the list of applications nested in the containing application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplicationDependencies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_dependencies_input::Builder,
    }
    impl<C, M, R> ListApplicationDependencies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationDependencies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationDependenciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationDependenciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationDependenciesInputOperationOutputAlias,
                crate::output::ListApplicationDependenciesOutput,
                crate::error::ListApplicationDependenciesError,
                crate::input::ListApplicationDependenciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the application to get.</p>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <p>Lists applications owned by the requester.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl<C, M, R> ListApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationsInputOperationOutputAlias,
                crate::output::ListApplicationsOutput,
                crate::error::ListApplicationsError,
                crate::input::ListApplicationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplicationVersions`.
    ///
    /// <p>Lists versions for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApplicationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_application_versions_input::Builder,
    }
    impl<C, M, R> ListApplicationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApplicationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApplicationVersionsInputOperationOutputAlias,
                crate::output::ListApplicationVersionsOutput,
                crate::error::ListApplicationVersionsError,
                crate::input::ListApplicationVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The total number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutApplicationPolicy`.
    ///
    /// <p>Sets the permission policy for an application. For the list of actions supported for this operation, see
    /// <a href="https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions">Application
    /// Permissions</a>
    /// .</p>
    #[derive(std::fmt::Debug)]
    pub struct PutApplicationPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_application_policy_input::Builder,
    }
    impl<C, M, R> PutApplicationPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutApplicationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutApplicationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutApplicationPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutApplicationPolicyInputOperationOutputAlias,
                crate::output::PutApplicationPolicyOutput,
                crate::error::PutApplicationPolicyError,
                crate::input::PutApplicationPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// Appends an item to `Statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>An array of policy statements applied to the application.</p>
        pub fn statements(
            mut self,
            inp: impl Into<crate::model::ApplicationPolicyStatement>,
        ) -> Self {
            self.inner = self.inner.statements(inp);
            self
        }
        /// <p>An array of policy statements applied to the application.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationPolicyStatement>>,
        ) -> Self {
            self.inner = self.inner.set_statements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnshareApplication`.
    ///
    /// <p>Unshares an application from an AWS Organization.</p><p>This operation can be called only from the organization's master account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnshareApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unshare_application_input::Builder,
    }
    impl<C, M, R> UnshareApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnshareApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnshareApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UnshareApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnshareApplicationInputOperationOutputAlias,
                crate::output::UnshareApplicationOutput,
                crate::error::UnshareApplicationError,
                crate::input::UnshareApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The AWS Organization ID to unshare the application from.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>The AWS Organization ID to unshare the application from.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The name of the author publishing the app.</p><p>Minimum length=1. Maximum length=127.</p><p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn author(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author(inp);
            self
        }
        /// <p>The name of the author publishing the app.</p><p>Minimum length=1. Maximum length=127.</p><p>Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author(input);
            self
        }
        /// <p>The description of the application.</p><p>Minimum length=1. Maximum length=256</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the application.</p><p>Minimum length=1. Maximum length=256</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn home_page_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_page_url(inp);
            self
        }
        /// <p>A URL with more information about the application, for example the location of your GitHub repository for the application.</p>
        pub fn set_home_page_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_page_url(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels to improve discovery of apps in search results.</p><p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p><p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>Labels to improve discovery of apps in search results.</p><p>Minimum length=1. Maximum length=127. Maximum number of labels: 10</p><p>Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>A text readme file in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p>
        pub fn readme_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_body(inp);
            self
        }
        /// <p>A text readme file in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p>
        pub fn set_readme_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_body(input);
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p>
        pub fn readme_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readme_url(inp);
            self
        }
        /// <p>A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.</p><p>Maximum size 5 MB</p>
        pub fn set_readme_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_readme_url(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
