// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application`](crate::client::Client::create_application).
///
/// See [`crate::client::fluent_builders::CreateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplication {
    _private: (),
}
impl CreateApplication {
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
    /// Creates a new `CreateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplication {
    type Output = std::result::Result<
        crate::output::CreateApplicationOutput,
        crate::error::CreateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_application_error(response)
        } else {
            crate::operation_deser::parse_create_application_response(response)
        }
    }
}

/// Operation shape for `CreateApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_application_version`](crate::client::Client::create_application_version).
///
/// See [`crate::client::fluent_builders::CreateApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApplicationVersion {
    _private: (),
}
impl CreateApplicationVersion {
    /// Creates a new builder-style object to manufacture [`CreateApplicationVersionInput`](crate::input::CreateApplicationVersionInput)
    pub fn builder() -> crate::input::create_application_version_input::Builder {
        crate::input::create_application_version_input::Builder::default()
    }
    /// Creates a new `CreateApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApplicationVersion {
    type Output = std::result::Result<
        crate::output::CreateApplicationVersionOutput,
        crate::error::CreateApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_application_version_error(response)
        } else {
            crate::operation_deser::parse_create_application_version_response(response)
        }
    }
}

/// Operation shape for `CreateCloudFormationChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cloud_formation_change_set`](crate::client::Client::create_cloud_formation_change_set).
///
/// See [`crate::client::fluent_builders::CreateCloudFormationChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCloudFormationChangeSet {
    _private: (),
}
impl CreateCloudFormationChangeSet {
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationChangeSetInput`](crate::input::CreateCloudFormationChangeSetInput)
    pub fn builder() -> crate::input::create_cloud_formation_change_set_input::Builder {
        crate::input::create_cloud_formation_change_set_input::Builder::default()
    }
    /// Creates a new `CreateCloudFormationChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCloudFormationChangeSet {
    type Output = std::result::Result<
        crate::output::CreateCloudFormationChangeSetOutput,
        crate::error::CreateCloudFormationChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_cloud_formation_change_set_error(response)
        } else {
            crate::operation_deser::parse_create_cloud_formation_change_set_response(response)
        }
    }
}

/// Operation shape for `CreateCloudFormationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cloud_formation_template`](crate::client::Client::create_cloud_formation_template).
///
/// See [`crate::client::fluent_builders::CreateCloudFormationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCloudFormationTemplate {
    _private: (),
}
impl CreateCloudFormationTemplate {
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationTemplateInput`](crate::input::CreateCloudFormationTemplateInput)
    pub fn builder() -> crate::input::create_cloud_formation_template_input::Builder {
        crate::input::create_cloud_formation_template_input::Builder::default()
    }
    /// Creates a new `CreateCloudFormationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCloudFormationTemplate {
    type Output = std::result::Result<
        crate::output::CreateCloudFormationTemplateOutput,
        crate::error::CreateCloudFormationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_cloud_formation_template_error(response)
        } else {
            crate::operation_deser::parse_create_cloud_formation_template_response(response)
        }
    }
}

/// Operation shape for `DeleteApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_application`](crate::client::Client::delete_application).
///
/// See [`crate::client::fluent_builders::DeleteApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApplication {
    _private: (),
}
impl DeleteApplication {
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
    /// Creates a new `DeleteApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApplication {
    type Output = std::result::Result<
        crate::output::DeleteApplicationOutput,
        crate::error::DeleteApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_application_error(response)
        } else {
            crate::operation_deser::parse_delete_application_response(response)
        }
    }
}

/// Operation shape for `GetApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_application`](crate::client::Client::get_application).
///
/// See [`crate::client::fluent_builders::GetApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApplication {
    _private: (),
}
impl GetApplication {
    /// Creates a new builder-style object to manufacture [`GetApplicationInput`](crate::input::GetApplicationInput)
    pub fn builder() -> crate::input::get_application_input::Builder {
        crate::input::get_application_input::Builder::default()
    }
    /// Creates a new `GetApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApplication {
    type Output =
        std::result::Result<crate::output::GetApplicationOutput, crate::error::GetApplicationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_application_error(response)
        } else {
            crate::operation_deser::parse_get_application_response(response)
        }
    }
}

/// Operation shape for `GetApplicationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_application_policy`](crate::client::Client::get_application_policy).
///
/// See [`crate::client::fluent_builders::GetApplicationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApplicationPolicy {
    _private: (),
}
impl GetApplicationPolicy {
    /// Creates a new builder-style object to manufacture [`GetApplicationPolicyInput`](crate::input::GetApplicationPolicyInput)
    pub fn builder() -> crate::input::get_application_policy_input::Builder {
        crate::input::get_application_policy_input::Builder::default()
    }
    /// Creates a new `GetApplicationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApplicationPolicy {
    type Output = std::result::Result<
        crate::output::GetApplicationPolicyOutput,
        crate::error::GetApplicationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_application_policy_error(response)
        } else {
            crate::operation_deser::parse_get_application_policy_response(response)
        }
    }
}

/// Operation shape for `GetCloudFormationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cloud_formation_template`](crate::client::Client::get_cloud_formation_template).
///
/// See [`crate::client::fluent_builders::GetCloudFormationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCloudFormationTemplate {
    _private: (),
}
impl GetCloudFormationTemplate {
    /// Creates a new builder-style object to manufacture [`GetCloudFormationTemplateInput`](crate::input::GetCloudFormationTemplateInput)
    pub fn builder() -> crate::input::get_cloud_formation_template_input::Builder {
        crate::input::get_cloud_formation_template_input::Builder::default()
    }
    /// Creates a new `GetCloudFormationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCloudFormationTemplate {
    type Output = std::result::Result<
        crate::output::GetCloudFormationTemplateOutput,
        crate::error::GetCloudFormationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cloud_formation_template_error(response)
        } else {
            crate::operation_deser::parse_get_cloud_formation_template_response(response)
        }
    }
}

/// Operation shape for `ListApplicationDependencies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_application_dependencies`](crate::client::Client::list_application_dependencies).
///
/// See [`crate::client::fluent_builders::ListApplicationDependencies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplicationDependencies {
    _private: (),
}
impl ListApplicationDependencies {
    /// Creates a new builder-style object to manufacture [`ListApplicationDependenciesInput`](crate::input::ListApplicationDependenciesInput)
    pub fn builder() -> crate::input::list_application_dependencies_input::Builder {
        crate::input::list_application_dependencies_input::Builder::default()
    }
    /// Creates a new `ListApplicationDependencies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplicationDependencies {
    type Output = std::result::Result<
        crate::output::ListApplicationDependenciesOutput,
        crate::error::ListApplicationDependenciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_application_dependencies_error(response)
        } else {
            crate::operation_deser::parse_list_application_dependencies_response(response)
        }
    }
}

/// Operation shape for `ListApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_applications`](crate::client::Client::list_applications).
///
/// See [`crate::client::fluent_builders::ListApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplications {
    _private: (),
}
impl ListApplications {
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
    /// Creates a new `ListApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplications {
    type Output = std::result::Result<
        crate::output::ListApplicationsOutput,
        crate::error::ListApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_applications_error(response)
        } else {
            crate::operation_deser::parse_list_applications_response(response)
        }
    }
}

/// Operation shape for `ListApplicationVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_application_versions`](crate::client::Client::list_application_versions).
///
/// See [`crate::client::fluent_builders::ListApplicationVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApplicationVersions {
    _private: (),
}
impl ListApplicationVersions {
    /// Creates a new builder-style object to manufacture [`ListApplicationVersionsInput`](crate::input::ListApplicationVersionsInput)
    pub fn builder() -> crate::input::list_application_versions_input::Builder {
        crate::input::list_application_versions_input::Builder::default()
    }
    /// Creates a new `ListApplicationVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApplicationVersions {
    type Output = std::result::Result<
        crate::output::ListApplicationVersionsOutput,
        crate::error::ListApplicationVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_application_versions_error(response)
        } else {
            crate::operation_deser::parse_list_application_versions_response(response)
        }
    }
}

/// Operation shape for `PutApplicationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_application_policy`](crate::client::Client::put_application_policy).
///
/// See [`crate::client::fluent_builders::PutApplicationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutApplicationPolicy {
    _private: (),
}
impl PutApplicationPolicy {
    /// Creates a new builder-style object to manufacture [`PutApplicationPolicyInput`](crate::input::PutApplicationPolicyInput)
    pub fn builder() -> crate::input::put_application_policy_input::Builder {
        crate::input::put_application_policy_input::Builder::default()
    }
    /// Creates a new `PutApplicationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutApplicationPolicy {
    type Output = std::result::Result<
        crate::output::PutApplicationPolicyOutput,
        crate::error::PutApplicationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_application_policy_error(response)
        } else {
            crate::operation_deser::parse_put_application_policy_response(response)
        }
    }
}

/// Operation shape for `UnshareApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unshare_application`](crate::client::Client::unshare_application).
///
/// See [`crate::client::fluent_builders::UnshareApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnshareApplication {
    _private: (),
}
impl UnshareApplication {
    /// Creates a new builder-style object to manufacture [`UnshareApplicationInput`](crate::input::UnshareApplicationInput)
    pub fn builder() -> crate::input::unshare_application_input::Builder {
        crate::input::unshare_application_input::Builder::default()
    }
    /// Creates a new `UnshareApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnshareApplication {
    type Output = std::result::Result<
        crate::output::UnshareApplicationOutput,
        crate::error::UnshareApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_unshare_application_error(response)
        } else {
            crate::operation_deser::parse_unshare_application_response(response)
        }
    }
}

/// Operation shape for `UpdateApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application`](crate::client::Client::update_application).
///
/// See [`crate::client::fluent_builders::UpdateApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplication {
    _private: (),
}
impl UpdateApplication {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
    /// Creates a new `UpdateApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplication {
    type Output = std::result::Result<
        crate::output::UpdateApplicationOutput,
        crate::error::UpdateApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_error(response)
        } else {
            crate::operation_deser::parse_update_application_response(response)
        }
    }
}
