// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS SecurityHub
///
/// Client for invoking operations on AWS SecurityHub. Each operation on AWS SecurityHub is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_securityhub::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_securityhub::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_securityhub::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptAdministratorInvitation`](crate::client::fluent_builders::AcceptAdministratorInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`administrator_id(impl Into<String>)`](crate::client::fluent_builders::AcceptAdministratorInvitation::administrator_id) / [`set_administrator_id(Option<String>)`](crate::client::fluent_builders::AcceptAdministratorInvitation::set_administrator_id): <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    ///   - [`invitation_id(impl Into<String>)`](crate::client::fluent_builders::AcceptAdministratorInvitation::invitation_id) / [`set_invitation_id(Option<String>)`](crate::client::fluent_builders::AcceptAdministratorInvitation::set_invitation_id): <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    /// - On success, responds with [`AcceptAdministratorInvitationOutput`](crate::output::AcceptAdministratorInvitationOutput)

    /// - On failure, responds with [`SdkError<AcceptAdministratorInvitationError>`](crate::error::AcceptAdministratorInvitationError)
    pub fn accept_administrator_invitation(
        &self,
    ) -> fluent_builders::AcceptAdministratorInvitation<C, M, R> {
        fluent_builders::AcceptAdministratorInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptInvitation`](crate::client::fluent_builders::AcceptInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`master_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::master_id) / [`set_master_id(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_master_id): <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    ///   - [`invitation_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::invitation_id) / [`set_invitation_id(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_invitation_id): <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    /// - On success, responds with [`AcceptInvitationOutput`](crate::output::AcceptInvitationOutput)

    /// - On failure, responds with [`SdkError<AcceptInvitationError>`](crate::error::AcceptInvitationError)
    pub fn accept_invitation(&self) -> fluent_builders::AcceptInvitation<C, M, R> {
        fluent_builders::AcceptInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisableStandards`](crate::client::fluent_builders::BatchDisableStandards) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`standards_subscription_arns(Vec<String>)`](crate::client::fluent_builders::BatchDisableStandards::standards_subscription_arns) / [`set_standards_subscription_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDisableStandards::set_standards_subscription_arns): <p>The ARNs of the standards subscriptions to disable.</p>
    /// - On success, responds with [`BatchDisableStandardsOutput`](crate::output::BatchDisableStandardsOutput) with field(s):
    ///   - [`standards_subscriptions(Option<Vec<StandardsSubscription>>)`](crate::output::BatchDisableStandardsOutput::standards_subscriptions): <p>The details of the standards subscriptions that were disabled.</p>
    /// - On failure, responds with [`SdkError<BatchDisableStandardsError>`](crate::error::BatchDisableStandardsError)
    pub fn batch_disable_standards(&self) -> fluent_builders::BatchDisableStandards<C, M, R> {
        fluent_builders::BatchDisableStandards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchEnableStandards`](crate::client::fluent_builders::BatchEnableStandards) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`standards_subscription_requests(Vec<StandardsSubscriptionRequest>)`](crate::client::fluent_builders::BatchEnableStandards::standards_subscription_requests) / [`set_standards_subscription_requests(Option<Vec<StandardsSubscriptionRequest>>)`](crate::client::fluent_builders::BatchEnableStandards::set_standards_subscription_requests): <p>The list of standards checks to enable.</p>
    /// - On success, responds with [`BatchEnableStandardsOutput`](crate::output::BatchEnableStandardsOutput) with field(s):
    ///   - [`standards_subscriptions(Option<Vec<StandardsSubscription>>)`](crate::output::BatchEnableStandardsOutput::standards_subscriptions): <p>The details of the standards subscriptions that were enabled.</p>
    /// - On failure, responds with [`SdkError<BatchEnableStandardsError>`](crate::error::BatchEnableStandardsError)
    pub fn batch_enable_standards(&self) -> fluent_builders::BatchEnableStandards<C, M, R> {
        fluent_builders::BatchEnableStandards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchImportFindings`](crate::client::fluent_builders::BatchImportFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`findings(Vec<AwsSecurityFinding>)`](crate::client::fluent_builders::BatchImportFindings::findings) / [`set_findings(Option<Vec<AwsSecurityFinding>>)`](crate::client::fluent_builders::BatchImportFindings::set_findings): <p>A list of findings to import. To successfully import a finding, it must follow the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
    /// - On success, responds with [`BatchImportFindingsOutput`](crate::output::BatchImportFindingsOutput) with field(s):
    ///   - [`failed_count(i32)`](crate::output::BatchImportFindingsOutput::failed_count): <p>The number of findings that failed to import.</p>
    ///   - [`success_count(i32)`](crate::output::BatchImportFindingsOutput::success_count): <p>The number of findings that were successfully imported.</p>
    ///   - [`failed_findings(Option<Vec<ImportFindingsError>>)`](crate::output::BatchImportFindingsOutput::failed_findings): <p>The list of findings that failed to import.</p>
    /// - On failure, responds with [`SdkError<BatchImportFindingsError>`](crate::error::BatchImportFindingsError)
    pub fn batch_import_findings(&self) -> fluent_builders::BatchImportFindings<C, M, R> {
        fluent_builders::BatchImportFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchUpdateFindings`](crate::client::fluent_builders::BatchUpdateFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_identifiers(Vec<AwsSecurityFindingIdentifier>)`](crate::client::fluent_builders::BatchUpdateFindings::finding_identifiers) / [`set_finding_identifiers(Option<Vec<AwsSecurityFindingIdentifier>>)`](crate::client::fluent_builders::BatchUpdateFindings::set_finding_identifiers): <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a time.</p>  <p>For each finding, the list provides the finding identifier and the ARN of the finding provider.</p>
    ///   - [`note(NoteUpdate)`](crate::client::fluent_builders::BatchUpdateFindings::note) / [`set_note(Option<NoteUpdate>)`](crate::client::fluent_builders::BatchUpdateFindings::set_note): <p>The updated note.</p>
    ///   - [`severity(SeverityUpdate)`](crate::client::fluent_builders::BatchUpdateFindings::severity) / [`set_severity(Option<SeverityUpdate>)`](crate::client::fluent_builders::BatchUpdateFindings::set_severity): <p>Used to update the finding severity.</p>
    ///   - [`verification_state(VerificationState)`](crate::client::fluent_builders::BatchUpdateFindings::verification_state) / [`set_verification_state(Option<VerificationState>)`](crate::client::fluent_builders::BatchUpdateFindings::set_verification_state): <p>Indicates the veracity of a finding.</p>  <p>The available values for <code>VerificationState</code> are as follows.</p>  <ul>   <li> <p> <code>UNKNOWN</code> – The default disposition of a security finding</p> </li>   <li> <p> <code>TRUE_POSITIVE</code> – The security finding is confirmed</p> </li>   <li> <p> <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm</p> </li>   <li> <p> <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose any threat, is expected, or both</p> </li>  </ul>
    ///   - [`confidence(i32)`](crate::client::fluent_builders::BatchUpdateFindings::confidence) / [`set_confidence(i32)`](crate::client::fluent_builders::BatchUpdateFindings::set_confidence): <p>The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p>  <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
    ///   - [`criticality(i32)`](crate::client::fluent_builders::BatchUpdateFindings::criticality) / [`set_criticality(i32)`](crate::client::fluent_builders::BatchUpdateFindings::set_criticality): <p>The updated value for the level of importance assigned to the resources associated with the findings.</p>  <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>
    ///   - [`types(Vec<String>)`](crate::client::fluent_builders::BatchUpdateFindings::types) / [`set_types(Option<Vec<String>>)`](crate::client::fluent_builders::BatchUpdateFindings::set_types): <p>One or more finding types in the format of namespace/category/classifier that classify a finding.</p>  <p>Valid namespace values are as follows.</p>  <ul>   <li> <p>Software and Configuration Checks</p> </li>   <li> <p>TTPs</p> </li>   <li> <p>Effects</p> </li>   <li> <p>Unusual Behaviors</p> </li>   <li> <p>Sensitive Data Identifications </p> </li>  </ul>
    ///   - [`user_defined_fields(HashMap<String, String>)`](crate::client::fluent_builders::BatchUpdateFindings::user_defined_fields) / [`set_user_defined_fields(Option<HashMap<String, String>>)`](crate::client::fluent_builders::BatchUpdateFindings::set_user_defined_fields): <p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p>
    ///   - [`workflow(WorkflowUpdate)`](crate::client::fluent_builders::BatchUpdateFindings::workflow) / [`set_workflow(Option<WorkflowUpdate>)`](crate::client::fluent_builders::BatchUpdateFindings::set_workflow): <p>Used to update the workflow status of a finding.</p>  <p>The workflow status indicates the progress of the investigation into the finding. </p>
    ///   - [`related_findings(Vec<RelatedFinding>)`](crate::client::fluent_builders::BatchUpdateFindings::related_findings) / [`set_related_findings(Option<Vec<RelatedFinding>>)`](crate::client::fluent_builders::BatchUpdateFindings::set_related_findings): <p>A list of findings that are related to the updated findings.</p>
    /// - On success, responds with [`BatchUpdateFindingsOutput`](crate::output::BatchUpdateFindingsOutput) with field(s):
    ///   - [`processed_findings(Option<Vec<AwsSecurityFindingIdentifier>>)`](crate::output::BatchUpdateFindingsOutput::processed_findings): <p>The list of findings that were updated successfully.</p>
    ///   - [`unprocessed_findings(Option<Vec<BatchUpdateFindingsUnprocessedFinding>>)`](crate::output::BatchUpdateFindingsOutput::unprocessed_findings): <p>The list of findings that were not updated.</p>
    /// - On failure, responds with [`SdkError<BatchUpdateFindingsError>`](crate::error::BatchUpdateFindingsError)
    pub fn batch_update_findings(&self) -> fluent_builders::BatchUpdateFindings<C, M, R> {
        fluent_builders::BatchUpdateFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateActionTarget`](crate::client::fluent_builders::CreateActionTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateActionTarget::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateActionTarget::set_name): <p>The name of the custom action target. Can contain up to 20 characters.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateActionTarget::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateActionTarget::set_description): <p>The description for the custom action target.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateActionTarget::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateActionTarget::set_id): <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
    /// - On success, responds with [`CreateActionTargetOutput`](crate::output::CreateActionTargetOutput) with field(s):
    ///   - [`action_target_arn(Option<String>)`](crate::output::CreateActionTargetOutput::action_target_arn): <p>The ARN for the custom action target.</p>
    /// - On failure, responds with [`SdkError<CreateActionTargetError>`](crate::error::CreateActionTargetError)
    pub fn create_action_target(&self) -> fluent_builders::CreateActionTarget<C, M, R> {
        fluent_builders::CreateActionTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFindingAggregator`](crate::client::fluent_builders::CreateFindingAggregator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`region_linking_mode(impl Into<String>)`](crate::client::fluent_builders::CreateFindingAggregator::region_linking_mode) / [`set_region_linking_mode(Option<String>)`](crate::client::fluent_builders::CreateFindingAggregator::set_region_linking_mode): <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>  <p>The selected option also determines how to use the Regions provided in the Regions list.</p>  <p>The options are as follows:</p>  <ul>   <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>   <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>   <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>  </ul>
    ///   - [`regions(Vec<String>)`](crate::client::fluent_builders::CreateFindingAggregator::regions) / [`set_regions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFindingAggregator::set_regions): <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>  <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region. </p>
    /// - On success, responds with [`CreateFindingAggregatorOutput`](crate::output::CreateFindingAggregatorOutput) with field(s):
    ///   - [`finding_aggregator_arn(Option<String>)`](crate::output::CreateFindingAggregatorOutput::finding_aggregator_arn): <p>The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and stop finding aggregation.</p>
    ///   - [`finding_aggregation_region(Option<String>)`](crate::output::CreateFindingAggregatorOutput::finding_aggregation_region): <p>The aggregation Region.</p>
    ///   - [`region_linking_mode(Option<String>)`](crate::output::CreateFindingAggregatorOutput::region_linking_mode): <p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>
    ///   - [`regions(Option<Vec<String>>)`](crate::output::CreateFindingAggregatorOutput::regions): <p>The list of excluded Regions or included Regions.</p>
    /// - On failure, responds with [`SdkError<CreateFindingAggregatorError>`](crate::error::CreateFindingAggregatorError)
    pub fn create_finding_aggregator(&self) -> fluent_builders::CreateFindingAggregator<C, M, R> {
        fluent_builders::CreateFindingAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInsight`](crate::client::fluent_builders::CreateInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateInsight::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateInsight::set_name): <p>The name of the custom insight to create.</p>
    ///   - [`filters(AwsSecurityFindingFilters)`](crate::client::fluent_builders::CreateInsight::filters) / [`set_filters(Option<AwsSecurityFindingFilters>)`](crate::client::fluent_builders::CreateInsight::set_filters): <p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>
    ///   - [`group_by_attribute(impl Into<String>)`](crate::client::fluent_builders::CreateInsight::group_by_attribute) / [`set_group_by_attribute(Option<String>)`](crate::client::fluent_builders::CreateInsight::set_group_by_attribute): <p>The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>
    /// - On success, responds with [`CreateInsightOutput`](crate::output::CreateInsightOutput) with field(s):
    ///   - [`insight_arn(Option<String>)`](crate::output::CreateInsightOutput::insight_arn): <p>The ARN of the insight created.</p>
    /// - On failure, responds with [`SdkError<CreateInsightError>`](crate::error::CreateInsightError)
    pub fn create_insight(&self) -> fluent_builders::CreateInsight<C, M, R> {
        fluent_builders::CreateInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMembers`](crate::client::fluent_builders::CreateMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_details(Vec<AccountDetails>)`](crate::client::fluent_builders::CreateMembers::account_details) / [`set_account_details(Option<Vec<AccountDetails>>)`](crate::client::fluent_builders::CreateMembers::set_account_details): <p>The list of accounts to associate with the Security Hub administrator account. For each account, the list includes the account ID and optionally the email address.</p>
    /// - On success, responds with [`CreateMembersOutput`](crate::output::CreateMembersOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::CreateMembersOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts that were not processed. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<CreateMembersError>`](crate::error::CreateMembersError)
    pub fn create_members(&self) -> fluent_builders::CreateMembers<C, M, R> {
        fluent_builders::CreateMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeclineInvitations`](crate::client::fluent_builders::DeclineInvitations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeclineInvitations::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeclineInvitations::set_account_ids): <p>The list of account IDs for the accounts from which to decline the invitations to Security Hub.</p>
    /// - On success, responds with [`DeclineInvitationsOutput`](crate::output::DeclineInvitationsOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::DeclineInvitationsOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts that were not processed. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<DeclineInvitationsError>`](crate::error::DeclineInvitationsError)
    pub fn decline_invitations(&self) -> fluent_builders::DeclineInvitations<C, M, R> {
        fluent_builders::DeclineInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteActionTarget`](crate::client::fluent_builders::DeleteActionTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_target_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteActionTarget::action_target_arn) / [`set_action_target_arn(Option<String>)`](crate::client::fluent_builders::DeleteActionTarget::set_action_target_arn): <p>The ARN of the custom action target to delete.</p>
    /// - On success, responds with [`DeleteActionTargetOutput`](crate::output::DeleteActionTargetOutput) with field(s):
    ///   - [`action_target_arn(Option<String>)`](crate::output::DeleteActionTargetOutput::action_target_arn): <p>The ARN of the custom action target that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteActionTargetError>`](crate::error::DeleteActionTargetError)
    pub fn delete_action_target(&self) -> fluent_builders::DeleteActionTarget<C, M, R> {
        fluent_builders::DeleteActionTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFindingAggregator`](crate::client::fluent_builders::DeleteFindingAggregator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_aggregator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFindingAggregator::finding_aggregator_arn) / [`set_finding_aggregator_arn(Option<String>)`](crate::client::fluent_builders::DeleteFindingAggregator::set_finding_aggregator_arn): <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    /// - On success, responds with [`DeleteFindingAggregatorOutput`](crate::output::DeleteFindingAggregatorOutput)

    /// - On failure, responds with [`SdkError<DeleteFindingAggregatorError>`](crate::error::DeleteFindingAggregatorError)
    pub fn delete_finding_aggregator(&self) -> fluent_builders::DeleteFindingAggregator<C, M, R> {
        fluent_builders::DeleteFindingAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInsight`](crate::client::fluent_builders::DeleteInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteInsight::insight_arn) / [`set_insight_arn(Option<String>)`](crate::client::fluent_builders::DeleteInsight::set_insight_arn): <p>The ARN of the insight to delete.</p>
    /// - On success, responds with [`DeleteInsightOutput`](crate::output::DeleteInsightOutput) with field(s):
    ///   - [`insight_arn(Option<String>)`](crate::output::DeleteInsightOutput::insight_arn): <p>The ARN of the insight that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteInsightError>`](crate::error::DeleteInsightError)
    pub fn delete_insight(&self) -> fluent_builders::DeleteInsight<C, M, R> {
        fluent_builders::DeleteInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInvitations`](crate::client::fluent_builders::DeleteInvitations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeleteInvitations::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteInvitations::set_account_ids): <p>The list of the account IDs that sent the invitations to delete.</p>
    /// - On success, responds with [`DeleteInvitationsOutput`](crate::output::DeleteInvitationsOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::DeleteInvitationsOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts for which the invitations were not deleted. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<DeleteInvitationsError>`](crate::error::DeleteInvitationsError)
    pub fn delete_invitations(&self) -> fluent_builders::DeleteInvitations<C, M, R> {
        fluent_builders::DeleteInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMembers`](crate::client::fluent_builders::DeleteMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeleteMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteMembers::set_account_ids): <p>The list of account IDs for the member accounts to delete.</p>
    /// - On success, responds with [`DeleteMembersOutput`](crate::output::DeleteMembersOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::DeleteMembersOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts that were not deleted. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<DeleteMembersError>`](crate::error::DeleteMembersError)
    pub fn delete_members(&self) -> fluent_builders::DeleteMembers<C, M, R> {
        fluent_builders::DeleteMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActionTargets`](crate::client::fluent_builders::DescribeActionTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeActionTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_target_arns(Vec<String>)`](crate::client::fluent_builders::DescribeActionTargets::action_target_arns) / [`set_action_target_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeActionTargets::set_action_target_arns): <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeActionTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeActionTargets::set_next_token): <p>The token that is required for pagination. On your first call to the <code>DescribeActionTargets</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeActionTargets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeActionTargets::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`DescribeActionTargetsOutput`](crate::output::DescribeActionTargetsOutput) with field(s):
    ///   - [`action_targets(Option<Vec<ActionTarget>>)`](crate::output::DescribeActionTargetsOutput::action_targets): <p>A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>, <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeActionTargetsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeActionTargetsError>`](crate::error::DescribeActionTargetsError)
    pub fn describe_action_targets(&self) -> fluent_builders::DescribeActionTargets<C, M, R> {
        fluent_builders::DescribeActionTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHub`](crate::client::fluent_builders::DescribeHub) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hub_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeHub::hub_arn) / [`set_hub_arn(Option<String>)`](crate::client::fluent_builders::DescribeHub::set_hub_arn): <p>The ARN of the Hub resource to retrieve.</p>
    /// - On success, responds with [`DescribeHubOutput`](crate::output::DescribeHubOutput) with field(s):
    ///   - [`hub_arn(Option<String>)`](crate::output::DescribeHubOutput::hub_arn): <p>The ARN of the Hub resource that was retrieved.</p>
    ///   - [`subscribed_at(Option<String>)`](crate::output::DescribeHubOutput::subscribed_at): <p>The date and time when Security Hub was enabled in the account.</p>
    ///   - [`auto_enable_controls(bool)`](crate::output::DescribeHubOutput::auto_enable_controls): <p>Whether to automatically enable new controls when they are added to standards that are enabled.</p>  <p>If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to <code>false</code>, then new controls are not enabled.</p>
    /// - On failure, responds with [`SdkError<DescribeHubError>`](crate::error::DescribeHubError)
    pub fn describe_hub(&self) -> fluent_builders::DescribeHub<C, M, R> {
        fluent_builders::DescribeHub::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeOrganizationConfiguration::send) it.

    /// - On success, responds with [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput) with field(s):
    ///   - [`auto_enable(bool)`](crate::output::DescribeOrganizationConfigurationOutput::auto_enable): <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>  <p>If set to <code>true</code>, then Security Hub is enabled for new accounts. If set to false, then new accounts are not added automatically.</p>
    ///   - [`member_account_limit_reached(bool)`](crate::output::DescribeOrganizationConfigurationOutput::member_account_limit_reached): <p>Whether the maximum number of allowed member accounts are already associated with the Security Hub administrator account.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationConfigurationError>`](crate::error::DescribeOrganizationConfigurationError)
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration<C, M, R> {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProducts`](crate::client::fluent_builders::DescribeProducts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeProducts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeProducts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeProducts::set_next_token): <p>The token that is required for pagination. On your first call to the <code>DescribeProducts</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeProducts::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeProducts::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`product_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeProducts::product_arn) / [`set_product_arn(Option<String>)`](crate::client::fluent_builders::DescribeProducts::set_product_arn): <p>The ARN of the integration to return.</p>
    /// - On success, responds with [`DescribeProductsOutput`](crate::output::DescribeProductsOutput) with field(s):
    ///   - [`products(Option<Vec<Product>>)`](crate::output::DescribeProductsOutput::products): <p>A list of products, including details for each product.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeProductsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeProductsError>`](crate::error::DescribeProductsError)
    pub fn describe_products(&self) -> fluent_builders::DescribeProducts<C, M, R> {
        fluent_builders::DescribeProducts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStandards`](crate::client::fluent_builders::DescribeStandards) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeStandards::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStandards::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStandards::set_next_token): <p>The token that is required for pagination. On your first call to the <code>DescribeStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeStandards::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeStandards::set_max_results): <p>The maximum number of standards to return.</p>
    /// - On success, responds with [`DescribeStandardsOutput`](crate::output::DescribeStandardsOutput) with field(s):
    ///   - [`standards(Option<Vec<Standard>>)`](crate::output::DescribeStandardsOutput::standards): <p>A list of available standards.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStandardsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeStandardsError>`](crate::error::DescribeStandardsError)
    pub fn describe_standards(&self) -> fluent_builders::DescribeStandards<C, M, R> {
        fluent_builders::DescribeStandards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStandardsControls`](crate::client::fluent_builders::DescribeStandardsControls) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeStandardsControls::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`standards_subscription_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeStandardsControls::standards_subscription_arn) / [`set_standards_subscription_arn(Option<String>)`](crate::client::fluent_builders::DescribeStandardsControls::set_standards_subscription_arn): <p>The ARN of a resource that represents your subscription to a supported standard. To get the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStandardsControls::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStandardsControls::set_next_token): <p>The token that is required for pagination. On your first call to the <code>DescribeStandardsControls</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeStandardsControls::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeStandardsControls::set_max_results): <p>The maximum number of security standard controls to return.</p>
    /// - On success, responds with [`DescribeStandardsControlsOutput`](crate::output::DescribeStandardsControlsOutput) with field(s):
    ///   - [`controls(Option<Vec<StandardsControl>>)`](crate::output::DescribeStandardsControlsOutput::controls): <p>A list of security standards controls.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStandardsControlsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeStandardsControlsError>`](crate::error::DescribeStandardsControlsError)
    pub fn describe_standards_controls(
        &self,
    ) -> fluent_builders::DescribeStandardsControls<C, M, R> {
        fluent_builders::DescribeStandardsControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableImportFindingsForProduct`](crate::client::fluent_builders::DisableImportFindingsForProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_subscription_arn(impl Into<String>)`](crate::client::fluent_builders::DisableImportFindingsForProduct::product_subscription_arn) / [`set_product_subscription_arn(Option<String>)`](crate::client::fluent_builders::DisableImportFindingsForProduct::set_product_subscription_arn): <p>The ARN of the integrated product to disable the integration for.</p>
    /// - On success, responds with [`DisableImportFindingsForProductOutput`](crate::output::DisableImportFindingsForProductOutput)

    /// - On failure, responds with [`SdkError<DisableImportFindingsForProductError>`](crate::error::DisableImportFindingsForProductError)
    pub fn disable_import_findings_for_product(
        &self,
    ) -> fluent_builders::DisableImportFindingsForProduct<C, M, R> {
        fluent_builders::DisableImportFindingsForProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableOrganizationAdminAccount`](crate::client::fluent_builders::DisableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::DisableOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::DisableOrganizationAdminAccount::set_admin_account_id): <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
    /// - On success, responds with [`DisableOrganizationAdminAccountOutput`](crate::output::DisableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<DisableOrganizationAdminAccountError>`](crate::error::DisableOrganizationAdminAccountError)
    pub fn disable_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableOrganizationAdminAccount<C, M, R> {
        fluent_builders::DisableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableSecurityHub`](crate::client::fluent_builders::DisableSecurityHub) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableSecurityHub::send) it.

    /// - On success, responds with [`DisableSecurityHubOutput`](crate::output::DisableSecurityHubOutput)

    /// - On failure, responds with [`SdkError<DisableSecurityHubError>`](crate::error::DisableSecurityHubError)
    pub fn disable_security_hub(&self) -> fluent_builders::DisableSecurityHub<C, M, R> {
        fluent_builders::DisableSecurityHub::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFromAdministratorAccount`](crate::client::fluent_builders::DisassociateFromAdministratorAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateFromAdministratorAccount::send) it.

    /// - On success, responds with [`DisassociateFromAdministratorAccountOutput`](crate::output::DisassociateFromAdministratorAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateFromAdministratorAccountError>`](crate::error::DisassociateFromAdministratorAccountError)
    pub fn disassociate_from_administrator_account(
        &self,
    ) -> fluent_builders::DisassociateFromAdministratorAccount<C, M, R> {
        fluent_builders::DisassociateFromAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFromMasterAccount`](crate::client::fluent_builders::DisassociateFromMasterAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateFromMasterAccount::send) it.

    /// - On success, responds with [`DisassociateFromMasterAccountOutput`](crate::output::DisassociateFromMasterAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateFromMasterAccountError>`](crate::error::DisassociateFromMasterAccountError)
    pub fn disassociate_from_master_account(
        &self,
    ) -> fluent_builders::DisassociateFromMasterAccount<C, M, R> {
        fluent_builders::DisassociateFromMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMembers`](crate::client::fluent_builders::DisassociateMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateMembers::set_account_ids): <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
    /// - On success, responds with [`DisassociateMembersOutput`](crate::output::DisassociateMembersOutput)

    /// - On failure, responds with [`SdkError<DisassociateMembersError>`](crate::error::DisassociateMembersError)
    pub fn disassociate_members(&self) -> fluent_builders::DisassociateMembers<C, M, R> {
        fluent_builders::DisassociateMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableImportFindingsForProduct`](crate::client::fluent_builders::EnableImportFindingsForProduct) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_arn(impl Into<String>)`](crate::client::fluent_builders::EnableImportFindingsForProduct::product_arn) / [`set_product_arn(Option<String>)`](crate::client::fluent_builders::EnableImportFindingsForProduct::set_product_arn): <p>The ARN of the product to enable the integration for.</p>
    /// - On success, responds with [`EnableImportFindingsForProductOutput`](crate::output::EnableImportFindingsForProductOutput) with field(s):
    ///   - [`product_subscription_arn(Option<String>)`](crate::output::EnableImportFindingsForProductOutput::product_subscription_arn): <p>The ARN of your subscription to the product to enable integrations for.</p>
    /// - On failure, responds with [`SdkError<EnableImportFindingsForProductError>`](crate::error::EnableImportFindingsForProductError)
    pub fn enable_import_findings_for_product(
        &self,
    ) -> fluent_builders::EnableImportFindingsForProduct<C, M, R> {
        fluent_builders::EnableImportFindingsForProduct::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableOrganizationAdminAccount`](crate::client::fluent_builders::EnableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::set_admin_account_id): <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.</p>
    /// - On success, responds with [`EnableOrganizationAdminAccountOutput`](crate::output::EnableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<EnableOrganizationAdminAccountError>`](crate::error::EnableOrganizationAdminAccountError)
    pub fn enable_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableOrganizationAdminAccount<C, M, R> {
        fluent_builders::EnableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableSecurityHub`](crate::client::fluent_builders::EnableSecurityHub) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::EnableSecurityHub::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::EnableSecurityHub::set_tags): <p>The tags to add to the hub resource when you enable Security Hub.</p>
    ///   - [`enable_default_standards(bool)`](crate::client::fluent_builders::EnableSecurityHub::enable_default_standards) / [`set_enable_default_standards(bool)`](crate::client::fluent_builders::EnableSecurityHub::set_enable_default_standards): <p>Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>
    /// - On success, responds with [`EnableSecurityHubOutput`](crate::output::EnableSecurityHubOutput)

    /// - On failure, responds with [`SdkError<EnableSecurityHubError>`](crate::error::EnableSecurityHubError)
    pub fn enable_security_hub(&self) -> fluent_builders::EnableSecurityHub<C, M, R> {
        fluent_builders::EnableSecurityHub::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAdministratorAccount`](crate::client::fluent_builders::GetAdministratorAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAdministratorAccount::send) it.

    /// - On success, responds with [`GetAdministratorAccountOutput`](crate::output::GetAdministratorAccountOutput) with field(s):
    ///   - [`administrator(Option<Invitation>)`](crate::output::GetAdministratorAccountOutput::administrator): <p>Details about an invitation.</p>
    /// - On failure, responds with [`SdkError<GetAdministratorAccountError>`](crate::error::GetAdministratorAccountError)
    pub fn get_administrator_account(&self) -> fluent_builders::GetAdministratorAccount<C, M, R> {
        fluent_builders::GetAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEnabledStandards`](crate::client::fluent_builders::GetEnabledStandards) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEnabledStandards::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`standards_subscription_arns(Vec<String>)`](crate::client::fluent_builders::GetEnabledStandards::standards_subscription_arns) / [`set_standards_subscription_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetEnabledStandards::set_standards_subscription_arns): <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEnabledStandards::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEnabledStandards::set_next_token): <p>The token that is required for pagination. On your first call to the <code>GetEnabledStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEnabledStandards::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetEnabledStandards::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`GetEnabledStandardsOutput`](crate::output::GetEnabledStandardsOutput) with field(s):
    ///   - [`standards_subscriptions(Option<Vec<StandardsSubscription>>)`](crate::output::GetEnabledStandardsOutput::standards_subscriptions): <p>The list of <code>StandardsSubscriptions</code> objects that include information about the enabled standards.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEnabledStandardsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetEnabledStandardsError>`](crate::error::GetEnabledStandardsError)
    pub fn get_enabled_standards(&self) -> fluent_builders::GetEnabledStandards<C, M, R> {
        fluent_builders::GetEnabledStandards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindingAggregator`](crate::client::fluent_builders::GetFindingAggregator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_aggregator_arn(impl Into<String>)`](crate::client::fluent_builders::GetFindingAggregator::finding_aggregator_arn) / [`set_finding_aggregator_arn(Option<String>)`](crate::client::fluent_builders::GetFindingAggregator::set_finding_aggregator_arn): <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    /// - On success, responds with [`GetFindingAggregatorOutput`](crate::output::GetFindingAggregatorOutput) with field(s):
    ///   - [`finding_aggregator_arn(Option<String>)`](crate::output::GetFindingAggregatorOutput::finding_aggregator_arn): <p>The ARN of the finding aggregator.</p>
    ///   - [`finding_aggregation_region(Option<String>)`](crate::output::GetFindingAggregatorOutput::finding_aggregation_region): <p>The aggregation Region.</p>
    ///   - [`region_linking_mode(Option<String>)`](crate::output::GetFindingAggregatorOutput::region_linking_mode): <p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>
    ///   - [`regions(Option<Vec<String>>)`](crate::output::GetFindingAggregatorOutput::regions): <p>The list of excluded Regions or included Regions.</p>
    /// - On failure, responds with [`SdkError<GetFindingAggregatorError>`](crate::error::GetFindingAggregatorError)
    pub fn get_finding_aggregator(&self) -> fluent_builders::GetFindingAggregator<C, M, R> {
        fluent_builders::GetFindingAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindings`](crate::client::fluent_builders::GetFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(AwsSecurityFindingFilters)`](crate::client::fluent_builders::GetFindings::filters) / [`set_filters(Option<AwsSecurityFindingFilters>)`](crate::client::fluent_builders::GetFindings::set_filters): <p>The finding attributes used to define a condition to filter the returned findings.</p>  <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.</p>  <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
    ///   - [`sort_criteria(Vec<SortCriterion>)`](crate::client::fluent_builders::GetFindings::sort_criteria) / [`set_sort_criteria(Option<Vec<SortCriterion>>)`](crate::client::fluent_builders::GetFindings::set_sort_criteria): <p>The finding attributes used to sort the list of returned findings.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetFindings::set_next_token): <p>The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetFindings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetFindings::set_max_results): <p>The maximum number of findings to return.</p>
    /// - On success, responds with [`GetFindingsOutput`](crate::output::GetFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<AwsSecurityFinding>>)`](crate::output::GetFindingsOutput::findings): <p>The findings that matched the filters specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetFindingsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetFindingsError>`](crate::error::GetFindingsError)
    pub fn get_findings(&self) -> fluent_builders::GetFindings<C, M, R> {
        fluent_builders::GetFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsightResults`](crate::client::fluent_builders::GetInsightResults) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_arn(impl Into<String>)`](crate::client::fluent_builders::GetInsightResults::insight_arn) / [`set_insight_arn(Option<String>)`](crate::client::fluent_builders::GetInsightResults::set_insight_arn): <p>The ARN of the insight for which to return results.</p>
    /// - On success, responds with [`GetInsightResultsOutput`](crate::output::GetInsightResultsOutput) with field(s):
    ///   - [`insight_results(Option<InsightResults>)`](crate::output::GetInsightResultsOutput::insight_results): <p>The insight results returned by the operation.</p>
    /// - On failure, responds with [`SdkError<GetInsightResultsError>`](crate::error::GetInsightResultsError)
    pub fn get_insight_results(&self) -> fluent_builders::GetInsightResults<C, M, R> {
        fluent_builders::GetInsightResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsights`](crate::client::fluent_builders::GetInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_arns(Vec<String>)`](crate::client::fluent_builders::GetInsights::insight_arns) / [`set_insight_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetInsights::set_insight_arns): <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInsights::set_next_token): <p>The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInsights::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetInsights::set_max_results): <p>The maximum number of items to return in the response.</p>
    /// - On success, responds with [`GetInsightsOutput`](crate::output::GetInsightsOutput) with field(s):
    ///   - [`insights(Option<Vec<Insight>>)`](crate::output::GetInsightsOutput::insights): <p>The insights returned by the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInsightsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetInsightsError>`](crate::error::GetInsightsError)
    pub fn get_insights(&self) -> fluent_builders::GetInsights<C, M, R> {
        fluent_builders::GetInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInvitationsCount`](crate::client::fluent_builders::GetInvitationsCount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetInvitationsCount::send) it.

    /// - On success, responds with [`GetInvitationsCountOutput`](crate::output::GetInvitationsCountOutput) with field(s):
    ///   - [`invitations_count(i32)`](crate::output::GetInvitationsCountOutput::invitations_count): <p>The number of all membership invitations sent to this Security Hub member account, not including the currently accepted invitation.</p>
    /// - On failure, responds with [`SdkError<GetInvitationsCountError>`](crate::error::GetInvitationsCountError)
    pub fn get_invitations_count(&self) -> fluent_builders::GetInvitationsCount<C, M, R> {
        fluent_builders::GetInvitationsCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMasterAccount`](crate::client::fluent_builders::GetMasterAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetMasterAccount::send) it.

    /// - On success, responds with [`GetMasterAccountOutput`](crate::output::GetMasterAccountOutput) with field(s):
    ///   - [`master(Option<Invitation>)`](crate::output::GetMasterAccountOutput::master): <p>A list of details about the Security Hub administrator account for the current member account. </p>
    /// - On failure, responds with [`SdkError<GetMasterAccountError>`](crate::error::GetMasterAccountError)
    pub fn get_master_account(&self) -> fluent_builders::GetMasterAccount<C, M, R> {
        fluent_builders::GetMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMembers`](crate::client::fluent_builders::GetMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::GetMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetMembers::set_account_ids): <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
    /// - On success, responds with [`GetMembersOutput`](crate::output::GetMembersOutput) with field(s):
    ///   - [`members(Option<Vec<Member>>)`](crate::output::GetMembersOutput::members): <p>The list of details about the Security Hub member accounts.</p>
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::GetMembersOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<GetMembersError>`](crate::error::GetMembersError)
    pub fn get_members(&self) -> fluent_builders::GetMembers<C, M, R> {
        fluent_builders::GetMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InviteMembers`](crate::client::fluent_builders::InviteMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::InviteMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::InviteMembers::set_account_ids): <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
    /// - On success, responds with [`InviteMembersOutput`](crate::output::InviteMembersOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<Result>>)`](crate::output::InviteMembersOutput::unprocessed_accounts): <p>The list of Amazon Web Services accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>
    /// - On failure, responds with [`SdkError<InviteMembersError>`](crate::error::InviteMembersError)
    pub fn invite_members(&self) -> fluent_builders::InviteMembers<C, M, R> {
        fluent_builders::InviteMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEnabledProductsForImport`](crate::client::fluent_builders::ListEnabledProductsForImport) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEnabledProductsForImport::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEnabledProductsForImport::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEnabledProductsForImport::set_next_token): <p>The token that is required for pagination. On your first call to the <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEnabledProductsForImport::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListEnabledProductsForImport::set_max_results): <p>The maximum number of items to return in the response.</p>
    /// - On success, responds with [`ListEnabledProductsForImportOutput`](crate::output::ListEnabledProductsForImportOutput) with field(s):
    ///   - [`product_subscriptions(Option<Vec<String>>)`](crate::output::ListEnabledProductsForImportOutput::product_subscriptions): <p>The list of ARNs for the resources that represent your subscriptions to products. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEnabledProductsForImportOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListEnabledProductsForImportError>`](crate::error::ListEnabledProductsForImportError)
    pub fn list_enabled_products_for_import(
        &self,
    ) -> fluent_builders::ListEnabledProductsForImport<C, M, R> {
        fluent_builders::ListEnabledProductsForImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindingAggregators`](crate::client::fluent_builders::ListFindingAggregators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindingAggregators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindingAggregators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindingAggregators::set_next_token): <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindingAggregators::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFindingAggregators::set_max_results): <p>The maximum number of results to return. This operation currently only returns a single result.</p>
    /// - On success, responds with [`ListFindingAggregatorsOutput`](crate::output::ListFindingAggregatorsOutput) with field(s):
    ///   - [`finding_aggregators(Option<Vec<FindingAggregator>>)`](crate::output::ListFindingAggregatorsOutput::finding_aggregators): <p>The list of finding aggregators. This operation currently only returns a single result.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingAggregatorsOutput::next_token): <p>If there are more results, this is the token to provide in the next call to <code>ListFindingAggregators</code>.</p>  <p>This operation currently only returns a single result. </p>
    /// - On failure, responds with [`SdkError<ListFindingAggregatorsError>`](crate::error::ListFindingAggregatorsError)
    pub fn list_finding_aggregators(&self) -> fluent_builders::ListFindingAggregators<C, M, R> {
        fluent_builders::ListFindingAggregators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInvitations`](crate::client::fluent_builders::ListInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInvitations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListInvitations::set_max_results): <p>The maximum number of items to return in the response. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInvitations::set_next_token): <p>The token that is required for pagination. On your first call to the <code>ListInvitations</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    /// - On success, responds with [`ListInvitationsOutput`](crate::output::ListInvitationsOutput) with field(s):
    ///   - [`invitations(Option<Vec<Invitation>>)`](crate::output::ListInvitationsOutput::invitations): <p>The details of the invitations returned by the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInvitationsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListInvitationsError>`](crate::error::ListInvitationsError)
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations<C, M, R> {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMembers`](crate::client::fluent_builders::ListMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`only_associated(bool)`](crate::client::fluent_builders::ListMembers::only_associated) / [`set_only_associated(bool)`](crate::client::fluent_builders::ListMembers::set_only_associated): <p>Specifies which member accounts to include in the response based on their relationship status with the administrator account. The default value is <code>TRUE</code>.</p>  <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>  <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMembers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMembers::set_max_results): <p>The maximum number of items to return in the response. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMembers::set_next_token): <p>The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the value of this parameter to <code>NULL</code>.</p>  <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
    /// - On success, responds with [`ListMembersOutput`](crate::output::ListMembersOutput) with field(s):
    ///   - [`members(Option<Vec<Member>>)`](crate::output::ListMembersOutput::members): <p>Member details returned by the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMembersOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListMembersError>`](crate::error::ListMembersError)
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationAdminAccounts`](crate::client::fluent_builders::ListOrganizationAdminAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationAdminAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_max_results): <p>The maximum number of items to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_next_token): <p>The token that is required for pagination. On your first call to the <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. </p>
    /// - On success, responds with [`ListOrganizationAdminAccountsOutput`](crate::output::ListOrganizationAdminAccountsOutput) with field(s):
    ///   - [`admin_accounts(Option<Vec<AdminAccount>>)`](crate::output::ListOrganizationAdminAccountsOutput::admin_accounts): <p>The list of Security Hub administrator accounts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationAdminAccountsOutput::next_token): <p>The pagination token to use to request the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationAdminAccountsError>`](crate::error::ListOrganizationAdminAccountsError)
    pub fn list_organization_admin_accounts(
        &self,
    ) -> fluent_builders::ListOrganizationAdminAccounts<C, M, R> {
        fluent_builders::ListOrganizationAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource to retrieve tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource to apply the tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateActionTarget`](crate::client::fluent_builders::UpdateActionTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_target_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateActionTarget::action_target_arn) / [`set_action_target_arn(Option<String>)`](crate::client::fluent_builders::UpdateActionTarget::set_action_target_arn): <p>The ARN of the custom action target to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateActionTarget::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateActionTarget::set_name): <p>The updated name of the custom action target.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateActionTarget::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateActionTarget::set_description): <p>The updated description for the custom action target.</p>
    /// - On success, responds with [`UpdateActionTargetOutput`](crate::output::UpdateActionTargetOutput)

    /// - On failure, responds with [`SdkError<UpdateActionTargetError>`](crate::error::UpdateActionTargetError)
    pub fn update_action_target(&self) -> fluent_builders::UpdateActionTarget<C, M, R> {
        fluent_builders::UpdateActionTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFindingAggregator`](crate::client::fluent_builders::UpdateFindingAggregator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_aggregator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingAggregator::finding_aggregator_arn) / [`set_finding_aggregator_arn(Option<String>)`](crate::client::fluent_builders::UpdateFindingAggregator::set_finding_aggregator_arn): <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    ///   - [`region_linking_mode(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingAggregator::region_linking_mode) / [`set_region_linking_mode(Option<String>)`](crate::client::fluent_builders::UpdateFindingAggregator::set_region_linking_mode): <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>  <p>The selected option also determines how to use the Regions provided in the Regions list.</p>  <p>The options are as follows:</p>  <ul>   <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>   <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>   <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>  </ul>
    ///   - [`regions(Vec<String>)`](crate::client::fluent_builders::UpdateFindingAggregator::regions) / [`set_regions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFindingAggregator::set_regions): <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>  <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
    /// - On success, responds with [`UpdateFindingAggregatorOutput`](crate::output::UpdateFindingAggregatorOutput) with field(s):
    ///   - [`finding_aggregator_arn(Option<String>)`](crate::output::UpdateFindingAggregatorOutput::finding_aggregator_arn): <p>The ARN of the finding aggregator.</p>
    ///   - [`finding_aggregation_region(Option<String>)`](crate::output::UpdateFindingAggregatorOutput::finding_aggregation_region): <p>The aggregation Region.</p>
    ///   - [`region_linking_mode(Option<String>)`](crate::output::UpdateFindingAggregatorOutput::region_linking_mode): <p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>
    ///   - [`regions(Option<Vec<String>>)`](crate::output::UpdateFindingAggregatorOutput::regions): <p>The list of excluded Regions or included Regions.</p>
    /// - On failure, responds with [`SdkError<UpdateFindingAggregatorError>`](crate::error::UpdateFindingAggregatorError)
    pub fn update_finding_aggregator(&self) -> fluent_builders::UpdateFindingAggregator<C, M, R> {
        fluent_builders::UpdateFindingAggregator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFindings`](crate::client::fluent_builders::UpdateFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(AwsSecurityFindingFilters)`](crate::client::fluent_builders::UpdateFindings::filters) / [`set_filters(Option<AwsSecurityFindingFilters>)`](crate::client::fluent_builders::UpdateFindings::set_filters): <p>A collection of attributes that specify which findings you want to update.</p>
    ///   - [`note(NoteUpdate)`](crate::client::fluent_builders::UpdateFindings::note) / [`set_note(Option<NoteUpdate>)`](crate::client::fluent_builders::UpdateFindings::set_note): <p>The updated note for the finding.</p>
    ///   - [`record_state(RecordState)`](crate::client::fluent_builders::UpdateFindings::record_state) / [`set_record_state(Option<RecordState>)`](crate::client::fluent_builders::UpdateFindings::set_record_state): <p>The updated record state for the finding.</p>
    /// - On success, responds with [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)

    /// - On failure, responds with [`SdkError<UpdateFindingsError>`](crate::error::UpdateFindingsError)
    pub fn update_findings(&self) -> fluent_builders::UpdateFindings<C, M, R> {
        fluent_builders::UpdateFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInsight`](crate::client::fluent_builders::UpdateInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateInsight::insight_arn) / [`set_insight_arn(Option<String>)`](crate::client::fluent_builders::UpdateInsight::set_insight_arn): <p>The ARN of the insight that you want to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateInsight::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateInsight::set_name): <p>The updated name for the insight.</p>
    ///   - [`filters(AwsSecurityFindingFilters)`](crate::client::fluent_builders::UpdateInsight::filters) / [`set_filters(Option<AwsSecurityFindingFilters>)`](crate::client::fluent_builders::UpdateInsight::set_filters): <p>The updated filters that define this insight.</p>
    ///   - [`group_by_attribute(impl Into<String>)`](crate::client::fluent_builders::UpdateInsight::group_by_attribute) / [`set_group_by_attribute(Option<String>)`](crate::client::fluent_builders::UpdateInsight::set_group_by_attribute): <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
    /// - On success, responds with [`UpdateInsightOutput`](crate::output::UpdateInsightOutput)

    /// - On failure, responds with [`SdkError<UpdateInsightError>`](crate::error::UpdateInsightError)
    pub fn update_insight(&self) -> fluent_builders::UpdateInsight<C, M, R> {
        fluent_builders::UpdateInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::auto_enable) / [`set_auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::set_auto_enable): <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>  <p>By default, this is <code>false</code>, and new accounts are not added automatically.</p>  <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
    /// - On success, responds with [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateOrganizationConfigurationError>`](crate::error::UpdateOrganizationConfigurationError)
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration<C, M, R> {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSecurityHubConfiguration`](crate::client::fluent_builders::UpdateSecurityHubConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_enable_controls(bool)`](crate::client::fluent_builders::UpdateSecurityHubConfiguration::auto_enable_controls) / [`set_auto_enable_controls(bool)`](crate::client::fluent_builders::UpdateSecurityHubConfiguration::set_auto_enable_controls): <p>Whether to automatically enable new controls when they are added to standards that are enabled.</p>  <p>By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code>. </p>
    /// - On success, responds with [`UpdateSecurityHubConfigurationOutput`](crate::output::UpdateSecurityHubConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateSecurityHubConfigurationError>`](crate::error::UpdateSecurityHubConfigurationError)
    pub fn update_security_hub_configuration(
        &self,
    ) -> fluent_builders::UpdateSecurityHubConfiguration<C, M, R> {
        fluent_builders::UpdateSecurityHubConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStandardsControl`](crate::client::fluent_builders::UpdateStandardsControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`standards_control_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStandardsControl::standards_control_arn) / [`set_standards_control_arn(Option<String>)`](crate::client::fluent_builders::UpdateStandardsControl::set_standards_control_arn): <p>The ARN of the security standard control to enable or disable.</p>
    ///   - [`control_status(ControlStatus)`](crate::client::fluent_builders::UpdateStandardsControl::control_status) / [`set_control_status(Option<ControlStatus>)`](crate::client::fluent_builders::UpdateStandardsControl::set_control_status): <p>The updated status of the security standard control.</p>
    ///   - [`disabled_reason(impl Into<String>)`](crate::client::fluent_builders::UpdateStandardsControl::disabled_reason) / [`set_disabled_reason(Option<String>)`](crate::client::fluent_builders::UpdateStandardsControl::set_disabled_reason): <p>A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required.</p>
    /// - On success, responds with [`UpdateStandardsControlOutput`](crate::output::UpdateStandardsControlOutput)

    /// - On failure, responds with [`SdkError<UpdateStandardsControlError>`](crate::error::UpdateStandardsControlError)
    pub fn update_standards_control(&self) -> fluent_builders::UpdateStandardsControl<C, M, R> {
        fluent_builders::UpdateStandardsControl::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptAdministratorInvitation`.
    ///
    /// <p>Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.</p>
    /// <p>This operation is only used by member accounts that are not added through Organizations.</p>
    /// <p>When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptAdministratorInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_administrator_invitation_input::Builder,
    }
    impl<C, M, R> AcceptAdministratorInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptAdministratorInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptAdministratorInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptAdministratorInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptAdministratorInvitationInputOperationOutputAlias,
                crate::output::AcceptAdministratorInvitationOutput,
                crate::error::AcceptAdministratorInvitationError,
                crate::input::AcceptAdministratorInvitationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn administrator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administrator_id(input.into());
            self
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn set_administrator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administrator_id(input);
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(input.into());
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptInvitation`.
    ///
    /// <p>This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.</p>
    /// <p>The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function must continue to use <code>AcceptInvitation</code>. You should also add <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>AcceptAdministratorInvitation</code>.</p>
    /// <p>Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.</p>
    /// <p>This operation is only used by member accounts that are not added through Organizations.</p>
    /// <p>When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_invitation_input::Builder,
    }
    impl<C, M, R> AcceptInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInvitationInputOperationOutputAlias,
                crate::output::AcceptInvitationOutput,
                crate::error::AcceptInvitationError,
                crate::input::AcceptInvitationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn master_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_id(input.into());
            self
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_master_id(input);
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(input.into());
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisableStandards`.
    ///
    /// <p>Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>Security Hub User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisableStandards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_disable_standards_input::Builder,
    }
    impl<C, M, R> BatchDisableStandards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisableStandards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisableStandardsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDisableStandardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDisableStandardsInputOperationOutputAlias,
                crate::output::BatchDisableStandardsOutput,
                crate::error::BatchDisableStandardsError,
                crate::input::BatchDisableStandardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StandardsSubscriptionArns`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_arns`](Self::set_standards_subscription_arns).
        ///
        /// <p>The ARNs of the standards subscriptions to disable.</p>
        pub fn standards_subscription_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.standards_subscription_arns(input.into());
            self
        }
        /// <p>The ARNs of the standards subscriptions to disable.</p>
        pub fn set_standards_subscription_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_standards_subscription_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchEnableStandards`.
    ///
    /// <p>Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use the <code>DescribeStandards</code> operation.</p>
    /// <p>For more information, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>Security Hub User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchEnableStandards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_enable_standards_input::Builder,
    }
    impl<C, M, R> BatchEnableStandards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchEnableStandards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchEnableStandardsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchEnableStandardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchEnableStandardsInputOperationOutputAlias,
                crate::output::BatchEnableStandardsOutput,
                crate::error::BatchEnableStandardsError,
                crate::input::BatchEnableStandardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `StandardsSubscriptionRequests`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_requests`](Self::set_standards_subscription_requests).
        ///
        /// <p>The list of standards checks to enable.</p>
        pub fn standards_subscription_requests(
            mut self,
            input: crate::model::StandardsSubscriptionRequest,
        ) -> Self {
            self.inner = self.inner.standards_subscription_requests(input);
            self
        }
        /// <p>The list of standards checks to enable.</p>
        pub fn set_standards_subscription_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StandardsSubscriptionRequest>>,
        ) -> Self {
            self.inner = self.inner.set_standards_subscription_requests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchImportFindings`.
    ///
    /// <p>Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.</p>
    /// <p> <code>BatchImportFindings</code> must be called by one of the following:</p>
    /// <ul>
    /// <li> <p>The account that is associated with the findings. The identifier of the associated account is the value of the <code>AwsAccountId</code> attribute for the finding.</p> </li>
    /// <li> <p>An account that is allow-listed for an official Security Hub partner integration.</p> </li>
    /// </ul>
    /// <p>The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.</p>
    /// <p>After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.</p>
    /// <ul>
    /// <li> <p> <code>Note</code> </p> </li>
    /// <li> <p> <code>UserDefinedFields</code> </p> </li>
    /// <li> <p> <code>VerificationState</code> </p> </li>
    /// <li> <p> <code>Workflow</code> </p> </li>
    /// </ul>
    /// <p>Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.</p>
    /// <ul>
    /// <li> <p> <code>Confidence</code> </p> </li>
    /// <li> <p> <code>Criticality</code> </p> </li>
    /// <li> <p> <code>RelatedFindings</code> </p> </li>
    /// <li> <p> <code>Severity</code> </p> </li>
    /// <li> <p> <code>Types</code> </p> </li>
    /// </ul>
    /// <p>Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchImportFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_import_findings_input::Builder,
    }
    impl<C, M, R> BatchImportFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchImportFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchImportFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchImportFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchImportFindingsInputOperationOutputAlias,
                crate::output::BatchImportFindingsOutput,
                crate::error::BatchImportFindingsError,
                crate::input::BatchImportFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>A list of findings to import. To successfully import a finding, it must follow the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
        pub fn findings(mut self, input: crate::model::AwsSecurityFinding) -> Self {
            self.inner = self.inner.findings(input);
            self
        }
        /// <p>A list of findings to import. To successfully import a finding, it must follow the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFinding>>,
        ) -> Self {
            self.inner = self.inner.set_findings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateFindings`.
    ///
    /// <p>Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.</p>
    /// <p>Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.</p>
    /// <p>Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields and objects.</p>
    /// <ul>
    /// <li> <p> <code>Confidence</code> </p> </li>
    /// <li> <p> <code>Criticality</code> </p> </li>
    /// <li> <p> <code>Note</code> </p> </li>
    /// <li> <p> <code>RelatedFindings</code> </p> </li>
    /// <li> <p> <code>Severity</code> </p> </li>
    /// <li> <p> <code>Types</code> </p> </li>
    /// <li> <p> <code>UserDefinedFields</code> </p> </li>
    /// <li> <p> <code>VerificationState</code> </p> </li>
    /// <li> <p> <code>Workflow</code> </p> </li>
    /// </ul>
    /// <p>You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access">Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUpdateFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_findings_input::Builder,
    }
    impl<C, M, R> BatchUpdateFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateFindingsInputOperationOutputAlias,
                crate::output::BatchUpdateFindingsOutput,
                crate::error::BatchUpdateFindingsError,
                crate::input::BatchUpdateFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FindingIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_finding_identifiers`](Self::set_finding_identifiers).
        ///
        /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a time.</p>
        /// <p>For each finding, the list provides the finding identifier and the ARN of the finding provider.</p>
        pub fn finding_identifiers(
            mut self,
            input: crate::model::AwsSecurityFindingIdentifier,
        ) -> Self {
            self.inner = self.inner.finding_identifiers(input);
            self
        }
        /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a time.</p>
        /// <p>For each finding, the list provides the finding identifier and the ARN of the finding provider.</p>
        pub fn set_finding_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFindingIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_finding_identifiers(input);
            self
        }
        /// <p>The updated note.</p>
        pub fn note(mut self, input: crate::model::NoteUpdate) -> Self {
            self.inner = self.inner.note(input);
            self
        }
        /// <p>The updated note.</p>
        pub fn set_note(mut self, input: std::option::Option<crate::model::NoteUpdate>) -> Self {
            self.inner = self.inner.set_note(input);
            self
        }
        /// <p>Used to update the finding severity.</p>
        pub fn severity(mut self, input: crate::model::SeverityUpdate) -> Self {
            self.inner = self.inner.severity(input);
            self
        }
        /// <p>Used to update the finding severity.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::SeverityUpdate>,
        ) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>Indicates the veracity of a finding.</p>
        /// <p>The available values for <code>VerificationState</code> are as follows.</p>
        /// <ul>
        /// <li> <p> <code>UNKNOWN</code> – The default disposition of a security finding</p> </li>
        /// <li> <p> <code>TRUE_POSITIVE</code> – The security finding is confirmed</p> </li>
        /// <li> <p> <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm</p> </li>
        /// <li> <p> <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose any threat, is expected, or both</p> </li>
        /// </ul>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.inner = self.inner.verification_state(input);
            self
        }
        /// <p>Indicates the veracity of a finding.</p>
        /// <p>The available values for <code>VerificationState</code> are as follows.</p>
        /// <ul>
        /// <li> <p> <code>UNKNOWN</code> – The default disposition of a security finding</p> </li>
        /// <li> <p> <code>TRUE_POSITIVE</code> – The security finding is confirmed</p> </li>
        /// <li> <p> <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm</p> </li>
        /// <li> <p> <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn't pose any threat, is expected, or both</p> </li>
        /// </ul>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.inner = self.inner.set_verification_state(input);
            self
        }
        /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
        pub fn confidence(mut self, input: i32) -> Self {
            self.inner = self.inner.confidence(input);
            self
        }
        /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_confidence(input);
            self
        }
        /// <p>The updated value for the level of importance assigned to the resources associated with the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>
        pub fn criticality(mut self, input: i32) -> Self {
            self.inner = self.inner.criticality(input);
            self
        }
        /// <p>The updated value for the level of importance assigned to the resources associated with the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>
        pub fn set_criticality(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_criticality(input);
            self
        }
        /// Appends an item to `Types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>One or more finding types in the format of namespace/category/classifier that classify a finding.</p>
        /// <p>Valid namespace values are as follows.</p>
        /// <ul>
        /// <li> <p>Software and Configuration Checks</p> </li>
        /// <li> <p>TTPs</p> </li>
        /// <li> <p>Effects</p> </li>
        /// <li> <p>Unusual Behaviors</p> </li>
        /// <li> <p>Sensitive Data Identifications </p> </li>
        /// </ul>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.types(input.into());
            self
        }
        /// <p>One or more finding types in the format of namespace/category/classifier that classify a finding.</p>
        /// <p>Valid namespace values are as follows.</p>
        /// <ul>
        /// <li> <p>Software and Configuration Checks</p> </li>
        /// <li> <p>TTPs</p> </li>
        /// <li> <p>Effects</p> </li>
        /// <li> <p>Unusual Behaviors</p> </li>
        /// <li> <p>Sensitive Data Identifications </p> </li>
        /// </ul>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_types(input);
            self
        }
        /// Adds a key-value pair to `UserDefinedFields`.
        ///
        /// To override the contents of this collection use [`set_user_defined_fields`](Self::set_user_defined_fields).
        ///
        /// <p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p>
        pub fn user_defined_fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.user_defined_fields(k.into(), v.into());
            self
        }
        /// <p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p>
        pub fn set_user_defined_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_user_defined_fields(input);
            self
        }
        /// <p>Used to update the workflow status of a finding.</p>
        /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
        pub fn workflow(mut self, input: crate::model::WorkflowUpdate) -> Self {
            self.inner = self.inner.workflow(input);
            self
        }
        /// <p>Used to update the workflow status of a finding.</p>
        /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
        pub fn set_workflow(
            mut self,
            input: std::option::Option<crate::model::WorkflowUpdate>,
        ) -> Self {
            self.inner = self.inner.set_workflow(input);
            self
        }
        /// Appends an item to `RelatedFindings`.
        ///
        /// To override the contents of this collection use [`set_related_findings`](Self::set_related_findings).
        ///
        /// <p>A list of findings that are related to the updated findings.</p>
        pub fn related_findings(mut self, input: crate::model::RelatedFinding) -> Self {
            self.inner = self.inner.related_findings(input);
            self
        }
        /// <p>A list of findings that are related to the updated findings.</p>
        pub fn set_related_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        ) -> Self {
            self.inner = self.inner.set_related_findings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateActionTarget`.
    ///
    /// <p>Creates a custom action target in Security Hub.</p>
    /// <p>You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateActionTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_action_target_input::Builder,
    }
    impl<C, M, R> CreateActionTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateActionTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActionTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActionTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateActionTargetInputOperationOutputAlias,
                crate::output::CreateActionTargetOutput,
                crate::error::CreateActionTargetError,
                crate::input::CreateActionTargetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description for the custom action target.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the custom action target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFindingAggregator`.
    ///
    /// <p>Used to enable finding aggregation. Must be called from the aggregation Region.</p>
    /// <p>For more details about cross-Region replication, see <a href="securityhub/latest/userguide/finding-aggregation.html">Configuring finding aggregation</a> in the <i>Security Hub User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFindingAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_finding_aggregator_input::Builder,
    }
    impl<C, M, R> CreateFindingAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFindingAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFindingAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFindingAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFindingAggregatorInputOperationOutputAlias,
                crate::output::CreateFindingAggregatorOutput,
                crate::error::CreateFindingAggregatorError,
                crate::input::CreateFindingAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>
        /// </ul>
        pub fn region_linking_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_linking_mode(input.into());
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>
        /// </ul>
        pub fn set_region_linking_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_region_linking_mode(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region. </p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(input.into());
            self
        }
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region. </p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInsight`.
    ///
    /// <p>Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.</p>
    /// <p>To group the related findings in the insight, use the <code>GroupByAttribute</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_insight_input::Builder,
    }
    impl<C, M, R> CreateInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInsightInputOperationOutputAlias,
                crate::output::CreateInsightOutput,
                crate::error::CreateInsightError,
                crate::input::CreateInsightInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom insight to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom insight to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_by_attribute(input.into());
            self
        }
        /// <p>The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_group_by_attribute(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMembers`.
    ///
    /// <p>Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.</p>
    /// <p> <code>CreateMembers</code> is always used to add accounts that are not organization members.</p>
    /// <p>For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following cases:</p>
    /// <ul>
    /// <li> <p>Security Hub is not configured to automatically add new organization accounts.</p> </li>
    /// <li> <p>The account was disassociated or deleted in Security Hub.</p> </li>
    /// </ul>
    /// <p>This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the <code>EnableSecurityHub</code> operation.</p>
    /// <p>For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.</p>
    /// <p>Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.</p>
    /// <ul>
    /// <li> <p>If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.</p> </li>
    /// <li> <p>For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.</p> </li>
    /// </ul>
    /// <p>A permissions policy is added that permits the administrator account to view the findings generated in the member account.</p>
    /// <p>To remove the association between the administrator and member accounts, use the <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_members_input::Builder,
    }
    impl<C, M, R> CreateMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMembersInputOperationOutputAlias,
                crate::output::CreateMembersOutput,
                crate::error::CreateMembersError,
                crate::input::CreateMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountDetails`.
        ///
        /// To override the contents of this collection use [`set_account_details`](Self::set_account_details).
        ///
        /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the list includes the account ID and optionally the email address.</p>
        pub fn account_details(mut self, input: crate::model::AccountDetails) -> Self {
            self.inner = self.inner.account_details(input);
            self
        }
        /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the list includes the account ID and optionally the email address.</p>
        pub fn set_account_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountDetails>>,
        ) -> Self {
            self.inner = self.inner.set_account_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineInvitations`.
    ///
    /// <p>Declines invitations to become a member account.</p>
    /// <p>This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeclineInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decline_invitations_input::Builder,
    }
    impl<C, M, R> DeclineInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeclineInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeclineInvitationsInputOperationOutputAlias,
                crate::output::DeclineInvitationsOutput,
                crate::error::DeclineInvitationsError,
                crate::input::DeclineInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the accounts from which to decline the invitations to Security Hub.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of account IDs for the accounts from which to decline the invitations to Security Hub.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteActionTarget`.
    ///
    /// <p>Deletes a custom action target from Security Hub.</p>
    /// <p>Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteActionTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_action_target_input::Builder,
    }
    impl<C, M, R> DeleteActionTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteActionTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActionTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActionTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteActionTargetInputOperationOutputAlias,
                crate::output::DeleteActionTargetOutput,
                crate::error::DeleteActionTargetError,
                crate::input::DeleteActionTargetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the custom action target to delete.</p>
        pub fn action_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_target_arn(input.into());
            self
        }
        /// <p>The ARN of the custom action target to delete.</p>
        pub fn set_action_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFindingAggregator`.
    ///
    /// <p>Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.</p>
    /// <p>When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFindingAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_finding_aggregator_input::Builder,
    }
    impl<C, M, R> DeleteFindingAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFindingAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFindingAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFindingAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFindingAggregatorInputOperationOutputAlias,
                crate::output::DeleteFindingAggregatorOutput,
                crate::error::DeleteFindingAggregatorError,
                crate::input::DeleteFindingAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_aggregator_arn(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_finding_aggregator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInsight`.
    ///
    /// <p>Deletes the insight specified by the <code>InsightArn</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_insight_input::Builder,
    }
    impl<C, M, R> DeleteInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInsightInputOperationOutputAlias,
                crate::output::DeleteInsightOutput,
                crate::error::DeleteInsightError,
                crate::input::DeleteInsightInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the insight to delete.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_arn(input.into());
            self
        }
        /// <p>The ARN of the insight to delete.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInvitations`.
    ///
    /// <p>Deletes invitations received by the Amazon Web Services account to become a member account.</p>
    /// <p>This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_invitations_input::Builder,
    }
    impl<C, M, R> DeleteInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInvitationsInputOperationOutputAlias,
                crate::output::DeleteInvitationsOutput,
                crate::error::DeleteInvitationsError,
                crate::input::DeleteInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of the account IDs that sent the invitations to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of the account IDs that sent the invitations to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMembers`.
    ///
    /// <p>Deletes the specified member accounts from Security Hub.</p>
    /// <p>Can be used to delete member accounts that belong to an organization as well as member accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_members_input::Builder,
    }
    impl<C, M, R> DeleteMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMembersInputOperationOutputAlias,
                crate::output::DeleteMembersOutput,
                crate::error::DeleteMembersError,
                crate::input::DeleteMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the member accounts to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of account IDs for the member accounts to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActionTargets`.
    ///
    /// <p>Returns a list of the custom action targets in Security Hub in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActionTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_action_targets_input::Builder,
    }
    impl<C, M, R> DescribeActionTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActionTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActionTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActionTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActionTargetsInputOperationOutputAlias,
                crate::output::DescribeActionTargetsOutput,
                crate::error::DescribeActionTargetsError,
                crate::input::DescribeActionTargetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeActionTargetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeActionTargetsPaginator<C, M, R> {
            crate::paginator::DescribeActionTargetsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ActionTargetArns`.
        ///
        /// To override the contents of this collection use [`set_action_target_arns`](Self::set_action_target_arns).
        ///
        /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
        pub fn action_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_target_arns(input.into());
            self
        }
        /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
        pub fn set_action_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_action_target_arns(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeActionTargets</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeActionTargets</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHub`.
    ///
    /// <p>Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you enabled Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHub<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hub_input::Builder,
    }
    impl<C, M, R> DescribeHub<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHub`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHubOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHubError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHubInputOperationOutputAlias,
                crate::output::DescribeHubOutput,
                crate::error::DescribeHubError,
                crate::input::DescribeHubInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Hub resource to retrieve.</p>
        pub fn hub_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hub_arn(input.into());
            self
        }
        /// <p>The ARN of the Hub resource to retrieve.</p>
        pub fn set_hub_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hub_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigurationInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigurationOutput,
                crate::error::DescribeOrganizationConfigurationError,
                crate::input::DescribeOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeProducts`.
    ///
    /// <p>Returns information about product integrations in Security Hub.</p>
    /// <p>You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.</p>
    /// <p>If you do not provide an integration ARN, then the results include all of the available product integrations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProducts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_products_input::Builder,
    }
    impl<C, M, R> DescribeProducts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProducts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProductsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProductsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProductsInputOperationOutputAlias,
                crate::output::DescribeProductsOutput,
                crate::error::DescribeProductsError,
                crate::input::DescribeProductsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeProductsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeProductsPaginator<C, M, R> {
            crate::paginator::DescribeProductsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeProducts</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeProducts</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ARN of the integration to return.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_arn(input.into());
            self
        }
        /// <p>The ARN of the integration to return.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStandards`.
    ///
    /// <p>Returns a list of the available standards in Security Hub.</p>
    /// <p>For each standard, the results include the standard ARN, the name, and a description. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStandards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_standards_input::Builder,
    }
    impl<C, M, R> DescribeStandards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStandards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStandardsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStandardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStandardsInputOperationOutputAlias,
                crate::output::DescribeStandardsOutput,
                crate::error::DescribeStandardsError,
                crate::input::DescribeStandardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeStandardsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeStandardsPaginator<C, M, R> {
            crate::paginator::DescribeStandardsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of standards to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of standards to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStandardsControls`.
    ///
    /// <p>Returns a list of security standards controls.</p>
    /// <p>For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStandardsControls<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_standards_controls_input::Builder,
    }
    impl<C, M, R> DescribeStandardsControls<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStandardsControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStandardsControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStandardsControlsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStandardsControlsInputOperationOutputAlias,
                crate::output::DescribeStandardsControlsOutput,
                crate::error::DescribeStandardsControlsError,
                crate::input::DescribeStandardsControlsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeStandardsControlsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeStandardsControlsPaginator<C, M, R> {
            crate::paginator::DescribeStandardsControlsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of a resource that represents your subscription to a supported standard. To get the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
        pub fn standards_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.standards_subscription_arn(input.into());
            self
        }
        /// <p>The ARN of a resource that represents your subscription to a supported standard. To get the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
        pub fn set_standards_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_standards_subscription_arn(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeStandardsControls</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>DescribeStandardsControls</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of security standard controls to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of security standard controls to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableImportFindingsForProduct`.
    ///
    /// <p>Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableImportFindingsForProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_import_findings_for_product_input::Builder,
    }
    impl<C, M, R> DisableImportFindingsForProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableImportFindingsForProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableImportFindingsForProductOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableImportFindingsForProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableImportFindingsForProductInputOperationOutputAlias,
                crate::output::DisableImportFindingsForProductOutput,
                crate::error::DisableImportFindingsForProductError,
                crate::input::DisableImportFindingsForProductInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the integrated product to disable the integration for.</p>
        pub fn product_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_subscription_arn(input.into());
            self
        }
        /// <p>The ARN of the integrated product to disable the integration for.</p>
        pub fn set_product_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_product_subscription_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableOrganizationAdminAccount`.
    ///
    /// <p>Disables a Security Hub administrator account. Can only be called by the organization management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> DisableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::DisableOrganizationAdminAccountOutput,
                crate::error::DisableOrganizationAdminAccountError,
                crate::input::DisableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSecurityHub`.
    ///
    /// <p>Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.</p>
    /// <p>When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated member accounts.</p>
    /// <p>When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.</p>
    /// <p>If you want to save your existing findings, you must export them before you disable Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableSecurityHub<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_security_hub_input::Builder,
    }
    impl<C, M, R> DisableSecurityHub<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableSecurityHub`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSecurityHubOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableSecurityHubError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableSecurityHubInputOperationOutputAlias,
                crate::output::DisableSecurityHubOutput,
                crate::error::DisableSecurityHubError,
                crate::input::DisableSecurityHubInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromAdministratorAccount`.
    ///
    /// <p>Disassociates the current Security Hub member account from the associated administrator account.</p>
    /// <p>This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFromAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_administrator_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateFromAdministratorAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromAdministratorAccountInputOperationOutputAlias,
                crate::output::DisassociateFromAdministratorAccountOutput,
                crate::error::DisassociateFromAdministratorAccountError,
                crate::input::DisassociateFromAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromMasterAccount`.
    ///
    /// <p>This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.</p>
    /// <p>The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.</p>
    /// <p>Disassociates the current Security Hub member account from the associated administrator account.</p>
    /// <p>This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFromMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_master_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFromMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromMasterAccountInputOperationOutputAlias,
                crate::output::DisassociateFromMasterAccountOutput,
                crate::error::DisassociateFromMasterAccountError,
                crate::input::DisassociateFromMasterAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateMembers`.
    ///
    /// <p>Disassociates the specified member accounts from the associated administrator account.</p>
    /// <p>Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_members_input::Builder,
    }
    impl<C, M, R> DisassociateMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMembersInputOperationOutputAlias,
                crate::output::DisassociateMembersOutput,
                crate::error::DisassociateMembersError,
                crate::input::DisassociateMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableImportFindingsForProduct`.
    ///
    /// <p>Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.</p>
    /// <p>When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableImportFindingsForProduct<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_import_findings_for_product_input::Builder,
    }
    impl<C, M, R> EnableImportFindingsForProduct<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableImportFindingsForProduct`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableImportFindingsForProductOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableImportFindingsForProductError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableImportFindingsForProductInputOperationOutputAlias,
                crate::output::EnableImportFindingsForProductOutput,
                crate::error::EnableImportFindingsForProductError,
                crate::input::EnableImportFindingsForProductInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the product to enable the integration for.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_arn(input.into());
            self
        }
        /// <p>The ARN of the product to enable the integration for.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableOrganizationAdminAccount`.
    ///
    /// <p>Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> EnableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::EnableOrganizationAdminAccountOutput,
                crate::error::EnableOrganizationAdminAccountError,
                crate::input::EnableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSecurityHub`.
    ///
    /// <p>Enables Security Hub for your account in the current Region or the Region you specify in the request.</p>
    /// <p>When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.</p>
    /// <p>When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable the following standards.</p>
    /// <ul>
    /// <li> <p>CIS Amazon Web Services Foundations</p> </li>
    /// <li> <p>Amazon Web Services Foundational Security Best Practices</p> </li>
    /// </ul>
    /// <p>You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard. </p>
    /// <p>To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>
    /// <p>After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To disable a standard, use the <code>BatchDisableStandards</code> operation.</p>
    /// <p>To learn more, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a> in the <i>Security Hub User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableSecurityHub<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_security_hub_input::Builder,
    }
    impl<C, M, R> EnableSecurityHub<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSecurityHub`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSecurityHubOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSecurityHubError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSecurityHubInputOperationOutputAlias,
                crate::output::EnableSecurityHubOutput,
                crate::error::EnableSecurityHubError,
                crate::input::EnableSecurityHubInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>
        pub fn enable_default_standards(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_default_standards(input);
            self
        }
        /// <p>Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>
        pub fn set_enable_default_standards(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_default_standards(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAdministratorAccount`.
    ///
    /// <p>Provides the details for the Security Hub administrator account for the current member account.</p>
    /// <p>Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_administrator_account_input::Builder,
    }
    impl<C, M, R> GetAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdministratorAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdministratorAccountInputOperationOutputAlias,
                crate::output::GetAdministratorAccountOutput,
                crate::error::GetAdministratorAccountError,
                crate::input::GetAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetEnabledStandards`.
    ///
    /// <p>Returns a list of the standards that are currently enabled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEnabledStandards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_enabled_standards_input::Builder,
    }
    impl<C, M, R> GetEnabledStandards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnabledStandards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnabledStandardsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnabledStandardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnabledStandardsInputOperationOutputAlias,
                crate::output::GetEnabledStandardsOutput,
                crate::error::GetEnabledStandardsError,
                crate::input::GetEnabledStandardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEnabledStandardsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetEnabledStandardsPaginator<C, M, R> {
            crate::paginator::GetEnabledStandardsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `StandardsSubscriptionArns`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_arns`](Self::set_standards_subscription_arns).
        ///
        /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
        pub fn standards_subscription_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.standards_subscription_arns(input.into());
            self
        }
        /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
        pub fn set_standards_subscription_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_standards_subscription_arns(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetEnabledStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetEnabledStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingAggregator`.
    ///
    /// <p>Returns the current finding aggregation configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_finding_aggregator_input::Builder,
    }
    impl<C, M, R> GetFindingAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingAggregatorInputOperationOutputAlias,
                crate::output::GetFindingAggregatorOutput,
                crate::error::GetFindingAggregatorError,
                crate::input::GetFindingAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_aggregator_arn(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_finding_aggregator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindings`.
    ///
    /// <p>Returns a list of findings that match the specified criteria.</p>
    /// <p>If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_input::Builder,
    }
    impl<C, M, R> GetFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsInputOperationOutputAlias,
                crate::output::GetFindingsOutput,
                crate::error::GetFindingsError,
                crate::input::GetFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetFindingsPaginator<C, M, R> {
            crate::paginator::GetFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The finding attributes used to define a condition to filter the returned findings.</p>
        /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.</p>
        /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The finding attributes used to define a condition to filter the returned findings.</p>
        /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.</p>
        /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The finding attributes used to sort the list of returned findings.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriterion) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The finding attributes used to sort the list of returned findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortCriterion>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of findings to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of findings to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightResults`.
    ///
    /// <p>Lists the results of the Security Hub insight specified by the insight ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsightResults<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_results_input::Builder,
    }
    impl<C, M, R> GetInsightResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsightResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightResultsInputOperationOutputAlias,
                crate::output::GetInsightResultsOutput,
                crate::error::GetInsightResultsError,
                crate::input::GetInsightResultsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the insight for which to return results.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_arn(input.into());
            self
        }
        /// <p>The ARN of the insight for which to return results.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsights`.
    ///
    /// <p>Lists and describes insights for the specified insight ARNs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insights_input::Builder,
    }
    impl<C, M, R> GetInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightsInputOperationOutputAlias,
                crate::output::GetInsightsOutput,
                crate::error::GetInsightsError,
                crate::input::GetInsightsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInsightsPaginator<C, M, R> {
            crate::paginator::GetInsightsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `InsightArns`.
        ///
        /// To override the contents of this collection use [`set_insight_arns`](Self::set_insight_arns).
        ///
        /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.</p>
        pub fn insight_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_arns(input.into());
            self
        }
        /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.</p>
        pub fn set_insight_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_insight_arns(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvitationsCount`.
    ///
    /// <p>Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInvitationsCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invitations_count_input::Builder,
    }
    impl<C, M, R> GetInvitationsCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvitationsCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvitationsCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvitationsCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvitationsCountInputOperationOutputAlias,
                crate::output::GetInvitationsCountOutput,
                crate::error::GetInvitationsCountError,
                crate::input::GetInvitationsCountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMasterAccount`.
    ///
    /// <p>This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.</p>
    /// <p>The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>GetAdministratorAccount</code>.</p>
    /// <p>Provides the details for the Security Hub administrator account for the current member account.</p>
    /// <p>Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_master_account_input::Builder,
    }
    impl<C, M, R> GetMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMasterAccountInputOperationOutputAlias,
                crate::output::GetMasterAccountOutput,
                crate::error::GetMasterAccountError,
                crate::input::GetMasterAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMembers`.
    ///
    /// <p>Returns the details for the Security Hub member accounts for the specified account IDs.</p>
    /// <p>An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.</p>
    /// <p>The results include both member accounts that are managed using Organizations and accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_members_input::Builder,
    }
    impl<C, M, R> GetMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMembersInputOperationOutputAlias,
                crate::output::GetMembersOutput,
                crate::error::GetMembersError,
                crate::input::GetMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteMembers`.
    ///
    /// <p>Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.</p>
    /// <p>This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.</p>
    /// <p>Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to create the member account in Security Hub.</p>
    /// <p>When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InviteMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invite_members_input::Builder,
    }
    impl<C, M, R> InviteMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InviteMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InviteMembersInputOperationOutputAlias,
                crate::output::InviteMembersOutput,
                crate::error::InviteMembersError,
                crate::input::InviteMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnabledProductsForImport`.
    ///
    /// <p>Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEnabledProductsForImport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_enabled_products_for_import_input::Builder,
    }
    impl<C, M, R> ListEnabledProductsForImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnabledProductsForImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnabledProductsForImportOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnabledProductsForImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnabledProductsForImportInputOperationOutputAlias,
                crate::output::ListEnabledProductsForImportOutput,
                crate::error::ListEnabledProductsForImportError,
                crate::input::ListEnabledProductsForImportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEnabledProductsForImportPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListEnabledProductsForImportPaginator<C, M, R> {
            crate::paginator::ListEnabledProductsForImportPaginator::new(self.handle, self.inner)
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingAggregators`.
    ///
    /// <p>If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding aggregator. You can run this operation from any Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindingAggregators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_finding_aggregators_input::Builder,
    }
    impl<C, M, R> ListFindingAggregators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindingAggregators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingAggregatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingAggregatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingAggregatorsInputOperationOutputAlias,
                crate::output::ListFindingAggregatorsOutput,
                crate::error::ListFindingAggregatorsError,
                crate::input::ListFindingAggregatorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingAggregatorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingAggregatorsPaginator<C, M, R> {
            crate::paginator::ListFindingAggregatorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.</p>
    /// <p>This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl<C, M, R> ListInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvitationsInputOperationOutputAlias,
                crate::output::ListInvitationsOutput,
                crate::error::ListInvitationsError,
                crate::input::ListInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInvitationsPaginator<C, M, R> {
            crate::paginator::ListInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListInvitations</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListInvitations</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Lists details about all member accounts for the current Security Hub administrator account.</p>
    /// <p>The results include both member accounts that belong to an organization and member accounts that were invited manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator<C, M, R> {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies which member accounts to include in the response based on their relationship status with the administrator account. The default value is <code>TRUE</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts. </p>
        pub fn only_associated(mut self, input: bool) -> Self {
            self.inner = self.inner.only_associated(input);
            self
        }
        /// <p>Specifies which member accounts to include in the response based on their relationship status with the administrator account. The default value is <code>TRUE</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts. </p>
        pub fn set_only_associated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the value of this parameter to <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationAdminAccounts`.
    ///
    /// <p>Lists the Security Hub administrator accounts. Can only be called by the organization management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationAdminAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_admin_accounts_input::Builder,
    }
    impl<C, M, R> ListOrganizationAdminAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationAdminAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationAdminAccountsInputOperationOutputAlias,
                crate::output::ListOrganizationAdminAccountsOutput,
                crate::error::ListOrganizationAdminAccountsError,
                crate::input::ListOrganizationAdminAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationAdminAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListOrganizationAdminAccountsPaginator<C, M, R> {
            crate::paginator::ListOrganizationAdminAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags associated with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to retrieve tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to apply the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to apply the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateActionTarget`.
    ///
    /// <p>Updates the name and description of a custom action target in Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateActionTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_action_target_input::Builder,
    }
    impl<C, M, R> UpdateActionTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateActionTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateActionTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateActionTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateActionTargetInputOperationOutputAlias,
                crate::output::UpdateActionTargetOutput,
                crate::error::UpdateActionTargetError,
                crate::input::UpdateActionTargetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the custom action target to update.</p>
        pub fn action_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_target_arn(input.into());
            self
        }
        /// <p>The ARN of the custom action target to update.</p>
        pub fn set_action_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_target_arn(input);
            self
        }
        /// <p>The updated name of the custom action target.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The updated name of the custom action target.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description for the custom action target.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description for the custom action target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindingAggregator`.
    ///
    /// <p>Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use <code>UpdateFindingAggregator</code> to change the aggregation Region.</p>
    /// <p>You must run <code>UpdateFindingAggregator</code> from the current aggregation Region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFindingAggregator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_finding_aggregator_input::Builder,
    }
    impl<C, M, R> UpdateFindingAggregator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindingAggregator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingAggregatorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingAggregatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingAggregatorInputOperationOutputAlias,
                crate::output::UpdateFindingAggregatorOutput,
                crate::error::UpdateFindingAggregatorError,
                crate::input::UpdateFindingAggregatorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_aggregator_arn(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_finding_aggregator_arn(input);
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>
        /// </ul>
        pub fn region_linking_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_linking_mode(input.into());
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li>
        /// <li> <p> <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li>
        /// </ul>
        pub fn set_region_linking_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_region_linking_mode(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regions(input.into());
            self
        }
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindings`.
    ///
    /// <p> <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use <code>BatchUpdateFindings</code>.</p>
    /// <p>Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_findings_input::Builder,
    }
    impl<C, M, R> UpdateFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingsInputOperationOutputAlias,
                crate::output::UpdateFindingsOutput,
                crate::error::UpdateFindingsError,
                crate::input::UpdateFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A collection of attributes that specify which findings you want to update.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A collection of attributes that specify which findings you want to update.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The updated note for the finding.</p>
        pub fn note(mut self, input: crate::model::NoteUpdate) -> Self {
            self.inner = self.inner.note(input);
            self
        }
        /// <p>The updated note for the finding.</p>
        pub fn set_note(mut self, input: std::option::Option<crate::model::NoteUpdate>) -> Self {
            self.inner = self.inner.set_note(input);
            self
        }
        /// <p>The updated record state for the finding.</p>
        pub fn record_state(mut self, input: crate::model::RecordState) -> Self {
            self.inner = self.inner.record_state(input);
            self
        }
        /// <p>The updated record state for the finding.</p>
        pub fn set_record_state(
            mut self,
            input: std::option::Option<crate::model::RecordState>,
        ) -> Self {
            self.inner = self.inner.set_record_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInsight`.
    ///
    /// <p>Updates the Security Hub insight identified by the specified insight ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_insight_input::Builder,
    }
    impl<C, M, R> UpdateInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInsightInputOperationOutputAlias,
                crate::output::UpdateInsightOutput,
                crate::error::UpdateInsightError,
                crate::input::UpdateInsightInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the insight that you want to update.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_arn(input.into());
            self
        }
        /// <p>The ARN of the insight that you want to update.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_arn(input);
            self
        }
        /// <p>The updated name for the insight.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The updated name for the insight.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated filters that define this insight.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The updated filters that define this insight.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_by_attribute(input.into());
            self
        }
        /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_group_by_attribute(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationConfigurationInputOperationOutputAlias,
                crate::output::UpdateOrganizationConfigurationOutput,
                crate::error::UpdateOrganizationConfigurationError,
                crate::input::UpdateOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
        /// <p>By default, this is <code>false</code>, and new accounts are not added automatically.</p>
        /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_enable(input);
            self
        }
        /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
        /// <p>By default, this is <code>false</code>, and new accounts are not added automatically.</p>
        /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecurityHubConfiguration`.
    ///
    /// <p>Updates configuration options for Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecurityHubConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_security_hub_configuration_input::Builder,
    }
    impl<C, M, R> UpdateSecurityHubConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSecurityHubConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecurityHubConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecurityHubConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSecurityHubConfigurationInputOperationOutputAlias,
                crate::output::UpdateSecurityHubConfigurationOutput,
                crate::error::UpdateSecurityHubConfigurationError,
                crate::input::UpdateSecurityHubConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether to automatically enable new controls when they are added to standards that are enabled.</p>
        /// <p>By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code>. </p>
        pub fn auto_enable_controls(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_enable_controls(input);
            self
        }
        /// <p>Whether to automatically enable new controls when they are added to standards that are enabled.</p>
        /// <p>By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code>. </p>
        pub fn set_auto_enable_controls(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable_controls(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStandardsControl`.
    ///
    /// <p>Used to control whether an individual security standard control is enabled or disabled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStandardsControl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_standards_control_input::Builder,
    }
    impl<C, M, R> UpdateStandardsControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStandardsControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStandardsControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStandardsControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStandardsControlInputOperationOutputAlias,
                crate::output::UpdateStandardsControlOutput,
                crate::error::UpdateStandardsControlError,
                crate::input::UpdateStandardsControlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the security standard control to enable or disable.</p>
        pub fn standards_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.standards_control_arn(input.into());
            self
        }
        /// <p>The ARN of the security standard control to enable or disable.</p>
        pub fn set_standards_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_standards_control_arn(input);
            self
        }
        /// <p>The updated status of the security standard control.</p>
        pub fn control_status(mut self, input: crate::model::ControlStatus) -> Self {
            self.inner = self.inner.control_status(input);
            self
        }
        /// <p>The updated status of the security standard control.</p>
        pub fn set_control_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.inner = self.inner.set_control_status(input);
            self
        }
        /// <p>A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required.</p>
        pub fn disabled_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disabled_reason(input.into());
            self
        }
        /// <p>A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required.</p>
        pub fn set_disabled_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_disabled_reason(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
