// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptAdministratorInvitationInput`](crate::input::AcceptAdministratorInvitationInput)
pub mod accept_administrator_invitation_input {
    /// A builder for [`AcceptAdministratorInvitationInput`](crate::input::AcceptAdministratorInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) administrator_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn administrator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_id = Some(input.into());
            self
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn set_administrator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_id = input;
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptAdministratorInvitationInput`](crate::input::AcceptAdministratorInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptAdministratorInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptAdministratorInvitationInput {
                administrator_id: self.administrator_id,
                invitation_id: self.invitation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptAdministratorInvitationInputOperationOutputAlias =
    crate::operation::AcceptAdministratorInvitation;
#[doc(hidden)]
pub type AcceptAdministratorInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptAdministratorInvitationInput {
    /// Consumes the builder and constructs an Operation<[`AcceptAdministratorInvitation`](crate::operation::AcceptAdministratorInvitation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptAdministratorInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptAdministratorInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/administrator").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptAdministratorInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptAdministratorInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_administrator_invitation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptAdministratorInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptAdministratorInvitation",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptAdministratorInvitationInput`](crate::input::AcceptAdministratorInvitationInput)
    pub fn builder() -> crate::input::accept_administrator_invitation_input::Builder {
        crate::input::accept_administrator_invitation_input::Builder::default()
    }
}

/// See [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
pub mod accept_invitation_input {
    /// A builder for [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn master_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_id = Some(input.into());
            self
        }
        /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_id = input;
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptInvitationInput {
                master_id: self.master_id,
                invitation_id: self.invitation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptInvitationInputOperationOutputAlias = crate::operation::AcceptInvitation;
#[doc(hidden)]
pub type AcceptInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptInvitationInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInvitation`](crate::operation::AcceptInvitation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/master").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_invitation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInvitation",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
}

/// See [`BatchDisableStandardsInput`](crate::input::BatchDisableStandardsInput)
pub mod batch_disable_standards_input {
    /// A builder for [`BatchDisableStandardsInput`](crate::input::BatchDisableStandardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standards_subscription_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `standards_subscription_arns`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_arns`](Self::set_standards_subscription_arns).
        ///
        /// <p>The ARNs of the standards subscriptions to disable.</p>
        pub fn standards_subscription_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.standards_subscription_arns.unwrap_or_default();
            v.push(input.into());
            self.standards_subscription_arns = Some(v);
            self
        }
        /// <p>The ARNs of the standards subscriptions to disable.</p>
        pub fn set_standards_subscription_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.standards_subscription_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisableStandardsInput`](crate::input::BatchDisableStandardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisableStandardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDisableStandardsInput {
                standards_subscription_arns: self.standards_subscription_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDisableStandardsInputOperationOutputAlias = crate::operation::BatchDisableStandards;
#[doc(hidden)]
pub type BatchDisableStandardsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDisableStandardsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisableStandards`](crate::operation::BatchDisableStandards)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisableStandards,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisableStandardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/standards/deregister").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisableStandardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisableStandardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disable_standards(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisableStandards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisableStandards",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisableStandardsInput`](crate::input::BatchDisableStandardsInput)
    pub fn builder() -> crate::input::batch_disable_standards_input::Builder {
        crate::input::batch_disable_standards_input::Builder::default()
    }
}

/// See [`BatchEnableStandardsInput`](crate::input::BatchEnableStandardsInput)
pub mod batch_enable_standards_input {
    /// A builder for [`BatchEnableStandardsInput`](crate::input::BatchEnableStandardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standards_subscription_requests:
            std::option::Option<std::vec::Vec<crate::model::StandardsSubscriptionRequest>>,
    }
    impl Builder {
        /// Appends an item to `standards_subscription_requests`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_requests`](Self::set_standards_subscription_requests).
        ///
        /// <p>The list of standards checks to enable.</p>
        pub fn standards_subscription_requests(
            mut self,
            input: impl Into<crate::model::StandardsSubscriptionRequest>,
        ) -> Self {
            let mut v = self.standards_subscription_requests.unwrap_or_default();
            v.push(input.into());
            self.standards_subscription_requests = Some(v);
            self
        }
        /// <p>The list of standards checks to enable.</p>
        pub fn set_standards_subscription_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StandardsSubscriptionRequest>>,
        ) -> Self {
            self.standards_subscription_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEnableStandardsInput`](crate::input::BatchEnableStandardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchEnableStandardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchEnableStandardsInput {
                standards_subscription_requests: self.standards_subscription_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchEnableStandardsInputOperationOutputAlias = crate::operation::BatchEnableStandards;
#[doc(hidden)]
pub type BatchEnableStandardsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchEnableStandardsInput {
    /// Consumes the builder and constructs an Operation<[`BatchEnableStandards`](crate::operation::BatchEnableStandards)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchEnableStandards,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchEnableStandardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/standards/register").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchEnableStandardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchEnableStandardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_enable_standards(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchEnableStandards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchEnableStandards",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchEnableStandardsInput`](crate::input::BatchEnableStandardsInput)
    pub fn builder() -> crate::input::batch_enable_standards_input::Builder {
        crate::input::batch_enable_standards_input::Builder::default()
    }
}

/// See [`BatchImportFindingsInput`](crate::input::BatchImportFindingsInput)
pub mod batch_import_findings_input {
    /// A builder for [`BatchImportFindingsInput`](crate::input::BatchImportFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFinding>>,
    }
    impl Builder {
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>A list of findings to import. To successfully import a finding, it must follow the
        /// <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
        pub fn findings(mut self, input: impl Into<crate::model::AwsSecurityFinding>) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input.into());
            self.findings = Some(v);
            self
        }
        /// <p>A list of findings to import. To successfully import a finding, it must follow the
        /// <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFinding>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchImportFindingsInput`](crate::input::BatchImportFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchImportFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchImportFindingsInput {
                findings: self.findings,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchImportFindingsInputOperationOutputAlias = crate::operation::BatchImportFindings;
#[doc(hidden)]
pub type BatchImportFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchImportFindingsInput {
    /// Consumes the builder and constructs an Operation<[`BatchImportFindings`](crate::operation::BatchImportFindings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchImportFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchImportFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings/import").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchImportFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchImportFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_import_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchImportFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchImportFindings",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchImportFindingsInput`](crate::input::BatchImportFindingsInput)
    pub fn builder() -> crate::input::batch_import_findings_input::Builder {
        crate::input::batch_import_findings_input::Builder::default()
    }
}

/// See [`BatchUpdateFindingsInput`](crate::input::BatchUpdateFindingsInput)
pub mod batch_update_findings_input {
    /// A builder for [`BatchUpdateFindingsInput`](crate::input::BatchUpdateFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_identifiers:
            std::option::Option<std::vec::Vec<crate::model::AwsSecurityFindingIdentifier>>,
        pub(crate) note: std::option::Option<crate::model::NoteUpdate>,
        pub(crate) severity: std::option::Option<crate::model::SeverityUpdate>,
        pub(crate) verification_state: std::option::Option<crate::model::VerificationState>,
        pub(crate) confidence: std::option::Option<i32>,
        pub(crate) criticality: std::option::Option<i32>,
        pub(crate) types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_defined_fields: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) workflow: std::option::Option<crate::model::WorkflowUpdate>,
        pub(crate) related_findings:
            std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
    }
    impl Builder {
        /// Appends an item to `finding_identifiers`.
        ///
        /// To override the contents of this collection use [`set_finding_identifiers`](Self::set_finding_identifiers).
        ///
        /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update
        /// up to 100 findings at a time.</p>
        /// <p>For each finding, the list provides the finding identifier and the ARN of the finding
        /// provider.</p>
        pub fn finding_identifiers(
            mut self,
            input: impl Into<crate::model::AwsSecurityFindingIdentifier>,
        ) -> Self {
            let mut v = self.finding_identifiers.unwrap_or_default();
            v.push(input.into());
            self.finding_identifiers = Some(v);
            self
        }
        /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update
        /// up to 100 findings at a time.</p>
        /// <p>For each finding, the list provides the finding identifier and the ARN of the finding
        /// provider.</p>
        pub fn set_finding_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFindingIdentifier>>,
        ) -> Self {
            self.finding_identifiers = input;
            self
        }
        /// <p>The updated note.</p>
        pub fn note(mut self, input: crate::model::NoteUpdate) -> Self {
            self.note = Some(input);
            self
        }
        /// <p>The updated note.</p>
        pub fn set_note(mut self, input: std::option::Option<crate::model::NoteUpdate>) -> Self {
            self.note = input;
            self
        }
        /// <p>Used to update the finding severity.</p>
        pub fn severity(mut self, input: crate::model::SeverityUpdate) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>Used to update the finding severity.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::SeverityUpdate>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>Indicates the veracity of a finding.</p>
        /// <p>The available values for <code>VerificationState</code> are  as follows.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNKNOWN</code> – The default disposition of a security finding</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRUE_POSITIVE</code> – The security finding is confirmed</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FALSE_POSITIVE</code> – The security finding was determined to be a false
        /// alarm</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where
        /// the finding doesn't pose any threat, is expected, or both</p>
        /// </li>
        /// </ul>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.verification_state = Some(input);
            self
        }
        /// <p>Indicates the veracity of a finding.</p>
        /// <p>The available values for <code>VerificationState</code> are  as follows.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNKNOWN</code> – The default disposition of a security finding</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRUE_POSITIVE</code> – The security finding is confirmed</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FALSE_POSITIVE</code> – The security finding was determined to be a false
        /// alarm</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where
        /// the finding doesn't pose any threat, is expected, or both</p>
        /// </li>
        /// </ul>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.verification_state = input;
            self
        }
        /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood
        /// that a finding accurately identifies the behavior or issue that it was intended to
        /// identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn confidence(mut self, input: i32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood
        /// that a finding accurately identifies the behavior or issue that it was intended to
        /// identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<i32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The updated value for the level of importance assigned to the resources associated with
        /// the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources. </p>
        pub fn criticality(mut self, input: i32) -> Self {
            self.criticality = Some(input);
            self
        }
        /// <p>The updated value for the level of importance assigned to the resources associated with
        /// the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources. </p>
        pub fn set_criticality(mut self, input: std::option::Option<i32>) -> Self {
            self.criticality = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>One or more finding types in the format of namespace/category/classifier that classify a
        /// finding.</p>
        /// <p>Valid namespace values are as follows.</p>
        /// <ul>
        /// <li>
        /// <p>Software and Configuration Checks</p>
        /// </li>
        /// <li>
        /// <p>TTPs</p>
        /// </li>
        /// <li>
        /// <p>Effects</p>
        /// </li>
        /// <li>
        /// <p>Unusual Behaviors</p>
        /// </li>
        /// <li>
        /// <p>Sensitive Data Identifications </p>
        /// </li>
        /// </ul>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>One or more finding types in the format of namespace/category/classifier that classify a
        /// finding.</p>
        /// <p>Valid namespace values are as follows.</p>
        /// <ul>
        /// <li>
        /// <p>Software and Configuration Checks</p>
        /// </li>
        /// <li>
        /// <p>TTPs</p>
        /// </li>
        /// <li>
        /// <p>Effects</p>
        /// </li>
        /// <li>
        /// <p>Unusual Behaviors</p>
        /// </li>
        /// <li>
        /// <p>Sensitive Data Identifications </p>
        /// </li>
        /// </ul>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Adds a key-value pair to `user_defined_fields`.
        ///
        /// To override the contents of this collection use [`set_user_defined_fields`](Self::set_user_defined_fields).
        ///
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding.</p>
        pub fn user_defined_fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_defined_fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_defined_fields = Some(hash_map);
            self
        }
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding.</p>
        pub fn set_user_defined_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_defined_fields = input;
            self
        }
        /// <p>Used to update the workflow status of a finding.</p>
        /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
        pub fn workflow(mut self, input: crate::model::WorkflowUpdate) -> Self {
            self.workflow = Some(input);
            self
        }
        /// <p>Used to update the workflow status of a finding.</p>
        /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
        pub fn set_workflow(
            mut self,
            input: std::option::Option<crate::model::WorkflowUpdate>,
        ) -> Self {
            self.workflow = input;
            self
        }
        /// Appends an item to `related_findings`.
        ///
        /// To override the contents of this collection use [`set_related_findings`](Self::set_related_findings).
        ///
        /// <p>A list of findings that are related to the updated findings.</p>
        pub fn related_findings(mut self, input: impl Into<crate::model::RelatedFinding>) -> Self {
            let mut v = self.related_findings.unwrap_or_default();
            v.push(input.into());
            self.related_findings = Some(v);
            self
        }
        /// <p>A list of findings that are related to the updated findings.</p>
        pub fn set_related_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        ) -> Self {
            self.related_findings = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateFindingsInput`](crate::input::BatchUpdateFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateFindingsInput {
                finding_identifiers: self.finding_identifiers,
                note: self.note,
                severity: self.severity,
                verification_state: self.verification_state,
                confidence: self.confidence.unwrap_or_default(),
                criticality: self.criticality.unwrap_or_default(),
                types: self.types,
                user_defined_fields: self.user_defined_fields,
                workflow: self.workflow,
                related_findings: self.related_findings,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateFindingsInputOperationOutputAlias = crate::operation::BatchUpdateFindings;
#[doc(hidden)]
pub type BatchUpdateFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchUpdateFindingsInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateFindings`](crate::operation::BatchUpdateFindings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings/batchupdate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateFindings",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateFindingsInput`](crate::input::BatchUpdateFindingsInput)
    pub fn builder() -> crate::input::batch_update_findings_input::Builder {
        crate::input::batch_update_findings_input::Builder::default()
    }
}

/// See [`CreateActionTargetInput`](crate::input::CreateActionTargetInput)
pub mod create_action_target_input {
    /// A builder for [`CreateActionTargetInput`](crate::input::CreateActionTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for the custom action target.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the custom action target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActionTargetInput`](crate::input::CreateActionTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateActionTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateActionTargetInput {
                name: self.name,
                description: self.description,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateActionTargetInputOperationOutputAlias = crate::operation::CreateActionTarget;
#[doc(hidden)]
pub type CreateActionTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateActionTargetInput {
    /// Consumes the builder and constructs an Operation<[`CreateActionTarget`](crate::operation::CreateActionTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateActionTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateActionTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/actionTargets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateActionTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateActionTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_action_target(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateActionTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateActionTarget",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateActionTargetInput`](crate::input::CreateActionTargetInput)
    pub fn builder() -> crate::input::create_action_target_input::Builder {
        crate::input::create_action_target_input::Builder::default()
    }
}

/// See [`CreateFindingAggregatorInput`](crate::input::CreateFindingAggregatorInput)
pub mod create_finding_aggregator_input {
    /// A builder for [`CreateFindingAggregatorInput`](crate::input::CreateFindingAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_linking_mode: std::option::Option<std::string::String>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
        /// </p>
        /// </li>
        /// </ul>
        pub fn region_linking_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_linking_mode = Some(input.into());
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_region_linking_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.region_linking_mode = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.
        /// </p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.
        /// </p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFindingAggregatorInput`](crate::input::CreateFindingAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFindingAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFindingAggregatorInput {
                region_linking_mode: self.region_linking_mode,
                regions: self.regions,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFindingAggregatorInputOperationOutputAlias =
    crate::operation::CreateFindingAggregator;
#[doc(hidden)]
pub type CreateFindingAggregatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFindingAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`CreateFindingAggregator`](crate::operation::CreateFindingAggregator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFindingAggregator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFindingAggregatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findingAggregator/create").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFindingAggregatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFindingAggregatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_finding_aggregator(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFindingAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFindingAggregator",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFindingAggregatorInput`](crate::input::CreateFindingAggregatorInput)
    pub fn builder() -> crate::input::create_finding_aggregator_input::Builder {
        crate::input::create_finding_aggregator_input::Builder::default()
    }
}

/// See [`CreateInsightInput`](crate::input::CreateInsightInput)
pub mod create_insight_input {
    /// A builder for [`CreateInsightInput`](crate::input::CreateInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        pub(crate) group_by_attribute: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom insight to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom insight to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight
        /// only includes findings that match the criteria defined in the filters.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight
        /// only includes findings that match the criteria defined in the filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The attribute used to group the findings for the insight. The grouping attribute
        /// identifies the type of item that the insight applies to. For example, if an insight is
        /// grouped by resource identifier, then the insight produces a list of resource
        /// identifiers.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_by_attribute = Some(input.into());
            self
        }
        /// <p>The attribute used to group the findings for the insight. The grouping attribute
        /// identifies the type of item that the insight applies to. For example, if an insight is
        /// grouped by resource identifier, then the insight produces a list of resource
        /// identifiers.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_by_attribute = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInsightInput`](crate::input::CreateInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInsightInput {
                name: self.name,
                filters: self.filters,
                group_by_attribute: self.group_by_attribute,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInsightInputOperationOutputAlias = crate::operation::CreateInsight;
#[doc(hidden)]
pub type CreateInsightInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateInsightInput {
    /// Consumes the builder and constructs an Operation<[`CreateInsight`](crate::operation::CreateInsight)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInsight,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInsightInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/insights").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInsightInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInsightInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_insight(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInsight",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInsightInput`](crate::input::CreateInsightInput)
    pub fn builder() -> crate::input::create_insight_input::Builder {
        crate::input::create_insight_input::Builder::default()
    }
}

/// See [`CreateMembersInput`](crate::input::CreateMembersInput)
pub mod create_members_input {
    /// A builder for [`CreateMembersInput`](crate::input::CreateMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_details:
            std::option::Option<std::vec::Vec<crate::model::AccountDetails>>,
    }
    impl Builder {
        /// Appends an item to `account_details`.
        ///
        /// To override the contents of this collection use [`set_account_details`](Self::set_account_details).
        ///
        /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the
        /// list includes the account ID and optionally the email address.</p>
        pub fn account_details(mut self, input: impl Into<crate::model::AccountDetails>) -> Self {
            let mut v = self.account_details.unwrap_or_default();
            v.push(input.into());
            self.account_details = Some(v);
            self
        }
        /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the
        /// list includes the account ID and optionally the email address.</p>
        pub fn set_account_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountDetails>>,
        ) -> Self {
            self.account_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMembersInput`](crate::input::CreateMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMembersInput {
                account_details: self.account_details,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMembersInputOperationOutputAlias = crate::operation::CreateMembers;
#[doc(hidden)]
pub type CreateMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMembersInput {
    /// Consumes the builder and constructs an Operation<[`CreateMembers`](crate::operation::CreateMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMembersInput`](crate::input::CreateMembersInput)
    pub fn builder() -> crate::input::create_members_input::Builder {
        crate::input::create_members_input::Builder::default()
    }
}

/// See [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
pub mod decline_invitations_input {
    /// A builder for [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the accounts from which to decline the invitations to
        /// Security Hub.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of account IDs for the accounts from which to decline the invitations to
        /// Security Hub.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeclineInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeclineInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeclineInvitationsInputOperationOutputAlias = crate::operation::DeclineInvitations;
#[doc(hidden)]
pub type DeclineInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeclineInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeclineInvitations`](crate::operation::DeclineInvitations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeclineInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeclineInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/decline").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeclineInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeclineInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_decline_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeclineInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeclineInvitations",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
}

/// See [`DeleteActionTargetInput`](crate::input::DeleteActionTargetInput)
pub mod delete_action_target_input {
    /// A builder for [`DeleteActionTargetInput`](crate::input::DeleteActionTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the custom action target to delete.</p>
        pub fn action_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom action target to delete.</p>
        pub fn set_action_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteActionTargetInput`](crate::input::DeleteActionTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteActionTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteActionTargetInput {
                action_target_arn: self.action_target_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteActionTargetInputOperationOutputAlias = crate::operation::DeleteActionTarget;
#[doc(hidden)]
pub type DeleteActionTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteActionTargetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteActionTarget`](crate::operation::DeleteActionTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteActionTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteActionTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.action_target_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_target_arn",
                        details: "cannot be empty or unset",
                    })?;
            let action_target_arn = aws_smithy_http::label::fmt_string(input_1, true);
            if action_target_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "action_target_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/actionTargets/{ActionTargetArn}",
                ActionTargetArn = action_target_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteActionTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteActionTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteActionTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteActionTarget",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteActionTargetInput`](crate::input::DeleteActionTargetInput)
    pub fn builder() -> crate::input::delete_action_target_input::Builder {
        crate::input::delete_action_target_input::Builder::default()
    }
}

/// See [`DeleteFindingAggregatorInput`](crate::input::DeleteFindingAggregatorInput)
pub mod delete_finding_aggregator_input {
    /// A builder for [`DeleteFindingAggregatorInput`](crate::input::DeleteFindingAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_aggregator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_aggregator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.finding_aggregator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFindingAggregatorInput`](crate::input::DeleteFindingAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFindingAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFindingAggregatorInput {
                finding_aggregator_arn: self.finding_aggregator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFindingAggregatorInputOperationOutputAlias =
    crate::operation::DeleteFindingAggregator;
#[doc(hidden)]
pub type DeleteFindingAggregatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFindingAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFindingAggregator`](crate::operation::DeleteFindingAggregator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFindingAggregator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFindingAggregatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.finding_aggregator_arn;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "finding_aggregator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let finding_aggregator_arn = aws_smithy_http::label::fmt_string(input_2, true);
            if finding_aggregator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "finding_aggregator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/findingAggregator/delete/{FindingAggregatorArn}",
                FindingAggregatorArn = finding_aggregator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFindingAggregatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFindingAggregatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFindingAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFindingAggregator",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFindingAggregatorInput`](crate::input::DeleteFindingAggregatorInput)
    pub fn builder() -> crate::input::delete_finding_aggregator_input::Builder {
        crate::input::delete_finding_aggregator_input::Builder::default()
    }
}

/// See [`DeleteInsightInput`](crate::input::DeleteInsightInput)
pub mod delete_insight_input {
    /// A builder for [`DeleteInsightInput`](crate::input::DeleteInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the insight to delete.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the insight to delete.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInsightInput`](crate::input::DeleteInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInsightInput {
                insight_arn: self.insight_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInsightInputOperationOutputAlias = crate::operation::DeleteInsight;
#[doc(hidden)]
pub type DeleteInsightInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInsightInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInsight`](crate::operation::DeleteInsight)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInsight,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInsightInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.insight_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "insight_arn",
                        details: "cannot be empty or unset",
                    })?;
            let insight_arn = aws_smithy_http::label::fmt_string(input_3, true);
            if insight_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "insight_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/insights/{InsightArn}", InsightArn = insight_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInsightInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInsightInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInsight",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInsightInput`](crate::input::DeleteInsightInput)
    pub fn builder() -> crate::input::delete_insight_input::Builder {
        crate::input::delete_insight_input::Builder::default()
    }
}

/// See [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
pub mod delete_invitations_input {
    /// A builder for [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of the account IDs that sent the invitations to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of the account IDs that sent the invitations to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInvitationsInputOperationOutputAlias = crate::operation::DeleteInvitations;
#[doc(hidden)]
pub type DeleteInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInvitations`](crate::operation::DeleteInvitations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/delete").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInvitations",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
}

/// See [`DeleteMembersInput`](crate::input::DeleteMembersInput)
pub mod delete_members_input {
    /// A builder for [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the member accounts to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of account IDs for the member accounts to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMembersInput`](crate::input::DeleteMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMembersInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMembersInputOperationOutputAlias = crate::operation::DeleteMembers;
#[doc(hidden)]
pub type DeleteMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMembersInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMembers`](crate::operation::DeleteMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members/delete").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    pub fn builder() -> crate::input::delete_members_input::Builder {
        crate::input::delete_members_input::Builder::default()
    }
}

/// See [`DescribeActionTargetsInput`](crate::input::DescribeActionTargetsInput)
pub mod describe_action_targets_input {
    /// A builder for [`DescribeActionTargetsInput`](crate::input::DescribeActionTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `action_target_arns`.
        ///
        /// To override the contents of this collection use [`set_action_target_arns`](Self::set_action_target_arns).
        ///
        /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
        pub fn action_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action_target_arns.unwrap_or_default();
            v.push(input.into());
            self.action_target_arns = Some(v);
            self
        }
        /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
        pub fn set_action_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action_target_arns = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeActionTargets</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeActionTargets</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActionTargetsInput`](crate::input::DescribeActionTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActionTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActionTargetsInput {
                action_target_arns: self.action_target_arns,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActionTargetsInputOperationOutputAlias = crate::operation::DescribeActionTargets;
#[doc(hidden)]
pub type DescribeActionTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActionTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActionTargets`](crate::operation::DescribeActionTargets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActionTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActionTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/actionTargets/get").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActionTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActionTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_action_targets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActionTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActionTargets",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActionTargetsInput`](crate::input::DescribeActionTargetsInput)
    pub fn builder() -> crate::input::describe_action_targets_input::Builder {
        crate::input::describe_action_targets_input::Builder::default()
    }
}

/// See [`DescribeHubInput`](crate::input::DescribeHubInput)
pub mod describe_hub_input {
    /// A builder for [`DescribeHubInput`](crate::input::DescribeHubInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hub_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Hub resource to retrieve.</p>
        pub fn hub_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hub_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Hub resource to retrieve.</p>
        pub fn set_hub_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hub_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHubInput`](crate::input::DescribeHubInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHubInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHubInput {
                hub_arn: self.hub_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHubInputOperationOutputAlias = crate::operation::DescribeHub;
#[doc(hidden)]
pub type DescribeHubInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHubInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHub`](crate::operation::DescribeHub)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHub,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHubInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeHubInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.hub_arn {
                query.push_kv("HubArn", &aws_smithy_http::query::fmt_string(&inner_4));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHubInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHubInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHub::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHub",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHubInput`](crate::input::DescribeHubInput)
    pub fn builder() -> crate::input::describe_hub_input::Builder {
        crate::input::describe_hub_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
pub mod describe_organization_configuration_input {
    /// A builder for [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConfiguration;
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConfiguration`](crate::operation::DescribeOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/organization/configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConfiguration",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
}

/// See [`DescribeProductsInput`](crate::input::DescribeProductsInput)
pub mod describe_products_input {
    /// A builder for [`DescribeProductsInput`](crate::input::DescribeProductsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) product_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeProducts</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeProducts</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ARN of the integration to return.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the integration to return.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProductsInput`](crate::input::DescribeProductsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProductsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProductsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                product_arn: self.product_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProductsInputOperationOutputAlias = crate::operation::DescribeProducts;
#[doc(hidden)]
pub type DescribeProductsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProductsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProducts`](crate::operation::DescribeProducts)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProducts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProductsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/products").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeProductsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_6) = &_input.product_arn {
                query.push_kv("ProductArn", &aws_smithy_http::query::fmt_string(&inner_6));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProductsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProductsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProducts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProducts",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProductsInput`](crate::input::DescribeProductsInput)
    pub fn builder() -> crate::input::describe_products_input::Builder {
        crate::input::describe_products_input::Builder::default()
    }
}

/// See [`DescribeStandardsInput`](crate::input::DescribeStandardsInput)
pub mod describe_standards_input {
    /// A builder for [`DescribeStandardsInput`](crate::input::DescribeStandardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeStandards</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeStandards</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of standards to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of standards to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStandardsInput`](crate::input::DescribeStandardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStandardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStandardsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStandardsInputOperationOutputAlias = crate::operation::DescribeStandards;
#[doc(hidden)]
pub type DescribeStandardsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStandardsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStandards`](crate::operation::DescribeStandards)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStandards,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStandardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/standards").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeStandardsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStandardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStandardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStandards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStandards",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStandardsInput`](crate::input::DescribeStandardsInput)
    pub fn builder() -> crate::input::describe_standards_input::Builder {
        crate::input::describe_standards_input::Builder::default()
    }
}

/// See [`DescribeStandardsControlsInput`](crate::input::DescribeStandardsControlsInput)
pub mod describe_standards_controls_input {
    /// A builder for [`DescribeStandardsControlsInput`](crate::input::DescribeStandardsControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standards_subscription_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of a resource that represents your subscription to a supported standard. To get
        /// the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
        pub fn standards_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.standards_subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a resource that represents your subscription to a supported standard. To get
        /// the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
        pub fn set_standards_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standards_subscription_arn = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeStandardsControls</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>DescribeStandardsControls</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of security standard controls to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of security standard controls to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStandardsControlsInput`](crate::input::DescribeStandardsControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStandardsControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStandardsControlsInput {
                standards_subscription_arn: self.standards_subscription_arn,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStandardsControlsInputOperationOutputAlias =
    crate::operation::DescribeStandardsControls;
#[doc(hidden)]
pub type DescribeStandardsControlsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStandardsControlsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStandardsControls`](crate::operation::DescribeStandardsControls)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStandardsControls,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStandardsControlsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.standards_subscription_arn;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "standards_subscription_arn",
                        details: "cannot be empty or unset",
                    })?;
            let standards_subscription_arn = aws_smithy_http::label::fmt_string(input_8, true);
            if standards_subscription_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "standards_subscription_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/standards/controls/{StandardsSubscriptionArn}",
                StandardsSubscriptionArn = standards_subscription_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeStandardsControlsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStandardsControlsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStandardsControlsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStandardsControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStandardsControls",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStandardsControlsInput`](crate::input::DescribeStandardsControlsInput)
    pub fn builder() -> crate::input::describe_standards_controls_input::Builder {
        crate::input::describe_standards_controls_input::Builder::default()
    }
}

/// See [`DisableImportFindingsForProductInput`](crate::input::DisableImportFindingsForProductInput)
pub mod disable_import_findings_for_product_input {
    /// A builder for [`DisableImportFindingsForProductInput`](crate::input::DisableImportFindingsForProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the integrated product to disable the integration for.</p>
        pub fn product_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the integrated product to disable the integration for.</p>
        pub fn set_product_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableImportFindingsForProductInput`](crate::input::DisableImportFindingsForProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableImportFindingsForProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableImportFindingsForProductInput {
                product_subscription_arn: self.product_subscription_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableImportFindingsForProductInputOperationOutputAlias =
    crate::operation::DisableImportFindingsForProduct;
#[doc(hidden)]
pub type DisableImportFindingsForProductInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableImportFindingsForProductInput {
    /// Consumes the builder and constructs an Operation<[`DisableImportFindingsForProduct`](crate::operation::DisableImportFindingsForProduct)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableImportFindingsForProduct,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableImportFindingsForProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.product_subscription_arn;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "product_subscription_arn",
                        details: "cannot be empty or unset",
                    })?;
            let product_subscription_arn = aws_smithy_http::label::fmt_string(input_10, true);
            if product_subscription_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "product_subscription_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/productSubscriptions/{ProductSubscriptionArn}",
                ProductSubscriptionArn = product_subscription_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableImportFindingsForProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableImportFindingsForProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableImportFindingsForProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableImportFindingsForProduct",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableImportFindingsForProductInput`](crate::input::DisableImportFindingsForProductInput)
    pub fn builder() -> crate::input::disable_import_findings_for_product_input::Builder {
        crate::input::disable_import_findings_for_product_input::Builder::default()
    }
}

/// See [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
pub mod disable_organization_admin_account_input {
    /// A builder for [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::DisableOrganizationAdminAccount;
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisableOrganizationAdminAccount`](crate::operation::DisableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/organization/admin/disable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_organization_admin_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableOrganizationAdminAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
}

/// See [`DisableSecurityHubInput`](crate::input::DisableSecurityHubInput)
pub mod disable_security_hub_input {
    /// A builder for [`DisableSecurityHubInput`](crate::input::DisableSecurityHubInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableSecurityHubInput`](crate::input::DisableSecurityHubInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableSecurityHubInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableSecurityHubInput {})
        }
    }
}
#[doc(hidden)]
pub type DisableSecurityHubInputOperationOutputAlias = crate::operation::DisableSecurityHub;
#[doc(hidden)]
pub type DisableSecurityHubInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableSecurityHubInput {
    /// Consumes the builder and constructs an Operation<[`DisableSecurityHub`](crate::operation::DisableSecurityHub)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableSecurityHub,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableSecurityHubInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableSecurityHubInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableSecurityHubInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableSecurityHub::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableSecurityHub",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableSecurityHubInput`](crate::input::DisableSecurityHubInput)
    pub fn builder() -> crate::input::disable_security_hub_input::Builder {
        crate::input::disable_security_hub_input::Builder::default()
    }
}

/// See [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
pub mod disassociate_from_administrator_account_input {
    /// A builder for [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFromAdministratorAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFromAdministratorAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DisassociateFromAdministratorAccountInputOperationOutputAlias =
    crate::operation::DisassociateFromAdministratorAccount;
#[doc(hidden)]
pub type DisassociateFromAdministratorAccountInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateFromAdministratorAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFromAdministratorAccount`](crate::operation::DisassociateFromAdministratorAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFromAdministratorAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFromAdministratorAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/administrator/disassociate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFromAdministratorAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFromAdministratorAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFromAdministratorAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFromAdministratorAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    pub fn builder() -> crate::input::disassociate_from_administrator_account_input::Builder {
        crate::input::disassociate_from_administrator_account_input::Builder::default()
    }
}

/// See [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
pub mod disassociate_from_master_account_input {
    /// A builder for [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFromMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFromMasterAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationOutputAlias =
    crate::operation::DisassociateFromMasterAccount;
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateFromMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFromMasterAccount`](crate::operation::DisassociateFromMasterAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFromMasterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFromMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/master/disassociate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFromMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFromMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFromMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFromMasterAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
}

/// See [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
pub mod disassociate_members_input {
    /// A builder for [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMembersInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMembersInputOperationOutputAlias = crate::operation::DisassociateMembers;
#[doc(hidden)]
pub type DisassociateMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateMembersInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMembers`](crate::operation::DisassociateMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members/disassociate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    pub fn builder() -> crate::input::disassociate_members_input::Builder {
        crate::input::disassociate_members_input::Builder::default()
    }
}

/// See [`EnableImportFindingsForProductInput`](crate::input::EnableImportFindingsForProductInput)
pub mod enable_import_findings_for_product_input {
    /// A builder for [`EnableImportFindingsForProductInput`](crate::input::EnableImportFindingsForProductInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the product to enable the integration for.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the product to enable the integration for.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableImportFindingsForProductInput`](crate::input::EnableImportFindingsForProductInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableImportFindingsForProductInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableImportFindingsForProductInput {
                product_arn: self.product_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableImportFindingsForProductInputOperationOutputAlias =
    crate::operation::EnableImportFindingsForProduct;
#[doc(hidden)]
pub type EnableImportFindingsForProductInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableImportFindingsForProductInput {
    /// Consumes the builder and constructs an Operation<[`EnableImportFindingsForProduct`](crate::operation::EnableImportFindingsForProduct)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableImportFindingsForProduct,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableImportFindingsForProductInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/productSubscriptions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableImportFindingsForProductInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableImportFindingsForProductInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_import_findings_for_product(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableImportFindingsForProduct::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableImportFindingsForProduct",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableImportFindingsForProductInput`](crate::input::EnableImportFindingsForProductInput)
    pub fn builder() -> crate::input::enable_import_findings_for_product_input::Builder {
        crate::input::enable_import_findings_for_product_input::Builder::default()
    }
}

/// See [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
pub mod enable_organization_admin_account_input {
    /// A builder for [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
        /// account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
        /// account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::EnableOrganizationAdminAccount;
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`EnableOrganizationAdminAccount`](crate::operation::EnableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/organization/admin/enable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_organization_admin_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableOrganizationAdminAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
}

/// See [`EnableSecurityHubInput`](crate::input::EnableSecurityHubInput)
pub mod enable_security_hub_input {
    /// A builder for [`EnableSecurityHubInput`](crate::input::EnableSecurityHubInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) enable_default_standards: std::option::Option<bool>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Whether to enable the security standards that Security Hub has designated as automatically
        /// enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set
        /// to <code>true</code>. To not enable the automatically enabled standards, set
        /// <code>EnableDefaultStandards</code> to <code>false</code>.</p>
        pub fn enable_default_standards(mut self, input: bool) -> Self {
            self.enable_default_standards = Some(input);
            self
        }
        /// <p>Whether to enable the security standards that Security Hub has designated as automatically
        /// enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set
        /// to <code>true</code>. To not enable the automatically enabled standards, set
        /// <code>EnableDefaultStandards</code> to <code>false</code>.</p>
        pub fn set_enable_default_standards(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_default_standards = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSecurityHubInput`](crate::input::EnableSecurityHubInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableSecurityHubInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableSecurityHubInput {
                tags: self.tags,
                enable_default_standards: self.enable_default_standards.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type EnableSecurityHubInputOperationOutputAlias = crate::operation::EnableSecurityHub;
#[doc(hidden)]
pub type EnableSecurityHubInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableSecurityHubInput {
    /// Consumes the builder and constructs an Operation<[`EnableSecurityHub`](crate::operation::EnableSecurityHub)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableSecurityHub,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableSecurityHubInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableSecurityHubInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableSecurityHubInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_security_hub(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableSecurityHub::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableSecurityHub",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableSecurityHubInput`](crate::input::EnableSecurityHubInput)
    pub fn builder() -> crate::input::enable_security_hub_input::Builder {
        crate::input::enable_security_hub_input::Builder::default()
    }
}

/// See [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
pub mod get_administrator_account_input {
    /// A builder for [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAdministratorAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAdministratorAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAdministratorAccountInputOperationOutputAlias =
    crate::operation::GetAdministratorAccount;
#[doc(hidden)]
pub type GetAdministratorAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAdministratorAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetAdministratorAccount`](crate::operation::GetAdministratorAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAdministratorAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAdministratorAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/administrator").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAdministratorAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAdministratorAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAdministratorAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAdministratorAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    pub fn builder() -> crate::input::get_administrator_account_input::Builder {
        crate::input::get_administrator_account_input::Builder::default()
    }
}

/// See [`GetEnabledStandardsInput`](crate::input::GetEnabledStandardsInput)
pub mod get_enabled_standards_input {
    /// A builder for [`GetEnabledStandardsInput`](crate::input::GetEnabledStandardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standards_subscription_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `standards_subscription_arns`.
        ///
        /// To override the contents of this collection use [`set_standards_subscription_arns`](Self::set_standards_subscription_arns).
        ///
        /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
        pub fn standards_subscription_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.standards_subscription_arns.unwrap_or_default();
            v.push(input.into());
            self.standards_subscription_arns = Some(v);
            self
        }
        /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
        pub fn set_standards_subscription_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.standards_subscription_arns = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetEnabledStandards</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetEnabledStandards</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnabledStandardsInput`](crate::input::GetEnabledStandardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEnabledStandardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEnabledStandardsInput {
                standards_subscription_arns: self.standards_subscription_arns,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetEnabledStandardsInputOperationOutputAlias = crate::operation::GetEnabledStandards;
#[doc(hidden)]
pub type GetEnabledStandardsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEnabledStandardsInput {
    /// Consumes the builder and constructs an Operation<[`GetEnabledStandards`](crate::operation::GetEnabledStandards)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEnabledStandards,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEnabledStandardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/standards/get").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEnabledStandardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEnabledStandardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_enabled_standards(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEnabledStandards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEnabledStandards",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEnabledStandardsInput`](crate::input::GetEnabledStandardsInput)
    pub fn builder() -> crate::input::get_enabled_standards_input::Builder {
        crate::input::get_enabled_standards_input::Builder::default()
    }
}

/// See [`GetFindingAggregatorInput`](crate::input::GetFindingAggregatorInput)
pub mod get_finding_aggregator_input {
    /// A builder for [`GetFindingAggregatorInput`](crate::input::GetFindingAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_aggregator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_aggregator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.finding_aggregator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingAggregatorInput`](crate::input::GetFindingAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingAggregatorInput {
                finding_aggregator_arn: self.finding_aggregator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingAggregatorInputOperationOutputAlias = crate::operation::GetFindingAggregator;
#[doc(hidden)]
pub type GetFindingAggregatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingAggregator`](crate::operation::GetFindingAggregator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingAggregator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingAggregatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.finding_aggregator_arn;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "finding_aggregator_arn",
                        details: "cannot be empty or unset",
                    })?;
            let finding_aggregator_arn = aws_smithy_http::label::fmt_string(input_11, true);
            if finding_aggregator_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "finding_aggregator_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/findingAggregator/get/{FindingAggregatorArn}",
                FindingAggregatorArn = finding_aggregator_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingAggregatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingAggregatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingAggregator",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingAggregatorInput`](crate::input::GetFindingAggregatorInput)
    pub fn builder() -> crate::input::get_finding_aggregator_input::Builder {
        crate::input::get_finding_aggregator_input::Builder::default()
    }
}

/// See [`GetFindingsInput`](crate::input::GetFindingsInput)
pub mod get_findings_input {
    /// A builder for [`GetFindingsInput`](crate::input::GetFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        pub(crate) sort_criteria: std::option::Option<std::vec::Vec<crate::model::SortCriterion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The finding attributes used to define a condition to filter the returned
        /// findings.</p>
        /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to
        /// 20 filter values.</p>
        /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To
        /// search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The finding attributes used to define a condition to filter the returned
        /// findings.</p>
        /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to
        /// 20 filter values.</p>
        /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To
        /// search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `sort_criteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The finding attributes used to sort the list of returned findings.</p>
        pub fn sort_criteria(mut self, input: impl Into<crate::model::SortCriterion>) -> Self {
            let mut v = self.sort_criteria.unwrap_or_default();
            v.push(input.into());
            self.sort_criteria = Some(v);
            self
        }
        /// <p>The finding attributes used to sort the list of returned findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortCriterion>>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetFindings</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetFindings</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of findings to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of findings to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsInput`](crate::input::GetFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsInput {
                filters: self.filters,
                sort_criteria: self.sort_criteria,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsInputOperationOutputAlias = crate::operation::GetFindings;
#[doc(hidden)]
pub type GetFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingsInput {
    /// Consumes the builder and constructs an Operation<[`GetFindings`](crate::operation::GetFindings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindings",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
}

/// See [`GetInsightResultsInput`](crate::input::GetInsightResultsInput)
pub mod get_insight_results_input {
    /// A builder for [`GetInsightResultsInput`](crate::input::GetInsightResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the insight for which to return results.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the insight for which to return results.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightResultsInput`](crate::input::GetInsightResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightResultsInput {
                insight_arn: self.insight_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightResultsInputOperationOutputAlias = crate::operation::GetInsightResults;
#[doc(hidden)]
pub type GetInsightResultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightResults`](crate::operation::GetInsightResults)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightResults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.insight_arn;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "insight_arn",
                        details: "cannot be empty or unset",
                    })?;
            let insight_arn = aws_smithy_http::label::fmt_string(input_12, true);
            if insight_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "insight_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/insights/results/{InsightArn}",
                InsightArn = insight_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightResults",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightResultsInput`](crate::input::GetInsightResultsInput)
    pub fn builder() -> crate::input::get_insight_results_input::Builder {
        crate::input::get_insight_results_input::Builder::default()
    }
}

/// See [`GetInsightsInput`](crate::input::GetInsightsInput)
pub mod get_insights_input {
    /// A builder for [`GetInsightsInput`](crate::input::GetInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `insight_arns`.
        ///
        /// To override the contents of this collection use [`set_insight_arns`](Self::set_insight_arns).
        ///
        /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then
        /// <code>GetInsights</code> returns all of your custom insights. It does not return any
        /// managed insights.</p>
        pub fn insight_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.insight_arns.unwrap_or_default();
            v.push(input.into());
            self.insight_arns = Some(v);
            self
        }
        /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then
        /// <code>GetInsights</code> returns all of your custom insights. It does not return any
        /// managed insights.</p>
        pub fn set_insight_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.insight_arns = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetInsights</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>GetInsights</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightsInput`](crate::input::GetInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightsInput {
                insight_arns: self.insight_arns,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightsInputOperationOutputAlias = crate::operation::GetInsights;
#[doc(hidden)]
pub type GetInsightsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightsInput {
    /// Consumes the builder and constructs an Operation<[`GetInsights`](crate::operation::GetInsights)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsights,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/insights/get").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_insights(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsights",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightsInput`](crate::input::GetInsightsInput)
    pub fn builder() -> crate::input::get_insights_input::Builder {
        crate::input::get_insights_input::Builder::default()
    }
}

/// See [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
pub mod get_invitations_count_input {
    /// A builder for [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInvitationsCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInvitationsCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetInvitationsCountInputOperationOutputAlias = crate::operation::GetInvitationsCount;
#[doc(hidden)]
pub type GetInvitationsCountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInvitationsCountInput {
    /// Consumes the builder and constructs an Operation<[`GetInvitationsCount`](crate::operation::GetInvitationsCount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInvitationsCount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInvitationsCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/count").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInvitationsCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInvitationsCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInvitationsCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInvitationsCount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
}

/// See [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
pub mod get_master_account_input {
    /// A builder for [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMasterAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetMasterAccountInputOperationOutputAlias = crate::operation::GetMasterAccount;
#[doc(hidden)]
pub type GetMasterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetMasterAccount`](crate::operation::GetMasterAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMasterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/master").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMasterAccount",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
}

/// See [`GetMembersInput`](crate::input::GetMembersInput)
pub mod get_members_input {
    /// A builder for [`GetMembersInput`](crate::input::GetMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMembersInput`](crate::input::GetMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMembersInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMembersInputOperationOutputAlias = crate::operation::GetMembers;
#[doc(hidden)]
pub type GetMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMembersInput {
    /// Consumes the builder and constructs an Operation<[`GetMembers`](crate::operation::GetMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members/get").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMembersInput`](crate::input::GetMembersInput)
    pub fn builder() -> crate::input::get_members_input::Builder {
        crate::input::get_members_input::Builder::default()
    }
}

/// See [`InviteMembersInput`](crate::input::InviteMembersInput)
pub mod invite_members_input {
    /// A builder for [`InviteMembersInput`](crate::input::InviteMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteMembersInput`](crate::input::InviteMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InviteMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InviteMembersInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type InviteMembersInputOperationOutputAlias = crate::operation::InviteMembers;
#[doc(hidden)]
pub type InviteMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InviteMembersInput {
    /// Consumes the builder and constructs an Operation<[`InviteMembers`](crate::operation::InviteMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InviteMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InviteMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members/invite").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InviteMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InviteMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_invite_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InviteMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InviteMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InviteMembersInput`](crate::input::InviteMembersInput)
    pub fn builder() -> crate::input::invite_members_input::Builder {
        crate::input::invite_members_input::Builder::default()
    }
}

/// See [`ListEnabledProductsForImportInput`](crate::input::ListEnabledProductsForImportInput)
pub mod list_enabled_products_for_import_input {
    /// A builder for [`ListEnabledProductsForImportInput`](crate::input::ListEnabledProductsForImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnabledProductsForImportInput`](crate::input::ListEnabledProductsForImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEnabledProductsForImportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEnabledProductsForImportInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListEnabledProductsForImportInputOperationOutputAlias =
    crate::operation::ListEnabledProductsForImport;
#[doc(hidden)]
pub type ListEnabledProductsForImportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEnabledProductsForImportInput {
    /// Consumes the builder and constructs an Operation<[`ListEnabledProductsForImport`](crate::operation::ListEnabledProductsForImport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEnabledProductsForImport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEnabledProductsForImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/productSubscriptions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEnabledProductsForImportInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEnabledProductsForImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEnabledProductsForImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEnabledProductsForImport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEnabledProductsForImport",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEnabledProductsForImportInput`](crate::input::ListEnabledProductsForImportInput)
    pub fn builder() -> crate::input::list_enabled_products_for_import_input::Builder {
        crate::input::list_enabled_products_for_import_input::Builder::default()
    }
}

/// See [`ListFindingAggregatorsInput`](crate::input::ListFindingAggregatorsInput)
pub mod list_finding_aggregators_input {
    /// A builder for [`ListFindingAggregatorsInput`](crate::input::ListFindingAggregatorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingAggregatorsInput`](crate::input::ListFindingAggregatorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingAggregatorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingAggregatorsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingAggregatorsInputOperationOutputAlias = crate::operation::ListFindingAggregators;
#[doc(hidden)]
pub type ListFindingAggregatorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFindingAggregatorsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindingAggregators`](crate::operation::ListFindingAggregators)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindingAggregators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingAggregatorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findingAggregator/list").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListFindingAggregatorsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_14));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingAggregatorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingAggregatorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindingAggregators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindingAggregators",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingAggregatorsInput`](crate::input::ListFindingAggregatorsInput)
    pub fn builder() -> crate::input::list_finding_aggregators_input::Builder {
        crate::input::list_finding_aggregators_input::Builder::default()
    }
}

/// See [`ListInvitationsInput`](crate::input::ListInvitationsInput)
pub mod list_invitations_input {
    /// A builder for [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to return in the response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListInvitations</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListInvitations</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvitationsInput`](crate::input::ListInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInvitationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInvitationsInputOperationOutputAlias = crate::operation::ListInvitations;
#[doc(hidden)]
pub type ListInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInvitations`](crate::operation::ListInvitations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListInvitationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInvitations",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
}

/// See [`ListMembersInput`](crate::input::ListMembersInput)
pub mod list_members_input {
    /// A builder for [`ListMembersInput`](crate::input::ListMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) only_associated: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which member accounts to include in the response based on their relationship
        /// status with the administrator account. The default value is <code>TRUE</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member
        /// accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all
        /// existing member accounts. </p>
        pub fn only_associated(mut self, input: bool) -> Self {
            self.only_associated = Some(input);
            self
        }
        /// <p>Specifies which member accounts to include in the response based on their relationship
        /// status with the administrator account. The default value is <code>TRUE</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member
        /// accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
        /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all
        /// existing member accounts. </p>
        pub fn set_only_associated(mut self, input: std::option::Option<bool>) -> Self {
            self.only_associated = input;
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListMembers</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListMembers</code> operation, set the value of this parameter to
        /// <code>NULL</code>.</p>
        /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
        /// parameter to the value returned from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMembersInput`](crate::input::ListMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMembersInput {
                only_associated: self.only_associated.unwrap_or_default(),
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMembersInputOperationOutputAlias = crate::operation::ListMembers;
#[doc(hidden)]
pub type ListMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListMembers`](crate::operation::ListMembers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListMembersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.only_associated {
                query.push_kv(
                    "OnlyAssociated",
                    &aws_smithy_types::primitive::Encoder::from(_input.only_associated).encode(),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_16) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_16));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMembers",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
}

/// See [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
pub mod list_organization_admin_accounts_input {
    /// A builder for [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to
        /// <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set
        /// the value of this parameter to the value returned from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that is required for pagination. On your first call to the
        /// <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to
        /// <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set
        /// the value of this parameter to the value returned from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationAdminAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationAdminAccountsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationOutputAlias =
    crate::operation::ListOrganizationAdminAccounts;
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOrganizationAdminAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationAdminAccounts`](crate::operation::ListOrganizationAdminAccounts)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationAdminAccounts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/organization/admin").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_17) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_17));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOrganizationAdminAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOrganizationAdminAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationAdminAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationAdminAccounts",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource to retrieve tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.resource_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource to apply the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to apply the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.resource_arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_19, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.resource_arn;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_20, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.tag_keys {
                for inner_22 in inner_21 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_22));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateActionTargetInput`](crate::input::UpdateActionTargetInput)
pub mod update_action_target_input {
    /// A builder for [`UpdateActionTargetInput`](crate::input::UpdateActionTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_target_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the custom action target to update.</p>
        pub fn action_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom action target to update.</p>
        pub fn set_action_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_target_arn = input;
            self
        }
        /// <p>The updated name of the custom action target.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the custom action target.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description for the custom action target.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description for the custom action target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateActionTargetInput`](crate::input::UpdateActionTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateActionTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateActionTargetInput {
                action_target_arn: self.action_target_arn,
                name: self.name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateActionTargetInputOperationOutputAlias = crate::operation::UpdateActionTarget;
#[doc(hidden)]
pub type UpdateActionTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateActionTargetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateActionTarget`](crate::operation::UpdateActionTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateActionTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateActionTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.action_target_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_target_arn",
                        details: "cannot be empty or unset",
                    })?;
            let action_target_arn = aws_smithy_http::label::fmt_string(input_23, true);
            if action_target_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "action_target_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/actionTargets/{ActionTargetArn}",
                ActionTargetArn = action_target_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateActionTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateActionTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_action_target(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateActionTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateActionTarget",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateActionTargetInput`](crate::input::UpdateActionTargetInput)
    pub fn builder() -> crate::input::update_action_target_input::Builder {
        crate::input::update_action_target_input::Builder::default()
    }
}

/// See [`UpdateFindingAggregatorInput`](crate::input::UpdateFindingAggregatorInput)
pub mod update_finding_aggregator_input {
    /// A builder for [`UpdateFindingAggregatorInput`](crate::input::UpdateFindingAggregatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_aggregator_arn: std::option::Option<std::string::String>,
        pub(crate) region_linking_mode: std::option::Option<std::string::String>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn finding_aggregator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_aggregator_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
        pub fn set_finding_aggregator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.finding_aggregator_arn = input;
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
        /// </p>
        /// </li>
        /// </ul>
        pub fn region_linking_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_linking_mode = Some(input.into());
            self
        }
        /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
        /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
        /// <p>The options are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_region_linking_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.region_linking_mode = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
        /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFindingAggregatorInput`](crate::input::UpdateFindingAggregatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFindingAggregatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFindingAggregatorInput {
                finding_aggregator_arn: self.finding_aggregator_arn,
                region_linking_mode: self.region_linking_mode,
                regions: self.regions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFindingAggregatorInputOperationOutputAlias =
    crate::operation::UpdateFindingAggregator;
#[doc(hidden)]
pub type UpdateFindingAggregatorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFindingAggregatorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFindingAggregator`](crate::operation::UpdateFindingAggregator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFindingAggregator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFindingAggregatorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findingAggregator/update").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFindingAggregatorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFindingAggregatorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_finding_aggregator(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFindingAggregator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFindingAggregator",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFindingAggregatorInput`](crate::input::UpdateFindingAggregatorInput)
    pub fn builder() -> crate::input::update_finding_aggregator_input::Builder {
        crate::input::update_finding_aggregator_input::Builder::default()
    }
}

/// See [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
pub mod update_findings_input {
    /// A builder for [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        pub(crate) note: std::option::Option<crate::model::NoteUpdate>,
        pub(crate) record_state: std::option::Option<crate::model::RecordState>,
    }
    impl Builder {
        /// <p>A collection of attributes that specify which findings you want to update.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>A collection of attributes that specify which findings you want to update.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The updated note for the finding.</p>
        pub fn note(mut self, input: crate::model::NoteUpdate) -> Self {
            self.note = Some(input);
            self
        }
        /// <p>The updated note for the finding.</p>
        pub fn set_note(mut self, input: std::option::Option<crate::model::NoteUpdate>) -> Self {
            self.note = input;
            self
        }
        /// <p>The updated record state for the finding.</p>
        pub fn record_state(mut self, input: crate::model::RecordState) -> Self {
            self.record_state = Some(input);
            self
        }
        /// <p>The updated record state for the finding.</p>
        pub fn set_record_state(
            mut self,
            input: std::option::Option<crate::model::RecordState>,
        ) -> Self {
            self.record_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFindingsInput {
                filters: self.filters,
                note: self.note,
                record_state: self.record_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFindingsInputOperationOutputAlias = crate::operation::UpdateFindings;
#[doc(hidden)]
pub type UpdateFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFindingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFindings`](crate::operation::UpdateFindings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFindings",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    pub fn builder() -> crate::input::update_findings_input::Builder {
        crate::input::update_findings_input::Builder::default()
    }
}

/// See [`UpdateInsightInput`](crate::input::UpdateInsightInput)
pub mod update_insight_input {
    /// A builder for [`UpdateInsightInput`](crate::input::UpdateInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        pub(crate) group_by_attribute: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the insight that you want to update.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the insight that you want to update.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_arn = input;
            self
        }
        /// <p>The updated name for the insight.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name for the insight.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated filters that define this insight.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The updated filters that define this insight.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_by_attribute = Some(input.into());
            self
        }
        /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_by_attribute = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInsightInput`](crate::input::UpdateInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInsightInput {
                insight_arn: self.insight_arn,
                name: self.name,
                filters: self.filters,
                group_by_attribute: self.group_by_attribute,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInsightInputOperationOutputAlias = crate::operation::UpdateInsight;
#[doc(hidden)]
pub type UpdateInsightInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateInsightInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInsight`](crate::operation::UpdateInsight)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInsight,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInsightInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.insight_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "insight_arn",
                        details: "cannot be empty or unset",
                    })?;
            let insight_arn = aws_smithy_http::label::fmt_string(input_24, true);
            if insight_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "insight_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/insights/{InsightArn}", InsightArn = insight_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInsightInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInsightInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_insight(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInsight",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInsightInput`](crate::input::UpdateInsightInput)
    pub fn builder() -> crate::input::update_insight_input::Builder {
        crate::input::update_insight_input::Builder::default()
    }
}

/// See [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
pub mod update_organization_configuration_input {
    /// A builder for [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
        /// <p>By default, this is <code>false</code>, and new accounts are not added
        /// automatically.</p>
        /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
        /// <p>By default, this is <code>false</code>, and new accounts are not added
        /// automatically.</p>
        /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOrganizationConfigurationInput {
                auto_enable: self.auto_enable.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::UpdateOrganizationConfiguration;
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOrganizationConfiguration`](crate::operation::UpdateOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOrganizationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/organization/configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_organization_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOrganizationConfiguration",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
}

/// See [`UpdateSecurityHubConfigurationInput`](crate::input::UpdateSecurityHubConfigurationInput)
pub mod update_security_hub_configuration_input {
    /// A builder for [`UpdateSecurityHubConfigurationInput`](crate::input::UpdateSecurityHubConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable_controls: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to automatically enable new controls when they are added to standards that are
        /// enabled.</p>
        /// <p>By default, this is set to <code>true</code>, and new controls are enabled
        /// automatically. To not automatically enable new controls, set this to <code>false</code>.
        /// </p>
        pub fn auto_enable_controls(mut self, input: bool) -> Self {
            self.auto_enable_controls = Some(input);
            self
        }
        /// <p>Whether to automatically enable new controls when they are added to standards that are
        /// enabled.</p>
        /// <p>By default, this is set to <code>true</code>, and new controls are enabled
        /// automatically. To not automatically enable new controls, set this to <code>false</code>.
        /// </p>
        pub fn set_auto_enable_controls(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable_controls = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSecurityHubConfigurationInput`](crate::input::UpdateSecurityHubConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSecurityHubConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSecurityHubConfigurationInput {
                auto_enable_controls: self.auto_enable_controls.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSecurityHubConfigurationInputOperationOutputAlias =
    crate::operation::UpdateSecurityHubConfiguration;
#[doc(hidden)]
pub type UpdateSecurityHubConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSecurityHubConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSecurityHubConfiguration`](crate::operation::UpdateSecurityHubConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSecurityHubConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSecurityHubConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/accounts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSecurityHubConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSecurityHubConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_security_hub_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSecurityHubConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSecurityHubConfiguration",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSecurityHubConfigurationInput`](crate::input::UpdateSecurityHubConfigurationInput)
    pub fn builder() -> crate::input::update_security_hub_configuration_input::Builder {
        crate::input::update_security_hub_configuration_input::Builder::default()
    }
}

/// See [`UpdateStandardsControlInput`](crate::input::UpdateStandardsControlInput)
pub mod update_standards_control_input {
    /// A builder for [`UpdateStandardsControlInput`](crate::input::UpdateStandardsControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standards_control_arn: std::option::Option<std::string::String>,
        pub(crate) control_status: std::option::Option<crate::model::ControlStatus>,
        pub(crate) disabled_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the security standard control to enable or disable.</p>
        pub fn standards_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.standards_control_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security standard control to enable or disable.</p>
        pub fn set_standards_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standards_control_arn = input;
            self
        }
        /// <p>The updated status of the security standard control.</p>
        pub fn control_status(mut self, input: crate::model::ControlStatus) -> Self {
            self.control_status = Some(input);
            self
        }
        /// <p>The updated status of the security standard control.</p>
        pub fn set_control_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.control_status = input;
            self
        }
        /// <p>A description of the reason why you are disabling a security standard control. If you
        /// are disabling a control, then this is required.</p>
        pub fn disabled_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.disabled_reason = Some(input.into());
            self
        }
        /// <p>A description of the reason why you are disabling a security standard control. If you
        /// are disabling a control, then this is required.</p>
        pub fn set_disabled_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disabled_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStandardsControlInput`](crate::input::UpdateStandardsControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStandardsControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStandardsControlInput {
                standards_control_arn: self.standards_control_arn,
                control_status: self.control_status,
                disabled_reason: self.disabled_reason,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStandardsControlInputOperationOutputAlias = crate::operation::UpdateStandardsControl;
#[doc(hidden)]
pub type UpdateStandardsControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStandardsControlInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStandardsControl`](crate::operation::UpdateStandardsControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStandardsControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStandardsControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.standards_control_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "standards_control_arn",
                        details: "cannot be empty or unset",
                    })?;
            let standards_control_arn = aws_smithy_http::label::fmt_string(input_25, true);
            if standards_control_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "standards_control_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/standards/control/{StandardsControlArn}",
                StandardsControlArn = standards_control_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStandardsControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStandardsControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_standards_control(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStandardsControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStandardsControl",
            "securityhub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStandardsControlInput`](crate::input::UpdateStandardsControlInput)
    pub fn builder() -> crate::input::update_standards_control_input::Builder {
        crate::input::update_standards_control_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStandardsControlInput {
    /// <p>The ARN of the security standard control to enable or disable.</p>
    pub standards_control_arn: std::option::Option<std::string::String>,
    /// <p>The updated status of the security standard control.</p>
    pub control_status: std::option::Option<crate::model::ControlStatus>,
    /// <p>A description of the reason why you are disabling a security standard control. If you
    /// are disabling a control, then this is required.</p>
    pub disabled_reason: std::option::Option<std::string::String>,
}
impl UpdateStandardsControlInput {
    /// <p>The ARN of the security standard control to enable or disable.</p>
    pub fn standards_control_arn(&self) -> std::option::Option<&str> {
        self.standards_control_arn.as_deref()
    }
    /// <p>The updated status of the security standard control.</p>
    pub fn control_status(&self) -> std::option::Option<&crate::model::ControlStatus> {
        self.control_status.as_ref()
    }
    /// <p>A description of the reason why you are disabling a security standard control. If you
    /// are disabling a control, then this is required.</p>
    pub fn disabled_reason(&self) -> std::option::Option<&str> {
        self.disabled_reason.as_deref()
    }
}
impl std::fmt::Debug for UpdateStandardsControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStandardsControlInput");
        formatter.field("standards_control_arn", &self.standards_control_arn);
        formatter.field("control_status", &self.control_status);
        formatter.field("disabled_reason", &self.disabled_reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSecurityHubConfigurationInput {
    /// <p>Whether to automatically enable new controls when they are added to standards that are
    /// enabled.</p>
    /// <p>By default, this is set to <code>true</code>, and new controls are enabled
    /// automatically. To not automatically enable new controls, set this to <code>false</code>.
    /// </p>
    pub auto_enable_controls: bool,
}
impl UpdateSecurityHubConfigurationInput {
    /// <p>Whether to automatically enable new controls when they are added to standards that are
    /// enabled.</p>
    /// <p>By default, this is set to <code>true</code>, and new controls are enabled
    /// automatically. To not automatically enable new controls, set this to <code>false</code>.
    /// </p>
    pub fn auto_enable_controls(&self) -> bool {
        self.auto_enable_controls
    }
}
impl std::fmt::Debug for UpdateSecurityHubConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSecurityHubConfigurationInput");
        formatter.field("auto_enable_controls", &self.auto_enable_controls);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationConfigurationInput {
    /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
    /// <p>By default, this is <code>false</code>, and new accounts are not added
    /// automatically.</p>
    /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
    pub auto_enable: bool,
}
impl UpdateOrganizationConfigurationInput {
    /// <p>Whether to automatically enable Security Hub for new accounts in the organization.</p>
    /// <p>By default, this is <code>false</code>, and new accounts are not added
    /// automatically.</p>
    /// <p>To automatically enable Security Hub for new accounts, set this to <code>true</code>.</p>
    pub fn auto_enable(&self) -> bool {
        self.auto_enable
    }
}
impl std::fmt::Debug for UpdateOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationConfigurationInput");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInsightInput {
    /// <p>The ARN of the insight that you want to update.</p>
    pub insight_arn: std::option::Option<std::string::String>,
    /// <p>The updated name for the insight.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated filters that define this insight.</p>
    pub filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
    /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
    pub group_by_attribute: std::option::Option<std::string::String>,
}
impl UpdateInsightInput {
    /// <p>The ARN of the insight that you want to update.</p>
    pub fn insight_arn(&self) -> std::option::Option<&str> {
        self.insight_arn.as_deref()
    }
    /// <p>The updated name for the insight.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated filters that define this insight.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::AwsSecurityFindingFilters> {
        self.filters.as_ref()
    }
    /// <p>The updated <code>GroupBy</code> attribute that defines this insight.</p>
    pub fn group_by_attribute(&self) -> std::option::Option<&str> {
        self.group_by_attribute.as_deref()
    }
}
impl std::fmt::Debug for UpdateInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInsightInput");
        formatter.field("insight_arn", &self.insight_arn);
        formatter.field("name", &self.name);
        formatter.field("filters", &self.filters);
        formatter.field("group_by_attribute", &self.group_by_attribute);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingsInput {
    /// <p>A collection of attributes that specify which findings you want to update.</p>
    pub filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
    /// <p>The updated note for the finding.</p>
    pub note: std::option::Option<crate::model::NoteUpdate>,
    /// <p>The updated record state for the finding.</p>
    pub record_state: std::option::Option<crate::model::RecordState>,
}
impl UpdateFindingsInput {
    /// <p>A collection of attributes that specify which findings you want to update.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::AwsSecurityFindingFilters> {
        self.filters.as_ref()
    }
    /// <p>The updated note for the finding.</p>
    pub fn note(&self) -> std::option::Option<&crate::model::NoteUpdate> {
        self.note.as_ref()
    }
    /// <p>The updated record state for the finding.</p>
    pub fn record_state(&self) -> std::option::Option<&crate::model::RecordState> {
        self.record_state.as_ref()
    }
}
impl std::fmt::Debug for UpdateFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingsInput");
        formatter.field("filters", &self.filters);
        formatter.field("note", &self.note);
        formatter.field("record_state", &self.record_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub finding_aggregator_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
    /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
    /// <p>The options are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
    /// </p>
    /// </li>
    /// </ul>
    pub region_linking_mode: std::option::Option<std::string::String>,
    /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
    /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub fn finding_aggregator_arn(&self) -> std::option::Option<&str> {
        self.finding_aggregator_arn.as_deref()
    }
    /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
    /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
    /// <p>The options are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
    /// </p>
    /// </li>
    /// </ul>
    pub fn region_linking_mode(&self) -> std::option::Option<&str> {
        self.region_linking_mode.as_deref()
    }
    /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
    /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for UpdateFindingAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingAggregatorInput");
        formatter.field("finding_aggregator_arn", &self.finding_aggregator_arn);
        formatter.field("region_linking_mode", &self.region_linking_mode);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateActionTargetInput {
    /// <p>The ARN of the custom action target to update.</p>
    pub action_target_arn: std::option::Option<std::string::String>,
    /// <p>The updated name of the custom action target.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description for the custom action target.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateActionTargetInput {
    /// <p>The ARN of the custom action target to update.</p>
    pub fn action_target_arn(&self) -> std::option::Option<&str> {
        self.action_target_arn.as_deref()
    }
    /// <p>The updated name of the custom action target.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated description for the custom action target.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateActionTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateActionTargetInput");
        formatter.field("action_target_arn", &self.action_target_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource to remove the tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource to remove the tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource to apply the tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource to apply the tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource to retrieve tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource to retrieve tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of items to return in the response.</p>
    pub max_results: i32,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to
    /// <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set
    /// the value of this parameter to the value returned from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of items to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to
    /// <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set
    /// the value of this parameter to the value returned from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOrganizationAdminAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationAdminAccountsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMembersInput {
    /// <p>Specifies which member accounts to include in the response based on their relationship
    /// status with the administrator account. The default value is <code>TRUE</code>.</p>
    /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member
    /// accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
    /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all
    /// existing member accounts. </p>
    pub only_associated: bool,
    /// <p>The maximum number of items to return in the response. </p>
    pub max_results: i32,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListMembers</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMembersInput {
    /// <p>Specifies which member accounts to include in the response based on their relationship
    /// status with the administrator account. The default value is <code>TRUE</code>.</p>
    /// <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member
    /// accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p>
    /// <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all
    /// existing member accounts. </p>
    pub fn only_associated(&self) -> bool {
        self.only_associated
    }
    /// <p>The maximum number of items to return in the response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListMembers</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMembersInput");
        formatter.field("only_associated", &self.only_associated);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvitationsInput {
    /// <p>The maximum number of items to return in the response. </p>
    pub max_results: i32,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListInvitations</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInvitationsInput {
    /// <p>The maximum number of items to return in the response. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListInvitations</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvitationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingAggregatorsInput {
    /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
    pub max_results: i32,
}
impl ListFindingAggregatorsInput {
    /// <p>The token returned with the previous set of results. Identifies the next set of results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return. This operation currently only returns a single result.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListFindingAggregatorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingAggregatorsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnabledProductsForImportInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in the response.</p>
    pub max_results: i32,
}
impl ListEnabledProductsForImportInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListEnabledProductsForImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnabledProductsForImportInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InviteMembersInput {
    /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl InviteMembersInput {
    /// <p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for InviteMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InviteMembersInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMembersInput {
    /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetMembersInput {
    /// <p>The list of account IDs for the Security Hub member accounts to return the details for. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for GetMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMembersInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMasterAccountInput {}
impl std::fmt::Debug for GetMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMasterAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvitationsCountInput {}
impl std::fmt::Debug for GetInvitationsCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvitationsCountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightsInput {
    /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then
    /// <code>GetInsights</code> returns all of your custom insights. It does not return any
    /// managed insights.</p>
    pub insight_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetInsights</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in the response.</p>
    pub max_results: i32,
}
impl GetInsightsInput {
    /// <p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then
    /// <code>GetInsights</code> returns all of your custom insights. It does not return any
    /// managed insights.</p>
    pub fn insight_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.insight_arns.as_deref()
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetInsights</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for GetInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightsInput");
        formatter.field("insight_arns", &self.insight_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightResultsInput {
    /// <p>The ARN of the insight for which to return results.</p>
    pub insight_arn: std::option::Option<std::string::String>,
}
impl GetInsightResultsInput {
    /// <p>The ARN of the insight for which to return results.</p>
    pub fn insight_arn(&self) -> std::option::Option<&str> {
        self.insight_arn.as_deref()
    }
}
impl std::fmt::Debug for GetInsightResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightResultsInput");
        formatter.field("insight_arn", &self.insight_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsInput {
    /// <p>The finding attributes used to define a condition to filter the returned
    /// findings.</p>
    /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to
    /// 20 filter values.</p>
    /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To
    /// search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
    pub filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
    /// <p>The finding attributes used to sort the list of returned findings.</p>
    pub sort_criteria: std::option::Option<std::vec::Vec<crate::model::SortCriterion>>,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetFindings</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of findings to return.</p>
    pub max_results: i32,
}
impl GetFindingsInput {
    /// <p>The finding attributes used to define a condition to filter the returned
    /// findings.</p>
    /// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to
    /// 20 filter values.</p>
    /// <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To
    /// search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::AwsSecurityFindingFilters> {
        self.filters.as_ref()
    }
    /// <p>The finding attributes used to sort the list of returned findings.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&[crate::model::SortCriterion]> {
        self.sort_criteria.as_deref()
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetFindings</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of findings to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for GetFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsInput");
        formatter.field("filters", &self.filters);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub finding_aggregator_arn: std::option::Option<std::string::String>,
}
impl GetFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub fn finding_aggregator_arn(&self) -> std::option::Option<&str> {
        self.finding_aggregator_arn.as_deref()
    }
}
impl std::fmt::Debug for GetFindingAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingAggregatorInput");
        formatter.field("finding_aggregator_arn", &self.finding_aggregator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnabledStandardsInput {
    /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
    pub standards_subscription_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetEnabledStandards</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: i32,
}
impl GetEnabledStandardsInput {
    /// <p>The list of the standards subscription ARNs for the standards to retrieve.</p>
    pub fn standards_subscription_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.standards_subscription_arns.as_deref()
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>GetEnabledStandards</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for GetEnabledStandardsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnabledStandardsInput");
        formatter.field(
            "standards_subscription_arns",
            &self.standards_subscription_arns,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAdministratorAccountInput {}
impl std::fmt::Debug for GetAdministratorAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAdministratorAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSecurityHubInput {
    /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Whether to enable the security standards that Security Hub has designated as automatically
    /// enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set
    /// to <code>true</code>. To not enable the automatically enabled standards, set
    /// <code>EnableDefaultStandards</code> to <code>false</code>.</p>
    pub enable_default_standards: bool,
}
impl EnableSecurityHubInput {
    /// <p>The tags to add to the hub resource when you enable Security Hub.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Whether to enable the security standards that Security Hub has designated as automatically
    /// enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set
    /// to <code>true</code>. To not enable the automatically enabled standards, set
    /// <code>EnableDefaultStandards</code> to <code>false</code>.</p>
    pub fn enable_default_standards(&self) -> bool {
        self.enable_default_standards
    }
}
impl std::fmt::Debug for EnableSecurityHubInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSecurityHubInput");
        formatter.field("tags", &self.tags);
        formatter.field("enable_default_standards", &self.enable_default_standards);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
    /// account.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator
    /// account.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for EnableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableImportFindingsForProductInput {
    /// <p>The ARN of the product to enable the integration for.</p>
    pub product_arn: std::option::Option<std::string::String>,
}
impl EnableImportFindingsForProductInput {
    /// <p>The ARN of the product to enable the integration for.</p>
    pub fn product_arn(&self) -> std::option::Option<&str> {
        self.product_arn.as_deref()
    }
}
impl std::fmt::Debug for EnableImportFindingsForProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableImportFindingsForProductInput");
        formatter.field("product_arn", &self.product_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMembersInput {
    /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociateMembersInput {
    /// <p>The account IDs of the member accounts to disassociate from the administrator account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMembersInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFromMasterAccountInput {}
impl std::fmt::Debug for DisassociateFromMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFromMasterAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFromAdministratorAccountInput {}
impl std::fmt::Debug for DisassociateFromAdministratorAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFromAdministratorAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableSecurityHubInput {}
impl std::fmt::Debug for DisableSecurityHubInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableSecurityHubInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for DisableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableImportFindingsForProductInput {
    /// <p>The ARN of the integrated product to disable the integration for.</p>
    pub product_subscription_arn: std::option::Option<std::string::String>,
}
impl DisableImportFindingsForProductInput {
    /// <p>The ARN of the integrated product to disable the integration for.</p>
    pub fn product_subscription_arn(&self) -> std::option::Option<&str> {
        self.product_subscription_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableImportFindingsForProductInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableImportFindingsForProductInput");
        formatter.field("product_subscription_arn", &self.product_subscription_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStandardsControlsInput {
    /// <p>The ARN of a resource that represents your subscription to a supported standard. To get
    /// the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
    pub standards_subscription_arn: std::option::Option<std::string::String>,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeStandardsControls</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of security standard controls to return.</p>
    pub max_results: i32,
}
impl DescribeStandardsControlsInput {
    /// <p>The ARN of a resource that represents your subscription to a supported standard. To get
    /// the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>
    pub fn standards_subscription_arn(&self) -> std::option::Option<&str> {
        self.standards_subscription_arn.as_deref()
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeStandardsControls</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of security standard controls to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeStandardsControlsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStandardsControlsInput");
        formatter.field(
            "standards_subscription_arn",
            &self.standards_subscription_arn,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStandardsInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeStandards</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of standards to return.</p>
    pub max_results: i32,
}
impl DescribeStandardsInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeStandards</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of standards to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeStandardsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStandardsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProductsInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeProducts</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: i32,
    /// <p>The ARN of the integration to return.</p>
    pub product_arn: std::option::Option<std::string::String>,
}
impl DescribeProductsInput {
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeProducts</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The ARN of the integration to return.</p>
    pub fn product_arn(&self) -> std::option::Option<&str> {
        self.product_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeProductsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProductsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("product_arn", &self.product_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigurationInput {}
impl std::fmt::Debug for DescribeOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHubInput {
    /// <p>The ARN of the Hub resource to retrieve.</p>
    pub hub_arn: std::option::Option<std::string::String>,
}
impl DescribeHubInput {
    /// <p>The ARN of the Hub resource to retrieve.</p>
    pub fn hub_arn(&self) -> std::option::Option<&str> {
        self.hub_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeHubInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHubInput");
        formatter.field("hub_arn", &self.hub_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActionTargetsInput {
    /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
    pub action_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeActionTargets</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: i32,
}
impl DescribeActionTargetsInput {
    /// <p>A list of custom action target ARNs for the custom action targets to retrieve.</p>
    pub fn action_target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.action_target_arns.as_deref()
    }
    /// <p>The token that is required for pagination. On your first call to the
    /// <code>DescribeActionTargets</code> operation, set the value of this parameter to
    /// <code>NULL</code>.</p>
    /// <p>For subsequent calls to the operation, to continue listing data, set the value of this
    /// parameter to the value returned from the previous response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeActionTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActionTargetsInput");
        formatter.field("action_target_arns", &self.action_target_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMembersInput {
    /// <p>The list of account IDs for the member accounts to delete.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteMembersInput {
    /// <p>The list of account IDs for the member accounts to delete.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMembersInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInvitationsInput {
    /// <p>The list of the account IDs that sent the invitations to delete.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteInvitationsInput {
    /// <p>The list of the account IDs that sent the invitations to delete.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInsightInput {
    /// <p>The ARN of the insight to delete.</p>
    pub insight_arn: std::option::Option<std::string::String>,
}
impl DeleteInsightInput {
    /// <p>The ARN of the insight to delete.</p>
    pub fn insight_arn(&self) -> std::option::Option<&str> {
        self.insight_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInsightInput");
        formatter.field("insight_arn", &self.insight_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub finding_aggregator_arn: std::option::Option<std::string::String>,
}
impl DeleteFindingAggregatorInput {
    /// <p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>
    pub fn finding_aggregator_arn(&self) -> std::option::Option<&str> {
        self.finding_aggregator_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteFindingAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFindingAggregatorInput");
        formatter.field("finding_aggregator_arn", &self.finding_aggregator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteActionTargetInput {
    /// <p>The ARN of the custom action target to delete.</p>
    pub action_target_arn: std::option::Option<std::string::String>,
}
impl DeleteActionTargetInput {
    /// <p>The ARN of the custom action target to delete.</p>
    pub fn action_target_arn(&self) -> std::option::Option<&str> {
        self.action_target_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteActionTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteActionTargetInput");
        formatter.field("action_target_arn", &self.action_target_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeclineInvitationsInput {
    /// <p>The list of account IDs for the accounts from which to decline the invitations to
    /// Security Hub.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeclineInvitationsInput {
    /// <p>The list of account IDs for the accounts from which to decline the invitations to
    /// Security Hub.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeclineInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeclineInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMembersInput {
    /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the
    /// list includes the account ID and optionally the email address.</p>
    pub account_details: std::option::Option<std::vec::Vec<crate::model::AccountDetails>>,
}
impl CreateMembersInput {
    /// <p>The list of accounts to associate with the Security Hub administrator account. For each account, the
    /// list includes the account ID and optionally the email address.</p>
    pub fn account_details(&self) -> std::option::Option<&[crate::model::AccountDetails]> {
        self.account_details.as_deref()
    }
}
impl std::fmt::Debug for CreateMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMembersInput");
        formatter.field("account_details", &self.account_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInsightInput {
    /// <p>The name of the custom insight to create.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more attributes used to filter the findings included in the insight. The insight
    /// only includes findings that match the criteria defined in the filters.</p>
    pub filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
    /// <p>The attribute used to group the findings for the insight. The grouping attribute
    /// identifies the type of item that the insight applies to. For example, if an insight is
    /// grouped by resource identifier, then the insight produces a list of resource
    /// identifiers.</p>
    pub group_by_attribute: std::option::Option<std::string::String>,
}
impl CreateInsightInput {
    /// <p>The name of the custom insight to create.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more attributes used to filter the findings included in the insight. The insight
    /// only includes findings that match the criteria defined in the filters.</p>
    pub fn filters(&self) -> std::option::Option<&crate::model::AwsSecurityFindingFilters> {
        self.filters.as_ref()
    }
    /// <p>The attribute used to group the findings for the insight. The grouping attribute
    /// identifies the type of item that the insight applies to. For example, if an insight is
    /// grouped by resource identifier, then the insight produces a list of resource
    /// identifiers.</p>
    pub fn group_by_attribute(&self) -> std::option::Option<&str> {
        self.group_by_attribute.as_deref()
    }
}
impl std::fmt::Debug for CreateInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInsightInput");
        formatter.field("name", &self.name);
        formatter.field("filters", &self.filters);
        formatter.field("group_by_attribute", &self.group_by_attribute);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFindingAggregatorInput {
    /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
    /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
    /// <p>The options are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
    /// </p>
    /// </li>
    /// </ul>
    pub region_linking_mode: std::option::Option<std::string::String>,
    /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
    /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.
    /// </p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateFindingAggregatorInput {
    /// <p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p>
    /// <p>The selected option also determines how to use the Regions provided in the Regions list.</p>
    /// <p>The options are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIED_REGIONS</code> - Indicates to aggregate findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions.
    /// </p>
    /// </li>
    /// </ul>
    pub fn region_linking_mode(&self) -> std::option::Option<&str> {
        self.region_linking_mode.as_deref()
    }
    /// <p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a comma-separated list of Regions that do not aggregate findings to the aggregation Region.</p>
    /// <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a comma-separated list of Regions that do aggregate findings to the aggregation Region.
    /// </p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for CreateFindingAggregatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFindingAggregatorInput");
        formatter.field("region_linking_mode", &self.region_linking_mode);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateActionTargetInput {
    /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for the custom action target.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
    pub id: std::option::Option<std::string::String>,
}
impl CreateActionTargetInput {
    /// <p>The name of the custom action target. Can contain up to 20 characters.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description for the custom action target.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for CreateActionTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateActionTargetInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateFindingsInput {
    /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update
    /// up to 100 findings at a time.</p>
    /// <p>For each finding, the list provides the finding identifier and the ARN of the finding
    /// provider.</p>
    pub finding_identifiers:
        std::option::Option<std::vec::Vec<crate::model::AwsSecurityFindingIdentifier>>,
    /// <p>The updated note.</p>
    pub note: std::option::Option<crate::model::NoteUpdate>,
    /// <p>Used to update the finding severity.</p>
    pub severity: std::option::Option<crate::model::SeverityUpdate>,
    /// <p>Indicates the veracity of a finding.</p>
    /// <p>The available values for <code>VerificationState</code> are  as follows.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNKNOWN</code> – The default disposition of a security finding</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRUE_POSITIVE</code> – The security finding is confirmed</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FALSE_POSITIVE</code> – The security finding was determined to be a false
    /// alarm</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where
    /// the finding doesn't pose any threat, is expected, or both</p>
    /// </li>
    /// </ul>
    pub verification_state: std::option::Option<crate::model::VerificationState>,
    /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood
    /// that a finding accurately identifies the behavior or issue that it was intended to
    /// identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub confidence: i32,
    /// <p>The updated value for the level of importance assigned to the resources associated with
    /// the findings.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources. </p>
    pub criticality: i32,
    /// <p>One or more finding types in the format of namespace/category/classifier that classify a
    /// finding.</p>
    /// <p>Valid namespace values are as follows.</p>
    /// <ul>
    /// <li>
    /// <p>Software and Configuration Checks</p>
    /// </li>
    /// <li>
    /// <p>TTPs</p>
    /// </li>
    /// <li>
    /// <p>Effects</p>
    /// </li>
    /// <li>
    /// <p>Unusual Behaviors</p>
    /// </li>
    /// <li>
    /// <p>Sensitive Data Identifications </p>
    /// </li>
    /// </ul>
    pub types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of name/value string pairs associated with the finding. These are custom,
    /// user-defined fields added to a finding.</p>
    pub user_defined_fields:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Used to update the workflow status of a finding.</p>
    /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
    pub workflow: std::option::Option<crate::model::WorkflowUpdate>,
    /// <p>A list of findings that are related to the updated findings.</p>
    pub related_findings: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
}
impl BatchUpdateFindingsInput {
    /// <p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update
    /// up to 100 findings at a time.</p>
    /// <p>For each finding, the list provides the finding identifier and the ARN of the finding
    /// provider.</p>
    pub fn finding_identifiers(
        &self,
    ) -> std::option::Option<&[crate::model::AwsSecurityFindingIdentifier]> {
        self.finding_identifiers.as_deref()
    }
    /// <p>The updated note.</p>
    pub fn note(&self) -> std::option::Option<&crate::model::NoteUpdate> {
        self.note.as_ref()
    }
    /// <p>Used to update the finding severity.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::SeverityUpdate> {
        self.severity.as_ref()
    }
    /// <p>Indicates the veracity of a finding.</p>
    /// <p>The available values for <code>VerificationState</code> are  as follows.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNKNOWN</code> – The default disposition of a security finding</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRUE_POSITIVE</code> – The security finding is confirmed</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FALSE_POSITIVE</code> – The security finding was determined to be a false
    /// alarm</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where
    /// the finding doesn't pose any threat, is expected, or both</p>
    /// </li>
    /// </ul>
    pub fn verification_state(&self) -> std::option::Option<&crate::model::VerificationState> {
        self.verification_state.as_ref()
    }
    /// <p>The updated value for the finding confidence. Confidence is defined as the likelihood
    /// that a finding accurately identifies the behavior or issue that it was intended to
    /// identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub fn confidence(&self) -> i32 {
        self.confidence
    }
    /// <p>The updated value for the level of importance assigned to the resources associated with
    /// the findings.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources. </p>
    pub fn criticality(&self) -> i32 {
        self.criticality
    }
    /// <p>One or more finding types in the format of namespace/category/classifier that classify a
    /// finding.</p>
    /// <p>Valid namespace values are as follows.</p>
    /// <ul>
    /// <li>
    /// <p>Software and Configuration Checks</p>
    /// </li>
    /// <li>
    /// <p>TTPs</p>
    /// </li>
    /// <li>
    /// <p>Effects</p>
    /// </li>
    /// <li>
    /// <p>Unusual Behaviors</p>
    /// </li>
    /// <li>
    /// <p>Sensitive Data Identifications </p>
    /// </li>
    /// </ul>
    pub fn types(&self) -> std::option::Option<&[std::string::String]> {
        self.types.as_deref()
    }
    /// <p>A list of name/value string pairs associated with the finding. These are custom,
    /// user-defined fields added to a finding.</p>
    pub fn user_defined_fields(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.user_defined_fields.as_ref()
    }
    /// <p>Used to update the workflow status of a finding.</p>
    /// <p>The workflow status indicates the progress of the investigation into the finding. </p>
    pub fn workflow(&self) -> std::option::Option<&crate::model::WorkflowUpdate> {
        self.workflow.as_ref()
    }
    /// <p>A list of findings that are related to the updated findings.</p>
    pub fn related_findings(&self) -> std::option::Option<&[crate::model::RelatedFinding]> {
        self.related_findings.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateFindingsInput");
        formatter.field("finding_identifiers", &self.finding_identifiers);
        formatter.field("note", &self.note);
        formatter.field("severity", &self.severity);
        formatter.field("verification_state", &self.verification_state);
        formatter.field("confidence", &self.confidence);
        formatter.field("criticality", &self.criticality);
        formatter.field("types", &self.types);
        formatter.field("user_defined_fields", &self.user_defined_fields);
        formatter.field("workflow", &self.workflow);
        formatter.field("related_findings", &self.related_findings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchImportFindingsInput {
    /// <p>A list of findings to import. To successfully import a finding, it must follow the
    /// <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::AwsSecurityFinding>>,
}
impl BatchImportFindingsInput {
    /// <p>A list of findings to import. To successfully import a finding, it must follow the
    /// <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>
    pub fn findings(&self) -> std::option::Option<&[crate::model::AwsSecurityFinding]> {
        self.findings.as_deref()
    }
}
impl std::fmt::Debug for BatchImportFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchImportFindingsInput");
        formatter.field("findings", &self.findings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEnableStandardsInput {
    /// <p>The list of standards checks to enable.</p>
    pub standards_subscription_requests:
        std::option::Option<std::vec::Vec<crate::model::StandardsSubscriptionRequest>>,
}
impl BatchEnableStandardsInput {
    /// <p>The list of standards checks to enable.</p>
    pub fn standards_subscription_requests(
        &self,
    ) -> std::option::Option<&[crate::model::StandardsSubscriptionRequest]> {
        self.standards_subscription_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchEnableStandardsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEnableStandardsInput");
        formatter.field(
            "standards_subscription_requests",
            &self.standards_subscription_requests,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisableStandardsInput {
    /// <p>The ARNs of the standards subscriptions to disable.</p>
    pub standards_subscription_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDisableStandardsInput {
    /// <p>The ARNs of the standards subscriptions to disable.</p>
    pub fn standards_subscription_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.standards_subscription_arns.as_deref()
    }
}
impl std::fmt::Debug for BatchDisableStandardsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisableStandardsInput");
        formatter.field(
            "standards_subscription_arns",
            &self.standards_subscription_arns,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInvitationInput {
    /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    pub master_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
}
impl AcceptInvitationInput {
    /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    pub fn master_id(&self) -> std::option::Option<&str> {
        self.master_id.as_deref()
    }
    /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInvitationInput");
        formatter.field("master_id", &self.master_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptAdministratorInvitationInput {
    /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    pub administrator_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
}
impl AcceptAdministratorInvitationInput {
    /// <p>The account ID of the Security Hub administrator account that sent the invitation.</p>
    pub fn administrator_id(&self) -> std::option::Option<&str> {
        self.administrator_id.as_deref()
    }
    /// <p>The identifier of the invitation sent from the Security Hub administrator account.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptAdministratorInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptAdministratorInvitationInput");
        formatter.field("administrator_id", &self.administrator_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.finish()
    }
}
