// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptAdministratorInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_administrator_invitation`](crate::client::Client::accept_administrator_invitation).
///
/// See [`crate::client::fluent_builders::AcceptAdministratorInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptAdministratorInvitation {
    _private: (),
}
impl AcceptAdministratorInvitation {
    /// Creates a new builder-style object to manufacture [`AcceptAdministratorInvitationInput`](crate::input::AcceptAdministratorInvitationInput)
    pub fn builder() -> crate::input::accept_administrator_invitation_input::Builder {
        crate::input::accept_administrator_invitation_input::Builder::default()
    }
    /// Creates a new `AcceptAdministratorInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptAdministratorInvitation {
    type Output = std::result::Result<
        crate::output::AcceptAdministratorInvitationOutput,
        crate::error::AcceptAdministratorInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_administrator_invitation_error(response)
        } else {
            crate::operation_deser::parse_accept_administrator_invitation_response(response)
        }
    }
}

/// Operation shape for `AcceptInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_invitation`](crate::client::Client::accept_invitation).
///
/// See [`crate::client::fluent_builders::AcceptInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInvitation {
    _private: (),
}
impl AcceptInvitation {
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
    /// Creates a new `AcceptInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInvitation {
    type Output = std::result::Result<
        crate::output::AcceptInvitationOutput,
        crate::error::AcceptInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_invitation_error(response)
        } else {
            crate::operation_deser::parse_accept_invitation_response(response)
        }
    }
}

/// Operation shape for `BatchDisableStandards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disable_standards`](crate::client::Client::batch_disable_standards).
///
/// See [`crate::client::fluent_builders::BatchDisableStandards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisableStandards {
    _private: (),
}
impl BatchDisableStandards {
    /// Creates a new builder-style object to manufacture [`BatchDisableStandardsInput`](crate::input::BatchDisableStandardsInput)
    pub fn builder() -> crate::input::batch_disable_standards_input::Builder {
        crate::input::batch_disable_standards_input::Builder::default()
    }
    /// Creates a new `BatchDisableStandards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDisableStandards {
    type Output = std::result::Result<
        crate::output::BatchDisableStandardsOutput,
        crate::error::BatchDisableStandardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disable_standards_error(response)
        } else {
            crate::operation_deser::parse_batch_disable_standards_response(response)
        }
    }
}

/// Operation shape for `BatchEnableStandards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_enable_standards`](crate::client::Client::batch_enable_standards).
///
/// See [`crate::client::fluent_builders::BatchEnableStandards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchEnableStandards {
    _private: (),
}
impl BatchEnableStandards {
    /// Creates a new builder-style object to manufacture [`BatchEnableStandardsInput`](crate::input::BatchEnableStandardsInput)
    pub fn builder() -> crate::input::batch_enable_standards_input::Builder {
        crate::input::batch_enable_standards_input::Builder::default()
    }
    /// Creates a new `BatchEnableStandards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchEnableStandards {
    type Output = std::result::Result<
        crate::output::BatchEnableStandardsOutput,
        crate::error::BatchEnableStandardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_enable_standards_error(response)
        } else {
            crate::operation_deser::parse_batch_enable_standards_response(response)
        }
    }
}

/// Operation shape for `BatchImportFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_import_findings`](crate::client::Client::batch_import_findings).
///
/// See [`crate::client::fluent_builders::BatchImportFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchImportFindings {
    _private: (),
}
impl BatchImportFindings {
    /// Creates a new builder-style object to manufacture [`BatchImportFindingsInput`](crate::input::BatchImportFindingsInput)
    pub fn builder() -> crate::input::batch_import_findings_input::Builder {
        crate::input::batch_import_findings_input::Builder::default()
    }
    /// Creates a new `BatchImportFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchImportFindings {
    type Output = std::result::Result<
        crate::output::BatchImportFindingsOutput,
        crate::error::BatchImportFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_import_findings_error(response)
        } else {
            crate::operation_deser::parse_batch_import_findings_response(response)
        }
    }
}

/// Operation shape for `BatchUpdateFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_findings`](crate::client::Client::batch_update_findings).
///
/// See [`crate::client::fluent_builders::BatchUpdateFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdateFindings {
    _private: (),
}
impl BatchUpdateFindings {
    /// Creates a new builder-style object to manufacture [`BatchUpdateFindingsInput`](crate::input::BatchUpdateFindingsInput)
    pub fn builder() -> crate::input::batch_update_findings_input::Builder {
        crate::input::batch_update_findings_input::Builder::default()
    }
    /// Creates a new `BatchUpdateFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdateFindings {
    type Output = std::result::Result<
        crate::output::BatchUpdateFindingsOutput,
        crate::error::BatchUpdateFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_findings_error(response)
        } else {
            crate::operation_deser::parse_batch_update_findings_response(response)
        }
    }
}

/// Operation shape for `CreateActionTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_action_target`](crate::client::Client::create_action_target).
///
/// See [`crate::client::fluent_builders::CreateActionTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateActionTarget {
    _private: (),
}
impl CreateActionTarget {
    /// Creates a new builder-style object to manufacture [`CreateActionTargetInput`](crate::input::CreateActionTargetInput)
    pub fn builder() -> crate::input::create_action_target_input::Builder {
        crate::input::create_action_target_input::Builder::default()
    }
    /// Creates a new `CreateActionTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateActionTarget {
    type Output = std::result::Result<
        crate::output::CreateActionTargetOutput,
        crate::error::CreateActionTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_action_target_error(response)
        } else {
            crate::operation_deser::parse_create_action_target_response(response)
        }
    }
}

/// Operation shape for `CreateInsight`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_insight`](crate::client::Client::create_insight).
///
/// See [`crate::client::fluent_builders::CreateInsight`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInsight {
    _private: (),
}
impl CreateInsight {
    /// Creates a new builder-style object to manufacture [`CreateInsightInput`](crate::input::CreateInsightInput)
    pub fn builder() -> crate::input::create_insight_input::Builder {
        crate::input::create_insight_input::Builder::default()
    }
    /// Creates a new `CreateInsight` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInsight {
    type Output =
        std::result::Result<crate::output::CreateInsightOutput, crate::error::CreateInsightError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_insight_error(response)
        } else {
            crate::operation_deser::parse_create_insight_response(response)
        }
    }
}

/// Operation shape for `CreateMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_members`](crate::client::Client::create_members).
///
/// See [`crate::client::fluent_builders::CreateMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMembers {
    _private: (),
}
impl CreateMembers {
    /// Creates a new builder-style object to manufacture [`CreateMembersInput`](crate::input::CreateMembersInput)
    pub fn builder() -> crate::input::create_members_input::Builder {
        crate::input::create_members_input::Builder::default()
    }
    /// Creates a new `CreateMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMembers {
    type Output =
        std::result::Result<crate::output::CreateMembersOutput, crate::error::CreateMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_members_error(response)
        } else {
            crate::operation_deser::parse_create_members_response(response)
        }
    }
}

/// Operation shape for `DeclineInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decline_invitations`](crate::client::Client::decline_invitations).
///
/// See [`crate::client::fluent_builders::DeclineInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeclineInvitations {
    _private: (),
}
impl DeclineInvitations {
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
    /// Creates a new `DeclineInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeclineInvitations {
    type Output = std::result::Result<
        crate::output::DeclineInvitationsOutput,
        crate::error::DeclineInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decline_invitations_error(response)
        } else {
            crate::operation_deser::parse_decline_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteActionTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_action_target`](crate::client::Client::delete_action_target).
///
/// See [`crate::client::fluent_builders::DeleteActionTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteActionTarget {
    _private: (),
}
impl DeleteActionTarget {
    /// Creates a new builder-style object to manufacture [`DeleteActionTargetInput`](crate::input::DeleteActionTargetInput)
    pub fn builder() -> crate::input::delete_action_target_input::Builder {
        crate::input::delete_action_target_input::Builder::default()
    }
    /// Creates a new `DeleteActionTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteActionTarget {
    type Output = std::result::Result<
        crate::output::DeleteActionTargetOutput,
        crate::error::DeleteActionTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_action_target_error(response)
        } else {
            crate::operation_deser::parse_delete_action_target_response(response)
        }
    }
}

/// Operation shape for `DeleteInsight`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_insight`](crate::client::Client::delete_insight).
///
/// See [`crate::client::fluent_builders::DeleteInsight`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInsight {
    _private: (),
}
impl DeleteInsight {
    /// Creates a new builder-style object to manufacture [`DeleteInsightInput`](crate::input::DeleteInsightInput)
    pub fn builder() -> crate::input::delete_insight_input::Builder {
        crate::input::delete_insight_input::Builder::default()
    }
    /// Creates a new `DeleteInsight` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInsight {
    type Output =
        std::result::Result<crate::output::DeleteInsightOutput, crate::error::DeleteInsightError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_insight_error(response)
        } else {
            crate::operation_deser::parse_delete_insight_response(response)
        }
    }
}

/// Operation shape for `DeleteInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_invitations`](crate::client::Client::delete_invitations).
///
/// See [`crate::client::fluent_builders::DeleteInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInvitations {
    _private: (),
}
impl DeleteInvitations {
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
    /// Creates a new `DeleteInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInvitations {
    type Output = std::result::Result<
        crate::output::DeleteInvitationsOutput,
        crate::error::DeleteInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_invitations_error(response)
        } else {
            crate::operation_deser::parse_delete_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_members`](crate::client::Client::delete_members).
///
/// See [`crate::client::fluent_builders::DeleteMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMembers {
    _private: (),
}
impl DeleteMembers {
    /// Creates a new builder-style object to manufacture [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    pub fn builder() -> crate::input::delete_members_input::Builder {
        crate::input::delete_members_input::Builder::default()
    }
    /// Creates a new `DeleteMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMembers {
    type Output =
        std::result::Result<crate::output::DeleteMembersOutput, crate::error::DeleteMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_members_error(response)
        } else {
            crate::operation_deser::parse_delete_members_response(response)
        }
    }
}

/// Operation shape for `DescribeActionTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_action_targets`](crate::client::Client::describe_action_targets).
///
/// See [`crate::client::fluent_builders::DescribeActionTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActionTargets {
    _private: (),
}
impl DescribeActionTargets {
    /// Creates a new builder-style object to manufacture [`DescribeActionTargetsInput`](crate::input::DescribeActionTargetsInput)
    pub fn builder() -> crate::input::describe_action_targets_input::Builder {
        crate::input::describe_action_targets_input::Builder::default()
    }
    /// Creates a new `DescribeActionTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActionTargets {
    type Output = std::result::Result<
        crate::output::DescribeActionTargetsOutput,
        crate::error::DescribeActionTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_action_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_action_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeHub`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hub`](crate::client::Client::describe_hub).
///
/// See [`crate::client::fluent_builders::DescribeHub`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHub {
    _private: (),
}
impl DescribeHub {
    /// Creates a new builder-style object to manufacture [`DescribeHubInput`](crate::input::DescribeHubInput)
    pub fn builder() -> crate::input::describe_hub_input::Builder {
        crate::input::describe_hub_input::Builder::default()
    }
    /// Creates a new `DescribeHub` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHub {
    type Output =
        std::result::Result<crate::output::DescribeHubOutput, crate::error::DescribeHubError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hub_error(response)
        } else {
            crate::operation_deser::parse_describe_hub_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_configuration`](crate::client::Client::describe_organization_configuration).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfiguration {
    _private: (),
}
impl DescribeOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigurationOutput,
        crate::error::DescribeOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeProducts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_products`](crate::client::Client::describe_products).
///
/// See [`crate::client::fluent_builders::DescribeProducts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProducts {
    _private: (),
}
impl DescribeProducts {
    /// Creates a new builder-style object to manufacture [`DescribeProductsInput`](crate::input::DescribeProductsInput)
    pub fn builder() -> crate::input::describe_products_input::Builder {
        crate::input::describe_products_input::Builder::default()
    }
    /// Creates a new `DescribeProducts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProducts {
    type Output = std::result::Result<
        crate::output::DescribeProductsOutput,
        crate::error::DescribeProductsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_products_error(response)
        } else {
            crate::operation_deser::parse_describe_products_response(response)
        }
    }
}

/// Operation shape for `DescribeStandards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_standards`](crate::client::Client::describe_standards).
///
/// See [`crate::client::fluent_builders::DescribeStandards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStandards {
    _private: (),
}
impl DescribeStandards {
    /// Creates a new builder-style object to manufacture [`DescribeStandardsInput`](crate::input::DescribeStandardsInput)
    pub fn builder() -> crate::input::describe_standards_input::Builder {
        crate::input::describe_standards_input::Builder::default()
    }
    /// Creates a new `DescribeStandards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStandards {
    type Output = std::result::Result<
        crate::output::DescribeStandardsOutput,
        crate::error::DescribeStandardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_standards_error(response)
        } else {
            crate::operation_deser::parse_describe_standards_response(response)
        }
    }
}

/// Operation shape for `DescribeStandardsControls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_standards_controls`](crate::client::Client::describe_standards_controls).
///
/// See [`crate::client::fluent_builders::DescribeStandardsControls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStandardsControls {
    _private: (),
}
impl DescribeStandardsControls {
    /// Creates a new builder-style object to manufacture [`DescribeStandardsControlsInput`](crate::input::DescribeStandardsControlsInput)
    pub fn builder() -> crate::input::describe_standards_controls_input::Builder {
        crate::input::describe_standards_controls_input::Builder::default()
    }
    /// Creates a new `DescribeStandardsControls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStandardsControls {
    type Output = std::result::Result<
        crate::output::DescribeStandardsControlsOutput,
        crate::error::DescribeStandardsControlsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_standards_controls_error(response)
        } else {
            crate::operation_deser::parse_describe_standards_controls_response(response)
        }
    }
}

/// Operation shape for `DisableImportFindingsForProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_import_findings_for_product`](crate::client::Client::disable_import_findings_for_product).
///
/// See [`crate::client::fluent_builders::DisableImportFindingsForProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableImportFindingsForProduct {
    _private: (),
}
impl DisableImportFindingsForProduct {
    /// Creates a new builder-style object to manufacture [`DisableImportFindingsForProductInput`](crate::input::DisableImportFindingsForProductInput)
    pub fn builder() -> crate::input::disable_import_findings_for_product_input::Builder {
        crate::input::disable_import_findings_for_product_input::Builder::default()
    }
    /// Creates a new `DisableImportFindingsForProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableImportFindingsForProduct {
    type Output = std::result::Result<
        crate::output::DisableImportFindingsForProductOutput,
        crate::error::DisableImportFindingsForProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_import_findings_for_product_error(response)
        } else {
            crate::operation_deser::parse_disable_import_findings_for_product_response(response)
        }
    }
}

/// Operation shape for `DisableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_organization_admin_account`](crate::client::Client::disable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DisableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableOrganizationAdminAccount {
    _private: (),
}
impl DisableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableOrganizationAdminAccountOutput,
        crate::error::DisableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisableSecurityHub`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_security_hub`](crate::client::Client::disable_security_hub).
///
/// See [`crate::client::fluent_builders::DisableSecurityHub`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableSecurityHub {
    _private: (),
}
impl DisableSecurityHub {
    /// Creates a new builder-style object to manufacture [`DisableSecurityHubInput`](crate::input::DisableSecurityHubInput)
    pub fn builder() -> crate::input::disable_security_hub_input::Builder {
        crate::input::disable_security_hub_input::Builder::default()
    }
    /// Creates a new `DisableSecurityHub` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableSecurityHub {
    type Output = std::result::Result<
        crate::output::DisableSecurityHubOutput,
        crate::error::DisableSecurityHubError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_security_hub_error(response)
        } else {
            crate::operation_deser::parse_disable_security_hub_response(response)
        }
    }
}

/// Operation shape for `DisassociateFromAdministratorAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_from_administrator_account`](crate::client::Client::disassociate_from_administrator_account).
///
/// See [`crate::client::fluent_builders::DisassociateFromAdministratorAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFromAdministratorAccount {
    _private: (),
}
impl DisassociateFromAdministratorAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    pub fn builder() -> crate::input::disassociate_from_administrator_account_input::Builder {
        crate::input::disassociate_from_administrator_account_input::Builder::default()
    }
    /// Creates a new `DisassociateFromAdministratorAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFromAdministratorAccount {
    type Output = std::result::Result<
        crate::output::DisassociateFromAdministratorAccountOutput,
        crate::error::DisassociateFromAdministratorAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_from_administrator_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_from_administrator_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateFromMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_from_master_account`](crate::client::Client::disassociate_from_master_account).
///
/// See [`crate::client::fluent_builders::DisassociateFromMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFromMasterAccount {
    _private: (),
}
impl DisassociateFromMasterAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
    /// Creates a new `DisassociateFromMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFromMasterAccount {
    type Output = std::result::Result<
        crate::output::DisassociateFromMasterAccountOutput,
        crate::error::DisassociateFromMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_from_master_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_from_master_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_members`](crate::client::Client::disassociate_members).
///
/// See [`crate::client::fluent_builders::DisassociateMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMembers {
    _private: (),
}
impl DisassociateMembers {
    /// Creates a new builder-style object to manufacture [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    pub fn builder() -> crate::input::disassociate_members_input::Builder {
        crate::input::disassociate_members_input::Builder::default()
    }
    /// Creates a new `DisassociateMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMembers {
    type Output = std::result::Result<
        crate::output::DisassociateMembersOutput,
        crate::error::DisassociateMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_members_error(response)
        } else {
            crate::operation_deser::parse_disassociate_members_response(response)
        }
    }
}

/// Operation shape for `EnableImportFindingsForProduct`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_import_findings_for_product`](crate::client::Client::enable_import_findings_for_product).
///
/// See [`crate::client::fluent_builders::EnableImportFindingsForProduct`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableImportFindingsForProduct {
    _private: (),
}
impl EnableImportFindingsForProduct {
    /// Creates a new builder-style object to manufacture [`EnableImportFindingsForProductInput`](crate::input::EnableImportFindingsForProductInput)
    pub fn builder() -> crate::input::enable_import_findings_for_product_input::Builder {
        crate::input::enable_import_findings_for_product_input::Builder::default()
    }
    /// Creates a new `EnableImportFindingsForProduct` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableImportFindingsForProduct {
    type Output = std::result::Result<
        crate::output::EnableImportFindingsForProductOutput,
        crate::error::EnableImportFindingsForProductError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_import_findings_for_product_error(response)
        } else {
            crate::operation_deser::parse_enable_import_findings_for_product_response(response)
        }
    }
}

/// Operation shape for `EnableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_organization_admin_account`](crate::client::Client::enable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::EnableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableOrganizationAdminAccount {
    _private: (),
}
impl EnableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableOrganizationAdminAccountOutput,
        crate::error::EnableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `EnableSecurityHub`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_security_hub`](crate::client::Client::enable_security_hub).
///
/// See [`crate::client::fluent_builders::EnableSecurityHub`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableSecurityHub {
    _private: (),
}
impl EnableSecurityHub {
    /// Creates a new builder-style object to manufacture [`EnableSecurityHubInput`](crate::input::EnableSecurityHubInput)
    pub fn builder() -> crate::input::enable_security_hub_input::Builder {
        crate::input::enable_security_hub_input::Builder::default()
    }
    /// Creates a new `EnableSecurityHub` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableSecurityHub {
    type Output = std::result::Result<
        crate::output::EnableSecurityHubOutput,
        crate::error::EnableSecurityHubError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_security_hub_error(response)
        } else {
            crate::operation_deser::parse_enable_security_hub_response(response)
        }
    }
}

/// Operation shape for `GetAdministratorAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_administrator_account`](crate::client::Client::get_administrator_account).
///
/// See [`crate::client::fluent_builders::GetAdministratorAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAdministratorAccount {
    _private: (),
}
impl GetAdministratorAccount {
    /// Creates a new builder-style object to manufacture [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    pub fn builder() -> crate::input::get_administrator_account_input::Builder {
        crate::input::get_administrator_account_input::Builder::default()
    }
    /// Creates a new `GetAdministratorAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAdministratorAccount {
    type Output = std::result::Result<
        crate::output::GetAdministratorAccountOutput,
        crate::error::GetAdministratorAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_administrator_account_error(response)
        } else {
            crate::operation_deser::parse_get_administrator_account_response(response)
        }
    }
}

/// Operation shape for `GetEnabledStandards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_enabled_standards`](crate::client::Client::get_enabled_standards).
///
/// See [`crate::client::fluent_builders::GetEnabledStandards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnabledStandards {
    _private: (),
}
impl GetEnabledStandards {
    /// Creates a new builder-style object to manufacture [`GetEnabledStandardsInput`](crate::input::GetEnabledStandardsInput)
    pub fn builder() -> crate::input::get_enabled_standards_input::Builder {
        crate::input::get_enabled_standards_input::Builder::default()
    }
    /// Creates a new `GetEnabledStandards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnabledStandards {
    type Output = std::result::Result<
        crate::output::GetEnabledStandardsOutput,
        crate::error::GetEnabledStandardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_enabled_standards_error(response)
        } else {
            crate::operation_deser::parse_get_enabled_standards_response(response)
        }
    }
}

/// Operation shape for `GetFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings`](crate::client::Client::get_findings).
///
/// See [`crate::client::fluent_builders::GetFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindings {
    _private: (),
}
impl GetFindings {
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
    /// Creates a new `GetFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindings {
    type Output =
        std::result::Result<crate::output::GetFindingsOutput, crate::error::GetFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_error(response)
        } else {
            crate::operation_deser::parse_get_findings_response(response)
        }
    }
}

/// Operation shape for `GetInsightResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_insight_results`](crate::client::Client::get_insight_results).
///
/// See [`crate::client::fluent_builders::GetInsightResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInsightResults {
    _private: (),
}
impl GetInsightResults {
    /// Creates a new builder-style object to manufacture [`GetInsightResultsInput`](crate::input::GetInsightResultsInput)
    pub fn builder() -> crate::input::get_insight_results_input::Builder {
        crate::input::get_insight_results_input::Builder::default()
    }
    /// Creates a new `GetInsightResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInsightResults {
    type Output = std::result::Result<
        crate::output::GetInsightResultsOutput,
        crate::error::GetInsightResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_insight_results_error(response)
        } else {
            crate::operation_deser::parse_get_insight_results_response(response)
        }
    }
}

/// Operation shape for `GetInsights`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_insights`](crate::client::Client::get_insights).
///
/// See [`crate::client::fluent_builders::GetInsights`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInsights {
    _private: (),
}
impl GetInsights {
    /// Creates a new builder-style object to manufacture [`GetInsightsInput`](crate::input::GetInsightsInput)
    pub fn builder() -> crate::input::get_insights_input::Builder {
        crate::input::get_insights_input::Builder::default()
    }
    /// Creates a new `GetInsights` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInsights {
    type Output =
        std::result::Result<crate::output::GetInsightsOutput, crate::error::GetInsightsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_insights_error(response)
        } else {
            crate::operation_deser::parse_get_insights_response(response)
        }
    }
}

/// Operation shape for `GetInvitationsCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_invitations_count`](crate::client::Client::get_invitations_count).
///
/// See [`crate::client::fluent_builders::GetInvitationsCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInvitationsCount {
    _private: (),
}
impl GetInvitationsCount {
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
    /// Creates a new `GetInvitationsCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInvitationsCount {
    type Output = std::result::Result<
        crate::output::GetInvitationsCountOutput,
        crate::error::GetInvitationsCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_invitations_count_error(response)
        } else {
            crate::operation_deser::parse_get_invitations_count_response(response)
        }
    }
}

/// Operation shape for `GetMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_master_account`](crate::client::Client::get_master_account).
///
/// See [`crate::client::fluent_builders::GetMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMasterAccount {
    _private: (),
}
impl GetMasterAccount {
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
    /// Creates a new `GetMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMasterAccount {
    type Output = std::result::Result<
        crate::output::GetMasterAccountOutput,
        crate::error::GetMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_master_account_error(response)
        } else {
            crate::operation_deser::parse_get_master_account_response(response)
        }
    }
}

/// Operation shape for `GetMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_members`](crate::client::Client::get_members).
///
/// See [`crate::client::fluent_builders::GetMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMembers {
    _private: (),
}
impl GetMembers {
    /// Creates a new builder-style object to manufacture [`GetMembersInput`](crate::input::GetMembersInput)
    pub fn builder() -> crate::input::get_members_input::Builder {
        crate::input::get_members_input::Builder::default()
    }
    /// Creates a new `GetMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMembers {
    type Output =
        std::result::Result<crate::output::GetMembersOutput, crate::error::GetMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_members_error(response)
        } else {
            crate::operation_deser::parse_get_members_response(response)
        }
    }
}

/// Operation shape for `InviteMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invite_members`](crate::client::Client::invite_members).
///
/// See [`crate::client::fluent_builders::InviteMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InviteMembers {
    _private: (),
}
impl InviteMembers {
    /// Creates a new builder-style object to manufacture [`InviteMembersInput`](crate::input::InviteMembersInput)
    pub fn builder() -> crate::input::invite_members_input::Builder {
        crate::input::invite_members_input::Builder::default()
    }
    /// Creates a new `InviteMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InviteMembers {
    type Output =
        std::result::Result<crate::output::InviteMembersOutput, crate::error::InviteMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invite_members_error(response)
        } else {
            crate::operation_deser::parse_invite_members_response(response)
        }
    }
}

/// Operation shape for `ListEnabledProductsForImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_enabled_products_for_import`](crate::client::Client::list_enabled_products_for_import).
///
/// See [`crate::client::fluent_builders::ListEnabledProductsForImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnabledProductsForImport {
    _private: (),
}
impl ListEnabledProductsForImport {
    /// Creates a new builder-style object to manufacture [`ListEnabledProductsForImportInput`](crate::input::ListEnabledProductsForImportInput)
    pub fn builder() -> crate::input::list_enabled_products_for_import_input::Builder {
        crate::input::list_enabled_products_for_import_input::Builder::default()
    }
    /// Creates a new `ListEnabledProductsForImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnabledProductsForImport {
    type Output = std::result::Result<
        crate::output::ListEnabledProductsForImportOutput,
        crate::error::ListEnabledProductsForImportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_enabled_products_for_import_error(response)
        } else {
            crate::operation_deser::parse_list_enabled_products_for_import_response(response)
        }
    }
}

/// Operation shape for `ListInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invitations`](crate::client::Client::list_invitations).
///
/// See [`crate::client::fluent_builders::ListInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvitations {
    _private: (),
}
impl ListInvitations {
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
    /// Creates a new `ListInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvitations {
    type Output = std::result::Result<
        crate::output::ListInvitationsOutput,
        crate::error::ListInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_invitations_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationAdminAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organization_admin_accounts`](crate::client::Client::list_organization_admin_accounts).
///
/// See [`crate::client::fluent_builders::ListOrganizationAdminAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationAdminAccounts {
    _private: (),
}
impl ListOrganizationAdminAccounts {
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
    /// Creates a new `ListOrganizationAdminAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationAdminAccounts {
    type Output = std::result::Result<
        crate::output::ListOrganizationAdminAccountsOutput,
        crate::error::ListOrganizationAdminAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organization_admin_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_organization_admin_accounts_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateActionTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_action_target`](crate::client::Client::update_action_target).
///
/// See [`crate::client::fluent_builders::UpdateActionTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateActionTarget {
    _private: (),
}
impl UpdateActionTarget {
    /// Creates a new builder-style object to manufacture [`UpdateActionTargetInput`](crate::input::UpdateActionTargetInput)
    pub fn builder() -> crate::input::update_action_target_input::Builder {
        crate::input::update_action_target_input::Builder::default()
    }
    /// Creates a new `UpdateActionTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateActionTarget {
    type Output = std::result::Result<
        crate::output::UpdateActionTargetOutput,
        crate::error::UpdateActionTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_action_target_error(response)
        } else {
            crate::operation_deser::parse_update_action_target_response(response)
        }
    }
}

/// Operation shape for `UpdateFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_findings`](crate::client::Client::update_findings).
///
/// See [`crate::client::fluent_builders::UpdateFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFindings {
    _private: (),
}
impl UpdateFindings {
    /// Creates a new builder-style object to manufacture [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    pub fn builder() -> crate::input::update_findings_input::Builder {
        crate::input::update_findings_input::Builder::default()
    }
    /// Creates a new `UpdateFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFindings {
    type Output =
        std::result::Result<crate::output::UpdateFindingsOutput, crate::error::UpdateFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_findings_error(response)
        } else {
            crate::operation_deser::parse_update_findings_response(response)
        }
    }
}

/// Operation shape for `UpdateInsight`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_insight`](crate::client::Client::update_insight).
///
/// See [`crate::client::fluent_builders::UpdateInsight`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInsight {
    _private: (),
}
impl UpdateInsight {
    /// Creates a new builder-style object to manufacture [`UpdateInsightInput`](crate::input::UpdateInsightInput)
    pub fn builder() -> crate::input::update_insight_input::Builder {
        crate::input::update_insight_input::Builder::default()
    }
    /// Creates a new `UpdateInsight` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInsight {
    type Output =
        std::result::Result<crate::output::UpdateInsightOutput, crate::error::UpdateInsightError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_insight_error(response)
        } else {
            crate::operation_deser::parse_update_insight_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organization_configuration`](crate::client::Client::update_organization_configuration).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationConfiguration {
    _private: (),
}
impl UpdateOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationConfigurationOutput,
        crate::error::UpdateOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateSecurityHubConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_security_hub_configuration`](crate::client::Client::update_security_hub_configuration).
///
/// See [`crate::client::fluent_builders::UpdateSecurityHubConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSecurityHubConfiguration {
    _private: (),
}
impl UpdateSecurityHubConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateSecurityHubConfigurationInput`](crate::input::UpdateSecurityHubConfigurationInput)
    pub fn builder() -> crate::input::update_security_hub_configuration_input::Builder {
        crate::input::update_security_hub_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateSecurityHubConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSecurityHubConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateSecurityHubConfigurationOutput,
        crate::error::UpdateSecurityHubConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_security_hub_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_security_hub_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateStandardsControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_standards_control`](crate::client::Client::update_standards_control).
///
/// See [`crate::client::fluent_builders::UpdateStandardsControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStandardsControl {
    _private: (),
}
impl UpdateStandardsControl {
    /// Creates a new builder-style object to manufacture [`UpdateStandardsControlInput`](crate::input::UpdateStandardsControlInput)
    pub fn builder() -> crate::input::update_standards_control_input::Builder {
        crate::input::update_standards_control_input::Builder::default()
    }
    /// Creates a new `UpdateStandardsControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStandardsControl {
    type Output = std::result::Result<
        crate::output::UpdateStandardsControlOutput,
        crate::error::UpdateStandardsControlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_standards_control_error(response)
        } else {
            crate::operation_deser::parse_update_standards_control_response(response)
        }
    }
}
