// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ControlStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ControlStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ControlStatus::Disabled,
            "ENABLED" => ControlStatus::Enabled,
            other => ControlStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ControlStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ControlStatus::from(s))
    }
}
impl ControlStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ControlStatus::Disabled => "DISABLED",
            ControlStatus::Enabled => "ENABLED",
            ControlStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ControlStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A collection of attributes that are applied to all active Security Hub-aggregated findings and
/// that result in a subset of findings that are included in this insight.</p>
/// <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to
/// 20 filter values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsSecurityFindingFilters {
    /// <p>The ARN generated by Security Hub that uniquely identifies a third-party company
    /// (security findings provider) after this provider's product (solution that generates
    /// findings) is registered with Security Hub.</p>
    pub product_arn: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
    pub aws_account_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The security findings provider-specific identifier for a finding.</p>
    pub id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
    /// generated a finding. In various security-findings providers' solutions, this generator can
    /// be called a rule, a check, a detector, a plugin, etc.</p>
    pub generator_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Region from which the finding was generated.</p>
    pub region: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A finding type in the format of <code>namespace/category/classifier</code> that
    /// classifies a finding.</p>
    pub r#type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider first
    /// observed the potential security issue that a finding captured.</p>
    pub first_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider most
    /// recently observed the potential security issue that a finding captured.</p>
    pub last_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider
    /// captured the potential security issue that a finding captured.</p>
    pub created_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider last
    /// updated the finding record. </p>
    pub updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The native severity as defined by the security-findings provider's solution that
    /// generated the finding.</p>
    pub severity_product: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The normalized severity of a finding.</p>
    pub severity_normalized: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The label of a finding's severity.</p>
    pub severity_label: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
    /// accurately identifies the behavior or issue that it was intended to identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub confidence: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The level of importance assigned to the resources associated with the finding.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources.</p>
    pub criticality: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>A finding's title.</p>
    pub title: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A finding's description.</p>
    pub description: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The recommendation of what to do about the issue described in a finding.</p>
    pub recommendation_text: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A URL that links to a page about the current finding in the security-findings provider's
    /// solution.</p>
    pub source_url: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A data type where security-findings providers can include additional solution-specific
    /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
    pub product_fields: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>The name of the solution (product) that generates findings.</p>
    /// <p>Note that this is a filter against the <code>aws/securityhub/ProductName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>ProductName</code> field.</p>
    pub product_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The name of the findings provider (company) that owns the solution (product) that
    /// generates findings.</p>
    /// <p>Note that this is a filter against the <code>aws/securityhub/CompanyName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>CompanyName</code> field.</p>
    pub company_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A list of name/value string pairs associated with the finding. These are custom,
    /// user-defined fields added to a finding. </p>
    pub user_defined_fields: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>The name of the malware that was observed.</p>
    pub malware_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The type of the malware that was observed.</p>
    pub malware_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The filesystem path of the malware that was observed.</p>
    pub malware_path: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The state of the malware that was observed.</p>
    pub malware_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Indicates the direction of network traffic associated with a finding.</p>
    pub network_direction: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The protocol of network-related information about a finding.</p>
    pub network_protocol: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The source IPv4 address of network-related information about a finding.</p>
    pub network_source_ip_v4: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The source IPv6 address of network-related information about a finding.</p>
    pub network_source_ip_v6: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The source port of network-related information about a finding.</p>
    pub network_source_port: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The source domain of network-related information about a finding.</p>
    pub network_source_domain: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The source media access control (MAC) address of network-related information about a
    /// finding.</p>
    pub network_source_mac: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The destination IPv4 address of network-related information about a finding.</p>
    pub network_destination_ip_v4: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The destination IPv6 address of network-related information about a finding.</p>
    pub network_destination_ip_v6: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The destination port of network-related information about a finding.</p>
    pub network_destination_port: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The destination domain of network-related information about a finding.</p>
    pub network_destination_domain: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The name of the process.</p>
    pub process_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The path to the process executable.</p>
    pub process_path: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The process ID.</p>
    pub process_pid: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The parent process ID.</p>
    pub process_parent_pid: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The date/time that the process was launched.</p>
    pub process_launched_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The date/time that the process was terminated.</p>
    pub process_terminated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The type of a threat intelligence indicator.</p>
    pub threat_intel_indicator_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The value of a threat intelligence indicator.</p>
    pub threat_intel_indicator_value:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The category of a threat intelligence indicator.</p>
    pub threat_intel_indicator_category:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The date/time of the last observation of a threat intelligence indicator.</p>
    pub threat_intel_indicator_last_observed_at:
        std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The source of the threat intelligence.</p>
    pub threat_intel_indicator_source:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The URL for more details from the source of the threat intelligence.</p>
    pub threat_intel_indicator_source_url:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Specifies the type of the resource that details are provided for.</p>
    pub resource_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The canonical identifier for the given resource type.</p>
    pub resource_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
    pub resource_partition: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
    pub resource_region: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
    /// processed.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>The instance type of the instance.</p>
    pub resource_aws_ec2_instance_type:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Amazon Machine Image (AMI) ID of the instance.</p>
    pub resource_aws_ec2_instance_image_id:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The IPv4 addresses associated with the instance.</p>
    pub resource_aws_ec2_instance_ip_v4_addresses:
        std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The IPv6 addresses associated with the instance.</p>
    pub resource_aws_ec2_instance_ip_v6_addresses:
        std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
    /// <p>The key name associated with the instance.</p>
    pub resource_aws_ec2_instance_key_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The IAM profile ARN of the instance.</p>
    pub resource_aws_ec2_instance_iam_instance_profile_arn:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The identifier of the VPC that the instance was launched in.</p>
    pub resource_aws_ec2_instance_vpc_id:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The identifier of the subnet that the instance was launched in.</p>
    pub resource_aws_ec2_instance_subnet_id:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The date and time the instance was launched.</p>
    pub resource_aws_ec2_instance_launched_at:
        std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The canonical user ID of the owner of the S3 bucket.</p>
    pub resource_aws_s3_bucket_owner_id:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The display name of the owner of the S3 bucket.</p>
    pub resource_aws_s3_bucket_owner_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The user associated with the IAM access key related to a finding.</p>
    pub resource_aws_iam_access_key_user_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The name of the principal that is associated with an IAM access key.</p>
    pub resource_aws_iam_access_key_principal_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The status of the IAM access key related to a finding.</p>
    pub resource_aws_iam_access_key_status:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The creation date/time of the IAM access key related to a finding.</p>
    pub resource_aws_iam_access_key_created_at:
        std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The name of an IAM user.</p>
    pub resource_aws_iam_user_user_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The name of the container related to a finding.</p>
    pub resource_container_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The identifier of the image related to a finding.</p>
    pub resource_container_image_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The name of the image related to a finding.</p>
    pub resource_container_image_name:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The date/time that the container was started.</p>
    pub resource_container_launched_at:
        std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The details of a resource that doesn't have a specific subfield for the resource type
    /// defined.</p>
    pub resource_details_other: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>Exclusive to findings that are generated as the result of a check run against a specific
    /// rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security
    /// standard-related finding details.</p>
    pub compliance_status: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The veracity of a finding.</p>
    pub verification_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The workflow state of a finding.</p>
    /// <p>Note that this field is deprecated. To search for a finding based on its workflow
    /// status, use <code>WorkflowStatus</code>.</p>
    pub workflow_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The status of the investigation into a finding. Allowed values are the following.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
    /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
    /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
    /// <ul>
    /// <li>
    /// <p>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p>
    /// </li>
    /// <li>
    /// <p>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code>,
    /// <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOTIFIED</code> - Indicates that the resource owner has been notified about
    /// the security issue. Used when the initial reviewer is not the resource owner, and
    /// needs intervention from the resource owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
    /// acted upon.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
    /// considered resolved. </p>
    /// </li>
    /// </ul>
    pub workflow_status: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The updated record state for the finding.</p>
    pub record_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The ARN of the solution that generated a related finding.</p>
    pub related_findings_product_arn:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The solution-generated identifier for a related finding.</p>
    pub related_findings_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The text of a note.</p>
    pub note_text: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The timestamp of when the note was updated.</p>
    pub note_updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>The principal that created a note.</p>
    pub note_updated_by: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>A keyword for a finding.</p>
    pub keyword: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
    /// <p>The finding provider value for the finding confidence. Confidence is defined as the likelihood
    /// that a finding accurately identifies the behavior or issue that it was intended to
    /// identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub finding_provider_fields_confidence:
        std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The finding provider value for the level of importance assigned to the resources associated with
    /// the findings.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources. </p>
    pub finding_provider_fields_criticality:
        std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>The finding identifier of a related finding that is identified by the finding provider.</p>
    pub finding_provider_fields_related_findings_id:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The ARN of the solution that generated a related finding that is identified by the finding provider.</p>
    pub finding_provider_fields_related_findings_product_arn:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The finding provider value for the severity label.</p>
    pub finding_provider_fields_severity_label:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The finding provider's original value for the severity.</p>
    pub finding_provider_fields_severity_original:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>One or more finding types that the finding provider assigned to the finding. Uses the format of <code>namespace/category/classifier</code>
    /// that classify a finding.</p>
    /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
    /// Behaviors | Sensitive Data Identifications</p>
    pub finding_provider_fields_types:
        std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
}
impl std::fmt::Debug for AwsSecurityFindingFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsSecurityFindingFilters");
        formatter.field("product_arn", &self.product_arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("id", &self.id);
        formatter.field("generator_id", &self.generator_id);
        formatter.field("region", &self.region);
        formatter.field("r#type", &self.r#type);
        formatter.field("first_observed_at", &self.first_observed_at);
        formatter.field("last_observed_at", &self.last_observed_at);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("severity_product", &self.severity_product);
        formatter.field("severity_normalized", &self.severity_normalized);
        formatter.field("severity_label", &self.severity_label);
        formatter.field("confidence", &self.confidence);
        formatter.field("criticality", &self.criticality);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("recommendation_text", &self.recommendation_text);
        formatter.field("source_url", &self.source_url);
        formatter.field("product_fields", &self.product_fields);
        formatter.field("product_name", &self.product_name);
        formatter.field("company_name", &self.company_name);
        formatter.field("user_defined_fields", &self.user_defined_fields);
        formatter.field("malware_name", &self.malware_name);
        formatter.field("malware_type", &self.malware_type);
        formatter.field("malware_path", &self.malware_path);
        formatter.field("malware_state", &self.malware_state);
        formatter.field("network_direction", &self.network_direction);
        formatter.field("network_protocol", &self.network_protocol);
        formatter.field("network_source_ip_v4", &self.network_source_ip_v4);
        formatter.field("network_source_ip_v6", &self.network_source_ip_v6);
        formatter.field("network_source_port", &self.network_source_port);
        formatter.field("network_source_domain", &self.network_source_domain);
        formatter.field("network_source_mac", &self.network_source_mac);
        formatter.field("network_destination_ip_v4", &self.network_destination_ip_v4);
        formatter.field("network_destination_ip_v6", &self.network_destination_ip_v6);
        formatter.field("network_destination_port", &self.network_destination_port);
        formatter.field(
            "network_destination_domain",
            &self.network_destination_domain,
        );
        formatter.field("process_name", &self.process_name);
        formatter.field("process_path", &self.process_path);
        formatter.field("process_pid", &self.process_pid);
        formatter.field("process_parent_pid", &self.process_parent_pid);
        formatter.field("process_launched_at", &self.process_launched_at);
        formatter.field("process_terminated_at", &self.process_terminated_at);
        formatter.field(
            "threat_intel_indicator_type",
            &self.threat_intel_indicator_type,
        );
        formatter.field(
            "threat_intel_indicator_value",
            &self.threat_intel_indicator_value,
        );
        formatter.field(
            "threat_intel_indicator_category",
            &self.threat_intel_indicator_category,
        );
        formatter.field(
            "threat_intel_indicator_last_observed_at",
            &self.threat_intel_indicator_last_observed_at,
        );
        formatter.field(
            "threat_intel_indicator_source",
            &self.threat_intel_indicator_source,
        );
        formatter.field(
            "threat_intel_indicator_source_url",
            &self.threat_intel_indicator_source_url,
        );
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_partition", &self.resource_partition);
        formatter.field("resource_region", &self.resource_region);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field(
            "resource_aws_ec2_instance_type",
            &self.resource_aws_ec2_instance_type,
        );
        formatter.field(
            "resource_aws_ec2_instance_image_id",
            &self.resource_aws_ec2_instance_image_id,
        );
        formatter.field(
            "resource_aws_ec2_instance_ip_v4_addresses",
            &self.resource_aws_ec2_instance_ip_v4_addresses,
        );
        formatter.field(
            "resource_aws_ec2_instance_ip_v6_addresses",
            &self.resource_aws_ec2_instance_ip_v6_addresses,
        );
        formatter.field(
            "resource_aws_ec2_instance_key_name",
            &self.resource_aws_ec2_instance_key_name,
        );
        formatter.field(
            "resource_aws_ec2_instance_iam_instance_profile_arn",
            &self.resource_aws_ec2_instance_iam_instance_profile_arn,
        );
        formatter.field(
            "resource_aws_ec2_instance_vpc_id",
            &self.resource_aws_ec2_instance_vpc_id,
        );
        formatter.field(
            "resource_aws_ec2_instance_subnet_id",
            &self.resource_aws_ec2_instance_subnet_id,
        );
        formatter.field(
            "resource_aws_ec2_instance_launched_at",
            &self.resource_aws_ec2_instance_launched_at,
        );
        formatter.field(
            "resource_aws_s3_bucket_owner_id",
            &self.resource_aws_s3_bucket_owner_id,
        );
        formatter.field(
            "resource_aws_s3_bucket_owner_name",
            &self.resource_aws_s3_bucket_owner_name,
        );
        formatter.field(
            "resource_aws_iam_access_key_user_name",
            &self.resource_aws_iam_access_key_user_name,
        );
        formatter.field(
            "resource_aws_iam_access_key_principal_name",
            &self.resource_aws_iam_access_key_principal_name,
        );
        formatter.field(
            "resource_aws_iam_access_key_status",
            &self.resource_aws_iam_access_key_status,
        );
        formatter.field(
            "resource_aws_iam_access_key_created_at",
            &self.resource_aws_iam_access_key_created_at,
        );
        formatter.field(
            "resource_aws_iam_user_user_name",
            &self.resource_aws_iam_user_user_name,
        );
        formatter.field("resource_container_name", &self.resource_container_name);
        formatter.field(
            "resource_container_image_id",
            &self.resource_container_image_id,
        );
        formatter.field(
            "resource_container_image_name",
            &self.resource_container_image_name,
        );
        formatter.field(
            "resource_container_launched_at",
            &self.resource_container_launched_at,
        );
        formatter.field("resource_details_other", &self.resource_details_other);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("verification_state", &self.verification_state);
        formatter.field("workflow_state", &self.workflow_state);
        formatter.field("workflow_status", &self.workflow_status);
        formatter.field("record_state", &self.record_state);
        formatter.field(
            "related_findings_product_arn",
            &self.related_findings_product_arn,
        );
        formatter.field("related_findings_id", &self.related_findings_id);
        formatter.field("note_text", &self.note_text);
        formatter.field("note_updated_at", &self.note_updated_at);
        formatter.field("note_updated_by", &self.note_updated_by);
        formatter.field("keyword", &self.keyword);
        formatter.field(
            "finding_provider_fields_confidence",
            &self.finding_provider_fields_confidence,
        );
        formatter.field(
            "finding_provider_fields_criticality",
            &self.finding_provider_fields_criticality,
        );
        formatter.field(
            "finding_provider_fields_related_findings_id",
            &self.finding_provider_fields_related_findings_id,
        );
        formatter.field(
            "finding_provider_fields_related_findings_product_arn",
            &self.finding_provider_fields_related_findings_product_arn,
        );
        formatter.field(
            "finding_provider_fields_severity_label",
            &self.finding_provider_fields_severity_label,
        );
        formatter.field(
            "finding_provider_fields_severity_original",
            &self.finding_provider_fields_severity_original,
        );
        formatter.field(
            "finding_provider_fields_types",
            &self.finding_provider_fields_types,
        );
        formatter.finish()
    }
}
/// See [`AwsSecurityFindingFilters`](crate::model::AwsSecurityFindingFilters)
pub mod aws_security_finding_filters {
    /// A builder for [`AwsSecurityFindingFilters`](crate::model::AwsSecurityFindingFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_arn: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) aws_account_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) generator_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) region: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) r#type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) first_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) last_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) created_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) severity_product: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) severity_normalized:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) severity_label: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) confidence: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) criticality: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) title: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) description: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) recommendation_text:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) source_url: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) product_fields: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) product_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) company_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) user_defined_fields: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) malware_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) malware_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) malware_path: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) malware_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) network_direction:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) network_protocol: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) network_source_ip_v4: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) network_source_ip_v6: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) network_source_port:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) network_source_domain:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) network_source_mac:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) network_destination_ip_v4:
            std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) network_destination_ip_v6:
            std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) network_destination_port:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) network_destination_domain:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) process_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) process_path: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) process_pid: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) process_parent_pid:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) process_launched_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) process_terminated_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) threat_intel_indicator_type:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) threat_intel_indicator_value:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) threat_intel_indicator_category:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) threat_intel_indicator_last_observed_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) threat_intel_indicator_source:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) threat_intel_indicator_source_url:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_partition:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_region: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) resource_aws_ec2_instance_type:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_image_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_ip_v4_addresses:
            std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) resource_aws_ec2_instance_ip_v6_addresses:
            std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        pub(crate) resource_aws_ec2_instance_key_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_iam_instance_profile_arn:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_vpc_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_subnet_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_ec2_instance_launched_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) resource_aws_s3_bucket_owner_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_s3_bucket_owner_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_iam_access_key_user_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_iam_access_key_principal_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_iam_access_key_status:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_aws_iam_access_key_created_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) resource_aws_iam_user_user_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_container_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_container_image_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_container_image_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_container_launched_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) resource_details_other:
            std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) compliance_status:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) verification_state:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) workflow_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) workflow_status: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) record_state: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) related_findings_product_arn:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) related_findings_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) note_text: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) note_updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) note_updated_by: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) keyword: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
        pub(crate) finding_provider_fields_confidence:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) finding_provider_fields_criticality:
            std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) finding_provider_fields_related_findings_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) finding_provider_fields_related_findings_product_arn:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) finding_provider_fields_severity_label:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) finding_provider_fields_severity_original:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) finding_provider_fields_types:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    }
    impl Builder {
        /// Appends an item to `product_arn`.
        ///
        /// To override the contents of this collection use [`set_product_arn`](Self::set_product_arn).
        ///
        /// <p>The ARN generated by Security Hub that uniquely identifies a third-party company
        /// (security findings provider) after this provider's product (solution that generates
        /// findings) is registered with Security Hub.</p>
        pub fn product_arn(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.product_arn.unwrap_or_default();
            v.push(input.into());
            self.product_arn = Some(v);
            self
        }
        /// <p>The ARN generated by Security Hub that uniquely identifies a third-party company
        /// (security findings provider) after this provider's product (solution that generates
        /// findings) is registered with Security Hub.</p>
        pub fn set_product_arn(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.product_arn = input;
            self
        }
        /// Appends an item to `aws_account_id`.
        ///
        /// To override the contents of this collection use [`set_aws_account_id`](Self::set_aws_account_id).
        ///
        /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
        pub fn aws_account_id(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.aws_account_id.unwrap_or_default();
            v.push(input.into());
            self.aws_account_id = Some(v);
            self
        }
        /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `id`.
        ///
        /// To override the contents of this collection use [`set_id`](Self::set_id).
        ///
        /// <p>The security findings provider-specific identifier for a finding.</p>
        pub fn id(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.id.unwrap_or_default();
            v.push(input.into());
            self.id = Some(v);
            self
        }
        /// <p>The security findings provider-specific identifier for a finding.</p>
        pub fn set_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `generator_id`.
        ///
        /// To override the contents of this collection use [`set_generator_id`](Self::set_generator_id).
        ///
        /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
        /// generated a finding. In various security-findings providers' solutions, this generator can
        /// be called a rule, a check, a detector, a plugin, etc.</p>
        pub fn generator_id(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.generator_id.unwrap_or_default();
            v.push(input.into());
            self.generator_id = Some(v);
            self
        }
        /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
        /// generated a finding. In various security-findings providers' solutions, this generator can
        /// be called a rule, a check, a detector, a plugin, etc.</p>
        pub fn set_generator_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.generator_id = input;
            self
        }
        /// Appends an item to `region`.
        ///
        /// To override the contents of this collection use [`set_region`](Self::set_region).
        ///
        /// <p>The Region from which the finding was generated.</p>
        pub fn region(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.region.unwrap_or_default();
            v.push(input.into());
            self.region = Some(v);
            self
        }
        /// <p>The Region from which the finding was generated.</p>
        pub fn set_region(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `r#type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>A finding type in the format of <code>namespace/category/classifier</code> that
        /// classifies a finding.</p>
        pub fn r#type(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.r#type.unwrap_or_default();
            v.push(input.into());
            self.r#type = Some(v);
            self
        }
        /// <p>A finding type in the format of <code>namespace/category/classifier</code> that
        /// classifies a finding.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `first_observed_at`.
        ///
        /// To override the contents of this collection use [`set_first_observed_at`](Self::set_first_observed_at).
        ///
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider first
        /// observed the potential security issue that a finding captured.</p>
        pub fn first_observed_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.first_observed_at.unwrap_or_default();
            v.push(input.into());
            self.first_observed_at = Some(v);
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider first
        /// observed the potential security issue that a finding captured.</p>
        pub fn set_first_observed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.first_observed_at = input;
            self
        }
        /// Appends an item to `last_observed_at`.
        ///
        /// To override the contents of this collection use [`set_last_observed_at`](Self::set_last_observed_at).
        ///
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider most
        /// recently observed the potential security issue that a finding captured.</p>
        pub fn last_observed_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.last_observed_at.unwrap_or_default();
            v.push(input.into());
            self.last_observed_at = Some(v);
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider most
        /// recently observed the potential security issue that a finding captured.</p>
        pub fn set_last_observed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.last_observed_at = input;
            self
        }
        /// Appends an item to `created_at`.
        ///
        /// To override the contents of this collection use [`set_created_at`](Self::set_created_at).
        ///
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider
        /// captured the potential security issue that a finding captured.</p>
        pub fn created_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.created_at.unwrap_or_default();
            v.push(input.into());
            self.created_at = Some(v);
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider
        /// captured the potential security issue that a finding captured.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `updated_at`.
        ///
        /// To override the contents of this collection use [`set_updated_at`](Self::set_updated_at).
        ///
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider last
        /// updated the finding record. </p>
        pub fn updated_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.updated_at.unwrap_or_default();
            v.push(input.into());
            self.updated_at = Some(v);
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the security-findings provider last
        /// updated the finding record. </p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `severity_product`.
        ///
        /// To override the contents of this collection use [`set_severity_product`](Self::set_severity_product).
        ///
        /// <p>The native severity as defined by the security-findings provider's solution that
        /// generated the finding.</p>
        pub fn severity_product(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.severity_product.unwrap_or_default();
            v.push(input.into());
            self.severity_product = Some(v);
            self
        }
        /// <p>The native severity as defined by the security-findings provider's solution that
        /// generated the finding.</p>
        pub fn set_severity_product(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.severity_product = input;
            self
        }
        /// Appends an item to `severity_normalized`.
        ///
        /// To override the contents of this collection use [`set_severity_normalized`](Self::set_severity_normalized).
        ///
        /// <p>The normalized severity of a finding.</p>
        pub fn severity_normalized(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.severity_normalized.unwrap_or_default();
            v.push(input.into());
            self.severity_normalized = Some(v);
            self
        }
        /// <p>The normalized severity of a finding.</p>
        pub fn set_severity_normalized(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.severity_normalized = input;
            self
        }
        /// Appends an item to `severity_label`.
        ///
        /// To override the contents of this collection use [`set_severity_label`](Self::set_severity_label).
        ///
        /// <p>The label of a finding's severity.</p>
        pub fn severity_label(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.severity_label.unwrap_or_default();
            v.push(input.into());
            self.severity_label = Some(v);
            self
        }
        /// <p>The label of a finding's severity.</p>
        pub fn set_severity_label(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.severity_label = input;
            self
        }
        /// Appends an item to `confidence`.
        ///
        /// To override the contents of this collection use [`set_confidence`](Self::set_confidence).
        ///
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn confidence(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.confidence.unwrap_or_default();
            v.push(input.into());
            self.confidence = Some(v);
            self
        }
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn set_confidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.confidence = input;
            self
        }
        /// Appends an item to `criticality`.
        ///
        /// To override the contents of this collection use [`set_criticality`](Self::set_criticality).
        ///
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn criticality(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.criticality.unwrap_or_default();
            v.push(input.into());
            self.criticality = Some(v);
            self
        }
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn set_criticality(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.criticality = input;
            self
        }
        /// Appends an item to `title`.
        ///
        /// To override the contents of this collection use [`set_title`](Self::set_title).
        ///
        /// <p>A finding's title.</p>
        pub fn title(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.title.unwrap_or_default();
            v.push(input.into());
            self.title = Some(v);
            self
        }
        /// <p>A finding's title.</p>
        pub fn set_title(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.title = input;
            self
        }
        /// Appends an item to `description`.
        ///
        /// To override the contents of this collection use [`set_description`](Self::set_description).
        ///
        /// <p>A finding's description.</p>
        pub fn description(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.description.unwrap_or_default();
            v.push(input.into());
            self.description = Some(v);
            self
        }
        /// <p>A finding's description.</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `recommendation_text`.
        ///
        /// To override the contents of this collection use [`set_recommendation_text`](Self::set_recommendation_text).
        ///
        /// <p>The recommendation of what to do about the issue described in a finding.</p>
        pub fn recommendation_text(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.recommendation_text.unwrap_or_default();
            v.push(input.into());
            self.recommendation_text = Some(v);
            self
        }
        /// <p>The recommendation of what to do about the issue described in a finding.</p>
        pub fn set_recommendation_text(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.recommendation_text = input;
            self
        }
        /// Appends an item to `source_url`.
        ///
        /// To override the contents of this collection use [`set_source_url`](Self::set_source_url).
        ///
        /// <p>A URL that links to a page about the current finding in the security-findings provider's
        /// solution.</p>
        pub fn source_url(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.source_url.unwrap_or_default();
            v.push(input.into());
            self.source_url = Some(v);
            self
        }
        /// <p>A URL that links to a page about the current finding in the security-findings provider's
        /// solution.</p>
        pub fn set_source_url(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.source_url = input;
            self
        }
        /// Appends an item to `product_fields`.
        ///
        /// To override the contents of this collection use [`set_product_fields`](Self::set_product_fields).
        ///
        /// <p>A data type where security-findings providers can include additional solution-specific
        /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
        pub fn product_fields(mut self, input: impl Into<crate::model::MapFilter>) -> Self {
            let mut v = self.product_fields.unwrap_or_default();
            v.push(input.into());
            self.product_fields = Some(v);
            self
        }
        /// <p>A data type where security-findings providers can include additional solution-specific
        /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
        pub fn set_product_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.product_fields = input;
            self
        }
        /// Appends an item to `product_name`.
        ///
        /// To override the contents of this collection use [`set_product_name`](Self::set_product_name).
        ///
        /// <p>The name of the solution (product) that generates findings.</p>
        /// <p>Note that this is a filter against the <code>aws/securityhub/ProductName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>ProductName</code> field.</p>
        pub fn product_name(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.product_name.unwrap_or_default();
            v.push(input.into());
            self.product_name = Some(v);
            self
        }
        /// <p>The name of the solution (product) that generates findings.</p>
        /// <p>Note that this is a filter against the <code>aws/securityhub/ProductName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>ProductName</code> field.</p>
        pub fn set_product_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.product_name = input;
            self
        }
        /// Appends an item to `company_name`.
        ///
        /// To override the contents of this collection use [`set_company_name`](Self::set_company_name).
        ///
        /// <p>The name of the findings provider (company) that owns the solution (product) that
        /// generates findings.</p>
        /// <p>Note that this is a filter against the <code>aws/securityhub/CompanyName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>CompanyName</code> field.</p>
        pub fn company_name(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.company_name.unwrap_or_default();
            v.push(input.into());
            self.company_name = Some(v);
            self
        }
        /// <p>The name of the findings provider (company) that owns the solution (product) that
        /// generates findings.</p>
        /// <p>Note that this is a filter against the <code>aws/securityhub/CompanyName</code> field in <code>ProductFields</code>. It is not a filter for the top-level <code>CompanyName</code> field.</p>
        pub fn set_company_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.company_name = input;
            self
        }
        /// Appends an item to `user_defined_fields`.
        ///
        /// To override the contents of this collection use [`set_user_defined_fields`](Self::set_user_defined_fields).
        ///
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding. </p>
        pub fn user_defined_fields(mut self, input: impl Into<crate::model::MapFilter>) -> Self {
            let mut v = self.user_defined_fields.unwrap_or_default();
            v.push(input.into());
            self.user_defined_fields = Some(v);
            self
        }
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding. </p>
        pub fn set_user_defined_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.user_defined_fields = input;
            self
        }
        /// Appends an item to `malware_name`.
        ///
        /// To override the contents of this collection use [`set_malware_name`](Self::set_malware_name).
        ///
        /// <p>The name of the malware that was observed.</p>
        pub fn malware_name(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.malware_name.unwrap_or_default();
            v.push(input.into());
            self.malware_name = Some(v);
            self
        }
        /// <p>The name of the malware that was observed.</p>
        pub fn set_malware_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.malware_name = input;
            self
        }
        /// Appends an item to `malware_type`.
        ///
        /// To override the contents of this collection use [`set_malware_type`](Self::set_malware_type).
        ///
        /// <p>The type of the malware that was observed.</p>
        pub fn malware_type(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.malware_type.unwrap_or_default();
            v.push(input.into());
            self.malware_type = Some(v);
            self
        }
        /// <p>The type of the malware that was observed.</p>
        pub fn set_malware_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.malware_type = input;
            self
        }
        /// Appends an item to `malware_path`.
        ///
        /// To override the contents of this collection use [`set_malware_path`](Self::set_malware_path).
        ///
        /// <p>The filesystem path of the malware that was observed.</p>
        pub fn malware_path(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.malware_path.unwrap_or_default();
            v.push(input.into());
            self.malware_path = Some(v);
            self
        }
        /// <p>The filesystem path of the malware that was observed.</p>
        pub fn set_malware_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.malware_path = input;
            self
        }
        /// Appends an item to `malware_state`.
        ///
        /// To override the contents of this collection use [`set_malware_state`](Self::set_malware_state).
        ///
        /// <p>The state of the malware that was observed.</p>
        pub fn malware_state(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.malware_state.unwrap_or_default();
            v.push(input.into());
            self.malware_state = Some(v);
            self
        }
        /// <p>The state of the malware that was observed.</p>
        pub fn set_malware_state(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.malware_state = input;
            self
        }
        /// Appends an item to `network_direction`.
        ///
        /// To override the contents of this collection use [`set_network_direction`](Self::set_network_direction).
        ///
        /// <p>Indicates the direction of network traffic associated with a finding.</p>
        pub fn network_direction(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.network_direction.unwrap_or_default();
            v.push(input.into());
            self.network_direction = Some(v);
            self
        }
        /// <p>Indicates the direction of network traffic associated with a finding.</p>
        pub fn set_network_direction(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_direction = input;
            self
        }
        /// Appends an item to `network_protocol`.
        ///
        /// To override the contents of this collection use [`set_network_protocol`](Self::set_network_protocol).
        ///
        /// <p>The protocol of network-related information about a finding.</p>
        pub fn network_protocol(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.network_protocol.unwrap_or_default();
            v.push(input.into());
            self.network_protocol = Some(v);
            self
        }
        /// <p>The protocol of network-related information about a finding.</p>
        pub fn set_network_protocol(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_protocol = input;
            self
        }
        /// Appends an item to `network_source_ip_v4`.
        ///
        /// To override the contents of this collection use [`set_network_source_ip_v4`](Self::set_network_source_ip_v4).
        ///
        /// <p>The source IPv4 address of network-related information about a finding.</p>
        pub fn network_source_ip_v4(mut self, input: impl Into<crate::model::IpFilter>) -> Self {
            let mut v = self.network_source_ip_v4.unwrap_or_default();
            v.push(input.into());
            self.network_source_ip_v4 = Some(v);
            self
        }
        /// <p>The source IPv4 address of network-related information about a finding.</p>
        pub fn set_network_source_ip_v4(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.network_source_ip_v4 = input;
            self
        }
        /// Appends an item to `network_source_ip_v6`.
        ///
        /// To override the contents of this collection use [`set_network_source_ip_v6`](Self::set_network_source_ip_v6).
        ///
        /// <p>The source IPv6 address of network-related information about a finding.</p>
        pub fn network_source_ip_v6(mut self, input: impl Into<crate::model::IpFilter>) -> Self {
            let mut v = self.network_source_ip_v6.unwrap_or_default();
            v.push(input.into());
            self.network_source_ip_v6 = Some(v);
            self
        }
        /// <p>The source IPv6 address of network-related information about a finding.</p>
        pub fn set_network_source_ip_v6(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.network_source_ip_v6 = input;
            self
        }
        /// Appends an item to `network_source_port`.
        ///
        /// To override the contents of this collection use [`set_network_source_port`](Self::set_network_source_port).
        ///
        /// <p>The source port of network-related information about a finding.</p>
        pub fn network_source_port(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.network_source_port.unwrap_or_default();
            v.push(input.into());
            self.network_source_port = Some(v);
            self
        }
        /// <p>The source port of network-related information about a finding.</p>
        pub fn set_network_source_port(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.network_source_port = input;
            self
        }
        /// Appends an item to `network_source_domain`.
        ///
        /// To override the contents of this collection use [`set_network_source_domain`](Self::set_network_source_domain).
        ///
        /// <p>The source domain of network-related information about a finding.</p>
        pub fn network_source_domain(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.network_source_domain.unwrap_or_default();
            v.push(input.into());
            self.network_source_domain = Some(v);
            self
        }
        /// <p>The source domain of network-related information about a finding.</p>
        pub fn set_network_source_domain(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_source_domain = input;
            self
        }
        /// Appends an item to `network_source_mac`.
        ///
        /// To override the contents of this collection use [`set_network_source_mac`](Self::set_network_source_mac).
        ///
        /// <p>The source media access control (MAC) address of network-related information about a
        /// finding.</p>
        pub fn network_source_mac(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.network_source_mac.unwrap_or_default();
            v.push(input.into());
            self.network_source_mac = Some(v);
            self
        }
        /// <p>The source media access control (MAC) address of network-related information about a
        /// finding.</p>
        pub fn set_network_source_mac(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_source_mac = input;
            self
        }
        /// Appends an item to `network_destination_ip_v4`.
        ///
        /// To override the contents of this collection use [`set_network_destination_ip_v4`](Self::set_network_destination_ip_v4).
        ///
        /// <p>The destination IPv4 address of network-related information about a finding.</p>
        pub fn network_destination_ip_v4(
            mut self,
            input: impl Into<crate::model::IpFilter>,
        ) -> Self {
            let mut v = self.network_destination_ip_v4.unwrap_or_default();
            v.push(input.into());
            self.network_destination_ip_v4 = Some(v);
            self
        }
        /// <p>The destination IPv4 address of network-related information about a finding.</p>
        pub fn set_network_destination_ip_v4(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.network_destination_ip_v4 = input;
            self
        }
        /// Appends an item to `network_destination_ip_v6`.
        ///
        /// To override the contents of this collection use [`set_network_destination_ip_v6`](Self::set_network_destination_ip_v6).
        ///
        /// <p>The destination IPv6 address of network-related information about a finding.</p>
        pub fn network_destination_ip_v6(
            mut self,
            input: impl Into<crate::model::IpFilter>,
        ) -> Self {
            let mut v = self.network_destination_ip_v6.unwrap_or_default();
            v.push(input.into());
            self.network_destination_ip_v6 = Some(v);
            self
        }
        /// <p>The destination IPv6 address of network-related information about a finding.</p>
        pub fn set_network_destination_ip_v6(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.network_destination_ip_v6 = input;
            self
        }
        /// Appends an item to `network_destination_port`.
        ///
        /// To override the contents of this collection use [`set_network_destination_port`](Self::set_network_destination_port).
        ///
        /// <p>The destination port of network-related information about a finding.</p>
        pub fn network_destination_port(
            mut self,
            input: impl Into<crate::model::NumberFilter>,
        ) -> Self {
            let mut v = self.network_destination_port.unwrap_or_default();
            v.push(input.into());
            self.network_destination_port = Some(v);
            self
        }
        /// <p>The destination port of network-related information about a finding.</p>
        pub fn set_network_destination_port(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.network_destination_port = input;
            self
        }
        /// Appends an item to `network_destination_domain`.
        ///
        /// To override the contents of this collection use [`set_network_destination_domain`](Self::set_network_destination_domain).
        ///
        /// <p>The destination domain of network-related information about a finding.</p>
        pub fn network_destination_domain(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.network_destination_domain.unwrap_or_default();
            v.push(input.into());
            self.network_destination_domain = Some(v);
            self
        }
        /// <p>The destination domain of network-related information about a finding.</p>
        pub fn set_network_destination_domain(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_destination_domain = input;
            self
        }
        /// Appends an item to `process_name`.
        ///
        /// To override the contents of this collection use [`set_process_name`](Self::set_process_name).
        ///
        /// <p>The name of the process.</p>
        pub fn process_name(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.process_name.unwrap_or_default();
            v.push(input.into());
            self.process_name = Some(v);
            self
        }
        /// <p>The name of the process.</p>
        pub fn set_process_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.process_name = input;
            self
        }
        /// Appends an item to `process_path`.
        ///
        /// To override the contents of this collection use [`set_process_path`](Self::set_process_path).
        ///
        /// <p>The path to the process executable.</p>
        pub fn process_path(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.process_path.unwrap_or_default();
            v.push(input.into());
            self.process_path = Some(v);
            self
        }
        /// <p>The path to the process executable.</p>
        pub fn set_process_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.process_path = input;
            self
        }
        /// Appends an item to `process_pid`.
        ///
        /// To override the contents of this collection use [`set_process_pid`](Self::set_process_pid).
        ///
        /// <p>The process ID.</p>
        pub fn process_pid(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.process_pid.unwrap_or_default();
            v.push(input.into());
            self.process_pid = Some(v);
            self
        }
        /// <p>The process ID.</p>
        pub fn set_process_pid(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.process_pid = input;
            self
        }
        /// Appends an item to `process_parent_pid`.
        ///
        /// To override the contents of this collection use [`set_process_parent_pid`](Self::set_process_parent_pid).
        ///
        /// <p>The parent process ID.</p>
        pub fn process_parent_pid(mut self, input: impl Into<crate::model::NumberFilter>) -> Self {
            let mut v = self.process_parent_pid.unwrap_or_default();
            v.push(input.into());
            self.process_parent_pid = Some(v);
            self
        }
        /// <p>The parent process ID.</p>
        pub fn set_process_parent_pid(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.process_parent_pid = input;
            self
        }
        /// Appends an item to `process_launched_at`.
        ///
        /// To override the contents of this collection use [`set_process_launched_at`](Self::set_process_launched_at).
        ///
        /// <p>The date/time that the process was launched.</p>
        pub fn process_launched_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.process_launched_at.unwrap_or_default();
            v.push(input.into());
            self.process_launched_at = Some(v);
            self
        }
        /// <p>The date/time that the process was launched.</p>
        pub fn set_process_launched_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.process_launched_at = input;
            self
        }
        /// Appends an item to `process_terminated_at`.
        ///
        /// To override the contents of this collection use [`set_process_terminated_at`](Self::set_process_terminated_at).
        ///
        /// <p>The date/time that the process was terminated.</p>
        pub fn process_terminated_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.process_terminated_at.unwrap_or_default();
            v.push(input.into());
            self.process_terminated_at = Some(v);
            self
        }
        /// <p>The date/time that the process was terminated.</p>
        pub fn set_process_terminated_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.process_terminated_at = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_type`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_type`](Self::set_threat_intel_indicator_type).
        ///
        /// <p>The type of a threat intelligence indicator.</p>
        pub fn threat_intel_indicator_type(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.threat_intel_indicator_type.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_type = Some(v);
            self
        }
        /// <p>The type of a threat intelligence indicator.</p>
        pub fn set_threat_intel_indicator_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.threat_intel_indicator_type = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_value`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_value`](Self::set_threat_intel_indicator_value).
        ///
        /// <p>The value of a threat intelligence indicator.</p>
        pub fn threat_intel_indicator_value(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.threat_intel_indicator_value.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_value = Some(v);
            self
        }
        /// <p>The value of a threat intelligence indicator.</p>
        pub fn set_threat_intel_indicator_value(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.threat_intel_indicator_value = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_category`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_category`](Self::set_threat_intel_indicator_category).
        ///
        /// <p>The category of a threat intelligence indicator.</p>
        pub fn threat_intel_indicator_category(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.threat_intel_indicator_category.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_category = Some(v);
            self
        }
        /// <p>The category of a threat intelligence indicator.</p>
        pub fn set_threat_intel_indicator_category(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.threat_intel_indicator_category = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_last_observed_at`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_last_observed_at`](Self::set_threat_intel_indicator_last_observed_at).
        ///
        /// <p>The date/time of the last observation of a threat intelligence indicator.</p>
        pub fn threat_intel_indicator_last_observed_at(
            mut self,
            input: impl Into<crate::model::DateFilter>,
        ) -> Self {
            let mut v = self
                .threat_intel_indicator_last_observed_at
                .unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_last_observed_at = Some(v);
            self
        }
        /// <p>The date/time of the last observation of a threat intelligence indicator.</p>
        pub fn set_threat_intel_indicator_last_observed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.threat_intel_indicator_last_observed_at = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_source`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_source`](Self::set_threat_intel_indicator_source).
        ///
        /// <p>The source of the threat intelligence.</p>
        pub fn threat_intel_indicator_source(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.threat_intel_indicator_source.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_source = Some(v);
            self
        }
        /// <p>The source of the threat intelligence.</p>
        pub fn set_threat_intel_indicator_source(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.threat_intel_indicator_source = input;
            self
        }
        /// Appends an item to `threat_intel_indicator_source_url`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicator_source_url`](Self::set_threat_intel_indicator_source_url).
        ///
        /// <p>The URL for more details from the source of the threat intelligence.</p>
        pub fn threat_intel_indicator_source_url(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.threat_intel_indicator_source_url.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicator_source_url = Some(v);
            self
        }
        /// <p>The URL for more details from the source of the threat intelligence.</p>
        pub fn set_threat_intel_indicator_source_url(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.threat_intel_indicator_source_url = input;
            self
        }
        /// Appends an item to `resource_type`.
        ///
        /// To override the contents of this collection use [`set_resource_type`](Self::set_resource_type).
        ///
        /// <p>Specifies the type of the resource that details are provided for.</p>
        pub fn resource_type(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.resource_type.unwrap_or_default();
            v.push(input.into());
            self.resource_type = Some(v);
            self
        }
        /// <p>Specifies the type of the resource that details are provided for.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_id`.
        ///
        /// To override the contents of this collection use [`set_resource_id`](Self::set_resource_id).
        ///
        /// <p>The canonical identifier for the given resource type.</p>
        pub fn resource_id(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.resource_id.unwrap_or_default();
            v.push(input.into());
            self.resource_id = Some(v);
            self
        }
        /// <p>The canonical identifier for the given resource type.</p>
        pub fn set_resource_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `resource_partition`.
        ///
        /// To override the contents of this collection use [`set_resource_partition`](Self::set_resource_partition).
        ///
        /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
        pub fn resource_partition(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.resource_partition.unwrap_or_default();
            v.push(input.into());
            self.resource_partition = Some(v);
            self
        }
        /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
        pub fn set_resource_partition(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_partition = input;
            self
        }
        /// Appends an item to `resource_region`.
        ///
        /// To override the contents of this collection use [`set_resource_region`](Self::set_resource_region).
        ///
        /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
        pub fn resource_region(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.resource_region.unwrap_or_default();
            v.push(input.into());
            self.resource_region = Some(v);
            self
        }
        /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
        pub fn set_resource_region(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_region = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
        /// processed.</p>
        pub fn resource_tags(mut self, input: impl Into<crate::model::MapFilter>) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_tags = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
        /// processed.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_type`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_type`](Self::set_resource_aws_ec2_instance_type).
        ///
        /// <p>The instance type of the instance.</p>
        pub fn resource_aws_ec2_instance_type(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_ec2_instance_type.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_type = Some(v);
            self
        }
        /// <p>The instance type of the instance.</p>
        pub fn set_resource_aws_ec2_instance_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_type = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_image_id`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_image_id`](Self::set_resource_aws_ec2_instance_image_id).
        ///
        /// <p>The Amazon Machine Image (AMI) ID of the instance.</p>
        pub fn resource_aws_ec2_instance_image_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_ec2_instance_image_id.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_image_id = Some(v);
            self
        }
        /// <p>The Amazon Machine Image (AMI) ID of the instance.</p>
        pub fn set_resource_aws_ec2_instance_image_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_image_id = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_ip_v4_addresses`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_ip_v4_addresses`](Self::set_resource_aws_ec2_instance_ip_v4_addresses).
        ///
        /// <p>The IPv4 addresses associated with the instance.</p>
        pub fn resource_aws_ec2_instance_ip_v4_addresses(
            mut self,
            input: impl Into<crate::model::IpFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_ec2_instance_ip_v4_addresses
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_ip_v4_addresses = Some(v);
            self
        }
        /// <p>The IPv4 addresses associated with the instance.</p>
        pub fn set_resource_aws_ec2_instance_ip_v4_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_ip_v4_addresses = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_ip_v6_addresses`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_ip_v6_addresses`](Self::set_resource_aws_ec2_instance_ip_v6_addresses).
        ///
        /// <p>The IPv6 addresses associated with the instance.</p>
        pub fn resource_aws_ec2_instance_ip_v6_addresses(
            mut self,
            input: impl Into<crate::model::IpFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_ec2_instance_ip_v6_addresses
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_ip_v6_addresses = Some(v);
            self
        }
        /// <p>The IPv6 addresses associated with the instance.</p>
        pub fn set_resource_aws_ec2_instance_ip_v6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_ip_v6_addresses = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_key_name`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_key_name`](Self::set_resource_aws_ec2_instance_key_name).
        ///
        /// <p>The key name associated with the instance.</p>
        pub fn resource_aws_ec2_instance_key_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_ec2_instance_key_name.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_key_name = Some(v);
            self
        }
        /// <p>The key name associated with the instance.</p>
        pub fn set_resource_aws_ec2_instance_key_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_key_name = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_iam_instance_profile_arn`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_iam_instance_profile_arn`](Self::set_resource_aws_ec2_instance_iam_instance_profile_arn).
        ///
        /// <p>The IAM profile ARN of the instance.</p>
        pub fn resource_aws_ec2_instance_iam_instance_profile_arn(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_ec2_instance_iam_instance_profile_arn
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_iam_instance_profile_arn = Some(v);
            self
        }
        /// <p>The IAM profile ARN of the instance.</p>
        pub fn set_resource_aws_ec2_instance_iam_instance_profile_arn(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_iam_instance_profile_arn = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_vpc_id`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_vpc_id`](Self::set_resource_aws_ec2_instance_vpc_id).
        ///
        /// <p>The identifier of the VPC that the instance was launched in.</p>
        pub fn resource_aws_ec2_instance_vpc_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_ec2_instance_vpc_id.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_vpc_id = Some(v);
            self
        }
        /// <p>The identifier of the VPC that the instance was launched in.</p>
        pub fn set_resource_aws_ec2_instance_vpc_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_vpc_id = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_subnet_id`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_subnet_id`](Self::set_resource_aws_ec2_instance_subnet_id).
        ///
        /// <p>The identifier of the subnet that the instance was launched in.</p>
        pub fn resource_aws_ec2_instance_subnet_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_ec2_instance_subnet_id.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_subnet_id = Some(v);
            self
        }
        /// <p>The identifier of the subnet that the instance was launched in.</p>
        pub fn set_resource_aws_ec2_instance_subnet_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_subnet_id = input;
            self
        }
        /// Appends an item to `resource_aws_ec2_instance_launched_at`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_ec2_instance_launched_at`](Self::set_resource_aws_ec2_instance_launched_at).
        ///
        /// <p>The date and time the instance was launched.</p>
        pub fn resource_aws_ec2_instance_launched_at(
            mut self,
            input: impl Into<crate::model::DateFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_ec2_instance_launched_at
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_ec2_instance_launched_at = Some(v);
            self
        }
        /// <p>The date and time the instance was launched.</p>
        pub fn set_resource_aws_ec2_instance_launched_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.resource_aws_ec2_instance_launched_at = input;
            self
        }
        /// Appends an item to `resource_aws_s3_bucket_owner_id`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_s3_bucket_owner_id`](Self::set_resource_aws_s3_bucket_owner_id).
        ///
        /// <p>The canonical user ID of the owner of the S3 bucket.</p>
        pub fn resource_aws_s3_bucket_owner_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_s3_bucket_owner_id.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_s3_bucket_owner_id = Some(v);
            self
        }
        /// <p>The canonical user ID of the owner of the S3 bucket.</p>
        pub fn set_resource_aws_s3_bucket_owner_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_s3_bucket_owner_id = input;
            self
        }
        /// Appends an item to `resource_aws_s3_bucket_owner_name`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_s3_bucket_owner_name`](Self::set_resource_aws_s3_bucket_owner_name).
        ///
        /// <p>The display name of the owner of the S3 bucket.</p>
        pub fn resource_aws_s3_bucket_owner_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_s3_bucket_owner_name.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_s3_bucket_owner_name = Some(v);
            self
        }
        /// <p>The display name of the owner of the S3 bucket.</p>
        pub fn set_resource_aws_s3_bucket_owner_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_s3_bucket_owner_name = input;
            self
        }
        /// Appends an item to `resource_aws_iam_access_key_user_name`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_iam_access_key_user_name`](Self::set_resource_aws_iam_access_key_user_name).
        ///
        /// <p>The user associated with the IAM access key related to a finding.</p>
        pub fn resource_aws_iam_access_key_user_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_iam_access_key_user_name
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_iam_access_key_user_name = Some(v);
            self
        }
        /// <p>The user associated with the IAM access key related to a finding.</p>
        pub fn set_resource_aws_iam_access_key_user_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_iam_access_key_user_name = input;
            self
        }
        /// Appends an item to `resource_aws_iam_access_key_principal_name`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_iam_access_key_principal_name`](Self::set_resource_aws_iam_access_key_principal_name).
        ///
        /// <p>The name of the principal that is associated with an IAM access key.</p>
        pub fn resource_aws_iam_access_key_principal_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_iam_access_key_principal_name
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_iam_access_key_principal_name = Some(v);
            self
        }
        /// <p>The name of the principal that is associated with an IAM access key.</p>
        pub fn set_resource_aws_iam_access_key_principal_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_iam_access_key_principal_name = input;
            self
        }
        /// Appends an item to `resource_aws_iam_access_key_status`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_iam_access_key_status`](Self::set_resource_aws_iam_access_key_status).
        ///
        /// <p>The status of the IAM access key related to a finding.</p>
        pub fn resource_aws_iam_access_key_status(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_iam_access_key_status.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_iam_access_key_status = Some(v);
            self
        }
        /// <p>The status of the IAM access key related to a finding.</p>
        pub fn set_resource_aws_iam_access_key_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_iam_access_key_status = input;
            self
        }
        /// Appends an item to `resource_aws_iam_access_key_created_at`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_iam_access_key_created_at`](Self::set_resource_aws_iam_access_key_created_at).
        ///
        /// <p>The creation date/time of the IAM access key related to a finding.</p>
        pub fn resource_aws_iam_access_key_created_at(
            mut self,
            input: impl Into<crate::model::DateFilter>,
        ) -> Self {
            let mut v = self
                .resource_aws_iam_access_key_created_at
                .unwrap_or_default();
            v.push(input.into());
            self.resource_aws_iam_access_key_created_at = Some(v);
            self
        }
        /// <p>The creation date/time of the IAM access key related to a finding.</p>
        pub fn set_resource_aws_iam_access_key_created_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.resource_aws_iam_access_key_created_at = input;
            self
        }
        /// Appends an item to `resource_aws_iam_user_user_name`.
        ///
        /// To override the contents of this collection use [`set_resource_aws_iam_user_user_name`](Self::set_resource_aws_iam_user_user_name).
        ///
        /// <p>The name of an IAM user.</p>
        pub fn resource_aws_iam_user_user_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_aws_iam_user_user_name.unwrap_or_default();
            v.push(input.into());
            self.resource_aws_iam_user_user_name = Some(v);
            self
        }
        /// <p>The name of an IAM user.</p>
        pub fn set_resource_aws_iam_user_user_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_aws_iam_user_user_name = input;
            self
        }
        /// Appends an item to `resource_container_name`.
        ///
        /// To override the contents of this collection use [`set_resource_container_name`](Self::set_resource_container_name).
        ///
        /// <p>The name of the container related to a finding.</p>
        pub fn resource_container_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_container_name.unwrap_or_default();
            v.push(input.into());
            self.resource_container_name = Some(v);
            self
        }
        /// <p>The name of the container related to a finding.</p>
        pub fn set_resource_container_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_container_name = input;
            self
        }
        /// Appends an item to `resource_container_image_id`.
        ///
        /// To override the contents of this collection use [`set_resource_container_image_id`](Self::set_resource_container_image_id).
        ///
        /// <p>The identifier of the image related to a finding.</p>
        pub fn resource_container_image_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_container_image_id.unwrap_or_default();
            v.push(input.into());
            self.resource_container_image_id = Some(v);
            self
        }
        /// <p>The identifier of the image related to a finding.</p>
        pub fn set_resource_container_image_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_container_image_id = input;
            self
        }
        /// Appends an item to `resource_container_image_name`.
        ///
        /// To override the contents of this collection use [`set_resource_container_image_name`](Self::set_resource_container_image_name).
        ///
        /// <p>The name of the image related to a finding.</p>
        pub fn resource_container_image_name(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.resource_container_image_name.unwrap_or_default();
            v.push(input.into());
            self.resource_container_image_name = Some(v);
            self
        }
        /// <p>The name of the image related to a finding.</p>
        pub fn set_resource_container_image_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_container_image_name = input;
            self
        }
        /// Appends an item to `resource_container_launched_at`.
        ///
        /// To override the contents of this collection use [`set_resource_container_launched_at`](Self::set_resource_container_launched_at).
        ///
        /// <p>The date/time that the container was started.</p>
        pub fn resource_container_launched_at(
            mut self,
            input: impl Into<crate::model::DateFilter>,
        ) -> Self {
            let mut v = self.resource_container_launched_at.unwrap_or_default();
            v.push(input.into());
            self.resource_container_launched_at = Some(v);
            self
        }
        /// <p>The date/time that the container was started.</p>
        pub fn set_resource_container_launched_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.resource_container_launched_at = input;
            self
        }
        /// Appends an item to `resource_details_other`.
        ///
        /// To override the contents of this collection use [`set_resource_details_other`](Self::set_resource_details_other).
        ///
        /// <p>The details of a resource that doesn't have a specific subfield for the resource type
        /// defined.</p>
        pub fn resource_details_other(mut self, input: impl Into<crate::model::MapFilter>) -> Self {
            let mut v = self.resource_details_other.unwrap_or_default();
            v.push(input.into());
            self.resource_details_other = Some(v);
            self
        }
        /// <p>The details of a resource that doesn't have a specific subfield for the resource type
        /// defined.</p>
        pub fn set_resource_details_other(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.resource_details_other = input;
            self
        }
        /// Appends an item to `compliance_status`.
        ///
        /// To override the contents of this collection use [`set_compliance_status`](Self::set_compliance_status).
        ///
        /// <p>Exclusive to findings that are generated as the result of a check run against a specific
        /// rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security
        /// standard-related finding details.</p>
        pub fn compliance_status(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.compliance_status.unwrap_or_default();
            v.push(input.into());
            self.compliance_status = Some(v);
            self
        }
        /// <p>Exclusive to findings that are generated as the result of a check run against a specific
        /// rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security
        /// standard-related finding details.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// Appends an item to `verification_state`.
        ///
        /// To override the contents of this collection use [`set_verification_state`](Self::set_verification_state).
        ///
        /// <p>The veracity of a finding.</p>
        pub fn verification_state(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.verification_state.unwrap_or_default();
            v.push(input.into());
            self.verification_state = Some(v);
            self
        }
        /// <p>The veracity of a finding.</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.verification_state = input;
            self
        }
        /// Appends an item to `workflow_state`.
        ///
        /// To override the contents of this collection use [`set_workflow_state`](Self::set_workflow_state).
        ///
        /// <p>The workflow state of a finding.</p>
        /// <p>Note that this field is deprecated. To search for a finding based on its workflow
        /// status, use <code>WorkflowStatus</code>.</p>
        pub fn workflow_state(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.workflow_state.unwrap_or_default();
            v.push(input.into());
            self.workflow_state = Some(v);
            self
        }
        /// <p>The workflow state of a finding.</p>
        /// <p>Note that this field is deprecated. To search for a finding based on its workflow
        /// status, use <code>WorkflowStatus</code>.</p>
        pub fn set_workflow_state(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.workflow_state = input;
            self
        }
        /// Appends an item to `workflow_status`.
        ///
        /// To override the contents of this collection use [`set_workflow_status`](Self::set_workflow_status).
        ///
        /// <p>The status of the investigation into a finding. Allowed values are the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
        /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
        /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
        /// <ul>
        /// <li>
        /// <p>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p>
        /// </li>
        /// <li>
        /// <p>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code>,
        /// <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFIED</code> - Indicates that the resource owner has been notified about
        /// the security issue. Used when the initial reviewer is not the resource owner, and
        /// needs intervention from the resource owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
        /// acted upon.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
        /// considered resolved. </p>
        /// </li>
        /// </ul>
        pub fn workflow_status(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.workflow_status.unwrap_or_default();
            v.push(input.into());
            self.workflow_status = Some(v);
            self
        }
        /// <p>The status of the investigation into a finding. Allowed values are the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
        /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
        /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
        /// <ul>
        /// <li>
        /// <p>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p>
        /// </li>
        /// <li>
        /// <p>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code>,
        /// <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFIED</code> - Indicates that the resource owner has been notified about
        /// the security issue. Used when the initial reviewer is not the resource owner, and
        /// needs intervention from the resource owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be
        /// acted upon.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
        /// considered resolved. </p>
        /// </li>
        /// </ul>
        pub fn set_workflow_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.workflow_status = input;
            self
        }
        /// Appends an item to `record_state`.
        ///
        /// To override the contents of this collection use [`set_record_state`](Self::set_record_state).
        ///
        /// <p>The updated record state for the finding.</p>
        pub fn record_state(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.record_state.unwrap_or_default();
            v.push(input.into());
            self.record_state = Some(v);
            self
        }
        /// <p>The updated record state for the finding.</p>
        pub fn set_record_state(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.record_state = input;
            self
        }
        /// Appends an item to `related_findings_product_arn`.
        ///
        /// To override the contents of this collection use [`set_related_findings_product_arn`](Self::set_related_findings_product_arn).
        ///
        /// <p>The ARN of the solution that generated a related finding.</p>
        pub fn related_findings_product_arn(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.related_findings_product_arn.unwrap_or_default();
            v.push(input.into());
            self.related_findings_product_arn = Some(v);
            self
        }
        /// <p>The ARN of the solution that generated a related finding.</p>
        pub fn set_related_findings_product_arn(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.related_findings_product_arn = input;
            self
        }
        /// Appends an item to `related_findings_id`.
        ///
        /// To override the contents of this collection use [`set_related_findings_id`](Self::set_related_findings_id).
        ///
        /// <p>The solution-generated identifier for a related finding.</p>
        pub fn related_findings_id(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.related_findings_id.unwrap_or_default();
            v.push(input.into());
            self.related_findings_id = Some(v);
            self
        }
        /// <p>The solution-generated identifier for a related finding.</p>
        pub fn set_related_findings_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.related_findings_id = input;
            self
        }
        /// Appends an item to `note_text`.
        ///
        /// To override the contents of this collection use [`set_note_text`](Self::set_note_text).
        ///
        /// <p>The text of a note.</p>
        pub fn note_text(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.note_text.unwrap_or_default();
            v.push(input.into());
            self.note_text = Some(v);
            self
        }
        /// <p>The text of a note.</p>
        pub fn set_note_text(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.note_text = input;
            self
        }
        /// Appends an item to `note_updated_at`.
        ///
        /// To override the contents of this collection use [`set_note_updated_at`](Self::set_note_updated_at).
        ///
        /// <p>The timestamp of when the note was updated.</p>
        pub fn note_updated_at(mut self, input: impl Into<crate::model::DateFilter>) -> Self {
            let mut v = self.note_updated_at.unwrap_or_default();
            v.push(input.into());
            self.note_updated_at = Some(v);
            self
        }
        /// <p>The timestamp of when the note was updated.</p>
        pub fn set_note_updated_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.note_updated_at = input;
            self
        }
        /// Appends an item to `note_updated_by`.
        ///
        /// To override the contents of this collection use [`set_note_updated_by`](Self::set_note_updated_by).
        ///
        /// <p>The principal that created a note.</p>
        pub fn note_updated_by(mut self, input: impl Into<crate::model::StringFilter>) -> Self {
            let mut v = self.note_updated_by.unwrap_or_default();
            v.push(input.into());
            self.note_updated_by = Some(v);
            self
        }
        /// <p>The principal that created a note.</p>
        pub fn set_note_updated_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.note_updated_by = input;
            self
        }
        /// Appends an item to `keyword`.
        ///
        /// To override the contents of this collection use [`set_keyword`](Self::set_keyword).
        ///
        /// <p>A keyword for a finding.</p>
        pub fn keyword(mut self, input: impl Into<crate::model::KeywordFilter>) -> Self {
            let mut v = self.keyword.unwrap_or_default();
            v.push(input.into());
            self.keyword = Some(v);
            self
        }
        /// <p>A keyword for a finding.</p>
        pub fn set_keyword(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeywordFilter>>,
        ) -> Self {
            self.keyword = input;
            self
        }
        /// Appends an item to `finding_provider_fields_confidence`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_confidence`](Self::set_finding_provider_fields_confidence).
        ///
        /// <p>The finding provider value for the finding confidence. Confidence is defined as the likelihood
        /// that a finding accurately identifies the behavior or issue that it was intended to
        /// identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn finding_provider_fields_confidence(
            mut self,
            input: impl Into<crate::model::NumberFilter>,
        ) -> Self {
            let mut v = self.finding_provider_fields_confidence.unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_confidence = Some(v);
            self
        }
        /// <p>The finding provider value for the finding confidence. Confidence is defined as the likelihood
        /// that a finding accurately identifies the behavior or issue that it was intended to
        /// identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn set_finding_provider_fields_confidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.finding_provider_fields_confidence = input;
            self
        }
        /// Appends an item to `finding_provider_fields_criticality`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_criticality`](Self::set_finding_provider_fields_criticality).
        ///
        /// <p>The finding provider value for the level of importance assigned to the resources associated with
        /// the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources. </p>
        pub fn finding_provider_fields_criticality(
            mut self,
            input: impl Into<crate::model::NumberFilter>,
        ) -> Self {
            let mut v = self.finding_provider_fields_criticality.unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_criticality = Some(v);
            self
        }
        /// <p>The finding provider value for the level of importance assigned to the resources associated with
        /// the findings.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources. </p>
        pub fn set_finding_provider_fields_criticality(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.finding_provider_fields_criticality = input;
            self
        }
        /// Appends an item to `finding_provider_fields_related_findings_id`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_related_findings_id`](Self::set_finding_provider_fields_related_findings_id).
        ///
        /// <p>The finding identifier of a related finding that is identified by the finding provider.</p>
        pub fn finding_provider_fields_related_findings_id(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .finding_provider_fields_related_findings_id
                .unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_related_findings_id = Some(v);
            self
        }
        /// <p>The finding identifier of a related finding that is identified by the finding provider.</p>
        pub fn set_finding_provider_fields_related_findings_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_provider_fields_related_findings_id = input;
            self
        }
        /// Appends an item to `finding_provider_fields_related_findings_product_arn`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_related_findings_product_arn`](Self::set_finding_provider_fields_related_findings_product_arn).
        ///
        /// <p>The ARN of the solution that generated a related finding that is identified by the finding provider.</p>
        pub fn finding_provider_fields_related_findings_product_arn(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .finding_provider_fields_related_findings_product_arn
                .unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_related_findings_product_arn = Some(v);
            self
        }
        /// <p>The ARN of the solution that generated a related finding that is identified by the finding provider.</p>
        pub fn set_finding_provider_fields_related_findings_product_arn(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_provider_fields_related_findings_product_arn = input;
            self
        }
        /// Appends an item to `finding_provider_fields_severity_label`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_severity_label`](Self::set_finding_provider_fields_severity_label).
        ///
        /// <p>The finding provider value for the severity label.</p>
        pub fn finding_provider_fields_severity_label(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .finding_provider_fields_severity_label
                .unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_severity_label = Some(v);
            self
        }
        /// <p>The finding provider value for the severity label.</p>
        pub fn set_finding_provider_fields_severity_label(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_provider_fields_severity_label = input;
            self
        }
        /// Appends an item to `finding_provider_fields_severity_original`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_severity_original`](Self::set_finding_provider_fields_severity_original).
        ///
        /// <p>The finding provider's original value for the severity.</p>
        pub fn finding_provider_fields_severity_original(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self
                .finding_provider_fields_severity_original
                .unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_severity_original = Some(v);
            self
        }
        /// <p>The finding provider's original value for the severity.</p>
        pub fn set_finding_provider_fields_severity_original(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_provider_fields_severity_original = input;
            self
        }
        /// Appends an item to `finding_provider_fields_types`.
        ///
        /// To override the contents of this collection use [`set_finding_provider_fields_types`](Self::set_finding_provider_fields_types).
        ///
        /// <p>One or more finding types that the finding provider assigned to the finding. Uses the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn finding_provider_fields_types(
            mut self,
            input: impl Into<crate::model::StringFilter>,
        ) -> Self {
            let mut v = self.finding_provider_fields_types.unwrap_or_default();
            v.push(input.into());
            self.finding_provider_fields_types = Some(v);
            self
        }
        /// <p>One or more finding types that the finding provider assigned to the finding. Uses the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn set_finding_provider_fields_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_provider_fields_types = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsSecurityFindingFilters`](crate::model::AwsSecurityFindingFilters)
        pub fn build(self) -> crate::model::AwsSecurityFindingFilters {
            crate::model::AwsSecurityFindingFilters {
                product_arn: self.product_arn,
                aws_account_id: self.aws_account_id,
                id: self.id,
                generator_id: self.generator_id,
                region: self.region,
                r#type: self.r#type,
                first_observed_at: self.first_observed_at,
                last_observed_at: self.last_observed_at,
                created_at: self.created_at,
                updated_at: self.updated_at,
                severity_product: self.severity_product,
                severity_normalized: self.severity_normalized,
                severity_label: self.severity_label,
                confidence: self.confidence,
                criticality: self.criticality,
                title: self.title,
                description: self.description,
                recommendation_text: self.recommendation_text,
                source_url: self.source_url,
                product_fields: self.product_fields,
                product_name: self.product_name,
                company_name: self.company_name,
                user_defined_fields: self.user_defined_fields,
                malware_name: self.malware_name,
                malware_type: self.malware_type,
                malware_path: self.malware_path,
                malware_state: self.malware_state,
                network_direction: self.network_direction,
                network_protocol: self.network_protocol,
                network_source_ip_v4: self.network_source_ip_v4,
                network_source_ip_v6: self.network_source_ip_v6,
                network_source_port: self.network_source_port,
                network_source_domain: self.network_source_domain,
                network_source_mac: self.network_source_mac,
                network_destination_ip_v4: self.network_destination_ip_v4,
                network_destination_ip_v6: self.network_destination_ip_v6,
                network_destination_port: self.network_destination_port,
                network_destination_domain: self.network_destination_domain,
                process_name: self.process_name,
                process_path: self.process_path,
                process_pid: self.process_pid,
                process_parent_pid: self.process_parent_pid,
                process_launched_at: self.process_launched_at,
                process_terminated_at: self.process_terminated_at,
                threat_intel_indicator_type: self.threat_intel_indicator_type,
                threat_intel_indicator_value: self.threat_intel_indicator_value,
                threat_intel_indicator_category: self.threat_intel_indicator_category,
                threat_intel_indicator_last_observed_at: self
                    .threat_intel_indicator_last_observed_at,
                threat_intel_indicator_source: self.threat_intel_indicator_source,
                threat_intel_indicator_source_url: self.threat_intel_indicator_source_url,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_partition: self.resource_partition,
                resource_region: self.resource_region,
                resource_tags: self.resource_tags,
                resource_aws_ec2_instance_type: self.resource_aws_ec2_instance_type,
                resource_aws_ec2_instance_image_id: self.resource_aws_ec2_instance_image_id,
                resource_aws_ec2_instance_ip_v4_addresses: self
                    .resource_aws_ec2_instance_ip_v4_addresses,
                resource_aws_ec2_instance_ip_v6_addresses: self
                    .resource_aws_ec2_instance_ip_v6_addresses,
                resource_aws_ec2_instance_key_name: self.resource_aws_ec2_instance_key_name,
                resource_aws_ec2_instance_iam_instance_profile_arn: self
                    .resource_aws_ec2_instance_iam_instance_profile_arn,
                resource_aws_ec2_instance_vpc_id: self.resource_aws_ec2_instance_vpc_id,
                resource_aws_ec2_instance_subnet_id: self.resource_aws_ec2_instance_subnet_id,
                resource_aws_ec2_instance_launched_at: self.resource_aws_ec2_instance_launched_at,
                resource_aws_s3_bucket_owner_id: self.resource_aws_s3_bucket_owner_id,
                resource_aws_s3_bucket_owner_name: self.resource_aws_s3_bucket_owner_name,
                resource_aws_iam_access_key_user_name: self.resource_aws_iam_access_key_user_name,
                resource_aws_iam_access_key_principal_name: self
                    .resource_aws_iam_access_key_principal_name,
                resource_aws_iam_access_key_status: self.resource_aws_iam_access_key_status,
                resource_aws_iam_access_key_created_at: self.resource_aws_iam_access_key_created_at,
                resource_aws_iam_user_user_name: self.resource_aws_iam_user_user_name,
                resource_container_name: self.resource_container_name,
                resource_container_image_id: self.resource_container_image_id,
                resource_container_image_name: self.resource_container_image_name,
                resource_container_launched_at: self.resource_container_launched_at,
                resource_details_other: self.resource_details_other,
                compliance_status: self.compliance_status,
                verification_state: self.verification_state,
                workflow_state: self.workflow_state,
                workflow_status: self.workflow_status,
                record_state: self.record_state,
                related_findings_product_arn: self.related_findings_product_arn,
                related_findings_id: self.related_findings_id,
                note_text: self.note_text,
                note_updated_at: self.note_updated_at,
                note_updated_by: self.note_updated_by,
                keyword: self.keyword,
                finding_provider_fields_confidence: self.finding_provider_fields_confidence,
                finding_provider_fields_criticality: self.finding_provider_fields_criticality,
                finding_provider_fields_related_findings_id: self
                    .finding_provider_fields_related_findings_id,
                finding_provider_fields_related_findings_product_arn: self
                    .finding_provider_fields_related_findings_product_arn,
                finding_provider_fields_severity_label: self.finding_provider_fields_severity_label,
                finding_provider_fields_severity_original: self
                    .finding_provider_fields_severity_original,
                finding_provider_fields_types: self.finding_provider_fields_types,
            }
        }
    }
}
impl AwsSecurityFindingFilters {
    /// Creates a new builder-style object to manufacture [`AwsSecurityFindingFilters`](crate::model::AwsSecurityFindingFilters)
    pub fn builder() -> crate::model::aws_security_finding_filters::Builder {
        crate::model::aws_security_finding_filters::Builder::default()
    }
}

/// <p>A string filter for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StringFilter {
    /// <p>The string filter value. Filter values are case sensitive. For example, the product name
    /// for control-based findings is <code>Security Hub</code>. If you provide <code>security hub</code>
    /// as the filter text, then there is no match.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The condition to apply to a string value when querying for findings. To search for
    /// values that contain the filter criteria value, use one of the following comparison
    /// operators:</p>
    /// <ul>
    /// <li>
    /// <p>To search for values that exactly match the filter value, use
    /// <code>EQUALS</code>.</p>
    /// <p>For example, the filter <code>ResourceType EQUALS AwsEc2SecurityGroup</code> only
    /// matches findings that have a resource type of
    /// <code>AwsEc2SecurityGroup</code>.</p>
    /// </li>
    /// <li>
    /// <p>To search for values that start with the filter value, use
    /// <code>PREFIX</code>.</p>
    /// <p>For example, the filter <code>ResourceType PREFIX AwsIam</code> matches findings
    /// that have a resource type that starts with <code>AwsIam</code>. Findings with a
    /// resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>, or
    /// <code>AwsIamUser</code> would all match.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>EQUALS</code> and <code>PREFIX</code> filters on the same field are joined by
    /// <code>OR</code>. A finding matches if it matches any one of those filters.</p>
    /// <p>To search for values that do not contain the filter criteria value, use one of the
    /// following comparison operators:</p>
    /// <ul>
    /// <li>
    /// <p>To search for values that do not exactly match the filter value, use
    /// <code>NOT_EQUALS</code>.</p>
    /// <p>For example, the filter <code>ResourceType NOT_EQUALS AwsIamPolicy</code> matches
    /// findings that have a resource type other than <code>AwsIamPolicy</code>.</p>
    /// </li>
    /// <li>
    /// <p>To search for values that do not start with the filter value, use
    /// <code>PREFIX_NOT_EQUALS</code>.</p>
    /// <p>For example, the filter <code>ResourceType PREFIX_NOT_EQUALS AwsIam</code> matches
    /// findings that have a resource type that does not start with <code>AwsIam</code>.
    /// Findings with a resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>,
    /// or <code>AwsIamUser</code> would all be excluded from the results.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>NOT_EQUALS</code> and <code>PREFIX_NOT_EQUALS</code> filters on the same field are
    /// joined by <code>AND</code>. A finding matches only if it matches all of those
    /// filters.</p>
    /// <p>For filters on the same field, you cannot provide both an <code>EQUALS</code> filter and
    /// a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter. Combining filters in
    /// this way always returns an error, even if the provided filter values would return valid
    /// results.</p>
    /// <p>You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or
    /// <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the
    /// <code>PREFIX</code> filters, then the <code>NOT_EQUALS</code> or
    /// <code>PREFIX_NOT_EQUALS</code> filters.</p>
    /// <p> For example, for the following filter, Security Hub first identifies findings that have
    /// resource types that start with either <code>AwsIAM</code> or <code>AwsEc2</code>. It then
    /// excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that
    /// have a resource type of <code>AwsEc2NetworkInterface</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ResourceType PREFIX AwsIam</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceType PREFIX AwsEc2</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceType NOT_EQUALS AwsIamPolicy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    pub comparison: std::option::Option<crate::model::StringFilterComparison>,
}
impl std::fmt::Debug for StringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StringFilter");
        formatter.field("value", &self.value);
        formatter.field("comparison", &self.comparison);
        formatter.finish()
    }
}
/// See [`StringFilter`](crate::model::StringFilter)
pub mod string_filter {
    /// A builder for [`StringFilter`](crate::model::StringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) comparison: std::option::Option<crate::model::StringFilterComparison>,
    }
    impl Builder {
        /// <p>The string filter value. Filter values are case sensitive. For example, the product name
        /// for control-based findings is <code>Security Hub</code>. If you provide <code>security hub</code>
        /// as the filter text, then there is no match.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string filter value. Filter values are case sensitive. For example, the product name
        /// for control-based findings is <code>Security Hub</code>. If you provide <code>security hub</code>
        /// as the filter text, then there is no match.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The condition to apply to a string value when querying for findings. To search for
        /// values that contain the filter criteria value, use one of the following comparison
        /// operators:</p>
        /// <ul>
        /// <li>
        /// <p>To search for values that exactly match the filter value, use
        /// <code>EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType EQUALS AwsEc2SecurityGroup</code> only
        /// matches findings that have a resource type of
        /// <code>AwsEc2SecurityGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>To search for values that start with the filter value, use
        /// <code>PREFIX</code>.</p>
        /// <p>For example, the filter <code>ResourceType PREFIX AwsIam</code> matches findings
        /// that have a resource type that starts with <code>AwsIam</code>. Findings with a
        /// resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>, or
        /// <code>AwsIamUser</code> would all match.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>EQUALS</code> and <code>PREFIX</code> filters on the same field are joined by
        /// <code>OR</code>. A finding matches if it matches any one of those filters.</p>
        /// <p>To search for values that do not contain the filter criteria value, use one of the
        /// following comparison operators:</p>
        /// <ul>
        /// <li>
        /// <p>To search for values that do not exactly match the filter value, use
        /// <code>NOT_EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType NOT_EQUALS AwsIamPolicy</code> matches
        /// findings that have a resource type other than <code>AwsIamPolicy</code>.</p>
        /// </li>
        /// <li>
        /// <p>To search for values that do not start with the filter value, use
        /// <code>PREFIX_NOT_EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType PREFIX_NOT_EQUALS AwsIam</code> matches
        /// findings that have a resource type that does not start with <code>AwsIam</code>.
        /// Findings with a resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>,
        /// or <code>AwsIamUser</code> would all be excluded from the results.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>NOT_EQUALS</code> and <code>PREFIX_NOT_EQUALS</code> filters on the same field are
        /// joined by <code>AND</code>. A finding matches only if it matches all of those
        /// filters.</p>
        /// <p>For filters on the same field, you cannot provide both an <code>EQUALS</code> filter and
        /// a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter. Combining filters in
        /// this way always returns an error, even if the provided filter values would return valid
        /// results.</p>
        /// <p>You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or
        /// <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the
        /// <code>PREFIX</code> filters, then the <code>NOT_EQUALS</code> or
        /// <code>PREFIX_NOT_EQUALS</code> filters.</p>
        /// <p> For example, for the following filter, Security Hub first identifies findings that have
        /// resource types that start with either <code>AwsIAM</code> or <code>AwsEc2</code>. It then
        /// excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that
        /// have a resource type of <code>AwsEc2NetworkInterface</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ResourceType PREFIX AwsIam</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType PREFIX AwsEc2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType NOT_EQUALS AwsIamPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn comparison(mut self, input: crate::model::StringFilterComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The condition to apply to a string value when querying for findings. To search for
        /// values that contain the filter criteria value, use one of the following comparison
        /// operators:</p>
        /// <ul>
        /// <li>
        /// <p>To search for values that exactly match the filter value, use
        /// <code>EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType EQUALS AwsEc2SecurityGroup</code> only
        /// matches findings that have a resource type of
        /// <code>AwsEc2SecurityGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>To search for values that start with the filter value, use
        /// <code>PREFIX</code>.</p>
        /// <p>For example, the filter <code>ResourceType PREFIX AwsIam</code> matches findings
        /// that have a resource type that starts with <code>AwsIam</code>. Findings with a
        /// resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>, or
        /// <code>AwsIamUser</code> would all match.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>EQUALS</code> and <code>PREFIX</code> filters on the same field are joined by
        /// <code>OR</code>. A finding matches if it matches any one of those filters.</p>
        /// <p>To search for values that do not contain the filter criteria value, use one of the
        /// following comparison operators:</p>
        /// <ul>
        /// <li>
        /// <p>To search for values that do not exactly match the filter value, use
        /// <code>NOT_EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType NOT_EQUALS AwsIamPolicy</code> matches
        /// findings that have a resource type other than <code>AwsIamPolicy</code>.</p>
        /// </li>
        /// <li>
        /// <p>To search for values that do not start with the filter value, use
        /// <code>PREFIX_NOT_EQUALS</code>.</p>
        /// <p>For example, the filter <code>ResourceType PREFIX_NOT_EQUALS AwsIam</code> matches
        /// findings that have a resource type that does not start with <code>AwsIam</code>.
        /// Findings with a resource type of <code>AwsIamPolicy</code>, <code>AwsIamRole</code>,
        /// or <code>AwsIamUser</code> would all be excluded from the results.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>NOT_EQUALS</code> and <code>PREFIX_NOT_EQUALS</code> filters on the same field are
        /// joined by <code>AND</code>. A finding matches only if it matches all of those
        /// filters.</p>
        /// <p>For filters on the same field, you cannot provide both an <code>EQUALS</code> filter and
        /// a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter. Combining filters in
        /// this way always returns an error, even if the provided filter values would return valid
        /// results.</p>
        /// <p>You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or
        /// <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the
        /// <code>PREFIX</code> filters, then the <code>NOT_EQUALS</code> or
        /// <code>PREFIX_NOT_EQUALS</code> filters.</p>
        /// <p> For example, for the following filter, Security Hub first identifies findings that have
        /// resource types that start with either <code>AwsIAM</code> or <code>AwsEc2</code>. It then
        /// excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that
        /// have a resource type of <code>AwsEc2NetworkInterface</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ResourceType PREFIX AwsIam</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType PREFIX AwsEc2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType NOT_EQUALS AwsIamPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::StringFilterComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// Consumes the builder and constructs a [`StringFilter`](crate::model::StringFilter)
        pub fn build(self) -> crate::model::StringFilter {
            crate::model::StringFilter {
                value: self.value,
                comparison: self.comparison,
            }
        }
    }
}
impl StringFilter {
    /// Creates a new builder-style object to manufacture [`StringFilter`](crate::model::StringFilter)
    pub fn builder() -> crate::model::string_filter::Builder {
        crate::model::string_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StringFilterComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEquals,
    #[allow(missing_docs)] // documentation missing in model
    Prefix,
    #[allow(missing_docs)] // documentation missing in model
    PrefixNotEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StringFilterComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => StringFilterComparison::Equals,
            "NOT_EQUALS" => StringFilterComparison::NotEquals,
            "PREFIX" => StringFilterComparison::Prefix,
            "PREFIX_NOT_EQUALS" => StringFilterComparison::PrefixNotEquals,
            other => StringFilterComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StringFilterComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StringFilterComparison::from(s))
    }
}
impl StringFilterComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StringFilterComparison::Equals => "EQUALS",
            StringFilterComparison::NotEquals => "NOT_EQUALS",
            StringFilterComparison::Prefix => "PREFIX",
            StringFilterComparison::PrefixNotEquals => "PREFIX_NOT_EQUALS",
            StringFilterComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS", "NOT_EQUALS", "PREFIX", "PREFIX_NOT_EQUALS"]
    }
}
impl AsRef<str> for StringFilterComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A number filter for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NumberFilter {
    /// <p>The greater-than-equal condition to be applied to a single field when querying for
    /// findings. </p>
    pub gte: f64,
    /// <p>The less-than-equal condition to be applied to a single field when querying for
    /// findings. </p>
    pub lte: f64,
    /// <p>The equal-to condition to be applied to a single field when querying for
    /// findings.</p>
    pub eq: f64,
}
impl std::fmt::Debug for NumberFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NumberFilter");
        formatter.field("gte", &self.gte);
        formatter.field("lte", &self.lte);
        formatter.field("eq", &self.eq);
        formatter.finish()
    }
}
/// See [`NumberFilter`](crate::model::NumberFilter)
pub mod number_filter {
    /// A builder for [`NumberFilter`](crate::model::NumberFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gte: std::option::Option<f64>,
        pub(crate) lte: std::option::Option<f64>,
        pub(crate) eq: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The greater-than-equal condition to be applied to a single field when querying for
        /// findings. </p>
        pub fn gte(mut self, input: f64) -> Self {
            self.gte = Some(input);
            self
        }
        /// <p>The greater-than-equal condition to be applied to a single field when querying for
        /// findings. </p>
        pub fn set_gte(mut self, input: std::option::Option<f64>) -> Self {
            self.gte = input;
            self
        }
        /// <p>The less-than-equal condition to be applied to a single field when querying for
        /// findings. </p>
        pub fn lte(mut self, input: f64) -> Self {
            self.lte = Some(input);
            self
        }
        /// <p>The less-than-equal condition to be applied to a single field when querying for
        /// findings. </p>
        pub fn set_lte(mut self, input: std::option::Option<f64>) -> Self {
            self.lte = input;
            self
        }
        /// <p>The equal-to condition to be applied to a single field when querying for
        /// findings.</p>
        pub fn eq(mut self, input: f64) -> Self {
            self.eq = Some(input);
            self
        }
        /// <p>The equal-to condition to be applied to a single field when querying for
        /// findings.</p>
        pub fn set_eq(mut self, input: std::option::Option<f64>) -> Self {
            self.eq = input;
            self
        }
        /// Consumes the builder and constructs a [`NumberFilter`](crate::model::NumberFilter)
        pub fn build(self) -> crate::model::NumberFilter {
            crate::model::NumberFilter {
                gte: self.gte.unwrap_or_default(),
                lte: self.lte.unwrap_or_default(),
                eq: self.eq.unwrap_or_default(),
            }
        }
    }
}
impl NumberFilter {
    /// Creates a new builder-style object to manufacture [`NumberFilter`](crate::model::NumberFilter)
    pub fn builder() -> crate::model::number_filter::Builder {
        crate::model::number_filter::Builder::default()
    }
}

/// <p>A keyword filter for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeywordFilter {
    /// <p>A value for the keyword.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeywordFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeywordFilter");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`KeywordFilter`](crate::model::KeywordFilter)
pub mod keyword_filter {
    /// A builder for [`KeywordFilter`](crate::model::KeywordFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value for the keyword.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value for the keyword.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`KeywordFilter`](crate::model::KeywordFilter)
        pub fn build(self) -> crate::model::KeywordFilter {
            crate::model::KeywordFilter { value: self.value }
        }
    }
}
impl KeywordFilter {
    /// Creates a new builder-style object to manufacture [`KeywordFilter`](crate::model::KeywordFilter)
    pub fn builder() -> crate::model::keyword_filter::Builder {
        crate::model::keyword_filter::Builder::default()
    }
}

/// <p>A date filter for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateFilter {
    /// <p>A start date for the date filter.</p>
    pub start: std::option::Option<std::string::String>,
    /// <p>An end date for the date filter.</p>
    pub end: std::option::Option<std::string::String>,
    /// <p>A date range for the date filter.</p>
    pub date_range: std::option::Option<crate::model::DateRange>,
}
impl std::fmt::Debug for DateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateFilter");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.field("date_range", &self.date_range);
        formatter.finish()
    }
}
/// See [`DateFilter`](crate::model::DateFilter)
pub mod date_filter {
    /// A builder for [`DateFilter`](crate::model::DateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) date_range: std::option::Option<crate::model::DateRange>,
    }
    impl Builder {
        /// <p>A start date for the date filter.</p>
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// <p>A start date for the date filter.</p>
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// <p>An end date for the date filter.</p>
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// <p>An end date for the date filter.</p>
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// <p>A date range for the date filter.</p>
        pub fn date_range(mut self, input: crate::model::DateRange) -> Self {
            self.date_range = Some(input);
            self
        }
        /// <p>A date range for the date filter.</p>
        pub fn set_date_range(
            mut self,
            input: std::option::Option<crate::model::DateRange>,
        ) -> Self {
            self.date_range = input;
            self
        }
        /// Consumes the builder and constructs a [`DateFilter`](crate::model::DateFilter)
        pub fn build(self) -> crate::model::DateFilter {
            crate::model::DateFilter {
                start: self.start,
                end: self.end,
                date_range: self.date_range,
            }
        }
    }
}
impl DateFilter {
    /// Creates a new builder-style object to manufacture [`DateFilter`](crate::model::DateFilter)
    pub fn builder() -> crate::model::date_filter::Builder {
        crate::model::date_filter::Builder::default()
    }
}

/// <p>A date range for the date filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateRange {
    /// <p>A date range value for the date filter.</p>
    pub value: i32,
    /// <p>A date range unit for the date filter.</p>
    pub unit: std::option::Option<crate::model::DateRangeUnit>,
}
impl std::fmt::Debug for DateRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateRange");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`DateRange`](crate::model::DateRange)
pub mod date_range {
    /// A builder for [`DateRange`](crate::model::DateRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i32>,
        pub(crate) unit: std::option::Option<crate::model::DateRangeUnit>,
    }
    impl Builder {
        /// <p>A date range value for the date filter.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>A date range value for the date filter.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// <p>A date range unit for the date filter.</p>
        pub fn unit(mut self, input: crate::model::DateRangeUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>A date range unit for the date filter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::DateRangeUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`DateRange`](crate::model::DateRange)
        pub fn build(self) -> crate::model::DateRange {
            crate::model::DateRange {
                value: self.value.unwrap_or_default(),
                unit: self.unit,
            }
        }
    }
}
impl DateRange {
    /// Creates a new builder-style object to manufacture [`DateRange`](crate::model::DateRange)
    pub fn builder() -> crate::model::date_range::Builder {
        crate::model::date_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DateRangeUnit {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DateRangeUnit {
    fn from(s: &str) -> Self {
        match s {
            "DAYS" => DateRangeUnit::Days,
            other => DateRangeUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DateRangeUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DateRangeUnit::from(s))
    }
}
impl DateRangeUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DateRangeUnit::Days => "DAYS",
            DateRangeUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAYS"]
    }
}
impl AsRef<str> for DateRangeUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A map filter for querying findings. Each map filter provides the field to check, the
/// value to look for, and the comparison operator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MapFilter {
    /// <p>The key of the map filter. For example, for <code>ResourceTags</code>, <code>Key</code>
    /// identifies the name of the tag. For <code>UserDefinedFields</code>, <code>Key</code> is the
    /// name of the field.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the key in the map filter. Filter values are case sensitive. For example,
    /// one of the values for a tag called <code>Department</code> might be <code>Security</code>.
    /// If you provide <code>security</code> as the filter value, then there is no match.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The condition to apply to the key value when querying for findings with a map
    /// filter.</p>
    /// <p>To search for values that exactly match the filter value, use <code>EQUALS</code>. For
    /// example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS
    /// Security</code> matches findings that have the value <code>Security</code> for the tag
    /// <code>Department</code>.</p>
    /// <p>To search for values other than the filter value, use <code>NOT_EQUALS</code>. For
    /// example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS
    /// Finance</code> matches findings that do not have the value <code>Finance</code> for the
    /// tag <code>Department</code>.</p>
    /// <p>
    /// <code>EQUALS</code> filters on the same field are joined by <code>OR</code>. A finding
    /// matches if it matches any one of those filters.</p>
    /// <p>
    /// <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code>. A
    /// finding matches only if it matches all of those filters.</p>
    /// <p>You cannot have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter
    /// on the same field.</p>
    pub comparison: std::option::Option<crate::model::MapFilterComparison>,
}
impl std::fmt::Debug for MapFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MapFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("comparison", &self.comparison);
        formatter.finish()
    }
}
/// See [`MapFilter`](crate::model::MapFilter)
pub mod map_filter {
    /// A builder for [`MapFilter`](crate::model::MapFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) comparison: std::option::Option<crate::model::MapFilterComparison>,
    }
    impl Builder {
        /// <p>The key of the map filter. For example, for <code>ResourceTags</code>, <code>Key</code>
        /// identifies the name of the tag. For <code>UserDefinedFields</code>, <code>Key</code> is the
        /// name of the field.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the map filter. For example, for <code>ResourceTags</code>, <code>Key</code>
        /// identifies the name of the tag. For <code>UserDefinedFields</code>, <code>Key</code> is the
        /// name of the field.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for the key in the map filter. Filter values are case sensitive. For example,
        /// one of the values for a tag called <code>Department</code> might be <code>Security</code>.
        /// If you provide <code>security</code> as the filter value, then there is no match.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the key in the map filter. Filter values are case sensitive. For example,
        /// one of the values for a tag called <code>Department</code> might be <code>Security</code>.
        /// If you provide <code>security</code> as the filter value, then there is no match.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The condition to apply to the key value when querying for findings with a map
        /// filter.</p>
        /// <p>To search for values that exactly match the filter value, use <code>EQUALS</code>. For
        /// example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS
        /// Security</code> matches findings that have the value <code>Security</code> for the tag
        /// <code>Department</code>.</p>
        /// <p>To search for values other than the filter value, use <code>NOT_EQUALS</code>. For
        /// example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS
        /// Finance</code> matches findings that do not have the value <code>Finance</code> for the
        /// tag <code>Department</code>.</p>
        /// <p>
        /// <code>EQUALS</code> filters on the same field are joined by <code>OR</code>. A finding
        /// matches if it matches any one of those filters.</p>
        /// <p>
        /// <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code>. A
        /// finding matches only if it matches all of those filters.</p>
        /// <p>You cannot have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter
        /// on the same field.</p>
        pub fn comparison(mut self, input: crate::model::MapFilterComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The condition to apply to the key value when querying for findings with a map
        /// filter.</p>
        /// <p>To search for values that exactly match the filter value, use <code>EQUALS</code>. For
        /// example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS
        /// Security</code> matches findings that have the value <code>Security</code> for the tag
        /// <code>Department</code>.</p>
        /// <p>To search for values other than the filter value, use <code>NOT_EQUALS</code>. For
        /// example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS
        /// Finance</code> matches findings that do not have the value <code>Finance</code> for the
        /// tag <code>Department</code>.</p>
        /// <p>
        /// <code>EQUALS</code> filters on the same field are joined by <code>OR</code>. A finding
        /// matches if it matches any one of those filters.</p>
        /// <p>
        /// <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code>. A
        /// finding matches only if it matches all of those filters.</p>
        /// <p>You cannot have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter
        /// on the same field.</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::MapFilterComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// Consumes the builder and constructs a [`MapFilter`](crate::model::MapFilter)
        pub fn build(self) -> crate::model::MapFilter {
            crate::model::MapFilter {
                key: self.key,
                value: self.value,
                comparison: self.comparison,
            }
        }
    }
}
impl MapFilter {
    /// Creates a new builder-style object to manufacture [`MapFilter`](crate::model::MapFilter)
    pub fn builder() -> crate::model::map_filter::Builder {
        crate::model::map_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MapFilterComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MapFilterComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => MapFilterComparison::Equals,
            "NOT_EQUALS" => MapFilterComparison::NotEquals,
            other => MapFilterComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MapFilterComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MapFilterComparison::from(s))
    }
}
impl MapFilterComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MapFilterComparison::Equals => "EQUALS",
            MapFilterComparison::NotEquals => "NOT_EQUALS",
            MapFilterComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS", "NOT_EQUALS"]
    }
}
impl AsRef<str> for MapFilterComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The IP filter for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpFilter {
    /// <p>A finding's CIDR value.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IpFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpFilter");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}
/// See [`IpFilter`](crate::model::IpFilter)
pub mod ip_filter {
    /// A builder for [`IpFilter`](crate::model::IpFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A finding's CIDR value.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>A finding's CIDR value.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`IpFilter`](crate::model::IpFilter)
        pub fn build(self) -> crate::model::IpFilter {
            crate::model::IpFilter { cidr: self.cidr }
        }
    }
}
impl IpFilter {
    /// Creates a new builder-style object to manufacture [`IpFilter`](crate::model::IpFilter)
    pub fn builder() -> crate::model::ip_filter::Builder {
        crate::model::ip_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RecordState::Active,
            "ARCHIVED" => RecordState::Archived,
            other => RecordState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordState::from(s))
    }
}
impl RecordState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordState::Active => "ACTIVE",
            RecordState::Archived => "ARCHIVED",
            RecordState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "ARCHIVED"]
    }
}
impl AsRef<str> for RecordState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The updated note.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoteUpdate {
    /// <p>The updated note text.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The principal that updated the note.</p>
    pub updated_by: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoteUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoteUpdate");
        formatter.field("text", &self.text);
        formatter.field("updated_by", &self.updated_by);
        formatter.finish()
    }
}
/// See [`NoteUpdate`](crate::model::NoteUpdate)
pub mod note_update {
    /// A builder for [`NoteUpdate`](crate::model::NoteUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The updated note text.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The updated note text.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The principal that updated the note.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The principal that updated the note.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// Consumes the builder and constructs a [`NoteUpdate`](crate::model::NoteUpdate)
        pub fn build(self) -> crate::model::NoteUpdate {
            crate::model::NoteUpdate {
                text: self.text,
                updated_by: self.updated_by,
            }
        }
    }
}
impl NoteUpdate {
    /// Creates a new builder-style object to manufacture [`NoteUpdate`](crate::model::NoteUpdate)
    pub fn builder() -> crate::model::note_update::Builder {
        crate::model::note_update::Builder::default()
    }
}

/// <p>Represents a Security Hub administrator account designated by an organization management
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminAccount {
    /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The current status of the Security Hub administrator account. Indicates whether the account is
    /// currently enabled as a Security Hub administrator.</p>
    pub status: std::option::Option<crate::model::AdminStatus>,
}
impl std::fmt::Debug for AdminAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AdminAccount`](crate::model::AdminAccount)
pub mod admin_account {
    /// A builder for [`AdminAccount`](crate::model::AdminAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AdminStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The current status of the Security Hub administrator account. Indicates whether the account is
        /// currently enabled as a Security Hub administrator.</p>
        pub fn status(mut self, input: crate::model::AdminStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the Security Hub administrator account. Indicates whether the account is
        /// currently enabled as a Security Hub administrator.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AdminStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminAccount`](crate::model::AdminAccount)
        pub fn build(self) -> crate::model::AdminAccount {
            crate::model::AdminAccount {
                account_id: self.account_id,
                status: self.status,
            }
        }
    }
}
impl AdminAccount {
    /// Creates a new builder-style object to manufacture [`AdminAccount`](crate::model::AdminAccount)
    pub fn builder() -> crate::model::admin_account::Builder {
        crate::model::admin_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdminStatus {
    #[allow(missing_docs)] // documentation missing in model
    DisableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdminStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE_IN_PROGRESS" => AdminStatus::DisableInProgress,
            "ENABLED" => AdminStatus::Enabled,
            other => AdminStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdminStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdminStatus::from(s))
    }
}
impl AdminStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdminStatus::DisableInProgress => "DISABLE_IN_PROGRESS",
            AdminStatus::Enabled => "ENABLED",
            AdminStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE_IN_PROGRESS", "ENABLED"]
    }
}
impl AsRef<str> for AdminStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details about a member account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The Amazon Web Services account ID of the member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The email address of the member account.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>This is replaced by <code>AdministratorID</code>.</p>
    /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
    pub master_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
    pub administrator_id: std::option::Option<std::string::String>,
    /// <p>The status of the relationship between the member account and its administrator account.
    /// </p>
    /// <p>The status can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - Indicates that the administrator account added the member account,
    /// but has not yet invited the member account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INVITED</code> - Indicates that the administrator account invited the member
    /// account. The member account has not yet responded to the invitation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENABLED</code> - Indicates that the member account is currently active. For
    /// manually invited member accounts, indicates that the member account accepted the
    /// invitation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REMOVED</code> - Indicates that the administrator account disassociated the member
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESIGNED</code> - Indicates that the member account disassociated themselves
    /// from the administrator account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - Indicates that the administrator account deleted the member
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCOUNT_SUSPENDED</code> - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.</p>
    /// </li>
    /// </ul>
    pub member_status: std::option::Option<std::string::String>,
    /// <p>A timestamp for the date and time when the invitation was sent to the member
    /// account.</p>
    pub invited_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp for the date and time when the member account was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("account_id", &self.account_id);
        formatter.field("email", &self.email);
        formatter.field("master_id", &self.master_id);
        formatter.field("administrator_id", &self.administrator_id);
        formatter.field("member_status", &self.member_status);
        formatter.field("invited_at", &self.invited_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) master_id: std::option::Option<std::string::String>,
        pub(crate) administrator_id: std::option::Option<std::string::String>,
        pub(crate) member_status: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>This is replaced by <code>AdministratorID</code>.</p>
        /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
        pub fn master_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_id = Some(input.into());
            self
        }
        /// <p>This is replaced by <code>AdministratorID</code>.</p>
        /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
        pub fn administrator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>
        pub fn set_administrator_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_id = input;
            self
        }
        /// <p>The status of the relationship between the member account and its administrator account.
        /// </p>
        /// <p>The status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - Indicates that the administrator account added the member account,
        /// but has not yet invited the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVITED</code> - Indicates that the administrator account invited the member
        /// account. The member account has not yet responded to the invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Indicates that the member account is currently active. For
        /// manually invited member accounts, indicates that the member account accepted the
        /// invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVED</code> - Indicates that the administrator account disassociated the member
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESIGNED</code> - Indicates that the member account disassociated themselves
        /// from the administrator account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - Indicates that the administrator account deleted the member
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCOUNT_SUSPENDED</code> - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.</p>
        /// </li>
        /// </ul>
        pub fn member_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_status = Some(input.into());
            self
        }
        /// <p>The status of the relationship between the member account and its administrator account.
        /// </p>
        /// <p>The status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - Indicates that the administrator account added the member account,
        /// but has not yet invited the member account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INVITED</code> - Indicates that the administrator account invited the member
        /// account. The member account has not yet responded to the invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Indicates that the member account is currently active. For
        /// manually invited member accounts, indicates that the member account accepted the
        /// invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVED</code> - Indicates that the administrator account disassociated the member
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESIGNED</code> - Indicates that the member account disassociated themselves
        /// from the administrator account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - Indicates that the administrator account deleted the member
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCOUNT_SUSPENDED</code> - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.</p>
        /// </li>
        /// </ul>
        pub fn set_member_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.member_status = input;
            self
        }
        /// <p>A timestamp for the date and time when the invitation was sent to the member
        /// account.</p>
        pub fn invited_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.invited_at = Some(input);
            self
        }
        /// <p>A timestamp for the date and time when the invitation was sent to the member
        /// account.</p>
        pub fn set_invited_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.invited_at = input;
            self
        }
        /// <p>The timestamp for the date and time when the member account was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The timestamp for the date and time when the member account was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                account_id: self.account_id,
                email: self.email,
                master_id: self.master_id,
                administrator_id: self.administrator_id,
                member_status: self.member_status,
                invited_at: self.invited_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

/// <p>Details about an invitation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Invitation {
    /// <p>The account ID of the Security Hub administrator account that the invitation was sent from.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the invitation sent to the member account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the invitation was sent.</p>
    pub invited_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the association between the member and administrator accounts.</p>
    pub member_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Invitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Invitation");
        formatter.field("account_id", &self.account_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("invited_at", &self.invited_at);
        formatter.field("member_status", &self.member_status);
        formatter.finish()
    }
}
/// See [`Invitation`](crate::model::Invitation)
pub mod invitation {
    /// A builder for [`Invitation`](crate::model::Invitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) member_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the Security Hub administrator account that the invitation was sent from.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the Security Hub administrator account that the invitation was sent from.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the invitation sent to the member account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The ID of the invitation sent to the member account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The timestamp of when the invitation was sent.</p>
        pub fn invited_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.invited_at = Some(input);
            self
        }
        /// <p>The timestamp of when the invitation was sent.</p>
        pub fn set_invited_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.invited_at = input;
            self
        }
        /// <p>The current status of the association between the member and administrator accounts.</p>
        pub fn member_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_status = Some(input.into());
            self
        }
        /// <p>The current status of the association between the member and administrator accounts.</p>
        pub fn set_member_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.member_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Invitation`](crate::model::Invitation)
        pub fn build(self) -> crate::model::Invitation {
            crate::model::Invitation {
                account_id: self.account_id,
                invitation_id: self.invitation_id,
                invited_at: self.invited_at,
                member_status: self.member_status,
            }
        }
    }
}
impl Invitation {
    /// Creates a new builder-style object to manufacture [`Invitation`](crate::model::Invitation)
    pub fn builder() -> crate::model::invitation::Builder {
        crate::model::invitation::Builder::default()
    }
}

/// <p>Details about the account that was not processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Result {
    /// <p>An Amazon Web Services account ID of the account that was not processed.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The reason that the account was not processed.</p>
    pub processing_result: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Result {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Result");
        formatter.field("account_id", &self.account_id);
        formatter.field("processing_result", &self.processing_result);
        formatter.finish()
    }
}
/// See [`Result`](crate::model::Result)
pub mod result {
    /// A builder for [`Result`](crate::model::Result)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) processing_result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Web Services account ID of the account that was not processed.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID of the account that was not processed.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The reason that the account was not processed.</p>
        pub fn processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.processing_result = Some(input.into());
            self
        }
        /// <p>The reason that the account was not processed.</p>
        pub fn set_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.processing_result = input;
            self
        }
        /// Consumes the builder and constructs a [`Result`](crate::model::Result)
        pub fn build(self) -> crate::model::Result {
            crate::model::Result {
                account_id: self.account_id,
                processing_result: self.processing_result,
            }
        }
    }
}
impl Result {
    /// Creates a new builder-style object to manufacture [`Result`](crate::model::Result)
    pub fn builder() -> crate::model::result::Builder {
        crate::model::result::Builder::default()
    }
}

/// <p>Contains information about a Security Hub insight.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Insight {
    /// <p>The ARN of a Security Hub insight.</p>
    pub insight_arn: std::option::Option<std::string::String>,
    /// <p>The name of a Security Hub insight.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more attributes used to filter the findings included in the insight. The insight
    /// only includes findings that match the criteria defined in the filters.</p>
    pub filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
    /// <p>The grouping attribute for the insight's findings. Indicates how to group the matching
    /// findings, and identifies the type of item that the insight applies to. For example, if an
    /// insight is grouped by resource identifier, then the insight produces a list of resource
    /// identifiers.</p>
    pub group_by_attribute: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Insight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Insight");
        formatter.field("insight_arn", &self.insight_arn);
        formatter.field("name", &self.name);
        formatter.field("filters", &self.filters);
        formatter.field("group_by_attribute", &self.group_by_attribute);
        formatter.finish()
    }
}
/// See [`Insight`](crate::model::Insight)
pub mod insight {
    /// A builder for [`Insight`](crate::model::Insight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        pub(crate) group_by_attribute: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a Security Hub insight.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a Security Hub insight.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_arn = input;
            self
        }
        /// <p>The name of a Security Hub insight.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a Security Hub insight.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight
        /// only includes findings that match the criteria defined in the filters.</p>
        pub fn filters(mut self, input: crate::model::AwsSecurityFindingFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>One or more attributes used to filter the findings included in the insight. The insight
        /// only includes findings that match the criteria defined in the filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::AwsSecurityFindingFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The grouping attribute for the insight's findings. Indicates how to group the matching
        /// findings, and identifies the type of item that the insight applies to. For example, if an
        /// insight is grouped by resource identifier, then the insight produces a list of resource
        /// identifiers.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_by_attribute = Some(input.into());
            self
        }
        /// <p>The grouping attribute for the insight's findings. Indicates how to group the matching
        /// findings, and identifies the type of item that the insight applies to. For example, if an
        /// insight is grouped by resource identifier, then the insight produces a list of resource
        /// identifiers.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_by_attribute = input;
            self
        }
        /// Consumes the builder and constructs a [`Insight`](crate::model::Insight)
        pub fn build(self) -> crate::model::Insight {
            crate::model::Insight {
                insight_arn: self.insight_arn,
                name: self.name,
                filters: self.filters,
                group_by_attribute: self.group_by_attribute,
            }
        }
    }
}
impl Insight {
    /// Creates a new builder-style object to manufacture [`Insight`](crate::model::Insight)
    pub fn builder() -> crate::model::insight::Builder {
        crate::model::insight::Builder::default()
    }
}

/// <p>The insight results returned by the <code>GetInsightResults</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightResults {
    /// <p>The ARN of the insight whose results are returned by the <code>GetInsightResults</code>
    /// operation.</p>
    pub insight_arn: std::option::Option<std::string::String>,
    /// <p>The attribute that the findings are grouped by for the insight whose results are
    /// returned by the <code>GetInsightResults</code> operation.</p>
    pub group_by_attribute: std::option::Option<std::string::String>,
    /// <p>The list of insight result values returned by the <code>GetInsightResults</code>
    /// operation.</p>
    pub result_values: std::option::Option<std::vec::Vec<crate::model::InsightResultValue>>,
}
impl std::fmt::Debug for InsightResults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightResults");
        formatter.field("insight_arn", &self.insight_arn);
        formatter.field("group_by_attribute", &self.group_by_attribute);
        formatter.field("result_values", &self.result_values);
        formatter.finish()
    }
}
/// See [`InsightResults`](crate::model::InsightResults)
pub mod insight_results {
    /// A builder for [`InsightResults`](crate::model::InsightResults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_arn: std::option::Option<std::string::String>,
        pub(crate) group_by_attribute: std::option::Option<std::string::String>,
        pub(crate) result_values:
            std::option::Option<std::vec::Vec<crate::model::InsightResultValue>>,
    }
    impl Builder {
        /// <p>The ARN of the insight whose results are returned by the <code>GetInsightResults</code>
        /// operation.</p>
        pub fn insight_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the insight whose results are returned by the <code>GetInsightResults</code>
        /// operation.</p>
        pub fn set_insight_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_arn = input;
            self
        }
        /// <p>The attribute that the findings are grouped by for the insight whose results are
        /// returned by the <code>GetInsightResults</code> operation.</p>
        pub fn group_by_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_by_attribute = Some(input.into());
            self
        }
        /// <p>The attribute that the findings are grouped by for the insight whose results are
        /// returned by the <code>GetInsightResults</code> operation.</p>
        pub fn set_group_by_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_by_attribute = input;
            self
        }
        /// Appends an item to `result_values`.
        ///
        /// To override the contents of this collection use [`set_result_values`](Self::set_result_values).
        ///
        /// <p>The list of insight result values returned by the <code>GetInsightResults</code>
        /// operation.</p>
        pub fn result_values(mut self, input: impl Into<crate::model::InsightResultValue>) -> Self {
            let mut v = self.result_values.unwrap_or_default();
            v.push(input.into());
            self.result_values = Some(v);
            self
        }
        /// <p>The list of insight result values returned by the <code>GetInsightResults</code>
        /// operation.</p>
        pub fn set_result_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightResultValue>>,
        ) -> Self {
            self.result_values = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightResults`](crate::model::InsightResults)
        pub fn build(self) -> crate::model::InsightResults {
            crate::model::InsightResults {
                insight_arn: self.insight_arn,
                group_by_attribute: self.group_by_attribute,
                result_values: self.result_values,
            }
        }
    }
}
impl InsightResults {
    /// Creates a new builder-style object to manufacture [`InsightResults`](crate::model::InsightResults)
    pub fn builder() -> crate::model::insight_results::Builder {
        crate::model::insight_results::Builder::default()
    }
}

/// <p>The insight result values returned by the <code>GetInsightResults</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightResultValue {
    /// <p>The value of the attribute that the findings are grouped by for the insight whose
    /// results are returned by the <code>GetInsightResults</code> operation.</p>
    pub group_by_attribute_value: std::option::Option<std::string::String>,
    /// <p>The number of findings returned for each <code>GroupByAttributeValue</code>.</p>
    pub count: i32,
}
impl std::fmt::Debug for InsightResultValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightResultValue");
        formatter.field("group_by_attribute_value", &self.group_by_attribute_value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`InsightResultValue`](crate::model::InsightResultValue)
pub mod insight_result_value {
    /// A builder for [`InsightResultValue`](crate::model::InsightResultValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_by_attribute_value: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value of the attribute that the findings are grouped by for the insight whose
        /// results are returned by the <code>GetInsightResults</code> operation.</p>
        pub fn group_by_attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_by_attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the attribute that the findings are grouped by for the insight whose
        /// results are returned by the <code>GetInsightResults</code> operation.</p>
        pub fn set_group_by_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_by_attribute_value = input;
            self
        }
        /// <p>The number of findings returned for each <code>GroupByAttributeValue</code>.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of findings returned for each <code>GroupByAttributeValue</code>.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightResultValue`](crate::model::InsightResultValue)
        pub fn build(self) -> crate::model::InsightResultValue {
            crate::model::InsightResultValue {
                group_by_attribute_value: self.group_by_attribute_value,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl InsightResultValue {
    /// Creates a new builder-style object to manufacture [`InsightResultValue`](crate::model::InsightResultValue)
    pub fn builder() -> crate::model::insight_result_value::Builder {
        crate::model::insight_result_value::Builder::default()
    }
}

/// <p>Provides consistent format for the contents of the Security Hub-aggregated findings.
/// <code>AwsSecurityFinding</code> format enables you to share findings between Amazon Web Services
/// security services and third-party solutions, and security standards checks.</p>
/// <note>
/// <p>A finding is a potential security issue generated either by Amazon Web Services services or by the integrated third-party
/// solutions and standards checks.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsSecurityFinding {
    /// <p>The schema version that a finding is formatted for.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The security findings provider-specific identifier for a finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN generated by Security Hub that uniquely identifies a product that generates findings.
    /// This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for
    /// a custom integration.</p>
    pub product_arn: std::option::Option<std::string::String>,
    /// <p>The name of the product that generated the finding.</p>
    /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
    /// <p>When you use the Security Hub console to filter findings by product name, you use this attribute.</p>
    /// <p>When you use the Security Hub API to filter findings by product name, you use the <code>aws/securityhub/ProductName</code> attribute under <code>ProductFields</code>.</p>
    /// <p>Security Hub does not synchronize those two attributes.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>The name of the company for the product that generated the finding.</p>
    /// <p>Security Hub populates this attribute automatically for each finding. You cannot be updated using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
    /// <p>When you use the Security Hub console to filter findings by company name, you use this attribute.</p>
    /// <p>When you use the Security Hub API to filter findings by company name, you use the <code>aws/securityhub/CompanyName</code> attribute under <code>ProductFields</code>.</p>
    /// <p>Security Hub does not synchronize those two attributes.</p>
    pub company_name: std::option::Option<std::string::String>,
    /// <p>The Region from which the finding was generated.</p>
    /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
    /// generated a finding. In various security-findings providers' solutions, this generator can
    /// be called a rule, a check, a detector, a plugin, etc. </p>
    pub generator_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
    /// that classify a finding.</p>
    /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
    /// Behaviors | Sensitive Data Identifications</p>
    pub types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates when the security-findings provider first observed the potential security
    /// issue that a finding captured.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub first_observed_at: std::option::Option<std::string::String>,
    /// <p>Indicates when the security-findings provider most recently observed the potential
    /// security issue that a finding captured.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub last_observed_at: std::option::Option<std::string::String>,
    /// <p>Indicates when the security-findings provider created the potential security issue that
    /// a finding captured.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>Indicates when the security-findings provider last updated the finding record.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub updated_at: std::option::Option<std::string::String>,
    /// <p>A finding's severity.</p>
    pub severity: std::option::Option<crate::model::Severity>,
    /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
    /// accurately identifies the behavior or issue that it was intended to identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub confidence: i32,
    /// <p>The level of importance assigned to the resources associated with the finding.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources.</p>
    pub criticality: i32,
    /// <p>A finding's title.</p>
    /// <note>
    /// <p>In this release, <code>Title</code> is a required property.</p>
    /// </note>
    pub title: std::option::Option<std::string::String>,
    /// <p>A finding's description.</p>
    /// <note>
    /// <p>In this release, <code>Description</code> is a required property.</p>
    /// </note>
    pub description: std::option::Option<std::string::String>,
    /// <p>A data type that describes the remediation options for a finding.</p>
    pub remediation: std::option::Option<crate::model::Remediation>,
    /// <p>A URL that links to a page about the current finding in the security-findings provider's
    /// solution.</p>
    pub source_url: std::option::Option<std::string::String>,
    /// <p>A data type where security-findings providers can include additional solution-specific
    /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
    /// <p>Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.</p>
    pub product_fields:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of name/value string pairs associated with the finding. These are custom,
    /// user-defined fields added to a finding. </p>
    pub user_defined_fields:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of malware related to a finding.</p>
    pub malware: std::option::Option<std::vec::Vec<crate::model::Malware>>,
    /// <p>The details of network-related information about a finding.</p>
    pub network: std::option::Option<crate::model::Network>,
    /// <p>Provides information about a network path that is relevant to a finding. Each entry
    /// under <code>NetworkPath</code> represents a component of that path.</p>
    pub network_path: std::option::Option<std::vec::Vec<crate::model::NetworkPathComponent>>,
    /// <p>The details of process-related information about a finding.</p>
    pub process: std::option::Option<crate::model::ProcessDetails>,
    /// <p>Threat intelligence details related to a finding.</p>
    pub threat_intel_indicators:
        std::option::Option<std::vec::Vec<crate::model::ThreatIntelIndicator>>,
    /// <p>A set of resource data types that describe the resources that the finding refers
    /// to.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>This data type is exclusive to findings that are generated as the result of a check run
    /// against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations.
    /// Contains security standard-related finding details.</p>
    pub compliance: std::option::Option<crate::model::Compliance>,
    /// <p>Indicates the veracity of a finding. </p>
    pub verification_state: std::option::Option<crate::model::VerificationState>,
    /// <p>The workflow state of a finding. </p>
    pub workflow_state: std::option::Option<crate::model::WorkflowState>,
    /// <p>Provides information about the status of the investigation into a finding.</p>
    pub workflow: std::option::Option<crate::model::Workflow>,
    /// <p>The record state of a finding.</p>
    pub record_state: std::option::Option<crate::model::RecordState>,
    /// <p>A list of related findings.</p>
    pub related_findings: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
    /// <p>A user-defined note added to a finding.</p>
    pub note: std::option::Option<crate::model::Note>,
    /// <p>Provides a list of vulnerabilities associated with the findings.</p>
    pub vulnerabilities: std::option::Option<std::vec::Vec<crate::model::Vulnerability>>,
    /// <p>Provides an overview of the patch compliance status for an instance against a selected
    /// compliance standard.</p>
    pub patch_summary: std::option::Option<crate::model::PatchSummary>,
    /// <p>Provides details about an action that affects or that was taken on a resource.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to provide and update their own values for confidence, criticality, related findings, severity, and types.</p>
    pub finding_provider_fields: std::option::Option<crate::model::FindingProviderFields>,
}
impl std::fmt::Debug for AwsSecurityFinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsSecurityFinding");
        formatter.field("schema_version", &self.schema_version);
        formatter.field("id", &self.id);
        formatter.field("product_arn", &self.product_arn);
        formatter.field("product_name", &self.product_name);
        formatter.field("company_name", &self.company_name);
        formatter.field("region", &self.region);
        formatter.field("generator_id", &self.generator_id);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("types", &self.types);
        formatter.field("first_observed_at", &self.first_observed_at);
        formatter.field("last_observed_at", &self.last_observed_at);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("severity", &self.severity);
        formatter.field("confidence", &self.confidence);
        formatter.field("criticality", &self.criticality);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("remediation", &self.remediation);
        formatter.field("source_url", &self.source_url);
        formatter.field("product_fields", &self.product_fields);
        formatter.field("user_defined_fields", &self.user_defined_fields);
        formatter.field("malware", &self.malware);
        formatter.field("network", &self.network);
        formatter.field("network_path", &self.network_path);
        formatter.field("process", &self.process);
        formatter.field("threat_intel_indicators", &self.threat_intel_indicators);
        formatter.field("resources", &self.resources);
        formatter.field("compliance", &self.compliance);
        formatter.field("verification_state", &self.verification_state);
        formatter.field("workflow_state", &self.workflow_state);
        formatter.field("workflow", &self.workflow);
        formatter.field("record_state", &self.record_state);
        formatter.field("related_findings", &self.related_findings);
        formatter.field("note", &self.note);
        formatter.field("vulnerabilities", &self.vulnerabilities);
        formatter.field("patch_summary", &self.patch_summary);
        formatter.field("action", &self.action);
        formatter.field("finding_provider_fields", &self.finding_provider_fields);
        formatter.finish()
    }
}
/// See [`AwsSecurityFinding`](crate::model::AwsSecurityFinding)
pub mod aws_security_finding {
    /// A builder for [`AwsSecurityFinding`](crate::model::AwsSecurityFinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) product_arn: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) company_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) generator_id: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) first_observed_at: std::option::Option<std::string::String>,
        pub(crate) last_observed_at: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::Severity>,
        pub(crate) confidence: std::option::Option<i32>,
        pub(crate) criticality: std::option::Option<i32>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) remediation: std::option::Option<crate::model::Remediation>,
        pub(crate) source_url: std::option::Option<std::string::String>,
        pub(crate) product_fields: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) user_defined_fields: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) malware: std::option::Option<std::vec::Vec<crate::model::Malware>>,
        pub(crate) network: std::option::Option<crate::model::Network>,
        pub(crate) network_path:
            std::option::Option<std::vec::Vec<crate::model::NetworkPathComponent>>,
        pub(crate) process: std::option::Option<crate::model::ProcessDetails>,
        pub(crate) threat_intel_indicators:
            std::option::Option<std::vec::Vec<crate::model::ThreatIntelIndicator>>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) compliance: std::option::Option<crate::model::Compliance>,
        pub(crate) verification_state: std::option::Option<crate::model::VerificationState>,
        pub(crate) workflow_state: std::option::Option<crate::model::WorkflowState>,
        pub(crate) workflow: std::option::Option<crate::model::Workflow>,
        pub(crate) record_state: std::option::Option<crate::model::RecordState>,
        pub(crate) related_findings:
            std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        pub(crate) note: std::option::Option<crate::model::Note>,
        pub(crate) vulnerabilities: std::option::Option<std::vec::Vec<crate::model::Vulnerability>>,
        pub(crate) patch_summary: std::option::Option<crate::model::PatchSummary>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) finding_provider_fields:
            std::option::Option<crate::model::FindingProviderFields>,
    }
    impl Builder {
        /// <p>The schema version that a finding is formatted for.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version that a finding is formatted for.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The security findings provider-specific identifier for a finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The security findings provider-specific identifier for a finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN generated by Security Hub that uniquely identifies a product that generates findings.
        /// This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for
        /// a custom integration.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_arn = Some(input.into());
            self
        }
        /// <p>The ARN generated by Security Hub that uniquely identifies a product that generates findings.
        /// This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for
        /// a custom integration.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_arn = input;
            self
        }
        /// <p>The name of the product that generated the finding.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
        /// <p>When you use the Security Hub console to filter findings by product name, you use this attribute.</p>
        /// <p>When you use the Security Hub API to filter findings by product name, you use the <code>aws/securityhub/ProductName</code> attribute under <code>ProductFields</code>.</p>
        /// <p>Security Hub does not synchronize those two attributes.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>The name of the product that generated the finding.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
        /// <p>When you use the Security Hub console to filter findings by product name, you use this attribute.</p>
        /// <p>When you use the Security Hub API to filter findings by product name, you use the <code>aws/securityhub/ProductName</code> attribute under <code>ProductFields</code>.</p>
        /// <p>Security Hub does not synchronize those two attributes.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>The name of the company for the product that generated the finding.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot be updated using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
        /// <p>When you use the Security Hub console to filter findings by company name, you use this attribute.</p>
        /// <p>When you use the Security Hub API to filter findings by company name, you use the <code>aws/securityhub/CompanyName</code> attribute under <code>ProductFields</code>.</p>
        /// <p>Security Hub does not synchronize those two attributes.</p>
        pub fn company_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.company_name = Some(input.into());
            self
        }
        /// <p>The name of the company for the product that generated the finding.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot be updated using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is when you use a custom integration.</p>
        /// <p>When you use the Security Hub console to filter findings by company name, you use this attribute.</p>
        /// <p>When you use the Security Hub API to filter findings by company name, you use the <code>aws/securityhub/CompanyName</code> attribute under <code>ProductFields</code>.</p>
        /// <p>Security Hub does not synchronize those two attributes.</p>
        pub fn set_company_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.company_name = input;
            self
        }
        /// <p>The Region from which the finding was generated.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region from which the finding was generated.</p>
        /// <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
        /// generated a finding. In various security-findings providers' solutions, this generator can
        /// be called a rule, a check, a detector, a plugin, etc. </p>
        pub fn generator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generator_id = Some(input.into());
            self
        }
        /// <p>The identifier for the solution-specific component (a discrete unit of logic) that
        /// generated a finding. In various security-findings providers' solutions, this generator can
        /// be called a rule, a check, a detector, a plugin, etc. </p>
        pub fn set_generator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.generator_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that a finding is generated in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// <p>Indicates when the security-findings provider first observed the potential security
        /// issue that a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn first_observed_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_observed_at = Some(input.into());
            self
        }
        /// <p>Indicates when the security-findings provider first observed the potential security
        /// issue that a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_first_observed_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_observed_at = input;
            self
        }
        /// <p>Indicates when the security-findings provider most recently observed the potential
        /// security issue that a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn last_observed_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_observed_at = Some(input.into());
            self
        }
        /// <p>Indicates when the security-findings provider most recently observed the potential
        /// security issue that a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_last_observed_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_observed_at = input;
            self
        }
        /// <p>Indicates when the security-findings provider created the potential security issue that
        /// a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>Indicates when the security-findings provider created the potential security issue that
        /// a finding captured.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Indicates when the security-findings provider last updated the finding record.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn updated_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_at = Some(input.into());
            self
        }
        /// <p>Indicates when the security-findings provider last updated the finding record.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_updated_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>A finding's severity.</p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>A finding's severity.</p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn confidence(mut self, input: i32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<i32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn criticality(mut self, input: i32) -> Self {
            self.criticality = Some(input);
            self
        }
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn set_criticality(mut self, input: std::option::Option<i32>) -> Self {
            self.criticality = input;
            self
        }
        /// <p>A finding's title.</p>
        /// <note>
        /// <p>In this release, <code>Title</code> is a required property.</p>
        /// </note>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A finding's title.</p>
        /// <note>
        /// <p>In this release, <code>Title</code> is a required property.</p>
        /// </note>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>A finding's description.</p>
        /// <note>
        /// <p>In this release, <code>Description</code> is a required property.</p>
        /// </note>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A finding's description.</p>
        /// <note>
        /// <p>In this release, <code>Description</code> is a required property.</p>
        /// </note>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A data type that describes the remediation options for a finding.</p>
        pub fn remediation(mut self, input: crate::model::Remediation) -> Self {
            self.remediation = Some(input);
            self
        }
        /// <p>A data type that describes the remediation options for a finding.</p>
        pub fn set_remediation(
            mut self,
            input: std::option::Option<crate::model::Remediation>,
        ) -> Self {
            self.remediation = input;
            self
        }
        /// <p>A URL that links to a page about the current finding in the security-findings provider's
        /// solution.</p>
        pub fn source_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_url = Some(input.into());
            self
        }
        /// <p>A URL that links to a page about the current finding in the security-findings provider's
        /// solution.</p>
        pub fn set_source_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_url = input;
            self
        }
        /// Adds a key-value pair to `product_fields`.
        ///
        /// To override the contents of this collection use [`set_product_fields`](Self::set_product_fields).
        ///
        /// <p>A data type where security-findings providers can include additional solution-specific
        /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
        /// <p>Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.</p>
        pub fn product_fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.product_fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.product_fields = Some(hash_map);
            self
        }
        /// <p>A data type where security-findings providers can include additional solution-specific
        /// details that aren't part of the defined <code>AwsSecurityFinding</code> format.</p>
        /// <p>Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.</p>
        pub fn set_product_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.product_fields = input;
            self
        }
        /// Adds a key-value pair to `user_defined_fields`.
        ///
        /// To override the contents of this collection use [`set_user_defined_fields`](Self::set_user_defined_fields).
        ///
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding. </p>
        pub fn user_defined_fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_defined_fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_defined_fields = Some(hash_map);
            self
        }
        /// <p>A list of name/value string pairs associated with the finding. These are custom,
        /// user-defined fields added to a finding. </p>
        pub fn set_user_defined_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_defined_fields = input;
            self
        }
        /// Appends an item to `malware`.
        ///
        /// To override the contents of this collection use [`set_malware`](Self::set_malware).
        ///
        /// <p>A list of malware related to a finding.</p>
        pub fn malware(mut self, input: impl Into<crate::model::Malware>) -> Self {
            let mut v = self.malware.unwrap_or_default();
            v.push(input.into());
            self.malware = Some(v);
            self
        }
        /// <p>A list of malware related to a finding.</p>
        pub fn set_malware(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Malware>>,
        ) -> Self {
            self.malware = input;
            self
        }
        /// <p>The details of network-related information about a finding.</p>
        pub fn network(mut self, input: crate::model::Network) -> Self {
            self.network = Some(input);
            self
        }
        /// <p>The details of network-related information about a finding.</p>
        pub fn set_network(mut self, input: std::option::Option<crate::model::Network>) -> Self {
            self.network = input;
            self
        }
        /// Appends an item to `network_path`.
        ///
        /// To override the contents of this collection use [`set_network_path`](Self::set_network_path).
        ///
        /// <p>Provides information about a network path that is relevant to a finding. Each entry
        /// under <code>NetworkPath</code> represents a component of that path.</p>
        pub fn network_path(
            mut self,
            input: impl Into<crate::model::NetworkPathComponent>,
        ) -> Self {
            let mut v = self.network_path.unwrap_or_default();
            v.push(input.into());
            self.network_path = Some(v);
            self
        }
        /// <p>Provides information about a network path that is relevant to a finding. Each entry
        /// under <code>NetworkPath</code> represents a component of that path.</p>
        pub fn set_network_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkPathComponent>>,
        ) -> Self {
            self.network_path = input;
            self
        }
        /// <p>The details of process-related information about a finding.</p>
        pub fn process(mut self, input: crate::model::ProcessDetails) -> Self {
            self.process = Some(input);
            self
        }
        /// <p>The details of process-related information about a finding.</p>
        pub fn set_process(
            mut self,
            input: std::option::Option<crate::model::ProcessDetails>,
        ) -> Self {
            self.process = input;
            self
        }
        /// Appends an item to `threat_intel_indicators`.
        ///
        /// To override the contents of this collection use [`set_threat_intel_indicators`](Self::set_threat_intel_indicators).
        ///
        /// <p>Threat intelligence details related to a finding.</p>
        pub fn threat_intel_indicators(
            mut self,
            input: impl Into<crate::model::ThreatIntelIndicator>,
        ) -> Self {
            let mut v = self.threat_intel_indicators.unwrap_or_default();
            v.push(input.into());
            self.threat_intel_indicators = Some(v);
            self
        }
        /// <p>Threat intelligence details related to a finding.</p>
        pub fn set_threat_intel_indicators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThreatIntelIndicator>>,
        ) -> Self {
            self.threat_intel_indicators = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A set of resource data types that describe the resources that the finding refers
        /// to.</p>
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>A set of resource data types that describe the resources that the finding refers
        /// to.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>This data type is exclusive to findings that are generated as the result of a check run
        /// against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations.
        /// Contains security standard-related finding details.</p>
        pub fn compliance(mut self, input: crate::model::Compliance) -> Self {
            self.compliance = Some(input);
            self
        }
        /// <p>This data type is exclusive to findings that are generated as the result of a check run
        /// against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations.
        /// Contains security standard-related finding details.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<crate::model::Compliance>,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// <p>Indicates the veracity of a finding. </p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.verification_state = Some(input);
            self
        }
        /// <p>Indicates the veracity of a finding. </p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.verification_state = input;
            self
        }
        /// <p>The workflow state of a finding. </p>
        pub fn workflow_state(mut self, input: crate::model::WorkflowState) -> Self {
            self.workflow_state = Some(input);
            self
        }
        /// <p>The workflow state of a finding. </p>
        pub fn set_workflow_state(
            mut self,
            input: std::option::Option<crate::model::WorkflowState>,
        ) -> Self {
            self.workflow_state = input;
            self
        }
        /// <p>Provides information about the status of the investigation into a finding.</p>
        pub fn workflow(mut self, input: crate::model::Workflow) -> Self {
            self.workflow = Some(input);
            self
        }
        /// <p>Provides information about the status of the investigation into a finding.</p>
        pub fn set_workflow(mut self, input: std::option::Option<crate::model::Workflow>) -> Self {
            self.workflow = input;
            self
        }
        /// <p>The record state of a finding.</p>
        pub fn record_state(mut self, input: crate::model::RecordState) -> Self {
            self.record_state = Some(input);
            self
        }
        /// <p>The record state of a finding.</p>
        pub fn set_record_state(
            mut self,
            input: std::option::Option<crate::model::RecordState>,
        ) -> Self {
            self.record_state = input;
            self
        }
        /// Appends an item to `related_findings`.
        ///
        /// To override the contents of this collection use [`set_related_findings`](Self::set_related_findings).
        ///
        /// <p>A list of related findings.</p>
        pub fn related_findings(mut self, input: impl Into<crate::model::RelatedFinding>) -> Self {
            let mut v = self.related_findings.unwrap_or_default();
            v.push(input.into());
            self.related_findings = Some(v);
            self
        }
        /// <p>A list of related findings.</p>
        pub fn set_related_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        ) -> Self {
            self.related_findings = input;
            self
        }
        /// <p>A user-defined note added to a finding.</p>
        pub fn note(mut self, input: crate::model::Note) -> Self {
            self.note = Some(input);
            self
        }
        /// <p>A user-defined note added to a finding.</p>
        pub fn set_note(mut self, input: std::option::Option<crate::model::Note>) -> Self {
            self.note = input;
            self
        }
        /// Appends an item to `vulnerabilities`.
        ///
        /// To override the contents of this collection use [`set_vulnerabilities`](Self::set_vulnerabilities).
        ///
        /// <p>Provides a list of vulnerabilities associated with the findings.</p>
        pub fn vulnerabilities(mut self, input: impl Into<crate::model::Vulnerability>) -> Self {
            let mut v = self.vulnerabilities.unwrap_or_default();
            v.push(input.into());
            self.vulnerabilities = Some(v);
            self
        }
        /// <p>Provides a list of vulnerabilities associated with the findings.</p>
        pub fn set_vulnerabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Vulnerability>>,
        ) -> Self {
            self.vulnerabilities = input;
            self
        }
        /// <p>Provides an overview of the patch compliance status for an instance against a selected
        /// compliance standard.</p>
        pub fn patch_summary(mut self, input: crate::model::PatchSummary) -> Self {
            self.patch_summary = Some(input);
            self
        }
        /// <p>Provides an overview of the patch compliance status for an instance against a selected
        /// compliance standard.</p>
        pub fn set_patch_summary(
            mut self,
            input: std::option::Option<crate::model::PatchSummary>,
        ) -> Self {
            self.patch_summary = input;
            self
        }
        /// <p>Provides details about an action that affects or that was taken on a resource.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Provides details about an action that affects or that was taken on a resource.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to provide and update their own values for confidence, criticality, related findings, severity, and types.</p>
        pub fn finding_provider_fields(
            mut self,
            input: crate::model::FindingProviderFields,
        ) -> Self {
            self.finding_provider_fields = Some(input);
            self
        }
        /// <p>In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to provide and update their own values for confidence, criticality, related findings, severity, and types.</p>
        pub fn set_finding_provider_fields(
            mut self,
            input: std::option::Option<crate::model::FindingProviderFields>,
        ) -> Self {
            self.finding_provider_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsSecurityFinding`](crate::model::AwsSecurityFinding)
        pub fn build(self) -> crate::model::AwsSecurityFinding {
            crate::model::AwsSecurityFinding {
                schema_version: self.schema_version,
                id: self.id,
                product_arn: self.product_arn,
                product_name: self.product_name,
                company_name: self.company_name,
                region: self.region,
                generator_id: self.generator_id,
                aws_account_id: self.aws_account_id,
                types: self.types,
                first_observed_at: self.first_observed_at,
                last_observed_at: self.last_observed_at,
                created_at: self.created_at,
                updated_at: self.updated_at,
                severity: self.severity,
                confidence: self.confidence.unwrap_or_default(),
                criticality: self.criticality.unwrap_or_default(),
                title: self.title,
                description: self.description,
                remediation: self.remediation,
                source_url: self.source_url,
                product_fields: self.product_fields,
                user_defined_fields: self.user_defined_fields,
                malware: self.malware,
                network: self.network,
                network_path: self.network_path,
                process: self.process,
                threat_intel_indicators: self.threat_intel_indicators,
                resources: self.resources,
                compliance: self.compliance,
                verification_state: self.verification_state,
                workflow_state: self.workflow_state,
                workflow: self.workflow,
                record_state: self.record_state,
                related_findings: self.related_findings,
                note: self.note,
                vulnerabilities: self.vulnerabilities,
                patch_summary: self.patch_summary,
                action: self.action,
                finding_provider_fields: self.finding_provider_fields,
            }
        }
    }
}
impl AwsSecurityFinding {
    /// Creates a new builder-style object to manufacture [`AwsSecurityFinding`](crate::model::AwsSecurityFinding)
    pub fn builder() -> crate::model::aws_security_finding::Builder {
        crate::model::aws_security_finding::Builder::default()
    }
}

/// <p>In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to provide and update values for confidence, criticality, related findings, severity, and types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingProviderFields {
    /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
    /// accurately identifies the behavior or issue that it was intended to identify.</p>
    /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
    /// confidence and 100 means 100 percent confidence.</p>
    pub confidence: i32,
    /// <p>The level of importance assigned to the resources associated with the finding.</p>
    /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
    /// is reserved for the most critical resources.</p>
    pub criticality: i32,
    /// <p>A list of findings that are related to the current finding.</p>
    pub related_findings: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
    /// <p>The severity of a finding.</p>
    pub severity: std::option::Option<crate::model::FindingProviderSeverity>,
    /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
    /// that classify a finding.</p>
    /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
    /// Behaviors | Sensitive Data Identifications</p>
    pub types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for FindingProviderFields {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingProviderFields");
        formatter.field("confidence", &self.confidence);
        formatter.field("criticality", &self.criticality);
        formatter.field("related_findings", &self.related_findings);
        formatter.field("severity", &self.severity);
        formatter.field("types", &self.types);
        formatter.finish()
    }
}
/// See [`FindingProviderFields`](crate::model::FindingProviderFields)
pub mod finding_provider_fields {
    /// A builder for [`FindingProviderFields`](crate::model::FindingProviderFields)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confidence: std::option::Option<i32>,
        pub(crate) criticality: std::option::Option<i32>,
        pub(crate) related_findings:
            std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        pub(crate) severity: std::option::Option<crate::model::FindingProviderSeverity>,
        pub(crate) types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn confidence(mut self, input: i32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A finding's confidence. Confidence is defined as the likelihood that a finding
        /// accurately identifies the behavior or issue that it was intended to identify.</p>
        /// <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent
        /// confidence and 100 means 100 percent confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<i32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn criticality(mut self, input: i32) -> Self {
            self.criticality = Some(input);
            self
        }
        /// <p>The level of importance assigned to the resources associated with the finding.</p>
        /// <p>A score of 0 means that the underlying resources have no criticality, and a score of 100
        /// is reserved for the most critical resources.</p>
        pub fn set_criticality(mut self, input: std::option::Option<i32>) -> Self {
            self.criticality = input;
            self
        }
        /// Appends an item to `related_findings`.
        ///
        /// To override the contents of this collection use [`set_related_findings`](Self::set_related_findings).
        ///
        /// <p>A list of findings that are related to the current finding.</p>
        pub fn related_findings(mut self, input: impl Into<crate::model::RelatedFinding>) -> Self {
            let mut v = self.related_findings.unwrap_or_default();
            v.push(input.into());
            self.related_findings = Some(v);
            self
        }
        /// <p>A list of findings that are related to the current finding.</p>
        pub fn set_related_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedFinding>>,
        ) -> Self {
            self.related_findings = input;
            self
        }
        /// <p>The severity of a finding.</p>
        pub fn severity(mut self, input: crate::model::FindingProviderSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of a finding.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::FindingProviderSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>One or more finding types in the format of <code>namespace/category/classifier</code>
        /// that classify a finding.</p>
        /// <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual
        /// Behaviors | Sensitive Data Identifications</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingProviderFields`](crate::model::FindingProviderFields)
        pub fn build(self) -> crate::model::FindingProviderFields {
            crate::model::FindingProviderFields {
                confidence: self.confidence.unwrap_or_default(),
                criticality: self.criticality.unwrap_or_default(),
                related_findings: self.related_findings,
                severity: self.severity,
                types: self.types,
            }
        }
    }
}
impl FindingProviderFields {
    /// Creates a new builder-style object to manufacture [`FindingProviderFields`](crate::model::FindingProviderFields)
    pub fn builder() -> crate::model::finding_provider_fields::Builder {
        crate::model::finding_provider_fields::Builder::default()
    }
}

/// <p>The severity assigned to the finding by the finding provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingProviderSeverity {
    /// <p>The severity label assigned to the finding by the finding provider.</p>
    pub label: std::option::Option<crate::model::SeverityLabel>,
    /// <p>The finding provider's original value for the severity.</p>
    pub original: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FindingProviderSeverity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingProviderSeverity");
        formatter.field("label", &self.label);
        formatter.field("original", &self.original);
        formatter.finish()
    }
}
/// See [`FindingProviderSeverity`](crate::model::FindingProviderSeverity)
pub mod finding_provider_severity {
    /// A builder for [`FindingProviderSeverity`](crate::model::FindingProviderSeverity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label: std::option::Option<crate::model::SeverityLabel>,
        pub(crate) original: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The severity label assigned to the finding by the finding provider.</p>
        pub fn label(mut self, input: crate::model::SeverityLabel) -> Self {
            self.label = Some(input);
            self
        }
        /// <p>The severity label assigned to the finding by the finding provider.</p>
        pub fn set_label(
            mut self,
            input: std::option::Option<crate::model::SeverityLabel>,
        ) -> Self {
            self.label = input;
            self
        }
        /// <p>The finding provider's original value for the severity.</p>
        pub fn original(mut self, input: impl Into<std::string::String>) -> Self {
            self.original = Some(input.into());
            self
        }
        /// <p>The finding provider's original value for the severity.</p>
        pub fn set_original(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.original = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingProviderSeverity`](crate::model::FindingProviderSeverity)
        pub fn build(self) -> crate::model::FindingProviderSeverity {
            crate::model::FindingProviderSeverity {
                label: self.label,
                original: self.original,
            }
        }
    }
}
impl FindingProviderSeverity {
    /// Creates a new builder-style object to manufacture [`FindingProviderSeverity`](crate::model::FindingProviderSeverity)
    pub fn builder() -> crate::model::finding_provider_severity::Builder {
        crate::model::finding_provider_severity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SeverityLabel {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Informational,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SeverityLabel {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => SeverityLabel::Critical,
            "HIGH" => SeverityLabel::High,
            "INFORMATIONAL" => SeverityLabel::Informational,
            "LOW" => SeverityLabel::Low,
            "MEDIUM" => SeverityLabel::Medium,
            other => SeverityLabel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SeverityLabel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SeverityLabel::from(s))
    }
}
impl SeverityLabel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SeverityLabel::Critical => "CRITICAL",
            SeverityLabel::High => "HIGH",
            SeverityLabel::Informational => "INFORMATIONAL",
            SeverityLabel::Low => "LOW",
            SeverityLabel::Medium => "MEDIUM",
            SeverityLabel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRITICAL", "HIGH", "INFORMATIONAL", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for SeverityLabel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a related finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedFinding {
    /// <p>The ARN of the product that generated a related finding.</p>
    pub product_arn: std::option::Option<std::string::String>,
    /// <p>The product-generated identifier for a related finding.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelatedFinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedFinding");
        formatter.field("product_arn", &self.product_arn);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`RelatedFinding`](crate::model::RelatedFinding)
pub mod related_finding {
    /// A builder for [`RelatedFinding`](crate::model::RelatedFinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the product that generated a related finding.</p>
        pub fn product_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the product that generated a related finding.</p>
        pub fn set_product_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_arn = input;
            self
        }
        /// <p>The product-generated identifier for a related finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The product-generated identifier for a related finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedFinding`](crate::model::RelatedFinding)
        pub fn build(self) -> crate::model::RelatedFinding {
            crate::model::RelatedFinding {
                product_arn: self.product_arn,
                id: self.id,
            }
        }
    }
}
impl RelatedFinding {
    /// Creates a new builder-style object to manufacture [`RelatedFinding`](crate::model::RelatedFinding)
    pub fn builder() -> crate::model::related_finding::Builder {
        crate::model::related_finding::Builder::default()
    }
}

/// <p>Provides details about one of the following actions that affects or that was taken on a resource:</p>
/// <ul>
/// <li>
/// <p>A remote IP address issued an Amazon Web Services API call</p>
/// </li>
/// <li>
/// <p>A DNS request was received</p>
/// </li>
/// <li>
/// <p>A remote IP address attempted to connect to an EC2 instance</p>
/// </li>
/// <li>
/// <p>A remote IP address attempted a port probe on an EC2 instance</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>The type of action that was detected. The possible action types are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NETWORK_CONNECTION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AWS_API_CALL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DNS_REQUEST</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PORT_PROBE</code>
    /// </p>
    /// </li>
    /// </ul>
    pub action_type: std::option::Option<std::string::String>,
    /// <p>Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details
    /// about the network connection that was detected.</p>
    pub network_connection_action: std::option::Option<crate::model::NetworkConnectionAction>,
    /// <p>Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about
    /// the API call that was detected. </p>
    pub aws_api_call_action: std::option::Option<crate::model::AwsApiCallAction>,
    /// <p>Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about
    /// the DNS request that was detected. </p>
    pub dns_request_action: std::option::Option<crate::model::DnsRequestAction>,
    /// <p>Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about
    /// the port probe that was detected. </p>
    pub port_probe_action: std::option::Option<crate::model::PortProbeAction>,
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("action_type", &self.action_type);
        formatter.field("network_connection_action", &self.network_connection_action);
        formatter.field("aws_api_call_action", &self.aws_api_call_action);
        formatter.field("dns_request_action", &self.dns_request_action);
        formatter.field("port_probe_action", &self.port_probe_action);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<std::string::String>,
        pub(crate) network_connection_action:
            std::option::Option<crate::model::NetworkConnectionAction>,
        pub(crate) aws_api_call_action: std::option::Option<crate::model::AwsApiCallAction>,
        pub(crate) dns_request_action: std::option::Option<crate::model::DnsRequestAction>,
        pub(crate) port_probe_action: std::option::Option<crate::model::PortProbeAction>,
    }
    impl Builder {
        /// <p>The type of action that was detected. The possible action types are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NETWORK_CONNECTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_API_CALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DNS_REQUEST</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PORT_PROBE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn action_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_type = Some(input.into());
            self
        }
        /// <p>The type of action that was detected. The possible action types are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NETWORK_CONNECTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS_API_CALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DNS_REQUEST</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PORT_PROBE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_action_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_type = input;
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details
        /// about the network connection that was detected.</p>
        pub fn network_connection_action(
            mut self,
            input: crate::model::NetworkConnectionAction,
        ) -> Self {
            self.network_connection_action = Some(input);
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details
        /// about the network connection that was detected.</p>
        pub fn set_network_connection_action(
            mut self,
            input: std::option::Option<crate::model::NetworkConnectionAction>,
        ) -> Self {
            self.network_connection_action = input;
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about
        /// the API call that was detected. </p>
        pub fn aws_api_call_action(mut self, input: crate::model::AwsApiCallAction) -> Self {
            self.aws_api_call_action = Some(input);
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about
        /// the API call that was detected. </p>
        pub fn set_aws_api_call_action(
            mut self,
            input: std::option::Option<crate::model::AwsApiCallAction>,
        ) -> Self {
            self.aws_api_call_action = input;
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about
        /// the DNS request that was detected. </p>
        pub fn dns_request_action(mut self, input: crate::model::DnsRequestAction) -> Self {
            self.dns_request_action = Some(input);
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about
        /// the DNS request that was detected. </p>
        pub fn set_dns_request_action(
            mut self,
            input: std::option::Option<crate::model::DnsRequestAction>,
        ) -> Self {
            self.dns_request_action = input;
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about
        /// the port probe that was detected. </p>
        pub fn port_probe_action(mut self, input: crate::model::PortProbeAction) -> Self {
            self.port_probe_action = Some(input);
            self
        }
        /// <p>Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about
        /// the port probe that was detected. </p>
        pub fn set_port_probe_action(
            mut self,
            input: std::option::Option<crate::model::PortProbeAction>,
        ) -> Self {
            self.port_probe_action = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                action_type: self.action_type,
                network_connection_action: self.network_connection_action,
                aws_api_call_action: self.aws_api_call_action,
                dns_request_action: self.dns_request_action,
                port_probe_action: self.port_probe_action,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Provided if <code>ActionType</code> is <code>PORT_PROBE</code>. It provides details
/// about the attempted port probe that was detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortProbeAction {
    /// <p>Information about the ports affected by the port probe.</p>
    pub port_probe_details: std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
    /// <p>Indicates whether the port probe was blocked.</p>
    pub blocked: bool,
}
impl std::fmt::Debug for PortProbeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortProbeAction");
        formatter.field("port_probe_details", &self.port_probe_details);
        formatter.field("blocked", &self.blocked);
        formatter.finish()
    }
}
/// See [`PortProbeAction`](crate::model::PortProbeAction)
pub mod port_probe_action {
    /// A builder for [`PortProbeAction`](crate::model::PortProbeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port_probe_details:
            std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
        pub(crate) blocked: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `port_probe_details`.
        ///
        /// To override the contents of this collection use [`set_port_probe_details`](Self::set_port_probe_details).
        ///
        /// <p>Information about the ports affected by the port probe.</p>
        pub fn port_probe_details(
            mut self,
            input: impl Into<crate::model::PortProbeDetail>,
        ) -> Self {
            let mut v = self.port_probe_details.unwrap_or_default();
            v.push(input.into());
            self.port_probe_details = Some(v);
            self
        }
        /// <p>Information about the ports affected by the port probe.</p>
        pub fn set_port_probe_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
        ) -> Self {
            self.port_probe_details = input;
            self
        }
        /// <p>Indicates whether the port probe was blocked.</p>
        pub fn blocked(mut self, input: bool) -> Self {
            self.blocked = Some(input);
            self
        }
        /// <p>Indicates whether the port probe was blocked.</p>
        pub fn set_blocked(mut self, input: std::option::Option<bool>) -> Self {
            self.blocked = input;
            self
        }
        /// Consumes the builder and constructs a [`PortProbeAction`](crate::model::PortProbeAction)
        pub fn build(self) -> crate::model::PortProbeAction {
            crate::model::PortProbeAction {
                port_probe_details: self.port_probe_details,
                blocked: self.blocked.unwrap_or_default(),
            }
        }
    }
}
impl PortProbeAction {
    /// Creates a new builder-style object to manufacture [`PortProbeAction`](crate::model::PortProbeAction)
    pub fn builder() -> crate::model::port_probe_action::Builder {
        crate::model::port_probe_action::Builder::default()
    }
}

/// <p>A port scan that was part of the port probe. For each scan, PortProbeDetails provides
/// information about the local IP address and port that were scanned, and the remote IP
/// address that the scan originated from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortProbeDetail {
    /// <p>Provides information about the port that was scanned.</p>
    pub local_port_details: std::option::Option<crate::model::ActionLocalPortDetails>,
    /// <p>Provides information about the IP address where the scanned port is located.</p>
    pub local_ip_details: std::option::Option<crate::model::ActionLocalIpDetails>,
    /// <p>Provides information about the remote IP address that performed the scan.</p>
    pub remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
}
impl std::fmt::Debug for PortProbeDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortProbeDetail");
        formatter.field("local_port_details", &self.local_port_details);
        formatter.field("local_ip_details", &self.local_ip_details);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.finish()
    }
}
/// See [`PortProbeDetail`](crate::model::PortProbeDetail)
pub mod port_probe_detail {
    /// A builder for [`PortProbeDetail`](crate::model::PortProbeDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_port_details: std::option::Option<crate::model::ActionLocalPortDetails>,
        pub(crate) local_ip_details: std::option::Option<crate::model::ActionLocalIpDetails>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
    }
    impl Builder {
        /// <p>Provides information about the port that was scanned.</p>
        pub fn local_port_details(mut self, input: crate::model::ActionLocalPortDetails) -> Self {
            self.local_port_details = Some(input);
            self
        }
        /// <p>Provides information about the port that was scanned.</p>
        pub fn set_local_port_details(
            mut self,
            input: std::option::Option<crate::model::ActionLocalPortDetails>,
        ) -> Self {
            self.local_port_details = input;
            self
        }
        /// <p>Provides information about the IP address where the scanned port is located.</p>
        pub fn local_ip_details(mut self, input: crate::model::ActionLocalIpDetails) -> Self {
            self.local_ip_details = Some(input);
            self
        }
        /// <p>Provides information about the IP address where the scanned port is located.</p>
        pub fn set_local_ip_details(
            mut self,
            input: std::option::Option<crate::model::ActionLocalIpDetails>,
        ) -> Self {
            self.local_ip_details = input;
            self
        }
        /// <p>Provides information about the remote IP address that performed the scan.</p>
        pub fn remote_ip_details(mut self, input: crate::model::ActionRemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>Provides information about the remote IP address that performed the scan.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::ActionRemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PortProbeDetail`](crate::model::PortProbeDetail)
        pub fn build(self) -> crate::model::PortProbeDetail {
            crate::model::PortProbeDetail {
                local_port_details: self.local_port_details,
                local_ip_details: self.local_ip_details,
                remote_ip_details: self.remote_ip_details,
            }
        }
    }
}
impl PortProbeDetail {
    /// Creates a new builder-style object to manufacture [`PortProbeDetail`](crate::model::PortProbeDetail)
    pub fn builder() -> crate::model::port_probe_detail::Builder {
        crate::model::port_probe_detail::Builder::default()
    }
}

/// <p>For <code>AwsApiAction</code>, <code>NetworkConnectionAction</code>, and
/// <code>PortProbeAction</code>, <code>RemoteIpDetails</code> provides information about
/// the remote IP address that was involved in the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionRemoteIpDetails {
    /// <p>The IP address.</p>
    pub ip_address_v4: std::option::Option<std::string::String>,
    /// <p>The internet service provider (ISP) organization associated with the remote IP
    /// address.</p>
    pub organization: std::option::Option<crate::model::IpOrganizationDetails>,
    /// <p>The country where the remote IP address is located.</p>
    pub country: std::option::Option<crate::model::Country>,
    /// <p>The city where the remote IP address is located.</p>
    pub city: std::option::Option<crate::model::City>,
    /// <p>The coordinates of the location of the remote IP address.</p>
    pub geo_location: std::option::Option<crate::model::GeoLocation>,
}
impl std::fmt::Debug for ActionRemoteIpDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionRemoteIpDetails");
        formatter.field("ip_address_v4", &self.ip_address_v4);
        formatter.field("organization", &self.organization);
        formatter.field("country", &self.country);
        formatter.field("city", &self.city);
        formatter.field("geo_location", &self.geo_location);
        formatter.finish()
    }
}
/// See [`ActionRemoteIpDetails`](crate::model::ActionRemoteIpDetails)
pub mod action_remote_ip_details {
    /// A builder for [`ActionRemoteIpDetails`](crate::model::ActionRemoteIpDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address_v4: std::option::Option<std::string::String>,
        pub(crate) organization: std::option::Option<crate::model::IpOrganizationDetails>,
        pub(crate) country: std::option::Option<crate::model::Country>,
        pub(crate) city: std::option::Option<crate::model::City>,
        pub(crate) geo_location: std::option::Option<crate::model::GeoLocation>,
    }
    impl Builder {
        /// <p>The IP address.</p>
        pub fn ip_address_v4(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address_v4 = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_ip_address_v4(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_address_v4 = input;
            self
        }
        /// <p>The internet service provider (ISP) organization associated with the remote IP
        /// address.</p>
        pub fn organization(mut self, input: crate::model::IpOrganizationDetails) -> Self {
            self.organization = Some(input);
            self
        }
        /// <p>The internet service provider (ISP) organization associated with the remote IP
        /// address.</p>
        pub fn set_organization(
            mut self,
            input: std::option::Option<crate::model::IpOrganizationDetails>,
        ) -> Self {
            self.organization = input;
            self
        }
        /// <p>The country where the remote IP address is located.</p>
        pub fn country(mut self, input: crate::model::Country) -> Self {
            self.country = Some(input);
            self
        }
        /// <p>The country where the remote IP address is located.</p>
        pub fn set_country(mut self, input: std::option::Option<crate::model::Country>) -> Self {
            self.country = input;
            self
        }
        /// <p>The city where the remote IP address is located.</p>
        pub fn city(mut self, input: crate::model::City) -> Self {
            self.city = Some(input);
            self
        }
        /// <p>The city where the remote IP address is located.</p>
        pub fn set_city(mut self, input: std::option::Option<crate::model::City>) -> Self {
            self.city = input;
            self
        }
        /// <p>The coordinates of the location of the remote IP address.</p>
        pub fn geo_location(mut self, input: crate::model::GeoLocation) -> Self {
            self.geo_location = Some(input);
            self
        }
        /// <p>The coordinates of the location of the remote IP address.</p>
        pub fn set_geo_location(
            mut self,
            input: std::option::Option<crate::model::GeoLocation>,
        ) -> Self {
            self.geo_location = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionRemoteIpDetails`](crate::model::ActionRemoteIpDetails)
        pub fn build(self) -> crate::model::ActionRemoteIpDetails {
            crate::model::ActionRemoteIpDetails {
                ip_address_v4: self.ip_address_v4,
                organization: self.organization,
                country: self.country,
                city: self.city,
                geo_location: self.geo_location,
            }
        }
    }
}
impl ActionRemoteIpDetails {
    /// Creates a new builder-style object to manufacture [`ActionRemoteIpDetails`](crate::model::ActionRemoteIpDetails)
    pub fn builder() -> crate::model::action_remote_ip_details::Builder {
        crate::model::action_remote_ip_details::Builder::default()
    }
}

/// <p>Provides the latitude and longitude coordinates of a location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoLocation {
    /// <p>The longitude of the location.</p>
    pub lon: f64,
    /// <p>The latitude of the location.</p>
    pub lat: f64,
}
impl std::fmt::Debug for GeoLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoLocation");
        formatter.field("lon", &self.lon);
        formatter.field("lat", &self.lat);
        formatter.finish()
    }
}
/// See [`GeoLocation`](crate::model::GeoLocation)
pub mod geo_location {
    /// A builder for [`GeoLocation`](crate::model::GeoLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lon: std::option::Option<f64>,
        pub(crate) lat: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The longitude of the location.</p>
        pub fn lon(mut self, input: f64) -> Self {
            self.lon = Some(input);
            self
        }
        /// <p>The longitude of the location.</p>
        pub fn set_lon(mut self, input: std::option::Option<f64>) -> Self {
            self.lon = input;
            self
        }
        /// <p>The latitude of the location.</p>
        pub fn lat(mut self, input: f64) -> Self {
            self.lat = Some(input);
            self
        }
        /// <p>The latitude of the location.</p>
        pub fn set_lat(mut self, input: std::option::Option<f64>) -> Self {
            self.lat = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoLocation`](crate::model::GeoLocation)
        pub fn build(self) -> crate::model::GeoLocation {
            crate::model::GeoLocation {
                lon: self.lon.unwrap_or_default(),
                lat: self.lat.unwrap_or_default(),
            }
        }
    }
}
impl GeoLocation {
    /// Creates a new builder-style object to manufacture [`GeoLocation`](crate::model::GeoLocation)
    pub fn builder() -> crate::model::geo_location::Builder {
        crate::model::geo_location::Builder::default()
    }
}

/// <p>Information about a city.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct City {
    /// <p>The name of the city.</p>
    pub city_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for City {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("City");
        formatter.field("city_name", &self.city_name);
        formatter.finish()
    }
}
/// See [`City`](crate::model::City)
pub mod city {
    /// A builder for [`City`](crate::model::City)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) city_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the city.</p>
        pub fn city_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.city_name = Some(input.into());
            self
        }
        /// <p>The name of the city.</p>
        pub fn set_city_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city_name = input;
            self
        }
        /// Consumes the builder and constructs a [`City`](crate::model::City)
        pub fn build(self) -> crate::model::City {
            crate::model::City {
                city_name: self.city_name,
            }
        }
    }
}
impl City {
    /// Creates a new builder-style object to manufacture [`City`](crate::model::City)
    pub fn builder() -> crate::model::city::Builder {
        crate::model::city::Builder::default()
    }
}

/// <p>Information about a country.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Country {
    /// <p>The 2-letter ISO 3166 country code for the country.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The name of the country.</p>
    pub country_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Country {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Country");
        formatter.field("country_code", &self.country_code);
        formatter.field("country_name", &self.country_name);
        formatter.finish()
    }
}
/// See [`Country`](crate::model::Country)
pub mod country {
    /// A builder for [`Country`](crate::model::Country)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) country_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 2-letter ISO 3166 country code for the country.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>The 2-letter ISO 3166 country code for the country.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The name of the country.</p>
        pub fn country_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_name = Some(input.into());
            self
        }
        /// <p>The name of the country.</p>
        pub fn set_country_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Country`](crate::model::Country)
        pub fn build(self) -> crate::model::Country {
            crate::model::Country {
                country_code: self.country_code,
                country_name: self.country_name,
            }
        }
    }
}
impl Country {
    /// Creates a new builder-style object to manufacture [`Country`](crate::model::Country)
    pub fn builder() -> crate::model::country::Builder {
        crate::model::country::Builder::default()
    }
}

/// <p>Provides information about an internet provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpOrganizationDetails {
    /// <p>The Autonomous System Number (ASN) of the internet provider</p>
    pub asn: i32,
    /// <p>The name of the organization that registered the ASN.</p>
    pub asn_org: std::option::Option<std::string::String>,
    /// <p>The ISP information for the internet provider.</p>
    pub isp: std::option::Option<std::string::String>,
    /// <p>The name of the internet provider.</p>
    pub org: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IpOrganizationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpOrganizationDetails");
        formatter.field("asn", &self.asn);
        formatter.field("asn_org", &self.asn_org);
        formatter.field("isp", &self.isp);
        formatter.field("org", &self.org);
        formatter.finish()
    }
}
/// See [`IpOrganizationDetails`](crate::model::IpOrganizationDetails)
pub mod ip_organization_details {
    /// A builder for [`IpOrganizationDetails`](crate::model::IpOrganizationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asn: std::option::Option<i32>,
        pub(crate) asn_org: std::option::Option<std::string::String>,
        pub(crate) isp: std::option::Option<std::string::String>,
        pub(crate) org: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Autonomous System Number (ASN) of the internet provider</p>
        pub fn asn(mut self, input: i32) -> Self {
            self.asn = Some(input);
            self
        }
        /// <p>The Autonomous System Number (ASN) of the internet provider</p>
        pub fn set_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The name of the organization that registered the ASN.</p>
        pub fn asn_org(mut self, input: impl Into<std::string::String>) -> Self {
            self.asn_org = Some(input.into());
            self
        }
        /// <p>The name of the organization that registered the ASN.</p>
        pub fn set_asn_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asn_org = input;
            self
        }
        /// <p>The ISP information for the internet provider.</p>
        pub fn isp(mut self, input: impl Into<std::string::String>) -> Self {
            self.isp = Some(input.into());
            self
        }
        /// <p>The ISP information for the internet provider.</p>
        pub fn set_isp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.isp = input;
            self
        }
        /// <p>The name of the internet provider.</p>
        pub fn org(mut self, input: impl Into<std::string::String>) -> Self {
            self.org = Some(input.into());
            self
        }
        /// <p>The name of the internet provider.</p>
        pub fn set_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.org = input;
            self
        }
        /// Consumes the builder and constructs a [`IpOrganizationDetails`](crate::model::IpOrganizationDetails)
        pub fn build(self) -> crate::model::IpOrganizationDetails {
            crate::model::IpOrganizationDetails {
                asn: self.asn.unwrap_or_default(),
                asn_org: self.asn_org,
                isp: self.isp,
                org: self.org,
            }
        }
    }
}
impl IpOrganizationDetails {
    /// Creates a new builder-style object to manufacture [`IpOrganizationDetails`](crate::model::IpOrganizationDetails)
    pub fn builder() -> crate::model::ip_organization_details::Builder {
        crate::model::ip_organization_details::Builder::default()
    }
}

/// <p>Provides information about the IP address where the scanned port is located.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionLocalIpDetails {
    /// <p>The IP address.</p>
    pub ip_address_v4: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActionLocalIpDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionLocalIpDetails");
        formatter.field("ip_address_v4", &self.ip_address_v4);
        formatter.finish()
    }
}
/// See [`ActionLocalIpDetails`](crate::model::ActionLocalIpDetails)
pub mod action_local_ip_details {
    /// A builder for [`ActionLocalIpDetails`](crate::model::ActionLocalIpDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address_v4: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address.</p>
        pub fn ip_address_v4(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address_v4 = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_ip_address_v4(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_address_v4 = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionLocalIpDetails`](crate::model::ActionLocalIpDetails)
        pub fn build(self) -> crate::model::ActionLocalIpDetails {
            crate::model::ActionLocalIpDetails {
                ip_address_v4: self.ip_address_v4,
            }
        }
    }
}
impl ActionLocalIpDetails {
    /// Creates a new builder-style object to manufacture [`ActionLocalIpDetails`](crate::model::ActionLocalIpDetails)
    pub fn builder() -> crate::model::action_local_ip_details::Builder {
        crate::model::action_local_ip_details::Builder::default()
    }
}

/// <p>For <code>NetworkConnectionAction</code> and <code>PortProbeDetails</code>,
/// <code>LocalPortDetails</code> provides information about the local port that was
/// involved in the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionLocalPortDetails {
    /// <p>The number of the port.</p>
    pub port: i32,
    /// <p>The port name of the local connection.</p>
    pub port_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActionLocalPortDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionLocalPortDetails");
        formatter.field("port", &self.port);
        formatter.field("port_name", &self.port_name);
        formatter.finish()
    }
}
/// See [`ActionLocalPortDetails`](crate::model::ActionLocalPortDetails)
pub mod action_local_port_details {
    /// A builder for [`ActionLocalPortDetails`](crate::model::ActionLocalPortDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) port_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of the port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The number of the port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The port name of the local connection.</p>
        pub fn port_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_name = Some(input.into());
            self
        }
        /// <p>The port name of the local connection.</p>
        pub fn set_port_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionLocalPortDetails`](crate::model::ActionLocalPortDetails)
        pub fn build(self) -> crate::model::ActionLocalPortDetails {
            crate::model::ActionLocalPortDetails {
                port: self.port.unwrap_or_default(),
                port_name: self.port_name,
            }
        }
    }
}
impl ActionLocalPortDetails {
    /// Creates a new builder-style object to manufacture [`ActionLocalPortDetails`](crate::model::ActionLocalPortDetails)
    pub fn builder() -> crate::model::action_local_port_details::Builder {
        crate::model::action_local_port_details::Builder::default()
    }
}

/// <p>Provided if <code>ActionType</code> is <code>DNS_REQUEST</code>. It provides details
/// about the DNS request that was detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRequestAction {
    /// <p>The DNS domain that is associated with the DNS request.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The protocol that was used for the DNS request.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>Indicates whether the DNS request was blocked.</p>
    pub blocked: bool,
}
impl std::fmt::Debug for DnsRequestAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRequestAction");
        formatter.field("domain", &self.domain);
        formatter.field("protocol", &self.protocol);
        formatter.field("blocked", &self.blocked);
        formatter.finish()
    }
}
/// See [`DnsRequestAction`](crate::model::DnsRequestAction)
pub mod dns_request_action {
    /// A builder for [`DnsRequestAction`](crate::model::DnsRequestAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) blocked: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DNS domain that is associated with the DNS request.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The DNS domain that is associated with the DNS request.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The protocol that was used for the DNS request.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol that was used for the DNS request.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Indicates whether the DNS request was blocked.</p>
        pub fn blocked(mut self, input: bool) -> Self {
            self.blocked = Some(input);
            self
        }
        /// <p>Indicates whether the DNS request was blocked.</p>
        pub fn set_blocked(mut self, input: std::option::Option<bool>) -> Self {
            self.blocked = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRequestAction`](crate::model::DnsRequestAction)
        pub fn build(self) -> crate::model::DnsRequestAction {
            crate::model::DnsRequestAction {
                domain: self.domain,
                protocol: self.protocol,
                blocked: self.blocked.unwrap_or_default(),
            }
        }
    }
}
impl DnsRequestAction {
    /// Creates a new builder-style object to manufacture [`DnsRequestAction`](crate::model::DnsRequestAction)
    pub fn builder() -> crate::model::dns_request_action::Builder {
        crate::model::dns_request_action::Builder::default()
    }
}

/// <p>Provided if <code>ActionType</code> is <code>AWS_API_CALL</code>. It provides details
/// about the API call that was detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsApiCallAction {
    /// <p>The name of the API method that was issued.</p>
    pub api: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Web Services service that the API method belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the API call originated from a remote IP address
    /// (<code>remoteip</code>) or from a DNS domain (<code>domain</code>).</p>
    pub caller_type: std::option::Option<std::string::String>,
    /// <p>Provided if <code>CallerType</code> is <code>remoteIp</code>. Provides information about
    /// the remote IP address that the API call originated from.</p>
    pub remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
    /// <p>Provided if <code>CallerType</code> is <code>domain</code>. Provides information about
    /// the DNS domain that the API call originated from.</p>
    pub domain_details: std::option::Option<crate::model::AwsApiCallActionDomainDetails>,
    /// <p>Identifies the resources that were affected by the API call.</p>
    pub affected_resources:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An ISO8601-formatted timestamp that indicates when the API call was first
    /// observed.</p>
    pub first_seen: std::option::Option<std::string::String>,
    /// <p>An ISO8601-formatted timestamp that indicates when the API call was most recently
    /// observed.</p>
    pub last_seen: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsApiCallAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsApiCallAction");
        formatter.field("api", &self.api);
        formatter.field("service_name", &self.service_name);
        formatter.field("caller_type", &self.caller_type);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.field("domain_details", &self.domain_details);
        formatter.field("affected_resources", &self.affected_resources);
        formatter.field("first_seen", &self.first_seen);
        formatter.field("last_seen", &self.last_seen);
        formatter.finish()
    }
}
/// See [`AwsApiCallAction`](crate::model::AwsApiCallAction)
pub mod aws_api_call_action {
    /// A builder for [`AwsApiCallAction`](crate::model::AwsApiCallAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) caller_type: std::option::Option<std::string::String>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
        pub(crate) domain_details: std::option::Option<crate::model::AwsApiCallActionDomainDetails>,
        pub(crate) affected_resources: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) first_seen: std::option::Option<std::string::String>,
        pub(crate) last_seen: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the API method that was issued.</p>
        pub fn api(mut self, input: impl Into<std::string::String>) -> Self {
            self.api = Some(input.into());
            self
        }
        /// <p>The name of the API method that was issued.</p>
        pub fn set_api(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api = input;
            self
        }
        /// <p>The name of the Amazon Web Services service that the API method belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services service that the API method belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Indicates whether the API call originated from a remote IP address
        /// (<code>remoteip</code>) or from a DNS domain (<code>domain</code>).</p>
        pub fn caller_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_type = Some(input.into());
            self
        }
        /// <p>Indicates whether the API call originated from a remote IP address
        /// (<code>remoteip</code>) or from a DNS domain (<code>domain</code>).</p>
        pub fn set_caller_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.caller_type = input;
            self
        }
        /// <p>Provided if <code>CallerType</code> is <code>remoteIp</code>. Provides information about
        /// the remote IP address that the API call originated from.</p>
        pub fn remote_ip_details(mut self, input: crate::model::ActionRemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>Provided if <code>CallerType</code> is <code>remoteIp</code>. Provides information about
        /// the remote IP address that the API call originated from.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::ActionRemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// <p>Provided if <code>CallerType</code> is <code>domain</code>. Provides information about
        /// the DNS domain that the API call originated from.</p>
        pub fn domain_details(
            mut self,
            input: crate::model::AwsApiCallActionDomainDetails,
        ) -> Self {
            self.domain_details = Some(input);
            self
        }
        /// <p>Provided if <code>CallerType</code> is <code>domain</code>. Provides information about
        /// the DNS domain that the API call originated from.</p>
        pub fn set_domain_details(
            mut self,
            input: std::option::Option<crate::model::AwsApiCallActionDomainDetails>,
        ) -> Self {
            self.domain_details = input;
            self
        }
        /// Adds a key-value pair to `affected_resources`.
        ///
        /// To override the contents of this collection use [`set_affected_resources`](Self::set_affected_resources).
        ///
        /// <p>Identifies the resources that were affected by the API call.</p>
        pub fn affected_resources(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.affected_resources.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.affected_resources = Some(hash_map);
            self
        }
        /// <p>Identifies the resources that were affected by the API call.</p>
        pub fn set_affected_resources(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.affected_resources = input;
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the API call was first
        /// observed.</p>
        pub fn first_seen(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_seen = Some(input.into());
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the API call was first
        /// observed.</p>
        pub fn set_first_seen(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_seen = input;
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the API call was most recently
        /// observed.</p>
        pub fn last_seen(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_seen = Some(input.into());
            self
        }
        /// <p>An ISO8601-formatted timestamp that indicates when the API call was most recently
        /// observed.</p>
        pub fn set_last_seen(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_seen = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsApiCallAction`](crate::model::AwsApiCallAction)
        pub fn build(self) -> crate::model::AwsApiCallAction {
            crate::model::AwsApiCallAction {
                api: self.api,
                service_name: self.service_name,
                caller_type: self.caller_type,
                remote_ip_details: self.remote_ip_details,
                domain_details: self.domain_details,
                affected_resources: self.affected_resources,
                first_seen: self.first_seen,
                last_seen: self.last_seen,
            }
        }
    }
}
impl AwsApiCallAction {
    /// Creates a new builder-style object to manufacture [`AwsApiCallAction`](crate::model::AwsApiCallAction)
    pub fn builder() -> crate::model::aws_api_call_action::Builder {
        crate::model::aws_api_call_action::Builder::default()
    }
}

/// <p>Provided if <code>CallerType</code> is <code>domain</code>. It provides information
/// about the DNS domain that issued the API call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsApiCallActionDomainDetails {
    /// <p>The name of the DNS domain that issued the API call.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsApiCallActionDomainDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsApiCallActionDomainDetails");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`AwsApiCallActionDomainDetails`](crate::model::AwsApiCallActionDomainDetails)
pub mod aws_api_call_action_domain_details {
    /// A builder for [`AwsApiCallActionDomainDetails`](crate::model::AwsApiCallActionDomainDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DNS domain that issued the API call.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the DNS domain that issued the API call.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsApiCallActionDomainDetails`](crate::model::AwsApiCallActionDomainDetails)
        pub fn build(self) -> crate::model::AwsApiCallActionDomainDetails {
            crate::model::AwsApiCallActionDomainDetails {
                domain: self.domain,
            }
        }
    }
}
impl AwsApiCallActionDomainDetails {
    /// Creates a new builder-style object to manufacture [`AwsApiCallActionDomainDetails`](crate::model::AwsApiCallActionDomainDetails)
    pub fn builder() -> crate::model::aws_api_call_action_domain_details::Builder {
        crate::model::aws_api_call_action_domain_details::Builder::default()
    }
}

/// <p>Provided if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. It provides
/// details about the attempted network connection that was detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConnectionAction {
    /// <p>The direction of the network connection request (<code>IN</code> or
    /// <code>OUT</code>).</p>
    pub connection_direction: std::option::Option<std::string::String>,
    /// <p>Information about the remote IP address that issued the network connection
    /// request.</p>
    pub remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
    /// <p>Information about the port on the remote IP address.</p>
    pub remote_port_details: std::option::Option<crate::model::ActionRemotePortDetails>,
    /// <p>Information about the port on the EC2 instance.</p>
    pub local_port_details: std::option::Option<crate::model::ActionLocalPortDetails>,
    /// <p>The protocol used to make the network connection request.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>Indicates whether the network connection attempt was blocked.</p>
    pub blocked: bool,
}
impl std::fmt::Debug for NetworkConnectionAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConnectionAction");
        formatter.field("connection_direction", &self.connection_direction);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.field("remote_port_details", &self.remote_port_details);
        formatter.field("local_port_details", &self.local_port_details);
        formatter.field("protocol", &self.protocol);
        formatter.field("blocked", &self.blocked);
        formatter.finish()
    }
}
/// See [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
pub mod network_connection_action {
    /// A builder for [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_direction: std::option::Option<std::string::String>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::ActionRemoteIpDetails>,
        pub(crate) remote_port_details: std::option::Option<crate::model::ActionRemotePortDetails>,
        pub(crate) local_port_details: std::option::Option<crate::model::ActionLocalPortDetails>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) blocked: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The direction of the network connection request (<code>IN</code> or
        /// <code>OUT</code>).</p>
        pub fn connection_direction(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_direction = Some(input.into());
            self
        }
        /// <p>The direction of the network connection request (<code>IN</code> or
        /// <code>OUT</code>).</p>
        pub fn set_connection_direction(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_direction = input;
            self
        }
        /// <p>Information about the remote IP address that issued the network connection
        /// request.</p>
        pub fn remote_ip_details(mut self, input: crate::model::ActionRemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>Information about the remote IP address that issued the network connection
        /// request.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::ActionRemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// <p>Information about the port on the remote IP address.</p>
        pub fn remote_port_details(mut self, input: crate::model::ActionRemotePortDetails) -> Self {
            self.remote_port_details = Some(input);
            self
        }
        /// <p>Information about the port on the remote IP address.</p>
        pub fn set_remote_port_details(
            mut self,
            input: std::option::Option<crate::model::ActionRemotePortDetails>,
        ) -> Self {
            self.remote_port_details = input;
            self
        }
        /// <p>Information about the port on the EC2 instance.</p>
        pub fn local_port_details(mut self, input: crate::model::ActionLocalPortDetails) -> Self {
            self.local_port_details = Some(input);
            self
        }
        /// <p>Information about the port on the EC2 instance.</p>
        pub fn set_local_port_details(
            mut self,
            input: std::option::Option<crate::model::ActionLocalPortDetails>,
        ) -> Self {
            self.local_port_details = input;
            self
        }
        /// <p>The protocol used to make the network connection request.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol used to make the network connection request.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Indicates whether the network connection attempt was blocked.</p>
        pub fn blocked(mut self, input: bool) -> Self {
            self.blocked = Some(input);
            self
        }
        /// <p>Indicates whether the network connection attempt was blocked.</p>
        pub fn set_blocked(mut self, input: std::option::Option<bool>) -> Self {
            self.blocked = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
        pub fn build(self) -> crate::model::NetworkConnectionAction {
            crate::model::NetworkConnectionAction {
                connection_direction: self.connection_direction,
                remote_ip_details: self.remote_ip_details,
                remote_port_details: self.remote_port_details,
                local_port_details: self.local_port_details,
                protocol: self.protocol,
                blocked: self.blocked.unwrap_or_default(),
            }
        }
    }
}
impl NetworkConnectionAction {
    /// Creates a new builder-style object to manufacture [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
    pub fn builder() -> crate::model::network_connection_action::Builder {
        crate::model::network_connection_action::Builder::default()
    }
}

/// <p>Provides information about the remote port that was involved in an attempted network
/// connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActionRemotePortDetails {
    /// <p>The number of the port.</p>
    pub port: i32,
    /// <p>The port name of the remote connection.</p>
    pub port_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActionRemotePortDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActionRemotePortDetails");
        formatter.field("port", &self.port);
        formatter.field("port_name", &self.port_name);
        formatter.finish()
    }
}
/// See [`ActionRemotePortDetails`](crate::model::ActionRemotePortDetails)
pub mod action_remote_port_details {
    /// A builder for [`ActionRemotePortDetails`](crate::model::ActionRemotePortDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) port_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of the port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The number of the port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The port name of the remote connection.</p>
        pub fn port_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_name = Some(input.into());
            self
        }
        /// <p>The port name of the remote connection.</p>
        pub fn set_port_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActionRemotePortDetails`](crate::model::ActionRemotePortDetails)
        pub fn build(self) -> crate::model::ActionRemotePortDetails {
            crate::model::ActionRemotePortDetails {
                port: self.port.unwrap_or_default(),
                port_name: self.port_name,
            }
        }
    }
}
impl ActionRemotePortDetails {
    /// Creates a new builder-style object to manufacture [`ActionRemotePortDetails`](crate::model::ActionRemotePortDetails)
    pub fn builder() -> crate::model::action_remote_port_details::Builder {
        crate::model::action_remote_port_details::Builder::default()
    }
}

/// <p>Provides an overview of the patch compliance status for an instance against a selected
/// compliance standard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchSummary {
    /// <p>The identifier of the compliance standard that was used to determine the patch
    /// compliance status.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The number of patches from the compliance standard that were installed
    /// successfully.</p>
    pub installed_count: i32,
    /// <p>The number of patches that are part of the compliance standard but are not installed.
    /// The count includes patches that failed to install.</p>
    pub missing_count: i32,
    /// <p>The number of patches from the compliance standard that failed to install.</p>
    pub failed_count: i32,
    /// <p>The number of installed patches that are not part of the compliance standard.</p>
    pub installed_other_count: i32,
    /// <p>The number of patches that are installed but are also on a list of patches that the
    /// customer rejected.</p>
    pub installed_rejected_count: i32,
    /// <p>The number of patches that were applied, but that require the instance to be rebooted in
    /// order to be marked as installed.</p>
    pub installed_pending_reboot: i32,
    /// <p>Indicates when the operation started.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub operation_start_time: std::option::Option<std::string::String>,
    /// <p>Indicates when the operation completed.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub operation_end_time: std::option::Option<std::string::String>,
    /// <p>The reboot option specified for the instance.</p>
    pub reboot_option: std::option::Option<std::string::String>,
    /// <p>The type of patch operation performed. For Patch Manager, the values are
    /// <code>SCAN</code> and <code>INSTALL</code>. </p>
    pub operation: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PatchSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchSummary");
        formatter.field("id", &self.id);
        formatter.field("installed_count", &self.installed_count);
        formatter.field("missing_count", &self.missing_count);
        formatter.field("failed_count", &self.failed_count);
        formatter.field("installed_other_count", &self.installed_other_count);
        formatter.field("installed_rejected_count", &self.installed_rejected_count);
        formatter.field("installed_pending_reboot", &self.installed_pending_reboot);
        formatter.field("operation_start_time", &self.operation_start_time);
        formatter.field("operation_end_time", &self.operation_end_time);
        formatter.field("reboot_option", &self.reboot_option);
        formatter.field("operation", &self.operation);
        formatter.finish()
    }
}
/// See [`PatchSummary`](crate::model::PatchSummary)
pub mod patch_summary {
    /// A builder for [`PatchSummary`](crate::model::PatchSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) installed_count: std::option::Option<i32>,
        pub(crate) missing_count: std::option::Option<i32>,
        pub(crate) failed_count: std::option::Option<i32>,
        pub(crate) installed_other_count: std::option::Option<i32>,
        pub(crate) installed_rejected_count: std::option::Option<i32>,
        pub(crate) installed_pending_reboot: std::option::Option<i32>,
        pub(crate) operation_start_time: std::option::Option<std::string::String>,
        pub(crate) operation_end_time: std::option::Option<std::string::String>,
        pub(crate) reboot_option: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the compliance standard that was used to determine the patch
        /// compliance status.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the compliance standard that was used to determine the patch
        /// compliance status.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The number of patches from the compliance standard that were installed
        /// successfully.</p>
        pub fn installed_count(mut self, input: i32) -> Self {
            self.installed_count = Some(input);
            self
        }
        /// <p>The number of patches from the compliance standard that were installed
        /// successfully.</p>
        pub fn set_installed_count(mut self, input: std::option::Option<i32>) -> Self {
            self.installed_count = input;
            self
        }
        /// <p>The number of patches that are part of the compliance standard but are not installed.
        /// The count includes patches that failed to install.</p>
        pub fn missing_count(mut self, input: i32) -> Self {
            self.missing_count = Some(input);
            self
        }
        /// <p>The number of patches that are part of the compliance standard but are not installed.
        /// The count includes patches that failed to install.</p>
        pub fn set_missing_count(mut self, input: std::option::Option<i32>) -> Self {
            self.missing_count = input;
            self
        }
        /// <p>The number of patches from the compliance standard that failed to install.</p>
        pub fn failed_count(mut self, input: i32) -> Self {
            self.failed_count = Some(input);
            self
        }
        /// <p>The number of patches from the compliance standard that failed to install.</p>
        pub fn set_failed_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_count = input;
            self
        }
        /// <p>The number of installed patches that are not part of the compliance standard.</p>
        pub fn installed_other_count(mut self, input: i32) -> Self {
            self.installed_other_count = Some(input);
            self
        }
        /// <p>The number of installed patches that are not part of the compliance standard.</p>
        pub fn set_installed_other_count(mut self, input: std::option::Option<i32>) -> Self {
            self.installed_other_count = input;
            self
        }
        /// <p>The number of patches that are installed but are also on a list of patches that the
        /// customer rejected.</p>
        pub fn installed_rejected_count(mut self, input: i32) -> Self {
            self.installed_rejected_count = Some(input);
            self
        }
        /// <p>The number of patches that are installed but are also on a list of patches that the
        /// customer rejected.</p>
        pub fn set_installed_rejected_count(mut self, input: std::option::Option<i32>) -> Self {
            self.installed_rejected_count = input;
            self
        }
        /// <p>The number of patches that were applied, but that require the instance to be rebooted in
        /// order to be marked as installed.</p>
        pub fn installed_pending_reboot(mut self, input: i32) -> Self {
            self.installed_pending_reboot = Some(input);
            self
        }
        /// <p>The number of patches that were applied, but that require the instance to be rebooted in
        /// order to be marked as installed.</p>
        pub fn set_installed_pending_reboot(mut self, input: std::option::Option<i32>) -> Self {
            self.installed_pending_reboot = input;
            self
        }
        /// <p>Indicates when the operation started.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn operation_start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_start_time = Some(input.into());
            self
        }
        /// <p>Indicates when the operation started.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_operation_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_start_time = input;
            self
        }
        /// <p>Indicates when the operation completed.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn operation_end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_end_time = Some(input.into());
            self
        }
        /// <p>Indicates when the operation completed.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_operation_end_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_end_time = input;
            self
        }
        /// <p>The reboot option specified for the instance.</p>
        pub fn reboot_option(mut self, input: impl Into<std::string::String>) -> Self {
            self.reboot_option = Some(input.into());
            self
        }
        /// <p>The reboot option specified for the instance.</p>
        pub fn set_reboot_option(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reboot_option = input;
            self
        }
        /// <p>The type of patch operation performed. For Patch Manager, the values are
        /// <code>SCAN</code> and <code>INSTALL</code>. </p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The type of patch operation performed. For Patch Manager, the values are
        /// <code>SCAN</code> and <code>INSTALL</code>. </p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchSummary`](crate::model::PatchSummary)
        pub fn build(self) -> crate::model::PatchSummary {
            crate::model::PatchSummary {
                id: self.id,
                installed_count: self.installed_count.unwrap_or_default(),
                missing_count: self.missing_count.unwrap_or_default(),
                failed_count: self.failed_count.unwrap_or_default(),
                installed_other_count: self.installed_other_count.unwrap_or_default(),
                installed_rejected_count: self.installed_rejected_count.unwrap_or_default(),
                installed_pending_reboot: self.installed_pending_reboot.unwrap_or_default(),
                operation_start_time: self.operation_start_time,
                operation_end_time: self.operation_end_time,
                reboot_option: self.reboot_option,
                operation: self.operation,
            }
        }
    }
}
impl PatchSummary {
    /// Creates a new builder-style object to manufacture [`PatchSummary`](crate::model::PatchSummary)
    pub fn builder() -> crate::model::patch_summary::Builder {
        crate::model::patch_summary::Builder::default()
    }
}

/// <p>A vulnerability associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Vulnerability {
    /// <p>The identifier of the vulnerability.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>List of software packages that have the vulnerability.</p>
    pub vulnerable_packages: std::option::Option<std::vec::Vec<crate::model::SoftwarePackage>>,
    /// <p>CVSS scores from the advisory related to the vulnerability.</p>
    pub cvss: std::option::Option<std::vec::Vec<crate::model::Cvss>>,
    /// <p>List of vulnerabilities that are related to this vulnerability.</p>
    pub related_vulnerabilities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the vendor that generates the vulnerability report.</p>
    pub vendor: std::option::Option<crate::model::VulnerabilityVendor>,
    /// <p>A list of URLs that provide additional information about the vulnerability.</p>
    pub reference_urls: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Vulnerability {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Vulnerability");
        formatter.field("id", &self.id);
        formatter.field("vulnerable_packages", &self.vulnerable_packages);
        formatter.field("cvss", &self.cvss);
        formatter.field("related_vulnerabilities", &self.related_vulnerabilities);
        formatter.field("vendor", &self.vendor);
        formatter.field("reference_urls", &self.reference_urls);
        formatter.finish()
    }
}
/// See [`Vulnerability`](crate::model::Vulnerability)
pub mod vulnerability {
    /// A builder for [`Vulnerability`](crate::model::Vulnerability)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) vulnerable_packages:
            std::option::Option<std::vec::Vec<crate::model::SoftwarePackage>>,
        pub(crate) cvss: std::option::Option<std::vec::Vec<crate::model::Cvss>>,
        pub(crate) related_vulnerabilities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vendor: std::option::Option<crate::model::VulnerabilityVendor>,
        pub(crate) reference_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the vulnerability.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the vulnerability.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `vulnerable_packages`.
        ///
        /// To override the contents of this collection use [`set_vulnerable_packages`](Self::set_vulnerable_packages).
        ///
        /// <p>List of software packages that have the vulnerability.</p>
        pub fn vulnerable_packages(
            mut self,
            input: impl Into<crate::model::SoftwarePackage>,
        ) -> Self {
            let mut v = self.vulnerable_packages.unwrap_or_default();
            v.push(input.into());
            self.vulnerable_packages = Some(v);
            self
        }
        /// <p>List of software packages that have the vulnerability.</p>
        pub fn set_vulnerable_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SoftwarePackage>>,
        ) -> Self {
            self.vulnerable_packages = input;
            self
        }
        /// Appends an item to `cvss`.
        ///
        /// To override the contents of this collection use [`set_cvss`](Self::set_cvss).
        ///
        /// <p>CVSS scores from the advisory related to the vulnerability.</p>
        pub fn cvss(mut self, input: impl Into<crate::model::Cvss>) -> Self {
            let mut v = self.cvss.unwrap_or_default();
            v.push(input.into());
            self.cvss = Some(v);
            self
        }
        /// <p>CVSS scores from the advisory related to the vulnerability.</p>
        pub fn set_cvss(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cvss>>,
        ) -> Self {
            self.cvss = input;
            self
        }
        /// Appends an item to `related_vulnerabilities`.
        ///
        /// To override the contents of this collection use [`set_related_vulnerabilities`](Self::set_related_vulnerabilities).
        ///
        /// <p>List of vulnerabilities that are related to this vulnerability.</p>
        pub fn related_vulnerabilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.related_vulnerabilities.unwrap_or_default();
            v.push(input.into());
            self.related_vulnerabilities = Some(v);
            self
        }
        /// <p>List of vulnerabilities that are related to this vulnerability.</p>
        pub fn set_related_vulnerabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.related_vulnerabilities = input;
            self
        }
        /// <p>Information about the vendor that generates the vulnerability report.</p>
        pub fn vendor(mut self, input: crate::model::VulnerabilityVendor) -> Self {
            self.vendor = Some(input);
            self
        }
        /// <p>Information about the vendor that generates the vulnerability report.</p>
        pub fn set_vendor(
            mut self,
            input: std::option::Option<crate::model::VulnerabilityVendor>,
        ) -> Self {
            self.vendor = input;
            self
        }
        /// Appends an item to `reference_urls`.
        ///
        /// To override the contents of this collection use [`set_reference_urls`](Self::set_reference_urls).
        ///
        /// <p>A list of URLs that provide additional information about the vulnerability.</p>
        pub fn reference_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reference_urls.unwrap_or_default();
            v.push(input.into());
            self.reference_urls = Some(v);
            self
        }
        /// <p>A list of URLs that provide additional information about the vulnerability.</p>
        pub fn set_reference_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reference_urls = input;
            self
        }
        /// Consumes the builder and constructs a [`Vulnerability`](crate::model::Vulnerability)
        pub fn build(self) -> crate::model::Vulnerability {
            crate::model::Vulnerability {
                id: self.id,
                vulnerable_packages: self.vulnerable_packages,
                cvss: self.cvss,
                related_vulnerabilities: self.related_vulnerabilities,
                vendor: self.vendor,
                reference_urls: self.reference_urls,
            }
        }
    }
}
impl Vulnerability {
    /// Creates a new builder-style object to manufacture [`Vulnerability`](crate::model::Vulnerability)
    pub fn builder() -> crate::model::vulnerability::Builder {
        crate::model::vulnerability::Builder::default()
    }
}

/// <p>A vendor that generates a vulnerability report.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VulnerabilityVendor {
    /// <p>The name of the vendor.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The URL of the vulnerability advisory.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The severity that the vendor assigned to the vulnerability.</p>
    pub vendor_severity: std::option::Option<std::string::String>,
    /// <p>Indicates when the vulnerability advisory was created.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub vendor_created_at: std::option::Option<std::string::String>,
    /// <p>Indicates when the vulnerability advisory was last updated.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub vendor_updated_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VulnerabilityVendor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VulnerabilityVendor");
        formatter.field("name", &self.name);
        formatter.field("url", &self.url);
        formatter.field("vendor_severity", &self.vendor_severity);
        formatter.field("vendor_created_at", &self.vendor_created_at);
        formatter.field("vendor_updated_at", &self.vendor_updated_at);
        formatter.finish()
    }
}
/// See [`VulnerabilityVendor`](crate::model::VulnerabilityVendor)
pub mod vulnerability_vendor {
    /// A builder for [`VulnerabilityVendor`](crate::model::VulnerabilityVendor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) vendor_severity: std::option::Option<std::string::String>,
        pub(crate) vendor_created_at: std::option::Option<std::string::String>,
        pub(crate) vendor_updated_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the vendor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the vendor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The URL of the vulnerability advisory.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the vulnerability advisory.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The severity that the vendor assigned to the vulnerability.</p>
        pub fn vendor_severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor_severity = Some(input.into());
            self
        }
        /// <p>The severity that the vendor assigned to the vulnerability.</p>
        pub fn set_vendor_severity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vendor_severity = input;
            self
        }
        /// <p>Indicates when the vulnerability advisory was created.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn vendor_created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor_created_at = Some(input.into());
            self
        }
        /// <p>Indicates when the vulnerability advisory was created.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_vendor_created_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vendor_created_at = input;
            self
        }
        /// <p>Indicates when the vulnerability advisory was last updated.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn vendor_updated_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor_updated_at = Some(input.into());
            self
        }
        /// <p>Indicates when the vulnerability advisory was last updated.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_vendor_updated_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vendor_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VulnerabilityVendor`](crate::model::VulnerabilityVendor)
        pub fn build(self) -> crate::model::VulnerabilityVendor {
            crate::model::VulnerabilityVendor {
                name: self.name,
                url: self.url,
                vendor_severity: self.vendor_severity,
                vendor_created_at: self.vendor_created_at,
                vendor_updated_at: self.vendor_updated_at,
            }
        }
    }
}
impl VulnerabilityVendor {
    /// Creates a new builder-style object to manufacture [`VulnerabilityVendor`](crate::model::VulnerabilityVendor)
    pub fn builder() -> crate::model::vulnerability_vendor::Builder {
        crate::model::vulnerability_vendor::Builder::default()
    }
}

/// <p>CVSS scores from the advisory related to the vulnerability.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cvss {
    /// <p>The version of CVSS for the CVSS score.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The base CVSS score.</p>
    pub base_score: f64,
    /// <p>The base scoring vector for the CVSS score.</p>
    pub base_vector: std::option::Option<std::string::String>,
    /// <p>The origin of the original CVSS score and vector.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Adjustments to the CVSS metrics.</p>
    pub adjustments: std::option::Option<std::vec::Vec<crate::model::Adjustment>>,
}
impl std::fmt::Debug for Cvss {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cvss");
        formatter.field("version", &self.version);
        formatter.field("base_score", &self.base_score);
        formatter.field("base_vector", &self.base_vector);
        formatter.field("source", &self.source);
        formatter.field("adjustments", &self.adjustments);
        formatter.finish()
    }
}
/// See [`Cvss`](crate::model::Cvss)
pub mod cvss {
    /// A builder for [`Cvss`](crate::model::Cvss)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) base_score: std::option::Option<f64>,
        pub(crate) base_vector: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) adjustments: std::option::Option<std::vec::Vec<crate::model::Adjustment>>,
    }
    impl Builder {
        /// <p>The version of CVSS for the CVSS score.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of CVSS for the CVSS score.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The base CVSS score.</p>
        pub fn base_score(mut self, input: f64) -> Self {
            self.base_score = Some(input);
            self
        }
        /// <p>The base CVSS score.</p>
        pub fn set_base_score(mut self, input: std::option::Option<f64>) -> Self {
            self.base_score = input;
            self
        }
        /// <p>The base scoring vector for the CVSS score.</p>
        pub fn base_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_vector = Some(input.into());
            self
        }
        /// <p>The base scoring vector for the CVSS score.</p>
        pub fn set_base_vector(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_vector = input;
            self
        }
        /// <p>The origin of the original CVSS score and vector.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The origin of the original CVSS score and vector.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `adjustments`.
        ///
        /// To override the contents of this collection use [`set_adjustments`](Self::set_adjustments).
        ///
        /// <p>Adjustments to the CVSS metrics.</p>
        pub fn adjustments(mut self, input: impl Into<crate::model::Adjustment>) -> Self {
            let mut v = self.adjustments.unwrap_or_default();
            v.push(input.into());
            self.adjustments = Some(v);
            self
        }
        /// <p>Adjustments to the CVSS metrics.</p>
        pub fn set_adjustments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Adjustment>>,
        ) -> Self {
            self.adjustments = input;
            self
        }
        /// Consumes the builder and constructs a [`Cvss`](crate::model::Cvss)
        pub fn build(self) -> crate::model::Cvss {
            crate::model::Cvss {
                version: self.version,
                base_score: self.base_score.unwrap_or_default(),
                base_vector: self.base_vector,
                source: self.source,
                adjustments: self.adjustments,
            }
        }
    }
}
impl Cvss {
    /// Creates a new builder-style object to manufacture [`Cvss`](crate::model::Cvss)
    pub fn builder() -> crate::model::cvss::Builder {
        crate::model::cvss::Builder::default()
    }
}

/// <p>An adjustment to the CVSS metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Adjustment {
    /// <p>The metric to adjust.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The reason for the adjustment.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Adjustment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Adjustment");
        formatter.field("metric", &self.metric);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`Adjustment`](crate::model::Adjustment)
pub mod adjustment {
    /// A builder for [`Adjustment`](crate::model::Adjustment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric to adjust.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The metric to adjust.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The reason for the adjustment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the adjustment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Adjustment`](crate::model::Adjustment)
        pub fn build(self) -> crate::model::Adjustment {
            crate::model::Adjustment {
                metric: self.metric,
                reason: self.reason,
            }
        }
    }
}
impl Adjustment {
    /// Creates a new builder-style object to manufacture [`Adjustment`](crate::model::Adjustment)
    pub fn builder() -> crate::model::adjustment::Builder {
        crate::model::adjustment::Builder::default()
    }
}

/// <p>Information about a software package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoftwarePackage {
    /// <p>The name of the software package.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the software package.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The epoch of the software package.</p>
    pub epoch: std::option::Option<std::string::String>,
    /// <p>The release of the software package.</p>
    pub release: std::option::Option<std::string::String>,
    /// <p>The architecture used for the software package.</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The source of the package.</p>
    pub package_manager: std::option::Option<std::string::String>,
    /// <p>The file system path to the package manager inventory file.</p>
    pub file_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SoftwarePackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoftwarePackage");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("epoch", &self.epoch);
        formatter.field("release", &self.release);
        formatter.field("architecture", &self.architecture);
        formatter.field("package_manager", &self.package_manager);
        formatter.field("file_path", &self.file_path);
        formatter.finish()
    }
}
/// See [`SoftwarePackage`](crate::model::SoftwarePackage)
pub mod software_package {
    /// A builder for [`SoftwarePackage`](crate::model::SoftwarePackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) epoch: std::option::Option<std::string::String>,
        pub(crate) release: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) package_manager: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the software package.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the software package.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the software package.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the software package.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The epoch of the software package.</p>
        pub fn epoch(mut self, input: impl Into<std::string::String>) -> Self {
            self.epoch = Some(input.into());
            self
        }
        /// <p>The epoch of the software package.</p>
        pub fn set_epoch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.epoch = input;
            self
        }
        /// <p>The release of the software package.</p>
        pub fn release(mut self, input: impl Into<std::string::String>) -> Self {
            self.release = Some(input.into());
            self
        }
        /// <p>The release of the software package.</p>
        pub fn set_release(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.release = input;
            self
        }
        /// <p>The architecture used for the software package.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The architecture used for the software package.</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The source of the package.</p>
        pub fn package_manager(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_manager = Some(input.into());
            self
        }
        /// <p>The source of the package.</p>
        pub fn set_package_manager(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_manager = input;
            self
        }
        /// <p>The file system path to the package manager inventory file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The file system path to the package manager inventory file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// Consumes the builder and constructs a [`SoftwarePackage`](crate::model::SoftwarePackage)
        pub fn build(self) -> crate::model::SoftwarePackage {
            crate::model::SoftwarePackage {
                name: self.name,
                version: self.version,
                epoch: self.epoch,
                release: self.release,
                architecture: self.architecture,
                package_manager: self.package_manager,
                file_path: self.file_path,
            }
        }
    }
}
impl SoftwarePackage {
    /// Creates a new builder-style object to manufacture [`SoftwarePackage`](crate::model::SoftwarePackage)
    pub fn builder() -> crate::model::software_package::Builder {
        crate::model::software_package::Builder::default()
    }
}

/// <p>A user-defined note added to a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Note {
    /// <p>The text of a note.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The principal that created a note.</p>
    pub updated_by: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the note was updated.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub updated_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Note {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Note");
        formatter.field("text", &self.text);
        formatter.field("updated_by", &self.updated_by);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Note`](crate::model::Note)
pub mod note {
    /// A builder for [`Note`](crate::model::Note)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) updated_by: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of a note.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of a note.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The principal that created a note.</p>
        pub fn updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_by = Some(input.into());
            self
        }
        /// <p>The principal that created a note.</p>
        pub fn set_updated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_by = input;
            self
        }
        /// <p>The timestamp of when the note was updated.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn updated_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_at = Some(input.into());
            self
        }
        /// <p>The timestamp of when the note was updated.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_updated_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Note`](crate::model::Note)
        pub fn build(self) -> crate::model::Note {
            crate::model::Note {
                text: self.text,
                updated_by: self.updated_by,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Note {
    /// Creates a new builder-style object to manufacture [`Note`](crate::model::Note)
    pub fn builder() -> crate::model::note::Builder {
        crate::model::note::Builder::default()
    }
}

/// <p>Provides information about the status of the investigation into a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workflow {
    /// <p>The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p>
    /// <p>The allowed values are the following.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
    /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
    /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RecordState</code> changes from <code>ARCHIVED</code> to
    /// <code>ACTIVE</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ComplianceStatus</code> changes from <code>PASSED</code> to either
    /// <code>WARNING</code>, <code>FAILED</code>, or
    /// <code>NOT_AVAILABLE</code>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOTIFIED</code> - Indicates that you notified the resource owner about the
    /// security issue. Used when the initial reviewer is not the resource owner, and needs
    /// intervention from the resource owner.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
    /// considered resolved. </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::WorkflowStatus>,
}
impl std::fmt::Debug for Workflow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workflow");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Workflow`](crate::model::Workflow)
pub mod workflow {
    /// A builder for [`Workflow`](crate::model::Workflow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::WorkflowStatus>,
    }
    impl Builder {
        /// <p>The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p>
        /// <p>The allowed values are the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
        /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
        /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RecordState</code> changes from <code>ARCHIVED</code> to
        /// <code>ACTIVE</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComplianceStatus</code> changes from <code>PASSED</code> to either
        /// <code>WARNING</code>, <code>FAILED</code>, or
        /// <code>NOT_AVAILABLE</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFIED</code> - Indicates that you notified the resource owner about the
        /// security issue. Used when the initial reviewer is not the resource owner, and needs
        /// intervention from the resource owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
        /// considered resolved. </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::WorkflowStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p>
        /// <p>The allowed values are the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NEW</code> - The initial state of a finding, before it is reviewed.</p>
        /// <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or
        /// <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RecordState</code> changes from <code>ARCHIVED</code> to
        /// <code>ACTIVE</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComplianceStatus</code> changes from <code>PASSED</code> to either
        /// <code>WARNING</code>, <code>FAILED</code>, or
        /// <code>NOT_AVAILABLE</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOTIFIED</code> - Indicates that you notified the resource owner about the
        /// security issue. Used when the initial reviewer is not the resource owner, and needs
        /// intervention from the resource owner.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESOLVED</code> - The finding was reviewed and remediated and is now
        /// considered resolved. </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkflowStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Workflow`](crate::model::Workflow)
        pub fn build(self) -> crate::model::Workflow {
            crate::model::Workflow {
                status: self.status,
            }
        }
    }
}
impl Workflow {
    /// Creates a new builder-style object to manufacture [`Workflow`](crate::model::Workflow)
    pub fn builder() -> crate::model::workflow::Builder {
        crate::model::workflow::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowStatus {
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Notified,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    #[allow(missing_docs)] // documentation missing in model
    Suppressed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowStatus {
    fn from(s: &str) -> Self {
        match s {
            "NEW" => WorkflowStatus::New,
            "NOTIFIED" => WorkflowStatus::Notified,
            "RESOLVED" => WorkflowStatus::Resolved,
            "SUPPRESSED" => WorkflowStatus::Suppressed,
            other => WorkflowStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowStatus::from(s))
    }
}
impl WorkflowStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowStatus::New => "NEW",
            WorkflowStatus::Notified => "NOTIFIED",
            WorkflowStatus::Resolved => "RESOLVED",
            WorkflowStatus::Suppressed => "SUPPRESSED",
            WorkflowStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NEW", "NOTIFIED", "RESOLVED", "SUPPRESSED"]
    }
}
impl AsRef<str> for WorkflowStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowState {
    #[allow(missing_docs)] // documentation missing in model
    Assigned,
    #[allow(missing_docs)] // documentation missing in model
    Deferred,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowState {
    fn from(s: &str) -> Self {
        match s {
            "ASSIGNED" => WorkflowState::Assigned,
            "DEFERRED" => WorkflowState::Deferred,
            "IN_PROGRESS" => WorkflowState::InProgress,
            "NEW" => WorkflowState::New,
            "RESOLVED" => WorkflowState::Resolved,
            other => WorkflowState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowState::from(s))
    }
}
impl WorkflowState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowState::Assigned => "ASSIGNED",
            WorkflowState::Deferred => "DEFERRED",
            WorkflowState::InProgress => "IN_PROGRESS",
            WorkflowState::New => "NEW",
            WorkflowState::Resolved => "RESOLVED",
            WorkflowState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSIGNED", "DEFERRED", "IN_PROGRESS", "NEW", "RESOLVED"]
    }
}
impl AsRef<str> for WorkflowState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `VerificationState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerificationState {
    #[allow(missing_docs)] // documentation missing in model
    BenignPositive,
    #[allow(missing_docs)] // documentation missing in model
    FalsePositive,
    #[allow(missing_docs)] // documentation missing in model
    TruePositive,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerificationState {
    fn from(s: &str) -> Self {
        match s {
            "BENIGN_POSITIVE" => VerificationState::BenignPositive,
            "FALSE_POSITIVE" => VerificationState::FalsePositive,
            "TRUE_POSITIVE" => VerificationState::TruePositive,
            "UNKNOWN" => VerificationState::UnknownValue,
            other => VerificationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerificationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerificationState::from(s))
    }
}
impl VerificationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerificationState::BenignPositive => "BENIGN_POSITIVE",
            VerificationState::FalsePositive => "FALSE_POSITIVE",
            VerificationState::TruePositive => "TRUE_POSITIVE",
            VerificationState::UnknownValue => "UNKNOWN",
            VerificationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BENIGN_POSITIVE",
            "FALSE_POSITIVE",
            "TRUE_POSITIVE",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for VerificationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains finding details that are specific to control-based findings. Only returned for
/// findings generated from controls.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Compliance {
    /// <p>The result of a standards check.</p>
    /// <p>The valid values for <code>Status</code> are as follows.</p>
    /// <ul>
    /// <li>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PASSED</code> - Standards check passed for all evaluated
    /// resources.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WARNING</code> - Some information is missing or this check is not
    /// supported for your configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Standards check failed for at least one evaluated
    /// resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_AVAILABLE</code> - Check could not be performed due to a service
    /// outage, API error, or because the result of the Config evaluation was
    /// <code>NOT_APPLICABLE</code>. If the Config evaluation result was
    /// <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives
    /// the finding.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>For a control, the industry or regulatory framework requirements that are related to the
    /// control. The check for that control is aligned with these requirements.</p>
    pub related_requirements: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For findings generated from controls, a list of reasons behind the value of
    /// <code>Status</code>. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
    /// <i>Security Hub User Guide</i>. </p>
    pub status_reasons: std::option::Option<std::vec::Vec<crate::model::StatusReason>>,
}
impl std::fmt::Debug for Compliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Compliance");
        formatter.field("status", &self.status);
        formatter.field("related_requirements", &self.related_requirements);
        formatter.field("status_reasons", &self.status_reasons);
        formatter.finish()
    }
}
/// See [`Compliance`](crate::model::Compliance)
pub mod compliance {
    /// A builder for [`Compliance`](crate::model::Compliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) related_requirements: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status_reasons: std::option::Option<std::vec::Vec<crate::model::StatusReason>>,
    }
    impl Builder {
        /// <p>The result of a standards check.</p>
        /// <p>The valid values for <code>Status</code> are as follows.</p>
        /// <ul>
        /// <li>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PASSED</code> - Standards check passed for all evaluated
        /// resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WARNING</code> - Some information is missing or this check is not
        /// supported for your configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Standards check failed for at least one evaluated
        /// resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_AVAILABLE</code> - Check could not be performed due to a service
        /// outage, API error, or because the result of the Config evaluation was
        /// <code>NOT_APPLICABLE</code>. If the Config evaluation result was
        /// <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives
        /// the finding.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The result of a standards check.</p>
        /// <p>The valid values for <code>Status</code> are as follows.</p>
        /// <ul>
        /// <li>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PASSED</code> - Standards check passed for all evaluated
        /// resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WARNING</code> - Some information is missing or this check is not
        /// supported for your configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Standards check failed for at least one evaluated
        /// resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_AVAILABLE</code> - Check could not be performed due to a service
        /// outage, API error, or because the result of the Config evaluation was
        /// <code>NOT_APPLICABLE</code>. If the Config evaluation result was
        /// <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives
        /// the finding.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `related_requirements`.
        ///
        /// To override the contents of this collection use [`set_related_requirements`](Self::set_related_requirements).
        ///
        /// <p>For a control, the industry or regulatory framework requirements that are related to the
        /// control. The check for that control is aligned with these requirements.</p>
        pub fn related_requirements(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.related_requirements.unwrap_or_default();
            v.push(input.into());
            self.related_requirements = Some(v);
            self
        }
        /// <p>For a control, the industry or regulatory framework requirements that are related to the
        /// control. The check for that control is aligned with these requirements.</p>
        pub fn set_related_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.related_requirements = input;
            self
        }
        /// Appends an item to `status_reasons`.
        ///
        /// To override the contents of this collection use [`set_status_reasons`](Self::set_status_reasons).
        ///
        /// <p>For findings generated from controls, a list of reasons behind the value of
        /// <code>Status</code>. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
        /// <i>Security Hub User Guide</i>. </p>
        pub fn status_reasons(mut self, input: impl Into<crate::model::StatusReason>) -> Self {
            let mut v = self.status_reasons.unwrap_or_default();
            v.push(input.into());
            self.status_reasons = Some(v);
            self
        }
        /// <p>For findings generated from controls, a list of reasons behind the value of
        /// <code>Status</code>. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
        /// <i>Security Hub User Guide</i>. </p>
        pub fn set_status_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatusReason>>,
        ) -> Self {
            self.status_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`Compliance`](crate::model::Compliance)
        pub fn build(self) -> crate::model::Compliance {
            crate::model::Compliance {
                status: self.status,
                related_requirements: self.related_requirements,
                status_reasons: self.status_reasons,
            }
        }
    }
}
impl Compliance {
    /// Creates a new builder-style object to manufacture [`Compliance`](crate::model::Compliance)
    pub fn builder() -> crate::model::compliance::Builder {
        crate::model::compliance::Builder::default()
    }
}

/// <p>Provides additional context for the value of <code>Compliance.Status</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusReason {
    /// <p>A code that represents a reason for the control status. For the list of status reason
    /// codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
    /// <i>Security Hub User Guide</i>. </p>
    pub reason_code: std::option::Option<std::string::String>,
    /// <p>The corresponding description for the status reason code.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StatusReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusReason");
        formatter.field("reason_code", &self.reason_code);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`StatusReason`](crate::model::StatusReason)
pub mod status_reason {
    /// A builder for [`StatusReason`](crate::model::StatusReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason_code: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A code that represents a reason for the control status. For the list of status reason
        /// codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
        /// <i>Security Hub User Guide</i>. </p>
        pub fn reason_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason_code = Some(input.into());
            self
        }
        /// <p>A code that represents a reason for the control status. For the list of status reason
        /// codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the
        /// <i>Security Hub User Guide</i>. </p>
        pub fn set_reason_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason_code = input;
            self
        }
        /// <p>The corresponding description for the status reason code.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The corresponding description for the status reason code.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusReason`](crate::model::StatusReason)
        pub fn build(self) -> crate::model::StatusReason {
            crate::model::StatusReason {
                reason_code: self.reason_code,
                description: self.description,
            }
        }
    }
}
impl StatusReason {
    /// Creates a new builder-style object to manufacture [`StatusReason`](crate::model::StatusReason)
    pub fn builder() -> crate::model::status_reason::Builder {
        crate::model::status_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    Passed,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ComplianceStatus::Failed,
            "NOT_AVAILABLE" => ComplianceStatus::NotAvailable,
            "PASSED" => ComplianceStatus::Passed,
            "WARNING" => ComplianceStatus::Warning,
            other => ComplianceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceStatus::from(s))
    }
}
impl ComplianceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceStatus::Failed => "FAILED",
            ComplianceStatus::NotAvailable => "NOT_AVAILABLE",
            ComplianceStatus::Passed => "PASSED",
            ComplianceStatus::Warning => "WARNING",
            ComplianceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "NOT_AVAILABLE", "PASSED", "WARNING"]
    }
}
impl AsRef<str> for ComplianceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A resource related to a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The type of the resource that details are provided for. If possible, set
    /// <code>Type</code> to one of the supported resource types. For example, if the resource
    /// is an EC2 instance, then set <code>Type</code> to <code>AwsEc2Instance</code>.</p>
    /// <p>If the resource does not match any of the provided types, then set <code>Type</code> to
    /// <code>Other</code>. </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The canonical identifier for the given resource type.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
    pub partition: std::option::Option<crate::model::Partition>,
    /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,</p>
    pub resource_role: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
    /// processed.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Contains information about sensitive data that was detected on the resource.</p>
    pub data_classification: std::option::Option<crate::model::DataClassificationDetails>,
    /// <p>Additional details about the resource related to a finding.</p>
    pub details: std::option::Option<crate::model::ResourceDetails>,
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("partition", &self.partition);
        formatter.field("region", &self.region);
        formatter.field("resource_role", &self.resource_role);
        formatter.field("tags", &self.tags);
        formatter.field("data_classification", &self.data_classification);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<crate::model::Partition>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) data_classification:
            std::option::Option<crate::model::DataClassificationDetails>,
        pub(crate) details: std::option::Option<crate::model::ResourceDetails>,
    }
    impl Builder {
        /// <p>The type of the resource that details are provided for. If possible, set
        /// <code>Type</code> to one of the supported resource types. For example, if the resource
        /// is an EC2 instance, then set <code>Type</code> to <code>AwsEc2Instance</code>.</p>
        /// <p>If the resource does not match any of the provided types, then set <code>Type</code> to
        /// <code>Other</code>. </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the resource that details are provided for. If possible, set
        /// <code>Type</code> to one of the supported resource types. For example, if the resource
        /// is an EC2 instance, then set <code>Type</code> to <code>AwsEc2Instance</code>.</p>
        /// <p>If the resource does not match any of the provided types, then set <code>Type</code> to
        /// <code>Other</code>. </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The canonical identifier for the given resource type.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The canonical identifier for the given resource type.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
        pub fn partition(mut self, input: crate::model::Partition) -> Self {
            self.partition = Some(input);
            self
        }
        /// <p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>
        pub fn set_partition(
            mut self,
            input: std::option::Option<crate::model::Partition>,
        ) -> Self {
            self.partition = input;
            self
        }
        /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The canonical Amazon Web Services external Region name where this resource is located.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,</p>
        pub fn resource_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_role = Some(input.into());
            self
        }
        /// <p>Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,</p>
        pub fn set_resource_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_role = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
        /// processed.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of Amazon Web Services tags associated with a resource at the time the finding was
        /// processed.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Contains information about sensitive data that was detected on the resource.</p>
        pub fn data_classification(
            mut self,
            input: crate::model::DataClassificationDetails,
        ) -> Self {
            self.data_classification = Some(input);
            self
        }
        /// <p>Contains information about sensitive data that was detected on the resource.</p>
        pub fn set_data_classification(
            mut self,
            input: std::option::Option<crate::model::DataClassificationDetails>,
        ) -> Self {
            self.data_classification = input;
            self
        }
        /// <p>Additional details about the resource related to a finding.</p>
        pub fn details(mut self, input: crate::model::ResourceDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>Additional details about the resource related to a finding.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::ResourceDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                r#type: self.r#type,
                id: self.id,
                partition: self.partition,
                region: self.region,
                resource_role: self.resource_role,
                tags: self.tags,
                data_classification: self.data_classification,
                details: self.details,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>Additional details about a resource related to a finding.</p>
/// <p>To provide the details, use the object that corresponds to the resource type. For
/// example, if the resource type is <code>AwsEc2Instance</code>, then you use the
/// <code>AwsEc2Instance</code> object to provide the details.</p>
/// <p>If the type-specific object does not contain all of the fields you want to populate,
/// then you use the <code>Other</code> object to populate those additional fields.</p>
/// <p>You also use the <code>Other</code> object to populate the details when the selected
/// type does not have a corresponding object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDetails {
    /// <p>Details for an autoscaling group.</p>
    pub aws_auto_scaling_auto_scaling_group:
        std::option::Option<crate::model::AwsAutoScalingAutoScalingGroupDetails>,
    /// <p>Details for an CodeBuild project.</p>
    pub aws_code_build_project: std::option::Option<crate::model::AwsCodeBuildProjectDetails>,
    /// <p>Details about a CloudFront distribution.</p>
    pub aws_cloud_front_distribution:
        std::option::Option<crate::model::AwsCloudFrontDistributionDetails>,
    /// <p>Details about an EC2 instance related to a finding.</p>
    pub aws_ec2_instance: std::option::Option<crate::model::AwsEc2InstanceDetails>,
    /// <p>Details for an EC2 network interface.</p>
    pub aws_ec2_network_interface: std::option::Option<crate::model::AwsEc2NetworkInterfaceDetails>,
    /// <p>Details for an EC2 security group.</p>
    pub aws_ec2_security_group: std::option::Option<crate::model::AwsEc2SecurityGroupDetails>,
    /// <p>Details for an EC2 volume.</p>
    pub aws_ec2_volume: std::option::Option<crate::model::AwsEc2VolumeDetails>,
    /// <p>Details for an EC2 VPC.</p>
    pub aws_ec2_vpc: std::option::Option<crate::model::AwsEc2VpcDetails>,
    /// <p>Details about an Elastic IP address.</p>
    pub aws_ec2_eip: std::option::Option<crate::model::AwsEc2EipDetails>,
    /// <p>Details about a subnet in Amazon EC2.</p>
    pub aws_ec2_subnet: std::option::Option<crate::model::AwsEc2SubnetDetails>,
    /// <p>Details about an EC2 network access control list (ACL).</p>
    pub aws_ec2_network_acl: std::option::Option<crate::model::AwsEc2NetworkAclDetails>,
    /// <p>Details about a load balancer.</p>
    pub aws_elbv2_load_balancer: std::option::Option<crate::model::AwsElbv2LoadBalancerDetails>,
    /// <p>Details about an Elastic Beanstalk environment.</p>
    pub aws_elastic_beanstalk_environment:
        std::option::Option<crate::model::AwsElasticBeanstalkEnvironmentDetails>,
    /// <p>Details for an Elasticsearch domain.</p>
    pub aws_elasticsearch_domain: std::option::Option<crate::model::AwsElasticsearchDomainDetails>,
    /// <p>Details about an S3 bucket related to a finding.</p>
    pub aws_s3_bucket: std::option::Option<crate::model::AwsS3BucketDetails>,
    /// <p>Details about the Amazon S3 Public Access Block configuration for an account.</p>
    pub aws_s3_account_public_access_block:
        std::option::Option<crate::model::AwsS3AccountPublicAccessBlockDetails>,
    /// <p>Details about an S3 object related to a finding.</p>
    pub aws_s3_object: std::option::Option<crate::model::AwsS3ObjectDetails>,
    /// <p>Details about a Secrets Manager secret.</p>
    pub aws_secrets_manager_secret:
        std::option::Option<crate::model::AwsSecretsManagerSecretDetails>,
    /// <p>Details about an IAM access key related to a finding.</p>
    pub aws_iam_access_key: std::option::Option<crate::model::AwsIamAccessKeyDetails>,
    /// <p>Details about an IAM user.</p>
    pub aws_iam_user: std::option::Option<crate::model::AwsIamUserDetails>,
    /// <p>Details about an IAM permissions policy.</p>
    pub aws_iam_policy: std::option::Option<crate::model::AwsIamPolicyDetails>,
    /// <p>Provides information about a version 2 stage for Amazon API Gateway.</p>
    pub aws_api_gateway_v2_stage: std::option::Option<crate::model::AwsApiGatewayV2StageDetails>,
    /// <p>Provides information about a version 2 API in Amazon API Gateway.</p>
    pub aws_api_gateway_v2_api: std::option::Option<crate::model::AwsApiGatewayV2ApiDetails>,
    /// <p>Details about a DynamoDB table.</p>
    pub aws_dynamo_db_table: std::option::Option<crate::model::AwsDynamoDbTableDetails>,
    /// <p>Provides information about a version 1 Amazon API Gateway stage.</p>
    pub aws_api_gateway_stage: std::option::Option<crate::model::AwsApiGatewayStageDetails>,
    /// <p>Provides information about a REST API in version 1 of Amazon API Gateway.</p>
    pub aws_api_gateway_rest_api: std::option::Option<crate::model::AwsApiGatewayRestApiDetails>,
    /// <p>Provides details about a CloudTrail trail.</p>
    pub aws_cloud_trail_trail: std::option::Option<crate::model::AwsCloudTrailTrailDetails>,
    /// <p>Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.</p>
    pub aws_ssm_patch_compliance: std::option::Option<crate::model::AwsSsmPatchComplianceDetails>,
    /// <p>Provides details about an Certificate Manager certificate.</p>
    pub aws_certificate_manager_certificate:
        std::option::Option<crate::model::AwsCertificateManagerCertificateDetails>,
    /// <p>Contains details about an Amazon Redshift cluster.</p>
    pub aws_redshift_cluster: std::option::Option<crate::model::AwsRedshiftClusterDetails>,
    /// <p>Contains details about a Classic Load Balancer.</p>
    pub aws_elb_load_balancer: std::option::Option<crate::model::AwsElbLoadBalancerDetails>,
    /// <p>Contains details about an IAM group.</p>
    pub aws_iam_group: std::option::Option<crate::model::AwsIamGroupDetails>,
    /// <p>Details about an IAM role.</p>
    pub aws_iam_role: std::option::Option<crate::model::AwsIamRoleDetails>,
    /// <p>Details about an KMS key.</p>
    pub aws_kms_key: std::option::Option<crate::model::AwsKmsKeyDetails>,
    /// <p>Details about a Lambda function.</p>
    pub aws_lambda_function: std::option::Option<crate::model::AwsLambdaFunctionDetails>,
    /// <p>Details for a Lambda layer version.</p>
    pub aws_lambda_layer_version: std::option::Option<crate::model::AwsLambdaLayerVersionDetails>,
    /// <p>Details about an Amazon RDS database instance.</p>
    pub aws_rds_db_instance: std::option::Option<crate::model::AwsRdsDbInstanceDetails>,
    /// <p>Details about an SNS topic.</p>
    pub aws_sns_topic: std::option::Option<crate::model::AwsSnsTopicDetails>,
    /// <p>Details about an SQS queue.</p>
    pub aws_sqs_queue: std::option::Option<crate::model::AwsSqsQueueDetails>,
    /// <p>Details for an WAF WebACL.</p>
    pub aws_waf_web_acl: std::option::Option<crate::model::AwsWafWebAclDetails>,
    /// <p>Details about an Amazon RDS database snapshot.</p>
    pub aws_rds_db_snapshot: std::option::Option<crate::model::AwsRdsDbSnapshotDetails>,
    /// <p>Details about an Amazon RDS database cluster snapshot.</p>
    pub aws_rds_db_cluster_snapshot:
        std::option::Option<crate::model::AwsRdsDbClusterSnapshotDetails>,
    /// <p>Details about an Amazon RDS database cluster.</p>
    pub aws_rds_db_cluster: std::option::Option<crate::model::AwsRdsDbClusterDetails>,
    /// <p>Details about an ECS cluster.</p>
    pub aws_ecs_cluster: std::option::Option<crate::model::AwsEcsClusterDetails>,
    /// <p>Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>
    pub aws_ecs_task_definition: std::option::Option<crate::model::AwsEcsTaskDefinitionDetails>,
    /// <p>Details about a container resource related to a finding.</p>
    pub container: std::option::Option<crate::model::ContainerDetails>,
    /// <p>Details about a resource that are not available in a type-specific details object. Use
    /// the <code>Other</code> object in the following cases.</p>
    /// <ul>
    /// <li>
    /// <p>The type-specific object does not contain all of the fields that you want to
    /// populate. In this case, first use the type-specific object to populate those fields.
    /// Use the <code>Other</code> object to populate the fields that are missing from the
    /// type-specific object.</p>
    /// </li>
    /// <li>
    /// <p>The resource type does not have a corresponding object. This includes resources
    /// for which the type is <code>Other</code>. </p>
    /// </li>
    /// </ul>
    pub other:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Details about an RDS event notification subscription.</p>
    pub aws_rds_event_subscription:
        std::option::Option<crate::model::AwsRdsEventSubscriptionDetails>,
    /// <p>Details about a service within an ECS cluster.</p>
    pub aws_ecs_service: std::option::Option<crate::model::AwsEcsServiceDetails>,
    /// <p>Provides details about a launch configuration.</p>
    pub aws_auto_scaling_launch_configuration:
        std::option::Option<crate::model::AwsAutoScalingLaunchConfigurationDetails>,
    /// <p>Details about an EC2 VPN connection.</p>
    pub aws_ec2_vpn_connection: std::option::Option<crate::model::AwsEc2VpnConnectionDetails>,
    /// <p>Information about an Amazon ECR image.</p>
    pub aws_ecr_container_image: std::option::Option<crate::model::AwsEcrContainerImageDetails>,
    /// <p>Details about an Amazon OpenSearch Service domain.</p>
    pub aws_open_search_service_domain:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainDetails>,
    /// <p>Details about the service configuration for a VPC endpoint service.</p>
    pub aws_ec2_vpc_endpoint_service:
        std::option::Option<crate::model::AwsEc2VpcEndpointServiceDetails>,
    /// <p>Information about the encryption configuration for X-Ray.</p>
    pub aws_xray_encryption_config:
        std::option::Option<crate::model::AwsXrayEncryptionConfigDetails>,
    /// <p>Details about a rate-based rule for global resources.</p>
    pub aws_waf_rate_based_rule: std::option::Option<crate::model::AwsWafRateBasedRuleDetails>,
    /// <p>Details about a rate-based rule for Regional resources.</p>
    pub aws_waf_regional_rate_based_rule:
        std::option::Option<crate::model::AwsWafRegionalRateBasedRuleDetails>,
    /// <p>Information about an Amazon Elastic Container Registry repository.</p>
    pub aws_ecr_repository: std::option::Option<crate::model::AwsEcrRepositoryDetails>,
    /// <p>Details about an Amazon EKS cluster.</p>
    pub aws_eks_cluster: std::option::Option<crate::model::AwsEksClusterDetails>,
}
impl std::fmt::Debug for ResourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDetails");
        formatter.field(
            "aws_auto_scaling_auto_scaling_group",
            &self.aws_auto_scaling_auto_scaling_group,
        );
        formatter.field("aws_code_build_project", &self.aws_code_build_project);
        formatter.field(
            "aws_cloud_front_distribution",
            &self.aws_cloud_front_distribution,
        );
        formatter.field("aws_ec2_instance", &self.aws_ec2_instance);
        formatter.field("aws_ec2_network_interface", &self.aws_ec2_network_interface);
        formatter.field("aws_ec2_security_group", &self.aws_ec2_security_group);
        formatter.field("aws_ec2_volume", &self.aws_ec2_volume);
        formatter.field("aws_ec2_vpc", &self.aws_ec2_vpc);
        formatter.field("aws_ec2_eip", &self.aws_ec2_eip);
        formatter.field("aws_ec2_subnet", &self.aws_ec2_subnet);
        formatter.field("aws_ec2_network_acl", &self.aws_ec2_network_acl);
        formatter.field("aws_elbv2_load_balancer", &self.aws_elbv2_load_balancer);
        formatter.field(
            "aws_elastic_beanstalk_environment",
            &self.aws_elastic_beanstalk_environment,
        );
        formatter.field("aws_elasticsearch_domain", &self.aws_elasticsearch_domain);
        formatter.field("aws_s3_bucket", &self.aws_s3_bucket);
        formatter.field(
            "aws_s3_account_public_access_block",
            &self.aws_s3_account_public_access_block,
        );
        formatter.field("aws_s3_object", &self.aws_s3_object);
        formatter.field(
            "aws_secrets_manager_secret",
            &self.aws_secrets_manager_secret,
        );
        formatter.field("aws_iam_access_key", &self.aws_iam_access_key);
        formatter.field("aws_iam_user", &self.aws_iam_user);
        formatter.field("aws_iam_policy", &self.aws_iam_policy);
        formatter.field("aws_api_gateway_v2_stage", &self.aws_api_gateway_v2_stage);
        formatter.field("aws_api_gateway_v2_api", &self.aws_api_gateway_v2_api);
        formatter.field("aws_dynamo_db_table", &self.aws_dynamo_db_table);
        formatter.field("aws_api_gateway_stage", &self.aws_api_gateway_stage);
        formatter.field("aws_api_gateway_rest_api", &self.aws_api_gateway_rest_api);
        formatter.field("aws_cloud_trail_trail", &self.aws_cloud_trail_trail);
        formatter.field("aws_ssm_patch_compliance", &self.aws_ssm_patch_compliance);
        formatter.field(
            "aws_certificate_manager_certificate",
            &self.aws_certificate_manager_certificate,
        );
        formatter.field("aws_redshift_cluster", &self.aws_redshift_cluster);
        formatter.field("aws_elb_load_balancer", &self.aws_elb_load_balancer);
        formatter.field("aws_iam_group", &self.aws_iam_group);
        formatter.field("aws_iam_role", &self.aws_iam_role);
        formatter.field("aws_kms_key", &self.aws_kms_key);
        formatter.field("aws_lambda_function", &self.aws_lambda_function);
        formatter.field("aws_lambda_layer_version", &self.aws_lambda_layer_version);
        formatter.field("aws_rds_db_instance", &self.aws_rds_db_instance);
        formatter.field("aws_sns_topic", &self.aws_sns_topic);
        formatter.field("aws_sqs_queue", &self.aws_sqs_queue);
        formatter.field("aws_waf_web_acl", &self.aws_waf_web_acl);
        formatter.field("aws_rds_db_snapshot", &self.aws_rds_db_snapshot);
        formatter.field(
            "aws_rds_db_cluster_snapshot",
            &self.aws_rds_db_cluster_snapshot,
        );
        formatter.field("aws_rds_db_cluster", &self.aws_rds_db_cluster);
        formatter.field("aws_ecs_cluster", &self.aws_ecs_cluster);
        formatter.field("aws_ecs_task_definition", &self.aws_ecs_task_definition);
        formatter.field("container", &self.container);
        formatter.field("other", &self.other);
        formatter.field(
            "aws_rds_event_subscription",
            &self.aws_rds_event_subscription,
        );
        formatter.field("aws_ecs_service", &self.aws_ecs_service);
        formatter.field(
            "aws_auto_scaling_launch_configuration",
            &self.aws_auto_scaling_launch_configuration,
        );
        formatter.field("aws_ec2_vpn_connection", &self.aws_ec2_vpn_connection);
        formatter.field("aws_ecr_container_image", &self.aws_ecr_container_image);
        formatter.field(
            "aws_open_search_service_domain",
            &self.aws_open_search_service_domain,
        );
        formatter.field(
            "aws_ec2_vpc_endpoint_service",
            &self.aws_ec2_vpc_endpoint_service,
        );
        formatter.field(
            "aws_xray_encryption_config",
            &self.aws_xray_encryption_config,
        );
        formatter.field("aws_waf_rate_based_rule", &self.aws_waf_rate_based_rule);
        formatter.field(
            "aws_waf_regional_rate_based_rule",
            &self.aws_waf_regional_rate_based_rule,
        );
        formatter.field("aws_ecr_repository", &self.aws_ecr_repository);
        formatter.field("aws_eks_cluster", &self.aws_eks_cluster);
        formatter.finish()
    }
}
/// See [`ResourceDetails`](crate::model::ResourceDetails)
pub mod resource_details {
    /// A builder for [`ResourceDetails`](crate::model::ResourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_auto_scaling_auto_scaling_group:
            std::option::Option<crate::model::AwsAutoScalingAutoScalingGroupDetails>,
        pub(crate) aws_code_build_project:
            std::option::Option<crate::model::AwsCodeBuildProjectDetails>,
        pub(crate) aws_cloud_front_distribution:
            std::option::Option<crate::model::AwsCloudFrontDistributionDetails>,
        pub(crate) aws_ec2_instance: std::option::Option<crate::model::AwsEc2InstanceDetails>,
        pub(crate) aws_ec2_network_interface:
            std::option::Option<crate::model::AwsEc2NetworkInterfaceDetails>,
        pub(crate) aws_ec2_security_group:
            std::option::Option<crate::model::AwsEc2SecurityGroupDetails>,
        pub(crate) aws_ec2_volume: std::option::Option<crate::model::AwsEc2VolumeDetails>,
        pub(crate) aws_ec2_vpc: std::option::Option<crate::model::AwsEc2VpcDetails>,
        pub(crate) aws_ec2_eip: std::option::Option<crate::model::AwsEc2EipDetails>,
        pub(crate) aws_ec2_subnet: std::option::Option<crate::model::AwsEc2SubnetDetails>,
        pub(crate) aws_ec2_network_acl: std::option::Option<crate::model::AwsEc2NetworkAclDetails>,
        pub(crate) aws_elbv2_load_balancer:
            std::option::Option<crate::model::AwsElbv2LoadBalancerDetails>,
        pub(crate) aws_elastic_beanstalk_environment:
            std::option::Option<crate::model::AwsElasticBeanstalkEnvironmentDetails>,
        pub(crate) aws_elasticsearch_domain:
            std::option::Option<crate::model::AwsElasticsearchDomainDetails>,
        pub(crate) aws_s3_bucket: std::option::Option<crate::model::AwsS3BucketDetails>,
        pub(crate) aws_s3_account_public_access_block:
            std::option::Option<crate::model::AwsS3AccountPublicAccessBlockDetails>,
        pub(crate) aws_s3_object: std::option::Option<crate::model::AwsS3ObjectDetails>,
        pub(crate) aws_secrets_manager_secret:
            std::option::Option<crate::model::AwsSecretsManagerSecretDetails>,
        pub(crate) aws_iam_access_key: std::option::Option<crate::model::AwsIamAccessKeyDetails>,
        pub(crate) aws_iam_user: std::option::Option<crate::model::AwsIamUserDetails>,
        pub(crate) aws_iam_policy: std::option::Option<crate::model::AwsIamPolicyDetails>,
        pub(crate) aws_api_gateway_v2_stage:
            std::option::Option<crate::model::AwsApiGatewayV2StageDetails>,
        pub(crate) aws_api_gateway_v2_api:
            std::option::Option<crate::model::AwsApiGatewayV2ApiDetails>,
        pub(crate) aws_dynamo_db_table: std::option::Option<crate::model::AwsDynamoDbTableDetails>,
        pub(crate) aws_api_gateway_stage:
            std::option::Option<crate::model::AwsApiGatewayStageDetails>,
        pub(crate) aws_api_gateway_rest_api:
            std::option::Option<crate::model::AwsApiGatewayRestApiDetails>,
        pub(crate) aws_cloud_trail_trail:
            std::option::Option<crate::model::AwsCloudTrailTrailDetails>,
        pub(crate) aws_ssm_patch_compliance:
            std::option::Option<crate::model::AwsSsmPatchComplianceDetails>,
        pub(crate) aws_certificate_manager_certificate:
            std::option::Option<crate::model::AwsCertificateManagerCertificateDetails>,
        pub(crate) aws_redshift_cluster:
            std::option::Option<crate::model::AwsRedshiftClusterDetails>,
        pub(crate) aws_elb_load_balancer:
            std::option::Option<crate::model::AwsElbLoadBalancerDetails>,
        pub(crate) aws_iam_group: std::option::Option<crate::model::AwsIamGroupDetails>,
        pub(crate) aws_iam_role: std::option::Option<crate::model::AwsIamRoleDetails>,
        pub(crate) aws_kms_key: std::option::Option<crate::model::AwsKmsKeyDetails>,
        pub(crate) aws_lambda_function: std::option::Option<crate::model::AwsLambdaFunctionDetails>,
        pub(crate) aws_lambda_layer_version:
            std::option::Option<crate::model::AwsLambdaLayerVersionDetails>,
        pub(crate) aws_rds_db_instance: std::option::Option<crate::model::AwsRdsDbInstanceDetails>,
        pub(crate) aws_sns_topic: std::option::Option<crate::model::AwsSnsTopicDetails>,
        pub(crate) aws_sqs_queue: std::option::Option<crate::model::AwsSqsQueueDetails>,
        pub(crate) aws_waf_web_acl: std::option::Option<crate::model::AwsWafWebAclDetails>,
        pub(crate) aws_rds_db_snapshot: std::option::Option<crate::model::AwsRdsDbSnapshotDetails>,
        pub(crate) aws_rds_db_cluster_snapshot:
            std::option::Option<crate::model::AwsRdsDbClusterSnapshotDetails>,
        pub(crate) aws_rds_db_cluster: std::option::Option<crate::model::AwsRdsDbClusterDetails>,
        pub(crate) aws_ecs_cluster: std::option::Option<crate::model::AwsEcsClusterDetails>,
        pub(crate) aws_ecs_task_definition:
            std::option::Option<crate::model::AwsEcsTaskDefinitionDetails>,
        pub(crate) container: std::option::Option<crate::model::ContainerDetails>,
        pub(crate) other: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) aws_rds_event_subscription:
            std::option::Option<crate::model::AwsRdsEventSubscriptionDetails>,
        pub(crate) aws_ecs_service: std::option::Option<crate::model::AwsEcsServiceDetails>,
        pub(crate) aws_auto_scaling_launch_configuration:
            std::option::Option<crate::model::AwsAutoScalingLaunchConfigurationDetails>,
        pub(crate) aws_ec2_vpn_connection:
            std::option::Option<crate::model::AwsEc2VpnConnectionDetails>,
        pub(crate) aws_ecr_container_image:
            std::option::Option<crate::model::AwsEcrContainerImageDetails>,
        pub(crate) aws_open_search_service_domain:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainDetails>,
        pub(crate) aws_ec2_vpc_endpoint_service:
            std::option::Option<crate::model::AwsEc2VpcEndpointServiceDetails>,
        pub(crate) aws_xray_encryption_config:
            std::option::Option<crate::model::AwsXrayEncryptionConfigDetails>,
        pub(crate) aws_waf_rate_based_rule:
            std::option::Option<crate::model::AwsWafRateBasedRuleDetails>,
        pub(crate) aws_waf_regional_rate_based_rule:
            std::option::Option<crate::model::AwsWafRegionalRateBasedRuleDetails>,
        pub(crate) aws_ecr_repository: std::option::Option<crate::model::AwsEcrRepositoryDetails>,
        pub(crate) aws_eks_cluster: std::option::Option<crate::model::AwsEksClusterDetails>,
    }
    impl Builder {
        /// <p>Details for an autoscaling group.</p>
        pub fn aws_auto_scaling_auto_scaling_group(
            mut self,
            input: crate::model::AwsAutoScalingAutoScalingGroupDetails,
        ) -> Self {
            self.aws_auto_scaling_auto_scaling_group = Some(input);
            self
        }
        /// <p>Details for an autoscaling group.</p>
        pub fn set_aws_auto_scaling_auto_scaling_group(
            mut self,
            input: std::option::Option<crate::model::AwsAutoScalingAutoScalingGroupDetails>,
        ) -> Self {
            self.aws_auto_scaling_auto_scaling_group = input;
            self
        }
        /// <p>Details for an CodeBuild project.</p>
        pub fn aws_code_build_project(
            mut self,
            input: crate::model::AwsCodeBuildProjectDetails,
        ) -> Self {
            self.aws_code_build_project = Some(input);
            self
        }
        /// <p>Details for an CodeBuild project.</p>
        pub fn set_aws_code_build_project(
            mut self,
            input: std::option::Option<crate::model::AwsCodeBuildProjectDetails>,
        ) -> Self {
            self.aws_code_build_project = input;
            self
        }
        /// <p>Details about a CloudFront distribution.</p>
        pub fn aws_cloud_front_distribution(
            mut self,
            input: crate::model::AwsCloudFrontDistributionDetails,
        ) -> Self {
            self.aws_cloud_front_distribution = Some(input);
            self
        }
        /// <p>Details about a CloudFront distribution.</p>
        pub fn set_aws_cloud_front_distribution(
            mut self,
            input: std::option::Option<crate::model::AwsCloudFrontDistributionDetails>,
        ) -> Self {
            self.aws_cloud_front_distribution = input;
            self
        }
        /// <p>Details about an EC2 instance related to a finding.</p>
        pub fn aws_ec2_instance(mut self, input: crate::model::AwsEc2InstanceDetails) -> Self {
            self.aws_ec2_instance = Some(input);
            self
        }
        /// <p>Details about an EC2 instance related to a finding.</p>
        pub fn set_aws_ec2_instance(
            mut self,
            input: std::option::Option<crate::model::AwsEc2InstanceDetails>,
        ) -> Self {
            self.aws_ec2_instance = input;
            self
        }
        /// <p>Details for an EC2 network interface.</p>
        pub fn aws_ec2_network_interface(
            mut self,
            input: crate::model::AwsEc2NetworkInterfaceDetails,
        ) -> Self {
            self.aws_ec2_network_interface = Some(input);
            self
        }
        /// <p>Details for an EC2 network interface.</p>
        pub fn set_aws_ec2_network_interface(
            mut self,
            input: std::option::Option<crate::model::AwsEc2NetworkInterfaceDetails>,
        ) -> Self {
            self.aws_ec2_network_interface = input;
            self
        }
        /// <p>Details for an EC2 security group.</p>
        pub fn aws_ec2_security_group(
            mut self,
            input: crate::model::AwsEc2SecurityGroupDetails,
        ) -> Self {
            self.aws_ec2_security_group = Some(input);
            self
        }
        /// <p>Details for an EC2 security group.</p>
        pub fn set_aws_ec2_security_group(
            mut self,
            input: std::option::Option<crate::model::AwsEc2SecurityGroupDetails>,
        ) -> Self {
            self.aws_ec2_security_group = input;
            self
        }
        /// <p>Details for an EC2 volume.</p>
        pub fn aws_ec2_volume(mut self, input: crate::model::AwsEc2VolumeDetails) -> Self {
            self.aws_ec2_volume = Some(input);
            self
        }
        /// <p>Details for an EC2 volume.</p>
        pub fn set_aws_ec2_volume(
            mut self,
            input: std::option::Option<crate::model::AwsEc2VolumeDetails>,
        ) -> Self {
            self.aws_ec2_volume = input;
            self
        }
        /// <p>Details for an EC2 VPC.</p>
        pub fn aws_ec2_vpc(mut self, input: crate::model::AwsEc2VpcDetails) -> Self {
            self.aws_ec2_vpc = Some(input);
            self
        }
        /// <p>Details for an EC2 VPC.</p>
        pub fn set_aws_ec2_vpc(
            mut self,
            input: std::option::Option<crate::model::AwsEc2VpcDetails>,
        ) -> Self {
            self.aws_ec2_vpc = input;
            self
        }
        /// <p>Details about an Elastic IP address.</p>
        pub fn aws_ec2_eip(mut self, input: crate::model::AwsEc2EipDetails) -> Self {
            self.aws_ec2_eip = Some(input);
            self
        }
        /// <p>Details about an Elastic IP address.</p>
        pub fn set_aws_ec2_eip(
            mut self,
            input: std::option::Option<crate::model::AwsEc2EipDetails>,
        ) -> Self {
            self.aws_ec2_eip = input;
            self
        }
        /// <p>Details about a subnet in Amazon EC2.</p>
        pub fn aws_ec2_subnet(mut self, input: crate::model::AwsEc2SubnetDetails) -> Self {
            self.aws_ec2_subnet = Some(input);
            self
        }
        /// <p>Details about a subnet in Amazon EC2.</p>
        pub fn set_aws_ec2_subnet(
            mut self,
            input: std::option::Option<crate::model::AwsEc2SubnetDetails>,
        ) -> Self {
            self.aws_ec2_subnet = input;
            self
        }
        /// <p>Details about an EC2 network access control list (ACL).</p>
        pub fn aws_ec2_network_acl(mut self, input: crate::model::AwsEc2NetworkAclDetails) -> Self {
            self.aws_ec2_network_acl = Some(input);
            self
        }
        /// <p>Details about an EC2 network access control list (ACL).</p>
        pub fn set_aws_ec2_network_acl(
            mut self,
            input: std::option::Option<crate::model::AwsEc2NetworkAclDetails>,
        ) -> Self {
            self.aws_ec2_network_acl = input;
            self
        }
        /// <p>Details about a load balancer.</p>
        pub fn aws_elbv2_load_balancer(
            mut self,
            input: crate::model::AwsElbv2LoadBalancerDetails,
        ) -> Self {
            self.aws_elbv2_load_balancer = Some(input);
            self
        }
        /// <p>Details about a load balancer.</p>
        pub fn set_aws_elbv2_load_balancer(
            mut self,
            input: std::option::Option<crate::model::AwsElbv2LoadBalancerDetails>,
        ) -> Self {
            self.aws_elbv2_load_balancer = input;
            self
        }
        /// <p>Details about an Elastic Beanstalk environment.</p>
        pub fn aws_elastic_beanstalk_environment(
            mut self,
            input: crate::model::AwsElasticBeanstalkEnvironmentDetails,
        ) -> Self {
            self.aws_elastic_beanstalk_environment = Some(input);
            self
        }
        /// <p>Details about an Elastic Beanstalk environment.</p>
        pub fn set_aws_elastic_beanstalk_environment(
            mut self,
            input: std::option::Option<crate::model::AwsElasticBeanstalkEnvironmentDetails>,
        ) -> Self {
            self.aws_elastic_beanstalk_environment = input;
            self
        }
        /// <p>Details for an Elasticsearch domain.</p>
        pub fn aws_elasticsearch_domain(
            mut self,
            input: crate::model::AwsElasticsearchDomainDetails,
        ) -> Self {
            self.aws_elasticsearch_domain = Some(input);
            self
        }
        /// <p>Details for an Elasticsearch domain.</p>
        pub fn set_aws_elasticsearch_domain(
            mut self,
            input: std::option::Option<crate::model::AwsElasticsearchDomainDetails>,
        ) -> Self {
            self.aws_elasticsearch_domain = input;
            self
        }
        /// <p>Details about an S3 bucket related to a finding.</p>
        pub fn aws_s3_bucket(mut self, input: crate::model::AwsS3BucketDetails) -> Self {
            self.aws_s3_bucket = Some(input);
            self
        }
        /// <p>Details about an S3 bucket related to a finding.</p>
        pub fn set_aws_s3_bucket(
            mut self,
            input: std::option::Option<crate::model::AwsS3BucketDetails>,
        ) -> Self {
            self.aws_s3_bucket = input;
            self
        }
        /// <p>Details about the Amazon S3 Public Access Block configuration for an account.</p>
        pub fn aws_s3_account_public_access_block(
            mut self,
            input: crate::model::AwsS3AccountPublicAccessBlockDetails,
        ) -> Self {
            self.aws_s3_account_public_access_block = Some(input);
            self
        }
        /// <p>Details about the Amazon S3 Public Access Block configuration for an account.</p>
        pub fn set_aws_s3_account_public_access_block(
            mut self,
            input: std::option::Option<crate::model::AwsS3AccountPublicAccessBlockDetails>,
        ) -> Self {
            self.aws_s3_account_public_access_block = input;
            self
        }
        /// <p>Details about an S3 object related to a finding.</p>
        pub fn aws_s3_object(mut self, input: crate::model::AwsS3ObjectDetails) -> Self {
            self.aws_s3_object = Some(input);
            self
        }
        /// <p>Details about an S3 object related to a finding.</p>
        pub fn set_aws_s3_object(
            mut self,
            input: std::option::Option<crate::model::AwsS3ObjectDetails>,
        ) -> Self {
            self.aws_s3_object = input;
            self
        }
        /// <p>Details about a Secrets Manager secret.</p>
        pub fn aws_secrets_manager_secret(
            mut self,
            input: crate::model::AwsSecretsManagerSecretDetails,
        ) -> Self {
            self.aws_secrets_manager_secret = Some(input);
            self
        }
        /// <p>Details about a Secrets Manager secret.</p>
        pub fn set_aws_secrets_manager_secret(
            mut self,
            input: std::option::Option<crate::model::AwsSecretsManagerSecretDetails>,
        ) -> Self {
            self.aws_secrets_manager_secret = input;
            self
        }
        /// <p>Details about an IAM access key related to a finding.</p>
        pub fn aws_iam_access_key(mut self, input: crate::model::AwsIamAccessKeyDetails) -> Self {
            self.aws_iam_access_key = Some(input);
            self
        }
        /// <p>Details about an IAM access key related to a finding.</p>
        pub fn set_aws_iam_access_key(
            mut self,
            input: std::option::Option<crate::model::AwsIamAccessKeyDetails>,
        ) -> Self {
            self.aws_iam_access_key = input;
            self
        }
        /// <p>Details about an IAM user.</p>
        pub fn aws_iam_user(mut self, input: crate::model::AwsIamUserDetails) -> Self {
            self.aws_iam_user = Some(input);
            self
        }
        /// <p>Details about an IAM user.</p>
        pub fn set_aws_iam_user(
            mut self,
            input: std::option::Option<crate::model::AwsIamUserDetails>,
        ) -> Self {
            self.aws_iam_user = input;
            self
        }
        /// <p>Details about an IAM permissions policy.</p>
        pub fn aws_iam_policy(mut self, input: crate::model::AwsIamPolicyDetails) -> Self {
            self.aws_iam_policy = Some(input);
            self
        }
        /// <p>Details about an IAM permissions policy.</p>
        pub fn set_aws_iam_policy(
            mut self,
            input: std::option::Option<crate::model::AwsIamPolicyDetails>,
        ) -> Self {
            self.aws_iam_policy = input;
            self
        }
        /// <p>Provides information about a version 2 stage for Amazon API Gateway.</p>
        pub fn aws_api_gateway_v2_stage(
            mut self,
            input: crate::model::AwsApiGatewayV2StageDetails,
        ) -> Self {
            self.aws_api_gateway_v2_stage = Some(input);
            self
        }
        /// <p>Provides information about a version 2 stage for Amazon API Gateway.</p>
        pub fn set_aws_api_gateway_v2_stage(
            mut self,
            input: std::option::Option<crate::model::AwsApiGatewayV2StageDetails>,
        ) -> Self {
            self.aws_api_gateway_v2_stage = input;
            self
        }
        /// <p>Provides information about a version 2 API in Amazon API Gateway.</p>
        pub fn aws_api_gateway_v2_api(
            mut self,
            input: crate::model::AwsApiGatewayV2ApiDetails,
        ) -> Self {
            self.aws_api_gateway_v2_api = Some(input);
            self
        }
        /// <p>Provides information about a version 2 API in Amazon API Gateway.</p>
        pub fn set_aws_api_gateway_v2_api(
            mut self,
            input: std::option::Option<crate::model::AwsApiGatewayV2ApiDetails>,
        ) -> Self {
            self.aws_api_gateway_v2_api = input;
            self
        }
        /// <p>Details about a DynamoDB table.</p>
        pub fn aws_dynamo_db_table(mut self, input: crate::model::AwsDynamoDbTableDetails) -> Self {
            self.aws_dynamo_db_table = Some(input);
            self
        }
        /// <p>Details about a DynamoDB table.</p>
        pub fn set_aws_dynamo_db_table(
            mut self,
            input: std::option::Option<crate::model::AwsDynamoDbTableDetails>,
        ) -> Self {
            self.aws_dynamo_db_table = input;
            self
        }
        /// <p>Provides information about a version 1 Amazon API Gateway stage.</p>
        pub fn aws_api_gateway_stage(
            mut self,
            input: crate::model::AwsApiGatewayStageDetails,
        ) -> Self {
            self.aws_api_gateway_stage = Some(input);
            self
        }
        /// <p>Provides information about a version 1 Amazon API Gateway stage.</p>
        pub fn set_aws_api_gateway_stage(
            mut self,
            input: std::option::Option<crate::model::AwsApiGatewayStageDetails>,
        ) -> Self {
            self.aws_api_gateway_stage = input;
            self
        }
        /// <p>Provides information about a REST API in version 1 of Amazon API Gateway.</p>
        pub fn aws_api_gateway_rest_api(
            mut self,
            input: crate::model::AwsApiGatewayRestApiDetails,
        ) -> Self {
            self.aws_api_gateway_rest_api = Some(input);
            self
        }
        /// <p>Provides information about a REST API in version 1 of Amazon API Gateway.</p>
        pub fn set_aws_api_gateway_rest_api(
            mut self,
            input: std::option::Option<crate::model::AwsApiGatewayRestApiDetails>,
        ) -> Self {
            self.aws_api_gateway_rest_api = input;
            self
        }
        /// <p>Provides details about a CloudTrail trail.</p>
        pub fn aws_cloud_trail_trail(
            mut self,
            input: crate::model::AwsCloudTrailTrailDetails,
        ) -> Self {
            self.aws_cloud_trail_trail = Some(input);
            self
        }
        /// <p>Provides details about a CloudTrail trail.</p>
        pub fn set_aws_cloud_trail_trail(
            mut self,
            input: std::option::Option<crate::model::AwsCloudTrailTrailDetails>,
        ) -> Self {
            self.aws_cloud_trail_trail = input;
            self
        }
        /// <p>Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.</p>
        pub fn aws_ssm_patch_compliance(
            mut self,
            input: crate::model::AwsSsmPatchComplianceDetails,
        ) -> Self {
            self.aws_ssm_patch_compliance = Some(input);
            self
        }
        /// <p>Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.</p>
        pub fn set_aws_ssm_patch_compliance(
            mut self,
            input: std::option::Option<crate::model::AwsSsmPatchComplianceDetails>,
        ) -> Self {
            self.aws_ssm_patch_compliance = input;
            self
        }
        /// <p>Provides details about an Certificate Manager certificate.</p>
        pub fn aws_certificate_manager_certificate(
            mut self,
            input: crate::model::AwsCertificateManagerCertificateDetails,
        ) -> Self {
            self.aws_certificate_manager_certificate = Some(input);
            self
        }
        /// <p>Provides details about an Certificate Manager certificate.</p>
        pub fn set_aws_certificate_manager_certificate(
            mut self,
            input: std::option::Option<crate::model::AwsCertificateManagerCertificateDetails>,
        ) -> Self {
            self.aws_certificate_manager_certificate = input;
            self
        }
        /// <p>Contains details about an Amazon Redshift cluster.</p>
        pub fn aws_redshift_cluster(
            mut self,
            input: crate::model::AwsRedshiftClusterDetails,
        ) -> Self {
            self.aws_redshift_cluster = Some(input);
            self
        }
        /// <p>Contains details about an Amazon Redshift cluster.</p>
        pub fn set_aws_redshift_cluster(
            mut self,
            input: std::option::Option<crate::model::AwsRedshiftClusterDetails>,
        ) -> Self {
            self.aws_redshift_cluster = input;
            self
        }
        /// <p>Contains details about a Classic Load Balancer.</p>
        pub fn aws_elb_load_balancer(
            mut self,
            input: crate::model::AwsElbLoadBalancerDetails,
        ) -> Self {
            self.aws_elb_load_balancer = Some(input);
            self
        }
        /// <p>Contains details about a Classic Load Balancer.</p>
        pub fn set_aws_elb_load_balancer(
            mut self,
            input: std::option::Option<crate::model::AwsElbLoadBalancerDetails>,
        ) -> Self {
            self.aws_elb_load_balancer = input;
            self
        }
        /// <p>Contains details about an IAM group.</p>
        pub fn aws_iam_group(mut self, input: crate::model::AwsIamGroupDetails) -> Self {
            self.aws_iam_group = Some(input);
            self
        }
        /// <p>Contains details about an IAM group.</p>
        pub fn set_aws_iam_group(
            mut self,
            input: std::option::Option<crate::model::AwsIamGroupDetails>,
        ) -> Self {
            self.aws_iam_group = input;
            self
        }
        /// <p>Details about an IAM role.</p>
        pub fn aws_iam_role(mut self, input: crate::model::AwsIamRoleDetails) -> Self {
            self.aws_iam_role = Some(input);
            self
        }
        /// <p>Details about an IAM role.</p>
        pub fn set_aws_iam_role(
            mut self,
            input: std::option::Option<crate::model::AwsIamRoleDetails>,
        ) -> Self {
            self.aws_iam_role = input;
            self
        }
        /// <p>Details about an KMS key.</p>
        pub fn aws_kms_key(mut self, input: crate::model::AwsKmsKeyDetails) -> Self {
            self.aws_kms_key = Some(input);
            self
        }
        /// <p>Details about an KMS key.</p>
        pub fn set_aws_kms_key(
            mut self,
            input: std::option::Option<crate::model::AwsKmsKeyDetails>,
        ) -> Self {
            self.aws_kms_key = input;
            self
        }
        /// <p>Details about a Lambda function.</p>
        pub fn aws_lambda_function(
            mut self,
            input: crate::model::AwsLambdaFunctionDetails,
        ) -> Self {
            self.aws_lambda_function = Some(input);
            self
        }
        /// <p>Details about a Lambda function.</p>
        pub fn set_aws_lambda_function(
            mut self,
            input: std::option::Option<crate::model::AwsLambdaFunctionDetails>,
        ) -> Self {
            self.aws_lambda_function = input;
            self
        }
        /// <p>Details for a Lambda layer version.</p>
        pub fn aws_lambda_layer_version(
            mut self,
            input: crate::model::AwsLambdaLayerVersionDetails,
        ) -> Self {
            self.aws_lambda_layer_version = Some(input);
            self
        }
        /// <p>Details for a Lambda layer version.</p>
        pub fn set_aws_lambda_layer_version(
            mut self,
            input: std::option::Option<crate::model::AwsLambdaLayerVersionDetails>,
        ) -> Self {
            self.aws_lambda_layer_version = input;
            self
        }
        /// <p>Details about an Amazon RDS database instance.</p>
        pub fn aws_rds_db_instance(mut self, input: crate::model::AwsRdsDbInstanceDetails) -> Self {
            self.aws_rds_db_instance = Some(input);
            self
        }
        /// <p>Details about an Amazon RDS database instance.</p>
        pub fn set_aws_rds_db_instance(
            mut self,
            input: std::option::Option<crate::model::AwsRdsDbInstanceDetails>,
        ) -> Self {
            self.aws_rds_db_instance = input;
            self
        }
        /// <p>Details about an SNS topic.</p>
        pub fn aws_sns_topic(mut self, input: crate::model::AwsSnsTopicDetails) -> Self {
            self.aws_sns_topic = Some(input);
            self
        }
        /// <p>Details about an SNS topic.</p>
        pub fn set_aws_sns_topic(
            mut self,
            input: std::option::Option<crate::model::AwsSnsTopicDetails>,
        ) -> Self {
            self.aws_sns_topic = input;
            self
        }
        /// <p>Details about an SQS queue.</p>
        pub fn aws_sqs_queue(mut self, input: crate::model::AwsSqsQueueDetails) -> Self {
            self.aws_sqs_queue = Some(input);
            self
        }
        /// <p>Details about an SQS queue.</p>
        pub fn set_aws_sqs_queue(
            mut self,
            input: std::option::Option<crate::model::AwsSqsQueueDetails>,
        ) -> Self {
            self.aws_sqs_queue = input;
            self
        }
        /// <p>Details for an WAF WebACL.</p>
        pub fn aws_waf_web_acl(mut self, input: crate::model::AwsWafWebAclDetails) -> Self {
            self.aws_waf_web_acl = Some(input);
            self
        }
        /// <p>Details for an WAF WebACL.</p>
        pub fn set_aws_waf_web_acl(
            mut self,
            input: std::option::Option<crate::model::AwsWafWebAclDetails>,
        ) -> Self {
            self.aws_waf_web_acl = input;
            self
        }
        /// <p>Details about an Amazon RDS database snapshot.</p>
        pub fn aws_rds_db_snapshot(mut self, input: crate::model::AwsRdsDbSnapshotDetails) -> Self {
            self.aws_rds_db_snapshot = Some(input);
            self
        }
        /// <p>Details about an Amazon RDS database snapshot.</p>
        pub fn set_aws_rds_db_snapshot(
            mut self,
            input: std::option::Option<crate::model::AwsRdsDbSnapshotDetails>,
        ) -> Self {
            self.aws_rds_db_snapshot = input;
            self
        }
        /// <p>Details about an Amazon RDS database cluster snapshot.</p>
        pub fn aws_rds_db_cluster_snapshot(
            mut self,
            input: crate::model::AwsRdsDbClusterSnapshotDetails,
        ) -> Self {
            self.aws_rds_db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Details about an Amazon RDS database cluster snapshot.</p>
        pub fn set_aws_rds_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::AwsRdsDbClusterSnapshotDetails>,
        ) -> Self {
            self.aws_rds_db_cluster_snapshot = input;
            self
        }
        /// <p>Details about an Amazon RDS database cluster.</p>
        pub fn aws_rds_db_cluster(mut self, input: crate::model::AwsRdsDbClusterDetails) -> Self {
            self.aws_rds_db_cluster = Some(input);
            self
        }
        /// <p>Details about an Amazon RDS database cluster.</p>
        pub fn set_aws_rds_db_cluster(
            mut self,
            input: std::option::Option<crate::model::AwsRdsDbClusterDetails>,
        ) -> Self {
            self.aws_rds_db_cluster = input;
            self
        }
        /// <p>Details about an ECS cluster.</p>
        pub fn aws_ecs_cluster(mut self, input: crate::model::AwsEcsClusterDetails) -> Self {
            self.aws_ecs_cluster = Some(input);
            self
        }
        /// <p>Details about an ECS cluster.</p>
        pub fn set_aws_ecs_cluster(
            mut self,
            input: std::option::Option<crate::model::AwsEcsClusterDetails>,
        ) -> Self {
            self.aws_ecs_cluster = input;
            self
        }
        /// <p>Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>
        pub fn aws_ecs_task_definition(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionDetails,
        ) -> Self {
            self.aws_ecs_task_definition = Some(input);
            self
        }
        /// <p>Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>
        pub fn set_aws_ecs_task_definition(
            mut self,
            input: std::option::Option<crate::model::AwsEcsTaskDefinitionDetails>,
        ) -> Self {
            self.aws_ecs_task_definition = input;
            self
        }
        /// <p>Details about a container resource related to a finding.</p>
        pub fn container(mut self, input: crate::model::ContainerDetails) -> Self {
            self.container = Some(input);
            self
        }
        /// <p>Details about a container resource related to a finding.</p>
        pub fn set_container(
            mut self,
            input: std::option::Option<crate::model::ContainerDetails>,
        ) -> Self {
            self.container = input;
            self
        }
        /// Adds a key-value pair to `other`.
        ///
        /// To override the contents of this collection use [`set_other`](Self::set_other).
        ///
        /// <p>Details about a resource that are not available in a type-specific details object. Use
        /// the <code>Other</code> object in the following cases.</p>
        /// <ul>
        /// <li>
        /// <p>The type-specific object does not contain all of the fields that you want to
        /// populate. In this case, first use the type-specific object to populate those fields.
        /// Use the <code>Other</code> object to populate the fields that are missing from the
        /// type-specific object.</p>
        /// </li>
        /// <li>
        /// <p>The resource type does not have a corresponding object. This includes resources
        /// for which the type is <code>Other</code>. </p>
        /// </li>
        /// </ul>
        pub fn other(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.other.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.other = Some(hash_map);
            self
        }
        /// <p>Details about a resource that are not available in a type-specific details object. Use
        /// the <code>Other</code> object in the following cases.</p>
        /// <ul>
        /// <li>
        /// <p>The type-specific object does not contain all of the fields that you want to
        /// populate. In this case, first use the type-specific object to populate those fields.
        /// Use the <code>Other</code> object to populate the fields that are missing from the
        /// type-specific object.</p>
        /// </li>
        /// <li>
        /// <p>The resource type does not have a corresponding object. This includes resources
        /// for which the type is <code>Other</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_other(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.other = input;
            self
        }
        /// <p>Details about an RDS event notification subscription.</p>
        pub fn aws_rds_event_subscription(
            mut self,
            input: crate::model::AwsRdsEventSubscriptionDetails,
        ) -> Self {
            self.aws_rds_event_subscription = Some(input);
            self
        }
        /// <p>Details about an RDS event notification subscription.</p>
        pub fn set_aws_rds_event_subscription(
            mut self,
            input: std::option::Option<crate::model::AwsRdsEventSubscriptionDetails>,
        ) -> Self {
            self.aws_rds_event_subscription = input;
            self
        }
        /// <p>Details about a service within an ECS cluster.</p>
        pub fn aws_ecs_service(mut self, input: crate::model::AwsEcsServiceDetails) -> Self {
            self.aws_ecs_service = Some(input);
            self
        }
        /// <p>Details about a service within an ECS cluster.</p>
        pub fn set_aws_ecs_service(
            mut self,
            input: std::option::Option<crate::model::AwsEcsServiceDetails>,
        ) -> Self {
            self.aws_ecs_service = input;
            self
        }
        /// <p>Provides details about a launch configuration.</p>
        pub fn aws_auto_scaling_launch_configuration(
            mut self,
            input: crate::model::AwsAutoScalingLaunchConfigurationDetails,
        ) -> Self {
            self.aws_auto_scaling_launch_configuration = Some(input);
            self
        }
        /// <p>Provides details about a launch configuration.</p>
        pub fn set_aws_auto_scaling_launch_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsAutoScalingLaunchConfigurationDetails>,
        ) -> Self {
            self.aws_auto_scaling_launch_configuration = input;
            self
        }
        /// <p>Details about an EC2 VPN connection.</p>
        pub fn aws_ec2_vpn_connection(
            mut self,
            input: crate::model::AwsEc2VpnConnectionDetails,
        ) -> Self {
            self.aws_ec2_vpn_connection = Some(input);
            self
        }
        /// <p>Details about an EC2 VPN connection.</p>
        pub fn set_aws_ec2_vpn_connection(
            mut self,
            input: std::option::Option<crate::model::AwsEc2VpnConnectionDetails>,
        ) -> Self {
            self.aws_ec2_vpn_connection = input;
            self
        }
        /// <p>Information about an Amazon ECR image.</p>
        pub fn aws_ecr_container_image(
            mut self,
            input: crate::model::AwsEcrContainerImageDetails,
        ) -> Self {
            self.aws_ecr_container_image = Some(input);
            self
        }
        /// <p>Information about an Amazon ECR image.</p>
        pub fn set_aws_ecr_container_image(
            mut self,
            input: std::option::Option<crate::model::AwsEcrContainerImageDetails>,
        ) -> Self {
            self.aws_ecr_container_image = input;
            self
        }
        /// <p>Details about an Amazon OpenSearch Service domain.</p>
        pub fn aws_open_search_service_domain(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainDetails,
        ) -> Self {
            self.aws_open_search_service_domain = Some(input);
            self
        }
        /// <p>Details about an Amazon OpenSearch Service domain.</p>
        pub fn set_aws_open_search_service_domain(
            mut self,
            input: std::option::Option<crate::model::AwsOpenSearchServiceDomainDetails>,
        ) -> Self {
            self.aws_open_search_service_domain = input;
            self
        }
        /// <p>Details about the service configuration for a VPC endpoint service.</p>
        pub fn aws_ec2_vpc_endpoint_service(
            mut self,
            input: crate::model::AwsEc2VpcEndpointServiceDetails,
        ) -> Self {
            self.aws_ec2_vpc_endpoint_service = Some(input);
            self
        }
        /// <p>Details about the service configuration for a VPC endpoint service.</p>
        pub fn set_aws_ec2_vpc_endpoint_service(
            mut self,
            input: std::option::Option<crate::model::AwsEc2VpcEndpointServiceDetails>,
        ) -> Self {
            self.aws_ec2_vpc_endpoint_service = input;
            self
        }
        /// <p>Information about the encryption configuration for X-Ray.</p>
        pub fn aws_xray_encryption_config(
            mut self,
            input: crate::model::AwsXrayEncryptionConfigDetails,
        ) -> Self {
            self.aws_xray_encryption_config = Some(input);
            self
        }
        /// <p>Information about the encryption configuration for X-Ray.</p>
        pub fn set_aws_xray_encryption_config(
            mut self,
            input: std::option::Option<crate::model::AwsXrayEncryptionConfigDetails>,
        ) -> Self {
            self.aws_xray_encryption_config = input;
            self
        }
        /// <p>Details about a rate-based rule for global resources.</p>
        pub fn aws_waf_rate_based_rule(
            mut self,
            input: crate::model::AwsWafRateBasedRuleDetails,
        ) -> Self {
            self.aws_waf_rate_based_rule = Some(input);
            self
        }
        /// <p>Details about a rate-based rule for global resources.</p>
        pub fn set_aws_waf_rate_based_rule(
            mut self,
            input: std::option::Option<crate::model::AwsWafRateBasedRuleDetails>,
        ) -> Self {
            self.aws_waf_rate_based_rule = input;
            self
        }
        /// <p>Details about a rate-based rule for Regional resources.</p>
        pub fn aws_waf_regional_rate_based_rule(
            mut self,
            input: crate::model::AwsWafRegionalRateBasedRuleDetails,
        ) -> Self {
            self.aws_waf_regional_rate_based_rule = Some(input);
            self
        }
        /// <p>Details about a rate-based rule for Regional resources.</p>
        pub fn set_aws_waf_regional_rate_based_rule(
            mut self,
            input: std::option::Option<crate::model::AwsWafRegionalRateBasedRuleDetails>,
        ) -> Self {
            self.aws_waf_regional_rate_based_rule = input;
            self
        }
        /// <p>Information about an Amazon Elastic Container Registry repository.</p>
        pub fn aws_ecr_repository(mut self, input: crate::model::AwsEcrRepositoryDetails) -> Self {
            self.aws_ecr_repository = Some(input);
            self
        }
        /// <p>Information about an Amazon Elastic Container Registry repository.</p>
        pub fn set_aws_ecr_repository(
            mut self,
            input: std::option::Option<crate::model::AwsEcrRepositoryDetails>,
        ) -> Self {
            self.aws_ecr_repository = input;
            self
        }
        /// <p>Details about an Amazon EKS cluster.</p>
        pub fn aws_eks_cluster(mut self, input: crate::model::AwsEksClusterDetails) -> Self {
            self.aws_eks_cluster = Some(input);
            self
        }
        /// <p>Details about an Amazon EKS cluster.</p>
        pub fn set_aws_eks_cluster(
            mut self,
            input: std::option::Option<crate::model::AwsEksClusterDetails>,
        ) -> Self {
            self.aws_eks_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDetails`](crate::model::ResourceDetails)
        pub fn build(self) -> crate::model::ResourceDetails {
            crate::model::ResourceDetails {
                aws_auto_scaling_auto_scaling_group: self.aws_auto_scaling_auto_scaling_group,
                aws_code_build_project: self.aws_code_build_project,
                aws_cloud_front_distribution: self.aws_cloud_front_distribution,
                aws_ec2_instance: self.aws_ec2_instance,
                aws_ec2_network_interface: self.aws_ec2_network_interface,
                aws_ec2_security_group: self.aws_ec2_security_group,
                aws_ec2_volume: self.aws_ec2_volume,
                aws_ec2_vpc: self.aws_ec2_vpc,
                aws_ec2_eip: self.aws_ec2_eip,
                aws_ec2_subnet: self.aws_ec2_subnet,
                aws_ec2_network_acl: self.aws_ec2_network_acl,
                aws_elbv2_load_balancer: self.aws_elbv2_load_balancer,
                aws_elastic_beanstalk_environment: self.aws_elastic_beanstalk_environment,
                aws_elasticsearch_domain: self.aws_elasticsearch_domain,
                aws_s3_bucket: self.aws_s3_bucket,
                aws_s3_account_public_access_block: self.aws_s3_account_public_access_block,
                aws_s3_object: self.aws_s3_object,
                aws_secrets_manager_secret: self.aws_secrets_manager_secret,
                aws_iam_access_key: self.aws_iam_access_key,
                aws_iam_user: self.aws_iam_user,
                aws_iam_policy: self.aws_iam_policy,
                aws_api_gateway_v2_stage: self.aws_api_gateway_v2_stage,
                aws_api_gateway_v2_api: self.aws_api_gateway_v2_api,
                aws_dynamo_db_table: self.aws_dynamo_db_table,
                aws_api_gateway_stage: self.aws_api_gateway_stage,
                aws_api_gateway_rest_api: self.aws_api_gateway_rest_api,
                aws_cloud_trail_trail: self.aws_cloud_trail_trail,
                aws_ssm_patch_compliance: self.aws_ssm_patch_compliance,
                aws_certificate_manager_certificate: self.aws_certificate_manager_certificate,
                aws_redshift_cluster: self.aws_redshift_cluster,
                aws_elb_load_balancer: self.aws_elb_load_balancer,
                aws_iam_group: self.aws_iam_group,
                aws_iam_role: self.aws_iam_role,
                aws_kms_key: self.aws_kms_key,
                aws_lambda_function: self.aws_lambda_function,
                aws_lambda_layer_version: self.aws_lambda_layer_version,
                aws_rds_db_instance: self.aws_rds_db_instance,
                aws_sns_topic: self.aws_sns_topic,
                aws_sqs_queue: self.aws_sqs_queue,
                aws_waf_web_acl: self.aws_waf_web_acl,
                aws_rds_db_snapshot: self.aws_rds_db_snapshot,
                aws_rds_db_cluster_snapshot: self.aws_rds_db_cluster_snapshot,
                aws_rds_db_cluster: self.aws_rds_db_cluster,
                aws_ecs_cluster: self.aws_ecs_cluster,
                aws_ecs_task_definition: self.aws_ecs_task_definition,
                container: self.container,
                other: self.other,
                aws_rds_event_subscription: self.aws_rds_event_subscription,
                aws_ecs_service: self.aws_ecs_service,
                aws_auto_scaling_launch_configuration: self.aws_auto_scaling_launch_configuration,
                aws_ec2_vpn_connection: self.aws_ec2_vpn_connection,
                aws_ecr_container_image: self.aws_ecr_container_image,
                aws_open_search_service_domain: self.aws_open_search_service_domain,
                aws_ec2_vpc_endpoint_service: self.aws_ec2_vpc_endpoint_service,
                aws_xray_encryption_config: self.aws_xray_encryption_config,
                aws_waf_rate_based_rule: self.aws_waf_rate_based_rule,
                aws_waf_regional_rate_based_rule: self.aws_waf_regional_rate_based_rule,
                aws_ecr_repository: self.aws_ecr_repository,
                aws_eks_cluster: self.aws_eks_cluster,
            }
        }
    }
}
impl ResourceDetails {
    /// Creates a new builder-style object to manufacture [`ResourceDetails`](crate::model::ResourceDetails)
    pub fn builder() -> crate::model::resource_details::Builder {
        crate::model::resource_details::Builder::default()
    }
}

/// <p>Provides details about an Amazon EKS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEksClusterDetails {
    /// <p>The ARN of the cluster.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The certificate authority data for the cluster.</p>
    pub certificate_authority_data: std::option::Option<std::string::String>,
    /// <p>The status of the cluster.</p>
    pub cluster_status: std::option::Option<std::string::String>,
    /// <p>The endpoint for the Amazon EKS API server.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The name of the cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The VPC configuration used by the cluster control plane.</p>
    pub resources_vpc_config:
        std::option::Option<crate::model::AwsEksClusterResourcesVpcConfigDetails>,
    /// <p>The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon Web Services API operations on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS server version for the cluster.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The logging configuration for the cluster.</p>
    pub logging: std::option::Option<crate::model::AwsEksClusterLoggingDetails>,
}
impl std::fmt::Debug for AwsEksClusterDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEksClusterDetails");
        formatter.field("arn", &self.arn);
        formatter.field(
            "certificate_authority_data",
            &self.certificate_authority_data,
        );
        formatter.field("cluster_status", &self.cluster_status);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("name", &self.name);
        formatter.field("resources_vpc_config", &self.resources_vpc_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("version", &self.version);
        formatter.field("logging", &self.logging);
        formatter.finish()
    }
}
/// See [`AwsEksClusterDetails`](crate::model::AwsEksClusterDetails)
pub mod aws_eks_cluster_details {
    /// A builder for [`AwsEksClusterDetails`](crate::model::AwsEksClusterDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) certificate_authority_data: std::option::Option<std::string::String>,
        pub(crate) cluster_status: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resources_vpc_config:
            std::option::Option<crate::model::AwsEksClusterResourcesVpcConfigDetails>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::AwsEksClusterLoggingDetails>,
    }
    impl Builder {
        /// <p>The ARN of the cluster.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the cluster.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The certificate authority data for the cluster.</p>
        pub fn certificate_authority_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_data = Some(input.into());
            self
        }
        /// <p>The certificate authority data for the cluster.</p>
        pub fn set_certificate_authority_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_data = input;
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_status = Some(input.into());
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn set_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_status = input;
            self
        }
        /// <p>The endpoint for the Amazon EKS API server.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for the Amazon EKS API server.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The VPC configuration used by the cluster control plane.</p>
        pub fn resources_vpc_config(
            mut self,
            input: crate::model::AwsEksClusterResourcesVpcConfigDetails,
        ) -> Self {
            self.resources_vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration used by the cluster control plane.</p>
        pub fn set_resources_vpc_config(
            mut self,
            input: std::option::Option<crate::model::AwsEksClusterResourcesVpcConfigDetails>,
        ) -> Self {
            self.resources_vpc_config = input;
            self
        }
        /// <p>The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon Web Services API operations on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon Web Services API operations on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon EKS server version for the cluster.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The Amazon EKS server version for the cluster.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The logging configuration for the cluster.</p>
        pub fn logging(mut self, input: crate::model::AwsEksClusterLoggingDetails) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The logging configuration for the cluster.</p>
        pub fn set_logging(
            mut self,
            input: std::option::Option<crate::model::AwsEksClusterLoggingDetails>,
        ) -> Self {
            self.logging = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEksClusterDetails`](crate::model::AwsEksClusterDetails)
        pub fn build(self) -> crate::model::AwsEksClusterDetails {
            crate::model::AwsEksClusterDetails {
                arn: self.arn,
                certificate_authority_data: self.certificate_authority_data,
                cluster_status: self.cluster_status,
                endpoint: self.endpoint,
                name: self.name,
                resources_vpc_config: self.resources_vpc_config,
                role_arn: self.role_arn,
                version: self.version,
                logging: self.logging,
            }
        }
    }
}
impl AwsEksClusterDetails {
    /// Creates a new builder-style object to manufacture [`AwsEksClusterDetails`](crate::model::AwsEksClusterDetails)
    pub fn builder() -> crate::model::aws_eks_cluster_details::Builder {
        crate::model::aws_eks_cluster_details::Builder::default()
    }
}

/// <p>The logging configuration for an Amazon EKS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEksClusterLoggingDetails {
    /// <p>Cluster logging configurations.</p>
    pub cluster_logging:
        std::option::Option<std::vec::Vec<crate::model::AwsEksClusterLoggingClusterLoggingDetails>>,
}
impl std::fmt::Debug for AwsEksClusterLoggingDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEksClusterLoggingDetails");
        formatter.field("cluster_logging", &self.cluster_logging);
        formatter.finish()
    }
}
/// See [`AwsEksClusterLoggingDetails`](crate::model::AwsEksClusterLoggingDetails)
pub mod aws_eks_cluster_logging_details {
    /// A builder for [`AwsEksClusterLoggingDetails`](crate::model::AwsEksClusterLoggingDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_logging: std::option::Option<
            std::vec::Vec<crate::model::AwsEksClusterLoggingClusterLoggingDetails>,
        >,
    }
    impl Builder {
        /// Appends an item to `cluster_logging`.
        ///
        /// To override the contents of this collection use [`set_cluster_logging`](Self::set_cluster_logging).
        ///
        /// <p>Cluster logging configurations.</p>
        pub fn cluster_logging(
            mut self,
            input: impl Into<crate::model::AwsEksClusterLoggingClusterLoggingDetails>,
        ) -> Self {
            let mut v = self.cluster_logging.unwrap_or_default();
            v.push(input.into());
            self.cluster_logging = Some(v);
            self
        }
        /// <p>Cluster logging configurations.</p>
        pub fn set_cluster_logging(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEksClusterLoggingClusterLoggingDetails>,
            >,
        ) -> Self {
            self.cluster_logging = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEksClusterLoggingDetails`](crate::model::AwsEksClusterLoggingDetails)
        pub fn build(self) -> crate::model::AwsEksClusterLoggingDetails {
            crate::model::AwsEksClusterLoggingDetails {
                cluster_logging: self.cluster_logging,
            }
        }
    }
}
impl AwsEksClusterLoggingDetails {
    /// Creates a new builder-style object to manufacture [`AwsEksClusterLoggingDetails`](crate::model::AwsEksClusterLoggingDetails)
    pub fn builder() -> crate::model::aws_eks_cluster_logging_details::Builder {
        crate::model::aws_eks_cluster_logging_details::Builder::default()
    }
}

/// <p>Details for a cluster logging configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEksClusterLoggingClusterLoggingDetails {
    /// <p>Whether the logging types that are listed in <code>Types</code> are enabled.</p>
    pub enabled: bool,
    /// <p>A list of logging types.</p>
    pub types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AwsEksClusterLoggingClusterLoggingDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEksClusterLoggingClusterLoggingDetails");
        formatter.field("enabled", &self.enabled);
        formatter.field("types", &self.types);
        formatter.finish()
    }
}
/// See [`AwsEksClusterLoggingClusterLoggingDetails`](crate::model::AwsEksClusterLoggingClusterLoggingDetails)
pub mod aws_eks_cluster_logging_cluster_logging_details {
    /// A builder for [`AwsEksClusterLoggingClusterLoggingDetails`](crate::model::AwsEksClusterLoggingClusterLoggingDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Whether the logging types that are listed in <code>Types</code> are enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the logging types that are listed in <code>Types</code> are enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>A list of logging types.</p>
        pub fn types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>A list of logging types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEksClusterLoggingClusterLoggingDetails`](crate::model::AwsEksClusterLoggingClusterLoggingDetails)
        pub fn build(self) -> crate::model::AwsEksClusterLoggingClusterLoggingDetails {
            crate::model::AwsEksClusterLoggingClusterLoggingDetails {
                enabled: self.enabled.unwrap_or_default(),
                types: self.types,
            }
        }
    }
}
impl AwsEksClusterLoggingClusterLoggingDetails {
    /// Creates a new builder-style object to manufacture [`AwsEksClusterLoggingClusterLoggingDetails`](crate::model::AwsEksClusterLoggingClusterLoggingDetails)
    pub fn builder() -> crate::model::aws_eks_cluster_logging_cluster_logging_details::Builder {
        crate::model::aws_eks_cluster_logging_cluster_logging_details::Builder::default()
    }
}

/// <p>Information about the VPC configuration used by the cluster control plane.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEksClusterResourcesVpcConfigDetails {
    /// <p>The security groups that are associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Amazon EKS control plane.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnets that are associated with the cluster.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AwsEksClusterResourcesVpcConfigDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEksClusterResourcesVpcConfigDetails");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}
/// See [`AwsEksClusterResourcesVpcConfigDetails`](crate::model::AwsEksClusterResourcesVpcConfigDetails)
pub mod aws_eks_cluster_resources_vpc_config_details {
    /// A builder for [`AwsEksClusterResourcesVpcConfigDetails`](crate::model::AwsEksClusterResourcesVpcConfigDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups that are associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Amazon EKS control plane.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security groups that are associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Amazon EKS control plane.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets that are associated with the cluster.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnets that are associated with the cluster.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEksClusterResourcesVpcConfigDetails`](crate::model::AwsEksClusterResourcesVpcConfigDetails)
        pub fn build(self) -> crate::model::AwsEksClusterResourcesVpcConfigDetails {
            crate::model::AwsEksClusterResourcesVpcConfigDetails {
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
            }
        }
    }
}
impl AwsEksClusterResourcesVpcConfigDetails {
    /// Creates a new builder-style object to manufacture [`AwsEksClusterResourcesVpcConfigDetails`](crate::model::AwsEksClusterResourcesVpcConfigDetails)
    pub fn builder() -> crate::model::aws_eks_cluster_resources_vpc_config_details::Builder {
        crate::model::aws_eks_cluster_resources_vpc_config_details::Builder::default()
    }
}

/// <p>Provides information about an Amazon Elastic Container Registry repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrRepositoryDetails {
    /// <p>The ARN of the repository.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The image scanning configuration for a repository.</p>
    pub image_scanning_configuration:
        std::option::Option<crate::model::AwsEcrRepositoryImageScanningConfigurationDetails>,
    /// <p>The tag mutability setting for the repository.</p>
    pub image_tag_mutability: std::option::Option<std::string::String>,
    /// <p>Information about the lifecycle policy for the repository.</p>
    pub lifecycle_policy: std::option::Option<crate::model::AwsEcrRepositoryLifecyclePolicyDetails>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The text of the repository policy.</p>
    pub repository_policy_text: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcrRepositoryDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrRepositoryDetails");
        formatter.field("arn", &self.arn);
        formatter.field(
            "image_scanning_configuration",
            &self.image_scanning_configuration,
        );
        formatter.field("image_tag_mutability", &self.image_tag_mutability);
        formatter.field("lifecycle_policy", &self.lifecycle_policy);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_policy_text", &self.repository_policy_text);
        formatter.finish()
    }
}
/// See [`AwsEcrRepositoryDetails`](crate::model::AwsEcrRepositoryDetails)
pub mod aws_ecr_repository_details {
    /// A builder for [`AwsEcrRepositoryDetails`](crate::model::AwsEcrRepositoryDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) image_scanning_configuration:
            std::option::Option<crate::model::AwsEcrRepositoryImageScanningConfigurationDetails>,
        pub(crate) image_tag_mutability: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy:
            std::option::Option<crate::model::AwsEcrRepositoryLifecyclePolicyDetails>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the repository.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the repository.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The image scanning configuration for a repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::AwsEcrRepositoryImageScanningConfigurationDetails,
        ) -> Self {
            self.image_scanning_configuration = Some(input);
            self
        }
        /// <p>The image scanning configuration for a repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcrRepositoryImageScanningConfigurationDetails,
            >,
        ) -> Self {
            self.image_scanning_configuration = input;
            self
        }
        /// <p>The tag mutability setting for the repository.</p>
        pub fn image_tag_mutability(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_tag_mutability = Some(input.into());
            self
        }
        /// <p>The tag mutability setting for the repository.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_tag_mutability = input;
            self
        }
        /// <p>Information about the lifecycle policy for the repository.</p>
        pub fn lifecycle_policy(
            mut self,
            input: crate::model::AwsEcrRepositoryLifecyclePolicyDetails,
        ) -> Self {
            self.lifecycle_policy = Some(input);
            self
        }
        /// <p>Information about the lifecycle policy for the repository.</p>
        pub fn set_lifecycle_policy(
            mut self,
            input: std::option::Option<crate::model::AwsEcrRepositoryLifecyclePolicyDetails>,
        ) -> Self {
            self.lifecycle_policy = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The text of the repository policy.</p>
        pub fn repository_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_policy_text = Some(input.into());
            self
        }
        /// <p>The text of the repository policy.</p>
        pub fn set_repository_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrRepositoryDetails`](crate::model::AwsEcrRepositoryDetails)
        pub fn build(self) -> crate::model::AwsEcrRepositoryDetails {
            crate::model::AwsEcrRepositoryDetails {
                arn: self.arn,
                image_scanning_configuration: self.image_scanning_configuration,
                image_tag_mutability: self.image_tag_mutability,
                lifecycle_policy: self.lifecycle_policy,
                repository_name: self.repository_name,
                repository_policy_text: self.repository_policy_text,
            }
        }
    }
}
impl AwsEcrRepositoryDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcrRepositoryDetails`](crate::model::AwsEcrRepositoryDetails)
    pub fn builder() -> crate::model::aws_ecr_repository_details::Builder {
        crate::model::aws_ecr_repository_details::Builder::default()
    }
}

/// <p>Information about the lifecycle policy for the repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrRepositoryLifecyclePolicyDetails {
    /// <p>The text of the lifecycle policy.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account identifier that is associated with the registry that contains the repository.</p>
    pub registry_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcrRepositoryLifecyclePolicyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrRepositoryLifecyclePolicyDetails");
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.field("registry_id", &self.registry_id);
        formatter.finish()
    }
}
/// See [`AwsEcrRepositoryLifecyclePolicyDetails`](crate::model::AwsEcrRepositoryLifecyclePolicyDetails)
pub mod aws_ecr_repository_lifecycle_policy_details {
    /// A builder for [`AwsEcrRepositoryLifecyclePolicyDetails`](crate::model::AwsEcrRepositoryLifecyclePolicyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
        pub(crate) registry_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of the lifecycle policy.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The text of the lifecycle policy.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// <p>The Amazon Web Services account identifier that is associated with the registry that contains the repository.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier that is associated with the registry that contains the repository.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrRepositoryLifecyclePolicyDetails`](crate::model::AwsEcrRepositoryLifecyclePolicyDetails)
        pub fn build(self) -> crate::model::AwsEcrRepositoryLifecyclePolicyDetails {
            crate::model::AwsEcrRepositoryLifecyclePolicyDetails {
                lifecycle_policy_text: self.lifecycle_policy_text,
                registry_id: self.registry_id,
            }
        }
    }
}
impl AwsEcrRepositoryLifecyclePolicyDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcrRepositoryLifecyclePolicyDetails`](crate::model::AwsEcrRepositoryLifecyclePolicyDetails)
    pub fn builder() -> crate::model::aws_ecr_repository_lifecycle_policy_details::Builder {
        crate::model::aws_ecr_repository_lifecycle_policy_details::Builder::default()
    }
}

/// <p>The image scanning configuration for a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrRepositoryImageScanningConfigurationDetails {
    /// <p>Whether to scan images after they are pushed to a repository.</p>
    pub scan_on_push: bool,
}
impl std::fmt::Debug for AwsEcrRepositoryImageScanningConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrRepositoryImageScanningConfigurationDetails");
        formatter.field("scan_on_push", &self.scan_on_push);
        formatter.finish()
    }
}
/// See [`AwsEcrRepositoryImageScanningConfigurationDetails`](crate::model::AwsEcrRepositoryImageScanningConfigurationDetails)
pub mod aws_ecr_repository_image_scanning_configuration_details {
    /// A builder for [`AwsEcrRepositoryImageScanningConfigurationDetails`](crate::model::AwsEcrRepositoryImageScanningConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scan_on_push: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to scan images after they are pushed to a repository.</p>
        pub fn scan_on_push(mut self, input: bool) -> Self {
            self.scan_on_push = Some(input);
            self
        }
        /// <p>Whether to scan images after they are pushed to a repository.</p>
        pub fn set_scan_on_push(mut self, input: std::option::Option<bool>) -> Self {
            self.scan_on_push = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrRepositoryImageScanningConfigurationDetails`](crate::model::AwsEcrRepositoryImageScanningConfigurationDetails)
        pub fn build(self) -> crate::model::AwsEcrRepositoryImageScanningConfigurationDetails {
            crate::model::AwsEcrRepositoryImageScanningConfigurationDetails {
                scan_on_push: self.scan_on_push.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcrRepositoryImageScanningConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcrRepositoryImageScanningConfigurationDetails`](crate::model::AwsEcrRepositoryImageScanningConfigurationDetails)
    pub fn builder(
    ) -> crate::model::aws_ecr_repository_image_scanning_configuration_details::Builder {
        crate::model::aws_ecr_repository_image_scanning_configuration_details::Builder::default()
    }
}

/// <p>contains details about a rate-based rule for Regional resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsWafRegionalRateBasedRuleDetails {
    /// <p>The name of the metrics for the rate-based rule.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The name of the rate-based rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
    pub rate_key: std::option::Option<std::string::String>,
    /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
    pub rate_limit: i64,
    /// <p>The unique identifier for the rate-based rule.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The predicates to include in the rate-based rule.</p>
    pub match_predicates:
        std::option::Option<std::vec::Vec<crate::model::AwsWafRegionalRateBasedRuleMatchPredicate>>,
}
impl std::fmt::Debug for AwsWafRegionalRateBasedRuleDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsWafRegionalRateBasedRuleDetails");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("name", &self.name);
        formatter.field("rate_key", &self.rate_key);
        formatter.field("rate_limit", &self.rate_limit);
        formatter.field("rule_id", &self.rule_id);
        formatter.field("match_predicates", &self.match_predicates);
        formatter.finish()
    }
}
/// See [`AwsWafRegionalRateBasedRuleDetails`](crate::model::AwsWafRegionalRateBasedRuleDetails)
pub mod aws_waf_regional_rate_based_rule_details {
    /// A builder for [`AwsWafRegionalRateBasedRuleDetails`](crate::model::AwsWafRegionalRateBasedRuleDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rate_key: std::option::Option<std::string::String>,
        pub(crate) rate_limit: std::option::Option<i64>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) match_predicates: std::option::Option<
            std::vec::Vec<crate::model::AwsWafRegionalRateBasedRuleMatchPredicate>,
        >,
    }
    impl Builder {
        /// <p>The name of the metrics for the rate-based rule.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metrics for the rate-based rule.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The name of the rate-based rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rate-based rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
        pub fn rate_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.rate_key = Some(input.into());
            self
        }
        /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
        pub fn set_rate_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rate_key = input;
            self
        }
        /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
        pub fn rate_limit(mut self, input: i64) -> Self {
            self.rate_limit = Some(input);
            self
        }
        /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.rate_limit = input;
            self
        }
        /// <p>The unique identifier for the rate-based rule.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the rate-based rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Appends an item to `match_predicates`.
        ///
        /// To override the contents of this collection use [`set_match_predicates`](Self::set_match_predicates).
        ///
        /// <p>The predicates to include in the rate-based rule.</p>
        pub fn match_predicates(
            mut self,
            input: impl Into<crate::model::AwsWafRegionalRateBasedRuleMatchPredicate>,
        ) -> Self {
            let mut v = self.match_predicates.unwrap_or_default();
            v.push(input.into());
            self.match_predicates = Some(v);
            self
        }
        /// <p>The predicates to include in the rate-based rule.</p>
        pub fn set_match_predicates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsWafRegionalRateBasedRuleMatchPredicate>,
            >,
        ) -> Self {
            self.match_predicates = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsWafRegionalRateBasedRuleDetails`](crate::model::AwsWafRegionalRateBasedRuleDetails)
        pub fn build(self) -> crate::model::AwsWafRegionalRateBasedRuleDetails {
            crate::model::AwsWafRegionalRateBasedRuleDetails {
                metric_name: self.metric_name,
                name: self.name,
                rate_key: self.rate_key,
                rate_limit: self.rate_limit.unwrap_or_default(),
                rule_id: self.rule_id,
                match_predicates: self.match_predicates,
            }
        }
    }
}
impl AwsWafRegionalRateBasedRuleDetails {
    /// Creates a new builder-style object to manufacture [`AwsWafRegionalRateBasedRuleDetails`](crate::model::AwsWafRegionalRateBasedRuleDetails)
    pub fn builder() -> crate::model::aws_waf_regional_rate_based_rule_details::Builder {
        crate::model::aws_waf_regional_rate_based_rule_details::Builder::default()
    }
}

/// <p>Details for a match predicate. A predicate might look for characteristics such as specific IP addresses, geographic locations, or sizes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsWafRegionalRateBasedRuleMatchPredicate {
    /// <p>The unique identifier for the predicate.</p>
    pub data_id: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
    /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.</p>
    pub negated: bool,
    /// <p>The type of predicate.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsWafRegionalRateBasedRuleMatchPredicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsWafRegionalRateBasedRuleMatchPredicate");
        formatter.field("data_id", &self.data_id);
        formatter.field("negated", &self.negated);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsWafRegionalRateBasedRuleMatchPredicate`](crate::model::AwsWafRegionalRateBasedRuleMatchPredicate)
pub mod aws_waf_regional_rate_based_rule_match_predicate {
    /// A builder for [`AwsWafRegionalRateBasedRuleMatchPredicate`](crate::model::AwsWafRegionalRateBasedRuleMatchPredicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_id: std::option::Option<std::string::String>,
        pub(crate) negated: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the predicate.</p>
        pub fn data_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the predicate.</p>
        pub fn set_data_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_id = input;
            self
        }
        /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
        /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.</p>
        pub fn negated(mut self, input: bool) -> Self {
            self.negated = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
        /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.</p>
        pub fn set_negated(mut self, input: std::option::Option<bool>) -> Self {
            self.negated = input;
            self
        }
        /// <p>The type of predicate.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of predicate.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsWafRegionalRateBasedRuleMatchPredicate`](crate::model::AwsWafRegionalRateBasedRuleMatchPredicate)
        pub fn build(self) -> crate::model::AwsWafRegionalRateBasedRuleMatchPredicate {
            crate::model::AwsWafRegionalRateBasedRuleMatchPredicate {
                data_id: self.data_id,
                negated: self.negated.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl AwsWafRegionalRateBasedRuleMatchPredicate {
    /// Creates a new builder-style object to manufacture [`AwsWafRegionalRateBasedRuleMatchPredicate`](crate::model::AwsWafRegionalRateBasedRuleMatchPredicate)
    pub fn builder() -> crate::model::aws_waf_regional_rate_based_rule_match_predicate::Builder {
        crate::model::aws_waf_regional_rate_based_rule_match_predicate::Builder::default()
    }
}

/// <p>Details about a rate-based rule for global resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsWafRateBasedRuleDetails {
    /// <p>The name of the metrics for the rate-based rule.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The name of the rate-based rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
    pub rate_key: std::option::Option<std::string::String>,
    /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
    pub rate_limit: i64,
    /// <p>The unique identifier for the rate-based rule.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The predicates to include in the rate-based rule.</p>
    pub match_predicates:
        std::option::Option<std::vec::Vec<crate::model::AwsWafRateBasedRuleMatchPredicate>>,
}
impl std::fmt::Debug for AwsWafRateBasedRuleDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsWafRateBasedRuleDetails");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("name", &self.name);
        formatter.field("rate_key", &self.rate_key);
        formatter.field("rate_limit", &self.rate_limit);
        formatter.field("rule_id", &self.rule_id);
        formatter.field("match_predicates", &self.match_predicates);
        formatter.finish()
    }
}
/// See [`AwsWafRateBasedRuleDetails`](crate::model::AwsWafRateBasedRuleDetails)
pub mod aws_waf_rate_based_rule_details {
    /// A builder for [`AwsWafRateBasedRuleDetails`](crate::model::AwsWafRateBasedRuleDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rate_key: std::option::Option<std::string::String>,
        pub(crate) rate_limit: std::option::Option<i64>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) match_predicates:
            std::option::Option<std::vec::Vec<crate::model::AwsWafRateBasedRuleMatchPredicate>>,
    }
    impl Builder {
        /// <p>The name of the metrics for the rate-based rule.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metrics for the rate-based rule.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The name of the rate-based rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rate-based rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
        pub fn rate_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.rate_key = Some(input.into());
            self
        }
        /// <p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>
        pub fn set_rate_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rate_key = input;
            self
        }
        /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
        pub fn rate_limit(mut self, input: i64) -> Self {
            self.rate_limit = Some(input);
            self
        }
        /// <p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.rate_limit = input;
            self
        }
        /// <p>The unique identifier for the rate-based rule.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the rate-based rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Appends an item to `match_predicates`.
        ///
        /// To override the contents of this collection use [`set_match_predicates`](Self::set_match_predicates).
        ///
        /// <p>The predicates to include in the rate-based rule.</p>
        pub fn match_predicates(
            mut self,
            input: impl Into<crate::model::AwsWafRateBasedRuleMatchPredicate>,
        ) -> Self {
            let mut v = self.match_predicates.unwrap_or_default();
            v.push(input.into());
            self.match_predicates = Some(v);
            self
        }
        /// <p>The predicates to include in the rate-based rule.</p>
        pub fn set_match_predicates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsWafRateBasedRuleMatchPredicate>,
            >,
        ) -> Self {
            self.match_predicates = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsWafRateBasedRuleDetails`](crate::model::AwsWafRateBasedRuleDetails)
        pub fn build(self) -> crate::model::AwsWafRateBasedRuleDetails {
            crate::model::AwsWafRateBasedRuleDetails {
                metric_name: self.metric_name,
                name: self.name,
                rate_key: self.rate_key,
                rate_limit: self.rate_limit.unwrap_or_default(),
                rule_id: self.rule_id,
                match_predicates: self.match_predicates,
            }
        }
    }
}
impl AwsWafRateBasedRuleDetails {
    /// Creates a new builder-style object to manufacture [`AwsWafRateBasedRuleDetails`](crate::model::AwsWafRateBasedRuleDetails)
    pub fn builder() -> crate::model::aws_waf_rate_based_rule_details::Builder {
        crate::model::aws_waf_rate_based_rule_details::Builder::default()
    }
}

/// <p>A match predicate. A predicate might look for characteristics such as specific IP addresses, geographic locations, or sizes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsWafRateBasedRuleMatchPredicate {
    /// <p>The unique identifier for the predicate.</p>
    pub data_id: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
    /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.
    /// </p>
    pub negated: bool,
    /// <p>The type of predicate.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsWafRateBasedRuleMatchPredicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsWafRateBasedRuleMatchPredicate");
        formatter.field("data_id", &self.data_id);
        formatter.field("negated", &self.negated);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsWafRateBasedRuleMatchPredicate`](crate::model::AwsWafRateBasedRuleMatchPredicate)
pub mod aws_waf_rate_based_rule_match_predicate {
    /// A builder for [`AwsWafRateBasedRuleMatchPredicate`](crate::model::AwsWafRateBasedRuleMatchPredicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_id: std::option::Option<std::string::String>,
        pub(crate) negated: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the predicate.</p>
        pub fn data_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the predicate.</p>
        pub fn set_data_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_id = input;
            self
        }
        /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
        /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.
        /// </p>
        pub fn negated(mut self, input: bool) -> Self {
            self.negated = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p>
        /// <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.
        /// </p>
        pub fn set_negated(mut self, input: std::option::Option<bool>) -> Self {
            self.negated = input;
            self
        }
        /// <p>The type of predicate.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of predicate.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsWafRateBasedRuleMatchPredicate`](crate::model::AwsWafRateBasedRuleMatchPredicate)
        pub fn build(self) -> crate::model::AwsWafRateBasedRuleMatchPredicate {
            crate::model::AwsWafRateBasedRuleMatchPredicate {
                data_id: self.data_id,
                negated: self.negated.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl AwsWafRateBasedRuleMatchPredicate {
    /// Creates a new builder-style object to manufacture [`AwsWafRateBasedRuleMatchPredicate`](crate::model::AwsWafRateBasedRuleMatchPredicate)
    pub fn builder() -> crate::model::aws_waf_rate_based_rule_match_predicate::Builder {
        crate::model::aws_waf_rate_based_rule_match_predicate::Builder::default()
    }
}

/// <p>Information about the encryption configuration for X-Ray.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsXrayEncryptionConfigDetails {
    /// <p>The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The current status of the encryption configuration. When <code>Status</code> is <code>UPDATING</code>, X-Ray might use both the old and new encryption.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code> indicates to use the default encryption.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsXrayEncryptionConfigDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsXrayEncryptionConfigDetails");
        formatter.field("key_id", &self.key_id);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsXrayEncryptionConfigDetails`](crate::model::AwsXrayEncryptionConfigDetails)
pub mod aws_xray_encryption_config_details {
    /// A builder for [`AwsXrayEncryptionConfigDetails`](crate::model::AwsXrayEncryptionConfigDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The current status of the encryption configuration. When <code>Status</code> is <code>UPDATING</code>, X-Ray might use both the old and new encryption.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the encryption configuration. When <code>Status</code> is <code>UPDATING</code>, X-Ray might use both the old and new encryption.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code> indicates to use the default encryption.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code> indicates to use the default encryption.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsXrayEncryptionConfigDetails`](crate::model::AwsXrayEncryptionConfigDetails)
        pub fn build(self) -> crate::model::AwsXrayEncryptionConfigDetails {
            crate::model::AwsXrayEncryptionConfigDetails {
                key_id: self.key_id,
                status: self.status,
                r#type: self.r#type,
            }
        }
    }
}
impl AwsXrayEncryptionConfigDetails {
    /// Creates a new builder-style object to manufacture [`AwsXrayEncryptionConfigDetails`](crate::model::AwsXrayEncryptionConfigDetails)
    pub fn builder() -> crate::model::aws_xray_encryption_config_details::Builder {
        crate::model::aws_xray_encryption_config_details::Builder::default()
    }
}

/// <p>Contains details about the service configuration for a VPC endpoint service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpcEndpointServiceDetails {
    /// <p>Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>
    pub acceptance_required: bool,
    /// <p>The Availability Zones where the service is available.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The DNS names for the service.</p>
    pub base_endpoint_dns_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether the service manages its VPC endpoints.</p>
    pub manages_vpc_endpoints: bool,
    /// <p>The ARNs of the Gateway Load Balancers for the service.</p>
    pub gateway_load_balancer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARNs of the Network Load Balancers for the service.</p>
    pub network_load_balancer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The private DNS name for the service.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the service.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The current state of the service.</p>
    pub service_state: std::option::Option<std::string::String>,
    /// <p>The types for the service.</p>
    pub service_type: std::option::Option<
        std::vec::Vec<crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails>,
    >,
}
impl std::fmt::Debug for AwsEc2VpcEndpointServiceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpcEndpointServiceDetails");
        formatter.field("acceptance_required", &self.acceptance_required);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("base_endpoint_dns_names", &self.base_endpoint_dns_names);
        formatter.field("manages_vpc_endpoints", &self.manages_vpc_endpoints);
        formatter.field(
            "gateway_load_balancer_arns",
            &self.gateway_load_balancer_arns,
        );
        formatter.field(
            "network_load_balancer_arns",
            &self.network_load_balancer_arns,
        );
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("service_id", &self.service_id);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_state", &self.service_state);
        formatter.field("service_type", &self.service_type);
        formatter.finish()
    }
}
/// See [`AwsEc2VpcEndpointServiceDetails`](crate::model::AwsEc2VpcEndpointServiceDetails)
pub mod aws_ec2_vpc_endpoint_service_details {
    /// A builder for [`AwsEc2VpcEndpointServiceDetails`](crate::model::AwsEc2VpcEndpointServiceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acceptance_required: std::option::Option<bool>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) base_endpoint_dns_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) manages_vpc_endpoints: std::option::Option<bool>,
        pub(crate) gateway_load_balancer_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_load_balancer_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_state: std::option::Option<std::string::String>,
        pub(crate) service_type: std::option::Option<
            std::vec::Vec<crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails>,
        >,
    }
    impl Builder {
        /// <p>Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>
        pub fn acceptance_required(mut self, input: bool) -> Self {
            self.acceptance_required = Some(input);
            self
        }
        /// <p>Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>
        pub fn set_acceptance_required(mut self, input: std::option::Option<bool>) -> Self {
            self.acceptance_required = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones where the service is available.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones where the service is available.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `base_endpoint_dns_names`.
        ///
        /// To override the contents of this collection use [`set_base_endpoint_dns_names`](Self::set_base_endpoint_dns_names).
        ///
        /// <p>The DNS names for the service.</p>
        pub fn base_endpoint_dns_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.base_endpoint_dns_names.unwrap_or_default();
            v.push(input.into());
            self.base_endpoint_dns_names = Some(v);
            self
        }
        /// <p>The DNS names for the service.</p>
        pub fn set_base_endpoint_dns_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.base_endpoint_dns_names = input;
            self
        }
        /// <p>Whether the service manages its VPC endpoints.</p>
        pub fn manages_vpc_endpoints(mut self, input: bool) -> Self {
            self.manages_vpc_endpoints = Some(input);
            self
        }
        /// <p>Whether the service manages its VPC endpoints.</p>
        pub fn set_manages_vpc_endpoints(mut self, input: std::option::Option<bool>) -> Self {
            self.manages_vpc_endpoints = input;
            self
        }
        /// Appends an item to `gateway_load_balancer_arns`.
        ///
        /// To override the contents of this collection use [`set_gateway_load_balancer_arns`](Self::set_gateway_load_balancer_arns).
        ///
        /// <p>The ARNs of the Gateway Load Balancers for the service.</p>
        pub fn gateway_load_balancer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.gateway_load_balancer_arns.unwrap_or_default();
            v.push(input.into());
            self.gateway_load_balancer_arns = Some(v);
            self
        }
        /// <p>The ARNs of the Gateway Load Balancers for the service.</p>
        pub fn set_gateway_load_balancer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.gateway_load_balancer_arns = input;
            self
        }
        /// Appends an item to `network_load_balancer_arns`.
        ///
        /// To override the contents of this collection use [`set_network_load_balancer_arns`](Self::set_network_load_balancer_arns).
        ///
        /// <p>The ARNs of the Network Load Balancers for the service.</p>
        pub fn network_load_balancer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.network_load_balancer_arns.unwrap_or_default();
            v.push(input.into());
            self.network_load_balancer_arns = Some(v);
            self
        }
        /// <p>The ARNs of the Network Load Balancers for the service.</p>
        pub fn set_network_load_balancer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.network_load_balancer_arns = input;
            self
        }
        /// <p>The private DNS name for the service.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private DNS name for the service.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The identifier of the service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The identifier of the service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The current state of the service.</p>
        pub fn service_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_state = Some(input.into());
            self
        }
        /// <p>The current state of the service.</p>
        pub fn set_service_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_state = input;
            self
        }
        /// Appends an item to `service_type`.
        ///
        /// To override the contents of this collection use [`set_service_type`](Self::set_service_type).
        ///
        /// <p>The types for the service.</p>
        pub fn service_type(
            mut self,
            input: impl Into<crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails>,
        ) -> Self {
            let mut v = self.service_type.unwrap_or_default();
            v.push(input.into());
            self.service_type = Some(v);
            self
        }
        /// <p>The types for the service.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails>,
            >,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpcEndpointServiceDetails`](crate::model::AwsEc2VpcEndpointServiceDetails)
        pub fn build(self) -> crate::model::AwsEc2VpcEndpointServiceDetails {
            crate::model::AwsEc2VpcEndpointServiceDetails {
                acceptance_required: self.acceptance_required.unwrap_or_default(),
                availability_zones: self.availability_zones,
                base_endpoint_dns_names: self.base_endpoint_dns_names,
                manages_vpc_endpoints: self.manages_vpc_endpoints.unwrap_or_default(),
                gateway_load_balancer_arns: self.gateway_load_balancer_arns,
                network_load_balancer_arns: self.network_load_balancer_arns,
                private_dns_name: self.private_dns_name,
                service_id: self.service_id,
                service_name: self.service_name,
                service_state: self.service_state,
                service_type: self.service_type,
            }
        }
    }
}
impl AwsEc2VpcEndpointServiceDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpcEndpointServiceDetails`](crate::model::AwsEc2VpcEndpointServiceDetails)
    pub fn builder() -> crate::model::aws_ec2_vpc_endpoint_service_details::Builder {
        crate::model::aws_ec2_vpc_endpoint_service_details::Builder::default()
    }
}

/// <p>The service type information for a VPC endpoint service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpcEndpointServiceServiceTypeDetails {
    /// <p>The type of service.</p>
    pub service_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEc2VpcEndpointServiceServiceTypeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpcEndpointServiceServiceTypeDetails");
        formatter.field("service_type", &self.service_type);
        formatter.finish()
    }
}
/// See [`AwsEc2VpcEndpointServiceServiceTypeDetails`](crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails)
pub mod aws_ec2_vpc_endpoint_service_service_type_details {
    /// A builder for [`AwsEc2VpcEndpointServiceServiceTypeDetails`](crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of service.</p>
        pub fn service_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_type = Some(input.into());
            self
        }
        /// <p>The type of service.</p>
        pub fn set_service_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpcEndpointServiceServiceTypeDetails`](crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails)
        pub fn build(self) -> crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails {
            crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails {
                service_type: self.service_type,
            }
        }
    }
}
impl AwsEc2VpcEndpointServiceServiceTypeDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpcEndpointServiceServiceTypeDetails`](crate::model::AwsEc2VpcEndpointServiceServiceTypeDetails)
    pub fn builder() -> crate::model::aws_ec2_vpc_endpoint_service_service_type_details::Builder {
        crate::model::aws_ec2_vpc_endpoint_service_service_type_details::Builder::default()
    }
}

/// <p>Information about an Amazon OpenSearch Service domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainDetails {
    /// <p>The ARN of the OpenSearch Service domain.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>IAM policy document that specifies the access policies for the OpenSearch Service domain.</p>
    pub access_policies: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the domain.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The domain endpoint.</p>
    pub domain_endpoint: std::option::Option<std::string::String>,
    /// <p>The version of the domain engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Details about the configuration for encryption at rest.</p>
    pub encryption_at_rest_options:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails>,
    /// <p>Details about the configuration for node-to-node encryption.</p>
    pub node_to_node_encryption_options: std::option::Option<
        crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails,
    >,
    /// <p>Information about the status of a domain relative to the latest service software.</p>
    pub service_software_options:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails>,
    /// <p>Details about the configuration of an OpenSearch cluster.</p>
    pub cluster_config:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainClusterConfigDetails>,
    /// <p>Additional options for the domain endpoint.</p>
    pub domain_endpoint_options:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails>,
    /// <p>Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.</p>
    pub vpc_options: std::option::Option<crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails>,
    /// <p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>
    pub log_publishing_options:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails>,
    /// <p>The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p>
    /// <p>This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.</p>
    pub domain_endpoints:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOpenSearchServiceDomainDetails");
        formatter.field("arn", &self.arn);
        formatter.field("access_policies", &self.access_policies);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("id", &self.id);
        formatter.field("domain_endpoint", &self.domain_endpoint);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "encryption_at_rest_options",
            &self.encryption_at_rest_options,
        );
        formatter.field(
            "node_to_node_encryption_options",
            &self.node_to_node_encryption_options,
        );
        formatter.field("service_software_options", &self.service_software_options);
        formatter.field("cluster_config", &self.cluster_config);
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.field("vpc_options", &self.vpc_options);
        formatter.field("log_publishing_options", &self.log_publishing_options);
        formatter.field("domain_endpoints", &self.domain_endpoints);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainDetails`](crate::model::AwsOpenSearchServiceDomainDetails)
pub mod aws_open_search_service_domain_details {
    /// A builder for [`AwsOpenSearchServiceDomainDetails`](crate::model::AwsOpenSearchServiceDomainDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) access_policies: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) domain_endpoint: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) encryption_at_rest_options: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails,
        >,
        pub(crate) node_to_node_encryption_options: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails,
        >,
        pub(crate) service_software_options: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails,
        >,
        pub(crate) cluster_config:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainClusterConfigDetails>,
        pub(crate) domain_endpoint_options: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails,
        >,
        pub(crate) vpc_options:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails>,
        pub(crate) log_publishing_options: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails,
        >,
        pub(crate) domain_endpoints: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the OpenSearch Service domain.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the OpenSearch Service domain.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>IAM policy document that specifies the access policies for the OpenSearch Service domain.</p>
        pub fn access_policies(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policies = Some(input.into());
            self
        }
        /// <p>IAM policy document that specifies the access policies for the OpenSearch Service domain.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The identifier of the domain.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The domain endpoint.</p>
        pub fn domain_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_endpoint = Some(input.into());
            self
        }
        /// <p>The domain endpoint.</p>
        pub fn set_domain_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_endpoint = input;
            self
        }
        /// <p>The version of the domain engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the domain engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Details about the configuration for encryption at rest.</p>
        pub fn encryption_at_rest_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails,
        ) -> Self {
            self.encryption_at_rest_options = Some(input);
            self
        }
        /// <p>Details about the configuration for encryption at rest.</p>
        pub fn set_encryption_at_rest_options(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails,
            >,
        ) -> Self {
            self.encryption_at_rest_options = input;
            self
        }
        /// <p>Details about the configuration for node-to-node encryption.</p>
        pub fn node_to_node_encryption_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails,
        ) -> Self {
            self.node_to_node_encryption_options = Some(input);
            self
        }
        /// <p>Details about the configuration for node-to-node encryption.</p>
        pub fn set_node_to_node_encryption_options(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails,
            >,
        ) -> Self {
            self.node_to_node_encryption_options = input;
            self
        }
        /// <p>Information about the status of a domain relative to the latest service software.</p>
        pub fn service_software_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails,
        ) -> Self {
            self.service_software_options = Some(input);
            self
        }
        /// <p>Information about the status of a domain relative to the latest service software.</p>
        pub fn set_service_software_options(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails,
            >,
        ) -> Self {
            self.service_software_options = input;
            self
        }
        /// <p>Details about the configuration of an OpenSearch cluster.</p>
        pub fn cluster_config(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainClusterConfigDetails,
        ) -> Self {
            self.cluster_config = Some(input);
            self
        }
        /// <p>Details about the configuration of an OpenSearch cluster.</p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainClusterConfigDetails,
            >,
        ) -> Self {
            self.cluster_config = input;
            self
        }
        /// <p>Additional options for the domain endpoint.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>Additional options for the domain endpoint.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails,
            >,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// <p>Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.</p>
        pub fn vpc_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails,
        ) -> Self {
            self.vpc_options = Some(input);
            self
        }
        /// <p>Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.</p>
        pub fn set_vpc_options(
            mut self,
            input: std::option::Option<crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails>,
        ) -> Self {
            self.vpc_options = input;
            self
        }
        /// <p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>
        pub fn log_publishing_options(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails,
        ) -> Self {
            self.log_publishing_options = Some(input);
            self
        }
        /// <p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>
        pub fn set_log_publishing_options(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails,
            >,
        ) -> Self {
            self.log_publishing_options = input;
            self
        }
        /// Adds a key-value pair to `domain_endpoints`.
        ///
        /// To override the contents of this collection use [`set_domain_endpoints`](Self::set_domain_endpoints).
        ///
        /// <p>The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p>
        /// <p>This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.</p>
        pub fn domain_endpoints(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.domain_endpoints.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.domain_endpoints = Some(hash_map);
            self
        }
        /// <p>The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p>
        /// <p>This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.</p>
        pub fn set_domain_endpoints(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.domain_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainDetails`](crate::model::AwsOpenSearchServiceDomainDetails)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainDetails {
            crate::model::AwsOpenSearchServiceDomainDetails {
                arn: self.arn,
                access_policies: self.access_policies,
                domain_name: self.domain_name,
                id: self.id,
                domain_endpoint: self.domain_endpoint,
                engine_version: self.engine_version,
                encryption_at_rest_options: self.encryption_at_rest_options,
                node_to_node_encryption_options: self.node_to_node_encryption_options,
                service_software_options: self.service_software_options,
                cluster_config: self.cluster_config,
                domain_endpoint_options: self.domain_endpoint_options,
                vpc_options: self.vpc_options,
                log_publishing_options: self.log_publishing_options,
                domain_endpoints: self.domain_endpoints,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainDetails`](crate::model::AwsOpenSearchServiceDomainDetails)
    pub fn builder() -> crate::model::aws_open_search_service_domain_details::Builder {
        crate::model::aws_open_search_service_domain_details::Builder::default()
    }
}

/// <p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
    /// <p>Configures the OpenSearch index logs publishing.</p>
    pub index_slow_logs:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
    /// <p>Configures the OpenSearch search slow log publishing.</p>
    pub search_slow_logs:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
    /// <p>Configures the OpenSearch audit logs publishing.</p>
    pub audit_logs:
        std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOpenSearchServiceDomainLogPublishingOptionsDetails");
        formatter.field("index_slow_logs", &self.index_slow_logs);
        formatter.field("search_slow_logs", &self.search_slow_logs);
        formatter.field("audit_logs", &self.audit_logs);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainLogPublishingOptionsDetails`](crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails)
pub mod aws_open_search_service_domain_log_publishing_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainLogPublishingOptionsDetails`](crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_slow_logs:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
        pub(crate) search_slow_logs:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
        pub(crate) audit_logs:
            std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
    }
    impl Builder {
        /// <p>Configures the OpenSearch index logs publishing.</p>
        pub fn index_slow_logs(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainLogPublishingOption,
        ) -> Self {
            self.index_slow_logs = Some(input);
            self
        }
        /// <p>Configures the OpenSearch index logs publishing.</p>
        pub fn set_index_slow_logs(
            mut self,
            input: std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
        ) -> Self {
            self.index_slow_logs = input;
            self
        }
        /// <p>Configures the OpenSearch search slow log publishing.</p>
        pub fn search_slow_logs(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainLogPublishingOption,
        ) -> Self {
            self.search_slow_logs = Some(input);
            self
        }
        /// <p>Configures the OpenSearch search slow log publishing.</p>
        pub fn set_search_slow_logs(
            mut self,
            input: std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
        ) -> Self {
            self.search_slow_logs = input;
            self
        }
        /// <p>Configures the OpenSearch audit logs publishing.</p>
        pub fn audit_logs(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainLogPublishingOption,
        ) -> Self {
            self.audit_logs = Some(input);
            self
        }
        /// <p>Configures the OpenSearch audit logs publishing.</p>
        pub fn set_audit_logs(
            mut self,
            input: std::option::Option<crate::model::AwsOpenSearchServiceDomainLogPublishingOption>,
        ) -> Self {
            self.audit_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainLogPublishingOptionsDetails`](crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
                index_slow_logs: self.index_slow_logs,
                search_slow_logs: self.search_slow_logs,
                audit_logs: self.audit_logs,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainLogPublishingOptionsDetails`](crate::model::AwsOpenSearchServiceDomainLogPublishingOptionsDetails)
    pub fn builder(
    ) -> crate::model::aws_open_search_service_domain_log_publishing_options_details::Builder {
        crate::model::aws_open_search_service_domain_log_publishing_options_details::Builder::default()
    }
}

/// <p>Configuration details for a log publishing option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainLogPublishingOption {
    /// <p>The ARN of the CloudWatch Logs group to publish the logs to.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Whether the log publishing is enabled.</p>
    pub enabled: bool,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainLogPublishingOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOpenSearchServiceDomainLogPublishingOption");
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainLogPublishingOption`](crate::model::AwsOpenSearchServiceDomainLogPublishingOption)
pub mod aws_open_search_service_domain_log_publishing_option {
    /// A builder for [`AwsOpenSearchServiceDomainLogPublishingOption`](crate::model::AwsOpenSearchServiceDomainLogPublishingOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the CloudWatch Logs group to publish the logs to.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch Logs group to publish the logs to.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Whether the log publishing is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the log publishing is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainLogPublishingOption`](crate::model::AwsOpenSearchServiceDomainLogPublishingOption)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainLogPublishingOption {
            crate::model::AwsOpenSearchServiceDomainLogPublishingOption {
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl AwsOpenSearchServiceDomainLogPublishingOption {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainLogPublishingOption`](crate::model::AwsOpenSearchServiceDomainLogPublishingOption)
    pub fn builder() -> crate::model::aws_open_search_service_domain_log_publishing_option::Builder
    {
        crate::model::aws_open_search_service_domain_log_publishing_option::Builder::default()
    }
}

/// <p>Contains information that OpenSearch Service derives based on the <code>VPCOptions</code> for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainVpcOptionsDetails {
    /// <p>The list of security group IDs that are associated with the VPC endpoints for the domain.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs that are associated with the VPC endpoints for the domain.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainVpcOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOpenSearchServiceDomainVpcOptionsDetails");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainVpcOptionsDetails`](crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails)
pub mod aws_open_search_service_domain_vpc_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainVpcOptionsDetails`](crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The list of security group IDs that are associated with the VPC endpoints for the domain.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The list of security group IDs that are associated with the VPC endpoints for the domain.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs that are associated with the VPC endpoints for the domain.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs that are associated with the VPC endpoints for the domain.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainVpcOptionsDetails`](crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails {
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainVpcOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainVpcOptionsDetails`](crate::model::AwsOpenSearchServiceDomainVpcOptionsDetails)
    pub fn builder() -> crate::model::aws_open_search_service_domain_vpc_options_details::Builder {
        crate::model::aws_open_search_service_domain_vpc_options_details::Builder::default()
    }
}

/// <p>Information about additional options for the domain endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
    /// <p>The ARN for the security certificate. The certificate is managed in ACM.</p>
    pub custom_endpoint_certificate_arn: std::option::Option<std::string::String>,
    /// <p>Whether to enable a custom endpoint for the domain.</p>
    pub custom_endpoint_enabled: bool,
    /// <p>Whether to require that all traffic to the domain arrive over HTTPS.</p>
    pub enforce_https: bool,
    /// <p>The fully qualified URL for the custom endpoint.</p>
    pub custom_endpoint: std::option::Option<std::string::String>,
    /// <p>The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.</p>
    pub tls_security_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsOpenSearchServiceDomainDomainEndpointOptionsDetails");
        formatter.field(
            "custom_endpoint_certificate_arn",
            &self.custom_endpoint_certificate_arn,
        );
        formatter.field("custom_endpoint_enabled", &self.custom_endpoint_enabled);
        formatter.field("enforce_https", &self.enforce_https);
        formatter.field("custom_endpoint", &self.custom_endpoint);
        formatter.field("tls_security_policy", &self.tls_security_policy);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainDomainEndpointOptionsDetails`](crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)
pub mod aws_open_search_service_domain_domain_endpoint_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainDomainEndpointOptionsDetails`](crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_endpoint_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_enabled: std::option::Option<bool>,
        pub(crate) enforce_https: std::option::Option<bool>,
        pub(crate) custom_endpoint: std::option::Option<std::string::String>,
        pub(crate) tls_security_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the security certificate. The certificate is managed in ACM.</p>
        pub fn custom_endpoint_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_endpoint_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the security certificate. The certificate is managed in ACM.</p>
        pub fn set_custom_endpoint_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_certificate_arn = input;
            self
        }
        /// <p>Whether to enable a custom endpoint for the domain.</p>
        pub fn custom_endpoint_enabled(mut self, input: bool) -> Self {
            self.custom_endpoint_enabled = Some(input);
            self
        }
        /// <p>Whether to enable a custom endpoint for the domain.</p>
        pub fn set_custom_endpoint_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.custom_endpoint_enabled = input;
            self
        }
        /// <p>Whether to require that all traffic to the domain arrive over HTTPS.</p>
        pub fn enforce_https(mut self, input: bool) -> Self {
            self.enforce_https = Some(input);
            self
        }
        /// <p>Whether to require that all traffic to the domain arrive over HTTPS.</p>
        pub fn set_enforce_https(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce_https = input;
            self
        }
        /// <p>The fully qualified URL for the custom endpoint.</p>
        pub fn custom_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint = Some(input.into());
            self
        }
        /// <p>The fully qualified URL for the custom endpoint.</p>
        pub fn set_custom_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint = input;
            self
        }
        /// <p>The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.</p>
        pub fn tls_security_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.tls_security_policy = Some(input.into());
            self
        }
        /// <p>The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.</p>
        pub fn set_tls_security_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tls_security_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainDomainEndpointOptionsDetails`](crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
                custom_endpoint_certificate_arn: self.custom_endpoint_certificate_arn,
                custom_endpoint_enabled: self.custom_endpoint_enabled.unwrap_or_default(),
                enforce_https: self.enforce_https.unwrap_or_default(),
                custom_endpoint: self.custom_endpoint,
                tls_security_policy: self.tls_security_policy,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainDomainEndpointOptionsDetails`](crate::model::AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)
    pub fn builder(
    ) -> crate::model::aws_open_search_service_domain_domain_endpoint_options_details::Builder {
        crate::model::aws_open_search_service_domain_domain_endpoint_options_details::Builder::default()
    }
}

/// <p>Details about the configuration of an OpenSearch cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainClusterConfigDetails {
    /// <p>The number of data nodes to use in the OpenSearch domain.</p>
    pub instance_count: i32,
    /// <p>Whether UltraWarm is enabled.</p>
    pub warm_enabled: bool,
    /// <p>The number of UltraWarm instances.</p>
    pub warm_count: i32,
    /// <p>Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.</p>
    pub dedicated_master_enabled: bool,
    /// <p>Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>
    pub zone_awareness_config: std::option::Option<
        crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails,
    >,
    /// <p>The number of instances to use for the master node. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>
    pub dedicated_master_count: i32,
    /// <p>The instance type for your data nodes. </p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The type of UltraWarm instance.</p>
    pub warm_type: std::option::Option<std::string::String>,
    /// <p>Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.</p>
    pub zone_awareness_enabled: bool,
    /// <p>The hardware configuration of the computer that hosts the dedicated master node.</p>
    /// <p>If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
    /// </p>
    pub dedicated_master_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainClusterConfigDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsOpenSearchServiceDomainClusterConfigDetails");
        formatter.field("instance_count", &self.instance_count);
        formatter.field("warm_enabled", &self.warm_enabled);
        formatter.field("warm_count", &self.warm_count);
        formatter.field("dedicated_master_enabled", &self.dedicated_master_enabled);
        formatter.field("zone_awareness_config", &self.zone_awareness_config);
        formatter.field("dedicated_master_count", &self.dedicated_master_count);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("warm_type", &self.warm_type);
        formatter.field("zone_awareness_enabled", &self.zone_awareness_enabled);
        formatter.field("dedicated_master_type", &self.dedicated_master_type);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainClusterConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigDetails)
pub mod aws_open_search_service_domain_cluster_config_details {
    /// A builder for [`AwsOpenSearchServiceDomainClusterConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) warm_enabled: std::option::Option<bool>,
        pub(crate) warm_count: std::option::Option<i32>,
        pub(crate) dedicated_master_enabled: std::option::Option<bool>,
        pub(crate) zone_awareness_config: std::option::Option<
            crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails,
        >,
        pub(crate) dedicated_master_count: std::option::Option<i32>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) warm_type: std::option::Option<std::string::String>,
        pub(crate) zone_awareness_enabled: std::option::Option<bool>,
        pub(crate) dedicated_master_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of data nodes to use in the OpenSearch domain.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of data nodes to use in the OpenSearch domain.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>Whether UltraWarm is enabled.</p>
        pub fn warm_enabled(mut self, input: bool) -> Self {
            self.warm_enabled = Some(input);
            self
        }
        /// <p>Whether UltraWarm is enabled.</p>
        pub fn set_warm_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.warm_enabled = input;
            self
        }
        /// <p>The number of UltraWarm instances.</p>
        pub fn warm_count(mut self, input: i32) -> Self {
            self.warm_count = Some(input);
            self
        }
        /// <p>The number of UltraWarm instances.</p>
        pub fn set_warm_count(mut self, input: std::option::Option<i32>) -> Self {
            self.warm_count = input;
            self
        }
        /// <p>Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.</p>
        pub fn dedicated_master_enabled(mut self, input: bool) -> Self {
            self.dedicated_master_enabled = Some(input);
            self
        }
        /// <p>Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.</p>
        pub fn set_dedicated_master_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.dedicated_master_enabled = input;
            self
        }
        /// <p>Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>
        pub fn zone_awareness_config(
            mut self,
            input: crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails,
        ) -> Self {
            self.zone_awareness_config = Some(input);
            self
        }
        /// <p>Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>
        pub fn set_zone_awareness_config(
            mut self,
            input: std::option::Option<
                crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails,
            >,
        ) -> Self {
            self.zone_awareness_config = input;
            self
        }
        /// <p>The number of instances to use for the master node. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>
        pub fn dedicated_master_count(mut self, input: i32) -> Self {
            self.dedicated_master_count = Some(input);
            self
        }
        /// <p>The number of instances to use for the master node. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>
        pub fn set_dedicated_master_count(mut self, input: std::option::Option<i32>) -> Self {
            self.dedicated_master_count = input;
            self
        }
        /// <p>The instance type for your data nodes. </p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for your data nodes. </p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The type of UltraWarm instance.</p>
        pub fn warm_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.warm_type = Some(input.into());
            self
        }
        /// <p>The type of UltraWarm instance.</p>
        pub fn set_warm_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warm_type = input;
            self
        }
        /// <p>Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.</p>
        pub fn zone_awareness_enabled(mut self, input: bool) -> Self {
            self.zone_awareness_enabled = Some(input);
            self
        }
        /// <p>Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.</p>
        pub fn set_zone_awareness_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.zone_awareness_enabled = input;
            self
        }
        /// <p>The hardware configuration of the computer that hosts the dedicated master node.</p>
        /// <p>If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
        /// </p>
        pub fn dedicated_master_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dedicated_master_type = Some(input.into());
            self
        }
        /// <p>The hardware configuration of the computer that hosts the dedicated master node.</p>
        /// <p>If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
        /// </p>
        pub fn set_dedicated_master_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dedicated_master_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainClusterConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigDetails)
        pub fn build(self) -> crate::model::AwsOpenSearchServiceDomainClusterConfigDetails {
            crate::model::AwsOpenSearchServiceDomainClusterConfigDetails {
                instance_count: self.instance_count.unwrap_or_default(),
                warm_enabled: self.warm_enabled.unwrap_or_default(),
                warm_count: self.warm_count.unwrap_or_default(),
                dedicated_master_enabled: self.dedicated_master_enabled.unwrap_or_default(),
                zone_awareness_config: self.zone_awareness_config,
                dedicated_master_count: self.dedicated_master_count.unwrap_or_default(),
                instance_type: self.instance_type,
                warm_type: self.warm_type,
                zone_awareness_enabled: self.zone_awareness_enabled.unwrap_or_default(),
                dedicated_master_type: self.dedicated_master_type,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainClusterConfigDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainClusterConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigDetails)
    pub fn builder() -> crate::model::aws_open_search_service_domain_cluster_config_details::Builder
    {
        crate::model::aws_open_search_service_domain_cluster_config_details::Builder::default()
    }
}

/// <p>Configuration options for zone awareness.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
    /// <p>The number of Availability Zones that the domain uses. Valid values are 2 and 3. The default is 2.</p>
    pub availability_zone_count: i32,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails");
        formatter.field("availability_zone_count", &self.availability_zone_count);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)
pub mod aws_open_search_service_domain_cluster_config_zone_awareness_config_details {
    /// A builder for [`AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of Availability Zones that the domain uses. Valid values are 2 and 3. The default is 2.</p>
        pub fn availability_zone_count(mut self, input: i32) -> Self {
            self.availability_zone_count = Some(input);
            self
        }
        /// <p>The number of Availability Zones that the domain uses. Valid values are 2 and 3. The default is 2.</p>
        pub fn set_availability_zone_count(mut self, input: std::option::Option<i32>) -> Self {
            self.availability_zone_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
        {
            crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
                availability_zone_count: self.availability_zone_count.unwrap_or_default(),
            }
        }
    }
}
impl AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails`](crate::model::AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)
    pub fn builder() -> crate::model::aws_open_search_service_domain_cluster_config_zone_awareness_config_details::Builder{
        crate::model::aws_open_search_service_domain_cluster_config_zone_awareness_config_details::Builder::default()
    }
}

/// <p>Provides information about the state of the domain relative to the latest service software.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
    /// <p>The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service schedules the software upgrade automatically.</p>
    pub automated_update_date: std::option::Option<std::string::String>,
    /// <p>Whether a request to update the domain can be canceled.</p>
    pub cancellable: bool,
    /// <p>The version of the service software that is currently installed on the domain.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>A more detailed description of the service software status.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The most recent version of the service software.</p>
    pub new_version: std::option::Option<std::string::String>,
    /// <p>Whether a service software update is available for the domain.</p>
    pub update_available: bool,
    /// <p>The status of the service software update.</p>
    pub update_status: std::option::Option<std::string::String>,
    /// <p>Whether the service software update is optional.</p>
    pub optional_deployment: bool,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails");
        formatter.field("automated_update_date", &self.automated_update_date);
        formatter.field("cancellable", &self.cancellable);
        formatter.field("current_version", &self.current_version);
        formatter.field("description", &self.description);
        formatter.field("new_version", &self.new_version);
        formatter.field("update_available", &self.update_available);
        formatter.field("update_status", &self.update_status);
        formatter.field("optional_deployment", &self.optional_deployment);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails`](crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)
pub mod aws_open_search_service_domain_service_software_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails`](crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automated_update_date: std::option::Option<std::string::String>,
        pub(crate) cancellable: std::option::Option<bool>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) new_version: std::option::Option<std::string::String>,
        pub(crate) update_available: std::option::Option<bool>,
        pub(crate) update_status: std::option::Option<std::string::String>,
        pub(crate) optional_deployment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service schedules the software upgrade automatically.</p>
        pub fn automated_update_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.automated_update_date = Some(input.into());
            self
        }
        /// <p>The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service schedules the software upgrade automatically.</p>
        pub fn set_automated_update_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automated_update_date = input;
            self
        }
        /// <p>Whether a request to update the domain can be canceled.</p>
        pub fn cancellable(mut self, input: bool) -> Self {
            self.cancellable = Some(input);
            self
        }
        /// <p>Whether a request to update the domain can be canceled.</p>
        pub fn set_cancellable(mut self, input: std::option::Option<bool>) -> Self {
            self.cancellable = input;
            self
        }
        /// <p>The version of the service software that is currently installed on the domain.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The version of the service software that is currently installed on the domain.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>A more detailed description of the service software status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A more detailed description of the service software status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The most recent version of the service software.</p>
        pub fn new_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_version = Some(input.into());
            self
        }
        /// <p>The most recent version of the service software.</p>
        pub fn set_new_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.new_version = input;
            self
        }
        /// <p>Whether a service software update is available for the domain.</p>
        pub fn update_available(mut self, input: bool) -> Self {
            self.update_available = Some(input);
            self
        }
        /// <p>Whether a service software update is available for the domain.</p>
        pub fn set_update_available(mut self, input: std::option::Option<bool>) -> Self {
            self.update_available = input;
            self
        }
        /// <p>The status of the service software update.</p>
        pub fn update_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_status = Some(input.into());
            self
        }
        /// <p>The status of the service software update.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>Whether the service software update is optional.</p>
        pub fn optional_deployment(mut self, input: bool) -> Self {
            self.optional_deployment = Some(input);
            self
        }
        /// <p>Whether the service software update is optional.</p>
        pub fn set_optional_deployment(mut self, input: std::option::Option<bool>) -> Self {
            self.optional_deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails`](crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
                automated_update_date: self.automated_update_date,
                cancellable: self.cancellable.unwrap_or_default(),
                current_version: self.current_version,
                description: self.description,
                new_version: self.new_version,
                update_available: self.update_available.unwrap_or_default(),
                update_status: self.update_status,
                optional_deployment: self.optional_deployment.unwrap_or_default(),
            }
        }
    }
}
impl AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails`](crate::model::AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)
    pub fn builder(
    ) -> crate::model::aws_open_search_service_domain_service_software_options_details::Builder
    {
        crate::model::aws_open_search_service_domain_service_software_options_details::Builder::default()
    }
}

/// <p>Provides details about the configuration for node-to-node encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
    /// <p>Whether node-to-node encryption is enabled.</p>
    pub enabled: bool,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails`](crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)
pub mod aws_open_search_service_domain_node_to_node_encryption_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails`](crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether node-to-node encryption is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether node-to-node encryption is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails`](crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails`](crate::model::AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)
    pub fn builder(
    ) -> crate::model::aws_open_search_service_domain_node_to_node_encryption_options_details::Builder
    {
        crate::model::aws_open_search_service_domain_node_to_node_encryption_options_details::Builder::default()
    }
}

/// <p>Details about the configuration for encryption at rest for the OpenSearch domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
    /// <p>Whether encryption at rest is enabled.</p>
    pub enabled: bool,
    /// <p>The KMS key ID.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails");
        formatter.field("enabled", &self.enabled);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails`](crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)
pub mod aws_open_search_service_domain_encryption_at_rest_options_details {
    /// A builder for [`AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails`](crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether encryption at rest is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether encryption at rest is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The KMS key ID.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key ID.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails`](crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
            crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
                enabled: self.enabled.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails`](crate::model::AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)
    pub fn builder(
    ) -> crate::model::aws_open_search_service_domain_encryption_at_rest_options_details::Builder
    {
        crate::model::aws_open_search_service_domain_encryption_at_rest_options_details::Builder::default()
    }
}

/// <p>Information about an Amazon ECR image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrContainerImageDetails {
    /// <p>The Amazon Web Services account identifier that is associated with the registry that the image belongs
    /// to.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that the image belongs to.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The architecture of the image.</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The sha256 digest of the image manifest.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The list of tags that are associated with the image.</p>
    pub image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time when the image was pushed to the repository.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub image_published_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcrContainerImageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrContainerImageDetails");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("architecture", &self.architecture);
        formatter.field("image_digest", &self.image_digest);
        formatter.field("image_tags", &self.image_tags);
        formatter.field("image_published_at", &self.image_published_at);
        formatter.finish()
    }
}
/// See [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
pub mod aws_ecr_container_image_details {
    /// A builder for [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) image_published_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account identifier that is associated with the registry that the image belongs
        /// to.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier that is associated with the registry that the image belongs
        /// to.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that the image belongs to.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that the image belongs to.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The architecture of the image.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The architecture of the image.</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The sha256 digest of the image manifest.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The sha256 digest of the image manifest.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Appends an item to `image_tags`.
        ///
        /// To override the contents of this collection use [`set_image_tags`](Self::set_image_tags).
        ///
        /// <p>The list of tags that are associated with the image.</p>
        pub fn image_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_tags.unwrap_or_default();
            v.push(input.into());
            self.image_tags = Some(v);
            self
        }
        /// <p>The list of tags that are associated with the image.</p>
        pub fn set_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_tags = input;
            self
        }
        /// <p>The date and time when the image was pushed to the repository.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn image_published_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_published_at = Some(input.into());
            self
        }
        /// <p>The date and time when the image was pushed to the repository.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_image_published_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_published_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
        pub fn build(self) -> crate::model::AwsEcrContainerImageDetails {
            crate::model::AwsEcrContainerImageDetails {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                architecture: self.architecture,
                image_digest: self.image_digest,
                image_tags: self.image_tags,
                image_published_at: self.image_published_at,
            }
        }
    }
}
impl AwsEcrContainerImageDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
    pub fn builder() -> crate::model::aws_ecr_container_image_details::Builder {
        crate::model::aws_ecr_container_image_details::Builder::default()
    }
}

/// <p>Details about an Amazon EC2 VPN
/// connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpnConnectionDetails {
    /// <p>The identifier of the VPN connection.</p>
    pub vpn_connection_id: std::option::Option<std::string::String>,
    /// <p>The current state of the VPN connection.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The identifier of the customer gateway that is at your end of the VPN connection.</p>
    pub customer_gateway_id: std::option::Option<std::string::String>,
    /// <p>The configuration information for the VPN connection's customer gateway, in the native XML
    /// format.</p>
    pub customer_gateway_configuration: std::option::Option<std::string::String>,
    /// <p>The type of VPN connection.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN
    /// connection.</p>
    pub vpn_gateway_id: std::option::Option<std::string::String>,
    /// <p>The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection. <code>VPN-Classic</code>
    /// indicates an Amazon Web Services Classic VPN connection.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>Information about the VPN tunnel.</p>
    pub vgw_telemetry:
        std::option::Option<std::vec::Vec<crate::model::AwsEc2VpnConnectionVgwTelemetryDetails>>,
    /// <p>The VPN connection options.</p>
    pub options: std::option::Option<crate::model::AwsEc2VpnConnectionOptionsDetails>,
    /// <p>The static routes that are associated with the VPN connection.</p>
    pub routes: std::option::Option<std::vec::Vec<crate::model::AwsEc2VpnConnectionRoutesDetails>>,
    /// <p>The identifier of the transit gateway that is associated with the VPN connection.</p>
    pub transit_gateway_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEc2VpnConnectionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpnConnectionDetails");
        formatter.field("vpn_connection_id", &self.vpn_connection_id);
        formatter.field("state", &self.state);
        formatter.field("customer_gateway_id", &self.customer_gateway_id);
        formatter.field(
            "customer_gateway_configuration",
            &self.customer_gateway_configuration,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("vpn_gateway_id", &self.vpn_gateway_id);
        formatter.field("category", &self.category);
        formatter.field("vgw_telemetry", &self.vgw_telemetry);
        formatter.field("options", &self.options);
        formatter.field("routes", &self.routes);
        formatter.field("transit_gateway_id", &self.transit_gateway_id);
        formatter.finish()
    }
}
/// See [`AwsEc2VpnConnectionDetails`](crate::model::AwsEc2VpnConnectionDetails)
pub mod aws_ec2_vpn_connection_details {
    /// A builder for [`AwsEc2VpnConnectionDetails`](crate::model::AwsEc2VpnConnectionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpn_connection_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) customer_gateway_id: std::option::Option<std::string::String>,
        pub(crate) customer_gateway_configuration: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) vpn_gateway_id: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) vgw_telemetry: std::option::Option<
            std::vec::Vec<crate::model::AwsEc2VpnConnectionVgwTelemetryDetails>,
        >,
        pub(crate) options: std::option::Option<crate::model::AwsEc2VpnConnectionOptionsDetails>,
        pub(crate) routes:
            std::option::Option<std::vec::Vec<crate::model::AwsEc2VpnConnectionRoutesDetails>>,
        pub(crate) transit_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the VPN connection.</p>
        pub fn vpn_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpn_connection_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPN connection.</p>
        pub fn set_vpn_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpn_connection_id = input;
            self
        }
        /// <p>The current state of the VPN connection.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The current state of the VPN connection.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The identifier of the customer gateway that is at your end of the VPN connection.</p>
        pub fn customer_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_gateway_id = Some(input.into());
            self
        }
        /// <p>The identifier of the customer gateway that is at your end of the VPN connection.</p>
        pub fn set_customer_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_id = input;
            self
        }
        /// <p>The configuration information for the VPN connection's customer gateway, in the native XML
        /// format.</p>
        pub fn customer_gateway_configuration(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.customer_gateway_configuration = Some(input.into());
            self
        }
        /// <p>The configuration information for the VPN connection's customer gateway, in the native XML
        /// format.</p>
        pub fn set_customer_gateway_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_gateway_configuration = input;
            self
        }
        /// <p>The type of VPN connection.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of VPN connection.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN
        /// connection.</p>
        pub fn vpn_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpn_gateway_id = Some(input.into());
            self
        }
        /// <p>The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN
        /// connection.</p>
        pub fn set_vpn_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpn_gateway_id = input;
            self
        }
        /// <p>The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection. <code>VPN-Classic</code>
        /// indicates an Amazon Web Services Classic VPN connection.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection. <code>VPN-Classic</code>
        /// indicates an Amazon Web Services Classic VPN connection.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// Appends an item to `vgw_telemetry`.
        ///
        /// To override the contents of this collection use [`set_vgw_telemetry`](Self::set_vgw_telemetry).
        ///
        /// <p>Information about the VPN tunnel.</p>
        pub fn vgw_telemetry(
            mut self,
            input: impl Into<crate::model::AwsEc2VpnConnectionVgwTelemetryDetails>,
        ) -> Self {
            let mut v = self.vgw_telemetry.unwrap_or_default();
            v.push(input.into());
            self.vgw_telemetry = Some(v);
            self
        }
        /// <p>Information about the VPN tunnel.</p>
        pub fn set_vgw_telemetry(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEc2VpnConnectionVgwTelemetryDetails>,
            >,
        ) -> Self {
            self.vgw_telemetry = input;
            self
        }
        /// <p>The VPN connection options.</p>
        pub fn options(mut self, input: crate::model::AwsEc2VpnConnectionOptionsDetails) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The VPN connection options.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::AwsEc2VpnConnectionOptionsDetails>,
        ) -> Self {
            self.options = input;
            self
        }
        /// Appends an item to `routes`.
        ///
        /// To override the contents of this collection use [`set_routes`](Self::set_routes).
        ///
        /// <p>The static routes that are associated with the VPN connection.</p>
        pub fn routes(
            mut self,
            input: impl Into<crate::model::AwsEc2VpnConnectionRoutesDetails>,
        ) -> Self {
            let mut v = self.routes.unwrap_or_default();
            v.push(input.into());
            self.routes = Some(v);
            self
        }
        /// <p>The static routes that are associated with the VPN connection.</p>
        pub fn set_routes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEc2VpnConnectionRoutesDetails>,
            >,
        ) -> Self {
            self.routes = input;
            self
        }
        /// <p>The identifier of the transit gateway that is associated with the VPN connection.</p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_id = Some(input.into());
            self
        }
        /// <p>The identifier of the transit gateway that is associated with the VPN connection.</p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpnConnectionDetails`](crate::model::AwsEc2VpnConnectionDetails)
        pub fn build(self) -> crate::model::AwsEc2VpnConnectionDetails {
            crate::model::AwsEc2VpnConnectionDetails {
                vpn_connection_id: self.vpn_connection_id,
                state: self.state,
                customer_gateway_id: self.customer_gateway_id,
                customer_gateway_configuration: self.customer_gateway_configuration,
                r#type: self.r#type,
                vpn_gateway_id: self.vpn_gateway_id,
                category: self.category,
                vgw_telemetry: self.vgw_telemetry,
                options: self.options,
                routes: self.routes,
                transit_gateway_id: self.transit_gateway_id,
            }
        }
    }
}
impl AwsEc2VpnConnectionDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpnConnectionDetails`](crate::model::AwsEc2VpnConnectionDetails)
    pub fn builder() -> crate::model::aws_ec2_vpn_connection_details::Builder {
        crate::model::aws_ec2_vpn_connection_details::Builder::default()
    }
}

/// <p>A static routes associated with
/// the VPN connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpnConnectionRoutesDetails {
    /// <p>The CIDR block associated with the local subnet of the customer data center.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>The current state of the static route.</p>
    pub state: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEc2VpnConnectionRoutesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpnConnectionRoutesDetails");
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`AwsEc2VpnConnectionRoutesDetails`](crate::model::AwsEc2VpnConnectionRoutesDetails)
pub mod aws_ec2_vpn_connection_routes_details {
    /// A builder for [`AwsEc2VpnConnectionRoutesDetails`](crate::model::AwsEc2VpnConnectionRoutesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CIDR block associated with the local subnet of the customer data center.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The CIDR block associated with the local subnet of the customer data center.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The current state of the static route.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The current state of the static route.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpnConnectionRoutesDetails`](crate::model::AwsEc2VpnConnectionRoutesDetails)
        pub fn build(self) -> crate::model::AwsEc2VpnConnectionRoutesDetails {
            crate::model::AwsEc2VpnConnectionRoutesDetails {
                destination_cidr_block: self.destination_cidr_block,
                state: self.state,
            }
        }
    }
}
impl AwsEc2VpnConnectionRoutesDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpnConnectionRoutesDetails`](crate::model::AwsEc2VpnConnectionRoutesDetails)
    pub fn builder() -> crate::model::aws_ec2_vpn_connection_routes_details::Builder {
        crate::model::aws_ec2_vpn_connection_routes_details::Builder::default()
    }
}

/// <p>VPN connection options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpnConnectionOptionsDetails {
    /// <p>Whether the VPN connection uses static routes only.</p>
    pub static_routes_only: bool,
    /// <p>The VPN tunnel options.</p>
    pub tunnel_options: std::option::Option<
        std::vec::Vec<crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails>,
    >,
}
impl std::fmt::Debug for AwsEc2VpnConnectionOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpnConnectionOptionsDetails");
        formatter.field("static_routes_only", &self.static_routes_only);
        formatter.field("tunnel_options", &self.tunnel_options);
        formatter.finish()
    }
}
/// See [`AwsEc2VpnConnectionOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsDetails)
pub mod aws_ec2_vpn_connection_options_details {
    /// A builder for [`AwsEc2VpnConnectionOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) static_routes_only: std::option::Option<bool>,
        pub(crate) tunnel_options: std::option::Option<
            std::vec::Vec<crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails>,
        >,
    }
    impl Builder {
        /// <p>Whether the VPN connection uses static routes only.</p>
        pub fn static_routes_only(mut self, input: bool) -> Self {
            self.static_routes_only = Some(input);
            self
        }
        /// <p>Whether the VPN connection uses static routes only.</p>
        pub fn set_static_routes_only(mut self, input: std::option::Option<bool>) -> Self {
            self.static_routes_only = input;
            self
        }
        /// Appends an item to `tunnel_options`.
        ///
        /// To override the contents of this collection use [`set_tunnel_options`](Self::set_tunnel_options).
        ///
        /// <p>The VPN tunnel options.</p>
        pub fn tunnel_options(
            mut self,
            input: impl Into<crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails>,
        ) -> Self {
            let mut v = self.tunnel_options.unwrap_or_default();
            v.push(input.into());
            self.tunnel_options = Some(v);
            self
        }
        /// <p>The VPN tunnel options.</p>
        pub fn set_tunnel_options(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails>,
            >,
        ) -> Self {
            self.tunnel_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpnConnectionOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsDetails)
        pub fn build(self) -> crate::model::AwsEc2VpnConnectionOptionsDetails {
            crate::model::AwsEc2VpnConnectionOptionsDetails {
                static_routes_only: self.static_routes_only.unwrap_or_default(),
                tunnel_options: self.tunnel_options,
            }
        }
    }
}
impl AwsEc2VpnConnectionOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpnConnectionOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsDetails)
    pub fn builder() -> crate::model::aws_ec2_vpn_connection_options_details::Builder {
        crate::model::aws_ec2_vpn_connection_options_details::Builder::default()
    }
}

/// <p>The VPN tunnel options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
    /// <p>The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.</p>
    pub dpd_timeout_seconds: i32,
    /// <p>The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.</p>
    pub ike_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The external IP address of the VPN tunnel.</p>
    pub outside_ip_address: std::option::Option<std::string::String>,
    /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
    /// negotiations.</p>
    pub phase1_dh_group_numbers: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
    /// negotiations.</p>
    pub phase1_encryption_algorithms: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
    /// negotiations.</p>
    pub phase1_integrity_algorithms: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
    pub phase1_lifetime_seconds: i32,
    /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
    /// negotiations.</p>
    pub phase2_dh_group_numbers: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
    /// negotiations.</p>
    pub phase2_encryption_algorithms: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
    /// negotiations.</p>
    pub phase2_integrity_algorithms: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
    pub phase2_lifetime_seconds: i32,
    /// <p>The preshared key to establish initial authentication between the virtual private gateway
    /// and the customer gateway.</p>
    pub pre_shared_key: std::option::Option<std::string::String>,
    /// <p>The percentage of the rekey window, which is determined by
    /// <code>RekeyMarginTimeSeconds</code> during which the rekey time is randomly selected.</p>
    pub rekey_fuzz_percentage: i32,
    /// <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
    /// side of the VPN connection performs an IKE rekey.</p>
    pub rekey_margin_time_seconds: i32,
    /// <p>The number of packets in an IKE replay window.</p>
    pub replay_window_size: i32,
    /// <p>The range of inside IPv4 addresses for the tunnel.</p>
    pub tunnel_inside_cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpnConnectionOptionsTunnelOptionsDetails");
        formatter.field("dpd_timeout_seconds", &self.dpd_timeout_seconds);
        formatter.field("ike_versions", &self.ike_versions);
        formatter.field("outside_ip_address", &self.outside_ip_address);
        formatter.field("phase1_dh_group_numbers", &self.phase1_dh_group_numbers);
        formatter.field(
            "phase1_encryption_algorithms",
            &self.phase1_encryption_algorithms,
        );
        formatter.field(
            "phase1_integrity_algorithms",
            &self.phase1_integrity_algorithms,
        );
        formatter.field("phase1_lifetime_seconds", &self.phase1_lifetime_seconds);
        formatter.field("phase2_dh_group_numbers", &self.phase2_dh_group_numbers);
        formatter.field(
            "phase2_encryption_algorithms",
            &self.phase2_encryption_algorithms,
        );
        formatter.field(
            "phase2_integrity_algorithms",
            &self.phase2_integrity_algorithms,
        );
        formatter.field("phase2_lifetime_seconds", &self.phase2_lifetime_seconds);
        formatter.field("pre_shared_key", &self.pre_shared_key);
        formatter.field("rekey_fuzz_percentage", &self.rekey_fuzz_percentage);
        formatter.field("rekey_margin_time_seconds", &self.rekey_margin_time_seconds);
        formatter.field("replay_window_size", &self.replay_window_size);
        formatter.field("tunnel_inside_cidr", &self.tunnel_inside_cidr);
        formatter.finish()
    }
}
/// See [`AwsEc2VpnConnectionOptionsTunnelOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails)
pub mod aws_ec2_vpn_connection_options_tunnel_options_details {
    /// A builder for [`AwsEc2VpnConnectionOptionsTunnelOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dpd_timeout_seconds: std::option::Option<i32>,
        pub(crate) ike_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) outside_ip_address: std::option::Option<std::string::String>,
        pub(crate) phase1_dh_group_numbers: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) phase1_encryption_algorithms:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) phase1_integrity_algorithms:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) phase1_lifetime_seconds: std::option::Option<i32>,
        pub(crate) phase2_dh_group_numbers: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) phase2_encryption_algorithms:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) phase2_integrity_algorithms:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) phase2_lifetime_seconds: std::option::Option<i32>,
        pub(crate) pre_shared_key: std::option::Option<std::string::String>,
        pub(crate) rekey_fuzz_percentage: std::option::Option<i32>,
        pub(crate) rekey_margin_time_seconds: std::option::Option<i32>,
        pub(crate) replay_window_size: std::option::Option<i32>,
        pub(crate) tunnel_inside_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.</p>
        pub fn dpd_timeout_seconds(mut self, input: i32) -> Self {
            self.dpd_timeout_seconds = Some(input);
            self
        }
        /// <p>The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.</p>
        pub fn set_dpd_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.dpd_timeout_seconds = input;
            self
        }
        /// Appends an item to `ike_versions`.
        ///
        /// To override the contents of this collection use [`set_ike_versions`](Self::set_ike_versions).
        ///
        /// <p>The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.</p>
        pub fn ike_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ike_versions.unwrap_or_default();
            v.push(input.into());
            self.ike_versions = Some(v);
            self
        }
        /// <p>The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.</p>
        pub fn set_ike_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ike_versions = input;
            self
        }
        /// <p>The external IP address of the VPN tunnel.</p>
        pub fn outside_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.outside_ip_address = Some(input.into());
            self
        }
        /// <p>The external IP address of the VPN tunnel.</p>
        pub fn set_outside_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outside_ip_address = input;
            self
        }
        /// Appends an item to `phase1_dh_group_numbers`.
        ///
        /// To override the contents of this collection use [`set_phase1_dh_group_numbers`](Self::set_phase1_dh_group_numbers).
        ///
        /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn phase1_dh_group_numbers(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.phase1_dh_group_numbers.unwrap_or_default();
            v.push(input.into());
            self.phase1_dh_group_numbers = Some(v);
            self
        }
        /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn set_phase1_dh_group_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.phase1_dh_group_numbers = input;
            self
        }
        /// Appends an item to `phase1_encryption_algorithms`.
        ///
        /// To override the contents of this collection use [`set_phase1_encryption_algorithms`](Self::set_phase1_encryption_algorithms).
        ///
        /// <p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn phase1_encryption_algorithms(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.phase1_encryption_algorithms.unwrap_or_default();
            v.push(input.into());
            self.phase1_encryption_algorithms = Some(v);
            self
        }
        /// <p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn set_phase1_encryption_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phase1_encryption_algorithms = input;
            self
        }
        /// Appends an item to `phase1_integrity_algorithms`.
        ///
        /// To override the contents of this collection use [`set_phase1_integrity_algorithms`](Self::set_phase1_integrity_algorithms).
        ///
        /// <p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn phase1_integrity_algorithms(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.phase1_integrity_algorithms.unwrap_or_default();
            v.push(input.into());
            self.phase1_integrity_algorithms = Some(v);
            self
        }
        /// <p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
        /// negotiations.</p>
        pub fn set_phase1_integrity_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phase1_integrity_algorithms = input;
            self
        }
        /// <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
        pub fn phase1_lifetime_seconds(mut self, input: i32) -> Self {
            self.phase1_lifetime_seconds = Some(input);
            self
        }
        /// <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
        pub fn set_phase1_lifetime_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.phase1_lifetime_seconds = input;
            self
        }
        /// Appends an item to `phase2_dh_group_numbers`.
        ///
        /// To override the contents of this collection use [`set_phase2_dh_group_numbers`](Self::set_phase2_dh_group_numbers).
        ///
        /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn phase2_dh_group_numbers(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.phase2_dh_group_numbers.unwrap_or_default();
            v.push(input.into());
            self.phase2_dh_group_numbers = Some(v);
            self
        }
        /// <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn set_phase2_dh_group_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.phase2_dh_group_numbers = input;
            self
        }
        /// Appends an item to `phase2_encryption_algorithms`.
        ///
        /// To override the contents of this collection use [`set_phase2_encryption_algorithms`](Self::set_phase2_encryption_algorithms).
        ///
        /// <p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn phase2_encryption_algorithms(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.phase2_encryption_algorithms.unwrap_or_default();
            v.push(input.into());
            self.phase2_encryption_algorithms = Some(v);
            self
        }
        /// <p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn set_phase2_encryption_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phase2_encryption_algorithms = input;
            self
        }
        /// Appends an item to `phase2_integrity_algorithms`.
        ///
        /// To override the contents of this collection use [`set_phase2_integrity_algorithms`](Self::set_phase2_integrity_algorithms).
        ///
        /// <p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn phase2_integrity_algorithms(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.phase2_integrity_algorithms.unwrap_or_default();
            v.push(input.into());
            self.phase2_integrity_algorithms = Some(v);
            self
        }
        /// <p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
        /// negotiations.</p>
        pub fn set_phase2_integrity_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.phase2_integrity_algorithms = input;
            self
        }
        /// <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
        pub fn phase2_lifetime_seconds(mut self, input: i32) -> Self {
            self.phase2_lifetime_seconds = Some(input);
            self
        }
        /// <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
        pub fn set_phase2_lifetime_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.phase2_lifetime_seconds = input;
            self
        }
        /// <p>The preshared key to establish initial authentication between the virtual private gateway
        /// and the customer gateway.</p>
        pub fn pre_shared_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_shared_key = Some(input.into());
            self
        }
        /// <p>The preshared key to establish initial authentication between the virtual private gateway
        /// and the customer gateway.</p>
        pub fn set_pre_shared_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_shared_key = input;
            self
        }
        /// <p>The percentage of the rekey window, which is determined by
        /// <code>RekeyMarginTimeSeconds</code> during which the rekey time is randomly selected.</p>
        pub fn rekey_fuzz_percentage(mut self, input: i32) -> Self {
            self.rekey_fuzz_percentage = Some(input);
            self
        }
        /// <p>The percentage of the rekey window, which is determined by
        /// <code>RekeyMarginTimeSeconds</code> during which the rekey time is randomly selected.</p>
        pub fn set_rekey_fuzz_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.rekey_fuzz_percentage = input;
            self
        }
        /// <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
        /// side of the VPN connection performs an IKE rekey.</p>
        pub fn rekey_margin_time_seconds(mut self, input: i32) -> Self {
            self.rekey_margin_time_seconds = Some(input);
            self
        }
        /// <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services
        /// side of the VPN connection performs an IKE rekey.</p>
        pub fn set_rekey_margin_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.rekey_margin_time_seconds = input;
            self
        }
        /// <p>The number of packets in an IKE replay window.</p>
        pub fn replay_window_size(mut self, input: i32) -> Self {
            self.replay_window_size = Some(input);
            self
        }
        /// <p>The number of packets in an IKE replay window.</p>
        pub fn set_replay_window_size(mut self, input: std::option::Option<i32>) -> Self {
            self.replay_window_size = input;
            self
        }
        /// <p>The range of inside IPv4 addresses for the tunnel.</p>
        pub fn tunnel_inside_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.tunnel_inside_cidr = Some(input.into());
            self
        }
        /// <p>The range of inside IPv4 addresses for the tunnel.</p>
        pub fn set_tunnel_inside_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tunnel_inside_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpnConnectionOptionsTunnelOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails)
        pub fn build(self) -> crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
            crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
                dpd_timeout_seconds: self.dpd_timeout_seconds.unwrap_or_default(),
                ike_versions: self.ike_versions,
                outside_ip_address: self.outside_ip_address,
                phase1_dh_group_numbers: self.phase1_dh_group_numbers,
                phase1_encryption_algorithms: self.phase1_encryption_algorithms,
                phase1_integrity_algorithms: self.phase1_integrity_algorithms,
                phase1_lifetime_seconds: self.phase1_lifetime_seconds.unwrap_or_default(),
                phase2_dh_group_numbers: self.phase2_dh_group_numbers,
                phase2_encryption_algorithms: self.phase2_encryption_algorithms,
                phase2_integrity_algorithms: self.phase2_integrity_algorithms,
                phase2_lifetime_seconds: self.phase2_lifetime_seconds.unwrap_or_default(),
                pre_shared_key: self.pre_shared_key,
                rekey_fuzz_percentage: self.rekey_fuzz_percentage.unwrap_or_default(),
                rekey_margin_time_seconds: self.rekey_margin_time_seconds.unwrap_or_default(),
                replay_window_size: self.replay_window_size.unwrap_or_default(),
                tunnel_inside_cidr: self.tunnel_inside_cidr,
            }
        }
    }
}
impl AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpnConnectionOptionsTunnelOptionsDetails`](crate::model::AwsEc2VpnConnectionOptionsTunnelOptionsDetails)
    pub fn builder() -> crate::model::aws_ec2_vpn_connection_options_tunnel_options_details::Builder
    {
        crate::model::aws_ec2_vpn_connection_options_tunnel_options_details::Builder::default()
    }
}

/// <p>Information about the VPN tunnel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2VpnConnectionVgwTelemetryDetails {
    /// <p>The number of accepted routes.</p>
    pub accepted_route_count: i32,
    /// <p>The ARN of the VPN tunnel endpoint certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The date and time of the last change in status.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub last_status_change: std::option::Option<std::string::String>,
    /// <p>The Internet-routable IP address of the virtual private gateway's outside
    /// interface.</p>
    pub outside_ip_address: std::option::Option<std::string::String>,
    /// <p>The status of the VPN tunnel.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an error occurs, a description of the error.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEc2VpnConnectionVgwTelemetryDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2VpnConnectionVgwTelemetryDetails");
        formatter.field("accepted_route_count", &self.accepted_route_count);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("last_status_change", &self.last_status_change);
        formatter.field("outside_ip_address", &self.outside_ip_address);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`AwsEc2VpnConnectionVgwTelemetryDetails`](crate::model::AwsEc2VpnConnectionVgwTelemetryDetails)
pub mod aws_ec2_vpn_connection_vgw_telemetry_details {
    /// A builder for [`AwsEc2VpnConnectionVgwTelemetryDetails`](crate::model::AwsEc2VpnConnectionVgwTelemetryDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accepted_route_count: std::option::Option<i32>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) last_status_change: std::option::Option<std::string::String>,
        pub(crate) outside_ip_address: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of accepted routes.</p>
        pub fn accepted_route_count(mut self, input: i32) -> Self {
            self.accepted_route_count = Some(input);
            self
        }
        /// <p>The number of accepted routes.</p>
        pub fn set_accepted_route_count(mut self, input: std::option::Option<i32>) -> Self {
            self.accepted_route_count = input;
            self
        }
        /// <p>The ARN of the VPN tunnel endpoint certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the VPN tunnel endpoint certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The date and time of the last change in status.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn last_status_change(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_status_change = Some(input.into());
            self
        }
        /// <p>The date and time of the last change in status.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_last_status_change(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_status_change = input;
            self
        }
        /// <p>The Internet-routable IP address of the virtual private gateway's outside
        /// interface.</p>
        pub fn outside_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.outside_ip_address = Some(input.into());
            self
        }
        /// <p>The Internet-routable IP address of the virtual private gateway's outside
        /// interface.</p>
        pub fn set_outside_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.outside_ip_address = input;
            self
        }
        /// <p>The status of the VPN tunnel.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPN tunnel.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurs, a description of the error.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>If an error occurs, a description of the error.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2VpnConnectionVgwTelemetryDetails`](crate::model::AwsEc2VpnConnectionVgwTelemetryDetails)
        pub fn build(self) -> crate::model::AwsEc2VpnConnectionVgwTelemetryDetails {
            crate::model::AwsEc2VpnConnectionVgwTelemetryDetails {
                accepted_route_count: self.accepted_route_count.unwrap_or_default(),
                certificate_arn: self.certificate_arn,
                last_status_change: self.last_status_change,
                outside_ip_address: self.outside_ip_address,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl AwsEc2VpnConnectionVgwTelemetryDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2VpnConnectionVgwTelemetryDetails`](crate::model::AwsEc2VpnConnectionVgwTelemetryDetails)
    pub fn builder() -> crate::model::aws_ec2_vpn_connection_vgw_telemetry_details::Builder {
        crate::model::aws_ec2_vpn_connection_vgw_telemetry_details::Builder::default()
    }
}

/// <p>Details about a launch configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAutoScalingLaunchConfigurationDetails {
    /// <p>For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's instances.</p>
    pub associate_public_ip_address: bool,
    /// <p>Specifies the block devices for the instance.</p>
    pub block_device_mappings: std::option::Option<
        std::vec::Vec<crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>,
    >,
    /// <p>The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.</p>
    pub classic_link_vpc_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>.</p>
    pub classic_link_vpc_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The creation date and time for the launch configuration.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>Whether the launch configuration is optimized for Amazon EBS I/O.</p>
    pub ebs_optimized: bool,
    /// <p>The name or the ARN of the instance profile associated with the IAM role for the
    /// instance. The instance profile contains the IAM role.</p>
    pub iam_instance_profile: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
    /// instances.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>Indicates the type of monitoring for instances in the group.</p>
    pub instance_monitoring: std::option::Option<
        crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails,
    >,
    /// <p>The instance type for the instances.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The identifier of the kernel associated with the AMI.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on
    /// isolated, single-tenant hardware and can only be launched into a VPC.</p>
    pub placement_tenancy: std::option::Option<std::string::String>,
    /// <p>The identifier of the RAM disk associated with the AMI.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>The security groups to assign to the instances in the Auto Scaling group.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the
    /// request.</p>
    pub spot_price: std::option::Option<std::string::String>,
    /// <p>The user data to make available to the launched EC2 instances. Must be base64-encoded
    /// text.</p>
    pub user_data: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsAutoScalingLaunchConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsAutoScalingLaunchConfigurationDetails");
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("classic_link_vpc_id", &self.classic_link_vpc_id);
        formatter.field(
            "classic_link_vpc_security_groups",
            &self.classic_link_vpc_security_groups,
        );
        formatter.field("created_time", &self.created_time);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_monitoring", &self.instance_monitoring);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("placement_tenancy", &self.placement_tenancy);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("spot_price", &self.spot_price);
        formatter.field("user_data", &self.user_data);
        formatter.finish()
    }
}
/// See [`AwsAutoScalingLaunchConfigurationDetails`](crate::model::AwsAutoScalingLaunchConfigurationDetails)
pub mod aws_auto_scaling_launch_configuration_details {
    /// A builder for [`AwsAutoScalingLaunchConfigurationDetails`](crate::model::AwsAutoScalingLaunchConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) block_device_mappings: std::option::Option<
            std::vec::Vec<
                crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails,
            >,
        >,
        pub(crate) classic_link_vpc_id: std::option::Option<std::string::String>,
        pub(crate) classic_link_vpc_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) instance_monitoring: std::option::Option<
            crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails,
        >,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) placement_tenancy: std::option::Option<std::string::String>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) spot_price: std::option::Option<std::string::String>,
        pub(crate) user_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's instances.</p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's instances.</p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>Specifies the block devices for the instance.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>Specifies the block devices for the instance.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails,
                >,
            >,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.</p>
        pub fn classic_link_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.classic_link_vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.</p>
        pub fn set_classic_link_vpc_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classic_link_vpc_id = input;
            self
        }
        /// Appends an item to `classic_link_vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_classic_link_vpc_security_groups`](Self::set_classic_link_vpc_security_groups).
        ///
        /// <p>The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>.</p>
        pub fn classic_link_vpc_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.classic_link_vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.classic_link_vpc_security_groups = Some(v);
            self
        }
        /// <p>The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>.</p>
        pub fn set_classic_link_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.classic_link_vpc_security_groups = input;
            self
        }
        /// <p>The creation date and time for the launch configuration.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The creation date and time for the launch configuration.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Whether the launch configuration is optimized for Amazon EBS I/O.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Whether the launch configuration is optimized for Amazon EBS I/O.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The name or the ARN of the instance profile associated with the IAM role for the
        /// instance. The instance profile contains the IAM role.</p>
        pub fn iam_instance_profile(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the instance profile associated with the IAM role for the
        /// instance. The instance profile contains the IAM role.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
        /// instances.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
        /// instances.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>Indicates the type of monitoring for instances in the group.</p>
        pub fn instance_monitoring(
            mut self,
            input: crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails,
        ) -> Self {
            self.instance_monitoring = Some(input);
            self
        }
        /// <p>Indicates the type of monitoring for instances in the group.</p>
        pub fn set_instance_monitoring(
            mut self,
            input: std::option::Option<
                crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails,
            >,
        ) -> Self {
            self.instance_monitoring = input;
            self
        }
        /// <p>The instance type for the instances.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for the instances.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The identifier of the kernel associated with the AMI.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The identifier of the kernel associated with the AMI.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on
        /// isolated, single-tenant hardware and can only be launched into a VPC.</p>
        pub fn placement_tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_tenancy = Some(input.into());
            self
        }
        /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on
        /// isolated, single-tenant hardware and can only be launched into a VPC.</p>
        pub fn set_placement_tenancy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_tenancy = input;
            self
        }
        /// <p>The identifier of the RAM disk associated with the AMI.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The identifier of the RAM disk associated with the AMI.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups to assign to the instances in the Auto Scaling group.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups to assign to the instances in the Auto Scaling group.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the
        /// request.</p>
        pub fn spot_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_price = Some(input.into());
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the
        /// request.</p>
        pub fn set_spot_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spot_price = input;
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. Must be base64-encoded
        /// text.</p>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. Must be base64-encoded
        /// text.</p>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAutoScalingLaunchConfigurationDetails`](crate::model::AwsAutoScalingLaunchConfigurationDetails)
        pub fn build(self) -> crate::model::AwsAutoScalingLaunchConfigurationDetails {
            crate::model::AwsAutoScalingLaunchConfigurationDetails {
                associate_public_ip_address: self.associate_public_ip_address.unwrap_or_default(),
                block_device_mappings: self.block_device_mappings,
                classic_link_vpc_id: self.classic_link_vpc_id,
                classic_link_vpc_security_groups: self.classic_link_vpc_security_groups,
                created_time: self.created_time,
                ebs_optimized: self.ebs_optimized.unwrap_or_default(),
                iam_instance_profile: self.iam_instance_profile,
                image_id: self.image_id,
                instance_monitoring: self.instance_monitoring,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                key_name: self.key_name,
                launch_configuration_name: self.launch_configuration_name,
                placement_tenancy: self.placement_tenancy,
                ramdisk_id: self.ramdisk_id,
                security_groups: self.security_groups,
                spot_price: self.spot_price,
                user_data: self.user_data,
            }
        }
    }
}
impl AwsAutoScalingLaunchConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsAutoScalingLaunchConfigurationDetails`](crate::model::AwsAutoScalingLaunchConfigurationDetails)
    pub fn builder() -> crate::model::aws_auto_scaling_launch_configuration_details::Builder {
        crate::model::aws_auto_scaling_launch_configuration_details::Builder::default()
    }
}

/// <p>Information about the type of monitoring for instances in the group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
    /// <p>If set to <code>true</code>, then instances in the group launch with detailed
    /// monitoring.</p>
    /// <p>If set to <code>false</code>, then instances in the group launch with basic
    /// monitoring.</p>
    pub enabled: bool,
}
impl std::fmt::Debug for AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails`](crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)
pub mod aws_auto_scaling_launch_configuration_instance_monitoring_details {
    /// A builder for [`AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails`](crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If set to <code>true</code>, then instances in the group launch with detailed
        /// monitoring.</p>
        /// <p>If set to <code>false</code>, then instances in the group launch with basic
        /// monitoring.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, then instances in the group launch with detailed
        /// monitoring.</p>
        /// <p>If set to <code>false</code>, then instances in the group launch with basic
        /// monitoring.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails`](crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
            crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
    /// Creates a new builder-style object to manufacture [`AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails`](crate::model::AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)
    pub fn builder(
    ) -> crate::model::aws_auto_scaling_launch_configuration_instance_monitoring_details::Builder
    {
        crate::model::aws_auto_scaling_launch_configuration_instance_monitoring_details::Builder::default()
    }
}

/// <p>A block device for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
    /// <p>The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.</p>
    pub ebs: std::option::Option<
        crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails,
    >,
    /// <p>Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image (AMI).</p>
    /// <p>If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.></p>
    pub no_device: bool,
    /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
    /// <p>You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>
    pub virtual_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails");
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.field("no_device", &self.no_device);
        formatter.field("virtual_name", &self.virtual_name);
        formatter.finish()
    }
}
/// See [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)
pub mod aws_auto_scaling_launch_configuration_block_device_mappings_details {
    /// A builder for [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<
            crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails,
        >,
        pub(crate) no_device: std::option::Option<bool>,
        pub(crate) virtual_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.</p>
        pub fn ebs(
            mut self,
            input: crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails,
        ) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.</p>
        pub fn set_ebs(
            mut self,
            input: std::option::Option<
                crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails,
            >,
        ) -> Self {
            self.ebs = input;
            self
        }
        /// <p>Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image (AMI).</p>
        /// <p>If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.></p>
        pub fn no_device(mut self, input: bool) -> Self {
            self.no_device = Some(input);
            self
        }
        /// <p>Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image (AMI).</p>
        /// <p>If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.></p>
        pub fn set_no_device(mut self, input: std::option::Option<bool>) -> Self {
            self.no_device = input;
            self
        }
        /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
        /// <p>You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
        /// <p>You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
            crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
                device_name: self.device_name,
                ebs: self.ebs,
                no_device: self.no_device.unwrap_or_default(),
                virtual_name: self.virtual_name,
            }
        }
    }
}
impl AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
    /// Creates a new builder-style object to manufacture [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)
    pub fn builder(
    ) -> crate::model::aws_auto_scaling_launch_configuration_block_device_mappings_details::Builder
    {
        crate::model::aws_auto_scaling_launch_configuration_block_device_mappings_details::Builder::default()
    }
}

/// <p>Parameters that are used to automatically set up EBS volumes when an instance is launched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
    /// <p>Whether to delete the volume when the instance is terminated.</p>
    pub delete_on_termination: bool,
    /// <p>Whether to encrypt the volume.</p>
    pub encrypted: bool,
    /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p>
    /// <p>Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.</p>
    pub iops: i32,
    /// <p>The snapshot ID of the volume to use.</p>
    /// <p>You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p>
    /// <ul>
    /// <li>
    /// <p>gp2 and gp3: 1-16,384</p>
    /// </li>
    /// <li>
    /// <p>io1: 4-16,384</p>
    /// </li>
    /// <li>
    /// <p>st1 and sc1: 125-16,384</p>
    /// </li>
    /// <li>
    /// <p>standard: 1-1,024</p>
    /// </li>
    /// </ul>
    /// <p>You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of the snapshot.</p>
    pub volume_size: i32,
    /// <p>The volume type.</p>
    pub volume_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails");
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("iops", &self.iops);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.finish()
    }
}
/// See [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)
pub mod aws_auto_scaling_launch_configuration_block_device_mappings_ebs_details {
    /// A builder for [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether to delete the volume when the instance is terminated.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Whether to delete the volume when the instance is terminated.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>Whether to encrypt the volume.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Whether to encrypt the volume.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p>
        /// <p>Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p>
        /// <p>Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The snapshot ID of the volume to use.</p>
        /// <p>You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID of the volume to use.</p>
        /// <p>You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p>
        /// <ul>
        /// <li>
        /// <p>gp2 and gp3: 1-16,384</p>
        /// </li>
        /// <li>
        /// <p>io1: 4-16,384</p>
        /// </li>
        /// <li>
        /// <p>st1 and sc1: 125-16,384</p>
        /// </li>
        /// <li>
        /// <p>standard: 1-1,024</p>
        /// </li>
        /// </ul>
        /// <p>You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of the snapshot.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p>
        /// <ul>
        /// <li>
        /// <p>gp2 and gp3: 1-16,384</p>
        /// </li>
        /// <li>
        /// <p>io1: 4-16,384</p>
        /// </li>
        /// <li>
        /// <p>st1 and sc1: 125-16,384</p>
        /// </li>
        /// <li>
        /// <p>standard: 1-1,024</p>
        /// </li>
        /// </ul>
        /// <p>You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of the snapshot.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The volume type.</p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type.</p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
            crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
                delete_on_termination: self.delete_on_termination.unwrap_or_default(),
                encrypted: self.encrypted.unwrap_or_default(),
                iops: self.iops.unwrap_or_default(),
                snapshot_id: self.snapshot_id,
                volume_size: self.volume_size.unwrap_or_default(),
                volume_type: self.volume_type,
            }
        }
    }
}
impl AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
    /// Creates a new builder-style object to manufacture [`AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails`](crate::model::AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails)
    pub fn builder() -> crate::model::aws_auto_scaling_launch_configuration_block_device_mappings_ebs_details::Builder{
        crate::model::aws_auto_scaling_launch_configuration_block_device_mappings_ebs_details::Builder::default()
    }
}

/// <p>Provides details about a service within an ECS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceDetails {
    /// <p>The capacity provider strategy that the service uses.</p>
    pub capacity_provider_strategy: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsServiceCapacityProviderStrategyDetails>,
    >,
    /// <p>The ARN of the cluster that hosts the service.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.</p>
    pub deployment_configuration:
        std::option::Option<crate::model::AwsEcsServiceDeploymentConfigurationDetails>,
    /// <p>Contains the deployment controller type that the service uses.</p>
    pub deployment_controller:
        std::option::Option<crate::model::AwsEcsServiceDeploymentControllerDetails>,
    /// <p>The number of instantiations of the task definition to run on the service.</p>
    pub desired_count: i32,
    /// <p>Whether to enable Amazon ECS managed tags for the tasks in the service.</p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Whether the execute command functionality is enabled for the service.</p>
    pub enable_execute_command: bool,
    /// <p>After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.</p>
    pub health_check_grace_period_seconds: i32,
    /// <p>The launch type that the service uses.</p>
    /// <p>Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
    /// </p>
    pub launch_type: std::option::Option<std::string::String>,
    /// <p>Information about the load balancers that the service uses.</p>
    pub load_balancers:
        std::option::Option<std::vec::Vec<crate::model::AwsEcsServiceLoadBalancersDetails>>,
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>
    pub network_configuration:
        std::option::Option<crate::model::AwsEcsServiceNetworkConfigurationDetails>,
    /// <p>The placement constraints for the tasks in the service.</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::AwsEcsServicePlacementConstraintsDetails>>,
    /// <p>Information about how tasks for the service are placed.</p>
    pub placement_strategies:
        std::option::Option<std::vec::Vec<crate::model::AwsEcsServicePlacementStrategiesDetails>>,
    /// <p>The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the <code>LATEST</code> platform version is used by default.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.</p>
    /// <p>Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
    /// </p>
    pub propagate_tags: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The scheduling strategy to use for the service.</p>
    /// <p>The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.</p>
    /// <p>The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.</p>
    /// <p>Valid values: <code>REPLICA</code> | <code>DAEMON</code>
    /// </p>
    pub scheduling_strategy: std::option::Option<std::string::String>,
    /// <p>The ARN of the service.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>The name of the service.</p>
    /// <p>The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>Information about the service discovery registries to assign to the service.</p>
    pub service_registries:
        std::option::Option<std::vec::Vec<crate::model::AwsEcsServiceServiceRegistriesDetails>>,
    /// <p>The task definition to use for tasks in the service.</p>
    pub task_definition: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServiceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceDetails");
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("cluster", &self.cluster);
        formatter.field("deployment_configuration", &self.deployment_configuration);
        formatter.field("deployment_controller", &self.deployment_controller);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.field(
            "health_check_grace_period_seconds",
            &self.health_check_grace_period_seconds,
        );
        formatter.field("launch_type", &self.launch_type);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("name", &self.name);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategies", &self.placement_strategies);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("role", &self.role);
        formatter.field("scheduling_strategy", &self.scheduling_strategy);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_registries", &self.service_registries);
        formatter.field("task_definition", &self.task_definition);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceDetails`](crate::model::AwsEcsServiceDetails)
pub mod aws_ecs_service_details {
    /// A builder for [`AwsEcsServiceDetails`](crate::model::AwsEcsServiceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider_strategy: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsServiceCapacityProviderStrategyDetails>,
        >,
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) deployment_configuration:
            std::option::Option<crate::model::AwsEcsServiceDeploymentConfigurationDetails>,
        pub(crate) deployment_controller:
            std::option::Option<crate::model::AwsEcsServiceDeploymentControllerDetails>,
        pub(crate) desired_count: std::option::Option<i32>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
        pub(crate) health_check_grace_period_seconds: std::option::Option<i32>,
        pub(crate) launch_type: std::option::Option<std::string::String>,
        pub(crate) load_balancers:
            std::option::Option<std::vec::Vec<crate::model::AwsEcsServiceLoadBalancersDetails>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_configuration:
            std::option::Option<crate::model::AwsEcsServiceNetworkConfigurationDetails>,
        pub(crate) placement_constraints: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsServicePlacementConstraintsDetails>,
        >,
        pub(crate) placement_strategies: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsServicePlacementStrategiesDetails>,
        >,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) propagate_tags: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) scheduling_strategy: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_registries:
            std::option::Option<std::vec::Vec<crate::model::AwsEcsServiceServiceRegistriesDetails>>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy that the service uses.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::AwsEcsServiceCapacityProviderStrategyDetails>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy that the service uses.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsServiceCapacityProviderStrategyDetails>,
            >,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The ARN of the cluster that hosts the service.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The ARN of the cluster that hosts the service.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::AwsEcsServiceDeploymentConfigurationDetails,
        ) -> Self {
            self.deployment_configuration = Some(input);
            self
        }
        /// <p>Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsEcsServiceDeploymentConfigurationDetails>,
        ) -> Self {
            self.deployment_configuration = input;
            self
        }
        /// <p>Contains the deployment controller type that the service uses.</p>
        pub fn deployment_controller(
            mut self,
            input: crate::model::AwsEcsServiceDeploymentControllerDetails,
        ) -> Self {
            self.deployment_controller = Some(input);
            self
        }
        /// <p>Contains the deployment controller type that the service uses.</p>
        pub fn set_deployment_controller(
            mut self,
            input: std::option::Option<crate::model::AwsEcsServiceDeploymentControllerDetails>,
        ) -> Self {
            self.deployment_controller = input;
            self
        }
        /// <p>The number of instantiations of the task definition to run on the service.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p>The number of instantiations of the task definition to run on the service.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p>Whether to enable Amazon ECS managed tags for the tasks in the service.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Whether to enable Amazon ECS managed tags for the tasks in the service.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Whether the execute command functionality is enabled for the service.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether the execute command functionality is enabled for the service.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// <p>After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.health_check_grace_period_seconds = Some(input);
            self
        }
        /// <p>After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_grace_period_seconds = input;
            self
        }
        /// <p>The launch type that the service uses.</p>
        /// <p>Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
        /// </p>
        pub fn launch_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_type = Some(input.into());
            self
        }
        /// <p>The launch type that the service uses.</p>
        /// <p>Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
        /// </p>
        pub fn set_launch_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_type = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>Information about the load balancers that the service uses.</p>
        pub fn load_balancers(
            mut self,
            input: impl Into<crate::model::AwsEcsServiceLoadBalancersDetails>,
        ) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>Information about the load balancers that the service uses.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsServiceLoadBalancersDetails>,
            >,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>
        pub fn network_configuration(
            mut self,
            input: crate::model::AwsEcsServiceNetworkConfigurationDetails,
        ) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsEcsServiceNetworkConfigurationDetails>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>The placement constraints for the tasks in the service.</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::AwsEcsServicePlacementConstraintsDetails>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>The placement constraints for the tasks in the service.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsServicePlacementConstraintsDetails>,
            >,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategies`.
        ///
        /// To override the contents of this collection use [`set_placement_strategies`](Self::set_placement_strategies).
        ///
        /// <p>Information about how tasks for the service are placed.</p>
        pub fn placement_strategies(
            mut self,
            input: impl Into<crate::model::AwsEcsServicePlacementStrategiesDetails>,
        ) -> Self {
            let mut v = self.placement_strategies.unwrap_or_default();
            v.push(input.into());
            self.placement_strategies = Some(v);
            self
        }
        /// <p>Information about how tasks for the service are placed.</p>
        pub fn set_placement_strategies(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsServicePlacementStrategiesDetails>,
            >,
        ) -> Self {
            self.placement_strategies = input;
            self
        }
        /// <p>The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the <code>LATEST</code> platform version is used by default.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the <code>LATEST</code> platform version is used by default.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.</p>
        /// <p>Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
        /// </p>
        pub fn propagate_tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.propagate_tags = Some(input.into());
            self
        }
        /// <p>Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.</p>
        /// <p>Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
        /// </p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The scheduling strategy to use for the service.</p>
        /// <p>The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.</p>
        /// <p>The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.</p>
        /// <p>Valid values: <code>REPLICA</code> | <code>DAEMON</code>
        /// </p>
        pub fn scheduling_strategy(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduling_strategy = Some(input.into());
            self
        }
        /// <p>The scheduling strategy to use for the service.</p>
        /// <p>The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.</p>
        /// <p>The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.</p>
        /// <p>Valid values: <code>REPLICA</code> | <code>DAEMON</code>
        /// </p>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduling_strategy = input;
            self
        }
        /// <p>The ARN of the service.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the service.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>The name of the service.</p>
        /// <p>The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        /// <p>The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Appends an item to `service_registries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>Information about the service discovery registries to assign to the service.</p>
        pub fn service_registries(
            mut self,
            input: impl Into<crate::model::AwsEcsServiceServiceRegistriesDetails>,
        ) -> Self {
            let mut v = self.service_registries.unwrap_or_default();
            v.push(input.into());
            self.service_registries = Some(v);
            self
        }
        /// <p>Information about the service discovery registries to assign to the service.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsServiceServiceRegistriesDetails>,
            >,
        ) -> Self {
            self.service_registries = input;
            self
        }
        /// <p>The task definition to use for tasks in the service.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The task definition to use for tasks in the service.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceDetails`](crate::model::AwsEcsServiceDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceDetails {
            crate::model::AwsEcsServiceDetails {
                capacity_provider_strategy: self.capacity_provider_strategy,
                cluster: self.cluster,
                deployment_configuration: self.deployment_configuration,
                deployment_controller: self.deployment_controller,
                desired_count: self.desired_count.unwrap_or_default(),
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
                health_check_grace_period_seconds: self
                    .health_check_grace_period_seconds
                    .unwrap_or_default(),
                launch_type: self.launch_type,
                load_balancers: self.load_balancers,
                name: self.name,
                network_configuration: self.network_configuration,
                placement_constraints: self.placement_constraints,
                placement_strategies: self.placement_strategies,
                platform_version: self.platform_version,
                propagate_tags: self.propagate_tags,
                role: self.role,
                scheduling_strategy: self.scheduling_strategy,
                service_arn: self.service_arn,
                service_name: self.service_name,
                service_registries: self.service_registries,
                task_definition: self.task_definition,
            }
        }
    }
}
impl AwsEcsServiceDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceDetails`](crate::model::AwsEcsServiceDetails)
    pub fn builder() -> crate::model::aws_ecs_service_details::Builder {
        crate::model::aws_ecs_service_details::Builder::default()
    }
}

/// <p>Information about a service discovery registry to assign to the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceServiceRegistriesDetails {
    /// <p>The container name value to use for the service discovery service.</p>
    /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
    /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The port value to use for the service discovery service.</p>
    /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
    /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
    pub container_port: i32,
    /// <p>The port value to use for a service discovery service that specifies an SRV record. This field can be used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.</p>
    pub port: i32,
    /// <p>The ARN of the service registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServiceServiceRegistriesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceServiceRegistriesDetails");
        formatter.field("container_name", &self.container_name);
        formatter.field("container_port", &self.container_port);
        formatter.field("port", &self.port);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceServiceRegistriesDetails`](crate::model::AwsEcsServiceServiceRegistriesDetails)
pub mod aws_ecs_service_service_registries_details {
    /// A builder for [`AwsEcsServiceServiceRegistriesDetails`](crate::model::AwsEcsServiceServiceRegistriesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The container name value to use for the service discovery service.</p>
        /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
        /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The container name value to use for the service discovery service.</p>
        /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
        /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The port value to use for the service discovery service.</p>
        /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
        /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port value to use for the service discovery service.</p>
        /// <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p>
        /// <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>The port value to use for a service discovery service that specifies an SRV record. This field can be used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port value to use for a service discovery service that specifies an SRV record. This field can be used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The ARN of the service registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the service registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceServiceRegistriesDetails`](crate::model::AwsEcsServiceServiceRegistriesDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceServiceRegistriesDetails {
            crate::model::AwsEcsServiceServiceRegistriesDetails {
                container_name: self.container_name,
                container_port: self.container_port.unwrap_or_default(),
                port: self.port.unwrap_or_default(),
                registry_arn: self.registry_arn,
            }
        }
    }
}
impl AwsEcsServiceServiceRegistriesDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceServiceRegistriesDetails`](crate::model::AwsEcsServiceServiceRegistriesDetails)
    pub fn builder() -> crate::model::aws_ecs_service_service_registries_details::Builder {
        crate::model::aws_ecs_service_service_registries_details::Builder::default()
    }
}

/// <p>A placement strategy that determines how to place the tasks for the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServicePlacementStrategiesDetails {
    /// <p>The field to apply the placement strategy against.</p>
    /// <p>For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as <code>attribute:ecs.availability-zone</code>.</p>
    /// <p>For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.</p>
    /// <p>For the <code>random</code> placement strategy, this attribute is not used.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>The type of placement strategy.</p>
    /// <p>The <code>random</code> placement strategy randomly places tasks on available candidates.</p>
    /// <p>The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the value of <code>Field</code>.</p>
    /// <p>The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that is specified in <code>Field</code>.</p>
    /// <p>Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServicePlacementStrategiesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServicePlacementStrategiesDetails");
        formatter.field("field", &self.field);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsEcsServicePlacementStrategiesDetails`](crate::model::AwsEcsServicePlacementStrategiesDetails)
pub mod aws_ecs_service_placement_strategies_details {
    /// A builder for [`AwsEcsServicePlacementStrategiesDetails`](crate::model::AwsEcsServicePlacementStrategiesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field to apply the placement strategy against.</p>
        /// <p>For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as <code>attribute:ecs.availability-zone</code>.</p>
        /// <p>For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.</p>
        /// <p>For the <code>random</code> placement strategy, this attribute is not used.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to apply the placement strategy against.</p>
        /// <p>For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as <code>attribute:ecs.availability-zone</code>.</p>
        /// <p>For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.</p>
        /// <p>For the <code>random</code> placement strategy, this attribute is not used.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// <p>The type of placement strategy.</p>
        /// <p>The <code>random</code> placement strategy randomly places tasks on available candidates.</p>
        /// <p>The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the value of <code>Field</code>.</p>
        /// <p>The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that is specified in <code>Field</code>.</p>
        /// <p>Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of placement strategy.</p>
        /// <p>The <code>random</code> placement strategy randomly places tasks on available candidates.</p>
        /// <p>The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the value of <code>Field</code>.</p>
        /// <p>The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that is specified in <code>Field</code>.</p>
        /// <p>Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServicePlacementStrategiesDetails`](crate::model::AwsEcsServicePlacementStrategiesDetails)
        pub fn build(self) -> crate::model::AwsEcsServicePlacementStrategiesDetails {
            crate::model::AwsEcsServicePlacementStrategiesDetails {
                field: self.field,
                r#type: self.r#type,
            }
        }
    }
}
impl AwsEcsServicePlacementStrategiesDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServicePlacementStrategiesDetails`](crate::model::AwsEcsServicePlacementStrategiesDetails)
    pub fn builder() -> crate::model::aws_ecs_service_placement_strategies_details::Builder {
        crate::model::aws_ecs_service_placement_strategies_details::Builder::default()
    }
}

/// <p>A placement constraint for the tasks in the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServicePlacementConstraintsDetails {
    /// <p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The type of constraint. Use <code>distinctInstance</code> to run each task in a particular group on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.</p>
    /// <p>Valid values: <code>distinctInstance</code> | <code>memberOf</code>
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServicePlacementConstraintsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServicePlacementConstraintsDetails");
        formatter.field("expression", &self.expression);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsEcsServicePlacementConstraintsDetails`](crate::model::AwsEcsServicePlacementConstraintsDetails)
pub mod aws_ecs_service_placement_constraints_details {
    /// A builder for [`AwsEcsServicePlacementConstraintsDetails`](crate::model::AwsEcsServicePlacementConstraintsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The type of constraint. Use <code>distinctInstance</code> to run each task in a particular group on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.</p>
        /// <p>Valid values: <code>distinctInstance</code> | <code>memberOf</code>
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of constraint. Use <code>distinctInstance</code> to run each task in a particular group on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.</p>
        /// <p>Valid values: <code>distinctInstance</code> | <code>memberOf</code>
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServicePlacementConstraintsDetails`](crate::model::AwsEcsServicePlacementConstraintsDetails)
        pub fn build(self) -> crate::model::AwsEcsServicePlacementConstraintsDetails {
            crate::model::AwsEcsServicePlacementConstraintsDetails {
                expression: self.expression,
                r#type: self.r#type,
            }
        }
    }
}
impl AwsEcsServicePlacementConstraintsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServicePlacementConstraintsDetails`](crate::model::AwsEcsServicePlacementConstraintsDetails)
    pub fn builder() -> crate::model::aws_ecs_service_placement_constraints_details::Builder {
        crate::model::aws_ecs_service_placement_constraints_details::Builder::default()
    }
}

/// <p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceNetworkConfigurationDetails {
    /// <p>The VPC subnet and security group configuration.</p>
    pub aws_vpc_configuration: std::option::Option<
        crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails,
    >,
}
impl std::fmt::Debug for AwsEcsServiceNetworkConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceNetworkConfigurationDetails");
        formatter.field("aws_vpc_configuration", &self.aws_vpc_configuration);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceNetworkConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationDetails)
pub mod aws_ecs_service_network_configuration_details {
    /// A builder for [`AwsEcsServiceNetworkConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_vpc_configuration: std::option::Option<
            crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails,
        >,
    }
    impl Builder {
        /// <p>The VPC subnet and security group configuration.</p>
        pub fn aws_vpc_configuration(
            mut self,
            input: crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails,
        ) -> Self {
            self.aws_vpc_configuration = Some(input);
            self
        }
        /// <p>The VPC subnet and security group configuration.</p>
        pub fn set_aws_vpc_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails,
            >,
        ) -> Self {
            self.aws_vpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceNetworkConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceNetworkConfigurationDetails {
            crate::model::AwsEcsServiceNetworkConfigurationDetails {
                aws_vpc_configuration: self.aws_vpc_configuration,
            }
        }
    }
}
impl AwsEcsServiceNetworkConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceNetworkConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationDetails)
    pub fn builder() -> crate::model::aws_ecs_service_network_configuration_details::Builder {
        crate::model::aws_ecs_service_network_configuration_details::Builder::default()
    }
}

/// <p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
    /// <p>Whether the task's elastic network interface receives a public IP address. The default value is <code>DISABLED</code>.</p>
    /// <p>Valid values: <code>ENABLED</code> | <code>DISABLED</code>
    /// </p>
    pub assign_public_ip: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups associated with the task or service.</p>
    /// <p>You can provide up to five security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the subnets associated with the task or service.</p>
    /// <p>You can provide up to 16 subnets.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails");
        formatter.field("assign_public_ip", &self.assign_public_ip);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)
pub mod aws_ecs_service_network_configuration_aws_vpc_configuration_details {
    /// A builder for [`AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assign_public_ip: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Whether the task's elastic network interface receives a public IP address. The default value is <code>DISABLED</code>.</p>
        /// <p>Valid values: <code>ENABLED</code> | <code>DISABLED</code>
        /// </p>
        pub fn assign_public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.assign_public_ip = Some(input.into());
            self
        }
        /// <p>Whether the task's elastic network interface receives a public IP address. The default value is <code>DISABLED</code>.</p>
        /// <p>Valid values: <code>ENABLED</code> | <code>DISABLED</code>
        /// </p>
        pub fn set_assign_public_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assign_public_ip = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups associated with the task or service.</p>
        /// <p>You can provide up to five security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups associated with the task or service.</p>
        /// <p>You can provide up to five security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets associated with the task or service.</p>
        /// <p>You can provide up to 16 subnets.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets associated with the task or service.</p>
        /// <p>You can provide up to 16 subnets.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
            crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
                assign_public_ip: self.assign_public_ip,
                security_groups: self.security_groups,
                subnets: self.subnets,
            }
        }
    }
}
impl AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails`](crate::model::AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_service_network_configuration_aws_vpc_configuration_details::Builder
    {
        crate::model::aws_ecs_service_network_configuration_aws_vpc_configuration_details::Builder::default()
    }
}

/// <p>Information about a load balancer that the service uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceLoadBalancersDetails {
    /// <p>The name of the container to associate with the load balancer.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The port on the container to associate with the load balancer. This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.</p>
    pub container_port: i32,
    /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
    /// <p>Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.</p>
    /// <p>Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServiceLoadBalancersDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceLoadBalancersDetails");
        formatter.field("container_name", &self.container_name);
        formatter.field("container_port", &self.container_port);
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceLoadBalancersDetails`](crate::model::AwsEcsServiceLoadBalancersDetails)
pub mod aws_ecs_service_load_balancers_details {
    /// A builder for [`AwsEcsServiceLoadBalancersDetails`](crate::model::AwsEcsServiceLoadBalancersDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container to associate with the load balancer.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container to associate with the load balancer.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The port on the container to associate with the load balancer. This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port on the container to associate with the load balancer. This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
        /// <p>Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
        /// <p>Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.</p>
        /// <p>Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.</p>
        /// <p>Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceLoadBalancersDetails`](crate::model::AwsEcsServiceLoadBalancersDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceLoadBalancersDetails {
            crate::model::AwsEcsServiceLoadBalancersDetails {
                container_name: self.container_name,
                container_port: self.container_port.unwrap_or_default(),
                load_balancer_name: self.load_balancer_name,
                target_group_arn: self.target_group_arn,
            }
        }
    }
}
impl AwsEcsServiceLoadBalancersDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceLoadBalancersDetails`](crate::model::AwsEcsServiceLoadBalancersDetails)
    pub fn builder() -> crate::model::aws_ecs_service_load_balancers_details::Builder {
        crate::model::aws_ecs_service_load_balancers_details::Builder::default()
    }
}

/// <p>Information about the deployment controller type that the service uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceDeploymentControllerDetails {
    /// <p>The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container with the latest version.</p>
    /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is powered by CodeDeploy. This deployment model a new deployment of a service can be verified before production traffic is sent to it.</p>
    /// <p>The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</p>
    /// <p>Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsServiceDeploymentControllerDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceDeploymentControllerDetails");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceDeploymentControllerDetails`](crate::model::AwsEcsServiceDeploymentControllerDetails)
pub mod aws_ecs_service_deployment_controller_details {
    /// A builder for [`AwsEcsServiceDeploymentControllerDetails`](crate::model::AwsEcsServiceDeploymentControllerDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container with the latest version.</p>
        /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is powered by CodeDeploy. This deployment model a new deployment of a service can be verified before production traffic is sent to it.</p>
        /// <p>The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</p>
        /// <p>Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container with the latest version.</p>
        /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is powered by CodeDeploy. This deployment model a new deployment of a service can be verified before production traffic is sent to it.</p>
        /// <p>The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</p>
        /// <p>Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceDeploymentControllerDetails`](crate::model::AwsEcsServiceDeploymentControllerDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceDeploymentControllerDetails {
            crate::model::AwsEcsServiceDeploymentControllerDetails {
                r#type: self.r#type,
            }
        }
    }
}
impl AwsEcsServiceDeploymentControllerDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceDeploymentControllerDetails`](crate::model::AwsEcsServiceDeploymentControllerDetails)
    pub fn builder() -> crate::model::aws_ecs_service_deployment_controller_details::Builder {
        crate::model::aws_ecs_service_deployment_controller_details::Builder::default()
    }
}

/// <p>Optional deployment parameters for the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceDeploymentConfigurationDetails {
    /// <p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>
    pub deployment_circuit_breaker: std::option::Option<
        crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails,
    >,
    /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default value is 200%.</p>
    /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
    /// <p>For the Fargate launch type, the maximum percent value is not used.</p>
    pub maximum_percent: i32,
    /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while any container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.</p>
    /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
    /// <p>For the Fargate launch type, the minimum healthy percent value is not used.</p>
    pub minimum_healthy_percent: i32,
}
impl std::fmt::Debug for AwsEcsServiceDeploymentConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceDeploymentConfigurationDetails");
        formatter.field(
            "deployment_circuit_breaker",
            &self.deployment_circuit_breaker,
        );
        formatter.field("maximum_percent", &self.maximum_percent);
        formatter.field("minimum_healthy_percent", &self.minimum_healthy_percent);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceDeploymentConfigurationDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDetails)
pub mod aws_ecs_service_deployment_configuration_details {
    /// A builder for [`AwsEcsServiceDeploymentConfigurationDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_circuit_breaker: std::option::Option<
            crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails,
        >,
        pub(crate) maximum_percent: std::option::Option<i32>,
        pub(crate) minimum_healthy_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>
        pub fn deployment_circuit_breaker(
            mut self,
            input: crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails,
        ) -> Self {
            self.deployment_circuit_breaker = Some(input);
            self
        }
        /// <p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>
        pub fn set_deployment_circuit_breaker(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails,
            >,
        ) -> Self {
            self.deployment_circuit_breaker = input;
            self
        }
        /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default value is 200%.</p>
        /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
        /// <p>For the Fargate launch type, the maximum percent value is not used.</p>
        pub fn maximum_percent(mut self, input: i32) -> Self {
            self.maximum_percent = Some(input);
            self
        }
        /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default value is 200%.</p>
        /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
        /// <p>For the Fargate launch type, the maximum percent value is not used.</p>
        pub fn set_maximum_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_percent = input;
            self
        }
        /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while any container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.</p>
        /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
        /// <p>For the Fargate launch type, the minimum healthy percent value is not used.</p>
        pub fn minimum_healthy_percent(mut self, input: i32) -> Self {
            self.minimum_healthy_percent = Some(input);
            self
        }
        /// <p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while any container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.</p>
        /// <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p>
        /// <p>For the Fargate launch type, the minimum healthy percent value is not used.</p>
        pub fn set_minimum_healthy_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_healthy_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceDeploymentConfigurationDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceDeploymentConfigurationDetails {
            crate::model::AwsEcsServiceDeploymentConfigurationDetails {
                deployment_circuit_breaker: self.deployment_circuit_breaker,
                maximum_percent: self.maximum_percent.unwrap_or_default(),
                minimum_healthy_percent: self.minimum_healthy_percent.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcsServiceDeploymentConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceDeploymentConfigurationDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDetails)
    pub fn builder() -> crate::model::aws_ecs_service_deployment_configuration_details::Builder {
        crate::model::aws_ecs_service_deployment_configuration_details::Builder::default()
    }
}

/// <p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
    /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
    pub enable: bool,
    /// <p>Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.</p>
    pub rollback: bool,
}
impl std::fmt::Debug for AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails");
        formatter.field("enable", &self.enable);
        formatter.field("rollback", &self.rollback);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)
pub mod aws_ecs_service_deployment_configuration_deployment_circuit_breaker_details {
    /// A builder for [`AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) rollback: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.</p>
        pub fn rollback(mut self, input: bool) -> Self {
            self.rollback = Some(input);
            self
        }
        /// <p>Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.</p>
        pub fn set_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.rollback = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
        {
            crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
                enable: self.enable.unwrap_or_default(),
                rollback: self.rollback.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails`](crate::model::AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)
    pub fn builder() -> crate::model::aws_ecs_service_deployment_configuration_deployment_circuit_breaker_details::Builder{
        crate::model::aws_ecs_service_deployment_configuration_deployment_circuit_breaker_details::Builder::default()
    }
}

/// <p>Strategy item for the capacity provider strategy that the service uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsServiceCapacityProviderStrategyDetails {
    /// <p>The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for <code>Base</code>.</p>
    /// <p>The value must be between 0 and 100000.</p>
    pub base: i32,
    /// <p>The short name of the capacity provider.</p>
    pub capacity_provider: std::option::Option<std::string::String>,
    /// <p>The relative percentage of the total number of tasks that should use the capacity provider.</p>
    /// <p>If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.</p>
    /// <p>The value can be between 0 and 1000.</p>
    pub weight: i32,
}
impl std::fmt::Debug for AwsEcsServiceCapacityProviderStrategyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsServiceCapacityProviderStrategyDetails");
        formatter.field("base", &self.base);
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.field("weight", &self.weight);
        formatter.finish()
    }
}
/// See [`AwsEcsServiceCapacityProviderStrategyDetails`](crate::model::AwsEcsServiceCapacityProviderStrategyDetails)
pub mod aws_ecs_service_capacity_provider_strategy_details {
    /// A builder for [`AwsEcsServiceCapacityProviderStrategyDetails`](crate::model::AwsEcsServiceCapacityProviderStrategyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base: std::option::Option<i32>,
        pub(crate) capacity_provider: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for <code>Base</code>.</p>
        /// <p>The value must be between 0 and 100000.</p>
        pub fn base(mut self, input: i32) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for <code>Base</code>.</p>
        /// <p>The value must be between 0 and 100000.</p>
        pub fn set_base(mut self, input: std::option::Option<i32>) -> Self {
            self.base = input;
            self
        }
        /// <p>The short name of the capacity provider.</p>
        pub fn capacity_provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider = Some(input.into());
            self
        }
        /// <p>The short name of the capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// <p>The relative percentage of the total number of tasks that should use the capacity provider.</p>
        /// <p>If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.</p>
        /// <p>The value can be between 0 and 1000.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The relative percentage of the total number of tasks that should use the capacity provider.</p>
        /// <p>If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.</p>
        /// <p>The value can be between 0 and 1000.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsServiceCapacityProviderStrategyDetails`](crate::model::AwsEcsServiceCapacityProviderStrategyDetails)
        pub fn build(self) -> crate::model::AwsEcsServiceCapacityProviderStrategyDetails {
            crate::model::AwsEcsServiceCapacityProviderStrategyDetails {
                base: self.base.unwrap_or_default(),
                capacity_provider: self.capacity_provider,
                weight: self.weight.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcsServiceCapacityProviderStrategyDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsServiceCapacityProviderStrategyDetails`](crate::model::AwsEcsServiceCapacityProviderStrategyDetails)
    pub fn builder() -> crate::model::aws_ecs_service_capacity_provider_strategy_details::Builder {
        crate::model::aws_ecs_service_capacity_provider_strategy_details::Builder::default()
    }
}

/// <p>Details about an Amazon RDS event notification subscription. The subscription allows Amazon RDS to post events to an SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsRdsEventSubscriptionDetails {
    /// <p>The identifier of the account that is associated with the event notification subscription.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the event notification subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>Whether the event notification subscription is enabled.</p>
    pub enabled: bool,
    /// <p>The list of event categories for the event notification subscription.</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the event notification subscription.</p>
    pub event_subscription_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the SNS topic to post the event notifications to.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>A list of source identifiers for the event notification subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The source type for the event notification subscription.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The status of the event notification subscription.</p>
    /// <p>Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code>
    /// </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The datetime when the event notification subscription was created.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub subscription_creation_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsRdsEventSubscriptionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsRdsEventSubscriptionDetails");
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("enabled", &self.enabled);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("event_subscription_arn", &self.event_subscription_arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("source_type", &self.source_type);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.finish()
    }
}
/// See [`AwsRdsEventSubscriptionDetails`](crate::model::AwsRdsEventSubscriptionDetails)
pub mod aws_rds_event_subscription_details {
    /// A builder for [`AwsRdsEventSubscriptionDetails`](crate::model::AwsRdsEventSubscriptionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_subscription_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the account that is associated with the event notification subscription.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The identifier of the account that is associated with the event notification subscription.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The identifier of the event notification subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The identifier of the event notification subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>Whether the event notification subscription is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the event notification subscription is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>The list of event categories for the event notification subscription.</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>The list of event categories for the event notification subscription.</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>The ARN of the event notification subscription.</p>
        pub fn event_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event notification subscription.</p>
        pub fn set_event_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_subscription_arn = input;
            self
        }
        /// <p>The ARN of the SNS topic to post the event notifications to.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to post the event notifications to.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of source identifiers for the event notification subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of source identifiers for the event notification subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// <p>The source type for the event notification subscription.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type for the event notification subscription.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The status of the event notification subscription.</p>
        /// <p>Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code>
        /// </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the event notification subscription.</p>
        /// <p>Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code>
        /// </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The datetime when the event notification subscription was created.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn subscription_creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_creation_time = Some(input.into());
            self
        }
        /// <p>The datetime when the event notification subscription was created.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsRdsEventSubscriptionDetails`](crate::model::AwsRdsEventSubscriptionDetails)
        pub fn build(self) -> crate::model::AwsRdsEventSubscriptionDetails {
            crate::model::AwsRdsEventSubscriptionDetails {
                cust_subscription_id: self.cust_subscription_id,
                customer_aws_id: self.customer_aws_id,
                enabled: self.enabled.unwrap_or_default(),
                event_categories_list: self.event_categories_list,
                event_subscription_arn: self.event_subscription_arn,
                sns_topic_arn: self.sns_topic_arn,
                source_ids_list: self.source_ids_list,
                source_type: self.source_type,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
            }
        }
    }
}
impl AwsRdsEventSubscriptionDetails {
    /// Creates a new builder-style object to manufacture [`AwsRdsEventSubscriptionDetails`](crate::model::AwsRdsEventSubscriptionDetails)
    pub fn builder() -> crate::model::aws_rds_event_subscription_details::Builder {
        crate::model::aws_rds_event_subscription_details::Builder::default()
    }
}

/// <p>Container details related to a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerDetails {
    /// <p>The name of the container related to a finding.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the image related to a finding.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The name of the image related to a finding.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>Indicates when the container started.</p>
    /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
    /// Date/Time Format</a>. The value cannot contain spaces. For example,
    /// <code>2020-03-22T13:22:13.933Z</code>.</p>
    pub launched_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerDetails");
        formatter.field("name", &self.name);
        formatter.field("image_id", &self.image_id);
        formatter.field("image_name", &self.image_name);
        formatter.field("launched_at", &self.launched_at);
        formatter.finish()
    }
}
/// See [`ContainerDetails`](crate::model::ContainerDetails)
pub mod container_details {
    /// A builder for [`ContainerDetails`](crate::model::ContainerDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) launched_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container related to a finding.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container related to a finding.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the image related to a finding.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The identifier of the image related to a finding.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The name of the image related to a finding.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image related to a finding.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>Indicates when the container started.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn launched_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.launched_at = Some(input.into());
            self
        }
        /// <p>Indicates when the container started.</p>
        /// <p>Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet
        /// Date/Time Format</a>. The value cannot contain spaces. For example,
        /// <code>2020-03-22T13:22:13.933Z</code>.</p>
        pub fn set_launched_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launched_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerDetails`](crate::model::ContainerDetails)
        pub fn build(self) -> crate::model::ContainerDetails {
            crate::model::ContainerDetails {
                name: self.name,
                image_id: self.image_id,
                image_name: self.image_name,
                launched_at: self.launched_at,
            }
        }
    }
}
impl ContainerDetails {
    /// Creates a new builder-style object to manufacture [`ContainerDetails`](crate::model::ContainerDetails)
    pub fn builder() -> crate::model::container_details::Builder {
        crate::model::container_details::Builder::default()
    }
}

/// <p>details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionDetails {
    /// <p>The container definitions that describe the containers that make up the task.</p>
    pub container_definitions: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails>,
    >,
    /// <p>The number of CPU units used by the task.</p>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of a family that this task definition is registered to.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
    pub inference_accelerators: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails>,
    >,
    /// <p>The IPC resource namespace to use for the containers in the task.</p>
    pub ipc_mode: std::option::Option<std::string::String>,
    /// <p>The amount (in MiB) of memory used by the task.</p>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The Docker networking mode to use for the containers in the task.</p>
    pub network_mode: std::option::Option<std::string::String>,
    /// <p>The process namespace to use for the containers in the task.</p>
    pub pid_mode: std::option::Option<std::string::String>,
    /// <p>The placement constraint objects to use for tasks.</p>
    pub placement_constraints: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails>,
    >,
    /// <p>The configuration details for the App Mesh proxy.</p>
    pub proxy_configuration:
        std::option::Option<crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails>,
    /// <p>The task launch types that the task definition was validated against.</p>
    pub requires_compatibilities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.</p>
    pub task_role_arn: std::option::Option<std::string::String>,
    /// <p>The data volume definitions for the task.</p>
    pub volumes:
        std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionVolumesDetails>>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionDetails");
        formatter.field("container_definitions", &self.container_definitions);
        formatter.field("cpu", &self.cpu);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("family", &self.family);
        formatter.field("inference_accelerators", &self.inference_accelerators);
        formatter.field("ipc_mode", &self.ipc_mode);
        formatter.field("memory", &self.memory);
        formatter.field("network_mode", &self.network_mode);
        formatter.field("pid_mode", &self.pid_mode);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("proxy_configuration", &self.proxy_configuration);
        formatter.field("requires_compatibilities", &self.requires_compatibilities);
        formatter.field("task_role_arn", &self.task_role_arn);
        formatter.field("volumes", &self.volumes);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionDetails`](crate::model::AwsEcsTaskDefinitionDetails)
pub mod aws_ecs_task_definition_details {
    /// A builder for [`AwsEcsTaskDefinitionDetails`](crate::model::AwsEcsTaskDefinitionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_definitions: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails>,
        >,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) inference_accelerators: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails>,
        >,
        pub(crate) ipc_mode: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) network_mode: std::option::Option<std::string::String>,
        pub(crate) pid_mode: std::option::Option<std::string::String>,
        pub(crate) placement_constraints: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails>,
        >,
        pub(crate) proxy_configuration:
            std::option::Option<crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails>,
        pub(crate) requires_compatibilities:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) task_role_arn: std::option::Option<std::string::String>,
        pub(crate) volumes:
            std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionVolumesDetails>>,
    }
    impl Builder {
        /// Appends an item to `container_definitions`.
        ///
        /// To override the contents of this collection use [`set_container_definitions`](Self::set_container_definitions).
        ///
        /// <p>The container definitions that describe the containers that make up the task.</p>
        pub fn container_definitions(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails>,
        ) -> Self {
            let mut v = self.container_definitions.unwrap_or_default();
            v.push(input.into());
            self.container_definitions = Some(v);
            self
        }
        /// <p>The container definitions that describe the containers that make up the task.</p>
        pub fn set_container_definitions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails>,
            >,
        ) -> Self {
            self.container_definitions = input;
            self
        }
        /// <p>The number of CPU units used by the task.</p>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of CPU units used by the task.</p>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The name of a family that this task definition is registered to.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The name of a family that this task definition is registered to.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// Appends an item to `inference_accelerators`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerators`](Self::set_inference_accelerators).
        ///
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn inference_accelerators(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails>,
        ) -> Self {
            let mut v = self.inference_accelerators.unwrap_or_default();
            v.push(input.into());
            self.inference_accelerators = Some(v);
            self
        }
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn set_inference_accelerators(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails>,
            >,
        ) -> Self {
            self.inference_accelerators = input;
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task.</p>
        pub fn ipc_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipc_mode = Some(input.into());
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task.</p>
        pub fn set_ipc_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipc_mode = input;
            self
        }
        /// <p>The amount (in MiB) of memory used by the task.</p>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The amount (in MiB) of memory used by the task.</p>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task.</p>
        pub fn network_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_mode = Some(input.into());
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task.</p>
        pub fn set_network_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_mode = input;
            self
        }
        /// <p>The process namespace to use for the containers in the task.</p>
        pub fn pid_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.pid_mode = Some(input.into());
            self
        }
        /// <p>The process namespace to use for the containers in the task.</p>
        pub fn set_pid_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pid_mode = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>The placement constraint objects to use for tasks.</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>The placement constraint objects to use for tasks.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails>,
            >,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        pub fn proxy_configuration(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails,
        ) -> Self {
            self.proxy_configuration = Some(input);
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        pub fn set_proxy_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails>,
        ) -> Self {
            self.proxy_configuration = input;
            self
        }
        /// Appends an item to `requires_compatibilities`.
        ///
        /// To override the contents of this collection use [`set_requires_compatibilities`](Self::set_requires_compatibilities).
        ///
        /// <p>The task launch types that the task definition was validated against.</p>
        pub fn requires_compatibilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.requires_compatibilities.unwrap_or_default();
            v.push(input.into());
            self.requires_compatibilities = Some(v);
            self
        }
        /// <p>The task launch types that the task definition was validated against.</p>
        pub fn set_requires_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.requires_compatibilities = input;
            self
        }
        /// <p>The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.</p>
        pub fn task_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_role_arn = Some(input.into());
            self
        }
        /// <p>The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.</p>
        pub fn set_task_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_role_arn = input;
            self
        }
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>The data volume definitions for the task.</p>
        pub fn volumes(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionVolumesDetails>,
        ) -> Self {
            let mut v = self.volumes.unwrap_or_default();
            v.push(input.into());
            self.volumes = Some(v);
            self
        }
        /// <p>The data volume definitions for the task.</p>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionVolumesDetails>,
            >,
        ) -> Self {
            self.volumes = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionDetails`](crate::model::AwsEcsTaskDefinitionDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionDetails {
            crate::model::AwsEcsTaskDefinitionDetails {
                container_definitions: self.container_definitions,
                cpu: self.cpu,
                execution_role_arn: self.execution_role_arn,
                family: self.family,
                inference_accelerators: self.inference_accelerators,
                ipc_mode: self.ipc_mode,
                memory: self.memory,
                network_mode: self.network_mode,
                pid_mode: self.pid_mode,
                placement_constraints: self.placement_constraints,
                proxy_configuration: self.proxy_configuration,
                requires_compatibilities: self.requires_compatibilities,
                task_role_arn: self.task_role_arn,
                volumes: self.volumes,
            }
        }
    }
}
impl AwsEcsTaskDefinitionDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionDetails`](crate::model::AwsEcsTaskDefinitionDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_details::Builder {
        crate::model::aws_ecs_task_definition_details::Builder::default()
    }
}

/// <p>A data volume to mount from another container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionVolumesDetails {
    /// <p>Information about a Docker volume.</p>
    pub docker_volume_configuration: std::option::Option<
        crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails,
    >,
    /// <p>Information about the Amazon Elastic File System file system that is used for task storage.</p>
    pub efs_volume_configuration:
        std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails>,
    /// <p>Information about a bind mount host volume.</p>
    pub host: std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesHostDetails>,
    /// <p>The name of the data volume.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionVolumesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionVolumesDetails");
        formatter.field(
            "docker_volume_configuration",
            &self.docker_volume_configuration,
        );
        formatter.field("efs_volume_configuration", &self.efs_volume_configuration);
        formatter.field("host", &self.host);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionVolumesDetails`](crate::model::AwsEcsTaskDefinitionVolumesDetails)
pub mod aws_ecs_task_definition_volumes_details {
    /// A builder for [`AwsEcsTaskDefinitionVolumesDetails`](crate::model::AwsEcsTaskDefinitionVolumesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) docker_volume_configuration: std::option::Option<
            crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails,
        >,
        pub(crate) efs_volume_configuration: std::option::Option<
            crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails,
        >,
        pub(crate) host: std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesHostDetails>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about a Docker volume.</p>
        pub fn docker_volume_configuration(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails,
        ) -> Self {
            self.docker_volume_configuration = Some(input);
            self
        }
        /// <p>Information about a Docker volume.</p>
        pub fn set_docker_volume_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails,
            >,
        ) -> Self {
            self.docker_volume_configuration = input;
            self
        }
        /// <p>Information about the Amazon Elastic File System file system that is used for task storage.</p>
        pub fn efs_volume_configuration(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails,
        ) -> Self {
            self.efs_volume_configuration = Some(input);
            self
        }
        /// <p>Information about the Amazon Elastic File System file system that is used for task storage.</p>
        pub fn set_efs_volume_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails,
            >,
        ) -> Self {
            self.efs_volume_configuration = input;
            self
        }
        /// <p>Information about a bind mount host volume.</p>
        pub fn host(mut self, input: crate::model::AwsEcsTaskDefinitionVolumesHostDetails) -> Self {
            self.host = Some(input);
            self
        }
        /// <p>Information about a bind mount host volume.</p>
        pub fn set_host(
            mut self,
            input: std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesHostDetails>,
        ) -> Self {
            self.host = input;
            self
        }
        /// <p>The name of the data volume.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data volume.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionVolumesDetails`](crate::model::AwsEcsTaskDefinitionVolumesDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionVolumesDetails {
            crate::model::AwsEcsTaskDefinitionVolumesDetails {
                docker_volume_configuration: self.docker_volume_configuration,
                efs_volume_configuration: self.efs_volume_configuration,
                host: self.host,
                name: self.name,
            }
        }
    }
}
impl AwsEcsTaskDefinitionVolumesDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionVolumesDetails`](crate::model::AwsEcsTaskDefinitionVolumesDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_volumes_details::Builder {
        crate::model::aws_ecs_task_definition_volumes_details::Builder::default()
    }
}

/// <p>Information about a bind mount host volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionVolumesHostDetails {
    /// <p>The path on the host container instance that is presented to the container.</p>
    pub source_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionVolumesHostDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionVolumesHostDetails");
        formatter.field("source_path", &self.source_path);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionVolumesHostDetails`](crate::model::AwsEcsTaskDefinitionVolumesHostDetails)
pub mod aws_ecs_task_definition_volumes_host_details {
    /// A builder for [`AwsEcsTaskDefinitionVolumesHostDetails`](crate::model::AwsEcsTaskDefinitionVolumesHostDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path on the host container instance that is presented to the container.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The path on the host container instance that is presented to the container.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionVolumesHostDetails`](crate::model::AwsEcsTaskDefinitionVolumesHostDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionVolumesHostDetails {
            crate::model::AwsEcsTaskDefinitionVolumesHostDetails {
                source_path: self.source_path,
            }
        }
    }
}
impl AwsEcsTaskDefinitionVolumesHostDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionVolumesHostDetails`](crate::model::AwsEcsTaskDefinitionVolumesHostDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_volumes_host_details::Builder {
        crate::model::aws_ecs_task_definition_volumes_host_details::Builder::default()
    }
}

/// <p>Information about the Amazon Elastic File System file system that is used for task storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
    /// <p>The authorization configuration details for the Amazon EFS file system.</p>
    pub authorization_config: std::option::Option<
        crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails,
    >,
    /// <p>The Amazon EFS file system identifier to use.</p>
    pub filesystem_id: std::option::Option<std::string::String>,
    /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the host.</p>
    pub root_directory: std::option::Option<std::string::String>,
    /// <p>Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. </p>
    pub transit_encryption: std::option::Option<std::string::String>,
    /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.</p>
    pub transit_encryption_port: i32,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails");
        formatter.field("authorization_config", &self.authorization_config);
        formatter.field("filesystem_id", &self.filesystem_id);
        formatter.field("root_directory", &self.root_directory);
        formatter.field("transit_encryption", &self.transit_encryption);
        formatter.field("transit_encryption_port", &self.transit_encryption_port);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)
pub mod aws_ecs_task_definition_volumes_efs_volume_configuration_details {
    /// A builder for [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_config: std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails>,
        pub(crate) filesystem_id: std::option::Option<std::string::String>,
        pub(crate) root_directory: std::option::Option<std::string::String>,
        pub(crate) transit_encryption: std::option::Option<std::string::String>,
        pub(crate) transit_encryption_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The authorization configuration details for the Amazon EFS file system.</p>
        pub fn authorization_config(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails,
        ) -> Self {
            self.authorization_config = Some(input);
            self
        }
        /// <p>The authorization configuration details for the Amazon EFS file system.</p>
        pub fn set_authorization_config(
            mut self,
            input: std::option::Option<crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails>,
        ) -> Self {
            self.authorization_config = input;
            self
        }
        /// <p>The Amazon EFS file system identifier to use.</p>
        pub fn filesystem_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.filesystem_id = Some(input.into());
            self
        }
        /// <p>The Amazon EFS file system identifier to use.</p>
        pub fn set_filesystem_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filesystem_id = input;
            self
        }
        /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the host.</p>
        pub fn root_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_directory = Some(input.into());
            self
        }
        /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the host.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// <p>Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. </p>
        pub fn transit_encryption(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_encryption = Some(input.into());
            self
        }
        /// <p>Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. </p>
        pub fn set_transit_encryption(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_encryption = input;
            self
        }
        /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.</p>
        pub fn transit_encryption_port(mut self, input: i32) -> Self {
            self.transit_encryption_port = Some(input);
            self
        }
        /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.</p>
        pub fn set_transit_encryption_port(mut self, input: std::option::Option<i32>) -> Self {
            self.transit_encryption_port = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
            crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
                authorization_config: self.authorization_config,
                filesystem_id: self.filesystem_id,
                root_directory: self.root_directory,
                transit_encryption: self.transit_encryption,
                transit_encryption_port: self.transit_encryption_port.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_volumes_efs_volume_configuration_details::Builder
    {
        crate::model::aws_ecs_task_definition_volumes_efs_volume_configuration_details::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
    /// <p>The Amazon EFS access point identifier to use.</p>
    pub access_point_id: std::option::Option<std::string::String>,
    /// <p>Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.</p>
    pub iam: std::option::Option<std::string::String>,
}
impl std::fmt::Debug
    for AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
{
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct(
            "AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails",
        );
        formatter.field("access_point_id", &self.access_point_id);
        formatter.field("iam", &self.iam);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)
pub mod aws_ecs_task_definition_volumes_efs_volume_configuration_authorization_config_details {
    /// A builder for [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_id: std::option::Option<std::string::String>,
        pub(crate) iam: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EFS access point identifier to use.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>The Amazon EFS access point identifier to use.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// <p>Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.</p>
        pub fn iam(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam = Some(input.into());
            self
        }
        /// <p>Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.</p>
        pub fn set_iam(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
        {
            crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
                access_point_id: self.access_point_id
                ,
                iam: self.iam
                ,
            }
        }
    }
}
impl AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails`](crate::model::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_volumes_efs_volume_configuration_authorization_config_details::Builder{
        crate::model::aws_ecs_task_definition_volumes_efs_volume_configuration_authorization_config_details::Builder::default()
    }
}

/// <p>Information about a Docker volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
    /// <p>Whether to create the Docker volume automatically if it does not already exist.</p>
    pub autoprovision: bool,
    /// <p>The Docker volume driver to use.</p>
    pub driver: std::option::Option<std::string::String>,
    /// <p>A map of Docker driver-specific options that are passed through.</p>
    pub driver_opts:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Custom metadata to add to the Docker volume.</p>
    pub labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are shared persist after the task stops.</p>
    pub scope: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails");
        formatter.field("autoprovision", &self.autoprovision);
        formatter.field("driver", &self.driver);
        formatter.field("driver_opts", &self.driver_opts);
        formatter.field("labels", &self.labels);
        formatter.field("scope", &self.scope);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)
pub mod aws_ecs_task_definition_volumes_docker_volume_configuration_details {
    /// A builder for [`AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) autoprovision: std::option::Option<bool>,
        pub(crate) driver: std::option::Option<std::string::String>,
        pub(crate) driver_opts: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether to create the Docker volume automatically if it does not already exist.</p>
        pub fn autoprovision(mut self, input: bool) -> Self {
            self.autoprovision = Some(input);
            self
        }
        /// <p>Whether to create the Docker volume automatically if it does not already exist.</p>
        pub fn set_autoprovision(mut self, input: std::option::Option<bool>) -> Self {
            self.autoprovision = input;
            self
        }
        /// <p>The Docker volume driver to use.</p>
        pub fn driver(mut self, input: impl Into<std::string::String>) -> Self {
            self.driver = Some(input.into());
            self
        }
        /// <p>The Docker volume driver to use.</p>
        pub fn set_driver(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.driver = input;
            self
        }
        /// Adds a key-value pair to `driver_opts`.
        ///
        /// To override the contents of this collection use [`set_driver_opts`](Self::set_driver_opts).
        ///
        /// <p>A map of Docker driver-specific options that are passed through.</p>
        pub fn driver_opts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.driver_opts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.driver_opts = Some(hash_map);
            self
        }
        /// <p>A map of Docker driver-specific options that are passed through.</p>
        pub fn set_driver_opts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.driver_opts = input;
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Custom metadata to add to the Docker volume.</p>
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.labels = Some(hash_map);
            self
        }
        /// <p>Custom metadata to add to the Docker volume.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are shared persist after the task stops.</p>
        pub fn scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.scope = Some(input.into());
            self
        }
        /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are shared persist after the task stops.</p>
        pub fn set_scope(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scope = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
            crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
                autoprovision: self.autoprovision.unwrap_or_default(),
                driver: self.driver,
                driver_opts: self.driver_opts,
                labels: self.labels,
                scope: self.scope,
            }
        }
    }
}
impl AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails`](crate::model::AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_volumes_docker_volume_configuration_details::Builder
    {
        crate::model::aws_ecs_task_definition_volumes_docker_volume_configuration_details::Builder::default()
    }
}

/// <p>The configuration details for the App Mesh
/// proxy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionProxyConfigurationDetails {
    /// <p>The name of the container that will serve as the App Mesh proxy.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin, specified as key-value pairs.</p>
    pub proxy_configuration_properties: std::option::Option<
        std::vec::Vec<
            crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails,
        >,
    >,
    /// <p>The proxy type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionProxyConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionProxyConfigurationDetails");
        formatter.field("container_name", &self.container_name);
        formatter.field(
            "proxy_configuration_properties",
            &self.proxy_configuration_properties,
        );
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionProxyConfigurationDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails)
pub mod aws_ecs_task_definition_proxy_configuration_details {
    /// A builder for [`AwsEcsTaskDefinitionProxyConfigurationDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) proxy_configuration_properties: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container that will serve as the App Mesh proxy.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container that will serve as the App Mesh proxy.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// Appends an item to `proxy_configuration_properties`.
        ///
        /// To override the contents of this collection use [`set_proxy_configuration_properties`](Self::set_proxy_configuration_properties).
        ///
        /// <p>The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin, specified as key-value pairs.</p>
        pub fn proxy_configuration_properties(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>,
        ) -> Self {
            let mut v = self.proxy_configuration_properties.unwrap_or_default();
            v.push(input.into());
            self.proxy_configuration_properties = Some(v);
            self
        }
        /// <p>The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin, specified as key-value pairs.</p>
        pub fn set_proxy_configuration_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails>>,
        ) -> Self {
            self.proxy_configuration_properties = input;
            self
        }
        /// <p>The proxy type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The proxy type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionProxyConfigurationDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails {
            crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails {
                container_name: self.container_name,
                proxy_configuration_properties: self.proxy_configuration_properties,
                r#type: self.r#type,
            }
        }
    }
}
impl AwsEcsTaskDefinitionProxyConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionProxyConfigurationDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_proxy_configuration_details::Builder {
        crate::model::aws_ecs_task_definition_proxy_configuration_details::Builder::default()
    }
}

/// <p>A network configuration parameter to provide to the Container Network Interface (CNI) plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
    /// <p>The name of the property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the property.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct(
            "AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails",
        );
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails)
pub mod aws_ecs_task_definition_proxy_configuration_proxy_configuration_properties_details {
    /// A builder for [`AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
        {
            crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
                name: self.name
                ,
                value: self.value
                ,
            }
        }
    }
}
impl AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails`](crate::model::AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_proxy_configuration_proxy_configuration_properties_details::Builder{
        crate::model::aws_ecs_task_definition_proxy_configuration_proxy_configuration_properties_details::Builder::default()
    }
}

/// <p>A placement constraint object to use for tasks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionPlacementConstraintsDetails {
    /// <p>A cluster query language expression to apply to the constraint.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The type of constraint.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionPlacementConstraintsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionPlacementConstraintsDetails");
        formatter.field("expression", &self.expression);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionPlacementConstraintsDetails`](crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails)
pub mod aws_ecs_task_definition_placement_constraints_details {
    /// A builder for [`AwsEcsTaskDefinitionPlacementConstraintsDetails`](crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cluster query language expression to apply to the constraint.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A cluster query language expression to apply to the constraint.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The type of constraint.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of constraint.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionPlacementConstraintsDetails`](crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails {
            crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails {
                expression: self.expression,
                r#type: self.r#type,
            }
        }
    }
}
impl AwsEcsTaskDefinitionPlacementConstraintsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionPlacementConstraintsDetails`](crate::model::AwsEcsTaskDefinitionPlacementConstraintsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_placement_constraints_details::Builder
    {
        crate::model::aws_ecs_task_definition_placement_constraints_details::Builder::default()
    }
}

/// <p>An Elastic Inference accelerator to use
/// for the containers in the task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
    /// <p>The Elastic Inference accelerator device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerator type to use.</p>
    pub device_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionInferenceAcceleratorsDetails");
        formatter.field("device_name", &self.device_name);
        formatter.field("device_type", &self.device_type);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionInferenceAcceleratorsDetails`](crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails)
pub mod aws_ecs_task_definition_inference_accelerators_details {
    /// A builder for [`AwsEcsTaskDefinitionInferenceAcceleratorsDetails`](crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic Inference accelerator device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionInferenceAcceleratorsDetails`](crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
            crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
                device_name: self.device_name,
                device_type: self.device_type,
            }
        }
    }
}
impl AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionInferenceAcceleratorsDetails`](crate::model::AwsEcsTaskDefinitionInferenceAcceleratorsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_inference_accelerators_details::Builder
    {
        crate::model::aws_ecs_task_definition_inference_accelerators_details::Builder::default()
    }
}

/// <p>A container definition that describes a container in the task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsDetails {
    /// <p>The command that is passed to the container.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of CPU units reserved for the container.</p>
    pub cpu: i32,
    /// <p>The dependencies that are defined for container startup and shutdown.</p>
    pub depends_on: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>,
    >,
    /// <p>Whether to disable networking within the container.</p>
    pub disable_networking: bool,
    /// <p>A list of DNS search domains that are presented to the container.</p>
    pub dns_search_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of DNS servers that are presented to the container.</p>
    pub dns_servers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A key-value map of labels to add to the container.</p>
    pub docker_labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.</p>
    pub docker_security_options: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The entry point that is passed to the container.</p>
    pub entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The environment variables to pass to a container.</p>
    pub environment: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>,
    >,
    /// <p>A list of files containing the environment variables to pass to a container.</p>
    pub environment_files: std::option::Option<
        std::vec::Vec<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails,
        >,
    >,
    /// <p>Whether the container is essential. All tasks must have at least one essential container.</p>
    pub essential: bool,
    /// <p>A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.</p>
    pub extra_hosts: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>,
    >,
    /// <p>The FireLens configuration for the container. Specifies and configures a log router for container logs.</p>
    pub firelens_configuration: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails,
    >,
    /// <p>The container health check command and associated configuration parameters for the container.</p>
    pub health_check: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails,
    >,
    /// <p>The hostname to use for the container.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The image used to start the container.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>If set to true, then containerized applications can be deployed that require <code>stdin</code> or a <code>tty</code> to be allocated.</p>
    pub interactive: bool,
    /// <p>A list of links for the container in the form <code>
    /// <i>container_name</i>:<i>alias</i>
    /// </code>. Allows containers to communicate with each other without the need for port mappings.</p>
    pub links: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>
    pub linux_parameters: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails,
    >,
    /// <p>The log configuration specification for the container.</p>
    pub log_configuration: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails,
    >,
    /// <p>The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.</p>
    pub memory: i32,
    /// <p>The soft limit (in MiB) of memory to reserve for the container.</p>
    pub memory_reservation: i32,
    /// <p>The mount points for the data volumes in the container.</p>
    pub mount_points: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>,
    >,
    /// <p>The name of the container.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of port mappings for the container.</p>
    pub port_mappings: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>,
    >,
    /// <p>Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.</p>
    pub privileged: bool,
    /// <p>Whether to allocate a TTY to the container.</p>
    pub pseudo_terminal: bool,
    /// <p>Whether the container is given read-only access to its root file system.</p>
    pub readonly_root_filesystem: bool,
    /// <p>The private repository authentication credentials to use.</p>
    pub repository_credentials: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails,
    >,
    /// <p>The type and amount of a resource to assign to a container. The only supported resource is a GPU.</p>
    pub resource_requirements: std::option::Option<
        std::vec::Vec<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails,
        >,
    >,
    /// <p>The secrets to pass to the container.</p>
    pub secrets: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>,
    >,
    /// <p>The number of seconds to wait before giving up on resolving dependencies for a container. </p>
    pub start_timeout: i32,
    /// <p>The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.</p>
    pub stop_timeout: i32,
    /// <p>A list of namespaced kernel parameters to set in the container.</p>
    pub system_controls: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>,
    >,
    /// <p>A list of ulimits to set in the container. </p>
    pub ulimits: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>,
    >,
    /// <p>The user to use inside the container.</p>
    /// <p>The value can use one of the following formats.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>
    /// <i>user</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>
    /// <i>user</i>
    /// </code>:<code>
    /// <i>group</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>
    /// <i>uid</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>
    /// <i>uid</i>
    /// </code>:<code>
    /// <i>gid</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>
    /// <i>user</i>
    /// </code>:<code>
    /// <i>gid</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>
    /// <i>uid</i>
    /// </code>:<code>
    /// <i>group</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    pub user: std::option::Option<std::string::String>,
    /// <p>Data volumes to mount from another container.</p>
    pub volumes_from: std::option::Option<
        std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>,
    >,
    /// <p>The working directory in which to run commands inside the container.</p>
    pub working_directory: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsDetails");
        formatter.field("command", &self.command);
        formatter.field("cpu", &self.cpu);
        formatter.field("depends_on", &self.depends_on);
        formatter.field("disable_networking", &self.disable_networking);
        formatter.field("dns_search_domains", &self.dns_search_domains);
        formatter.field("dns_servers", &self.dns_servers);
        formatter.field("docker_labels", &self.docker_labels);
        formatter.field("docker_security_options", &self.docker_security_options);
        formatter.field("entry_point", &self.entry_point);
        formatter.field("environment", &self.environment);
        formatter.field("environment_files", &self.environment_files);
        formatter.field("essential", &self.essential);
        formatter.field("extra_hosts", &self.extra_hosts);
        formatter.field("firelens_configuration", &self.firelens_configuration);
        formatter.field("health_check", &self.health_check);
        formatter.field("hostname", &self.hostname);
        formatter.field("image", &self.image);
        formatter.field("interactive", &self.interactive);
        formatter.field("links", &self.links);
        formatter.field("linux_parameters", &self.linux_parameters);
        formatter.field("log_configuration", &self.log_configuration);
        formatter.field("memory", &self.memory);
        formatter.field("memory_reservation", &self.memory_reservation);
        formatter.field("mount_points", &self.mount_points);
        formatter.field("name", &self.name);
        formatter.field("port_mappings", &self.port_mappings);
        formatter.field("privileged", &self.privileged);
        formatter.field("pseudo_terminal", &self.pseudo_terminal);
        formatter.field("readonly_root_filesystem", &self.readonly_root_filesystem);
        formatter.field("repository_credentials", &self.repository_credentials);
        formatter.field("resource_requirements", &self.resource_requirements);
        formatter.field("secrets", &self.secrets);
        formatter.field("start_timeout", &self.start_timeout);
        formatter.field("stop_timeout", &self.stop_timeout);
        formatter.field("system_controls", &self.system_controls);
        formatter.field("ulimits", &self.ulimits);
        formatter.field("user", &self.user);
        formatter.field("volumes_from", &self.volumes_from);
        formatter.field("working_directory", &self.working_directory);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails)
pub mod aws_ecs_task_definition_container_definitions_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cpu: std::option::Option<i32>,
        pub(crate) depends_on: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>,
        >,
        pub(crate) disable_networking: std::option::Option<bool>,
        pub(crate) dns_search_domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dns_servers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) docker_labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) docker_security_options: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>,
        >,
        pub(crate) environment_files: std::option::Option<
            std::vec::Vec<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails,
            >,
        >,
        pub(crate) essential: std::option::Option<bool>,
        pub(crate) extra_hosts: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>,
        >,
        pub(crate) firelens_configuration: std::option::Option<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails,
        >,
        pub(crate) health_check: std::option::Option<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails,
        >,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) interactive: std::option::Option<bool>,
        pub(crate) links: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) linux_parameters: std::option::Option<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails,
        >,
        pub(crate) log_configuration: std::option::Option<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails,
        >,
        pub(crate) memory: std::option::Option<i32>,
        pub(crate) memory_reservation: std::option::Option<i32>,
        pub(crate) mount_points: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>,
        >,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) port_mappings: std::option::Option<
            std::vec::Vec<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails,
            >,
        >,
        pub(crate) privileged: std::option::Option<bool>,
        pub(crate) pseudo_terminal: std::option::Option<bool>,
        pub(crate) readonly_root_filesystem: std::option::Option<bool>,
        pub(crate) repository_credentials: std::option::Option<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails,
        >,
        pub(crate) resource_requirements: std::option::Option<
            std::vec::Vec<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails,
            >,
        >,
        pub(crate) secrets: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>,
        >,
        pub(crate) start_timeout: std::option::Option<i32>,
        pub(crate) stop_timeout: std::option::Option<i32>,
        pub(crate) system_controls: std::option::Option<
            std::vec::Vec<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails,
            >,
        >,
        pub(crate) ulimits: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>,
        >,
        pub(crate) user: std::option::Option<std::string::String>,
        pub(crate) volumes_from: std::option::Option<
            std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>,
        >,
        pub(crate) working_directory: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>The command that is passed to the container.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>The command that is passed to the container.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// <p>The number of CPU units reserved for the container.</p>
        pub fn cpu(mut self, input: i32) -> Self {
            self.cpu = Some(input);
            self
        }
        /// <p>The number of CPU units reserved for the container.</p>
        pub fn set_cpu(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu = input;
            self
        }
        /// Appends an item to `depends_on`.
        ///
        /// To override the contents of this collection use [`set_depends_on`](Self::set_depends_on).
        ///
        /// <p>The dependencies that are defined for container startup and shutdown.</p>
        pub fn depends_on(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>,
        ) -> Self {
            let mut v = self.depends_on.unwrap_or_default();
            v.push(input.into());
            self.depends_on = Some(v);
            self
        }
        /// <p>The dependencies that are defined for container startup and shutdown.</p>
        pub fn set_depends_on(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails,
                >,
            >,
        ) -> Self {
            self.depends_on = input;
            self
        }
        /// <p>Whether to disable networking within the container.</p>
        pub fn disable_networking(mut self, input: bool) -> Self {
            self.disable_networking = Some(input);
            self
        }
        /// <p>Whether to disable networking within the container.</p>
        pub fn set_disable_networking(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_networking = input;
            self
        }
        /// Appends an item to `dns_search_domains`.
        ///
        /// To override the contents of this collection use [`set_dns_search_domains`](Self::set_dns_search_domains).
        ///
        /// <p>A list of DNS search domains that are presented to the container.</p>
        pub fn dns_search_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_search_domains.unwrap_or_default();
            v.push(input.into());
            self.dns_search_domains = Some(v);
            self
        }
        /// <p>A list of DNS search domains that are presented to the container.</p>
        pub fn set_dns_search_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_search_domains = input;
            self
        }
        /// Appends an item to `dns_servers`.
        ///
        /// To override the contents of this collection use [`set_dns_servers`](Self::set_dns_servers).
        ///
        /// <p>A list of DNS servers that are presented to the container.</p>
        pub fn dns_servers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_servers.unwrap_or_default();
            v.push(input.into());
            self.dns_servers = Some(v);
            self
        }
        /// <p>A list of DNS servers that are presented to the container.</p>
        pub fn set_dns_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_servers = input;
            self
        }
        /// Adds a key-value pair to `docker_labels`.
        ///
        /// To override the contents of this collection use [`set_docker_labels`](Self::set_docker_labels).
        ///
        /// <p>A key-value map of labels to add to the container.</p>
        pub fn docker_labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.docker_labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.docker_labels = Some(hash_map);
            self
        }
        /// <p>A key-value map of labels to add to the container.</p>
        pub fn set_docker_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.docker_labels = input;
            self
        }
        /// Appends an item to `docker_security_options`.
        ///
        /// To override the contents of this collection use [`set_docker_security_options`](Self::set_docker_security_options).
        ///
        /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.</p>
        pub fn docker_security_options(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.docker_security_options.unwrap_or_default();
            v.push(input.into());
            self.docker_security_options = Some(v);
            self
        }
        /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.</p>
        pub fn set_docker_security_options(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.docker_security_options = input;
            self
        }
        /// Appends an item to `entry_point`.
        ///
        /// To override the contents of this collection use [`set_entry_point`](Self::set_entry_point).
        ///
        /// <p>The entry point that is passed to the container.</p>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entry_point.unwrap_or_default();
            v.push(input.into());
            self.entry_point = Some(v);
            self
        }
        /// <p>The entry point that is passed to the container.</p>
        pub fn set_entry_point(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entry_point = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to pass to a container.</p>
        pub fn environment(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>,
        ) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input.into());
            self.environment = Some(v);
            self
        }
        /// <p>The environment variables to pass to a container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails,
                >,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Appends an item to `environment_files`.
        ///
        /// To override the contents of this collection use [`set_environment_files`](Self::set_environment_files).
        ///
        /// <p>A list of files containing the environment variables to pass to a container.</p>
        pub fn environment_files(
            mut self,
            input: impl Into<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails,
            >,
        ) -> Self {
            let mut v = self.environment_files.unwrap_or_default();
            v.push(input.into());
            self.environment_files = Some(v);
            self
        }
        /// <p>A list of files containing the environment variables to pass to a container.</p>
        pub fn set_environment_files(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails,
                >,
            >,
        ) -> Self {
            self.environment_files = input;
            self
        }
        /// <p>Whether the container is essential. All tasks must have at least one essential container.</p>
        pub fn essential(mut self, input: bool) -> Self {
            self.essential = Some(input);
            self
        }
        /// <p>Whether the container is essential. All tasks must have at least one essential container.</p>
        pub fn set_essential(mut self, input: std::option::Option<bool>) -> Self {
            self.essential = input;
            self
        }
        /// Appends an item to `extra_hosts`.
        ///
        /// To override the contents of this collection use [`set_extra_hosts`](Self::set_extra_hosts).
        ///
        /// <p>A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.</p>
        pub fn extra_hosts(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>,
        ) -> Self {
            let mut v = self.extra_hosts.unwrap_or_default();
            v.push(input.into());
            self.extra_hosts = Some(v);
            self
        }
        /// <p>A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.</p>
        pub fn set_extra_hosts(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails,
                >,
            >,
        ) -> Self {
            self.extra_hosts = input;
            self
        }
        /// <p>The FireLens configuration for the container. Specifies and configures a log router for container logs.</p>
        pub fn firelens_configuration(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails,
        ) -> Self {
            self.firelens_configuration = Some(input);
            self
        }
        /// <p>The FireLens configuration for the container. Specifies and configures a log router for container logs.</p>
        pub fn set_firelens_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails,
            >,
        ) -> Self {
            self.firelens_configuration = input;
            self
        }
        /// <p>The container health check command and associated configuration parameters for the container.</p>
        pub fn health_check(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails,
        ) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>The container health check command and associated configuration parameters for the container.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails,
            >,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// <p>The hostname to use for the container.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname to use for the container.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The image used to start the container.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The image used to start the container.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>If set to true, then containerized applications can be deployed that require <code>stdin</code> or a <code>tty</code> to be allocated.</p>
        pub fn interactive(mut self, input: bool) -> Self {
            self.interactive = Some(input);
            self
        }
        /// <p>If set to true, then containerized applications can be deployed that require <code>stdin</code> or a <code>tty</code> to be allocated.</p>
        pub fn set_interactive(mut self, input: std::option::Option<bool>) -> Self {
            self.interactive = input;
            self
        }
        /// Appends an item to `links`.
        ///
        /// To override the contents of this collection use [`set_links`](Self::set_links).
        ///
        /// <p>A list of links for the container in the form <code>
        /// <i>container_name</i>:<i>alias</i>
        /// </code>. Allows containers to communicate with each other without the need for port mappings.</p>
        pub fn links(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.links.unwrap_or_default();
            v.push(input.into());
            self.links = Some(v);
            self
        }
        /// <p>A list of links for the container in the form <code>
        /// <i>container_name</i>:<i>alias</i>
        /// </code>. Allows containers to communicate with each other without the need for port mappings.</p>
        pub fn set_links(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.links = input;
            self
        }
        /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>
        pub fn linux_parameters(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails,
        ) -> Self {
            self.linux_parameters = Some(input);
            self
        }
        /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>
        pub fn set_linux_parameters(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails,
            >,
        ) -> Self {
            self.linux_parameters = input;
            self
        }
        /// <p>The log configuration specification for the container.</p>
        pub fn log_configuration(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails,
        ) -> Self {
            self.log_configuration = Some(input);
            self
        }
        /// <p>The log configuration specification for the container.</p>
        pub fn set_log_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails,
            >,
        ) -> Self {
            self.log_configuration = input;
            self
        }
        /// <p>The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.</p>
        pub fn memory(mut self, input: i32) -> Self {
            self.memory = Some(input);
            self
        }
        /// <p>The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.</p>
        pub fn set_memory(mut self, input: std::option::Option<i32>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container.</p>
        pub fn memory_reservation(mut self, input: i32) -> Self {
            self.memory_reservation = Some(input);
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container.</p>
        pub fn set_memory_reservation(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_reservation = input;
            self
        }
        /// Appends an item to `mount_points`.
        ///
        /// To override the contents of this collection use [`set_mount_points`](Self::set_mount_points).
        ///
        /// <p>The mount points for the data volumes in the container.</p>
        pub fn mount_points(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>,
        ) -> Self {
            let mut v = self.mount_points.unwrap_or_default();
            v.push(input.into());
            self.mount_points = Some(v);
            self
        }
        /// <p>The mount points for the data volumes in the container.</p>
        pub fn set_mount_points(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails,
                >,
            >,
        ) -> Self {
            self.mount_points = input;
            self
        }
        /// <p>The name of the container.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `port_mappings`.
        ///
        /// To override the contents of this collection use [`set_port_mappings`](Self::set_port_mappings).
        ///
        /// <p>The list of port mappings for the container.</p>
        pub fn port_mappings(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>,
        ) -> Self {
            let mut v = self.port_mappings.unwrap_or_default();
            v.push(input.into());
            self.port_mappings = Some(v);
            self
        }
        /// <p>The list of port mappings for the container.</p>
        pub fn set_port_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails,
                >,
            >,
        ) -> Self {
            self.port_mappings = input;
            self
        }
        /// <p>Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.</p>
        pub fn privileged(mut self, input: bool) -> Self {
            self.privileged = Some(input);
            self
        }
        /// <p>Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.</p>
        pub fn set_privileged(mut self, input: std::option::Option<bool>) -> Self {
            self.privileged = input;
            self
        }
        /// <p>Whether to allocate a TTY to the container.</p>
        pub fn pseudo_terminal(mut self, input: bool) -> Self {
            self.pseudo_terminal = Some(input);
            self
        }
        /// <p>Whether to allocate a TTY to the container.</p>
        pub fn set_pseudo_terminal(mut self, input: std::option::Option<bool>) -> Self {
            self.pseudo_terminal = input;
            self
        }
        /// <p>Whether the container is given read-only access to its root file system.</p>
        pub fn readonly_root_filesystem(mut self, input: bool) -> Self {
            self.readonly_root_filesystem = Some(input);
            self
        }
        /// <p>Whether the container is given read-only access to its root file system.</p>
        pub fn set_readonly_root_filesystem(mut self, input: std::option::Option<bool>) -> Self {
            self.readonly_root_filesystem = input;
            self
        }
        /// <p>The private repository authentication credentials to use.</p>
        pub fn repository_credentials(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails,
        ) -> Self {
            self.repository_credentials = Some(input);
            self
        }
        /// <p>The private repository authentication credentials to use.</p>
        pub fn set_repository_credentials(
            mut self,
            input: std::option::Option<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails,
            >,
        ) -> Self {
            self.repository_credentials = input;
            self
        }
        /// Appends an item to `resource_requirements`.
        ///
        /// To override the contents of this collection use [`set_resource_requirements`](Self::set_resource_requirements).
        ///
        /// <p>The type and amount of a resource to assign to a container. The only supported resource is a GPU.</p>
        pub fn resource_requirements(
            mut self,
            input: impl Into<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails,
            >,
        ) -> Self {
            let mut v = self.resource_requirements.unwrap_or_default();
            v.push(input.into());
            self.resource_requirements = Some(v);
            self
        }
        /// <p>The type and amount of a resource to assign to a container. The only supported resource is a GPU.</p>
        pub fn set_resource_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>>,
        ) -> Self {
            self.resource_requirements = input;
            self
        }
        /// Appends an item to `secrets`.
        ///
        /// To override the contents of this collection use [`set_secrets`](Self::set_secrets).
        ///
        /// <p>The secrets to pass to the container.</p>
        pub fn secrets(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>,
        ) -> Self {
            let mut v = self.secrets.unwrap_or_default();
            v.push(input.into());
            self.secrets = Some(v);
            self
        }
        /// <p>The secrets to pass to the container.</p>
        pub fn set_secrets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>,
            >,
        ) -> Self {
            self.secrets = input;
            self
        }
        /// <p>The number of seconds to wait before giving up on resolving dependencies for a container. </p>
        pub fn start_timeout(mut self, input: i32) -> Self {
            self.start_timeout = Some(input);
            self
        }
        /// <p>The number of seconds to wait before giving up on resolving dependencies for a container. </p>
        pub fn set_start_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.start_timeout = input;
            self
        }
        /// <p>The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.</p>
        pub fn stop_timeout(mut self, input: i32) -> Self {
            self.stop_timeout = Some(input);
            self
        }
        /// <p>The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.</p>
        pub fn set_stop_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.stop_timeout = input;
            self
        }
        /// Appends an item to `system_controls`.
        ///
        /// To override the contents of this collection use [`set_system_controls`](Self::set_system_controls).
        ///
        /// <p>A list of namespaced kernel parameters to set in the container.</p>
        pub fn system_controls(
            mut self,
            input: impl Into<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails,
            >,
        ) -> Self {
            let mut v = self.system_controls.unwrap_or_default();
            v.push(input.into());
            self.system_controls = Some(v);
            self
        }
        /// <p>A list of namespaced kernel parameters to set in the container.</p>
        pub fn set_system_controls(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails,
                >,
            >,
        ) -> Self {
            self.system_controls = input;
            self
        }
        /// Appends an item to `ulimits`.
        ///
        /// To override the contents of this collection use [`set_ulimits`](Self::set_ulimits).
        ///
        /// <p>A list of ulimits to set in the container. </p>
        pub fn ulimits(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>,
        ) -> Self {
            let mut v = self.ulimits.unwrap_or_default();
            v.push(input.into());
            self.ulimits = Some(v);
            self
        }
        /// <p>A list of ulimits to set in the container. </p>
        pub fn set_ulimits(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>,
            >,
        ) -> Self {
            self.ulimits = input;
            self
        }
        /// <p>The user to use inside the container.</p>
        /// <p>The value can use one of the following formats.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>:<code>
        /// <i>group</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>:<code>
        /// <i>gid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>:<code>
        /// <i>gid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>:<code>
        /// <i>group</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.user = Some(input.into());
            self
        }
        /// <p>The user to use inside the container.</p>
        /// <p>The value can use one of the following formats.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>:<code>
        /// <i>group</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>:<code>
        /// <i>gid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>user</i>
        /// </code>:<code>
        /// <i>gid</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>
        /// <i>uid</i>
        /// </code>:<code>
        /// <i>group</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user = input;
            self
        }
        /// Appends an item to `volumes_from`.
        ///
        /// To override the contents of this collection use [`set_volumes_from`](Self::set_volumes_from).
        ///
        /// <p>Data volumes to mount from another container.</p>
        pub fn volumes_from(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>,
        ) -> Self {
            let mut v = self.volumes_from.unwrap_or_default();
            v.push(input.into());
            self.volumes_from = Some(v);
            self
        }
        /// <p>Data volumes to mount from another container.</p>
        pub fn set_volumes_from(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails,
                >,
            >,
        ) -> Self {
            self.volumes_from = input;
            self
        }
        /// <p>The working directory in which to run commands inside the container.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory in which to run commands inside the container.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails {
                command: self.command,
                cpu: self.cpu.unwrap_or_default(),
                depends_on: self.depends_on,
                disable_networking: self.disable_networking.unwrap_or_default(),
                dns_search_domains: self.dns_search_domains,
                dns_servers: self.dns_servers,
                docker_labels: self.docker_labels,
                docker_security_options: self.docker_security_options,
                entry_point: self.entry_point,
                environment: self.environment,
                environment_files: self.environment_files,
                essential: self.essential.unwrap_or_default(),
                extra_hosts: self.extra_hosts,
                firelens_configuration: self.firelens_configuration,
                health_check: self.health_check,
                hostname: self.hostname,
                image: self.image,
                interactive: self.interactive.unwrap_or_default(),
                links: self.links,
                linux_parameters: self.linux_parameters,
                log_configuration: self.log_configuration,
                memory: self.memory.unwrap_or_default(),
                memory_reservation: self.memory_reservation.unwrap_or_default(),
                mount_points: self.mount_points,
                name: self.name,
                port_mappings: self.port_mappings,
                privileged: self.privileged.unwrap_or_default(),
                pseudo_terminal: self.pseudo_terminal.unwrap_or_default(),
                readonly_root_filesystem: self.readonly_root_filesystem.unwrap_or_default(),
                repository_credentials: self.repository_credentials,
                resource_requirements: self.resource_requirements,
                secrets: self.secrets,
                start_timeout: self.start_timeout.unwrap_or_default(),
                stop_timeout: self.stop_timeout.unwrap_or_default(),
                system_controls: self.system_controls,
                ulimits: self.ulimits,
                user: self.user,
                volumes_from: self.volumes_from,
                working_directory: self.working_directory,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_container_definitions_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_details::Builder::default()
    }
}

/// <p>A data volume to mount from another container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
    /// <p>Whether the container has read-only access to the volume.</p>
    pub read_only: bool,
    /// <p>The name of another container within the same task definition from which to mount volumes.</p>
    pub source_container: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails");
        formatter.field("read_only", &self.read_only);
        formatter.field("source_container", &self.source_container);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails)
pub mod aws_ecs_task_definition_container_definitions_volumes_from_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) source_container: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether the container has read-only access to the volume.</p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>Whether the container has read-only access to the volume.</p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>The name of another container within the same task definition from which to mount volumes.</p>
        pub fn source_container(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_container = Some(input.into());
            self
        }
        /// <p>The name of another container within the same task definition from which to mount volumes.</p>
        pub fn set_source_container(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_container = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
                read_only: self.read_only.unwrap_or_default(),
                source_container: self.source_container,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_volumes_from_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_volumes_from_details::Builder::default()
    }
}

/// <p>A ulimit to set in the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
    /// <p>The hard limit for the ulimit type.</p>
    pub hard_limit: i32,
    /// <p>The type of the ulimit.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The soft limit for the ulimit type.</p>
    pub soft_limit: i32,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails");
        formatter.field("hard_limit", &self.hard_limit);
        formatter.field("name", &self.name);
        formatter.field("soft_limit", &self.soft_limit);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails)
pub mod aws_ecs_task_definition_container_definitions_ulimits_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hard_limit: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) soft_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The hard limit for the ulimit type.</p>
        pub fn hard_limit(mut self, input: i32) -> Self {
            self.hard_limit = Some(input);
            self
        }
        /// <p>The hard limit for the ulimit type.</p>
        pub fn set_hard_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.hard_limit = input;
            self
        }
        /// <p>The type of the ulimit.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The type of the ulimit.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The soft limit for the ulimit type.</p>
        pub fn soft_limit(mut self, input: i32) -> Self {
            self.soft_limit = Some(input);
            self
        }
        /// <p>The soft limit for the ulimit type.</p>
        pub fn set_soft_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.soft_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
                hard_limit: self.hard_limit.unwrap_or_default(),
                name: self.name,
                soft_limit: self.soft_limit.unwrap_or_default(),
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_ulimits_details::Builder {
        crate::model::aws_ecs_task_definition_container_definitions_ulimits_details::Builder::default()
    }
}

/// <p>A namespaced kernel parameter to set in the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
    /// <p>The namespaced kernel parameter for which to set a value.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The value of the parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails");
        formatter.field("namespace", &self.namespace);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails)
pub mod aws_ecs_task_definition_container_definitions_system_controls_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespaced kernel parameter for which to set a value.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespaced kernel parameter for which to set a value.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
                namespace: self.namespace,
                value: self.value,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_system_controls_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_system_controls_details::Builder::default()
    }
}

/// <p>A secret to pass to the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
    /// <p>The name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The secret to expose to the container. The value is either the full ARN of the Secrets Manager
    /// secret or the full ARN of the parameter in the Systems Manager Parameter Store.</p>
    pub value_from: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails");
        formatter.field("name", &self.name);
        formatter.field("value_from", &self.value_from);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails)
pub mod aws_ecs_task_definition_container_definitions_secrets_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value_from: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The secret to expose to the container. The value is either the full ARN of the Secrets Manager
        /// secret or the full ARN of the parameter in the Systems Manager Parameter Store.</p>
        pub fn value_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_from = Some(input.into());
            self
        }
        /// <p>The secret to expose to the container. The value is either the full ARN of the Secrets Manager
        /// secret or the full ARN of the parameter in the Systems Manager Parameter Store.</p>
        pub fn set_value_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_from = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
                name: self.name,
                value_from: self.value_from,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_secrets_details::Builder {
        crate::model::aws_ecs_task_definition_container_definitions_secrets_details::Builder::default()
    }
}

/// <p>A resource to assign to a container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
    /// <p>The type of resource to assign to a container.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value for the specified resource type.</p>
    /// <p>For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent
    /// reserves for the container.</p>
    /// <p>For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code>
    /// attribute of an entry in <code>InferenceAccelerators</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails)
pub mod aws_ecs_task_definition_container_definitions_resource_requirements_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of resource to assign to a container.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of resource to assign to a container.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value for the specified resource type.</p>
        /// <p>For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent
        /// reserves for the container.</p>
        /// <p>For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code>
        /// attribute of an entry in <code>InferenceAccelerators</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the specified resource type.</p>
        /// <p>For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent
        /// reserves for the container.</p>
        /// <p>For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code>
        /// attribute of an entry in <code>InferenceAccelerators</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
        {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_container_definitions_resource_requirements_details::Builder{
        crate::model::aws_ecs_task_definition_container_definitions_resource_requirements_details::Builder::default()
    }
}

/// <p>The private repository authentication credentials to use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
    /// <p>The ARN of the secret that contains the private repository credentials.</p>
    pub credentials_parameter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails");
        formatter.field("credentials_parameter", &self.credentials_parameter);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)
pub mod aws_ecs_task_definition_container_definitions_repository_credentials_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials_parameter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret that contains the private repository credentials.</p>
        pub fn credentials_parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_parameter = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that contains the private repository credentials.</p>
        pub fn set_credentials_parameter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_parameter = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
        {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
                credentials_parameter: self.credentials_parameter,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_container_definitions_repository_credentials_details::Builder{
        crate::model::aws_ecs_task_definition_container_definitions_repository_credentials_details::Builder::default()
    }
}

/// <p>A port mapping for the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
    /// <p>The port number on the container that is bound to the user-specified or automatically assigned host port.</p>
    pub container_port: i32,
    /// <p>The port number on the container instance to reserve for the container.</p>
    pub host_port: i32,
    /// <p>The protocol used for the port mapping. The default is <code>tcp</code>.</p>
    pub protocol: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails");
        formatter.field("container_port", &self.container_port);
        formatter.field("host_port", &self.host_port);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails)
pub mod aws_ecs_task_definition_container_definitions_port_mappings_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) host_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The port number on the container that is bound to the user-specified or automatically assigned host port.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port number on the container that is bound to the user-specified or automatically assigned host port.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>The port number on the container instance to reserve for the container.</p>
        pub fn host_port(mut self, input: i32) -> Self {
            self.host_port = Some(input);
            self
        }
        /// <p>The port number on the container instance to reserve for the container.</p>
        pub fn set_host_port(mut self, input: std::option::Option<i32>) -> Self {
            self.host_port = input;
            self
        }
        /// <p>The protocol used for the port mapping. The default is <code>tcp</code>.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol used for the port mapping. The default is <code>tcp</code>.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
                container_port: self.container_port.unwrap_or_default(),
                host_port: self.host_port.unwrap_or_default(),
                protocol: self.protocol,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_port_mappings_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_port_mappings_details::Builder::default()
    }
}

/// <p>A mount point for the data volumes in the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
    /// <p>The path on the container to mount the host volume at.</p>
    pub container_path: std::option::Option<std::string::String>,
    /// <p>Whether the container has read-only access to the volume.</p>
    pub read_only: bool,
    /// <p>The name of the volume to mount. Must match the name of a volume listed in <code>VolumeDetails</code> for the task definition.</p>
    pub source_volume: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails");
        formatter.field("container_path", &self.container_path);
        formatter.field("read_only", &self.read_only);
        formatter.field("source_volume", &self.source_volume);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails)
pub mod aws_ecs_task_definition_container_definitions_mount_points_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_path: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
        pub(crate) source_volume: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path on the container to mount the host volume at.</p>
        pub fn container_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_path = Some(input.into());
            self
        }
        /// <p>The path on the container to mount the host volume at.</p>
        pub fn set_container_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_path = input;
            self
        }
        /// <p>Whether the container has read-only access to the volume.</p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>Whether the container has read-only access to the volume.</p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>The name of the volume to mount. Must match the name of a volume listed in <code>VolumeDetails</code> for the task definition.</p>
        pub fn source_volume(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_volume = Some(input.into());
            self
        }
        /// <p>The name of the volume to mount. Must match the name of a volume listed in <code>VolumeDetails</code> for the task definition.</p>
        pub fn set_source_volume(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_volume = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
                container_path: self.container_path,
                read_only: self.read_only.unwrap_or_default(),
                source_volume: self.source_volume,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_mount_points_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_mount_points_details::Builder::default()
    }
}

/// <p>The log configuration specification for the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails  {
    /// <p>The log driver to use for the container.</p>
    pub log_driver: std::option::Option<std::string::String>,
    /// <p>The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.</p>
    pub options: std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The secrets to pass to the log configuration.</p>
    pub secret_options: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>>,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails");
        formatter.field("log_driver", &self.log_driver);
        formatter.field("options", &self.options);
        formatter.field("secret_options", &self.secret_options);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)
pub mod aws_ecs_task_definition_container_definitions_log_configuration_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_driver: std::option::Option<std::string::String>,
        pub(crate) options: std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
        pub(crate) secret_options: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>>,
    }
    impl Builder {
        /// <p>The log driver to use for the container.</p>
        pub fn log_driver(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_driver = Some(input.into());
            self
        }
        /// <p>The log driver to use for the container.</p>
        pub fn set_log_driver(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_driver = input;
            self
        }
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.</p>
        pub fn options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.options = Some(hash_map);
            self
        }
        /// <p>The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// Appends an item to `secret_options`.
        ///
        /// To override the contents of this collection use [`set_secret_options`](Self::set_secret_options).
        ///
        /// <p>The secrets to pass to the log configuration.</p>
        pub fn secret_options(
            mut self,
            input: impl Into<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>,
        ) -> Self {
            let mut v = self.secret_options.unwrap_or_default();
            v.push(input.into());
            self.secret_options = Some(v);
            self
        }
        /// <p>The secrets to pass to the log configuration.</p>
        pub fn set_secret_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>>,
        ) -> Self {
            self.secret_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
                log_driver: self.log_driver,
                options: self.options,
                secret_options: self.secret_options,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_container_definitions_log_configuration_details::Builder{
        crate::model::aws_ecs_task_definition_container_definitions_log_configuration_details::Builder::default()
    }
}

/// <p>A secret to pass to the log configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
    /// <p>The name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The secret to expose to the container.</p>
    /// <p>The value is either the full ARN of the Secrets Manager secret or the full ARN of the
    /// parameter in the Systems Manager Parameter Store.</p>
    pub value_from: std::option::Option<std::string::String>,
}
impl std::fmt::Debug
    for AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
{
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct(
            "AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails",
        );
        formatter.field("name", &self.name);
        formatter.field("value_from", &self.value_from);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails)
pub mod aws_ecs_task_definition_container_definitions_log_configuration_secret_options_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value_from: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The secret to expose to the container.</p>
        /// <p>The value is either the full ARN of the Secrets Manager secret or the full ARN of the
        /// parameter in the Systems Manager Parameter Store.</p>
        pub fn value_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_from = Some(input.into());
            self
        }
        /// <p>The secret to expose to the container.</p>
        /// <p>The value is either the full ARN of the Secrets Manager secret or the full ARN of the
        /// parameter in the Systems Manager Parameter Store.</p>
        pub fn set_value_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_from = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails)
        pub fn build(self) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails{
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
                name: self.name
                ,
                value_from: self.value_from
                ,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails)
    pub fn builder() -> crate::model::aws_ecs_task_definition_container_definitions_log_configuration_secret_options_details::Builder{
        crate::model::aws_ecs_task_definition_container_definitions_log_configuration_secret_options_details::Builder::default()
    }
}

/// <p>>Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
    /// <p>The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.</p>
    pub capabilities: std::option::Option<
        crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails,
    >,
    /// <p>The host devices to expose to the container.</p>
    pub devices: std::option::Option<
        std::vec::Vec<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails,
        >,
    >,
    /// <p>Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes. </p>
    pub init_process_enabled: bool,
    /// <p>The total amount of swap memory (in MiB) that a container can use.</p>
    pub max_swap: i32,
    /// <p>The value for the size (in MiB) of the <b>/dev/shm</b> volume.</p>
    pub shared_memory_size: i32,
    /// <p>Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The higher the value, the more aggressive the swappiness. The default is 60.</p>
    pub swappiness: i32,
    /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount.</p>
    pub tmpfs: std::option::Option<
        std::vec::Vec<
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails,
        >,
    >,
}
impl std::fmt::Debug for AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails");
        formatter.field("capabilities", &self.capabilities);
        formatter.field("devices", &self.devices);
        formatter.field("init_process_enabled", &self.init_process_enabled);
        formatter.field("max_swap", &self.max_swap);
        formatter.field("shared_memory_size", &self.shared_memory_size);
        formatter.field("swappiness", &self.swappiness);
        formatter.field("tmpfs", &self.tmpfs);
        formatter.finish()
    }
}
/// See [`AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)
pub mod aws_ecs_task_definition_container_definitions_linux_parameters_details {
    /// A builder for [`AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capabilities: std::option::Option<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails>,
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>>,
        pub(crate) init_process_enabled: std::option::Option<bool>,
        pub(crate) max_swap: std::option::Option<i32>,
        pub(crate) shared_memory_size: std::option::Option<i32>,
        pub(crate) swappiness: std::option::Option<i32>,
        pub(crate) tmpfs: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>>,
    }
    impl Builder {
        /// <p>The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.</p>
        pub fn capabilities(
            mut self,
            input: crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails,
        ) -> Self {
            self.capabilities = Some(input);
            self
        }
        /// <p>The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The host devices to expose to the container.</p>
        pub fn devices(
            mut self,
            input: impl Into<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails,
            >,
        ) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>The host devices to expose to the container.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes. </p>
        pub fn init_process_enabled(mut self, input: bool) -> Self {
            self.init_process_enabled = Some(input);
            self
        }
        /// <p>Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes. </p>
        pub fn set_init_process_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.init_process_enabled = input;
            self
        }
        /// <p>The total amount of swap memory (in MiB) that a container can use.</p>
        pub fn max_swap(mut self, input: i32) -> Self {
            self.max_swap = Some(input);
            self
        }
        /// <p>The total amount of swap memory (in MiB) that a container can use.</p>
        pub fn set_max_swap(mut self, input: std::option::Option<i32>) -> Self {
            self.max_swap = input;
            self
        }
        /// <p>The value for the size (in MiB) of the <b>/dev/shm</b> volume.</p>
        pub fn shared_memory_size(mut self, input: i32) -> Self {
            self.shared_memory_size = Some(input);
            self
        }
        /// <p>The value for the size (in MiB) of the <b>/dev/shm</b> volume.</p>
        pub fn set_shared_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.shared_memory_size = input;
            self
        }
        /// <p>Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The higher the value, the more aggressive the swappiness. The default is 60.</p>
        pub fn swappiness(mut self, input: i32) -> Self {
            self.swappiness = Some(input);
            self
        }
        /// <p>Configures the container's memory swappiness behavior. Determines how aggressively pages are swapped. The higher the value, the more aggressive the swappiness. The default is 60.</p>
        pub fn set_swappiness(mut self, input: std::option::Option<i32>) -> Self {
            self.swappiness = input;
            self
        }
        /// Appends an item to `tmpfs`.
        ///
        /// To override the contents of this collection use [`set_tmpfs`](Self::set_tmpfs).
        ///
        /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount.</p>
        pub fn tmpfs(
            mut self,
            input: impl Into<
                crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails,
            >,
        ) -> Self {
            let mut v = self.tmpfs.unwrap_or_default();
            v.push(input.into());
            self.tmpfs = Some(v);
            self
        }
        /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount.</p>
        pub fn set_tmpfs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>>,
        ) -> Self {
            self.tmpfs = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)
        pub fn build(
            self,
        ) -> crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
            crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
                capabilities: self.capabilities,
                devices: self.devices,
                init_process_enabled: self.init_process_enabled.unwrap_or_default(),
                max_swap: self.max_swap.unwrap_or_default(),
                shared_memory_size: self.shared_memory_size.unwrap_or_default(),
                swappiness: self.swappiness.unwrap_or_default(),
                tmpfs: self.tmpfs,
            }
        }
    }
}
impl AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails`](crate::model::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)
    pub fn builder(
    ) -> crate::model::aws_ecs_task_definition_container_definitions_linux_parameters_details::Builder
    {
        crate::model::aws_ecs_task_definition_container_definitions_linux_parameters_details::Builder::default()
    }
}

/// <p>The container path, mount options, and size (in MiB) of a tmpfs mount.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
    /// <p>The absolute file path where the tmp