// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_rotate_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelRotateSecretOutput,
    crate::error::CancelRotateSecretError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelRotateSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelRotateSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::CancelRotateSecretError {
            meta: generic,
            kind: crate::error::CancelRotateSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CancelRotateSecretError {
            meta: generic,
            kind: crate::error::CancelRotateSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CancelRotateSecretError {
            meta: generic,
            kind: crate::error::CancelRotateSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CancelRotateSecretError {
            meta: generic,
            kind: crate::error::CancelRotateSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelRotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelRotateSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_rotate_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelRotateSecretOutput,
    crate::error::CancelRotateSecretError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_rotate_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_rotate_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelRotateSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSecretOutput, crate::error::CreateSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DecryptionFailure" => {
            crate::error::CreateSecretError {
                meta: generic,
                kind: crate::error::CreateSecretErrorKind::DecryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::decryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_decryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EncryptionFailure" => {
            crate::error::CreateSecretError {
                meta: generic,
                kind: crate::error::CreateSecretErrorKind::EncryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::encryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_encryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServiceError" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceExistsException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::ResourceExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateSecretError {
            meta: generic,
            kind: crate::error::CreateSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateSecretOutput, crate::error::CreateSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourcePolicyOutput,
    crate::error::DeleteResourcePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteResourcePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteResourcePolicyError {
            meta: generic,
            kind: crate::error::DeleteResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResourcePolicyOutput,
    crate::error::DeleteResourcePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteResourcePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSecretOutput, crate::error::DeleteSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeleteSecretError {
            meta: generic,
            kind: crate::error::DeleteSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteSecretError {
            meta: generic,
            kind: crate::error::DeleteSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeleteSecretError {
            meta: generic,
            kind: crate::error::DeleteSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteSecretError {
            meta: generic,
            kind: crate::error::DeleteSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSecretOutput, crate::error::DeleteSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSecretOutput, crate::error::DescribeSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DescribeSecretError {
            meta: generic,
            kind: crate::error::DescribeSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeSecretError {
            meta: generic,
            kind: crate::error::DescribeSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeSecretError {
            meta: generic,
            kind: crate::error::DescribeSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSecretOutput, crate::error::DescribeSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_random_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRandomPasswordOutput, crate::error::GetRandomPasswordError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRandomPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRandomPasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::GetRandomPasswordError {
            meta: generic,
            kind: crate::error::GetRandomPasswordErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetRandomPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetRandomPasswordError {
            meta: generic,
            kind: crate::error::GetRandomPasswordErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRandomPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::GetRandomPasswordError {
            meta: generic,
            kind: crate::error::GetRandomPasswordErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRandomPasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRandomPasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_random_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRandomPasswordOutput, crate::error::GetRandomPasswordError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_random_password_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_random_password(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRandomPasswordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetResourcePolicyOutput, crate::error::GetResourcePolicyError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetResourcePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::GetResourcePolicyError {
            meta: generic,
            kind: crate::error::GetResourcePolicyErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetResourcePolicyError {
            meta: generic,
            kind: crate::error::GetResourcePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::GetResourcePolicyError {
            meta: generic,
            kind: crate::error::GetResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetResourcePolicyError {
            meta: generic,
            kind: crate::error::GetResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetResourcePolicyOutput, crate::error::GetResourcePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetResourcePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_secret_value_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSecretValueOutput, crate::error::GetSecretValueError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSecretValueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSecretValueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DecryptionFailure" => {
            crate::error::GetSecretValueError {
                meta: generic,
                kind: crate::error::GetSecretValueErrorKind::DecryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::decryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_decryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::GetSecretValueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServiceError" => crate::error::GetSecretValueError {
            meta: generic,
            kind: crate::error::GetSecretValueErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetSecretValueError {
            meta: generic,
            kind: crate::error::GetSecretValueErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::GetSecretValueError {
            meta: generic,
            kind: crate::error::GetSecretValueErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetSecretValueError {
            meta: generic,
            kind: crate::error::GetSecretValueErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSecretValueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_secret_value_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSecretValueOutput, crate::error::GetSecretValueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_secret_value_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_secret_value(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSecretValueError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_secrets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSecretsOutput, crate::error::ListSecretsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSecretsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSecretsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListSecretsError {
            meta: generic,
            kind: crate::error::ListSecretsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListSecretsError {
            meta: generic,
            kind: crate::error::ListSecretsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListSecretsError {
            meta: generic,
            kind: crate::error::ListSecretsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSecretsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_secrets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSecretsOutput, crate::error::ListSecretsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_secrets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_secrets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSecretsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_secret_version_ids_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSecretVersionIdsOutput,
    crate::error::ListSecretVersionIdsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSecretVersionIdsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListSecretVersionIdsError {
            meta: generic,
            kind: crate::error::ListSecretVersionIdsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListSecretVersionIdsError {
            meta: generic,
            kind: crate::error::ListSecretVersionIdsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListSecretVersionIdsError {
            meta: generic,
            kind: crate::error::ListSecretVersionIdsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListSecretVersionIdsError {
            meta: generic,
            kind: crate::error::ListSecretVersionIdsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSecretVersionIdsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_secret_version_ids_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSecretVersionIdsOutput,
    crate::error::ListSecretVersionIdsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_secret_version_ids_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_secret_version_ids(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSecretVersionIdsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutResourcePolicyOutput, crate::error::PutResourcePolicyError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutResourcePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PublicPolicyException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::PublicPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::public_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_public_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutResourcePolicyError {
            meta: generic,
            kind: crate::error::PutResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutResourcePolicyOutput, crate::error::PutResourcePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutResourcePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_secret_value_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSecretValueOutput, crate::error::PutSecretValueError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutSecretValueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutSecretValueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DecryptionFailure" => {
            crate::error::PutSecretValueError {
                meta: generic,
                kind: crate::error::PutSecretValueErrorKind::DecryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::decryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_decryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EncryptionFailure" => {
            crate::error::PutSecretValueError {
                meta: generic,
                kind: crate::error::PutSecretValueErrorKind::EncryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::encryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_encryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServiceError" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceExistsException" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::ResourceExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutSecretValueError {
            meta: generic,
            kind: crate::error::PutSecretValueErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSecretValueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutSecretValueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_secret_value_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSecretValueOutput, crate::error::PutSecretValueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_secret_value_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_secret_value(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutSecretValueError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_regions_from_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRegionsFromReplicationOutput,
    crate::error::RemoveRegionsFromReplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveRegionsFromReplicationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::RemoveRegionsFromReplicationError {
            meta: generic,
            kind: crate::error::RemoveRegionsFromReplicationErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RemoveRegionsFromReplicationError {
            meta: generic,
            kind: crate::error::RemoveRegionsFromReplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::RemoveRegionsFromReplicationError {
            meta: generic,
            kind: crate::error::RemoveRegionsFromReplicationErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RemoveRegionsFromReplicationError {
            meta: generic,
            kind: crate::error::RemoveRegionsFromReplicationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveRegionsFromReplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_regions_from_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRegionsFromReplicationOutput,
    crate::error::RemoveRegionsFromReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_regions_from_replication_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_remove_regions_from_replication(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RemoveRegionsFromReplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_replicate_secret_to_regions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReplicateSecretToRegionsOutput,
    crate::error::ReplicateSecretToRegionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ReplicateSecretToRegionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ReplicateSecretToRegionsError {
            meta: generic,
            kind: crate::error::ReplicateSecretToRegionsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ReplicateSecretToRegionsError {
            meta: generic,
            kind: crate::error::ReplicateSecretToRegionsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ReplicateSecretToRegionsError {
            meta: generic,
            kind: crate::error::ReplicateSecretToRegionsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ReplicateSecretToRegionsError {
            meta: generic,
            kind: crate::error::ReplicateSecretToRegionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReplicateSecretToRegionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_replicate_secret_to_regions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReplicateSecretToRegionsOutput,
    crate::error::ReplicateSecretToRegionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::replicate_secret_to_regions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_replicate_secret_to_regions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReplicateSecretToRegionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreSecretOutput, crate::error::RestoreSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::RestoreSecretError {
            meta: generic,
            kind: crate::error::RestoreSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RestoreSecretError {
            meta: generic,
            kind: crate::error::RestoreSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::RestoreSecretError {
            meta: generic,
            kind: crate::error::RestoreSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RestoreSecretError {
            meta: generic,
            kind: crate::error::RestoreSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestoreSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreSecretOutput, crate::error::RestoreSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_restore_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rotate_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RotateSecretOutput, crate::error::RotateSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RotateSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RotateSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::RotateSecretError {
            meta: generic,
            kind: crate::error::RotateSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::RotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RotateSecretError {
            meta: generic,
            kind: crate::error::RotateSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::RotateSecretError {
            meta: generic,
            kind: crate::error::RotateSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RotateSecretError {
            meta: generic,
            kind: crate::error::RotateSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RotateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RotateSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rotate_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RotateSecretOutput, crate::error::RotateSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::rotate_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_rotate_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RotateSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_replication_to_replica_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopReplicationToReplicaOutput,
    crate::error::StopReplicationToReplicaError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopReplicationToReplicaError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::StopReplicationToReplicaError {
            meta: generic,
            kind: crate::error::StopReplicationToReplicaErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopReplicationToReplicaError {
            meta: generic,
            kind: crate::error::StopReplicationToReplicaErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::StopReplicationToReplicaError {
            meta: generic,
            kind: crate::error::StopReplicationToReplicaErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StopReplicationToReplicaError {
            meta: generic,
            kind: crate::error::StopReplicationToReplicaErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopReplicationToReplicaError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_replication_to_replica_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopReplicationToReplicaOutput,
    crate::error::StopReplicationToReplicaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_replication_to_replica_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_replication_to_replica(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopReplicationToReplicaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_secret_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSecretOutput, crate::error::UpdateSecretError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSecretError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSecretError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DecryptionFailure" => {
            crate::error::UpdateSecretError {
                meta: generic,
                kind: crate::error::UpdateSecretErrorKind::DecryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::decryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_decryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EncryptionFailure" => {
            crate::error::UpdateSecretError {
                meta: generic,
                kind: crate::error::UpdateSecretErrorKind::EncryptionFailure({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::encryption_failure::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_encryption_failure_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServiceError" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionNotMetException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::PreconditionNotMetException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_not_met_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_not_met_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceExistsException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::ResourceExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateSecretError {
            meta: generic,
            kind: crate::error::UpdateSecretErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSecretError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_secret_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateSecretOutput, crate::error::UpdateSecretError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_secret_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_secret(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSecretError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_secret_version_stage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSecretVersionStageOutput,
    crate::error::UpdateSecretVersionStageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSecretVersionStageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::UpdateSecretVersionStageError {
            meta: generic,
            kind: crate::error::UpdateSecretVersionStageErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateSecretVersionStageError {
            meta: generic,
            kind: crate::error::UpdateSecretVersionStageErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::UpdateSecretVersionStageError {
            meta: generic,
            kind: crate::error::UpdateSecretVersionStageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateSecretVersionStageError {
            meta: generic,
            kind: crate::error::UpdateSecretVersionStageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateSecretVersionStageError {
            meta: generic,
            kind: crate::error::UpdateSecretVersionStageErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSecretVersionStageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_secret_version_stage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSecretVersionStageOutput,
    crate::error::UpdateSecretVersionStageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_secret_version_stage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_secret_version_stage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSecretVersionStageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_resource_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidateResourcePolicyOutput,
    crate::error::ValidateResourcePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ValidateResourcePolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ValidateResourcePolicyError {
            meta: generic,
            kind: crate::error::ValidateResourcePolicyErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ValidateResourcePolicyError {
            meta: generic,
            kind: crate::error::ValidateResourcePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ValidateResourcePolicyError {
            meta: generic,
            kind: crate::error::ValidateResourcePolicyErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::ValidateResourcePolicyError {
            meta: generic,
            kind: crate::error::ValidateResourcePolicyErrorKind::MalformedPolicyDocumentException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::malformed_policy_document_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::ValidateResourcePolicyError {
            meta: generic,
            kind: crate::error::ValidateResourcePolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ValidateResourcePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_resource_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidateResourcePolicyOutput,
    crate::error::ValidateResourcePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::validate_resource_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_validate_resource_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ValidateResourcePolicyError::unhandled)?;
        output.build()
    })
}
