// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Secrets Manager
///
/// Client for invoking operations on AWS Secrets Manager. Each operation on AWS Secrets Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_secretsmanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_secretsmanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_secretsmanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelRotateSecret`](crate::client::fluent_builders::CancelRotateSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::CancelRotateSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::CancelRotateSecret::set_secret_id): <p>The ARN or name of the secret.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    /// - On success, responds with [`CancelRotateSecretOutput`](crate::output::CancelRotateSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CancelRotateSecretOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::CancelRotateSecretOutput::name): <p>The name of the secret.</p>
    ///   - [`version_id(Option<String>)`](crate::output::CancelRotateSecretOutput::version_id): <p>The unique identifier of the version of the secret created during the rotation. This version might not be complete, and should be evaluated for possible deletion. We recommend that you remove the <code>VersionStage</code> value <code>AWSPENDING</code> from this version so that Secrets Manager can delete it. Failing to clean up a cancelled rotation can block you from starting future rotations.</p>
    /// - On failure, responds with [`SdkError<CancelRotateSecretError>`](crate::error::CancelRotateSecretError)
    pub fn cancel_rotate_secret(&self) -> fluent_builders::CancelRotateSecret {
        fluent_builders::CancelRotateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSecret`](crate::client::fluent_builders::CreateSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSecret::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSecret::set_name): <p>The name of the new secret.</p>  <p>The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-</p>  <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateSecret::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateSecret::set_client_request_token): <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version. </p> <note>   <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>  </note>  <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p>  <ul>   <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>   <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li>   <li> <p>If a version with this value already exists and that version's <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <code>PutSecretValue</code> to create a new version.</p> </li>  </ul>  <p>This value becomes the <code>VersionId</code> of the new version.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSecret::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSecret::set_description): <p>The description of the secret.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateSecret::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateSecret::set_kms_key_id): <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret.</p>  <p>To use a KMS key in a different account, use the key ARN or the alias ARN.</p>  <p>If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code>. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.</p>  <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
    ///   - [`secret_binary(Blob)`](crate::client::fluent_builders::CreateSecret::secret_binary) / [`set_secret_binary(Option<Blob>)`](crate::client::fluent_builders::CreateSecret::set_secret_binary): <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.</p>  <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>  <p>This parameter is not available in the Secrets Manager console.</p>
    ///   - [`secret_string(impl Into<String>)`](crate::client::fluent_builders::CreateSecret::secret_string) / [`set_secret_string(Option<String>)`](crate::client::fluent_builders::CreateSecret::set_secret_string): <p>The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.</p>  <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>  <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSecret::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSecret::set_tags): <p>A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:</p>  <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p>  <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p>  <p>If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a>.</p>  <p>For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>. If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.</p>  <p>The following restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per secret: 50</p> </li>   <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>   <li> <p>Tag keys and values are case sensitive.</p> </li>   <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>   <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>  </ul>
    ///   - [`add_replica_regions(Vec<ReplicaRegionType>)`](crate::client::fluent_builders::CreateSecret::add_replica_regions) / [`set_add_replica_regions(Option<Vec<ReplicaRegionType>>)`](crate::client::fluent_builders::CreateSecret::set_add_replica_regions): <p>A list of Regions and KMS keys to replicate secrets.</p>
    ///   - [`force_overwrite_replica_secret(bool)`](crate::client::fluent_builders::CreateSecret::force_overwrite_replica_secret) / [`set_force_overwrite_replica_secret(bool)`](crate::client::fluent_builders::CreateSecret::set_force_overwrite_replica_secret): <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
    /// - On success, responds with [`CreateSecretOutput`](crate::output::CreateSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateSecretOutput::arn): <p>The ARN of the new secret. The ARN includes the name of the secret followed by six random characters. This ensures that if you create a new secret with the same name as a deleted secret, then users with access to the old secret don't get access to the new secret because the ARNs are different.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateSecretOutput::name): <p>The name of the new secret.</p>
    ///   - [`version_id(Option<String>)`](crate::output::CreateSecretOutput::version_id): <p>The unique identifier associated with the version of the new secret.</p>
    ///   - [`replication_status(Option<Vec<ReplicationStatusType>>)`](crate::output::CreateSecretOutput::replication_status): <p>A list of the replicas of this secret and their status:</p>  <ul>   <li> <p> <code>Failed</code>, which indicates that the replica was not created.</p> </li>   <li> <p> <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.</p> </li>   <li> <p> <code>InSync</code>, which indicates that the replica was created.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateSecretError>`](crate::error::CreateSecretError)
    pub fn create_secret(&self) -> fluent_builders::CreateSecret {
        fluent_builders::CreateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_secret_id): <p>The ARN or name of the secret to delete the attached resource-based policy for.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteResourcePolicyOutput::arn): <p>The ARN of the secret that the resource-based policy was deleted for.</p>
    ///   - [`name(Option<String>)`](crate::output::DeleteResourcePolicyOutput::name): <p>The name of the secret that the resource-based policy was deleted for.</p>
    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSecret`](crate::client::fluent_builders::DeleteSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::DeleteSecret::set_secret_id): <p>The ARN or name of the secret to delete.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`recovery_window_in_days(i64)`](crate::client::fluent_builders::DeleteSecret::recovery_window_in_days) / [`set_recovery_window_in_days(Option<i64>)`](crate::client::fluent_builders::DeleteSecret::set_recovery_window_in_days): <p>The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and <code>ForceDeleteWithoutRecovery</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
    ///   - [`force_delete_without_recovery(bool)`](crate::client::fluent_builders::DeleteSecret::force_delete_without_recovery) / [`set_force_delete_without_recovery(Option<bool>)`](crate::client::fluent_builders::DeleteSecret::set_force_delete_without_recovery): <p>Specifies whether to delete the secret without any recovery window. You can't use both this parameter and <code>RecoveryWindowInDays</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>  <p>Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.</p> <important>   <p>Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p>  </important>
    /// - On success, responds with [`DeleteSecretOutput`](crate::output::DeleteSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteSecretOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::DeleteSecretOutput::name): <p>The name of the secret.</p>
    ///   - [`deletion_date(Option<DateTime>)`](crate::output::DeleteSecretOutput::deletion_date): <p>The date and time after which this secret Secrets Manager can permanently delete this secret, and it can no longer be restored. This value is the date and time of the delete request plus the number of days in <code>RecoveryWindowInDays</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteSecretError>`](crate::error::DeleteSecretError)
    pub fn delete_secret(&self) -> fluent_builders::DeleteSecret {
        fluent_builders::DeleteSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecret`](crate::client::fluent_builders::DescribeSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::DescribeSecret::set_secret_id): <p>The ARN or name of the secret. </p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    /// - On success, responds with [`DescribeSecretOutput`](crate::output::DescribeSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeSecretOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeSecretOutput::name): <p>The name of the secret.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeSecretOutput::description): <p>The description of the secret.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::DescribeSecretOutput::kms_key_id): <p>The ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is encrypted with the Amazon Web Services managed key <code>aws/secretsmanager</code>, this field is omitted.</p>
    ///   - [`rotation_enabled(Option<bool>)`](crate::output::DescribeSecretOutput::rotation_enabled): <p>Specifies whether automatic rotation is turned on for this secret.</p>  <p>To turn on rotation, use <code>RotateSecret</code>. To turn off rotation, use <code>CancelRotateSecret</code>.</p>
    ///   - [`rotation_lambda_arn(Option<String>)`](crate::output::DescribeSecretOutput::rotation_lambda_arn): <p>The ARN of the Lambda function that Secrets Manager invokes to rotate the secret. </p>
    ///   - [`rotation_rules(Option<RotationRulesType>)`](crate::output::DescribeSecretOutput::rotation_rules): <p>The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on, but it is now turned off, this field shows the previous rotation schedule and rotation function. If the secret never had rotation turned on, this field is omitted.</p>
    ///   - [`last_rotated_date(Option<DateTime>)`](crate::output::DescribeSecretOutput::last_rotated_date): <p>The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for rotation, Secrets Manager returns null.</p>
    ///   - [`last_changed_date(Option<DateTime>)`](crate::output::DescribeSecretOutput::last_changed_date): <p>The last date and time that this secret was modified in any way.</p>
    ///   - [`last_accessed_date(Option<DateTime>)`](crate::output::DescribeSecretOutput::last_accessed_date): <p>The last date that the secret value was retrieved. This value does not include the time. This field is omitted if the secret has never been retrieved.</p>
    ///   - [`deleted_date(Option<DateTime>)`](crate::output::DescribeSecretOutput::deleted_date): <p>The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is omitted. When you delete a secret, Secrets Manager requires a recovery window of at least 7 days before deleting the secret. Some time after the deleted date, Secrets Manager deletes the secret, including all of its versions.</p>  <p>If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not accessible. To cancel a scheduled deletion and restore access to the secret, use <code>RestoreSecret</code>.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeSecretOutput::tags): <p>The list of tags attached to the secret. To add tags to a secret, use <code>TagResource</code>. To remove tags, use <code>UntagResource</code>.</p>
    ///   - [`version_ids_to_stages(Option<HashMap<String, Vec<String>>>)`](crate::output::DescribeSecretOutput::version_ids_to_stages): <p>A list of the versions of the secret that have staging labels attached. Versions that don't have staging labels are considered deprecated and Secrets Manager can delete them.</p>  <p>Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three staging labels for rotation are: </p>  <ul>   <li> <p> <code>AWSCURRENT</code>, which indicates the current version of the secret.</p> </li>   <li> <p> <code>AWSPENDING</code>, which indicates the version of the secret that contains new secret information that will become the next current version when rotation finishes.</p> <p>During rotation, Secrets Manager creates an <code>AWSPENDING</code> version ID before creating the new secret version. To check if a secret version exists, call <code>GetSecretValue</code>.</p> </li>   <li> <p> <code>AWSPREVIOUS</code>, which indicates the previous current version of the secret. You can use this as the <i>last known good</i> version.</p> </li>  </ul>  <p>For more information about rotation and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation works</a>.</p>
    ///   - [`owning_service(Option<String>)`](crate::output::DescribeSecretOutput::owning_service): <p>The name of the service that created this secret.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::DescribeSecretOutput::created_date): <p>The date the secret was created.</p>
    ///   - [`primary_region(Option<String>)`](crate::output::DescribeSecretOutput::primary_region): <p>The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in <code>ReplicationStatus</code>. </p>
    ///   - [`replication_status(Option<Vec<ReplicationStatusType>>)`](crate::output::DescribeSecretOutput::replication_status): <p>A list of the replicas of this secret and their status: </p>  <ul>   <li> <p> <code>Failed</code>, which indicates that the replica was not created.</p> </li>   <li> <p> <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.</p> </li>   <li> <p> <code>InSync</code>, which indicates that the replica was created.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeSecretError>`](crate::error::DescribeSecretError)
    pub fn describe_secret(&self) -> fluent_builders::DescribeSecret {
        fluent_builders::DescribeSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRandomPassword`](crate::client::fluent_builders::GetRandomPassword) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`password_length(i64)`](crate::client::fluent_builders::GetRandomPassword::password_length) / [`set_password_length(Option<i64>)`](crate::client::fluent_builders::GetRandomPassword::set_password_length): <p>The length of the password. If you don't include this parameter, the default length is 32 characters.</p>
    ///   - [`exclude_characters(impl Into<String>)`](crate::client::fluent_builders::GetRandomPassword::exclude_characters) / [`set_exclude_characters(Option<String>)`](crate::client::fluent_builders::GetRandomPassword::set_exclude_characters): <p>A string of the characters that you don't want in the password.</p>
    ///   - [`exclude_numbers(bool)`](crate::client::fluent_builders::GetRandomPassword::exclude_numbers) / [`set_exclude_numbers(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_exclude_numbers): <p>Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.</p>
    ///   - [`exclude_punctuation(bool)`](crate::client::fluent_builders::GetRandomPassword::exclude_punctuation) / [`set_exclude_punctuation(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_exclude_punctuation): <p>Specifies whether to exclude the following punctuation characters from the password: <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this switch, the password can contain punctuation.</p>
    ///   - [`exclude_uppercase(bool)`](crate::client::fluent_builders::GetRandomPassword::exclude_uppercase) / [`set_exclude_uppercase(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_exclude_uppercase): <p>Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.</p>
    ///   - [`exclude_lowercase(bool)`](crate::client::fluent_builders::GetRandomPassword::exclude_lowercase) / [`set_exclude_lowercase(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_exclude_lowercase): <p>Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.</p>
    ///   - [`include_space(bool)`](crate::client::fluent_builders::GetRandomPassword::include_space) / [`set_include_space(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_include_space): <p>Specifies whether to include the space character. If you include this switch, the password can contain space characters.</p>
    ///   - [`require_each_included_type(bool)`](crate::client::fluent_builders::GetRandomPassword::require_each_included_type) / [`set_require_each_included_type(Option<bool>)`](crate::client::fluent_builders::GetRandomPassword::set_require_each_included_type): <p>Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.</p>
    /// - On success, responds with [`GetRandomPasswordOutput`](crate::output::GetRandomPasswordOutput) with field(s):
    ///   - [`random_password(Option<String>)`](crate::output::GetRandomPasswordOutput::random_password): <p>A string with the password.</p>
    /// - On failure, responds with [`SdkError<GetRandomPasswordError>`](crate::error::GetRandomPasswordError)
    pub fn get_random_password(&self) -> fluent_builders::GetRandomPassword {
        fluent_builders::GetRandomPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicy::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::GetResourcePolicy::set_secret_id): <p>The ARN or name of the secret to retrieve the attached resource-based policy for.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    /// - On success, responds with [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetResourcePolicyOutput::arn): <p>The ARN of the secret that the resource-based policy was retrieved for.</p>
    ///   - [`name(Option<String>)`](crate::output::GetResourcePolicyOutput::name): <p>The name of the secret that the resource-based policy was retrieved for.</p>
    ///   - [`resource_policy(Option<String>)`](crate::output::GetResourcePolicyOutput::resource_policy): <p>A JSON-formatted string that contains the permissions policy attached to the secret. For more information about permissions policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control for Secrets Manager</a>.</p>
    /// - On failure, responds with [`SdkError<GetResourcePolicyError>`](crate::error::GetResourcePolicyError)
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSecretValue`](crate::client::fluent_builders::GetSecretValue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::GetSecretValue::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::GetSecretValue::set_secret_id): <p>The ARN or name of the secret to retrieve.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetSecretValue::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetSecretValue::set_version_id): <p>The unique identifier of the version of the secret to retrieve. If you include both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code> version.</p>  <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>
    ///   - [`version_stage(impl Into<String>)`](crate::client::fluent_builders::GetSecretValue::version_stage) / [`set_version_stage(Option<String>)`](crate::client::fluent_builders::GetSecretValue::set_version_stage): <p>The staging label of the version of the secret to retrieve. </p>  <p>Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
    /// - On success, responds with [`GetSecretValueOutput`](crate::output::GetSecretValueOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetSecretValueOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::GetSecretValueOutput::name): <p>The friendly name of the secret.</p>
    ///   - [`version_id(Option<String>)`](crate::output::GetSecretValueOutput::version_id): <p>The unique identifier of this version of the secret.</p>
    ///   - [`secret_binary(Option<Blob>)`](crate::output::GetSecretValueOutput::secret_binary): <p>The decrypted secret value, if the secret value was originally provided as binary data in the form of a byte array. The response parameter represents the binary data as a <a href="https://tools.ietf.org/html/rfc4648#section-4">base64-encoded</a> string.</p>  <p>If the secret was created by using the Secrets Manager console, or if the secret value was originally provided as a string, then this field is omitted. The secret value appears in <code>SecretString</code> instead.</p>
    ///   - [`secret_string(Option<String>)`](crate::output::GetSecretValueOutput::secret_string): <p>The decrypted secret value, if the secret value was originally provided as a string or through the Secrets Manager console.</p>  <p>If this secret was created by using the console, then Secrets Manager stores the information as a JSON structure of key/value pairs. </p>
    ///   - [`version_stages(Option<Vec<String>>)`](crate::output::GetSecretValueOutput::version_stages): <p>A list of all of the staging labels currently attached to this version of the secret.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetSecretValueOutput::created_date): <p>The date and time that this version of the secret was created. If you don't specify which version in <code>VersionId</code> or <code>VersionStage</code>, then Secrets Manager uses the <code>AWSCURRENT</code> version.</p>
    /// - On failure, responds with [`SdkError<GetSecretValueError>`](crate::error::GetSecretValueError)
    pub fn get_secret_value(&self) -> fluent_builders::GetSecretValue {
        fluent_builders::GetSecretValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecrets`](crate::client::fluent_builders::ListSecrets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecrets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecrets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecrets::set_max_results): <p>The number of results to include in the response.</p>  <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecrets</code> again with the value from <code>NextToken</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecrets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecrets::set_next_token): <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecrets</code> again with this value.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListSecrets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListSecrets::set_filters): <p>The filters to apply to the list of secrets.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListSecrets::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListSecrets::set_sort_order): <p>Lists secrets in the requested order. </p>
    /// - On success, responds with [`ListSecretsOutput`](crate::output::ListSecretsOutput) with field(s):
    ///   - [`secret_list(Option<Vec<SecretListEntry>>)`](crate::output::ListSecretsOutput::secret_list): <p>A list of the secrets in the account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecretsOutput::next_token): <p>Secrets Manager includes this value if there's more output available than what is included in the current response. This can occur even when the response includes no values at all, such as when you ask for a filtered view of a long list. To get the next results, call <code>ListSecrets</code> again with this value.</p>
    /// - On failure, responds with [`SdkError<ListSecretsError>`](crate::error::ListSecretsError)
    pub fn list_secrets(&self) -> fluent_builders::ListSecrets {
        fluent_builders::ListSecrets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecretVersionIds`](crate::client::fluent_builders::ListSecretVersionIds) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecretVersionIds::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::ListSecretVersionIds::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::ListSecretVersionIds::set_secret_id): <p>The ARN or name of the secret whose versions you want to list.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecretVersionIds::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecretVersionIds::set_max_results): <p>The number of results to include in the response.</p>  <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecretVersionIds</code> again with the value from <code>NextToken</code>. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecretVersionIds::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecretVersionIds::set_next_token): <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecretVersionIds</code> again with this value.</p>
    ///   - [`include_deprecated(bool)`](crate::client::fluent_builders::ListSecretVersionIds::include_deprecated) / [`set_include_deprecated(Option<bool>)`](crate::client::fluent_builders::ListSecretVersionIds::set_include_deprecated): <p>Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager.</p>
    /// - On success, responds with [`ListSecretVersionIdsOutput`](crate::output::ListSecretVersionIdsOutput) with field(s):
    ///   - [`versions(Option<Vec<SecretVersionsListEntry>>)`](crate::output::ListSecretVersionIdsOutput::versions): <p>A list of the versions of the secret.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecretVersionIdsOutput::next_token): <p>Secrets Manager includes this value if there's more output available than what is included in the current response. This can occur even when the response includes no values at all, such as when you ask for a filtered view of a long list. To get the next results, call <code>ListSecretVersionIds</code> again with this value. </p>
    ///   - [`arn(Option<String>)`](crate::output::ListSecretVersionIdsOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::ListSecretVersionIdsOutput::name): <p>The name of the secret.</p>
    /// - On failure, responds with [`SdkError<ListSecretVersionIdsError>`](crate::error::ListSecretVersionIdsError)
    pub fn list_secret_version_ids(&self) -> fluent_builders::ListSecretVersionIds {
        fluent_builders::ListSecretVersionIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_secret_id): <p>The ARN or name of the secret to attach the resource-based policy.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`resource_policy(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_policy) / [`set_resource_policy(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_policy): <p>A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
    ///   - [`block_public_policy(bool)`](crate::client::fluent_builders::PutResourcePolicy::block_public_policy) / [`set_block_public_policy(Option<bool>)`](crate::client::fluent_builders::PutResourcePolicy::set_block_public_policy): <p>Specifies whether to block resource-based policies that allow broad access to the secret. By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.</p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::PutResourcePolicyOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::PutResourcePolicyOutput::name): <p>The name of the secret.</p>
    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSecretValue`](crate::client::fluent_builders::PutSecretValue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::PutSecretValue::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::PutSecretValue::set_secret_id): <p>The ARN or name of the secret to add a new version to.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>  <p>If the secret doesn't already exist, use <code>CreateSecret</code> instead.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::PutSecretValue::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::PutSecretValue::set_client_request_token): <p>A unique identifier for the new version of the secret. </p> <note>   <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty because they generate a random UUID for you. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p>  </note>  <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>  <ul>   <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>   <li> <p>If a version with this value already exists and that version's <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored. The operation is idempotent. </p> </li>   <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.</p> </li>  </ul>  <p>This value becomes the <code>VersionId</code> of the new version.</p>
    ///   - [`secret_binary(Blob)`](crate::client::fluent_builders::PutSecretValue::secret_binary) / [`set_secret_binary(Option<Blob>)`](crate::client::fluent_builders::PutSecretValue::set_secret_binary): <p>The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>  <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>  <p>You can't access this value from the Secrets Manager console.</p>
    ///   - [`secret_string(impl Into<String>)`](crate::client::fluent_builders::PutSecretValue::secret_string) / [`set_secret_string(Option<String>)`](crate::client::fluent_builders::PutSecretValue::set_secret_string): <p>The text to encrypt and store in the new version of the secret. </p>  <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>  <p>We recommend you create the secret string as JSON key/value pairs, as shown in the example.</p>
    ///   - [`version_stages(Vec<String>)`](crate::client::fluent_builders::PutSecretValue::version_stages) / [`set_version_stages(Option<Vec<String>>)`](crate::client::fluent_builders::PutSecretValue::set_version_stages): <p>A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.</p>  <p>If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify <code>AWSCURRENT</code>, and it is already attached to another version, then Secrets Manager also moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>  <p>If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version.</p>
    /// - On success, responds with [`PutSecretValueOutput`](crate::output::PutSecretValueOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::PutSecretValueOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::PutSecretValueOutput::name): <p>The name of the secret.</p>
    ///   - [`version_id(Option<String>)`](crate::output::PutSecretValueOutput::version_id): <p>The unique identifier of the version of the secret.</p>
    ///   - [`version_stages(Option<Vec<String>>)`](crate::output::PutSecretValueOutput::version_stages): <p>The list of staging labels that are currently attached to this version of the secret. Secrets Manager uses staging labels to track a version as it progresses through the secret rotation process.</p>
    /// - On failure, responds with [`SdkError<PutSecretValueError>`](crate::error::PutSecretValueError)
    pub fn put_secret_value(&self) -> fluent_builders::PutSecretValue {
        fluent_builders::PutSecretValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveRegionsFromReplication`](crate::client::fluent_builders::RemoveRegionsFromReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::RemoveRegionsFromReplication::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::RemoveRegionsFromReplication::set_secret_id): <p>The ARN or name of the secret.</p>
    ///   - [`remove_replica_regions(Vec<String>)`](crate::client::fluent_builders::RemoveRegionsFromReplication::remove_replica_regions) / [`set_remove_replica_regions(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveRegionsFromReplication::set_remove_replica_regions): <p>The Regions of the replicas to remove.</p>
    /// - On success, responds with [`RemoveRegionsFromReplicationOutput`](crate::output::RemoveRegionsFromReplicationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::RemoveRegionsFromReplicationOutput::arn): <p>The ARN of the primary secret.</p>
    ///   - [`replication_status(Option<Vec<ReplicationStatusType>>)`](crate::output::RemoveRegionsFromReplicationOutput::replication_status): <p>The status of replicas for this secret after you remove Regions.</p>
    /// - On failure, responds with [`SdkError<RemoveRegionsFromReplicationError>`](crate::error::RemoveRegionsFromReplicationError)
    pub fn remove_regions_from_replication(&self) -> fluent_builders::RemoveRegionsFromReplication {
        fluent_builders::RemoveRegionsFromReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReplicateSecretToRegions`](crate::client::fluent_builders::ReplicateSecretToRegions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::ReplicateSecretToRegions::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::ReplicateSecretToRegions::set_secret_id): <p>The ARN or name of the secret to replicate.</p>
    ///   - [`add_replica_regions(Vec<ReplicaRegionType>)`](crate::client::fluent_builders::ReplicateSecretToRegions::add_replica_regions) / [`set_add_replica_regions(Option<Vec<ReplicaRegionType>>)`](crate::client::fluent_builders::ReplicateSecretToRegions::set_add_replica_regions): <p>A list of Regions in which to replicate the secret.</p>
    ///   - [`force_overwrite_replica_secret(bool)`](crate::client::fluent_builders::ReplicateSecretToRegions::force_overwrite_replica_secret) / [`set_force_overwrite_replica_secret(bool)`](crate::client::fluent_builders::ReplicateSecretToRegions::set_force_overwrite_replica_secret): <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
    /// - On success, responds with [`ReplicateSecretToRegionsOutput`](crate::output::ReplicateSecretToRegionsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ReplicateSecretToRegionsOutput::arn): <p>The ARN of the primary secret.</p>
    ///   - [`replication_status(Option<Vec<ReplicationStatusType>>)`](crate::output::ReplicateSecretToRegionsOutput::replication_status): <p>The status of replication.</p>
    /// - On failure, responds with [`SdkError<ReplicateSecretToRegionsError>`](crate::error::ReplicateSecretToRegionsError)
    pub fn replicate_secret_to_regions(&self) -> fluent_builders::ReplicateSecretToRegions {
        fluent_builders::ReplicateSecretToRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreSecret`](crate::client::fluent_builders::RestoreSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::RestoreSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::RestoreSecret::set_secret_id): <p>The ARN or name of the secret to restore.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    /// - On success, responds with [`RestoreSecretOutput`](crate::output::RestoreSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::RestoreSecretOutput::arn): <p>The ARN of the secret that was restored.</p>
    ///   - [`name(Option<String>)`](crate::output::RestoreSecretOutput::name): <p>The name of the secret that was restored.</p>
    /// - On failure, responds with [`SdkError<RestoreSecretError>`](crate::error::RestoreSecretError)
    pub fn restore_secret(&self) -> fluent_builders::RestoreSecret {
        fluent_builders::RestoreSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RotateSecret`](crate::client::fluent_builders::RotateSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::RotateSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::RotateSecret::set_secret_id): <p>The ARN or name of the secret to rotate.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::RotateSecret::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::RotateSecret::set_client_request_token): <p>A unique identifier for the new version of the secret that helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during rotation. This value becomes the <code>VersionId</code> of the new version.</p>  <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p>  <p>You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
    ///   - [`rotation_lambda_arn(impl Into<String>)`](crate::client::fluent_builders::RotateSecret::rotation_lambda_arn) / [`set_rotation_lambda_arn(Option<String>)`](crate::client::fluent_builders::RotateSecret::set_rotation_lambda_arn): <p>The ARN of the Lambda rotation function that can rotate the secret.</p>
    ///   - [`rotation_rules(RotationRulesType)`](crate::client::fluent_builders::RotateSecret::rotation_rules) / [`set_rotation_rules(Option<RotationRulesType>)`](crate::client::fluent_builders::RotateSecret::set_rotation_rules): <p>A structure that defines the rotation configuration for this secret.</p>
    ///   - [`rotate_immediately(bool)`](crate::client::fluent_builders::RotateSecret::rotate_immediately) / [`set_rotate_immediately(Option<bool>)`](crate::client::fluent_builders::RotateSecret::set_rotate_immediately): <p>Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in <code>RotateSecretRequest$RotationRules</code>.</p>  <p>If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"> <code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.</p>  <p>If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.</p>
    /// - On success, responds with [`RotateSecretOutput`](crate::output::RotateSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::RotateSecretOutput::arn): <p>The ARN of the secret.</p>
    ///   - [`name(Option<String>)`](crate::output::RotateSecretOutput::name): <p>The name of the secret.</p>
    ///   - [`version_id(Option<String>)`](crate::output::RotateSecretOutput::version_id): <p>The ID of the new version of the secret.</p>
    /// - On failure, responds with [`SdkError<RotateSecretError>`](crate::error::RotateSecretError)
    pub fn rotate_secret(&self) -> fluent_builders::RotateSecret {
        fluent_builders::RotateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopReplicationToReplica`](crate::client::fluent_builders::StopReplicationToReplica) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::StopReplicationToReplica::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::StopReplicationToReplica::set_secret_id): <p>The ARN of the primary secret. </p>
    /// - On success, responds with [`StopReplicationToReplicaOutput`](crate::output::StopReplicationToReplicaOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::StopReplicationToReplicaOutput::arn): <p>The ARN of the promoted secret. The ARN is the same as the original primary secret except the Region is changed.</p>
    /// - On failure, responds with [`SdkError<StopReplicationToReplicaError>`](crate::error::StopReplicationToReplicaError)
    pub fn stop_replication_to_replica(&self) -> fluent_builders::StopReplicationToReplica {
        fluent_builders::StopReplicationToReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::TagResource::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::TagResource::set_secret_id): <p>The identifier for the secret to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to attach to the secret as a JSON text string argument. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p>  <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::UntagResource::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::UntagResource::set_secret_id): <p>The ARN or name of the secret.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.</p>  <p>This parameter requires a JSON text string argument.</p>  <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSecret`](crate::client::fluent_builders::UpdateSecret) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecret::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::UpdateSecret::set_secret_id): <p>The ARN or name of the secret.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateSecret::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateSecret::set_client_request_token): <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.</p> <note>   <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>  </note>  <p>This value becomes the <code>VersionId</code> of the new version.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSecret::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSecret::set_description): <p>The description of the secret.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecret::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::UpdateSecret::set_kms_key_id): <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or <code>AWSPREVIOUS</code>. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>.</p> <important>   <p>You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.</p>  </important>
    ///   - [`secret_binary(Blob)`](crate::client::fluent_builders::UpdateSecret::secret_binary) / [`set_secret_binary(Option<Blob>)`](crate::client::fluent_builders::UpdateSecret::set_secret_binary): <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>  <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.</p>  <p>You can't access this parameter in the Secrets Manager console.</p>
    ///   - [`secret_string(impl Into<String>)`](crate::client::fluent_builders::UpdateSecret::secret_string) / [`set_secret_string(Option<String>)`](crate::client::fluent_builders::UpdateSecret::set_secret_string): <p>The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value. </p>  <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. </p>
    /// - On success, responds with [`UpdateSecretOutput`](crate::output::UpdateSecretOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateSecretOutput::arn): <p>The ARN of the secret that was updated.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateSecretOutput::name): <p>The name of the secret that was updated.</p>
    ///   - [`version_id(Option<String>)`](crate::output::UpdateSecretOutput::version_id): <p>If Secrets Manager created a new version of the secret during this operation, then <code>VersionId</code> contains the unique identifier of the new version.</p>
    /// - On failure, responds with [`SdkError<UpdateSecretError>`](crate::error::UpdateSecretError)
    pub fn update_secret(&self) -> fluent_builders::UpdateSecret {
        fluent_builders::UpdateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSecretVersionStage`](crate::client::fluent_builders::UpdateSecretVersionStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::set_secret_id): <p>The ARN or the name of the secret with the version and staging labelsto modify.</p>  <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
    ///   - [`version_stage(impl Into<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::version_stage) / [`set_version_stage(Option<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::set_version_stage): <p>The staging label to add to this version.</p>
    ///   - [`remove_from_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::remove_from_version_id) / [`set_remove_from_version_id(Option<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::set_remove_from_version_id): <p>The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>
    ///   - [`move_to_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::move_to_version_id) / [`set_move_to_version_id(Option<String>)`](crate::client::fluent_builders::UpdateSecretVersionStage::set_move_to_version_id): <p>The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.</p>  <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>
    /// - On success, responds with [`UpdateSecretVersionStageOutput`](crate::output::UpdateSecretVersionStageOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateSecretVersionStageOutput::arn): <p>The ARN of the secret that was updated.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateSecretVersionStageOutput::name): <p>The name of the secret that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateSecretVersionStageError>`](crate::error::UpdateSecretVersionStageError)
    pub fn update_secret_version_stage(&self) -> fluent_builders::UpdateSecretVersionStage {
        fluent_builders::UpdateSecretVersionStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidateResourcePolicy`](crate::client::fluent_builders::ValidateResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`secret_id(impl Into<String>)`](crate::client::fluent_builders::ValidateResourcePolicy::secret_id) / [`set_secret_id(Option<String>)`](crate::client::fluent_builders::ValidateResourcePolicy::set_secret_id): <p>This field is reserved for internal use.</p>
    ///   - [`resource_policy(impl Into<String>)`](crate::client::fluent_builders::ValidateResourcePolicy::resource_policy) / [`set_resource_policy(Option<String>)`](crate::client::fluent_builders::ValidateResourcePolicy::set_resource_policy): <p>A JSON-formatted string that contains an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
    /// - On success, responds with [`ValidateResourcePolicyOutput`](crate::output::ValidateResourcePolicyOutput) with field(s):
    ///   - [`policy_validation_passed(bool)`](crate::output::ValidateResourcePolicyOutput::policy_validation_passed): <p>True if your policy passes validation, otherwise false.</p>
    ///   - [`validation_errors(Option<Vec<ValidationErrorsEntry>>)`](crate::output::ValidateResourcePolicyOutput::validation_errors): <p>Validation errors if your policy didn't pass validation.</p>
    /// - On failure, responds with [`SdkError<ValidateResourcePolicyError>`](crate::error::ValidateResourcePolicyError)
    pub fn validate_resource_policy(&self) -> fluent_builders::ValidateResourcePolicy {
        fluent_builders::ValidateResourcePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelRotateSecret`.
    ///
    /// <p>Turns off automatic rotation, and if a rotation is currently in progress, cancels the rotation.</p>
    /// <p>To turn on automatic rotation again, call <code>RotateSecret</code>.</p> <note>
    /// <p>If you cancel a rotation in progress, it can leave the <code>VersionStage</code> labels in an unexpected state. Depending on the step of the rotation in progress, you might need to remove the staging label <code>AWSPENDING</code> from the partially created version, specified by the <code>VersionId</code> response value. We recommend you also evaluate the partially rotated new version to see if it should be deleted. You can delete a version by removing all staging labels from it.</p>
    /// </note>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:CancelRotateSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelRotateSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_rotate_secret_input::Builder,
    }
    impl CancelRotateSecret {
        /// Creates a new `CancelRotateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelRotateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelRotateSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecret`.
    ///
    /// <p>Creates a new secret. A <i>secret</i> is a set of credentials, such as a user name and password, that you store in an encrypted form in Secrets Manager. The secret also includes the connection information to access a database or other service, which Secrets Manager doesn't encrypt. A secret in Secrets Manager consists of both the protected secret data and the important information needed to manage the secret.</p>
    /// <p>For information about creating a secret in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html">Create a secret</a>.</p>
    /// <p>To create a secret, you can provide the secret value to be encrypted in either the <code>SecretString</code> parameter or the <code>SecretBinary</code> parameter, but not both. If you include <code>SecretString</code> or <code>SecretBinary</code> then Secrets Manager creates an initial secret version and automatically attaches the staging label <code>AWSCURRENT</code> to it.</p>
    /// <p>If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant delay in returning the result.</p>
    /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:CreateSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_secret_input::Builder,
    }
    impl CreateSecret {
        /// Creates a new `CreateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new secret.</p>
        /// <p>The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-</p>
        /// <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new secret.</p>
        /// <p>The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-</p>
        /// <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <code>PutSecretValue</code> to create a new version.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <code>PutSecretValue</code> to create a new version.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret.</p>
        /// <p>To use a KMS key in a different account, use the key ARN or the alias ARN.</p>
        /// <p>If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code>. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.</p>
        /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret.</p>
        /// <p>To use a KMS key in a different account, use the key ARN or the alias ARN.</p>
        /// <p>If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code>. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.</p>
        /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>This parameter is not available in the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>This parameter is not available in the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.</p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.</p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:</p>
        /// <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p>
        /// <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p>
        /// <p>If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a>.</p>
        /// <p>For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>. If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per secret: 50</p> </li>
        /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
        /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:</p>
        /// <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p>
        /// <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p>
        /// <p>If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a>.</p>
        /// <p>For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>. If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per secret: 50</p> </li>
        /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
        /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AddReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_add_replica_regions`](Self::set_add_replica_regions).
        ///
        /// <p>A list of Regions and KMS keys to replicate secrets.</p>
        pub fn add_replica_regions(mut self, input: crate::model::ReplicaRegionType) -> Self {
            self.inner = self.inner.add_replica_regions(input);
            self
        }
        /// <p>A list of Regions and KMS keys to replicate secrets.</p>
        pub fn set_add_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaRegionType>>,
        ) -> Self {
            self.inner = self.inner.set_add_replica_regions(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn force_overwrite_replica_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.force_overwrite_replica_secret(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn set_force_overwrite_replica_secret(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_overwrite_replica_secret(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes the resource-based permission policy attached to the secret. To attach a policy to a secret, use <code>PutResourcePolicy</code>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:DeleteResourcePolicy</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to delete the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to delete the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecret`.
    ///
    /// <p>Deletes a secret and all of its versions. You can specify a recovery window during which you can restore the secret. The minimum recovery window is 7 days. The default recovery window is 30 days. Secrets Manager attaches a <code>DeletionDate</code> stamp to the secret that specifies the end of the recovery window. At the end of the recovery window, Secrets Manager deletes the secret permanently.</p>
    /// <p>For information about deleting a secret in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_delete-secret.html">https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_delete-secret.html</a>. </p>
    /// <p>Secrets Manager performs the permanent secret deletion at the end of the waiting period as a background task with low priority. There is no guarantee of a specific time after the recovery window for the permanent delete to occur.</p>
    /// <p>At any time before recovery window ends, you can use <code>RestoreSecret</code> to remove the <code>DeletionDate</code> and cancel the deletion of the secret.</p>
    /// <p>In a secret scheduled for deletion, you cannot access the encrypted secret value. To access that information, first cancel the deletion with <code>RestoreSecret</code> and then retrieve the information.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:DeleteSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_secret_input::Builder,
    }
    impl DeleteSecret {
        /// Creates a new `DeleteSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to delete.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to delete.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and <code>ForceDeleteWithoutRecovery</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        pub fn recovery_window_in_days(mut self, input: i64) -> Self {
            self.inner = self.inner.recovery_window_in_days(input);
            self
        }
        /// <p>The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and <code>ForceDeleteWithoutRecovery</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        pub fn set_recovery_window_in_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_recovery_window_in_days(input);
            self
        }
        /// <p>Specifies whether to delete the secret without any recovery window. You can't use both this parameter and <code>RecoveryWindowInDays</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        /// <p>Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.</p> <important>
        /// <p>Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p>
        /// </important>
        pub fn force_delete_without_recovery(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete_without_recovery(input);
            self
        }
        /// <p>Specifies whether to delete the secret without any recovery window. You can't use both this parameter and <code>RecoveryWindowInDays</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        /// <p>Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.</p> <important>
        /// <p>Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p>
        /// </important>
        pub fn set_force_delete_without_recovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_delete_without_recovery(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecret`.
    ///
    /// <p>Retrieves the details of a secret. It does not include the encrypted secret value. Secrets Manager only returns fields that have a value in the response. </p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:DescribeSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_secret_input::Builder,
    }
    impl DescribeSecret {
        /// Creates a new `DescribeSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret. </p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret. </p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRandomPassword`.
    ///
    /// <p>Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:GetRandomPassword</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRandomPassword {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_random_password_input::Builder,
    }
    impl GetRandomPassword {
        /// Creates a new `GetRandomPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRandomPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRandomPasswordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The length of the password. If you don't include this parameter, the default length is 32 characters.</p>
        pub fn password_length(mut self, input: i64) -> Self {
            self.inner = self.inner.password_length(input);
            self
        }
        /// <p>The length of the password. If you don't include this parameter, the default length is 32 characters.</p>
        pub fn set_password_length(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_password_length(input);
            self
        }
        /// <p>A string of the characters that you don't want in the password.</p>
        pub fn exclude_characters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclude_characters(input.into());
            self
        }
        /// <p>A string of the characters that you don't want in the password.</p>
        pub fn set_exclude_characters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclude_characters(input);
            self
        }
        /// <p>Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.</p>
        pub fn exclude_numbers(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_numbers(input);
            self
        }
        /// <p>Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.</p>
        pub fn set_exclude_numbers(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_numbers(input);
            self
        }
        /// <p>Specifies whether to exclude the following punctuation characters from the password: <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this switch, the password can contain punctuation.</p>
        pub fn exclude_punctuation(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_punctuation(input);
            self
        }
        /// <p>Specifies whether to exclude the following punctuation characters from the password: <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this switch, the password can contain punctuation.</p>
        pub fn set_exclude_punctuation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_punctuation(input);
            self
        }
        /// <p>Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.</p>
        pub fn exclude_uppercase(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_uppercase(input);
            self
        }
        /// <p>Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.</p>
        pub fn set_exclude_uppercase(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_uppercase(input);
            self
        }
        /// <p>Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.</p>
        pub fn exclude_lowercase(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_lowercase(input);
            self
        }
        /// <p>Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.</p>
        pub fn set_exclude_lowercase(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_lowercase(input);
            self
        }
        /// <p>Specifies whether to include the space character. If you include this switch, the password can contain space characters.</p>
        pub fn include_space(mut self, input: bool) -> Self {
            self.inner = self.inner.include_space(input);
            self
        }
        /// <p>Specifies whether to include the space character. If you include this switch, the password can contain space characters.</p>
        pub fn set_include_space(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_space(input);
            self
        }
        /// <p>Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.</p>
        pub fn require_each_included_type(mut self, input: bool) -> Self {
            self.inner = self.inner.require_each_included_type(input);
            self
        }
        /// <p>Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.</p>
        pub fn set_require_each_included_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_each_included_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Retrieves the JSON text of the resource-based policy document attached to the secret. For more information about permissions policies attached to a secret, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html">Permissions policies attached to a secret</a>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:GetResourcePolicy</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl GetResourcePolicy {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to retrieve the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to retrieve the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSecretValue`.
    ///
    /// <p>Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> from the specified version of a secret, whichever contains content.</p>
    /// <p>We recommend that you cache your secret values by using client-side caching. Caching secrets improves speed and reduces your costs. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html">Cache secrets for your applications</a>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:GetSecretValue</code>. If the secret is encrypted using a customer-managed key instead of the Amazon Web Services managed key <code>aws/secretsmanager</code>, then you also need <code>kms:Decrypt</code> permissions for that key. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSecretValue {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_secret_value_input::Builder,
    }
    impl GetSecretValue {
        /// Creates a new `GetSecretValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSecretValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSecretValueError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to retrieve.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to retrieve.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The unique identifier of the version of the secret to retrieve. If you include both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        /// <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The unique identifier of the version of the secret to retrieve. If you include both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        /// <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The staging label of the version of the secret to retrieve. </p>
        /// <p>Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        pub fn version_stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stage(input.into());
            self
        }
        /// <p>The staging label of the version of the secret to retrieve. </p>
        /// <p>Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        pub fn set_version_stage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecrets`.
    ///
    /// <p>Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.</p>
    /// <p>To list the versions of a secret, use <code>ListSecretVersionIds</code>.</p>
    /// <p>To get the secret value from <code>SecretString</code> or <code>SecretBinary</code>, call <code>GetSecretValue</code>.</p>
    /// <p>For information about finding secrets in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html">Enhanced search capabilities for secrets in Secrets Manager</a>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:ListSecrets</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecrets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_secrets_input::Builder,
    }
    impl ListSecrets {
        /// Creates a new `ListSecrets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecretsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecretsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecretsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecretsPaginator {
            crate::paginator::ListSecretsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecrets</code> again with the value from <code>NextToken</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecrets</code> again with the value from <code>NextToken</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecrets</code> again with this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecrets</code> again with this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the list of secrets.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to apply to the list of secrets.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Lists secrets in the requested order. </p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>Lists secrets in the requested order. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecretVersionIds`.
    ///
    /// <p>Lists the versions for a secret. </p>
    /// <p>To list the secrets in the account, use <code>ListSecrets</code>.</p>
    /// <p>To get the secret value from <code>SecretString</code> or <code>SecretBinary</code>, call <code>GetSecretValue</code>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:ListSecretVersionIds</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecretVersionIds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_secret_version_ids_input::Builder,
    }
    impl ListSecretVersionIds {
        /// Creates a new `ListSecretVersionIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecretVersionIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecretVersionIdsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecretVersionIdsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecretVersionIdsPaginator {
            crate::paginator::ListSecretVersionIdsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN or name of the secret whose versions you want to list.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret whose versions you want to list.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecretVersionIds</code> again with the value from <code>NextToken</code>. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecretVersionIds</code> again with the value from <code>NextToken</code>. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecretVersionIds</code> again with this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecretVersionIds</code> again with this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager.</p>
        pub fn include_deprecated(mut self, input: bool) -> Self {
            self.inner = self.inner.include_deprecated(input);
            self
        }
        /// <p>Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager.</p>
        pub fn set_include_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deprecated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control for Secrets Manager</a> </p>
    /// <p>For information about attaching a policy in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html">Attach a permissions policy to a secret</a>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:PutResourcePolicy</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to attach the resource-based policy.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to attach the resource-based policy.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(input.into());
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
        /// <p>Specifies whether to block resource-based policies that allow broad access to the secret. By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.inner = self.inner.block_public_policy(input);
            self
        }
        /// <p>Specifies whether to block resource-based policies that allow broad access to the secret. By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_block_public_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSecretValue`.
    ///
    /// <p>Creates a new version with a new encrypted secret value and attaches it to the secret. The version can contain a new <code>SecretString</code> value or a new <code>SecretBinary</code> value. </p>
    /// <p>We recommend you avoid calling <code>PutSecretValue</code> at a sustained rate of more than once every 10 minutes. When you update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you call <code>PutSecretValue</code> more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p>
    /// <p>You can specify the staging labels to attach to the new version in <code>VersionStages</code>. If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version. If this operation creates the first version for the secret, then Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to it .</p>
    /// <p>If this operation moves the staging label <code>AWSCURRENT</code> from another version to this version, then Secrets Manager also automatically moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
    /// <p>This operation is idempotent. If a version with a <code>VersionId</code> with the same value as the <code>ClientRequestToken</code> parameter already exists, and you specify the same secret data, the operation succeeds but does nothing. However, if the secret data is different, then the operation fails because you can't modify an existing version; you can only create new ones.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:PutSecretValue</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSecretValue {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_secret_value_input::Builder,
    }
    impl PutSecretValue {
        /// Creates a new `PutSecretValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSecretValueOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSecretValueError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to add a new version to.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        /// <p>If the secret doesn't already exist, use <code>CreateSecret</code> instead.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to add a new version to.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        /// <p>If the secret doesn't already exist, use <code>CreateSecret</code> instead.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A unique identifier for the new version of the secret. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty because they generate a random UUID for you. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored. The operation is idempotent. </p> </li>
        /// <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the new version of the secret. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty because they generate a random UUID for you. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored. The operation is idempotent. </p> </li>
        /// <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>You can't access this value from the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>You can't access this value from the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text to encrypt and store in the new version of the secret. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>We recommend you create the secret string as JSON key/value pairs, as shown in the example.</p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text to encrypt and store in the new version of the secret. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>We recommend you create the secret string as JSON key/value pairs, as shown in the example.</p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
        /// Appends an item to `VersionStages`.
        ///
        /// To override the contents of this collection use [`set_version_stages`](Self::set_version_stages).
        ///
        /// <p>A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.</p>
        /// <p>If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify <code>AWSCURRENT</code>, and it is already attached to another version, then Secrets Manager also moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
        /// <p>If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version.</p>
        pub fn version_stages(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stages(input.into());
            self
        }
        /// <p>A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.</p>
        /// <p>If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify <code>AWSCURRENT</code>, and it is already attached to another version, then Secrets Manager also moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
        /// <p>If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version.</p>
        pub fn set_version_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_stages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRegionsFromReplication`.
    ///
    /// <p>For a secret that is replicated to other Regions, deletes the secret replicas from the Regions you specify.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:RemoveRegionsFromReplication</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveRegionsFromReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_regions_from_replication_input::Builder,
    }
    impl RemoveRegionsFromReplication {
        /// Creates a new `RemoveRegionsFromReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRegionsFromReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRegionsFromReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `RemoveReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_remove_replica_regions`](Self::set_remove_replica_regions).
        ///
        /// <p>The Regions of the replicas to remove.</p>
        pub fn remove_replica_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_replica_regions(input.into());
            self
        }
        /// <p>The Regions of the replicas to remove.</p>
        pub fn set_remove_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_replica_regions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReplicateSecretToRegions`.
    ///
    /// <p>Replicates the secret to a new Regions. See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html">Multi-Region secrets</a>.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:ReplicateSecretToRegions</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReplicateSecretToRegions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::replicate_secret_to_regions_input::Builder,
    }
    impl ReplicateSecretToRegions {
        /// Creates a new `ReplicateSecretToRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReplicateSecretToRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ReplicateSecretToRegionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to replicate.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to replicate.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `AddReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_add_replica_regions`](Self::set_add_replica_regions).
        ///
        /// <p>A list of Regions in which to replicate the secret.</p>
        pub fn add_replica_regions(mut self, input: crate::model::ReplicaRegionType) -> Self {
            self.inner = self.inner.add_replica_regions(input);
            self
        }
        /// <p>A list of Regions in which to replicate the secret.</p>
        pub fn set_add_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaRegionType>>,
        ) -> Self {
            self.inner = self.inner.set_add_replica_regions(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn force_overwrite_replica_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.force_overwrite_replica_secret(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn set_force_overwrite_replica_secret(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_overwrite_replica_secret(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreSecret`.
    ///
    /// <p>Cancels the scheduled deletion of a secret by removing the <code>DeletedDate</code> time stamp. You can access a secret again after it has been restored.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:RestoreSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_secret_input::Builder,
    }
    impl RestoreSecret {
        /// Creates a new `RestoreSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to restore.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to restore.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateSecret`.
    ///
    /// <p>Configures and starts the asynchronous process of rotating the secret.</p>
    /// <p>If you include the configuration parameters, the operation sets the values for the secret and then immediately starts a rotation. If you don't include the configuration parameters, the operation starts a rotation with the values already stored in the secret. For more information about rotation, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html">Rotate secrets</a>.</p>
    /// <p>To configure rotation, you include the ARN of an Amazon Web Services Lambda function and the schedule for the rotation. The Lambda rotation function creates a new version of the secret and creates or updates the credentials on the database or service to match. After testing the new credentials, the function marks the new secret version with the staging label <code>AWSCURRENT</code>. Then anyone who retrieves the secret gets the new version. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation works</a>.</p>
    /// <p>When rotation is successful, the <code>AWSPENDING</code> staging label might be attached to the same version as the <code>AWSCURRENT</code> version, or it might not be attached to any version.</p>
    /// <p>If the <code>AWSPENDING</code> staging label is present but not attached to the same version as <code>AWSCURRENT</code>, then any later invocation of <code>RotateSecret</code> assumes that a previous rotation request is still in progress and returns an error.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:RotateSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. You also need <code>lambda:InvokeFunction</code> permissions on the rotation function. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets-required-permissions-function.html"> Permissions for rotation</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RotateSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rotate_secret_input::Builder,
    }
    impl RotateSecret {
        /// Creates a new `RotateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to rotate.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to rotate.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A unique identifier for the new version of the secret that helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during rotation. This value becomes the <code>VersionId</code> of the new version.</p>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p>
        /// <p>You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the new version of the secret that helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during rotation. This value becomes the <code>VersionId</code> of the new version.</p>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p>
        /// <p>You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Lambda rotation function that can rotate the secret.</p>
        pub fn rotation_lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rotation_lambda_arn(input.into());
            self
        }
        /// <p>The ARN of the Lambda rotation function that can rotate the secret.</p>
        pub fn set_rotation_lambda_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rotation_lambda_arn(input);
            self
        }
        /// <p>A structure that defines the rotation configuration for this secret.</p>
        pub fn rotation_rules(mut self, input: crate::model::RotationRulesType) -> Self {
            self.inner = self.inner.rotation_rules(input);
            self
        }
        /// <p>A structure that defines the rotation configuration for this secret.</p>
        pub fn set_rotation_rules(
            mut self,
            input: std::option::Option<crate::model::RotationRulesType>,
        ) -> Self {
            self.inner = self.inner.set_rotation_rules(input);
            self
        }
        /// <p>Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in <code>RotateSecretRequest$RotationRules</code>.</p>
        /// <p>If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"> <code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.</p>
        /// <p>If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.</p>
        pub fn rotate_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.rotate_immediately(input);
            self
        }
        /// <p>Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in <code>RotateSecretRequest$RotationRules</code>.</p>
        /// <p>If you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html"> <code>testSecret</code> step</a> of the Lambda rotation function. The test creates an <code>AWSPENDING</code> version of the secret and then removes it.</p>
        /// <p>If you don't specify this value, then by default, Secrets Manager rotates the secret immediately.</p>
        pub fn set_rotate_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_rotate_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopReplicationToReplica`.
    ///
    /// <p>Removes the link between the replica secret and the primary secret and promotes the replica to a primary secret in the replica Region.</p>
    /// <p>You must call this operation from the Region in which you want to promote the replica to a primary secret.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:StopReplicationToReplica</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopReplicationToReplica {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_replication_to_replica_input::Builder,
    }
    impl StopReplicationToReplica {
        /// Creates a new `StopReplicationToReplica`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopReplicationToReplicaOutput,
            aws_smithy_http::result::SdkError<crate::error::StopReplicationToReplicaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the primary secret. </p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN of the primary secret. </p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They are not associated with specific versions of the secret. This operation appends tags to the existing list of tags.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li> <p>Maximum number of tags per secret: 50</p> </li>
    /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Tag keys and values are case sensitive.</p> </li>
    /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
    /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
    /// </ul> <important>
    /// <p>If you use tags as part of your security strategy, then adding or removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p>
    /// </important>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:TagResource</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the secret to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The identifier for the secret to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the secret as a JSON text string argument. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the secret as a JSON text string argument. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes specific tags from a secret.</p>
    /// <p>This operation is idempotent. If a requested tag is not attached to the secret, no error is returned and the secret metadata is unchanged.</p> <important>
    /// <p>If you use tags as part of your security strategy, then removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p>
    /// </important>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:UntagResource</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.</p>
        /// <p>This parameter requires a JSON text string argument.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.</p>
        /// <p>This parameter requires a JSON text string argument.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecret`.
    ///
    /// <p>Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can also use <code>PutSecretValue</code>.</p>
    /// <p>To change the rotation configuration of a secret, use <code>RotateSecret</code> instead.</p>
    /// <p>We recommend you avoid calling <code>UpdateSecret</code> at a sustained rate of more than once every 10 minutes. When you call <code>UpdateSecret</code> to update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you update the secret value more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p>
    /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code> to create a new secret version, Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to the new version. </p>
    /// <p>If you call this operation with a <code>VersionId</code> that matches an existing version's <code>ClientRequestToken</code>, the operation results in an error. You can't modify an existing version, you can only create a new version. To remove a version, remove all staging labels from it. See <code>UpdateSecretVersionStage</code>.</p>
    /// <p>If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant delay in returning the result. </p>
    /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed key. </p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:UpdateSecret</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. If you use a customer managed key, you must also have <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permissions on the key. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/security-encryption.html"> Secret encryption and decryption</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecret {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_secret_input::Builder,
    }
    impl UpdateSecret {
        /// Creates a new `UpdateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecretError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.</p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.</p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or <code>AWSPREVIOUS</code>. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>.</p> <important>
        /// <p>You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.</p>
        /// </important>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or <code>AWSPREVIOUS</code>. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>.</p> <important>
        /// <p>You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.</p>
        /// </important>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.</p>
        /// <p>You can't access this parameter in the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.</p>
        /// <p>You can't access this parameter in the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. </p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. </p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecretVersionStage`.
    ///
    /// <p>Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a version as it progresses through the secret rotation process. Each staging label can be attached to only one version at a time. To add a staging label to a version when it is already attached to another version, Secrets Manager first removes it from the other version first and then attaches it to this one. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>. </p>
    /// <p>The staging labels that you specify in the <code>VersionStage</code> parameter are added to the existing list of staging labels for the version. </p>
    /// <p>You can move the <code>AWSCURRENT</code> staging label to this version by including it in this call.</p> <note>
    /// <p>Whenever you move <code>AWSCURRENT</code>, Secrets Manager automatically moves the label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
    /// </note>
    /// <p>If this action results in the last label being removed from a version, then the version is considered to be 'deprecated' and can be deleted by Secrets Manager.</p>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:UpdateSecretVersionStage</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecretVersionStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_secret_version_stage_input::Builder,
    }
    impl UpdateSecretVersionStage {
        /// Creates a new `UpdateSecretVersionStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecretVersionStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecretVersionStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or the name of the secret with the version and staging labelsto modify.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or the name of the secret with the version and staging labelsto modify.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The staging label to add to this version.</p>
        pub fn version_stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stage(input.into());
            self
        }
        /// <p>The staging label to add to this version.</p>
        pub fn set_version_stage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_stage(input);
            self
        }
        /// <p>The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>
        pub fn remove_from_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_from_version_id(input.into());
            self
        }
        /// <p>The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>
        pub fn set_remove_from_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remove_from_version_id(input);
            self
        }
        /// <p>The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.</p>
        /// <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>
        pub fn move_to_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.move_to_version_id(input.into());
            self
        }
        /// <p>The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.</p>
        /// <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>
        pub fn set_move_to_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_move_to_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateResourcePolicy`.
    ///
    /// <p>Validates that a resource policy does not grant a wide range of principals access to your secret. A resource-based policy is optional for secrets.</p>
    /// <p>The API performs three checks when validating the policy:</p>
    /// <ul>
    /// <li> <p>Sends a call to <a href="https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/">Zelkova</a>, an automated reasoning engine, to ensure your resource policy does not allow broad access to your secret, for example policies that use a wildcard for the principal.</p> </li>
    /// <li> <p>Checks for correct syntax in a policy.</p> </li>
    /// <li> <p>Verifies the policy does not lock out a caller.</p> </li>
    /// </ul>
    /// <p> <b>Required permissions: </b> <code>secretsmanager:ValidateResourcePolicy</code>. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions"> IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidateResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::validate_resource_policy_input::Builder,
    }
    impl ValidateResourcePolicy {
        /// Creates a new `ValidateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This field is reserved for internal use.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>This field is reserved for internal use.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A JSON-formatted string that contains an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(input.into());
            self
        }
        /// <p>A JSON-formatted string that contains an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
