// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Secrets Manager
///
/// Client for invoking operations on AWS Secrets Manager. Each operation on AWS Secrets Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_secretsmanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_secretsmanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_secretsmanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelRotateSecret` operation.
    ///
    /// See [`CancelRotateSecret`](crate::client::fluent_builders::CancelRotateSecret) for more information about the
    /// operation and its arguments.
    pub fn cancel_rotate_secret(&self) -> fluent_builders::CancelRotateSecret<C, M, R> {
        fluent_builders::CancelRotateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSecret` operation.
    ///
    /// See [`CreateSecret`](crate::client::fluent_builders::CreateSecret) for more information about the
    /// operation and its arguments.
    pub fn create_secret(&self) -> fluent_builders::CreateSecret<C, M, R> {
        fluent_builders::CreateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSecret` operation.
    ///
    /// See [`DeleteSecret`](crate::client::fluent_builders::DeleteSecret) for more information about the
    /// operation and its arguments.
    pub fn delete_secret(&self) -> fluent_builders::DeleteSecret<C, M, R> {
        fluent_builders::DeleteSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecret` operation.
    ///
    /// See [`DescribeSecret`](crate::client::fluent_builders::DescribeSecret) for more information about the
    /// operation and its arguments.
    pub fn describe_secret(&self) -> fluent_builders::DescribeSecret<C, M, R> {
        fluent_builders::DescribeSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRandomPassword` operation.
    ///
    /// See [`GetRandomPassword`](crate::client::fluent_builders::GetRandomPassword) for more information about the
    /// operation and its arguments.
    pub fn get_random_password(&self) -> fluent_builders::GetRandomPassword<C, M, R> {
        fluent_builders::GetRandomPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicy` operation.
    ///
    /// See [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy<C, M, R> {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSecretValue` operation.
    ///
    /// See [`GetSecretValue`](crate::client::fluent_builders::GetSecretValue) for more information about the
    /// operation and its arguments.
    pub fn get_secret_value(&self) -> fluent_builders::GetSecretValue<C, M, R> {
        fluent_builders::GetSecretValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecrets` operation.
    ///
    /// See [`ListSecrets`](crate::client::fluent_builders::ListSecrets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSecrets::into_paginator).
    pub fn list_secrets(&self) -> fluent_builders::ListSecrets<C, M, R> {
        fluent_builders::ListSecrets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecretVersionIds` operation.
    ///
    /// See [`ListSecretVersionIds`](crate::client::fluent_builders::ListSecretVersionIds) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSecretVersionIds::into_paginator).
    pub fn list_secret_version_ids(&self) -> fluent_builders::ListSecretVersionIds<C, M, R> {
        fluent_builders::ListSecretVersionIds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSecretValue` operation.
    ///
    /// See [`PutSecretValue`](crate::client::fluent_builders::PutSecretValue) for more information about the
    /// operation and its arguments.
    pub fn put_secret_value(&self) -> fluent_builders::PutSecretValue<C, M, R> {
        fluent_builders::PutSecretValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRegionsFromReplication` operation.
    ///
    /// See [`RemoveRegionsFromReplication`](crate::client::fluent_builders::RemoveRegionsFromReplication) for more information about the
    /// operation and its arguments.
    pub fn remove_regions_from_replication(
        &self,
    ) -> fluent_builders::RemoveRegionsFromReplication<C, M, R> {
        fluent_builders::RemoveRegionsFromReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplicateSecretToRegions` operation.
    ///
    /// See [`ReplicateSecretToRegions`](crate::client::fluent_builders::ReplicateSecretToRegions) for more information about the
    /// operation and its arguments.
    pub fn replicate_secret_to_regions(
        &self,
    ) -> fluent_builders::ReplicateSecretToRegions<C, M, R> {
        fluent_builders::ReplicateSecretToRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreSecret` operation.
    ///
    /// See [`RestoreSecret`](crate::client::fluent_builders::RestoreSecret) for more information about the
    /// operation and its arguments.
    pub fn restore_secret(&self) -> fluent_builders::RestoreSecret<C, M, R> {
        fluent_builders::RestoreSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RotateSecret` operation.
    ///
    /// See [`RotateSecret`](crate::client::fluent_builders::RotateSecret) for more information about the
    /// operation and its arguments.
    pub fn rotate_secret(&self) -> fluent_builders::RotateSecret<C, M, R> {
        fluent_builders::RotateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopReplicationToReplica` operation.
    ///
    /// See [`StopReplicationToReplica`](crate::client::fluent_builders::StopReplicationToReplica) for more information about the
    /// operation and its arguments.
    pub fn stop_replication_to_replica(
        &self,
    ) -> fluent_builders::StopReplicationToReplica<C, M, R> {
        fluent_builders::StopReplicationToReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecret` operation.
    ///
    /// See [`UpdateSecret`](crate::client::fluent_builders::UpdateSecret) for more information about the
    /// operation and its arguments.
    pub fn update_secret(&self) -> fluent_builders::UpdateSecret<C, M, R> {
        fluent_builders::UpdateSecret::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecretVersionStage` operation.
    ///
    /// See [`UpdateSecretVersionStage`](crate::client::fluent_builders::UpdateSecretVersionStage) for more information about the
    /// operation and its arguments.
    pub fn update_secret_version_stage(
        &self,
    ) -> fluent_builders::UpdateSecretVersionStage<C, M, R> {
        fluent_builders::UpdateSecretVersionStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidateResourcePolicy` operation.
    ///
    /// See [`ValidateResourcePolicy`](crate::client::fluent_builders::ValidateResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn validate_resource_policy(&self) -> fluent_builders::ValidateResourcePolicy<C, M, R> {
        fluent_builders::ValidateResourcePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelRotateSecret`.
    ///
    /// <p>Turns off automatic rotation, and if a rotation is currently in progress, cancels the rotation.</p>
    /// <p>To turn on automatic rotation again, call <code>RotateSecret</code>.</p> <note>
    /// <p>If you cancel a rotation in progress, it can leave the <code>VersionStage</code> labels in an unexpected state. Depending on the step of the rotation in progress, you might need to remove the staging label <code>AWSPENDING</code> from the partially created version, specified by the <code>VersionId</code> response value. We recommend you also evaluate the partially rotated new version to see if it should be deleted. You can delete a version by removing all staging labels from it.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelRotateSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_rotate_secret_input::Builder,
    }
    impl<C, M, R> CancelRotateSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelRotateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelRotateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelRotateSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelRotateSecretInputOperationOutputAlias,
                crate::output::CancelRotateSecretOutput,
                crate::error::CancelRotateSecretError,
                crate::input::CancelRotateSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecret`.
    ///
    /// <p>Creates a new secret. A <i>secret</i> is a set of credentials, such as a user name and password, that you store in an encrypted form in Secrets Manager. The secret also includes the connection information to access a database or other service, which Secrets Manager doesn't encrypt. A secret in Secrets Manager consists of both the protected secret data and the important information needed to manage the secret.</p>
    /// <p>For information about creating a secret in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html">Create a secret</a>.</p>
    /// <p>To create a secret, you can provide the secret value to be encrypted in either the <code>SecretString</code> parameter or the <code>SecretBinary</code> parameter, but not both. If you include <code>SecretString</code> or <code>SecretBinary</code> then Secrets Manager creates an initial secret version and automatically attaches the staging label <code>AWSCURRENT</code> to it.</p>
    /// <p>If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant delay in returning the result.</p>
    /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_secret_input::Builder,
    }
    impl<C, M, R> CreateSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecretInputOperationOutputAlias,
                crate::output::CreateSecretOutput,
                crate::error::CreateSecretError,
                crate::input::CreateSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new secret.</p>
        /// <p>The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-</p>
        /// <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new secret.</p>
        /// <p>The secret name can contain ASCII letters, numbers, and the following characters: /_+=.@-</p>
        /// <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <code>PutSecretValue</code> to create a new version.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates an initial version for the secret, and this parameter specifies the unique identifier for the new version. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <code>PutSecretValue</code> to create a new version.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret.</p>
        /// <p>To use a KMS key in a different account, use the key ARN or the alias ARN.</p>
        /// <p>If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code>. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.</p>
        /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt the secret value in the secret.</p>
        /// <p>To use a KMS key in a different account, use the key ARN or the alias ARN.</p>
        /// <p>If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code>. If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.</p>
        /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed KMS key. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>This parameter is not available in the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>This parameter is not available in the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.</p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text data to encrypt and store in this new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.</p>
        /// <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both.</p>
        /// <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that a Lambda rotation function can parse.</p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:</p>
        /// <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p>
        /// <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p>
        /// <p>If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a>.</p>
        /// <p>For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>. If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per secret: 50</p> </li>
        /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
        /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to attach to the secret. Each tag is a key and value pair of strings in a JSON text string, for example:</p>
        /// <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p>
        /// <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p>
        /// <p>If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a>.</p>
        /// <p>For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>. If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.</p>
        /// <p>The following restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per secret: 50</p> </li>
        /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Tag keys and values are case sensitive.</p> </li>
        /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
        /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AddReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_add_replica_regions`](Self::set_add_replica_regions).
        ///
        /// <p>A list of Regions and KMS keys to replicate secrets.</p>
        pub fn add_replica_regions(mut self, input: crate::model::ReplicaRegionType) -> Self {
            self.inner = self.inner.add_replica_regions(input);
            self
        }
        /// <p>A list of Regions and KMS keys to replicate secrets.</p>
        pub fn set_add_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaRegionType>>,
        ) -> Self {
            self.inner = self.inner.set_add_replica_regions(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn force_overwrite_replica_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.force_overwrite_replica_secret(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn set_force_overwrite_replica_secret(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_overwrite_replica_secret(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes the resource-based permission policy attached to the secret. To attach a policy to a secret, use <code>PutResourcePolicy</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to delete the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to delete the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecret`.
    ///
    /// <p>Deletes a secret and all of its versions. You can specify a recovery window during which you can restore the secret. The minimum recovery window is 7 days. The default recovery window is 30 days. Secrets Manager attaches a <code>DeletionDate</code> stamp to the secret that specifies the end of the recovery window. At the end of the recovery window, Secrets Manager deletes the secret permanently.</p>
    /// <p>For information about deleting a secret in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_delete-secret.html">https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_delete-secret.html</a>. </p>
    /// <p>Secrets Manager performs the permanent secret deletion at the end of the waiting period as a background task with low priority. There is no guarantee of a specific time after the recovery window for the permanent delete to occur.</p>
    /// <p>At any time before recovery window ends, you can use <code>RestoreSecret</code> to remove the <code>DeletionDate</code> and cancel the deletion of the secret.</p>
    /// <p>In a secret scheduled for deletion, you cannot access the encrypted secret value. To access that information, first cancel the deletion with <code>RestoreSecret</code> and then retrieve the information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_secret_input::Builder,
    }
    impl<C, M, R> DeleteSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecretInputOperationOutputAlias,
                crate::output::DeleteSecretOutput,
                crate::error::DeleteSecretError,
                crate::input::DeleteSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to delete.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to delete.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and <code>ForceDeleteWithoutRecovery</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        pub fn recovery_window_in_days(mut self, input: i64) -> Self {
            self.inner = self.inner.recovery_window_in_days(input);
            self
        }
        /// <p>The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and <code>ForceDeleteWithoutRecovery</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        pub fn set_recovery_window_in_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_recovery_window_in_days(input);
            self
        }
        /// <p>Specifies whether to delete the secret without any recovery window. You can't use both this parameter and <code>RecoveryWindowInDays</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        /// <p>Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.</p> <important>
        /// <p>Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p>
        /// </important>
        pub fn force_delete_without_recovery(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete_without_recovery(input);
            self
        }
        /// <p>Specifies whether to delete the secret without any recovery window. You can't use both this parameter and <code>RecoveryWindowInDays</code> in the same call. If you don't use either, then Secrets Manager defaults to a 30 day recovery window.</p>
        /// <p>Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.</p> <important>
        /// <p>Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p>
        /// </important>
        pub fn set_force_delete_without_recovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_delete_without_recovery(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecret`.
    ///
    /// <p>Retrieves the details of a secret. It does not include the encrypted secret value. Secrets Manager only returns fields that have a value in the response. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_secret_input::Builder,
    }
    impl<C, M, R> DescribeSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSecretInputOperationOutputAlias,
                crate::output::DescribeSecretOutput,
                crate::error::DescribeSecretError,
                crate::input::DescribeSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret. </p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret. </p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRandomPassword`.
    ///
    /// <p>Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRandomPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_random_password_input::Builder,
    }
    impl<C, M, R> GetRandomPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRandomPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRandomPasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRandomPasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRandomPasswordInputOperationOutputAlias,
                crate::output::GetRandomPasswordOutput,
                crate::error::GetRandomPasswordError,
                crate::input::GetRandomPasswordInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The length of the password. If you don't include this parameter, the default length is 32 characters.</p>
        pub fn password_length(mut self, input: i64) -> Self {
            self.inner = self.inner.password_length(input);
            self
        }
        /// <p>The length of the password. If you don't include this parameter, the default length is 32 characters.</p>
        pub fn set_password_length(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_password_length(input);
            self
        }
        /// <p>A string of the characters that you don't want in the password.</p>
        pub fn exclude_characters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclude_characters(input.into());
            self
        }
        /// <p>A string of the characters that you don't want in the password.</p>
        pub fn set_exclude_characters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclude_characters(input);
            self
        }
        /// <p>Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.</p>
        pub fn exclude_numbers(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_numbers(input);
            self
        }
        /// <p>Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.</p>
        pub fn set_exclude_numbers(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_numbers(input);
            self
        }
        /// <p>Specifies whether to exclude the following punctuation characters from the password: <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this switch, the password can contain punctuation.</p>
        pub fn exclude_punctuation(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_punctuation(input);
            self
        }
        /// <p>Specifies whether to exclude the following punctuation characters from the password: <code>! " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \ ] ^ _ ` { | } ~</code>. If you don't include this switch, the password can contain punctuation.</p>
        pub fn set_exclude_punctuation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_punctuation(input);
            self
        }
        /// <p>Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.</p>
        pub fn exclude_uppercase(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_uppercase(input);
            self
        }
        /// <p>Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.</p>
        pub fn set_exclude_uppercase(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_uppercase(input);
            self
        }
        /// <p>Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.</p>
        pub fn exclude_lowercase(mut self, input: bool) -> Self {
            self.inner = self.inner.exclude_lowercase(input);
            self
        }
        /// <p>Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.</p>
        pub fn set_exclude_lowercase(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_lowercase(input);
            self
        }
        /// <p>Specifies whether to include the space character. If you include this switch, the password can contain space characters.</p>
        pub fn include_space(mut self, input: bool) -> Self {
            self.inner = self.inner.include_space(input);
            self
        }
        /// <p>Specifies whether to include the space character. If you include this switch, the password can contain space characters.</p>
        pub fn set_include_space(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_space(input);
            self
        }
        /// <p>Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.</p>
        pub fn require_each_included_type(mut self, input: bool) -> Self {
            self.inner = self.inner.require_each_included_type(input);
            self
        }
        /// <p>Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.</p>
        pub fn set_require_each_included_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_each_included_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Retrieves the JSON text of the resource-based policy document attached to the secret. For more information about permissions policies attached to a secret, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html">Permissions policies attached to a secret</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl<C, M, R> GetResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePolicyInputOperationOutputAlias,
                crate::output::GetResourcePolicyOutput,
                crate::error::GetResourcePolicyError,
                crate::input::GetResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to retrieve the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to retrieve the attached resource-based policy for.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSecretValue`.
    ///
    /// <p>Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> from the specified version of a secret, whichever contains content.</p>
    /// <p>For information about retrieving the secret value in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html">Retrieve secrets</a>. </p>
    /// <p>To run this command, you must have <code>secretsmanager:GetSecretValue</code> permissions. If the secret is encrypted using a customer-managed key instead of the Amazon Web Services managed key <code>aws/secretsmanager</code>, then you also need <code>kms:Decrypt</code> permissions for that key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSecretValue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_secret_value_input::Builder,
    }
    impl<C, M, R> GetSecretValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSecretValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSecretValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSecretValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSecretValueInputOperationOutputAlias,
                crate::output::GetSecretValueOutput,
                crate::error::GetSecretValueError,
                crate::input::GetSecretValueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to retrieve.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to retrieve.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The unique identifier of the version of the secret to retrieve. If you include both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        /// <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The unique identifier of the version of the secret to retrieve. If you include both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, then Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        /// <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The staging label of the version of the secret to retrieve. </p>
        /// <p>Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        pub fn version_stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stage(input.into());
            self
        }
        /// <p>The staging label of the version of the secret to retrieve. </p>
        /// <p>Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version. If you don't specify either a <code>VersionStage</code> or <code>VersionId</code>, Secrets Manager returns the <code>AWSCURRENT</code> version.</p>
        pub fn set_version_stage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecrets`.
    ///
    /// <p>Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account. </p>
    /// <p>To list the versions of a secret, use <code>ListSecretVersionIds</code>.</p>
    /// <p>To get the secret value from <code>SecretString</code> or <code>SecretBinary</code>, call <code>GetSecretValue</code>.</p>
    /// <p>For information about finding secrets in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html">Enhanced search capabilities for secrets in Secrets Manager</a>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have <code>secretsmanager:ListSecrets</code> permissions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecrets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_secrets_input::Builder,
    }
    impl<C, M, R> ListSecrets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecrets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecretsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecretsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecretsInputOperationOutputAlias,
                crate::output::ListSecretsOutput,
                crate::error::ListSecretsError,
                crate::input::ListSecretsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecretsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecretsPaginator<C, M, R> {
            crate::paginator::ListSecretsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecrets</code> again with the value from <code>NextToken</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecrets</code> again with the value from <code>NextToken</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecrets</code> again with this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecrets</code> again with this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the list of secrets.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to apply to the list of secrets.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Lists secrets in the requested order. </p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>Lists secrets in the requested order. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecretVersionIds`.
    ///
    /// <p>Lists the versions for a secret. </p>
    /// <p>To list the secrets in the account, use <code>ListSecrets</code>.</p>
    /// <p>To get the secret value from <code>SecretString</code> or <code>SecretBinary</code>, call <code>GetSecretValue</code>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have <code>secretsmanager:ListSecretVersionIds</code> permissions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecretVersionIds<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_secret_version_ids_input::Builder,
    }
    impl<C, M, R> ListSecretVersionIds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecretVersionIds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecretVersionIdsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecretVersionIdsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecretVersionIdsInputOperationOutputAlias,
                crate::output::ListSecretVersionIdsOutput,
                crate::error::ListSecretVersionIdsError,
                crate::input::ListSecretVersionIdsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecretVersionIdsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecretVersionIdsPaginator<C, M, R> {
            crate::paginator::ListSecretVersionIdsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN or name of the secret whose versions you want to list.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret whose versions you want to list.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecretVersionIds</code> again with the value from <code>NextToken</code>. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of results to include in the response.</p>
        /// <p>If there are more results available, in the response, Secrets Manager includes <code>NextToken</code>. To get the next results, call <code>ListSecretVersionIds</code> again with the value from <code>NextToken</code>. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecretVersionIds</code> again with this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call <code>ListSecretVersionIds</code> again with this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager.</p>
        pub fn include_deprecated(mut self, input: bool) -> Self {
            self.inner = self.inner.include_deprecated(input);
            self
        }
        /// <p>Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager.</p>
        pub fn set_include_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deprecated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control for Secrets Manager</a> </p>
    /// <p>For information about attaching a policy in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html">Attach a permissions policy to a secret</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to attach the resource-based policy.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to attach the resource-based policy.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(input.into());
            self
        }
        /// <p>A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
        /// <p>Specifies whether to block resource-based policies that allow broad access to the secret. By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.inner = self.inner.block_public_policy(input);
            self
        }
        /// <p>Specifies whether to block resource-based policies that allow broad access to the secret. By default, Secrets Manager blocks policies that allow broad access, for example those that use a wildcard for the principal.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_block_public_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSecretValue`.
    ///
    /// <p>Creates a new version with a new encrypted secret value and attaches it to the secret. The version can contain a new <code>SecretString</code> value or a new <code>SecretBinary</code> value. </p>
    /// <p>We recommend you avoid calling <code>PutSecretValue</code> at a sustained rate of more than once every 10 minutes. When you update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you call <code>PutSecretValue</code> more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p>
    /// <p>You can specify the staging labels to attach to the new version in <code>VersionStages</code>. If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version. If this operation creates the first version for the secret, then Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to it .</p>
    /// <p>If this operation moves the staging label <code>AWSCURRENT</code> from another version to this version, then Secrets Manager also automatically moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
    /// <p>This operation is idempotent. If a version with a <code>VersionId</code> with the same value as the <code>ClientRequestToken</code> parameter already exists, and you specify the same secret data, the operation succeeds but does nothing. However, if the secret data is different, then the operation fails because you can't modify an existing version; you can only create new ones.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSecretValue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_secret_value_input::Builder,
    }
    impl<C, M, R> PutSecretValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSecretValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSecretValueOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSecretValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSecretValueInputOperationOutputAlias,
                crate::output::PutSecretValueOutput,
                crate::error::PutSecretValueError,
                crate::input::PutSecretValueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to add a new version to.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        /// <p>If the secret doesn't already exist, use <code>CreateSecret</code> instead.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to add a new version to.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        /// <p>If the secret doesn't already exist, use <code>CreateSecret</code> instead.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A unique identifier for the new version of the secret. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty because they generate a random UUID for you. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored. The operation is idempotent. </p> </li>
        /// <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the new version of the secret. </p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty because they generate a random UUID for you. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p>
        /// </note>
        /// <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        /// <ul>
        /// <li> <p>If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new version of the secret is created. </p> </li>
        /// <li> <p>If a version with this value already exists and that version's <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored. The operation is idempotent. </p> </li>
        /// <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.</p> </li>
        /// </ul>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>You can't access this value from the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>You can't access this value from the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text to encrypt and store in the new version of the secret. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>We recommend you create the secret string as JSON key/value pairs, as shown in the example.</p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text to encrypt and store in the new version of the secret. </p>
        /// <p>You must include <code>SecretBinary</code> or <code>SecretString</code>, but not both.</p>
        /// <p>We recommend you create the secret string as JSON key/value pairs, as shown in the example.</p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
        /// Appends an item to `VersionStages`.
        ///
        /// To override the contents of this collection use [`set_version_stages`](Self::set_version_stages).
        ///
        /// <p>A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.</p>
        /// <p>If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify <code>AWSCURRENT</code>, and it is already attached to another version, then Secrets Manager also moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
        /// <p>If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version.</p>
        pub fn version_stages(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stages(input.into());
            self
        }
        /// <p>A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.</p>
        /// <p>If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify <code>AWSCURRENT</code>, and it is already attached to another version, then Secrets Manager also moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
        /// <p>If you don't include <code>VersionStages</code>, then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this version.</p>
        pub fn set_version_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_stages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRegionsFromReplication`.
    ///
    /// <p>For a secret that is replicated to other Regions, deletes the secret replicas from the Regions you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveRegionsFromReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_regions_from_replication_input::Builder,
    }
    impl<C, M, R> RemoveRegionsFromReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveRegionsFromReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRegionsFromReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRegionsFromReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveRegionsFromReplicationInputOperationOutputAlias,
                crate::output::RemoveRegionsFromReplicationOutput,
                crate::error::RemoveRegionsFromReplicationError,
                crate::input::RemoveRegionsFromReplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `RemoveReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_remove_replica_regions`](Self::set_remove_replica_regions).
        ///
        /// <p>The Regions of the replicas to remove.</p>
        pub fn remove_replica_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_replica_regions(input.into());
            self
        }
        /// <p>The Regions of the replicas to remove.</p>
        pub fn set_remove_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_replica_regions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReplicateSecretToRegions`.
    ///
    /// <p>Replicates the secret to a new Regions. See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html">Multi-Region secrets</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReplicateSecretToRegions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::replicate_secret_to_regions_input::Builder,
    }
    impl<C, M, R> ReplicateSecretToRegions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReplicateSecretToRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReplicateSecretToRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ReplicateSecretToRegionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReplicateSecretToRegionsInputOperationOutputAlias,
                crate::output::ReplicateSecretToRegionsOutput,
                crate::error::ReplicateSecretToRegionsError,
                crate::input::ReplicateSecretToRegionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to replicate.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to replicate.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `AddReplicaRegions`.
        ///
        /// To override the contents of this collection use [`set_add_replica_regions`](Self::set_add_replica_regions).
        ///
        /// <p>A list of Regions in which to replicate the secret.</p>
        pub fn add_replica_regions(mut self, input: crate::model::ReplicaRegionType) -> Self {
            self.inner = self.inner.add_replica_regions(input);
            self
        }
        /// <p>A list of Regions in which to replicate the secret.</p>
        pub fn set_add_replica_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaRegionType>>,
        ) -> Self {
            self.inner = self.inner.set_add_replica_regions(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn force_overwrite_replica_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.force_overwrite_replica_secret(input);
            self
        }
        /// <p>Specifies whether to overwrite a secret with the same name in the destination Region.</p>
        pub fn set_force_overwrite_replica_secret(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_overwrite_replica_secret(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreSecret`.
    ///
    /// <p>Cancels the scheduled deletion of a secret by removing the <code>DeletedDate</code> time stamp. You can access a secret again after it has been restored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_secret_input::Builder,
    }
    impl<C, M, R> RestoreSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreSecretInputOperationOutputAlias,
                crate::output::RestoreSecretOutput,
                crate::error::RestoreSecretError,
                crate::input::RestoreSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to restore.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to restore.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateSecret`.
    ///
    /// <p>Configures and starts the asynchronous process of rotating the secret.</p>
    /// <p>If you include the configuration parameters, the operation sets the values for the secret and then immediately starts a rotation. If you don't include the configuration parameters, the operation starts a rotation with the values already stored in the secret. For more information about rotation, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html">Rotate secrets</a>.</p>
    /// <p>To configure rotation, you include the ARN of an Amazon Web Services Lambda function and the schedule for the rotation. The Lambda rotation function creates a new version of the secret and creates or updates the credentials on the database or service to match. After testing the new credentials, the function marks the new secret version with the staging label <code>AWSCURRENT</code>. Then anyone who retrieves the secret gets the new version. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation works</a>.</p>
    /// <p>When rotation is successful, the <code>AWSPENDING</code> staging label might be attached to the same version as the <code>AWSCURRENT</code> version, or it might not be attached to any version.</p>
    /// <p>If the <code>AWSPENDING</code> staging label is present but not attached to the same version as <code>AWSCURRENT</code>, then any later invocation of <code>RotateSecret</code> assumes that a previous rotation request is still in progress and returns an error.</p>
    /// <p>To run this command, you must have <code>secretsmanager:RotateSecret</code> permissions and <code>lambda:InvokeFunction</code> permissions on the function specified in the secret's metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RotateSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rotate_secret_input::Builder,
    }
    impl<C, M, R> RotateSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RotateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RotateSecretInputOperationOutputAlias,
                crate::output::RotateSecretOutput,
                crate::error::RotateSecretError,
                crate::input::RotateSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret to rotate.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret to rotate.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A unique identifier for the new version of the secret that helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during rotation. This value becomes the <code>VersionId</code> of the new version.</p>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p>
        /// <p>You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique identifier for the new version of the secret that helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during rotation. This value becomes the <code>VersionId</code> of the new version.</p>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p>
        /// <p>You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Lambda rotation function that can rotate the secret.</p>
        pub fn rotation_lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rotation_lambda_arn(input.into());
            self
        }
        /// <p>The ARN of the Lambda rotation function that can rotate the secret.</p>
        pub fn set_rotation_lambda_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rotation_lambda_arn(input);
            self
        }
        /// <p>A structure that defines the rotation configuration for this secret.</p>
        pub fn rotation_rules(mut self, input: crate::model::RotationRulesType) -> Self {
            self.inner = self.inner.rotation_rules(input);
            self
        }
        /// <p>A structure that defines the rotation configuration for this secret.</p>
        pub fn set_rotation_rules(
            mut self,
            input: std::option::Option<crate::model::RotationRulesType>,
        ) -> Self {
            self.inner = self.inner.set_rotation_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopReplicationToReplica`.
    ///
    /// <p>Removes the link between the replica secret and the primary secret and promotes the replica to a primary secret in the replica Region.</p>
    /// <p>You must call this operation from the Region in which you want to promote the replica to a primary secret.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopReplicationToReplica<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_replication_to_replica_input::Builder,
    }
    impl<C, M, R> StopReplicationToReplica<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopReplicationToReplica`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopReplicationToReplicaOutput,
            aws_smithy_http::result::SdkError<crate::error::StopReplicationToReplicaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopReplicationToReplicaInputOperationOutputAlias,
                crate::output::StopReplicationToReplicaOutput,
                crate::error::StopReplicationToReplicaError,
                crate::input::StopReplicationToReplicaInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the primary secret. </p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN of the primary secret. </p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They are not associated with specific versions of the secret. This operation appends tags to the existing list of tags.</p>
    /// <p>The following restrictions apply to tags:</p>
    /// <ul>
    /// <li> <p>Maximum number of tags per secret: 50</p> </li>
    /// <li> <p>Maximum key length: 127 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 255 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Tag keys and values are case sensitive.</p> </li>
    /// <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li>
    /// <li> <p>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li>
    /// </ul> <important>
    /// <p>If you use tags as part of your security strategy, then adding or removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the secret to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The identifier for the secret to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the secret as a JSON text string argument. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the secret as a JSON text string argument. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes specific tags from a secret.</p>
    /// <p>This operation is idempotent. If a requested tag is not attached to the secret, no error is returned and the secret metadata is unchanged.</p> <important>
    /// <p>If you use tags as part of your security strategy, then removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.</p>
        /// <p>This parameter requires a JSON text string argument.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.</p>
        /// <p>This parameter requires a JSON text string argument.</p>
        /// <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecret`.
    ///
    /// <p>Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can also use <code>PutSecretValue</code>.</p>
    /// <p>To change the rotation configuration of a secret, use <code>RotateSecret</code> instead.</p>
    /// <p>We recommend you avoid calling <code>UpdateSecret</code> at a sustained rate of more than once every 10 minutes. When you call <code>UpdateSecret</code> to update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you update the secret value more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p>
    /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code> to create a new secret version, Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to the new version. </p>
    /// <p>If you call this operation with a <code>VersionId</code> that matches an existing version's <code>ClientRequestToken</code>, the operation results in an error. You can't modify an existing version, you can only create a new version. To remove a version, remove all staging labels from it. See <code>UpdateSecretVersionStage</code>.</p>
    /// <p>If you don't specify an KMS encryption key, Secrets Manager uses the Amazon Web Services managed key <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant delay in returning the result. </p>
    /// <p>If the secret is in a different Amazon Web Services account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed key. </p>
    /// <p>To run this command, you must have <code>secretsmanager:UpdateSecret</code> permissions. If you use a customer managed key, you must also have <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permissions .</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecret<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_secret_input::Builder,
    }
    impl<C, M, R> UpdateSecret<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSecret`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecretOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecretError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSecretInputOperationOutputAlias,
                crate::output::UpdateSecretOutput,
                crate::error::UpdateSecretError,
                crate::input::UpdateSecretInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or name of the secret.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.</p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.</p> <note>
        /// <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p>
        /// </note>
        /// <p>This value becomes the <code>VersionId</code> of the new version.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or <code>AWSPREVIOUS</code>. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>.</p> <important>
        /// <p>You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.</p>
        /// </important>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or <code>AWSPREVIOUS</code>. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>.</p> <important>
        /// <p>You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.</p>
        /// </important>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.</p>
        /// <p>You can't access this parameter in the Secrets Manager console.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.secret_binary(input);
            self
        }
        /// <p>The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.</p>
        /// <p>You can't access this parameter in the Secrets Manager console.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_secret_binary(input);
            self
        }
        /// <p>The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. </p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_string(input.into());
            self
        }
        /// <p>The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value. </p>
        /// <p>Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. </p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_secret_string(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecretVersionStage`.
    ///
    /// <p>Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a version as it progresses through the secret rotation process. Each staging label can be attached to only one version at a time. To add a staging label to a version when it is already attached to another version, Secrets Manager first removes it from the other version first and then attaches it to this one. For more information about versions and staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts: Version</a>. </p>
    /// <p>The staging labels that you specify in the <code>VersionStage</code> parameter are added to the existing list of staging labels for the version. </p>
    /// <p>You can move the <code>AWSCURRENT</code> staging label to this version by including it in this call.</p> <note>
    /// <p>Whenever you move <code>AWSCURRENT</code>, Secrets Manager automatically moves the label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p>
    /// </note>
    /// <p>If this action results in the last label being removed from a version, then the version is considered to be 'deprecated' and can be deleted by Secrets Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecretVersionStage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_secret_version_stage_input::Builder,
    }
    impl<C, M, R> UpdateSecretVersionStage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSecretVersionStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecretVersionStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecretVersionStageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSecretVersionStageInputOperationOutputAlias,
                crate::output::UpdateSecretVersionStageOutput,
                crate::error::UpdateSecretVersionStageError,
                crate::input::UpdateSecretVersionStageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN or the name of the secret with the version and staging labelsto modify.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>The ARN or the name of the secret with the version and staging labelsto modify.</p>
        /// <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>The staging label to add to this version.</p>
        pub fn version_stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_stage(input.into());
            self
        }
        /// <p>The staging label to add to this version.</p>
        pub fn set_version_stage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_stage(input);
            self
        }
        /// <p>The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>
        pub fn remove_from_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_from_version_id(input.into());
            self
        }
        /// <p>The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>
        pub fn set_remove_from_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remove_from_version_id(input);
            self
        }
        /// <p>The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.</p>
        /// <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>
        pub fn move_to_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.move_to_version_id(input.into());
            self
        }
        /// <p>The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.</p>
        /// <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>
        pub fn set_move_to_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_move_to_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateResourcePolicy`.
    ///
    /// <p>Validates that a resource policy does not grant a wide range of principals access to your secret. A resource-based policy is optional for secrets.</p>
    /// <p>The API performs three checks when validating the policy:</p>
    /// <ul>
    /// <li> <p>Sends a call to <a href="https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/">Zelkova</a>, an automated reasoning engine, to ensure your resource policy does not allow broad access to your secret, for example policies that use a wildcard for the principal.</p> </li>
    /// <li> <p>Checks for correct syntax in a policy.</p> </li>
    /// <li> <p>Verifies the policy does not lock out a caller.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidateResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_resource_policy_input::Builder,
    }
    impl<C, M, R> ValidateResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidateResourcePolicyInputOperationOutputAlias,
                crate::output::ValidateResourcePolicyOutput,
                crate::error::ValidateResourcePolicyError,
                crate::input::ValidateResourcePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This field is reserved for internal use.</p>
        pub fn secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_id(input.into());
            self
        }
        /// <p>This field is reserved for internal use.</p>
        pub fn set_secret_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_id(input);
            self
        }
        /// <p>A JSON-formatted string that contains an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(input.into());
            self
        }
        /// <p>A JSON-formatted string that contains an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For example policies, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html">Permissions policy examples</a>.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
