// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateResourcePolicyOutput {
    /// <p>Returns a message stating that your Reource Policy passed validation. </p>
    pub policy_validation_passed: bool,
    /// <p>Returns an error message if your policy doesn't pass validatation.</p>
    pub validation_errors: std::option::Option<std::vec::Vec<crate::model::ValidationErrorsEntry>>,
}
impl std::fmt::Debug for ValidateResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateResourcePolicyOutput");
        formatter.field("policy_validation_passed", &self.policy_validation_passed);
        formatter.field("validation_errors", &self.validation_errors);
        formatter.finish()
    }
}
/// See [`ValidateResourcePolicyOutput`](crate::output::ValidateResourcePolicyOutput)
pub mod validate_resource_policy_output {
    /// A builder for [`ValidateResourcePolicyOutput`](crate::output::ValidateResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_validation_passed: std::option::Option<bool>,
        pub(crate) validation_errors:
            std::option::Option<std::vec::Vec<crate::model::ValidationErrorsEntry>>,
    }
    impl Builder {
        /// <p>Returns a message stating that your Reource Policy passed validation. </p>
        pub fn policy_validation_passed(mut self, input: bool) -> Self {
            self.policy_validation_passed = Some(input);
            self
        }
        /// <p>Returns a message stating that your Reource Policy passed validation. </p>
        pub fn set_policy_validation_passed(mut self, input: std::option::Option<bool>) -> Self {
            self.policy_validation_passed = input;
            self
        }
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// <p>Returns an error message if your policy doesn't pass validatation.</p>
        pub fn validation_errors(
            mut self,
            input: impl Into<crate::model::ValidationErrorsEntry>,
        ) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input.into());
            self.validation_errors = Some(v);
            self
        }
        /// <p>Returns an error message if your policy doesn't pass validatation.</p>
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationErrorsEntry>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateResourcePolicyOutput`](crate::output::ValidateResourcePolicyOutput)
        pub fn build(self) -> crate::output::ValidateResourcePolicyOutput {
            crate::output::ValidateResourcePolicyOutput {
                policy_validation_passed: self.policy_validation_passed.unwrap_or_default(),
                validation_errors: self.validation_errors,
            }
        }
    }
}
impl ValidateResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`ValidateResourcePolicyOutput`](crate::output::ValidateResourcePolicyOutput)
    pub fn builder() -> crate::output::validate_resource_policy_output::Builder {
        crate::output::validate_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSecretVersionStageOutput {
    /// <p>The ARN of the secret with the modified staging label.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret with the modified staging label.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSecretVersionStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSecretVersionStageOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateSecretVersionStageOutput`](crate::output::UpdateSecretVersionStageOutput)
pub mod update_secret_version_stage_output {
    /// A builder for [`UpdateSecretVersionStageOutput`](crate::output::UpdateSecretVersionStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret with the modified staging label.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret with the modified staging label.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret with the modified staging label.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret with the modified staging label.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSecretVersionStageOutput`](crate::output::UpdateSecretVersionStageOutput)
        pub fn build(self) -> crate::output::UpdateSecretVersionStageOutput {
            crate::output::UpdateSecretVersionStageOutput {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl UpdateSecretVersionStageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSecretVersionStageOutput`](crate::output::UpdateSecretVersionStageOutput)
    pub fn builder() -> crate::output::update_secret_version_stage_output::Builder {
        crate::output::update_secret_version_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSecretOutput {
    /// <p>The ARN of the secret that was updated.</p>
    /// <note>
    /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
    /// you initially create a secret. This affects only the ARN and not the actual friendly name.
    /// This ensures that if you create a new secret with the same name as an old secret that you
    /// previously deleted, then users with access to the old secret <i>don't</i>
    /// automatically get access to the new secret because the ARNs are different.</p>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret that was updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If a new version of the secret was created by this operation, then <code>VersionId</code>
    /// contains the unique identifier of the new version.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`UpdateSecretOutput`](crate::output::UpdateSecretOutput)
pub mod update_secret_output {
    /// A builder for [`UpdateSecretOutput`](crate::output::UpdateSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret that was updated.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that was updated.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret that was updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret that was updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If a new version of the secret was created by this operation, then <code>VersionId</code>
        /// contains the unique identifier of the new version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>If a new version of the secret was created by this operation, then <code>VersionId</code>
        /// contains the unique identifier of the new version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSecretOutput`](crate::output::UpdateSecretOutput)
        pub fn build(self) -> crate::output::UpdateSecretOutput {
            crate::output::UpdateSecretOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
            }
        }
    }
}
impl UpdateSecretOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSecretOutput`](crate::output::UpdateSecretOutput)
    pub fn builder() -> crate::output::update_secret_output::Builder {
        crate::output::update_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopReplicationToReplicaOutput {
    /// <p>Response <code>StopReplicationToReplica</code> of a secret, based on the <code>ARN,</code>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopReplicationToReplicaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopReplicationToReplicaOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`StopReplicationToReplicaOutput`](crate::output::StopReplicationToReplicaOutput)
pub mod stop_replication_to_replica_output {
    /// A builder for [`StopReplicationToReplicaOutput`](crate::output::StopReplicationToReplicaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Response <code>StopReplicationToReplica</code> of a secret, based on the <code>ARN,</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Response <code>StopReplicationToReplica</code> of a secret, based on the <code>ARN,</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopReplicationToReplicaOutput`](crate::output::StopReplicationToReplicaOutput)
        pub fn build(self) -> crate::output::StopReplicationToReplicaOutput {
            crate::output::StopReplicationToReplicaOutput { arn: self.arn }
        }
    }
}
impl StopReplicationToReplicaOutput {
    /// Creates a new builder-style object to manufacture [`StopReplicationToReplicaOutput`](crate::output::StopReplicationToReplicaOutput)
    pub fn builder() -> crate::output::stop_replication_to_replica_output::Builder {
        crate::output::stop_replication_to_replica_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RotateSecretOutput {
    /// <p>The ARN of the secret.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the new version of the secret created by the rotation started by this
    /// request.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RotateSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RotateSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`RotateSecretOutput`](crate::output::RotateSecretOutput)
pub mod rotate_secret_output {
    /// A builder for [`RotateSecretOutput`](crate::output::RotateSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the new version of the secret created by the rotation started by this
        /// request.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of the new version of the secret created by the rotation started by this
        /// request.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RotateSecretOutput`](crate::output::RotateSecretOutput)
        pub fn build(self) -> crate::output::RotateSecretOutput {
            crate::output::RotateSecretOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
            }
        }
    }
}
impl RotateSecretOutput {
    /// Creates a new builder-style object to manufacture [`RotateSecretOutput`](crate::output::RotateSecretOutput)
    pub fn builder() -> crate::output::rotate_secret_output::Builder {
        crate::output::rotate_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreSecretOutput {
    /// <p>The ARN of the secret that was restored.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret that was restored.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RestoreSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RestoreSecretOutput`](crate::output::RestoreSecretOutput)
pub mod restore_secret_output {
    /// A builder for [`RestoreSecretOutput`](crate::output::RestoreSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret that was restored.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that was restored.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret that was restored.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret that was restored.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreSecretOutput`](crate::output::RestoreSecretOutput)
        pub fn build(self) -> crate::output::RestoreSecretOutput {
            crate::output::RestoreSecretOutput {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl RestoreSecretOutput {
    /// Creates a new builder-style object to manufacture [`RestoreSecretOutput`](crate::output::RestoreSecretOutput)
    pub fn builder() -> crate::output::restore_secret_output::Builder {
        crate::output::restore_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicateSecretToRegionsOutput {
    /// <p>Replicate a secret based on the <code>ReplicaRegionType</code>> consisting of a
    /// Region(required) and a KMSKeyId (optional) which can be the ARN, KeyID, or Alias. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Describes the secret replication status as <code>PENDING</code>, <code>SUCCESS</code> or <code>FAIL</code>.</p>
    pub replication_status: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
}
impl std::fmt::Debug for ReplicateSecretToRegionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicateSecretToRegionsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("replication_status", &self.replication_status);
        formatter.finish()
    }
}
/// See [`ReplicateSecretToRegionsOutput`](crate::output::ReplicateSecretToRegionsOutput)
pub mod replicate_secret_to_regions_output {
    /// A builder for [`ReplicateSecretToRegionsOutput`](crate::output::ReplicateSecretToRegionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) replication_status:
            std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
    }
    impl Builder {
        /// <p>Replicate a secret based on the <code>ReplicaRegionType</code>> consisting of a
        /// Region(required) and a KMSKeyId (optional) which can be the ARN, KeyID, or Alias. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Replicate a secret based on the <code>ReplicaRegionType</code>> consisting of a
        /// Region(required) and a KMSKeyId (optional) which can be the ARN, KeyID, or Alias. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `replication_status`.
        ///
        /// To override the contents of this collection use [`set_replication_status`](Self::set_replication_status).
        ///
        /// <p>Describes the secret replication status as <code>PENDING</code>, <code>SUCCESS</code> or <code>FAIL</code>.</p>
        pub fn replication_status(
            mut self,
            input: impl Into<crate::model::ReplicationStatusType>,
        ) -> Self {
            let mut v = self.replication_status.unwrap_or_default();
            v.push(input.into());
            self.replication_status = Some(v);
            self
        }
        /// <p>Describes the secret replication status as <code>PENDING</code>, <code>SUCCESS</code> or <code>FAIL</code>.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicateSecretToRegionsOutput`](crate::output::ReplicateSecretToRegionsOutput)
        pub fn build(self) -> crate::output::ReplicateSecretToRegionsOutput {
            crate::output::ReplicateSecretToRegionsOutput {
                arn: self.arn,
                replication_status: self.replication_status,
            }
        }
    }
}
impl ReplicateSecretToRegionsOutput {
    /// Creates a new builder-style object to manufacture [`ReplicateSecretToRegionsOutput`](crate::output::ReplicateSecretToRegionsOutput)
    pub fn builder() -> crate::output::replicate_secret_to_regions_output::Builder {
        crate::output::replicate_secret_to_regions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRegionsFromReplicationOutput {
    /// <p>The secret <code>ARN</code> removed from replication regions.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Describes the remaining replication status after you remove regions from the replication list.</p>
    pub replication_status: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
}
impl std::fmt::Debug for RemoveRegionsFromReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRegionsFromReplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("replication_status", &self.replication_status);
        formatter.finish()
    }
}
/// See [`RemoveRegionsFromReplicationOutput`](crate::output::RemoveRegionsFromReplicationOutput)
pub mod remove_regions_from_replication_output {
    /// A builder for [`RemoveRegionsFromReplicationOutput`](crate::output::RemoveRegionsFromReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) replication_status:
            std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
    }
    impl Builder {
        /// <p>The secret <code>ARN</code> removed from replication regions.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The secret <code>ARN</code> removed from replication regions.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `replication_status`.
        ///
        /// To override the contents of this collection use [`set_replication_status`](Self::set_replication_status).
        ///
        /// <p>Describes the remaining replication status after you remove regions from the replication list.</p>
        pub fn replication_status(
            mut self,
            input: impl Into<crate::model::ReplicationStatusType>,
        ) -> Self {
            let mut v = self.replication_status.unwrap_or_default();
            v.push(input.into());
            self.replication_status = Some(v);
            self
        }
        /// <p>Describes the remaining replication status after you remove regions from the replication list.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveRegionsFromReplicationOutput`](crate::output::RemoveRegionsFromReplicationOutput)
        pub fn build(self) -> crate::output::RemoveRegionsFromReplicationOutput {
            crate::output::RemoveRegionsFromReplicationOutput {
                arn: self.arn,
                replication_status: self.replication_status,
            }
        }
    }
}
impl RemoveRegionsFromReplicationOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRegionsFromReplicationOutput`](crate::output::RemoveRegionsFromReplicationOutput)
    pub fn builder() -> crate::output::remove_regions_from_replication_output::Builder {
        crate::output::remove_regions_from_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSecretValueOutput {
    /// <p>The Amazon Resource Name (ARN) for the secret for which you just created a version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret for which you just created or updated a version.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the version of the secret you just created or updated.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The list of staging labels that are currently attached to this version of the secret.
    /// Staging labels are used to track a version as it progresses through the secret rotation
    /// process.</p>
    pub version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PutSecretValueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSecretValueOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.field("version_stages", &self.version_stages);
        formatter.finish()
    }
}
/// See [`PutSecretValueOutput`](crate::output::PutSecretValueOutput)
pub mod put_secret_value_output {
    /// A builder for [`PutSecretValueOutput`](crate::output::PutSecretValueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the secret for which you just created a version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the secret for which you just created a version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret for which you just created or updated a version.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret for which you just created or updated a version.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of the version of the secret you just created or updated.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the version of the secret you just created or updated.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `version_stages`.
        ///
        /// To override the contents of this collection use [`set_version_stages`](Self::set_version_stages).
        ///
        /// <p>The list of staging labels that are currently attached to this version of the secret.
        /// Staging labels are used to track a version as it progresses through the secret rotation
        /// process.</p>
        pub fn version_stages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.version_stages.unwrap_or_default();
            v.push(input.into());
            self.version_stages = Some(v);
            self
        }
        /// <p>The list of staging labels that are currently attached to this version of the secret.
        /// Staging labels are used to track a version as it progresses through the secret rotation
        /// process.</p>
        pub fn set_version_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.version_stages = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSecretValueOutput`](crate::output::PutSecretValueOutput)
        pub fn build(self) -> crate::output::PutSecretValueOutput {
            crate::output::PutSecretValueOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
                version_stages: self.version_stages,
            }
        }
    }
}
impl PutSecretValueOutput {
    /// Creates a new builder-style object to manufacture [`PutSecretValueOutput`](crate::output::PutSecretValueOutput)
    pub fn builder() -> crate::output::put_secret_value_output::Builder {
        crate::output::put_secret_value_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {
    /// <p>The ARN of the secret retrieved by the resource-based policy.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret retrieved by the resource-based policy.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret retrieved by the resource-based policy.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret retrieved by the resource-based policy.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret retrieved by the resource-based policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret retrieved by the resource-based policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecretVersionIdsOutput {
    /// <p>The list of the currently available versions of the specified secret.</p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::SecretVersionsListEntry>>,
    /// <p>If present in the response, this value indicates that
    /// there's more output available than included in the current response. This can
    /// occur even when the response includes no values at all, such as when you ask for a filtered view
    /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
    /// subsequent call to the operation to continue processing and get the next part of the output. You
    /// should repeat this until the <code>NextToken</code> response element comes back empty (as
    /// <code>null</code>).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the secret.</p>
    /// <note>
    /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
    /// you initially create a secret. This affects only the ARN and not the actual friendly name.
    /// This ensures that if you create a new secret with the same name as an old secret that you
    /// previously deleted, then users with access to the old secret <i>don't</i>
    /// automatically get access to the new secret because the ARNs are different.</p>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSecretVersionIdsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecretVersionIdsOutput");
        formatter.field("versions", &self.versions);
        formatter.field("next_token", &self.next_token);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ListSecretVersionIdsOutput`](crate::output::ListSecretVersionIdsOutput)
pub mod list_secret_version_ids_output {
    /// A builder for [`ListSecretVersionIdsOutput`](crate::output::ListSecretVersionIdsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) versions:
            std::option::Option<std::vec::Vec<crate::model::SecretVersionsListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>The list of the currently available versions of the specified secret.</p>
        pub fn versions(mut self, input: impl Into<crate::model::SecretVersionsListEntry>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>The list of the currently available versions of the specified secret.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecretVersionsListEntry>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>If present in the response, this value indicates that
        /// there's more output available than included in the current response. This can
        /// occur even when the response includes no values at all, such as when you ask for a filtered view
        /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
        /// subsequent call to the operation to continue processing and get the next part of the output. You
        /// should repeat this until the <code>NextToken</code> response element comes back empty (as
        /// <code>null</code>).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present in the response, this value indicates that
        /// there's more output available than included in the current response. This can
        /// occur even when the response includes no values at all, such as when you ask for a filtered view
        /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
        /// subsequent call to the operation to continue processing and get the next part of the output. You
        /// should repeat this until the <code>NextToken</code> response element comes back empty (as
        /// <code>null</code>).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the secret.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the secret.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecretVersionIdsOutput`](crate::output::ListSecretVersionIdsOutput)
        pub fn build(self) -> crate::output::ListSecretVersionIdsOutput {
            crate::output::ListSecretVersionIdsOutput {
                versions: self.versions,
                next_token: self.next_token,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl ListSecretVersionIdsOutput {
    /// Creates a new builder-style object to manufacture [`ListSecretVersionIdsOutput`](crate::output::ListSecretVersionIdsOutput)
    pub fn builder() -> crate::output::list_secret_version_ids_output::Builder {
        crate::output::list_secret_version_ids_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecretsOutput {
    /// <p>A list of the secrets in the account.</p>
    pub secret_list: std::option::Option<std::vec::Vec<crate::model::SecretListEntry>>,
    /// <p>If present in the response, this value indicates that
    /// there's more output available than included in the current response. This can
    /// occur even when the response includes no values at all, such as when you ask for a filtered view
    /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
    /// subsequent call to the operation to continue processing and get the next part of the output. You
    /// should repeat this until the <code>NextToken</code> response element comes back empty (as
    /// <code>null</code>).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSecretsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecretsOutput");
        formatter.field("secret_list", &self.secret_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSecretsOutput`](crate::output::ListSecretsOutput)
pub mod list_secrets_output {
    /// A builder for [`ListSecretsOutput`](crate::output::ListSecretsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_list: std::option::Option<std::vec::Vec<crate::model::SecretListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `secret_list`.
        ///
        /// To override the contents of this collection use [`set_secret_list`](Self::set_secret_list).
        ///
        /// <p>A list of the secrets in the account.</p>
        pub fn secret_list(mut self, input: impl Into<crate::model::SecretListEntry>) -> Self {
            let mut v = self.secret_list.unwrap_or_default();
            v.push(input.into());
            self.secret_list = Some(v);
            self
        }
        /// <p>A list of the secrets in the account.</p>
        pub fn set_secret_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecretListEntry>>,
        ) -> Self {
            self.secret_list = input;
            self
        }
        /// <p>If present in the response, this value indicates that
        /// there's more output available than included in the current response. This can
        /// occur even when the response includes no values at all, such as when you ask for a filtered view
        /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
        /// subsequent call to the operation to continue processing and get the next part of the output. You
        /// should repeat this until the <code>NextToken</code> response element comes back empty (as
        /// <code>null</code>).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present in the response, this value indicates that
        /// there's more output available than included in the current response. This can
        /// occur even when the response includes no values at all, such as when you ask for a filtered view
        /// of a very long list. Use this value in the <code>NextToken</code> request parameter in a
        /// subsequent call to the operation to continue processing and get the next part of the output. You
        /// should repeat this until the <code>NextToken</code> response element comes back empty (as
        /// <code>null</code>).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecretsOutput`](crate::output::ListSecretsOutput)
        pub fn build(self) -> crate::output::ListSecretsOutput {
            crate::output::ListSecretsOutput {
                secret_list: self.secret_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSecretsOutput {
    /// Creates a new builder-style object to manufacture [`ListSecretsOutput`](crate::output::ListSecretsOutput)
    pub fn builder() -> crate::output::list_secrets_output::Builder {
        crate::output::list_secrets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSecretValueOutput {
    /// <p>The ARN of the secret.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of this version of the secret.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The decrypted part of the protected secret information that was originally provided as
    /// binary data in the form of a byte array. The response parameter represents the binary data as
    /// a <a href="https://tools.ietf.org/html/rfc4648#section-4">base64-encoded</a>
    /// string.</p>
    /// <p>This parameter is not used if the secret is created by the Secrets Manager console.</p>
    /// <p>If you store custom information in this field of the secret, then you must code your
    /// Lambda rotation function to parse and interpret whatever you store in the
    /// <code>SecretString</code> or <code>SecretBinary</code> fields.</p>
    pub secret_binary: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The decrypted part of the protected secret information that was originally provided as a
    /// string.</p>
    /// <p>If you create this secret by using the Secrets Manager console then only the
    /// <code>SecretString</code> parameter contains data. Secrets Manager stores the information as a
    /// JSON structure of key/value pairs that the Lambda rotation function knows how to parse.</p>
    /// <p>If you store custom information in the secret by using the <a>CreateSecret</a>,
    /// <a>UpdateSecret</a>, or <a>PutSecretValue</a> API operations instead
    /// of the Secrets Manager console, or by using the <b>Other secret type</b> in
    /// the console, then you must code your Lambda rotation function to parse and interpret those
    /// values.</p>
    pub secret_string: std::option::Option<std::string::String>,
    /// <p>A list of all of the staging labels currently attached to this version of the
    /// secret.</p>
    pub version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time that this version of the secret was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for GetSecretValueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSecretValueOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.field("secret_binary", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_string", &"*** Sensitive Data Redacted ***");
        formatter.field("version_stages", &self.version_stages);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`GetSecretValueOutput`](crate::output::GetSecretValueOutput)
pub mod get_secret_value_output {
    /// A builder for [`GetSecretValueOutput`](crate::output::GetSecretValueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) secret_binary: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) secret_string: std::option::Option<std::string::String>,
        pub(crate) version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the secret.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of this version of the secret.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of this version of the secret.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The decrypted part of the protected secret information that was originally provided as
        /// binary data in the form of a byte array. The response parameter represents the binary data as
        /// a <a href="https://tools.ietf.org/html/rfc4648#section-4">base64-encoded</a>
        /// string.</p>
        /// <p>This parameter is not used if the secret is created by the Secrets Manager console.</p>
        /// <p>If you store custom information in this field of the secret, then you must code your
        /// Lambda rotation function to parse and interpret whatever you store in the
        /// <code>SecretString</code> or <code>SecretBinary</code> fields.</p>
        pub fn secret_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.secret_binary = Some(input);
            self
        }
        /// <p>The decrypted part of the protected secret information that was originally provided as
        /// binary data in the form of a byte array. The response parameter represents the binary data as
        /// a <a href="https://tools.ietf.org/html/rfc4648#section-4">base64-encoded</a>
        /// string.</p>
        /// <p>This parameter is not used if the secret is created by the Secrets Manager console.</p>
        /// <p>If you store custom information in this field of the secret, then you must code your
        /// Lambda rotation function to parse and interpret whatever you store in the
        /// <code>SecretString</code> or <code>SecretBinary</code> fields.</p>
        pub fn set_secret_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.secret_binary = input;
            self
        }
        /// <p>The decrypted part of the protected secret information that was originally provided as a
        /// string.</p>
        /// <p>If you create this secret by using the Secrets Manager console then only the
        /// <code>SecretString</code> parameter contains data. Secrets Manager stores the information as a
        /// JSON structure of key/value pairs that the Lambda rotation function knows how to parse.</p>
        /// <p>If you store custom information in the secret by using the <a>CreateSecret</a>,
        /// <a>UpdateSecret</a>, or <a>PutSecretValue</a> API operations instead
        /// of the Secrets Manager console, or by using the <b>Other secret type</b> in
        /// the console, then you must code your Lambda rotation function to parse and interpret those
        /// values.</p>
        pub fn secret_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_string = Some(input.into());
            self
        }
        /// <p>The decrypted part of the protected secret information that was originally provided as a
        /// string.</p>
        /// <p>If you create this secret by using the Secrets Manager console then only the
        /// <code>SecretString</code> parameter contains data. Secrets Manager stores the information as a
        /// JSON structure of key/value pairs that the Lambda rotation function knows how to parse.</p>
        /// <p>If you store custom information in the secret by using the <a>CreateSecret</a>,
        /// <a>UpdateSecret</a>, or <a>PutSecretValue</a> API operations instead
        /// of the Secrets Manager console, or by using the <b>Other secret type</b> in
        /// the console, then you must code your Lambda rotation function to parse and interpret those
        /// values.</p>
        pub fn set_secret_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_string = input;
            self
        }
        /// Appends an item to `version_stages`.
        ///
        /// To override the contents of this collection use [`set_version_stages`](Self::set_version_stages).
        ///
        /// <p>A list of all of the staging labels currently attached to this version of the
        /// secret.</p>
        pub fn version_stages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.version_stages.unwrap_or_default();
            v.push(input.into());
            self.version_stages = Some(v);
            self
        }
        /// <p>A list of all of the staging labels currently attached to this version of the
        /// secret.</p>
        pub fn set_version_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.version_stages = input;
            self
        }
        /// <p>The date and time that this version of the secret was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time that this version of the secret was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSecretValueOutput`](crate::output::GetSecretValueOutput)
        pub fn build(self) -> crate::output::GetSecretValueOutput {
            crate::output::GetSecretValueOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
                secret_binary: self.secret_binary,
                secret_string: self.secret_string,
                version_stages: self.version_stages,
                created_date: self.created_date,
            }
        }
    }
}
impl GetSecretValueOutput {
    /// Creates a new builder-style object to manufacture [`GetSecretValueOutput`](crate::output::GetSecretValueOutput)
    pub fn builder() -> crate::output::get_secret_value_output::Builder {
        crate::output::get_secret_value_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p>The ARN of the secret that the resource-based policy was retrieved for.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret that the resource-based policy was retrieved for.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A JSON-formatted string that describes the permissions that are associated with the
    /// attached secret. These permissions are combined with any permissions that are associated with
    /// the user or role that attempts to access this secret. The combined permissions specify who can
    /// access the secret and what actions they can perform. For more information, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and Access Control for
    /// Amazon Web Services Secrets Manager</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
    pub resource_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("resource_policy", &self.resource_policy);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret that the resource-based policy was retrieved for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that the resource-based policy was retrieved for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret that the resource-based policy was retrieved for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret that the resource-based policy was retrieved for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A JSON-formatted string that describes the permissions that are associated with the
        /// attached secret. These permissions are combined with any permissions that are associated with
        /// the user or role that attempts to access this secret. The combined permissions specify who can
        /// access the secret and what actions they can perform. For more information, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and Access Control for
        /// Amazon Web Services Secrets Manager</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_policy = Some(input.into());
            self
        }
        /// <p>A JSON-formatted string that describes the permissions that are associated with the
        /// attached secret. These permissions are combined with any permissions that are associated with
        /// the user or role that attempts to access this secret. The combined permissions specify who can
        /// access the secret and what actions they can perform. For more information, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and Access Control for
        /// Amazon Web Services Secrets Manager</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                arn: self.arn,
                name: self.name,
                resource_policy: self.resource_policy,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRandomPasswordOutput {
    /// <p>A string with the generated password.</p>
    pub random_password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRandomPasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRandomPasswordOutput");
        formatter.field("random_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetRandomPasswordOutput`](crate::output::GetRandomPasswordOutput)
pub mod get_random_password_output {
    /// A builder for [`GetRandomPasswordOutput`](crate::output::GetRandomPasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) random_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string with the generated password.</p>
        pub fn random_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.random_password = Some(input.into());
            self
        }
        /// <p>A string with the generated password.</p>
        pub fn set_random_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.random_password = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRandomPasswordOutput`](crate::output::GetRandomPasswordOutput)
        pub fn build(self) -> crate::output::GetRandomPasswordOutput {
            crate::output::GetRandomPasswordOutput {
                random_password: self.random_password,
            }
        }
    }
}
impl GetRandomPasswordOutput {
    /// Creates a new builder-style object to manufacture [`GetRandomPasswordOutput`](crate::output::GetRandomPasswordOutput)
    pub fn builder() -> crate::output::get_random_password_output::Builder {
        crate::output::get_random_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSecretOutput {
    /// <p>The ARN of the secret.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The user-provided friendly name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The user-provided description of the secret.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) that's used to encrypt the
    /// <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret.
    /// If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with the
    /// default Amazon Web Services KMS CMK (the one named <code>awssecretsmanager</code>) for this account.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether automatic rotation is enabled for this secret.</p>
    /// <p>To enable rotation, use <a>RotateSecret</a> with
    /// <code>AutomaticallyRotateAfterDays</code> set to a value greater than 0. To disable
    /// rotation, use <a>CancelRotateSecret</a>.</p>
    pub rotation_enabled: std::option::Option<bool>,
    /// <p>The ARN of a Lambda function that's invoked by Secrets Manager to rotate the
    /// secret either automatically per the schedule or manually by a call to
    /// <code>RotateSecret</code>.</p>
    pub rotation_lambda_arn: std::option::Option<std::string::String>,
    /// <p>A structure with the rotation configuration for this secret. This field is only populated
    /// if rotation is configured.</p>
    pub rotation_rules: std::option::Option<crate::model::RotationRulesType>,
    /// <p>The last date and time that the rotation process for this secret was invoked.</p>
    /// <p>The most recent date and time that the Secrets Manager rotation process successfully
    /// completed. If the secret doesn't rotate, Secrets Manager returns a null value.</p>
    pub last_rotated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date and time that this secret was modified in any way.</p>
    pub last_changed_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
    /// date and therefore shows only the date, not the time.</p>
    pub last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>This value exists if the secret is scheduled for deletion. Some time after the specified
    /// date and time, Secrets Manager deletes the secret and all of its versions.</p>
    /// <p>If a secret is scheduled for deletion, then its details, including the encrypted secret
    /// information, is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.</p>
    pub deleted_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The list of user-defined tags that are associated with the secret. To add tags to a
    /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A list of all of the currently assigned <code>VersionStage</code> staging labels and the
    /// <code>VersionId</code> that each is attached to. Staging labels are used to keep track of
    /// the different versions during the rotation process.</p>
    /// <note>
    /// <p>A version that does not have any staging labels attached is considered deprecated and
    /// subject to deletion. Such versions are not included in this list.</p>
    /// </note>
    pub version_ids_to_stages: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>Returns the name of the service that created this secret.</p>
    pub owning_service: std::option::Option<std::string::String>,
    /// <p>The date you created the secret.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the primary region for secret replication. </p>
    pub primary_region: std::option::Option<std::string::String>,
    /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.<code>P</code>
    /// </p>
    pub replication_status: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
}
impl std::fmt::Debug for DescribeSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("rotation_enabled", &self.rotation_enabled);
        formatter.field("rotation_lambda_arn", &self.rotation_lambda_arn);
        formatter.field("rotation_rules", &self.rotation_rules);
        formatter.field("last_rotated_date", &self.last_rotated_date);
        formatter.field("last_changed_date", &self.last_changed_date);
        formatter.field("last_accessed_date", &self.last_accessed_date);
        formatter.field("deleted_date", &self.deleted_date);
        formatter.field("tags", &self.tags);
        formatter.field("version_ids_to_stages", &self.version_ids_to_stages);
        formatter.field("owning_service", &self.owning_service);
        formatter.field("created_date", &self.created_date);
        formatter.field("primary_region", &self.primary_region);
        formatter.field("replication_status", &self.replication_status);
        formatter.finish()
    }
}
/// See [`DescribeSecretOutput`](crate::output::DescribeSecretOutput)
pub mod describe_secret_output {
    /// A builder for [`DescribeSecretOutput`](crate::output::DescribeSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) rotation_enabled: std::option::Option<bool>,
        pub(crate) rotation_lambda_arn: std::option::Option<std::string::String>,
        pub(crate) rotation_rules: std::option::Option<crate::model::RotationRulesType>,
        pub(crate) last_rotated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_changed_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deleted_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) version_ids_to_stages: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) owning_service: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) primary_region: std::option::Option<std::string::String>,
        pub(crate) replication_status:
            std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
    }
    impl Builder {
        /// <p>The ARN of the secret.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The user-provided friendly name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user-provided friendly name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The user-provided description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-provided description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) that's used to encrypt the
        /// <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret.
        /// If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with the
        /// default Amazon Web Services KMS CMK (the one named <code>awssecretsmanager</code>) for this account.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) that's used to encrypt the
        /// <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret.
        /// If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with the
        /// default Amazon Web Services KMS CMK (the one named <code>awssecretsmanager</code>) for this account.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether automatic rotation is enabled for this secret.</p>
        /// <p>To enable rotation, use <a>RotateSecret</a> with
        /// <code>AutomaticallyRotateAfterDays</code> set to a value greater than 0. To disable
        /// rotation, use <a>CancelRotateSecret</a>.</p>
        pub fn rotation_enabled(mut self, input: bool) -> Self {
            self.rotation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether automatic rotation is enabled for this secret.</p>
        /// <p>To enable rotation, use <a>RotateSecret</a> with
        /// <code>AutomaticallyRotateAfterDays</code> set to a value greater than 0. To disable
        /// rotation, use <a>CancelRotateSecret</a>.</p>
        pub fn set_rotation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.rotation_enabled = input;
            self
        }
        /// <p>The ARN of a Lambda function that's invoked by Secrets Manager to rotate the
        /// secret either automatically per the schedule or manually by a call to
        /// <code>RotateSecret</code>.</p>
        pub fn rotation_lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rotation_lambda_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a Lambda function that's invoked by Secrets Manager to rotate the
        /// secret either automatically per the schedule or manually by a call to
        /// <code>RotateSecret</code>.</p>
        pub fn set_rotation_lambda_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rotation_lambda_arn = input;
            self
        }
        /// <p>A structure with the rotation configuration for this secret. This field is only populated
        /// if rotation is configured.</p>
        pub fn rotation_rules(mut self, input: crate::model::RotationRulesType) -> Self {
            self.rotation_rules = Some(input);
            self
        }
        /// <p>A structure with the rotation configuration for this secret. This field is only populated
        /// if rotation is configured.</p>
        pub fn set_rotation_rules(
            mut self,
            input: std::option::Option<crate::model::RotationRulesType>,
        ) -> Self {
            self.rotation_rules = input;
            self
        }
        /// <p>The last date and time that the rotation process for this secret was invoked.</p>
        /// <p>The most recent date and time that the Secrets Manager rotation process successfully
        /// completed. If the secret doesn't rotate, Secrets Manager returns a null value.</p>
        pub fn last_rotated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_rotated_date = Some(input);
            self
        }
        /// <p>The last date and time that the rotation process for this secret was invoked.</p>
        /// <p>The most recent date and time that the Secrets Manager rotation process successfully
        /// completed. If the secret doesn't rotate, Secrets Manager returns a null value.</p>
        pub fn set_last_rotated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_rotated_date = input;
            self
        }
        /// <p>The last date and time that this secret was modified in any way.</p>
        pub fn last_changed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_changed_date = Some(input);
            self
        }
        /// <p>The last date and time that this secret was modified in any way.</p>
        pub fn set_last_changed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_changed_date = input;
            self
        }
        /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
        /// date and therefore shows only the date, not the time.</p>
        pub fn last_accessed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_accessed_date = Some(input);
            self
        }
        /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
        /// date and therefore shows only the date, not the time.</p>
        pub fn set_last_accessed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_accessed_date = input;
            self
        }
        /// <p>This value exists if the secret is scheduled for deletion. Some time after the specified
        /// date and time, Secrets Manager deletes the secret and all of its versions.</p>
        /// <p>If a secret is scheduled for deletion, then its details, including the encrypted secret
        /// information, is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.</p>
        pub fn deleted_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deleted_date = Some(input);
            self
        }
        /// <p>This value exists if the secret is scheduled for deletion. Some time after the specified
        /// date and time, Secrets Manager deletes the secret and all of its versions.</p>
        /// <p>If a secret is scheduled for deletion, then its details, including the encrypted secret
        /// information, is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.</p>
        pub fn set_deleted_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deleted_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of user-defined tags that are associated with the secret. To add tags to a
        /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of user-defined tags that are associated with the secret. To add tags to a
        /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `version_ids_to_stages`.
        ///
        /// To override the contents of this collection use [`set_version_ids_to_stages`](Self::set_version_ids_to_stages).
        ///
        /// <p>A list of all of the currently assigned <code>VersionStage</code> staging labels and the
        /// <code>VersionId</code> that each is attached to. Staging labels are used to keep track of
        /// the different versions during the rotation process.</p>
        /// <note>
        /// <p>A version that does not have any staging labels attached is considered deprecated and
        /// subject to deletion. Such versions are not included in this list.</p>
        /// </note>
        pub fn version_ids_to_stages(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.version_ids_to_stages.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.version_ids_to_stages = Some(hash_map);
            self
        }
        /// <p>A list of all of the currently assigned <code>VersionStage</code> staging labels and the
        /// <code>VersionId</code> that each is attached to. Staging labels are used to keep track of
        /// the different versions during the rotation process.</p>
        /// <note>
        /// <p>A version that does not have any staging labels attached is considered deprecated and
        /// subject to deletion. Such versions are not included in this list.</p>
        /// </note>
        pub fn set_version_ids_to_stages(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.version_ids_to_stages = input;
            self
        }
        /// <p>Returns the name of the service that created this secret.</p>
        pub fn owning_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.owning_service = Some(input.into());
            self
        }
        /// <p>Returns the name of the service that created this secret.</p>
        pub fn set_owning_service(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owning_service = input;
            self
        }
        /// <p>The date you created the secret.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date you created the secret.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Specifies the primary region for secret replication. </p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_region = Some(input.into());
            self
        }
        /// <p>Specifies the primary region for secret replication. </p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_region = input;
            self
        }
        /// Appends an item to `replication_status`.
        ///
        /// To override the contents of this collection use [`set_replication_status`](Self::set_replication_status).
        ///
        /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.<code>P</code>
        /// </p>
        pub fn replication_status(
            mut self,
            input: impl Into<crate::model::ReplicationStatusType>,
        ) -> Self {
            let mut v = self.replication_status.unwrap_or_default();
            v.push(input.into());
            self.replication_status = Some(v);
            self
        }
        /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.<code>P</code>
        /// </p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecretOutput`](crate::output::DescribeSecretOutput)
        pub fn build(self) -> crate::output::DescribeSecretOutput {
            crate::output::DescribeSecretOutput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                kms_key_id: self.kms_key_id,
                rotation_enabled: self.rotation_enabled,
                rotation_lambda_arn: self.rotation_lambda_arn,
                rotation_rules: self.rotation_rules,
                last_rotated_date: self.last_rotated_date,
                last_changed_date: self.last_changed_date,
                last_accessed_date: self.last_accessed_date,
                deleted_date: self.deleted_date,
                tags: self.tags,
                version_ids_to_stages: self.version_ids_to_stages,
                owning_service: self.owning_service,
                created_date: self.created_date,
                primary_region: self.primary_region,
                replication_status: self.replication_status,
            }
        }
    }
}
impl DescribeSecretOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSecretOutput`](crate::output::DescribeSecretOutput)
    pub fn builder() -> crate::output::describe_secret_output::Builder {
        crate::output::describe_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSecretOutput {
    /// <p>The ARN of the secret that is now scheduled for deletion.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret currently scheduled for deletion.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date and time after which this secret can be deleted by Secrets Manager and can no longer be
    /// restored. This value is the date and time of the delete request plus the number of days
    /// specified in <code>RecoveryWindowInDays</code>.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DeleteSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.finish()
    }
}
/// See [`DeleteSecretOutput`](crate::output::DeleteSecretOutput)
pub mod delete_secret_output {
    /// A builder for [`DeleteSecretOutput`](crate::output::DeleteSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the secret that is now scheduled for deletion.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that is now scheduled for deletion.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret currently scheduled for deletion.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret currently scheduled for deletion.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date and time after which this secret can be deleted by Secrets Manager and can no longer be
        /// restored. This value is the date and time of the delete request plus the number of days
        /// specified in <code>RecoveryWindowInDays</code>.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time after which this secret can be deleted by Secrets Manager and can no longer be
        /// restored. This value is the date and time of the delete request plus the number of days
        /// specified in <code>RecoveryWindowInDays</code>.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSecretOutput`](crate::output::DeleteSecretOutput)
        pub fn build(self) -> crate::output::DeleteSecretOutput {
            crate::output::DeleteSecretOutput {
                arn: self.arn,
                name: self.name,
                deletion_date: self.deletion_date,
            }
        }
    }
}
impl DeleteSecretOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSecretOutput`](crate::output::DeleteSecretOutput)
    pub fn builder() -> crate::output::delete_secret_output::Builder {
        crate::output::delete_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {
    /// <p>The ARN of the secret that the resource-based policy was deleted for.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret that the resource-based policy was deleted for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret that the resource-based policy was deleted for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret that the resource-based policy was deleted for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret that the resource-based policy was deleted for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret that the resource-based policy was deleted for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSecretOutput {
    /// <p>The Amazon Resource Name (ARN) of the secret that you just created.</p>
    /// <note>
    /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
    /// you initially create a secret. This affects only the ARN and not the actual friendly name.
    /// This ensures that if you create a new secret with the same name as an old secret that you
    /// previously deleted, then users with access to the old secret <i>don't</i>
    /// automatically get access to the new secret because the ARNs are different.</p>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret that you just created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier associated with the version of the secret you just created.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.</p>
    pub replication_status: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
}
impl std::fmt::Debug for CreateSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.field("replication_status", &self.replication_status);
        formatter.finish()
    }
}
/// See [`CreateSecretOutput`](crate::output::CreateSecretOutput)
pub mod create_secret_output {
    /// A builder for [`CreateSecretOutput`](crate::output::CreateSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) replication_status:
            std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the secret that you just created.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that you just created.</p>
        /// <note>
        /// <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when
        /// you initially create a secret. This affects only the ARN and not the actual friendly name.
        /// This ensures that if you create a new secret with the same name as an old secret that you
        /// previously deleted, then users with access to the old secret <i>don't</i>
        /// automatically get access to the new secret because the ARNs are different.</p>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret that you just created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret that you just created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier associated with the version of the secret you just created.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier associated with the version of the secret you just created.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `replication_status`.
        ///
        /// To override the contents of this collection use [`set_replication_status`](Self::set_replication_status).
        ///
        /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.</p>
        pub fn replication_status(
            mut self,
            input: impl Into<crate::model::ReplicationStatusType>,
        ) -> Self {
            let mut v = self.replication_status.unwrap_or_default();
            v.push(input.into());
            self.replication_status = Some(v);
            self
        }
        /// <p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationStatusType>>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecretOutput`](crate::output::CreateSecretOutput)
        pub fn build(self) -> crate::output::CreateSecretOutput {
            crate::output::CreateSecretOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
                replication_status: self.replication_status,
            }
        }
    }
}
impl CreateSecretOutput {
    /// Creates a new builder-style object to manufacture [`CreateSecretOutput`](crate::output::CreateSecretOutput)
    pub fn builder() -> crate::output::create_secret_output::Builder {
        crate::output::create_secret_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelRotateSecretOutput {
    /// <p>The ARN of the secret for which rotation was canceled.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret for which rotation was canceled.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the version of the secret created during the rotation. This
    /// version might not be complete, and should be evaluated for possible deletion. At the very
    /// least, you should remove the <code>VersionStage</code> value <code>AWSPENDING</code> to enable this
    /// version to be deleted. Failing to clean up a cancelled rotation can block you from
    /// successfully starting future rotations.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelRotateSecretOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelRotateSecretOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`CancelRotateSecretOutput`](crate::output::CancelRotateSecretOutput)
pub mod cancel_rotate_secret_output {
    /// A builder for [`CancelRotateSecretOutput`](crate::output::CancelRotateSecretOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the secret for which rotation was canceled.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the secret for which rotation was canceled.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret for which rotation was canceled.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret for which rotation was canceled.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of the version of the secret created during the rotation. This
        /// version might not be complete, and should be evaluated for possible deletion. At the very
        /// least, you should remove the <code>VersionStage</code> value <code>AWSPENDING</code> to enable this
        /// version to be deleted. Failing to clean up a cancelled rotation can block you from
        /// successfully starting future rotations.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the version of the secret created during the rotation. This
        /// version might not be complete, and should be evaluated for possible deletion. At the very
        /// least, you should remove the <code>VersionStage</code> value <code>AWSPENDING</code> to enable this
        /// version to be deleted. Failing to clean up a cancelled rotation can block you from
        /// successfully starting future rotations.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelRotateSecretOutput`](crate::output::CancelRotateSecretOutput)
        pub fn build(self) -> crate::output::CancelRotateSecretOutput {
            crate::output::CancelRotateSecretOutput {
                arn: self.arn,
                name: self.name,
                version_id: self.version_id,
            }
        }
    }
}
impl CancelRotateSecretOutput {
    /// Creates a new builder-style object to manufacture [`CancelRotateSecretOutput`](crate::output::CancelRotateSecretOutput)
    pub fn builder() -> crate::output::cancel_rotate_secret_output::Builder {
        crate::output::cancel_rotate_secret_output::Builder::default()
    }
}
