// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Displays errors that occurred during validation of the resource policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationErrorsEntry {
    /// <p>Checks the name of the policy.</p>
    pub check_name: std::option::Option<std::string::String>,
    /// <p>Displays error messages if validation encounters problems during validation of the resource policy.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationErrorsEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationErrorsEntry");
        formatter.field("check_name", &self.check_name);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ValidationErrorsEntry`](crate::model::ValidationErrorsEntry)
pub mod validation_errors_entry {
    /// A builder for [`ValidationErrorsEntry`](crate::model::ValidationErrorsEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks the name of the policy.</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>Checks the name of the policy.</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Displays error messages if validation encounters problems during validation of the resource policy.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Displays error messages if validation encounters problems during validation of the resource policy.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationErrorsEntry`](crate::model::ValidationErrorsEntry)
        pub fn build(self) -> crate::model::ValidationErrorsEntry {
            crate::model::ValidationErrorsEntry {
                check_name: self.check_name,
                error_message: self.error_message,
            }
        }
    }
}
impl ValidationErrorsEntry {
    /// Creates a new builder-style object to manufacture [`ValidationErrorsEntry`](crate::model::ValidationErrorsEntry)
    pub fn builder() -> crate::model::validation_errors_entry::Builder {
        crate::model::validation_errors_entry::Builder::default()
    }
}

/// <p>A structure that contains information about a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key identifier, or name, of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The string value associated with the key of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key identifier, or name, of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The string value associated with the key of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string value associated with the key of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A structure that defines the rotation configuration for the secret.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RotationRulesType {
    /// <p>Specifies the number of days between automatic scheduled rotations of the secret.</p>
    /// <p>Secrets Manager schedules the next rotation when the previous
    /// one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the
    /// actual date of the last rotation. The service chooses the hour within that 24-hour date window
    /// randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour
    /// and influenced by a variety of factors that help distribute load.</p>
    pub automatically_after_days: std::option::Option<i64>,
}
impl std::fmt::Debug for RotationRulesType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RotationRulesType");
        formatter.field("automatically_after_days", &self.automatically_after_days);
        formatter.finish()
    }
}
/// See [`RotationRulesType`](crate::model::RotationRulesType)
pub mod rotation_rules_type {
    /// A builder for [`RotationRulesType`](crate::model::RotationRulesType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatically_after_days: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies the number of days between automatic scheduled rotations of the secret.</p>
        /// <p>Secrets Manager schedules the next rotation when the previous
        /// one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the
        /// actual date of the last rotation. The service chooses the hour within that 24-hour date window
        /// randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour
        /// and influenced by a variety of factors that help distribute load.</p>
        pub fn automatically_after_days(mut self, input: i64) -> Self {
            self.automatically_after_days = Some(input);
            self
        }
        /// <p>Specifies the number of days between automatic scheduled rotations of the secret.</p>
        /// <p>Secrets Manager schedules the next rotation when the previous
        /// one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the
        /// actual date of the last rotation. The service chooses the hour within that 24-hour date window
        /// randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour
        /// and influenced by a variety of factors that help distribute load.</p>
        pub fn set_automatically_after_days(mut self, input: std::option::Option<i64>) -> Self {
            self.automatically_after_days = input;
            self
        }
        /// Consumes the builder and constructs a [`RotationRulesType`](crate::model::RotationRulesType)
        pub fn build(self) -> crate::model::RotationRulesType {
            crate::model::RotationRulesType {
                automatically_after_days: self.automatically_after_days,
            }
        }
    }
}
impl RotationRulesType {
    /// Creates a new builder-style object to manufacture [`RotationRulesType`](crate::model::RotationRulesType)
    pub fn builder() -> crate::model::rotation_rules_type::Builder {
        crate::model::rotation_rules_type::Builder::default()
    }
}

/// <p>A replication object consisting of a <code>RegionReplicationStatus</code> object and includes a Region, KMSKeyId, status, and status message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationStatusType {
    /// <p>The Region where replication occurs.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>Status message such as "<i>Secret with this name already exists in this
    /// region</i>".</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date that you last accessed the secret in the Region. </p>
    pub last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ReplicationStatusType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationStatusType");
        formatter.field("region", &self.region);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("last_accessed_date", &self.last_accessed_date);
        formatter.finish()
    }
}
/// See [`ReplicationStatusType`](crate::model::ReplicationStatusType)
pub mod replication_status_type {
    /// A builder for [`ReplicationStatusType`](crate::model::ReplicationStatusType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Region where replication occurs.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where replication occurs.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>Status message such as "<i>Secret with this name already exists in this
        /// region</i>".</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Status message such as "<i>Secret with this name already exists in this
        /// region</i>".</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date that you last accessed the secret in the Region. </p>
        pub fn last_accessed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_accessed_date = Some(input);
            self
        }
        /// <p>The date that you last accessed the secret in the Region. </p>
        pub fn set_last_accessed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_accessed_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationStatusType`](crate::model::ReplicationStatusType)
        pub fn build(self) -> crate::model::ReplicationStatusType {
            crate::model::ReplicationStatusType {
                region: self.region,
                kms_key_id: self.kms_key_id,
                status: self.status,
                status_message: self.status_message,
                last_accessed_date: self.last_accessed_date,
            }
        }
    }
}
impl ReplicationStatusType {
    /// Creates a new builder-style object to manufacture [`ReplicationStatusType`](crate::model::ReplicationStatusType)
    pub fn builder() -> crate::model::replication_status_type::Builder {
        crate::model::replication_status_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => StatusType::Failed,
            "InProgress" => StatusType::InProgress,
            "InSync" => StatusType::InSync,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Failed => "Failed",
            StatusType::InProgress => "InProgress",
            StatusType::InSync => "InSync",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "InSync"]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>(Optional) Custom type consisting of a <code>Region</code> (required) and the <code>KmsKeyId</code> which can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaRegionType {
    /// <p>Describes a single instance of Region objects.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicaRegionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaRegionType");
        formatter.field("region", &self.region);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ReplicaRegionType`](crate::model::ReplicaRegionType)
pub mod replica_region_type {
    /// A builder for [`ReplicaRegionType`](crate::model::ReplicaRegionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes a single instance of Region objects.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Describes a single instance of Region objects.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaRegionType`](crate::model::ReplicaRegionType)
        pub fn build(self) -> crate::model::ReplicaRegionType {
            crate::model::ReplicaRegionType {
                region: self.region,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ReplicaRegionType {
    /// Creates a new builder-style object to manufacture [`ReplicaRegionType`](crate::model::ReplicaRegionType)
    pub fn builder() -> crate::model::replica_region_type::Builder {
        crate::model::replica_region_type::Builder::default()
    }
}

/// <p>A structure that contains information about one version of a secret.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecretVersionsListEntry {
    /// <p>The unique version identifier of this version of the secret.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>An array of staging labels that are currently associated with this version of the
    /// secret.</p>
    pub version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date that this version of the secret was last accessed. Note that the resolution of
    /// this field is at the date level and does not include the time.</p>
    pub last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time this version of the secret was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The KMS keys used to encrypt the secret version.</p>
    pub kms_key_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SecretVersionsListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecretVersionsListEntry");
        formatter.field("version_id", &self.version_id);
        formatter.field("version_stages", &self.version_stages);
        formatter.field("last_accessed_date", &self.last_accessed_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("kms_key_ids", &self.kms_key_ids);
        formatter.finish()
    }
}
/// See [`SecretVersionsListEntry`](crate::model::SecretVersionsListEntry)
pub mod secret_versions_list_entry {
    /// A builder for [`SecretVersionsListEntry`](crate::model::SecretVersionsListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) version_stages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) kms_key_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique version identifier of this version of the secret.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The unique version identifier of this version of the secret.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `version_stages`.
        ///
        /// To override the contents of this collection use [`set_version_stages`](Self::set_version_stages).
        ///
        /// <p>An array of staging labels that are currently associated with this version of the
        /// secret.</p>
        pub fn version_stages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.version_stages.unwrap_or_default();
            v.push(input.into());
            self.version_stages = Some(v);
            self
        }
        /// <p>An array of staging labels that are currently associated with this version of the
        /// secret.</p>
        pub fn set_version_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.version_stages = input;
            self
        }
        /// <p>The date that this version of the secret was last accessed. Note that the resolution of
        /// this field is at the date level and does not include the time.</p>
        pub fn last_accessed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_accessed_date = Some(input);
            self
        }
        /// <p>The date that this version of the secret was last accessed. Note that the resolution of
        /// this field is at the date level and does not include the time.</p>
        pub fn set_last_accessed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_accessed_date = input;
            self
        }
        /// <p>The date and time this version of the secret was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time this version of the secret was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Appends an item to `kms_key_ids`.
        ///
        /// To override the contents of this collection use [`set_kms_key_ids`](Self::set_kms_key_ids).
        ///
        /// <p>The KMS keys used to encrypt the secret version.</p>
        pub fn kms_key_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.kms_key_ids.unwrap_or_default();
            v.push(input.into());
            self.kms_key_ids = Some(v);
            self
        }
        /// <p>The KMS keys used to encrypt the secret version.</p>
        pub fn set_kms_key_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.kms_key_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`SecretVersionsListEntry`](crate::model::SecretVersionsListEntry)
        pub fn build(self) -> crate::model::SecretVersionsListEntry {
            crate::model::SecretVersionsListEntry {
                version_id: self.version_id,
                version_stages: self.version_stages,
                last_accessed_date: self.last_accessed_date,
                created_date: self.created_date,
                kms_key_ids: self.kms_key_ids,
            }
        }
    }
}
impl SecretVersionsListEntry {
    /// Creates a new builder-style object to manufacture [`SecretVersionsListEntry`](crate::model::SecretVersionsListEntry)
    pub fn builder() -> crate::model::secret_versions_list_entry::Builder {
        crate::model::secret_versions_list_entry::Builder::default()
    }
}

/// <p>A structure that contains the details about a secret. It does not include the encrypted
/// <code>SecretString</code> and <code>SecretBinary</code> values. To get those values, use the
/// <a>GetSecretValue</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecretListEntry {
    /// <p>The Amazon Resource Name (ARN) of the secret.</p>
    /// <p>For more information about ARNs in Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources">Policy Resources</a> in the
    /// <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name of the secret. You can use forward slashes in the name to represent a
    /// path hierarchy. For example, <code>/prod/databases/dbserver1</code> could represent the secret
    /// for a server named <code>dbserver1</code> in the folder <code>databases</code> in the folder
    /// <code>prod</code>. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The user-provided description of the secret.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) used to encrypt the
    /// <code>SecretString</code> and <code>SecretBinary</code> fields in each version of the
    /// secret. If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with
    /// the default KMS CMK, the key named <code>awssecretsmanager</code>, for this account.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether automatic, scheduled rotation is enabled for this secret.</p>
    pub rotation_enabled: std::option::Option<bool>,
    /// <p>The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the
    /// secret either automatically per the schedule or manually by a call to <a>RotateSecret</a>.</p>
    pub rotation_lambda_arn: std::option::Option<std::string::String>,
    /// <p>A structure that defines the rotation configuration for the secret.</p>
    pub rotation_rules: std::option::Option<crate::model::RotationRulesType>,
    /// <p>The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn't ever rotated.</p>
    pub last_rotated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date and time that this secret was modified in any way.</p>
    pub last_changed_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
    /// date and therefore shows only the date, not the time.</p>
    pub last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time the deletion of the secret occurred. Not present on active secrets. The
    /// secret can be recovered until the number of days in the recovery window has passed, as
    /// specified in the <code>RecoveryWindowInDays</code> parameter of the <a>DeleteSecret</a> operation.</p>
    pub deleted_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The list of user-defined tags associated with the secret. To add tags to a
    /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A list of all of the currently assigned <code>SecretVersionStage</code> staging labels and
    /// the <code>SecretVersionId</code> attached to each one. Staging labels are used to keep
    /// track of the different versions during the rotation process.</p>
    /// <note>
    /// <p>A version that does not have any <code>SecretVersionStage</code> is considered
    /// deprecated and subject to deletion. Such versions are not included in this list.</p>
    /// </note>
    pub secret_versions_to_stages: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>Returns the name of the service that created the secret.</p>
    pub owning_service: std::option::Option<std::string::String>,
    /// <p>The date and time when a secret was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Region where Secrets Manager originated the secret.</p>
    pub primary_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SecretListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecretListEntry");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("rotation_enabled", &self.rotation_enabled);
        formatter.field("rotation_lambda_arn", &self.rotation_lambda_arn);
        formatter.field("rotation_rules", &self.rotation_rules);
        formatter.field("last_rotated_date", &self.last_rotated_date);
        formatter.field("last_changed_date", &self.last_changed_date);
        formatter.field("last_accessed_date", &self.last_accessed_date);
        formatter.field("deleted_date", &self.deleted_date);
        formatter.field("tags", &self.tags);
        formatter.field("secret_versions_to_stages", &self.secret_versions_to_stages);
        formatter.field("owning_service", &self.owning_service);
        formatter.field("created_date", &self.created_date);
        formatter.field("primary_region", &self.primary_region);
        formatter.finish()
    }
}
/// See [`SecretListEntry`](crate::model::SecretListEntry)
pub mod secret_list_entry {
    /// A builder for [`SecretListEntry`](crate::model::SecretListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) rotation_enabled: std::option::Option<bool>,
        pub(crate) rotation_lambda_arn: std::option::Option<std::string::String>,
        pub(crate) rotation_rules: std::option::Option<crate::model::RotationRulesType>,
        pub(crate) last_rotated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_changed_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_accessed_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deleted_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) secret_versions_to_stages: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) owning_service: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) primary_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the secret.</p>
        /// <p>For more information about ARNs in Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources">Policy Resources</a> in the
        /// <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret.</p>
        /// <p>For more information about ARNs in Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources">Policy Resources</a> in the
        /// <i>Amazon Web Services Secrets Manager User Guide</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name of the secret. You can use forward slashes in the name to represent a
        /// path hierarchy. For example, <code>/prod/databases/dbserver1</code> could represent the secret
        /// for a server named <code>dbserver1</code> in the folder <code>databases</code> in the folder
        /// <code>prod</code>. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the secret. You can use forward slashes in the name to represent a
        /// path hierarchy. For example, <code>/prod/databases/dbserver1</code> could represent the secret
        /// for a server named <code>dbserver1</code> in the folder <code>databases</code> in the folder
        /// <code>prod</code>. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The user-provided description of the secret.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-provided description of the secret.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) used to encrypt the
        /// <code>SecretString</code> and <code>SecretBinary</code> fields in each version of the
        /// secret. If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with
        /// the default KMS CMK, the key named <code>awssecretsmanager</code>, for this account.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) used to encrypt the
        /// <code>SecretString</code> and <code>SecretBinary</code> fields in each version of the
        /// secret. If you don't provide a key, then Secrets Manager defaults to encrypting the secret fields with
        /// the default KMS CMK, the key named <code>awssecretsmanager</code>, for this account.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Indicates whether automatic, scheduled rotation is enabled for this secret.</p>
        pub fn rotation_enabled(mut self, input: bool) -> Self {
            self.rotation_enabled = Some(input);
            self
        }
        /// <p>Indicates whether automatic, scheduled rotation is enabled for this secret.</p>
        pub fn set_rotation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.rotation_enabled = input;
            self
        }
        /// <p>The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the
        /// secret either automatically per the schedule or manually by a call to <a>RotateSecret</a>.</p>
        pub fn rotation_lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rotation_lambda_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the
        /// secret either automatically per the schedule or manually by a call to <a>RotateSecret</a>.</p>
        pub fn set_rotation_lambda_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rotation_lambda_arn = input;
            self
        }
        /// <p>A structure that defines the rotation configuration for the secret.</p>
        pub fn rotation_rules(mut self, input: crate::model::RotationRulesType) -> Self {
            self.rotation_rules = Some(input);
            self
        }
        /// <p>A structure that defines the rotation configuration for the secret.</p>
        pub fn set_rotation_rules(
            mut self,
            input: std::option::Option<crate::model::RotationRulesType>,
        ) -> Self {
            self.rotation_rules = input;
            self
        }
        /// <p>The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn't ever rotated.</p>
        pub fn last_rotated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_rotated_date = Some(input);
            self
        }
        /// <p>The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn't ever rotated.</p>
        pub fn set_last_rotated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_rotated_date = input;
            self
        }
        /// <p>The last date and time that this secret was modified in any way.</p>
        pub fn last_changed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_changed_date = Some(input);
            self
        }
        /// <p>The last date and time that this secret was modified in any way.</p>
        pub fn set_last_changed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_changed_date = input;
            self
        }
        /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
        /// date and therefore shows only the date, not the time.</p>
        pub fn last_accessed_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_accessed_date = Some(input);
            self
        }
        /// <p>The last date that this secret was accessed. This value is truncated to midnight of the
        /// date and therefore shows only the date, not the time.</p>
        pub fn set_last_accessed_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_accessed_date = input;
            self
        }
        /// <p>The date and time the deletion of the secret occurred. Not present on active secrets. The
        /// secret can be recovered until the number of days in the recovery window has passed, as
        /// specified in the <code>RecoveryWindowInDays</code> parameter of the <a>DeleteSecret</a> operation.</p>
        pub fn deleted_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deleted_date = Some(input);
            self
        }
        /// <p>The date and time the deletion of the secret occurred. Not present on active secrets. The
        /// secret can be recovered until the number of days in the recovery window has passed, as
        /// specified in the <code>RecoveryWindowInDays</code> parameter of the <a>DeleteSecret</a> operation.</p>
        pub fn set_deleted_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deleted_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of user-defined tags associated with the secret. To add tags to a
        /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of user-defined tags associated with the secret. To add tags to a
        /// secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `secret_versions_to_stages`.
        ///
        /// To override the contents of this collection use [`set_secret_versions_to_stages`](Self::set_secret_versions_to_stages).
        ///
        /// <p>A list of all of the currently assigned <code>SecretVersionStage</code> staging labels and
        /// the <code>SecretVersionId</code> attached to each one. Staging labels are used to keep
        /// track of the different versions during the rotation process.</p>
        /// <note>
        /// <p>A version that does not have any <code>SecretVersionStage</code> is considered
        /// deprecated and subject to deletion. Such versions are not included in this list.</p>
        /// </note>
        pub fn secret_versions_to_stages(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.secret_versions_to_stages.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.secret_versions_to_stages = Some(hash_map);
            self
        }
        /// <p>A list of all of the currently assigned <code>SecretVersionStage</code> staging labels and
        /// the <code>SecretVersionId</code> attached to each one. Staging labels are used to keep
        /// track of the different versions during the rotation process.</p>
        /// <note>
        /// <p>A version that does not have any <code>SecretVersionStage</code> is considered
        /// deprecated and subject to deletion. Such versions are not included in this list.</p>
        /// </note>
        pub fn set_secret_versions_to_stages(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.secret_versions_to_stages = input;
            self
        }
        /// <p>Returns the name of the service that created the secret.</p>
        pub fn owning_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.owning_service = Some(input.into());
            self
        }
        /// <p>Returns the name of the service that created the secret.</p>
        pub fn set_owning_service(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owning_service = input;
            self
        }
        /// <p>The date and time when a secret was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when a secret was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The Region where Secrets Manager originated the secret.</p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_region = Some(input.into());
            self
        }
        /// <p>The Region where Secrets Manager originated the secret.</p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_region = input;
            self
        }
        /// Consumes the builder and constructs a [`SecretListEntry`](crate::model::SecretListEntry)
        pub fn build(self) -> crate::model::SecretListEntry {
            crate::model::SecretListEntry {
                arn: self.arn,
                name: self.name,
                description: self.description,
                kms_key_id: self.kms_key_id,
                rotation_enabled: self.rotation_enabled,
                rotation_lambda_arn: self.rotation_lambda_arn,
                rotation_rules: self.rotation_rules,
                last_rotated_date: self.last_rotated_date,
                last_changed_date: self.last_changed_date,
                last_accessed_date: self.last_accessed_date,
                deleted_date: self.deleted_date,
                tags: self.tags,
                secret_versions_to_stages: self.secret_versions_to_stages,
                owning_service: self.owning_service,
                created_date: self.created_date,
                primary_region: self.primary_region,
            }
        }
    }
}
impl SecretListEntry {
    /// Creates a new builder-style object to manufacture [`SecretListEntry`](crate::model::SecretListEntry)
    pub fn builder() -> crate::model::secret_list_entry::Builder {
        crate::model::secret_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrderType {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrderType {
    fn from(s: &str) -> Self {
        match s {
            "asc" => SortOrderType::Asc,
            "desc" => SortOrderType::Desc,
            other => SortOrderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrderType::from(s))
    }
}
impl SortOrderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrderType::Asc => "asc",
            SortOrderType::Desc => "desc",
            SortOrderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["asc", "desc"]
    }
}
impl AsRef<str> for SortOrderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Allows you to add filters when you use the search function in Secrets Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>Filters your list of secrets by a specific key.</p>
    pub key: std::option::Option<crate::model::FilterNameStringType>,
    /// <p>Filters your list of secrets by a specific value.</p>
    /// <p>You can prefix your search value with an exclamation mark (<code>!</code>) in order to perform negation filters. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::FilterNameStringType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Filters your list of secrets by a specific key.</p>
        pub fn key(mut self, input: crate::model::FilterNameStringType) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>Filters your list of secrets by a specific key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::FilterNameStringType>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Filters your list of secrets by a specific value.</p>
        /// <p>You can prefix your search value with an exclamation mark (<code>!</code>) in order to perform negation filters. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Filters your list of secrets by a specific value.</p>
        /// <p>You can prefix your search value with an exclamation mark (<code>!</code>) in order to perform negation filters. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterNameStringType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Description,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryRegion,
    #[allow(missing_docs)] // documentation missing in model
    TagKey,
    #[allow(missing_docs)] // documentation missing in model
    TagValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterNameStringType {
    fn from(s: &str) -> Self {
        match s {
            "all" => FilterNameStringType::All,
            "description" => FilterNameStringType::Description,
            "name" => FilterNameStringType::Name,
            "primary-region" => FilterNameStringType::PrimaryRegion,
            "tag-key" => FilterNameStringType::TagKey,
            "tag-value" => FilterNameStringType::TagValue,
            other => FilterNameStringType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterNameStringType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterNameStringType::from(s))
    }
}
impl FilterNameStringType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterNameStringType::All => "all",
            FilterNameStringType::Description => "description",
            FilterNameStringType::Name => "name",
            FilterNameStringType::PrimaryRegion => "primary-region",
            FilterNameStringType::TagKey => "tag-key",
            FilterNameStringType::TagValue => "tag-value",
            FilterNameStringType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "all",
            "description",
            "name",
            "primary-region",
            "tag-key",
            "tag-value",
        ]
    }
}
impl AsRef<str> for FilterNameStringType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
