// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateDiscovererInput`](crate::input::CreateDiscovererInput)
pub mod create_discoverer_input {
    /// A builder for [`CreateDiscovererInput`](crate::input::CreateDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) cross_account: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A description for the discoverer.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the discoverer.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true).</p>
        pub fn cross_account(mut self, input: bool) -> Self {
            self.cross_account = Some(input);
            self
        }
        /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true).</p>
        pub fn set_cross_account(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDiscovererInput`](crate::input::CreateDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDiscovererInput {
                description: self.description,
                source_arn: self.source_arn,
                cross_account: self.cross_account.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDiscovererInputOperationOutputAlias = crate::operation::CreateDiscoverer;
#[doc(hidden)]
pub type CreateDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`CreateDiscoverer`](crate::operation::CreateDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/discoverers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_discoverer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDiscovererInput`](crate::input::CreateDiscovererInput)
    pub fn builder() -> crate::input::create_discoverer_input::Builder {
        crate::input::create_discoverer_input::Builder::default()
    }
}

/// See [`CreateRegistryInput`](crate::input::CreateRegistryInput)
pub mod create_registry_input {
    /// A builder for [`CreateRegistryInput`](crate::input::CreateRegistryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A description of the registry to be created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the registry to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate with the registry.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to associate with the registry.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRegistryInput`](crate::input::CreateRegistryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRegistryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRegistryInput {
                description: self.description,
                registry_name: self.registry_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRegistryInputOperationOutputAlias = crate::operation::CreateRegistry;
#[doc(hidden)]
pub type CreateRegistryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRegistryInput {
    /// Consumes the builder and constructs an Operation<[`CreateRegistry`](crate::operation::CreateRegistry)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRegistry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRegistryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.registry_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_1, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRegistryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRegistryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_registry(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRegistry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRegistry",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRegistryInput`](crate::input::CreateRegistryInput)
    pub fn builder() -> crate::input::create_registry_input::Builder {
        crate::input::create_registry_input::Builder::default()
    }
}

/// See [`CreateSchemaInput`](crate::input::CreateSchemaInput)
pub mod create_schema_input {
    /// A builder for [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>The source of the schema definition.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The source of the schema definition.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A description of the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the schema.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the schema.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of schema.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of schema.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaInput`](crate::input::CreateSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSchemaInput {
                content: self.content,
                description: self.description,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                tags: self.tags,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSchemaInputOperationOutputAlias = crate::operation::CreateSchema;
#[doc(hidden)]
pub type CreateSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSchemaInput {
    /// Consumes the builder and constructs an Operation<[`CreateSchema`](crate::operation::CreateSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.registry_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_2, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.schema_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_3, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
}

/// See [`DeleteDiscovererInput`](crate::input::DeleteDiscovererInput)
pub mod delete_discoverer_input {
    /// A builder for [`DeleteDiscovererInput`](crate::input::DeleteDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDiscovererInput`](crate::input::DeleteDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDiscovererInput {
                discoverer_id: self.discoverer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDiscovererInputOperationOutputAlias = crate::operation::DeleteDiscoverer;
#[doc(hidden)]
pub type DeleteDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDiscoverer`](crate::operation::DeleteDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.discoverer_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "discoverer_id",
                        details: "cannot be empty or unset",
                    })?;
            let discoverer_id = aws_smithy_http::label::fmt_string(input_4, false);
            if discoverer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "discoverer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/discoverers/id/{DiscovererId}",
                DiscovererId = discoverer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDiscovererInput`](crate::input::DeleteDiscovererInput)
    pub fn builder() -> crate::input::delete_discoverer_input::Builder {
        crate::input::delete_discoverer_input::Builder::default()
    }
}

/// See [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
pub mod delete_registry_input {
    /// A builder for [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRegistryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRegistryInput {
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRegistryInputOperationOutputAlias = crate::operation::DeleteRegistry;
#[doc(hidden)]
pub type DeleteRegistryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRegistryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRegistry`](crate::operation::DeleteRegistry)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRegistry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRegistryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.registry_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_5, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRegistryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRegistryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRegistry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRegistry",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
    pub fn builder() -> crate::input::delete_registry_input::Builder {
        crate::input::delete_registry_input::Builder::default()
    }
}

/// See [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
pub mod delete_resource_policy_input {
    /// A builder for [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcePolicyInput {
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationOutputAlias = crate::operation::DeleteResourcePolicy;
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcePolicy`](crate::operation::DeleteResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteResourcePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.registry_name {
                query.push_kv(
                    "registryName",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcePolicy",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
}

/// See [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
pub mod delete_schema_input {
    /// A builder for [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSchemaInput {
                registry_name: self.registry_name,
                schema_name: self.schema_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSchemaInputOperationOutputAlias = crate::operation::DeleteSchema;
#[doc(hidden)]
pub type DeleteSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchema`](crate::operation::DeleteSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.registry_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_7, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.schema_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_8, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
}

/// See [`DeleteSchemaVersionInput`](crate::input::DeleteSchemaVersionInput)
pub mod delete_schema_version_input {
    /// A builder for [`DeleteSchemaVersionInput`](crate::input::DeleteSchemaVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// The version number of the schema
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// The version number of the schema
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaVersionInput`](crate::input::DeleteSchemaVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSchemaVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSchemaVersionInput {
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSchemaVersionInputOperationOutputAlias = crate::operation::DeleteSchemaVersion;
#[doc(hidden)]
pub type DeleteSchemaVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSchemaVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchemaVersion`](crate::operation::DeleteSchemaVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchemaVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSchemaVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.registry_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_9, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.schema_name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_10, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.schema_version;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_version",
                        details: "cannot be empty or unset",
                    })?;
            let schema_version = aws_smithy_http::label::fmt_string(input_11, false);
            if schema_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/version/{SchemaVersion}", RegistryName = registry_name, SchemaName = schema_name, SchemaVersion = schema_version).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSchemaVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSchemaVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchemaVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchemaVersion",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSchemaVersionInput`](crate::input::DeleteSchemaVersionInput)
    pub fn builder() -> crate::input::delete_schema_version_input::Builder {
        crate::input::delete_schema_version_input::Builder::default()
    }
}

/// See [`DescribeCodeBindingInput`](crate::input::DescribeCodeBindingInput)
pub mod describe_code_binding_input {
    /// A builder for [`DescribeCodeBindingInput`](crate::input::DescribeCodeBindingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language of the code binding.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The language of the code binding.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCodeBindingInput`](crate::input::DescribeCodeBindingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCodeBindingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCodeBindingInput {
                language: self.language,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCodeBindingInputOperationOutputAlias = crate::operation::DescribeCodeBinding;
#[doc(hidden)]
pub type DescribeCodeBindingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCodeBindingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCodeBinding`](crate::operation::DescribeCodeBinding)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCodeBinding,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCodeBindingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.registry_name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_12, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.schema_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_13, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.language;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "language",
                        details: "cannot be empty or unset",
                    })?;
            let language = aws_smithy_http::label::fmt_string(input_14, false);
            if language.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "language",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/language/{Language}",
                RegistryName = registry_name,
                SchemaName = schema_name,
                Language = language
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeCodeBindingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_15) = &_input.schema_version {
                query.push_kv(
                    "schemaVersion",
                    &aws_smithy_http::query::fmt_string(&inner_15),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCodeBindingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCodeBindingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCodeBinding::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCodeBinding",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCodeBindingInput`](crate::input::DescribeCodeBindingInput)
    pub fn builder() -> crate::input::describe_code_binding_input::Builder {
        crate::input::describe_code_binding_input::Builder::default()
    }
}

/// See [`DescribeDiscovererInput`](crate::input::DescribeDiscovererInput)
pub mod describe_discoverer_input {
    /// A builder for [`DescribeDiscovererInput`](crate::input::DescribeDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDiscovererInput`](crate::input::DescribeDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDiscovererInput {
                discoverer_id: self.discoverer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDiscovererInputOperationOutputAlias = crate::operation::DescribeDiscoverer;
#[doc(hidden)]
pub type DescribeDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDiscoverer`](crate::operation::DescribeDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.discoverer_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "discoverer_id",
                        details: "cannot be empty or unset",
                    })?;
            let discoverer_id = aws_smithy_http::label::fmt_string(input_16, false);
            if discoverer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "discoverer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/discoverers/id/{DiscovererId}",
                DiscovererId = discoverer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDiscovererInput`](crate::input::DescribeDiscovererInput)
    pub fn builder() -> crate::input::describe_discoverer_input::Builder {
        crate::input::describe_discoverer_input::Builder::default()
    }
}

/// See [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
pub mod describe_registry_input {
    /// A builder for [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRegistryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRegistryInput {
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRegistryInputOperationOutputAlias = crate::operation::DescribeRegistry;
#[doc(hidden)]
pub type DescribeRegistryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRegistryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRegistry`](crate::operation::DescribeRegistry)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRegistry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRegistryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.registry_name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_17, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRegistryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRegistryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRegistry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRegistry",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    pub fn builder() -> crate::input::describe_registry_input::Builder {
        crate::input::describe_registry_input::Builder::default()
    }
}

/// See [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
pub mod describe_schema_input {
    /// A builder for [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSchemaInput {
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSchemaInputOperationOutputAlias = crate::operation::DescribeSchema;
#[doc(hidden)]
pub type DescribeSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSchema`](crate::operation::DescribeSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.registry_name;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_18, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.schema_name;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_19, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeSchemaInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.schema_version {
                query.push_kv(
                    "schemaVersion",
                    &aws_smithy_http::query::fmt_string(&inner_20),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    pub fn builder() -> crate::input::describe_schema_input::Builder {
        crate::input::describe_schema_input::Builder::default()
    }
}

/// See [`ExportSchemaInput`](crate::input::ExportSchemaInput)
pub mod export_schema_input {
    /// A builder for [`ExportSchemaInput`](crate::input::ExportSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSchemaInput`](crate::input::ExportSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportSchemaInput {
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportSchemaInputOperationOutputAlias = crate::operation::ExportSchema;
#[doc(hidden)]
pub type ExportSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportSchemaInput {
    /// Consumes the builder and constructs an Operation<[`ExportSchema`](crate::operation::ExportSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.registry_name;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_21, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.schema_name;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_22, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/export",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ExportSchemaInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_23) = &_input.schema_version {
                query.push_kv(
                    "schemaVersion",
                    &aws_smithy_http::query::fmt_string(&inner_23),
                );
            }
            if let Some(inner_24) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportSchemaInput`](crate::input::ExportSchemaInput)
    pub fn builder() -> crate::input::export_schema_input::Builder {
        crate::input::export_schema_input::Builder::default()
    }
}

/// See [`GetCodeBindingSourceInput`](crate::input::GetCodeBindingSourceInput)
pub mod get_code_binding_source_input {
    /// A builder for [`GetCodeBindingSourceInput`](crate::input::GetCodeBindingSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language of the code binding.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The language of the code binding.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCodeBindingSourceInput`](crate::input::GetCodeBindingSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCodeBindingSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCodeBindingSourceInput {
                language: self.language,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCodeBindingSourceInputOperationOutputAlias = crate::operation::GetCodeBindingSource;
#[doc(hidden)]
pub type GetCodeBindingSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCodeBindingSourceInput {
    /// Consumes the builder and constructs an Operation<[`GetCodeBindingSource`](crate::operation::GetCodeBindingSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCodeBindingSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCodeBindingSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.registry_name;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_25, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.schema_name;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_26, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.language;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "language",
                        details: "cannot be empty or unset",
                    })?;
            let language = aws_smithy_http::label::fmt_string(input_27, false);
            if language.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "language",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/language/{Language}/source", RegistryName = registry_name, SchemaName = schema_name, Language = language).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetCodeBindingSourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.schema_version {
                query.push_kv(
                    "schemaVersion",
                    &aws_smithy_http::query::fmt_string(&inner_28),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCodeBindingSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCodeBindingSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCodeBindingSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCodeBindingSource",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCodeBindingSourceInput`](crate::input::GetCodeBindingSourceInput)
    pub fn builder() -> crate::input::get_code_binding_source_input::Builder {
        crate::input::get_code_binding_source_input::Builder::default()
    }
}

/// See [`GetDiscoveredSchemaInput`](crate::input::GetDiscoveredSchemaInput)
pub mod get_discovered_schema_input {
    /// A builder for [`GetDiscoveredSchemaInput`](crate::input::GetDiscoveredSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of strings where each string is a JSON event. These are the events that were used to generate the schema. The array includes a single type of event and has a maximum size of 10 events.</p>
        pub fn events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>An array of strings where each string is a JSON event. These are the events that were used to generate the schema. The array includes a single type of event and has a maximum size of 10 events.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The type of event.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of event.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiscoveredSchemaInput`](crate::input::GetDiscoveredSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDiscoveredSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDiscoveredSchemaInput {
                events: self.events,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDiscoveredSchemaInputOperationOutputAlias = crate::operation::GetDiscoveredSchema;
#[doc(hidden)]
pub type GetDiscoveredSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDiscoveredSchemaInput {
    /// Consumes the builder and constructs an Operation<[`GetDiscoveredSchema`](crate::operation::GetDiscoveredSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDiscoveredSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDiscoveredSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/discover").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDiscoveredSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDiscoveredSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_discovered_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDiscoveredSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDiscoveredSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDiscoveredSchemaInput`](crate::input::GetDiscoveredSchemaInput)
    pub fn builder() -> crate::input::get_discovered_schema_input::Builder {
        crate::input::get_discovered_schema_input::Builder::default()
    }
}

/// See [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
pub mod get_resource_policy_input {
    /// A builder for [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcePolicyInput {
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcePolicyInputOperationOutputAlias = crate::operation::GetResourcePolicy;
#[doc(hidden)]
pub type GetResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetResourcePolicy`](crate::operation::GetResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetResourcePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.registry_name {
                query.push_kv(
                    "registryName",
                    &aws_smithy_http::query::fmt_string(&inner_29),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourcePolicy",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
}

/// See [`ListDiscoverersInput`](crate::input::ListDiscoverersInput)
pub mod list_discoverers_input {
    /// A builder for [`ListDiscoverersInput`](crate::input::ListDiscoverersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id_prefix: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) source_arn_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifying this limits the results to only those discoverer IDs that start with the specified prefix.</p>
        pub fn discoverer_id_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those discoverer IDs that start with the specified prefix.</p>
        pub fn set_discoverer_id_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id_prefix = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifying this limits the results to only those ARNs that start with the specified prefix.</p>
        pub fn source_arn_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those ARNs that start with the specified prefix.</p>
        pub fn set_source_arn_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_arn_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDiscoverersInput`](crate::input::ListDiscoverersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDiscoverersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDiscoverersInput {
                discoverer_id_prefix: self.discoverer_id_prefix,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
                source_arn_prefix: self.source_arn_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDiscoverersInputOperationOutputAlias = crate::operation::ListDiscoverers;
#[doc(hidden)]
pub type ListDiscoverersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDiscoverersInput {
    /// Consumes the builder and constructs an Operation<[`ListDiscoverers`](crate::operation::ListDiscoverers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDiscoverers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDiscoverersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/discoverers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDiscoverersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.discoverer_id_prefix {
                query.push_kv(
                    "discovererIdPrefix",
                    &aws_smithy_http::query::fmt_string(&inner_30),
                );
            }
            if _input.limit != 0 {
                query.push_kv(
                    "limit",
                    aws_smithy_types::primitive::Encoder::from(_input.limit).encode(),
                );
            }
            if let Some(inner_31) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_31));
            }
            if let Some(inner_32) = &_input.source_arn_prefix {
                query.push_kv(
                    "sourceArnPrefix",
                    &aws_smithy_http::query::fmt_string(&inner_32),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDiscoverersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDiscoverersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDiscoverers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDiscoverers",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDiscoverersInput`](crate::input::ListDiscoverersInput)
    pub fn builder() -> crate::input::list_discoverers_input::Builder {
        crate::input::list_discoverers_input::Builder::default()
    }
}

/// See [`ListRegistriesInput`](crate::input::ListRegistriesInput)
pub mod list_registries_input {
    /// A builder for [`ListRegistriesInput`](crate::input::ListRegistriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) registry_name_prefix: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifying this limits the results to only those registry names that start with the specified prefix.</p>
        pub fn registry_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those registry names that start with the specified prefix.</p>
        pub fn set_registry_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name_prefix = input;
            self
        }
        /// <p>Can be set to Local or AWS to limit responses to your custom registries, or the ones provided by AWS.</p>
        pub fn scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.scope = Some(input.into());
            self
        }
        /// <p>Can be set to Local or AWS to limit responses to your custom registries, or the ones provided by AWS.</p>
        pub fn set_scope(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scope = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegistriesInput`](crate::input::ListRegistriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRegistriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRegistriesInput {
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
                registry_name_prefix: self.registry_name_prefix,
                scope: self.scope,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRegistriesInputOperationOutputAlias = crate::operation::ListRegistries;
#[doc(hidden)]
pub type ListRegistriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRegistriesInput {
    /// Consumes the builder and constructs an Operation<[`ListRegistries`](crate::operation::ListRegistries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRegistries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRegistriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/registries").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRegistriesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.limit != 0 {
                query.push_kv(
                    "limit",
                    aws_smithy_types::primitive::Encoder::from(_input.limit).encode(),
                );
            }
            if let Some(inner_33) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.registry_name_prefix {
                query.push_kv(
                    "registryNamePrefix",
                    &aws_smithy_http::query::fmt_string(&inner_34),
                );
            }
            if let Some(inner_35) = &_input.scope {
                query.push_kv("scope", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRegistriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRegistriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRegistries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRegistries",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRegistriesInput`](crate::input::ListRegistriesInput)
    pub fn builder() -> crate::input::list_registries_input::Builder {
        crate::input::list_registries_input::Builder::default()
    }
}

/// See [`ListSchemasInput`](crate::input::ListSchemasInput)
pub mod list_schemas_input {
    /// A builder for [`ListSchemasInput`](crate::input::ListSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>Specifying this limits the results to only those schema names that start with the specified prefix.</p>
        pub fn schema_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name_prefix = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those schema names that start with the specified prefix.</p>
        pub fn set_schema_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_name_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasInput`](crate::input::ListSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchemasInput {
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
                registry_name: self.registry_name,
                schema_name_prefix: self.schema_name_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchemasInputOperationOutputAlias = crate::operation::ListSchemas;
#[doc(hidden)]
pub type ListSchemasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSchemasInput {
    /// Consumes the builder and constructs an Operation<[`ListSchemas`](crate::operation::ListSchemas)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchemas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.registry_name;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_36, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSchemasInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.limit != 0 {
                query.push_kv(
                    "limit",
                    aws_smithy_types::primitive::Encoder::from(_input.limit).encode(),
                );
            }
            if let Some(inner_37) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            if let Some(inner_38) = &_input.schema_name_prefix {
                query.push_kv(
                    "schemaNamePrefix",
                    &aws_smithy_http::query::fmt_string(&inner_38),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchemas",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
}

/// See [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
pub mod list_schema_versions_input {
    /// A builder for [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchemaVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchemaVersionsInput {
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchemaVersionsInputOperationOutputAlias = crate::operation::ListSchemaVersions;
#[doc(hidden)]
pub type ListSchemaVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSchemaVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSchemaVersions`](crate::operation::ListSchemaVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchemaVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchemaVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.registry_name;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_39, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_40 = &_input.schema_name;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_40, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/versions",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSchemaVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.limit != 0 {
                query.push_kv(
                    "limit",
                    aws_smithy_types::primitive::Encoder::from(_input.limit).encode(),
                );
            }
            if let Some(inner_41) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchemaVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchemaVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchemaVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchemaVersions",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
    pub fn builder() -> crate::input::list_schema_versions_input::Builder {
        crate::input::list_schema_versions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.resource_arn;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_42, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutCodeBindingInput`](crate::input::PutCodeBindingInput)
pub mod put_code_binding_input {
    /// A builder for [`PutCodeBindingInput`](crate::input::PutCodeBindingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language of the code binding.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The language of the code binding.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only this schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Consumes the builder and constructs a [`PutCodeBindingInput`](crate::input::PutCodeBindingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutCodeBindingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutCodeBindingInput {
                language: self.language,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
            })
        }
    }
}
#[doc(hidden)]
pub type PutCodeBindingInputOperationOutputAlias = crate::operation::PutCodeBinding;
#[doc(hidden)]
pub type PutCodeBindingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutCodeBindingInput {
    /// Consumes the builder and constructs an Operation<[`PutCodeBinding`](crate::operation::PutCodeBinding)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutCodeBinding,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutCodeBindingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.registry_name;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_43, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_44 = &_input.schema_name;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_44, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_45 = &_input.language;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "language",
                        details: "cannot be empty or unset",
                    })?;
            let language = aws_smithy_http::label::fmt_string(input_45, false);
            if language.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "language",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}/language/{Language}",
                RegistryName = registry_name,
                SchemaName = schema_name,
                Language = language
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PutCodeBindingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_46) = &_input.schema_version {
                query.push_kv(
                    "schemaVersion",
                    &aws_smithy_http::query::fmt_string(&inner_46),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutCodeBindingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutCodeBindingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutCodeBinding::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutCodeBinding",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutCodeBindingInput`](crate::input::PutCodeBindingInput)
    pub fn builder() -> crate::input::put_code_binding_input::Builder {
        crate::input::put_code_binding_input::Builder::default()
    }
}

/// See [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
pub mod put_resource_policy_input {
    /// A builder for [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource-based policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The resource-based policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The revision ID of the policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourcePolicyInput {
                policy: self.policy,
                registry_name: self.registry_name,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourcePolicyInputOperationOutputAlias = crate::operation::PutResourcePolicy;
#[doc(hidden)]
pub type PutResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutResourcePolicy`](crate::operation::PutResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PutResourcePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.registry_name {
                query.push_kv(
                    "registryName",
                    &aws_smithy_http::query::fmt_string(&inner_47),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_resource_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourcePolicy",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
}

/// See [`SearchSchemasInput`](crate::input::SearchSchemasInput)
pub mod search_schemas_input {
    /// A builder for [`SearchSchemasInput`](crate::input::SearchSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keywords: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifying this limits the results to only schemas that include the provided keywords.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.keywords = Some(input.into());
            self
        }
        /// <p>Specifying this limits the results to only schemas that include the provided keywords.</p>
        pub fn set_keywords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keywords = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSchemasInput`](crate::input::SearchSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchSchemasInput {
                keywords: self.keywords,
                limit: self.limit.unwrap_or_default(),
                next_token: self.next_token,
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchSchemasInputOperationOutputAlias = crate::operation::SearchSchemas;
#[doc(hidden)]
pub type SearchSchemasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchSchemasInput {
    /// Consumes the builder and constructs an Operation<[`SearchSchemas`](crate::operation::SearchSchemas)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchSchemas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.registry_name;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_48, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/search",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::SearchSchemasInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_49) = &_input.keywords {
                query.push_kv("keywords", &aws_smithy_http::query::fmt_string(&inner_49));
            }
            if _input.limit != 0 {
                query.push_kv(
                    "limit",
                    aws_smithy_types::primitive::Encoder::from(_input.limit).encode(),
                );
            }
            if let Some(inner_50) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_50));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchSchemas",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchSchemasInput`](crate::input::SearchSchemasInput)
    pub fn builder() -> crate::input::search_schemas_input::Builder {
        crate::input::search_schemas_input::Builder::default()
    }
}

/// See [`StartDiscovererInput`](crate::input::StartDiscovererInput)
pub mod start_discoverer_input {
    /// A builder for [`StartDiscovererInput`](crate::input::StartDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDiscovererInput`](crate::input::StartDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDiscovererInput {
                discoverer_id: self.discoverer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDiscovererInputOperationOutputAlias = crate::operation::StartDiscoverer;
#[doc(hidden)]
pub type StartDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`StartDiscoverer`](crate::operation::StartDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.discoverer_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "discoverer_id",
                        details: "cannot be empty or unset",
                    })?;
            let discoverer_id = aws_smithy_http::label::fmt_string(input_51, false);
            if discoverer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "discoverer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/discoverers/id/{DiscovererId}/start",
                DiscovererId = discoverer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDiscovererInput`](crate::input::StartDiscovererInput)
    pub fn builder() -> crate::input::start_discoverer_input::Builder {
        crate::input::start_discoverer_input::Builder::default()
    }
}

/// See [`StopDiscovererInput`](crate::input::StopDiscovererInput)
pub mod stop_discoverer_input {
    /// A builder for [`StopDiscovererInput`](crate::input::StopDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDiscovererInput`](crate::input::StopDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDiscovererInput {
                discoverer_id: self.discoverer_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDiscovererInputOperationOutputAlias = crate::operation::StopDiscoverer;
#[doc(hidden)]
pub type StopDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`StopDiscoverer`](crate::operation::StopDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.discoverer_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "discoverer_id",
                        details: "cannot be empty or unset",
                    })?;
            let discoverer_id = aws_smithy_http::label::fmt_string(input_52, false);
            if discoverer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "discoverer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/discoverers/id/{DiscovererId}/stop",
                DiscovererId = discoverer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDiscovererInput`](crate::input::StopDiscovererInput)
    pub fn builder() -> crate::input::stop_discoverer_input::Builder {
        crate::input::stop_discoverer_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.resource_arn;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_53, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of key-value pairs.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys of key-value pairs.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.resource_arn;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_54, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_55) = &_input.tag_keys {
                for inner_56 in inner_55 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_56));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDiscovererInput`](crate::input::UpdateDiscovererInput)
pub mod update_discoverer_input {
    /// A builder for [`UpdateDiscovererInput`](crate::input::UpdateDiscovererInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) cross_account: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The description of the discoverer to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the discoverer to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true)</p>
        pub fn cross_account(mut self, input: bool) -> Self {
            self.cross_account = Some(input);
            self
        }
        /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true)</p>
        pub fn set_cross_account(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDiscovererInput`](crate::input::UpdateDiscovererInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDiscovererInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDiscovererInput {
                description: self.description,
                discoverer_id: self.discoverer_id,
                cross_account: self.cross_account.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDiscovererInputOperationOutputAlias = crate::operation::UpdateDiscoverer;
#[doc(hidden)]
pub type UpdateDiscovererInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDiscovererInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDiscoverer`](crate::operation::UpdateDiscoverer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDiscoverer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDiscovererInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.discoverer_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "discoverer_id",
                        details: "cannot be empty or unset",
                    })?;
            let discoverer_id = aws_smithy_http::label::fmt_string(input_57, false);
            if discoverer_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "discoverer_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/discoverers/id/{DiscovererId}",
                DiscovererId = discoverer_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDiscovererInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDiscovererInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_discoverer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDiscoverer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDiscoverer",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDiscovererInput`](crate::input::UpdateDiscovererInput)
    pub fn builder() -> crate::input::update_discoverer_input::Builder {
        crate::input::update_discoverer_input::Builder::default()
    }
}

/// See [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
pub mod update_registry_input {
    /// A builder for [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description of the registry to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the registry to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRegistryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRegistryInput {
                description: self.description,
                registry_name: self.registry_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRegistryInputOperationOutputAlias = crate::operation::UpdateRegistry;
#[doc(hidden)]
pub type UpdateRegistryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRegistryInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRegistry`](crate::operation::UpdateRegistry)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRegistry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRegistryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.registry_name;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_58, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}",
                RegistryName = registry_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRegistryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRegistryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_registry(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRegistry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRegistry",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
    pub fn builder() -> crate::input::update_registry_input::Builder {
        crate::input::update_registry_input::Builder::default()
    }
}

/// See [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
pub mod update_schema_input {
    /// A builder for [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>The ID of the client token.</p>
        pub fn client_token_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token_id = Some(input.into());
            self
        }
        /// <p>The ID of the client token.</p>
        pub fn set_client_token_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_token_id = input;
            self
        }
        /// <p>The source of the schema definition.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The source of the schema definition.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The description of the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The schema type for the events schema.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The schema type for the events schema.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSchemaInput {
                client_token_id: self.client_token_id,
                content: self.content,
                description: self.description,
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSchemaInputOperationOutputAlias = crate::operation::UpdateSchema;
#[doc(hidden)]
pub type UpdateSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSchemaInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSchema`](crate::operation::UpdateSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_59 = &_input.registry_name;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "registry_name",
                        details: "cannot be empty or unset",
                    })?;
            let registry_name = aws_smithy_http::label::fmt_string(input_59, false);
            if registry_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "registry_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_60 = &_input.schema_name;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "schema_name",
                        details: "cannot be empty or unset",
                    })?;
            let schema_name = aws_smithy_http::label::fmt_string(input_60, false);
            if schema_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "schema_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/registries/name/{RegistryName}/schemas/name/{SchemaName}",
                RegistryName = registry_name,
                SchemaName = schema_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token_id.is_none() {
            self.client_token_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSchema",
            "schemas",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    pub fn builder() -> crate::input::update_schema_input::Builder {
        crate::input::update_schema_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSchemaInput {
    /// <p>The ID of the client token.</p>
    pub client_token_id: std::option::Option<std::string::String>,
    /// <p>The source of the schema definition.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The description of the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The schema type for the events schema.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl UpdateSchemaInput {
    /// <p>The ID of the client token.</p>
    pub fn client_token_id(&self) -> std::option::Option<&str> {
        self.client_token_id.as_deref()
    }
    /// <p>The source of the schema definition.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The description of the schema.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The schema type for the events schema.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UpdateSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSchemaInput");
        formatter.field("client_token_id", &self.client_token_id);
        formatter.field("content", &self.content);
        formatter.field("description", &self.description);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>Updates the registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegistryInput {
    /// <p>The description of the registry to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl UpdateRegistryInput {
    /// <p>The description of the registry to update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRegistryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegistryInput");
        formatter.field("description", &self.description);
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDiscovererInput {
    /// <p>The description of the discoverer to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true)</p>
    pub cross_account: bool,
}
impl UpdateDiscovererInput {
    /// <p>The description of the discoverer to update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true)</p>
    pub fn cross_account(&self) -> bool {
        self.cross_account
    }
}
impl std::fmt::Debug for UpdateDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDiscovererInput");
        formatter.field("description", &self.description);
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("cross_account", &self.cross_account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys of key-value pairs.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys of key-value pairs.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
}
impl StopDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
}
impl std::fmt::Debug for StopDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDiscovererInput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
}
impl StartDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
}
impl std::fmt::Debug for StartDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDiscovererInput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSchemasInput {
    /// <p>Specifying this limits the results to only schemas that include the provided keywords.</p>
    pub keywords: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl SearchSchemasInput {
    /// <p>Specifying this limits the results to only schemas that include the provided keywords.</p>
    pub fn keywords(&self) -> std::option::Option<&str> {
        self.keywords.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for SearchSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSchemasInput");
        formatter.field("keywords", &self.keywords);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

/// <p>The name of the policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyInput {
    /// <p>The resource-based policy.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The revision ID of the policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl PutResourcePolicyInput {
    /// <p>The resource-based policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The revision ID of the policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for PutResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyInput");
        formatter.field("policy", &self.policy);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutCodeBindingInput {
    /// <p>The language of the code binding.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl PutCodeBindingInput {
    /// <p>The language of the code binding.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for PutCodeBindingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutCodeBindingInput");
        formatter.field("language", &self.language);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemaVersionsInput {
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
}
impl ListSchemaVersionsInput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
}
impl std::fmt::Debug for ListSchemaVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemaVersionsInput");
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasInput {
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only those schema names that start with the specified prefix.</p>
    pub schema_name_prefix: std::option::Option<std::string::String>,
}
impl ListSchemasInput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>Specifying this limits the results to only those schema names that start with the specified prefix.</p>
    pub fn schema_name_prefix(&self) -> std::option::Option<&str> {
        self.schema_name_prefix.as_deref()
    }
}
impl std::fmt::Debug for ListSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasInput");
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name_prefix", &self.schema_name_prefix);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegistriesInput {
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only those registry names that start with the specified prefix.</p>
    pub registry_name_prefix: std::option::Option<std::string::String>,
    /// <p>Can be set to Local or AWS to limit responses to your custom registries, or the ones provided by AWS.</p>
    pub scope: std::option::Option<std::string::String>,
}
impl ListRegistriesInput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifying this limits the results to only those registry names that start with the specified prefix.</p>
    pub fn registry_name_prefix(&self) -> std::option::Option<&str> {
        self.registry_name_prefix.as_deref()
    }
    /// <p>Can be set to Local or AWS to limit responses to your custom registries, or the ones provided by AWS.</p>
    pub fn scope(&self) -> std::option::Option<&str> {
        self.scope.as_deref()
    }
}
impl std::fmt::Debug for ListRegistriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegistriesInput");
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.field("registry_name_prefix", &self.registry_name_prefix);
        formatter.field("scope", &self.scope);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDiscoverersInput {
    /// <p>Specifying this limits the results to only those discoverer IDs that start with the specified prefix.</p>
    pub discoverer_id_prefix: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only those ARNs that start with the specified prefix.</p>
    pub source_arn_prefix: std::option::Option<std::string::String>,
}
impl ListDiscoverersInput {
    /// <p>Specifying this limits the results to only those discoverer IDs that start with the specified prefix.</p>
    pub fn discoverer_id_prefix(&self) -> std::option::Option<&str> {
        self.discoverer_id_prefix.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifying this limits the results to only those ARNs that start with the specified prefix.</p>
    pub fn source_arn_prefix(&self) -> std::option::Option<&str> {
        self.source_arn_prefix.as_deref()
    }
}
impl std::fmt::Debug for ListDiscoverersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDiscoverersInput");
        formatter.field("discoverer_id_prefix", &self.discoverer_id_prefix);
        formatter.field("limit", &self.limit);
        formatter.field("next_token", &self.next_token);
        formatter.field("source_arn_prefix", &self.source_arn_prefix);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl GetResourcePolicyInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDiscoveredSchemaInput {
    /// <p>An array of strings where each string is a JSON event. These are the events that were used to generate the schema. The array includes a single type of event and has a maximum size of 10 events.</p>
    pub events: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of event.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl GetDiscoveredSchemaInput {
    /// <p>An array of strings where each string is a JSON event. These are the events that were used to generate the schema. The array includes a single type of event and has a maximum size of 10 events.</p>
    pub fn events(&self) -> std::option::Option<&[std::string::String]> {
        self.events.as_deref()
    }
    /// <p>The type of event.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for GetDiscoveredSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDiscoveredSchemaInput");
        formatter.field("events", &self.events);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCodeBindingSourceInput {
    /// <p>The language of the code binding.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl GetCodeBindingSourceInput {
    /// <p>The language of the code binding.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for GetCodeBindingSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCodeBindingSourceInput");
        formatter.field("language", &self.language);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSchemaInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
}
impl ExportSchemaInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ExportSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSchemaInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSchemaInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl DescribeSchemaInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSchemaInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistryInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl DescribeRegistryInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeRegistryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistryInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
}
impl DescribeDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDiscovererInput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCodeBindingInput {
    /// <p>The language of the code binding.</p>
    pub language: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
}
impl DescribeCodeBindingInput {
    /// <p>The language of the code binding.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Specifying this limits the results to only this schema version.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeCodeBindingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCodeBindingInput");
        formatter.field("language", &self.language);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaVersionInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// The version number of the schema
    pub schema_version: std::option::Option<std::string::String>,
}
impl DeleteSchemaVersionInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// The version number of the schema
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteSchemaVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaVersionInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
}
impl DeleteSchemaInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistryInput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl DeleteRegistryInput {
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRegistryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistryInput");
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
}
impl DeleteDiscovererInput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDiscovererInput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaInput {
    /// <p>The source of the schema definition.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A description of the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>Tags associated with the schema.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of schema.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl CreateSchemaInput {
    /// <p>The source of the schema definition.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>A description of the schema.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>Tags associated with the schema.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of schema.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CreateSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaInput");
        formatter.field("content", &self.content);
        formatter.field("description", &self.description);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRegistryInput {
    /// <p>A description of the registry to be created.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Tags to associate with the registry.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRegistryInput {
    /// <p>A description of the registry to be created.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>Tags to associate with the registry.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRegistryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRegistryInput");
        formatter.field("description", &self.description);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDiscovererInput {
    /// <p>A description for the discoverer.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true).</p>
    pub cross_account: bool,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDiscovererInput {
    /// <p>A description for the discoverer.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the event bus.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>Support discovery of schemas in events sent to the bus from another account. (default: true).</p>
    pub fn cross_account(&self) -> bool {
        self.cross_account
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDiscovererInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDiscovererInput");
        formatter.field("description", &self.description);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("cross_account", &self.cross_account);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
