// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSchemaOutput {
    /// <p>The description of the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that schema was modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The version number of the schema</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>Key-value pairs associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of the schema.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The date the schema version was created.</p>
    pub version_created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateSchemaOutput {
    /// <p>The description of the schema.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that schema was modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The ARN of the schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The version number of the schema</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>Key-value pairs associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of the schema.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The date the schema version was created.</p>
    pub fn version_created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.version_created_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSchemaOutput");
        formatter.field("description", &self.description);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("version_created_date", &self.version_created_date);
        formatter.finish()
    }
}
/// See [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
pub mod update_schema_output {
    /// A builder for [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) version_created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The description of the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The version number of the schema</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version number of the schema</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of the schema.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the schema.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn version_created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.version_created_date = Some(input);
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn set_version_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.version_created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
        pub fn build(self) -> crate::output::UpdateSchemaOutput {
            crate::output::UpdateSchemaOutput {
                description: self.description,
                last_modified: self.last_modified,
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
                tags: self.tags,
                r#type: self.r#type,
                version_created_date: self.version_created_date,
            }
        }
    }
}
impl UpdateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    pub fn builder() -> crate::output::update_schema_output::Builder {
        crate::output::update_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegistryOutput {
    /// <p>The description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Tags associated with the registry.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateRegistryOutput {
    /// <p>The description of the registry.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the registry.</p>
    pub fn registry_arn(&self) -> std::option::Option<&str> {
        self.registry_arn.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>Tags associated with the registry.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegistryOutput");
        formatter.field("description", &self.description);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
pub mod update_registry_output {
    /// A builder for [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the registry.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the registry.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
        pub fn build(self) -> crate::output::UpdateRegistryOutput {
            crate::output::UpdateRegistryOutput {
                description: self.description,
                registry_arn: self.registry_arn,
                registry_name: self.registry_name,
                tags: self.tags,
            }
        }
    }
}
impl UpdateRegistryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
    pub fn builder() -> crate::output::update_registry_output::Builder {
        crate::output::update_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the discoverer.</p>
    pub discoverer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The state of the discoverer.</p>
    pub state: std::option::Option<crate::model::DiscovererState>,
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub cross_account: bool,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the discoverer.</p>
    pub fn discoverer_arn(&self) -> std::option::Option<&str> {
        self.discoverer_arn.as_deref()
    }
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>The ARN of the event bus.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The state of the discoverer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DiscovererState> {
        self.state.as_ref()
    }
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub fn cross_account(&self) -> bool {
        self.cross_account
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDiscovererOutput");
        formatter.field("description", &self.description);
        formatter.field("discoverer_arn", &self.discoverer_arn);
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("state", &self.state);
        formatter.field("cross_account", &self.cross_account);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateDiscovererOutput`](crate::output::UpdateDiscovererOutput)
pub mod update_discoverer_output {
    /// A builder for [`UpdateDiscovererOutput`](crate::output::UpdateDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) discoverer_arn: std::option::Option<std::string::String>,
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiscovererState>,
        pub(crate) cross_account: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the discoverer.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the discoverer.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn discoverer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn set_discoverer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_arn = input;
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn state(mut self, input: crate::model::DiscovererState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiscovererState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn cross_account(mut self, input: bool) -> Self {
            self.cross_account = Some(input);
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn set_cross_account(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDiscovererOutput`](crate::output::UpdateDiscovererOutput)
        pub fn build(self) -> crate::output::UpdateDiscovererOutput {
            crate::output::UpdateDiscovererOutput {
                description: self.description,
                discoverer_arn: self.discoverer_arn,
                discoverer_id: self.discoverer_id,
                source_arn: self.source_arn,
                state: self.state,
                cross_account: self.cross_account.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl UpdateDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDiscovererOutput`](crate::output::UpdateDiscovererOutput)
    pub fn builder() -> crate::output::update_discoverer_output::Builder {
        crate::output::update_discoverer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDiscovererOutput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>The state of the discoverer.</p>
    pub state: std::option::Option<crate::model::DiscovererState>,
}
impl StopDiscovererOutput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>The state of the discoverer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DiscovererState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for StopDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDiscovererOutput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`StopDiscovererOutput`](crate::output::StopDiscovererOutput)
pub mod stop_discoverer_output {
    /// A builder for [`StopDiscovererOutput`](crate::output::StopDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiscovererState>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn state(mut self, input: crate::model::DiscovererState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiscovererState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDiscovererOutput`](crate::output::StopDiscovererOutput)
        pub fn build(self) -> crate::output::StopDiscovererOutput {
            crate::output::StopDiscovererOutput {
                discoverer_id: self.discoverer_id,
                state: self.state,
            }
        }
    }
}
impl StopDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`StopDiscovererOutput`](crate::output::StopDiscovererOutput)
    pub fn builder() -> crate::output::stop_discoverer_output::Builder {
        crate::output::stop_discoverer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDiscovererOutput {
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>The state of the discoverer.</p>
    pub state: std::option::Option<crate::model::DiscovererState>,
}
impl StartDiscovererOutput {
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>The state of the discoverer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DiscovererState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for StartDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDiscovererOutput");
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`StartDiscovererOutput`](crate::output::StartDiscovererOutput)
pub mod start_discoverer_output {
    /// A builder for [`StartDiscovererOutput`](crate::output::StartDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiscovererState>,
    }
    impl Builder {
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn state(mut self, input: crate::model::DiscovererState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiscovererState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDiscovererOutput`](crate::output::StartDiscovererOutput)
        pub fn build(self) -> crate::output::StartDiscovererOutput {
            crate::output::StartDiscovererOutput {
                discoverer_id: self.discoverer_id,
                state: self.state,
            }
        }
    }
}
impl StartDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`StartDiscovererOutput`](crate::output::StartDiscovererOutput)
    pub fn builder() -> crate::output::start_discoverer_output::Builder {
        crate::output::start_discoverer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSchemasOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of SearchSchemaSummary information.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::SearchSchemaSummary>>,
}
impl SearchSchemasOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of SearchSchemaSummary information.</p>
    pub fn schemas(&self) -> std::option::Option<&[crate::model::SearchSchemaSummary]> {
        self.schemas.as_deref()
    }
}
impl std::fmt::Debug for SearchSchemasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSchemasOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("schemas", &self.schemas);
        formatter.finish()
    }
}
/// See [`SearchSchemasOutput`](crate::output::SearchSchemasOutput)
pub mod search_schemas_output {
    /// A builder for [`SearchSchemasOutput`](crate::output::SearchSchemasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::SearchSchemaSummary>>,
    }
    impl Builder {
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>An array of SearchSchemaSummary information.</p>
        pub fn schemas(mut self, input: impl Into<crate::model::SearchSchemaSummary>) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input.into());
            self.schemas = Some(v);
            self
        }
        /// <p>An array of SearchSchemaSummary information.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchSchemaSummary>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSchemasOutput`](crate::output::SearchSchemasOutput)
        pub fn build(self) -> crate::output::SearchSchemasOutput {
            crate::output::SearchSchemasOutput {
                next_token: self.next_token,
                schemas: self.schemas,
            }
        }
    }
}
impl SearchSchemasOutput {
    /// Creates a new builder-style object to manufacture [`SearchSchemasOutput`](crate::output::SearchSchemasOutput)
    pub fn builder() -> crate::output::search_schemas_output::Builder {
        crate::output::search_schemas_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {
    /// <p>The resource-based policy.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The revision ID of the policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl PutResourcePolicyOutput {
    /// <p>The resource-based policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The revision ID of the policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource-based policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The resource-based policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The revision ID of the policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutCodeBindingOutput {
    /// <p>The time and date that the code binding was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that code bindings were modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version number of the schema.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The current status of code binding generation.</p>
    pub status: std::option::Option<crate::model::CodeGenerationStatus>,
}
impl PutCodeBindingOutput {
    /// <p>The time and date that the code binding was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that code bindings were modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The version number of the schema.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>The current status of code binding generation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CodeGenerationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PutCodeBindingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutCodeBindingOutput");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PutCodeBindingOutput`](crate::output::PutCodeBindingOutput)
pub mod put_code_binding_output {
    /// A builder for [`PutCodeBindingOutput`](crate::output::PutCodeBindingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CodeGenerationStatus>,
    }
    impl Builder {
        /// <p>The time and date that the code binding was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The time and date that the code binding was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that code bindings were modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that code bindings were modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The current status of code binding generation.</p>
        pub fn status(mut self, input: crate::model::CodeGenerationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of code binding generation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CodeGenerationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PutCodeBindingOutput`](crate::output::PutCodeBindingOutput)
        pub fn build(self) -> crate::output::PutCodeBindingOutput {
            crate::output::PutCodeBindingOutput {
                creation_date: self.creation_date,
                last_modified: self.last_modified,
                schema_version: self.schema_version,
                status: self.status,
            }
        }
    }
}
impl PutCodeBindingOutput {
    /// Creates a new builder-style object to manufacture [`PutCodeBindingOutput`](crate::output::PutCodeBindingOutput)
    pub fn builder() -> crate::output::put_code_binding_output::Builder {
        crate::output::put_code_binding_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Key-value pairs associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>Key-value pairs associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemaVersionsOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of schema version summaries.</p>
    pub schema_versions: std::option::Option<std::vec::Vec<crate::model::SchemaVersionSummary>>,
}
impl ListSchemaVersionsOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of schema version summaries.</p>
    pub fn schema_versions(&self) -> std::option::Option<&[crate::model::SchemaVersionSummary]> {
        self.schema_versions.as_deref()
    }
}
impl std::fmt::Debug for ListSchemaVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemaVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("schema_versions", &self.schema_versions);
        formatter.finish()
    }
}
/// See [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
pub mod list_schema_versions_output {
    /// A builder for [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) schema_versions:
            std::option::Option<std::vec::Vec<crate::model::SchemaVersionSummary>>,
    }
    impl Builder {
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `schema_versions`.
        ///
        /// To override the contents of this collection use [`set_schema_versions`](Self::set_schema_versions).
        ///
        /// <p>An array of schema version summaries.</p>
        pub fn schema_versions(
            mut self,
            input: impl Into<crate::model::SchemaVersionSummary>,
        ) -> Self {
            let mut v = self.schema_versions.unwrap_or_default();
            v.push(input.into());
            self.schema_versions = Some(v);
            self
        }
        /// <p>An array of schema version summaries.</p>
        pub fn set_schema_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaVersionSummary>>,
        ) -> Self {
            self.schema_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
        pub fn build(self) -> crate::output::ListSchemaVersionsOutput {
            crate::output::ListSchemaVersionsOutput {
                next_token: self.next_token,
                schema_versions: self.schema_versions,
            }
        }
    }
}
impl ListSchemaVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
    pub fn builder() -> crate::output::list_schema_versions_output::Builder {
        crate::output::list_schema_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of schema summaries.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::SchemaSummary>>,
}
impl ListSchemasOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of schema summaries.</p>
    pub fn schemas(&self) -> std::option::Option<&[crate::model::SchemaSummary]> {
        self.schemas.as_deref()
    }
}
impl std::fmt::Debug for ListSchemasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("schemas", &self.schemas);
        formatter.finish()
    }
}
/// See [`ListSchemasOutput`](crate::output::ListSchemasOutput)
pub mod list_schemas_output {
    /// A builder for [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::SchemaSummary>>,
    }
    impl Builder {
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>An array of schema summaries.</p>
        pub fn schemas(mut self, input: impl Into<crate::model::SchemaSummary>) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input.into());
            self.schemas = Some(v);
            self
        }
        /// <p>An array of schema summaries.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaSummary>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasOutput`](crate::output::ListSchemasOutput)
        pub fn build(self) -> crate::output::ListSchemasOutput {
            crate::output::ListSchemasOutput {
                next_token: self.next_token,
                schemas: self.schemas,
            }
        }
    }
}
impl ListSchemasOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    pub fn builder() -> crate::output::list_schemas_output::Builder {
        crate::output::list_schemas_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegistriesOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of registry summaries.</p>
    pub registries: std::option::Option<std::vec::Vec<crate::model::RegistrySummary>>,
}
impl ListRegistriesOutput {
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of registry summaries.</p>
    pub fn registries(&self) -> std::option::Option<&[crate::model::RegistrySummary]> {
        self.registries.as_deref()
    }
}
impl std::fmt::Debug for ListRegistriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegistriesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("registries", &self.registries);
        formatter.finish()
    }
}
/// See [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
pub mod list_registries_output {
    /// A builder for [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) registries: std::option::Option<std::vec::Vec<crate::model::RegistrySummary>>,
    }
    impl Builder {
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `registries`.
        ///
        /// To override the contents of this collection use [`set_registries`](Self::set_registries).
        ///
        /// <p>An array of registry summaries.</p>
        pub fn registries(mut self, input: impl Into<crate::model::RegistrySummary>) -> Self {
            let mut v = self.registries.unwrap_or_default();
            v.push(input.into());
            self.registries = Some(v);
            self
        }
        /// <p>An array of registry summaries.</p>
        pub fn set_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistrySummary>>,
        ) -> Self {
            self.registries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
        pub fn build(self) -> crate::output::ListRegistriesOutput {
            crate::output::ListRegistriesOutput {
                next_token: self.next_token,
                registries: self.registries,
            }
        }
    }
}
impl ListRegistriesOutput {
    /// Creates a new builder-style object to manufacture [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
    pub fn builder() -> crate::output::list_registries_output::Builder {
        crate::output::list_registries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDiscoverersOutput {
    /// <p>An array of DiscovererSummary information.</p>
    pub discoverers: std::option::Option<std::vec::Vec<crate::model::DiscovererSummary>>,
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDiscoverersOutput {
    /// <p>An array of DiscovererSummary information.</p>
    pub fn discoverers(&self) -> std::option::Option<&[crate::model::DiscovererSummary]> {
        self.discoverers.as_deref()
    }
    /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDiscoverersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDiscoverersOutput");
        formatter.field("discoverers", &self.discoverers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDiscoverersOutput`](crate::output::ListDiscoverersOutput)
pub mod list_discoverers_output {
    /// A builder for [`ListDiscoverersOutput`](crate::output::ListDiscoverersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) discoverers: std::option::Option<std::vec::Vec<crate::model::DiscovererSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `discoverers`.
        ///
        /// To override the contents of this collection use [`set_discoverers`](Self::set_discoverers).
        ///
        /// <p>An array of DiscovererSummary information.</p>
        pub fn discoverers(mut self, input: impl Into<crate::model::DiscovererSummary>) -> Self {
            let mut v = self.discoverers.unwrap_or_default();
            v.push(input.into());
            self.discoverers = Some(v);
            self
        }
        /// <p>An array of DiscovererSummary information.</p>
        pub fn set_discoverers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DiscovererSummary>>,
        ) -> Self {
            self.discoverers = input;
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return. To request the first page, leave NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDiscoverersOutput`](crate::output::ListDiscoverersOutput)
        pub fn build(self) -> crate::output::ListDiscoverersOutput {
            crate::output::ListDiscoverersOutput {
                discoverers: self.discoverers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDiscoverersOutput {
    /// Creates a new builder-style object to manufacture [`ListDiscoverersOutput`](crate::output::ListDiscoverersOutput)
    pub fn builder() -> crate::output::list_discoverers_output::Builder {
        crate::output::list_discoverers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p>The resource-based policy.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The revision ID.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetResourcePolicyOutput {
    /// <p>The resource-based policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The revision ID.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource-based policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The resource-based policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The revision ID.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDiscoveredSchemaOutput {
    /// <p>The source of the schema definition.</p>
    pub content: std::option::Option<std::string::String>,
}
impl GetDiscoveredSchemaOutput {
    /// <p>The source of the schema definition.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for GetDiscoveredSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDiscoveredSchemaOutput");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`GetDiscoveredSchemaOutput`](crate::output::GetDiscoveredSchemaOutput)
pub mod get_discovered_schema_output {
    /// A builder for [`GetDiscoveredSchemaOutput`](crate::output::GetDiscoveredSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source of the schema definition.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The source of the schema definition.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiscoveredSchemaOutput`](crate::output::GetDiscoveredSchemaOutput)
        pub fn build(self) -> crate::output::GetDiscoveredSchemaOutput {
            crate::output::GetDiscoveredSchemaOutput {
                content: self.content,
            }
        }
    }
}
impl GetDiscoveredSchemaOutput {
    /// Creates a new builder-style object to manufacture [`GetDiscoveredSchemaOutput`](crate::output::GetDiscoveredSchemaOutput)
    pub fn builder() -> crate::output::get_discovered_schema_output::Builder {
        crate::output::get_discovered_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCodeBindingSourceOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub body: std::option::Option<aws_smithy_types::Blob>,
}
impl GetCodeBindingSourceOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for GetCodeBindingSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCodeBindingSourceOutput");
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`GetCodeBindingSourceOutput`](crate::output::GetCodeBindingSourceOutput)
pub mod get_code_binding_source_output {
    /// A builder for [`GetCodeBindingSourceOutput`](crate::output::GetCodeBindingSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCodeBindingSourceOutput`](crate::output::GetCodeBindingSourceOutput)
        pub fn build(self) -> crate::output::GetCodeBindingSourceOutput {
            crate::output::GetCodeBindingSourceOutput { body: self.body }
        }
    }
}
impl GetCodeBindingSourceOutput {
    /// Creates a new builder-style object to manufacture [`GetCodeBindingSourceOutput`](crate::output::GetCodeBindingSourceOutput)
    pub fn builder() -> crate::output::get_code_binding_source_output::Builder {
        crate::output::get_code_binding_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSchemaOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub content: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub schema_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub schema_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub schema_version: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
}
impl ExportSchemaOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ExportSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSchemaOutput");
        formatter.field("content", &self.content);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ExportSchemaOutput`](crate::output::ExportSchemaOutput)
pub mod export_schema_output {
    /// A builder for [`ExportSchemaOutput`](crate::output::ExportSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSchemaOutput`](crate::output::ExportSchemaOutput)
        pub fn build(self) -> crate::output::ExportSchemaOutput {
            crate::output::ExportSchemaOutput {
                content: self.content,
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
                r#type: self.r#type,
            }
        }
    }
}
impl ExportSchemaOutput {
    /// Creates a new builder-style object to manufacture [`ExportSchemaOutput`](crate::output::ExportSchemaOutput)
    pub fn builder() -> crate::output::export_schema_output::Builder {
        crate::output::export_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSchemaOutput {
    /// <p>The source of the schema definition.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The description of the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that schema was modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The version number of the schema</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of the schema.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The date the schema version was created.</p>
    pub version_created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeSchemaOutput {
    /// <p>The source of the schema definition.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The description of the schema.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that schema was modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The ARN of the schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The version number of the schema</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of the schema.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The date the schema version was created.</p>
    pub fn version_created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.version_created_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSchemaOutput");
        formatter.field("content", &self.content);
        formatter.field("description", &self.description);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("version_created_date", &self.version_created_date);
        formatter.finish()
    }
}
/// See [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
pub mod describe_schema_output {
    /// A builder for [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) version_created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The source of the schema definition.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The source of the schema definition.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The description of the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The version number of the schema</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version number of the schema</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of the schema.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the schema.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn version_created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.version_created_date = Some(input);
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn set_version_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.version_created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
        pub fn build(self) -> crate::output::DescribeSchemaOutput {
            crate::output::DescribeSchemaOutput {
                content: self.content,
                description: self.description,
                last_modified: self.last_modified,
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
                tags: self.tags,
                r#type: self.r#type,
                version_created_date: self.version_created_date,
            }
        }
    }
}
impl DescribeSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSchemaOutput`](crate::output::DescribeSchemaOutput)
    pub fn builder() -> crate::output::describe_schema_output::Builder {
        crate::output::describe_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistryOutput {
    /// <p>The description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Tags associated with the registry.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeRegistryOutput {
    /// <p>The description of the registry.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the registry.</p>
    pub fn registry_arn(&self) -> std::option::Option<&str> {
        self.registry_arn.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>Tags associated with the registry.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistryOutput");
        formatter.field("description", &self.description);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
pub mod describe_registry_output {
    /// A builder for [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the registry.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the registry.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
        pub fn build(self) -> crate::output::DescribeRegistryOutput {
            crate::output::DescribeRegistryOutput {
                description: self.description,
                registry_arn: self.registry_arn,
                registry_name: self.registry_name,
                tags: self.tags,
            }
        }
    }
}
impl DescribeRegistryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
    pub fn builder() -> crate::output::describe_registry_output::Builder {
        crate::output::describe_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the discoverer.</p>
    pub discoverer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The state of the discoverer.</p>
    pub state: std::option::Option<crate::model::DiscovererState>,
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub cross_account: bool,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the discoverer.</p>
    pub fn discoverer_arn(&self) -> std::option::Option<&str> {
        self.discoverer_arn.as_deref()
    }
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>The ARN of the event bus.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The state of the discoverer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DiscovererState> {
        self.state.as_ref()
    }
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub fn cross_account(&self) -> bool {
        self.cross_account
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDiscovererOutput");
        formatter.field("description", &self.description);
        formatter.field("discoverer_arn", &self.discoverer_arn);
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("state", &self.state);
        formatter.field("cross_account", &self.cross_account);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeDiscovererOutput`](crate::output::DescribeDiscovererOutput)
pub mod describe_discoverer_output {
    /// A builder for [`DescribeDiscovererOutput`](crate::output::DescribeDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) discoverer_arn: std::option::Option<std::string::String>,
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiscovererState>,
        pub(crate) cross_account: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the discoverer.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the discoverer.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn discoverer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn set_discoverer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_arn = input;
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn state(mut self, input: crate::model::DiscovererState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiscovererState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn cross_account(mut self, input: bool) -> Self {
            self.cross_account = Some(input);
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn set_cross_account(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDiscovererOutput`](crate::output::DescribeDiscovererOutput)
        pub fn build(self) -> crate::output::DescribeDiscovererOutput {
            crate::output::DescribeDiscovererOutput {
                description: self.description,
                discoverer_arn: self.discoverer_arn,
                discoverer_id: self.discoverer_id,
                source_arn: self.source_arn,
                state: self.state,
                cross_account: self.cross_account.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl DescribeDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDiscovererOutput`](crate::output::DescribeDiscovererOutput)
    pub fn builder() -> crate::output::describe_discoverer_output::Builder {
        crate::output::describe_discoverer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCodeBindingOutput {
    /// <p>The time and date that the code binding was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that code bindings were modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version number of the schema.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The current status of code binding generation.</p>
    pub status: std::option::Option<crate::model::CodeGenerationStatus>,
}
impl DescribeCodeBindingOutput {
    /// <p>The time and date that the code binding was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time that code bindings were modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The version number of the schema.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>The current status of code binding generation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CodeGenerationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DescribeCodeBindingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCodeBindingOutput");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeCodeBindingOutput`](crate::output::DescribeCodeBindingOutput)
pub mod describe_code_binding_output {
    /// A builder for [`DescribeCodeBindingOutput`](crate::output::DescribeCodeBindingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CodeGenerationStatus>,
    }
    impl Builder {
        /// <p>The time and date that the code binding was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The time and date that the code binding was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that code bindings were modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that code bindings were modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The current status of code binding generation.</p>
        pub fn status(mut self, input: crate::model::CodeGenerationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of code binding generation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CodeGenerationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCodeBindingOutput`](crate::output::DescribeCodeBindingOutput)
        pub fn build(self) -> crate::output::DescribeCodeBindingOutput {
            crate::output::DescribeCodeBindingOutput {
                creation_date: self.creation_date,
                last_modified: self.last_modified,
                schema_version: self.schema_version,
                status: self.status,
            }
        }
    }
}
impl DescribeCodeBindingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCodeBindingOutput`](crate::output::DescribeCodeBindingOutput)
    pub fn builder() -> crate::output::describe_code_binding_output::Builder {
        crate::output::describe_code_binding_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaVersionOutput {}
impl std::fmt::Debug for DeleteSchemaVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteSchemaVersionOutput`](crate::output::DeleteSchemaVersionOutput)
pub mod delete_schema_version_output {
    /// A builder for [`DeleteSchemaVersionOutput`](crate::output::DeleteSchemaVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSchemaVersionOutput`](crate::output::DeleteSchemaVersionOutput)
        pub fn build(self) -> crate::output::DeleteSchemaVersionOutput {
            crate::output::DeleteSchemaVersionOutput {}
        }
    }
}
impl DeleteSchemaVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaVersionOutput`](crate::output::DeleteSchemaVersionOutput)
    pub fn builder() -> crate::output::delete_schema_version_output::Builder {
        crate::output::delete_schema_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaOutput {}
impl std::fmt::Debug for DeleteSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaOutput");
        formatter.finish()
    }
}
/// See [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
pub mod delete_schema_output {
    /// A builder for [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
        pub fn build(self) -> crate::output::DeleteSchemaOutput {
            crate::output::DeleteSchemaOutput {}
        }
    }
}
impl DeleteSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    pub fn builder() -> crate::output::delete_schema_output::Builder {
        crate::output::delete_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistryOutput {}
impl std::fmt::Debug for DeleteRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistryOutput");
        formatter.finish()
    }
}
/// See [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
pub mod delete_registry_output {
    /// A builder for [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
        pub fn build(self) -> crate::output::DeleteRegistryOutput {
            crate::output::DeleteRegistryOutput {}
        }
    }
}
impl DeleteRegistryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
    pub fn builder() -> crate::output::delete_registry_output::Builder {
        crate::output::delete_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDiscovererOutput {}
impl std::fmt::Debug for DeleteDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDiscovererOutput");
        formatter.finish()
    }
}
/// See [`DeleteDiscovererOutput`](crate::output::DeleteDiscovererOutput)
pub mod delete_discoverer_output {
    /// A builder for [`DeleteDiscovererOutput`](crate::output::DeleteDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDiscovererOutput`](crate::output::DeleteDiscovererOutput)
        pub fn build(self) -> crate::output::DeleteDiscovererOutput {
            crate::output::DeleteDiscovererOutput {}
        }
    }
}
impl DeleteDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDiscovererOutput`](crate::output::DeleteDiscovererOutput)
    pub fn builder() -> crate::output::delete_discoverer_output::Builder {
        crate::output::delete_discoverer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaOutput {
    /// <p>The description of the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that schema was modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The version number of the schema</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>Key-value pairs associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The type of the schema.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The date the schema version was created.</p>
    pub version_created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateSchemaOutput {
    /// <p>The description of the schema.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that schema was modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The ARN of the schema.</p>
    pub fn schema_arn(&self) -> std::option::Option<&str> {
        self.schema_arn.as_deref()
    }
    /// <p>The name of the schema.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The version number of the schema</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>Key-value pairs associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The type of the schema.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The date the schema version was created.</p>
    pub fn version_created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.version_created_date.as_ref()
    }
}
impl std::fmt::Debug for CreateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaOutput");
        formatter.field("description", &self.description);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("version_created_date", &self.version_created_date);
        formatter.finish()
    }
}
/// See [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
pub mod create_schema_output {
    /// A builder for [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) version_created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The description of the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that schema was modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The version number of the schema</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version number of the schema</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Key-value pairs associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The type of the schema.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the schema.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn version_created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.version_created_date = Some(input);
            self
        }
        /// <p>The date the schema version was created.</p>
        pub fn set_version_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.version_created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
        pub fn build(self) -> crate::output::CreateSchemaOutput {
            crate::output::CreateSchemaOutput {
                description: self.description,
                last_modified: self.last_modified,
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                schema_version: self.schema_version,
                tags: self.tags,
                r#type: self.r#type,
                version_created_date: self.version_created_date,
            }
        }
    }
}
impl CreateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    pub fn builder() -> crate::output::create_schema_output::Builder {
        crate::output::create_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRegistryOutput {
    /// <p>The description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Tags associated with the registry.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRegistryOutput {
    /// <p>The description of the registry.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the registry.</p>
    pub fn registry_arn(&self) -> std::option::Option<&str> {
        self.registry_arn.as_deref()
    }
    /// <p>The name of the registry.</p>
    pub fn registry_name(&self) -> std::option::Option<&str> {
        self.registry_name.as_deref()
    }
    /// <p>Tags associated with the registry.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRegistryOutput");
        formatter.field("description", &self.description);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
pub mod create_registry_output {
    /// A builder for [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the registry.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the registry.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
        pub fn build(self) -> crate::output::CreateRegistryOutput {
            crate::output::CreateRegistryOutput {
                description: self.description,
                registry_arn: self.registry_arn,
                registry_name: self.registry_name,
                tags: self.tags,
            }
        }
    }
}
impl CreateRegistryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
    pub fn builder() -> crate::output::create_registry_output::Builder {
        crate::output::create_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the discoverer.</p>
    pub discoverer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the discoverer.</p>
    pub discoverer_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The state of the discoverer.</p>
    pub state: std::option::Option<crate::model::DiscovererState>,
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub cross_account: bool,
    /// <p>Tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDiscovererOutput {
    /// <p>The description of the discoverer.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the discoverer.</p>
    pub fn discoverer_arn(&self) -> std::option::Option<&str> {
        self.discoverer_arn.as_deref()
    }
    /// <p>The ID of the discoverer.</p>
    pub fn discoverer_id(&self) -> std::option::Option<&str> {
        self.discoverer_id.as_deref()
    }
    /// <p>The ARN of the event bus.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The state of the discoverer.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DiscovererState> {
        self.state.as_ref()
    }
    /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
    pub fn cross_account(&self) -> bool {
        self.cross_account
    }
    /// <p>Tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDiscovererOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDiscovererOutput");
        formatter.field("description", &self.description);
        formatter.field("discoverer_arn", &self.discoverer_arn);
        formatter.field("discoverer_id", &self.discoverer_id);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("state", &self.state);
        formatter.field("cross_account", &self.cross_account);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateDiscovererOutput`](crate::output::CreateDiscovererOutput)
pub mod create_discoverer_output {
    /// A builder for [`CreateDiscovererOutput`](crate::output::CreateDiscovererOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) discoverer_arn: std::option::Option<std::string::String>,
        pub(crate) discoverer_id: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiscovererState>,
        pub(crate) cross_account: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The description of the discoverer.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the discoverer.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn discoverer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the discoverer.</p>
        pub fn set_discoverer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_arn = input;
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn discoverer_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.discoverer_id = Some(input.into());
            self
        }
        /// <p>The ID of the discoverer.</p>
        pub fn set_discoverer_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.discoverer_id = input;
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn state(mut self, input: crate::model::DiscovererState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the discoverer.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiscovererState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn cross_account(mut self, input: bool) -> Self {
            self.cross_account = Some(input);
            self
        }
        /// <p>The Status if the discoverer will discover schemas from events sent from another account.</p>
        pub fn set_cross_account(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDiscovererOutput`](crate::output::CreateDiscovererOutput)
        pub fn build(self) -> crate::output::CreateDiscovererOutput {
            crate::output::CreateDiscovererOutput {
                description: self.description,
                discoverer_arn: self.discoverer_arn,
                discoverer_id: self.discoverer_id,
                source_arn: self.source_arn,
                state: self.state,
                cross_account: self.cross_account.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl CreateDiscovererOutput {
    /// Creates a new builder-style object to manufacture [`CreateDiscovererOutput`](crate::output::CreateDiscovererOutput)
    pub fn builder() -> crate::output::create_discoverer_output::Builder {
        crate::output::create_discoverer_output::Builder::default()
    }
}
