// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_discoverer`](crate::client::Client::create_discoverer).
///
/// See [`crate::client::fluent_builders::CreateDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDiscoverer {
    _private: (),
}
impl CreateDiscoverer {
    /// Creates a new builder-style object to manufacture [`CreateDiscovererInput`](crate::input::CreateDiscovererInput)
    pub fn builder() -> crate::input::create_discoverer_input::Builder {
        crate::input::create_discoverer_input::Builder::default()
    }
    /// Creates a new `CreateDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDiscoverer {
    type Output = std::result::Result<
        crate::output::CreateDiscovererOutput,
        crate::error::CreateDiscovererError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_discoverer_error(response)
        } else {
            crate::operation_deser::parse_create_discoverer_response(response)
        }
    }
}

/// Operation shape for `CreateRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_registry`](crate::client::Client::create_registry).
///
/// See [`crate::client::fluent_builders::CreateRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRegistry {
    _private: (),
}
impl CreateRegistry {
    /// Creates a new builder-style object to manufacture [`CreateRegistryInput`](crate::input::CreateRegistryInput)
    pub fn builder() -> crate::input::create_registry_input::Builder {
        crate::input::create_registry_input::Builder::default()
    }
    /// Creates a new `CreateRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRegistry {
    type Output =
        std::result::Result<crate::output::CreateRegistryOutput, crate::error::CreateRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_registry_error(response)
        } else {
            crate::operation_deser::parse_create_registry_response(response)
        }
    }
}

/// Operation shape for `CreateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_schema`](crate::client::Client::create_schema).
///
/// See [`crate::client::fluent_builders::CreateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSchema {
    _private: (),
}
impl CreateSchema {
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
    /// Creates a new `CreateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSchema {
    type Output =
        std::result::Result<crate::output::CreateSchemaOutput, crate::error::CreateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_schema_error(response)
        } else {
            crate::operation_deser::parse_create_schema_response(response)
        }
    }
}

/// Operation shape for `DeleteDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_discoverer`](crate::client::Client::delete_discoverer).
///
/// See [`crate::client::fluent_builders::DeleteDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDiscoverer {
    _private: (),
}
impl DeleteDiscoverer {
    /// Creates a new builder-style object to manufacture [`DeleteDiscovererInput`](crate::input::DeleteDiscovererInput)
    pub fn builder() -> crate::input::delete_discoverer_input::Builder {
        crate::input::delete_discoverer_input::Builder::default()
    }
    /// Creates a new `DeleteDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDiscoverer {
    type Output = std::result::Result<
        crate::output::DeleteDiscovererOutput,
        crate::error::DeleteDiscovererError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_discoverer_error(response)
        } else {
            crate::operation_deser::parse_delete_discoverer_response(response)
        }
    }
}

/// Operation shape for `DeleteRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_registry`](crate::client::Client::delete_registry).
///
/// See [`crate::client::fluent_builders::DeleteRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegistry {
    _private: (),
}
impl DeleteRegistry {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
    pub fn builder() -> crate::input::delete_registry_input::Builder {
        crate::input::delete_registry_input::Builder::default()
    }
    /// Creates a new `DeleteRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegistry {
    type Output =
        std::result::Result<crate::output::DeleteRegistryOutput, crate::error::DeleteRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_registry_error(response)
        } else {
            crate::operation_deser::parse_delete_registry_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema`](crate::client::Client::delete_schema).
///
/// See [`crate::client::fluent_builders::DeleteSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchema {
    _private: (),
}
impl DeleteSchema {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
    /// Creates a new `DeleteSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchema {
    type Output =
        std::result::Result<crate::output::DeleteSchemaOutput, crate::error::DeleteSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_schema_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_response(response)
        }
    }
}

/// Operation shape for `DeleteSchemaVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema_version`](crate::client::Client::delete_schema_version).
///
/// See [`crate::client::fluent_builders::DeleteSchemaVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchemaVersion {
    _private: (),
}
impl DeleteSchemaVersion {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaVersionInput`](crate::input::DeleteSchemaVersionInput)
    pub fn builder() -> crate::input::delete_schema_version_input::Builder {
        crate::input::delete_schema_version_input::Builder::default()
    }
    /// Creates a new `DeleteSchemaVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchemaVersion {
    type Output = std::result::Result<
        crate::output::DeleteSchemaVersionOutput,
        crate::error::DeleteSchemaVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_schema_version_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_version_response(response)
        }
    }
}

/// Operation shape for `DescribeCodeBinding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_code_binding`](crate::client::Client::describe_code_binding).
///
/// See [`crate::client::fluent_builders::DescribeCodeBinding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCodeBinding {
    _private: (),
}
impl DescribeCodeBinding {
    /// Creates a new builder-style object to manufacture [`DescribeCodeBindingInput`](crate::input::DescribeCodeBindingInput)
    pub fn builder() -> crate::input::describe_code_binding_input::Builder {
        crate::input::describe_code_binding_input::Builder::default()
    }
    /// Creates a new `DescribeCodeBinding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCodeBinding {
    type Output = std::result::Result<
        crate::output::DescribeCodeBindingOutput,
        crate::error::DescribeCodeBindingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_code_binding_error(response)
        } else {
            crate::operation_deser::parse_describe_code_binding_response(response)
        }
    }
}

/// Operation shape for `DescribeDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_discoverer`](crate::client::Client::describe_discoverer).
///
/// See [`crate::client::fluent_builders::DescribeDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDiscoverer {
    _private: (),
}
impl DescribeDiscoverer {
    /// Creates a new builder-style object to manufacture [`DescribeDiscovererInput`](crate::input::DescribeDiscovererInput)
    pub fn builder() -> crate::input::describe_discoverer_input::Builder {
        crate::input::describe_discoverer_input::Builder::default()
    }
    /// Creates a new `DescribeDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDiscoverer {
    type Output = std::result::Result<
        crate::output::DescribeDiscovererOutput,
        crate::error::DescribeDiscovererError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_discoverer_error(response)
        } else {
            crate::operation_deser::parse_describe_discoverer_response(response)
        }
    }
}

/// Operation shape for `DescribeRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_registry`](crate::client::Client::describe_registry).
///
/// See [`crate::client::fluent_builders::DescribeRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegistry {
    _private: (),
}
impl DescribeRegistry {
    /// Creates a new builder-style object to manufacture [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    pub fn builder() -> crate::input::describe_registry_input::Builder {
        crate::input::describe_registry_input::Builder::default()
    }
    /// Creates a new `DescribeRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegistry {
    type Output = std::result::Result<
        crate::output::DescribeRegistryOutput,
        crate::error::DescribeRegistryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_registry_error(response)
        } else {
            crate::operation_deser::parse_describe_registry_response(response)
        }
    }
}

/// Operation shape for `DescribeSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_schema`](crate::client::Client::describe_schema).
///
/// See [`crate::client::fluent_builders::DescribeSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSchema {
    _private: (),
}
impl DescribeSchema {
    /// Creates a new builder-style object to manufacture [`DescribeSchemaInput`](crate::input::DescribeSchemaInput)
    pub fn builder() -> crate::input::describe_schema_input::Builder {
        crate::input::describe_schema_input::Builder::default()
    }
    /// Creates a new `DescribeSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSchema {
    type Output =
        std::result::Result<crate::output::DescribeSchemaOutput, crate::error::DescribeSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_schema_error(response)
        } else {
            crate::operation_deser::parse_describe_schema_response(response)
        }
    }
}

/// Operation shape for `ExportSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_schema`](crate::client::Client::export_schema).
///
/// See [`crate::client::fluent_builders::ExportSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportSchema {
    _private: (),
}
impl ExportSchema {
    /// Creates a new builder-style object to manufacture [`ExportSchemaInput`](crate::input::ExportSchemaInput)
    pub fn builder() -> crate::input::export_schema_input::Builder {
        crate::input::export_schema_input::Builder::default()
    }
    /// Creates a new `ExportSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportSchema {
    type Output =
        std::result::Result<crate::output::ExportSchemaOutput, crate::error::ExportSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_schema_error(response)
        } else {
            crate::operation_deser::parse_export_schema_response(response)
        }
    }
}

/// Operation shape for `GetCodeBindingSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_code_binding_source`](crate::client::Client::get_code_binding_source).
///
/// See [`crate::client::fluent_builders::GetCodeBindingSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCodeBindingSource {
    _private: (),
}
impl GetCodeBindingSource {
    /// Creates a new builder-style object to manufacture [`GetCodeBindingSourceInput`](crate::input::GetCodeBindingSourceInput)
    pub fn builder() -> crate::input::get_code_binding_source_input::Builder {
        crate::input::get_code_binding_source_input::Builder::default()
    }
    /// Creates a new `GetCodeBindingSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCodeBindingSource {
    type Output = std::result::Result<
        crate::output::GetCodeBindingSourceOutput,
        crate::error::GetCodeBindingSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_code_binding_source_error(response)
        } else {
            crate::operation_deser::parse_get_code_binding_source_response(response)
        }
    }
}

/// Operation shape for `GetDiscoveredSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_discovered_schema`](crate::client::Client::get_discovered_schema).
///
/// See [`crate::client::fluent_builders::GetDiscoveredSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDiscoveredSchema {
    _private: (),
}
impl GetDiscoveredSchema {
    /// Creates a new builder-style object to manufacture [`GetDiscoveredSchemaInput`](crate::input::GetDiscoveredSchemaInput)
    pub fn builder() -> crate::input::get_discovered_schema_input::Builder {
        crate::input::get_discovered_schema_input::Builder::default()
    }
    /// Creates a new `GetDiscoveredSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDiscoveredSchema {
    type Output = std::result::Result<
        crate::output::GetDiscoveredSchemaOutput,
        crate::error::GetDiscoveredSchemaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_discovered_schema_error(response)
        } else {
            crate::operation_deser::parse_get_discovered_schema_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policy`](crate::client::Client::get_resource_policy).
///
/// See [`crate::client::fluent_builders::GetResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicy {
    _private: (),
}
impl GetResourcePolicy {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicy {
    type Output = std::result::Result<
        crate::output::GetResourcePolicyOutput,
        crate::error::GetResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policy_response(response)
        }
    }
}

/// Operation shape for `ListDiscoverers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_discoverers`](crate::client::Client::list_discoverers).
///
/// See [`crate::client::fluent_builders::ListDiscoverers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDiscoverers {
    _private: (),
}
impl ListDiscoverers {
    /// Creates a new builder-style object to manufacture [`ListDiscoverersInput`](crate::input::ListDiscoverersInput)
    pub fn builder() -> crate::input::list_discoverers_input::Builder {
        crate::input::list_discoverers_input::Builder::default()
    }
    /// Creates a new `ListDiscoverers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDiscoverers {
    type Output = std::result::Result<
        crate::output::ListDiscoverersOutput,
        crate::error::ListDiscoverersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_discoverers_error(response)
        } else {
            crate::operation_deser::parse_list_discoverers_response(response)
        }
    }
}

/// Operation shape for `ListRegistries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_registries`](crate::client::Client::list_registries).
///
/// See [`crate::client::fluent_builders::ListRegistries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegistries {
    _private: (),
}
impl ListRegistries {
    /// Creates a new builder-style object to manufacture [`ListRegistriesInput`](crate::input::ListRegistriesInput)
    pub fn builder() -> crate::input::list_registries_input::Builder {
        crate::input::list_registries_input::Builder::default()
    }
    /// Creates a new `ListRegistries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegistries {
    type Output =
        std::result::Result<crate::output::ListRegistriesOutput, crate::error::ListRegistriesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_registries_error(response)
        } else {
            crate::operation_deser::parse_list_registries_response(response)
        }
    }
}

/// Operation shape for `ListSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schemas`](crate::client::Client::list_schemas).
///
/// See [`crate::client::fluent_builders::ListSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemas {
    _private: (),
}
impl ListSchemas {
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
    /// Creates a new `ListSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemas {
    type Output =
        std::result::Result<crate::output::ListSchemasOutput, crate::error::ListSchemasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schemas_error(response)
        } else {
            crate::operation_deser::parse_list_schemas_response(response)
        }
    }
}

/// Operation shape for `ListSchemaVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schema_versions`](crate::client::Client::list_schema_versions).
///
/// See [`crate::client::fluent_builders::ListSchemaVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemaVersions {
    _private: (),
}
impl ListSchemaVersions {
    /// Creates a new builder-style object to manufacture [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
    pub fn builder() -> crate::input::list_schema_versions_input::Builder {
        crate::input::list_schema_versions_input::Builder::default()
    }
    /// Creates a new `ListSchemaVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemaVersions {
    type Output = std::result::Result<
        crate::output::ListSchemaVersionsOutput,
        crate::error::ListSchemaVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schema_versions_error(response)
        } else {
            crate::operation_deser::parse_list_schema_versions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutCodeBinding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_code_binding`](crate::client::Client::put_code_binding).
///
/// See [`crate::client::fluent_builders::PutCodeBinding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutCodeBinding {
    _private: (),
}
impl PutCodeBinding {
    /// Creates a new builder-style object to manufacture [`PutCodeBindingInput`](crate::input::PutCodeBindingInput)
    pub fn builder() -> crate::input::put_code_binding_input::Builder {
        crate::input::put_code_binding_input::Builder::default()
    }
    /// Creates a new `PutCodeBinding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutCodeBinding {
    type Output =
        std::result::Result<crate::output::PutCodeBindingOutput, crate::error::PutCodeBindingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_put_code_binding_error(response)
        } else {
            crate::operation_deser::parse_put_code_binding_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `SearchSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_schemas`](crate::client::Client::search_schemas).
///
/// See [`crate::client::fluent_builders::SearchSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchSchemas {
    _private: (),
}
impl SearchSchemas {
    /// Creates a new builder-style object to manufacture [`SearchSchemasInput`](crate::input::SearchSchemasInput)
    pub fn builder() -> crate::input::search_schemas_input::Builder {
        crate::input::search_schemas_input::Builder::default()
    }
    /// Creates a new `SearchSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchSchemas {
    type Output =
        std::result::Result<crate::output::SearchSchemasOutput, crate::error::SearchSchemasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_schemas_error(response)
        } else {
            crate::operation_deser::parse_search_schemas_response(response)
        }
    }
}

/// Operation shape for `StartDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_discoverer`](crate::client::Client::start_discoverer).
///
/// See [`crate::client::fluent_builders::StartDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDiscoverer {
    _private: (),
}
impl StartDiscoverer {
    /// Creates a new builder-style object to manufacture [`StartDiscovererInput`](crate::input::StartDiscovererInput)
    pub fn builder() -> crate::input::start_discoverer_input::Builder {
        crate::input::start_discoverer_input::Builder::default()
    }
    /// Creates a new `StartDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDiscoverer {
    type Output = std::result::Result<
        crate::output::StartDiscovererOutput,
        crate::error::StartDiscovererError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_discoverer_error(response)
        } else {
            crate::operation_deser::parse_start_discoverer_response(response)
        }
    }
}

/// Operation shape for `StopDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_discoverer`](crate::client::Client::stop_discoverer).
///
/// See [`crate::client::fluent_builders::StopDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDiscoverer {
    _private: (),
}
impl StopDiscoverer {
    /// Creates a new builder-style object to manufacture [`StopDiscovererInput`](crate::input::StopDiscovererInput)
    pub fn builder() -> crate::input::stop_discoverer_input::Builder {
        crate::input::stop_discoverer_input::Builder::default()
    }
    /// Creates a new `StopDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDiscoverer {
    type Output =
        std::result::Result<crate::output::StopDiscovererOutput, crate::error::StopDiscovererError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_discoverer_error(response)
        } else {
            crate::operation_deser::parse_stop_discoverer_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDiscoverer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_discoverer`](crate::client::Client::update_discoverer).
///
/// See [`crate::client::fluent_builders::UpdateDiscoverer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDiscoverer {
    _private: (),
}
impl UpdateDiscoverer {
    /// Creates a new builder-style object to manufacture [`UpdateDiscovererInput`](crate::input::UpdateDiscovererInput)
    pub fn builder() -> crate::input::update_discoverer_input::Builder {
        crate::input::update_discoverer_input::Builder::default()
    }
    /// Creates a new `UpdateDiscoverer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDiscoverer {
    type Output = std::result::Result<
        crate::output::UpdateDiscovererOutput,
        crate::error::UpdateDiscovererError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_discoverer_error(response)
        } else {
            crate::operation_deser::parse_update_discoverer_response(response)
        }
    }
}

/// Operation shape for `UpdateRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_registry`](crate::client::Client::update_registry).
///
/// See [`crate::client::fluent_builders::UpdateRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegistry {
    _private: (),
}
impl UpdateRegistry {
    /// Creates a new builder-style object to manufacture [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
    pub fn builder() -> crate::input::update_registry_input::Builder {
        crate::input::update_registry_input::Builder::default()
    }
    /// Creates a new `UpdateRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegistry {
    type Output =
        std::result::Result<crate::output::UpdateRegistryOutput, crate::error::UpdateRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_registry_error(response)
        } else {
            crate::operation_deser::parse_update_registry_response(response)
        }
    }
}

/// Operation shape for `UpdateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_schema`](crate::client::Client::update_schema).
///
/// See [`crate::client::fluent_builders::UpdateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSchema {
    _private: (),
}
impl UpdateSchema {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    pub fn builder() -> crate::input::update_schema_input::Builder {
        crate::input::update_schema_input::Builder::default()
    }
    /// Creates a new `UpdateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSchema {
    type Output =
        std::result::Result<crate::output::UpdateSchemaOutput, crate::error::UpdateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_schema_error(response)
        } else {
            crate::operation_deser::parse_update_schema_response(response)
        }
    }
}
