// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDiscovererError {
    /// Kind of error that occurred.
    pub kind: CreateDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDiscovererError {
    fn code(&self) -> Option<&str> {
        CreateDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDiscovererError {
    /// Creates a new `CreateDiscovererError`.
    pub fn new(kind: CreateDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiscovererErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDiscovererErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateDiscovererErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRegistryError {
    /// Kind of error that occurred.
    pub kind: CreateRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRegistryErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ConflictException(crate::error::ConflictException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRegistryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRegistryError {
    fn code(&self) -> Option<&str> {
        CreateRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRegistryError {
    /// Creates a new `CreateRegistryError`.
    pub fn new(kind: CreateRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRegistryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRegistryErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRegistryErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateRegistryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateRegistryErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRegistryErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRegistryErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRegistryErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateRegistryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateRegistryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateRegistryErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSchemaError {
    /// Kind of error that occurred.
    pub kind: CreateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSchemaError {
    fn code(&self) -> Option<&str> {
        CreateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSchemaError {
    /// Creates a new `CreateSchemaError`.
    pub fn new(kind: CreateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDiscovererError {
    /// Kind of error that occurred.
    pub kind: DeleteDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDiscovererError {
    fn code(&self) -> Option<&str> {
        DeleteDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDiscovererError {
    /// Creates a new `DeleteDiscovererError`.
    pub fn new(kind: DeleteDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiscovererErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiscovererErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiscovererErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegistryError {
    /// Kind of error that occurred.
    pub kind: DeleteRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegistryErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegistryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegistryError {
    fn code(&self) -> Option<&str> {
        DeleteRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegistryError {
    /// Creates a new `DeleteRegistryError`.
    pub fn new(kind: DeleteRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegistryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteRegistryErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteRegistryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRegistryErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRegistryErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegistryErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResourcePolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaError {
    /// Creates a new `DeleteSchemaError`.
    pub fn new(kind: DeleteSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaVersionErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaVersionError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaVersionError {
    /// Creates a new `DeleteSchemaVersionError`.
    pub fn new(kind: DeleteSchemaVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSchemaVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteSchemaVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteSchemaVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCodeBinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCodeBindingError {
    /// Kind of error that occurred.
    pub kind: DescribeCodeBindingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCodeBinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCodeBindingErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    TooManyRequestsException(crate::error::TooManyRequestsException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCodeBindingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCodeBindingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeCodeBindingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCodeBindingError {
    fn code(&self) -> Option<&str> {
        DescribeCodeBindingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCodeBindingError {
    /// Creates a new `DescribeCodeBindingError`.
    pub fn new(kind: DescribeCodeBindingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCodeBindingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCodeBindingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCodeBindingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCodeBindingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCodeBindingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeBindingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeCodeBindingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCodeBindingErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeCodeBindingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDiscovererError {
    /// Kind of error that occurred.
    pub kind: DescribeDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDiscovererError {
    fn code(&self) -> Option<&str> {
        DescribeDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDiscovererError {
    /// Creates a new `DescribeDiscovererError`.
    pub fn new(kind: DescribeDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRegistryError {
    /// Kind of error that occurred.
    pub kind: DescribeRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRegistryErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRegistryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRegistryError {
    fn code(&self) -> Option<&str> {
        DescribeRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRegistryError {
    /// Creates a new `DescribeRegistryError`.
    pub fn new(kind: DescribeRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRegistryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegistryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegistryErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeRegistryErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRegistryErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSchemaError {
    /// Kind of error that occurred.
    pub kind: DescribeSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSchemaError {
    fn code(&self) -> Option<&str> {
        DescribeSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSchemaError {
    /// Creates a new `DescribeSchemaError`.
    pub fn new(kind: DescribeSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeSchemaErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeSchemaErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeSchemaErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `DescribeSchemaErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemaErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportSchemaError {
    /// Kind of error that occurred.
    pub kind: ExportSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    TooManyRequestsException(crate::error::TooManyRequestsException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ExportSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportSchemaError {
    fn code(&self) -> Option<&str> {
        ExportSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportSchemaError {
    /// Creates a new `ExportSchemaError`.
    pub fn new(kind: ExportSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ExportSchemaErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ExportSchemaErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ExportSchemaErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSchemaErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ExportSchemaErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ExportSchemaErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ExportSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            ExportSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            ExportSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ExportSchemaErrorKind::NotFoundException(_inner) => Some(_inner),
            ExportSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ExportSchemaErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ExportSchemaErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ExportSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCodeBindingSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCodeBindingSourceError {
    /// Kind of error that occurred.
    pub kind: GetCodeBindingSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCodeBindingSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCodeBindingSourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    TooManyRequestsException(crate::error::TooManyRequestsException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCodeBindingSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCodeBindingSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetCodeBindingSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCodeBindingSourceError {
    fn code(&self) -> Option<&str> {
        GetCodeBindingSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCodeBindingSourceError {
    /// Creates a new `GetCodeBindingSourceError`.
    pub fn new(kind: GetCodeBindingSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCodeBindingSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCodeBindingSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCodeBindingSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCodeBindingSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `GetCodeBindingSourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeBindingSourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetCodeBindingSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCodeBindingSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetCodeBindingSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDiscoveredSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDiscoveredSchemaError {
    /// Kind of error that occurred.
    pub kind: GetDiscoveredSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDiscoveredSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDiscoveredSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDiscoveredSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDiscoveredSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDiscoveredSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetDiscoveredSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetDiscoveredSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetDiscoveredSchemaErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDiscoveredSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDiscoveredSchemaError {
    fn code(&self) -> Option<&str> {
        GetDiscoveredSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDiscoveredSchemaError {
    /// Creates a new `GetDiscoveredSchemaError`.
    pub fn new(kind: GetDiscoveredSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDiscoveredSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDiscoveredSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDiscoveredSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDiscoveredSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDiscoveredSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredSchemaErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetDiscoveredSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredSchemaErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetDiscoveredSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetDiscoveredSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetDiscoveredSchemaErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiscoveredSchemaErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetDiscoveredSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDiscoveredSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDiscoveredSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetDiscoveredSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetDiscoveredSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetDiscoveredSchemaErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDiscoveredSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: GetResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePolicyErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePolicyError {
    fn code(&self) -> Option<&str> {
        GetResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePolicyError {
    /// Creates a new `GetResourcePolicyError`.
    pub fn new(kind: GetResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetResourcePolicyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetResourcePolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDiscoverers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDiscoverersError {
    /// Kind of error that occurred.
    pub kind: ListDiscoverersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDiscoverers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDiscoverersErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDiscoverersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDiscoverersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDiscoverersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListDiscoverersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListDiscoverersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDiscoverersErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDiscoverersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDiscoverersError {
    fn code(&self) -> Option<&str> {
        ListDiscoverersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDiscoverersError {
    /// Creates a new `ListDiscoverersError`.
    pub fn new(kind: ListDiscoverersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDiscoverersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDiscoverersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDiscoverersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDiscoverersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDiscoverersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListDiscoverersErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListDiscoverersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListDiscoverersErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListDiscoverersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoverersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListDiscoverersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoverersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListDiscoverersErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDiscoverersErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListDiscoverersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDiscoverersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDiscoverersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListDiscoverersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListDiscoverersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDiscoverersErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDiscoverersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRegistriesError {
    /// Kind of error that occurred.
    pub kind: ListRegistriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRegistriesErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRegistriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRegistriesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRegistriesError {
    fn code(&self) -> Option<&str> {
        ListRegistriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRegistriesError {
    /// Creates a new `ListRegistriesError`.
    pub fn new(kind: ListRegistriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRegistriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRegistriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRegistriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRegistriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRegistriesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListRegistriesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListRegistriesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListRegistriesErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListRegistriesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListRegistriesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListRegistriesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListRegistriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRegistriesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListRegistriesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListRegistriesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListRegistriesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRegistriesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListRegistriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemasError {
    /// Kind of error that occurred.
    pub kind: ListSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemasErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemasErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemasError {
    fn code(&self) -> Option<&str> {
        ListSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemasError {
    /// Creates a new `ListSchemasError`.
    pub fn new(kind: ListSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSchemasErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListSchemasErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListSchemasErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemasErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemasErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemasErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemasErrorKind::BadRequestException(_inner) => Some(_inner),
            ListSchemasErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListSchemasErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListSchemasErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListSchemasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemaVersionsError {
    /// Kind of error that occurred.
    pub kind: ListSchemaVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemaVersionsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemaVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemaVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemaVersionsError {
    fn code(&self) -> Option<&str> {
        ListSchemaVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemaVersionsError {
    /// Creates a new `ListSchemaVersionsError`.
    pub fn new(kind: ListSchemaVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemaVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemaVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemaVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemaVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `ListSchemaVersionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListSchemaVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemaVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutCodeBinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutCodeBindingError {
    /// Kind of error that occurred.
    pub kind: PutCodeBindingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutCodeBinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutCodeBindingErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    GoneException(crate::error::GoneException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    TooManyRequestsException(crate::error::TooManyRequestsException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutCodeBindingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutCodeBindingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::GoneException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutCodeBindingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutCodeBindingError {
    fn code(&self) -> Option<&str> {
        PutCodeBindingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutCodeBindingError {
    /// Creates a new `PutCodeBindingError`.
    pub fn new(kind: PutCodeBindingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutCodeBindingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutCodeBindingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutCodeBindingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutCodeBindingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutCodeBindingErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PutCodeBindingErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::GoneException`.
    pub fn is_gone_exception(&self) -> bool {
        matches!(&self.kind, PutCodeBindingErrorKind::GoneException(_))
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCodeBindingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutCodeBindingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCodeBindingErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `PutCodeBindingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCodeBindingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutCodeBindingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutCodeBindingErrorKind::BadRequestException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::GoneException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::NotFoundException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutCodeBindingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailedException(crate::error::PreconditionFailedException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutResourcePolicyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `PutResourcePolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchSchemasError {
    /// Kind of error that occurred.
    pub kind: SearchSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchSchemasErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchSchemasErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SearchSchemasErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            SearchSchemasErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            SearchSchemasErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SearchSchemasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            SearchSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchSchemasError {
    fn code(&self) -> Option<&str> {
        SearchSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchSchemasError {
    /// Creates a new `SearchSchemasError`.
    pub fn new(kind: SearchSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchSchemasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchSchemasErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, SearchSchemasErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `SearchSchemasErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, SearchSchemasErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `SearchSchemasErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchSchemasErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `SearchSchemasErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchSchemasErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `SearchSchemasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, SearchSchemasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for SearchSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchSchemasErrorKind::BadRequestException(_inner) => Some(_inner),
            SearchSchemasErrorKind::ForbiddenException(_inner) => Some(_inner),
            SearchSchemasErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            SearchSchemasErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SearchSchemasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            SearchSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDiscovererError {
    /// Kind of error that occurred.
    pub kind: StartDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDiscovererError {
    fn code(&self) -> Option<&str> {
        StartDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDiscovererError {
    /// Creates a new `StartDiscovererError`.
    pub fn new(kind: StartDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartDiscovererErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StartDiscovererErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartDiscovererErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `StartDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StartDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            StartDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            StartDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StartDiscovererErrorKind::NotFoundException(_inner) => Some(_inner),
            StartDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDiscovererError {
    /// Kind of error that occurred.
    pub kind: StopDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StopDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDiscovererError {
    fn code(&self) -> Option<&str> {
        StopDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDiscovererError {
    /// Creates a new `StopDiscovererError`.
    pub fn new(kind: StopDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopDiscovererErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StopDiscovererErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopDiscovererErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `StopDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StopDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            StopDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            StopDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StopDiscovererErrorKind::NotFoundException(_inner) => Some(_inner),
            StopDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StopDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDiscovererError {
    /// Kind of error that occurred.
    pub kind: UpdateDiscovererErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDiscoverer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDiscovererErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDiscovererError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDiscovererErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDiscovererErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDiscovererError {
    fn code(&self) -> Option<&str> {
        UpdateDiscovererError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDiscovererError {
    /// Creates a new `UpdateDiscovererError`.
    pub fn new(kind: UpdateDiscovererErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDiscovererError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDiscovererErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDiscovererError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDiscovererErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDiscovererErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateDiscovererErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDiscovererErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDiscovererErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDiscovererErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDiscovererErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDiscovererErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDiscovererError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDiscovererErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDiscovererErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegistryError {
    /// Kind of error that occurred.
    pub kind: UpdateRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegistryErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegistryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegistryError {
    fn code(&self) -> Option<&str> {
        UpdateRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegistryError {
    /// Creates a new `UpdateRegistryError`.
    pub fn new(kind: UpdateRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegistryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateRegistryErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateRegistryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateRegistryErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRegistryErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegistryErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSchemaError {
    /// Kind of error that occurred.
    pub kind: UpdateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSchemaErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    BadRequestException(crate::error::BadRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalServerErrorException(crate::error::InternalServerErrorException),
    #[allow(missing_docs)] // documentation missing in model
    NotFoundException(crate::error::NotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSchemaErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSchemaError {
    fn code(&self) -> Option<&str> {
        UpdateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSchemaError {
    /// Creates a new `UpdateSchemaError`.
    pub fn new(kind: UpdateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateSchemaErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSchemaErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailedException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailedException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailedException {}
/// See [`PreconditionFailedException`](crate::error::PreconditionFailedException)
pub mod precondition_failed_exception {
    /// A builder for [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailedException`](crate::error::PreconditionFailedException)
        pub fn build(self) -> crate::error::PreconditionFailedException {
            crate::error::PreconditionFailedException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl PreconditionFailedException {
    /// Creates a new builder-style object to manufacture [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    pub fn builder() -> crate::error::precondition_failed_exception::Builder {
        crate::error::precondition_failed_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoneException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GoneException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoneException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GoneException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GoneException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GoneException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for GoneException {}
/// See [`GoneException`](crate::error::GoneException)
pub mod gone_exception {
    /// A builder for [`GoneException`](crate::error::GoneException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GoneException`](crate::error::GoneException)
        pub fn build(self) -> crate::error::GoneException {
            crate::error::GoneException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl GoneException {
    /// Creates a new builder-style object to manufacture [`GoneException`](crate::error::GoneException)
    pub fn builder() -> crate::error::gone_exception::Builder {
        crate::error::gone_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message string of the error output.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message string of the error output.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
