// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateSavingsPlanInput`](crate::input::CreateSavingsPlanInput)
pub mod create_savings_plan_input {
    /// A builder for [`CreateSavingsPlanInput`](crate::input::CreateSavingsPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_offering_id: std::option::Option<std::string::String>,
        pub(crate) commitment: std::option::Option<std::string::String>,
        pub(crate) upfront_payment_amount: std::option::Option<std::string::String>,
        pub(crate) purchase_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the offering.</p>
        pub fn savings_plan_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_savings_plan_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_offering_id = input;
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
        pub fn commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.commitment = Some(input.into());
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
        pub fn set_commitment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commitment = input;
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn upfront_payment_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.upfront_payment_amount = Some(input.into());
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn set_upfront_payment_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upfront_payment_amount = input;
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn purchase_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.purchase_time = Some(input);
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn set_purchase_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.purchase_time = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSavingsPlanInput`](crate::input::CreateSavingsPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSavingsPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSavingsPlanInput {
                savings_plan_offering_id: self.savings_plan_offering_id,
                commitment: self.commitment,
                upfront_payment_amount: self.upfront_payment_amount,
                purchase_time: self.purchase_time,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSavingsPlanInputOperationOutputAlias = crate::operation::CreateSavingsPlan;
#[doc(hidden)]
pub type CreateSavingsPlanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSavingsPlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateSavingsPlan`](crate::operation::CreateSavingsPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSavingsPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSavingsPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateSavingsPlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSavingsPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSavingsPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_savings_plan(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSavingsPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSavingsPlan",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSavingsPlanInput`](crate::input::CreateSavingsPlanInput)
    pub fn builder() -> crate::input::create_savings_plan_input::Builder {
        crate::input::create_savings_plan_input::Builder::default()
    }
}

/// See [`DeleteQueuedSavingsPlanInput`](crate::input::DeleteQueuedSavingsPlanInput)
pub mod delete_queued_savings_plan_input {
    /// A builder for [`DeleteQueuedSavingsPlanInput`](crate::input::DeleteQueuedSavingsPlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_id = Some(input.into());
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQueuedSavingsPlanInput`](crate::input::DeleteQueuedSavingsPlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQueuedSavingsPlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQueuedSavingsPlanInput {
                savings_plan_id: self.savings_plan_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteQueuedSavingsPlanInputOperationOutputAlias =
    crate::operation::DeleteQueuedSavingsPlan;
#[doc(hidden)]
pub type DeleteQueuedSavingsPlanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteQueuedSavingsPlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQueuedSavingsPlan`](crate::operation::DeleteQueuedSavingsPlan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQueuedSavingsPlan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQueuedSavingsPlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteQueuedSavingsPlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQueuedSavingsPlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQueuedSavingsPlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_queued_savings_plan(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQueuedSavingsPlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQueuedSavingsPlan",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQueuedSavingsPlanInput`](crate::input::DeleteQueuedSavingsPlanInput)
    pub fn builder() -> crate::input::delete_queued_savings_plan_input::Builder {
        crate::input::delete_queued_savings_plan_input::Builder::default()
    }
}

/// See [`DescribeSavingsPlanRatesInput`](crate::input::DescribeSavingsPlanRatesInput)
pub mod describe_savings_plan_rates_input {
    /// A builder for [`DescribeSavingsPlanRatesInput`](crate::input::DescribeSavingsPlanRatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_id = Some(input.into());
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanRateFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSavingsPlanRatesInput`](crate::input::DescribeSavingsPlanRatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSavingsPlanRatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSavingsPlanRatesInput {
                savings_plan_id: self.savings_plan_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSavingsPlanRatesInputOperationOutputAlias =
    crate::operation::DescribeSavingsPlanRates;
#[doc(hidden)]
pub type DescribeSavingsPlanRatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSavingsPlanRatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSavingsPlanRates`](crate::operation::DescribeSavingsPlanRates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSavingsPlanRates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSavingsPlanRatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeSavingsPlanRates").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSavingsPlanRatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSavingsPlanRatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_savings_plan_rates(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSavingsPlanRates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSavingsPlanRates",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSavingsPlanRatesInput`](crate::input::DescribeSavingsPlanRatesInput)
    pub fn builder() -> crate::input::describe_savings_plan_rates_input::Builder {
        crate::input::describe_savings_plan_rates_input::Builder::default()
    }
}

/// See [`DescribeSavingsPlansInput`](crate::input::DescribeSavingsPlansInput)
pub mod describe_savings_plans_input {
    /// A builder for [`DescribeSavingsPlansInput`](crate::input::DescribeSavingsPlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) savings_plan_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::SavingsPlanState>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SavingsPlanFilter>>,
    }
    impl Builder {
        /// Appends an item to `savings_plan_arns`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_arns`](Self::set_savings_plan_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn savings_plan_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.savings_plan_arns.unwrap_or_default();
            v.push(input.into());
            self.savings_plan_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn set_savings_plan_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.savings_plan_arns = input;
            self
        }
        /// Appends an item to `savings_plan_ids`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_ids`](Self::set_savings_plan_ids).
        ///
        /// <p>The IDs of the Savings Plans.</p>
        pub fn savings_plan_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.savings_plan_ids.unwrap_or_default();
            v.push(input.into());
            self.savings_plan_ids = Some(v);
            self
        }
        /// <p>The IDs of the Savings Plans.</p>
        pub fn set_savings_plan_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.savings_plan_ids = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states.</p>
        pub fn states(mut self, input: crate::model::SavingsPlanState) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p>The states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSavingsPlansInput`](crate::input::DescribeSavingsPlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSavingsPlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSavingsPlansInput {
                savings_plan_arns: self.savings_plan_arns,
                savings_plan_ids: self.savings_plan_ids,
                next_token: self.next_token,
                max_results: self.max_results,
                states: self.states,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSavingsPlansInputOperationOutputAlias = crate::operation::DescribeSavingsPlans;
#[doc(hidden)]
pub type DescribeSavingsPlansInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSavingsPlansInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSavingsPlans`](crate::operation::DescribeSavingsPlans)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSavingsPlans,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSavingsPlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeSavingsPlans").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSavingsPlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSavingsPlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_savings_plans(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSavingsPlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSavingsPlans",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSavingsPlansInput`](crate::input::DescribeSavingsPlansInput)
    pub fn builder() -> crate::input::describe_savings_plans_input::Builder {
        crate::input::describe_savings_plans_input::Builder::default()
    }
}

/// See [`DescribeSavingsPlansOfferingRatesInput`](crate::input::DescribeSavingsPlansOfferingRatesInput)
pub mod describe_savings_plans_offering_rates_input {
    /// A builder for [`DescribeSavingsPlansOfferingRatesInput`](crate::input::DescribeSavingsPlansOfferingRatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_offering_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) savings_plan_payment_options:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        pub(crate) savings_plan_types:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        pub(crate) products:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        pub(crate) service_codes:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateServiceCode>>,
        pub(crate) usage_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingRateFilterElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `savings_plan_offering_ids`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_offering_ids`](Self::set_savings_plan_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn savings_plan_offering_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.savings_plan_offering_ids.unwrap_or_default();
            v.push(input.into());
            self.savings_plan_offering_ids = Some(v);
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_savings_plan_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.savings_plan_offering_ids = input;
            self
        }
        /// Appends an item to `savings_plan_payment_options`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_payment_options`](Self::set_savings_plan_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn savings_plan_payment_options(
            mut self,
            input: crate::model::SavingsPlanPaymentOption,
        ) -> Self {
            let mut v = self.savings_plan_payment_options.unwrap_or_default();
            v.push(input);
            self.savings_plan_payment_options = Some(v);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_savings_plan_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.savings_plan_payment_options = input;
            self
        }
        /// Appends an item to `savings_plan_types`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_types`](Self::set_savings_plan_types).
        ///
        /// <p>The plan types.</p>
        pub fn savings_plan_types(mut self, input: crate::model::SavingsPlanType) -> Self {
            let mut v = self.savings_plan_types.unwrap_or_default();
            v.push(input);
            self.savings_plan_types = Some(v);
            self
        }
        /// <p>The plan types.</p>
        pub fn set_savings_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.savings_plan_types = input;
            self
        }
        /// Appends an item to `products`.
        ///
        /// To override the contents of this collection use [`set_products`](Self::set_products).
        ///
        /// <p>The AWS products.</p>
        pub fn products(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            let mut v = self.products.unwrap_or_default();
            v.push(input);
            self.products = Some(v);
            self
        }
        /// <p>The AWS products.</p>
        pub fn set_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        ) -> Self {
            self.products = input;
            self
        }
        /// Appends an item to `service_codes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(mut self, input: crate::model::SavingsPlanRateServiceCode) -> Self {
            let mut v = self.service_codes.unwrap_or_default();
            v.push(input);
            self.service_codes = Some(v);
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateServiceCode>>,
        ) -> Self {
            self.service_codes = input;
            self
        }
        /// Appends an item to `usage_types`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.usage_types.unwrap_or_default();
            v.push(input.into());
            self.usage_types = Some(v);
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.usage_types = input;
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(
            mut self,
            input: crate::model::SavingsPlanOfferingRateFilterElement,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingRateFilterElement>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSavingsPlansOfferingRatesInput`](crate::input::DescribeSavingsPlansOfferingRatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSavingsPlansOfferingRatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSavingsPlansOfferingRatesInput {
                savings_plan_offering_ids: self.savings_plan_offering_ids,
                savings_plan_payment_options: self.savings_plan_payment_options,
                savings_plan_types: self.savings_plan_types,
                products: self.products,
                service_codes: self.service_codes,
                usage_types: self.usage_types,
                operations: self.operations,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSavingsPlansOfferingRatesInputOperationOutputAlias =
    crate::operation::DescribeSavingsPlansOfferingRates;
#[doc(hidden)]
pub type DescribeSavingsPlansOfferingRatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSavingsPlansOfferingRatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSavingsPlansOfferingRates`](crate::operation::DescribeSavingsPlansOfferingRates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSavingsPlansOfferingRates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSavingsPlansOfferingRatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeSavingsPlansOfferingRates")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSavingsPlansOfferingRatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSavingsPlansOfferingRatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_savings_plans_offering_rates(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSavingsPlansOfferingRates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSavingsPlansOfferingRates",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSavingsPlansOfferingRatesInput`](crate::input::DescribeSavingsPlansOfferingRatesInput)
    pub fn builder() -> crate::input::describe_savings_plans_offering_rates_input::Builder {
        crate::input::describe_savings_plans_offering_rates_input::Builder::default()
    }
}

/// See [`DescribeSavingsPlansOfferingsInput`](crate::input::DescribeSavingsPlansOfferingsInput)
pub mod describe_savings_plans_offerings_input {
    /// A builder for [`DescribeSavingsPlansOfferingsInput`](crate::input::DescribeSavingsPlansOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) payment_options:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        pub(crate) product_type: std::option::Option<crate::model::SavingsPlanProductType>,
        pub(crate) plan_types: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        pub(crate) durations: std::option::Option<std::vec::Vec<i64>>,
        pub(crate) currencies: std::option::Option<std::vec::Vec<crate::model::CurrencyCode>>,
        pub(crate) descriptions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) usage_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingFilterElement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `offering_ids`.
        ///
        /// To override the contents of this collection use [`set_offering_ids`](Self::set_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn offering_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.offering_ids.unwrap_or_default();
            v.push(input.into());
            self.offering_ids = Some(v);
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.offering_ids = input;
            self
        }
        /// Appends an item to `payment_options`.
        ///
        /// To override the contents of this collection use [`set_payment_options`](Self::set_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn payment_options(mut self, input: crate::model::SavingsPlanPaymentOption) -> Self {
            let mut v = self.payment_options.unwrap_or_default();
            v.push(input);
            self.payment_options = Some(v);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.payment_options = input;
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// Appends an item to `plan_types`.
        ///
        /// To override the contents of this collection use [`set_plan_types`](Self::set_plan_types).
        ///
        /// <p>The plan type.</p>
        pub fn plan_types(mut self, input: crate::model::SavingsPlanType) -> Self {
            let mut v = self.plan_types.unwrap_or_default();
            v.push(input);
            self.plan_types = Some(v);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.plan_types = input;
            self
        }
        /// Appends an item to `durations`.
        ///
        /// To override the contents of this collection use [`set_durations`](Self::set_durations).
        ///
        /// <p>The durations, in seconds.</p>
        pub fn durations(mut self, input: i64) -> Self {
            let mut v = self.durations.unwrap_or_default();
            v.push(input);
            self.durations = Some(v);
            self
        }
        /// <p>The durations, in seconds.</p>
        pub fn set_durations(mut self, input: std::option::Option<std::vec::Vec<i64>>) -> Self {
            self.durations = input;
            self
        }
        /// Appends an item to `currencies`.
        ///
        /// To override the contents of this collection use [`set_currencies`](Self::set_currencies).
        ///
        /// <p>The currencies.</p>
        pub fn currencies(mut self, input: crate::model::CurrencyCode) -> Self {
            let mut v = self.currencies.unwrap_or_default();
            v.push(input);
            self.currencies = Some(v);
            self
        }
        /// <p>The currencies.</p>
        pub fn set_currencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrencyCode>>,
        ) -> Self {
            self.currencies = input;
            self
        }
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>The descriptions.</p>
        pub fn descriptions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.descriptions.unwrap_or_default();
            v.push(input.into());
            self.descriptions = Some(v);
            self
        }
        /// <p>The descriptions.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.descriptions = input;
            self
        }
        /// Appends an item to `service_codes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.service_codes.unwrap_or_default();
            v.push(input.into());
            self.service_codes = Some(v);
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.service_codes = input;
            self
        }
        /// Appends an item to `usage_types`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.usage_types.unwrap_or_default();
            v.push(input.into());
            self.usage_types = Some(v);
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.usage_types = input;
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanOfferingFilterElement) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingFilterElement>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSavingsPlansOfferingsInput`](crate::input::DescribeSavingsPlansOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSavingsPlansOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSavingsPlansOfferingsInput {
                offering_ids: self.offering_ids,
                payment_options: self.payment_options,
                product_type: self.product_type,
                plan_types: self.plan_types,
                durations: self.durations,
                currencies: self.currencies,
                descriptions: self.descriptions,
                service_codes: self.service_codes,
                usage_types: self.usage_types,
                operations: self.operations,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSavingsPlansOfferingsInputOperationOutputAlias =
    crate::operation::DescribeSavingsPlansOfferings;
#[doc(hidden)]
pub type DescribeSavingsPlansOfferingsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSavingsPlansOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSavingsPlansOfferings`](crate::operation::DescribeSavingsPlansOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSavingsPlansOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSavingsPlansOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeSavingsPlansOfferings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSavingsPlansOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSavingsPlansOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_savings_plans_offerings(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSavingsPlansOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSavingsPlansOfferings",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSavingsPlansOfferingsInput`](crate::input::DescribeSavingsPlansOfferingsInput)
    pub fn builder() -> crate::input::describe_savings_plans_offerings_input::Builder {
        crate::input::describe_savings_plans_offerings_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListTagsForResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UntagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "savingsplans",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSavingsPlansOfferingsInput {
    /// <p>The IDs of the offerings.</p>
    pub offering_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The payment options.</p>
    pub payment_options: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
    /// <p>The product type.</p>
    pub product_type: std::option::Option<crate::model::SavingsPlanProductType>,
    /// <p>The plan type.</p>
    pub plan_types: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
    /// <p>The durations, in seconds.</p>
    pub durations: std::option::Option<std::vec::Vec<i64>>,
    /// <p>The currencies.</p>
    pub currencies: std::option::Option<std::vec::Vec<crate::model::CurrencyCode>>,
    /// <p>The descriptions.</p>
    pub descriptions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The services.</p>
    pub service_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The usage details of the line item in the billing report.</p>
    pub usage_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub operations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingFilterElement>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub max_results: i32,
}
impl DescribeSavingsPlansOfferingsInput {
    /// <p>The IDs of the offerings.</p>
    pub fn offering_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.offering_ids.as_deref()
    }
    /// <p>The payment options.</p>
    pub fn payment_options(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlanPaymentOption]> {
        self.payment_options.as_deref()
    }
    /// <p>The product type.</p>
    pub fn product_type(&self) -> std::option::Option<&crate::model::SavingsPlanProductType> {
        self.product_type.as_ref()
    }
    /// <p>The plan type.</p>
    pub fn plan_types(&self) -> std::option::Option<&[crate::model::SavingsPlanType]> {
        self.plan_types.as_deref()
    }
    /// <p>The durations, in seconds.</p>
    pub fn durations(&self) -> std::option::Option<&[i64]> {
        self.durations.as_deref()
    }
    /// <p>The currencies.</p>
    pub fn currencies(&self) -> std::option::Option<&[crate::model::CurrencyCode]> {
        self.currencies.as_deref()
    }
    /// <p>The descriptions.</p>
    pub fn descriptions(&self) -> std::option::Option<&[std::string::String]> {
        self.descriptions.as_deref()
    }
    /// <p>The services.</p>
    pub fn service_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.service_codes.as_deref()
    }
    /// <p>The usage details of the line item in the billing report.</p>
    pub fn usage_types(&self) -> std::option::Option<&[std::string::String]> {
        self.usage_types.as_deref()
    }
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub fn operations(&self) -> std::option::Option<&[std::string::String]> {
        self.operations.as_deref()
    }
    /// <p>The filters.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlanOfferingFilterElement]> {
        self.filters.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeSavingsPlansOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSavingsPlansOfferingsInput");
        formatter.field("offering_ids", &self.offering_ids);
        formatter.field("payment_options", &self.payment_options);
        formatter.field("product_type", &self.product_type);
        formatter.field("plan_types", &self.plan_types);
        formatter.field("durations", &self.durations);
        formatter.field("currencies", &self.currencies);
        formatter.field("descriptions", &self.descriptions);
        formatter.field("service_codes", &self.service_codes);
        formatter.field("usage_types", &self.usage_types);
        formatter.field("operations", &self.operations);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSavingsPlansOfferingRatesInput {
    /// <p>The IDs of the offerings.</p>
    pub savings_plan_offering_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The payment options.</p>
    pub savings_plan_payment_options:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
    /// <p>The plan types.</p>
    pub savings_plan_types: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
    /// <p>The AWS products.</p>
    pub products: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
    /// <p>The services.</p>
    pub service_codes: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateServiceCode>>,
    /// <p>The usage details of the line item in the billing report.</p>
    pub usage_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub operations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The filters.</p>
    pub filters:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingRateFilterElement>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub max_results: i32,
}
impl DescribeSavingsPlansOfferingRatesInput {
    /// <p>The IDs of the offerings.</p>
    pub fn savings_plan_offering_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.savings_plan_offering_ids.as_deref()
    }
    /// <p>The payment options.</p>
    pub fn savings_plan_payment_options(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlanPaymentOption]> {
        self.savings_plan_payment_options.as_deref()
    }
    /// <p>The plan types.</p>
    pub fn savings_plan_types(&self) -> std::option::Option<&[crate::model::SavingsPlanType]> {
        self.savings_plan_types.as_deref()
    }
    /// <p>The AWS products.</p>
    pub fn products(&self) -> std::option::Option<&[crate::model::SavingsPlanProductType]> {
        self.products.as_deref()
    }
    /// <p>The services.</p>
    pub fn service_codes(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlanRateServiceCode]> {
        self.service_codes.as_deref()
    }
    /// <p>The usage details of the line item in the billing report.</p>
    pub fn usage_types(&self) -> std::option::Option<&[std::string::String]> {
        self.usage_types.as_deref()
    }
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub fn operations(&self) -> std::option::Option<&[std::string::String]> {
        self.operations.as_deref()
    }
    /// <p>The filters.</p>
    pub fn filters(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlanOfferingRateFilterElement]> {
        self.filters.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeSavingsPlansOfferingRatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSavingsPlansOfferingRatesInput");
        formatter.field("savings_plan_offering_ids", &self.savings_plan_offering_ids);
        formatter.field(
            "savings_plan_payment_options",
            &self.savings_plan_payment_options,
        );
        formatter.field("savings_plan_types", &self.savings_plan_types);
        formatter.field("products", &self.products);
        formatter.field("service_codes", &self.service_codes);
        formatter.field("usage_types", &self.usage_types);
        formatter.field("operations", &self.operations);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSavingsPlansInput {
    /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
    pub savings_plan_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the Savings Plans.</p>
    pub savings_plan_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The states.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::SavingsPlanState>>,
    /// <p>The filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SavingsPlanFilter>>,
}
impl DescribeSavingsPlansInput {
    /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
    pub fn savings_plan_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.savings_plan_arns.as_deref()
    }
    /// <p>The IDs of the Savings Plans.</p>
    pub fn savings_plan_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.savings_plan_ids.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The states.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::SavingsPlanState]> {
        self.states.as_deref()
    }
    /// <p>The filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SavingsPlanFilter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for DescribeSavingsPlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSavingsPlansInput");
        formatter.field("savings_plan_arns", &self.savings_plan_arns);
        formatter.field("savings_plan_ids", &self.savings_plan_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("states", &self.states);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSavingsPlanRatesInput {
    /// <p>The ID of the Savings Plan.</p>
    pub savings_plan_id: std::option::Option<std::string::String>,
    /// <p>The filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateFilter>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeSavingsPlanRatesInput {
    /// <p>The ID of the Savings Plan.</p>
    pub fn savings_plan_id(&self) -> std::option::Option<&str> {
        self.savings_plan_id.as_deref()
    }
    /// <p>The filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SavingsPlanRateFilter]> {
        self.filters.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeSavingsPlanRatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSavingsPlanRatesInput");
        formatter.field("savings_plan_id", &self.savings_plan_id);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueuedSavingsPlanInput {
    /// <p>The ID of the Savings Plan.</p>
    pub savings_plan_id: std::option::Option<std::string::String>,
}
impl DeleteQueuedSavingsPlanInput {
    /// <p>The ID of the Savings Plan.</p>
    pub fn savings_plan_id(&self) -> std::option::Option<&str> {
        self.savings_plan_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteQueuedSavingsPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueuedSavingsPlanInput");
        formatter.field("savings_plan_id", &self.savings_plan_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSavingsPlanInput {
    /// <p>The ID of the offering.</p>
    pub savings_plan_offering_id: std::option::Option<std::string::String>,
    /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
    pub commitment: std::option::Option<std::string::String>,
    /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
    pub upfront_payment_amount: std::option::Option<std::string::String>,
    /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
    pub purchase_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateSavingsPlanInput {
    /// <p>The ID of the offering.</p>
    pub fn savings_plan_offering_id(&self) -> std::option::Option<&str> {
        self.savings_plan_offering_id.as_deref()
    }
    /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
    pub fn commitment(&self) -> std::option::Option<&str> {
        self.commitment.as_deref()
    }
    /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
    pub fn upfront_payment_amount(&self) -> std::option::Option<&str> {
        self.upfront_payment_amount.as_deref()
    }
    /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
    pub fn purchase_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.purchase_time.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>One or more tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateSavingsPlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSavingsPlanInput");
        formatter.field("savings_plan_offering_id", &self.savings_plan_offering_id);
        formatter.field("commitment", &self.commitment);
        formatter.field("upfront_payment_amount", &self.upfront_payment_amount);
        formatter.field("purchase_time", &self.purchase_time);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
