// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Savings Plans
///
/// Client for invoking operations on AWS Savings Plans. Each operation on AWS Savings Plans is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_savingsplans::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_savingsplans::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_savingsplans::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateSavingsPlan`](crate::client::fluent_builders::CreateSavingsPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plan_offering_id(impl Into<String>)`](crate::client::fluent_builders::CreateSavingsPlan::savings_plan_offering_id) / [`set_savings_plan_offering_id(Option<String>)`](crate::client::fluent_builders::CreateSavingsPlan::set_savings_plan_offering_id): <p>The ID of the offering.</p>
    ///   - [`commitment(impl Into<String>)`](crate::client::fluent_builders::CreateSavingsPlan::commitment) / [`set_commitment(Option<String>)`](crate::client::fluent_builders::CreateSavingsPlan::set_commitment): <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
    ///   - [`upfront_payment_amount(impl Into<String>)`](crate::client::fluent_builders::CreateSavingsPlan::upfront_payment_amount) / [`set_upfront_payment_amount(Option<String>)`](crate::client::fluent_builders::CreateSavingsPlan::set_upfront_payment_amount): <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
    ///   - [`purchase_time(DateTime)`](crate::client::fluent_builders::CreateSavingsPlan::purchase_time) / [`set_purchase_time(Option<DateTime>)`](crate::client::fluent_builders::CreateSavingsPlan::set_purchase_time): <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateSavingsPlan::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateSavingsPlan::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSavingsPlan::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSavingsPlan::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`CreateSavingsPlanOutput`](crate::output::CreateSavingsPlanOutput) with field(s):
    ///   - [`savings_plan_id(Option<String>)`](crate::output::CreateSavingsPlanOutput::savings_plan_id): <p>The ID of the Savings Plan.</p>
    /// - On failure, responds with [`SdkError<CreateSavingsPlanError>`](crate::error::CreateSavingsPlanError)
    pub fn create_savings_plan(&self) -> fluent_builders::CreateSavingsPlan {
        fluent_builders::CreateSavingsPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQueuedSavingsPlan`](crate::client::fluent_builders::DeleteQueuedSavingsPlan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plan_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQueuedSavingsPlan::savings_plan_id) / [`set_savings_plan_id(Option<String>)`](crate::client::fluent_builders::DeleteQueuedSavingsPlan::set_savings_plan_id): <p>The ID of the Savings Plan.</p>
    /// - On success, responds with [`DeleteQueuedSavingsPlanOutput`](crate::output::DeleteQueuedSavingsPlanOutput)

    /// - On failure, responds with [`SdkError<DeleteQueuedSavingsPlanError>`](crate::error::DeleteQueuedSavingsPlanError)
    pub fn delete_queued_savings_plan(&self) -> fluent_builders::DeleteQueuedSavingsPlan {
        fluent_builders::DeleteQueuedSavingsPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSavingsPlanRates`](crate::client::fluent_builders::DescribeSavingsPlanRates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plan_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::savings_plan_id) / [`set_savings_plan_id(Option<String>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::set_savings_plan_id): <p>The ID of the Savings Plan.</p>
    ///   - [`filters(Vec<SavingsPlanRateFilter>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::filters) / [`set_filters(Option<Vec<SavingsPlanRateFilter>>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::set_filters): <p>The filters.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlanRates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSavingsPlanRates::set_max_results): <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    /// - On success, responds with [`DescribeSavingsPlanRatesOutput`](crate::output::DescribeSavingsPlanRatesOutput) with field(s):
    ///   - [`savings_plan_id(Option<String>)`](crate::output::DescribeSavingsPlanRatesOutput::savings_plan_id): <p>The ID of the Savings Plan.</p>
    ///   - [`search_results(Option<Vec<SavingsPlanRate>>)`](crate::output::DescribeSavingsPlanRatesOutput::search_results): <p>Information about the Savings Plans rates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSavingsPlanRatesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSavingsPlanRatesError>`](crate::error::DescribeSavingsPlanRatesError)
    pub fn describe_savings_plan_rates(&self) -> fluent_builders::DescribeSavingsPlanRates {
        fluent_builders::DescribeSavingsPlanRates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSavingsPlans`](crate::client::fluent_builders::DescribeSavingsPlans) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plan_arns(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlans::savings_plan_arns) / [`set_savings_plan_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_savings_plan_arns): <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
    ///   - [`savings_plan_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlans::savings_plan_ids) / [`set_savings_plan_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_savings_plan_ids): <p>The IDs of the Savings Plans.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSavingsPlans::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlans::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_max_results): <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    ///   - [`states(Vec<SavingsPlanState>)`](crate::client::fluent_builders::DescribeSavingsPlans::states) / [`set_states(Option<Vec<SavingsPlanState>>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_states): <p>The states.</p>
    ///   - [`filters(Vec<SavingsPlanFilter>)`](crate::client::fluent_builders::DescribeSavingsPlans::filters) / [`set_filters(Option<Vec<SavingsPlanFilter>>)`](crate::client::fluent_builders::DescribeSavingsPlans::set_filters): <p>The filters.</p>
    /// - On success, responds with [`DescribeSavingsPlansOutput`](crate::output::DescribeSavingsPlansOutput) with field(s):
    ///   - [`savings_plans(Option<Vec<SavingsPlan>>)`](crate::output::DescribeSavingsPlansOutput::savings_plans): <p>Information about the Savings Plans.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSavingsPlansOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSavingsPlansError>`](crate::error::DescribeSavingsPlansError)
    pub fn describe_savings_plans(&self) -> fluent_builders::DescribeSavingsPlans {
        fluent_builders::DescribeSavingsPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSavingsPlansOfferingRates`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plan_offering_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::savings_plan_offering_ids) / [`set_savings_plan_offering_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_savings_plan_offering_ids): <p>The IDs of the offerings.</p>
    ///   - [`savings_plan_payment_options(Vec<SavingsPlanPaymentOption>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::savings_plan_payment_options) / [`set_savings_plan_payment_options(Option<Vec<SavingsPlanPaymentOption>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_savings_plan_payment_options): <p>The payment options.</p>
    ///   - [`savings_plan_types(Vec<SavingsPlanType>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::savings_plan_types) / [`set_savings_plan_types(Option<Vec<SavingsPlanType>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_savings_plan_types): <p>The plan types.</p>
    ///   - [`products(Vec<SavingsPlanProductType>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::products) / [`set_products(Option<Vec<SavingsPlanProductType>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_products): <p>The AWS products.</p>
    ///   - [`service_codes(Vec<SavingsPlanRateServiceCode>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::service_codes) / [`set_service_codes(Option<Vec<SavingsPlanRateServiceCode>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_service_codes): <p>The services.</p>
    ///   - [`usage_types(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::usage_types) / [`set_usage_types(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_usage_types): <p>The usage details of the line item in the billing report.</p>
    ///   - [`operations(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::operations) / [`set_operations(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_operations): <p>The specific AWS operation for the line item in the billing report.</p>
    ///   - [`filters(Vec<SavingsPlanOfferingRateFilterElement>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::filters) / [`set_filters(Option<Vec<SavingsPlanOfferingRateFilterElement>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_filters): <p>The filters.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates::set_max_results): <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    /// - On success, responds with [`DescribeSavingsPlansOfferingRatesOutput`](crate::output::DescribeSavingsPlansOfferingRatesOutput) with field(s):
    ///   - [`search_results(Option<Vec<SavingsPlanOfferingRate>>)`](crate::output::DescribeSavingsPlansOfferingRatesOutput::search_results): <p>Information about the Savings Plans offering rates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSavingsPlansOfferingRatesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSavingsPlansOfferingRatesError>`](crate::error::DescribeSavingsPlansOfferingRatesError)
    pub fn describe_savings_plans_offering_rates(
        &self,
    ) -> fluent_builders::DescribeSavingsPlansOfferingRates {
        fluent_builders::DescribeSavingsPlansOfferingRates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSavingsPlansOfferings`](crate::client::fluent_builders::DescribeSavingsPlansOfferings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`offering_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::offering_ids) / [`set_offering_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_offering_ids): <p>The IDs of the offerings.</p>
    ///   - [`payment_options(Vec<SavingsPlanPaymentOption>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::payment_options) / [`set_payment_options(Option<Vec<SavingsPlanPaymentOption>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_payment_options): <p>The payment options.</p>
    ///   - [`product_type(SavingsPlanProductType)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::product_type) / [`set_product_type(Option<SavingsPlanProductType>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_product_type): <p>The product type.</p>
    ///   - [`plan_types(Vec<SavingsPlanType>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::plan_types) / [`set_plan_types(Option<Vec<SavingsPlanType>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_plan_types): <p>The plan type.</p>
    ///   - [`durations(Vec<i64>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::durations) / [`set_durations(Option<Vec<i64>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_durations): <p>The durations, in seconds.</p>
    ///   - [`currencies(Vec<CurrencyCode>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::currencies) / [`set_currencies(Option<Vec<CurrencyCode>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_currencies): <p>The currencies.</p>
    ///   - [`descriptions(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::descriptions) / [`set_descriptions(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_descriptions): <p>The descriptions.</p>
    ///   - [`service_codes(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::service_codes) / [`set_service_codes(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_service_codes): <p>The services.</p>
    ///   - [`usage_types(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::usage_types) / [`set_usage_types(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_usage_types): <p>The usage details of the line item in the billing report.</p>
    ///   - [`operations(Vec<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::operations) / [`set_operations(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_operations): <p>The specific AWS operation for the line item in the billing report.</p>
    ///   - [`filters(Vec<SavingsPlanOfferingFilterElement>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::filters) / [`set_filters(Option<Vec<SavingsPlanOfferingFilterElement>>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_filters): <p>The filters.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeSavingsPlansOfferings::set_max_results): <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
    /// - On success, responds with [`DescribeSavingsPlansOfferingsOutput`](crate::output::DescribeSavingsPlansOfferingsOutput) with field(s):
    ///   - [`search_results(Option<Vec<SavingsPlanOffering>>)`](crate::output::DescribeSavingsPlansOfferingsOutput::search_results): <p>Information about the Savings Plans offerings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSavingsPlansOfferingsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSavingsPlansOfferingsError>`](crate::error::DescribeSavingsPlansOfferingsError)
    pub fn describe_savings_plans_offerings(
        &self,
    ) -> fluent_builders::DescribeSavingsPlansOfferings {
        fluent_builders::DescribeSavingsPlansOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateSavingsPlan`.
    ///
    /// <p>Creates a Savings Plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSavingsPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_savings_plan_input::Builder,
    }
    impl CreateSavingsPlan {
        /// Creates a new `CreateSavingsPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSavingsPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSavingsPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the offering.</p>
        pub fn savings_plan_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_offering_id(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_savings_plan_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_offering_id(input);
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
        pub fn commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commitment(input.into());
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.</p>
        pub fn set_commitment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commitment(input);
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn upfront_payment_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upfront_payment_amount(input.into());
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn set_upfront_payment_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_upfront_payment_amount(input);
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn purchase_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.purchase_time(input);
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn set_purchase_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_purchase_time(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueuedSavingsPlan`.
    ///
    /// <p>Deletes the queued purchase for the specified Savings Plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQueuedSavingsPlan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_queued_savings_plan_input::Builder,
    }
    impl DeleteQueuedSavingsPlan {
        /// Creates a new `DeleteQueuedSavingsPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueuedSavingsPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueuedSavingsPlanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_id(input.into());
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlanRates`.
    ///
    /// <p>Describes the specified Savings Plans rates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSavingsPlanRates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_savings_plan_rates_input::Builder,
    }
    impl DescribeSavingsPlanRates {
        /// Creates a new `DescribeSavingsPlanRates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlanRatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlanRatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_id(input.into());
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanRateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlans`.
    ///
    /// <p>Describes the specified Savings Plans.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSavingsPlans {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_savings_plans_input::Builder,
    }
    impl DescribeSavingsPlans {
        /// Creates a new `DescribeSavingsPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `savingsPlanArns`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_arns`](Self::set_savings_plan_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn savings_plan_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn set_savings_plan_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_arns(input);
            self
        }
        /// Appends an item to `savingsPlanIds`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_ids`](Self::set_savings_plan_ids).
        ///
        /// <p>The IDs of the Savings Plans.</p>
        pub fn savings_plan_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_ids(input.into());
            self
        }
        /// <p>The IDs of the Savings Plans.</p>
        pub fn set_savings_plan_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_ids(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states.</p>
        pub fn states(mut self, input: crate::model::SavingsPlanState) -> Self {
            self.inner = self.inner.states(input);
            self
        }
        /// <p>The states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlansOfferingRates`.
    ///
    /// <p>Describes the specified Savings Plans offering rates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSavingsPlansOfferingRates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_savings_plans_offering_rates_input::Builder,
    }
    impl DescribeSavingsPlansOfferingRates {
        /// Creates a new `DescribeSavingsPlansOfferingRates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOfferingRatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansOfferingRatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `savingsPlanOfferingIds`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_offering_ids`](Self::set_savings_plan_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn savings_plan_offering_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_offering_ids(input.into());
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_savings_plan_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_offering_ids(input);
            self
        }
        /// Appends an item to `savingsPlanPaymentOptions`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_payment_options`](Self::set_savings_plan_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn savings_plan_payment_options(
            mut self,
            input: crate::model::SavingsPlanPaymentOption,
        ) -> Self {
            self.inner = self.inner.savings_plan_payment_options(input);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_savings_plan_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_payment_options(input);
            self
        }
        /// Appends an item to `savingsPlanTypes`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_types`](Self::set_savings_plan_types).
        ///
        /// <p>The plan types.</p>
        pub fn savings_plan_types(mut self, input: crate::model::SavingsPlanType) -> Self {
            self.inner = self.inner.savings_plan_types(input);
            self
        }
        /// <p>The plan types.</p>
        pub fn set_savings_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_types(input);
            self
        }
        /// Appends an item to `products`.
        ///
        /// To override the contents of this collection use [`set_products`](Self::set_products).
        ///
        /// <p>The AWS products.</p>
        pub fn products(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            self.inner = self.inner.products(input);
            self
        }
        /// <p>The AWS products.</p>
        pub fn set_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        ) -> Self {
            self.inner = self.inner.set_products(input);
            self
        }
        /// Appends an item to `serviceCodes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(mut self, input: crate::model::SavingsPlanRateServiceCode) -> Self {
            self.inner = self.inner.service_codes(input);
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateServiceCode>>,
        ) -> Self {
            self.inner = self.inner.set_service_codes(input);
            self
        }
        /// Appends an item to `usageTypes`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_types(input.into());
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usage_types(input);
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations(input.into());
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(
            mut self,
            input: crate::model::SavingsPlanOfferingRateFilterElement,
        ) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingRateFilterElement>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlansOfferings`.
    ///
    /// <p>Describes the specified Savings Plans offerings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSavingsPlansOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_savings_plans_offerings_input::Builder,
    }
    impl DescribeSavingsPlansOfferings {
        /// Creates a new `DescribeSavingsPlansOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansOfferingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `offeringIds`.
        ///
        /// To override the contents of this collection use [`set_offering_ids`](Self::set_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn offering_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_ids(input.into());
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_offering_ids(input);
            self
        }
        /// Appends an item to `paymentOptions`.
        ///
        /// To override the contents of this collection use [`set_payment_options`](Self::set_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn payment_options(mut self, input: crate::model::SavingsPlanPaymentOption) -> Self {
            self.inner = self.inner.payment_options(input);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.inner = self.inner.set_payment_options(input);
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            self.inner = self.inner.product_type(input);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `planTypes`.
        ///
        /// To override the contents of this collection use [`set_plan_types`](Self::set_plan_types).
        ///
        /// <p>The plan type.</p>
        pub fn plan_types(mut self, input: crate::model::SavingsPlanType) -> Self {
            self.inner = self.inner.plan_types(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.inner = self.inner.set_plan_types(input);
            self
        }
        /// Appends an item to `durations`.
        ///
        /// To override the contents of this collection use [`set_durations`](Self::set_durations).
        ///
        /// <p>The durations, in seconds.</p>
        pub fn durations(mut self, input: i64) -> Self {
            self.inner = self.inner.durations(input);
            self
        }
        /// <p>The durations, in seconds.</p>
        pub fn set_durations(mut self, input: std::option::Option<std::vec::Vec<i64>>) -> Self {
            self.inner = self.inner.set_durations(input);
            self
        }
        /// Appends an item to `currencies`.
        ///
        /// To override the contents of this collection use [`set_currencies`](Self::set_currencies).
        ///
        /// <p>The currencies.</p>
        pub fn currencies(mut self, input: crate::model::CurrencyCode) -> Self {
            self.inner = self.inner.currencies(input);
            self
        }
        /// <p>The currencies.</p>
        pub fn set_currencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrencyCode>>,
        ) -> Self {
            self.inner = self.inner.set_currencies(input);
            self
        }
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>The descriptions.</p>
        pub fn descriptions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.descriptions(input.into());
            self
        }
        /// <p>The descriptions.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_descriptions(input);
            self
        }
        /// Appends an item to `serviceCodes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_codes(input.into());
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_service_codes(input);
            self
        }
        /// Appends an item to `usageTypes`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_types(input.into());
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usage_types(input);
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations(input.into());
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, input: crate::model::SavingsPlanOfferingFilterElement) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingFilterElement>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
