// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a Savings Plan offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOffering {
    /// <p>The ID of the offering.</p>
    pub offering_id: std::option::Option<std::string::String>,
    /// <p>The product type.</p>
    pub product_types: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
    /// <p>The plan type.</p>
    pub plan_type: std::option::Option<crate::model::SavingsPlanType>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The payment option.</p>
    pub payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
    /// <p>The duration, in seconds.</p>
    pub duration_seconds: i64,
    /// <p>The currency.</p>
    pub currency: std::option::Option<crate::model::CurrencyCode>,
    /// <p>The service.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The usage details of the line item in the billing report.</p>
    pub usage_type: std::option::Option<std::string::String>,
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The properties.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingProperty>>,
}
impl std::fmt::Debug for SavingsPlanOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOffering");
        formatter.field("offering_id", &self.offering_id);
        formatter.field("product_types", &self.product_types);
        formatter.field("plan_type", &self.plan_type);
        formatter.field("description", &self.description);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("currency", &self.currency);
        formatter.field("service_code", &self.service_code);
        formatter.field("usage_type", &self.usage_type);
        formatter.field("operation", &self.operation);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`SavingsPlanOffering`](crate::model::SavingsPlanOffering)
pub mod savings_plan_offering {
    /// A builder for [`SavingsPlanOffering`](crate::model::SavingsPlanOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) product_types:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        pub(crate) plan_type: std::option::Option<crate::model::SavingsPlanType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        pub(crate) duration_seconds: std::option::Option<i64>,
        pub(crate) currency: std::option::Option<crate::model::CurrencyCode>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) usage_type: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingProperty>>,
    }
    impl Builder {
        /// <p>The ID of the offering.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Appends an item to `product_types`.
        ///
        /// To override the contents of this collection use [`set_product_types`](Self::set_product_types).
        ///
        /// <p>The product type.</p>
        pub fn product_types(
            mut self,
            input: impl Into<crate::model::SavingsPlanProductType>,
        ) -> Self {
            let mut v = self.product_types.unwrap_or_default();
            v.push(input.into());
            self.product_types = Some(v);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        ) -> Self {
            self.product_types = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::SavingsPlanType) -> Self {
            self.plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanType>,
        ) -> Self {
            self.plan_type = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The payment option.</p>
        pub fn payment_option(mut self, input: crate::model::SavingsPlanPaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The duration, in seconds.</p>
        pub fn duration_seconds(mut self, input: i64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The duration, in seconds.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>The currency.</p>
        pub fn currency(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The currency.</p>
        pub fn set_currency(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency = input;
            self
        }
        /// <p>The service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_type = Some(input.into());
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_type = input;
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The properties.</p>
        pub fn properties(
            mut self,
            input: impl Into<crate::model::SavingsPlanOfferingProperty>,
        ) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input.into());
            self.properties = Some(v);
            self
        }
        /// <p>The properties.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingProperty>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOffering`](crate::model::SavingsPlanOffering)
        pub fn build(self) -> crate::model::SavingsPlanOffering {
            crate::model::SavingsPlanOffering {
                offering_id: self.offering_id,
                product_types: self.product_types,
                plan_type: self.plan_type,
                description: self.description,
                payment_option: self.payment_option,
                duration_seconds: self.duration_seconds.unwrap_or_default(),
                currency: self.currency,
                service_code: self.service_code,
                usage_type: self.usage_type,
                operation: self.operation,
                properties: self.properties,
            }
        }
    }
}
impl SavingsPlanOffering {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOffering`](crate::model::SavingsPlanOffering)
    pub fn builder() -> crate::model::savings_plan_offering::Builder {
        crate::model::savings_plan_offering::Builder::default()
    }
}

/// <p>Information about a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOfferingProperty {
    /// <p>The property name.</p>
    pub name: std::option::Option<crate::model::SavingsPlanOfferingPropertyKey>,
    /// <p>The property value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SavingsPlanOfferingProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOfferingProperty");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SavingsPlanOfferingProperty`](crate::model::SavingsPlanOfferingProperty)
pub mod savings_plan_offering_property {
    /// A builder for [`SavingsPlanOfferingProperty`](crate::model::SavingsPlanOfferingProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlanOfferingPropertyKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlanOfferingPropertyKey) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The property name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanOfferingPropertyKey>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The property value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The property value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOfferingProperty`](crate::model::SavingsPlanOfferingProperty)
        pub fn build(self) -> crate::model::SavingsPlanOfferingProperty {
            crate::model::SavingsPlanOfferingProperty {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SavingsPlanOfferingProperty {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOfferingProperty`](crate::model::SavingsPlanOfferingProperty)
    pub fn builder() -> crate::model::savings_plan_offering_property::Builder {
        crate::model::savings_plan_offering_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanOfferingPropertyKey {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanOfferingPropertyKey {
    fn from(s: &str) -> Self {
        match s {
            "instanceFamily" => SavingsPlanOfferingPropertyKey::InstanceFamily,
            "region" => SavingsPlanOfferingPropertyKey::Region,
            other => SavingsPlanOfferingPropertyKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanOfferingPropertyKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanOfferingPropertyKey::from(s))
    }
}
impl SavingsPlanOfferingPropertyKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanOfferingPropertyKey::InstanceFamily => "instanceFamily",
            SavingsPlanOfferingPropertyKey::Region => "region",
            SavingsPlanOfferingPropertyKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["instanceFamily", "region"]
    }
}
impl AsRef<str> for SavingsPlanOfferingPropertyKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CurrencyCode {
    #[allow(missing_docs)] // documentation missing in model
    Cny,
    #[allow(missing_docs)] // documentation missing in model
    Usd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CurrencyCode {
    fn from(s: &str) -> Self {
        match s {
            "CNY" => CurrencyCode::Cny,
            "USD" => CurrencyCode::Usd,
            other => CurrencyCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CurrencyCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CurrencyCode::from(s))
    }
}
impl CurrencyCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CurrencyCode::Cny => "CNY",
            CurrencyCode::Usd => "USD",
            CurrencyCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CNY", "USD"]
    }
}
impl AsRef<str> for CurrencyCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanPaymentOption {
    #[allow(missing_docs)] // documentation missing in model
    AllUpfront,
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    #[allow(missing_docs)] // documentation missing in model
    PartialUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanPaymentOption {
    fn from(s: &str) -> Self {
        match s {
            "All Upfront" => SavingsPlanPaymentOption::AllUpfront,
            "No Upfront" => SavingsPlanPaymentOption::NoUpfront,
            "Partial Upfront" => SavingsPlanPaymentOption::PartialUpfront,
            other => SavingsPlanPaymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanPaymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanPaymentOption::from(s))
    }
}
impl SavingsPlanPaymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanPaymentOption::AllUpfront => "All Upfront",
            SavingsPlanPaymentOption::NoUpfront => "No Upfront",
            SavingsPlanPaymentOption::PartialUpfront => "Partial Upfront",
            SavingsPlanPaymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["All Upfront", "No Upfront", "Partial Upfront"]
    }
}
impl AsRef<str> for SavingsPlanPaymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanType {
    #[allow(missing_docs)] // documentation missing in model
    Compute,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Instance,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanType {
    fn from(s: &str) -> Self {
        match s {
            "Compute" => SavingsPlanType::Compute,
            "EC2Instance" => SavingsPlanType::Ec2Instance,
            "SageMaker" => SavingsPlanType::Sagemaker,
            other => SavingsPlanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanType::from(s))
    }
}
impl SavingsPlanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanType::Compute => "Compute",
            SavingsPlanType::Ec2Instance => "EC2Instance",
            SavingsPlanType::Sagemaker => "SageMaker",
            SavingsPlanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Compute", "EC2Instance", "SageMaker"]
    }
}
impl AsRef<str> for SavingsPlanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanProductType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Fargate,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanProductType {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => SavingsPlanProductType::Ec2,
            "Fargate" => SavingsPlanProductType::Fargate,
            "Lambda" => SavingsPlanProductType::Lambda,
            "SageMaker" => SavingsPlanProductType::Sagemaker,
            other => SavingsPlanProductType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanProductType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanProductType::from(s))
    }
}
impl SavingsPlanProductType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanProductType::Ec2 => "EC2",
            SavingsPlanProductType::Fargate => "Fargate",
            SavingsPlanProductType::Lambda => "Lambda",
            SavingsPlanProductType::Sagemaker => "SageMaker",
            SavingsPlanProductType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "Fargate", "Lambda", "SageMaker"]
    }
}
impl AsRef<str> for SavingsPlanProductType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOfferingFilterElement {
    /// <p>The filter name.</p>
    pub name: std::option::Option<crate::model::SavingsPlanOfferingFilterAttribute>,
    /// <p>The filter values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SavingsPlanOfferingFilterElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOfferingFilterElement");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SavingsPlanOfferingFilterElement`](crate::model::SavingsPlanOfferingFilterElement)
pub mod savings_plan_offering_filter_element {
    /// A builder for [`SavingsPlanOfferingFilterElement`](crate::model::SavingsPlanOfferingFilterElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlanOfferingFilterAttribute>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The filter name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlanOfferingFilterAttribute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The filter name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanOfferingFilterAttribute>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOfferingFilterElement`](crate::model::SavingsPlanOfferingFilterElement)
        pub fn build(self) -> crate::model::SavingsPlanOfferingFilterElement {
            crate::model::SavingsPlanOfferingFilterElement {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl SavingsPlanOfferingFilterElement {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOfferingFilterElement`](crate::model::SavingsPlanOfferingFilterElement)
    pub fn builder() -> crate::model::savings_plan_offering_filter_element::Builder {
        crate::model::savings_plan_offering_filter_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanOfferingFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanOfferingFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "instanceFamily" => SavingsPlanOfferingFilterAttribute::InstanceFamily,
            "region" => SavingsPlanOfferingFilterAttribute::Region,
            other => SavingsPlanOfferingFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanOfferingFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanOfferingFilterAttribute::from(s))
    }
}
impl SavingsPlanOfferingFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanOfferingFilterAttribute::InstanceFamily => "instanceFamily",
            SavingsPlanOfferingFilterAttribute::Region => "region",
            SavingsPlanOfferingFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["instanceFamily", "region"]
    }
}
impl AsRef<str> for SavingsPlanOfferingFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Savings Plan offering rate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOfferingRate {
    /// <p>The Savings Plan offering.</p>
    pub savings_plan_offering: std::option::Option<crate::model::ParentSavingsPlanOffering>,
    /// <p>The Savings Plan rate.</p>
    pub rate: std::option::Option<std::string::String>,
    /// <p>The unit.</p>
    pub unit: std::option::Option<crate::model::SavingsPlanRateUnit>,
    /// <p>The product type.</p>
    pub product_type: std::option::Option<crate::model::SavingsPlanProductType>,
    /// <p>The service.</p>
    pub service_code: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
    /// <p>The usage details of the line item in the billing report.</p>
    pub usage_type: std::option::Option<std::string::String>,
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The properties.</p>
    pub properties:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingRateProperty>>,
}
impl std::fmt::Debug for SavingsPlanOfferingRate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOfferingRate");
        formatter.field("savings_plan_offering", &self.savings_plan_offering);
        formatter.field("rate", &self.rate);
        formatter.field("unit", &self.unit);
        formatter.field("product_type", &self.product_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("usage_type", &self.usage_type);
        formatter.field("operation", &self.operation);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`SavingsPlanOfferingRate`](crate::model::SavingsPlanOfferingRate)
pub mod savings_plan_offering_rate {
    /// A builder for [`SavingsPlanOfferingRate`](crate::model::SavingsPlanOfferingRate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_offering:
            std::option::Option<crate::model::ParentSavingsPlanOffering>,
        pub(crate) rate: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<crate::model::SavingsPlanRateUnit>,
        pub(crate) product_type: std::option::Option<crate::model::SavingsPlanProductType>,
        pub(crate) service_code: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
        pub(crate) usage_type: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanOfferingRateProperty>>,
    }
    impl Builder {
        /// <p>The Savings Plan offering.</p>
        pub fn savings_plan_offering(
            mut self,
            input: crate::model::ParentSavingsPlanOffering,
        ) -> Self {
            self.savings_plan_offering = Some(input);
            self
        }
        /// <p>The Savings Plan offering.</p>
        pub fn set_savings_plan_offering(
            mut self,
            input: std::option::Option<crate::model::ParentSavingsPlanOffering>,
        ) -> Self {
            self.savings_plan_offering = input;
            self
        }
        /// <p>The Savings Plan rate.</p>
        pub fn rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.rate = Some(input.into());
            self
        }
        /// <p>The Savings Plan rate.</p>
        pub fn set_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rate = input;
            self
        }
        /// <p>The unit.</p>
        pub fn unit(mut self, input: crate::model::SavingsPlanRateUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// <p>The service.</p>
        pub fn service_code(mut self, input: crate::model::SavingsPlanRateServiceCode) -> Self {
            self.service_code = Some(input);
            self
        }
        /// <p>The service.</p>
        pub fn set_service_code(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
        ) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_type = Some(input.into());
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_type = input;
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The properties.</p>
        pub fn properties(
            mut self,
            input: impl Into<crate::model::SavingsPlanOfferingRateProperty>,
        ) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input.into());
            self.properties = Some(v);
            self
        }
        /// <p>The properties.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingRateProperty>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOfferingRate`](crate::model::SavingsPlanOfferingRate)
        pub fn build(self) -> crate::model::SavingsPlanOfferingRate {
            crate::model::SavingsPlanOfferingRate {
                savings_plan_offering: self.savings_plan_offering,
                rate: self.rate,
                unit: self.unit,
                product_type: self.product_type,
                service_code: self.service_code,
                usage_type: self.usage_type,
                operation: self.operation,
                properties: self.properties,
            }
        }
    }
}
impl SavingsPlanOfferingRate {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOfferingRate`](crate::model::SavingsPlanOfferingRate)
    pub fn builder() -> crate::model::savings_plan_offering_rate::Builder {
        crate::model::savings_plan_offering_rate::Builder::default()
    }
}

/// <p>Information about a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOfferingRateProperty {
    /// <p>The property name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The property value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SavingsPlanOfferingRateProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOfferingRateProperty");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SavingsPlanOfferingRateProperty`](crate::model::SavingsPlanOfferingRateProperty)
pub mod savings_plan_offering_rate_property {
    /// A builder for [`SavingsPlanOfferingRateProperty`](crate::model::SavingsPlanOfferingRateProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The property name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The property value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The property value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOfferingRateProperty`](crate::model::SavingsPlanOfferingRateProperty)
        pub fn build(self) -> crate::model::SavingsPlanOfferingRateProperty {
            crate::model::SavingsPlanOfferingRateProperty {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SavingsPlanOfferingRateProperty {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOfferingRateProperty`](crate::model::SavingsPlanOfferingRateProperty)
    pub fn builder() -> crate::model::savings_plan_offering_rate_property::Builder {
        crate::model::savings_plan_offering_rate_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanRateServiceCode {
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Fargate,
    #[allow(missing_docs)] // documentation missing in model
    FargateEks,
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanRateServiceCode {
    fn from(s: &str) -> Self {
        match s {
            "AWSLambda" => SavingsPlanRateServiceCode::Lambda,
            "AmazonEC2" => SavingsPlanRateServiceCode::Ec2,
            "AmazonECS" => SavingsPlanRateServiceCode::Fargate,
            "AmazonEKS" => SavingsPlanRateServiceCode::FargateEks,
            "AmazonSageMaker" => SavingsPlanRateServiceCode::Sagemaker,
            other => SavingsPlanRateServiceCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanRateServiceCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanRateServiceCode::from(s))
    }
}
impl SavingsPlanRateServiceCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanRateServiceCode::Lambda => "AWSLambda",
            SavingsPlanRateServiceCode::Ec2 => "AmazonEC2",
            SavingsPlanRateServiceCode::Fargate => "AmazonECS",
            SavingsPlanRateServiceCode::FargateEks => "AmazonEKS",
            SavingsPlanRateServiceCode::Sagemaker => "AmazonSageMaker",
            SavingsPlanRateServiceCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWSLambda",
            "AmazonEC2",
            "AmazonECS",
            "AmazonEKS",
            "AmazonSageMaker",
        ]
    }
}
impl AsRef<str> for SavingsPlanRateServiceCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanRateUnit {
    #[allow(missing_docs)] // documentation missing in model
    Hours,
    #[allow(missing_docs)] // documentation missing in model
    LambdaGbSecond,
    #[allow(missing_docs)] // documentation missing in model
    Request,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanRateUnit {
    fn from(s: &str) -> Self {
        match s {
            "Hrs" => SavingsPlanRateUnit::Hours,
            "Lambda-GB-Second" => SavingsPlanRateUnit::LambdaGbSecond,
            "Request" => SavingsPlanRateUnit::Request,
            other => SavingsPlanRateUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanRateUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanRateUnit::from(s))
    }
}
impl SavingsPlanRateUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanRateUnit::Hours => "Hrs",
            SavingsPlanRateUnit::LambdaGbSecond => "Lambda-GB-Second",
            SavingsPlanRateUnit::Request => "Request",
            SavingsPlanRateUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Hrs", "Lambda-GB-Second", "Request"]
    }
}
impl AsRef<str> for SavingsPlanRateUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Savings Plan offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParentSavingsPlanOffering {
    /// <p>The ID of the offering.</p>
    pub offering_id: std::option::Option<std::string::String>,
    /// <p>The payment option.</p>
    pub payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
    /// <p>The plan type.</p>
    pub plan_type: std::option::Option<crate::model::SavingsPlanType>,
    /// <p>The duration, in seconds.</p>
    pub duration_seconds: i64,
    /// <p>The currency.</p>
    pub currency: std::option::Option<crate::model::CurrencyCode>,
    /// <p>The description.</p>
    pub plan_description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParentSavingsPlanOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParentSavingsPlanOffering");
        formatter.field("offering_id", &self.offering_id);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("plan_type", &self.plan_type);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("currency", &self.currency);
        formatter.field("plan_description", &self.plan_description);
        formatter.finish()
    }
}
/// See [`ParentSavingsPlanOffering`](crate::model::ParentSavingsPlanOffering)
pub mod parent_savings_plan_offering {
    /// A builder for [`ParentSavingsPlanOffering`](crate::model::ParentSavingsPlanOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        pub(crate) plan_type: std::option::Option<crate::model::SavingsPlanType>,
        pub(crate) duration_seconds: std::option::Option<i64>,
        pub(crate) currency: std::option::Option<crate::model::CurrencyCode>,
        pub(crate) plan_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the offering.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// <p>The payment option.</p>
        pub fn payment_option(mut self, input: crate::model::SavingsPlanPaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn plan_type(mut self, input: crate::model::SavingsPlanType) -> Self {
            self.plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanType>,
        ) -> Self {
            self.plan_type = input;
            self
        }
        /// <p>The duration, in seconds.</p>
        pub fn duration_seconds(mut self, input: i64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The duration, in seconds.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>The currency.</p>
        pub fn currency(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The currency.</p>
        pub fn set_currency(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency = input;
            self
        }
        /// <p>The description.</p>
        pub fn plan_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.plan_description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_plan_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.plan_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ParentSavingsPlanOffering`](crate::model::ParentSavingsPlanOffering)
        pub fn build(self) -> crate::model::ParentSavingsPlanOffering {
            crate::model::ParentSavingsPlanOffering {
                offering_id: self.offering_id,
                payment_option: self.payment_option,
                plan_type: self.plan_type,
                duration_seconds: self.duration_seconds.unwrap_or_default(),
                currency: self.currency,
                plan_description: self.plan_description,
            }
        }
    }
}
impl ParentSavingsPlanOffering {
    /// Creates a new builder-style object to manufacture [`ParentSavingsPlanOffering`](crate::model::ParentSavingsPlanOffering)
    pub fn builder() -> crate::model::parent_savings_plan_offering::Builder {
        crate::model::parent_savings_plan_offering::Builder::default()
    }
}

/// <p>Information about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanOfferingRateFilterElement {
    /// <p>The filter name.</p>
    pub name: std::option::Option<crate::model::SavingsPlanRateFilterAttribute>,
    /// <p>The filter values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SavingsPlanOfferingRateFilterElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanOfferingRateFilterElement");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SavingsPlanOfferingRateFilterElement`](crate::model::SavingsPlanOfferingRateFilterElement)
pub mod savings_plan_offering_rate_filter_element {
    /// A builder for [`SavingsPlanOfferingRateFilterElement`](crate::model::SavingsPlanOfferingRateFilterElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlanRateFilterAttribute>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The filter name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlanRateFilterAttribute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The filter name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateFilterAttribute>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanOfferingRateFilterElement`](crate::model::SavingsPlanOfferingRateFilterElement)
        pub fn build(self) -> crate::model::SavingsPlanOfferingRateFilterElement {
            crate::model::SavingsPlanOfferingRateFilterElement {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl SavingsPlanOfferingRateFilterElement {
    /// Creates a new builder-style object to manufacture [`SavingsPlanOfferingRateFilterElement`](crate::model::SavingsPlanOfferingRateFilterElement)
    pub fn builder() -> crate::model::savings_plan_offering_rate_filter_element::Builder {
        crate::model::savings_plan_offering_rate_filter_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanRateFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    ProductDescription,
    #[allow(missing_docs)] // documentation missing in model
    ProductId,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    Tenancy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanRateFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "instanceFamily" => SavingsPlanRateFilterAttribute::InstanceFamily,
            "instanceType" => SavingsPlanRateFilterAttribute::InstanceType,
            "productDescription" => SavingsPlanRateFilterAttribute::ProductDescription,
            "productId" => SavingsPlanRateFilterAttribute::ProductId,
            "region" => SavingsPlanRateFilterAttribute::Region,
            "tenancy" => SavingsPlanRateFilterAttribute::Tenancy,
            other => SavingsPlanRateFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanRateFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanRateFilterAttribute::from(s))
    }
}
impl SavingsPlanRateFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanRateFilterAttribute::InstanceFamily => "instanceFamily",
            SavingsPlanRateFilterAttribute::InstanceType => "instanceType",
            SavingsPlanRateFilterAttribute::ProductDescription => "productDescription",
            SavingsPlanRateFilterAttribute::ProductId => "productId",
            SavingsPlanRateFilterAttribute::Region => "region",
            SavingsPlanRateFilterAttribute::Tenancy => "tenancy",
            SavingsPlanRateFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "instanceFamily",
            "instanceType",
            "productDescription",
            "productId",
            "region",
            "tenancy",
        ]
    }
}
impl AsRef<str> for SavingsPlanRateFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Savings Plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlan {
    /// <p>The ID of the offering.</p>
    pub offering_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Savings Plan.</p>
    pub savings_plan_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Savings Plan.</p>
    pub savings_plan_arn: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The start time.</p>
    pub start: std::option::Option<std::string::String>,
    /// <p>The end time.</p>
    pub end: std::option::Option<std::string::String>,
    /// <p>The state.</p>
    pub state: std::option::Option<crate::model::SavingsPlanState>,
    /// <p>The AWS Region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The EC2 instance family.</p>
    pub ec2_instance_family: std::option::Option<std::string::String>,
    /// <p>The plan type.</p>
    pub savings_plan_type: std::option::Option<crate::model::SavingsPlanType>,
    /// <p>The payment option.</p>
    pub payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
    /// <p>The product types.</p>
    pub product_types: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
    /// <p>The currency.</p>
    pub currency: std::option::Option<crate::model::CurrencyCode>,
    /// <p>The hourly commitment, in USD.</p>
    pub commitment: std::option::Option<std::string::String>,
    /// <p>The up-front payment amount.</p>
    pub upfront_payment_amount: std::option::Option<std::string::String>,
    /// <p>The recurring payment amount.</p>
    pub recurring_payment_amount: std::option::Option<std::string::String>,
    /// <p>The duration of the term, in seconds.</p>
    pub term_duration_in_seconds: i64,
    /// <p>One or more tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SavingsPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlan");
        formatter.field("offering_id", &self.offering_id);
        formatter.field("savings_plan_id", &self.savings_plan_id);
        formatter.field("savings_plan_arn", &self.savings_plan_arn);
        formatter.field("description", &self.description);
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.field("state", &self.state);
        formatter.field("region", &self.region);
        formatter.field("ec2_instance_family", &self.ec2_instance_family);
        formatter.field("savings_plan_type", &self.savings_plan_type);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("product_types", &self.product_types);
        formatter.field("currency", &self.currency);
        formatter.field("commitment", &self.commitment);
        formatter.field("upfront_payment_amount", &self.upfront_payment_amount);
        formatter.field("recurring_payment_amount", &self.recurring_payment_amount);
        formatter.field("term_duration_in_seconds", &self.term_duration_in_seconds);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`SavingsPlan`](crate::model::SavingsPlan)
pub mod savings_plan {
    /// A builder for [`SavingsPlan`](crate::model::SavingsPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) savings_plan_id: std::option::Option<std::string::String>,
        pub(crate) savings_plan_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::SavingsPlanState>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_family: std::option::Option<std::string::String>,
        pub(crate) savings_plan_type: std::option::Option<crate::model::SavingsPlanType>,
        pub(crate) payment_option: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        pub(crate) product_types:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        pub(crate) currency: std::option::Option<crate::model::CurrencyCode>,
        pub(crate) commitment: std::option::Option<std::string::String>,
        pub(crate) upfront_payment_amount: std::option::Option<std::string::String>,
        pub(crate) recurring_payment_amount: std::option::Option<std::string::String>,
        pub(crate) term_duration_in_seconds: std::option::Option<i64>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the offering.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_id = Some(input.into());
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Savings Plan.</p>
        pub fn savings_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Savings Plan.</p>
        pub fn set_savings_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_arn = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The start time.</p>
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// <p>The start time.</p>
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end time.</p>
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// <p>The end time.</p>
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// <p>The state.</p>
        pub fn state(mut self, input: crate::model::SavingsPlanState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The AWS Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The EC2 instance family.</p>
        pub fn ec2_instance_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_family = Some(input.into());
            self
        }
        /// <p>The EC2 instance family.</p>
        pub fn set_ec2_instance_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_family = input;
            self
        }
        /// <p>The plan type.</p>
        pub fn savings_plan_type(mut self, input: crate::model::SavingsPlanType) -> Self {
            self.savings_plan_type = Some(input);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_savings_plan_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanType>,
        ) -> Self {
            self.savings_plan_type = input;
            self
        }
        /// <p>The payment option.</p>
        pub fn payment_option(mut self, input: crate::model::SavingsPlanPaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanPaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// Appends an item to `product_types`.
        ///
        /// To override the contents of this collection use [`set_product_types`](Self::set_product_types).
        ///
        /// <p>The product types.</p>
        pub fn product_types(
            mut self,
            input: impl Into<crate::model::SavingsPlanProductType>,
        ) -> Self {
            let mut v = self.product_types.unwrap_or_default();
            v.push(input.into());
            self.product_types = Some(v);
            self
        }
        /// <p>The product types.</p>
        pub fn set_product_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        ) -> Self {
            self.product_types = input;
            self
        }
        /// <p>The currency.</p>
        pub fn currency(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The currency.</p>
        pub fn set_currency(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency = input;
            self
        }
        /// <p>The hourly commitment, in USD.</p>
        pub fn commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.commitment = Some(input.into());
            self
        }
        /// <p>The hourly commitment, in USD.</p>
        pub fn set_commitment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commitment = input;
            self
        }
        /// <p>The up-front payment amount.</p>
        pub fn upfront_payment_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.upfront_payment_amount = Some(input.into());
            self
        }
        /// <p>The up-front payment amount.</p>
        pub fn set_upfront_payment_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upfront_payment_amount = input;
            self
        }
        /// <p>The recurring payment amount.</p>
        pub fn recurring_payment_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurring_payment_amount = Some(input.into());
            self
        }
        /// <p>The recurring payment amount.</p>
        pub fn set_recurring_payment_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_payment_amount = input;
            self
        }
        /// <p>The duration of the term, in seconds.</p>
        pub fn term_duration_in_seconds(mut self, input: i64) -> Self {
            self.term_duration_in_seconds = Some(input);
            self
        }
        /// <p>The duration of the term, in seconds.</p>
        pub fn set_term_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.term_duration_in_seconds = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlan`](crate::model::SavingsPlan)
        pub fn build(self) -> crate::model::SavingsPlan {
            crate::model::SavingsPlan {
                offering_id: self.offering_id,
                savings_plan_id: self.savings_plan_id,
                savings_plan_arn: self.savings_plan_arn,
                description: self.description,
                start: self.start,
                end: self.end,
                state: self.state,
                region: self.region,
                ec2_instance_family: self.ec2_instance_family,
                savings_plan_type: self.savings_plan_type,
                payment_option: self.payment_option,
                product_types: self.product_types,
                currency: self.currency,
                commitment: self.commitment,
                upfront_payment_amount: self.upfront_payment_amount,
                recurring_payment_amount: self.recurring_payment_amount,
                term_duration_in_seconds: self.term_duration_in_seconds.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl SavingsPlan {
    /// Creates a new builder-style object to manufacture [`SavingsPlan`](crate::model::SavingsPlan)
    pub fn builder() -> crate::model::savings_plan::Builder {
        crate::model::savings_plan::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    PaymentFailed,
    #[allow(missing_docs)] // documentation missing in model
    PaymentPending,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    QueuedDeleted,
    #[allow(missing_docs)] // documentation missing in model
    Retired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanState {
    fn from(s: &str) -> Self {
        match s {
            "active" => SavingsPlanState::Active,
            "payment-failed" => SavingsPlanState::PaymentFailed,
            "payment-pending" => SavingsPlanState::PaymentPending,
            "queued" => SavingsPlanState::Queued,
            "queued-deleted" => SavingsPlanState::QueuedDeleted,
            "retired" => SavingsPlanState::Retired,
            other => SavingsPlanState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanState::from(s))
    }
}
impl SavingsPlanState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanState::Active => "active",
            SavingsPlanState::PaymentFailed => "payment-failed",
            SavingsPlanState::PaymentPending => "payment-pending",
            SavingsPlanState::Queued => "queued",
            SavingsPlanState::QueuedDeleted => "queued-deleted",
            SavingsPlanState::Retired => "retired",
            SavingsPlanState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "active",
            "payment-failed",
            "payment-pending",
            "queued",
            "queued-deleted",
            "retired",
        ]
    }
}
impl AsRef<str> for SavingsPlanState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanFilter {
    /// <p>The filter name.</p>
    pub name: std::option::Option<crate::model::SavingsPlansFilterName>,
    /// <p>The filter value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SavingsPlanFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SavingsPlanFilter`](crate::model::SavingsPlanFilter)
pub mod savings_plan_filter {
    /// A builder for [`SavingsPlanFilter`](crate::model::SavingsPlanFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlansFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The filter name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlansFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The filter name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanFilter`](crate::model::SavingsPlanFilter)
        pub fn build(self) -> crate::model::SavingsPlanFilter {
            crate::model::SavingsPlanFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl SavingsPlanFilter {
    /// Creates a new builder-style object to manufacture [`SavingsPlanFilter`](crate::model::SavingsPlanFilter)
    pub fn builder() -> crate::model::savings_plan_filter::Builder {
        crate::model::savings_plan_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlansFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Commitment,
    #[allow(missing_docs)] // documentation missing in model
    Ec2InstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    End,
    #[allow(missing_docs)] // documentation missing in model
    PaymentOption,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    SavingsPlanType,
    #[allow(missing_docs)] // documentation missing in model
    Start,
    #[allow(missing_docs)] // documentation missing in model
    Term,
    #[allow(missing_docs)] // documentation missing in model
    Upfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlansFilterName {
    fn from(s: &str) -> Self {
        match s {
            "commitment" => SavingsPlansFilterName::Commitment,
            "ec2-instance-family" => SavingsPlansFilterName::Ec2InstanceFamily,
            "end" => SavingsPlansFilterName::End,
            "payment-option" => SavingsPlansFilterName::PaymentOption,
            "region" => SavingsPlansFilterName::Region,
            "savings-plan-type" => SavingsPlansFilterName::SavingsPlanType,
            "start" => SavingsPlansFilterName::Start,
            "term" => SavingsPlansFilterName::Term,
            "upfront" => SavingsPlansFilterName::Upfront,
            other => SavingsPlansFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlansFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlansFilterName::from(s))
    }
}
impl SavingsPlansFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlansFilterName::Commitment => "commitment",
            SavingsPlansFilterName::Ec2InstanceFamily => "ec2-instance-family",
            SavingsPlansFilterName::End => "end",
            SavingsPlansFilterName::PaymentOption => "payment-option",
            SavingsPlansFilterName::Region => "region",
            SavingsPlansFilterName::SavingsPlanType => "savings-plan-type",
            SavingsPlansFilterName::Start => "start",
            SavingsPlansFilterName::Term => "term",
            SavingsPlansFilterName::Upfront => "upfront",
            SavingsPlansFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "commitment",
            "ec2-instance-family",
            "end",
            "payment-option",
            "region",
            "savings-plan-type",
            "start",
            "term",
            "upfront",
        ]
    }
}
impl AsRef<str> for SavingsPlansFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Savings Plan rate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanRate {
    /// <p>The rate.</p>
    pub rate: std::option::Option<std::string::String>,
    /// <p>The currency.</p>
    pub currency: std::option::Option<crate::model::CurrencyCode>,
    /// <p>The unit.</p>
    pub unit: std::option::Option<crate::model::SavingsPlanRateUnit>,
    /// <p>The product type.</p>
    pub product_type: std::option::Option<crate::model::SavingsPlanProductType>,
    /// <p>The service.</p>
    pub service_code: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
    /// <p>The usage details of the line item in the billing report.</p>
    pub usage_type: std::option::Option<std::string::String>,
    /// <p>The specific AWS operation for the line item in the billing report.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The properties.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateProperty>>,
}
impl std::fmt::Debug for SavingsPlanRate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanRate");
        formatter.field("rate", &self.rate);
        formatter.field("currency", &self.currency);
        formatter.field("unit", &self.unit);
        formatter.field("product_type", &self.product_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("usage_type", &self.usage_type);
        formatter.field("operation", &self.operation);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`SavingsPlanRate`](crate::model::SavingsPlanRate)
pub mod savings_plan_rate {
    /// A builder for [`SavingsPlanRate`](crate::model::SavingsPlanRate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rate: std::option::Option<std::string::String>,
        pub(crate) currency: std::option::Option<crate::model::CurrencyCode>,
        pub(crate) unit: std::option::Option<crate::model::SavingsPlanRateUnit>,
        pub(crate) product_type: std::option::Option<crate::model::SavingsPlanProductType>,
        pub(crate) service_code: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
        pub(crate) usage_type: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateProperty>>,
    }
    impl Builder {
        /// <p>The rate.</p>
        pub fn rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.rate = Some(input.into());
            self
        }
        /// <p>The rate.</p>
        pub fn set_rate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rate = input;
            self
        }
        /// <p>The currency.</p>
        pub fn currency(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The currency.</p>
        pub fn set_currency(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency = input;
            self
        }
        /// <p>The unit.</p>
        pub fn unit(mut self, input: crate::model::SavingsPlanRateUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, input: crate::model::SavingsPlanProductType) -> Self {
            self.product_type = Some(input);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanProductType>,
        ) -> Self {
            self.product_type = input;
            self
        }
        /// <p>The service.</p>
        pub fn service_code(mut self, input: crate::model::SavingsPlanRateServiceCode) -> Self {
            self.service_code = Some(input);
            self
        }
        /// <p>The service.</p>
        pub fn set_service_code(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateServiceCode>,
        ) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_type = Some(input.into());
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_type = input;
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The properties.</p>
        pub fn properties(
            mut self,
            input: impl Into<crate::model::SavingsPlanRateProperty>,
        ) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input.into());
            self.properties = Some(v);
            self
        }
        /// <p>The properties.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateProperty>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanRate`](crate::model::SavingsPlanRate)
        pub fn build(self) -> crate::model::SavingsPlanRate {
            crate::model::SavingsPlanRate {
                rate: self.rate,
                currency: self.currency,
                unit: self.unit,
                product_type: self.product_type,
                service_code: self.service_code,
                usage_type: self.usage_type,
                operation: self.operation,
                properties: self.properties,
            }
        }
    }
}
impl SavingsPlanRate {
    /// Creates a new builder-style object to manufacture [`SavingsPlanRate`](crate::model::SavingsPlanRate)
    pub fn builder() -> crate::model::savings_plan_rate::Builder {
        crate::model::savings_plan_rate::Builder::default()
    }
}

/// <p>Information about a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanRateProperty {
    /// <p>The property name.</p>
    pub name: std::option::Option<crate::model::SavingsPlanRatePropertyKey>,
    /// <p>The property value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SavingsPlanRateProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanRateProperty");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SavingsPlanRateProperty`](crate::model::SavingsPlanRateProperty)
pub mod savings_plan_rate_property {
    /// A builder for [`SavingsPlanRateProperty`](crate::model::SavingsPlanRateProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlanRatePropertyKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The property name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlanRatePropertyKey) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The property name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRatePropertyKey>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The property value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The property value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanRateProperty`](crate::model::SavingsPlanRateProperty)
        pub fn build(self) -> crate::model::SavingsPlanRateProperty {
            crate::model::SavingsPlanRateProperty {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SavingsPlanRateProperty {
    /// Creates a new builder-style object to manufacture [`SavingsPlanRateProperty`](crate::model::SavingsPlanRateProperty)
    pub fn builder() -> crate::model::savings_plan_rate_property::Builder {
        crate::model::savings_plan_rate_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanRatePropertyKey {
    #[allow(missing_docs)] // documentation missing in model
    InstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    ProductDescription,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    Tenancy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanRatePropertyKey {
    fn from(s: &str) -> Self {
        match s {
            "instanceFamily" => SavingsPlanRatePropertyKey::InstanceFamily,
            "instanceType" => SavingsPlanRatePropertyKey::InstanceType,
            "productDescription" => SavingsPlanRatePropertyKey::ProductDescription,
            "region" => SavingsPlanRatePropertyKey::Region,
            "tenancy" => SavingsPlanRatePropertyKey::Tenancy,
            other => SavingsPlanRatePropertyKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanRatePropertyKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanRatePropertyKey::from(s))
    }
}
impl SavingsPlanRatePropertyKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanRatePropertyKey::InstanceFamily => "instanceFamily",
            SavingsPlanRatePropertyKey::InstanceType => "instanceType",
            SavingsPlanRatePropertyKey::ProductDescription => "productDescription",
            SavingsPlanRatePropertyKey::Region => "region",
            SavingsPlanRatePropertyKey::Tenancy => "tenancy",
            SavingsPlanRatePropertyKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "instanceFamily",
            "instanceType",
            "productDescription",
            "region",
            "tenancy",
        ]
    }
}
impl AsRef<str> for SavingsPlanRatePropertyKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlanRateFilter {
    /// <p>The filter name.</p>
    pub name: std::option::Option<crate::model::SavingsPlanRateFilterName>,
    /// <p>The filter values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SavingsPlanRateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlanRateFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SavingsPlanRateFilter`](crate::model::SavingsPlanRateFilter)
pub mod savings_plan_rate_filter {
    /// A builder for [`SavingsPlanRateFilter`](crate::model::SavingsPlanRateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SavingsPlanRateFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The filter name.</p>
        pub fn name(mut self, input: crate::model::SavingsPlanRateFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The filter name.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanRateFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlanRateFilter`](crate::model::SavingsPlanRateFilter)
        pub fn build(self) -> crate::model::SavingsPlanRateFilter {
            crate::model::SavingsPlanRateFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl SavingsPlanRateFilter {
    /// Creates a new builder-style object to manufacture [`SavingsPlanRateFilter`](crate::model::SavingsPlanRateFilter)
    pub fn builder() -> crate::model::savings_plan_rate_filter::Builder {
        crate::model::savings_plan_rate_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlanRateFilterName {
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    Operation,
    #[allow(missing_docs)] // documentation missing in model
    ProductDescription,
    #[allow(missing_docs)] // documentation missing in model
    ProductType,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    ServiceCode,
    #[allow(missing_docs)] // documentation missing in model
    Tenancy,
    #[allow(missing_docs)] // documentation missing in model
    UsageType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlanRateFilterName {
    fn from(s: &str) -> Self {
        match s {
            "instanceType" => SavingsPlanRateFilterName::InstanceType,
            "operation" => SavingsPlanRateFilterName::Operation,
            "productDescription" => SavingsPlanRateFilterName::ProductDescription,
            "productType" => SavingsPlanRateFilterName::ProductType,
            "region" => SavingsPlanRateFilterName::Region,
            "serviceCode" => SavingsPlanRateFilterName::ServiceCode,
            "tenancy" => SavingsPlanRateFilterName::Tenancy,
            "usageType" => SavingsPlanRateFilterName::UsageType,
            other => SavingsPlanRateFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlanRateFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlanRateFilterName::from(s))
    }
}
impl SavingsPlanRateFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlanRateFilterName::InstanceType => "instanceType",
            SavingsPlanRateFilterName::Operation => "operation",
            SavingsPlanRateFilterName::ProductDescription => "productDescription",
            SavingsPlanRateFilterName::ProductType => "productType",
            SavingsPlanRateFilterName::Region => "region",
            SavingsPlanRateFilterName::ServiceCode => "serviceCode",
            SavingsPlanRateFilterName::Tenancy => "tenancy",
            SavingsPlanRateFilterName::UsageType => "usageType",
            SavingsPlanRateFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "instanceType",
            "operation",
            "productDescription",
            "productType",
            "region",
            "serviceCode",
            "tenancy",
            "usageType",
        ]
    }
}
impl AsRef<str> for SavingsPlanRateFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
