// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSSavingsPlan`.
///
/// This client allows ergonomic access to a `AWSSavingsPlan`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateSavingsPlan` operation.
    ///
    /// See [`CreateSavingsPlan`](crate::client::fluent_builders::CreateSavingsPlan) for more information about the
    /// operation and its arguments.
    pub fn create_savings_plan(&self) -> fluent_builders::CreateSavingsPlan<C, M, R> {
        fluent_builders::CreateSavingsPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQueuedSavingsPlan` operation.
    ///
    /// See [`DeleteQueuedSavingsPlan`](crate::client::fluent_builders::DeleteQueuedSavingsPlan) for more information about the
    /// operation and its arguments.
    pub fn delete_queued_savings_plan(&self) -> fluent_builders::DeleteQueuedSavingsPlan<C, M, R> {
        fluent_builders::DeleteQueuedSavingsPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSavingsPlanRates` operation.
    ///
    /// See [`DescribeSavingsPlanRates`](crate::client::fluent_builders::DescribeSavingsPlanRates) for more information about the
    /// operation and its arguments.
    pub fn describe_savings_plan_rates(
        &self,
    ) -> fluent_builders::DescribeSavingsPlanRates<C, M, R> {
        fluent_builders::DescribeSavingsPlanRates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSavingsPlans` operation.
    ///
    /// See [`DescribeSavingsPlans`](crate::client::fluent_builders::DescribeSavingsPlans) for more information about the
    /// operation and its arguments.
    pub fn describe_savings_plans(&self) -> fluent_builders::DescribeSavingsPlans<C, M, R> {
        fluent_builders::DescribeSavingsPlans::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSavingsPlansOfferingRates` operation.
    ///
    /// See [`DescribeSavingsPlansOfferingRates`](crate::client::fluent_builders::DescribeSavingsPlansOfferingRates) for more information about the
    /// operation and its arguments.
    pub fn describe_savings_plans_offering_rates(
        &self,
    ) -> fluent_builders::DescribeSavingsPlansOfferingRates<C, M, R> {
        fluent_builders::DescribeSavingsPlansOfferingRates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSavingsPlansOfferings` operation.
    ///
    /// See [`DescribeSavingsPlansOfferings`](crate::client::fluent_builders::DescribeSavingsPlansOfferings) for more information about the
    /// operation and its arguments.
    pub fn describe_savings_plans_offerings(
        &self,
    ) -> fluent_builders::DescribeSavingsPlansOfferings<C, M, R> {
        fluent_builders::DescribeSavingsPlansOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateSavingsPlan`.
    ///
    /// <p>Creates a Savings Plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSavingsPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_savings_plan_input::Builder,
    }
    impl<C, M, R> CreateSavingsPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSavingsPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSavingsPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSavingsPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSavingsPlanInputOperationOutputAlias,
                crate::output::CreateSavingsPlanOutput,
                crate::error::CreateSavingsPlanError,
                crate::input::CreateSavingsPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the offering.</p>
        pub fn savings_plan_offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_offering_id(inp);
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_savings_plan_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_offering_id(input);
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more
        /// than three digits after the decimal point.</p>
        pub fn commitment(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commitment(inp);
            self
        }
        /// <p>The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more
        /// than three digits after the decimal point.</p>
        pub fn set_commitment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commitment(input);
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan.
        /// This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn upfront_payment_amount(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upfront_payment_amount(inp);
            self
        }
        /// <p>The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings Plan.
        /// This parameter is supported only if the payment option is <code>Partial Upfront</code>.</p>
        pub fn set_upfront_payment_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_upfront_payment_amount(input);
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn purchase_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.purchase_time(inp);
            self
        }
        /// <p>The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).</p>
        pub fn set_purchase_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_purchase_time(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueuedSavingsPlan`.
    ///
    /// <p>Deletes the queued purchase for the specified Savings Plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteQueuedSavingsPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_queued_savings_plan_input::Builder,
    }
    impl<C, M, R> DeleteQueuedSavingsPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQueuedSavingsPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueuedSavingsPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueuedSavingsPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQueuedSavingsPlanInputOperationOutputAlias,
                crate::output::DeleteQueuedSavingsPlanOutput,
                crate::error::DeleteQueuedSavingsPlanError,
                crate::input::DeleteQueuedSavingsPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_id(inp);
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlanRates`.
    ///
    /// <p>Describes the specified Savings Plans rates.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSavingsPlanRates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_savings_plan_rates_input::Builder,
    }
    impl<C, M, R> DescribeSavingsPlanRates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSavingsPlanRates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlanRatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlanRatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSavingsPlanRatesInputOperationOutputAlias,
                crate::output::DescribeSavingsPlanRatesOutput,
                crate::error::DescribeSavingsPlanRatesError,
                crate::input::DescribeSavingsPlanRatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn savings_plan_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_id(inp);
            self
        }
        /// <p>The ID of the Savings Plan.</p>
        pub fn set_savings_plan_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SavingsPlanRateFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlans`.
    ///
    /// <p>Describes the specified Savings Plans.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSavingsPlans<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_savings_plans_input::Builder,
    }
    impl<C, M, R> DescribeSavingsPlans<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSavingsPlans`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSavingsPlansInputOperationOutputAlias,
                crate::output::DescribeSavingsPlansOutput,
                crate::error::DescribeSavingsPlansError,
                crate::input::DescribeSavingsPlansInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `savingsPlanArns`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_arns`](Self::set_savings_plan_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn savings_plan_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the Savings Plans.</p>
        pub fn set_savings_plan_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_arns(input);
            self
        }
        /// Appends an item to `savingsPlanIds`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_ids`](Self::set_savings_plan_ids).
        ///
        /// <p>The IDs of the Savings Plans.</p>
        pub fn savings_plan_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_ids(inp);
            self
        }
        /// <p>The IDs of the Savings Plans.</p>
        pub fn set_savings_plan_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_ids(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>The states.</p>
        pub fn states(mut self, inp: impl Into<crate::model::SavingsPlanState>) -> Self {
            self.inner = self.inner.states(inp);
            self
        }
        /// <p>The states.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanState>>,
        ) -> Self {
            self.inner = self.inner.set_states(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SavingsPlanFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlansOfferingRates`.
    ///
    /// <p>Describes the specified Savings Plans offering rates.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSavingsPlansOfferingRates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_savings_plans_offering_rates_input::Builder,
    }
    impl<C, M, R> DescribeSavingsPlansOfferingRates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSavingsPlansOfferingRates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOfferingRatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansOfferingRatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSavingsPlansOfferingRatesInputOperationOutputAlias,
                crate::output::DescribeSavingsPlansOfferingRatesOutput,
                crate::error::DescribeSavingsPlansOfferingRatesError,
                crate::input::DescribeSavingsPlansOfferingRatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `savingsPlanOfferingIds`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_offering_ids`](Self::set_savings_plan_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn savings_plan_offering_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.savings_plan_offering_ids(inp);
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_savings_plan_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_offering_ids(input);
            self
        }
        /// Appends an item to `savingsPlanPaymentOptions`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_payment_options`](Self::set_savings_plan_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn savings_plan_payment_options(
            mut self,
            inp: impl Into<crate::model::SavingsPlanPaymentOption>,
        ) -> Self {
            self.inner = self.inner.savings_plan_payment_options(inp);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_savings_plan_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_payment_options(input);
            self
        }
        /// Appends an item to `savingsPlanTypes`.
        ///
        /// To override the contents of this collection use [`set_savings_plan_types`](Self::set_savings_plan_types).
        ///
        /// <p>The plan types.</p>
        pub fn savings_plan_types(mut self, inp: impl Into<crate::model::SavingsPlanType>) -> Self {
            self.inner = self.inner.savings_plan_types(inp);
            self
        }
        /// <p>The plan types.</p>
        pub fn set_savings_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.inner = self.inner.set_savings_plan_types(input);
            self
        }
        /// Appends an item to `products`.
        ///
        /// To override the contents of this collection use [`set_products`](Self::set_products).
        ///
        /// <p>The AWS products.</p>
        pub fn products(mut self, inp: impl Into<crate::model::SavingsPlanProductType>) -> Self {
            self.inner = self.inner.products(inp);
            self
        }
        /// <p>The AWS products.</p>
        pub fn set_products(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanProductType>>,
        ) -> Self {
            self.inner = self.inner.set_products(input);
            self
        }
        /// Appends an item to `serviceCodes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(
            mut self,
            inp: impl Into<crate::model::SavingsPlanRateServiceCode>,
        ) -> Self {
            self.inner = self.inner.service_codes(inp);
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanRateServiceCode>>,
        ) -> Self {
            self.inner = self.inner.set_service_codes(input);
            self
        }
        /// Appends an item to `usageTypes`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_types(inp);
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usage_types(input);
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations(inp);
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::SavingsPlanOfferingRateFilterElement>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingRateFilterElement>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSavingsPlansOfferings`.
    ///
    /// <p>Describes the specified Savings Plans offerings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSavingsPlansOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_savings_plans_offerings_input::Builder,
    }
    impl<C, M, R> DescribeSavingsPlansOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSavingsPlansOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSavingsPlansOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSavingsPlansOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSavingsPlansOfferingsInputOperationOutputAlias,
                crate::output::DescribeSavingsPlansOfferingsOutput,
                crate::error::DescribeSavingsPlansOfferingsError,
                crate::input::DescribeSavingsPlansOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `offeringIds`.
        ///
        /// To override the contents of this collection use [`set_offering_ids`](Self::set_offering_ids).
        ///
        /// <p>The IDs of the offerings.</p>
        pub fn offering_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_ids(inp);
            self
        }
        /// <p>The IDs of the offerings.</p>
        pub fn set_offering_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_offering_ids(input);
            self
        }
        /// Appends an item to `paymentOptions`.
        ///
        /// To override the contents of this collection use [`set_payment_options`](Self::set_payment_options).
        ///
        /// <p>The payment options.</p>
        pub fn payment_options(
            mut self,
            inp: impl Into<crate::model::SavingsPlanPaymentOption>,
        ) -> Self {
            self.inner = self.inner.payment_options(inp);
            self
        }
        /// <p>The payment options.</p>
        pub fn set_payment_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanPaymentOption>>,
        ) -> Self {
            self.inner = self.inner.set_payment_options(input);
            self
        }
        /// <p>The product type.</p>
        pub fn product_type(mut self, inp: crate::model::SavingsPlanProductType) -> Self {
            self.inner = self.inner.product_type(inp);
            self
        }
        /// <p>The product type.</p>
        pub fn set_product_type(
            mut self,
            input: std::option::Option<crate::model::SavingsPlanProductType>,
        ) -> Self {
            self.inner = self.inner.set_product_type(input);
            self
        }
        /// Appends an item to `planTypes`.
        ///
        /// To override the contents of this collection use [`set_plan_types`](Self::set_plan_types).
        ///
        /// <p>The plan type.</p>
        pub fn plan_types(mut self, inp: impl Into<crate::model::SavingsPlanType>) -> Self {
            self.inner = self.inner.plan_types(inp);
            self
        }
        /// <p>The plan type.</p>
        pub fn set_plan_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlanType>>,
        ) -> Self {
            self.inner = self.inner.set_plan_types(input);
            self
        }
        /// Appends an item to `durations`.
        ///
        /// To override the contents of this collection use [`set_durations`](Self::set_durations).
        ///
        /// <p>The durations, in seconds.</p>
        pub fn durations(mut self, inp: impl Into<i64>) -> Self {
            self.inner = self.inner.durations(inp);
            self
        }
        /// <p>The durations, in seconds.</p>
        pub fn set_durations(mut self, input: std::option::Option<std::vec::Vec<i64>>) -> Self {
            self.inner = self.inner.set_durations(input);
            self
        }
        /// Appends an item to `currencies`.
        ///
        /// To override the contents of this collection use [`set_currencies`](Self::set_currencies).
        ///
        /// <p>The currencies.</p>
        pub fn currencies(mut self, inp: impl Into<crate::model::CurrencyCode>) -> Self {
            self.inner = self.inner.currencies(inp);
            self
        }
        /// <p>The currencies.</p>
        pub fn set_currencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrencyCode>>,
        ) -> Self {
            self.inner = self.inner.set_currencies(input);
            self
        }
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>The descriptions.</p>
        pub fn descriptions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.descriptions(inp);
            self
        }
        /// <p>The descriptions.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_descriptions(input);
            self
        }
        /// Appends an item to `serviceCodes`.
        ///
        /// To override the contents of this collection use [`set_service_codes`](Self::set_service_codes).
        ///
        /// <p>The services.</p>
        pub fn service_codes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_codes(inp);
            self
        }
        /// <p>The services.</p>
        pub fn set_service_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_service_codes(input);
            self
        }
        /// Appends an item to `usageTypes`.
        ///
        /// To override the contents of this collection use [`set_usage_types`](Self::set_usage_types).
        ///
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn usage_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_types(inp);
            self
        }
        /// <p>The usage details of the line item in the billing report.</p>
        pub fn set_usage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usage_types(input);
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn operations(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operations(inp);
            self
        }
        /// <p>The specific AWS operation for the line item in the billing report.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters.</p>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::SavingsPlanOfferingFilterElement>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlanOfferingFilterElement>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve additional results, make another
        /// call with the returned token value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
