// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`InvokeEndpointInput`](crate::input::InvokeEndpointInput)
pub mod invoke_endpoint_input {
    /// A builder for [`InvokeEndpointInput`](crate::input::InvokeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) accept: std::option::Option<std::string::String>,
        pub(crate) custom_attributes: std::option::Option<std::string::String>,
        pub(crate) target_model: std::option::Option<std::string::String>,
        pub(crate) target_variant: std::option::Option<std::string::String>,
        pub(crate) target_container_hostname: std::option::Option<std::string::String>,
        pub(crate) inference_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API. </p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API. </p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker passes all of the data in the body to the model. </p>
        /// <p>For information about the format of the request body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.</p>
        pub fn body(mut self, input: aws_smithy_types::Blob) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker passes all of the data in the body to the model. </p>
        /// <p>For information about the format of the request body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.</p>
        pub fn set_body(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.body = input;
            self
        }
        /// <p>The MIME type of the input data in the request body.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The MIME type of the input data in the request body.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The desired MIME type of the inference in the response.</p>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p>The desired MIME type of the inference in the response.</p>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
        /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your post-processing function.</p>
        /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.</p>
        pub fn custom_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_attributes = Some(input.into());
            self
        }
        /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
        /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your post-processing function.</p>
        /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.</p>
        pub fn set_custom_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_attributes = input;
            self
        }
        /// <p>The model to request for inference when invoking a multi-model endpoint.</p>
        pub fn target_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_model = Some(input.into());
            self
        }
        /// <p>The model to request for inference when invoking a multi-model endpoint.</p>
        pub fn set_target_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_model = input;
            self
        }
        /// <p>Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.</p>
        /// <p>For information about how to use variant targeting to perform a/b testing, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a> </p>
        pub fn target_variant(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_variant = Some(input.into());
            self
        }
        /// <p>Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.</p>
        /// <p>For information about how to use variant targeting to perform a/b testing, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a> </p>
        pub fn set_target_variant(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_variant = input;
            self
        }
        /// <p>If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.</p>
        pub fn target_container_hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_container_hostname = Some(input.into());
            self
        }
        /// <p>If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.</p>
        pub fn set_target_container_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_container_hostname = input;
            self
        }
        /// <p>If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.</p>
        pub fn inference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inference_id = Some(input.into());
            self
        }
        /// <p>If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.</p>
        pub fn set_inference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inference_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeEndpointInput`](crate::input::InvokeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InvokeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InvokeEndpointInput {
                endpoint_name: self.endpoint_name,
                body: self.body,
                content_type: self.content_type,
                accept: self.accept,
                custom_attributes: self.custom_attributes,
                target_model: self.target_model,
                target_variant: self.target_variant,
                target_container_hostname: self.target_container_hostname,
                inference_id: self.inference_id,
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeEndpointInputOperationOutputAlias = crate::operation::InvokeEndpoint;
#[doc(hidden)]
pub type InvokeEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InvokeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`InvokeEndpoint`](crate::operation::InvokeEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InvokeEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InvokeEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.endpoint_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_name",
                        details: "cannot be empty or unset",
                    })?;
            let endpoint_name = aws_smithy_http::label::fmt_string(input_1, false);
            if endpoint_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "endpoint_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/endpoints/{EndpointName}/invocations",
                EndpointName = endpoint_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::InvokeEndpointInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_2) = &_input.content_type {
                let formatted_3 = AsRef::<str>::as_ref(inner_2);
                if !formatted_3.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_3;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_4) = &_input.accept {
                let formatted_5 = AsRef::<str>::as_ref(inner_4);
                if !formatted_5.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_5;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Accept", header_value);
                }
            }
            if let Some(inner_6) = &_input.custom_attributes {
                let formatted_7 = AsRef::<str>::as_ref(inner_6);
                if !formatted_7.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_7;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "custom_attributes",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Custom-Attributes", header_value);
                }
            }
            if let Some(inner_8) = &_input.target_model {
                let formatted_9 = AsRef::<str>::as_ref(inner_8);
                if !formatted_9.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_9;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "target_model",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Target-Model", header_value);
                }
            }
            if let Some(inner_10) = &_input.target_variant {
                let formatted_11 = AsRef::<str>::as_ref(inner_10);
                if !formatted_11.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_11;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "target_variant",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Target-Variant", header_value);
                }
            }
            if let Some(inner_12) = &_input.target_container_hostname {
                let formatted_13 = AsRef::<str>::as_ref(inner_12);
                if !formatted_13.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_13;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "target_container_hostname",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder =
                        builder.header("X-Amzn-SageMaker-Target-Container-Hostname", header_value);
                }
            }
            if let Some(inner_14) = &_input.inference_id {
                let formatted_15 = AsRef::<str>::as_ref(inner_14);
                if !formatted_15.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_15;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "inference_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Inference-Id", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InvokeEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InvokeEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_invoke_endpoint_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InvokeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InvokeEndpoint",
            "sagemakerruntime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InvokeEndpointInput`](crate::input::InvokeEndpointInput)
    pub fn builder() -> crate::input::invoke_endpoint_input::Builder {
        crate::input::invoke_endpoint_input::Builder::default()
    }
}

/// See [`InvokeEndpointAsyncInput`](crate::input::InvokeEndpointAsyncInput)
pub mod invoke_endpoint_async_input {
    /// A builder for [`InvokeEndpointAsyncInput`](crate::input::InvokeEndpointAsyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) accept: std::option::Option<std::string::String>,
        pub(crate) custom_attributes: std::option::Option<std::string::String>,
        pub(crate) inference_id: std::option::Option<std::string::String>,
        pub(crate) input_location: std::option::Option<std::string::String>,
        pub(crate) request_ttl_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html"> <code>CreateEndpoint</code> </a> API.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html"> <code>CreateEndpoint</code> </a> API.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The MIME type of the input data in the request body.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The MIME type of the input data in the request body.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The desired MIME type of the inference in the response.</p>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p>The desired MIME type of the inference in the response.</p>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
        /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your post-processing function. </p>
        /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK. </p>
        pub fn custom_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_attributes = Some(input.into());
            self
        }
        /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
        /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your post-processing function. </p>
        /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK. </p>
        pub fn set_custom_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_attributes = input;
            self
        }
        /// <p>The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified. </p>
        pub fn inference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inference_id = Some(input.into());
            self
        }
        /// <p>The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified. </p>
        pub fn set_inference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inference_id = input;
            self
        }
        /// <p>The Amazon S3 URI where the inference request payload is stored.</p>
        pub fn input_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI where the inference request payload is stored.</p>
        pub fn set_input_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_location = input;
            self
        }
        /// <p>Maximum age in seconds a request can be in the queue before it is marked as expired.</p>
        pub fn request_ttl_seconds(mut self, input: i32) -> Self {
            self.request_ttl_seconds = Some(input);
            self
        }
        /// <p>Maximum age in seconds a request can be in the queue before it is marked as expired.</p>
        pub fn set_request_ttl_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.request_ttl_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeEndpointAsyncInput`](crate::input::InvokeEndpointAsyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InvokeEndpointAsyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InvokeEndpointAsyncInput {
                endpoint_name: self.endpoint_name,
                content_type: self.content_type,
                accept: self.accept,
                custom_attributes: self.custom_attributes,
                inference_id: self.inference_id,
                input_location: self.input_location,
                request_ttl_seconds: self.request_ttl_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeEndpointAsyncInputOperationOutputAlias = crate::operation::InvokeEndpointAsync;
#[doc(hidden)]
pub type InvokeEndpointAsyncInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InvokeEndpointAsyncInput {
    /// Consumes the builder and constructs an Operation<[`InvokeEndpointAsync`](crate::operation::InvokeEndpointAsync)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InvokeEndpointAsync,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InvokeEndpointAsyncInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.endpoint_name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "endpoint_name",
                        details: "cannot be empty or unset",
                    })?;
            let endpoint_name = aws_smithy_http::label::fmt_string(input_16, false);
            if endpoint_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "endpoint_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/endpoints/{EndpointName}/async-invocations",
                EndpointName = endpoint_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::InvokeEndpointAsyncInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_17) = &_input.content_type {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Content-Type", header_value);
                }
            }
            if let Some(inner_19) = &_input.accept {
                let formatted_20 = AsRef::<str>::as_ref(inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Accept", header_value);
                }
            }
            if let Some(inner_21) = &_input.custom_attributes {
                let formatted_22 = AsRef::<str>::as_ref(inner_21);
                if !formatted_22.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_22;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "custom_attributes",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Custom-Attributes", header_value);
                }
            }
            if let Some(inner_23) = &_input.inference_id {
                let formatted_24 = AsRef::<str>::as_ref(inner_23);
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "inference_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-Inference-Id", header_value);
                }
            }
            if let Some(inner_25) = &_input.input_location {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "input_location",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-InputLocation", header_value);
                }
            }
            if let Some(inner_27) = &_input.request_ttl_seconds {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(*inner_27);
                let formatted_28 = encoder.encode();
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_ttl_seconds",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-SageMaker-RequestTTLSeconds", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InvokeEndpointAsyncInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InvokeEndpointAsyncInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InvokeEndpointAsync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InvokeEndpointAsync",
            "sagemakerruntime",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InvokeEndpointAsyncInput`](crate::input::InvokeEndpointAsyncInput)
    pub fn builder() -> crate::input::invoke_endpoint_async_input::Builder {
        crate::input::invoke_endpoint_async_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeEndpointAsyncInput {
    /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html"> <code>CreateEndpoint</code> </a> API.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The MIME type of the input data in the request body.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The desired MIME type of the inference in the response.</p>
    pub accept: std::option::Option<std::string::String>,
    /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
    /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your post-processing function. </p>
    /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK. </p>
    pub custom_attributes: std::option::Option<std::string::String>,
    /// <p>The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified. </p>
    pub inference_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 URI where the inference request payload is stored.</p>
    pub input_location: std::option::Option<std::string::String>,
    /// <p>Maximum age in seconds a request can be in the queue before it is marked as expired.</p>
    pub request_ttl_seconds: std::option::Option<i32>,
}
impl InvokeEndpointAsyncInput {
    /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html"> <code>CreateEndpoint</code> </a> API.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The MIME type of the input data in the request body.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The desired MIME type of the inference in the response.</p>
    pub fn accept(&self) -> std::option::Option<&str> {
        self.accept.as_deref()
    }
    /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
    /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID</code>: in your post-processing function. </p>
    /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK. </p>
    pub fn custom_attributes(&self) -> std::option::Option<&str> {
        self.custom_attributes.as_deref()
    }
    /// <p>The identifier for the inference request. Amazon SageMaker will generate an identifier for you if none is specified. </p>
    pub fn inference_id(&self) -> std::option::Option<&str> {
        self.inference_id.as_deref()
    }
    /// <p>The Amazon S3 URI where the inference request payload is stored.</p>
    pub fn input_location(&self) -> std::option::Option<&str> {
        self.input_location.as_deref()
    }
    /// <p>Maximum age in seconds a request can be in the queue before it is marked as expired.</p>
    pub fn request_ttl_seconds(&self) -> std::option::Option<i32> {
        self.request_ttl_seconds
    }
}
impl std::fmt::Debug for InvokeEndpointAsyncInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeEndpointAsyncInput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("content_type", &self.content_type);
        formatter.field("accept", &self.accept);
        formatter.field("custom_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("inference_id", &self.inference_id);
        formatter.field("input_location", &self.input_location);
        formatter.field("request_ttl_seconds", &self.request_ttl_seconds);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeEndpointInput {
    /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API. </p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker passes all of the data in the body to the model. </p>
    /// <p>For information about the format of the request body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.</p>
    pub body: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The MIME type of the input data in the request body.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The desired MIME type of the inference in the response.</p>
    pub accept: std::option::Option<std::string::String>,
    /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
    /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your post-processing function.</p>
    /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.</p>
    pub custom_attributes: std::option::Option<std::string::String>,
    /// <p>The model to request for inference when invoking a multi-model endpoint.</p>
    pub target_model: std::option::Option<std::string::String>,
    /// <p>Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.</p>
    /// <p>For information about how to use variant targeting to perform a/b testing, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a> </p>
    pub target_variant: std::option::Option<std::string::String>,
    /// <p>If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.</p>
    pub target_container_hostname: std::option::Option<std::string::String>,
    /// <p>If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.</p>
    pub inference_id: std::option::Option<std::string::String>,
}
impl InvokeEndpointInput {
    /// <p>The name of the endpoint that you specified when you created the endpoint using the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API. </p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker passes all of the data in the body to the model. </p>
    /// <p>For information about the format of the request body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.</p>
    pub fn body(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.body.as_ref()
    }
    /// <p>The MIME type of the input data in the request body.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The desired MIME type of the inference in the response.</p>
    pub fn accept(&self) -> std::option::Option<&str> {
        self.accept.as_deref()
    }
    /// <p>Provides additional information about a request for an inference submitted to a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for example, to provide an ID that you can use to track a request or to provide other metadata that a service endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
    /// <p>The code in your model is responsible for setting or updating any custom attributes in the response. If your code does not set this value in the response, an empty value is returned. For example, if a custom attribute represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your post-processing function.</p>
    /// <p>This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.</p>
    pub fn custom_attributes(&self) -> std::option::Option<&str> {
        self.custom_attributes.as_deref()
    }
    /// <p>The model to request for inference when invoking a multi-model endpoint.</p>
    pub fn target_model(&self) -> std::option::Option<&str> {
        self.target_model.as_deref()
    }
    /// <p>Specify the production variant to send the inference request to when invoking an endpoint that is running two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute the invocation traffic based on the variant weights.</p>
    /// <p>For information about how to use variant targeting to perform a/b testing, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a> </p>
    pub fn target_variant(&self) -> std::option::Option<&str> {
        self.target_variant.as_deref()
    }
    /// <p>If the endpoint hosts multiple containers and is configured to use direct invocation, this parameter specifies the host name of the container to invoke.</p>
    pub fn target_container_hostname(&self) -> std::option::Option<&str> {
        self.target_container_hostname.as_deref()
    }
    /// <p>If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For information about data capture, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.</p>
    pub fn inference_id(&self) -> std::option::Option<&str> {
        self.inference_id.as_deref()
    }
}
impl std::fmt::Debug for InvokeEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeEndpointInput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("accept", &self.accept);
        formatter.field("custom_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("target_model", &self.target_model);
        formatter.field("target_variant", &self.target_variant);
        formatter.field("target_container_hostname", &self.target_container_hostname);
        formatter.field("inference_id", &self.inference_id);
        formatter.finish()
    }
}
