// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p> An internal failure occurred. </p>
    InternalFailure(crate::error::InternalFailure),
    /// <p> Model (owned by the customer in the container) returned 4xx or 5xx error code.
    /// </p>
    ModelError(crate::error::ModelError),
    /// <p> The service is unavailable. Try your call again. </p>
    ServiceUnavailable(crate::error::ServiceUnavailable),
    /// <p> Inspect your request and try again. </p>
    ValidationError(crate::error::ValidationError),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::InternalFailure(inner) => inner.fmt(f),
            Error::ModelError(inner) => inner.fmt(f),
            Error::ServiceUnavailable(inner) => inner.fmt(f),
            Error::ValidationError(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::InvokeEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::InvokeEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::InvokeEndpointErrorKind::InternalFailure(inner) => {
                    Error::InternalFailure(inner)
                }
                crate::error::InvokeEndpointErrorKind::ModelError(inner) => {
                    Error::ModelError(inner)
                }
                crate::error::InvokeEndpointErrorKind::ServiceUnavailable(inner) => {
                    Error::ServiceUnavailable(inner)
                }
                crate::error::InvokeEndpointErrorKind::ValidationError(inner) => {
                    Error::ValidationError(inner)
                }
                crate::error::InvokeEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::InvokeEndpointAsyncError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::InvokeEndpointAsyncError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::InvokeEndpointAsyncErrorKind::InternalFailure(inner) => {
                    Error::InternalFailure(inner)
                }
                crate::error::InvokeEndpointAsyncErrorKind::ServiceUnavailable(inner) => {
                    Error::ServiceUnavailable(inner)
                }
                crate::error::InvokeEndpointAsyncErrorKind::ValidationError(inner) => {
                    Error::ValidationError(inner)
                }
                crate::error::InvokeEndpointAsyncErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
