// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `InvokeEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invoke_endpoint`](crate::client::Client::invoke_endpoint).
///
/// See [`crate::client::fluent_builders::InvokeEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InvokeEndpoint {
    _private: (),
}
impl InvokeEndpoint {
    /// Creates a new builder-style object to manufacture [`InvokeEndpointInput`](crate::input::InvokeEndpointInput)
    pub fn builder() -> crate::input::invoke_endpoint_input::Builder {
        crate::input::invoke_endpoint_input::Builder::default()
    }
    /// Creates a new `InvokeEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InvokeEndpoint {
    type Output =
        std::result::Result<crate::output::InvokeEndpointOutput, crate::error::InvokeEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invoke_endpoint_error(response)
        } else {
            crate::operation_deser::parse_invoke_endpoint_response(response)
        }
    }
}

/// Operation shape for `InvokeEndpointAsync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invoke_endpoint_async`](crate::client::Client::invoke_endpoint_async).
///
/// See [`crate::client::fluent_builders::InvokeEndpointAsync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InvokeEndpointAsync {
    _private: (),
}
impl InvokeEndpointAsync {
    /// Creates a new builder-style object to manufacture [`InvokeEndpointAsyncInput`](crate::input::InvokeEndpointAsyncInput)
    pub fn builder() -> crate::input::invoke_endpoint_async_input::Builder {
        crate::input::invoke_endpoint_async_input::Builder::default()
    }
    /// Creates a new `InvokeEndpointAsync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InvokeEndpointAsync {
    type Output = std::result::Result<
        crate::output::InvokeEndpointAsyncOutput,
        crate::error::InvokeEndpointAsyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_invoke_endpoint_async_error(response)
        } else {
            crate::operation_deser::parse_invoke_endpoint_async_response(response)
        }
    }
}
