// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `GetDeviceRegistration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_registration`](crate::client::Client::get_device_registration).
///
/// See [`crate::client::fluent_builders::GetDeviceRegistration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceRegistration {
    _private: (),
}
impl GetDeviceRegistration {
    /// Creates a new builder-style object to manufacture [`GetDeviceRegistrationInput`](crate::input::GetDeviceRegistrationInput)
    pub fn builder() -> crate::input::get_device_registration_input::Builder {
        crate::input::get_device_registration_input::Builder::default()
    }
    /// Creates a new `GetDeviceRegistration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceRegistration {
    type Output = std::result::Result<
        crate::output::GetDeviceRegistrationOutput,
        crate::error::GetDeviceRegistrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_registration_error(response)
        } else {
            crate::operation_deser::parse_get_device_registration_response(response)
        }
    }
}

/// Operation shape for `SendHeartbeat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_heartbeat`](crate::client::Client::send_heartbeat).
///
/// See [`crate::client::fluent_builders::SendHeartbeat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendHeartbeat {
    _private: (),
}
impl SendHeartbeat {
    /// Creates a new builder-style object to manufacture [`SendHeartbeatInput`](crate::input::SendHeartbeatInput)
    pub fn builder() -> crate::input::send_heartbeat_input::Builder {
        crate::input::send_heartbeat_input::Builder::default()
    }
    /// Creates a new `SendHeartbeat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendHeartbeat {
    type Output =
        std::result::Result<crate::output::SendHeartbeatOutput, crate::error::SendHeartbeatError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_heartbeat_error(response)
        } else {
            crate::operation_deser::parse_send_heartbeat_response(response)
        }
    }
}
