// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonSageMakerEdge`.
///
/// This client allows ergonomic access to a `AmazonSageMakerEdge`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `GetDeviceRegistration` operation.
    ///
    /// See [`GetDeviceRegistration`](crate::client::fluent_builders::GetDeviceRegistration) for more information about the
    /// operation and its arguments.
    pub fn get_device_registration(&self) -> fluent_builders::GetDeviceRegistration<C, M, R> {
        fluent_builders::GetDeviceRegistration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendHeartbeat` operation.
    ///
    /// See [`SendHeartbeat`](crate::client::fluent_builders::SendHeartbeat) for more information about the
    /// operation and its arguments.
    pub fn send_heartbeat(&self) -> fluent_builders::SendHeartbeat<C, M, R> {
        fluent_builders::SendHeartbeat::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `GetDeviceRegistration`.
    ///
    /// <p>Use to check if a device is registered with SageMaker Edge Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeviceRegistration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_registration_input::Builder,
    }
    impl<C, M, R> GetDeviceRegistration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceRegistration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceRegistrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceRegistrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceRegistrationInputOperationOutputAlias,
                crate::output::GetDeviceRegistrationOutput,
                crate::error::GetDeviceRegistrationError,
                crate::input::GetDeviceRegistrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the device you want to get the registration status from.</p>
        pub fn device_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(inp);
            self
        }
        /// <p>The unique name of the device you want to get the registration status from.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn device_fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(inp);
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendHeartbeat`.
    ///
    /// <p>Use to get the current status of devices registered on SageMaker Edge Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendHeartbeat<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_heartbeat_input::Builder,
    }
    impl<C, M, R> SendHeartbeat<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::SendHeartbeatError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendHeartbeatInputOperationOutputAlias,
                crate::output::SendHeartbeatOutput,
                crate::error::SendHeartbeatError,
                crate::input::SendHeartbeatInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AgentMetrics`.
        ///
        /// To override the contents of this collection use [`set_agent_metrics`](Self::set_agent_metrics).
        ///
        /// <p>For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.</p>
        pub fn agent_metrics(mut self, inp: impl Into<crate::model::EdgeMetric>) -> Self {
            self.inner = self.inner.agent_metrics(inp);
            self
        }
        /// <p>For internal use. Returns a list of SageMaker Edge Manager agent operating metrics.</p>
        pub fn set_agent_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EdgeMetric>>,
        ) -> Self {
            self.inner = self.inner.set_agent_metrics(input);
            self
        }
        /// Appends an item to `Models`.
        ///
        /// To override the contents of this collection use [`set_models`](Self::set_models).
        ///
        /// <p>Returns a list of models deployed on the the device.</p>
        pub fn models(mut self, inp: impl Into<crate::model::Model>) -> Self {
            self.inner = self.inner.models(inp);
            self
        }
        /// <p>Returns a list of models deployed on the the device.</p>
        pub fn set_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Model>>,
        ) -> Self {
            self.inner = self.inner.set_models(input);
            self
        }
        /// <p>Returns the version of the agent.</p>
        pub fn agent_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_version(inp);
            self
        }
        /// <p>Returns the version of the agent.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agent_version(input);
            self
        }
        /// <p>The unique name of the device.</p>
        pub fn device_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(inp);
            self
        }
        /// <p>The unique name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn device_fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(inp);
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
