// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteHumanLoopInput`](crate::input::DeleteHumanLoopInput)
pub mod delete_human_loop_input {
    /// A builder for [`DeleteHumanLoopInput`](crate::input::DeleteHumanLoopInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the human loop that you want to delete.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human loop that you want to delete.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHumanLoopInput`](crate::input::DeleteHumanLoopInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHumanLoopInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHumanLoopInput {
                human_loop_name: self.human_loop_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHumanLoopInputOperationOutputAlias = crate::operation::DeleteHumanLoop;
#[doc(hidden)]
pub type DeleteHumanLoopInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHumanLoopInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHumanLoop`](crate::operation::DeleteHumanLoop)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHumanLoop,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHumanLoopInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.human_loop_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "human_loop_name",
                        details: "cannot be empty or unset",
                    })?;
            let human_loop_name = aws_smithy_http::label::fmt_string(input_1, false);
            if human_loop_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "human_loop_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/human-loops/{HumanLoopName}",
                HumanLoopName = human_loop_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHumanLoopInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHumanLoopInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHumanLoop::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHumanLoop",
            "sagemakera2iruntime",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHumanLoopInput`](crate::input::DeleteHumanLoopInput)
    pub fn builder() -> crate::input::delete_human_loop_input::Builder {
        crate::input::delete_human_loop_input::Builder::default()
    }
}

/// See [`DescribeHumanLoopInput`](crate::input::DescribeHumanLoopInput)
pub mod describe_human_loop_input {
    /// A builder for [`DescribeHumanLoopInput`](crate::input::DescribeHumanLoopInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the human loop that you want information about.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human loop that you want information about.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHumanLoopInput`](crate::input::DescribeHumanLoopInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHumanLoopInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHumanLoopInput {
                human_loop_name: self.human_loop_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHumanLoopInputOperationOutputAlias = crate::operation::DescribeHumanLoop;
#[doc(hidden)]
pub type DescribeHumanLoopInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHumanLoopInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHumanLoop`](crate::operation::DescribeHumanLoop)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHumanLoop,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHumanLoopInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.human_loop_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "human_loop_name",
                        details: "cannot be empty or unset",
                    })?;
            let human_loop_name = aws_smithy_http::label::fmt_string(input_2, false);
            if human_loop_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "human_loop_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/human-loops/{HumanLoopName}",
                HumanLoopName = human_loop_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHumanLoopInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHumanLoopInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHumanLoop::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHumanLoop",
            "sagemakera2iruntime",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHumanLoopInput`](crate::input::DescribeHumanLoopInput)
    pub fn builder() -> crate::input::describe_human_loop_input::Builder {
        crate::input::describe_human_loop_input::Builder::default()
    }
}

/// See [`ListHumanLoopsInput`](crate::input::ListHumanLoopsInput)
pub mod list_human_loops_input {
    /// A builder for [`ListHumanLoopsInput`](crate::input::ListHumanLoopsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creation_time_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) flow_definition_arn: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>(Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time_after = Some(input);
            self
        }
        /// <p>(Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time_after = input;
            self
        }
        /// <p>(Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time_before = Some(input);
            self
        }
        /// <p>(Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time_before = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a flow definition.</p>
        pub fn flow_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a flow definition.</p>
        pub fn set_flow_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_arn = input;
            self
        }
        /// <p>Optional. The order for displaying results. Valid values: <code>Ascending</code> and
        /// <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>Optional. The order for displaying results. Valid values: <code>Ascending</code> and
        /// <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>A token to display the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to display the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of items to return. If the total number of available items is more than
        /// the value specified in <code>MaxResults</code>, then a <code>NextToken</code> is returned in
        /// the output. You can use this token to display the next page of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of items to return. If the total number of available items is more than
        /// the value specified in <code>MaxResults</code>, then a <code>NextToken</code> is returned in
        /// the output. You can use this token to display the next page of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHumanLoopsInput`](crate::input::ListHumanLoopsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHumanLoopsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHumanLoopsInput {
                creation_time_after: self.creation_time_after,
                creation_time_before: self.creation_time_before,
                flow_definition_arn: self.flow_definition_arn,
                sort_order: self.sort_order,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHumanLoopsInputOperationOutputAlias = crate::operation::ListHumanLoops;
#[doc(hidden)]
pub type ListHumanLoopsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHumanLoopsInput {
    /// Consumes the builder and constructs an Operation<[`ListHumanLoops`](crate::operation::ListHumanLoops)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHumanLoops,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHumanLoopsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/human-loops").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListHumanLoopsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.creation_time_after {
                query.push_kv(
                    "CreationTimeAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_3,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_4) = &_input.creation_time_before {
                query.push_kv(
                    "CreationTimeBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_4,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_5) = &_input.flow_definition_arn {
                query.push_kv(
                    "FlowDefinitionArn",
                    &aws_smithy_http::query::fmt_string(&inner_5),
                );
            }
            if let Some(inner_6) = &_input.sort_order {
                query.push_kv("SortOrder", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            if let Some(inner_8) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_8).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHumanLoopsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHumanLoopsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHumanLoops::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHumanLoops",
            "sagemakera2iruntime",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHumanLoopsInput`](crate::input::ListHumanLoopsInput)
    pub fn builder() -> crate::input::list_human_loops_input::Builder {
        crate::input::list_human_loops_input::Builder::default()
    }
}

/// See [`StartHumanLoopInput`](crate::input::StartHumanLoopInput)
pub mod start_human_loop_input {
    /// A builder for [`StartHumanLoopInput`](crate::input::StartHumanLoopInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
        pub(crate) flow_definition_arn: std::option::Option<std::string::String>,
        pub(crate) human_loop_input: std::option::Option<crate::model::HumanLoopInput>,
        pub(crate) data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
    }
    impl Builder {
        /// <p>The name of the human loop.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human loop.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition associated with this human
        /// loop.</p>
        pub fn flow_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition associated with this human
        /// loop.</p>
        pub fn set_flow_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_arn = input;
            self
        }
        /// <p>An object that contains information about the human loop.</p>
        pub fn human_loop_input(mut self, input: crate::model::HumanLoopInput) -> Self {
            self.human_loop_input = Some(input);
            self
        }
        /// <p>An object that contains information about the human loop.</p>
        pub fn set_human_loop_input(
            mut self,
            input: std::option::Option<crate::model::HumanLoopInput>,
        ) -> Self {
            self.human_loop_input = input;
            self
        }
        /// <p>Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data
        /// is free of personally identifiable information and/or free of adult content.</p>
        pub fn data_attributes(mut self, input: crate::model::HumanLoopDataAttributes) -> Self {
            self.data_attributes = Some(input);
            self
        }
        /// <p>Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data
        /// is free of personally identifiable information and/or free of adult content.</p>
        pub fn set_data_attributes(
            mut self,
            input: std::option::Option<crate::model::HumanLoopDataAttributes>,
        ) -> Self {
            self.data_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`StartHumanLoopInput`](crate::input::StartHumanLoopInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartHumanLoopInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartHumanLoopInput {
                human_loop_name: self.human_loop_name,
                flow_definition_arn: self.flow_definition_arn,
                human_loop_input: self.human_loop_input,
                data_attributes: self.data_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type StartHumanLoopInputOperationOutputAlias = crate::operation::StartHumanLoop;
#[doc(hidden)]
pub type StartHumanLoopInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartHumanLoopInput {
    /// Consumes the builder and constructs an Operation<[`StartHumanLoop`](crate::operation::StartHumanLoop)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartHumanLoop,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartHumanLoopInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/human-loops").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartHumanLoopInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartHumanLoopInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_human_loop(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartHumanLoop::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartHumanLoop",
            "sagemakera2iruntime",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartHumanLoopInput`](crate::input::StartHumanLoopInput)
    pub fn builder() -> crate::input::start_human_loop_input::Builder {
        crate::input::start_human_loop_input::Builder::default()
    }
}

/// See [`StopHumanLoopInput`](crate::input::StopHumanLoopInput)
pub mod stop_human_loop_input {
    /// A builder for [`StopHumanLoopInput`](crate::input::StopHumanLoopInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the human loop that you want to stop.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human loop that you want to stop.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopHumanLoopInput`](crate::input::StopHumanLoopInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopHumanLoopInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopHumanLoopInput {
                human_loop_name: self.human_loop_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StopHumanLoopInputOperationOutputAlias = crate::operation::StopHumanLoop;
#[doc(hidden)]
pub type StopHumanLoopInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopHumanLoopInput {
    /// Consumes the builder and constructs an Operation<[`StopHumanLoop`](crate::operation::StopHumanLoop)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopHumanLoop,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopHumanLoopInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/human-loops/stop").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopHumanLoopInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopHumanLoopInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_human_loop(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopHumanLoop::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopHumanLoop",
            "sagemakera2iruntime",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopHumanLoopInput`](crate::input::StopHumanLoopInput)
    pub fn builder() -> crate::input::stop_human_loop_input::Builder {
        crate::input::stop_human_loop_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopHumanLoopInput {
    /// <p>The name of the human loop that you want to stop.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopHumanLoopInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopHumanLoopInput");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartHumanLoopInput {
    /// <p>The name of the human loop.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the flow definition associated with this human
    /// loop.</p>
    pub flow_definition_arn: std::option::Option<std::string::String>,
    /// <p>An object that contains information about the human loop.</p>
    pub human_loop_input: std::option::Option<crate::model::HumanLoopInput>,
    /// <p>Attributes of the specified data. Use <code>DataAttributes</code> to specify if your data
    /// is free of personally identifiable information and/or free of adult content.</p>
    pub data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
}
impl std::fmt::Debug for StartHumanLoopInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartHumanLoopInput");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.field("flow_definition_arn", &self.flow_definition_arn);
        formatter.field("human_loop_input", &self.human_loop_input);
        formatter.field("data_attributes", &self.data_attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHumanLoopsInput {
    /// <p>(Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
    pub creation_time_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>(Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For example, <code>2020-02-24</code>.</p>
    pub creation_time_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of a flow definition.</p>
    pub flow_definition_arn: std::option::Option<std::string::String>,
    /// <p>Optional. The order for displaying results. Valid values: <code>Ascending</code> and
    /// <code>Descending</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>A token to display the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of items to return. If the total number of available items is more than
    /// the value specified in <code>MaxResults</code>, then a <code>NextToken</code> is returned in
    /// the output. You can use this token to display the next page of results. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListHumanLoopsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHumanLoopsInput");
        formatter.field("creation_time_after", &self.creation_time_after);
        formatter.field("creation_time_before", &self.creation_time_before);
        formatter.field("flow_definition_arn", &self.flow_definition_arn);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHumanLoopInput {
    /// <p>The name of the human loop that you want information about.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeHumanLoopInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHumanLoopInput");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHumanLoopInput {
    /// <p>The name of the human loop that you want to delete.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteHumanLoopInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHumanLoopInput");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.finish()
    }
}
