// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_association_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddAssociationOutput, crate::error::AddAssociationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddAssociationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddAssociationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::AddAssociationError {
            meta: generic,
            kind: crate::error::AddAssociationErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::AddAssociationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::AddAssociationError {
                meta: generic,
                kind: crate::error::AddAssociationErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::AddAssociationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AddAssociationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_association_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddAssociationOutput, crate::error::AddAssociationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_association_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_association(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddAssociationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    Err(crate::error::AddTagsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTrialComponentOutput,
    crate::error::AssociateTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateTrialComponentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::AssociateTrialComponentError {
            meta: generic,
            kind: crate::error::AssociateTrialComponentErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrialComponentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::AssociateTrialComponentError {
                meta: generic,
                kind: crate::error::AssociateTrialComponentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AssociateTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateTrialComponentOutput,
    crate::error::AssociateTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_describe_model_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDescribeModelPackageOutput,
    crate::error::BatchDescribeModelPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDescribeModelPackageError::unhandled)?;
    Err(crate::error::BatchDescribeModelPackageError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_describe_model_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDescribeModelPackageOutput,
    crate::error::BatchDescribeModelPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_describe_model_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_describe_model_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDescribeModelPackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateActionOutput, crate::error::CreateActionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateActionError {
            meta: generic,
            kind: crate::error::CreateActionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateActionOutput, crate::error::CreateActionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_algorithm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAlgorithmOutput, crate::error::CreateAlgorithmError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAlgorithmError::unhandled)?;
    Err(crate::error::CreateAlgorithmError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_algorithm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAlgorithmOutput, crate::error::CreateAlgorithmError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_algorithm_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_algorithm(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAlgorithmError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateAppError {
                meta: generic,
                kind: crate::error::CreateAppErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_app_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_app(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAppError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_image_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAppImageConfigOutput,
    crate::error::CreateAppImageConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAppImageConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAppImageConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateAppImageConfigError {
                meta: generic,
                kind: crate::error::CreateAppImageConfigErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppImageConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateAppImageConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_image_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAppImageConfigOutput,
    crate::error::CreateAppImageConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_app_image_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_app_image_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAppImageConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateArtifactOutput, crate::error::CreateArtifactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateArtifactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateArtifactError {
            meta: generic,
            kind: crate::error::CreateArtifactErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateArtifactError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateArtifactOutput, crate::error::CreateArtifactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_auto_ml_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAutoMlJobOutput, crate::error::CreateAutoMLJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAutoMLJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAutoMLJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateAutoMLJobError {
                meta: generic,
                kind: crate::error::CreateAutoMLJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoMLJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateAutoMLJobError {
            meta: generic,
            kind: crate::error::CreateAutoMLJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAutoMLJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAutoMLJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_auto_ml_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAutoMlJobOutput, crate::error::CreateAutoMLJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_auto_ml_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_auto_ml_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAutoMLJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_code_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCodeRepositoryOutput,
    crate::error::CreateCodeRepositoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCodeRepositoryError::unhandled)?;
    Err(crate::error::CreateCodeRepositoryError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_code_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCodeRepositoryOutput,
    crate::error::CreateCodeRepositoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_code_repository_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_code_repository(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCodeRepositoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_compilation_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCompilationJobOutput,
    crate::error::CreateCompilationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCompilationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCompilationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateCompilationJobError {
                meta: generic,
                kind: crate::error::CreateCompilationJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCompilationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateCompilationJobError {
            meta: generic,
            kind: crate::error::CreateCompilationJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCompilationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCompilationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_compilation_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCompilationJobOutput,
    crate::error::CreateCompilationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_compilation_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_compilation_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCompilationJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_context_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateContextOutput, crate::error::CreateContextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateContextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateContextError {
            meta: generic,
            kind: crate::error::CreateContextErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateContextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_context_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateContextOutput, crate::error::CreateContextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_context_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_context(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateContextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataQualityJobDefinitionOutput,
    crate::error::CreateDataQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDataQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDataQualityJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateDataQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::CreateDataQualityJobDefinitionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateDataQualityJobDefinitionError {
            meta: generic,
            kind: crate::error::CreateDataQualityJobDefinitionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataQualityJobDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDataQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataQualityJobDefinitionOutput,
    crate::error::CreateDataQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_data_quality_job_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_data_quality_job_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateDataQualityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_device_fleet_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDeviceFleetOutput, crate::error::CreateDeviceFleetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDeviceFleetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDeviceFleetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateDeviceFleetError {
                meta: generic,
                kind: crate::error::CreateDeviceFleetErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeviceFleetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateDeviceFleetError {
            meta: generic,
            kind: crate::error::CreateDeviceFleetErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDeviceFleetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDeviceFleetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_device_fleet_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDeviceFleetOutput, crate::error::CreateDeviceFleetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_device_fleet_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateDomainError {
                meta: generic,
                kind: crate::error::CreateDomainErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_edge_packaging_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEdgePackagingJobOutput,
    crate::error::CreateEdgePackagingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEdgePackagingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEdgePackagingJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateEdgePackagingJobError {
            meta: generic,
            kind: crate::error::CreateEdgePackagingJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEdgePackagingJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEdgePackagingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_edge_packaging_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEdgePackagingJobOutput,
    crate::error::CreateEdgePackagingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_edge_packaging_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointConfigOutput,
    crate::error::CreateEndpointConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateEndpointConfigError {
            meta: generic,
            kind: crate::error::CreateEndpointConfigErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEndpointConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointConfigOutput,
    crate::error::CreateEndpointConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_endpoint_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_experiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateExperimentOutput, crate::error::CreateExperimentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateExperimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateExperimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateExperimentError {
            meta: generic,
            kind: crate::error::CreateExperimentErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateExperimentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateExperimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_experiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateExperimentOutput, crate::error::CreateExperimentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_experiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_experiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateExperimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_feature_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFeatureGroupOutput,
    crate::error::CreateFeatureGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFeatureGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFeatureGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateFeatureGroupError {
                meta: generic,
                kind: crate::error::CreateFeatureGroupErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFeatureGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateFeatureGroupError {
            meta: generic,
            kind: crate::error::CreateFeatureGroupErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFeatureGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFeatureGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_feature_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFeatureGroupOutput,
    crate::error::CreateFeatureGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_feature_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_feature_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFeatureGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_flow_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFlowDefinitionOutput,
    crate::error::CreateFlowDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFlowDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFlowDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateFlowDefinitionError {
                meta: generic,
                kind: crate::error::CreateFlowDefinitionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFlowDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateFlowDefinitionError {
            meta: generic,
            kind: crate::error::CreateFlowDefinitionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFlowDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFlowDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_flow_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFlowDefinitionOutput,
    crate::error::CreateFlowDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_flow_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_flow_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFlowDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_human_task_ui_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHumanTaskUiOutput, crate::error::CreateHumanTaskUiError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHumanTaskUiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateHumanTaskUiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateHumanTaskUiError {
                meta: generic,
                kind: crate::error::CreateHumanTaskUiErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHumanTaskUiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateHumanTaskUiError {
            meta: generic,
            kind: crate::error::CreateHumanTaskUiErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHumanTaskUiError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHumanTaskUiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_human_task_ui_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateHumanTaskUiOutput, crate::error::CreateHumanTaskUiError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_human_task_ui_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_human_task_ui(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHumanTaskUiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hyper_parameter_tuning_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHyperParameterTuningJobOutput,
    crate::error::CreateHyperParameterTuningJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHyperParameterTuningJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateHyperParameterTuningJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateHyperParameterTuningJobError {
                meta: generic,
                kind: crate::error::CreateHyperParameterTuningJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHyperParameterTuningJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateHyperParameterTuningJobError {
            meta: generic,
            kind: crate::error::CreateHyperParameterTuningJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateHyperParameterTuningJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHyperParameterTuningJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hyper_parameter_tuning_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHyperParameterTuningJobOutput,
    crate::error::CreateHyperParameterTuningJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_hyper_parameter_tuning_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_hyper_parameter_tuning_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateHyperParameterTuningJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateImageOutput, crate::error::CreateImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateImageError {
                meta: generic,
                kind: crate::error::CreateImageErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateImageError {
            meta: generic,
            kind: crate::error::CreateImageErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateImageOutput, crate::error::CreateImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_image_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateImageVersionOutput,
    crate::error::CreateImageVersionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateImageVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateImageVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateImageVersionError {
                meta: generic,
                kind: crate::error::CreateImageVersionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateImageVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateImageVersionError {
            meta: generic,
            kind: crate::error::CreateImageVersionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateImageVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreateImageVersionError {
                meta: generic,
                kind: crate::error::CreateImageVersionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateImageVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateImageVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_image_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateImageVersionOutput,
    crate::error::CreateImageVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_image_version_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_image_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateImageVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_inference_recommendations_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInferenceRecommendationsJobOutput,
    crate::error::CreateInferenceRecommendationsJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInferenceRecommendationsJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateInferenceRecommendationsJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateInferenceRecommendationsJobError {
                meta: generic,
                kind: crate::error::CreateInferenceRecommendationsJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInferenceRecommendationsJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateInferenceRecommendationsJobError {
            meta: generic,
            kind: crate::error::CreateInferenceRecommendationsJobErrorKind::ResourceLimitExceeded(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_limit_exceeded::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInferenceRecommendationsJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateInferenceRecommendationsJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_inference_recommendations_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInferenceRecommendationsJobOutput,
    crate::error::CreateInferenceRecommendationsJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_inference_recommendations_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_inference_recommendations_job(response.body().as_ref(), output).map_err(crate::error::CreateInferenceRecommendationsJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_labeling_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLabelingJobOutput, crate::error::CreateLabelingJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLabelingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLabelingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateLabelingJobError {
                meta: generic,
                kind: crate::error::CreateLabelingJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLabelingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateLabelingJobError {
            meta: generic,
            kind: crate::error::CreateLabelingJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLabelingJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLabelingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_labeling_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLabelingJobOutput, crate::error::CreateLabelingJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_labeling_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_labeling_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLabelingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateModelError {
            meta: generic,
            kind: crate::error::CreateModelErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_bias_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelBiasJobDefinitionOutput,
    crate::error::CreateModelBiasJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelBiasJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateModelBiasJobDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateModelBiasJobDefinitionError {
                meta: generic,
                kind: crate::error::CreateModelBiasJobDefinitionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelBiasJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateModelBiasJobDefinitionError {
            meta: generic,
            kind: crate::error::CreateModelBiasJobDefinitionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelBiasJobDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelBiasJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_bias_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelBiasJobDefinitionOutput,
    crate::error::CreateModelBiasJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_model_bias_job_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_model_bias_job_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateModelBiasJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_explainability_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelExplainabilityJobDefinitionOutput,
    crate::error::CreateModelExplainabilityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelExplainabilityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateModelExplainabilityJobDefinitionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateModelExplainabilityJobDefinitionError {
                meta: generic,
                kind: crate::error::CreateModelExplainabilityJobDefinitionErrorKind::ResourceInUse(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::resource_in_use::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelExplainabilityJobDefinitionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateModelExplainabilityJobDefinitionError {
            meta: generic,
            kind:
                crate::error::CreateModelExplainabilityJobDefinitionErrorKind::ResourceLimitExceeded(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_limit_exceeded::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelExplainabilityJobDefinitionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateModelExplainabilityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_explainability_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelExplainabilityJobDefinitionOutput,
    crate::error::CreateModelExplainabilityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_model_explainability_job_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_model_explainability_job_definition(response.body().as_ref(), output).map_err(crate::error::CreateModelExplainabilityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelPackageOutput,
    crate::error::CreateModelPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelPackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateModelPackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::CreateModelPackageError {
                meta: generic,
                kind: crate::error::CreateModelPackageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelPackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateModelPackageError {
            meta: generic,
            kind: crate::error::CreateModelPackageErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelPackageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelPackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelPackageOutput,
    crate::error::CreateModelPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_model_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_model_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateModelPackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_package_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelPackageGroupOutput,
    crate::error::CreateModelPackageGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelPackageGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateModelPackageGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateModelPackageGroupError {
            meta: generic,
            kind: crate::error::CreateModelPackageGroupErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelPackageGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelPackageGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_package_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelPackageGroupOutput,
    crate::error::CreateModelPackageGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_model_package_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_model_package_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateModelPackageGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelQualityJobDefinitionOutput,
    crate::error::CreateModelQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateModelQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateModelQualityJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateModelQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::CreateModelQualityJobDefinitionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateModelQualityJobDefinitionError {
            meta: generic,
            kind: crate::error::CreateModelQualityJobDefinitionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateModelQualityJobDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateModelQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_model_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateModelQualityJobDefinitionOutput,
    crate::error::CreateModelQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_model_quality_job_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_model_quality_job_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateModelQualityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMonitoringScheduleOutput,
    crate::error::CreateMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateMonitoringScheduleError {
                meta: generic,
                kind: crate::error::CreateMonitoringScheduleErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateMonitoringScheduleError {
            meta: generic,
            kind: crate::error::CreateMonitoringScheduleErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMonitoringScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMonitoringScheduleOutput,
    crate::error::CreateMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_monitoring_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_monitoring_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateMonitoringScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotebookInstanceOutput,
    crate::error::CreateNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNotebookInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateNotebookInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateNotebookInstanceError {
            meta: generic,
            kind: crate::error::CreateNotebookInstanceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotebookInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateNotebookInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotebookInstanceOutput,
    crate::error::CreateNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_notebook_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_notebook_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateNotebookInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notebook_instance_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotebookInstanceLifecycleConfigOutput,
    crate::error::CreateNotebookInstanceLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateNotebookInstanceLifecycleConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateNotebookInstanceLifecycleConfigError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateNotebookInstanceLifecycleConfigError {
            meta: generic,
            kind:
                crate::error::CreateNotebookInstanceLifecycleConfigErrorKind::ResourceLimitExceeded(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_limit_exceeded::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateNotebookInstanceLifecycleConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateNotebookInstanceLifecycleConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_notebook_instance_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateNotebookInstanceLifecycleConfigOutput,
    crate::error::CreateNotebookInstanceLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_notebook_instance_lifecycle_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_notebook_instance_lifecycle_config(response.body().as_ref(), output).map_err(crate::error::CreateNotebookInstanceLifecycleConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreatePipelineError {
                meta: generic,
                kind: crate::error::CreatePipelineErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_presigned_domain_url_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePresignedDomainUrlOutput,
    crate::error::CreatePresignedDomainUrlError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePresignedDomainUrlError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePresignedDomainUrlError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::CreatePresignedDomainUrlError {
                meta: generic,
                kind: crate::error::CreatePresignedDomainUrlErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePresignedDomainUrlError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreatePresignedDomainUrlError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_presigned_domain_url_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePresignedDomainUrlOutput,
    crate::error::CreatePresignedDomainUrlError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_presigned_domain_url_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_presigned_domain_url(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePresignedDomainUrlError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_presigned_notebook_instance_url_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePresignedNotebookInstanceUrlOutput,
    crate::error::CreatePresignedNotebookInstanceUrlError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePresignedNotebookInstanceUrlError::unhandled)?;
    Err(crate::error::CreatePresignedNotebookInstanceUrlError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_presigned_notebook_instance_url_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePresignedNotebookInstanceUrlOutput,
    crate::error::CreatePresignedNotebookInstanceUrlError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_presigned_notebook_instance_url_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_presigned_notebook_instance_url(response.body().as_ref(), output).map_err(crate::error::CreatePresignedNotebookInstanceUrlError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_processing_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProcessingJobOutput,
    crate::error::CreateProcessingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProcessingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateProcessingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateProcessingJobError {
                meta: generic,
                kind: crate::error::CreateProcessingJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProcessingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateProcessingJobError {
            meta: generic,
            kind: crate::error::CreateProcessingJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProcessingJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreateProcessingJobError {
                meta: generic,
                kind: crate::error::CreateProcessingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProcessingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateProcessingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_processing_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateProcessingJobOutput,
    crate::error::CreateProcessingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_processing_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_processing_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProcessingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateProjectError {
            meta: generic,
            kind: crate::error::CreateProjectErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateProjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_studio_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStudioLifecycleConfigOutput,
    crate::error::CreateStudioLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStudioLifecycleConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateStudioLifecycleConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateStudioLifecycleConfigError {
                meta: generic,
                kind: crate::error::CreateStudioLifecycleConfigErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStudioLifecycleConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateStudioLifecycleConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_studio_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStudioLifecycleConfigOutput,
    crate::error::CreateStudioLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_studio_lifecycle_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_studio_lifecycle_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStudioLifecycleConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_training_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrainingJobOutput, crate::error::CreateTrainingJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrainingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrainingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateTrainingJobError {
                meta: generic,
                kind: crate::error::CreateTrainingJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrainingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateTrainingJobError {
            meta: generic,
            kind: crate::error::CreateTrainingJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrainingJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreateTrainingJobError {
                meta: generic,
                kind: crate::error::CreateTrainingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrainingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateTrainingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_training_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrainingJobOutput, crate::error::CreateTrainingJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_training_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_training_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrainingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_transform_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTransformJobOutput,
    crate::error::CreateTransformJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTransformJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTransformJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateTransformJobError {
                meta: generic,
                kind: crate::error::CreateTransformJobErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTransformJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateTransformJobError {
            meta: generic,
            kind: crate::error::CreateTransformJobErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTransformJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreateTransformJobError {
                meta: generic,
                kind: crate::error::CreateTransformJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTransformJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateTransformJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_transform_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTransformJobOutput,
    crate::error::CreateTransformJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_transform_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_transform_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTransformJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trial_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrialOutput, crate::error::CreateTrialError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateTrialError {
            meta: generic,
            kind: crate::error::CreateTrialErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::CreateTrialError {
                meta: generic,
                kind: crate::error::CreateTrialErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateTrialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trial_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrialOutput, crate::error::CreateTrialError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_trial_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_trial(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTrialComponentOutput,
    crate::error::CreateTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrialComponentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::CreateTrialComponentError {
            meta: generic,
            kind: crate::error::CreateTrialComponentErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrialComponentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateTrialComponentOutput,
    crate::error::CreateTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserProfileOutput, crate::error::CreateUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateUserProfileError {
                meta: generic,
                kind: crate::error::CreateUserProfileErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateUserProfileError {
            meta: generic,
            kind: crate::error::CreateUserProfileErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserProfileOutput, crate::error::CreateUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workforce_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkforceOutput, crate::error::CreateWorkforceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWorkforceError::unhandled)?;
    Err(crate::error::CreateWorkforceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workforce_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkforceOutput, crate::error::CreateWorkforceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_workforce_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_workforce(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWorkforceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkteamOutput, crate::error::CreateWorkteamError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWorkteamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWorkteamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::CreateWorkteamError {
                meta: generic,
                kind: crate::error::CreateWorkteamErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkteamError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::CreateWorkteamError {
            meta: generic,
            kind: crate::error::CreateWorkteamErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWorkteamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWorkteamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWorkteamOutput, crate::error::CreateWorkteamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_workteam_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_workteam(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWorkteamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteActionOutput, crate::error::DeleteActionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteActionError {
                meta: generic,
                kind: crate::error::DeleteActionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteActionOutput, crate::error::DeleteActionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_algorithm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlgorithmOutput, crate::error::DeleteAlgorithmError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAlgorithmError::unhandled)?;
    Err(crate::error::DeleteAlgorithmError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_algorithm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlgorithmOutput, crate::error::DeleteAlgorithmError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_algorithm_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteAppError {
                meta: generic,
                kind: crate::error::DeleteAppErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteAppError {
                meta: generic,
                kind: crate::error::DeleteAppErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_app_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_image_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppImageConfigOutput,
    crate::error::DeleteAppImageConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppImageConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAppImageConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteAppImageConfigError {
                meta: generic,
                kind: crate::error::DeleteAppImageConfigErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppImageConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAppImageConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_image_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppImageConfigOutput,
    crate::error::DeleteAppImageConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_app_image_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteArtifactOutput, crate::error::DeleteArtifactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteArtifactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteArtifactError {
                meta: generic,
                kind: crate::error::DeleteArtifactErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteArtifactError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteArtifactOutput, crate::error::DeleteArtifactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_association_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAssociationOutput, crate::error::DeleteAssociationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAssociationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAssociationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteAssociationError {
                meta: generic,
                kind: crate::error::DeleteAssociationErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAssociationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAssociationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_association_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAssociationOutput, crate::error::DeleteAssociationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_association_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_association(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAssociationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_code_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCodeRepositoryOutput,
    crate::error::DeleteCodeRepositoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCodeRepositoryError::unhandled)?;
    Err(crate::error::DeleteCodeRepositoryError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_code_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCodeRepositoryOutput,
    crate::error::DeleteCodeRepositoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_code_repository_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_context_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteContextOutput, crate::error::DeleteContextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteContextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteContextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteContextError {
                meta: generic,
                kind: crate::error::DeleteContextErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteContextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_context_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteContextOutput, crate::error::DeleteContextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_context_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_context(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteContextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_data_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDataQualityJobDefinitionOutput,
    crate::error::DeleteDataQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDataQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDataQualityJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteDataQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::DeleteDataQualityJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDataQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDataQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_data_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDataQualityJobDefinitionOutput,
    crate::error::DeleteDataQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_data_quality_job_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_fleet_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeviceFleetOutput, crate::error::DeleteDeviceFleetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDeviceFleetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDeviceFleetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteDeviceFleetError {
                meta: generic,
                kind: crate::error::DeleteDeviceFleetErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDeviceFleetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDeviceFleetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_device_fleet_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDeviceFleetOutput, crate::error::DeleteDeviceFleetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_device_fleet_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteDomainError {
                meta: generic,
                kind: crate::error::DeleteDomainErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteDomainError {
                meta: generic,
                kind: crate::error::DeleteDomainErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointError::unhandled)?;
    Err(crate::error::DeleteEndpointError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointConfigOutput,
    crate::error::DeleteEndpointConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointConfigError::unhandled)?;
    Err(crate::error::DeleteEndpointConfigError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointConfigOutput,
    crate::error::DeleteEndpointConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_experiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteExperimentOutput, crate::error::DeleteExperimentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteExperimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteExperimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteExperimentError {
                meta: generic,
                kind: crate::error::DeleteExperimentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteExperimentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteExperimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_experiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteExperimentOutput, crate::error::DeleteExperimentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_experiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_experiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteExperimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_feature_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFeatureGroupOutput,
    crate::error::DeleteFeatureGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFeatureGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFeatureGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteFeatureGroupError {
                meta: generic,
                kind: crate::error::DeleteFeatureGroupErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFeatureGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteFeatureGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_feature_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFeatureGroupOutput,
    crate::error::DeleteFeatureGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_feature_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_flow_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFlowDefinitionOutput,
    crate::error::DeleteFlowDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFlowDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFlowDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteFlowDefinitionError {
                meta: generic,
                kind: crate::error::DeleteFlowDefinitionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFlowDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteFlowDefinitionError {
                meta: generic,
                kind: crate::error::DeleteFlowDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFlowDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteFlowDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_flow_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFlowDefinitionOutput,
    crate::error::DeleteFlowDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_flow_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_human_task_ui_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteHumanTaskUiOutput, crate::error::DeleteHumanTaskUiError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteHumanTaskUiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteHumanTaskUiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteHumanTaskUiError {
                meta: generic,
                kind: crate::error::DeleteHumanTaskUiErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteHumanTaskUiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteHumanTaskUiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_human_task_ui_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteHumanTaskUiOutput, crate::error::DeleteHumanTaskUiError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_human_task_ui_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteImageOutput, crate::error::DeleteImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteImageError {
                meta: generic,
                kind: crate::error::DeleteImageErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteImageError {
                meta: generic,
                kind: crate::error::DeleteImageErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteImageOutput, crate::error::DeleteImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_image_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_image_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteImageVersionOutput,
    crate::error::DeleteImageVersionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteImageVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteImageVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteImageVersionError {
                meta: generic,
                kind: crate::error::DeleteImageVersionErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImageVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteImageVersionError {
                meta: generic,
                kind: crate::error::DeleteImageVersionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImageVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteImageVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_image_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteImageVersionOutput,
    crate::error::DeleteImageVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_image_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelError::unhandled)?;
    Err(crate::error::DeleteModelError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_model_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_bias_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelBiasJobDefinitionOutput,
    crate::error::DeleteModelBiasJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelBiasJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteModelBiasJobDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteModelBiasJobDefinitionError {
                meta: generic,
                kind: crate::error::DeleteModelBiasJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelBiasJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteModelBiasJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_bias_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelBiasJobDefinitionOutput,
    crate::error::DeleteModelBiasJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_model_bias_job_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_explainability_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelExplainabilityJobDefinitionOutput,
    crate::error::DeleteModelExplainabilityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelExplainabilityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DeleteModelExplainabilityJobDefinitionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::DeleteModelExplainabilityJobDefinitionError {
            meta: generic,
            kind: crate::error::DeleteModelExplainabilityJobDefinitionErrorKind::ResourceNotFound(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelExplainabilityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteModelExplainabilityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_explainability_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelExplainabilityJobDefinitionOutput,
    crate::error::DeleteModelExplainabilityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_model_explainability_job_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageOutput,
    crate::error::DeleteModelPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelPackageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteModelPackageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::DeleteModelPackageError {
                meta: generic,
                kind: crate::error::DeleteModelPackageErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelPackageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteModelPackageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageOutput,
    crate::error::DeleteModelPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_model_package_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageGroupOutput,
    crate::error::DeleteModelPackageGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelPackageGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteModelPackageGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::DeleteModelPackageGroupError {
                meta: generic,
                kind: crate::error::DeleteModelPackageGroupErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelPackageGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteModelPackageGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageGroupOutput,
    crate::error::DeleteModelPackageGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_model_package_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageGroupPolicyOutput,
    crate::error::DeleteModelPackageGroupPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelPackageGroupPolicyError::unhandled)?;
    Err(crate::error::DeleteModelPackageGroupPolicyError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_package_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelPackageGroupPolicyOutput,
    crate::error::DeleteModelPackageGroupPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_model_package_group_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelQualityJobDefinitionOutput,
    crate::error::DeleteModelQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteModelQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteModelQualityJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteModelQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::DeleteModelQualityJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteModelQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteModelQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_model_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteModelQualityJobDefinitionOutput,
    crate::error::DeleteModelQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_model_quality_job_definition_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMonitoringScheduleOutput,
    crate::error::DeleteMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteMonitoringScheduleError {
                meta: generic,
                kind: crate::error::DeleteMonitoringScheduleErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMonitoringScheduleOutput,
    crate::error::DeleteMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_monitoring_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotebookInstanceOutput,
    crate::error::DeleteNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNotebookInstanceError::unhandled)?;
    Err(crate::error::DeleteNotebookInstanceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotebookInstanceOutput,
    crate::error::DeleteNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_notebook_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notebook_instance_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotebookInstanceLifecycleConfigOutput,
    crate::error::DeleteNotebookInstanceLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteNotebookInstanceLifecycleConfigError::unhandled)?;
    Err(crate::error::DeleteNotebookInstanceLifecycleConfigError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_notebook_instance_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteNotebookInstanceLifecycleConfigOutput,
    crate::error::DeleteNotebookInstanceLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_notebook_instance_lifecycle_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeletePipelineError {
                meta: generic,
                kind: crate::error::DeletePipelineErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeletePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteProjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::DeleteProjectError {
                meta: generic,
                kind: crate::error::DeleteProjectErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProjectError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteProjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_project_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_studio_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStudioLifecycleConfigOutput,
    crate::error::DeleteStudioLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStudioLifecycleConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteStudioLifecycleConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteStudioLifecycleConfigError {
                meta: generic,
                kind: crate::error::DeleteStudioLifecycleConfigErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStudioLifecycleConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteStudioLifecycleConfigError {
                meta: generic,
                kind: crate::error::DeleteStudioLifecycleConfigErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStudioLifecycleConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteStudioLifecycleConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_studio_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStudioLifecycleConfigOutput,
    crate::error::DeleteStudioLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_studio_lifecycle_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    Err(crate::error::DeleteTagsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trial_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrialOutput, crate::error::DeleteTrialError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTrialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTrialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteTrialError {
                meta: generic,
                kind: crate::error::DeleteTrialErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteTrialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trial_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrialOutput, crate::error::DeleteTrialError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_trial_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_trial(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTrialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteTrialComponentOutput,
    crate::error::DeleteTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTrialComponentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteTrialComponentError {
                meta: generic,
                kind: crate::error::DeleteTrialComponentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteTrialComponentOutput,
    crate::error::DeleteTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserProfileOutput, crate::error::DeleteUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::DeleteUserProfileError {
                meta: generic,
                kind: crate::error::DeleteUserProfileErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::DeleteUserProfileError {
                meta: generic,
                kind: crate::error::DeleteUserProfileErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserProfileOutput, crate::error::DeleteUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workforce_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkforceOutput, crate::error::DeleteWorkforceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWorkforceError::unhandled)?;
    Err(crate::error::DeleteWorkforceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workforce_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkforceOutput, crate::error::DeleteWorkforceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_workforce_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkteamOutput, crate::error::DeleteWorkteamError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWorkteamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWorkteamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::DeleteWorkteamError {
            meta: generic,
            kind: crate::error::DeleteWorkteamErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWorkteamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteWorkteamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWorkteamOutput, crate::error::DeleteWorkteamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_workteam_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_workteam(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteWorkteamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterDevicesOutput, crate::error::DeregisterDevicesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterDevicesError::unhandled)?;
    Err(crate::error::DeregisterDevicesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeregisterDevicesOutput, crate::error::DeregisterDevicesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_devices_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeActionOutput, crate::error::DescribeActionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeActionError {
                meta: generic,
                kind: crate::error::DescribeActionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeActionOutput, crate::error::DescribeActionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_algorithm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAlgorithmOutput, crate::error::DescribeAlgorithmError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAlgorithmError::unhandled)?;
    Err(crate::error::DescribeAlgorithmError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_algorithm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAlgorithmOutput, crate::error::DescribeAlgorithmError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_algorithm_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_algorithm(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAlgorithmError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAppOutput, crate::error::DescribeAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeAppError {
                meta: generic,
                kind: crate::error::DescribeAppErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAppError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAppOutput, crate::error::DescribeAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_app_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_app(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAppError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_app_image_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAppImageConfigOutput,
    crate::error::DescribeAppImageConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAppImageConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAppImageConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeAppImageConfigError {
                meta: generic,
                kind: crate::error::DescribeAppImageConfigErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAppImageConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeAppImageConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_app_image_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAppImageConfigOutput,
    crate::error::DescribeAppImageConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_app_image_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_app_image_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAppImageConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeArtifactOutput, crate::error::DescribeArtifactError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeArtifactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeArtifactError {
                meta: generic,
                kind: crate::error::DescribeArtifactErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeArtifactError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeArtifactOutput, crate::error::DescribeArtifactError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_ml_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAutoMlJobOutput, crate::error::DescribeAutoMLJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAutoMLJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAutoMLJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeAutoMLJobError {
                meta: generic,
                kind: crate::error::DescribeAutoMLJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAutoMLJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeAutoMLJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_auto_ml_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAutoMlJobOutput, crate::error::DescribeAutoMLJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_auto_ml_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_auto_ml_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAutoMLJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_code_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCodeRepositoryOutput,
    crate::error::DescribeCodeRepositoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCodeRepositoryError::unhandled)?;
    Err(crate::error::DescribeCodeRepositoryError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_code_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCodeRepositoryOutput,
    crate::error::DescribeCodeRepositoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_code_repository_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_code_repository(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCodeRepositoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_compilation_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCompilationJobOutput,
    crate::error::DescribeCompilationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCompilationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCompilationJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeCompilationJobError {
                meta: generic,
                kind: crate::error::DescribeCompilationJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCompilationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeCompilationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_compilation_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCompilationJobOutput,
    crate::error::DescribeCompilationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_compilation_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_compilation_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCompilationJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_context_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeContextOutput, crate::error::DescribeContextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeContextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeContextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeContextError {
                meta: generic,
                kind: crate::error::DescribeContextErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeContextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_context_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeContextOutput, crate::error::DescribeContextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_context_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_context(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeContextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataQualityJobDefinitionOutput,
    crate::error::DescribeDataQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDataQualityJobDefinitionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeDataQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::DescribeDataQualityJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDataQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataQualityJobDefinitionOutput,
    crate::error::DescribeDataQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_data_quality_job_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_data_quality_job_definition(response.body().as_ref(), output).map_err(crate::error::DescribeDataQualityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeDeviceError {
                meta: generic,
                kind: crate::error::DescribeDeviceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDeviceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_device_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_device_fleet_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDeviceFleetOutput,
    crate::error::DescribeDeviceFleetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDeviceFleetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDeviceFleetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeDeviceFleetError {
                meta: generic,
                kind: crate::error::DescribeDeviceFleetErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDeviceFleetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDeviceFleetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_device_fleet_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDeviceFleetOutput,
    crate::error::DescribeDeviceFleetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_device_fleet_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_device_fleet(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDeviceFleetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeDomainError {
                meta: generic,
                kind: crate::error::DescribeDomainErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_edge_packaging_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEdgePackagingJobOutput,
    crate::error::DescribeEdgePackagingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEdgePackagingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEdgePackagingJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeEdgePackagingJobError {
                meta: generic,
                kind: crate::error::DescribeEdgePackagingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEdgePackagingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeEdgePackagingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_edge_packaging_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEdgePackagingJobOutput,
    crate::error::DescribeEdgePackagingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_edge_packaging_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_edge_packaging_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEdgePackagingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointOutput, crate::error::DescribeEndpointError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointError::unhandled)?;
    Err(crate::error::DescribeEndpointError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointOutput, crate::error::DescribeEndpointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointConfigOutput,
    crate::error::DescribeEndpointConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointConfigError::unhandled)?;
    Err(crate::error::DescribeEndpointConfigError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointConfigOutput,
    crate::error::DescribeEndpointConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_experiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExperimentOutput,
    crate::error::DescribeExperimentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExperimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExperimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeExperimentError {
                meta: generic,
                kind: crate::error::DescribeExperimentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExperimentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeExperimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_experiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExperimentOutput,
    crate::error::DescribeExperimentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_experiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_experiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExperimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_feature_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFeatureGroupOutput,
    crate::error::DescribeFeatureGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFeatureGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeFeatureGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeFeatureGroupError {
                meta: generic,
                kind: crate::error::DescribeFeatureGroupErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFeatureGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeFeatureGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_feature_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFeatureGroupOutput,
    crate::error::DescribeFeatureGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_feature_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_feature_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFeatureGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_flow_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFlowDefinitionOutput,
    crate::error::DescribeFlowDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFlowDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeFlowDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeFlowDefinitionError {
                meta: generic,
                kind: crate::error::DescribeFlowDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFlowDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeFlowDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_flow_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFlowDefinitionOutput,
    crate::error::DescribeFlowDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_flow_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_flow_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFlowDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_human_task_ui_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHumanTaskUiOutput,
    crate::error::DescribeHumanTaskUiError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeHumanTaskUiError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeHumanTaskUiError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeHumanTaskUiError {
                meta: generic,
                kind: crate::error::DescribeHumanTaskUiErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHumanTaskUiError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeHumanTaskUiError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_human_task_ui_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHumanTaskUiOutput,
    crate::error::DescribeHumanTaskUiError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_human_task_ui_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_human_task_ui(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeHumanTaskUiError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hyper_parameter_tuning_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHyperParameterTuningJobOutput,
    crate::error::DescribeHyperParameterTuningJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeHyperParameterTuningJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeHyperParameterTuningJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeHyperParameterTuningJobError {
                meta: generic,
                kind: crate::error::DescribeHyperParameterTuningJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeHyperParameterTuningJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeHyperParameterTuningJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hyper_parameter_tuning_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHyperParameterTuningJobOutput,
    crate::error::DescribeHyperParameterTuningJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_hyper_parameter_tuning_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_hyper_parameter_tuning_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeHyperParameterTuningJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeImageOutput, crate::error::DescribeImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeImageError {
                meta: generic,
                kind: crate::error::DescribeImageErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeImageOutput, crate::error::DescribeImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageVersionOutput,
    crate::error::DescribeImageVersionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImageVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeImageVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeImageVersionError {
                meta: generic,
                kind: crate::error::DescribeImageVersionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeImageVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageVersionOutput,
    crate::error::DescribeImageVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_image_version_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_image_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeImageVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_inference_recommendations_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInferenceRecommendationsJobOutput,
    crate::error::DescribeInferenceRecommendationsJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInferenceRecommendationsJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeInferenceRecommendationsJobError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeInferenceRecommendationsJobError {
                meta: generic,
                kind: crate::error::DescribeInferenceRecommendationsJobErrorKind::ResourceNotFound(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::resource_not_found::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeInferenceRecommendationsJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        _ => crate::error::DescribeInferenceRecommendationsJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_inference_recommendations_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInferenceRecommendationsJobOutput,
    crate::error::DescribeInferenceRecommendationsJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_inference_recommendations_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_inference_recommendations_job(response.body().as_ref(), output).map_err(crate::error::DescribeInferenceRecommendationsJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_labeling_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLabelingJobOutput,
    crate::error::DescribeLabelingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLabelingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLabelingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeLabelingJobError {
                meta: generic,
                kind: crate::error::DescribeLabelingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLabelingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeLabelingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_labeling_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLabelingJobOutput,
    crate::error::DescribeLabelingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_labeling_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_labeling_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLabelingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lineage_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLineageGroupOutput,
    crate::error::DescribeLineageGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLineageGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLineageGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeLineageGroupError {
                meta: generic,
                kind: crate::error::DescribeLineageGroupErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLineageGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeLineageGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lineage_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLineageGroupOutput,
    crate::error::DescribeLineageGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_lineage_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_lineage_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLineageGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeModelOutput, crate::error::DescribeModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelError::unhandled)?;
    Err(crate::error::DescribeModelError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeModelOutput, crate::error::DescribeModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_bias_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelBiasJobDefinitionOutput,
    crate::error::DescribeModelBiasJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelBiasJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeModelBiasJobDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeModelBiasJobDefinitionError {
                meta: generic,
                kind: crate::error::DescribeModelBiasJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeModelBiasJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeModelBiasJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_bias_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelBiasJobDefinitionOutput,
    crate::error::DescribeModelBiasJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_model_bias_job_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_model_bias_job_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeModelBiasJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_explainability_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelExplainabilityJobDefinitionOutput,
    crate::error::DescribeModelExplainabilityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelExplainabilityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeModelExplainabilityJobDefinitionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::DescribeModelExplainabilityJobDefinitionError {
            meta: generic,
            kind: crate::error::DescribeModelExplainabilityJobDefinitionErrorKind::ResourceNotFound(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeModelExplainabilityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeModelExplainabilityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_explainability_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelExplainabilityJobDefinitionOutput,
    crate::error::DescribeModelExplainabilityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_model_explainability_job_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_model_explainability_job_definition(response.body().as_ref(), output).map_err(crate::error::DescribeModelExplainabilityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelPackageOutput,
    crate::error::DescribeModelPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelPackageError::unhandled)?;
    Err(crate::error::DescribeModelPackageError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelPackageOutput,
    crate::error::DescribeModelPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_model_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_model_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeModelPackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_package_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelPackageGroupOutput,
    crate::error::DescribeModelPackageGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelPackageGroupError::unhandled)?;
    Err(crate::error::DescribeModelPackageGroupError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_package_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelPackageGroupOutput,
    crate::error::DescribeModelPackageGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_model_package_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_model_package_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeModelPackageGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_quality_job_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelQualityJobDefinitionOutput,
    crate::error::DescribeModelQualityJobDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeModelQualityJobDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeModelQualityJobDefinitionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeModelQualityJobDefinitionError {
                meta: generic,
                kind: crate::error::DescribeModelQualityJobDefinitionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeModelQualityJobDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeModelQualityJobDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_model_quality_job_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeModelQualityJobDefinitionOutput,
    crate::error::DescribeModelQualityJobDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_model_quality_job_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_model_quality_job_definition(response.body().as_ref(), output).map_err(crate::error::DescribeModelQualityJobDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMonitoringScheduleOutput,
    crate::error::DescribeMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeMonitoringScheduleError {
                meta: generic,
                kind: crate::error::DescribeMonitoringScheduleErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMonitoringScheduleOutput,
    crate::error::DescribeMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_monitoring_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_monitoring_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeMonitoringScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotebookInstanceOutput,
    crate::error::DescribeNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNotebookInstanceError::unhandled)?;
    Err(crate::error::DescribeNotebookInstanceError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotebookInstanceOutput,
    crate::error::DescribeNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_notebook_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_notebook_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeNotebookInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notebook_instance_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotebookInstanceLifecycleConfigOutput,
    crate::error::DescribeNotebookInstanceLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNotebookInstanceLifecycleConfigError::unhandled)?;
    Err(crate::error::DescribeNotebookInstanceLifecycleConfigError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_notebook_instance_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNotebookInstanceLifecycleConfigOutput,
    crate::error::DescribeNotebookInstanceLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_notebook_instance_lifecycle_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_notebook_instance_lifecycle_config(response.body().as_ref(), output).map_err(crate::error::DescribeNotebookInstanceLifecycleConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePipelineOutput, crate::error::DescribePipelineError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribePipelineError {
                meta: generic,
                kind: crate::error::DescribePipelineErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePipelineOutput, crate::error::DescribePipelineError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_definition_for_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePipelineDefinitionForExecutionOutput,
    crate::error::DescribePipelineDefinitionForExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePipelineDefinitionForExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribePipelineDefinitionForExecutionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::DescribePipelineDefinitionForExecutionError {
            meta: generic,
            kind: crate::error::DescribePipelineDefinitionForExecutionErrorKind::ResourceNotFound(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelineDefinitionForExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribePipelineDefinitionForExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_definition_for_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePipelineDefinitionForExecutionOutput,
    crate::error::DescribePipelineDefinitionForExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_pipeline_definition_for_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_pipeline_definition_for_execution(response.body().as_ref(), output).map_err(crate::error::DescribePipelineDefinitionForExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePipelineExecutionOutput,
    crate::error::DescribePipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePipelineExecutionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribePipelineExecutionError {
                meta: generic,
                kind: crate::error::DescribePipelineExecutionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribePipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePipelineExecutionOutput,
    crate::error::DescribePipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_processing_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProcessingJobOutput,
    crate::error::DescribeProcessingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProcessingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeProcessingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeProcessingJobError {
                meta: generic,
                kind: crate::error::DescribeProcessingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeProcessingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeProcessingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_processing_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeProcessingJobOutput,
    crate::error::DescribeProcessingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_processing_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_processing_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProcessingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProjectOutput, crate::error::DescribeProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeProjectError::unhandled)?;
    Err(crate::error::DescribeProjectError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeProjectOutput, crate::error::DescribeProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_studio_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStudioLifecycleConfigOutput,
    crate::error::DescribeStudioLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStudioLifecycleConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeStudioLifecycleConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeStudioLifecycleConfigError {
                meta: generic,
                kind: crate::error::DescribeStudioLifecycleConfigErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStudioLifecycleConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeStudioLifecycleConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_studio_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStudioLifecycleConfigOutput,
    crate::error::DescribeStudioLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_studio_lifecycle_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_studio_lifecycle_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeStudioLifecycleConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_subscribed_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSubscribedWorkteamOutput,
    crate::error::DescribeSubscribedWorkteamError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSubscribedWorkteamError::unhandled)?;
    Err(crate::error::DescribeSubscribedWorkteamError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_subscribed_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSubscribedWorkteamOutput,
    crate::error::DescribeSubscribedWorkteamError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_subscribed_workteam_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_subscribed_workteam(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSubscribedWorkteamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_training_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTrainingJobOutput,
    crate::error::DescribeTrainingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTrainingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTrainingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeTrainingJobError {
                meta: generic,
                kind: crate::error::DescribeTrainingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrainingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTrainingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_training_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTrainingJobOutput,
    crate::error::DescribeTrainingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_training_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_training_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTrainingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_transform_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTransformJobOutput,
    crate::error::DescribeTransformJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTransformJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTransformJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeTransformJobError {
                meta: generic,
                kind: crate::error::DescribeTransformJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTransformJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTransformJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_transform_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTransformJobOutput,
    crate::error::DescribeTransformJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_transform_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_transform_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTransformJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trial_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrialOutput, crate::error::DescribeTrialError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTrialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTrialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeTrialError {
                meta: generic,
                kind: crate::error::DescribeTrialErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTrialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trial_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrialOutput, crate::error::DescribeTrialError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_trial_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_trial(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTrialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTrialComponentOutput,
    crate::error::DescribeTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTrialComponentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeTrialComponentError {
                meta: generic,
                kind: crate::error::DescribeTrialComponentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTrialComponentOutput,
    crate::error::DescribeTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserProfileOutput,
    crate::error::DescribeUserProfileError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DescribeUserProfileError {
                meta: generic,
                kind: crate::error::DescribeUserProfileErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUserProfileOutput,
    crate::error::DescribeUserProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workforce_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWorkforceOutput, crate::error::DescribeWorkforceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkforceError::unhandled)?;
    Err(crate::error::DescribeWorkforceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workforce_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWorkforceOutput, crate::error::DescribeWorkforceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workforce_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workforce(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkforceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWorkteamOutput, crate::error::DescribeWorkteamError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeWorkteamError::unhandled)?;
    Err(crate::error::DescribeWorkteamError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeWorkteamOutput, crate::error::DescribeWorkteamError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_workteam_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_workteam(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeWorkteamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_sagemaker_servicecatalog_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableSagemakerServicecatalogPortfolioOutput,
    crate::error::DisableSagemakerServicecatalogPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableSagemakerServicecatalogPortfolioError::unhandled)?;
    Err(crate::error::DisableSagemakerServicecatalogPortfolioError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_sagemaker_servicecatalog_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableSagemakerServicecatalogPortfolioOutput,
    crate::error::DisableSagemakerServicecatalogPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disable_sagemaker_servicecatalog_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTrialComponentOutput,
    crate::error::DisassociateTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateTrialComponentError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DisassociateTrialComponentError {
                meta: generic,
                kind: crate::error::DisassociateTrialComponentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DisassociateTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateTrialComponentOutput,
    crate::error::DisassociateTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disassociate_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisassociateTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_sagemaker_servicecatalog_portfolio_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableSagemakerServicecatalogPortfolioOutput,
    crate::error::EnableSagemakerServicecatalogPortfolioError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableSagemakerServicecatalogPortfolioError::unhandled)?;
    Err(crate::error::EnableSagemakerServicecatalogPortfolioError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_sagemaker_servicecatalog_portfolio_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableSagemakerServicecatalogPortfolioOutput,
    crate::error::EnableSagemakerServicecatalogPortfolioError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::enable_sagemaker_servicecatalog_portfolio_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_fleet_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDeviceFleetReportOutput,
    crate::error::GetDeviceFleetReportError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDeviceFleetReportError::unhandled)?;
    Err(crate::error::GetDeviceFleetReportError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_device_fleet_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDeviceFleetReportOutput,
    crate::error::GetDeviceFleetReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_device_fleet_report_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_device_fleet_report(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDeviceFleetReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lineage_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLineageGroupPolicyOutput,
    crate::error::GetLineageGroupPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLineageGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLineageGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::GetLineageGroupPolicyError {
                meta: generic,
                kind: crate::error::GetLineageGroupPolicyErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::GetLineageGroupPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetLineageGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lineage_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLineageGroupPolicyOutput,
    crate::error::GetLineageGroupPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_lineage_group_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_lineage_group_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLineageGroupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_package_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetModelPackageGroupPolicyOutput,
    crate::error::GetModelPackageGroupPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetModelPackageGroupPolicyError::unhandled)?;
    Err(crate::error::GetModelPackageGroupPolicyError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_model_package_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetModelPackageGroupPolicyOutput,
    crate::error::GetModelPackageGroupPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_model_package_group_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_model_package_group_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetModelPackageGroupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sagemaker_servicecatalog_portfolio_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSagemakerServicecatalogPortfolioStatusOutput,
    crate::error::GetSagemakerServicecatalogPortfolioStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSagemakerServicecatalogPortfolioStatusError::unhandled)?;
    Err(crate::error::GetSagemakerServicecatalogPortfolioStatusError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sagemaker_servicecatalog_portfolio_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSagemakerServicecatalogPortfolioStatusOutput,
    crate::error::GetSagemakerServicecatalogPortfolioStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_sagemaker_servicecatalog_portfolio_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_sagemaker_servicecatalog_portfolio_status(response.body().as_ref(), output).map_err(crate::error::GetSagemakerServicecatalogPortfolioStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_search_suggestions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSearchSuggestionsOutput,
    crate::error::GetSearchSuggestionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSearchSuggestionsError::unhandled)?;
    Err(crate::error::GetSearchSuggestionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_search_suggestions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSearchSuggestionsOutput,
    crate::error::GetSearchSuggestionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_search_suggestions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_search_suggestions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSearchSuggestionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActionsOutput, crate::error::ListActionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListActionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListActionsError {
                meta: generic,
                kind: crate::error::ListActionsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListActionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActionsOutput, crate::error::ListActionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_actions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_actions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_algorithms_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAlgorithmsOutput, crate::error::ListAlgorithmsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAlgorithmsError::unhandled)?;
    Err(crate::error::ListAlgorithmsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_algorithms_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAlgorithmsOutput, crate::error::ListAlgorithmsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_algorithms_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_algorithms(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAlgorithmsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_app_image_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAppImageConfigsOutput,
    crate::error::ListAppImageConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAppImageConfigsError::unhandled)?;
    Err(crate::error::ListAppImageConfigsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_app_image_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAppImageConfigsOutput,
    crate::error::ListAppImageConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_app_image_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_app_image_configs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAppImageConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_apps_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAppsError::unhandled)?;
    Err(crate::error::ListAppsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_apps_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_apps_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_apps(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAppsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_artifacts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListArtifactsOutput, crate::error::ListArtifactsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListArtifactsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListArtifactsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListArtifactsError {
                meta: generic,
                kind: crate::error::ListArtifactsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListArtifactsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListArtifactsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_artifacts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListArtifactsOutput, crate::error::ListArtifactsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_artifacts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_artifacts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListArtifactsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_associations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAssociationsOutput, crate::error::ListAssociationsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAssociationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAssociationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListAssociationsError {
                meta: generic,
                kind: crate::error::ListAssociationsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListAssociationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListAssociationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_associations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAssociationsOutput, crate::error::ListAssociationsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_associations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_associations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAssociationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_auto_ml_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAutoMlJobsOutput, crate::error::ListAutoMLJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAutoMLJobsError::unhandled)?;
    Err(crate::error::ListAutoMLJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_auto_ml_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAutoMlJobsOutput, crate::error::ListAutoMLJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_auto_ml_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_auto_ml_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAutoMLJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_candidates_for_auto_ml_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCandidatesForAutoMlJobOutput,
    crate::error::ListCandidatesForAutoMLJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCandidatesForAutoMLJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCandidatesForAutoMLJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListCandidatesForAutoMLJobError {
                meta: generic,
                kind: crate::error::ListCandidatesForAutoMLJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListCandidatesForAutoMLJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListCandidatesForAutoMLJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_candidates_for_auto_ml_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCandidatesForAutoMlJobOutput,
    crate::error::ListCandidatesForAutoMLJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_candidates_for_auto_ml_job_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_candidates_for_auto_ml_job(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListCandidatesForAutoMLJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_code_repositories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCodeRepositoriesOutput,
    crate::error::ListCodeRepositoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCodeRepositoriesError::unhandled)?;
    Err(crate::error::ListCodeRepositoriesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_code_repositories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCodeRepositoriesOutput,
    crate::error::ListCodeRepositoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_code_repositories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_code_repositories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCodeRepositoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_compilation_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCompilationJobsOutput,
    crate::error::ListCompilationJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCompilationJobsError::unhandled)?;
    Err(crate::error::ListCompilationJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_compilation_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCompilationJobsOutput,
    crate::error::ListCompilationJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_compilation_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_compilation_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCompilationJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_contexts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListContextsOutput, crate::error::ListContextsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListContextsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListContextsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListContextsError {
                meta: generic,
                kind: crate::error::ListContextsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListContextsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListContextsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_contexts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListContextsOutput, crate::error::ListContextsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_contexts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_contexts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListContextsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_data_quality_job_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDataQualityJobDefinitionsOutput,
    crate::error::ListDataQualityJobDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDataQualityJobDefinitionsError::unhandled)?;
    Err(crate::error::ListDataQualityJobDefinitionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_data_quality_job_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDataQualityJobDefinitionsOutput,
    crate::error::ListDataQualityJobDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_data_quality_job_definitions_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_data_quality_job_definitions(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListDataQualityJobDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_device_fleets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDeviceFleetsOutput, crate::error::ListDeviceFleetsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDeviceFleetsError::unhandled)?;
    Err(crate::error::ListDeviceFleetsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_device_fleets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDeviceFleetsOutput, crate::error::ListDeviceFleetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_device_fleets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_device_fleets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDeviceFleetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDevicesError::unhandled)?;
    Err(crate::error::ListDevicesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_devices_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domains_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDomainsError::unhandled)?;
    Err(crate::error::ListDomainsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domains_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_domains_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_domains(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDomainsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_edge_packaging_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEdgePackagingJobsOutput,
    crate::error::ListEdgePackagingJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEdgePackagingJobsError::unhandled)?;
    Err(crate::error::ListEdgePackagingJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_edge_packaging_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEdgePackagingJobsOutput,
    crate::error::ListEdgePackagingJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_edge_packaging_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_edge_packaging_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEdgePackagingJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoint_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointConfigsOutput,
    crate::error::ListEndpointConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEndpointConfigsError::unhandled)?;
    Err(crate::error::ListEndpointConfigsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoint_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointConfigsOutput,
    crate::error::ListEndpointConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_endpoint_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_endpoint_configs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEndpointConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEndpointsError::unhandled)?;
    Err(crate::error::ListEndpointsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_endpoints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_experiments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExperimentsOutput, crate::error::ListExperimentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListExperimentsError::unhandled)?;
    Err(crate::error::ListExperimentsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_experiments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExperimentsOutput, crate::error::ListExperimentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_experiments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_experiments(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListExperimentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_feature_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFeatureGroupsOutput, crate::error::ListFeatureGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFeatureGroupsError::unhandled)?;
    Err(crate::error::ListFeatureGroupsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_feature_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFeatureGroupsOutput, crate::error::ListFeatureGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_feature_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_feature_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFeatureGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_flow_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFlowDefinitionsOutput,
    crate::error::ListFlowDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFlowDefinitionsError::unhandled)?;
    Err(crate::error::ListFlowDefinitionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_flow_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFlowDefinitionsOutput,
    crate::error::ListFlowDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_flow_definitions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_flow_definitions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFlowDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_human_task_uis_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListHumanTaskUisOutput, crate::error::ListHumanTaskUisError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHumanTaskUisError::unhandled)?;
    Err(crate::error::ListHumanTaskUisError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_human_task_uis_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListHumanTaskUisOutput, crate::error::ListHumanTaskUisError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_human_task_uis_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_human_task_uis(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListHumanTaskUisError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hyper_parameter_tuning_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHyperParameterTuningJobsOutput,
    crate::error::ListHyperParameterTuningJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListHyperParameterTuningJobsError::unhandled)?;
    Err(crate::error::ListHyperParameterTuningJobsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_hyper_parameter_tuning_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListHyperParameterTuningJobsOutput,
    crate::error::ListHyperParameterTuningJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_hyper_parameter_tuning_jobs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_hyper_parameter_tuning_jobs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListHyperParameterTuningJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListImagesError::unhandled)?;
    Err(crate::error::ListImagesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_image_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImageVersionsOutput, crate::error::ListImageVersionsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListImageVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListImageVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListImageVersionsError {
                meta: generic,
                kind: crate::error::ListImageVersionsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListImageVersionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListImageVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_image_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImageVersionsOutput, crate::error::ListImageVersionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_image_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_image_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListImageVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_inference_recommendations_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInferenceRecommendationsJobsOutput,
    crate::error::ListInferenceRecommendationsJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInferenceRecommendationsJobsError::unhandled)?;
    Err(crate::error::ListInferenceRecommendationsJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_inference_recommendations_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInferenceRecommendationsJobsOutput,
    crate::error::ListInferenceRecommendationsJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_inference_recommendations_jobs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_inference_recommendations_jobs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListInferenceRecommendationsJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_labeling_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLabelingJobsOutput, crate::error::ListLabelingJobsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLabelingJobsError::unhandled)?;
    Err(crate::error::ListLabelingJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_labeling_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLabelingJobsOutput, crate::error::ListLabelingJobsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_labeling_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_labeling_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLabelingJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_labeling_jobs_for_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLabelingJobsForWorkteamOutput,
    crate::error::ListLabelingJobsForWorkteamError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLabelingJobsForWorkteamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListLabelingJobsForWorkteamError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListLabelingJobsForWorkteamError {
                meta: generic,
                kind: crate::error::ListLabelingJobsForWorkteamErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListLabelingJobsForWorkteamError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListLabelingJobsForWorkteamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_labeling_jobs_for_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLabelingJobsForWorkteamOutput,
    crate::error::ListLabelingJobsForWorkteamError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_labeling_jobs_for_workteam_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_labeling_jobs_for_workteam(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListLabelingJobsForWorkteamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_lineage_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLineageGroupsOutput, crate::error::ListLineageGroupsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLineageGroupsError::unhandled)?;
    Err(crate::error::ListLineageGroupsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_lineage_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLineageGroupsOutput, crate::error::ListLineageGroupsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_lineage_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_lineage_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLineageGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_bias_job_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelBiasJobDefinitionsOutput,
    crate::error::ListModelBiasJobDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelBiasJobDefinitionsError::unhandled)?;
    Err(crate::error::ListModelBiasJobDefinitionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_bias_job_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelBiasJobDefinitionsOutput,
    crate::error::ListModelBiasJobDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_model_bias_job_definitions_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_model_bias_job_definitions(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListModelBiasJobDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_explainability_job_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelExplainabilityJobDefinitionsOutput,
    crate::error::ListModelExplainabilityJobDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelExplainabilityJobDefinitionsError::unhandled)?;
    Err(crate::error::ListModelExplainabilityJobDefinitionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_explainability_job_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelExplainabilityJobDefinitionsOutput,
    crate::error::ListModelExplainabilityJobDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_model_explainability_job_definitions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_model_explainability_job_definitions(response.body().as_ref(), output).map_err(crate::error::ListModelExplainabilityJobDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_metadata_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelMetadataOutput, crate::error::ListModelMetadataError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelMetadataError::unhandled)?;
    Err(crate::error::ListModelMetadataError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_metadata_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelMetadataOutput, crate::error::ListModelMetadataError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_model_metadata_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_model_metadata(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListModelMetadataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_package_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelPackageGroupsOutput,
    crate::error::ListModelPackageGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelPackageGroupsError::unhandled)?;
    Err(crate::error::ListModelPackageGroupsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_package_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelPackageGroupsOutput,
    crate::error::ListModelPackageGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_model_package_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_model_package_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListModelPackageGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_packages_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelPackagesOutput, crate::error::ListModelPackagesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelPackagesError::unhandled)?;
    Err(crate::error::ListModelPackagesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_packages_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelPackagesOutput, crate::error::ListModelPackagesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_model_packages_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_model_packages(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListModelPackagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_quality_job_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelQualityJobDefinitionsOutput,
    crate::error::ListModelQualityJobDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelQualityJobDefinitionsError::unhandled)?;
    Err(crate::error::ListModelQualityJobDefinitionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_model_quality_job_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListModelQualityJobDefinitionsOutput,
    crate::error::ListModelQualityJobDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_model_quality_job_definitions_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_model_quality_job_definitions(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListModelQualityJobDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_models_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelsOutput, crate::error::ListModelsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListModelsError::unhandled)?;
    Err(crate::error::ListModelsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_models_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListModelsOutput, crate::error::ListModelsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_models_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_models(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListModelsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_monitoring_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMonitoringExecutionsOutput,
    crate::error::ListMonitoringExecutionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMonitoringExecutionsError::unhandled)?;
    Err(crate::error::ListMonitoringExecutionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_monitoring_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMonitoringExecutionsOutput,
    crate::error::ListMonitoringExecutionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_monitoring_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_monitoring_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMonitoringExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_monitoring_schedules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMonitoringSchedulesOutput,
    crate::error::ListMonitoringSchedulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMonitoringSchedulesError::unhandled)?;
    Err(crate::error::ListMonitoringSchedulesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_monitoring_schedules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMonitoringSchedulesOutput,
    crate::error::ListMonitoringSchedulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_monitoring_schedules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_monitoring_schedules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMonitoringSchedulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_notebook_instance_lifecycle_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNotebookInstanceLifecycleConfigsOutput,
    crate::error::ListNotebookInstanceLifecycleConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListNotebookInstanceLifecycleConfigsError::unhandled)?;
    Err(crate::error::ListNotebookInstanceLifecycleConfigsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_notebook_instance_lifecycle_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNotebookInstanceLifecycleConfigsOutput,
    crate::error::ListNotebookInstanceLifecycleConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_notebook_instance_lifecycle_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_notebook_instance_lifecycle_configs(response.body().as_ref(), output).map_err(crate::error::ListNotebookInstanceLifecycleConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_notebook_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNotebookInstancesOutput,
    crate::error::ListNotebookInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListNotebookInstancesError::unhandled)?;
    Err(crate::error::ListNotebookInstancesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_notebook_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListNotebookInstancesOutput,
    crate::error::ListNotebookInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_notebook_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_notebook_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListNotebookInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionsOutput,
    crate::error::ListPipelineExecutionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPipelineExecutionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListPipelineExecutionsError {
                meta: generic,
                kind: crate::error::ListPipelineExecutionsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListPipelineExecutionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionsOutput,
    crate::error::ListPipelineExecutionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipeline_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipeline_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelineExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_execution_steps_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionStepsOutput,
    crate::error::ListPipelineExecutionStepsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelineExecutionStepsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPipelineExecutionStepsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListPipelineExecutionStepsError {
                meta: generic,
                kind: crate::error::ListPipelineExecutionStepsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineExecutionStepsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListPipelineExecutionStepsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_execution_steps_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineExecutionStepsOutput,
    crate::error::ListPipelineExecutionStepsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipeline_execution_steps_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipeline_execution_steps(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelineExecutionStepsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_parameters_for_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineParametersForExecutionOutput,
    crate::error::ListPipelineParametersForExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelineParametersForExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPipelineParametersForExecutionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListPipelineParametersForExecutionError {
                meta: generic,
                kind: crate::error::ListPipelineParametersForExecutionErrorKind::ResourceNotFound(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::resource_not_found::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelineParametersForExecutionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        _ => crate::error::ListPipelineParametersForExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipeline_parameters_for_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPipelineParametersForExecutionOutput,
    crate::error::ListPipelineParametersForExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_pipeline_parameters_for_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipeline_parameters_for_execution(response.body().as_ref(), output).map_err(crate::error::ListPipelineParametersForExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelinesError::unhandled)?;
    Err(crate::error::ListPipelinesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipelines_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipelines(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_processing_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProcessingJobsOutput,
    crate::error::ListProcessingJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProcessingJobsError::unhandled)?;
    Err(crate::error::ListProcessingJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_processing_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProcessingJobsOutput,
    crate::error::ListProcessingJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_processing_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_processing_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProcessingJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_projects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProjectsError::unhandled)?;
    Err(crate::error::ListProjectsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_projects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_projects_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_projects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProjectsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_studio_lifecycle_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStudioLifecycleConfigsOutput,
    crate::error::ListStudioLifecycleConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStudioLifecycleConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListStudioLifecycleConfigsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::ListStudioLifecycleConfigsError {
                meta: generic,
                kind: crate::error::ListStudioLifecycleConfigsErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::ListStudioLifecycleConfigsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListStudioLifecycleConfigsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_studio_lifecycle_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStudioLifecycleConfigsOutput,
    crate::error::ListStudioLifecycleConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_studio_lifecycle_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_studio_lifecycle_configs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStudioLifecycleConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscribed_workteams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscribedWorkteamsOutput,
    crate::error::ListSubscribedWorkteamsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSubscribedWorkteamsError::unhandled)?;
    Err(crate::error::ListSubscribedWorkteamsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscribed_workteams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscribedWorkteamsOutput,
    crate::error::ListSubscribedWorkteamsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_subscribed_workteams_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_subscribed_workteams(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSubscribedWorkteamsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsError::unhandled)?;
    Err(crate::error::ListTagsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_training_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrainingJobsOutput, crate::error::ListTrainingJobsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrainingJobsError::unhandled)?;
    Err(crate::error::ListTrainingJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_training_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrainingJobsOutput, crate::error::ListTrainingJobsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_training_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_training_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrainingJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_training_jobs_for_hyper_parameter_tuning_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrainingJobsForHyperParameterTuningJobOutput,
    crate::error::ListTrainingJobsForHyperParameterTuningJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrainingJobsForHyperParameterTuningJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListTrainingJobsForHyperParameterTuningJobError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::ListTrainingJobsForHyperParameterTuningJobError {
            meta: generic,
            kind:
                crate::error::ListTrainingJobsForHyperParameterTuningJobErrorKind::ResourceNotFound(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::resource_not_found::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrainingJobsForHyperParameterTuningJobError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ListTrainingJobsForHyperParameterTuningJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_training_jobs_for_hyper_parameter_tuning_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrainingJobsForHyperParameterTuningJobOutput,
    crate::error::ListTrainingJobsForHyperParameterTuningJobError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::list_training_jobs_for_hyper_parameter_tuning_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_training_jobs_for_hyper_parameter_tuning_job(response.body().as_ref(), output).map_err(crate::error::ListTrainingJobsForHyperParameterTuningJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_transform_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTransformJobsOutput, crate::error::ListTransformJobsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTransformJobsError::unhandled)?;
    Err(crate::error::ListTransformJobsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_transform_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTransformJobsOutput, crate::error::ListTransformJobsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_transform_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_transform_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTransformJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trial_components_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrialComponentsOutput,
    crate::error::ListTrialComponentsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrialComponentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTrialComponentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListTrialComponentsError {
                meta: generic,
                kind: crate::error::ListTrialComponentsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrialComponentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTrialComponentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trial_components_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTrialComponentsOutput,
    crate::error::ListTrialComponentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_trial_components_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_trial_components(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrialComponentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrialsOutput, crate::error::ListTrialsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTrialsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::ListTrialsError {
                meta: generic,
                kind: crate::error::ListTrialsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrialsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTrialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrialsOutput, crate::error::ListTrialsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_trials_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_trials(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserProfilesOutput, crate::error::ListUserProfilesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserProfilesError::unhandled)?;
    Err(crate::error::ListUserProfilesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserProfilesOutput, crate::error::ListUserProfilesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_profiles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_user_profiles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workforces_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkforcesOutput, crate::error::ListWorkforcesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWorkforcesError::unhandled)?;
    Err(crate::error::ListWorkforcesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workforces_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkforcesOutput, crate::error::ListWorkforcesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_workforces_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_workforces(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWorkforcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workteams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkteamsOutput, crate::error::ListWorkteamsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWorkteamsError::unhandled)?;
    Err(crate::error::ListWorkteamsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_workteams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWorkteamsOutput, crate::error::ListWorkteamsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_workteams_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_workteams(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWorkteamsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_model_package_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutModelPackageGroupPolicyOutput,
    crate::error::PutModelPackageGroupPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutModelPackageGroupPolicyError::unhandled)?;
    Err(crate::error::PutModelPackageGroupPolicyError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_model_package_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutModelPackageGroupPolicyOutput,
    crate::error::PutModelPackageGroupPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_model_package_group_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_model_package_group_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutModelPackageGroupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_lineage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryLineageOutput, crate::error::QueryLineageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::QueryLineageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::QueryLineageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::QueryLineageError {
                meta: generic,
                kind: crate::error::QueryLineageErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::QueryLineageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::QueryLineageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_lineage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryLineageOutput, crate::error::QueryLineageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::query_lineage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_query_lineage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::QueryLineageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterDevicesOutput, crate::error::RegisterDevicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterDevicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RegisterDevicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::RegisterDevicesError {
            meta: generic,
            kind: crate::error::RegisterDevicesErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterDevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterDevicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RegisterDevicesOutput, crate::error::RegisterDevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_devices_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_render_ui_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RenderUiTemplateOutput, crate::error::RenderUiTemplateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RenderUiTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RenderUiTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::RenderUiTemplateError {
                meta: generic,
                kind: crate::error::RenderUiTemplateErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::RenderUiTemplateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RenderUiTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_render_ui_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RenderUiTemplateOutput, crate::error::RenderUiTemplateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::render_ui_template_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_render_ui_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RenderUiTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retry_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetryPipelineExecutionOutput,
    crate::error::RetryPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetryPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RetryPipelineExecutionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::RetryPipelineExecutionError {
                meta: generic,
                kind: crate::error::RetryPipelineExecutionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetryPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::RetryPipelineExecutionError {
            meta: generic,
            kind: crate::error::RetryPipelineExecutionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::RetryPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::RetryPipelineExecutionError {
                meta: generic,
                kind: crate::error::RetryPipelineExecutionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::RetryPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RetryPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retry_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RetryPipelineExecutionOutput,
    crate::error::RetryPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retry_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_retry_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RetryPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchOutput, crate::error::SearchError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchError::unhandled)?;
    Err(crate::error::SearchError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchOutput, crate::error::SearchError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_pipeline_execution_step_failure_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendPipelineExecutionStepFailureOutput,
    crate::error::SendPipelineExecutionStepFailureError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendPipelineExecutionStepFailureError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendPipelineExecutionStepFailureError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::SendPipelineExecutionStepFailureError {
            meta: generic,
            kind: crate::error::SendPipelineExecutionStepFailureErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepFailureError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::SendPipelineExecutionStepFailureError {
                meta: generic,
                kind: crate::error::SendPipelineExecutionStepFailureErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepFailureError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SendPipelineExecutionStepFailureError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_pipeline_execution_step_failure_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendPipelineExecutionStepFailureOutput,
    crate::error::SendPipelineExecutionStepFailureError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::send_pipeline_execution_step_failure_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_pipeline_execution_step_failure(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepFailureError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_pipeline_execution_step_success_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendPipelineExecutionStepSuccessOutput,
    crate::error::SendPipelineExecutionStepSuccessError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendPipelineExecutionStepSuccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendPipelineExecutionStepSuccessError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::SendPipelineExecutionStepSuccessError {
            meta: generic,
            kind: crate::error::SendPipelineExecutionStepSuccessErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepSuccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::SendPipelineExecutionStepSuccessError {
                meta: generic,
                kind: crate::error::SendPipelineExecutionStepSuccessErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepSuccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SendPipelineExecutionStepSuccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_pipeline_execution_step_success_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendPipelineExecutionStepSuccessOutput,
    crate::error::SendPipelineExecutionStepSuccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::send_pipeline_execution_step_success_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_pipeline_execution_step_success(response.body().as_ref(), output).map_err(crate::error::SendPipelineExecutionStepSuccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartMonitoringScheduleOutput,
    crate::error::StartMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StartMonitoringScheduleError {
                meta: generic,
                kind: crate::error::StartMonitoringScheduleErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StartMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StartMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartMonitoringScheduleOutput,
    crate::error::StartMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_monitoring_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartNotebookInstanceOutput,
    crate::error::StartNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartNotebookInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartNotebookInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::StartNotebookInstanceError {
            meta: generic,
            kind: crate::error::StartNotebookInstanceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::StartNotebookInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartNotebookInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartNotebookInstanceOutput,
    crate::error::StartNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_notebook_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPipelineExecutionOutput,
    crate::error::StartPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartPipelineExecutionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::StartPipelineExecutionError {
            meta: generic,
            kind: crate::error::StartPipelineExecutionErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::StartPipelineExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::StartPipelineExecutionError {
                meta: generic,
                kind: crate::error::StartPipelineExecutionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StartPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StartPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartPipelineExecutionOutput,
    crate::error::StartPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_auto_ml_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopAutoMlJobOutput, crate::error::StopAutoMLJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopAutoMLJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopAutoMLJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopAutoMLJobError {
                meta: generic,
                kind: crate::error::StopAutoMLJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopAutoMLJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopAutoMLJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_auto_ml_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopAutoMlJobOutput, crate::error::StopAutoMLJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_auto_ml_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_compilation_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopCompilationJobOutput,
    crate::error::StopCompilationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopCompilationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopCompilationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopCompilationJobError {
                meta: generic,
                kind: crate::error::StopCompilationJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopCompilationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopCompilationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_compilation_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopCompilationJobOutput,
    crate::error::StopCompilationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_compilation_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_edge_packaging_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEdgePackagingJobOutput,
    crate::error::StopEdgePackagingJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopEdgePackagingJobError::unhandled)?;
    Err(crate::error::StopEdgePackagingJobError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_edge_packaging_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopEdgePackagingJobOutput,
    crate::error::StopEdgePackagingJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_edge_packaging_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_hyper_parameter_tuning_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopHyperParameterTuningJobOutput,
    crate::error::StopHyperParameterTuningJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopHyperParameterTuningJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopHyperParameterTuningJobError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopHyperParameterTuningJobError {
                meta: generic,
                kind: crate::error::StopHyperParameterTuningJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopHyperParameterTuningJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopHyperParameterTuningJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_hyper_parameter_tuning_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopHyperParameterTuningJobOutput,
    crate::error::StopHyperParameterTuningJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_hyper_parameter_tuning_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_inference_recommendations_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopInferenceRecommendationsJobOutput,
    crate::error::StopInferenceRecommendationsJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopInferenceRecommendationsJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopInferenceRecommendationsJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopInferenceRecommendationsJobError {
                meta: generic,
                kind: crate::error::StopInferenceRecommendationsJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopInferenceRecommendationsJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopInferenceRecommendationsJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_inference_recommendations_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopInferenceRecommendationsJobOutput,
    crate::error::StopInferenceRecommendationsJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::stop_inference_recommendations_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_labeling_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopLabelingJobOutput, crate::error::StopLabelingJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopLabelingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopLabelingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopLabelingJobError {
                meta: generic,
                kind: crate::error::StopLabelingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopLabelingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopLabelingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_labeling_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopLabelingJobOutput, crate::error::StopLabelingJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_labeling_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopMonitoringScheduleOutput,
    crate::error::StopMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopMonitoringScheduleError {
                meta: generic,
                kind: crate::error::StopMonitoringScheduleErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopMonitoringScheduleOutput,
    crate::error::StopMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_monitoring_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopNotebookInstanceOutput,
    crate::error::StopNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopNotebookInstanceError::unhandled)?;
    Err(crate::error::StopNotebookInstanceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopNotebookInstanceOutput,
    crate::error::StopNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_notebook_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPipelineExecutionOutput,
    crate::error::StopPipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopPipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopPipelineExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopPipelineExecutionError {
                meta: generic,
                kind: crate::error::StopPipelineExecutionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopPipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopPipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopPipelineExecutionOutput,
    crate::error::StopPipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopPipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_processing_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopProcessingJobOutput, crate::error::StopProcessingJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopProcessingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopProcessingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopProcessingJobError {
                meta: generic,
                kind: crate::error::StopProcessingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopProcessingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopProcessingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_processing_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopProcessingJobOutput, crate::error::StopProcessingJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_processing_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTrainingJobOutput, crate::error::StopTrainingJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopTrainingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopTrainingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopTrainingJobError {
                meta: generic,
                kind: crate::error::StopTrainingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopTrainingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopTrainingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_training_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTrainingJobOutput, crate::error::StopTrainingJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_training_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_transform_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTransformJobOutput, crate::error::StopTransformJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopTransformJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopTransformJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::StopTransformJobError {
                meta: generic,
                kind: crate::error::StopTransformJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::StopTransformJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopTransformJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_transform_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTransformJobOutput, crate::error::StopTransformJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_transform_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateActionOutput, crate::error::UpdateActionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateActionError {
                meta: generic,
                kind: crate::error::UpdateActionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateActionError {
                meta: generic,
                kind: crate::error::UpdateActionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateActionOutput, crate::error::UpdateActionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_action_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_app_image_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAppImageConfigOutput,
    crate::error::UpdateAppImageConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAppImageConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAppImageConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::UpdateAppImageConfigError {
                meta: generic,
                kind: crate::error::UpdateAppImageConfigErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAppImageConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateAppImageConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_app_image_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAppImageConfigOutput,
    crate::error::UpdateAppImageConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_app_image_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_app_image_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAppImageConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_artifact_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateArtifactOutput, crate::error::UpdateArtifactError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateArtifactError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateArtifactError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateArtifactError {
                meta: generic,
                kind: crate::error::UpdateArtifactErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateArtifactError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateArtifactError {
                meta: generic,
                kind: crate::error::UpdateArtifactErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateArtifactError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateArtifactError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_artifact_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateArtifactOutput, crate::error::UpdateArtifactError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_artifact_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_artifact(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateArtifactError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_code_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCodeRepositoryOutput,
    crate::error::UpdateCodeRepositoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCodeRepositoryError::unhandled)?;
    Err(crate::error::UpdateCodeRepositoryError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_code_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCodeRepositoryOutput,
    crate::error::UpdateCodeRepositoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_code_repository_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_code_repository(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateCodeRepositoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_context_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateContextOutput, crate::error::UpdateContextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateContextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateContextError {
                meta: generic,
                kind: crate::error::UpdateContextErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateContextError {
                meta: generic,
                kind: crate::error::UpdateContextErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateContextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_context_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateContextOutput, crate::error::UpdateContextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_context_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_context(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateContextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_fleet_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeviceFleetOutput, crate::error::UpdateDeviceFleetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDeviceFleetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDeviceFleetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::UpdateDeviceFleetError {
                meta: generic,
                kind: crate::error::UpdateDeviceFleetErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDeviceFleetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateDeviceFleetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_device_fleet_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDeviceFleetOutput, crate::error::UpdateDeviceFleetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_device_fleet_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDevicesOutput, crate::error::UpdateDevicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDevicesError::unhandled)?;
    Err(crate::error::UpdateDevicesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDevicesOutput, crate::error::UpdateDevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_devices_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDomainOutput, crate::error::UpdateDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::UpdateDomainError {
                meta: generic,
                kind: crate::error::UpdateDomainErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::UpdateDomainError {
            meta: generic,
            kind: crate::error::UpdateDomainErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::UpdateDomainError {
                meta: generic,
                kind: crate::error::UpdateDomainErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDomainOutput, crate::error::UpdateDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateEndpointError {
            meta: generic,
            kind: crate::error::UpdateEndpointErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_weights_and_capacities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEndpointWeightsAndCapacitiesOutput,
    crate::error::UpdateEndpointWeightsAndCapacitiesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEndpointWeightsAndCapacitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateEndpointWeightsAndCapacitiesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateEndpointWeightsAndCapacitiesError {
            meta: generic,
            kind: crate::error::UpdateEndpointWeightsAndCapacitiesErrorKind::ResourceLimitExceeded(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_limit_exceeded::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointWeightsAndCapacitiesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateEndpointWeightsAndCapacitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_weights_and_capacities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEndpointWeightsAndCapacitiesOutput,
    crate::error::UpdateEndpointWeightsAndCapacitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_endpoint_weights_and_capacities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_endpoint_weights_and_capacities(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointWeightsAndCapacitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_experiment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateExperimentOutput, crate::error::UpdateExperimentError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateExperimentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateExperimentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateExperimentError {
                meta: generic,
                kind: crate::error::UpdateExperimentErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateExperimentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateExperimentError {
                meta: generic,
                kind: crate::error::UpdateExperimentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateExperimentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateExperimentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_experiment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateExperimentOutput, crate::error::UpdateExperimentError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_experiment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_experiment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateExperimentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateImageOutput, crate::error::UpdateImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::UpdateImageError {
                meta: generic,
                kind: crate::error::UpdateImageErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateImageError {
                meta: generic,
                kind: crate::error::UpdateImageErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateImageOutput, crate::error::UpdateImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_model_package_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateModelPackageOutput,
    crate::error::UpdateModelPackageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateModelPackageError::unhandled)?;
    Err(crate::error::UpdateModelPackageError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_model_package_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateModelPackageOutput,
    crate::error::UpdateModelPackageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_model_package_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_model_package(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateModelPackageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_monitoring_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateMonitoringScheduleOutput,
    crate::error::UpdateMonitoringScheduleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateMonitoringScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateMonitoringScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateMonitoringScheduleError {
            meta: generic,
            kind: crate::error::UpdateMonitoringScheduleErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMonitoringScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::UpdateMonitoringScheduleError {
                meta: generic,
                kind: crate::error::UpdateMonitoringScheduleErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMonitoringScheduleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateMonitoringScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_monitoring_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateMonitoringScheduleOutput,
    crate::error::UpdateMonitoringScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_monitoring_schedule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_monitoring_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateMonitoringScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notebook_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotebookInstanceOutput,
    crate::error::UpdateNotebookInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNotebookInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateNotebookInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateNotebookInstanceError {
            meta: generic,
            kind: crate::error::UpdateNotebookInstanceErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotebookInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateNotebookInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notebook_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotebookInstanceOutput,
    crate::error::UpdateNotebookInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_notebook_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notebook_instance_lifecycle_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotebookInstanceLifecycleConfigOutput,
    crate::error::UpdateNotebookInstanceLifecycleConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateNotebookInstanceLifecycleConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateNotebookInstanceLifecycleConfigError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateNotebookInstanceLifecycleConfigError {
            meta: generic,
            kind:
                crate::error::UpdateNotebookInstanceLifecycleConfigErrorKind::ResourceLimitExceeded(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_limit_exceeded::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateNotebookInstanceLifecycleConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::UpdateNotebookInstanceLifecycleConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_notebook_instance_lifecycle_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateNotebookInstanceLifecycleConfigOutput,
    crate::error::UpdateNotebookInstanceLifecycleConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_notebook_instance_lifecycle_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::UpdatePipelineError {
                meta: generic,
                kind: crate::error::UpdatePipelineErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePipelineExecutionOutput,
    crate::error::UpdatePipelineExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePipelineExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdatePipelineExecutionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::UpdatePipelineExecutionError {
                meta: generic,
                kind: crate::error::UpdatePipelineExecutionErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePipelineExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdatePipelineExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_pipeline_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePipelineExecutionOutput,
    crate::error::UpdatePipelineExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_pipeline_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_pipeline_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePipelineExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_project_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateProjectError::unhandled)?;
    Err(crate::error::UpdateProjectError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_project_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_project_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_project(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateProjectError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_training_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrainingJobOutput, crate::error::UpdateTrainingJobError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrainingJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrainingJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::UpdateTrainingJobError {
                meta: generic,
                kind: crate::error::UpdateTrainingJobErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrainingJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateTrainingJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_training_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrainingJobOutput, crate::error::UpdateTrainingJobError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_training_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_training_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrainingJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trial_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrialOutput, crate::error::UpdateTrialError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateTrialError {
                meta: generic,
                kind: crate::error::UpdateTrialErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateTrialError {
                meta: generic,
                kind: crate::error::UpdateTrialErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateTrialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trial_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrialOutput, crate::error::UpdateTrialError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_trial_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_trial(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trial_component_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTrialComponentOutput,
    crate::error::UpdateTrialComponentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrialComponentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrialComponentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::UpdateTrialComponentError {
                meta: generic,
                kind: crate::error::UpdateTrialComponentErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::UpdateTrialComponentError {
                meta: generic,
                kind: crate::error::UpdateTrialComponentErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrialComponentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateTrialComponentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trial_component_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTrialComponentOutput,
    crate::error::UpdateTrialComponentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_trial_component_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_trial_component(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrialComponentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserProfileOutput, crate::error::UpdateUserProfileError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceInUse" => {
            crate::error::UpdateUserProfileError {
                meta: generic,
                kind: crate::error::UpdateUserProfileErrorKind::ResourceInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceLimitExceeded" => crate::error::UpdateUserProfileError {
            meta: generic,
            kind: crate::error::UpdateUserProfileErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::UpdateUserProfileError {
                meta: generic,
                kind: crate::error::UpdateUserProfileErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateUserProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserProfileOutput, crate::error::UpdateUserProfileError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_profile_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_user_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateUserProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workforce_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWorkforceOutput, crate::error::UpdateWorkforceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWorkforceError::unhandled)?;
    Err(crate::error::UpdateWorkforceError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workforce_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWorkforceOutput, crate::error::UpdateWorkforceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_workforce_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_workforce(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateWorkforceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workteam_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWorkteamOutput, crate::error::UpdateWorkteamError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWorkteamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateWorkteamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceLimitExceeded" => crate::error::UpdateWorkteamError {
            meta: generic,
            kind: crate::error::UpdateWorkteamErrorKind::ResourceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWorkteamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateWorkteamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_workteam_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWorkteamOutput, crate::error::UpdateWorkteamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_workteam_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_workteam(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateWorkteamError::unhandled)?;
        output.build()
    })
}
